// Copyright (c) 2022 GeometryFactory (France).
// All rights reserved.
//
// This file is part of CGAL (www.cgal.org).
//
// $URL: https://github.com/CGAL/cgal/blob/v6.0.3/Mesh_3/include/CGAL/Mesh_3/features_detection/cases_table.h $
// $Id: include/CGAL/Mesh_3/features_detection/cases_table.h cefe3007d59 $
// SPDX-License-Identifier: GPL-3.0-or-later OR LicenseRef-Commercial
//
//
// Author(s)     : Sebastien Loriot
//
//******************************************************************************
//
//******************************************************************************

#ifndef CGAL_MESH_3_FEATURES_DETECTION_CASES_TABLES_H
#define CGAL_MESH_3_FEATURES_DETECTION_CASES_TABLES_H

#include <CGAL/license/Mesh_3.h>

#include <array>
#include <unordered_map>
#include <boost/functional/hash.hpp>
#include <vector>
#include <algorithm>

namespace CGAL
{
namespace Mesh_3
{
namespace internal
{

using Combination = std::array<std::uint8_t, 8>;
using Hash_combination = boost::hash<Combination>;

using Cases = std::array<std::uint8_t, 10>[4140];

inline auto find_case(const Cases& cases, Combination comb) {
  using std::begin;
  using std::end;
  return std::lower_bound(begin(cases), end(cases),
                          std::array<std::uint8_t, 10>{
                              comb[0],
                              comb[1],
                              comb[2],
                              comb[3],
                              comb[4],
                              comb[5],
                              comb[6],
                              comb[7],
                              0,
                              0
                          });
};
const Cases cases = {
{ {0,0,0,0,0,0,0,0, 0,0} },
{ {0,0,0,0,0,0,0,1, 1,0} },
{ {0,0,0,0,0,0,1,0, 1,1} },
{ {0,0,0,0,0,0,1,1, 2,0} },
{ {0,0,0,0,0,0,1,2, 3,0} },
{ {0,0,0,0,0,1,0,0, 1,6} },
{ {0,0,0,0,0,1,0,1, 2,18} },
{ {0,0,0,0,0,1,0,2, 3,19} },
{ {0,0,0,0,0,1,1,0, 4,0} },
{ {0,0,0,0,0,1,1,1, 5,0} },
{ {0,0,0,0,0,1,1,2, 6,0} },
{ {0,0,0,0,0,1,2,0, 7,0} },
{ {0,0,0,0,0,1,2,1, 8,0} },
{ {0,0,0,0,0,1,2,2, 8,19} },
{ {0,0,0,0,0,1,2,3, 58,0} },
{ {0,0,0,0,1,0,0,0, 1,7} },
{ {0,0,0,0,1,0,0,1, 4,1} },
{ {0,0,0,0,1,0,0,2, 7,1} },
{ {0,0,0,0,1,0,1,0, 2,15} },
{ {0,0,0,0,1,0,1,1, 5,1} },
{ {0,0,0,0,1,0,1,2, 8,1} },
{ {0,0,0,0,1,0,2,0, 3,14} },
{ {0,0,0,0,1,0,2,1, 6,1} },
{ {0,0,0,0,1,0,2,2, 8,14} },
{ {0,0,0,0,1,0,2,3, 58,1} },
{ {0,0,0,0,1,1,0,0, 2,6} },
{ {0,0,0,0,1,1,0,1, 5,18} },
{ {0,0,0,0,1,1,0,2, 8,18} },
{ {0,0,0,0,1,1,1,0, 5,15} },
{ {0,0,0,0,1,1,1,1, 9,0} },
{ {0,0,0,0,1,1,1,2, 10,0} },
{ {0,0,0,0,1,1,2,0, 8,15} },
{ {0,0,0,0,1,1,2,1, 10,1} },
{ {0,0,0,0,1,1,2,2, 11,0} },
{ {0,0,0,0,1,1,2,3, 59,0} },
{ {0,0,0,0,1,2,0,0, 3,6} },
{ {0,0,0,0,1,2,0,1, 6,18} },
{ {0,0,0,0,1,2,0,2, 8,17} },
{ {0,0,0,0,1,2,0,3, 58,18} },
{ {0,0,0,0,1,2,1,0, 8,16} },
{ {0,0,0,0,1,2,1,1, 10,18} },
{ {0,0,0,0,1,2,1,2, 11,18} },
{ {0,0,0,0,1,2,1,3, 59,19} },
{ {0,0,0,0,1,2,2,0, 6,15} },
{ {0,0,0,0,1,2,2,1, 12,0} },
{ {0,0,0,0,1,2,2,2, 10,15} },
{ {0,0,0,0,1,2,2,3, 60,0} },
{ {0,0,0,0,1,2,3,0, 58,15} },
{ {0,0,0,0,1,2,3,1, 60,1} },
{ {0,0,0,0,1,2,3,2, 59,14} },
{ {0,0,0,0,1,2,3,3, 59,17} },
{ {0,0,0,0,1,2,3,4, 124,0} },
{ {0,0,0,1,0,0,0,0, 1,2} },
{ {0,0,0,1,0,0,0,1, 2,12} },
{ {0,0,0,1,0,0,0,2, 3,13} },
{ {0,0,0,1,0,0,1,0, 4,3} },
{ {0,0,0,1,0,0,1,1, 5,21} },
{ {0,0,0,1,0,0,1,2, 6,21} },
{ {0,0,0,1,0,0,2,0, 7,21} },
{ {0,0,0,1,0,0,2,1, 8,21} },
{ {0,0,0,1,0,0,2,2, 8,32} },
{ {0,0,0,1,0,0,2,3, 58,21} },
{ {0,0,0,1,0,1,0,0, 4,13} },
{ {0,0,0,1,0,1,0,1, 5,13} },
{ {0,0,0,1,0,1,0,2, 6,13} },
{ {0,0,0,1,0,1,1,0, 13,0} },
{ {0,0,0,1,0,1,1,1, 14,0} },
{ {0,0,0,1,0,1,1,2, 15,0} },
{ {0,0,0,1,0,1,2,0, 16,0} },
{ {0,0,0,1,0,1,2,1, 17,0} },
{ {0,0,0,1,0,1,2,2, 18,0} },
{ {0,0,0,1,0,1,2,3, 61,0} },
{ {0,0,0,1,0,2,0,0, 7,27} },
{ {0,0,0,1,0,2,0,1, 8,40} },
{ {0,0,0,1,0,2,0,2, 8,13} },
{ {0,0,0,1,0,2,0,3, 58,40} },
{ {0,0,0,1,0,2,1,0, 16,19} },
{ {0,0,0,1,0,2,1,1, 17,19} },
{ {0,0,0,1,0,2,1,2, 18,19} },
{ {0,0,0,1,0,2,1,3, 61,19} },
{ {0,0,0,1,0,2,2,0, 16,13} },
{ {0,0,0,1,0,2,2,1, 18,13} },
{ {0,0,0,1,0,2,2,2, 17,13} },
{ {0,0,0,1,0,2,2,3, 61,13} },
{ {0,0,0,1,0,2,3,0, 62,0} },
{ {0,0,0,1,0,2,3,1, 63,0} },
{ {0,0,0,1,0,2,3,2, 63,21} },
{ {0,0,0,1,0,2,3,3, 63,40} },
{ {0,0,0,1,0,2,3,4, 125,0} },
{ {0,0,0,1,1,0,0,0, 19,0} },
{ {0,0,0,1,1,0,0,1, 20,0} },
{ {0,0,0,1,1,0,0,2, 21,0} },
{ {0,0,0,1,1,0,1,0, 20,20} },
{ {0,0,0,1,1,0,1,1, 22,0} },
{ {0,0,0,1,1,0,1,2, 23,0} },
{ {0,0,0,1,1,0,2,0, 21,20} },
{ {0,0,0,1,1,0,2,1, 23,20} },
{ {0,0,0,1,1,0,2,2, 24,0} },
{ {0,0,0,1,1,0,2,3, 64,0} },
{ {0,0,0,1,1,1,0,0, 20,26} },
{ {0,0,0,1,1,1,0,1, 22,19} },
{ {0,0,0,1,1,1,0,2, 23,19} },
{ {0,0,0,1,1,1,1,0, 25,0} },
{ {0,0,0,1,1,1,1,1, 5,5} },
{ {0,0,0,1,1,1,1,2, 26,0} },
{ {0,0,0,1,1,1,2,0, 27,0} },
{ {0,0,0,1,1,1,2,1, 28,0} },
{ {0,0,0,1,1,1,2,2, 29,0} },
{ {0,0,0,1,1,1,2,3, 65,0} },
{ {0,0,0,1,1,2,0,0, 21,26} },
{ {0,0,0,1,1,2,0,1, 23,41} },
{ {0,0,0,1,1,2,0,2, 24,19} },
{ {0,0,0,1,1,2,0,3, 64,19} },
{ {0,0,0,1,1,2,1,0, 27,19} },
{ {0,0,0,1,1,2,1,1, 28,19} },
{ {0,0,0,1,1,2,1,2, 29,19} },
{ {0,0,0,1,1,2,1,3, 65,19} },
{ {0,0,0,1,1,2,2,0, 30,0} },
{ {0,0,0,1,1,2,2,1, 31,0} },
{ {0,0,0,1,1,2,2,2, 32,0} },
{ {0,0,0,1,1,2,2,3, 66,0} },
{ {0,0,0,1,1,2,3,0, 67,0} },
{ {0,0,0,1,1,2,3,1, 68,0} },
{ {0,0,0,1,1,2,3,2, 69,0} },
{ {0,0,0,1,1,2,3,3, 69,19} },
{ {0,0,0,1,1,2,3,4, 126,0} },
{ {0,0,0,1,2,0,0,0, 33,0} },
{ {0,0,0,1,2,0,0,1, 34,0} },
{ {0,0,0,1,2,0,0,2, 35,0} },
{ {0,0,0,1,2,0,0,3, 70,0} },
{ {0,0,0,1,2,0,1,0, 35,20} },
{ {0,0,0,1,2,0,1,1, 28,39} },
{ {0,0,0,1,2,0,1,2, 36,0} },
{ {0,0,0,1,2,0,1,3, 71,0} },
{ {0,0,0,1,2,0,2,0, 34,20} },
{ {0,0,0,1,2,0,2,1, 37,0} },
{ {0,0,0,1,2,0,2,2, 28,29} },
{ {0,0,0,1,2,0,2,3, 72,0} },
{ {0,0,0,1,2,0,3,0, 70,20} },
{ {0,0,0,1,2,0,3,1, 72,20} },
{ {0,0,0,1,2,0,3,2, 71,20} },
{ {0,0,0,1,2,0,3,3, 73,0} },
{ {0,0,0,1,2,0,3,4, 127,0} },
{ {0,0,0,1,2,1,0,0, 35,26} },
{ {0,0,0,1,2,1,0,1, 28,22} },
{ {0,0,0,1,2,1,0,2, 36,19} },
{ {0,0,0,1,2,1,0,3, 71,19} },
{ {0,0,0,1,2,1,1,0, 38,0} },
{ {0,0,0,1,2,1,1,1, 17,22} },
{ {0,0,0,1,2,1,1,2, 39,0} },
{ {0,0,0,1,2,1,1,3, 74,0} },
{ {0,0,0,1,2,1,2,0, 40,0} },
{ {0,0,0,1,2,1,2,1, 41,0} },
{ {0,0,0,1,2,1,2,2, 42,0} },
{ {0,0,0,1,2,1,2,3, 75,0} },
{ {0,0,0,1,2,1,3,0, 76,0} },
{ {0,0,0,1,2,1,3,1, 77,0} },
{ {0,0,0,1,2,1,3,2, 78,0} },
{ {0,0,0,1,2,1,3,3, 79,0} },
{ {0,0,0,1,2,1,3,4, 128,0} },
{ {0,0,0,1,2,2,0,0, 34,26} },
{ {0,0,0,1,2,2,0,1, 37,19} },
{ {0,0,0,1,2,2,0,2, 28,10} },
{ {0,0,0,1,2,2,0,3, 72,19} },
{ {0,0,0,1,2,2,1,0, 40,19} },
{ {0,0,0,1,2,2,1,1, 41,19} },
{ {0,0,0,1,2,2,1,2, 42,19} },
{ {0,0,0,1,2,2,1,3, 75,19} },
{ {0,0,0,1,2,2,2,0, 26,11} },
{ {0,0,0,1,2,2,2,1, 43,0} },
{ {0,0,0,1,2,2,2,2, 10,11} },
{ {0,0,0,1,2,2,2,3, 80,0} },
{ {0,0,0,1,2,2,3,0, 81,0} },
{ {0,0,0,1,2,2,3,1, 82,0} },
{ {0,0,0,1,2,2,3,2, 83,0} },
{ {0,0,0,1,2,2,3,3, 84,0} },
{ {0,0,0,1,2,2,3,4, 129,0} },
{ {0,0,0,1,2,3,0,0, 70,26} },
{ {0,0,0,1,2,3,0,1, 72,41} },
{ {0,0,0,1,2,3,0,2, 71,41} },
{ {0,0,0,1,2,3,0,3, 73,19} },
{ {0,0,0,1,2,3,0,4, 127,19} },
{ {0,0,0,1,2,3,1,0, 76,19} },
{ {0,0,0,1,2,3,1,1, 77,19} },
{ {0,0,0,1,2,3,1,2, 78,19} },
{ {0,0,0,1,2,3,1,3, 79,19} },
{ {0,0,0,1,2,3,1,4, 128,19} },
{ {0,0,0,1,2,3,2,0, 81,19} },
{ {0,0,0,1,2,3,2,1, 82,19} },
{ {0,0,0,1,2,3,2,2, 83,19} },
{ {0,0,0,1,2,3,2,3, 84,19} },
{ {0,0,0,1,2,3,2,4, 129,19} },
{ {0,0,0,1,2,3,3,0, 85,0} },
{ {0,0,0,1,2,3,3,1, 86,0} },
{ {0,0,0,1,2,3,3,2, 87,0} },
{ {0,0,0,1,2,3,3,3, 88,0} },
{ {0,0,0,1,2,3,3,4, 130,0} },
{ {0,0,0,1,2,3,4,0, 131,0} },
{ {0,0,0,1,2,3,4,1, 132,0} },
{ {0,0,0,1,2,3,4,2, 133,0} },
{ {0,0,0,1,2,3,4,3, 134,0} },
{ {0,0,0,1,2,3,4,4, 134,19} },
{ {0,0,0,1,2,3,4,5, 167,0} },
{ {0,0,1,0,0,0,0,0, 1,3} },
{ {0,0,1,0,0,0,0,1, 4,2} },
{ {0,0,1,0,0,0,0,2, 7,20} },
{ {0,0,1,0,0,0,1,0, 2,9} },
{ {0,0,1,0,0,0,1,1, 5,20} },
{ {0,0,1,0,0,0,1,2, 8,20} },
{ {0,0,1,0,0,0,2,0, 3,8} },
{ {0,0,1,0,0,0,2,1, 6,20} },
{ {0,0,1,0,0,0,2,2, 8,43} },
{ {0,0,1,0,0,0,2,3, 58,20} },
{ {0,0,1,0,0,1,0,0, 19,1} },
{ {0,0,1,0,0,1,0,1, 20,21} },
{ {0,0,1,0,0,1,0,2, 21,21} },
{ {0,0,1,0,0,1,1,0, 20,1} },
{ {0,0,1,0,0,1,1,1, 22,1} },
{ {0,0,1,0,0,1,1,2, 23,21} },
{ {0,0,1,0,0,1,2,0, 21,1} },
{ {0,0,1,0,0,1,2,1, 23,1} },
{ {0,0,1,0,0,1,2,2, 24,1} },
{ {0,0,1,0,0,1,2,3, 64,21} },
{ {0,0,1,0,0,2,0,0, 33,1} },
{ {0,0,1,0,0,2,0,1, 35,21} },
{ {0,0,1,0,0,2,0,2, 34,21} },
{ {0,0,1,0,0,2,0,3, 70,21} },
{ {0,0,1,0,0,2,1,0, 34,1} },
{ {0,0,1,0,0,2,1,1, 28,44} },
{ {0,0,1,0,0,2,1,2, 37,1} },
{ {0,0,1,0,0,2,1,3, 72,21} },
{ {0,0,1,0,0,2,2,0, 35,1} },
{ {0,0,1,0,0,2,2,1, 36,1} },
{ {0,0,1,0,0,2,2,2, 28,30} },
{ {0,0,1,0,0,2,2,3, 71,21} },
{ {0,0,1,0,0,2,3,0, 70,1} },
{ {0,0,1,0,0,2,3,1, 71,1} },
{ {0,0,1,0,0,2,3,2, 72,1} },
{ {0,0,1,0,0,2,3,3, 73,1} },
{ {0,0,1,0,0,2,3,4, 127,21} },
{ {0,0,1,0,1,0,0,0, 4,8} },
{ {0,0,1,0,1,0,0,1, 13,1} },
{ {0,0,1,0,1,0,0,2, 16,1} },
{ {0,0,1,0,1,0,1,0, 5,8} },
{ {0,0,1,0,1,0,1,1, 14,1} },
{ {0,0,1,0,1,0,1,2, 17,1} },
{ {0,0,1,0,1,0,2,0, 6,8} },
{ {0,0,1,0,1,0,2,1, 15,1} },
{ {0,0,1,0,1,0,2,2, 18,1} },
{ {0,0,1,0,1,0,2,3, 61,1} },
{ {0,0,1,0,1,1,0,0, 20,23} },
{ {0,0,1,0,1,1,0,1, 25,1} },
{ {0,0,1,0,1,1,0,2, 27,1} },
{ {0,0,1,0,1,1,1,0, 22,14} },
{ {0,0,1,0,1,1,1,1, 5,4} },
{ {0,0,1,0,1,1,1,2, 28,1} },
{ {0,0,1,0,1,1,2,0, 23,14} },
{ {0,0,1,0,1,1,2,1, 26,1} },
{ {0,0,1,0,1,1,2,2, 29,1} },
{ {0,0,1,0,1,1,2,3, 65,1} },
{ {0,0,1,0,1,2,0,0, 35,23} },
{ {0,0,1,0,1,2,0,1, 38,1} },
{ {0,0,1,0,1,2,0,2, 40,1} },
{ {0,0,1,0,1,2,0,3, 76,1} },
{ {0,0,1,0,1,2,1,0, 28,27} },
{ {0,0,1,0,1,2,1,1, 17,27} },
{ {0,0,1,0,1,2,1,2, 41,1} },
{ {0,0,1,0,1,2,1,3, 77,1} },
{ {0,0,1,0,1,2,2,0, 36,14} },
{ {0,0,1,0,1,2,2,1, 39,1} },
{ {0,0,1,0,1,2,2,2, 42,1} },
{ {0,0,1,0,1,2,2,3, 78,1} },
{ {0,0,1,0,1,2,3,0, 71,14} },
{ {0,0,1,0,1,2,3,1, 74,1} },
{ {0,0,1,0,1,2,3,2, 75,1} },
{ {0,0,1,0,1,2,3,3, 79,1} },
{ {0,0,1,0,1,2,3,4, 128,1} },
{ {0,0,1,0,2,0,0,0, 7,22} },
{ {0,0,1,0,2,0,0,1, 16,14} },
{ {0,0,1,0,2,0,0,2, 16,8} },
{ {0,0,1,0,2,0,0,3, 62,1} },
{ {0,0,1,0,2,0,1,0, 8,35} },
{ {0,0,1,0,2,0,1,1, 17,14} },
{ {0,0,1,0,2,0,1,2, 18,8} },
{ {0,0,1,0,2,0,1,3, 63,1} },
{ {0,0,1,0,2,0,2,0, 8,8} },
{ {0,0,1,0,2,0,2,1, 18,14} },
{ {0,0,1,0,2,0,2,2, 17,8} },
{ {0,0,1,0,2,0,2,3, 63,20} },
{ {0,0,1,0,2,0,3,0, 58,35} },
{ {0,0,1,0,2,0,3,1, 61,14} },
{ {0,0,1,0,2,0,3,2, 61,8} },
{ {0,0,1,0,2,0,3,3, 63,35} },
{ {0,0,1,0,2,0,3,4, 125,1} },
{ {0,0,1,0,2,1,0,0, 21,23} },
{ {0,0,1,0,2,1,0,1, 27,14} },
{ {0,0,1,0,2,1,0,2, 30,1} },
{ {0,0,1,0,2,1,0,3, 67,1} },
{ {0,0,1,0,2,1,1,0, 23,34} },
{ {0,0,1,0,2,1,1,1, 28,14} },
{ {0,0,1,0,2,1,1,2, 31,1} },
{ {0,0,1,0,2,1,1,3, 68,1} },
{ {0,0,1,0,2,1,2,0, 24,14} },
{ {0,0,1,0,2,1,2,1, 29,14} },
{ {0,0,1,0,2,1,2,2, 32,1} },
{ {0,0,1,0,2,1,2,3, 69,1} },
{ {0,0,1,0,2,1,3,0, 64,14} },
{ {0,0,1,0,2,1,3,1, 65,14} },
{ {0,0,1,0,2,1,3,2, 66,1} },
{ {0,0,1,0,2,1,3,3, 69,14} },
{ {0,0,1,0,2,1,3,4, 126,1} },
{ {0,0,1,0,2,2,0,0, 34,23} },
{ {0,0,1,0,2,2,0,1, 40,14} },
{ {0,0,1,0,2,2,0,2, 26,10} },
{ {0,0,1,0,2,2,0,3, 81,1} },
{ {0,0,1,0,2,2,1,0, 37,14} },
{ {0,0,1,0,2,2,1,1, 41,14} },
{ {0,0,1,0,2,2,1,2, 43,1} },
{ {0,0,1,0,2,2,1,3, 82,1} },
{ {0,0,1,0,2,2,2,0, 28,11} },
{ {0,0,1,0,2,2,2,1, 42,14} },
{ {0,0,1,0,2,2,2,2, 10,10} },
{ {0,0,1,0,2,2,2,3, 83,1} },
{ {0,0,1,0,2,2,3,0, 72,14} },
{ {0,0,1,0,2,2,3,1, 75,14} },
{ {0,0,1,0,2,2,3,2, 80,1} },
{ {0,0,1,0,2,2,3,3, 84,1} },
{ {0,0,1,0,2,2,3,4, 129,1} },
{ {0,0,1,0,2,3,0,0, 70,23} },
{ {0,0,1,0,2,3,0,1, 76,14} },
{ {0,0,1,0,2,3,0,2, 85,1} },
{ {0,0,1,0,2,3,0,3, 81,14} },
{ {0,0,1,0,2,3,0,4, 131,1} },
{ {0,0,1,0,2,3,1,0, 72,34} },
{ {0,0,1,0,2,3,1,1, 77,44} },
{ {0,0,1,0,2,3,1,2, 86,1} },
{ {0,0,1,0,2,3,1,3, 82,14} },
{ {0,0,1,0,2,3,1,4, 132,1} },
{ {0,0,1,0,2,3,2,0, 73,14} },
{ {0,0,1,0,2,3,2,1, 79,14} },
{ {0,0,1,0,2,3,2,2, 88,1} },
{ {0,0,1,0,2,3,2,3, 84,14} },
{ {0,0,1,0,2,3,2,4, 134,1} },
{ {0,0,1,0,2,3,3,0, 71,34} },
{ {0,0,1,0,2,3,3,1, 78,14} },
{ {0,0,1,0,2,3,3,2, 87,1} },
{ {0,0,1,0,2,3,3,3, 83,14} },
{ {0,0,1,0,2,3,3,4, 133,1} },
{ {0,0,1,0,2,3,4,0, 127,14} },
{ {0,0,1,0,2,3,4,1, 128,14} },
{ {0,0,1,0,2,3,4,2, 130,1} },
{ {0,0,1,0,2,3,4,3, 129,14} },
{ {0,0,1,0,2,3,4,4, 134,14} },
{ {0,0,1,0,2,3,4,5, 167,1} },
{ {0,0,1,1,0,0,0,0, 2,2} },
{ {0,0,1,1,0,0,0,1, 5,2} },
{ {0,0,1,1,0,0,0,2, 8,33} },
{ {0,0,1,1,0,0,1,0, 5,3} },
{ {0,0,1,1,0,0,1,1, 9,2} },
{ {0,0,1,1,0,0,1,2, 10,21} },
{ {0,0,1,1,0,0,2,0, 8,42} },
{ {0,0,1,1,0,0,2,1, 10,20} },
{ {0,0,1,1,0,0,2,2, 11,20} },
{ {0,0,1,1,0,0,2,3, 59,21} },
{ {0,0,1,1,0,1,0,0, 20,12} },
{ {0,0,1,1,0,1,0,1, 22,12} },
{ {0,0,1,1,0,1,0,2, 23,32} },
{ {0,0,1,1,0,1,1,0, 25,21} },
{ {0,0,1,1,0,1,1,1, 5,24} },
{ {0,0,1,1,0,1,1,2, 26,21} },
{ {0,0,1,1,0,1,2,0, 27,21} },
{ {0,0,1,1,0,1,2,1, 28,21} },
{ {0,0,1,1,0,1,2,2, 29,21} },
{ {0,0,1,1,0,1,2,3, 65,21} },
{ {0,0,1,1,0,2,0,0, 34,12} },
{ {0,0,1,1,0,2,0,1, 28,7} },
{ {0,0,1,1,0,2,0,2, 37,12} },
{ {0,0,1,1,0,2,0,3, 72,32} },
{ {0,0,1,1,0,2,1,0, 26,6} },
{ {0,0,1,1,0,2,1,1, 10,6} },
{ {0,0,1,1,0,2,1,2, 43,21} },
{ {0,0,1,1,0,2,1,3, 80,21} },
{ {0,0,1,1,0,2,2,0, 40,32} },
{ {0,0,1,1,0,2,2,1, 42,32} },
{ {0,0,1,1,0,2,2,2, 41,32} },
{ {0,0,1,1,0,2,2,3, 75,32} },
{ {0,0,1,1,0,2,3,0, 81,21} },
{ {0,0,1,1,0,2,3,1, 83,21} },
{ {0,0,1,1,0,2,3,2, 82,21} },
{ {0,0,1,1,0,2,3,3, 84,21} },
{ {0,0,1,1,0,2,3,4, 129,21} },
{ {0,0,1,1,1,0,0,0, 20,9} },
{ {0,0,1,1,1,0,0,1, 25,20} },
{ {0,0,1,1,1,0,0,2, 27,20} },
{ {0,0,1,1,1,0,1,0, 22,9} },
{ {0,0,1,1,1,0,1,1, 5,25} },
{ {0,0,1,1,1,0,1,2, 28,20} },
{ {0,0,1,1,1,0,2,0, 23,43} },
{ {0,0,1,1,1,0,2,1, 26,20} },
{ {0,0,1,1,1,0,2,2, 29,20} },
{ {0,0,1,1,1,0,2,3, 65,20} },
{ {0,0,1,1,1,1,0,0, 44,0} },
{ {0,0,1,1,1,1,0,1, 20,22} },
{ {0,0,1,1,1,1,0,2, 45,0} },
{ {0,0,1,1,1,1,1,0, 20,27} },
{ {0,0,1,1,1,1,1,1, 2,4} },
{ {0,0,1,1,1,1,1,2, 34,27} },
{ {0,0,1,1,1,1,2,0, 45,1} },
{ {0,0,1,1,1,1,2,1, 34,22} },
{ {0,0,1,1,1,1,2,2, 46,0} },
{ {0,0,1,1,1,1,2,3, 89,0} },
{ {0,0,1,1,1,2,0,0, 45,6} },
{ {0,0,1,1,1,2,0,1, 27,7} },
{ {0,0,1,1,1,2,0,2, 47,0} },
{ {0,0,1,1,1,2,0,3, 90,0} },
{ {0,0,1,1,1,2,1,0, 23,45} },
{ {0,0,1,1,1,2,1,1, 8,44} },
{ {0,0,1,1,1,2,1,2, 37,27} },
{ {0,0,1,1,1,2,1,3, 72,45} },
{ {0,0,1,1,1,2,2,0, 48,0} },
{ {0,0,1,1,1,2,2,1, 40,38} },
{ {0,0,1,1,1,2,2,2, 29,5} },
{ {0,0,1,1,1,2,2,3, 91,0} },
{ {0,0,1,1,1,2,3,0, 92,0} },
{ {0,0,1,1,1,2,3,1, 81,7} },
{ {0,0,1,1,1,2,3,2, 93,0} },
{ {0,0,1,1,1,2,3,3, 94,0} },
{ {0,0,1,1,1,2,3,4, 135,0} },
{ {0,0,1,1,2,0,0,0, 34,9} },
{ {0,0,1,1,2,0,0,1, 26,7} },
{ {0,0,1,1,2,0,0,2, 40,43} },
{ {0,0,1,1,2,0,0,3, 81,20} },
{ {0,0,1,1,2,0,1,0, 28,6} },
{ {0,0,1,1,2,0,1,1, 10,7} },
{ {0,0,1,1,2,0,1,2, 42,43} },
{ {0,0,1,1,2,0,1,3, 83,20} },
{ {0,0,1,1,2,0,2,0, 37,9} },
{ {0,0,1,1,2,0,2,1, 43,20} },
{ {0,0,1,1,2,0,2,2, 41,43} },
{ {0,0,1,1,2,0,2,3, 82,20} },
{ {0,0,1,1,2,0,3,0, 72,43} },
{ {0,0,1,1,2,0,3,1, 80,20} },
{ {0,0,1,1,2,0,3,2, 75,43} },
{ {0,0,1,1,2,0,3,3, 84,20} },
{ {0,0,1,1,2,0,3,4, 129,20} },
{ {0,0,1,1,2,1,0,0, 45,7} },
{ {0,0,1,1,2,1,0,1, 23,38} },
{ {0,0,1,1,2,1,0,2, 48,1} },
{ {0,0,1,1,2,1,0,3, 92,1} },
{ {0,0,1,1,2,1,1,0, 27,6} },
{ {0,0,1,1,2,1,1,1, 8,39} },
{ {0,0,1,1,2,1,1,2, 40,45} },
{ {0,0,1,1,2,1,1,3, 81,6} },
{ {0,0,1,1,2,1,2,0, 47,1} },
{ {0,0,1,1,2,1,2,1, 37,22} },
{ {0,0,1,1,2,1,2,2, 29,4} },
{ {0,0,1,1,2,1,2,3, 93,1} },
{ {0,0,1,1,2,1,3,0, 90,1} },
{ {0,0,1,1,2,1,3,1, 72,38} },
{ {0,0,1,1,2,1,3,2, 91,1} },
{ {0,0,1,1,2,1,3,3, 94,1} },
{ {0,0,1,1,2,1,3,4, 135,1} },
{ {0,0,1,1,2,2,0,0, 46,6} },
{ {0,0,1,1,2,2,0,1, 29,7} },
{ {0,0,1,1,2,2,0,2, 29,10} },
{ {0,0,1,1,2,2,0,3, 94,17} },
{ {0,0,1,1,2,2,1,0, 29,6} },
{ {0,0,1,1,2,2,1,1, 11,6} },
{ {0,0,1,1,2,2,1,2, 41,45} },
{ {0,0,1,1,2,2,1,3, 84,6} },
{ {0,0,1,1,2,2,2,0, 29,11} },
{ {0,0,1,1,2,2,2,1, 41,38} },
{ {0,0,1,1,2,2,2,2, 11,10} },
{ {0,0,1,1,2,2,2,3, 84,11} },
{ {0,0,1,1,2,2,3,0, 94,16} },
{ {0,0,1,1,2,2,3,1, 84,7} },
{ {0,0,1,1,2,2,3,2, 84,10} },
{ {0,0,1,1,2,2,3,3, 95,0} },
{ {0,0,1,1,2,2,3,4, 136,0} },
{ {0,0,1,1,2,3,0,0, 89,6} },
{ {0,0,1,1,2,3,0,1, 65,7} },
{ {0,0,1,1,2,3,0,2, 91,17} },
{ {0,0,1,1,2,3,0,3, 93,17} },
{ {0,0,1,1,2,3,0,4, 135,17} },
{ {0,0,1,1,2,3,1,0, 65,6} },
{ {0,0,1,1,2,3,1,1, 59,6} },
{ {0,0,1,1,2,3,1,2, 75,45} },
{ {0,0,1,1,2,3,1,3, 82,6} },
{ {0,0,1,1,2,3,1,4, 129,6} },
{ {0,0,1,1,2,3,2,0, 93,16} },
{ {0,0,1,1,2,3,2,1, 82,7} },
{ {0,0,1,1,2,3,2,2, 84,4} },
{ {0,0,1,1,2,3,2,3, 96,0} },
{ {0,0,1,1,2,3,2,4, 137,0} },
{ {0,0,1,1,2,3,3,0, 91,16} },
{ {0,0,1,1,2,3,3,1, 75,38} },
{ {0,0,1,1,2,3,3,2, 97,0} },
{ {0,0,1,1,2,3,3,3, 84,5} },
{ {0,0,1,1,2,3,3,4, 138,0} },
{ {0,0,1,1,2,3,4,0, 135,16} },
{ {0,0,1,1,2,3,4,1, 129,7} },
{ {0,0,1,1,2,3,4,2, 138,1} },
{ {0,0,1,1,2,3,4,3, 137,1} },
{ {0,0,1,1,2,3,4,4, 136,17} },
{ {0,0,1,1,2,3,4,5, 168,0} },
{ {0,0,1,2,0,0,0,0, 3,2} },
{ {0,0,1,2,0,0,0,1, 6,2} },
{ {0,0,1,2,0,0,0,2, 8,2} },
{ {0,0,1,2,0,0,0,3, 58,33} },
{ {0,0,1,2,0,0,1,0, 8,3} },
{ {0,0,1,2,0,0,1,1, 10,2} },
{ {0,0,1,2,0,0,1,2, 11,33} },
{ {0,0,1,2,0,0,1,3, 59,32} },
{ {0,0,1,2,0,0,2,0, 6,3} },
{ {0,0,1,2,0,0,2,1, 12,3} },
{ {0,0,1,2,0,0,2,2, 10,3} },
{ {0,0,1,2,0,0,2,3, 60,21} },
{ {0,0,1,2,0,0,3,0, 58,42} },
{ {0,0,1,2,0,0,3,1, 60,20} },
{ {0,0,1,2,0,0,3,2, 59,43} },
{ {0,0,1,2,0,0,3,3, 59,2} },
{ {0,0,1,2,0,0,3,4, 124,21} },
{ {0,0,1,2,0,1,0,0, 21,12} },
{ {0,0,1,2,0,1,0,1, 23,12} },
{ {0,0,1,2,0,1,0,2, 24,12} },
{ {0,0,1,2,0,1,0,3, 64,32} },
{ {0,0,1,2,0,1,1,0, 27,32} },
{ {0,0,1,2,0,1,1,1, 28,32} },
{ {0,0,1,2,0,1,1,2, 29,32} },
{ {0,0,1,2,0,1,1,3, 65,32} },
{ {0,0,1,2,0,1,2,0, 30,21} },
{ {0,0,1,2,0,1,2,1, 31,21} },
{ {0,0,1,2,0,1,2,2, 32,21} },
{ {0,0,1,2,0,1,2,3, 66,21} },
{ {0,0,1,2,0,1,3,0, 67,21} },
{ {0,0,1,2,0,1,3,1, 68,21} },
{ {0,0,1,2,0,1,3,2, 69,21} },
{ {0,0,1,2,0,1,3,3, 69,32} },
{ {0,0,1,2,0,1,3,4, 126,21} },
{ {0,0,1,2,0,2,0,0, 35,12} },
{ {0,0,1,2,0,2,0,1, 36,12} },
{ {0,0,1,2,0,2,0,2, 28,37} },
{ {0,0,1,2,0,2,0,3, 71,32} },
{ {0,0,1,2,0,2,1,0, 40,21} },
{ {0,0,1,2,0,2,1,1, 42,21} },
{ {0,0,1,2,0,2,1,2, 41,21} },
{ {0,0,1,2,0,2,1,3, 75,21} },
{ {0,0,1,2,0,2,2,0, 38,21} },
{ {0,0,1,2,0,2,2,1, 39,21} },
{ {0,0,1,2,0,2,2,2, 17,30} },
{ {0,0,1,2,0,2,2,3, 74,21} },
{ {0,0,1,2,0,2,3,0, 76,21} },
{ {0,0,1,2,0,2,3,1, 78,21} },
{ {0,0,1,2,0,2,3,2, 77,21} },
{ {0,0,1,2,0,2,3,3, 79,21} },
{ {0,0,1,2,0,2,3,4, 128,21} },
{ {0,0,1,2,0,3,0,0, 70,12} },
{ {0,0,1,2,0,3,0,1, 71,12} },
{ {0,0,1,2,0,3,0,2, 73,12} },
{ {0,0,1,2,0,3,0,3, 72,12} },
{ {0,0,1,2,0,3,0,4, 127,32} },
{ {0,0,1,2,0,3,1,0, 81,32} },
{ {0,0,1,2,0,3,1,1, 83,44} },
{ {0,0,1,2,0,3,1,2, 84,32} },
{ {0,0,1,2,0,3,1,3, 82,32} },
{ {0,0,1,2,0,3,1,4, 129,32} },
{ {0,0,1,2,0,3,2,0, 85,21} },
{ {0,0,1,2,0,3,2,1, 87,21} },
{ {0,0,1,2,0,3,2,2, 88,24} },
{ {0,0,1,2,0,3,2,3, 86,21} },
{ {0,0,1,2,0,3,2,4, 130,21} },
{ {0,0,1,2,0,3,3,0, 76,32} },
{ {0,0,1,2,0,3,3,1, 78,32} },
{ {0,0,1,2,0,3,3,2, 79,32} },
{ {0,0,1,2,0,3,3,3, 77,32} },
{ {0,0,1,2,0,3,3,4, 128,32} },
{ {0,0,1,2,0,3,4,0, 131,21} },
{ {0,0,1,2,0,3,4,1, 133,21} },
{ {0,0,1,2,0,3,4,2, 134,21} },
{ {0,0,1,2,0,3,4,3, 132,21} },
{ {0,0,1,2,0,3,4,4, 134,32} },
{ {0,0,1,2,0,3,4,5, 167,21} },
{ {0,0,1,2,1,0,0,0, 35,9} },
{ {0,0,1,2,1,0,0,1, 38,20} },
{ {0,0,1,2,1,0,0,2, 40,20} },
{ {0,0,1,2,1,0,0,3, 76,20} },
{ {0,0,1,2,1,0,1,0, 28,46} },
{ {0,0,1,2,1,0,1,1, 17,29} },
{ {0,0,1,2,1,0,1,2, 41,20} },
{ {0,0,1,2,1,0,1,3, 77,20} },
{ {0,0,1,2,1,0,2,0, 36,43} },
{ {0,0,1,2,1,0,2,1, 39,20} },
{ {0,0,1,2,1,0,2,2, 42,20} },
{ {0,0,1,2,1,0,2,3, 78,20} },
{ {0,0,1,2,1,0,3,0, 71,43} },
{ {0,0,1,2,1,0,3,1, 74,20} },
{ {0,0,1,2,1,0,3,2, 75,20} },
{ {0,0,1,2,1,0,3,3, 79,20} },
{ {0,0,1,2,1,0,3,4, 128,20} },
{ {0,0,1,2,1,1,0,0, 45,2} },
{ {0,0,1,2,1,1,0,1, 27,10} },
{ {0,0,1,2,1,1,0,2, 47,21} },
{ {0,0,1,2,1,1,0,3, 90,21} },
{ {0,0,1,2,1,1,1,0, 23,28} },
{ {0,0,1,2,1,1,1,1, 8,29} },
{ {0,0,1,2,1,1,1,2, 37,46} },
{ {0,0,1,2,1,1,1,3, 72,28} },
{ {0,0,1,2,1,1,2,0, 48,21} },
{ {0,0,1,2,1,1,2,1, 40,31} },
{ {0,0,1,2,1,1,2,2, 29,24} },
{ {0,0,1,2,1,1,2,3, 91,21} },
{ {0,0,1,2,1,1,3,0, 92,21} },
{ {0,0,1,2,1,1,3,1, 81,10} },
{ {0,0,1,2,1,1,3,2, 93,21} },
{ {0,0,1,2,1,1,3,3, 94,21} },
{ {0,0,1,2,1,1,3,4, 135,21} },
{ {0,0,1,2,1,2,0,0, 49,0} },
{ {0,0,1,2,1,2,0,1, 50,0} },
{ {0,0,1,2,1,2,0,2, 31,22} },
{ {0,0,1,2,1,2,0,3, 98,0} },
{ {0,0,1,2,1,2,1,0, 31,27} },
{ {0,0,1,2,1,2,1,1, 18,4} },
{ {0,0,1,2,1,2,1,2, 43,27} },
{ {0,0,1,2,1,2,1,3, 86,27} },
{ {0,0,1,2,1,2,2,0, 50,1} },
{ {0,0,1,2,1,2,2,1, 51,0} },
{ {0,0,1,2,1,2,2,2, 18,5} },
{ {0,0,1,2,1,2,2,3, 99,0} },
{ {0,0,1,2,1,2,3,0, 98,1} },
{ {0,0,1,2,1,2,3,1, 99,1} },
{ {0,0,1,2,1,2,3,2, 86,22} },
{ {0,0,1,2,1,2,3,3, 100,0} },
{ {0,0,1,2,1,2,3,4, 139,0} },
{ {0,0,1,2,1,3,0,0, 101,0} },
{ {0,0,1,2,1,3,0,1, 102,0} },
{ {0,0,1,2,1,3,0,2, 103,0} },
{ {0,0,1,2,1,3,0,3, 103,21} },
{ {0,0,1,2,1,3,0,4, 140,0} },
{ {0,0,1,2,1,3,1,0, 68,27} },
{ {0,0,1,2,1,3,1,1, 63,27} },
{ {0,0,1,2,1,3,1,2, 82,27} },
{ {0,0,1,2,1,3,1,3, 82,46} },
{ {0,0,1,2,1,3,1,4, 132,27} },
{ {0,0,1,2,1,3,2,0, 104,0} },
{ {0,0,1,2,1,3,2,1, 105,0} },
{ {0,0,1,2,1,3,2,2, 79,24} },
{ {0,0,1,2,1,3,2,3, 106,0} },
{ {0,0,1,2,1,3,2,4, 141,0} },
{ {0,0,1,2,1,3,3,0, 104,21} },
{ {0,0,1,2,1,3,3,1, 105,21} },
{ {0,0,1,2,1,3,3,2, 106,21} },
{ {0,0,1,2,1,3,3,3, 79,5} },
{ {0,0,1,2,1,3,3,4, 141,21} },
{ {0,0,1,2,1,3,4,0, 142,0} },
{ {0,0,1,2,1,3,4,1, 143,0} },
{ {0,0,1,2,1,3,4,2, 144,0} },
{ {0,0,1,2,1,3,4,3, 144,21} },
{ {0,0,1,2,1,3,4,4, 145,0} },
{ {0,0,1,2,1,3,4,5, 169,0} },
{ {0,0,1,2,2,0,0,0, 21,9} },
{ {0,0,1,2,2,0,0,1, 30,20} },
{ {0,0,1,2,2,0,0,2, 27,43} },
{ {0,0,1,2,2,0,0,3, 67,20} },
{ {0,0,1,2,2,0,1,0, 24,9} },
{ {0,0,1,2,2,0,1,1, 32,20} },
{ {0,0,1,2,2,0,1,2, 29,43} },
{ {0,0,1,2,2,0,1,3, 69,20} },
{ {0,0,1,2,2,0,2,0, 23,9} },
{ {0,0,1,2,2,0,2,1, 31,20} },
{ {0,0,1,2,2,0,2,2, 28,43} },
{ {0,0,1,2,2,0,2,3, 68,20} },
{ {0,0,1,2,2,0,3,0, 64,43} },
{ {0,0,1,2,2,0,3,1, 66,20} },
{ {0,0,1,2,2,0,3,2, 65,43} },
{ {0,0,1,2,2,0,3,3, 69,43} },
{ {0,0,1,2,2,0,3,4, 126,20} },
{ {0,0,1,2,2,1,0,0, 52,0} },
{ {0,0,1,2,2,1,0,1, 53,0} },
{ {0,0,1,2,2,1,0,2, 53,21} },
{ {0,0,1,2,2,1,0,3, 107,0} },
{ {0,0,1,2,2,1,1,0, 53,20} },
{ {0,0,1,2,2,1,1,1, 24,5} },
{ {0,0,1,2,2,1,1,2, 47,44} },
{ {0,0,1,2,2,1,1,3, 108,0} },
{ {0,0,1,2,2,1,2,0, 53,1} },
{ {0,0,1,2,2,1,2,1, 47,30} },
{ {0,0,1,2,2,1,2,2, 24,4} },
{ {0,0,1,2,2,1,2,3, 108,21} },
{ {0,0,1,2,2,1,3,0, 107,20} },
{ {0,0,1,2,2,1,3,1, 108,20} },
{ {0,0,1,2,2,1,3,2, 108,1} },
{ {0,0,1,2,2,1,3,3, 109,0} },
{ {0,0,1,2,2,1,3,4, 146,0} },
{ {0,0,1,2,2,2,0,0, 45,3} },
{ {0,0,1,2,2,2,0,1, 48,20} },
{ {0,0,1,2,2,2,0,2, 23,31} },
{ {0,0,1,2,2,2,0,3, 92,20} },
{ {0,0,1,2,2,2,1,0, 47,20} },
{ {0,0,1,2,2,2,1,1, 29,25} },
{ {0,0,1,2,2,2,1,2, 37,37} },
{ {0,0,1,2,2,2,1,3, 93,20} },
{ {0,0,1,2,2,2,2,0, 27,11} },
{ {0,0,1,2,2,2,2,1, 40,28} },
{ {0,0,1,2,2,2,2,2, 8,30} },
{ {0,0,1,2,2,2,2,3, 81,11} },
{ {0,0,1,2,2,2,3,0, 90,20} },
{ {0,0,1,2,2,2,3,1, 91,20} },
{ {0,0,1,2,2,2,3,2, 72,31} },
{ {0,0,1,2,2,2,3,3, 94,20} },
{ {0,0,1,2,2,2,3,4, 135,20} },
{ {0,0,1,2,2,3,0,0, 110,0} },
{ {0,0,1,2,2,3,0,1, 111,0} },
{ {0,0,1,2,2,3,0,2, 112,0} },
{ {0,0,1,2,2,3,0,3, 108,36} },
{ {0,0,1,2,2,3,0,4, 147,0} },
{ {0,0,1,2,2,3,1,0, 108,26} },
{ {0,0,1,2,2,3,1,1, 69,44} },
{ {0,0,1,2,2,3,1,2, 93,44} },
{ {0,0,1,2,2,3,1,3, 113,0} },
{ {0,0,1,2,2,3,1,4, 148,0} },
{ {0,0,1,2,2,3,2,0, 112,46} },
{ {0,0,1,2,2,3,2,1, 103,46} },
{ {0,0,1,2,2,3,2,2, 73,24} },
{ {0,0,1,2,2,3,2,3, 93,30} },
{ {0,0,1,2,2,3,2,4, 149,0} },
{ {0,0,1,2,2,3,3,0, 111,20} },
{ {0,0,1,2,2,3,3,1, 114,0} },
{ {0,0,1,2,2,3,3,2, 103,22} },
{ {0,0,1,2,2,3,3,3, 69,30} },
{ {0,0,1,2,2,3,3,4, 150,0} },
{ {0,0,1,2,2,3,4,0, 147,20} },
{ {0,0,1,2,2,3,4,1, 150,20} },
{ {0,0,1,2,2,3,4,2, 149,20} },
{ {0,0,1,2,2,3,4,3, 148,20} },
{ {0,0,1,2,2,3,4,4, 151,0} },
{ {0,0,1,2,2,3,4,5, 170,0} },
{ {0,0,1,2,3,0,0,0, 70,9} },
{ {0,0,1,2,3,0,0,1, 85,20} },
{ {0,0,1,2,3,0,0,2, 81,43} },
{ {0,0,1,2,3,0,0,3, 76,43} },
{ {0,0,1,2,3,0,0,4, 131,20} },
{ {0,0,1,2,3,0,1,0, 73,9} },
{ {0,0,1,2,3,0,1,1, 88,25} },
{ {0,0,1,2,3,0,1,2, 84,43} },
{ {0,0,1,2,3,0,1,3, 79,43} },
{ {0,0,1,2,3,0,1,4, 134,20} },
{ {0,0,1,2,3,0,2,0, 71,9} },
{ {0,0,1,2,3,0,2,1, 87,20} },
{ {0,0,1,2,3,0,2,2, 83,39} },
{ {0,0,1,2,3,0,2,3, 78,43} },
{ {0,0,1,2,3,0,2,4, 133,20} },
{ {0,0,1,2,3,0,3,0, 72,9} },
{ {0,0,1,2,3,0,3,1, 86,20} },
{ {0,0,1,2,3,0,3,2, 82,43} },
{ {0,0,1,2,3,0,3,3, 77,43} },
{ {0,0,1,2,3,0,3,4, 132,20} },
{ {0,0,1,2,3,0,4,0, 127,43} },
{ {0,0,1,2,3,0,4,1, 130,20} },
{ {0,0,1,2,3,0,4,2, 129,43} },
{ {0,0,1,2,3,0,4,3, 128,43} },
{ {0,0,1,2,3,0,4,4, 134,43} },
{ {0,0,1,2,3,0,4,5, 167,20} },
{ {0,0,1,2,3,1,0,0, 110,1} },
{ {0,0,1,2,3,1,0,1, 112,37} },
{ {0,0,1,2,3,1,0,2, 108,23} },
{ {0,0,1,2,3,1,0,3, 111,21} },
{ {0,0,1,2,3,1,0,4, 147,21} },
{ {0,0,1,2,3,1,1,0, 112,1} },
{ {0,0,1,2,3,1,1,1, 73,25} },
{ {0,0,1,2,3,1,1,2, 93,39} },
{ {0,0,1,2,3,1,1,3, 103,27} },
{ {0,0,1,2,3,1,1,4, 149,21} },
{ {0,0,1,2,3,1,2,0, 111,1} },
{ {0,0,1,2,3,1,2,1, 103,37} },
{ {0,0,1,2,3,1,2,2, 69,39} },
{ {0,0,1,2,3,1,2,3, 114,1} },
{ {0,0,1,2,3,1,2,4, 150,21} },
{ {0,0,1,2,3,1,3,0, 108,47} },
{ {0,0,1,2,3,1,3,1, 93,29} },
{ {0,0,1,2,3,1,3,2, 113,1} },
{ {0,0,1,2,3,1,3,3, 69,29} },
{ {0,0,1,2,3,1,3,4, 148,21} },
{ {0,0,1,2,3,1,4,0, 147,1} },
{ {0,0,1,2,3,1,4,1, 149,1} },
{ {0,0,1,2,3,1,4,2, 148,1} },
{ {0,0,1,2,3,1,4,3, 150,1} },
{ {0,0,1,2,3,1,4,4, 151,1} },
{ {0,0,1,2,3,1,4,5, 170,1} },
{ {0,0,1,2,3,2,0,0, 101,1} },
{ {0,0,1,2,3,2,0,1, 104,1} },
{ {0,0,1,2,3,2,0,2, 68,22} },
{ {0,0,1,2,3,2,0,3, 104,20} },
{ {0,0,1,2,3,2,0,4, 142,1} },
{ {0,0,1,2,3,2,1,0, 103,1} },
{ {0,0,1,2,3,2,1,1, 79,25} },
{ {0,0,1,2,3,2,1,2, 82,22} },
{ {0,0,1,2,3,2,1,3, 106,20} },
{ {0,0,1,2,3,2,1,4, 144,1} },
{ {0,0,1,2,3,2,2,0, 102,1} },
{ {0,0,1,2,3,2,2,1, 105,1} },
{ {0,0,1,2,3,2,2,2, 63,22} },
{ {0,0,1,2,3,2,2,3, 105,20} },
{ {0,0,1,2,3,2,2,4, 143,1} },
{ {0,0,1,2,3,2,3,0, 103,20} },
{ {0,0,1,2,3,2,3,1, 106,1} },
{ {0,0,1,2,3,2,3,2, 82,37} },
{ {0,0,1,2,3,2,3,3, 79,4} },
{ {0,0,1,2,3,2,3,4, 144,20} },
{ {0,0,1,2,3,2,4,0, 140,1} },
{ {0,0,1,2,3,2,4,1, 141,1} },
{ {0,0,1,2,3,2,4,2, 132,22} },
{ {0,0,1,2,3,2,4,3, 141,20} },
{ {0,0,1,2,3,2,4,4, 145,1} },
{ {0,0,1,2,3,2,4,5, 169,1} },
{ {0,0,1,2,3,3,0,0, 89,2} },
{ {0,0,1,2,3,3,0,1, 91,2} },
{ {0,0,1,2,3,3,0,2, 93,2} },
{ {0,0,1,2,3,3,0,3, 65,10} },
{ {0,0,1,2,3,3,0,4, 135,2} },
{ {0,0,1,2,3,3,1,0, 93,3} },
{ {0,0,1,2,3,3,1,1, 84,25} },
{ {0,0,1,2,3,3,1,2, 96,45} },
{ {0,0,1,2,3,3,1,3, 82,10} },
{ {0,0,1,2,3,3,1,4, 137,21} },
{ {0,0,1,2,3,3,2,0, 91,3} },
{ {0,0,1,2,3,3,2,1, 97,21} },
{ {0,0,1,2,3,3,2,2, 84,24} },
{ {0,0,1,2,3,3,2,3, 75,31} },
{ {0,0,1,2,3,3,2,4, 138,21} },
{ {0,0,1,2,3,3,3,0, 65,11} },
{ {0,0,1,2,3,3,3,1, 75,28} },
{ {0,0,1,2,3,3,3,2, 82,11} },
{ {0,0,1,2,3,3,3,3, 59,11} },
{ {0,0,1,2,3,3,3,4, 129,11} },
{ {0,0,1,2,3,3,4,0, 135,3} },
{ {0,0,1,2,3,3,4,1, 138,20} },
{ {0,0,1,2,3,3,4,2, 137,20} },
{ {0,0,1,2,3,3,4,3, 129,10} },
{ {0,0,1,2,3,3,4,4, 136,2} },
{ {0,0,1,2,3,3,4,5, 168,21} },
{ {0,0,1,2,3,4,0,0, 152,0} },
{ {0,0,1,2,3,4,0,1, 153,0} },
{ {0,0,1,2,3,4,0,2, 149,38} },
{ {0,0,1,2,3,4,0,3, 153,21} },
{ {0,0,1,2,3,4,0,4, 149,31} },
{ {0,0,1,2,3,4,0,5, 171,0} },
{ {0,0,1,2,3,4,1,0, 149,45} },
{ {0,0,1,2,3,4,1,1, 134,44} },
{ {0,0,1,2,3,4,1,2, 137,45} },
{ {0,0,1,2,3,4,1,3, 144,27} },
{ {0,0,1,2,3,4,1,4, 154,0} },
{ {0,0,1,2,3,4,1,5, 172,0} },
{ {0,0,1,2,3,4,2,0, 153,1} },
{ {0,0,1,2,3,4,2,1, 155,0} },
{ {0,0,1,2,3,4,2,2, 134,39} },
{ {0,0,1,2,3,4,2,3, 156,0} },
{ {0,0,1,2,3,4,2,4, 144,37} },
{ {0,0,1,2,3,4,2,5, 173,0} },
{ {0,0,1,2,3,4,3,0, 149,28} },
{ {0,0,1,2,3,4,3,1, 144,46} },
{ {0,0,1,2,3,4,3,2, 154,1} },
{ {0,0,1,2,3,4,3,3, 134,29} },
{ {0,0,1,2,3,4,3,4, 137,28} },
{ {0,0,1,2,3,4,3,5, 172,21} },
{ {0,0,1,2,3,4,4,0, 153,20} },
{ {0,0,1,2,3,4,4,1, 156,1} },
{ {0,0,1,2,3,4,4,2, 144,22} },
{ {0,0,1,2,3,4,4,3, 155,21} },
{ {0,0,1,2,3,4,4,4, 134,30} },
{ {0,0,1,2,3,4,4,5, 173,21} },
{ {0,0,1,2,3,4,5,0, 171,1} },
{ {0,0,1,2,3,4,5,1, 173,1} },
{ {0,0,1,2,3,4,5,2, 172,1} },
{ {0,0,1,2,3,4,5,3, 173,20} },
{ {0,0,1,2,3,4,5,4, 172,20} },
{ {0,0,1,2,3,4,5,5, 174,0} },
{ {0,0,1,2,3,4,5,6, 182,0} },
{ {0,1,0,0,0,0,0,0, 1,4} },
{ {0,1,0,0,0,0,0,1, 4,12} },
{ {0,1,0,0,0,0,0,2, 7,12} },
{ {0,1,0,0,0,0,1,0, 19,7} },
{ {0,1,0,0,0,0,1,1, 20,13} },
{ {0,1,0,0,0,0,1,2, 21,13} },
{ {0,1,0,0,0,0,2,0, 33,2} },
{ {0,1,0,0,0,0,2,1, 35,13} },
{ {0,1,0,0,0,0,2,2, 34,13} },
{ {0,1,0,0,0,0,2,3, 70,13} },
{ {0,1,0,0,0,1,0,0, 2,27} },
{ {0,1,0,0,0,1,0,1, 5,26} },
{ {0,1,0,0,0,1,0,2, 8,41} },
{ {0,1,0,0,0,1,1,0, 20,18} },
{ {0,1,0,0,0,1,1,1, 22,18} },
{ {0,1,0,0,0,1,1,2, 23,40} },
{ {0,1,0,0,0,1,2,0, 34,18} },
{ {0,1,0,0,0,1,2,1, 28,9} },
{ {0,1,0,0,0,1,2,2, 37,18} },
{ {0,1,0,0,0,1,2,3, 72,40} },
{ {0,1,0,0,0,2,0,0, 3,26} },
{ {0,1,0,0,0,2,0,1, 6,26} },
{ {0,1,0,0,0,2,0,2, 8,26} },
{ {0,1,0,0,0,2,0,3, 58,41} },
{ {0,1,0,0,0,2,1,0, 21,18} },
{ {0,1,0,0,0,2,1,1, 23,18} },
{ {0,1,0,0,0,2,1,2, 24,18} },
{ {0,1,0,0,0,2,1,3, 64,40} },
{ {0,1,0,0,0,2,2,0, 35,18} },
{ {0,1,0,0,0,2,2,1, 36,18} },
{ {0,1,0,0,0,2,2,2, 28,5} },
{ {0,1,0,0,0,2,2,3, 71,40} },
{ {0,1,0,0,0,2,3,0, 70,18} },
{ {0,1,0,0,0,2,3,1, 71,18} },
{ {0,1,0,0,0,2,3,2, 73,18} },
{ {0,1,0,0,0,2,3,3, 72,18} },
{ {0,1,0,0,0,2,3,4, 127,40} },
{ {0,1,0,0,1,0,0,0, 4,6} },
{ {0,1,0,0,1,0,0,1, 13,6} },
{ {0,1,0,0,1,0,0,2, 16,18} },
{ {0,1,0,0,1,0,1,0, 20,7} },
{ {0,1,0,0,1,0,1,1, 25,18} },
{ {0,1,0,0,1,0,1,2, 27,18} },
{ {0,1,0,0,1,0,2,0, 35,7} },
{ {0,1,0,0,1,0,2,1, 38,18} },
{ {0,1,0,0,1,0,2,2, 40,18} },
{ {0,1,0,0,1,0,2,3, 76,18} },
{ {0,1,0,0,1,1,0,0, 5,6} },
{ {0,1,0,0,1,1,0,1, 14,6} },
{ {0,1,0,0,1,1,0,2, 17,18} },
{ {0,1,0,0,1,1,1,0, 22,7} },
{ {0,1,0,0,1,1,1,1, 5,10} },
{ {0,1,0,0,1,1,1,2, 28,18} },
{ {0,1,0,0,1,1,2,0, 28,42} },
{ {0,1,0,0,1,1,2,1, 17,9} },
{ {0,1,0,0,1,1,2,2, 41,18} },
{ {0,1,0,0,1,1,2,3, 77,18} },
{ {0,1,0,0,1,2,0,0, 6,6} },
{ {0,1,0,0,1,2,0,1, 15,6} },
{ {0,1,0,0,1,2,0,2, 18,18} },
{ {0,1,0,0,1,2,0,3, 61,18} },
{ {0,1,0,0,1,2,1,0, 23,17} },
{ {0,1,0,0,1,2,1,1, 26,18} },
{ {0,1,0,0,1,2,1,2, 29,18} },
{ {0,1,0,0,1,2,1,3, 65,18} },
{ {0,1,0,0,1,2,2,0, 36,17} },
{ {0,1,0,0,1,2,2,1, 39,18} },
{ {0,1,0,0,1,2,2,2, 42,18} },
{ {0,1,0,0,1,2,2,3, 78,18} },
{ {0,1,0,0,1,2,3,0, 71,17} },
{ {0,1,0,0,1,2,3,1, 74,18} },
{ {0,1,0,0,1,2,3,2, 79,18} },
{ {0,1,0,0,1,2,3,3, 75,18} },
{ {0,1,0,0,1,2,3,4, 128,18} },
{ {0,1,0,0,2,0,0,0, 7,6} },
{ {0,1,0,0,2,0,0,1, 16,6} },
{ {0,1,0,0,2,0,0,2, 16,26} },
{ {0,1,0,0,2,0,0,3, 62,18} },
{ {0,1,0,0,2,0,1,0, 21,7} },
{ {0,1,0,0,2,0,1,1, 27,17} },
{ {0,1,0,0,2,0,1,2, 30,18} },
{ {0,1,0,0,2,0,1,3, 67,18} },
{ {0,1,0,0,2,0,2,0, 34,7} },
{ {0,1,0,0,2,0,2,1, 40,17} },
{ {0,1,0,0,2,0,2,2, 26,4} },
{ {0,1,0,0,2,0,2,3, 81,18} },
{ {0,1,0,0,2,0,3,0, 70,7} },
{ {0,1,0,0,2,0,3,1, 76,17} },
{ {0,1,0,0,2,0,3,2, 85,18} },
{ {0,1,0,0,2,0,3,3, 81,17} },
{ {0,1,0,0,2,0,3,4, 131,18} },
{ {0,1,0,0,2,1,0,0, 8,6} },
{ {0,1,0,0,2,1,0,1, 17,6} },
{ {0,1,0,0,2,1,0,2, 18,26} },
{ {0,1,0,0,2,1,0,3, 63,18} },
{ {0,1,0,0,2,1,1,0, 23,7} },
{ {0,1,0,0,2,1,1,1, 28,17} },
{ {0,1,0,0,2,1,1,2, 31,18} },
{ {0,1,0,0,2,1,1,3, 68,18} },
{ {0,1,0,0,2,1,2,0, 37,17} },
{ {0,1,0,0,2,1,2,1, 41,17} },
{ {0,1,0,0,2,1,2,2, 43,18} },
{ {0,1,0,0,2,1,2,3, 82,18} },
{ {0,1,0,0,2,1,3,0, 72,7} },
{ {0,1,0,0,2,1,3,1, 77,9} },
{ {0,1,0,0,2,1,3,2, 86,18} },
{ {0,1,0,0,2,1,3,3, 82,17} },
{ {0,1,0,0,2,1,3,4, 132,18} },
{ {0,1,0,0,2,2,0,0, 8,45} },
{ {0,1,0,0,2,2,0,1, 18,6} },
{ {0,1,0,0,2,2,0,2, 17,26} },
{ {0,1,0,0,2,2,0,3, 63,41} },
{ {0,1,0,0,2,2,1,0, 24,7} },
{ {0,1,0,0,2,2,1,1, 29,17} },
{ {0,1,0,0,2,2,1,2, 32,18} },
{ {0,1,0,0,2,2,1,3, 69,18} },
{ {0,1,0,0,2,2,2,0, 28,28} },
{ {0,1,0,0,2,2,2,1, 42,17} },
{ {0,1,0,0,2,2,2,2, 10,4} },
{ {0,1,0,0,2,2,2,3, 83,18} },
{ {0,1,0,0,2,2,3,0, 73,17} },
{ {0,1,0,0,2,2,3,1, 79,17} },
{ {0,1,0,0,2,2,3,2, 88,18} },
{ {0,1,0,0,2,2,3,3, 84,17} },
{ {0,1,0,0,2,2,3,4, 134,18} },
{ {0,1,0,0,2,3,0,0, 58,6} },
{ {0,1,0,0,2,3,0,1, 61,6} },
{ {0,1,0,0,2,3,0,2, 61,26} },
{ {0,1,0,0,2,3,0,3, 63,6} },
{ {0,1,0,0,2,3,0,4, 125,18} },
{ {0,1,0,0,2,3,1,0, 64,17} },
{ {0,1,0,0,2,3,1,1, 65,17} },
{ {0,1,0,0,2,3,1,2, 66,18} },
{ {0,1,0,0,2,3,1,3, 69,17} },
{ {0,1,0,0,2,3,1,4, 126,18} },
{ {0,1,0,0,2,3,2,0, 72,17} },
{ {0,1,0,0,2,3,2,1, 75,17} },
{ {0,1,0,0,2,3,2,2, 80,18} },
{ {0,1,0,0,2,3,2,3, 84,18} },
{ {0,1,0,0,2,3,2,4, 129,18} },
{ {0,1,0,0,2,3,3,0, 71,7} },
{ {0,1,0,0,2,3,3,1, 78,17} },
{ {0,1,0,0,2,3,3,2, 87,18} },
{ {0,1,0,0,2,3,3,3, 83,17} },
{ {0,1,0,0,2,3,3,4, 133,18} },
{ {0,1,0,0,2,3,4,0, 127,17} },
{ {0,1,0,0,2,3,4,1, 128,17} },
{ {0,1,0,0,2,3,4,2, 130,18} },
{ {0,1,0,0,2,3,4,3, 134,17} },
{ {0,1,0,0,2,3,4,4, 129,17} },
{ {0,1,0,0,2,3,4,5, 167,18} },
{ {0,1,0,1,0,0,0,0, 2,28} },
{ {0,1,0,1,0,0,0,1, 5,12} },
{ {0,1,0,1,0,0,0,2, 8,12} },
{ {0,1,0,1,0,0,1,0, 20,2} },
{ {0,1,0,1,0,0,1,1, 22,13} },
{ {0,1,0,1,0,0,1,2, 23,13} },
{ {0,1,0,1,0,0,2,0, 34,2} },
{ {0,1,0,1,0,0,2,1, 28,34} },
{ {0,1,0,1,0,0,2,2, 37,33} },
{ {0,1,0,1,0,0,2,3, 72,13} },
{ {0,1,0,1,0,1,0,0, 5,27} },
{ {0,1,0,1,0,1,0,1, 9,12} },
{ {0,1,0,1,0,1,0,2, 10,13} },
{ {0,1,0,1,0,1,1,0, 25,13} },
{ {0,1,0,1,0,1,1,1, 5,22} },
{ {0,1,0,1,0,1,1,2, 26,13} },
{ {0,1,0,1,0,1,2,0, 26,8} },
{ {0,1,0,1,0,1,2,1, 10,8} },
{ {0,1,0,1,0,1,2,2, 43,13} },
{ {0,1,0,1,0,1,2,3, 80,13} },
{ {0,1,0,1,0,2,0,0, 8,27} },
{ {0,1,0,1,0,2,0,1, 10,26} },
{ {0,1,0,1,0,2,0,2, 11,40} },
{ {0,1,0,1,0,2,0,3, 59,40} },
{ {0,1,0,1,0,2,1,0, 27,40} },
{ {0,1,0,1,0,2,1,1, 28,40} },
{ {0,1,0,1,0,2,1,2, 29,40} },
{ {0,1,0,1,0,2,1,3, 65,40} },
{ {0,1,0,1,0,2,2,0, 40,13} },
{ {0,1,0,1,0,2,2,1, 42,13} },
{ {0,1,0,1,0,2,2,2, 41,13} },
{ {0,1,0,1,0,2,2,3, 75,13} },
{ {0,1,0,1,0,2,3,0, 81,40} },
{ {0,1,0,1,0,2,3,1, 83,34} },
{ {0,1,0,1,0,2,3,2, 84,40} },
{ {0,1,0,1,0,2,3,3, 82,40} },
{ {0,1,0,1,0,2,3,4, 129,40} },
{ {0,1,0,1,1,0,0,0, 20,25} },
{ {0,1,0,1,1,0,0,1, 25,26} },
{ {0,1,0,1,1,0,0,2, 27,41} },
{ {0,1,0,1,1,0,1,0, 44,18} },
{ {0,1,0,1,1,0,1,1, 20,24} },
{ {0,1,0,1,1,0,1,2, 45,19} },
{ {0,1,0,1,1,0,2,0, 45,14} },
{ {0,1,0,1,1,0,2,1, 27,34} },
{ {0,1,0,1,1,0,2,2, 47,19} },
{ {0,1,0,1,1,0,2,3, 90,19} },
{ {0,1,0,1,1,1,0,0, 22,26} },
{ {0,1,0,1,1,1,0,1, 5,9} },
{ {0,1,0,1,1,1,0,2, 28,41} },
{ {0,1,0,1,1,1,1,0, 20,3} },
{ {0,1,0,1,1,1,1,1, 2,31} },
{ {0,1,0,1,1,1,1,2, 34,3} },
{ {0,1,0,1,1,1,2,0, 23,8} },
{ {0,1,0,1,1,1,2,1, 8,9} },
{ {0,1,0,1,1,1,2,2, 37,42} },
{ {0,1,0,1,1,1,2,3, 72,8} },
{ {0,1,0,1,1,2,0,0, 23,26} },
{ {0,1,0,1,1,2,0,1, 26,26} },
{ {0,1,0,1,1,2,0,2, 29,41} },
{ {0,1,0,1,1,2,0,3, 65,41} },
{ {0,1,0,1,1,2,1,0, 45,18} },
{ {0,1,0,1,1,2,1,1, 34,24} },
{ {0,1,0,1,1,2,1,2, 46,18} },
{ {0,1,0,1,1,2,1,3, 89,19} },
{ {0,1,0,1,1,2,2,0, 48,19} },
{ {0,1,0,1,1,2,2,1, 40,23} },
{ {0,1,0,1,1,2,2,2, 29,30} },
{ {0,1,0,1,1,2,2,3, 91,19} },
{ {0,1,0,1,1,2,3,0, 92,15} },
{ {0,1,0,1,1,2,3,1, 81,34} },
{ {0,1,0,1,1,2,3,2, 94,19} },
{ {0,1,0,1,1,2,3,3, 93,19} },
{ {0,1,0,1,1,2,3,4, 135,19} },
{ {0,1,0,1,2,0,0,0, 34,25} },
{ {0,1,0,1,2,0,0,1, 26,23} },
{ {0,1,0,1,2,0,0,2, 40,26} },
{ {0,1,0,1,2,0,0,3, 81,41} },
{ {0,1,0,1,2,0,1,0, 45,15} },
{ {0,1,0,1,2,0,1,1, 23,23} },
{ {0,1,0,1,2,0,1,2, 48,18} },
{ {0,1,0,1,2,0,1,3, 92,18} },
{ {0,1,0,1,2,0,2,0, 46,15} },
{ {0,1,0,1,2,0,2,1, 29,34} },
{ {0,1,0,1,2,0,2,2, 29,29} },
{ {0,1,0,1,2,0,2,3, 94,14} },
{ {0,1,0,1,2,0,3,0, 89,14} },
{ {0,1,0,1,2,0,3,1, 65,34} },
{ {0,1,0,1,2,0,3,2, 91,14} },
{ {0,1,0,1,2,0,3,3, 93,14} },
{ {0,1,0,1,2,0,3,4, 135,14} },
{ {0,1,0,1,2,1,0,0, 28,35} },
{ {0,1,0,1,2,1,0,1, 10,23} },
{ {0,1,0,1,2,1,0,2, 42,26} },
{ {0,1,0,1,2,1,0,3, 83,41} },
{ {0,1,0,1,2,1,1,0, 27,35} },
{ {0,1,0,1,2,1,1,1, 8,22} },
{ {0,1,0,1,2,1,1,2, 40,8} },
{ {0,1,0,1,2,1,1,3, 81,35} },
{ {0,1,0,1,2,1,2,0, 29,35} },
{ {0,1,0,1,2,1,2,1, 11,35} },
{ {0,1,0,1,2,1,2,2, 41,8} },
{ {0,1,0,1,2,1,2,3, 84,35} },
{ {0,1,0,1,2,1,3,0, 65,35} },
{ {0,1,0,1,2,1,3,1, 59,35} },
{ {0,1,0,1,2,1,3,2, 75,8} },
{ {0,1,0,1,2,1,3,3, 82,35} },
{ {0,1,0,1,2,1,3,4, 129,35} },
{ {0,1,0,1,2,2,0,0, 37,44} },
{ {0,1,0,1,2,2,0,1, 43,26} },
{ {0,1,0,1,2,2,0,2, 41,26} },
{ {0,1,0,1,2,2,0,3, 82,41} },
{ {0,1,0,1,2,2,1,0, 47,18} },
{ {0,1,0,1,2,2,1,1, 37,39} },
{ {0,1,0,1,2,2,1,2, 29,31} },
{ {0,1,0,1,2,2,1,3, 93,18} },
{ {0,1,0,1,2,2,2,0, 29,28} },
{ {0,1,0,1,2,2,2,1, 41,23} },
{ {0,1,0,1,2,2,2,2, 11,28} },
{ {0,1,0,1,2,2,2,3, 84,28} },
{ {0,1,0,1,2,2,3,0, 93,15} },
{ {0,1,0,1,2,2,3,1, 82,34} },
{ {0,1,0,1,2,2,3,2, 84,31} },
{ {0,1,0,1,2,2,3,3, 96,19} },
{ {0,1,0,1,2,2,3,4, 137,19} },
{ {0,1,0,1,2,3,0,0, 72,26} },
{ {0,1,0,1,2,3,0,1, 80,26} },
{ {0,1,0,1,2,3,0,2, 75,26} },
{ {0,1,0,1,2,3,0,3, 84,41} },
{ {0,1,0,1,2,3,0,4, 129,41} },
{ {0,1,0,1,2,3,1,0, 90,18} },
{ {0,1,0,1,2,3,1,1, 72,23} },
{ {0,1,0,1,2,3,1,2, 91,18} },
{ {0,1,0,1,2,3,1,3, 94,18} },
{ {0,1,0,1,2,3,1,4, 135,18} },
{ {0,1,0,1,2,3,2,0, 94,15} },
{ {0,1,0,1,2,3,2,1, 84,34} },
{ {0,1,0,1,2,3,2,2, 84,29} },
{ {0,1,0,1,2,3,2,3, 95,18} },
{ {0,1,0,1,2,3,2,4, 136,19} },
{ {0,1,0,1,2,3,3,0, 91,15} },
{ {0,1,0,1,2,3,3,1, 75,23} },
{ {0,1,0,1,2,3,3,2, 97,19} },
{ {0,1,0,1,2,3,3,3, 84,30} },
{ {0,1,0,1,2,3,3,4, 138,19} },
{ {0,1,0,1,2,3,4,0, 135,15} },
{ {0,1,0,1,2,3,4,1, 129,34} },
{ {0,1,0,1,2,3,4,2, 138,14} },
{ {0,1,0,1,2,3,4,3, 136,14} },
{ {0,1,0,1,2,3,4,4, 137,18} },
{ {0,1,0,1,2,3,4,5, 168,19} },
{ {0,1,0,2,0,0,0,0, 3,28} },
{ {0,1,0,2,0,0,0,1, 6,12} },
{ {0,1,0,2,0,0,0,2, 8,47} },
{ {0,1,0,2,0,0,0,3, 58,12} },
{ {0,1,0,2,0,0,1,0, 21,2} },
{ {0,1,0,2,0,0,1,1, 23,33} },
{ {0,1,0,2,0,0,1,2, 24,13} },
{ {0,1,0,2,0,0,1,3, 64,13} },
{ {0,1,0,2,0,0,2,0, 35,2} },
{ {0,1,0,2,0,0,2,1, 36,33} },
{ {0,1,0,2,0,0,2,2, 28,24} },
{ {0,1,0,2,0,0,2,3, 71,13} },
{ {0,1,0,2,0,0,3,0, 70,2} },
{ {0,1,0,2,0,0,3,1, 71,33} },
{ {0,1,0,2,0,0,3,2, 73,33} },
{ {0,1,0,2,0,0,3,3, 72,33} },
{ {0,1,0,2,0,0,3,4, 127,13} },
{ {0,1,0,2,0,1,0,0, 8,46} },
{ {0,1,0,2,0,1,0,1, 10,12} },
{ {0,1,0,2,0,1,0,2, 11,12} },
{ {0,1,0,2,0,1,0,3, 59,13} },
{ {0,1,0,2,0,1,1,0, 27,13} },
{ {0,1,0,2,0,1,1,1, 28,13} },
{ {0,1,0,2,0,1,1,2, 29,13} },
{ {0,1,0,2,0,1,1,3, 65,13} },
{ {0,1,0,2,0,1,2,0, 40,40} },
{ {0,1,0,2,0,1,2,1, 42,40} },
{ {0,1,0,2,0,1,2,2, 41,40} },
{ {0,1,0,2,0,1,2,3, 75,40} },
{ {0,1,0,2,0,1,3,0, 81,13} },
{ {0,1,0,2,0,1,3,1, 83,9} },
{ {0,1,0,2,0,1,3,2, 84,13} },
{ {0,1,0,2,0,1,3,3, 82,13} },
{ {0,1,0,2,0,1,3,4, 129,13} },
{ {0,1,0,2,0,2,0,0, 6,27} },
{ {0,1,0,2,0,2,0,1, 12,13} },
{ {0,1,0,2,0,2,0,2, 10,27} },
{ {0,1,0,2,0,2,0,3, 60,13} },
{ {0,1,0,2,0,2,1,0, 30,13} },
{ {0,1,0,2,0,2,1,1, 31,13} },
{ {0,1,0,2,0,2,1,2, 32,13} },
{ {0,1,0,2,0,2,1,3, 66,13} },
{ {0,1,0,2,0,2,2,0, 38,13} },
{ {0,1,0,2,0,2,2,1, 39,13} },
{ {0,1,0,2,0,2,2,2, 17,5} },
{ {0,1,0,2,0,2,2,3, 74,13} },
{ {0,1,0,2,0,2,3,0, 85,13} },
{ {0,1,0,2,0,2,3,1, 87,13} },
{ {0,1,0,2,0,2,3,2, 88,22} },
{ {0,1,0,2,0,2,3,3, 86,13} },
{ {0,1,0,2,0,2,3,4, 130,13} },
{ {0,1,0,2,0,3,0,0, 58,27} },
{ {0,1,0,2,0,3,0,1, 60,26} },
{ {0,1,0,2,0,3,0,2, 59,26} },
{ {0,1,0,2,0,3,0,3, 59,47} },
{ {0,1,0,2,0,3,0,4, 124,40} },
{ {0,1,0,2,0,3,1,0, 67,40} },
{ {0,1,0,2,0,3,1,1, 68,40} },
{ {0,1,0,2,0,3,1,2, 69,40} },
{ {0,1,0,2,0,3,1,3, 69,13} },
{ {0,1,0,2,0,3,1,4, 126,40} },
{ {0,1,0,2,0,3,2,0, 76,40} },
{ {0,1,0,2,0,3,2,1, 78,40} },
{ {0,1,0,2,0,3,2,2, 77,40} },
{ {0,1,0,2,0,3,2,3, 79,40} },
{ {0,1,0,2,0,3,2,4, 128,40} },
{ {0,1,0,2,0,3,3,0, 76,13} },
{ {0,1,0,2,0,3,3,1, 78,13} },
{ {0,1,0,2,0,3,3,2, 79,13} },
{ {0,1,0,2,0,3,3,3, 77,13} },
{ {0,1,0,2,0,3,3,4, 128,13} },
{ {0,1,0,2,0,3,4,0, 131,40} },
{ {0,1,0,2,0,3,4,1, 133,40} },
{ {0,1,0,2,0,3,4,2, 134,40} },
{ {0,1,0,2,0,3,4,3, 134,13} },
{ {0,1,0,2,0,3,4,4, 132,40} },
{ {0,1,0,2,0,3,4,5, 167,40} },
{ {0,1,0,2,1,0,0,0, 35,25} },
{ {0,1,0,2,1,0,0,1, 38,26} },
{ {0,1,0,2,1,0,0,2, 40,41} },
{ {0,1,0,2,1,0,0,3, 76,41} },
{ {0,1,0,2,1,0,1,0, 45,28} },
{ {0,1,0,2,1,0,1,1, 27,29} },
{ {0,1,0,2,1,0,1,2, 47,40} },
{ {0,1,0,2,1,0,1,3, 90,40} },
{ {0,1,0,2,1,0,2,0, 49,19} },
{ {0,1,0,2,1,0,2,1, 50,19} },
{ {0,1,0,2,1,0,2,2, 31,24} },
{ {0,1,0,2,1,0,2,3, 98,19} },
{ {0,1,0,2,1,0,3,0, 101,19} },
{ {0,1,0,2,1,0,3,1, 102,19} },
{ {0,1,0,2,1,0,3,2, 103,19} },
{ {0,1,0,2,1,0,3,3, 103,40} },
{ {0,1,0,2,1,0,3,4, 140,19} },
{ {0,1,0,2,1,1,0,0, 28,3} },
{ {0,1,0,2,1,1,0,1, 17,3} },
{ {0,1,0,2,1,1,0,2, 41,41} },
{ {0,1,0,2,1,1,0,3, 77,41} },
{ {0,1,0,2,1,1,1,0, 23,11} },
{ {0,1,0,2,1,1,1,1, 8,10} },
{ {0,1,0,2,1,1,1,2, 37,3} },
{ {0,1,0,2,1,1,1,3, 72,11} },
{ {0,1,0,2,1,1,2,0, 31,3} },
{ {0,1,0,2,1,1,2,1, 18,31} },
{ {0,1,0,2,1,1,2,2, 43,3} },
{ {0,1,0,2,1,1,2,3, 86,3} },
{ {0,1,0,2,1,1,3,0, 68,42} },
{ {0,1,0,2,1,1,3,1, 63,42} },
{ {0,1,0,2,1,1,3,2, 82,42} },
{ {0,1,0,2,1,1,3,3, 82,3} },
{ {0,1,0,2,1,1,3,4, 132,42} },
{ {0,1,0,2,1,2,0,0, 36,26} },
{ {0,1,0,2,1,2,0,1, 39,26} },
{ {0,1,0,2,1,2,0,2, 42,41} },
{ {0,1,0,2,1,2,0,3, 78,41} },
{ {0,1,0,2,1,2,1,0, 48,40} },
{ {0,1,0,2,1,2,1,1, 40,4} },
{ {0,1,0,2,1,2,1,2, 29,37} },
{ {0,1,0,2,1,2,1,3, 91,40} },
{ {0,1,0,2,1,2,2,0, 50,18} },
{ {0,1,0,2,1,2,2,1, 51,19} },
{ {0,1,0,2,1,2,2,2, 18,30} },
{ {0,1,0,2,1,2,2,3, 99,19} },
{ {0,1,0,2,1,2,3,0, 104,19} },
{ {0,1,0,2,1,2,3,1, 105,19} },
{ {0,1,0,2,1,2,3,2, 79,37} },
{ {0,1,0,2,1,2,3,3, 106,19} },
{ {0,1,0,2,1,2,3,4, 141,19} },
{ {0,1,0,2,1,3,0,0, 71,26} },
{ {0,1,0,2,1,3,0,1, 74,26} },
{ {0,1,0,2,1,3,0,2, 75,41} },
{ {0,1,0,2,1,3,0,3, 79,41} },
{ {0,1,0,2,1,3,0,4, 128,41} },
{ {0,1,0,2,1,3,1,0, 92,40} },
{ {0,1,0,2,1,3,1,1, 81,29} },
{ {0,1,0,2,1,3,1,2, 93,40} },
{ {0,1,0,2,1,3,1,3, 94,40} },
{ {0,1,0,2,1,3,1,4, 135,40} },
{ {0,1,0,2,1,3,2,0, 98,18} },
{ {0,1,0,2,1,3,2,1, 99,18} },
{ {0,1,0,2,1,3,2,2, 86,24} },
{ {0,1,0,2,1,3,2,3, 100,19} },
{ {0,1,0,2,1,3,2,4, 139,19} },
{ {0,1,0,2,1,3,3,0, 104,40} },
{ {0,1,0,2,1,3,3,1, 105,40} },
{ {0,1,0,2,1,3,3,2, 106,40} },
{ {0,1,0,2,1,3,3,3, 79,30} },
{ {0,1,0,2,1,3,3,4, 141,40} },
{ {0,1,0,2,1,3,4,0, 142,19} },
{ {0,1,0,2,1,3,4,1, 143,19} },
{ {0,1,0,2,1,3,4,2, 144,19} },
{ {0,1,0,2,1,3,4,3, 145,19} },
{ {0,1,0,2,1,3,4,4, 144,40} },
{ {0,1,0,2,1,3,4,5, 169,19} },
{ {0,1,0,2,2,0,0,0, 21,25} },
{ {0,1,0,2,2,0,0,1, 30,26} },
{ {0,1,0,2,2,0,0,2, 27,26} },
{ {0,1,0,2,2,0,0,3, 67,41} },
{ {0,1,0,2,2,0,1,0, 52,19} },
{ {0,1,0,2,2,0,1,1, 53,19} },
{ {0,1,0,2,2,0,1,2, 53,40} },
{ {0,1,0,2,2,0,1,3, 107,19} },
{ {0,1,0,2,2,0,2,0, 45,29} },
{ {0,1,0,2,2,0,2,1, 48,41} },
{ {0,1,0,2,2,0,2,2, 23,4} },
{ {0,1,0,2,2,0,2,3, 92,41} },
{ {0,1,0,2,2,0,3,0, 110,19} },
{ {0,1,0,2,2,0,3,1, 111,19} },
{ {0,1,0,2,2,0,3,2, 112,19} },
{ {0,1,0,2,2,0,3,3, 108,25} },
{ {0,1,0,2,2,0,3,4, 147,19} },
{ {0,1,0,2,2,1,0,0, 24,26} },
{ {0,1,0,2,2,1,0,1, 32,26} },
{ {0,1,0,2,2,1,0,2, 29,26} },
{ {0,1,0,2,2,1,0,3, 69,41} },
{ {0,1,0,2,2,1,1,0, 53,41} },
{ {0,1,0,2,2,1,1,1, 24,30} },
{ {0,1,0,2,2,1,1,2, 47,9} },
{ {0,1,0,2,2,1,1,3, 108,19} },
{ {0,1,0,2,2,1,2,0, 47,41} },
{ {0,1,0,2,2,1,2,1, 29,36} },
{ {0,1,0,2,2,1,2,2, 37,24} },
{ {0,1,0,2,2,1,2,3, 93,41} },
{ {0,1,0,2,2,1,3,0, 108,43} },
{ {0,1,0,2,2,1,3,1, 69,9} },
{ {0,1,0,2,2,1,3,2, 93,9} },
{ {0,1,0,2,2,1,3,3, 113,19} },
{ {0,1,0,2,2,1,3,4, 148,19} },
{ {0,1,0,2,2,2,0,0, 23,44} },
{ {0,1,0,2,2,2,0,1, 31,26} },
{ {0,1,0,2,2,2,0,2, 28,26} },
{ {0,1,0,2,2,2,0,3, 68,41} },
{ {0,1,0,2,2,2,1,0, 53,18} },
{ {0,1,0,2,2,2,1,1, 47,5} },
{ {0,1,0,2,2,2,1,2, 24,31} },
{ {0,1,0,2,2,2,1,3, 108,40} },
{ {0,1,0,2,2,2,2,0, 27,28} },
{ {0,1,0,2,2,2,2,1, 40,11} },
{ {0,1,0,2,2,2,2,2, 8,5} },
{ {0,1,0,2,2,2,2,3, 81,28} },
{ {0,1,0,2,2,2,3,0, 112,3} },
{ {0,1,0,2,2,2,3,1, 103,3} },
{ {0,1,0,2,2,2,3,2, 73,37} },
{ {0,1,0,2,2,2,3,3, 93,5} },
{ {0,1,0,2,2,2,3,4, 149,19} },
{ {0,1,0,2,2,3,0,0, 64,26} },
{ {0,1,0,2,2,3,0,1, 66,26} },
{ {0,1,0,2,2,3,0,2, 65,26} },
{ {0,1,0,2,2,3,0,3, 69,26} },
{ {0,1,0,2,2,3,0,4, 126,41} },
{ {0,1,0,2,2,3,1,0, 107,41} },
{ {0,1,0,2,2,3,1,1, 108,41} },
{ {0,1,0,2,2,3,1,2, 108,18} },
{ {0,1,0,2,2,3,1,3, 109,19} },
{ {0,1,0,2,2,3,1,4, 146,19} },
{ {0,1,0,2,2,3,2,0, 90,41} },
{ {0,1,0,2,2,3,2,1, 91,41} },
{ {0,1,0,2,2,3,2,2, 72,4} },
{ {0,1,0,2,2,3,2,3, 94,41} },
{ {0,1,0,2,2,3,2,4, 135,41} },
{ {0,1,0,2,2,3,3,0, 111,41} },
{ {0,1,0,2,2,3,3,1, 114,19} },
{ {0,1,0,2,2,3,3,2, 103,39} },
{ {0,1,0,2,2,3,3,3, 69,5} },
{ {0,1,0,2,2,3,3,4, 150,19} },
{ {0,1,0,2,2,3,4,0, 147,41} },
{ {0,1,0,2,2,3,4,1, 150,41} },
{ {0,1,0,2,2,3,4,2, 149,41} },
{ {0,1,0,2,2,3,4,3, 151,19} },
{ {0,1,0,2,2,3,4,4, 148,41} },
{ {0,1,0,2,2,3,4,5, 170,19} },
{ {0,1,0,2,3,0,0,0, 70,25} },
{ {0,1,0,2,3,0,0,1, 85,26} },
{ {0,1,0,2,3,0,0,2, 81,26} },
{ {0,1,0,2,3,0,0,3, 76,26} },
{ {0,1,0,2,3,0,0,4, 131,41} },
{ {0,1,0,2,3,0,1,0, 110,18} },
{ {0,1,0,2,3,0,1,1, 112,24} },
{ {0,1,0,2,3,0,1,2, 108,38} },
{ {0,1,0,2,3,0,1,3, 111,40} },
{ {0,1,0,2,3,0,1,4, 147,40} },
{ {0,1,0,2,3,0,2,0, 101,18} },
{ {0,1,0,2,3,0,2,1, 104,18} },
{ {0,1,0,2,3,0,2,2, 68,39} },
{ {0,1,0,2,3,0,2,3, 104,41} },
{ {0,1,0,2,3,0,2,4, 142,18} },
{ {0,1,0,2,3,0,3,0, 89,28} },
{ {0,1,0,2,3,0,3,1, 91,47} },
{ {0,1,0,2,3,0,3,2, 93,47} },
{ {0,1,0,2,3,0,3,3, 65,29} },
{ {0,1,0,2,3,0,3,4, 135,47} },
{ {0,1,0,2,3,0,4,0, 152,19} },
{ {0,1,0,2,3,0,4,1, 153,19} },
{ {0,1,0,2,3,0,4,2, 149,23} },
{ {0,1,0,2,3,0,4,3, 153,40} },
{ {0,1,0,2,3,0,4,4, 149,4} },
{ {0,1,0,2,3,0,4,5, 171,19} },
{ {0,1,0,2,3,1,0,0, 73,44} },
{ {0,1,0,2,3,1,0,1, 88,9} },
{ {0,1,0,2,3,1,0,2, 84,26} },
{ {0,1,0,2,3,1,0,3, 79,26} },
{ {0,1,0,2,3,1,0,4, 134,41} },
{ {0,1,0,2,3,1,1,0, 112,18} },
{ {0,1,0,2,3,1,1,1, 73,36} },
{ {0,1,0,2,3,1,1,2, 93,22} },
{ {0,1,0,2,3,1,1,3, 103,42} },
{ {0,1,0,2,3,1,1,4, 149,40} },
{ {0,1,0,2,3,1,2,0, 103,18} },
{ {0,1,0,2,3,1,2,1, 79,36} },
{ {0,1,0,2,3,1,2,2, 82,39} },
{ {0,1,0,2,3,1,2,3, 106,41} },
{ {0,1,0,2,3,1,2,4, 144,18} },
{ {0,1,0,2,3,1,3,0, 93,46} },
{ {0,1,0,2,3,1,3,1, 84,36} },
{ {0,1,0,2,3,1,3,2, 96,8} },
{ {0,1,0,2,3,1,3,3, 82,29} },
{ {0,1,0,2,3,1,3,4, 137,40} },
{ {0,1,0,2,3,1,4,0, 149,8} },
{ {0,1,0,2,3,1,4,1, 134,9} },
{ {0,1,0,2,3,1,4,2, 137,8} },
{ {0,1,0,2,3,1,4,3, 144,42} },
{ {0,1,0,2,3,1,4,4, 154,19} },
{ {0,1,0,2,3,1,4,5, 172,19} },
{ {0,1,0,2,3,2,0,0, 71,44} },
{ {0,1,0,2,3,2,0,1, 87,26} },
{ {0,1,0,2,3,2,0,2, 83,22} },
{ {0,1,0,2,3,2,0,3, 78,26} },
{ {0,1,0,2,3,2,0,4, 133,41} },
{ {0,1,0,2,3,2,1,0, 111,18} },
{ {0,1,0,2,3,2,1,1, 103,24} },
{ {0,1,0,2,3,2,1,2, 69,22} },
{ {0,1,0,2,3,2,1,3, 114,18} },
{ {0,1,0,2,3,2,1,4, 150,40} },
{ {0,1,0,2,3,2,2,0, 102,18} },
{ {0,1,0,2,3,2,2,1, 105,18} },
{ {0,1,0,2,3,2,2,2, 63,39} },
{ {0,1,0,2,3,2,2,3, 105,41} },
{ {0,1,0,2,3,2,2,4, 143,18} },
{ {0,1,0,2,3,2,3,0, 91,46} },
{ {0,1,0,2,3,2,3,1, 97,40} },
{ {0,1,0,2,3,2,3,2, 84,37} },
{ {0,1,0,2,3,2,3,3, 75,4} },
{ {0,1,0,2,3,2,3,4, 138,40} },
{ {0,1,0,2,3,2,4,0, 153,18} },
{ {0,1,0,2,3,2,4,1, 155,19} },
{ {0,1,0,2,3,2,4,2, 134,22} },
{ {0,1,0,2,3,2,4,3, 156,19} },
{ {0,1,0,2,3,2,4,4, 144,24} },
{ {0,1,0,2,3,2,4,5, 173,19} },
{ {0,1,0,2,3,3,0,0, 72,44} },
{ {0,1,0,2,3,3,0,1, 86,26} },
{ {0,1,0,2,3,3,0,2, 82,26} },
{ {0,1,0,2,3,3,0,3, 77,26} },
{ {0,1,0,2,3,3,0,4, 132,41} },
{ {0,1,0,2,3,3,1,0, 108,2} },
{ {0,1,0,2,3,3,1,1, 93,10} },
{ {0,1,0,2,3,3,1,2, 113,18} },
{ {0,1,0,2,3,3,1,3, 69,10} },
{ {0,1,0,2,3,3,1,4, 148,40} },
{ {0,1,0,2,3,3,2,0, 103,41} },
{ {0,1,0,2,3,3,2,1, 106,18} },
{ {0,1,0,2,3,3,2,2, 82,24} },
{ {0,1,0,2,3,3,2,3, 79,31} },
{ {0,1,0,2,3,3,2,4, 144,41} },
{ {0,1,0,2,3,3,3,0, 65,28} },
{ {0,1,0,2,3,3,3,1, 75,11} },
{ {0,1,0,2,3,3,3,2, 82,28} },
{ {0,1,0,2,3,3,3,3, 59,28} },
{ {0,1,0,2,3,3,3,4, 129,28} },
{ {0,1,0,2,3,3,4,0, 149,11} },
{ {0,1,0,2,3,3,4,1, 144,3} },
{ {0,1,0,2,3,3,4,2, 154,18} },
{ {0,1,0,2,3,3,4,3, 134,10} },
{ {0,1,0,2,3,3,4,4, 137,11} },
{ {0,1,0,2,3,3,4,5, 172,40} },
{ {0,1,0,2,3,4,0,0, 127,26} },
{ {0,1,0,2,3,4,0,1, 130,26} },
{ {0,1,0,2,3,4,0,2, 129,26} },
{ {0,1,0,2,3,4,0,3, 128,26} },
{ {0,1,0,2,3,4,0,4, 134,26} },
{ {0,1,0,2,3,4,0,5, 167,41} },
{ {0,1,0,2,3,4,1,0, 147,18} },
{ {0,1,0,2,3,4,1,1, 149,18} },
{ {0,1,0,2,3,4,1,2, 148,18} },
{ {0,1,0,2,3,4,1,3, 150,18} },
{ {0,1,0,2,3,4,1,4, 151,18} },
{ {0,1,0,2,3,4,1,5, 170,18} },
{ {0,1,0,2,3,4,2,0, 140,18} },
{ {0,1,0,2,3,4,2,1, 141,18} },
{ {0,1,0,2,3,4,2,2, 132,39} },
{ {0,1,0,2,3,4,2,3, 141,41} },
{ {0,1,0,2,3,4,2,4, 145,18} },
{ {0,1,0,2,3,4,2,5, 169,18} },
{ {0,1,0,2,3,4,3,0, 135,46} },
{ {0,1,0,2,3,4,3,1, 138,41} },
{ {0,1,0,2,3,4,3,2, 137,41} },
{ {0,1,0,2,3,4,3,3, 129,29} },
{ {0,1,0,2,3,4,3,4, 136,47} },
{ {0,1,0,2,3,4,3,5, 168,40} },
{ {0,1,0,2,3,4,4,0, 153,41} },
{ {0,1,0,2,3,4,4,1, 156,18} },
{ {0,1,0,2,3,4,4,2, 144,39} },
{ {0,1,0,2,3,4,4,3, 155,40} },
{ {0,1,0,2,3,4,4,4, 134,5} },
{ {0,1,0,2,3,4,4,5, 173,40} },
{ {0,1,0,2,3,4,5,0, 171,18} },
{ {0,1,0,2,3,4,5,1, 173,18} },
{ {0,1,0,2,3,4,5,2, 172,18} },
{ {0,1,0,2,3,4,5,3, 173,41} },
{ {0,1,0,2,3,4,5,4, 174,19} },
{ {0,1,0,2,3,4,5,5, 172,41} },
{ {0,1,0,2,3,4,5,6, 182,19} },
{ {0,1,1,0,0,0,0,0, 4,5} },
{ {0,1,1,0,0,0,0,1, 13,2} },
{ {0,1,1,0,0,0,0,2, 16,12} },
{ {0,1,1,0,0,0,1,0, 20,10} },
{ {0,1,1,0,0,0,1,1, 25,2} },
{ {0,1,1,0,0,0,1,2, 27,33} },
{ {0,1,1,0,0,0,2,0, 35,10} },
{ {0,1,1,0,0,0,2,1, 38,2} },
{ {0,1,1,0,0,0,2,2, 40,33} },
{ {0,1,1,0,0,0,2,3, 76,33} },
{ {0,1,1,0,0,1,0,0, 20,4} },
{ {0,1,1,0,0,1,0,1, 25,12} },
{ {0,1,1,0,0,1,0,2, 27,12} },
{ {0,1,1,0,0,1,1,0, 44,12} },
{ {0,1,1,0,0,1,1,1, 20,5} },
{ {0,1,1,0,0,1,1,2, 45,13} },
{ {0,1,1,0,0,1,2,0, 45,8} },
{ {0,1,1,0,0,1,2,1, 27,9} },
{ {0,1,1,0,0,1,2,2, 47,32} },
{ {0,1,1,0,0,1,2,3, 90,32} },
{ {0,1,1,0,0,2,0,0, 35,4} },
{ {0,1,1,0,0,2,0,1, 38,12} },
{ {0,1,1,0,0,2,0,2, 40,12} },
{ {0,1,1,0,0,2,0,3, 76,12} },
{ {0,1,1,0,0,2,1,0, 45,26} },
{ {0,1,1,0,0,2,1,1, 27,44} },
{ {0,1,1,0,0,2,1,2, 47,13} },
{ {0,1,1,0,0,2,1,3, 90,13} },
{ {0,1,1,0,0,2,2,0, 49,13} },
{ {0,1,1,0,0,2,2,1, 50,13} },
{ {0,1,1,0,0,2,2,2, 31,5} },
{ {0,1,1,0,0,2,2,3, 98,13} },
{ {0,1,1,0,0,2,3,0, 101,23} },
{ {0,1,1,0,0,2,3,1, 102,32} },
{ {0,1,1,0,0,2,3,2, 103,32} },
{ {0,1,1,0,0,2,3,3, 103,13} },
{ {0,1,1,0,0,2,3,4, 140,32} },
{ {0,1,1,0,1,0,0,0, 13,5} },
{ {0,1,1,0,1,0,0,1, 54,0} },
{ {0,1,1,0,1,0,0,2, 55,0} },
{ {0,1,1,0,1,0,1,0, 25,22} },
{ {0,1,1,0,1,0,1,1, 13,4} },
{ {0,1,1,0,1,0,1,2, 38,27} },
{ {0,1,1,0,1,0,2,0, 38,22} },
{ {0,1,1,0,1,0,2,1, 55,1} },
{ {0,1,1,0,1,0,2,2, 51,5} },
{ {0,1,1,0,1,0,2,3, 115,0} },
{ {0,1,1,0,1,1,0,0, 25,24} },
{ {0,1,1,0,1,1,0,1, 13,3} },
{ {0,1,1,0,1,1,0,2, 38,3} },
{ {0,1,1,0,1,1,1,0, 20,11} },
{ {0,1,1,0,1,1,1,1, 4,4} },
{ {0,1,1,0,1,1,1,2, 35,11} },
{ {0,1,1,0,1,1,2,0, 27,42} },
{ {0,1,1,0,1,1,2,1, 16,9} },
{ {0,1,1,0,1,1,2,2, 40,42} },
{ {0,1,1,0,1,1,2,3, 76,42} },
{ {0,1,1,0,1,2,0,0, 38,24} },
{ {0,1,1,0,1,2,0,1, 55,6} },
{ {0,1,1,0,1,2,0,2, 51,30} },
{ {0,1,1,0,1,2,0,3, 115,19} },
{ {0,1,1,0,1,2,1,0, 27,27} },
{ {0,1,1,0,1,2,1,1, 16,27} },
{ {0,1,1,0,1,2,1,2, 40,27} },
{ {0,1,1,0,1,2,1,3, 76,27} },
{ {0,1,1,0,1,2,2,0, 50,23} },
{ {0,1,1,0,1,2,2,1, 56,0} },
{ {0,1,1,0,1,2,2,2, 39,5} },
{ {0,1,1,0,1,2,2,3, 116,0} },
{ {0,1,1,0,1,2,3,0, 102,23} },
{ {0,1,1,0,1,2,3,1, 117,0} },
{ {0,1,1,0,1,2,3,2, 105,36} },
{ {0,1,1,0,1,2,3,3, 105,25} },
{ {0,1,1,0,1,2,3,4, 157,0} },
{ {0,1,1,0,2,0,0,0, 16,22} },
{ {0,1,1,0,2,0,0,1, 55,7} },
{ {0,1,1,0,2,0,0,2, 56,1} },
{ {0,1,1,0,2,0,0,3, 117,1} },
{ {0,1,1,0,2,0,1,0, 27,22} },
{ {0,1,1,0,2,0,1,1, 38,25} },
{ {0,1,1,0,2,0,1,2, 50,26} },
{ {0,1,1,0,2,0,1,3, 102,26} },
{ {0,1,1,0,2,0,2,0, 40,22} },
{ {0,1,1,0,2,0,2,1, 51,28} },
{ {0,1,1,0,2,0,2,2, 39,4} },
{ {0,1,1,0,2,0,2,3, 105,47} },
{ {0,1,1,0,2,0,3,0, 76,22} },
{ {0,1,1,0,2,0,3,1, 115,14} },
{ {0,1,1,0,2,0,3,2, 116,1} },
{ {0,1,1,0,2,0,3,3, 105,24} },
{ {0,1,1,0,2,0,3,4, 157,1} },
{ {0,1,1,0,2,1,0,0, 27,39} },
{ {0,1,1,0,2,1,0,1, 38,9} },
{ {0,1,1,0,2,1,0,2, 50,8} },
{ {0,1,1,0,2,1,0,3, 102,43} },
{ {0,1,1,0,2,1,1,0, 45,23} },
{ {0,1,1,0,2,1,1,1, 35,5} },
{ {0,1,1,0,2,1,1,2, 49,8} },
{ {0,1,1,0,2,1,1,3, 101,26} },
{ {0,1,1,0,2,1,2,0, 47,23} },
{ {0,1,1,0,2,1,2,1, 40,9} },
{ {0,1,1,0,2,1,2,2, 31,4} },
{ {0,1,1,0,2,1,2,3, 103,43} },
{ {0,1,1,0,2,1,3,0, 90,8} },
{ {0,1,1,0,2,1,3,1, 76,9} },
{ {0,1,1,0,2,1,3,2, 98,8} },
{ {0,1,1,0,2,1,3,3, 103,8} },
{ {0,1,1,0,2,1,3,4, 140,43} },
{ {0,1,1,0,2,2,0,0, 40,39} },
{ {0,1,1,0,2,2,0,1, 51,2} },
{ {0,1,1,0,2,2,0,2, 39,10} },
{ {0,1,1,0,2,2,0,3, 105,2} },
{ {0,1,1,0,2,2,1,0, 47,38} },
{ {0,1,1,0,2,2,1,1, 40,44} },
{ {0,1,1,0,2,2,1,2, 31,10} },
{ {0,1,1,0,2,2,1,3, 103,26} },
{ {0,1,1,0,2,2,2,0, 31,11} },
{ {0,1,1,0,2,2,2,1, 39,11} },
{ {0,1,1,0,2,2,2,2, 12,5} },
{ {0,1,1,0,2,2,2,3, 87,11} },
{ {0,1,1,0,2,2,3,0, 103,23} },
{ {0,1,1,0,2,2,3,1, 105,3} },
{ {0,1,1,0,2,2,3,2, 87,10} },
{ {0,1,1,0,2,2,3,3, 97,11} },
{ {0,1,1,0,2,2,3,4, 155,2} },
{ {0,1,1,0,2,3,0,0, 76,39} },
{ {0,1,1,0,2,3,0,1, 115,6} },
{ {0,1,1,0,2,3,0,2, 116,18} },
{ {0,1,1,0,2,3,0,3, 105,37} },
{ {0,1,1,0,2,3,0,4, 157,18} },
{ {0,1,1,0,2,3,1,0, 90,45} },
{ {0,1,1,0,2,3,1,1, 76,44} },
{ {0,1,1,0,2,3,1,2, 98,26} },
{ {0,1,1,0,2,3,1,3, 103,45} },
{ {0,1,1,0,2,3,1,4, 140,26} },
{ {0,1,1,0,2,3,2,0, 103,38} },
{ {0,1,1,0,2,3,2,1, 105,46} },
{ {0,1,1,0,2,3,2,2, 87,4} },
{ {0,1,1,0,2,3,2,3, 97,28} },
{ {0,1,1,0,2,3,2,4, 155,47} },
{ {0,1,1,0,2,3,3,0, 98,23} },
{ {0,1,1,0,2,3,3,1, 116,15} },
{ {0,1,1,0,2,3,3,2, 118,0} },
{ {0,1,1,0,2,3,3,3, 87,5} },
{ {0,1,1,0,2,3,3,4, 158,0} },
{ {0,1,1,0,2,3,4,0, 140,23} },
{ {0,1,1,0,2,3,4,1, 157,15} },
{ {0,1,1,0,2,3,4,2, 158,1} },
{ {0,1,1,0,2,3,4,3, 155,36} },
{ {0,1,1,0,2,3,4,4, 155,25} },
{ {0,1,1,0,2,3,4,5, 175,0} },
{ {0,1,1,1,0,0,0,0, 5,11} },
{ {0,1,1,1,0,0,0,1, 14,2} },
{ {0,1,1,1,0,0,0,2, 17,12} },
{ {0,1,1,1,0,0,1,0, 22,2} },
{ {0,1,1,1,0,0,1,1, 5,7} },
{ {0,1,1,1,0,0,1,2, 28,33} },
{ {0,1,1,1,0,0,2,0, 28,15} },
{ {0,1,1,1,0,0,2,1, 17,15} },
{ {0,1,1,1,0,0,2,2, 41,33} },
{ {0,1,1,1,0,0,2,3, 77,33} },
{ {0,1,1,1,0,1,0,0, 22,29} },
{ {0,1,1,1,0,1,0,1, 5,23} },
{ {0,1,1,1,0,1,0,2, 28,12} },
{ {0,1,1,1,0,1,1,0, 20,15} },
{ {0,1,1,1,0,1,1,1, 2,22} },
{ {0,1,1,1,0,1,1,2, 34,15} },
{ {0,1,1,1,0,1,2,0, 23,35} },
{ {0,1,1,1,0,1,2,1, 8,34} },
{ {0,1,1,1,0,1,2,2, 37,15} },
{ {0,1,1,1,0,1,2,3, 72,35} },
{ {0,1,1,1,0,2,0,0, 28,16} },
{ {0,1,1,1,0,2,0,1, 17,7} },
{ {0,1,1,1,0,2,0,2, 41,12} },
{ {0,1,1,1,0,2,0,3, 77,12} },
{ {0,1,1,1,0,2,1,0, 23,6} },
{ {0,1,1,1,0,2,1,1, 8,7} },
{ {0,1,1,1,0,2,1,2, 37,16} },
{ {0,1,1,1,0,2,1,3, 72,6} },
{ {0,1,1,1,0,2,2,0, 31,15} },
{ {0,1,1,1,0,2,2,1, 18,23} },
{ {0,1,1,1,0,2,2,2, 43,15} },
{ {0,1,1,1,0,2,2,3, 86,15} },
{ {0,1,1,1,0,2,3,0, 68,15} },
{ {0,1,1,1,0,2,3,1, 63,15} },
{ {0,1,1,1,0,2,3,2, 82,15} },
{ {0,1,1,1,0,2,3,3, 82,16} },
{ {0,1,1,1,0,2,3,4, 132,15} },
{ {0,1,1,1,1,0,0,0, 25,5} },
{ {0,1,1,1,1,0,0,1, 13,7} },
{ {0,1,1,1,1,0,0,2, 38,15} },
{ {0,1,1,1,1,0,1,0, 20,6} },
{ {0,1,1,1,1,0,1,1, 4,7} },
{ {0,1,1,1,1,0,1,2, 35,6} },
{ {0,1,1,1,1,0,2,0, 27,15} },
{ {0,1,1,1,1,0,2,1, 16,15} },
{ {0,1,1,1,1,0,2,2, 40,15} },
{ {0,1,1,1,1,0,2,3, 76,15} },
{ {0,1,1,1,1,1,0,0, 20,8} },
{ {0,1,1,1,1,1,0,1, 4,9} },
{ {0,1,1,1,1,1,0,2, 35,8} },
{ {0,1,1,1,1,1,1,0, 19,6} },
{ {0,1,1,1,1,1,1,1, 1,5} },
{ {0,1,1,1,1,1,1,2, 33,3} },
{ {0,1,1,1,1,1,2,0, 21,8} },
{ {0,1,1,1,1,1,2,1, 7,9} },
{ {0,1,1,1,1,1,2,2, 34,8} },
{ {0,1,1,1,1,1,2,3, 70,8} },
{ {0,1,1,1,1,2,0,0, 27,16} },
{ {0,1,1,1,1,2,0,1, 16,7} },
{ {0,1,1,1,1,2,0,2, 40,16} },
{ {0,1,1,1,1,2,0,3, 76,16} },
{ {0,1,1,1,1,2,1,0, 21,6} },
{ {0,1,1,1,1,2,1,1, 7,7} },
{ {0,1,1,1,1,2,1,2, 34,6} },
{ {0,1,1,1,1,2,1,3, 70,6} },
{ {0,1,1,1,1,2,2,0, 30,15} },
{ {0,1,1,1,1,2,2,1, 16,23} },
{ {0,1,1,1,1,2,2,2, 26,5} },
{ {0,1,1,1,1,2,2,3, 85,15} },
{ {0,1,1,1,1,2,3,0, 67,15} },
{ {0,1,1,1,1,2,3,1, 62,15} },
{ {0,1,1,1,1,2,3,2, 81,15} },
{ {0,1,1,1,1,2,3,3, 81,16} },
{ {0,1,1,1,1,2,3,4, 131,15} },
{ {0,1,1,1,2,0,0,0, 26,15} },
{ {0,1,1,1,2,0,0,1, 15,7} },
{ {0,1,1,1,2,0,0,2, 39,15} },
{ {0,1,1,1,2,0,0,3, 74,15} },
{ {0,1,1,1,2,0,1,0, 23,16} },
{ {0,1,1,1,2,0,1,1, 6,7} },
{ {0,1,1,1,2,0,1,2, 36,16} },
{ {0,1,1,1,2,0,1,3, 71,16} },
{ {0,1,1,1,2,0,2,0, 29,15} },
{ {0,1,1,1,2,0,2,1, 18,15} },
{ {0,1,1,1,2,0,2,2, 42,15} },
{ {0,1,1,1,2,0,2,3, 79,15} },
{ {0,1,1,1,2,0,3,0, 65,15} },
{ {0,1,1,1,2,0,3,1, 61,15} },
{ {0,1,1,1,2,0,3,2, 78,15} },
{ {0,1,1,1,2,0,3,3, 75,15} },
{ {0,1,1,1,2,0,3,4, 128,15} },
{ {0,1,1,1,2,1,0,0, 23,15} },
{ {0,1,1,1,2,1,0,1, 6,23} },
{ {0,1,1,1,2,1,0,2, 36,15} },
{ {0,1,1,1,2,1,0,3, 71,15} },
{ {0,1,1,1,2,1,1,0, 21,15} },
{ {0,1,1,1,2,1,1,1, 3,23} },
{ {0,1,1,1,2,1,1,2, 35,15} },
{ {0,1,1,1,2,1,1,3, 70,15} },
{ {0,1,1,1,2,1,2,0, 24,15} },
{ {0,1,1,1,2,1,2,1, 8,23} },
{ {0,1,1,1,2,1,2,2, 28,4} },
{ {0,1,1,1,2,1,2,3, 73,15} },
{ {0,1,1,1,2,1,3,0, 64,35} },
{ {0,1,1,1,2,1,3,1, 58,34} },
{ {0,1,1,1,2,1,3,2, 71,35} },
{ {0,1,1,1,2,1,3,3, 72,15} },
{ {0,1,1,1,2,1,3,4, 127,15} },
{ {0,1,1,1,2,2,0,0, 29,16} },
{ {0,1,1,1,2,2,0,1, 18,7} },
{ {0,1,1,1,2,2,0,2, 42,16} },
{ {0,1,1,1,2,2,0,3, 79,16} },
{ {0,1,1,1,2,2,1,0, 24,6} },
{ {0,1,1,1,2,2,1,1, 8,38} },
{ {0,1,1,1,2,2,1,2, 28,31} },
{ {0,1,1,1,2,2,1,3, 73,16} },
{ {0,1,1,1,2,2,2,0, 32,15} },
{ {0,1,1,1,2,2,2,1, 17,23} },
{ {0,1,1,1,2,2,2,2, 10,5} },
{ {0,1,1,1,2,2,2,3, 88,15} },
{ {0,1,1,1,2,2,3,0, 69,15} },
{ {0,1,1,1,2,2,3,1, 63,34} },
{ {0,1,1,1,2,2,3,2, 83,15} },
{ {0,1,1,1,2,2,3,3, 84,16} },
{ {0,1,1,1,2,2,3,4, 134,15} },
{ {0,1,1,1,2,3,0,0, 65,16} },
{ {0,1,1,1,2,3,0,1, 61,7} },
{ {0,1,1,1,2,3,0,2, 78,16} },
{ {0,1,1,1,2,3,0,3, 75,16} },
{ {0,1,1,1,2,3,0,4, 128,16} },
{ {0,1,1,1,2,3,1,0, 64,6} },
{ {0,1,1,1,2,3,1,1, 58,7} },
{ {0,1,1,1,2,3,1,2, 71,6} },
{ {0,1,1,1,2,3,1,3, 72,16} },
{ {0,1,1,1,2,3,1,4, 127,16} },
{ {0,1,1,1,2,3,2,0, 69,16} },
{ {0,1,1,1,2,3,2,1, 63,7} },
{ {0,1,1,1,2,3,2,2, 83,16} },
{ {0,1,1,1,2,3,2,3, 84,15} },
{ {0,1,1,1,2,3,2,4, 134,16} },
{ {0,1,1,1,2,3,3,0, 66,15} },
{ {0,1,1,1,2,3,3,1, 61,23} },
{ {0,1,1,1,2,3,3,2, 87,15} },
{ {0,1,1,1,2,3,3,3, 80,15} },
{ {0,1,1,1,2,3,3,4, 130,15} },
{ {0,1,1,1,2,3,4,0, 126,15} },
{ {0,1,1,1,2,3,4,1, 125,15} },
{ {0,1,1,1,2,3,4,2, 133,15} },
{ {0,1,1,1,2,3,4,3, 129,15} },
{ {0,1,1,1,2,3,4,4, 129,16} },
{ {0,1,1,1,2,3,4,5, 167,15} },
{ {0,1,1,2,0,0,0,0, 6,11} },
{ {0,1,1,2,0,0,0,1, 15,2} },
{ {0,1,1,2,0,0,0,2, 18,12} },
{ {0,1,1,2,0,0,0,3, 61,12} },
{ {0,1,1,2,0,0,1,0, 23,2} },
{ {0,1,1,2,0,0,1,1, 26,2} },
{ {0,1,1,2,0,0,1,2, 29,33} },
{ {0,1,1,2,0,0,1,3, 65,33} },
{ {0,1,1,2,0,0,2,0, 36,2} },
{ {0,1,1,2,0,0,2,1, 39,2} },
{ {0,1,1,2,0,0,2,2, 42,33} },
{ {0,1,1,2,0,0,2,3, 78,33} },
{ {0,1,1,2,0,0,3,0, 71,2} },
{ {0,1,1,2,0,0,3,1, 74,2} },
{ {0,1,1,2,0,0,3,2, 79,33} },
{ {0,1,1,2,0,0,3,3, 75,33} },
{ {0,1,1,2,0,0,3,4, 128,33} },
{ {0,1,1,2,0,1,0,0, 23,47} },
{ {0,1,1,2,0,1,0,1, 26,12} },
{ {0,1,1,2,0,1,0,2, 29,12} },
{ {0,1,1,2,0,1,0,3, 65,12} },
{ {0,1,1,2,0,1,1,0, 45,12} },
{ {0,1,1,2,0,1,1,1, 34,5} },
{ {0,1,1,2,0,1,1,2, 46,12} },
{ {0,1,1,2,0,1,1,3, 89,13} },
{ {0,1,1,2,0,1,2,0, 48,32} },
{ {0,1,1,2,0,1,2,1, 40,36} },
{ {0,1,1,2,0,1,2,2, 29,39} },
{ {0,1,1,2,0,1,2,3, 91,32} },
{ {0,1,1,2,0,1,3,0, 92,42} },
{ {0,1,1,2,0,1,3,1, 81,9} },
{ {0,1,1,2,0,1,3,2, 94,32} },
{ {0,1,1,2,0,1,3,3, 93,32} },
{ {0,1,1,2,0,1,3,4, 135,32} },
{ {0,1,1,2,0,2,0,0, 36,47} },
{ {0,1,1,2,0,2,0,1, 39,12} },
{ {0,1,1,2,0,2,0,2, 42,12} },
{ {0,1,1,2,0,2,0,3, 78,12} },
{ {0,1,1,2,0,2,1,0, 48,13} },
{ {0,1,1,2,0,2,1,1, 40,25} },
{ {0,1,1,2,0,2,1,2, 29,22} },
{ {0,1,1,2,0,2,1,3, 91,13} },
{ {0,1,1,2,0,2,2,0, 50,12} },
{ {0,1,1,2,0,2,2,1, 51,13} },
{ {0,1,1,2,0,2,2,2, 18,22} },
{ {0,1,1,2,0,2,2,3, 99,13} },
{ {0,1,1,2,0,2,3,0, 104,32} },
{ {0,1,1,2,0,2,3,1, 105,32} },
{ {0,1,1,2,0,2,3,2, 79,22} },
{ {0,1,1,2,0,2,3,3, 106,32} },
{ {0,1,1,2,0,2,3,4, 141,32} },
{ {0,1,1,2,0,3,0,0, 71,47} },
{ {0,1,1,2,0,3,0,1, 74,12} },
{ {0,1,1,2,0,3,0,2, 79,12} },
{ {0,1,1,2,0,3,0,3, 75,12} },
{ {0,1,1,2,0,3,0,4, 128,12} },
{ {0,1,1,2,0,3,1,0, 92,27} },
{ {0,1,1,2,0,3,1,1, 81,44} },
{ {0,1,1,2,0,3,1,2, 94,13} },
{ {0,1,1,2,0,3,1,3, 93,13} },
{ {0,1,1,2,0,3,1,4, 135,13} },
{ {0,1,1,2,0,3,2,0, 104,13} },
{ {0,1,1,2,0,3,2,1, 105,13} },
{ {0,1,1,2,0,3,2,2, 79,39} },
{ {0,1,1,2,0,3,2,3, 106,13} },
{ {0,1,1,2,0,3,2,4, 141,13} },
{ {0,1,1,2,0,3,3,0, 98,12} },
{ {0,1,1,2,0,3,3,1, 99,12} },
{ {0,1,1,2,0,3,3,2, 100,13} },
{ {0,1,1,2,0,3,3,3, 86,5} },
{ {0,1,1,2,0,3,3,4, 139,13} },
{ {0,1,1,2,0,3,4,0, 142,32} },
{ {0,1,1,2,0,3,4,1, 143,32} },
{ {0,1,1,2,0,3,4,2, 145,32} },
{ {0,1,1,2,0,3,4,3, 144,32} },
{ {0,1,1,2,0,3,4,4, 144,13} },
{ {0,1,1,2,0,3,4,5, 169,32} },
{ {0,1,1,2,1,0,0,0, 38,5} },
{ {0,1,1,2,1,0,0,1, 55,2} },
{ {0,1,1,2,1,0,0,2, 51,22} },
{ {0,1,1,2,1,0,0,3, 115,13} },
{ {0,1,1,2,1,0,1,0, 27,46} },
{ {0,1,1,2,1,0,1,1, 16,29} },
{ {0,1,1,2,1,0,1,2, 40,46} },
{ {0,1,1,2,1,0,1,3, 76,46} },
{ {0,1,1,2,1,0,2,0, 50,31} },
{ {0,1,1,2,1,0,2,1, 56,3} },
{ {0,1,1,2,1,0,2,2, 39,24} },
{ {0,1,1,2,1,0,2,3, 116,21} },
{ {0,1,1,2,1,0,3,0, 102,36} },
{ {0,1,1,2,1,0,3,1, 117,21} },
{ {0,1,1,2,1,0,3,2, 105,23} },
{ {0,1,1,2,1,0,3,3, 105,4} },
{ {0,1,1,2,1,0,3,4, 157,21} },
{ {0,1,1,2,1,1,0,0, 27,3} },
{ {0,1,1,2,1,1,0,1, 16,3} },
{ {0,1,1,2,1,1,0,2, 40,3} },
{ {0,1,1,2,1,1,0,3, 76,3} },
{ {0,1,1,2,1,1,1,0, 21,11} },
{ {0,1,1,2,1,1,1,1, 7,10} },
{ {0,1,1,2,1,1,1,2, 34,11} },
{ {0,1,1,2,1,1,1,3, 70,11} },
{ {0,1,1,2,1,1,2,0, 30,3} },
{ {0,1,1,2,1,1,2,1, 16,31} },
{ {0,1,1,2,1,1,2,2, 26,24} },
{ {0,1,1,2,1,1,2,3, 85,3} },
{ {0,1,1,2,1,1,3,0, 67,42} },
{ {0,1,1,2,1,1,3,1, 62,42} },
{ {0,1,1,2,1,1,3,2, 81,42} },
{ {0,1,1,2,1,1,3,3, 81,3} },
{ {0,1,1,2,1,1,3,4, 131,42} },
{ {0,1,1,2,1,2,0,0, 50,4} },
{ {0,1,1,2,1,2,0,1, 56,13} },
{ {0,1,1,2,1,2,0,2, 39,22} },
{ {0,1,1,2,1,2,0,3, 116,13} },
{ {0,1,1,2,1,2,1,0, 30,27} },
{ {0,1,1,2,1,2,1,1, 16,4} },
{ {0,1,1,2,1,2,1,2, 26,22} },
{ {0,1,1,2,1,2,1,3, 85,27} },
{ {0,1,1,2,1,2,2,0, 57,0} },
{ {0,1,1,2,1,2,2,1, 55,5} },
{ {0,1,1,2,1,2,2,2, 15,5} },
{ {0,1,1,2,1,2,2,3, 119,0} },
{ {0,1,1,2,1,2,3,0, 120,0} },
{ {0,1,1,2,1,2,3,1, 117,9} },
{ {0,1,1,2,1,2,3,2, 74,22} },
{ {0,1,1,2,1,2,3,3, 99,5} },
{ {0,1,1,2,1,2,3,4, 159,0} },
{ {0,1,1,2,1,3,0,0, 102,25} },
{ {0,1,1,2,1,3,0,1, 117,27} },
{ {0,1,1,2,1,3,0,2, 105,38} },
{ {0,1,1,2,1,3,0,3, 105,31} },
{ {0,1,1,2,1,3,0,4, 157,40} },
{ {0,1,1,2,1,3,1,0, 67,27} },
{ {0,1,1,2,1,3,1,1, 62,27} },
{ {0,1,1,2,1,3,1,2, 81,27} },
{ {0,1,1,2,1,3,1,3, 81,46} },
{ {0,1,1,2,1,3,1,4, 131,27} },
{ {0,1,1,2,1,3,2,0, 120,19} },
{ {0,1,1,2,1,3,2,1, 117,7} },
{ {0,1,1,2,1,3,2,2, 74,24} },
{ {0,1,1,2,1,3,2,3, 99,30} },
{ {0,1,1,2,1,3,2,4, 159,19} },
{ {0,1,1,2,1,3,3,0, 120,13} },
{ {0,1,1,2,1,3,3,1, 117,10} },
{ {0,1,1,2,1,3,3,2, 99,22} },
{ {0,1,1,2,1,3,3,3, 74,5} },
{ {0,1,1,2,1,3,3,4, 159,13} },
{ {0,1,1,2,1,3,4,0, 160,0} },
{ {0,1,1,2,1,3,4,1, 161,0} },
{ {0,1,1,2,1,3,4,2, 143,23} },
{ {0,1,1,2,1,3,4,3, 143,36} },
{ {0,1,1,2,1,3,4,4, 143,25} },
{ {0,1,1,2,1,3,4,5, 176,0} },
{ {0,1,1,2,2,0,0,0, 30,5} },
{ {0,1,1,2,2,0,0,1, 57,2} },
{ {0,1,1,2,2,0,0,2, 50,22} },
{ {0,1,1,2,2,0,0,3, 120,12} },
{ {0,1,1,2,2,0,1,0, 53,36} },
{ {0,1,1,2,2,0,1,1, 30,25} },
{ {0,1,1,2,2,0,1,2, 48,44} },
{ {0,1,1,2,2,0,1,3, 111,26} },
{ {0,1,1,2,2,0,2,0, 48,30} },
{ {0,1,1,2,2,0,2,1, 50,29} },
{ {0,1,1,2,2,0,2,2, 36,4} },
{ {0,1,1,2,2,0,2,3, 104,47} },
{ {0,1,1,2,2,0,3,0, 111,36} },
{ {0,1,1,2,2,0,3,1, 120,15} },
{ {0,1,1,2,2,0,3,2, 104,23} },
{ {0,1,1,2,2,0,3,3, 114,5} },
{ {0,1,1,2,2,0,3,4, 162,0} },
{ {0,1,1,2,2,1,0,0, 53,25} },
{ {0,1,1,2,2,1,0,1, 30,9} },
{ {0,1,1,2,2,1,0,2, 48,9} },
{ {0,1,1,2,2,1,0,3, 111,43} },
{ {0,1,1,2,2,1,1,0, 52,9} },
{ {0,1,1,2,2,1,1,1, 21,5} },
{ {0,1,1,2,2,1,1,2, 45,22} },
{ {0,1,1,2,2,1,1,3, 110,26} },
{ {0,1,1,2,2,1,2,0, 53,8} },
{ {0,1,1,2,2,1,2,1, 27,36} },
{ {0,1,1,2,2,1,2,2, 23,24} },
{ {0,1,1,2,2,1,2,3, 112,43} },
{ {0,1,1,2,2,1,3,0, 107,43} },
{ {0,1,1,2,2,1,3,1, 67,9} },
{ {0,1,1,2,2,1,3,2, 92,9} },
{ {0,1,1,2,2,1,3,3, 108,5} },
{ {0,1,1,2,2,1,3,4, 147,43} },
{ {0,1,1,2,2,2,0,0, 48,5} },
{ {0,1,1,2,2,2,0,1, 50,3} },
{ {0,1,1,2,2,2,0,2, 36,31} },
{ {0,1,1,2,2,2,0,3, 104,2} },
{ {0,1,1,2,2,2,1,0, 53,45} },
{ {0,1,1,2,2,2,1,1, 27,25} },
{ {0,1,1,2,2,2,1,2, 23,37} },
{ {0,1,1,2,2,2,1,3, 112,26} },
{ {0,1,1,2,2,2,2,0, 30,11} },
{ {0,1,1,2,2,2,2,1, 38,11} },
{ {0,1,1,2,2,2,2,2, 6,5} },
{ {0,1,1,2,2,2,2,3, 85,11} },
{ {0,1,1,2,2,2,3,0, 111,3} },
{ {0,1,1,2,2,2,3,1, 102,3} },
{ {0,1,1,2,2,2,3,2, 71,37} },
{ {0,1,1,2,2,2,3,3, 91,5} },
{ {0,1,1,2,2,2,3,4, 153,3} },
{ {0,1,1,2,2,3,0,0, 111,25} },
{ {0,1,1,2,2,3,0,1, 120,7} },
{ {0,1,1,2,2,3,0,2, 104,38} },
{ {0,1,1,2,2,3,0,3, 114,30} },
{ {0,1,1,2,2,3,0,4, 162,19} },
{ {0,1,1,2,2,3,1,0, 107,26} },
{ {0,1,1,2,2,3,1,1, 67,44} },
{ {0,1,1,2,2,3,1,2, 92,44} },
{ {0,1,1,2,2,3,1,3, 108,30} },
{ {0,1,1,2,2,3,1,4, 147,26} },
{ {0,1,1,2,2,3,2,0, 111,46} },
{ {0,1,1,2,2,3,2,1, 102,46} },
{ {0,1,1,2,2,3,2,2, 71,24} },
{ {0,1,1,2,2,3,2,3, 91,30} },
{ {0,1,1,2,2,3,2,4, 153,46} },
{ {0,1,1,2,2,3,3,0, 121,0} },
{ {0,1,1,2,2,3,3,1, 120,23} },
{ {0,1,1,2,2,3,3,2, 98,22} },
{ {0,1,1,2,2,3,3,3, 66,5} },
{ {0,1,1,2,2,3,3,4, 163,0} },
{ {0,1,1,2,2,3,4,0, 164,0} },
{ {0,1,1,2,2,3,4,1, 160,15} },
{ {0,1,1,2,2,3,4,2, 142,23} },
{ {0,1,1,2,2,3,4,3, 150,30} },
{ {0,1,1,2,2,3,4,4, 150,5} },
{ {0,1,1,2,2,3,4,5, 177,0} },
{ {0,1,1,2,3,0,0,0, 85,5} },
{ {0,1,1,2,3,0,0,1, 119,7} },
{ {0,1,1,2,3,0,0,2, 99,23} },
{ {0,1,1,2,3,0,0,3, 116,11} },
{ {0,1,1,2,3,0,0,4, 159,12} },
{ {0,1,1,2,3,0,1,0, 112,45} },
{ {0,1,1,2,3,0,1,1, 85,25} },
{ {0,1,1,2,3,0,1,2, 91,38} },
{ {0,1,1,2,3,0,1,3, 104,27} },
{ {0,1,1,2,3,0,1,4, 153,26} },
{ {0,1,1,2,3,0,2,0, 104,37} },
{ {0,1,1,2,3,0,2,1, 116,7} },
{ {0,1,1,2,3,0,2,2, 78,39} },
{ {0,1,1,2,3,0,2,3, 122,0} },
{ {0,1,1,2,3,0,2,4, 165,0} },
{ {0,1,1,2,3,0,3,0, 91,28} },
{ {0,1,1,2,3,0,3,1, 99,28} },
{ {0,1,1,2,3,0,3,2, 106,23} },
{ {0,1,1,2,3,0,3,3, 78,29} },
{ {0,1,1,2,3,0,3,4, 141,47} },
{ {0,1,1,2,3,0,4,0, 153,36} },
{ {0,1,1,2,3,0,4,1, 159,15} },
{ {0,1,1,2,3,0,4,2, 141,23} },
{ {0,1,1,2,3,0,4,3, 165,20} },
{ {0,1,1,2,3,0,4,4, 156,24} },
{ {0,1,1,2,3,0,4,5, 178,0} },
{ {0,1,1,2,3,1,0,0, 112,8} },
{ {0,1,1,2,3,1,0,1, 85,9} },
{ {0,1,1,2,3,1,0,2, 91,23} },
{ {0,1,1,2,3,1,0,3, 104,42} },
{ {0,1,1,2,3,1,0,4, 153,43} },
{ {0,1,1,2,3,1,1,0, 110,8} },
{ {0,1,1,2,3,1,1,1, 70,5} },
{ {0,1,1,2,3,1,1,2, 89,23} },
{ {0,1,1,2,3,1,1,3, 101,27} },
{ {0,1,1,2,3,1,1,4, 152,26} },
{ {0,1,1,2,3,1,2,0, 111,8} },
{ {0,1,1,2,3,1,2,1, 76,36} },
{ {0,1,1,2,3,1,2,2, 65,39} },
{ {0,1,1,2,3,1,2,3, 104,9} },
{ {0,1,1,2,3,1,2,4, 153,8} },
{ {0,1,1,2,3,1,3,0, 108,28} },
{ {0,1,1,2,3,1,3,1, 81,36} },
{ {0,1,1,2,3,1,3,2, 93,23} },
{ {0,1,1,2,3,1,3,3, 68,29} },
{ {0,1,1,2,3,1,3,4, 149,47} },
{ {0,1,1,2,3,1,4,0, 147,8} },
{ {0,1,1,2,3,1,4,1, 131,9} },
{ {0,1,1,2,3,1,4,2, 135,23} },
{ {0,1,1,2,3,1,4,3, 142,42} },
{ {0,1,1,2,3,1,4,4, 149,24} },
{ {0,1,1,2,3,1,4,5, 171,43} },
{ {0,1,1,2,3,2,0,0, 104,24} },
{ {0,1,1,2,3,2,0,1, 116,23} },
{ {0,1,1,2,3,2,0,2, 78,22} },
{ {0,1,1,2,3,2,0,3, 122,19} },
{ {0,1,1,2,3,2,0,4, 165,19} },
{ {0,1,1,2,3,2,1,0, 111,45} },
{ {0,1,1,2,3,2,1,1, 76,25} },
{ {0,1,1,2,3,2,1,2, 65,22} },
{ {0,1,1,2,3,2,1,3, 104,44} },
{ {0,1,1,2,3,2,1,4, 153,45} },
{ {0,1,1,2,3,2,2,0, 120,22} },
{ {0,1,1,2,3,2,2,1, 115,23} },
{ {0,1,1,2,3,2,2,2, 61,22} },
{ {0,1,1,2,3,2,2,3, 116,5} },
{ {0,1,1,2,3,2,2,4, 159,22} },
{ {0,1,1,2,3,2,3,0, 114,46} },
{ {0,1,1,2,3,2,3,1, 105,29} },
{ {0,1,1,2,3,2,3,2, 75,22} },
{ {0,1,1,2,3,2,3,3, 78,4} },
{ {0,1,1,2,3,2,3,4, 156,47} },
{ {0,1,1,2,3,2,4,0, 162,35} },
{ {0,1,1,2,3,2,4,1, 157,34} },
{ {0,1,1,2,3,2,4,2, 128,22} },
{ {0,1,1,2,3,2,4,3, 165,35} },
{ {0,1,1,2,3,2,4,4, 141,24} },
{ {0,1,1,2,3,2,4,5, 178,35} },
{ {0,1,1,2,3,3,0,0, 91,11} },
{ {0,1,1,2,3,3,0,1, 99,2} },
{ {0,1,1,2,3,3,0,2, 106,38} },
{ {0,1,1,2,3,3,0,3, 78,10} },
{ {0,1,1,2,3,3,0,4, 141,2} },
{ {0,1,1,2,3,3,1,0, 108,11} },
{ {0,1,1,2,3,3,1,1, 81,25} },
{ {0,1,1,2,3,3,1,2, 93,38} },
{ {0,1,1,2,3,3,1,3, 68,10} },
{ {0,1,1,2,3,3,1,4, 149,2} },
{ {0,1,1,2,3,3,2,0, 114,3} },
{ {0,1,1,2,3,3,2,1, 105,10} },
{ {0,1,1,2,3,3,2,2, 75,39} },
{ {0,1,1,2,3,3,2,3, 78,31} },
{ {0,1,1,2,3,3,2,4, 156,2} },
{ {0,1,1,2,3,3,3,0, 66,11} },
{ {0,1,1,2,3,3,3,1, 74,11} },
{ {0,1,1,2,3,3,3,2, 86,11} },
{ {0,1,1,2,3,3,3,3, 60,11} },
{ {0,1,1,2,3,3,3,4, 130,11} },
{ {0,1,1,2,3,3,4,0, 150,11} },
{ {0,1,1,2,3,3,4,1, 143,3} },
{ {0,1,1,2,3,3,4,2, 144,23} },
{ {0,1,1,2,3,3,4,3, 133,10} },
{ {0,1,1,2,3,3,4,4, 138,11} },
{ {0,1,1,2,3,3,4,5, 173,2} },
{ {0,1,1,2,3,4,0,0, 153,25} },
{ {0,1,1,2,3,4,0,1, 159,7} },
{ {0,1,1,2,3,4,0,2, 141,38} },
{ {0,1,1,2,3,4,0,3, 165,41} },
{ {0,1,1,2,3,4,0,4, 156,37} },
{ {0,1,1,2,3,4,0,5, 178,19} },
{ {0,1,1,2,3,4,1,0, 147,45} },
{ {0,1,1,2,3,4,1,1, 131,44} },
{ {0,1,1,2,3,4,1,2, 135,38} },
{ {0,1,1,2,3,4,1,3, 142,27} },
{ {0,1,1,2,3,4,1,4, 149,37} },
{ {0,1,1,2,3,4,1,5, 171,26} },
{ {0,1,1,2,3,4,2,0, 162,6} },
{ {0,1,1,2,3,4,2,1, 157,7} },
{ {0,1,1,2,3,4,2,2, 128,39} },
{ {0,1,1,2,3,4,2,3, 165,6} },
{ {0,1,1,2,3,4,2,4, 141,37} },
{ {0,1,1,2,3,4,2,5, 178,6} },
{ {0,1,1,2,3,4,3,0, 150,28} },
{ {0,1,1,2,3,4,3,1, 143,46} },
{ {0,1,1,2,3,4,3,2, 144,38} },
{ {0,1,1,2,3,4,3,3, 133,29} },
{ {0,1,1,2,3,4,3,4, 138,28} },
{ {0,1,1,2,3,4,3,5, 173,47} },
{ {0,1,1,2,3,4,4,0, 163,15} },
{ {0,1,1,2,3,4,4,1, 159,23} },
{ {0,1,1,2,3,4,4,2, 139,23} },
{ {0,1,1,2,3,4,4,3, 158,11} },
{ {0,1,1,2,3,4,4,4, 130,5} },
{ {0,1,1,2,3,4,4,5, 179,0} },
{ {0,1,1,2,3,4,5,0, 177,15} },
{ {0,1,1,2,3,4,5,1, 176,15} },
{ {0,1,1,2,3,4,5,2, 169,23} },
{ {0,1,1,2,3,4,5,3, 180,0} },
{ {0,1,1,2,3,4,5,4, 173,37} },
{ {0,1,1,2,3,4,5,5, 173,24} },
{ {0,1,1,2,3,4,5,6, 183,0} },
{ {0,1,2,0,0,0,0,0, 7,11} },
{ {0,1,2,0,0,0,0,1, 16,2} },
{ {0,1,2,0,0,0,0,2, 16,28} },
{ {0,1,2,0,0,0,0,3, 62,33} },
{ {0,1,2,0,0,0,1,0, 21,10} },
{ {0,1,2,0,0,0,1,1, 27,2} },
{ {0,1,2,0,0,0,1,2, 30,2} },
{ {0,1,2,0,0,0,1,3, 67,33} },
{ {0,1,2,0,0,0,2,0, 34,10} },
{ {0,1,2,0,0,0,2,1, 40,2} },
{ {0,1,2,0,0,0,2,2, 26,25} },
{ {0,1,2,0,0,0,2,3, 81,33} },
{ {0,1,2,0,0,0,3,0, 70,10} },
{ {0,1,2,0,0,0,3,1, 76,2} },
{ {0,1,2,0,0,0,3,2, 85,2} },
{ {0,1,2,0,0,0,3,3, 81,2} },
{ {0,1,2,0,0,0,3,4, 131,33} },
{ {0,1,2,0,0,1,0,0, 34,4} },
{ {0,1,2,0,0,1,0,1, 26,9} },
{ {0,1,2,0,0,1,0,2, 40,47} },
{ {0,1,2,0,0,1,0,3, 81,12} },
{ {0,1,2,0,0,1,1,0, 45,9} },
{ {0,1,2,0,0,1,1,1, 23,36} },
{ {0,1,2,0,0,1,1,2, 48,33} },
{ {0,1,2,0,0,1,1,3, 92,33} },
{ {0,1,2,0,0,1,2,0, 46,9} },
{ {0,1,2,0,0,1,2,1, 29,9} },
{ {0,1,2,0,0,1,2,2, 29,44} },
{ {0,1,2,0,0,1,2,3, 94,43} },
{ {0,1,2,0,0,1,3,0, 89,8} },
{ {0,1,2,0,0,1,3,1, 65,9} },
{ {0,1,2,0,0,1,3,2, 91,43} },
{ {0,1,2,0,0,1,3,3, 93,43} },
{ {0,1,2,0,0,1,3,4, 135,43} },
{ {0,1,2,0,0,2,0,0, 21,4} },
{ {0,1,2,0,0,2,0,1, 30,12} },
{ {0,1,2,0,0,2,0,2, 27,47} },
{ {0,1,2,0,0,2,0,3, 67,12} },
{ {0,1,2,0,0,2,1,0, 52,12} },
{ {0,1,2,0,0,2,1,1, 53,32} },
{ {0,1,2,0,0,2,1,2, 53,13} },
{ {0,1,2,0,0,2,1,3, 107,32} },
{ {0,1,2,0,0,2,2,0, 45,27} },
{ {0,1,2,0,0,2,2,1, 48,12} },
{ {0,1,2,0,0,2,2,2, 23,25} },
{ {0,1,2,0,0,2,2,3, 92,12} },
{ {0,1,2,0,0,2,3,0, 110,23} },
{ {0,1,2,0,0,2,3,1, 111,32} },
{ {0,1,2,0,0,2,3,2, 112,32} },
{ {0,1,2,0,0,2,3,3, 108,4} },
{ {0,1,2,0,0,2,3,4, 147,32} },
{ {0,1,2,0,0,3,0,0, 70,4} },
{ {0,1,2,0,0,3,0,1, 85,12} },
{ {0,1,2,0,0,3,0,2, 76,47} },
{ {0,1,2,0,0,3,0,3, 81,47} },
{ {0,1,2,0,0,3,0,4, 131,12} },
{ {0,1,2,0,0,3,1,0, 110,13} },
{ {0,1,2,0,0,3,1,1, 112,13} },
{ {0,1,2,0,0,3,1,2, 111,13} },
{ {0,1,2,0,0,3,1,3, 108,31} },
{ {0,1,2,0,0,3,1,4, 147,13} },
{ {0,1,2,0,0,3,2,0, 89,26} },
{ {0,1,2,0,0,3,2,1, 91,26} },
{ {0,1,2,0,0,3,2,2, 65,44} },
{ {0,1,2,0,0,3,2,3, 93,26} },
{ {0,1,2,0,0,3,2,4, 135,26} },
{ {0,1,2,0,0,3,3,0, 101,22} },
{ {0,1,2,0,0,3,3,1, 104,33} },
{ {0,1,2,0,0,3,3,2, 104,12} },
{ {0,1,2,0,0,3,3,3, 68,30} },
{ {0,1,2,0,0,3,3,4, 142,33} },
{ {0,1,2,0,0,3,4,0, 152,23} },
{ {0,1,2,0,0,3,4,1, 153,32} },
{ {0,1,2,0,0,3,4,2, 153,13} },
{ {0,1,2,0,0,3,4,3, 149,36} },
{ {0,1,2,0,0,3,4,4, 149,25} },
{ {0,1,2,0,0,3,4,5, 171,32} },
{ {0,1,2,0,1,0,0,0, 16,30} },
{ {0,1,2,0,1,0,0,1, 55,3} },
{ {0,1,2,0,1,0,0,2, 56,2} },
{ {0,1,2,0,1,0,0,3, 117,20} },
{ {0,1,2,0,1,0,1,0, 27,37} },
{ {0,1,2,0,1,0,1,1, 38,4} },
{ {0,1,2,0,1,0,1,2, 50,28} },
{ {0,1,2,0,1,0,1,3, 102,47} },
{ {0,1,2,0,1,0,2,0, 40,37} },
{ {0,1,2,0,1,0,2,1, 51,26} },
{ {0,1,2,0,1,0,2,2, 39,25} },
{ {0,1,2,0,1,0,2,3, 105,26} },
{ {0,1,2,0,1,0,3,0, 76,37} },
{ {0,1,2,0,1,0,3,1, 115,8} },
{ {0,1,2,0,1,0,3,2, 116,20} },
{ {0,1,2,0,1,0,3,3, 105,5} },
{ {0,1,2,0,1,0,3,4, 157,20} },
{ {0,1,2,0,1,1,0,0, 26,3} },
{ {0,1,2,0,1,1,0,1, 15,3} },
{ {0,1,2,0,1,1,0,2, 39,3} },
{ {0,1,2,0,1,1,0,3, 74,3} },
{ {0,1,2,0,1,1,1,0, 23,3} },
{ {0,1,2,0,1,1,1,1, 6,10} },
{ {0,1,2,0,1,1,1,2, 36,3} },
{ {0,1,2,0,1,1,1,3, 71,3} },
{ {0,1,2,0,1,1,2,0, 29,42} },
{ {0,1,2,0,1,1,2,1, 18,9} },
{ {0,1,2,0,1,1,2,2, 42,42} },
{ {0,1,2,0,1,1,2,3, 79,42} },
{ {0,1,2,0,1,1,3,0, 65,42} },
{ {0,1,2,0,1,1,3,1, 61,9} },
{ {0,1,2,0,1,1,3,2, 78,42} },
{ {0,1,2,0,1,1,3,3, 75,42} },
{ {0,1,2,0,1,1,3,4, 128,42} },
{ {0,1,2,0,1,2,0,0, 30,24} },
{ {0,1,2,0,1,2,0,1, 57,6} },
{ {0,1,2,0,1,2,0,2, 50,30} },
{ {0,1,2,0,1,2,0,3, 120,18} },
{ {0,1,2,0,1,2,1,0, 53,23} },
{ {0,1,2,0,1,2,1,1, 30,4} },
{ {0,1,2,0,1,2,1,2, 48,29} },
{ {0,1,2,0,1,2,1,3, 111,47} },
{ {0,1,2,0,1,2,2,0, 48,39} },
{ {0,1,2,0,1,2,2,1, 50,27} },
{ {0,1,2,0,1,2,2,2, 36,25} },
{ {0,1,2,0,1,2,2,3, 104,26} },
{ {0,1,2,0,1,2,3,0, 111,23} },
{ {0,1,2,0,1,2,3,1, 120,9} },
{ {0,1,2,0,1,2,3,2, 104,36} },
{ {0,1,2,0,1,2,3,3, 114,24} },
{ {0,1,2,0,1,2,3,4, 162,21} },
{ {0,1,2,0,1,3,0,0, 85,24} },
{ {0,1,2,0,1,3,0,1, 119,6} },
{ {0,1,2,0,1,3,0,2, 116,6} },
{ {0,1,2,0,1,3,0,3, 99,31} },
{ {0,1,2,0,1,3,0,4, 159,18} },
{ {0,1,2,0,1,3,1,0, 112,38} },
{ {0,1,2,0,1,3,1,1, 85,4} },
{ {0,1,2,0,1,3,1,2, 104,46} },
{ {0,1,2,0,1,3,1,3, 91,31} },
{ {0,1,2,0,1,3,1,4, 153,47} },
{ {0,1,2,0,1,3,2,0, 91,45} },
{ {0,1,2,0,1,3,2,1, 99,26} },
{ {0,1,2,0,1,3,2,2, 78,44} },
{ {0,1,2,0,1,3,2,3, 106,26} },
{ {0,1,2,0,1,3,2,4, 141,26} },
{ {0,1,2,0,1,3,3,0, 104,22} },
{ {0,1,2,0,1,3,3,1, 116,10} },
{ {0,1,2,0,1,3,3,2, 122,1} },
{ {0,1,2,0,1,3,3,3, 78,30} },
{ {0,1,2,0,1,3,3,4, 165,21} },
{ {0,1,2,0,1,3,4,0, 153,23} },
{ {0,1,2,0,1,3,4,1, 159,9} },
{ {0,1,2,0,1,3,4,2, 165,1} },
{ {0,1,2,0,1,3,4,3, 141,36} },
{ {0,1,2,0,1,3,4,4, 156,25} },
{ {0,1,2,0,1,3,4,5, 178,21} },
{ {0,1,2,0,2,0,0,0, 16,5} },
{ {0,1,2,0,2,0,0,1, 56,8} },
{ {0,1,2,0,2,0,0,2, 55,4} },
{ {0,1,2,0,2,0,0,3, 117,12} },
{ {0,1,2,0,2,0,1,0, 30,22} },
{ {0,1,2,0,2,0,1,1, 50,5} },
{ {0,1,2,0,2,0,1,2, 57,1} },
{ {0,1,2,0,2,0,1,3, 120,1} },
{ {0,1,2,0,2,0,2,0, 26,27} },
{ {0,1,2,0,2,0,2,1, 39,27} },
{ {0,1,2,0,2,0,2,2, 15,4} },
{ {0,1,2,0,2,0,2,3, 74,27} },
{ {0,1,2,0,2,0,3,0, 85,22} },
{ {0,1,2,0,2,0,3,1, 116,8} },
{ {0,1,2,0,2,0,3,2, 119,1} },
{ {0,1,2,0,2,0,3,3, 99,4} },
{ {0,1,2,0,2,0,3,4, 159,1} },
{ {0,1,2,0,2,1,0,0, 40,24} },
{ {0,1,2,0,2,1,0,1, 39,9} },
{ {0,1,2,0,2,1,0,2, 51,8} },
{ {0,1,2,0,2,1,0,3, 105,43} },
{ {0,1,2,0,2,1,1,0, 48,22} },
{ {0,1,2,0,2,1,1,1, 36,36} },
{ {0,1,2,0,2,1,1,2, 50,9} },
{ {0,1,2,0,2,1,1,3, 104,43} },
{ {0,1,2,0,2,1,2,0, 29,27} },
{ {0,1,2,0,2,1,2,1, 42,9} },
{ {0,1,2,0,2,1,2,2, 18,27} },
{ {0,1,2,0,2,1,2,3, 79,27} },
{ {0,1,2,0,2,1,3,0, 91,8} },
{ {0,1,2,0,2,1,3,1, 78,9} },
{ {0,1,2,0,2,1,3,2, 99,8} },
{ {0,1,2,0,2,1,3,3, 106,43} },
{ {0,1,2,0,2,1,3,4, 141,43} },
{ {0,1,2,0,2,2,0,0, 27,24} },
{ {0,1,2,0,2,2,0,1, 50,2} },
{ {0,1,2,0,2,2,0,2, 38,10} },
{ {0,1,2,0,2,2,0,3, 102,2} },
{ {0,1,2,0,2,2,1,0, 53,38} },
{ {0,1,2,0,2,2,1,1, 48,4} },
{ {0,1,2,0,2,2,1,2, 30,10} },
{ {0,1,2,0,2,2,1,3, 111,2} },
{ {0,1,2,0,2,2,2,0, 23,46} },
{ {0,1,2,0,2,2,2,1, 36,46} },
{ {0,1,2,0,2,2,2,2, 6,4} },
{ {0,1,2,0,2,2,2,3, 71,46} },
{ {0,1,2,0,2,2,3,0, 112,23} },
{ {0,1,2,0,2,2,3,1, 104,3} },
{ {0,1,2,0,2,2,3,2, 85,10} },
{ {0,1,2,0,2,2,3,3, 91,4} },
{ {0,1,2,0,2,2,3,4, 153,2} },
{ {0,1,2,0,2,3,0,0, 76,24} },
{ {0,1,2,0,2,3,0,1, 116,26} },
{ {0,1,2,0,2,3,0,2, 115,26} },
{ {0,1,2,0,2,3,0,3, 105,30} },
{ {0,1,2,0,2,3,0,4, 157,41} },
{ {0,1,2,0,2,3,1,0, 111,38} },
{ {0,1,2,0,2,3,1,1, 104,25} },
{ {0,1,2,0,2,3,1,2, 120,27} },
{ {0,1,2,0,2,3,1,3, 114,37} },
{ {0,1,2,0,2,3,1,4, 162,40} },
{ {0,1,2,0,2,3,2,0, 65,27} },
{ {0,1,2,0,2,3,2,1, 78,27} },
{ {0,1,2,0,2,3,2,2, 61,27} },
{ {0,1,2,0,2,3,2,3, 75,27} },
{ {0,1,2,0,2,3,2,4, 128,27} },
{ {0,1,2,0,2,3,3,0, 104,39} },
{ {0,1,2,0,2,3,3,1, 122,14} },
{ {0,1,2,0,2,3,3,2, 116,4} },
{ {0,1,2,0,2,3,3,3, 78,5} },
{ {0,1,2,0,2,3,3,4, 165,40} },
{ {0,1,2,0,2,3,4,0, 153,38} },
{ {0,1,2,0,2,3,4,1, 165,14} },
{ {0,1,2,0,2,3,4,2, 159,27} },
{ {0,1,2,0,2,3,4,3, 156,36} },
{ {0,1,2,0,2,3,4,4, 141,25} },
{ {0,1,2,0,2,3,4,5, 178,40} },
{ {0,1,2,0,3,0,0,0, 62,22} },
{ {0,1,2,0,3,0,0,1, 117,22} },
{ {0,1,2,0,3,0,0,2, 117,6} },
{ {0,1,2,0,3,0,0,3, 117,11} },
{ {0,1,2,0,3,0,0,4, 161,1} },
{ {0,1,2,0,3,0,1,0, 67,22} },
{ {0,1,2,0,3,0,1,1, 102,24} },
{ {0,1,2,0,3,0,1,2, 120,14} },
{ {0,1,2,0,3,0,1,3, 120,8} },
{ {0,1,2,0,3,0,1,4, 160,1} },
{ {0,1,2,0,3,0,2,0, 81,22} },
{ {0,1,2,0,3,0,2,1, 105,45} },
{ {0,1,2,0,3,0,2,2, 74,25} },
{ {0,1,2,0,3,0,2,3, 99,27} },
{ {0,1,2,0,3,0,2,4, 143,26} },
{ {0,1,2,0,3,0,3,0, 81,37} },
{ {0,1,2,0,3,0,3,1, 105,28} },
{ {0,1,2,0,3,0,3,2, 99,29} },
{ {0,1,2,0,3,0,3,3, 74,4} },
{ {0,1,2,0,3,0,3,4, 143,47} },
{ {0,1,2,0,3,0,4,0, 131,22} },
{ {0,1,2,0,3,0,4,1, 157,35} },
{ {0,1,2,0,3,0,4,2, 159,14} },
{ {0,1,2,0,3,0,4,3, 159,8} },
{ {0,1,2,0,3,0,4,4, 143,24} },
{ {0,1,2,0,3,0,4,5, 176,1} },
{ {0,1,2,0,3,1,0,0, 81,39} },
{ {0,1,2,0,3,1,0,1, 74,9} },
{ {0,1,2,0,3,1,0,2, 105,8} },
{ {0,1,2,0,3,1,0,3, 99,9} },
{ {0,1,2,0,3,1,0,4, 143,43} },
{ {0,1,2,0,3,1,1,0, 92,22} },
{ {0,1,2,0,3,1,1,1, 71,36} },
{ {0,1,2,0,3,1,1,2, 104,8} },
{ {0,1,2,0,3,1,1,3, 98,9} },
{ {0,1,2,0,3,1,1,4, 142,43} },
{ {0,1,2,0,3,1,2,0, 94,8} },
{ {0,1,2,0,3,1,2,1, 79,9} },
{ {0,1,2,0,3,1,2,2, 79,44} },
{ {0,1,2,0,3,1,2,3, 100,8} },
{ {0,1,2,0,3,1,2,4, 145,43} },
{ {0,1,2,0,3,1,3,0, 93,8} },
{ {0,1,2,0,3,1,3,1, 75,9} },
{ {0,1,2,0,3,1,3,2, 106,8} },
{ {0,1,2,0,3,1,3,3, 86,4} },
{ {0,1,2,0,3,1,3,4, 144,43} },
{ {0,1,2,0,3,1,4,0, 135,8} },
{ {0,1,2,0,3,1,4,1, 128,9} },
{ {0,1,2,0,3,1,4,2, 141,8} },
{ {0,1,2,0,3,1,4,3, 139,8} },
{ {0,1,2,0,3,1,4,4, 144,8} },
{ {0,1,2,0,3,1,4,5, 169,43} },
{ {0,1,2,0,3,2,0,0, 67,39} },
{ {0,1,2,0,3,2,0,1, 120,6} },
{ {0,1,2,0,3,2,0,2, 102,37} },
{ {0,1,2,0,3,2,0,3, 120,26} },
{ {0,1,2,0,3,2,0,4, 160,18} },
{ {0,1,2,0,3,2,1,0, 107,23} },
{ {0,1,2,0,3,2,1,1, 111,24} },
{ {0,1,2,0,3,2,1,2, 111,37} },
{ {0,1,2,0,3,2,1,3, 121,1} },
{ {0,1,2,0,3,2,1,4, 164,1} },
{ {0,1,2,0,3,2,2,0, 92,39} },
{ {0,1,2,0,3,2,2,1, 104,45} },
{ {0,1,2,0,3,2,2,2, 71,25} },
{ {0,1,2,0,3,2,2,3, 98,27} },
{ {0,1,2,0,3,2,2,4, 142,26} },
{ {0,1,2,0,3,2,3,0, 108,29} },
{ {0,1,2,0,3,2,3,1, 114,47} },
{ {0,1,2,0,3,2,3,2, 91,29} },
{ {0,1,2,0,3,2,3,3, 66,4} },
{ {0,1,2,0,3,2,3,4, 150,29} },
{ {0,1,2,0,3,2,4,0, 147,23} },
{ {0,1,2,0,3,2,4,1, 162,14} },
{ {0,1,2,0,3,2,4,2, 153,37} },
{ {0,1,2,0,3,2,4,3, 163,1} },
{ {0,1,2,0,3,2,4,4, 150,4} },
{ {0,1,2,0,3,2,4,5, 177,1} },
{ {0,1,2,0,3,3,0,0, 81,24} },
{ {0,1,2,0,3,3,0,1, 99,3} },
{ {0,1,2,0,3,3,0,2, 105,11} },
{ {0,1,2,0,3,3,0,3, 74,10} },
{ {0,1,2,0,3,3,0,4, 143,2} },
{ {0,1,2,0,3,3,1,0, 108,10} },
{ {0,1,2,0,3,3,1,1, 91,10} },
{ {0,1,2,0,3,3,1,2, 114,2} },
{ {0,1,2,0,3,3,1,3, 66,10} },
{ {0,1,2,0,3,3,1,4, 150,10} },
{ {0,1,2,0,3,3,2,0, 93,45} },
{ {0,1,2,0,3,3,2,1, 106,45} },
{ {0,1,2,0,3,3,2,2, 75,44} },
{ {0,1,2,0,3,3,2,3, 86,10} },
{ {0,1,2,0,3,3,2,4, 144,26} },
{ {0,1,2,0,3,3,3,0, 68,11} },
{ {0,1,2,0,3,3,3,1, 78,11} },
{ {0,1,2,0,3,3,3,2, 78,28} },
{ {0,1,2,0,3,3,3,3, 60,10} },
{ {0,1,2,0,3,3,3,4, 133,11} },
{ {0,1,2,0,3,3,4,0, 149,3} },
{ {0,1,2,0,3,3,4,1, 141,3} },
{ {0,1,2,0,3,3,4,2, 156,3} },
{ {0,1,2,0,3,3,4,3, 130,10} },
{ {0,1,2,0,3,3,4,4, 138,10} },
{ {0,1,2,0,3,3,4,5, 173,3} },
{ {0,1,2,0,3,4,0,0, 131,39} },
{ {0,1,2,0,3,4,0,1, 159,6} },
{ {0,1,2,0,3,4,0,2, 157,6} },
{ {0,1,2,0,3,4,0,3, 159,26} },
{ {0,1,2,0,3,4,0,4, 143,37} },
{ {0,1,2,0,3,4,0,5, 176,18} },
{ {0,1,2,0,3,4,1,0, 147,38} },
{ {0,1,2,0,3,4,1,1, 153,24} },
{ {0,1,2,0,3,4,1,2, 162,17} },
{ {0,1,2,0,3,4,1,3, 163,18} },
{ {0,1,2,0,3,4,1,4, 150,31} },
{ {0,1,2,0,3,4,1,5, 177,18} },
{ {0,1,2,0,3,4,2,0, 135,45} },
{ {0,1,2,0,3,4,2,1, 141,45} },
{ {0,1,2,0,3,4,2,2, 128,44} },
{ {0,1,2,0,3,4,2,3, 139,26} },
{ {0,1,2,0,3,4,2,4, 144,45} },
{ {0,1,2,0,3,4,2,5, 169,26} },
{ {0,1,2,0,3,4,3,0, 149,46} },
{ {0,1,2,0,3,4,3,1, 156,46} },
{ {0,1,2,0,3,4,3,2, 141,46} },
{ {0,1,2,0,3,4,3,3, 130,4} },
{ {0,1,2,0,3,4,3,4, 138,29} },
{ {0,1,2,0,3,4,3,5, 173,46} },
{ {0,1,2,0,3,4,4,0, 142,22} },
{ {0,1,2,0,3,4,4,1, 165,34} },
{ {0,1,2,0,3,4,4,2, 165,7} },
{ {0,1,2,0,3,4,4,3, 158,10} },
{ {0,1,2,0,3,4,4,4, 133,30} },
{ {0,1,2,0,3,4,4,5, 180,1} },
{ {0,1,2,0,3,4,5,0, 171,23} },
{ {0,1,2,0,3,4,5,1, 178,34} },
{ {0,1,2,0,3,4,5,2, 178,7} },
{ {0,1,2,0,3,4,5,3, 179,1} },
{ {0,1,2,0,3,4,5,4, 173,36} },
{ {0,1,2,0,3,4,5,5, 173,25} },
{ {0,1,2,0,3,4,5,6, 183,1} },
{ {0,1,2,1,0,0,0,0, 8,11} },
{ {0,1,2,1,0,0,0,1, 17,2} },
{ {0,1,2,1,0,0,0,2, 18,28} },
{ {0,1,2,1,0,0,0,3, 63,33} },
{ {0,1,2,1,0,0,1,0, 23,10} },
{ {0,1,2,1,0,0,1,1, 28,2} },
{ {0,1,2,1,0,0,1,2, 31,2} },
{ {0,1,2,1,0,0,1,3, 68,33} },
{ {0,1,2,1,0,0,2,0, 37,2} },
{ {0,1,2,1,0,0,2,1, 41,2} },
{ {0,1,2,1,0,0,2,2, 43,2} },
{ {0,1,2,1,0,0,2,3, 82,33} },
{ {0,1,2,1,0,0,3,0, 72,10} },
{ {0,1,2,1,0,0,3,1, 77,34} },
{ {0,1,2,1,0,0,3,2, 86,2} },
{ {0,1,2,1,0,0,3,3, 82,2} },
{ {0,1,2,1,0,0,3,4, 132,33} },
{ {0,1,2,1,0,1,0,0, 28,8} },
{ {0,1,2,1,0,1,0,1, 10,9} },
{ {0,1,2,1,0,1,0,2, 42,47} },
{ {0,1,2,1,0,1,0,3, 83,12} },
{ {0,1,2,1,0,1,1,0, 27,8} },
{ {0,1,2,1,0,1,1,1, 8,37} },
{ {0,1,2,1,0,1,1,2, 40,35} },
{ {0,1,2,1,0,1,1,3, 81,8} },
{ {0,1,2,1,0,1,2,0, 29,8} },
{ {0,1,2,1,0,1,2,1, 11,9} },
{ {0,1,2,1,0,1,2,2, 41,35} },
{ {0,1,2,1,0,1,2,3, 84,8} },
{ {0,1,2,1,0,1,3,0, 65,8} },
{ {0,1,2,1,0,1,3,1, 59,8} },
{ {0,1,2,1,0,1,3,2, 75,35} },
{ {0,1,2,1,0,1,3,3, 82,8} },
{ {0,1,2,1,0,1,3,4, 129,8} },
{ {0,1,2,1,0,2,0,0, 24,29} },
{ {0,1,2,1,0,2,0,1, 32,12} },
{ {0,1,2,1,0,2,0,2, 29,47} },
{ {0,1,2,1,0,2,0,3, 69,12} },
{ {0,1,2,1,0,2,1,0, 53,12} },
{ {0,1,2,1,0,2,1,1, 24,23} },
{ {0,1,2,1,0,2,1,2, 47,34} },
{ {0,1,2,1,0,2,1,3, 108,32} },
{ {0,1,2,1,0,2,2,0, 47,12} },
{ {0,1,2,1,0,2,2,1, 29,23} },
{ {0,1,2,1,0,2,2,2, 37,5} },
{ {0,1,2,1,0,2,2,3, 93,12} },
{ {0,1,2,1,0,2,3,0, 108,14} },
{ {0,1,2,1,0,2,3,1, 69,34} },
{ {0,1,2,1,0,2,3,2, 93,34} },
{ {0,1,2,1,0,2,3,3, 113,32} },
{ {0,1,2,1,0,2,3,4, 148,32} },
{ {0,1,2,1,0,3,0,0, 73,47} },
{ {0,1,2,1,0,3,0,1, 88,12} },
{ {0,1,2,1,0,3,0,2, 79,47} },
{ {0,1,2,1,0,3,0,3, 84,47} },
{ {0,1,2,1,0,3,0,4, 134,12} },
{ {0,1,2,1,0,3,1,0, 112,15} },
{ {0,1,2,1,0,3,1,1, 73,39} },
{ {0,1,2,1,0,3,1,2, 103,15} },
{ {0,1,2,1,0,3,1,3, 93,37} },
{ {0,1,2,1,0,3,1,4, 149,13} },
{ {0,1,2,1,0,3,2,0, 93,27} },
{ {0,1,2,1,0,3,2,1, 84,23} },
{ {0,1,2,1,0,3,2,2, 82,44} },
{ {0,1,2,1,0,3,2,3, 96,13} },
{ {0,1,2,1,0,3,2,4, 137,13} },
{ {0,1,2,1,0,3,3,0, 103,33} },
{ {0,1,2,1,0,3,3,1, 79,23} },
{ {0,1,2,1,0,3,3,2, 106,34} },
{ {0,1,2,1,0,3,3,3, 82,30} },
{ {0,1,2,1,0,3,3,4, 144,33} },
{ {0,1,2,1,0,3,4,0, 149,35} },
{ {0,1,2,1,0,3,4,1, 134,34} },
{ {0,1,2,1,0,3,4,2, 144,15} },
{ {0,1,2,1,0,3,4,3, 137,35} },
{ {0,1,2,1,0,3,4,4, 154,14} },
{ {0,1,2,1,0,3,4,5, 172,32} },
{ {0,1,2,1,1,0,0,0, 27,30} },
{ {0,1,2,1,1,0,0,1, 38,23} },
{ {0,1,2,1,1,0,0,2, 50,14} },
{ {0,1,2,1,1,0,0,3, 102,14} },
{ {0,1,2,1,1,0,1,0, 45,31} },
{ {0,1,2,1,1,0,1,1, 35,24} },
{ {0,1,2,1,1,0,1,2, 49,14} },
{ {0,1,2,1,1,0,1,3, 101,14} },
{ {0,1,2,1,1,0,2,0, 47,36} },
{ {0,1,2,1,1,0,2,1, 40,34} },
{ {0,1,2,1,1,0,2,2, 31,25} },
{ {0,1,2,1,1,0,2,3, 103,14} },
{ {0,1,2,1,1,0,3,0, 90,35} },
{ {0,1,2,1,1,0,3,1, 76,34} },
{ {0,1,2,1,1,0,3,2, 98,14} },
{ {0,1,2,1,1,0,3,3, 103,35} },
{ {0,1,2,1,1,0,3,4, 140,14} },
{ {0,1,2,1,1,1,0,0, 23,42} },
{ {0,1,2,1,1,1,0,1, 6,9} },
{ {0,1,2,1,1,1,0,2, 36,42} },
{ {0,1,2,1,1,1,0,3, 71,42} },
{ {0,1,2,1,1,1,1,0, 21,3} },
{ {0,1,2,1,1,1,1,1, 3,31} },
{ {0,1,2,1,1,1,1,2, 35,3} },
{ {0,1,2,1,1,1,1,3, 70,3} },
{ {0,1,2,1,1,1,2,0, 24,8} },
{ {0,1,2,1,1,1,2,1, 8,36} },
{ {0,1,2,1,1,1,2,2, 28,25} },
{ {0,1,2,1,1,1,2,3, 73,42} },
{ {0,1,2,1,1,1,3,0, 64,8} },
{ {0,1,2,1,1,1,3,1, 58,9} },
{ {0,1,2,1,1,1,3,2, 71,8} },
{ {0,1,2,1,1,1,3,3, 72,42} },
{ {0,1,2,1,1,1,3,4, 127,42} },
{ {0,1,2,1,1,2,0,0, 53,4} },
{ {0,1,2,1,1,2,0,1, 30,23} },
{ {0,1,2,1,1,2,0,2, 48,34} },
{ {0,1,2,1,1,2,0,3, 111,14} },
{ {0,1,2,1,1,2,1,0, 52,14} },
{ {0,1,2,1,1,2,1,1, 21,24} },
{ {0,1,2,1,1,2,1,2, 45,30} },
{ {0,1,2,1,1,2,1,3, 110,14} },
{ {0,1,2,1,1,2,2,0, 53,35} },
{ {0,1,2,1,1,2,2,1, 27,23} },
{ {0,1,2,1,1,2,2,2, 23,5} },
{ {0,1,2,1,1,2,2,3, 112,14} },
{ {0,1,2,1,1,2,3,0, 107,14} },
{ {0,1,2,1,1,2,3,1, 67,34} },
{ {0,1,2,1,1,2,3,2, 92,34} },
{ {0,1,2,1,1,2,3,3, 108,24} },
{ {0,1,2,1,1,2,3,4, 147,14} },
{ {0,1,2,1,1,3,0,0, 112,25} },
{ {0,1,2,1,1,3,0,1, 85,23} },
{ {0,1,2,1,1,3,0,2, 104,15} },
{ {0,1,2,1,1,3,0,3, 91,36} },
{ {0,1,2,1,1,3,0,4, 153,14} },
{ {0,1,2,1,1,3,1,0, 110,15} },
{ {0,1,2,1,1,3,1,1, 70,24} },
{ {0,1,2,1,1,3,1,2, 101,15} },
{ {0,1,2,1,1,3,1,3, 89,31} },
{ {0,1,2,1,1,3,1,4, 152,14} },
{ {0,1,2,1,1,3,2,0, 108,45} },
{ {0,1,2,1,1,3,2,1, 81,23} },
{ {0,1,2,1,1,3,2,2, 68,44} },
{ {0,1,2,1,1,3,2,3, 93,36} },
{ {0,1,2,1,1,3,2,4, 149,26} },
{ {0,1,2,1,1,3,3,0, 111,35} },
{ {0,1,2,1,1,3,3,1, 76,23} },
{ {0,1,2,1,1,3,3,2, 104,34} },
{ {0,1,2,1,1,3,3,3, 65,30} },
{ {0,1,2,1,1,3,3,4, 153,35} },
{ {0,1,2,1,1,3,4,0, 147,35} },
{ {0,1,2,1,1,3,4,1, 131,34} },
{ {0,1,2,1,1,3,4,2, 142,15} },
{ {0,1,2,1,1,3,4,3, 135,36} },
{ {0,1,2,1,1,3,4,4, 149,5} },
{ {0,1,2,1,1,3,4,5, 171,14} },
{ {0,1,2,1,2,0,0,0, 40,5} },
{ {0,1,2,1,2,0,0,1, 39,23} },
{ {0,1,2,1,2,0,0,2, 51,14} },
{ {0,1,2,1,2,0,0,3, 105,14} },
{ {0,1,2,1,2,0,1,0, 48,37} },
{ {0,1,2,1,2,0,1,1, 36,23} },
{ {0,1,2,1,2,0,1,2, 50,15} },
{ {0,1,2,1,2,0,1,3, 104,14} },
{ {0,1,2,1,2,0,2,0, 29,46} },
{ {0,1,2,1,2,0,2,1, 42,34} },
{ {0,1,2,1,2,0,2,2, 18,29} },
{ {0,1,2,1,2,0,2,3, 79,46} },
{ {0,1,2,1,2,0,3,0, 91,35} },
{ {0,1,2,1,2,0,3,1, 78,34} },
{ {0,1,2,1,2,0,3,2, 99,14} },
{ {0,1,2,1,2,0,3,3, 106,14} },
{ {0,1,2,1,2,0,3,4, 141,14} },
{ {0,1,2,1,2,1,0,0, 31,8} },
{ {0,1,2,1,2,1,0,1, 12,8} },
{ {0,1,2,1,2,1,0,2, 39,8} },
{ {0,1,2,1,2,1,0,3, 87,8} },
{ {0,1,2,1,2,1,1,0, 30,8} },
{ {0,1,2,1,2,1,1,1, 6,22} },
{ {0,1,2,1,2,1,1,2, 38,8} },
{ {0,1,2,1,2,1,1,3, 85,8} },
{ {0,1,2,1,2,1,2,0, 32,8} },
{ {0,1,2,1,2,1,2,1, 10,22} },
{ {0,1,2,1,2,1,2,2, 17,4} },
{ {0,1,2,1,2,1,2,3, 88,27} },
{ {0,1,2,1,2,1,3,0, 66,8} },
{ {0,1,2,1,2,1,3,1, 60,8} },
{ {0,1,2,1,2,1,3,2, 74,8} },
{ {0,1,2,1,2,1,3,3, 86,8} },
{ {0,1,2,1,2,1,3,4, 130,8} },
{ {0,1,2,1,2,2,0,0, 47,4} },
{ {0,1,2,1,2,2,0,1, 31,23} },
{ {0,1,2,1,2,2,0,2, 40,10} },
{ {0,1,2,1,2,2,0,3, 103,2} },
{ {0,1,2,1,2,2,1,0, 53,15} },
{ {0,1,2,1,2,2,1,1, 23,39} },
{ {0,1,2,1,2,2,1,2, 27,31} },
{ {0,1,2,1,2,2,1,3, 112,2} },
{ {0,1,2,1,2,2,2,0, 24,28} },
{ {0,1,2,1,2,2,2,1, 28,23} },
{ {0,1,2,1,2,2,2,2, 8,4} },
{ {0,1,2,1,2,2,2,3, 73,46} },
{ {0,1,2,1,2,2,3,0, 108,35} },
{ {0,1,2,1,2,2,3,1, 68,34} },
{ {0,1,2,1,2,2,3,2, 81,31} },
{ {0,1,2,1,2,2,3,3, 93,4} },
{ {0,1,2,1,2,2,3,4, 149,14} },
{ {0,1,2,1,2,3,0,0, 103,25} },
{ {0,1,2,1,2,3,0,1, 87,23} },
{ {0,1,2,1,2,3,0,2, 105,15} },
{ {0,1,2,1,2,3,0,3, 97,35} },
{ {0,1,2,1,2,3,0,4, 155,14} },
{ {0,1,2,1,2,3,1,0, 111,15} },
{ {0,1,2,1,2,3,1,1, 71,39} },
{ {0,1,2,1,2,3,1,2, 102,15} },
{ {0,1,2,1,2,3,1,3, 91,37} },
{ {0,1,2,1,2,3,1,4, 153,15} },
{ {0,1,2,1,2,3,2,0, 69,27} },
{ {0,1,2,1,2,3,2,1, 83,27} },
{ {0,1,2,1,2,3,2,2, 63,44} },
{ {0,1,2,1,2,3,2,3, 84,46} },
{ {0,1,2,1,2,3,2,4, 134,27} },
{ {0,1,2,1,2,3,3,0, 114,15} },
{ {0,1,2,1,2,3,3,1, 78,23} },
{ {0,1,2,1,2,3,3,2, 105,34} },
{ {0,1,2,1,2,3,3,3, 75,5} },
{ {0,1,2,1,2,3,3,4, 156,14} },
{ {0,1,2,1,2,3,4,0, 150,35} },
{ {0,1,2,1,2,3,4,1, 133,34} },
{ {0,1,2,1,2,3,4,2, 143,15} },
{ {0,1,2,1,2,3,4,3, 138,35} },
{ {0,1,2,1,2,3,4,4, 144,25} },
{ {0,1,2,1,2,3,4,5, 173,14} },
{ {0,1,2,1,3,0,0,0, 81,30} },
{ {0,1,2,1,3,0,0,1, 74,23} },
{ {0,1,2,1,3,0,0,2, 99,15} },
{ {0,1,2,1,3,0,0,3, 105,35} },
{ {0,1,2,1,3,0,0,4, 143,14} },
{ {0,1,2,1,3,0,1,0, 92,35} },
{ {0,1,2,1,3,0,1,1, 71,23} },
{ {0,1,2,1,3,0,1,2, 98,15} },
{ {0,1,2,1,3,0,1,3, 104,35} },
{ {0,1,2,1,3,0,1,4, 142,14} },
{ {0,1,2,1,3,0,2,0, 93,35} },
{ {0,1,2,1,3,0,2,1, 75,34} },
{ {0,1,2,1,3,0,2,2, 86,25} },
{ {0,1,2,1,3,0,2,3, 106,35} },
{ {0,1,2,1,3,0,2,4, 144,14} },
{ {0,1,2,1,3,0,3,0, 94,35} },
{ {0,1,2,1,3,0,3,1, 79,34} },
{ {0,1,2,1,3,0,3,2, 100,14} },
{ {0,1,2,1,3,0,3,3, 79,29} },
{ {0,1,2,1,3,0,3,4, 145,14} },
{ {0,1,2,1,3,0,4,0, 135,35} },
{ {0,1,2,1,3,0,4,1, 128,34} },
{ {0,1,2,1,3,0,4,2, 139,14} },
{ {0,1,2,1,3,0,4,3, 141,35} },
{ {0,1,2,1,3,0,4,4, 144,35} },
{ {0,1,2,1,3,0,4,5, 169,14} },
{ {0,1,2,1,3,1,0,0, 68,35} },
{ {0,1,2,1,3,1,0,1, 60,23} },
{ {0,1,2,1,3,1,0,2, 78,35} },
{ {0,1,2,1,3,1,0,3, 78,8} },
{ {0,1,2,1,3,1,0,4, 133,35} },
{ {0,1,2,1,3,1,1,0, 67,35} },
{ {0,1,2,1,3,1,1,1, 58,22} },
{ {0,1,2,1,3,1,1,2, 76,35} },
{ {0,1,2,1,3,1,1,3, 76,8} },
{ {0,1,2,1,3,1,1,4, 131,35} },
{ {0,1,2,1,3,1,2,0, 69,35} },
{ {0,1,2,1,3,1,2,1, 59,23} },
{ {0,1,2,1,3,1,2,2, 77,35} },
{ {0,1,2,1,3,1,2,3, 79,8} },
{ {0,1,2,1,3,1,2,4, 134,35} },
{ {0,1,2,1,3,1,3,0, 69,8} },
{ {0,1,2,1,3,1,3,1, 59,36} },
{ {0,1,2,1,3,1,3,2, 79,35} },
{ {0,1,2,1,3,1,3,3, 77,8} },
{ {0,1,2,1,3,1,3,4, 134,8} },
{ {0,1,2,1,3,1,4,0, 126,35} },
{ {0,1,2,1,3,1,4,1, 124,35} },
{ {0,1,2,1,3,1,4,2, 128,35} },
{ {0,1,2,1,3,1,4,3, 128,8} },
{ {0,1,2,1,3,1,4,4, 132,35} },
{ {0,1,2,1,3,1,4,5, 167,35} },
{ {0,1,2,1,3,2,0,0, 108,34} },
{ {0,1,2,1,3,2,0,1, 66,23} },
{ {0,1,2,1,3,2,0,2, 91,34} },
{ {0,1,2,1,3,2,0,3, 114,14} },
{ {0,1,2,1,3,2,0,4, 150,34} },
{ {0,1,2,1,3,2,1,0, 107,34} },
{ {0,1,2,1,3,2,1,1, 64,23} },
{ {0,1,2,1,3,2,1,2, 90,34} },
{ {0,1,2,1,3,2,1,3, 111,34} },
{ {0,1,2,1,3,2,1,4, 147,34} },
{ {0,1,2,1,3,2,2,0, 108,15} },
{ {0,1,2,1,3,2,2,1, 65,23} },
{ {0,1,2,1,3,2,2,2, 72,5} },
{ {0,1,2,1,3,2,2,3, 103,44} },
{ {0,1,2,1,3,2,2,4, 149,34} },
{ {0,1,2,1,3,2,3,0, 109,14} },
{ {0,1,2,1,3,2,3,1, 69,23} },
{ {0,1,2,1,3,2,3,2, 94,34} },
{ {0,1,2,1,3,2,3,3, 69,4} },
{ {0,1,2,1,3,2,3,4, 151,14} },
{ {0,1,2,1,3,2,4,0, 146,14} },
{ {0,1,2,1,3,2,4,1, 126,34} },
{ {0,1,2,1,3,2,4,2, 135,34} },
{ {0,1,2,1,3,2,4,3, 150,14} },
{ {0,1,2,1,3,2,4,4, 148,34} },
{ {0,1,2,1,3,2,4,5, 170,14} },
{ {0,1,2,1,3,3,0,0, 93,11} },
{ {0,1,2,1,3,3,0,1, 86,23} },
{ {0,1,2,1,3,3,0,2, 106,15} },
{ {0,1,2,1,3,3,0,3, 75,10} },
{ {0,1,2,1,3,3,0,4, 144,2} },
{ {0,1,2,1,3,3,1,0, 108,3} },
{ {0,1,2,1,3,3,1,1, 72,39} },
{ {0,1,2,1,3,3,1,2, 103,34} },
{ {0,1,2,1,3,3,1,3, 65,31} },
{ {0,1,2,1,3,3,1,4, 149,10} },
{ {0,1,2,1,3,3,2,0, 113,15} },
{ {0,1,2,1,3,3,2,1, 82,23} },
{ {0,1,2,1,3,3,2,2, 82,25} },
{ {0,1,2,1,3,3,2,3, 82,31} },
{ {0,1,2,1,3,3,2,4, 154,15} },
{ {0,1,2,1,3,3,3,0, 69,11} },
{ {0,1,2,1,3,3,3,1, 77,23} },
{ {0,1,2,1,3,3,3,2, 79,28} },
{ {0,1,2,1,3,3,3,3, 59,31} },
{ {0,1,2,1,3,3,3,4, 134,11} },
{ {0,1,2,1,3,3,4,0, 148,35} },
{ {0,1,2,1,3,3,4,1, 132,34} },
{ {0,1,2,1,3,3,4,2, 144,34} },
{ {0,1,2,1,3,3,4,3, 129,31} },
{ {0,1,2,1,3,3,4,4, 137,10} },
{ {0,1,2,1,3,3,4,5, 172,35} },
{ {0,1,2,1,3,4,0,0, 149,15} },
{ {0,1,2,1,3,4,0,1, 130,23} },
{ {0,1,2,1,3,4,0,2, 141,15} },
{ {0,1,2,1,3,4,0,3, 156,15} },
{ {0,1,2,1,3,4,0,4, 138,34} },
{ {0,1,2,1,3,4,0,5, 173,15} },
{ {0,1,2,1,3,4,1,0, 147,15} },
{ {0,1,2,1,3,4,1,1, 127,39} },
{ {0,1,2,1,3,4,1,2, 140,15} },
{ {0,1,2,1,3,4,1,3, 153,34} },
{ {0,1,2,1,3,4,1,4, 135,37} },
{ {0,1,2,1,3,4,1,5, 171,15} },
{ {0,1,2,1,3,4,2,0, 148,45} },
{ {0,1,2,1,3,4,2,1, 129,23} },
{ {0,1,2,1,3,4,2,2, 132,44} },
{ {0,1,2,1,3,4,2,3, 144,44} },
{ {0,1,2,1,3,4,2,4, 137,34} },
{ {0,1,2,1,3,4,2,5, 172,15} },
{ {0,1,2,1,3,4,3,0, 151,15} },
{ {0,1,2,1,3,4,3,1, 134,23} },
{ {0,1,2,1,3,4,3,2, 145,15} },
{ {0,1,2,1,3,4,3,3, 134,4} },
{ {0,1,2,1,3,4,3,4, 136,36} },
{ {0,1,2,1,3,4,3,5, 174,14} },
{ {0,1,2,1,3,4,4,0, 150,15} },
{ {0,1,2,1,3,4,4,1, 128,23} },
{ {0,1,2,1,3,4,4,2, 141,34} },
{ {0,1,2,1,3,4,4,3, 155,34} },
{ {0,1,2,1,3,4,4,4, 129,30} },
{ {0,1,2,1,3,4,4,5, 173,34} },
{ {0,1,2,1,3,4,5,0, 170,15} },
{ {0,1,2,1,3,4,5,1, 167,34} },
{ {0,1,2,1,3,4,5,2, 169,15} },
{ {0,1,2,1,3,4,5,3, 173,35} },
{ {0,1,2,1,3,4,5,4, 168,35} },
{ {0,1,2,1,3,4,5,5, 172,34} },
{ {0,1,2,1,3,4,5,6, 182,14} },
{ {0,1,2,2,0,0,0,0, 8,28} },
{ {0,1,2,2,0,0,0,1, 18,2} },
{ {0,1,2,2,0,0,0,2, 17,28} },
{ {0,1,2,2,0,0,0,3, 63,12} },
{ {0,1,2,2,0,0,1,0, 24,2} },
{ {0,1,2,2,0,0,1,1, 29,2} },
{ {0,1,2,2,0,0,1,2, 32,2} },
{ {0,1,2,2,0,0,1,3, 69,33} },
{ {0,1,2,2,0,0,2,0, 28,45} },
{ {0,1,2,2,0,0,2,1, 42,2} },
{ {0,1,2,2,0,0,2,2, 10,25} },
{ {0,1,2,2,0,0,2,3, 83,33} },
{ {0,1,2,2,0,0,3,0, 73,2} },
{ {0,1,2,2,0,0,3,1, 79,2} },
{ {0,1,2,2,0,0,3,2, 88,2} },
{ {0,1,2,2,0,0,3,3, 84,2} },
{ {0,1,2,2,0,0,3,4, 134,33} },
{ {0,1,2,2,0,1,0,0, 37,29} },
{ {0,1,2,2,0,1,0,1, 43,12} },
{ {0,1,2,2,0,1,0,2, 41,47} },
{ {0,1,2,2,0,1,0,3, 82,12} },
{ {0,1,2,2,0,1,1,0, 47,33} },
{ {0,1,2,2,0,1,1,1, 37,30} },
{ {0,1,2,2,0,1,1,2, 29,38} },
{ {0,1,2,2,0,1,1,3, 93,33} },
{ {0,1,2,2,0,1,2,0, 29,45} },
{ {0,1,2,2,0,1,2,1, 41,36} },
{ {0,1,2,2,0,1,2,2, 11,44} },
{ {0,1,2,2,0,1,2,3, 84,45} },
{ {0,1,2,2,0,1,3,0, 93,42} },
{ {0,1,2,2,0,1,3,1, 82,9} },
{ {0,1,2,2,0,1,3,2, 84,38} },
{ {0,1,2,2,0,1,3,3, 96,32} },
{ {0,1,2,2,0,1,3,4, 137,32} },
{ {0,1,2,2,0,2,0,0, 23,29} },
{ {0,1,2,2,0,2,0,1, 31,12} },
{ {0,1,2,2,0,2,0,2, 28,47} },
{ {0,1,2,2,0,2,0,3, 68,12} },
{ {0,1,2,2,0,2,1,0, 53,33} },
{ {0,1,2,2,0,2,1,1, 47,24} },
{ {0,1,2,2,0,2,1,2, 24,22} },
{ {0,1,2,2,0,2,1,3, 108,13} },
{ {0,1,2,2,0,2,2,0, 27,45} },
{ {0,1,2,2,0,2,2,1, 40,6} },
{ {0,1,2,2,0,2,2,2, 8,24} },
{ {0,1,2,2,0,2,2,3, 81,45} },
{ {0,1,2,2,0,2,3,0, 112,16} },
{ {0,1,2,2,0,2,3,1, 103,16} },
{ {0,1,2,2,0,2,3,2, 73,22} },
{ {0,1,2,2,0,2,3,3, 93,24} },
{ {0,1,2,2,0,2,3,4, 149,32} },
{ {0,1,2,2,0,3,0,0, 72,29} },
{ {0,1,2,2,0,3,0,1, 86,12} },
{ {0,1,2,2,0,3,0,2, 77,7} },
{ {0,1,2,2,0,3,0,3, 82,47} },
{ {0,1,2,2,0,3,0,4, 132,12} },
{ {0,1,2,2,0,3,1,0, 108,17} },
{ {0,1,2,2,0,3,1,1, 93,7} },
{ {0,1,2,2,0,3,1,2, 69,7} },
{ {0,1,2,2,0,3,1,3, 113,13} },
{ {0,1,2,2,0,3,1,4, 148,13} },
{ {0,1,2,2,0,3,2,0, 65,45} },
{ {0,1,2,2,0,3,2,1, 75,6} },
{ {0,1,2,2,0,3,2,2, 59,45} },
{ {0,1,2,2,0,3,2,3, 82,45} },
{ {0,1,2,2,0,3,2,4, 129,45} },
{ {0,1,2,2,0,3,3,0, 103,12} },
{ {0,1,2,2,0,3,3,1, 106,7} },
{ {0,1,2,2,0,3,3,2, 79,38} },
{ {0,1,2,2,0,3,3,3, 82,5} },
{ {0,1,2,2,0,3,3,4, 144,12} },
{ {0,1,2,2,0,3,4,0, 149,6} },
{ {0,1,2,2,0,3,4,1, 144,16} },
{ {0,1,2,2,0,3,4,2, 134,7} },
{ {0,1,2,2,0,3,4,3, 154,17} },
{ {0,1,2,2,0,3,4,4, 137,6} },
{ {0,1,2,2,0,3,4,5, 172,13} },
{ {0,1,2,2,1,0,0,0, 40,30} },
{ {0,1,2,2,1,0,0,1, 51,6} },
{ {0,1,2,2,1,0,0,2, 39,7} },
{ {0,1,2,2,1,0,0,3, 105,17} },
{ {0,1,2,2,1,0,1,0, 47,31} },
{ {0,1,2,2,1,0,1,1, 40,29} },
{ {0,1,2,2,1,0,1,2, 31,7} },
{ {0,1,2,2,1,0,1,3, 103,47} },
{ {0,1,2,2,1,0,2,0, 31,6} },
{ {0,1,2,2,1,0,2,1, 39,6} },
{ {0,1,2,2,1,0,2,2, 12,6} },
{ {0,1,2,2,1,0,2,3, 87,6} },
{ {0,1,2,2,1,0,3,0, 103,36} },
{ {0,1,2,2,1,0,3,1, 105,16} },
{ {0,1,2,2,1,0,3,2, 87,7} },
{ {0,1,2,2,1,0,3,3, 97,6} },
{ {0,1,2,2,1,0,3,4, 155,17} },
{ {0,1,2,2,1,1,0,0, 29,3} },
{ {0,1,2,2,1,1,0,1, 18,3} },
{ {0,1,2,2,1,1,0,2, 42,3} },
{ {0,1,2,2,1,1,0,3, 79,3} },
{ {0,1,2,2,1,1,1,0, 24,3} },
{ {0,1,2,2,1,1,1,1, 8,31} },
{ {0,1,2,2,1,1,1,2, 28,38} },
{ {0,1,2,2,1,1,1,3, 73,3} },
{ {0,1,2,2,1,1,2,0, 32,3} },
{ {0,1,2,2,1,1,2,1, 17,31} },
{ {0,1,2,2,1,1,2,2, 10,24} },
{ {0,1,2,2,1,1,2,3, 88,3} },
{ {0,1,2,2,1,1,3,0, 69,42} },
{ {0,1,2,2,1,1,3,1, 63,9} },
{ {0,1,2,2,1,1,3,2, 83,42} },
{ {0,1,2,2,1,1,3,3, 84,3} },
{ {0,1,2,2,1,1,3,4, 134,42} },
{ {0,1,2,2,1,2,0,0, 48,24} },
{ {0,1,2,2,1,2,0,1, 50,7} },
{ {0,1,2,2,1,2,0,2, 36,38} },
{ {0,1,2,2,1,2,0,3, 104,17} },
{ {0,1,2,2,1,2,1,0, 53,28} },
{ {0,1,2,2,1,2,1,1, 27,4} },
{ {0,1,2,2,1,2,1,2, 23,22} },
{ {0,1,2,2,1,2,1,3, 112,47} },
{ {0,1,2,2,1,2,2,0, 30,6} },
{ {0,1,2,2,1,2,2,1, 38,6} },
{ {0,1,2,2,1,2,2,2, 6,24} },
{ {0,1,2,2,1,2,2,3, 85,6} },
{ {0,1,2,2,1,2,3,0, 111,16} },
{ {0,1,2,2,1,2,3,1, 102,16} },
{ {0,1,2,2,1,2,3,2, 71,22} },
{ {0,1,2,2,1,2,3,3, 91,24} },
{ {0,1,2,2,1,2,3,4, 153,16} },
{ {0,1,2,2,1,3,0,0, 91,6} },
{ {0,1,2,2,1,3,0,1, 99,6} },
{ {0,1,2,2,1,3,0,2, 78,7} },
{ {0,1,2,2,1,3,0,3, 106,17} },
{ {0,1,2,2,1,3,0,4, 141,17} },
{ {0,1,2,2,1,3,1,0, 108,6} },
{ {0,1,2,2,1,3,1,1, 81,4} },
{ {0,1,2,2,1,3,1,2, 68,7} },
{ {0,1,2,2,1,3,1,3, 93,31} },
{ {0,1,2,2,1,3,1,4, 149,17} },
{ {0,1,2,2,1,3,2,0, 66,6} },
{ {0,1,2,2,1,3,2,1, 74,6} },
{ {0,1,2,2,1,3,2,2, 60,6} },
{ {0,1,2,2,1,3,2,3, 86,6} },
{ {0,1,2,2,1,3,2,4, 130,6} },
{ {0,1,2,2,1,3,3,0, 114,16} },
{ {0,1,2,2,1,3,3,1, 105,7} },
{ {0,1,2,2,1,3,3,2, 78,38} },
{ {0,1,2,2,1,3,3,3, 75,30} },
{ {0,1,2,2,1,3,3,4, 156,17} },
{ {0,1,2,2,1,3,4,0, 150,6} },
{ {0,1,2,2,1,3,4,1, 143,16} },
{ {0,1,2,2,1,3,4,2, 133,7} },
{ {0,1,2,2,1,3,4,3, 144,36} },
{ {0,1,2,2,1,3,4,4, 138,6} },
{ {0,1,2,2,1,3,4,5, 173,17} },
{ {0,1,2,2,2,0,0,0, 27,5} },
{ {0,1,2,2,2,0,0,1, 50,6} },
{ {0,1,2,2,2,0,0,2, 38,7} },
{ {0,1,2,2,2,0,0,3, 102,17} },
{ {0,1,2,2,2,0,1,0, 53,31} },
{ {0,1,2,2,2,0,1,1, 48,25} },
{ {0,1,2,2,2,0,1,2, 30,7} },
{ {0,1,2,2,2,0,1,3, 111,17} },
{ {0,1,2,2,2,0,2,0, 23,27} },
{ {0,1,2,2,2,0,2,1, 36,27} },
{ {0,1,2,2,2,0,2,2, 6,25} },
{ {0,1,2,2,2,0,2,3, 71,27} },
{ {0,1,2,2,2,0,3,0, 112,36} },
{ {0,1,2,2,2,0,3,1, 104,16} },
{ {0,1,2,2,2,0,3,2, 85,7} },
{ {0,1,2,2,2,0,3,3, 91,25} },
{ {0,1,2,2,2,0,3,4, 153,17} },
{ {0,1,2,2,2,1,0,0, 47,25} },
{ {0,1,2,2,2,1,0,1, 31,9} },
{ {0,1,2,2,2,1,0,2, 40,7} },
{ {0,1,2,2,2,1,0,3, 103,17} },
{ {0,1,2,2,2,1,1,0, 53,42} },
{ {0,1,2,2,2,1,1,1, 23,30} },
{ {0,1,2,2,2,1,1,2, 27,38} },
{ {0,1,2,2,2,1,1,3, 112,17} },
{ {0,1,2,2,2,1,2,0, 24,27} },
{ {0,1,2,2,2,1,2,1, 28,36} },
{ {0,1,2,2,2,1,2,2, 8,25} },
{ {0,1,2,2,2,1,2,3, 73,27} },
{ {0,1,2,2,2,1,3,0, 108,8} },
{ {0,1,2,2,2,1,3,1, 68,9} },
{ {0,1,2,2,2,1,3,2, 81,38} },
{ {0,1,2,2,2,1,3,3, 93,25} },
{ {0,1,2,2,2,1,3,4, 149,43} },
{ {0,1,2,2,2,2,0,0, 45,4} },
{ {0,1,2,2,2,2,0,1, 49,6} },
{ {0,1,2,2,2,2,0,2, 35,22} },
{ {0,1,2,2,2,2,0,3, 101,2} },
{ {0,1,2,2,2,2,1,0, 52,7} },
{ {0,1,2,2,2,2,1,1, 45,5} },
{ {0,1,2,2,2,2,1,2, 21,22} },
{ {0,1,2,2,2,2,1,3, 110,2} },
{ {0,1,2,2,2,2,2,0, 21,27} },
{ {0,1,2,2,2,2,2,1, 35,27} },
{ {0,1,2,2,2,2,2,2, 3,4} },
{ {0,1,2,2,2,2,2,3, 70,27} },
{ {0,1,2,2,2,2,3,0, 110,3} },
{ {0,1,2,2,2,2,3,1, 101,3} },
{ {0,1,2,2,2,2,3,2, 70,22} },
{ {0,1,2,2,2,2,3,3, 89,4} },
{ {0,1,2,2,2,2,3,4, 152,2} },
{ {0,1,2,2,2,3,0,0, 90,6} },
{ {0,1,2,2,2,3,0,1, 98,6} },
{ {0,1,2,2,2,3,0,2, 76,7} },
{ {0,1,2,2,2,3,0,3, 103,6} },
{ {0,1,2,2,2,3,0,4, 140,17} },
{ {0,1,2,2,2,3,1,0, 107,17} },
{ {0,1,2,2,2,3,1,1, 92,7} },
{ {0,1,2,2,2,3,1,2, 67,7} },
{ {0,1,2,2,2,3,1,3, 108,37} },
{ {0,1,2,2,2,3,1,4, 147,17} },
{ {0,1,2,2,2,3,2,0, 64,45} },
{ {0,1,2,2,2,3,2,1, 71,45} },
{ {0,1,2,2,2,3,2,2, 58,44} },
{ {0,1,2,2,2,3,2,3, 72,27} },
{ {0,1,2,2,2,3,2,4, 127,27} },
{ {0,1,2,2,2,3,3,0, 111,6} },
{ {0,1,2,2,2,3,3,1, 104,7} },
{ {0,1,2,2,2,3,3,2, 76,38} },
{ {0,1,2,2,2,3,3,3, 65,5} },
{ {0,1,2,2,2,3,3,4, 153,6} },
{ {0,1,2,2,2,3,4,0, 147,6} },
{ {0,1,2,2,2,3,4,1, 142,16} },
{ {0,1,2,2,2,3,4,2, 131,7} },
{ {0,1,2,2,2,3,4,3, 149,30} },
{ {0,1,2,2,2,3,4,4, 135,25} },
{ {0,1,2,2,2,3,4,5, 171,17} },
{ {0,1,2,2,3,0,0,0, 81,5} },
{ {0,1,2,2,3,0,0,1, 99,7} },
{ {0,1,2,2,3,0,0,2, 74,7} },
{ {0,1,2,2,3,0,0,3, 105,6} },
{ {0,1,2,2,3,0,0,4, 143,17} },
{ {0,1,2,2,3,0,1,0, 108,7} },
{ {0,1,2,2,3,0,1,1, 91,7} },
{ {0,1,2,2,3,0,1,2, 66,7} },
{ {0,1,2,2,3,0,1,3, 114,17} },
{ {0,1,2,2,3,0,1,4, 150,7} },
{ {0,1,2,2,3,0,2,0, 68,6} },
{ {0,1,2,2,3,0,2,1, 78,6} },
{ {0,1,2,2,3,0,2,2, 60,7} },
{ {0,1,2,2,3,0,2,3, 78,45} },
{ {0,1,2,2,3,0,2,4, 133,6} },
{ {0,1,2,2,3,0,3,0, 93,28} },
{ {0,1,2,2,3,0,3,1, 106,16} },
{ {0,1,2,2,3,0,3,2, 86,7} },
{ {0,1,2,2,3,0,3,3, 75,29} },
{ {0,1,2,2,3,0,3,4, 144,47} },
{ {0,1,2,2,3,0,4,0, 149,16} },
{ {0,1,2,2,3,0,4,1, 141,16} },
{ {0,1,2,2,3,0,4,2, 130,7} },
{ {0,1,2,2,3,0,4,3, 156,16} },
{ {0,1,2,2,3,0,4,4, 138,7} },
{ {0,1,2,2,3,0,4,5, 173,16} },
{ {0,1,2,2,3,1,0,0, 93,6} },
{ {0,1,2,2,3,1,0,1, 86,9} },
{ {0,1,2,2,3,1,0,2, 75,7} },
{ {0,1,2,2,3,1,0,3, 106,6} },
{ {0,1,2,2,3,1,0,4, 144,17} },
{ {0,1,2,2,3,1,1,0, 108,16} },
{ {0,1,2,2,3,1,1,1, 72,30} },
{ {0,1,2,2,3,1,1,2, 65,38} },
{ {0,1,2,2,3,1,1,3, 103,9} },
{ {0,1,2,2,3,1,1,4, 149,7} },
{ {0,1,2,2,3,1,2,0, 69,6} },
{ {0,1,2,2,3,1,2,1, 77,6} },
{ {0,1,2,2,3,1,2,2, 59,38} },
{ {0,1,2,2,3,1,2,3, 79,45} },
{ {0,1,2,2,3,1,2,4, 134,6} },
{ {0,1,2,2,3,1,3,0, 113,8} },
{ {0,1,2,2,3,1,3,1, 82,36} },
{ {0,1,2,2,3,1,3,2, 82,38} },
{ {0,1,2,2,3,1,3,3, 82,4} },
{ {0,1,2,2,3,1,3,4, 154,16} },
{ {0,1,2,2,3,1,4,0, 148,8} },
{ {0,1,2,2,3,1,4,1, 132,9} },
{ {0,1,2,2,3,1,4,2, 129,38} },
{ {0,1,2,2,3,1,4,3, 144,9} },
{ {0,1,2,2,3,1,4,4, 137,7} },
{ {0,1,2,2,3,1,4,5, 172,8} },
{ {0,1,2,2,3,2,0,0, 92,6} },
{ {0,1,2,2,3,2,0,1, 98,7} },
{ {0,1,2,2,3,2,0,2, 71,38} },
{ {0,1,2,2,3,2,0,3, 104,6} },
{ {0,1,2,2,3,2,0,4, 142,17} },
{ {0,1,2,2,3,2,1,0, 107,7} },
{ {0,1,2,2,3,2,1,1, 90,7} },
{ {0,1,2,2,3,2,1,2, 64,38} },
{ {0,1,2,2,3,2,1,3, 111,7} },
{ {0,1,2,2,3,2,1,4, 147,7} },
{ {0,1,2,2,3,2,2,0, 67,6} },
{ {0,1,2,2,3,2,2,1, 76,6} },
{ {0,1,2,2,3,2,2,2, 58,39} },
{ {0,1,2,2,3,2,2,3, 76,45} },
{ {0,1,2,2,3,2,2,4, 131,6} },
{ {0,1,2,2,3,2,3,0, 108,46} },
{ {0,1,2,2,3,2,3,1, 103,7} },
{ {0,1,2,2,3,2,3,2, 72,22} },
{ {0,1,2,2,3,2,3,3, 65,4} },
{ {0,1,2,2,3,2,3,4, 149,29} },
{ {0,1,2,2,3,2,4,0, 147,16} },
{ {0,1,2,2,3,2,4,1, 140,16} },
{ {0,1,2,2,3,2,4,2, 127,22} },
{ {0,1,2,2,3,2,4,3, 153,7} },
{ {0,1,2,2,3,2,4,4, 135,24} },
{ {0,1,2,2,3,2,4,5, 171,16} },
{ {0,1,2,2,3,3,0,0, 94,6} },
{ {0,1,2,2,3,3,0,1, 100,6} },
{ {0,1,2,2,3,3,0,2, 79,7} },
{ {0,1,2,2,3,3,0,3, 79,10} },
{ {0,1,2,2,3,3,0,4, 145,17} },
{ {0,1,2,2,3,3,1,0, 109,7} },
{ {0,1,2,2,3,3,1,1, 94,7} },
{ {0,1,2,2,3,3,1,2, 69,38} },
{ {0,1,2,2,3,3,1,3, 69,31} },
{ {0,1,2,2,3,3,1,4, 151,17} },
{ {0,1,2,2,3,3,2,0, 69,45} },
{ {0,1,2,2,3,3,2,1, 79,6} },
{ {0,1,2,2,3,3,2,2, 59,25} },
{ {0,1,2,2,3,3,2,3, 77,45} },
{ {0,1,2,2,3,3,2,4, 134,45} },
{ {0,1,2,2,3,3,3,0, 69,28} },
{ {0,1,2,2,3,3,3,1, 79,11} },
{ {0,1,2,2,3,3,3,2, 77,38} },
{ {0,1,2,2,3,3,3,3, 59,4} },
{ {0,1,2,2,3,3,3,4, 134,28} },
{ {0,1,2,2,3,3,4,0, 151,16} },
{ {0,1,2,2,3,3,4,1, 145,16} },
{ {0,1,2,2,3,3,4,2, 134,38} },
{ {0,1,2,2,3,3,4,3, 134,31} },
{ {0,1,2,2,3,3,4,4, 136,25} },
{ {0,1,2,2,3,3,4,5, 174,17} },
{ {0,1,2,2,3,4,0,0, 135,6} },
{ {0,1,2,2,3,4,0,1, 139,6} },
{ {0,1,2,2,3,4,0,2, 128,7} },
{ {0,1,2,2,3,4,0,3, 141,6} },
{ {0,1,2,2,3,4,0,4, 144,6} },
{ {0,1,2,2,3,4,0,5, 169,17} },
{ {0,1,2,2,3,4,1,0, 146,17} },
{ {0,1,2,2,3,4,1,1, 135,7} },
{ {0,1,2,2,3,4,1,2, 126,7} },
{ {0,1,2,2,3,4,1,3, 150,17} },
{ {0,1,2,2,3,4,1,4, 148,7} },
{ {0,1,2,2,3,4,1,5, 170,17} },
{ {0,1,2,2,3,4,2,0, 126,6} },
{ {0,1,2,2,3,4,2,1, 128,6} },
{ {0,1,2,2,3,4,2,2, 124,6} },
{ {0,1,2,2,3,4,2,3, 128,45} },
{ {0,1,2,2,3,4,2,4, 132,6} },
{ {0,1,2,2,3,4,2,5, 167,6} },
{ {0,1,2,2,3,4,3,0, 148,6} },
{ {0,1,2,2,3,4,3,1, 144,7} },
{ {0,1,2,2,3,4,3,2, 132,7} },
{ {0,1,2,2,3,4,3,3, 129,4} },
{ {0,1,2,2,3,4,3,4, 137,29} },
{ {0,1,2,2,3,4,3,5, 172,6} },
{ {0,1,2,2,3,4,4,0, 150,16} },
{ {0,1,2,2,3,4,4,1, 141,7} },
{ {0,1,2,2,3,4,4,2, 128,38} },
{ {0,1,2,2,3,4,4,3, 155,7} },
{ {0,1,2,2,3,4,4,4, 129,5} },
{ {0,1,2,2,3,4,4,5, 173,7} },
{ {0,1,2,2,3,4,5,0, 170,16} },
{ {0,1,2,2,3,4,5,1, 169,16} },
{ {0,1,2,2,3,4,5,2, 167,7} },
{ {0,1,2,2,3,4,5,3, 173,6} },
{ {0,1,2,2,3,4,5,4, 172,7} },
{ {0,1,2,2,3,4,5,5, 168,6} },
{ {0,1,2,2,3,4,5,6, 182,17} },
{ {0,1,2,3,0,0,0,0, 58,11} },
{ {0,1,2,3,0,0,0,1, 61,2} },
{ {0,1,2,3,0,0,0,2, 61,28} },
{ {0,1,2,3,0,0,0,3, 63,11} },
{ {0,1,2,3,0,0,0,4, 125,33} },
{ {0,1,2,3,0,0,1,0, 64,2} },
{ {0,1,2,3,0,0,1,1, 65,2} },
{ {0,1,2,3,0,0,1,2, 66,2} },
{ {0,1,2,3,0,0,1,3, 69,2} },
{ {0,1,2,3,0,0,1,4, 126,33} },
{ {0,1,2,3,0,0,2,0, 72,2} },
{ {0,1,2,3,0,0,2,1, 75,2} },
{ {0,1,2,3,0,0,2,2, 80,2} },
{ {0,1,2,3,0,0,2,3, 84,33} },
{ {0,1,2,3,0,0,2,4, 129,33} },
{ {0,1,2,3,0,0,3,0, 71,10} },
{ {0,1,2,3,0,0,3,1, 78,2} },
{ {0,1,2,3,0,0,3,2, 87,2} },
{ {0,1,2,3,0,0,3,3, 83,2} },
{ {0,1,2,3,0,0,3,4, 133,33} },
{ {0,1,2,3,0,0,4,0, 127,2} },
{ {0,1,2,3,0,0,4,1, 128,2} },
{ {0,1,2,3,0,0,4,2, 130,2} },
{ {0,1,2,3,0,0,4,3, 134,2} },
{ {0,1,2,3,0,0,4,4, 129,2} },
{ {0,1,2,3,0,0,4,5, 167,33} },
{ {0,1,2,3,0,1,0,0, 72,47} },
{ {0,1,2,3,0,1,0,1, 80,12} },
{ {0,1,2,3,0,1,0,2, 75,47} },
{ {0,1,2,3,0,1,0,3, 84,12} },
{ {0,1,2,3,0,1,0,4, 129,12} },
{ {0,1,2,3,0,1,1,0, 90,33} },
{ {0,1,2,3,0,1,1,1, 72,36} },
{ {0,1,2,3,0,1,1,2, 91,33} },
{ {0,1,2,3,0,1,1,3, 94,33} },
{ {0,1,2,3,0,1,1,4, 135,33} },
{ {0,1,2,3,0,1,2,0, 94,42} },
{ {0,1,2,3,0,1,2,1, 84,9} },
{ {0,1,2,3,0,1,2,2, 84,44} },
{ {0,1,2,3,0,1,2,3, 95,33} },
{ {0,1,2,3,0,1,2,4, 136,32} },
{ {0,1,2,3,0,1,3,0, 91,42} },
{ {0,1,2,3,0,1,3,1, 75,36} },
{ {0,1,2,3,0,1,3,2, 97,32} },
{ {0,1,2,3,0,1,3,3, 84,39} },
{ {0,1,2,3,0,1,3,4, 138,32} },
{ {0,1,2,3,0,1,4,0, 135,42} },
{ {0,1,2,3,0,1,4,1, 129,9} },
{ {0,1,2,3,0,1,4,2, 138,43} },
{ {0,1,2,3,0,1,4,3, 136,43} },
{ {0,1,2,3,0,1,4,4, 137,33} },
{ {0,1,2,3,0,1,4,5, 168,32} },
{ {0,1,2,3,0,2,0,0, 64,47} },
{ {0,1,2,3,0,2,0,1, 66,12} },
{ {0,1,2,3,0,2,0,2, 65,47} },
{ {0,1,2,3,0,2,0,3, 69,47} },
{ {0,1,2,3,0,2,0,4, 126,12} },
{ {0,1,2,3,0,2,1,0, 107,12} },
{ {0,1,2,3,0,2,1,1, 108,12} },
{ {0,1,2,3,0,2,1,2, 108,33} },
{ {0,1,2,3,0,2,1,3, 109,12} },
{ {0,1,2,3,0,2,1,4, 146,32} },
{ {0,1,2,3,0,2,2,0, 90,12} },
{ {0,1,2,3,0,2,2,1, 91,12} },
{ {0,1,2,3,0,2,2,2, 72,25} },
{ {0,1,2,3,0,2,2,3, 94,12} },
{ {0,1,2,3,0,2,2,4, 135,12} },
{ {0,1,2,3,0,2,3,0, 111,12} },
{ {0,1,2,3,0,2,3,1, 114,32} },
{ {0,1,2,3,0,2,3,2, 103,30} },
{ {0,1,2,3,0,2,3,3, 69,24} },
{ {0,1,2,3,0,2,3,4, 150,32} },
{ {0,1,2,3,0,2,4,0, 147,12} },
{ {0,1,2,3,0,2,4,1, 150,12} },
{ {0,1,2,3,0,2,4,2, 149,12} },
{ {0,1,2,3,0,2,4,3, 151,32} },
{ {0,1,2,3,0,2,4,4, 148,12} },
{ {0,1,2,3,0,2,4,5, 170,32} },
{ {0,1,2,3,0,3,0,0, 71,29} },
{ {0,1,2,3,0,3,0,1, 87,12} },
{ {0,1,2,3,0,3,0,2, 78,47} },
{ {0,1,2,3,0,3,0,3, 83,47} },
{ {0,1,2,3,0,3,0,4, 133,12} },
{ {0,1,2,3,0,3,1,0, 111,33} },
{ {0,1,2,3,0,3,1,1, 103,5} },
{ {0,1,2,3,0,3,1,2, 114,13} },
{ {0,1,2,3,0,3,1,3, 69,37} },
{ {0,1,2,3,0,3,1,4, 150,13} },
{ {0,1,2,3,0,3,2,0, 91,27} },
{ {0,1,2,3,0,3,2,1, 97,13} },
{ {0,1,2,3,0,3,2,2, 75,25} },
{ {0,1,2,3,0,3,2,3, 84,22} },
{ {0,1,2,3,0,3,2,4, 138,13} },
{ {0,1,2,3,0,3,3,0, 102,33} },
{ {0,1,2,3,0,3,3,1, 105,33} },
{ {0,1,2,3,0,3,3,2, 105,12} },
{ {0,1,2,3,0,3,3,3, 63,30} },
{ {0,1,2,3,0,3,3,4, 143,33} },
{ {0,1,2,3,0,3,4,0, 153,33} },
{ {0,1,2,3,0,3,4,1, 155,32} },
{ {0,1,2,3,0,3,4,2, 156,32} },
{ {0,1,2,3,0,3,4,3, 134,37} },
{ {0,1,2,3,0,3,4,4, 144,5} },
{ {0,1,2,3,0,3,4,5, 173,32} },
{ {0,1,2,3,0,4,0,0, 127,47} },
{ {0,1,2,3,0,4,0,1, 130,12} },
{ {0,1,2,3,0,4,0,2, 128,47} },
{ {0,1,2,3,0,4,0,3, 134,47} },
{ {0,1,2,3,0,4,0,4, 129,47} },
{ {0,1,2,3,0,4,0,5, 167,12} },
{ {0,1,2,3,0,4,1,0, 147,33} },
{ {0,1,2,3,0,4,1,1, 149,33} },
{ {0,1,2,3,0,4,1,2, 150,33} },
{ {0,1,2,3,0,4,1,3, 151,13} },
{ {0,1,2,3,0,4,1,4, 148,33} },
{ {0,1,2,3,0,4,1,5, 170,13} },
{ {0,1,2,3,0,4,2,0, 135,27} },
{ {0,1,2,3,0,4,2,1, 138,26} },
{ {0,1,2,3,0,4,2,2, 129,44} },
{ {0,1,2,3,0,4,2,3, 136,26} },
{ {0,1,2,3,0,4,2,4, 137,12} },
{ {0,1,2,3,0,4,2,5, 168,13} },
{ {0,1,2,3,0,4,3,0, 153,12} },
{ {0,1,2,3,0,4,3,1, 156,13} },
{ {0,1,2,3,0,4,3,2, 155,13} },
{ {0,1,2,3,0,4,3,3, 134,24} },
{ {0,1,2,3,0,4,3,4, 144,30} },
{ {0,1,2,3,0,4,3,5, 173,13} },
{ {0,1,2,3,0,4,4,0, 140,33} },
{ {0,1,2,3,0,4,4,1, 141,33} },
{ {0,1,2,3,0,4,4,2, 141,12} },
{ {0,1,2,3,0,4,4,3, 145,33} },
{ {0,1,2,3,0,4,4,4, 132,30} },
{ {0,1,2,3,0,4,4,5, 169,33} },
{ {0,1,2,3,0,4,5,0, 171,33} },
{ {0,1,2,3,0,4,5,1, 173,33} },
{ {0,1,2,3,0,4,5,2, 173,12} },
{ {0,1,2,3,0,4,5,3, 174,32} },
{ {0,1,2,3,0,4,5,4, 172,33} },
{ {0,1,2,3,0,4,5,5, 172,12} },
{ {0,1,2,3,0,4,5,6, 182,32} },
{ {0,1,2,3,1,0,0,0, 76,30} },
{ {0,1,2,3,1,0,0,1, 115,2} },
{ {0,1,2,3,1,0,0,2, 116,2} },
{ {0,1,2,3,1,0,0,3, 105,22} },
{ {0,1,2,3,1,0,0,4, 157,33} },
{ {0,1,2,3,1,0,1,0, 90,28} },
{ {0,1,2,3,1,0,1,1, 76,29} },
{ {0,1,2,3,1,0,1,2, 98,28} },
{ {0,1,2,3,1,0,1,3, 103,28} },
{ {0,1,2,3,1,0,1,4, 140,47} },
{ {0,1,2,3,1,0,2,0, 103,31} },
{ {0,1,2,3,1,0,2,1, 105,27} },
{ {0,1,2,3,1,0,2,2, 87,25} },
{ {0,1,2,3,1,0,2,3, 97,45} },
{ {0,1,2,3,1,0,2,4, 155,26} },
{ {0,1,2,3,1,0,3,0, 98,31} },
{ {0,1,2,3,1,0,3,1, 116,3} },
{ {0,1,2,3,1,0,3,2, 118,3} },
{ {0,1,2,3,1,0,3,3, 87,24} },
{ {0,1,2,3,1,0,3,4, 158,21} },
{ {0,1,2,3,1,0,4,0, 140,36} },
{ {0,1,2,3,1,0,4,1, 157,42} },
{ {0,1,2,3,1,0,4,2, 158,20} },
{ {0,1,2,3,1,0,4,3, 155,23} },
{ {0,1,2,3,1,0,4,4, 155,4} },
{ {0,1,2,3,1,0,4,5, 175,21} },
{ {0,1,2,3,1,1,0,0, 65,3} },
{ {0,1,2,3,1,1,0,1, 61,3} },
{ {0,1,2,3,1,1,0,2, 78,3} },
{ {0,1,2,3,1,1,0,3, 75,3} },
{ {0,1,2,3,1,1,0,4, 128,3} },
{ {0,1,2,3,1,1,1,0, 64,11} },
{ {0,1,2,3,1,1,1,1, 58,10} },
{ {0,1,2,3,1,1,1,2, 71,11} },
{ {0,1,2,3,1,1,1,3, 72,3} },
{ {0,1,2,3,1,1,1,4, 127,3} },
{ {0,1,2,3,1,1,2,0, 69,3} },
{ {0,1,2,3,1,1,2,1, 63,10} },
{ {0,1,2,3,1,1,2,2, 83,3} },
{ {0,1,2,3,1,1,2,3, 84,42} },
{ {0,1,2,3,1,1,2,4, 134,3} },
{ {0,1,2,3,1,1,3,0, 66,3} },
{ {0,1,2,3,1,1,3,1, 61,31} },
{ {0,1,2,3,1,1,3,2, 87,3} },
{ {0,1,2,3,1,1,3,3, 80,3} },
{ {0,1,2,3,1,1,3,4, 130,3} },
{ {0,1,2,3,1,1,4,0, 126,42} },
{ {0,1,2,3,1,1,4,1, 125,42} },
{ {0,1,2,3,1,1,4,2, 133,42} },
{ {0,1,2,3,1,1,4,3, 129,42} },
{ {0,1,2,3,1,1,4,4, 129,3} },
{ {0,1,2,3,1,1,4,5, 167,42} },
{ {0,1,2,3,1,2,0,0, 111,4} },
{ {0,1,2,3,1,2,0,1, 120,3} },
{ {0,1,2,3,1,2,0,2, 104,31} },
{ {0,1,2,3,1,2,0,3, 114,39} },
{ {0,1,2,3,1,2,0,4, 162,32} },
{ {0,1,2,3,1,2,1,0, 107,47} },
{ {0,1,2,3,1,2,1,1, 67,29} },
{ {0,1,2,3,1,2,1,2, 92,29} },
{ {0,1,2,3,1,2,1,3, 108,39} },
{ {0,1,2,3,1,2,1,4, 147,47} },
{ {0,1,2,3,1,2,2,0, 111,27} },
{ {0,1,2,3,1,2,2,1, 102,27} },
{ {0,1,2,3,1,2,2,2, 71,5} },
{ {0,1,2,3,1,2,2,3, 91,39} },
{ {0,1,2,3,1,2,2,4, 153,27} },
{ {0,1,2,3,1,2,3,0, 121,21} },
{ {0,1,2,3,1,2,3,1, 120,31} },
{ {0,1,2,3,1,2,3,2, 98,30} },
{ {0,1,2,3,1,2,3,3, 66,24} },
{ {0,1,2,3,1,2,3,4, 163,21} },
{ {0,1,2,3,1,2,4,0, 164,21} },
{ {0,1,2,3,1,2,4,1, 160,42} },
{ {0,1,2,3,1,2,4,2, 142,36} },
{ {0,1,2,3,1,2,4,3, 150,39} },
{ {0,1,2,3,1,2,4,4, 150,24} },
{ {0,1,2,3,1,2,4,5, 177,21} },
{ {0,1,2,3,1,3,0,0, 104,5} },
{ {0,1,2,3,1,3,0,1, 116,9} },
{ {0,1,2,3,1,3,0,2, 122,12} },
{ {0,1,2,3,1,3,0,3, 78,37} },
{ {0,1,2,3,1,3,0,4, 165,32} },
{ {0,1,2,3,1,3,1,0, 111,28} },
{ {0,1,2,3,1,3,1,1, 76,4} },
{ {0,1,2,3,1,3,1,2, 104,29} },
{ {0,1,2,3,1,3,1,3, 65,37} },
{ {0,1,2,3,1,3,1,4, 153,28} },
{ {0,1,2,3,1,3,2,0, 114,27} },
{ {0,1,2,3,1,3,2,1, 105,44} },
{ {0,1,2,3,1,3,2,2, 78,25} },
{ {0,1,2,3,1,3,2,3, 75,37} },
{ {0,1,2,3,1,3,2,4, 156,26} },
{ {0,1,2,3,1,3,3,0, 120,30} },
{ {0,1,2,3,1,3,3,1, 115,30} },
{ {0,1,2,3,1,3,3,2, 116,24} },
{ {0,1,2,3,1,3,3,3, 61,30} },
{ {0,1,2,3,1,3,3,4, 159,30} },
{ {0,1,2,3,1,3,4,0, 162,8} },
{ {0,1,2,3,1,3,4,1, 157,9} },
{ {0,1,2,3,1,3,4,2, 165,8} },
{ {0,1,2,3,1,3,4,3, 128,37} },
{ {0,1,2,3,1,3,4,4, 141,5} },
{ {0,1,2,3,1,3,4,5, 178,8} },
{ {0,1,2,3,1,4,0,0, 153,4} },
{ {0,1,2,3,1,4,0,1, 159,3} },
{ {0,1,2,3,1,4,0,2, 165,26} },
{ {0,1,2,3,1,4,0,3, 156,38} },
{ {0,1,2,3,1,4,0,4, 141,31} },
{ {0,1,2,3,1,4,0,5, 178,32} },
{ {0,1,2,3,1,4,1,0, 147,28} },
{ {0,1,2,3,1,4,1,1, 131,29} },
{ {0,1,2,3,1,4,1,2, 142,46} },
{ {0,1,2,3,1,4,1,3, 149,22} },
{ {0,1,2,3,1,4,1,4, 135,31} },
{ {0,1,2,3,1,4,1,5, 171,47} },
{ {0,1,2,3,1,4,2,0, 150,45} },
{ {0,1,2,3,1,4,2,1, 143,27} },
{ {0,1,2,3,1,4,2,2, 133,44} },
{ {0,1,2,3,1,4,2,3, 138,45} },
{ {0,1,2,3,1,4,2,4, 144,31} },
{ {0,1,2,3,1,4,2,5, 173,26} },
{ {0,1,2,3,1,4,3,0, 163,6} },
{ {0,1,2,3,1,4,3,1, 159,31} },
{ {0,1,2,3,1,4,3,2, 158,6} },
{ {0,1,2,3,1,4,3,3, 130,24} },
{ {0,1,2,3,1,4,3,4, 139,31} },
{ {0,1,2,3,1,4,3,5, 179,21} },
{ {0,1,2,3,1,4,4,0, 162,11} },
{ {0,1,2,3,1,4,4,1, 157,10} },
{ {0,1,2,3,1,4,4,2, 165,11} },
{ {0,1,2,3,1,4,4,3, 141,22} },
{ {0,1,2,3,1,4,4,4, 128,30} },
{ {0,1,2,3,1,4,4,5, 178,11} },
{ {0,1,2,3,1,4,5,0, 177,42} },
{ {0,1,2,3,1,4,5,1, 176,42} },
{ {0,1,2,3,1,4,5,2, 180,21} },
{ {0,1,2,3,1,4,5,3, 173,22} },
{ {0,1,2,3,1,4,5,4, 169,36} },
{ {0,1,2,3,1,4,5,5, 173,5} },
{ {0,1,2,3,1,4,5,6, 183,21} },
{ {0,1,2,3,2,0,0,0, 76,5} },
{ {0,1,2,3,2,0,0,1, 116,12} },
{ {0,1,2,3,2,0,0,2, 115,28} },
{ {0,1,2,3,2,0,0,3, 105,39} },
{ {0,1,2,3,2,0,0,4, 157,12} },
{ {0,1,2,3,2,0,1,0, 111,31} },
{ {0,1,2,3,2,0,1,1, 104,4} },
{ {0,1,2,3,2,0,1,2, 120,29} },
{ {0,1,2,3,2,0,1,3, 114,22} },
{ {0,1,2,3,2,0,1,4, 162,13} },
{ {0,1,2,3,2,0,2,0, 65,46} },
{ {0,1,2,3,2,0,2,1, 78,46} },
{ {0,1,2,3,2,0,2,2, 61,29} },
{ {0,1,2,3,2,0,2,3, 75,46} },
{ {0,1,2,3,2,0,2,4, 128,46} },
{ {0,1,2,3,2,0,3,0, 104,30} },
{ {0,1,2,3,2,0,3,1, 122,43} },
{ {0,1,2,3,2,0,3,2, 116,25} },
{ {0,1,2,3,2,0,3,3, 78,24} },
{ {0,1,2,3,2,0,3,4, 165,13} },
{ {0,1,2,3,2,0,4,0, 153,31} },
{ {0,1,2,3,2,0,4,1, 165,43} },
{ {0,1,2,3,2,0,4,2, 159,29} },
{ {0,1,2,3,2,0,4,3, 156,23} },
{ {0,1,2,3,2,0,4,4, 141,4} },
{ {0,1,2,3,2,0,4,5, 178,13} },
{ {0,1,2,3,2,1,0,0, 103,4} },
{ {0,1,2,3,2,1,0,1, 87,9} },
{ {0,1,2,3,2,1,0,2, 105,42} },
{ {0,1,2,3,2,1,0,3, 97,8} },
{ {0,1,2,3,2,1,0,4, 155,43} },
{ {0,1,2,3,2,1,1,0, 111,42} },
{ {0,1,2,3,2,1,1,1, 71,30} },
{ {0,1,2,3,2,1,1,2, 102,42} },
{ {0,1,2,3,2,1,1,3, 91,22} },
{ {0,1,2,3,2,1,1,4, 153,42} },
{ {0,1,2,3,2,1,2,0, 69,46} },
{ {0,1,2,3,2,1,2,1, 83,46} },
{ {0,1,2,3,2,1,2,2, 63,29} },
{ {0,1,2,3,2,1,2,3, 84,27} },
{ {0,1,2,3,2,1,2,4, 134,46} },
{ {0,1,2,3,2,1,3,0, 114,42} },
{ {0,1,2,3,2,1,3,1, 78,36} },
{ {0,1,2,3,2,1,3,2, 105,9} },
{ {0,1,2,3,2,1,3,3, 75,24} },
{ {0,1,2,3,2,1,3,4, 156,43} },
{ {0,1,2,3,2,1,4,0, 150,8} },
{ {0,1,2,3,2,1,4,1, 133,9} },
{ {0,1,2,3,2,1,4,2, 143,42} },
{ {0,1,2,3,2,1,4,3, 138,8} },
{ {0,1,2,3,2,1,4,4, 144,4} },
{ {0,1,2,3,2,1,4,5, 173,43} },
{ {0,1,2,3,2,2,0,0, 90,11} },
{ {0,1,2,3,2,2,0,1, 98,2} },
{ {0,1,2,3,2,2,0,2, 76,10} },
{ {0,1,2,3,2,2,0,3, 103,11} },
{ {0,1,2,3,2,2,0,4, 140,2} },
{ {0,1,2,3,2,2,1,0, 107,2} },
{ {0,1,2,3,2,2,1,1, 92,10} },
{ {0,1,2,3,2,2,1,2, 67,10} },
{ {0,1,2,3,2,2,1,3, 108,22} },
{ {0,1,2,3,2,2,1,4, 147,2} },
{ {0,1,2,3,2,2,2,0, 64,28} },
{ {0,1,2,3,2,2,2,1, 71,28} },
{ {0,1,2,3,2,2,2,2, 58,29} },
{ {0,1,2,3,2,2,2,3, 72,46} },
{ {0,1,2,3,2,2,2,4, 127,46} },
{ {0,1,2,3,2,2,3,0, 111,11} },
{ {0,1,2,3,2,2,3,1, 104,10} },
{ {0,1,2,3,2,2,3,2, 76,31} },
{ {0,1,2,3,2,2,3,3, 65,24} },
{ {0,1,2,3,2,2,3,4, 153,11} },
{ {0,1,2,3,2,2,4,0, 147,11} },
{ {0,1,2,3,2,2,4,1, 142,3} },
{ {0,1,2,3,2,2,4,2, 131,10} },
{ {0,1,2,3,2,2,4,3, 149,39} },
{ {0,1,2,3,2,2,4,4, 135,4} },
{ {0,1,2,3,2,2,4,5, 171,2} },
{ {0,1,2,3,2,3,0,0, 98,4} },
{ {0,1,2,3,2,3,0,1, 118,13} },
{ {0,1,2,3,2,3,0,2, 116,27} },
{ {0,1,2,3,2,3,0,3, 87,22} },
{ {0,1,2,3,2,3,0,4, 158,13} },
{ {0,1,2,3,2,3,1,0, 121,13} },
{ {0,1,2,3,2,3,1,1, 98,5} },
{ {0,1,2,3,2,3,1,2, 120,4} },
{ {0,1,2,3,2,3,1,3, 66,22} },
{ {0,1,2,3,2,3,1,4, 163,13} },
{ {0,1,2,3,2,3,2,0, 66,27} },
{ {0,1,2,3,2,3,2,1, 87,27} },
{ {0,1,2,3,2,3,2,2, 61,4} },
{ {0,1,2,3,2,3,2,3, 80,27} },
{ {0,1,2,3,2,3,2,4, 130,27} },
{ {0,1,2,3,2,3,3,0, 120,5} },
{ {0,1,2,3,2,3,3,1, 116,22} },
{ {0,1,2,3,2,3,3,2, 115,5} },
{ {0,1,2,3,2,3,3,3, 61,5} },
{ {0,1,2,3,2,3,3,4, 159,5} },
{ {0,1,2,3,2,3,4,0, 163,8} },
{ {0,1,2,3,2,3,4,1, 158,8} },
{ {0,1,2,3,2,3,4,2, 159,4} },
{ {0,1,2,3,2,3,4,3, 130,22} },
{ {0,1,2,3,2,3,4,4, 139,4} },
{ {0,1,2,3,2,3,4,5, 179,13} },
{ {0,1,2,3,2,4,0,0, 140,25} },
{ {0,1,2,3,2,4,0,1, 158,26} },
{ {0,1,2,3,2,4,0,2, 157,27} },
{ {0,1,2,3,2,4,0,3, 155,38} },
{ {0,1,2,3,2,4,0,4, 155,31} },
{ {0,1,2,3,2,4,0,5, 175,40} },
{ {0,1,2,3,2,4,1,0, 164,40} },
{ {0,1,2,3,2,4,1,1, 142,25} },
{ {0,1,2,3,2,4,1,2, 160,27} },
{ {0,1,2,3,2,4,1,3, 150,22} },
{ {0,1,2,3,2,4,1,4, 150,37} },
{ {0,1,2,3,2,4,1,5, 177,40} },
{ {0,1,2,3,2,4,2,0, 126,27} },
{ {0,1,2,3,2,4,2,1, 133,27} },
{ {0,1,2,3,2,4,2,2, 125,27} },
{ {0,1,2,3,2,4,2,3, 129,27} },
{ {0,1,2,3,2,4,2,4, 129,46} },
{ {0,1,2,3,2,4,2,5, 167,27} },
{ {0,1,2,3,2,4,3,0, 162,45} },
{ {0,1,2,3,2,4,3,1, 165,45} },
{ {0,1,2,3,2,4,3,2, 157,44} },
{ {0,1,2,3,2,4,3,3, 128,24} },
{ {0,1,2,3,2,4,3,4, 141,30} },
{ {0,1,2,3,2,4,3,5, 178,45} },
{ {0,1,2,3,2,4,4,0, 162,28} },
{ {0,1,2,3,2,4,4,1, 165,28} },
{ {0,1,2,3,2,4,4,2, 157,29} },
{ {0,1,2,3,2,4,4,3, 141,39} },
{ {0,1,2,3,2,4,4,4, 128,5} },
{ {0,1,2,3,2,4,4,5, 178,28} },
{ {0,1,2,3,2,4,5,0, 177,27} },
{ {0,1,2,3,2,4,5,1, 180,40} },
{ {0,1,2,3,2,4,5,2, 176,27} },
{ {0,1,2,3,2,4,5,3, 173,39} },
{ {0,1,2,3,2,4,5,4, 173,30} },
{ {0,1,2,3,2,4,5,5, 169,25} },
{ {0,1,2,3,2,4,5,6, 183,40} },
{ {0,1,2,3,3,0,0,0, 67,30} },
{ {0,1,2,3,3,0,0,1, 120,2} },
{ {0,1,2,3,3,0,0,2, 120,28} },
{ {0,1,2,3,3,0,0,3, 102,22} },
{ {0,1,2,3,3,0,0,4, 160,33} },
{ {0,1,2,3,3,0,1,0, 107,36} },
{ {0,1,2,3,3,0,1,1, 111,5} },
{ {0,1,2,3,3,0,1,2, 121,20} },
{ {0,1,2,3,3,0,1,3, 111,22} },
{ {0,1,2,3,3,0,1,4, 164,20} },
{ {0,1,2,3,3,0,2,0, 108,44} },
{ {0,1,2,3,3,0,2,1, 114,26} },
{ {0,1,2,3,3,0,2,2, 66,25} },
{ {0,1,2,3,3,0,2,3, 91,44} },
{ {0,1,2,3,3,0,2,4, 150,44} },
{ {0,1,2,3,3,0,3,0, 92,30} },
{ {0,1,2,3,3,0,3,1, 104,28} },
{ {0,1,2,3,3,0,3,2, 98,29} },
{ {0,1,2,3,3,0,3,3, 71,4} },
{ {0,1,2,3,3,0,3,4, 142,47} },
{ {0,1,2,3,3,0,4,0, 147,36} },
{ {0,1,2,3,3,0,4,1, 162,43} },
{ {0,1,2,3,3,0,4,2, 163,20} },
{ {0,1,2,3,3,0,4,3, 153,22} },
{ {0,1,2,3,3,0,4,4, 150,25} },
{ {0,1,2,3,3,0,4,5, 177,20} },
{ {0,1,2,3,3,1,0,0, 108,9} },
{ {0,1,2,3,3,1,0,1, 66,9} },
{ {0,1,2,3,3,1,0,2, 114,43} },
{ {0,1,2,3,3,1,0,3, 91,9} },
{ {0,1,2,3,3,1,0,4, 150,9} },
{ {0,1,2,3,3,1,1,0, 107,9} },
{ {0,1,2,3,3,1,1,1, 64,36} },
{ {0,1,2,3,3,1,1,2, 111,9} },
{ {0,1,2,3,3,1,1,3, 90,9} },
{ {0,1,2,3,3,1,1,4, 147,9} },
{ {0,1,2,3,3,1,2,0, 109,9} },
{ {0,1,2,3,3,1,2,1, 69,36} },
{ {0,1,2,3,3,1,2,2, 69,25} },
{ {0,1,2,3,3,1,2,3, 94,9} },
{ {0,1,2,3,3,1,2,4, 151,43} },
{ {0,1,2,3,3,1,3,0, 108,42} },
{ {0,1,2,3,3,1,3,1, 65,36} },
{ {0,1,2,3,3,1,3,2, 103,29} },
{ {0,1,2,3,3,1,3,3, 72,24} },
{ {0,1,2,3,3,1,3,4, 149,9} },
{ {0,1,2,3,3,1,4,0, 146,43} },
{ {0,1,2,3,3,1,4,1, 126,9} },
{ {0,1,2,3,3,1,4,2, 150,43} },
{ {0,1,2,3,3,1,4,3, 135,9} },
{ {0,1,2,3,3,1,4,4, 148,9} },
{ {0,1,2,3,3,1,4,5, 170,43} },
{ {0,1,2,3,3,2,0,0, 107,25} },
{ {0,1,2,3,3,2,0,1, 121,26} },
{ {0,1,2,3,3,2,0,2, 111,30} },
{ {0,1,2,3,3,2,0,3, 111,39} },
{ {0,1,2,3,3,2,0,4, 164,41} },
{ {0,1,2,3,3,2,1,0, 123,0} },
{ {0,1,2,3,3,2,1,1, 107,5} },
{ {0,1,2,3,3,2,1,2, 107,30} },
{ {0,1,2,3,3,2,1,3, 107,39} },
{ {0,1,2,3,3,2,1,4, 166,0} },
{ {0,1,2,3,3,2,2,0, 107,44} },
{ {0,1,2,3,3,2,2,1, 111,44} },
{ {0,1,2,3,3,2,2,2, 64,25} },
{ {0,1,2,3,3,2,2,3, 90,44} },
{ {0,1,2,3,3,2,2,4, 147,44} },
{ {0,1,2,3,3,2,3,0, 107,29} },
{ {0,1,2,3,3,2,3,1, 111,29} },
{ {0,1,2,3,3,2,3,2, 90,30} },
{ {0,1,2,3,3,2,3,3, 64,4} },
{ {0,1,2,3,3,2,3,4, 147,29} },
{ {0,1,2,3,3,2,4,0, 166,20} },
{ {0,1,2,3,3,2,4,1, 164,9} },
{ {0,1,2,3,3,2,4,2, 147,30} },
{ {0,1,2,3,3,2,4,3, 147,39} },
{ {0,1,2,3,3,2,4,4, 146,25} },
{ {0,1,2,3,3,2,4,5, 181,0} },
{ {0,1,2,3,3,3,0,0, 92,5} },
{ {0,1,2,3,3,3,0,1, 98,3} },
{ {0,1,2,3,3,3,0,2, 104,11} },
{ {0,1,2,3,3,3,0,3, 71,31} },
{ {0,1,2,3,3,3,0,4, 142,2} },
{ {0,1,2,3,3,3,1,0, 107,10} },
{ {0,1,2,3,3,3,1,1, 90,5} },
{ {0,1,2,3,3,3,1,2, 111,10} },
{ {0,1,2,3,3,3,1,3, 64,31} },
{ {0,1,2,3,3,3,1,4, 147,10} },
{ {0,1,2,3,3,3,2,0, 108,27} },
{ {0,1,2,3,3,3,2,1, 103,10} },
{ {0,1,2,3,3,3,2,2, 65,25} },
{ {0,1,2,3,3,3,2,3, 72,37} },
{ {0,1,2,3,3,3,2,4, 149,44} },
{ {0,1,2,3,3,3,3,0, 67,11} },
{ {0,1,2,3,3,3,3,1, 76,11} },
{ {0,1,2,3,3,3,3,2, 76,28} },
{ {0,1,2,3,3,3,3,3, 58,30} },
{ {0,1,2,3,3,3,3,4, 131,11} },
{ {0,1,2,3,3,3,4,0, 147,3} },
{ {0,1,2,3,3,3,4,1, 140,3} },
{ {0,1,2,3,3,3,4,2, 153,10} },
{ {0,1,2,3,3,3,4,3, 127,37} },
{ {0,1,2,3,3,3,4,4, 135,5} },
{ {0,1,2,3,3,3,4,5, 171,3} },
{ {0,1,2,3,3,4,0,0, 147,25} },
{ {0,1,2,3,3,4,0,1, 163,26} },
{ {0,1,2,3,3,4,0,2, 162,26} },
{ {0,1,2,3,3,4,0,3, 153,39} },
{ {0,1,2,3,3,4,0,4, 150,36} },
{ {0,1,2,3,3,4,0,5, 177,41} },
{ {0,1,2,3,3,4,1,0, 166,41} },
{ {0,1,2,3,3,4,1,1, 147,5} },
{ {0,1,2,3,3,4,1,2, 164,44} },
{ {0,1,2,3,3,4,1,3, 147,22} },
{ {0,1,2,3,3,4,1,4, 146,36} },
{ {0,1,2,3,3,4,1,5, 181,19} },
{ {0,1,2,3,3,4,2,0, 146,26} },
{ {0,1,2,3,3,4,2,1, 150,26} },
{ {0,1,2,3,3,4,2,2, 126,44} },
{ {0,1,2,3,3,4,2,3, 135,44} },
{ {0,1,2,3,3,4,2,4, 148,44} },
{ {0,1,2,3,3,4,2,5, 170,26} },
{ {0,1,2,3,3,4,3,0, 147,46} },
{ {0,1,2,3,3,4,3,1, 153,29} },
{ {0,1,2,3,3,4,3,2, 140,46} },
{ {0,1,2,3,3,4,3,3, 127,24} },
{ {0,1,2,3,3,4,3,4, 135,30} },
{ {0,1,2,3,3,4,3,5, 171,46} },
{ {0,1,2,3,3,4,4,0, 164,30} },
{ {0,1,2,3,3,4,4,1, 162,30} },
{ {0,1,2,3,3,4,4,2, 162,5} },
{ {0,1,2,3,3,4,4,3, 140,22} },
{ {0,1,2,3,3,4,4,4, 126,30} },
{ {0,1,2,3,3,4,4,5, 177,30} },
{ {0,1,2,3,3,4,5,0, 181,43} },
{ {0,1,2,3,3,4,5,1, 177,9} },
{ {0,1,2,3,3,4,5,2, 177,44} },
{ {0,1,2,3,3,4,5,3, 171,22} },
{ {0,1,2,3,3,4,5,4, 170,36} },
{ {0,1,2,3,3,4,5,5, 170,25} },
{ {0,1,2,3,3,4,5,6, 184,0} },
{ {0,1,2,3,4,0,0,0, 131,30} },
{ {0,1,2,3,4,0,0,1, 159,2} },
{ {0,1,2,3,4,0,0,2, 159,28} },
{ {0,1,2,3,4,0,0,3, 143,22} },
{ {0,1,2,3,4,0,0,4, 157,11} },
{ {0,1,2,3,4,0,0,5, 176,33} },
{ {0,1,2,3,4,0,1,0, 147,31} },
{ {0,1,2,3,4,0,1,1, 153,5} },
{ {0,1,2,3,4,0,1,2, 163,7} },
{ {0,1,2,3,4,0,1,3, 150,38} },
{ {0,1,2,3,4,0,1,4, 162,10} },
{ {0,1,2,3,4,0,1,5, 177,33} },
{ {0,1,2,3,4,0,2,0, 149,27} },
{ {0,1,2,3,4,0,2,1, 156,45} },
{ {0,1,2,3,4,0,2,2, 130,25} },
{ {0,1,2,3,4,0,2,3, 138,38} },
{ {0,1,2,3,4,0,2,4, 141,27} },
{ {0,1,2,3,4,0,2,5, 173,27} },
{ {0,1,2,3,4,0,3,0, 142,37} },
{ {0,1,2,3,4,0,3,1, 165,23} },
{ {0,1,2,3,4,0,3,2, 158,7} },
{ {0,1,2,3,4,0,3,3, 133,39} },
{ {0,1,2,3,4,0,3,4, 165,10} },
{ {0,1,2,3,4,0,3,5, 180,20} },
{ {0,1,2,3,4,0,4,0, 135,28} },
{ {0,1,2,3,4,0,4,1, 141,28} },
{ {0,1,2,3,4,0,4,2, 139,28} },
{ {0,1,2,3,4,0,4,3, 144,28} },
{ {0,1,2,3,4,0,4,4, 128,29} },
{ {0,1,2,3,4,0,4,5, 169,47} },
{ {0,1,2,3,4,0,5,0, 171,36} },
{ {0,1,2,3,4,0,5,1, 178,9} },
{ {0,1,2,3,4,0,5,2, 179,20} },
{ {0,1,2,3,4,0,5,3, 173,23} },
{ {0,1,2,3,4,0,5,4, 178,10} },
{ {0,1,2,3,4,0,5,5, 173,4} },
{ {0,1,2,3,4,0,5,6, 183,20} },
{ {0,1,2,3,4,1,0,0, 149,42} },
{ {0,1,2,3,4,1,0,1, 130,9} },
{ {0,1,2,3,4,1,0,2, 156,8} },
{ {0,1,2,3,4,1,0,3, 138,23} },
{ {0,1,2,3,4,1,0,4, 141,42} },
{ {0,1,2,3,4,1,0,5, 173,42} },
{ {0,1,2,3,4,1,1,0, 147,42} },
{ {0,1,2,3,4,1,1,1, 127,36} },
{ {0,1,2,3,4,1,1,2, 153,9} },
{ {0,1,2,3,4,1,1,3, 135,22} },
{ {0,1,2,3,4,1,1,4, 140,42} },
{ {0,1,2,3,4,1,1,5, 171,42} },
{ {0,1,2,3,4,1,2,0, 151,8} },
{ {0,1,2,3,4,1,2,1, 134,36} },
{ {0,1,2,3,4,1,2,2, 134,25} },
{ {0,1,2,3,4,1,2,3, 136,23} },
{ {0,1,2,3,4,1,2,4, 145,42} },
{ {0,1,2,3,4,1,2,5, 174,43} },
{ {0,1,2,3,4,1,3,0, 150,42} },
{ {0,1,2,3,4,1,3,1, 128,36} },
{ {0,1,2,3,4,1,3,2, 155,8} },
{ {0,1,2,3,4,1,3,3, 129,39} },
{ {0,1,2,3,4,1,3,4, 141,9} },
{ {0,1,2,3,4,1,3,5, 173,9} },
{ {0,1,2,3,4,1,4,0, 148,42} },
{ {0,1,2,3,4,1,4,1, 129,36} },
{ {0,1,2,3,4,1,4,2, 144,29} },
{ {0,1,2,3,4,1,4,3, 137,9} },
{ {0,1,2,3,4,1,4,4, 132,29} },
{ {0,1,2,3,4,1,4,5, 172,42} },
{ {0,1,2,3,4,1,5,0, 170,8} },
{ {0,1,2,3,4,1,5,1, 167,9} },
{ {0,1,2,3,4,1,5,2, 173,8} },
{ {0,1,2,3,4,1,5,3, 168,8} },
{ {0,1,2,3,4,1,5,4, 169,42} },
{ {0,1,2,3,4,1,5,5, 172,9} },
{ {0,1,2,3,4,1,5,6, 182,43} },
{ {0,1,2,3,4,2,0,0, 147,4} },
{ {0,1,2,3,4,2,0,1, 163,23} },
{ {0,1,2,3,4,2,0,2, 153,30} },
{ {0,1,2,3,4,2,0,3, 150,23} },
{ {0,1,2,3,4,2,0,4, 162,29} },
{ {0,1,2,3,4,2,0,5, 177,12} },
{ {0,1,2,3,4,2,1,0, 166,23} },
{ {0,1,2,3,4,2,1,1, 147,24} },
{ {0,1,2,3,4,2,1,2, 147,37} },
{ {0,1,2,3,4,2,1,3, 146,23} },
{ {0,1,2,3,4,2,1,4, 164,29} },
{ {0,1,2,3,4,2,1,5, 181,32} },
{ {0,1,2,3,4,2,2,0, 147,27} },
{ {0,1,2,3,4,2,2,1, 153,44} },
{ {0,1,2,3,4,2,2,2, 127,25} },
{ {0,1,2,3,4,2,2,3, 135,39} },
{ {0,1,2,3,4,2,2,4, 140,27} },
{ {0,1,2,3,4,2,2,5, 171,27} },
{ {0,1,2,3,4,2,3,0, 164,39} },
{ {0,1,2,3,4,2,3,1, 162,23} },
{ {0,1,2,3,4,2,3,2, 140,37} },
{ {0,1,2,3,4,2,3,3, 126,39} },
{ {0,1,2,3,4,2,3,4, 162,4} },
{ {0,1,2,3,4,2,3,5, 177,39} },
{ {0,1,2,3,4,2,4,0, 146,47} },
{ {0,1,2,3,4,2,4,1, 150,47} },
{ {0,1,2,3,4,2,4,2, 135,29} },
{ {0,1,2,3,4,2,4,3, 148,39} },
{ {0,1,2,3,4,2,4,4, 126,29} },
{ {0,1,2,3,4,2,4,5, 170,47} },
{ {0,1,2,3,4,2,5,0, 181,14} },
{ {0,1,2,3,4,2,5,1, 177,34} },
{ {0,1,2,3,4,2,5,2, 171,37} },
{ {0,1,2,3,4,2,5,3, 170,23} },
{ {0,1,2,3,4,2,5,4, 177,29} },
{ {0,1,2,3,4,2,5,5, 170,24} },
{ {0,1,2,3,4,2,5,6, 184,21} },
{ {0,1,2,3,4,3,0,0, 142,24} },
{ {0,1,2,3,4,3,0,1, 158,23} },
{ {0,1,2,3,4,3,0,2, 165,38} },
{ {0,1,2,3,4,3,0,3, 133,22} },
{ {0,1,2,3,4,3,0,4, 165,29} },
{ {0,1,2,3,4,3,0,5, 180,35} },
{ {0,1,2,3,4,3,1,0, 164,22} },
{ {0,1,2,3,4,3,1,1, 140,24} },
{ {0,1,2,3,4,3,1,2, 162,38} },
{ {0,1,2,3,4,3,1,3, 126,22} },
{ {0,1,2,3,4,3,1,4, 162,31} },
{ {0,1,2,3,4,3,1,5, 177,22} },
{ {0,1,2,3,4,3,2,0, 150,27} },
{ {0,1,2,3,4,3,2,1, 155,45} },
{ {0,1,2,3,4,3,2,2, 128,25} },
{ {0,1,2,3,4,3,2,3, 129,22} },
{ {0,1,2,3,4,3,2,4, 141,44} },
{ {0,1,2,3,4,3,2,5, 173,44} },
{ {0,1,2,3,4,3,3,0, 160,22} },
{ {0,1,2,3,4,3,3,1, 157,22} },
{ {0,1,2,3,4,3,3,2, 157,39} },
{ {0,1,2,3,4,3,3,3, 125,22} },
{ {0,1,2,3,4,3,3,4, 157,30} },
{ {0,1,2,3,4,3,3,5, 176,22} },
{ {0,1,2,3,4,3,4,0, 150,46} },
{ {0,1,2,3,4,3,4,1, 155,29} },
{ {0,1,2,3,4,3,4,2, 141,29} },
{ {0,1,2,3,4,3,4,3, 129,37} },
{ {0,1,2,3,4,3,4,4, 128,4} },
{ {0,1,2,3,4,3,4,5, 173,29} },
{ {0,1,2,3,4,3,5,0, 177,35} },
{ {0,1,2,3,4,3,5,1, 175,35} },
{ {0,1,2,3,4,3,5,2, 178,22} },
{ {0,1,2,3,4,3,5,3, 167,22} },
{ {0,1,2,3,4,3,5,4, 178,31} },
{ {0,1,2,3,4,3,5,5, 169,24} },
{ {0,1,2,3,4,3,5,6, 183,35} },
{ {0,1,2,3,4,4,0,0, 135,11} },
{ {0,1,2,3,4,4,0,1, 139,2} },
{ {0,1,2,3,4,4,0,2, 141,11} },
{ {0,1,2,3,4,4,0,3, 144,11} },
{ {0,1,2,3,4,4,0,4, 128,10} },
{ {0,1,2,3,4,4,0,5, 169,2} },
{ {0,1,2,3,4,4,1,0, 146,2} },
{ {0,1,2,3,4,4,1,1, 135,10} },
{ {0,1,2,3,4,4,1,2, 150,2} },
{ {0,1,2,3,4,4,1,3, 148,22} },
{ {0,1,2,3,4,4,1,4, 126,10} },
{ {0,1,2,3,4,4,1,5, 170,2} },
{ {0,1,2,3,4,4,2,0, 148,27} },
{ {0,1,2,3,4,4,2,1, 144,10} },
{ {0,1,2,3,4,4,2,2, 129,25} },
{ {0,1,2,3,4,4,2,3, 137,44} },
{ {0,1,2,3,4,4,2,4, 132,10} },
{ {0,1,2,3,4,4,2,5, 172,27} },
{ {0,1,2,3,4,4,3,0, 150,3} },
{ {0,1,2,3,4,4,3,1, 141,10} },
{ {0,1,2,3,4,4,3,2, 155,10} },
{ {0,1,2,3,4,4,3,3, 129,24} },
{ {0,1,2,3,4,4,3,4, 128,31} },
{ {0,1,2,3,4,4,3,5, 173,10} },
{ {0,1,2,3,4,4,4,0, 126,11} },
{ {0,1,2,3,4,4,4,1, 128,11} },
{ {0,1,2,3,4,4,4,2, 128,28} },
{ {0,1,2,3,4,4,4,3, 132,11} },
{ {0,1,2,3,4,4,4,4, 124,11} },
{ {0,1,2,3,4,4,4,5, 167,11} },
{ {0,1,2,3,4,4,5,0, 170,3} },
{ {0,1,2,3,4,4,5,1, 169,3} },
{ {0,1,2,3,4,4,5,2, 173,11} },
{ {0,1,2,3,4,4,5,3, 172,22} },
{ {0,1,2,3,4,4,5,4, 167,10} },
{ {0,1,2,3,4,4,5,5, 168,11} },
{ {0,1,2,3,4,4,5,6, 182,2} },
{ {0,1,2,3,4,5,0,0, 171,25} },
{ {0,1,2,3,4,5,0,1, 179,26} },
{ {0,1,2,3,4,5,0,2, 178,44} },
{ {0,1,2,3,4,5,0,3, 173,38} },
{ {0,1,2,3,4,5,0,4, 178,29} },
{ {0,1,2,3,4,5,0,5, 173,31} },
{ {0,1,2,3,4,5,0,6, 183,41} },
{ {0,1,2,3,4,5,1,0, 181,17} },
{ {0,1,2,3,4,5,1,1, 171,24} },
{ {0,1,2,3,4,5,1,2, 177,7} },
{ {0,1,2,3,4,5,1,3, 170,38} },
{ {0,1,2,3,4,5,1,4, 177,10} },
{ {0,1,2,3,4,5,1,5, 170,37} },
{ {0,1,2,3,4,5,1,6, 184,40} },
{ {0,1,2,3,4,5,2,0, 170,45} },
{ {0,1,2,3,4,5,2,1, 173,45} },
{ {0,1,2,3,4,5,2,2, 167,44} },
{ {0,1,2,3,4,5,2,3, 168,45} },
{ {0,1,2,3,4,5,2,4, 169,27} },
{ {0,1,2,3,4,5,2,5, 172,44} },
{ {0,1,2,3,4,5,2,6, 182,26} },
{ {0,1,2,3,4,5,3,0, 177,6} },
{ {0,1,2,3,4,5,3,1, 178,39} },
{ {0,1,2,3,4,5,3,2, 175,6} },
{ {0,1,2,3,4,5,3,3, 167,39} },
{ {0,1,2,3,4,5,3,4, 178,4} },
{ {0,1,2,3,4,5,3,5, 169,37} },
{ {0,1,2,3,4,5,3,6, 183,6} },
{ {0,1,2,3,4,5,4,0, 170,46} },
{ {0,1,2,3,4,5,4,1, 173,28} },
{ {0,1,2,3,4,5,4,2, 169,46} },
{ {0,1,2,3,4,5,4,3, 172,39} },
{ {0,1,2,3,4,5,4,4, 167,29} },
{ {0,1,2,3,4,5,4,5, 168,28} },
{ {0,1,2,3,4,5,4,6, 182,47} },
{ {0,1,2,3,4,5,5,0, 177,11} },
{ {0,1,2,3,4,5,5,1, 178,30} },
{ {0,1,2,3,4,5,5,2, 178,5} },
{ {0,1,2,3,4,5,5,3, 169,22} },
{ {0,1,2,3,4,5,5,4, 175,11} },
{ {0,1,2,3,4,5,5,5, 167,30} },
{ {0,1,2,3,4,5,5,6, 183,11} },
{ {0,1,2,3,4,5,6,0, 184,35} },
{ {0,1,2,3,4,5,6,1, 183,34} },
{ {0,1,2,3,4,5,6,2, 183,7} },
{ {0,1,2,3,4,5,6,3, 182,23} },
{ {0,1,2,3,4,5,6,4, 183,10} },
{ {0,1,2,3,4,5,6,5, 182,36} },
{ {0,1,2,3,4,5,6,6, 182,25} },
{ {0,1,2,3,4,5,6,7, 185,0} }
};

}//end namespace internal
}//end namespace Mesh_3
}//end namespace CGAL

#endif // CGAL_MESH_3_FEATURES_DETECTION_CASES_TABLES_H
