include(RunCMake)

run_cmake(NoQt)
if (DEFINED with_qt_version)
  set(RunCMake_TEST_OPTIONS
    -Dwith_qt_version=${with_qt_version}
    "-DQt${with_qt_version}_DIR:PATH=${Qt${with_qt_version}_DIR}"
    "-DCMAKE_PREFIX_PATH:STRING=${CMAKE_PREFIX_PATH}"
  )

  run_cmake(QtInFunction)
  run_cmake(QtInFunctionNested)
  run_cmake(QtInFunctionProperty)

  run_cmake(CMP0111-imported-target-full)
  run_cmake(CMP0111-imported-target-libname)
  run_cmake(CMP0111-imported-target-implib-only)

  block()
    set(RunCMake_TEST_BINARY_DIR  ${RunCMake_BINARY_DIR}/MocPredefs-build)
    run_cmake(MocPredefs)
    set(RunCMake_TEST_NO_CLEAN 1)
    run_cmake_command(MocPredefs-build ${CMAKE_COMMAND} --build . --config Debug)
  endblock()

  # Detect information from the toolchain:
  # - CMAKE_INCLUDE_FLAG_CXX
  # - CMAKE_INCLUDE_SYSTEM_FLAG_CXX
  run_cmake(Inspect)
  include("${RunCMake_BINARY_DIR}/Inspect-build/info.cmake")
  foreach(autogen_type IN ITEMS MOC UIC)
    block()
      set(RunCMake_TEST_VARIANT_DESCRIPTION "-AUTO${autogen_type}=ON")
      if(CMAKE_INCLUDE_SYSTEM_FLAG_CXX)
        if(RunCMake_GENERATOR MATCHES "Visual Studio")
          string(REGEX REPLACE "^-" "/" test_expect_stdout_common "${CMAKE_INCLUDE_SYSTEM_FLAG_CXX}")
        else()
          set(test_expect_stdout_common "-*${CMAKE_INCLUDE_SYSTEM_FLAG_CXX}")
        endif()
        set(test_expect_stdout_1 "${test_expect_stdout_common}")
        set(test_expect_stdout_1_short "${test_expect_stdout_common}")
        set(test_expect_stdout_2 "${test_expect_stdout_common}")
        string(APPEND test_expect_stdout_1 " *(\"[^\"]*|([^ ]|\\ )*)[\\/]dummy_autogen[\\/]include")
        string(APPEND test_expect_stdout_1_short " *(\"[^\"]*|([^ ]|\\ )*)[\\/]\\.o[\\/]9624d702[\\/]autogen[\\/]include")
        if(RunCMake_GENERATOR_IS_MULTI_CONFIG)
          string(APPEND test_expect_stdout_1 "_Debug")
          string(APPEND test_expect_stdout_1_short "_Debug")
        endif()
        string(APPEND test_expect_stdout_2 " *(\"[^\"]*|([^ ]|\\ )*)[\\/]QtCore")
        set(test_expect_stdout "${test_expect_stdout_1}.*${test_expect_stdout_2}")
        set(test_expect_stdout_short "${test_expect_stdout_1_short}.*${test_expect_stdout_2}")

        block()
          set(RunCMake_TEST_BINARY_DIR  ${RunCMake_BINARY_DIR}/CMP0151-new-build)
          run_cmake_with_options(CMP0151-new ${RunCMake_TEST_OPTIONS}  -DCMAKE_AUTO${autogen_type}=ON -DCMAKE_POLICY_DEFAULT_CMP0151=NEW)
          set(RunCMake_TEST_NO_CLEAN 1)
          set(RunCMake_TEST_EXPECT_stdout "${test_expect_stdout}")
          run_cmake_command(CMP0151-new-build ${CMAKE_COMMAND} --build . --config Debug --verbose)
        endblock()

        block()
          set(RunCMake_TEST_BINARY_DIR  ${RunCMake_BINARY_DIR}/AutogenUseSystemIncludeOn-build)
          run_cmake_with_options(AutogenUseSystemIncludeOn ${RunCMake_TEST_OPTIONS} -DCMAKE_AUTO${autogen_type}=ON -DCMAKE_POLICY_DEFAULT_CMP0151=NEW)
          set(RunCMake_TEST_NO_CLEAN 1)
          set(RunCMake_TEST_EXPECT_stdout "${test_expect_stdout}")
          run_cmake_command(AutogenUseSystemIncludeOn-build ${CMAKE_COMMAND} --build . --config Debug --verbose)
        endblock()

        if (RunCMake_GENERATOR MATCHES "(Ninja|Makefiles|Visual Studio)")
          block()
            set(RunCMake_TEST_BINARY_DIR  ${RunCMake_BINARY_DIR}/CMP0151Short-new-build)
            run_cmake_with_options(CMP0151Short-new ${RunCMake_TEST_OPTIONS}  -DCMAKE_AUTO${autogen_type}=ON -DCMAKE_POLICY_DEFAULT_CMP0151=NEW)
            set(RunCMake_TEST_NO_CLEAN 1)
            set(RunCMake_TEST_EXPECT_stdout "${test_expect_stdout_short}")
            run_cmake_command(CMP0151Short-new-build ${CMAKE_COMMAND} --build . --config Debug --verbose)
          endblock()

          block()
            set(RunCMake_TEST_BINARY_DIR  ${RunCMake_BINARY_DIR}/AutogenUseSystemIncludeShortOn-build)
            run_cmake_with_options(AutogenUseSystemIncludeShortOn ${RunCMake_TEST_OPTIONS} -DCMAKE_AUTO${autogen_type}=ON -DCMAKE_POLICY_DEFAULT_CMP0151=NEW)
            set(RunCMake_TEST_NO_CLEAN 1)
            set(RunCMake_TEST_EXPECT_stdout "${test_expect_stdout_short}")
            run_cmake_command(AutogenUseSystemIncludeShortOn-build ${CMAKE_COMMAND} --build . --config Debug --verbose)
          endblock()
        endif ()
      endif()

      if(CMAKE_INCLUDE_FLAG_CXX)
        if(RunCMake_GENERATOR MATCHES "Visual Studio")
          string(REGEX REPLACE "^-" "/" test_expect_stdout "${CMAKE_INCLUDE_FLAG_CXX}")
          string(REGEX REPLACE "^-" "/" test_expect_stdout_short "${CMAKE_INCLUDE_FLAG_CXX}")
        else()
          set(test_expect_stdout "-*${CMAKE_INCLUDE_FLAG_CXX}")
          set(test_expect_stdout_short "-*${CMAKE_INCLUDE_FLAG_CXX}")
        endif()
        string(APPEND test_expect_stdout " *(\"[^\"]*|([^ ]|\\ )*)[\\/]dummy_autogen[\\/]include")
        string(APPEND test_expect_stdout_short " *(\"[^\"]*|([^ ]|\\ )*)[\\/]\\.o[\\/]9624d702[\\/]autogen[\\/]include")
        if(RunCMake_GENERATOR_IS_MULTI_CONFIG)
          string(APPEND test_expect_stdout "_Debug")
          string(APPEND test_expect_stdout_short "_Debug")
        endif()

        block()
          set(RunCMake_TEST_BINARY_DIR ${RunCMake_BINARY_DIR}/CMP0151-old-build)
          set(RunCMake_TEST_EXPECT_stderr ".") # ignore CMP0151 deprecation warnings
          run_cmake_with_options(CMP0151-old ${RunCMake_TEST_OPTIONS} -DCMAKE_AUTO${autogen_type}=ON -DCMAKE_POLICY_DEFAULT_CMP0151=OLD)
          unset(RunCMake_TEST_EXPECT_stderr)
          set(RunCMake_TEST_NO_CLEAN 1)
          set(RunCMake_TEST_EXPECT_stdout "${test_expect_stdout}")
          run_cmake_command(CMP0151-old-build ${CMAKE_COMMAND} --build . --config Debug --verbose)
        endblock()

        block()
          set(RunCMake_TEST_BINARY_DIR  ${RunCMake_BINARY_DIR}/AutogenUseSystemIncludeOff-build)
          run_cmake_with_options(AutogenUseSystemIncludeOff ${RunCMake_TEST_OPTIONS} -DCMAKE_AUTO${autogen_type}=ON -DCMAKE_POLICY_DEFAULT_CMP0151=NEW)
          set(RunCMake_TEST_NO_CLEAN 1)
          set(RunCMake_TEST_EXPECT_stdout "${test_expect_stdout}")
          run_cmake_command(AutogenUseSystemIncludeOff-build ${CMAKE_COMMAND} --build . --config Debug --verbose)
        endblock()

        if (RunCMake_GENERATOR MATCHES "(Ninja|Makefiles|Visual Studio)")
          block()
            set(RunCMake_TEST_BINARY_DIR ${RunCMake_BINARY_DIR}/CMP0151Short-old-build)
            set(RunCMake_TEST_EXPECT_stderr ".") # ignore CMP0151 deprecation warnings
            run_cmake_with_options(CMP0151Short-old ${RunCMake_TEST_OPTIONS} -DCMAKE_AUTO${autogen_type}=ON -DCMAKE_POLICY_DEFAULT_CMP0151=OLD)
            unset(RunCMake_TEST_EXPECT_stderr)
            set(RunCMake_TEST_NO_CLEAN 1)
            set(RunCMake_TEST_EXPECT_stdout "${test_expect_stdout_short}")
            run_cmake_command(CMP0151Short-old-build ${CMAKE_COMMAND} --build . --config Debug --verbose)
          endblock()

          block()
            set(RunCMake_TEST_BINARY_DIR  ${RunCMake_BINARY_DIR}/AutogenUseSystemIncludeShortOff-build)
            run_cmake_with_options(AutogenUseSystemIncludeShortOff ${RunCMake_TEST_OPTIONS} -DCMAKE_AUTO${autogen_type}=ON -DCMAKE_POLICY_DEFAULT_CMP0151=NEW)
            set(RunCMake_TEST_NO_CLEAN 1)
            set(RunCMake_TEST_EXPECT_stdout "${test_expect_stdout_short}")
            run_cmake_command(AutogenUseSystemIncludeShortOff-build ${CMAKE_COMMAND} --build . --config Debug --verbose)
          endblock()
        endif()
      endif()
    endblock()
  endforeach()
  if(CMAKE_INCLUDE_FLAG_CXX)
    if(RunCMake_GENERATOR MATCHES "Make|Ninja")
      block()
        set(RunCMake_TEST_BINARY_DIR  ${RunCMake_BINARY_DIR}/AutogenSkipLinting-build)
        list(APPEND RunCMake_TEST_OPTIONS
          "-DPSEUDO_CPPCHECK=${PSEUDO_CPPCHECK}"
          "-DPSEUDO_CPPLINT=${PSEUDO_CPPLINT}"
          "-DPSEUDO_IWYU=${PSEUDO_IWYU}"
          "-DPSEUDO_TIDY=${PSEUDO_TIDY}")

        run_cmake(AutogenSkipLinting)
        set(RunCMake_TEST_NO_CLEAN 1)
        run_cmake_command(AutogenSkipLinting-build ${CMAKE_COMMAND} --build . --config Debug --verbose)
      endblock()
    endif()
  endif()

  if(RunCMake_GENERATOR_IS_MULTI_CONFIG AND NOT RunCMake_GENERATOR MATCHES "Xcode")
    block()
      set(RunCMake_TEST_BINARY_DIR  ${RunCMake_BINARY_DIR}/MocGeneratedFile-build)
      run_cmake(MocGeneratedFile)
      set(RunCMake_TEST_NO_CLEAN 1)
      run_cmake_command(MocGeneratedFile-build ${CMAKE_COMMAND} --build . --config Debug --verbose)
    endblock()
    if(RunCMake_GENERATOR MATCHES "Ninja Multi-Config")
      block()
        set(RunCMake_TEST_BINARY_DIR  ${RunCMake_BINARY_DIR}/MocGeneratedFile-cross-config-build)
        list(APPEND RunCMake_TEST_OPTIONS -DCMAKE_CROSS_CONFIGS=all)
        set(RunCMake_TEST_VARIANT_DESCRIPTION "-CMAKE_CROSS_CONFIGS-all")
        run_cmake(MocGeneratedFile)
        set(RunCMake_TEST_NO_CLEAN 1)
        set(RunCMake_TEST_VARIANT_DESCRIPTION "-Release")
        run_cmake_command(MocGeneratedFile-cross-config-build ${CMAKE_COMMAND} --build . --config Release --target libgen:Debug)
        set(RunCMake_TEST_VARIANT_DESCRIPTION "-Debug")
        run_cmake_command(MocGeneratedFile-cross-config-build ${CMAKE_COMMAND} --build . --config Debug --target libgen:Release)
        unset(RunCMake_TEST_VARIANT_DESCRIPTION)
      endblock()
    endif()
  endif()
  block()
    foreach(LIB_LINK_COUNT RANGE 1 4)
      set(RunCMake_TEST_VARIANT_DESCRIPTION "-link-count-${LIB_LINK_COUNT}")
      set(RunCMake_TEST_BINARY_DIR
        "${RunCMake_BINARY_DIR}/AutogenDuplicateDependency-build-${LIB_LINK_COUNT}")
      run_cmake_with_options(AutogenDuplicateDependency ${RunCMake_TEST_OPTIONS} -DLIB_LINK_COUNT=${LIB_LINK_COUNT})
      set(RunCMake_TEST_NO_CLEAN 1)
      set(RunCMake-check-file "check-fancy-generated.cmake")
      run_cmake_command("AutogenDuplicateDependency-build"
        ${CMAKE_COMMAND} --build . --target App_autogen --verbose)
      unset(RunCMake_TEST_VARIANT_DESCRIPTION)
      unset(RunCMake-check-file)
      unset(RunCMake_TEST_NO_CLEAN)
    endforeach()
  endblock()
endif ()
