include(RunCMake)

function(run_cmake_build name verifyType target)
  if(NOT BUILD_CONFIG)
    set(BUILD_CONFIG Debug)
  endif()
  set(RunCMake_TEST_BINARY_DIR ${RunCMake_BINARY_DIR}/${name}-build)
  set(RunCMake_TEST_NO_CLEAN 1)
  run_cmake_command(${name}-${target}-${BUILD_CONFIG}-build
    ${CMAKE_COMMAND} --build . --config ${BUILD_CONFIG} --target ${target}_verify_${verifyType}_header_sets
  )
endfunction()

set(RunCMake_TEST_OPTIONS -DCMAKE_VERIFY_INTERFACE_HEADER_SETS=ON)
if(NOT RunCMake_GENERATOR_IS_MULTI_CONFIG)
  list(APPEND RunCMake_TEST_OPTIONS -DCMAKE_BUILD_TYPE=Debug)
endif()
run_cmake(VerifyInterfaceHeaderSets)
unset(RunCMake_TEST_OPTIONS)

run_cmake_build(VerifyInterfaceHeaderSets interface static)
run_cmake_build(VerifyInterfaceHeaderSets interface shared)
run_cmake_build(VerifyInterfaceHeaderSets interface object)
run_cmake_build(VerifyInterfaceHeaderSets interface interface)
run_cmake_build(VerifyInterfaceHeaderSets interface exe)
run_cmake_build(VerifyInterfaceHeaderSets interface export_exe)
run_cmake_build(VerifyInterfaceHeaderSets interface none)
run_cmake_build(VerifyInterfaceHeaderSets interface property_off)
run_cmake_build(VerifyInterfaceHeaderSets interface private)
run_cmake_build(VerifyInterfaceHeaderSets interface a_h)
run_cmake_build(VerifyInterfaceHeaderSets interface dir_c_h)
run_cmake_build(VerifyInterfaceHeaderSets interface dir_cxx_h)

if(NOT RunCMake_GENERATOR STREQUAL "Xcode")
  run_cmake_build(VerifyInterfaceHeaderSets interface config)
  if(RunCMake_GENERATOR_IS_MULTI_CONFIG)
    set(BUILD_CONFIG Release)
    run_cmake_build(VerifyInterfaceHeaderSets interface config)
    unset(BUILD_CONFIG)
  endif()
endif()

run_cmake_build(VerifyInterfaceHeaderSets interface lang_test_c)
run_cmake_build(VerifyInterfaceHeaderSets interface lang_test_cxx)
run_cmake_build(VerifyInterfaceHeaderSets interface iface_lang_cxx)
run_cmake_build(VerifyInterfaceHeaderSets interface list)
run_cmake_build(VerifyInterfaceHeaderSets interface skip_linting)

set(RunCMake_TEST_OPTIONS -DCMAKE_VERIFY_INTERFACE_HEADER_SETS=ON)
run_cmake(AllVerifyInterfaceHeaderSets)
unset(RunCMake_TEST_OPTIONS)

run_cmake_build(AllVerifyInterfaceHeaderSets interface all)

set(RunCMake_TEST_OPTIONS -DCMAKE_VERIFY_INTERFACE_HEADER_SETS=ON)
run_cmake(VerifyInterfaceHeaderSetsNonexistent)
unset(RunCMake_TEST_OPTIONS)

run_cmake(VerifyInterfaceHeaderSets-CMP0209-NEW)
run_cmake(VerifyInterfaceHeaderSets-CMP0209-OLD)
run_cmake(VerifyInterfaceHeaderSets-CMP0209-WARN)

set(RunCMake_TEST_OPTIONS -DCMAKE_VERIFY_PRIVATE_HEADER_SETS=ON)
if(NOT RunCMake_GENERATOR_IS_MULTI_CONFIG)
  list(APPEND RunCMake_TEST_OPTIONS -DCMAKE_BUILD_TYPE=Debug)
endif()
run_cmake(VerifyPrivateHeaderSets)
unset(RunCMake_TEST_OPTIONS)

run_cmake_build(VerifyPrivateHeaderSets private static)
run_cmake_build(VerifyPrivateHeaderSets private shared)
run_cmake_build(VerifyPrivateHeaderSets private object)
run_cmake_build(VerifyPrivateHeaderSets private interface)
run_cmake_build(VerifyPrivateHeaderSets private iface_private)
run_cmake_build(VerifyPrivateHeaderSets private exe)
run_cmake_build(VerifyPrivateHeaderSets private none)
run_cmake_build(VerifyPrivateHeaderSets private property_off)
run_cmake_build(VerifyPrivateHeaderSets private a_h)
run_cmake_build(VerifyPrivateHeaderSets private dir_c_h)
run_cmake_build(VerifyPrivateHeaderSets private dir_cxx_h)

if(NOT RunCMake_GENERATOR STREQUAL "Xcode")
  run_cmake_build(VerifyPrivateHeaderSets private config)
  if(RunCMake_GENERATOR_IS_MULTI_CONFIG)
    set(BUILD_CONFIG Release)
    run_cmake_build(VerifyPrivateHeaderSets private config)
    unset(BUILD_CONFIG)
  endif()
endif()

run_cmake_build(VerifyPrivateHeaderSets private lang_test_c)
run_cmake_build(VerifyPrivateHeaderSets private lang_test_cxx)
run_cmake_build(VerifyPrivateHeaderSets private iface_lang_cxx)
run_cmake_build(VerifyPrivateHeaderSets private list)
run_cmake_build(VerifyPrivateHeaderSets private skip_linting)

set(RunCMake_TEST_OPTIONS -DCMAKE_VERIFY_PRIVATE_HEADER_SETS=ON)
run_cmake(AllVerifyPrivateHeaderSets)
unset(RunCMake_TEST_OPTIONS)

run_cmake_build(AllVerifyPrivateHeaderSets private all)

set(RunCMake_TEST_OPTIONS -DCMAKE_VERIFY_PRIVATE_HEADER_SETS=ON)
run_cmake(VerifyPrivateHeaderSetsNonexistent)
unset(RunCMake_TEST_OPTIONS)
