// Copyright (c) 2003  INRIA Sophia-Antipolis (France).
// All rights reserved.
//
// This file is part of CGAL (www.cgal.org)
//
// $URL: https://github.com/CGAL/cgal/blob/v6.0.3/Intersections_3/include/CGAL/Intersections_3/internal/Plane_3_Triangle_3_do_intersect.h $
// $Id: include/CGAL/Intersections_3/internal/Plane_3_Triangle_3_do_intersect.h cefe3007d59 $
// SPDX-License-Identifier: LGPL-3.0-or-later OR LicenseRef-Commercial
//
//
// Author(s)     : Philippe Guigue

#ifndef CGAL_INTERNAL_INTERSECTIONS_PLANE_3_TRIANGLE_3_DO_INTERSECT_H
#define CGAL_INTERNAL_INTERSECTIONS_PLANE_3_TRIANGLE_3_DO_INTERSECT_H

#include <CGAL/enum.h>
#include <CGAL/kernel_assertions.h>

namespace CGAL {
namespace Intersections {
namespace internal {

template <class K>
typename K::Boolean
do_intersect(const typename K::Triangle_3& t,
             const typename K::Plane_3& h,
             const K& k)
{
  CGAL_kernel_precondition(!k.is_degenerate_3_object()(t));
  CGAL_kernel_precondition(!k.is_degenerate_3_object()(h));

  typename K::Construct_vertex_3 vertex_on = k.construct_vertex_3_object();
  typename K::Oriented_side_3 oriented_side = k.oriented_side_3_object();

  switch(oriented_side(h,vertex_on(t,0)))
  {
  case ON_POSITIVE_SIDE:
    return (oriented_side(h,vertex_on(t,1)) != ON_POSITIVE_SIDE) ||
           (oriented_side(h,vertex_on(t,2)) != ON_POSITIVE_SIDE);
  case ON_NEGATIVE_SIDE:
    return (oriented_side(h,vertex_on(t,1)) != ON_NEGATIVE_SIDE) ||
           (oriented_side(h,vertex_on(t,2)) != ON_NEGATIVE_SIDE);
  case ON_ORIENTED_BOUNDARY:
    return true;
  default:// should not happen.
    CGAL_kernel_assertion(false);
    return false;
  }
}

template <class K>
inline
typename K::Boolean
do_intersect(const typename K::Plane_3& h,
             const typename K::Triangle_3& t,
             const K& k)
{
  return do_intersect(t, h, k);
}

} // namespace internal
} // namespace Intersections
} // namespace CGAL

#endif // CGAL_INTERNAL_INTERSECTIONS_PLANE_3_TRIANGLE_3_DO_INTERSECT_H
