
///////////////////////////////////////////////////////////
//                                                       //
//                         SAGA                          //
//                                                       //
//      System for Automated Geoscientific Analyses      //
//                                                       //
//                     Tool Library                      //
//                    io_webservices                     //
//                                                       //
//-------------------------------------------------------//
//                                                       //
//                   opendata_dgm1.h                     //
//                                                       //
//                 Copyrights (C) 2025                   //
//                     Olaf Conrad                       //
//                                                       //
//-------------------------------------------------------//
//                                                       //
// This file is part of 'SAGA - System for Automated     //
// Geoscientific Analyses'. SAGA is free software; you   //
// can redistribute it and/or modify it under the terms  //
// of the GNU General Public License as published by the //
// Free Software Foundation, either version 2 of the     //
// License, or (at your option) any later version.       //
//                                                       //
// SAGA is distributed in the hope that it will be       //
// useful, but WITHOUT ANY WARRANTY; without even the    //
// implied warranty of MERCHANTABILITY or FITNESS FOR A  //
// PARTICULAR PURPOSE. See the GNU General Public        //
// License for more details.                             //
//                                                       //
// You should have received a copy of the GNU General    //
// Public License along with this program; if not, see   //
// <http://www.gnu.org/licenses/>.                       //
//                                                       //
//-------------------------------------------------------//
//                                                       //
//    e-mail:     oconrad@saga-gis.org                   //
//                                                       //
//    contact:    Olaf Conrad                            //
//                Institute of Geography                 //
//                University of Hamburg                  //
//                Germany                                //
//                                                       //
///////////////////////////////////////////////////////////

//---------------------------------------------------------
#ifndef HEADER_INCLUDED__opendata_dgm1_H
#define HEADER_INCLUDED__opendata_dgm1_H


///////////////////////////////////////////////////////////
//                                                       //
//                                                       //
//                                                       //
///////////////////////////////////////////////////////////

//---------------------------------------------------------
#include "sg_curl.h"


///////////////////////////////////////////////////////////
//                                                       //
//                                                       //
//                                                       //
///////////////////////////////////////////////////////////

//---------------------------------------------------------
class COpenData_DGM1 : public CSG_Tool
{
public:
	COpenData_DGM1(void);

	virtual CSG_String			Get_MenuPath			(void)	{	return( "DGM1 Germany" );	}

//	virtual bool				do_Sync_Projections		(void)	const	{	return( false  );	}

	virtual bool				On_Before_Execution		(void);
	virtual bool				On_After_Execution		(void);


protected:

	int							m_Tile_Size = 1;

	CSG_String					m_ServerPath, m_VRT_Name = "dgm1", m_Name = "DGM1", m_Extension = "tif";


	virtual int                 On_Parameter_Changed	(CSG_Parameters *pParameters, CSG_Parameter *pParameter);
	virtual int					On_Parameters_Enable	(CSG_Parameters *pParameters, CSG_Parameter *pParameter);

	virtual bool				On_Execute				(void);

	bool						Show_Error				(const CSG_String &Message);

	bool						Set_Data_CRS			(int EPSG);
	bool						Set_Default_Extent		(double xMin, double yMin, double xMax, double yMax, double Cellsize = 1.);

	virtual CSG_String			Get_Tile_Name			(int Col, int Row) = 0;
	virtual CSG_String			Get_Tile_Request		(int Col, int Row) { return( Get_Tile_Name(Col, Row) ); }

	virtual int					Provide_Tile			(const CSG_String &Directory, int Col, int Row);
	virtual int					Provide_Tile			(const CSG_String &Directory, const CSG_String &Tile, const CSG_String &Request);

	virtual bool				On_Provide_Tile			(const CSG_String &File) { return( true ); }


private:

	int							m_EPSG = 25832;

	CSG_Parameters_CRSPicker	m_CRS;


	bool						Provide_Tiles			(const CSG_String &Directory, CSG_Rect Extent);

	bool						Update_VRT				(const CSG_String &Directory);

};


///////////////////////////////////////////////////////////
//                                                       //
///////////////////////////////////////////////////////////

//---------------------------------------------------------
class COpenData_DGM1_Bayern : public COpenData_DGM1
{
public:
	COpenData_DGM1_Bayern(void);


protected:

	virtual CSG_String			Get_Tile_Name			(int Col, int Row);

};


///////////////////////////////////////////////////////////
//                                                       //
///////////////////////////////////////////////////////////

//---------------------------------------------------------
class COpenData_DGM1_RLP : public COpenData_DGM1
{
public:
	COpenData_DGM1_RLP(void);


protected:

	virtual CSG_String			Get_Tile_Name			(int Col, int Row);

};


///////////////////////////////////////////////////////////
//                                                       //
///////////////////////////////////////////////////////////

//---------------------------------------------------------
class COpenData_DGM1_NRW : public COpenData_DGM1
{
public:
	COpenData_DGM1_NRW(void);


protected:

	virtual bool				On_Execute				(void);

	virtual CSG_String			Get_Tile_Name			(int Col, int Row);

	virtual int					Provide_Tile			(const CSG_String &Directory, int Col, int Row);

};


///////////////////////////////////////////////////////////
//                                                       //
///////////////////////////////////////////////////////////

//---------------------------------------------------------
class COpenData_DGM1_MV : public COpenData_DGM1
{
public:
	COpenData_DGM1_MV(void);


protected:

	virtual CSG_String			Get_Tile_Name			(int Col, int Row);
	virtual CSG_String			Get_Tile_Request		(int Col, int Row);

};


///////////////////////////////////////////////////////////
//                                                       //
///////////////////////////////////////////////////////////

//---------------------------------------------------------
class COpenData_DGM1_NI : public COpenData_DGM1
{
public:
	COpenData_DGM1_NI(void);


protected:

	virtual bool				On_Execute				(void);

	virtual CSG_String			Get_Tile_Name			(int Col, int Row);
	virtual CSG_String			Get_Tile_Request		(int Col, int Row);


	typedef struct STiles { int id; const char *date; } TTiles;

	TTiles *					Get_Tiles				(void) const;

};


///////////////////////////////////////////////////////////
//                                                       //
///////////////////////////////////////////////////////////

//---------------------------------------------------------
class COpenData_DGM1_SH : public COpenData_DGM1
{
public:
	COpenData_DGM1_SH(void);


protected:

	virtual bool				On_Execute				(void);

	virtual CSG_String			Get_Tile_Name			(int Col, int Row);
	virtual CSG_String			Get_Tile_Request		(int Col, int Row);


	typedef struct STiles { int id; const char *file; } TTiles;

	TTiles *					Get_Tiles				(int DataSet) const;

};


///////////////////////////////////////////////////////////
//                                                       //
///////////////////////////////////////////////////////////

//---------------------------------------------------------
class COpenData_DGM1_Sachsen : public COpenData_DGM1
{
public:
	COpenData_DGM1_Sachsen(void);


protected:

	virtual bool				On_Execute				(void);

	virtual CSG_String			Get_Tile_Name			(int Col, int Row);
	virtual CSG_String			Get_Tile_Request		(int Col, int Row);

};


///////////////////////////////////////////////////////////
//                                                       //
///////////////////////////////////////////////////////////

//---------------------------------------------------------
class COpenData_DGM1_Thuringia : public COpenData_DGM1
{
public:
	COpenData_DGM1_Thuringia(void);


protected:

	virtual bool				On_Execute				(void);

	virtual CSG_String			Get_Tile_Name			(int Col, int Row);

};


///////////////////////////////////////////////////////////
//                                                       //
///////////////////////////////////////////////////////////

//---------------------------------------------------------
class COpenData_DGM1_Brandenburg : public COpenData_DGM1
{
public:
	COpenData_DGM1_Brandenburg(void);


protected:

	virtual bool				On_Execute				(void);

	virtual CSG_String			Get_Tile_Name			(int Col, int Row);

	virtual bool				On_Provide_Tile			(const CSG_String &File);

};


///////////////////////////////////////////////////////////
//                                                       //
//                                                       //
//                                                       //
///////////////////////////////////////////////////////////

//---------------------------------------------------------
#endif // #ifndef HEADER_INCLUDED__opendata_dgm1_H
