// NOTE: File has been autogenerated by utils/aarch64_builtins_test_generator.py
// RUN: %clang_cc1 %s -fsyntax-only -triple aarch64-none-linux-gnu -target-feature +fp8 -target-feature +sme -target-feature +sve -target-feature +sve2 -verify=guard
// RUN: %clang_cc1 %s -fsyntax-only -triple aarch64-none-linux-gnu -target-feature +fp8 -target-feature +sme -target-feature +sme2 -target-feature +sve -verify
// expected-no-diagnostics

// REQUIRES: aarch64-registered-target

#include <arm_sve.h>

// Properties: guard="sve,(sve2|sme2),fp8" streaming_guard="sme,sme2,fp8" flags="feature-dependent"

void test(void) {
  fpm_t fpm_t_val;
  svbfloat16x2_t svbfloat16x2_t_val;
  svfloat16x2_t svfloat16x2_t_val;
  svfloat32x2_t svfloat32x2_t_val;
  svmfloat8_t svmfloat8_t_val;

  svcvt1_bf16_fpm(svmfloat8_t_val, fpm_t_val);
  svcvt1_bf16_mf8_fpm(svmfloat8_t_val, fpm_t_val);
  svcvt1_f16_fpm(svmfloat8_t_val, fpm_t_val);
  svcvt1_f16_mf8_fpm(svmfloat8_t_val, fpm_t_val);
  svcvt2_bf16_fpm(svmfloat8_t_val, fpm_t_val);
  svcvt2_bf16_mf8_fpm(svmfloat8_t_val, fpm_t_val);
  svcvt2_f16_fpm(svmfloat8_t_val, fpm_t_val);
  svcvt2_f16_mf8_fpm(svmfloat8_t_val, fpm_t_val);
  svcvtlt1_bf16_fpm(svmfloat8_t_val, fpm_t_val);
  svcvtlt1_bf16_mf8_fpm(svmfloat8_t_val, fpm_t_val);
  svcvtlt1_f16_fpm(svmfloat8_t_val, fpm_t_val);
  svcvtlt1_f16_mf8_fpm(svmfloat8_t_val, fpm_t_val);
  svcvtlt2_bf16_fpm(svmfloat8_t_val, fpm_t_val);
  svcvtlt2_bf16_mf8_fpm(svmfloat8_t_val, fpm_t_val);
  svcvtlt2_f16_fpm(svmfloat8_t_val, fpm_t_val);
  svcvtlt2_f16_mf8_fpm(svmfloat8_t_val, fpm_t_val);
  svcvtn_mf8_bf16_x2_fpm(svbfloat16x2_t_val, fpm_t_val);
  svcvtn_mf8_f16_x2_fpm(svfloat16x2_t_val, fpm_t_val);
  svcvtn_mf8_fpm(svbfloat16x2_t_val, fpm_t_val);
  svcvtn_mf8_fpm(svfloat16x2_t_val, fpm_t_val);
  svcvtnb_mf8_f32_x2_fpm(svfloat32x2_t_val, fpm_t_val);
  svcvtnb_mf8_fpm(svfloat32x2_t_val, fpm_t_val);
  svcvtnt_mf8_f32_x2_fpm(svmfloat8_t_val, svfloat32x2_t_val, fpm_t_val);
  svcvtnt_mf8_fpm(svmfloat8_t_val, svfloat32x2_t_val, fpm_t_val);
}

void test_streaming(void) __arm_streaming{
  fpm_t fpm_t_val;
  svbfloat16x2_t svbfloat16x2_t_val;
  svfloat16x2_t svfloat16x2_t_val;
  svfloat32x2_t svfloat32x2_t_val;
  svmfloat8_t svmfloat8_t_val;

  // guard-error@+1 {{builtin can only be called from a non-streaming function}}
  svcvt1_bf16_fpm(svmfloat8_t_val, fpm_t_val);
  // guard-error@+1 {{builtin can only be called from a non-streaming function}}
  svcvt1_bf16_mf8_fpm(svmfloat8_t_val, fpm_t_val);
  // guard-error@+1 {{builtin can only be called from a non-streaming function}}
  svcvt1_f16_fpm(svmfloat8_t_val, fpm_t_val);
  // guard-error@+1 {{builtin can only be called from a non-streaming function}}
  svcvt1_f16_mf8_fpm(svmfloat8_t_val, fpm_t_val);
  // guard-error@+1 {{builtin can only be called from a non-streaming function}}
  svcvt2_bf16_fpm(svmfloat8_t_val, fpm_t_val);
  // guard-error@+1 {{builtin can only be called from a non-streaming function}}
  svcvt2_bf16_mf8_fpm(svmfloat8_t_val, fpm_t_val);
  // guard-error@+1 {{builtin can only be called from a non-streaming function}}
  svcvt2_f16_fpm(svmfloat8_t_val, fpm_t_val);
  // guard-error@+1 {{builtin can only be called from a non-streaming function}}
  svcvt2_f16_mf8_fpm(svmfloat8_t_val, fpm_t_val);
  // guard-error@+1 {{builtin can only be called from a non-streaming function}}
  svcvtlt1_bf16_fpm(svmfloat8_t_val, fpm_t_val);
  // guard-error@+1 {{builtin can only be called from a non-streaming function}}
  svcvtlt1_bf16_mf8_fpm(svmfloat8_t_val, fpm_t_val);
  // guard-error@+1 {{builtin can only be called from a non-streaming function}}
  svcvtlt1_f16_fpm(svmfloat8_t_val, fpm_t_val);
  // guard-error@+1 {{builtin can only be called from a non-streaming function}}
  svcvtlt1_f16_mf8_fpm(svmfloat8_t_val, fpm_t_val);
  // guard-error@+1 {{builtin can only be called from a non-streaming function}}
  svcvtlt2_bf16_fpm(svmfloat8_t_val, fpm_t_val);
  // guard-error@+1 {{builtin can only be called from a non-streaming function}}
  svcvtlt2_bf16_mf8_fpm(svmfloat8_t_val, fpm_t_val);
  // guard-error@+1 {{builtin can only be called from a non-streaming function}}
  svcvtlt2_f16_fpm(svmfloat8_t_val, fpm_t_val);
  // guard-error@+1 {{builtin can only be called from a non-streaming function}}
  svcvtlt2_f16_mf8_fpm(svmfloat8_t_val, fpm_t_val);
  // guard-error@+1 {{builtin can only be called from a non-streaming function}}
  svcvtn_mf8_bf16_x2_fpm(svbfloat16x2_t_val, fpm_t_val);
  // guard-error@+1 {{builtin can only be called from a non-streaming function}}
  svcvtn_mf8_f16_x2_fpm(svfloat16x2_t_val, fpm_t_val);
  // guard-error@+1 {{builtin can only be called from a non-streaming function}}
  svcvtn_mf8_fpm(svbfloat16x2_t_val, fpm_t_val);
  // guard-error@+1 {{builtin can only be called from a non-streaming function}}
  svcvtn_mf8_fpm(svfloat16x2_t_val, fpm_t_val);
  // guard-error@+1 {{builtin can only be called from a non-streaming function}}
  svcvtnb_mf8_f32_x2_fpm(svfloat32x2_t_val, fpm_t_val);
  // guard-error@+1 {{builtin can only be called from a non-streaming function}}
  svcvtnb_mf8_fpm(svfloat32x2_t_val, fpm_t_val);
  // guard-error@+1 {{builtin can only be called from a non-streaming function}}
  svcvtnt_mf8_f32_x2_fpm(svmfloat8_t_val, svfloat32x2_t_val, fpm_t_val);
  // guard-error@+1 {{builtin can only be called from a non-streaming function}}
  svcvtnt_mf8_fpm(svmfloat8_t_val, svfloat32x2_t_val, fpm_t_val);
}

void test_streaming_compatible(void) __arm_streaming_compatible{
  fpm_t fpm_t_val;
  svbfloat16x2_t svbfloat16x2_t_val;
  svfloat16x2_t svfloat16x2_t_val;
  svfloat32x2_t svfloat32x2_t_val;
  svmfloat8_t svmfloat8_t_val;

  // guard-error@+1 {{builtin can only be called from a non-streaming function}}
  svcvt1_bf16_fpm(svmfloat8_t_val, fpm_t_val);
  // guard-error@+1 {{builtin can only be called from a non-streaming function}}
  svcvt1_bf16_mf8_fpm(svmfloat8_t_val, fpm_t_val);
  // guard-error@+1 {{builtin can only be called from a non-streaming function}}
  svcvt1_f16_fpm(svmfloat8_t_val, fpm_t_val);
  // guard-error@+1 {{builtin can only be called from a non-streaming function}}
  svcvt1_f16_mf8_fpm(svmfloat8_t_val, fpm_t_val);
  // guard-error@+1 {{builtin can only be called from a non-streaming function}}
  svcvt2_bf16_fpm(svmfloat8_t_val, fpm_t_val);
  // guard-error@+1 {{builtin can only be called from a non-streaming function}}
  svcvt2_bf16_mf8_fpm(svmfloat8_t_val, fpm_t_val);
  // guard-error@+1 {{builtin can only be called from a non-streaming function}}
  svcvt2_f16_fpm(svmfloat8_t_val, fpm_t_val);
  // guard-error@+1 {{builtin can only be called from a non-streaming function}}
  svcvt2_f16_mf8_fpm(svmfloat8_t_val, fpm_t_val);
  // guard-error@+1 {{builtin can only be called from a non-streaming function}}
  svcvtlt1_bf16_fpm(svmfloat8_t_val, fpm_t_val);
  // guard-error@+1 {{builtin can only be called from a non-streaming function}}
  svcvtlt1_bf16_mf8_fpm(svmfloat8_t_val, fpm_t_val);
  // guard-error@+1 {{builtin can only be called from a non-streaming function}}
  svcvtlt1_f16_fpm(svmfloat8_t_val, fpm_t_val);
  // guard-error@+1 {{builtin can only be called from a non-streaming function}}
  svcvtlt1_f16_mf8_fpm(svmfloat8_t_val, fpm_t_val);
  // guard-error@+1 {{builtin can only be called from a non-streaming function}}
  svcvtlt2_bf16_fpm(svmfloat8_t_val, fpm_t_val);
  // guard-error@+1 {{builtin can only be called from a non-streaming function}}
  svcvtlt2_bf16_mf8_fpm(svmfloat8_t_val, fpm_t_val);
  // guard-error@+1 {{builtin can only be called from a non-streaming function}}
  svcvtlt2_f16_fpm(svmfloat8_t_val, fpm_t_val);
  // guard-error@+1 {{builtin can only be called from a non-streaming function}}
  svcvtlt2_f16_mf8_fpm(svmfloat8_t_val, fpm_t_val);
  // guard-error@+1 {{builtin can only be called from a non-streaming function}}
  svcvtn_mf8_bf16_x2_fpm(svbfloat16x2_t_val, fpm_t_val);
  // guard-error@+1 {{builtin can only be called from a non-streaming function}}
  svcvtn_mf8_f16_x2_fpm(svfloat16x2_t_val, fpm_t_val);
  // guard-error@+1 {{builtin can only be called from a non-streaming function}}
  svcvtn_mf8_fpm(svbfloat16x2_t_val, fpm_t_val);
  // guard-error@+1 {{builtin can only be called from a non-streaming function}}
  svcvtn_mf8_fpm(svfloat16x2_t_val, fpm_t_val);
  // guard-error@+1 {{builtin can only be called from a non-streaming function}}
  svcvtnb_mf8_f32_x2_fpm(svfloat32x2_t_val, fpm_t_val);
  // guard-error@+1 {{builtin can only be called from a non-streaming function}}
  svcvtnb_mf8_fpm(svfloat32x2_t_val, fpm_t_val);
  // guard-error@+1 {{builtin can only be called from a non-streaming function}}
  svcvtnt_mf8_f32_x2_fpm(svmfloat8_t_val, svfloat32x2_t_val, fpm_t_val);
  // guard-error@+1 {{builtin can only be called from a non-streaming function}}
  svcvtnt_mf8_fpm(svmfloat8_t_val, svfloat32x2_t_val, fpm_t_val);
}
