// NOTE: File has been autogenerated by utils/aarch64_builtins_test_generator.py
// RUN: %clang_cc1 %s -fsyntax-only -triple aarch64-none-linux-gnu -target-feature +sme -target-feature +sve -verify=guard
// RUN: %clang_cc1 %s -fsyntax-only -triple aarch64-none-linux-gnu -target-feature +sme -target-feature +sme2p2 -target-feature +sve -verify
// expected-no-diagnostics

// REQUIRES: aarch64-registered-target

#include <arm_sve.h>

// Properties: guard="sve" streaming_guard="sme,sme2p2" flags="feature-dependent"

void test(void) {
  svbool_t svbool_t_val;
  svfloat32_t svfloat32_t_val;
  svfloat64_t svfloat64_t_val;
  svint32_t svint32_t_val;
  svint64_t svint64_t_val;
  svuint32_t svuint32_t_val;
  svuint64_t svuint64_t_val;

  svcompact(svbool_t_val, svfloat32_t_val);
  svcompact(svbool_t_val, svfloat64_t_val);
  svcompact(svbool_t_val, svint32_t_val);
  svcompact(svbool_t_val, svint64_t_val);
  svcompact(svbool_t_val, svuint32_t_val);
  svcompact(svbool_t_val, svuint64_t_val);
  svcompact_f32(svbool_t_val, svfloat32_t_val);
  svcompact_f64(svbool_t_val, svfloat64_t_val);
  svcompact_s32(svbool_t_val, svint32_t_val);
  svcompact_s64(svbool_t_val, svint64_t_val);
  svcompact_u32(svbool_t_val, svuint32_t_val);
  svcompact_u64(svbool_t_val, svuint64_t_val);
}

void test_streaming(void) __arm_streaming{
  svbool_t svbool_t_val;
  svfloat32_t svfloat32_t_val;
  svfloat64_t svfloat64_t_val;
  svint32_t svint32_t_val;
  svint64_t svint64_t_val;
  svuint32_t svuint32_t_val;
  svuint64_t svuint64_t_val;

  // guard-error@+1 {{builtin can only be called from a non-streaming function}}
  svcompact(svbool_t_val, svfloat32_t_val);
  // guard-error@+1 {{builtin can only be called from a non-streaming function}}
  svcompact(svbool_t_val, svfloat64_t_val);
  // guard-error@+1 {{builtin can only be called from a non-streaming function}}
  svcompact(svbool_t_val, svint32_t_val);
  // guard-error@+1 {{builtin can only be called from a non-streaming function}}
  svcompact(svbool_t_val, svint64_t_val);
  // guard-error@+1 {{builtin can only be called from a non-streaming function}}
  svcompact(svbool_t_val, svuint32_t_val);
  // guard-error@+1 {{builtin can only be called from a non-streaming function}}
  svcompact(svbool_t_val, svuint64_t_val);
  // guard-error@+1 {{builtin can only be called from a non-streaming function}}
  svcompact_f32(svbool_t_val, svfloat32_t_val);
  // guard-error@+1 {{builtin can only be called from a non-streaming function}}
  svcompact_f64(svbool_t_val, svfloat64_t_val);
  // guard-error@+1 {{builtin can only be called from a non-streaming function}}
  svcompact_s32(svbool_t_val, svint32_t_val);
  // guard-error@+1 {{builtin can only be called from a non-streaming function}}
  svcompact_s64(svbool_t_val, svint64_t_val);
  // guard-error@+1 {{builtin can only be called from a non-streaming function}}
  svcompact_u32(svbool_t_val, svuint32_t_val);
  // guard-error@+1 {{builtin can only be called from a non-streaming function}}
  svcompact_u64(svbool_t_val, svuint64_t_val);
}

void test_streaming_compatible(void) __arm_streaming_compatible{
  svbool_t svbool_t_val;
  svfloat32_t svfloat32_t_val;
  svfloat64_t svfloat64_t_val;
  svint32_t svint32_t_val;
  svint64_t svint64_t_val;
  svuint32_t svuint32_t_val;
  svuint64_t svuint64_t_val;

  // guard-error@+1 {{builtin can only be called from a non-streaming function}}
  svcompact(svbool_t_val, svfloat32_t_val);
  // guard-error@+1 {{builtin can only be called from a non-streaming function}}
  svcompact(svbool_t_val, svfloat64_t_val);
  // guard-error@+1 {{builtin can only be called from a non-streaming function}}
  svcompact(svbool_t_val, svint32_t_val);
  // guard-error@+1 {{builtin can only be called from a non-streaming function}}
  svcompact(svbool_t_val, svint64_t_val);
  // guard-error@+1 {{builtin can only be called from a non-streaming function}}
  svcompact(svbool_t_val, svuint32_t_val);
  // guard-error@+1 {{builtin can only be called from a non-streaming function}}
  svcompact(svbool_t_val, svuint64_t_val);
  // guard-error@+1 {{builtin can only be called from a non-streaming function}}
  svcompact_f32(svbool_t_val, svfloat32_t_val);
  // guard-error@+1 {{builtin can only be called from a non-streaming function}}
  svcompact_f64(svbool_t_val, svfloat64_t_val);
  // guard-error@+1 {{builtin can only be called from a non-streaming function}}
  svcompact_s32(svbool_t_val, svint32_t_val);
  // guard-error@+1 {{builtin can only be called from a non-streaming function}}
  svcompact_s64(svbool_t_val, svint64_t_val);
  // guard-error@+1 {{builtin can only be called from a non-streaming function}}
  svcompact_u32(svbool_t_val, svuint32_t_val);
  // guard-error@+1 {{builtin can only be called from a non-streaming function}}
  svcompact_u64(svbool_t_val, svuint64_t_val);
}
