$NetBSD$

* Part of patchset to build chromium on NetBSD
* Based on OpenBSD's chromium patches, and
  pkgsrc's qt5-qtwebengine patches

--- base/files/dir_reader_linux.h.orig	2026-02-03 22:07:10.000000000 +0000
+++ base/files/dir_reader_linux.h
@@ -19,10 +19,16 @@
 #include "base/logging.h"
 #include "base/posix/eintr_wrapper.h"
 
+#include "build/build_config.h"
+
 // See the comments in dir_reader_posix.h about this.
 
 namespace base {
 
+#if BUILDFLAG(IS_BSD)
+#include <dirent.h>
+typedef struct dirent linux_dirent;
+#else
 struct linux_dirent {
   uint64_t d_ino;
   int64_t d_off;
@@ -30,6 +36,7 @@ struct linux_dirent {
   unsigned char d_type;
   char d_name[0];
 };
+#endif
 
 class DirReaderLinux {
  public:
@@ -61,7 +68,11 @@ class DirReaderLinux {
       return true;
     }
 
+#if BUILDFLAG(IS_BSD)
+    const int r = getdents(fd_, reinterpret_cast<char *>(buf_.data()), buf_.size());
+#else
     const long r = syscall(__NR_getdents64, fd_, buf_.data(), buf_.size());
+#endif
     if (r == 0) {
       return false;
     }
