$NetBSD$

Add NetBSD support.

--- pkg/browsers/basedir_netbsd.go.orig	2025-12-20 21:20:16.771439541 +0000
+++ pkg/browsers/basedir_netbsd.go
@@ -0,0 +1,42 @@
+//
+//  Copyright (c) 2025 Chakib Ben Ziane <contact@blob42.xyz>  and [`gosuki` contributors](https://github.com/blob42/gosuki/graphs/contributors).
+//  All rights reserved.
+//
+//  SPDX-License-Identifier: AGPL-3.0-or-later
+//
+//  This file is part of GoSuki.
+//
+//  GoSuki is free software: you can redistribute it and/or modify
+//  it under the terms of the GNU Affero General Public License as
+//  published by the Free Software Foundation, either version 3 of the
+//  License, or (at your option) any later version.
+//
+//  GoSuki is distributed in the hope that it will be useful,
+//  but WITHOUT ANY WARRANTY; without even the implied warranty of
+//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
+//  GNU Affero General Public License for more details.
+//
+//  You should have received a copy of the GNU Affero General Public License
+//  along with gosuki.  If not, see <http://www.gnu.org/licenses/>.
+//
+
+//go:build netbsd
+
+package browsers
+
+import (
+	"github.com/blob42/gosuki/internal/utils"
+	"github.com/blob42/gosuki/pkg/logging"
+)
+
+var log = logging.GetLogger("browsers")
+
+// base directory without normalization
+func (b BrowserDef) GetBaseDir() string {
+	return b.BaseDir
+}
+
+// Expands to the full path of base directory
+func (b BrowserDef) ExpandBaseDir() (string, error) {
+	return utils.ExpandPath(b.BaseDir)
+}
