$NetBSD$

Use index_modules() instead of pickup up modules in ${PWD} (and mostly likely
failing).

Patch shared upstream via:

 <https://github.com/threat9/routersploit/pull/578>

--- routersploit/core/exploit/shell.py.orig	2018-10-17 17:30:53.000000000 +0000
+++ routersploit/core/exploit/shell.py
@@ -4,8 +4,6 @@ import binascii
 from http.server import BaseHTTPRequestHandler, HTTPServer
 import threading
 import time
-from os import listdir
-from os.path import isfile, join
 import importlib
 
 from routersploit.core.exploit.printer import (
@@ -18,6 +16,7 @@ from routersploit.core.exploit.printer i
 )
 
 from routersploit.core.exploit.utils import (
+    index_modules,
     random_text,
 )
 
@@ -28,14 +27,11 @@ def shell(exploit, architecture="", meth
     options = []
 
     if architecture and method:
-        path = "routersploit/modules/payloads/{}/".format(architecture)
-
         # get all payloads for given architecture
-        all_payloads = [f.split(".")[0] for f in listdir(path) if isfile(join(path, f)) and f.endswith(".py") and f != "__init__.py"]
+        all_payloads = [p.lstrip('payloads.').replace('.', '/') for p in index_modules() if "payloads.{}".format(architecture) in p]
 
-        payload_path = path.replace("/", ".")
         for p in all_payloads:
-            module = getattr(importlib.import_module("{}{}".format(payload_path, p)), 'Payload')
+            module = getattr(importlib.import_module('routersploit.modules.payloads.' + p.replace('/', '.')), 'Payload')
 
             # if method/arch is cmd then filter out payloads
             if method is "cmd":
