/* -*- c++ -*- ----------------------------------------------------------
   LAMMPS - Large-scale Atomic/Molecular Massively Parallel Simulator
   https://www.lammps.org/, Sandia National Laboratories
   LAMMPS development team: developers@lammps.org

   Copyright (2003) Sandia Corporation.  Under the terms of Contract
   DE-AC04-94AL85000 with Sandia Corporation, the U.S. Government retains
   certain rights in this software.  This software is distributed under
   the GNU General Public License.

   See the README file in the top-level LAMMPS directory.
------------------------------------------------------------------------- */

#ifdef FIX_CLASS
// clang-format off
FixStyle(eos/table/rx/kk,FixEOStableRXKokkos<LMPDeviceType>);
FixStyle(eos/table/rx/kk/device,FixEOStableRXKokkos<LMPDeviceType>);
FixStyle(eos/table/rx/kk/host,FixEOStableRXKokkos<LMPHostType>);
// clang-format on
#else

// clang-format off
#ifndef LMP_FIX_EOS_TABLE_RX_KOKKOS_H
#define LMP_FIX_EOS_TABLE_RX_KOKKOS_H

#include "fix_eos_table_rx.h"
#include "kokkos_type.h"

namespace LAMMPS_NS {

struct TagFixEOStableRXInit{};
struct TagFixEOStableRXSetup{};
struct TagFixEOStableRXTemperatureLookup{};
struct TagFixEOStableRXTemperatureLookup2{};

template<class DeviceType>
class FixEOStableRXKokkos : public FixEOStableRX {
 public:
  typedef DeviceType device_type;
  typedef ArrayTypes<DeviceType> AT;
  typedef EV_FLOAT value_type;

  FixEOStableRXKokkos(class LAMMPS *, int, char **);
  ~FixEOStableRXKokkos() override;
  void setup(int) override;
  void init() override;
  void post_integrate() override;
  void end_of_step() override;

// NOLINTNEXTLINE
  KOKKOS_INLINE_FUNCTION
  void operator()(TagFixEOStableRXInit, const int&) const;

// NOLINTNEXTLINE
  KOKKOS_INLINE_FUNCTION
  void operator()(TagFixEOStableRXSetup, const int&) const;

// NOLINTNEXTLINE
  KOKKOS_INLINE_FUNCTION
  void operator()(TagFixEOStableRXTemperatureLookup, const int&) const;

// NOLINTNEXTLINE
  KOKKOS_INLINE_FUNCTION
  void operator()(TagFixEOStableRXTemperatureLookup2, const int&) const;

// NOLINTNEXTLINE
  KOKKOS_INLINE_FUNCTION
  void energy_lookup(int, KK_FLOAT, KK_FLOAT &) const;

// NOLINTNEXTLINE
  KOKKOS_INLINE_FUNCTION
  void temperature_lookup(int, KK_FLOAT, KK_FLOAT &) const;

 protected:
  //struct Table {
  //  int ninput;
  //  KK_FLOAT lo,hi;
  //  KK_FLOAT *rfile,*efile;
  //  KK_FLOAT *e2file;
  //  KK_FLOAT delta,invdelta,deltasq6;
  //  KK_FLOAT *r,*e,*de,*e2;
  //};
  //Table *tables, *tables2;

  /*struct TableDeviceConst {
    typename AT::t_int_1d_randomread lo,hi;
    typename AT::t_kkfloat_1d_randomread invdelta;
    typename AT::t_kkfloat_2d_randomread r,e,de;
  };*/
 //Its faster not to use texture fetch if the number of tables is less than 32!
  struct TableDeviceConst {
    typename AT::t_int_1d lo,hi;
    typename AT::t_kkfloat_1d invdelta;
    typename AT::t_kkfloat_2d_randomread r,e,de;
  };

  struct TableDevice {
    typename AT::t_int_1d lo,hi;
    typename AT::t_kkfloat_1d invdelta;
    typename AT::t_kkfloat_2d r,e,de;
  };

  struct TableHost {
    HAT::t_int_1d lo,hi;
    HAT::t_kkfloat_1d invdelta;
    HAT::t_kkfloat_2d r,e,de;
  };

  TableDeviceConst d_table_const;
  TableDevice* d_table;
  TableHost* h_table;

  int **tabindex;

  double boltz;

  void allocate();
  void error_check();
  int update_table;
  void create_kokkos_tables();

  DAT::tdual_kkfloat_1d k_dHf,k_energyCorr,k_tempCorrCoeff,k_moleculeCorrCoeff;
  typename AT::t_kkfloat_1d d_dHf,d_energyCorr,d_tempCorrCoeff,d_moleculeCorrCoeff;

  typename AT::t_int_1d mask;
  typename AT::t_kkfloat_1d uCond,uMech,uChem,uCG,uCGnew,rho,dpdTheta,duChem;
  typename AT::t_kkfloat_2d dvector;

  DAT::tdual_int_scalar k_error_flag;
  DAT::tdual_int_scalar k_warning_flag;

  int pack_reverse_comm(int, int, double *) override;
  void unpack_reverse_comm(int, int *, double *) override;
  int pack_forward_comm(int , int *, double *, int, int *) override;
  void unpack_forward_comm(int , int , double *) override;

  };
}

#endif
#endif

