/* File generated automatically from tools/winapi/tests.dat; do not edit! */
/* This file can be copied, modified and distributed without restriction. */

/*
 * Unit tests for data structure packing
 */

#define WINE_NOWINSOCK

#include "windows.h"

#include "wine/test.h"

/***********************************************************************
 * Compatibility macros
 */

#define DWORD_PTR UINT_PTR
#define LONG_PTR INT_PTR
#define ULONG_PTR UINT_PTR

/***********************************************************************
 * Windows API extension
 */

#if defined(_MSC_VER) && (_MSC_VER >= 1300) && defined(__cplusplus)
# define _TYPE_ALIGNMENT(type) __alignof(type)
#elif defined(__GNUC__) || defined(__clang__)
# define _TYPE_ALIGNMENT(type) __alignof__(type)
#else
/*
 * FIXME: May not be possible without a compiler extension
 *        (if type is not just a name that is, otherwise the normal
 *         TYPE_ALIGNMENT can be used)
 */
#endif

#if defined(TYPE_ALIGNMENT) && defined(_MSC_VER) && _MSC_VER >= 800 && !defined(__cplusplus)
#pragma warning(disable:4116)
#endif

#if !defined(TYPE_ALIGNMENT) && defined(_TYPE_ALIGNMENT)
# define TYPE_ALIGNMENT _TYPE_ALIGNMENT
#endif

/***********************************************************************
 * Test helper macros
 */

#define TEST_TYPE_SIZE(type, size)              C_ASSERT(sizeof(type) == size);

#ifdef TYPE_ALIGNMENT
# define TEST_TYPE_ALIGN(type, align)           C_ASSERT(TYPE_ALIGNMENT(type) == align);
#else
# define TEST_TYPE_ALIGN(type, align)
#endif

#ifdef _TYPE_ALIGNMENT
# define TEST_TARGET_ALIGN(type, align)         C_ASSERT(_TYPE_ALIGNMENT(*(type)0) == align);
# define TEST_FIELD_ALIGN(type, field, align)   C_ASSERT(_TYPE_ALIGNMENT(((type*)0)->field) == align);
#else
# define TEST_TARGET_ALIGN(type, align)
# define TEST_FIELD_ALIGN(type, field, align)
#endif

#define TEST_FIELD_OFFSET(type, field, offset)  C_ASSERT(FIELD_OFFSET(type, field) == offset);

#define TEST_TARGET_SIZE(type, size)            TEST_TYPE_SIZE(*(type)0, size)
#define TEST_FIELD_SIZE(type, field, size)      TEST_TYPE_SIZE((((type*)0)->field), size)
#define TEST_TYPE_SIGNED(type)                  C_ASSERT((type) -1 < 0);
#define TEST_TYPE_UNSIGNED(type)                C_ASSERT((type) -1 > 0);


#ifdef _WIN64

static void test_pack_LPOSVERSIONINFOA(void)
{
    /* LPOSVERSIONINFOA */
    TEST_TYPE_SIZE   (LPOSVERSIONINFOA, 8)
    TEST_TYPE_ALIGN  (LPOSVERSIONINFOA, 8)
    TEST_TARGET_SIZE (LPOSVERSIONINFOA, 148)
    TEST_TARGET_ALIGN(LPOSVERSIONINFOA, 4)
}

static void test_pack_LPOSVERSIONINFOEXA(void)
{
    /* LPOSVERSIONINFOEXA */
    TEST_TYPE_SIZE   (LPOSVERSIONINFOEXA, 8)
    TEST_TYPE_ALIGN  (LPOSVERSIONINFOEXA, 8)
    TEST_TARGET_SIZE (LPOSVERSIONINFOEXA, 156)
    TEST_TARGET_ALIGN(LPOSVERSIONINFOEXA, 4)
}

static void test_pack_LPOSVERSIONINFOEXW(void)
{
    /* LPOSVERSIONINFOEXW */
    TEST_TYPE_SIZE   (LPOSVERSIONINFOEXW, 8)
    TEST_TYPE_ALIGN  (LPOSVERSIONINFOEXW, 8)
    TEST_TARGET_SIZE (LPOSVERSIONINFOEXW, 284)
    TEST_TARGET_ALIGN(LPOSVERSIONINFOEXW, 4)
}

static void test_pack_LPOSVERSIONINFOW(void)
{
    /* LPOSVERSIONINFOW */
    TEST_TYPE_SIZE   (LPOSVERSIONINFOW, 8)
    TEST_TYPE_ALIGN  (LPOSVERSIONINFOW, 8)
    TEST_TARGET_SIZE (LPOSVERSIONINFOW, 276)
    TEST_TARGET_ALIGN(LPOSVERSIONINFOW, 4)
}

static void test_pack_OSVERSIONINFOA(void)
{
    /* OSVERSIONINFOA */
    TEST_TYPE_SIZE   (OSVERSIONINFOA, 148)
    TEST_TYPE_ALIGN  (OSVERSIONINFOA, 4)
    TEST_FIELD_SIZE  (OSVERSIONINFOA, dwOSVersionInfoSize, 4)
    TEST_FIELD_ALIGN (OSVERSIONINFOA, dwOSVersionInfoSize, 4)
    TEST_FIELD_OFFSET(OSVERSIONINFOA, dwOSVersionInfoSize, 0)
    TEST_FIELD_SIZE  (OSVERSIONINFOA, dwMajorVersion, 4)
    TEST_FIELD_ALIGN (OSVERSIONINFOA, dwMajorVersion, 4)
    TEST_FIELD_OFFSET(OSVERSIONINFOA, dwMajorVersion, 4)
    TEST_FIELD_SIZE  (OSVERSIONINFOA, dwMinorVersion, 4)
    TEST_FIELD_ALIGN (OSVERSIONINFOA, dwMinorVersion, 4)
    TEST_FIELD_OFFSET(OSVERSIONINFOA, dwMinorVersion, 8)
    TEST_FIELD_SIZE  (OSVERSIONINFOA, dwBuildNumber, 4)
    TEST_FIELD_ALIGN (OSVERSIONINFOA, dwBuildNumber, 4)
    TEST_FIELD_OFFSET(OSVERSIONINFOA, dwBuildNumber, 12)
    TEST_FIELD_SIZE  (OSVERSIONINFOA, dwPlatformId, 4)
    TEST_FIELD_ALIGN (OSVERSIONINFOA, dwPlatformId, 4)
    TEST_FIELD_OFFSET(OSVERSIONINFOA, dwPlatformId, 16)
    TEST_FIELD_SIZE  (OSVERSIONINFOA, szCSDVersion, 128)
    TEST_FIELD_ALIGN (OSVERSIONINFOA, szCSDVersion, 1)
    TEST_FIELD_OFFSET(OSVERSIONINFOA, szCSDVersion, 20)
}

static void test_pack_OSVERSIONINFOEXA(void)
{
    /* OSVERSIONINFOEXA */
    TEST_TYPE_SIZE   (OSVERSIONINFOEXA, 156)
    TEST_TYPE_ALIGN  (OSVERSIONINFOEXA, 4)
    TEST_FIELD_SIZE  (OSVERSIONINFOEXA, dwOSVersionInfoSize, 4)
    TEST_FIELD_ALIGN (OSVERSIONINFOEXA, dwOSVersionInfoSize, 4)
    TEST_FIELD_OFFSET(OSVERSIONINFOEXA, dwOSVersionInfoSize, 0)
    TEST_FIELD_SIZE  (OSVERSIONINFOEXA, dwMajorVersion, 4)
    TEST_FIELD_ALIGN (OSVERSIONINFOEXA, dwMajorVersion, 4)
    TEST_FIELD_OFFSET(OSVERSIONINFOEXA, dwMajorVersion, 4)
    TEST_FIELD_SIZE  (OSVERSIONINFOEXA, dwMinorVersion, 4)
    TEST_FIELD_ALIGN (OSVERSIONINFOEXA, dwMinorVersion, 4)
    TEST_FIELD_OFFSET(OSVERSIONINFOEXA, dwMinorVersion, 8)
    TEST_FIELD_SIZE  (OSVERSIONINFOEXA, dwBuildNumber, 4)
    TEST_FIELD_ALIGN (OSVERSIONINFOEXA, dwBuildNumber, 4)
    TEST_FIELD_OFFSET(OSVERSIONINFOEXA, dwBuildNumber, 12)
    TEST_FIELD_SIZE  (OSVERSIONINFOEXA, dwPlatformId, 4)
    TEST_FIELD_ALIGN (OSVERSIONINFOEXA, dwPlatformId, 4)
    TEST_FIELD_OFFSET(OSVERSIONINFOEXA, dwPlatformId, 16)
    TEST_FIELD_SIZE  (OSVERSIONINFOEXA, szCSDVersion, 128)
    TEST_FIELD_ALIGN (OSVERSIONINFOEXA, szCSDVersion, 1)
    TEST_FIELD_OFFSET(OSVERSIONINFOEXA, szCSDVersion, 20)
    TEST_FIELD_SIZE  (OSVERSIONINFOEXA, wServicePackMajor, 2)
    TEST_FIELD_ALIGN (OSVERSIONINFOEXA, wServicePackMajor, 2)
    TEST_FIELD_OFFSET(OSVERSIONINFOEXA, wServicePackMajor, 148)
    TEST_FIELD_SIZE  (OSVERSIONINFOEXA, wServicePackMinor, 2)
    TEST_FIELD_ALIGN (OSVERSIONINFOEXA, wServicePackMinor, 2)
    TEST_FIELD_OFFSET(OSVERSIONINFOEXA, wServicePackMinor, 150)
    TEST_FIELD_SIZE  (OSVERSIONINFOEXA, wSuiteMask, 2)
    TEST_FIELD_ALIGN (OSVERSIONINFOEXA, wSuiteMask, 2)
    TEST_FIELD_OFFSET(OSVERSIONINFOEXA, wSuiteMask, 152)
    TEST_FIELD_SIZE  (OSVERSIONINFOEXA, wProductType, 1)
    TEST_FIELD_ALIGN (OSVERSIONINFOEXA, wProductType, 1)
    TEST_FIELD_OFFSET(OSVERSIONINFOEXA, wProductType, 154)
    TEST_FIELD_SIZE  (OSVERSIONINFOEXA, wReserved, 1)
    TEST_FIELD_ALIGN (OSVERSIONINFOEXA, wReserved, 1)
    TEST_FIELD_OFFSET(OSVERSIONINFOEXA, wReserved, 155)
}

static void test_pack_OSVERSIONINFOEXW(void)
{
    /* OSVERSIONINFOEXW */
    TEST_TYPE_SIZE   (OSVERSIONINFOEXW, 284)
    TEST_TYPE_ALIGN  (OSVERSIONINFOEXW, 4)
    TEST_FIELD_SIZE  (OSVERSIONINFOEXW, dwOSVersionInfoSize, 4)
    TEST_FIELD_ALIGN (OSVERSIONINFOEXW, dwOSVersionInfoSize, 4)
    TEST_FIELD_OFFSET(OSVERSIONINFOEXW, dwOSVersionInfoSize, 0)
    TEST_FIELD_SIZE  (OSVERSIONINFOEXW, dwMajorVersion, 4)
    TEST_FIELD_ALIGN (OSVERSIONINFOEXW, dwMajorVersion, 4)
    TEST_FIELD_OFFSET(OSVERSIONINFOEXW, dwMajorVersion, 4)
    TEST_FIELD_SIZE  (OSVERSIONINFOEXW, dwMinorVersion, 4)
    TEST_FIELD_ALIGN (OSVERSIONINFOEXW, dwMinorVersion, 4)
    TEST_FIELD_OFFSET(OSVERSIONINFOEXW, dwMinorVersion, 8)
    TEST_FIELD_SIZE  (OSVERSIONINFOEXW, dwBuildNumber, 4)
    TEST_FIELD_ALIGN (OSVERSIONINFOEXW, dwBuildNumber, 4)
    TEST_FIELD_OFFSET(OSVERSIONINFOEXW, dwBuildNumber, 12)
    TEST_FIELD_SIZE  (OSVERSIONINFOEXW, dwPlatformId, 4)
    TEST_FIELD_ALIGN (OSVERSIONINFOEXW, dwPlatformId, 4)
    TEST_FIELD_OFFSET(OSVERSIONINFOEXW, dwPlatformId, 16)
    TEST_FIELD_SIZE  (OSVERSIONINFOEXW, szCSDVersion, 256)
    TEST_FIELD_ALIGN (OSVERSIONINFOEXW, szCSDVersion, 2)
    TEST_FIELD_OFFSET(OSVERSIONINFOEXW, szCSDVersion, 20)
    TEST_FIELD_SIZE  (OSVERSIONINFOEXW, wServicePackMajor, 2)
    TEST_FIELD_ALIGN (OSVERSIONINFOEXW, wServicePackMajor, 2)
    TEST_FIELD_OFFSET(OSVERSIONINFOEXW, wServicePackMajor, 276)
    TEST_FIELD_SIZE  (OSVERSIONINFOEXW, wServicePackMinor, 2)
    TEST_FIELD_ALIGN (OSVERSIONINFOEXW, wServicePackMinor, 2)
    TEST_FIELD_OFFSET(OSVERSIONINFOEXW, wServicePackMinor, 278)
    TEST_FIELD_SIZE  (OSVERSIONINFOEXW, wSuiteMask, 2)
    TEST_FIELD_ALIGN (OSVERSIONINFOEXW, wSuiteMask, 2)
    TEST_FIELD_OFFSET(OSVERSIONINFOEXW, wSuiteMask, 280)
    TEST_FIELD_SIZE  (OSVERSIONINFOEXW, wProductType, 1)
    TEST_FIELD_ALIGN (OSVERSIONINFOEXW, wProductType, 1)
    TEST_FIELD_OFFSET(OSVERSIONINFOEXW, wProductType, 282)
    TEST_FIELD_SIZE  (OSVERSIONINFOEXW, wReserved, 1)
    TEST_FIELD_ALIGN (OSVERSIONINFOEXW, wReserved, 1)
    TEST_FIELD_OFFSET(OSVERSIONINFOEXW, wReserved, 283)
}

static void test_pack_OSVERSIONINFOW(void)
{
    /* OSVERSIONINFOW */
    TEST_TYPE_SIZE   (OSVERSIONINFOW, 276)
    TEST_TYPE_ALIGN  (OSVERSIONINFOW, 4)
    TEST_FIELD_SIZE  (OSVERSIONINFOW, dwOSVersionInfoSize, 4)
    TEST_FIELD_ALIGN (OSVERSIONINFOW, dwOSVersionInfoSize, 4)
    TEST_FIELD_OFFSET(OSVERSIONINFOW, dwOSVersionInfoSize, 0)
    TEST_FIELD_SIZE  (OSVERSIONINFOW, dwMajorVersion, 4)
    TEST_FIELD_ALIGN (OSVERSIONINFOW, dwMajorVersion, 4)
    TEST_FIELD_OFFSET(OSVERSIONINFOW, dwMajorVersion, 4)
    TEST_FIELD_SIZE  (OSVERSIONINFOW, dwMinorVersion, 4)
    TEST_FIELD_ALIGN (OSVERSIONINFOW, dwMinorVersion, 4)
    TEST_FIELD_OFFSET(OSVERSIONINFOW, dwMinorVersion, 8)
    TEST_FIELD_SIZE  (OSVERSIONINFOW, dwBuildNumber, 4)
    TEST_FIELD_ALIGN (OSVERSIONINFOW, dwBuildNumber, 4)
    TEST_FIELD_OFFSET(OSVERSIONINFOW, dwBuildNumber, 12)
    TEST_FIELD_SIZE  (OSVERSIONINFOW, dwPlatformId, 4)
    TEST_FIELD_ALIGN (OSVERSIONINFOW, dwPlatformId, 4)
    TEST_FIELD_OFFSET(OSVERSIONINFOW, dwPlatformId, 16)
    TEST_FIELD_SIZE  (OSVERSIONINFOW, szCSDVersion, 256)
    TEST_FIELD_ALIGN (OSVERSIONINFOW, szCSDVersion, 2)
    TEST_FIELD_OFFSET(OSVERSIONINFOW, szCSDVersion, 20)
}

static void test_pack_POSVERSIONINFOA(void)
{
    /* POSVERSIONINFOA */
    TEST_TYPE_SIZE   (POSVERSIONINFOA, 8)
    TEST_TYPE_ALIGN  (POSVERSIONINFOA, 8)
    TEST_TARGET_SIZE (POSVERSIONINFOA, 148)
    TEST_TARGET_ALIGN(POSVERSIONINFOA, 4)
}

static void test_pack_POSVERSIONINFOEXA(void)
{
    /* POSVERSIONINFOEXA */
    TEST_TYPE_SIZE   (POSVERSIONINFOEXA, 8)
    TEST_TYPE_ALIGN  (POSVERSIONINFOEXA, 8)
    TEST_TARGET_SIZE (POSVERSIONINFOEXA, 156)
    TEST_TARGET_ALIGN(POSVERSIONINFOEXA, 4)
}

static void test_pack_POSVERSIONINFOEXW(void)
{
    /* POSVERSIONINFOEXW */
    TEST_TYPE_SIZE   (POSVERSIONINFOEXW, 8)
    TEST_TYPE_ALIGN  (POSVERSIONINFOEXW, 8)
    TEST_TARGET_SIZE (POSVERSIONINFOEXW, 284)
    TEST_TARGET_ALIGN(POSVERSIONINFOEXW, 4)
}

static void test_pack_POSVERSIONINFOW(void)
{
    /* POSVERSIONINFOW */
    TEST_TYPE_SIZE   (POSVERSIONINFOW, 8)
    TEST_TYPE_ALIGN  (POSVERSIONINFOW, 8)
    TEST_TARGET_SIZE (POSVERSIONINFOW, 276)
    TEST_TARGET_ALIGN(POSVERSIONINFOW, 4)
}

static void test_pack_LPLONG(void)
{
    /* LPLONG */
    TEST_TYPE_SIZE   (LPLONG, 8)
    TEST_TYPE_ALIGN  (LPLONG, 8)
}

static void test_pack_LPVOID(void)
{
    /* LPVOID */
    TEST_TYPE_SIZE   (LPVOID, 8)
    TEST_TYPE_ALIGN  (LPVOID, 8)
}

static void test_pack_PHKEY(void)
{
    /* PHKEY */
    TEST_TYPE_SIZE   (PHKEY, 8)
    TEST_TYPE_ALIGN  (PHKEY, 8)
}

static void test_pack_ACTCTXA(void)
{
    /* ACTCTXA */
    TEST_TYPE_SIZE   (ACTCTXA, 56)
    TEST_TYPE_ALIGN  (ACTCTXA, 8)
    TEST_FIELD_SIZE  (ACTCTXA, cbSize, 4)
    TEST_FIELD_ALIGN (ACTCTXA, cbSize, 4)
    TEST_FIELD_OFFSET(ACTCTXA, cbSize, 0)
    TEST_FIELD_SIZE  (ACTCTXA, dwFlags, 4)
    TEST_FIELD_ALIGN (ACTCTXA, dwFlags, 4)
    TEST_FIELD_OFFSET(ACTCTXA, dwFlags, 4)
    TEST_FIELD_SIZE  (ACTCTXA, lpSource, 8)
    TEST_FIELD_ALIGN (ACTCTXA, lpSource, 8)
    TEST_FIELD_OFFSET(ACTCTXA, lpSource, 8)
    TEST_FIELD_SIZE  (ACTCTXA, wProcessorArchitecture, 2)
    TEST_FIELD_ALIGN (ACTCTXA, wProcessorArchitecture, 2)
    TEST_FIELD_OFFSET(ACTCTXA, wProcessorArchitecture, 16)
    TEST_FIELD_SIZE  (ACTCTXA, wLangId, 2)
    TEST_FIELD_ALIGN (ACTCTXA, wLangId, 2)
    TEST_FIELD_OFFSET(ACTCTXA, wLangId, 18)
    TEST_FIELD_SIZE  (ACTCTXA, lpAssemblyDirectory, 8)
    TEST_FIELD_ALIGN (ACTCTXA, lpAssemblyDirectory, 8)
    TEST_FIELD_OFFSET(ACTCTXA, lpAssemblyDirectory, 24)
    TEST_FIELD_SIZE  (ACTCTXA, lpResourceName, 8)
    TEST_FIELD_ALIGN (ACTCTXA, lpResourceName, 8)
    TEST_FIELD_OFFSET(ACTCTXA, lpResourceName, 32)
    TEST_FIELD_SIZE  (ACTCTXA, lpApplicationName, 8)
    TEST_FIELD_ALIGN (ACTCTXA, lpApplicationName, 8)
    TEST_FIELD_OFFSET(ACTCTXA, lpApplicationName, 40)
    TEST_FIELD_SIZE  (ACTCTXA, hModule, 8)
    TEST_FIELD_ALIGN (ACTCTXA, hModule, 8)
    TEST_FIELD_OFFSET(ACTCTXA, hModule, 48)
}

static void test_pack_ACTCTXW(void)
{
    /* ACTCTXW */
    TEST_TYPE_SIZE   (ACTCTXW, 56)
    TEST_TYPE_ALIGN  (ACTCTXW, 8)
    TEST_FIELD_SIZE  (ACTCTXW, cbSize, 4)
    TEST_FIELD_ALIGN (ACTCTXW, cbSize, 4)
    TEST_FIELD_OFFSET(ACTCTXW, cbSize, 0)
    TEST_FIELD_SIZE  (ACTCTXW, dwFlags, 4)
    TEST_FIELD_ALIGN (ACTCTXW, dwFlags, 4)
    TEST_FIELD_OFFSET(ACTCTXW, dwFlags, 4)
    TEST_FIELD_SIZE  (ACTCTXW, lpSource, 8)
    TEST_FIELD_ALIGN (ACTCTXW, lpSource, 8)
    TEST_FIELD_OFFSET(ACTCTXW, lpSource, 8)
    TEST_FIELD_SIZE  (ACTCTXW, wProcessorArchitecture, 2)
    TEST_FIELD_ALIGN (ACTCTXW, wProcessorArchitecture, 2)
    TEST_FIELD_OFFSET(ACTCTXW, wProcessorArchitecture, 16)
    TEST_FIELD_SIZE  (ACTCTXW, wLangId, 2)
    TEST_FIELD_ALIGN (ACTCTXW, wLangId, 2)
    TEST_FIELD_OFFSET(ACTCTXW, wLangId, 18)
    TEST_FIELD_SIZE  (ACTCTXW, lpAssemblyDirectory, 8)
    TEST_FIELD_ALIGN (ACTCTXW, lpAssemblyDirectory, 8)
    TEST_FIELD_OFFSET(ACTCTXW, lpAssemblyDirectory, 24)
    TEST_FIELD_SIZE  (ACTCTXW, lpResourceName, 8)
    TEST_FIELD_ALIGN (ACTCTXW, lpResourceName, 8)
    TEST_FIELD_OFFSET(ACTCTXW, lpResourceName, 32)
    TEST_FIELD_SIZE  (ACTCTXW, lpApplicationName, 8)
    TEST_FIELD_ALIGN (ACTCTXW, lpApplicationName, 8)
    TEST_FIELD_OFFSET(ACTCTXW, lpApplicationName, 40)
    TEST_FIELD_SIZE  (ACTCTXW, hModule, 8)
    TEST_FIELD_ALIGN (ACTCTXW, hModule, 8)
    TEST_FIELD_OFFSET(ACTCTXW, hModule, 48)
}

static void test_pack_ACTCTX_SECTION_KEYED_DATA(void)
{
    /* ACTCTX_SECTION_KEYED_DATA */
    TEST_TYPE_SIZE   (ACTCTX_SECTION_KEYED_DATA, 112)
    TEST_TYPE_ALIGN  (ACTCTX_SECTION_KEYED_DATA, 8)
    TEST_FIELD_SIZE  (ACTCTX_SECTION_KEYED_DATA, cbSize, 4)
    TEST_FIELD_ALIGN (ACTCTX_SECTION_KEYED_DATA, cbSize, 4)
    TEST_FIELD_OFFSET(ACTCTX_SECTION_KEYED_DATA, cbSize, 0)
    TEST_FIELD_SIZE  (ACTCTX_SECTION_KEYED_DATA, ulDataFormatVersion, 4)
    TEST_FIELD_ALIGN (ACTCTX_SECTION_KEYED_DATA, ulDataFormatVersion, 4)
    TEST_FIELD_OFFSET(ACTCTX_SECTION_KEYED_DATA, ulDataFormatVersion, 4)
    TEST_FIELD_SIZE  (ACTCTX_SECTION_KEYED_DATA, lpData, 8)
    TEST_FIELD_ALIGN (ACTCTX_SECTION_KEYED_DATA, lpData, 8)
    TEST_FIELD_OFFSET(ACTCTX_SECTION_KEYED_DATA, lpData, 8)
    TEST_FIELD_SIZE  (ACTCTX_SECTION_KEYED_DATA, ulLength, 4)
    TEST_FIELD_ALIGN (ACTCTX_SECTION_KEYED_DATA, ulLength, 4)
    TEST_FIELD_OFFSET(ACTCTX_SECTION_KEYED_DATA, ulLength, 16)
    TEST_FIELD_SIZE  (ACTCTX_SECTION_KEYED_DATA, lpSectionGlobalData, 8)
    TEST_FIELD_ALIGN (ACTCTX_SECTION_KEYED_DATA, lpSectionGlobalData, 8)
    TEST_FIELD_OFFSET(ACTCTX_SECTION_KEYED_DATA, lpSectionGlobalData, 24)
    TEST_FIELD_SIZE  (ACTCTX_SECTION_KEYED_DATA, ulSectionGlobalDataLength, 4)
    TEST_FIELD_ALIGN (ACTCTX_SECTION_KEYED_DATA, ulSectionGlobalDataLength, 4)
    TEST_FIELD_OFFSET(ACTCTX_SECTION_KEYED_DATA, ulSectionGlobalDataLength, 32)
    TEST_FIELD_SIZE  (ACTCTX_SECTION_KEYED_DATA, lpSectionBase, 8)
    TEST_FIELD_ALIGN (ACTCTX_SECTION_KEYED_DATA, lpSectionBase, 8)
    TEST_FIELD_OFFSET(ACTCTX_SECTION_KEYED_DATA, lpSectionBase, 40)
    TEST_FIELD_SIZE  (ACTCTX_SECTION_KEYED_DATA, ulSectionTotalLength, 4)
    TEST_FIELD_ALIGN (ACTCTX_SECTION_KEYED_DATA, ulSectionTotalLength, 4)
    TEST_FIELD_OFFSET(ACTCTX_SECTION_KEYED_DATA, ulSectionTotalLength, 48)
    TEST_FIELD_SIZE  (ACTCTX_SECTION_KEYED_DATA, hActCtx, 8)
    TEST_FIELD_ALIGN (ACTCTX_SECTION_KEYED_DATA, hActCtx, 8)
    TEST_FIELD_OFFSET(ACTCTX_SECTION_KEYED_DATA, hActCtx, 56)
    TEST_FIELD_SIZE  (ACTCTX_SECTION_KEYED_DATA, ulAssemblyRosterIndex, 4)
    TEST_FIELD_ALIGN (ACTCTX_SECTION_KEYED_DATA, ulAssemblyRosterIndex, 4)
    TEST_FIELD_OFFSET(ACTCTX_SECTION_KEYED_DATA, ulAssemblyRosterIndex, 64)
    TEST_FIELD_SIZE  (ACTCTX_SECTION_KEYED_DATA, ulFlags, 4)
    TEST_FIELD_ALIGN (ACTCTX_SECTION_KEYED_DATA, ulFlags, 4)
    TEST_FIELD_OFFSET(ACTCTX_SECTION_KEYED_DATA, ulFlags, 68)
    TEST_FIELD_SIZE  (ACTCTX_SECTION_KEYED_DATA, AssemblyMetadata, 40)
    TEST_FIELD_ALIGN (ACTCTX_SECTION_KEYED_DATA, AssemblyMetadata, 8)
    TEST_FIELD_OFFSET(ACTCTX_SECTION_KEYED_DATA, AssemblyMetadata, 72)
}

static void test_pack_ACTCTX_SECTION_KEYED_DATA_2600(void)
{
    /* ACTCTX_SECTION_KEYED_DATA_2600 */
    TEST_TYPE_SIZE   (ACTCTX_SECTION_KEYED_DATA_2600, 72)
    TEST_TYPE_ALIGN  (ACTCTX_SECTION_KEYED_DATA_2600, 8)
    TEST_FIELD_SIZE  (ACTCTX_SECTION_KEYED_DATA_2600, cbSize, 4)
    TEST_FIELD_ALIGN (ACTCTX_SECTION_KEYED_DATA_2600, cbSize, 4)
    TEST_FIELD_OFFSET(ACTCTX_SECTION_KEYED_DATA_2600, cbSize, 0)
    TEST_FIELD_SIZE  (ACTCTX_SECTION_KEYED_DATA_2600, ulDataFormatVersion, 4)
    TEST_FIELD_ALIGN (ACTCTX_SECTION_KEYED_DATA_2600, ulDataFormatVersion, 4)
    TEST_FIELD_OFFSET(ACTCTX_SECTION_KEYED_DATA_2600, ulDataFormatVersion, 4)
    TEST_FIELD_SIZE  (ACTCTX_SECTION_KEYED_DATA_2600, lpData, 8)
    TEST_FIELD_ALIGN (ACTCTX_SECTION_KEYED_DATA_2600, lpData, 8)
    TEST_FIELD_OFFSET(ACTCTX_SECTION_KEYED_DATA_2600, lpData, 8)
    TEST_FIELD_SIZE  (ACTCTX_SECTION_KEYED_DATA_2600, ulLength, 4)
    TEST_FIELD_ALIGN (ACTCTX_SECTION_KEYED_DATA_2600, ulLength, 4)
    TEST_FIELD_OFFSET(ACTCTX_SECTION_KEYED_DATA_2600, ulLength, 16)
    TEST_FIELD_SIZE  (ACTCTX_SECTION_KEYED_DATA_2600, lpSectionGlobalData, 8)
    TEST_FIELD_ALIGN (ACTCTX_SECTION_KEYED_DATA_2600, lpSectionGlobalData, 8)
    TEST_FIELD_OFFSET(ACTCTX_SECTION_KEYED_DATA_2600, lpSectionGlobalData, 24)
    TEST_FIELD_SIZE  (ACTCTX_SECTION_KEYED_DATA_2600, ulSectionGlobalDataLength, 4)
    TEST_FIELD_ALIGN (ACTCTX_SECTION_KEYED_DATA_2600, ulSectionGlobalDataLength, 4)
    TEST_FIELD_OFFSET(ACTCTX_SECTION_KEYED_DATA_2600, ulSectionGlobalDataLength, 32)
    TEST_FIELD_SIZE  (ACTCTX_SECTION_KEYED_DATA_2600, lpSectionBase, 8)
    TEST_FIELD_ALIGN (ACTCTX_SECTION_KEYED_DATA_2600, lpSectionBase, 8)
    TEST_FIELD_OFFSET(ACTCTX_SECTION_KEYED_DATA_2600, lpSectionBase, 40)
    TEST_FIELD_SIZE  (ACTCTX_SECTION_KEYED_DATA_2600, ulSectionTotalLength, 4)
    TEST_FIELD_ALIGN (ACTCTX_SECTION_KEYED_DATA_2600, ulSectionTotalLength, 4)
    TEST_FIELD_OFFSET(ACTCTX_SECTION_KEYED_DATA_2600, ulSectionTotalLength, 48)
    TEST_FIELD_SIZE  (ACTCTX_SECTION_KEYED_DATA_2600, hActCtx, 8)
    TEST_FIELD_ALIGN (ACTCTX_SECTION_KEYED_DATA_2600, hActCtx, 8)
    TEST_FIELD_OFFSET(ACTCTX_SECTION_KEYED_DATA_2600, hActCtx, 56)
    TEST_FIELD_SIZE  (ACTCTX_SECTION_KEYED_DATA_2600, ulAssemblyRosterIndex, 4)
    TEST_FIELD_ALIGN (ACTCTX_SECTION_KEYED_DATA_2600, ulAssemblyRosterIndex, 4)
    TEST_FIELD_OFFSET(ACTCTX_SECTION_KEYED_DATA_2600, ulAssemblyRosterIndex, 64)
}

static void test_pack_ACTCTX_SECTION_KEYED_DATA_ASSEMBLY_METADATA(void)
{
    /* ACTCTX_SECTION_KEYED_DATA_ASSEMBLY_METADATA */
    TEST_TYPE_SIZE   (ACTCTX_SECTION_KEYED_DATA_ASSEMBLY_METADATA, 40)
    TEST_TYPE_ALIGN  (ACTCTX_SECTION_KEYED_DATA_ASSEMBLY_METADATA, 8)
    TEST_FIELD_SIZE  (ACTCTX_SECTION_KEYED_DATA_ASSEMBLY_METADATA, lpInformation, 8)
    TEST_FIELD_ALIGN (ACTCTX_SECTION_KEYED_DATA_ASSEMBLY_METADATA, lpInformation, 8)
    TEST_FIELD_OFFSET(ACTCTX_SECTION_KEYED_DATA_ASSEMBLY_METADATA, lpInformation, 0)
    TEST_FIELD_SIZE  (ACTCTX_SECTION_KEYED_DATA_ASSEMBLY_METADATA, lpSectionBase, 8)
    TEST_FIELD_ALIGN (ACTCTX_SECTION_KEYED_DATA_ASSEMBLY_METADATA, lpSectionBase, 8)
    TEST_FIELD_OFFSET(ACTCTX_SECTION_KEYED_DATA_ASSEMBLY_METADATA, lpSectionBase, 8)
    TEST_FIELD_SIZE  (ACTCTX_SECTION_KEYED_DATA_ASSEMBLY_METADATA, ulSectionLength, 4)
    TEST_FIELD_ALIGN (ACTCTX_SECTION_KEYED_DATA_ASSEMBLY_METADATA, ulSectionLength, 4)
    TEST_FIELD_OFFSET(ACTCTX_SECTION_KEYED_DATA_ASSEMBLY_METADATA, ulSectionLength, 16)
    TEST_FIELD_SIZE  (ACTCTX_SECTION_KEYED_DATA_ASSEMBLY_METADATA, lpSectionGlobalDataBase, 8)
    TEST_FIELD_ALIGN (ACTCTX_SECTION_KEYED_DATA_ASSEMBLY_METADATA, lpSectionGlobalDataBase, 8)
    TEST_FIELD_OFFSET(ACTCTX_SECTION_KEYED_DATA_ASSEMBLY_METADATA, lpSectionGlobalDataBase, 24)
    TEST_FIELD_SIZE  (ACTCTX_SECTION_KEYED_DATA_ASSEMBLY_METADATA, ulSectionGlobalDataLength, 4)
    TEST_FIELD_ALIGN (ACTCTX_SECTION_KEYED_DATA_ASSEMBLY_METADATA, ulSectionGlobalDataLength, 4)
    TEST_FIELD_OFFSET(ACTCTX_SECTION_KEYED_DATA_ASSEMBLY_METADATA, ulSectionGlobalDataLength, 32)
}

static void test_pack_ACTIVATION_CONTEXT_BASIC_INFORMATION(void)
{
    /* ACTIVATION_CONTEXT_BASIC_INFORMATION */
    TEST_TYPE_SIZE   (ACTIVATION_CONTEXT_BASIC_INFORMATION, 16)
    TEST_TYPE_ALIGN  (ACTIVATION_CONTEXT_BASIC_INFORMATION, 8)
    TEST_FIELD_SIZE  (ACTIVATION_CONTEXT_BASIC_INFORMATION, hActCtx, 8)
    TEST_FIELD_ALIGN (ACTIVATION_CONTEXT_BASIC_INFORMATION, hActCtx, 8)
    TEST_FIELD_OFFSET(ACTIVATION_CONTEXT_BASIC_INFORMATION, hActCtx, 0)
    TEST_FIELD_SIZE  (ACTIVATION_CONTEXT_BASIC_INFORMATION, dwFlags, 4)
    TEST_FIELD_ALIGN (ACTIVATION_CONTEXT_BASIC_INFORMATION, dwFlags, 4)
    TEST_FIELD_OFFSET(ACTIVATION_CONTEXT_BASIC_INFORMATION, dwFlags, 8)
}

static void test_pack_BY_HANDLE_FILE_INFORMATION(void)
{
    /* BY_HANDLE_FILE_INFORMATION */
    TEST_TYPE_SIZE   (BY_HANDLE_FILE_INFORMATION, 52)
    TEST_TYPE_ALIGN  (BY_HANDLE_FILE_INFORMATION, 4)
    TEST_FIELD_SIZE  (BY_HANDLE_FILE_INFORMATION, dwFileAttributes, 4)
    TEST_FIELD_ALIGN (BY_HANDLE_FILE_INFORMATION, dwFileAttributes, 4)
    TEST_FIELD_OFFSET(BY_HANDLE_FILE_INFORMATION, dwFileAttributes, 0)
    TEST_FIELD_SIZE  (BY_HANDLE_FILE_INFORMATION, ftCreationTime, 8)
    TEST_FIELD_ALIGN (BY_HANDLE_FILE_INFORMATION, ftCreationTime, 4)
    TEST_FIELD_OFFSET(BY_HANDLE_FILE_INFORMATION, ftCreationTime, 4)
    TEST_FIELD_SIZE  (BY_HANDLE_FILE_INFORMATION, ftLastAccessTime, 8)
    TEST_FIELD_ALIGN (BY_HANDLE_FILE_INFORMATION, ftLastAccessTime, 4)
    TEST_FIELD_OFFSET(BY_HANDLE_FILE_INFORMATION, ftLastAccessTime, 12)
    TEST_FIELD_SIZE  (BY_HANDLE_FILE_INFORMATION, ftLastWriteTime, 8)
    TEST_FIELD_ALIGN (BY_HANDLE_FILE_INFORMATION, ftLastWriteTime, 4)
    TEST_FIELD_OFFSET(BY_HANDLE_FILE_INFORMATION, ftLastWriteTime, 20)
    TEST_FIELD_SIZE  (BY_HANDLE_FILE_INFORMATION, dwVolumeSerialNumber, 4)
    TEST_FIELD_ALIGN (BY_HANDLE_FILE_INFORMATION, dwVolumeSerialNumber, 4)
    TEST_FIELD_OFFSET(BY_HANDLE_FILE_INFORMATION, dwVolumeSerialNumber, 28)
    TEST_FIELD_SIZE  (BY_HANDLE_FILE_INFORMATION, nFileSizeHigh, 4)
    TEST_FIELD_ALIGN (BY_HANDLE_FILE_INFORMATION, nFileSizeHigh, 4)
    TEST_FIELD_OFFSET(BY_HANDLE_FILE_INFORMATION, nFileSizeHigh, 32)
    TEST_FIELD_SIZE  (BY_HANDLE_FILE_INFORMATION, nFileSizeLow, 4)
    TEST_FIELD_ALIGN (BY_HANDLE_FILE_INFORMATION, nFileSizeLow, 4)
    TEST_FIELD_OFFSET(BY_HANDLE_FILE_INFORMATION, nFileSizeLow, 36)
    TEST_FIELD_SIZE  (BY_HANDLE_FILE_INFORMATION, nNumberOfLinks, 4)
    TEST_FIELD_ALIGN (BY_HANDLE_FILE_INFORMATION, nNumberOfLinks, 4)
    TEST_FIELD_OFFSET(BY_HANDLE_FILE_INFORMATION, nNumberOfLinks, 40)
    TEST_FIELD_SIZE  (BY_HANDLE_FILE_INFORMATION, nFileIndexHigh, 4)
    TEST_FIELD_ALIGN (BY_HANDLE_FILE_INFORMATION, nFileIndexHigh, 4)
    TEST_FIELD_OFFSET(BY_HANDLE_FILE_INFORMATION, nFileIndexHigh, 44)
    TEST_FIELD_SIZE  (BY_HANDLE_FILE_INFORMATION, nFileIndexLow, 4)
    TEST_FIELD_ALIGN (BY_HANDLE_FILE_INFORMATION, nFileIndexLow, 4)
    TEST_FIELD_OFFSET(BY_HANDLE_FILE_INFORMATION, nFileIndexLow, 48)
}

static void test_pack_COMMCONFIG(void)
{
    /* COMMCONFIG */
    TEST_TYPE_SIZE   (COMMCONFIG, 52)
    TEST_TYPE_ALIGN  (COMMCONFIG, 4)
    TEST_FIELD_SIZE  (COMMCONFIG, dwSize, 4)
    TEST_FIELD_ALIGN (COMMCONFIG, dwSize, 4)
    TEST_FIELD_OFFSET(COMMCONFIG, dwSize, 0)
    TEST_FIELD_SIZE  (COMMCONFIG, wVersion, 2)
    TEST_FIELD_ALIGN (COMMCONFIG, wVersion, 2)
    TEST_FIELD_OFFSET(COMMCONFIG, wVersion, 4)
    TEST_FIELD_SIZE  (COMMCONFIG, wReserved, 2)
    TEST_FIELD_ALIGN (COMMCONFIG, wReserved, 2)
    TEST_FIELD_OFFSET(COMMCONFIG, wReserved, 6)
    TEST_FIELD_SIZE  (COMMCONFIG, dcb, 28)
    TEST_FIELD_ALIGN (COMMCONFIG, dcb, 4)
    TEST_FIELD_OFFSET(COMMCONFIG, dcb, 8)
    TEST_FIELD_SIZE  (COMMCONFIG, dwProviderSubType, 4)
    TEST_FIELD_ALIGN (COMMCONFIG, dwProviderSubType, 4)
    TEST_FIELD_OFFSET(COMMCONFIG, dwProviderSubType, 36)
    TEST_FIELD_SIZE  (COMMCONFIG, dwProviderOffset, 4)
    TEST_FIELD_ALIGN (COMMCONFIG, dwProviderOffset, 4)
    TEST_FIELD_OFFSET(COMMCONFIG, dwProviderOffset, 40)
    TEST_FIELD_SIZE  (COMMCONFIG, dwProviderSize, 4)
    TEST_FIELD_ALIGN (COMMCONFIG, dwProviderSize, 4)
    TEST_FIELD_OFFSET(COMMCONFIG, dwProviderSize, 44)
    TEST_FIELD_SIZE  (COMMCONFIG, wcProviderData, 2)
    TEST_FIELD_ALIGN (COMMCONFIG, wcProviderData, 2)
    TEST_FIELD_OFFSET(COMMCONFIG, wcProviderData, 48)
}

static void test_pack_COMMPROP(void)
{
    /* COMMPROP */
    TEST_TYPE_SIZE   (COMMPROP, 64)
    TEST_TYPE_ALIGN  (COMMPROP, 4)
    TEST_FIELD_SIZE  (COMMPROP, wPacketLength, 2)
    TEST_FIELD_ALIGN (COMMPROP, wPacketLength, 2)
    TEST_FIELD_OFFSET(COMMPROP, wPacketLength, 0)
    TEST_FIELD_SIZE  (COMMPROP, wPacketVersion, 2)
    TEST_FIELD_ALIGN (COMMPROP, wPacketVersion, 2)
    TEST_FIELD_OFFSET(COMMPROP, wPacketVersion, 2)
    TEST_FIELD_SIZE  (COMMPROP, dwServiceMask, 4)
    TEST_FIELD_ALIGN (COMMPROP, dwServiceMask, 4)
    TEST_FIELD_OFFSET(COMMPROP, dwServiceMask, 4)
    TEST_FIELD_SIZE  (COMMPROP, dwReserved1, 4)
    TEST_FIELD_ALIGN (COMMPROP, dwReserved1, 4)
    TEST_FIELD_OFFSET(COMMPROP, dwReserved1, 8)
    TEST_FIELD_SIZE  (COMMPROP, dwMaxTxQueue, 4)
    TEST_FIELD_ALIGN (COMMPROP, dwMaxTxQueue, 4)
    TEST_FIELD_OFFSET(COMMPROP, dwMaxTxQueue, 12)
    TEST_FIELD_SIZE  (COMMPROP, dwMaxRxQueue, 4)
    TEST_FIELD_ALIGN (COMMPROP, dwMaxRxQueue, 4)
    TEST_FIELD_OFFSET(COMMPROP, dwMaxRxQueue, 16)
    TEST_FIELD_SIZE  (COMMPROP, dwMaxBaud, 4)
    TEST_FIELD_ALIGN (COMMPROP, dwMaxBaud, 4)
    TEST_FIELD_OFFSET(COMMPROP, dwMaxBaud, 20)
    TEST_FIELD_SIZE  (COMMPROP, dwProvSubType, 4)
    TEST_FIELD_ALIGN (COMMPROP, dwProvSubType, 4)
    TEST_FIELD_OFFSET(COMMPROP, dwProvSubType, 24)
    TEST_FIELD_SIZE  (COMMPROP, dwProvCapabilities, 4)
    TEST_FIELD_ALIGN (COMMPROP, dwProvCapabilities, 4)
    TEST_FIELD_OFFSET(COMMPROP, dwProvCapabilities, 28)
    TEST_FIELD_SIZE  (COMMPROP, dwSettableParams, 4)
    TEST_FIELD_ALIGN (COMMPROP, dwSettableParams, 4)
    TEST_FIELD_OFFSET(COMMPROP, dwSettableParams, 32)
    TEST_FIELD_SIZE  (COMMPROP, dwSettableBaud, 4)
    TEST_FIELD_ALIGN (COMMPROP, dwSettableBaud, 4)
    TEST_FIELD_OFFSET(COMMPROP, dwSettableBaud, 36)
    TEST_FIELD_SIZE  (COMMPROP, wSettableData, 2)
    TEST_FIELD_ALIGN (COMMPROP, wSettableData, 2)
    TEST_FIELD_OFFSET(COMMPROP, wSettableData, 40)
    TEST_FIELD_SIZE  (COMMPROP, wSettableStopParity, 2)
    TEST_FIELD_ALIGN (COMMPROP, wSettableStopParity, 2)
    TEST_FIELD_OFFSET(COMMPROP, wSettableStopParity, 42)
    TEST_FIELD_SIZE  (COMMPROP, dwCurrentTxQueue, 4)
    TEST_FIELD_ALIGN (COMMPROP, dwCurrentTxQueue, 4)
    TEST_FIELD_OFFSET(COMMPROP, dwCurrentTxQueue, 44)
    TEST_FIELD_SIZE  (COMMPROP, dwCurrentRxQueue, 4)
    TEST_FIELD_ALIGN (COMMPROP, dwCurrentRxQueue, 4)
    TEST_FIELD_OFFSET(COMMPROP, dwCurrentRxQueue, 48)
    TEST_FIELD_SIZE  (COMMPROP, dwProvSpec1, 4)
    TEST_FIELD_ALIGN (COMMPROP, dwProvSpec1, 4)
    TEST_FIELD_OFFSET(COMMPROP, dwProvSpec1, 52)
    TEST_FIELD_SIZE  (COMMPROP, dwProvSpec2, 4)
    TEST_FIELD_ALIGN (COMMPROP, dwProvSpec2, 4)
    TEST_FIELD_OFFSET(COMMPROP, dwProvSpec2, 56)
    TEST_FIELD_SIZE  (COMMPROP, wcProvChar, 2)
    TEST_FIELD_ALIGN (COMMPROP, wcProvChar, 2)
    TEST_FIELD_OFFSET(COMMPROP, wcProvChar, 60)
}

static void test_pack_COMMTIMEOUTS(void)
{
    /* COMMTIMEOUTS */
    TEST_TYPE_SIZE   (COMMTIMEOUTS, 20)
    TEST_TYPE_ALIGN  (COMMTIMEOUTS, 4)
    TEST_FIELD_SIZE  (COMMTIMEOUTS, ReadIntervalTimeout, 4)
    TEST_FIELD_ALIGN (COMMTIMEOUTS, ReadIntervalTimeout, 4)
    TEST_FIELD_OFFSET(COMMTIMEOUTS, ReadIntervalTimeout, 0)
    TEST_FIELD_SIZE  (COMMTIMEOUTS, ReadTotalTimeoutMultiplier, 4)
    TEST_FIELD_ALIGN (COMMTIMEOUTS, ReadTotalTimeoutMultiplier, 4)
    TEST_FIELD_OFFSET(COMMTIMEOUTS, ReadTotalTimeoutMultiplier, 4)
    TEST_FIELD_SIZE  (COMMTIMEOUTS, ReadTotalTimeoutConstant, 4)
    TEST_FIELD_ALIGN (COMMTIMEOUTS, ReadTotalTimeoutConstant, 4)
    TEST_FIELD_OFFSET(COMMTIMEOUTS, ReadTotalTimeoutConstant, 8)
    TEST_FIELD_SIZE  (COMMTIMEOUTS, WriteTotalTimeoutMultiplier, 4)
    TEST_FIELD_ALIGN (COMMTIMEOUTS, WriteTotalTimeoutMultiplier, 4)
    TEST_FIELD_OFFSET(COMMTIMEOUTS, WriteTotalTimeoutMultiplier, 12)
    TEST_FIELD_SIZE  (COMMTIMEOUTS, WriteTotalTimeoutConstant, 4)
    TEST_FIELD_ALIGN (COMMTIMEOUTS, WriteTotalTimeoutConstant, 4)
    TEST_FIELD_OFFSET(COMMTIMEOUTS, WriteTotalTimeoutConstant, 16)
}

static void test_pack_COMSTAT(void)
{
    /* COMSTAT */
    TEST_TYPE_SIZE   (COMSTAT, 12)
    TEST_TYPE_ALIGN  (COMSTAT, 4)
    TEST_FIELD_SIZE  (COMSTAT, cbInQue, 4)
    TEST_FIELD_ALIGN (COMSTAT, cbInQue, 4)
    TEST_FIELD_OFFSET(COMSTAT, cbInQue, 4)
    TEST_FIELD_SIZE  (COMSTAT, cbOutQue, 4)
    TEST_FIELD_ALIGN (COMSTAT, cbOutQue, 4)
    TEST_FIELD_OFFSET(COMSTAT, cbOutQue, 8)
}

static void test_pack_CREATE_PROCESS_DEBUG_INFO(void)
{
    /* CREATE_PROCESS_DEBUG_INFO */
    TEST_TYPE_SIZE   (CREATE_PROCESS_DEBUG_INFO, 72)
    TEST_TYPE_ALIGN  (CREATE_PROCESS_DEBUG_INFO, 8)
    TEST_FIELD_SIZE  (CREATE_PROCESS_DEBUG_INFO, hFile, 8)
    TEST_FIELD_ALIGN (CREATE_PROCESS_DEBUG_INFO, hFile, 8)
    TEST_FIELD_OFFSET(CREATE_PROCESS_DEBUG_INFO, hFile, 0)
    TEST_FIELD_SIZE  (CREATE_PROCESS_DEBUG_INFO, hProcess, 8)
    TEST_FIELD_ALIGN (CREATE_PROCESS_DEBUG_INFO, hProcess, 8)
    TEST_FIELD_OFFSET(CREATE_PROCESS_DEBUG_INFO, hProcess, 8)
    TEST_FIELD_SIZE  (CREATE_PROCESS_DEBUG_INFO, hThread, 8)
    TEST_FIELD_ALIGN (CREATE_PROCESS_DEBUG_INFO, hThread, 8)
    TEST_FIELD_OFFSET(CREATE_PROCESS_DEBUG_INFO, hThread, 16)
    TEST_FIELD_SIZE  (CREATE_PROCESS_DEBUG_INFO, lpBaseOfImage, 8)
    TEST_FIELD_ALIGN (CREATE_PROCESS_DEBUG_INFO, lpBaseOfImage, 8)
    TEST_FIELD_OFFSET(CREATE_PROCESS_DEBUG_INFO, lpBaseOfImage, 24)
    TEST_FIELD_SIZE  (CREATE_PROCESS_DEBUG_INFO, dwDebugInfoFileOffset, 4)
    TEST_FIELD_ALIGN (CREATE_PROCESS_DEBUG_INFO, dwDebugInfoFileOffset, 4)
    TEST_FIELD_OFFSET(CREATE_PROCESS_DEBUG_INFO, dwDebugInfoFileOffset, 32)
    TEST_FIELD_SIZE  (CREATE_PROCESS_DEBUG_INFO, nDebugInfoSize, 4)
    TEST_FIELD_ALIGN (CREATE_PROCESS_DEBUG_INFO, nDebugInfoSize, 4)
    TEST_FIELD_OFFSET(CREATE_PROCESS_DEBUG_INFO, nDebugInfoSize, 36)
    TEST_FIELD_SIZE  (CREATE_PROCESS_DEBUG_INFO, lpThreadLocalBase, 8)
    TEST_FIELD_ALIGN (CREATE_PROCESS_DEBUG_INFO, lpThreadLocalBase, 8)
    TEST_FIELD_OFFSET(CREATE_PROCESS_DEBUG_INFO, lpThreadLocalBase, 40)
    TEST_FIELD_SIZE  (CREATE_PROCESS_DEBUG_INFO, lpStartAddress, 8)
    TEST_FIELD_ALIGN (CREATE_PROCESS_DEBUG_INFO, lpStartAddress, 8)
    TEST_FIELD_OFFSET(CREATE_PROCESS_DEBUG_INFO, lpStartAddress, 48)
    TEST_FIELD_SIZE  (CREATE_PROCESS_DEBUG_INFO, lpImageName, 8)
    TEST_FIELD_ALIGN (CREATE_PROCESS_DEBUG_INFO, lpImageName, 8)
    TEST_FIELD_OFFSET(CREATE_PROCESS_DEBUG_INFO, lpImageName, 56)
    TEST_FIELD_SIZE  (CREATE_PROCESS_DEBUG_INFO, fUnicode, 2)
    TEST_FIELD_ALIGN (CREATE_PROCESS_DEBUG_INFO, fUnicode, 2)
    TEST_FIELD_OFFSET(CREATE_PROCESS_DEBUG_INFO, fUnicode, 64)
}

static void test_pack_CREATE_THREAD_DEBUG_INFO(void)
{
    /* CREATE_THREAD_DEBUG_INFO */
    TEST_TYPE_SIZE   (CREATE_THREAD_DEBUG_INFO, 24)
    TEST_TYPE_ALIGN  (CREATE_THREAD_DEBUG_INFO, 8)
    TEST_FIELD_SIZE  (CREATE_THREAD_DEBUG_INFO, hThread, 8)
    TEST_FIELD_ALIGN (CREATE_THREAD_DEBUG_INFO, hThread, 8)
    TEST_FIELD_OFFSET(CREATE_THREAD_DEBUG_INFO, hThread, 0)
    TEST_FIELD_SIZE  (CREATE_THREAD_DEBUG_INFO, lpThreadLocalBase, 8)
    TEST_FIELD_ALIGN (CREATE_THREAD_DEBUG_INFO, lpThreadLocalBase, 8)
    TEST_FIELD_OFFSET(CREATE_THREAD_DEBUG_INFO, lpThreadLocalBase, 8)
    TEST_FIELD_SIZE  (CREATE_THREAD_DEBUG_INFO, lpStartAddress, 8)
    TEST_FIELD_ALIGN (CREATE_THREAD_DEBUG_INFO, lpStartAddress, 8)
    TEST_FIELD_OFFSET(CREATE_THREAD_DEBUG_INFO, lpStartAddress, 16)
}

static void test_pack_CRITICAL_SECTION(void)
{
    /* CRITICAL_SECTION */
    TEST_TYPE_SIZE   (CRITICAL_SECTION, 40)
    TEST_TYPE_ALIGN  (CRITICAL_SECTION, 8)
}

static void test_pack_CRITICAL_SECTION_DEBUG(void)
{
    /* CRITICAL_SECTION_DEBUG */
}

static void test_pack_DCB(void)
{
    /* DCB */
    TEST_TYPE_SIZE   (DCB, 28)
    TEST_TYPE_ALIGN  (DCB, 4)
    TEST_FIELD_SIZE  (DCB, DCBlength, 4)
    TEST_FIELD_ALIGN (DCB, DCBlength, 4)
    TEST_FIELD_OFFSET(DCB, DCBlength, 0)
    TEST_FIELD_SIZE  (DCB, BaudRate, 4)
    TEST_FIELD_ALIGN (DCB, BaudRate, 4)
    TEST_FIELD_OFFSET(DCB, BaudRate, 4)
    TEST_FIELD_SIZE  (DCB, wReserved, 2)
    TEST_FIELD_ALIGN (DCB, wReserved, 2)
    TEST_FIELD_OFFSET(DCB, wReserved, 12)
    TEST_FIELD_SIZE  (DCB, XonLim, 2)
    TEST_FIELD_ALIGN (DCB, XonLim, 2)
    TEST_FIELD_OFFSET(DCB, XonLim, 14)
    TEST_FIELD_SIZE  (DCB, XoffLim, 2)
    TEST_FIELD_ALIGN (DCB, XoffLim, 2)
    TEST_FIELD_OFFSET(DCB, XoffLim, 16)
    TEST_FIELD_SIZE  (DCB, ByteSize, 1)
    TEST_FIELD_ALIGN (DCB, ByteSize, 1)
    TEST_FIELD_OFFSET(DCB, ByteSize, 18)
    TEST_FIELD_SIZE  (DCB, Parity, 1)
    TEST_FIELD_ALIGN (DCB, Parity, 1)
    TEST_FIELD_OFFSET(DCB, Parity, 19)
    TEST_FIELD_SIZE  (DCB, StopBits, 1)
    TEST_FIELD_ALIGN (DCB, StopBits, 1)
    TEST_FIELD_OFFSET(DCB, StopBits, 20)
    TEST_FIELD_SIZE  (DCB, XonChar, 1)
    TEST_FIELD_ALIGN (DCB, XonChar, 1)
    TEST_FIELD_OFFSET(DCB, XonChar, 21)
    TEST_FIELD_SIZE  (DCB, XoffChar, 1)
    TEST_FIELD_ALIGN (DCB, XoffChar, 1)
    TEST_FIELD_OFFSET(DCB, XoffChar, 22)
    TEST_FIELD_SIZE  (DCB, ErrorChar, 1)
    TEST_FIELD_ALIGN (DCB, ErrorChar, 1)
    TEST_FIELD_OFFSET(DCB, ErrorChar, 23)
    TEST_FIELD_SIZE  (DCB, EofChar, 1)
    TEST_FIELD_ALIGN (DCB, EofChar, 1)
    TEST_FIELD_OFFSET(DCB, EofChar, 24)
    TEST_FIELD_SIZE  (DCB, EvtChar, 1)
    TEST_FIELD_ALIGN (DCB, EvtChar, 1)
    TEST_FIELD_OFFSET(DCB, EvtChar, 25)
    TEST_FIELD_SIZE  (DCB, wReserved1, 2)
    TEST_FIELD_ALIGN (DCB, wReserved1, 2)
    TEST_FIELD_OFFSET(DCB, wReserved1, 26)
}

static void test_pack_DEBUG_EVENT(void)
{
    /* DEBUG_EVENT */
    TEST_FIELD_SIZE  (DEBUG_EVENT, dwDebugEventCode, 4)
    TEST_FIELD_ALIGN (DEBUG_EVENT, dwDebugEventCode, 4)
    TEST_FIELD_OFFSET(DEBUG_EVENT, dwDebugEventCode, 0)
    TEST_FIELD_SIZE  (DEBUG_EVENT, dwProcessId, 4)
    TEST_FIELD_ALIGN (DEBUG_EVENT, dwProcessId, 4)
    TEST_FIELD_OFFSET(DEBUG_EVENT, dwProcessId, 4)
    TEST_FIELD_SIZE  (DEBUG_EVENT, dwThreadId, 4)
    TEST_FIELD_ALIGN (DEBUG_EVENT, dwThreadId, 4)
    TEST_FIELD_OFFSET(DEBUG_EVENT, dwThreadId, 8)
}

static void test_pack_ENUMRESLANGPROCA(void)
{
    /* ENUMRESLANGPROCA */
    TEST_TYPE_SIZE   (ENUMRESLANGPROCA, 8)
    TEST_TYPE_ALIGN  (ENUMRESLANGPROCA, 8)
}

static void test_pack_ENUMRESLANGPROCW(void)
{
    /* ENUMRESLANGPROCW */
    TEST_TYPE_SIZE   (ENUMRESLANGPROCW, 8)
    TEST_TYPE_ALIGN  (ENUMRESLANGPROCW, 8)
}

static void test_pack_ENUMRESNAMEPROCA(void)
{
    /* ENUMRESNAMEPROCA */
    TEST_TYPE_SIZE   (ENUMRESNAMEPROCA, 8)
    TEST_TYPE_ALIGN  (ENUMRESNAMEPROCA, 8)
}

static void test_pack_ENUMRESNAMEPROCW(void)
{
    /* ENUMRESNAMEPROCW */
    TEST_TYPE_SIZE   (ENUMRESNAMEPROCW, 8)
    TEST_TYPE_ALIGN  (ENUMRESNAMEPROCW, 8)
}

static void test_pack_ENUMRESTYPEPROCA(void)
{
    /* ENUMRESTYPEPROCA */
    TEST_TYPE_SIZE   (ENUMRESTYPEPROCA, 8)
    TEST_TYPE_ALIGN  (ENUMRESTYPEPROCA, 8)
}

static void test_pack_ENUMRESTYPEPROCW(void)
{
    /* ENUMRESTYPEPROCW */
    TEST_TYPE_SIZE   (ENUMRESTYPEPROCW, 8)
    TEST_TYPE_ALIGN  (ENUMRESTYPEPROCW, 8)
}

static void test_pack_EXCEPTION_DEBUG_INFO(void)
{
    /* EXCEPTION_DEBUG_INFO */
    TEST_TYPE_SIZE   (EXCEPTION_DEBUG_INFO, 160)
    TEST_TYPE_ALIGN  (EXCEPTION_DEBUG_INFO, 8)
    TEST_FIELD_SIZE  (EXCEPTION_DEBUG_INFO, ExceptionRecord, 152)
    TEST_FIELD_ALIGN (EXCEPTION_DEBUG_INFO, ExceptionRecord, 8)
    TEST_FIELD_OFFSET(EXCEPTION_DEBUG_INFO, ExceptionRecord, 0)
    TEST_FIELD_SIZE  (EXCEPTION_DEBUG_INFO, dwFirstChance, 4)
    TEST_FIELD_ALIGN (EXCEPTION_DEBUG_INFO, dwFirstChance, 4)
    TEST_FIELD_OFFSET(EXCEPTION_DEBUG_INFO, dwFirstChance, 152)
}

static void test_pack_EXIT_PROCESS_DEBUG_INFO(void)
{
    /* EXIT_PROCESS_DEBUG_INFO */
    TEST_TYPE_SIZE   (EXIT_PROCESS_DEBUG_INFO, 4)
    TEST_TYPE_ALIGN  (EXIT_PROCESS_DEBUG_INFO, 4)
    TEST_FIELD_SIZE  (EXIT_PROCESS_DEBUG_INFO, dwExitCode, 4)
    TEST_FIELD_ALIGN (EXIT_PROCESS_DEBUG_INFO, dwExitCode, 4)
    TEST_FIELD_OFFSET(EXIT_PROCESS_DEBUG_INFO, dwExitCode, 0)
}

static void test_pack_EXIT_THREAD_DEBUG_INFO(void)
{
    /* EXIT_THREAD_DEBUG_INFO */
    TEST_TYPE_SIZE   (EXIT_THREAD_DEBUG_INFO, 4)
    TEST_TYPE_ALIGN  (EXIT_THREAD_DEBUG_INFO, 4)
    TEST_FIELD_SIZE  (EXIT_THREAD_DEBUG_INFO, dwExitCode, 4)
    TEST_FIELD_ALIGN (EXIT_THREAD_DEBUG_INFO, dwExitCode, 4)
    TEST_FIELD_OFFSET(EXIT_THREAD_DEBUG_INFO, dwExitCode, 0)
}

static void test_pack_HW_PROFILE_INFOA(void)
{
    /* HW_PROFILE_INFOA */
    TEST_TYPE_SIZE   (HW_PROFILE_INFOA, 124)
    TEST_TYPE_ALIGN  (HW_PROFILE_INFOA, 4)
    TEST_FIELD_SIZE  (HW_PROFILE_INFOA, dwDockInfo, 4)
    TEST_FIELD_ALIGN (HW_PROFILE_INFOA, dwDockInfo, 4)
    TEST_FIELD_OFFSET(HW_PROFILE_INFOA, dwDockInfo, 0)
    TEST_FIELD_SIZE  (HW_PROFILE_INFOA, szHwProfileGuid, 39)
    TEST_FIELD_ALIGN (HW_PROFILE_INFOA, szHwProfileGuid, 1)
    TEST_FIELD_OFFSET(HW_PROFILE_INFOA, szHwProfileGuid, 4)
    TEST_FIELD_SIZE  (HW_PROFILE_INFOA, szHwProfileName, 80)
    TEST_FIELD_ALIGN (HW_PROFILE_INFOA, szHwProfileName, 1)
    TEST_FIELD_OFFSET(HW_PROFILE_INFOA, szHwProfileName, 43)
}

static void test_pack_HW_PROFILE_INFOW(void)
{
    /* HW_PROFILE_INFOW */
    TEST_TYPE_SIZE   (HW_PROFILE_INFOW, 244)
    TEST_TYPE_ALIGN  (HW_PROFILE_INFOW, 4)
    TEST_FIELD_SIZE  (HW_PROFILE_INFOW, dwDockInfo, 4)
    TEST_FIELD_ALIGN (HW_PROFILE_INFOW, dwDockInfo, 4)
    TEST_FIELD_OFFSET(HW_PROFILE_INFOW, dwDockInfo, 0)
    TEST_FIELD_SIZE  (HW_PROFILE_INFOW, szHwProfileGuid, 78)
    TEST_FIELD_ALIGN (HW_PROFILE_INFOW, szHwProfileGuid, 2)
    TEST_FIELD_OFFSET(HW_PROFILE_INFOW, szHwProfileGuid, 4)
    TEST_FIELD_SIZE  (HW_PROFILE_INFOW, szHwProfileName, 160)
    TEST_FIELD_ALIGN (HW_PROFILE_INFOW, szHwProfileName, 2)
    TEST_FIELD_OFFSET(HW_PROFILE_INFOW, szHwProfileName, 82)
}

static void test_pack_LOAD_DLL_DEBUG_INFO(void)
{
    /* LOAD_DLL_DEBUG_INFO */
    TEST_TYPE_SIZE   (LOAD_DLL_DEBUG_INFO, 40)
    TEST_TYPE_ALIGN  (LOAD_DLL_DEBUG_INFO, 8)
    TEST_FIELD_SIZE  (LOAD_DLL_DEBUG_INFO, hFile, 8)
    TEST_FIELD_ALIGN (LOAD_DLL_DEBUG_INFO, hFile, 8)
    TEST_FIELD_OFFSET(LOAD_DLL_DEBUG_INFO, hFile, 0)
    TEST_FIELD_SIZE  (LOAD_DLL_DEBUG_INFO, lpBaseOfDll, 8)
    TEST_FIELD_ALIGN (LOAD_DLL_DEBUG_INFO, lpBaseOfDll, 8)
    TEST_FIELD_OFFSET(LOAD_DLL_DEBUG_INFO, lpBaseOfDll, 8)
    TEST_FIELD_SIZE  (LOAD_DLL_DEBUG_INFO, dwDebugInfoFileOffset, 4)
    TEST_FIELD_ALIGN (LOAD_DLL_DEBUG_INFO, dwDebugInfoFileOffset, 4)
    TEST_FIELD_OFFSET(LOAD_DLL_DEBUG_INFO, dwDebugInfoFileOffset, 16)
    TEST_FIELD_SIZE  (LOAD_DLL_DEBUG_INFO, nDebugInfoSize, 4)
    TEST_FIELD_ALIGN (LOAD_DLL_DEBUG_INFO, nDebugInfoSize, 4)
    TEST_FIELD_OFFSET(LOAD_DLL_DEBUG_INFO, nDebugInfoSize, 20)
    TEST_FIELD_SIZE  (LOAD_DLL_DEBUG_INFO, lpImageName, 8)
    TEST_FIELD_ALIGN (LOAD_DLL_DEBUG_INFO, lpImageName, 8)
    TEST_FIELD_OFFSET(LOAD_DLL_DEBUG_INFO, lpImageName, 24)
    TEST_FIELD_SIZE  (LOAD_DLL_DEBUG_INFO, fUnicode, 2)
    TEST_FIELD_ALIGN (LOAD_DLL_DEBUG_INFO, fUnicode, 2)
    TEST_FIELD_OFFSET(LOAD_DLL_DEBUG_INFO, fUnicode, 32)
}

static void test_pack_LPBY_HANDLE_FILE_INFORMATION(void)
{
    /* LPBY_HANDLE_FILE_INFORMATION */
    TEST_TYPE_SIZE   (LPBY_HANDLE_FILE_INFORMATION, 8)
    TEST_TYPE_ALIGN  (LPBY_HANDLE_FILE_INFORMATION, 8)
    TEST_TARGET_SIZE (LPBY_HANDLE_FILE_INFORMATION, 52)
    TEST_TARGET_ALIGN(LPBY_HANDLE_FILE_INFORMATION, 4)
}

static void test_pack_LPCOMMCONFIG(void)
{
    /* LPCOMMCONFIG */
    TEST_TYPE_SIZE   (LPCOMMCONFIG, 8)
    TEST_TYPE_ALIGN  (LPCOMMCONFIG, 8)
    TEST_TARGET_SIZE (LPCOMMCONFIG, 52)
    TEST_TARGET_ALIGN(LPCOMMCONFIG, 4)
}

static void test_pack_LPCOMMPROP(void)
{
    /* LPCOMMPROP */
    TEST_TYPE_SIZE   (LPCOMMPROP, 8)
    TEST_TYPE_ALIGN  (LPCOMMPROP, 8)
    TEST_TARGET_SIZE (LPCOMMPROP, 64)
    TEST_TARGET_ALIGN(LPCOMMPROP, 4)
}

static void test_pack_LPCOMMTIMEOUTS(void)
{
    /* LPCOMMTIMEOUTS */
    TEST_TYPE_SIZE   (LPCOMMTIMEOUTS, 8)
    TEST_TYPE_ALIGN  (LPCOMMTIMEOUTS, 8)
    TEST_TARGET_SIZE (LPCOMMTIMEOUTS, 20)
    TEST_TARGET_ALIGN(LPCOMMTIMEOUTS, 4)
}

static void test_pack_LPCOMSTAT(void)
{
    /* LPCOMSTAT */
    TEST_TYPE_SIZE   (LPCOMSTAT, 8)
    TEST_TYPE_ALIGN  (LPCOMSTAT, 8)
    TEST_TARGET_SIZE (LPCOMSTAT, 12)
    TEST_TARGET_ALIGN(LPCOMSTAT, 4)
}

static void test_pack_LPCRITICAL_SECTION(void)
{
    /* LPCRITICAL_SECTION */
    TEST_TYPE_SIZE   (LPCRITICAL_SECTION, 8)
    TEST_TYPE_ALIGN  (LPCRITICAL_SECTION, 8)
}

static void test_pack_LPCRITICAL_SECTION_DEBUG(void)
{
    /* LPCRITICAL_SECTION_DEBUG */
    TEST_TYPE_SIZE   (LPCRITICAL_SECTION_DEBUG, 8)
    TEST_TYPE_ALIGN  (LPCRITICAL_SECTION_DEBUG, 8)
}

static void test_pack_LPDCB(void)
{
    /* LPDCB */
    TEST_TYPE_SIZE   (LPDCB, 8)
    TEST_TYPE_ALIGN  (LPDCB, 8)
    TEST_TARGET_SIZE (LPDCB, 28)
    TEST_TARGET_ALIGN(LPDCB, 4)
}

static void test_pack_LPDEBUG_EVENT(void)
{
    /* LPDEBUG_EVENT */
    TEST_TYPE_SIZE   (LPDEBUG_EVENT, 8)
    TEST_TYPE_ALIGN  (LPDEBUG_EVENT, 8)
}

static void test_pack_LPEXCEPTION_POINTERS(void)
{
    /* LPEXCEPTION_POINTERS */
    TEST_TYPE_SIZE   (LPEXCEPTION_POINTERS, 8)
    TEST_TYPE_ALIGN  (LPEXCEPTION_POINTERS, 8)
}

static void test_pack_LPEXCEPTION_RECORD(void)
{
    /* LPEXCEPTION_RECORD */
    TEST_TYPE_SIZE   (LPEXCEPTION_RECORD, 8)
    TEST_TYPE_ALIGN  (LPEXCEPTION_RECORD, 8)
}

static void test_pack_LPFIBER_START_ROUTINE(void)
{
    /* LPFIBER_START_ROUTINE */
    TEST_TYPE_SIZE   (LPFIBER_START_ROUTINE, 8)
    TEST_TYPE_ALIGN  (LPFIBER_START_ROUTINE, 8)
}

static void test_pack_LPHW_PROFILE_INFOA(void)
{
    /* LPHW_PROFILE_INFOA */
    TEST_TYPE_SIZE   (LPHW_PROFILE_INFOA, 8)
    TEST_TYPE_ALIGN  (LPHW_PROFILE_INFOA, 8)
    TEST_TARGET_SIZE (LPHW_PROFILE_INFOA, 124)
    TEST_TARGET_ALIGN(LPHW_PROFILE_INFOA, 4)
}

static void test_pack_LPHW_PROFILE_INFOW(void)
{
    /* LPHW_PROFILE_INFOW */
    TEST_TYPE_SIZE   (LPHW_PROFILE_INFOW, 8)
    TEST_TYPE_ALIGN  (LPHW_PROFILE_INFOW, 8)
    TEST_TARGET_SIZE (LPHW_PROFILE_INFOW, 244)
    TEST_TARGET_ALIGN(LPHW_PROFILE_INFOW, 4)
}

static void test_pack_LPMEMORYSTATUS(void)
{
    /* LPMEMORYSTATUS */
    TEST_TYPE_SIZE   (LPMEMORYSTATUS, 8)
    TEST_TYPE_ALIGN  (LPMEMORYSTATUS, 8)
    TEST_TARGET_SIZE (LPMEMORYSTATUS, 56)
    TEST_TARGET_ALIGN(LPMEMORYSTATUS, 8)
}

static void test_pack_LPMEMORYSTATUSEX(void)
{
    /* LPMEMORYSTATUSEX */
    TEST_TYPE_SIZE   (LPMEMORYSTATUSEX, 8)
    TEST_TYPE_ALIGN  (LPMEMORYSTATUSEX, 8)
    TEST_TARGET_SIZE (LPMEMORYSTATUSEX, 64)
    TEST_TARGET_ALIGN(LPMEMORYSTATUSEX, 8)
}

static void test_pack_LPOFSTRUCT(void)
{
    /* LPOFSTRUCT */
    TEST_TYPE_SIZE   (LPOFSTRUCT, 8)
    TEST_TYPE_ALIGN  (LPOFSTRUCT, 8)
    TEST_TARGET_SIZE (LPOFSTRUCT, 136)
    TEST_TARGET_ALIGN(LPOFSTRUCT, 2)
}

static void test_pack_LPOVERLAPPED(void)
{
    /* LPOVERLAPPED */
    TEST_TYPE_SIZE   (LPOVERLAPPED, 8)
    TEST_TYPE_ALIGN  (LPOVERLAPPED, 8)
}

static void test_pack_LPOVERLAPPED_COMPLETION_ROUTINE(void)
{
    /* LPOVERLAPPED_COMPLETION_ROUTINE */
    TEST_TYPE_SIZE   (LPOVERLAPPED_COMPLETION_ROUTINE, 8)
    TEST_TYPE_ALIGN  (LPOVERLAPPED_COMPLETION_ROUTINE, 8)
}

static void test_pack_LPPROCESS_HEAP_ENTRY(void)
{
    /* LPPROCESS_HEAP_ENTRY */
    TEST_TYPE_SIZE   (LPPROCESS_HEAP_ENTRY, 8)
    TEST_TYPE_ALIGN  (LPPROCESS_HEAP_ENTRY, 8)
}

static void test_pack_LPPROCESS_INFORMATION(void)
{
    /* LPPROCESS_INFORMATION */
    TEST_TYPE_SIZE   (LPPROCESS_INFORMATION, 8)
    TEST_TYPE_ALIGN  (LPPROCESS_INFORMATION, 8)
    TEST_TARGET_SIZE (LPPROCESS_INFORMATION, 24)
    TEST_TARGET_ALIGN(LPPROCESS_INFORMATION, 8)
}

static void test_pack_LPPROGRESS_ROUTINE(void)
{
    /* LPPROGRESS_ROUTINE */
    TEST_TYPE_SIZE   (LPPROGRESS_ROUTINE, 8)
    TEST_TYPE_ALIGN  (LPPROGRESS_ROUTINE, 8)
}

static void test_pack_LPSECURITY_ATTRIBUTES(void)
{
    /* LPSECURITY_ATTRIBUTES */
    TEST_TYPE_SIZE   (LPSECURITY_ATTRIBUTES, 8)
    TEST_TYPE_ALIGN  (LPSECURITY_ATTRIBUTES, 8)
    TEST_TARGET_SIZE (LPSECURITY_ATTRIBUTES, 24)
    TEST_TARGET_ALIGN(LPSECURITY_ATTRIBUTES, 8)
}

static void test_pack_LPSTARTUPINFOA(void)
{
    /* LPSTARTUPINFOA */
    TEST_TYPE_SIZE   (LPSTARTUPINFOA, 8)
    TEST_TYPE_ALIGN  (LPSTARTUPINFOA, 8)
    TEST_TARGET_SIZE (LPSTARTUPINFOA, 104)
    TEST_TARGET_ALIGN(LPSTARTUPINFOA, 8)
}

static void test_pack_LPSTARTUPINFOW(void)
{
    /* LPSTARTUPINFOW */
    TEST_TYPE_SIZE   (LPSTARTUPINFOW, 8)
    TEST_TYPE_ALIGN  (LPSTARTUPINFOW, 8)
    TEST_TARGET_SIZE (LPSTARTUPINFOW, 104)
    TEST_TARGET_ALIGN(LPSTARTUPINFOW, 8)
}

static void test_pack_LPSYSTEMTIME(void)
{
    /* LPSYSTEMTIME */
    TEST_TYPE_SIZE   (LPSYSTEMTIME, 8)
    TEST_TYPE_ALIGN  (LPSYSTEMTIME, 8)
    TEST_TARGET_SIZE (LPSYSTEMTIME, 16)
    TEST_TARGET_ALIGN(LPSYSTEMTIME, 2)
}

static void test_pack_LPSYSTEM_INFO(void)
{
    /* LPSYSTEM_INFO */
    TEST_TYPE_SIZE   (LPSYSTEM_INFO, 8)
    TEST_TYPE_ALIGN  (LPSYSTEM_INFO, 8)
}

static void test_pack_LPSYSTEM_POWER_STATUS(void)
{
    /* LPSYSTEM_POWER_STATUS */
    TEST_TYPE_SIZE   (LPSYSTEM_POWER_STATUS, 8)
    TEST_TYPE_ALIGN  (LPSYSTEM_POWER_STATUS, 8)
    TEST_TARGET_SIZE (LPSYSTEM_POWER_STATUS, 12)
    TEST_TARGET_ALIGN(LPSYSTEM_POWER_STATUS, 4)
}

static void test_pack_LPTHREAD_START_ROUTINE(void)
{
    /* LPTHREAD_START_ROUTINE */
    TEST_TYPE_SIZE   (LPTHREAD_START_ROUTINE, 8)
    TEST_TYPE_ALIGN  (LPTHREAD_START_ROUTINE, 8)
}

static void test_pack_LPWIN32_FILE_ATTRIBUTE_DATA(void)
{
    /* LPWIN32_FILE_ATTRIBUTE_DATA */
    TEST_TYPE_SIZE   (LPWIN32_FILE_ATTRIBUTE_DATA, 8)
    TEST_TYPE_ALIGN  (LPWIN32_FILE_ATTRIBUTE_DATA, 8)
    TEST_TARGET_SIZE (LPWIN32_FILE_ATTRIBUTE_DATA, 36)
    TEST_TARGET_ALIGN(LPWIN32_FILE_ATTRIBUTE_DATA, 4)
}

static void test_pack_LPWIN32_FIND_DATAA(void)
{
    /* LPWIN32_FIND_DATAA */
    TEST_TYPE_SIZE   (LPWIN32_FIND_DATAA, 8)
    TEST_TYPE_ALIGN  (LPWIN32_FIND_DATAA, 8)
    TEST_TARGET_SIZE (LPWIN32_FIND_DATAA, 320)
    TEST_TARGET_ALIGN(LPWIN32_FIND_DATAA, 4)
}

static void test_pack_LPWIN32_FIND_DATAW(void)
{
    /* LPWIN32_FIND_DATAW */
    TEST_TYPE_SIZE   (LPWIN32_FIND_DATAW, 8)
    TEST_TYPE_ALIGN  (LPWIN32_FIND_DATAW, 8)
    TEST_TARGET_SIZE (LPWIN32_FIND_DATAW, 592)
    TEST_TARGET_ALIGN(LPWIN32_FIND_DATAW, 4)
}

static void test_pack_LPWIN32_STREAM_ID(void)
{
    /* LPWIN32_STREAM_ID */
    TEST_TYPE_SIZE   (LPWIN32_STREAM_ID, 8)
    TEST_TYPE_ALIGN  (LPWIN32_STREAM_ID, 8)
    TEST_TARGET_SIZE (LPWIN32_STREAM_ID, 24)
    TEST_TARGET_ALIGN(LPWIN32_STREAM_ID, 8)
}

static void test_pack_MEMORYSTATUS(void)
{
    /* MEMORYSTATUS */
    TEST_TYPE_SIZE   (MEMORYSTATUS, 56)
    TEST_TYPE_ALIGN  (MEMORYSTATUS, 8)
    TEST_FIELD_SIZE  (MEMORYSTATUS, dwLength, 4)
    TEST_FIELD_ALIGN (MEMORYSTATUS, dwLength, 4)
    TEST_FIELD_OFFSET(MEMORYSTATUS, dwLength, 0)
    TEST_FIELD_SIZE  (MEMORYSTATUS, dwMemoryLoad, 4)
    TEST_FIELD_ALIGN (MEMORYSTATUS, dwMemoryLoad, 4)
    TEST_FIELD_OFFSET(MEMORYSTATUS, dwMemoryLoad, 4)
    TEST_FIELD_SIZE  (MEMORYSTATUS, dwTotalPhys, 8)
    TEST_FIELD_ALIGN (MEMORYSTATUS, dwTotalPhys, 8)
    TEST_FIELD_OFFSET(MEMORYSTATUS, dwTotalPhys, 8)
    TEST_FIELD_SIZE  (MEMORYSTATUS, dwAvailPhys, 8)
    TEST_FIELD_ALIGN (MEMORYSTATUS, dwAvailPhys, 8)
    TEST_FIELD_OFFSET(MEMORYSTATUS, dwAvailPhys, 16)
    TEST_FIELD_SIZE  (MEMORYSTATUS, dwTotalPageFile, 8)
    TEST_FIELD_ALIGN (MEMORYSTATUS, dwTotalPageFile, 8)
    TEST_FIELD_OFFSET(MEMORYSTATUS, dwTotalPageFile, 24)
    TEST_FIELD_SIZE  (MEMORYSTATUS, dwAvailPageFile, 8)
    TEST_FIELD_ALIGN (MEMORYSTATUS, dwAvailPageFile, 8)
    TEST_FIELD_OFFSET(MEMORYSTATUS, dwAvailPageFile, 32)
    TEST_FIELD_SIZE  (MEMORYSTATUS, dwTotalVirtual, 8)
    TEST_FIELD_ALIGN (MEMORYSTATUS, dwTotalVirtual, 8)
    TEST_FIELD_OFFSET(MEMORYSTATUS, dwTotalVirtual, 40)
    TEST_FIELD_SIZE  (MEMORYSTATUS, dwAvailVirtual, 8)
    TEST_FIELD_ALIGN (MEMORYSTATUS, dwAvailVirtual, 8)
    TEST_FIELD_OFFSET(MEMORYSTATUS, dwAvailVirtual, 48)
}

static void test_pack_MEMORYSTATUSEX(void)
{
    /* MEMORYSTATUSEX (pack 8) */
    TEST_TYPE_SIZE   (MEMORYSTATUSEX, 64)
    TEST_TYPE_ALIGN  (MEMORYSTATUSEX, 8)
    TEST_FIELD_SIZE  (MEMORYSTATUSEX, dwLength, 4)
    TEST_FIELD_ALIGN (MEMORYSTATUSEX, dwLength, 4)
    TEST_FIELD_OFFSET(MEMORYSTATUSEX, dwLength, 0)
    TEST_FIELD_SIZE  (MEMORYSTATUSEX, dwMemoryLoad, 4)
    TEST_FIELD_ALIGN (MEMORYSTATUSEX, dwMemoryLoad, 4)
    TEST_FIELD_OFFSET(MEMORYSTATUSEX, dwMemoryLoad, 4)
    TEST_FIELD_SIZE  (MEMORYSTATUSEX, ullTotalPhys, 8)
    TEST_FIELD_ALIGN (MEMORYSTATUSEX, ullTotalPhys, 8)
    TEST_FIELD_OFFSET(MEMORYSTATUSEX, ullTotalPhys, 8)
    TEST_FIELD_SIZE  (MEMORYSTATUSEX, ullAvailPhys, 8)
    TEST_FIELD_ALIGN (MEMORYSTATUSEX, ullAvailPhys, 8)
    TEST_FIELD_OFFSET(MEMORYSTATUSEX, ullAvailPhys, 16)
    TEST_FIELD_SIZE  (MEMORYSTATUSEX, ullTotalPageFile, 8)
    TEST_FIELD_ALIGN (MEMORYSTATUSEX, ullTotalPageFile, 8)
    TEST_FIELD_OFFSET(MEMORYSTATUSEX, ullTotalPageFile, 24)
    TEST_FIELD_SIZE  (MEMORYSTATUSEX, ullAvailPageFile, 8)
    TEST_FIELD_ALIGN (MEMORYSTATUSEX, ullAvailPageFile, 8)
    TEST_FIELD_OFFSET(MEMORYSTATUSEX, ullAvailPageFile, 32)
    TEST_FIELD_SIZE  (MEMORYSTATUSEX, ullTotalVirtual, 8)
    TEST_FIELD_ALIGN (MEMORYSTATUSEX, ullTotalVirtual, 8)
    TEST_FIELD_OFFSET(MEMORYSTATUSEX, ullTotalVirtual, 40)
    TEST_FIELD_SIZE  (MEMORYSTATUSEX, ullAvailVirtual, 8)
    TEST_FIELD_ALIGN (MEMORYSTATUSEX, ullAvailVirtual, 8)
    TEST_FIELD_OFFSET(MEMORYSTATUSEX, ullAvailVirtual, 48)
    TEST_FIELD_SIZE  (MEMORYSTATUSEX, ullAvailExtendedVirtual, 8)
    TEST_FIELD_ALIGN (MEMORYSTATUSEX, ullAvailExtendedVirtual, 8)
    TEST_FIELD_OFFSET(MEMORYSTATUSEX, ullAvailExtendedVirtual, 56)
}

static void test_pack_OFSTRUCT(void)
{
    /* OFSTRUCT */
    TEST_TYPE_SIZE   (OFSTRUCT, 136)
    TEST_TYPE_ALIGN  (OFSTRUCT, 2)
    TEST_FIELD_SIZE  (OFSTRUCT, cBytes, 1)
    TEST_FIELD_ALIGN (OFSTRUCT, cBytes, 1)
    TEST_FIELD_OFFSET(OFSTRUCT, cBytes, 0)
    TEST_FIELD_SIZE  (OFSTRUCT, fFixedDisk, 1)
    TEST_FIELD_ALIGN (OFSTRUCT, fFixedDisk, 1)
    TEST_FIELD_OFFSET(OFSTRUCT, fFixedDisk, 1)
    TEST_FIELD_SIZE  (OFSTRUCT, nErrCode, 2)
    TEST_FIELD_ALIGN (OFSTRUCT, nErrCode, 2)
    TEST_FIELD_OFFSET(OFSTRUCT, nErrCode, 2)
    TEST_FIELD_SIZE  (OFSTRUCT, Reserved1, 2)
    TEST_FIELD_ALIGN (OFSTRUCT, Reserved1, 2)
    TEST_FIELD_OFFSET(OFSTRUCT, Reserved1, 4)
    TEST_FIELD_SIZE  (OFSTRUCT, Reserved2, 2)
    TEST_FIELD_ALIGN (OFSTRUCT, Reserved2, 2)
    TEST_FIELD_OFFSET(OFSTRUCT, Reserved2, 6)
    TEST_FIELD_SIZE  (OFSTRUCT, szPathName, 128)
    TEST_FIELD_ALIGN (OFSTRUCT, szPathName, 1)
    TEST_FIELD_OFFSET(OFSTRUCT, szPathName, 8)
}

static void test_pack_OUTPUT_DEBUG_STRING_INFO(void)
{
    /* OUTPUT_DEBUG_STRING_INFO */
    TEST_TYPE_SIZE   (OUTPUT_DEBUG_STRING_INFO, 16)
    TEST_TYPE_ALIGN  (OUTPUT_DEBUG_STRING_INFO, 8)
    TEST_FIELD_SIZE  (OUTPUT_DEBUG_STRING_INFO, lpDebugStringData, 8)
    TEST_FIELD_ALIGN (OUTPUT_DEBUG_STRING_INFO, lpDebugStringData, 8)
    TEST_FIELD_OFFSET(OUTPUT_DEBUG_STRING_INFO, lpDebugStringData, 0)
    TEST_FIELD_SIZE  (OUTPUT_DEBUG_STRING_INFO, fUnicode, 2)
    TEST_FIELD_ALIGN (OUTPUT_DEBUG_STRING_INFO, fUnicode, 2)
    TEST_FIELD_OFFSET(OUTPUT_DEBUG_STRING_INFO, fUnicode, 8)
    TEST_FIELD_SIZE  (OUTPUT_DEBUG_STRING_INFO, nDebugStringLength, 2)
    TEST_FIELD_ALIGN (OUTPUT_DEBUG_STRING_INFO, nDebugStringLength, 2)
    TEST_FIELD_OFFSET(OUTPUT_DEBUG_STRING_INFO, nDebugStringLength, 10)
}

static void test_pack_PACTCTXA(void)
{
    /* PACTCTXA */
    TEST_TYPE_SIZE   (PACTCTXA, 8)
    TEST_TYPE_ALIGN  (PACTCTXA, 8)
    TEST_TARGET_SIZE (PACTCTXA, 56)
    TEST_TARGET_ALIGN(PACTCTXA, 8)
}

static void test_pack_PACTCTXW(void)
{
    /* PACTCTXW */
    TEST_TYPE_SIZE   (PACTCTXW, 8)
    TEST_TYPE_ALIGN  (PACTCTXW, 8)
    TEST_TARGET_SIZE (PACTCTXW, 56)
    TEST_TARGET_ALIGN(PACTCTXW, 8)
}

static void test_pack_PACTCTX_SECTION_KEYED_DATA(void)
{
    /* PACTCTX_SECTION_KEYED_DATA */
    TEST_TYPE_SIZE   (PACTCTX_SECTION_KEYED_DATA, 8)
    TEST_TYPE_ALIGN  (PACTCTX_SECTION_KEYED_DATA, 8)
    TEST_TARGET_SIZE (PACTCTX_SECTION_KEYED_DATA, 112)
    TEST_TARGET_ALIGN(PACTCTX_SECTION_KEYED_DATA, 8)
}

static void test_pack_PACTCTX_SECTION_KEYED_DATA_2600(void)
{
    /* PACTCTX_SECTION_KEYED_DATA_2600 */
    TEST_TYPE_SIZE   (PACTCTX_SECTION_KEYED_DATA_2600, 8)
    TEST_TYPE_ALIGN  (PACTCTX_SECTION_KEYED_DATA_2600, 8)
    TEST_TARGET_SIZE (PACTCTX_SECTION_KEYED_DATA_2600, 72)
    TEST_TARGET_ALIGN(PACTCTX_SECTION_KEYED_DATA_2600, 8)
}

static void test_pack_PACTCTX_SECTION_KEYED_DATA_ASSEMBLY_METADATA(void)
{
    /* PACTCTX_SECTION_KEYED_DATA_ASSEMBLY_METADATA */
    TEST_TYPE_SIZE   (PACTCTX_SECTION_KEYED_DATA_ASSEMBLY_METADATA, 8)
    TEST_TYPE_ALIGN  (PACTCTX_SECTION_KEYED_DATA_ASSEMBLY_METADATA, 8)
    TEST_TARGET_SIZE (PACTCTX_SECTION_KEYED_DATA_ASSEMBLY_METADATA, 40)
    TEST_TARGET_ALIGN(PACTCTX_SECTION_KEYED_DATA_ASSEMBLY_METADATA, 8)
}

static void test_pack_PACTIVATION_CONTEXT_BASIC_INFORMATION(void)
{
    /* PACTIVATION_CONTEXT_BASIC_INFORMATION */
    TEST_TYPE_SIZE   (PACTIVATION_CONTEXT_BASIC_INFORMATION, 8)
    TEST_TYPE_ALIGN  (PACTIVATION_CONTEXT_BASIC_INFORMATION, 8)
    TEST_TARGET_SIZE (PACTIVATION_CONTEXT_BASIC_INFORMATION, 16)
    TEST_TARGET_ALIGN(PACTIVATION_CONTEXT_BASIC_INFORMATION, 8)
}

static void test_pack_PAPCFUNC(void)
{
    /* PAPCFUNC */
    TEST_TYPE_SIZE   (PAPCFUNC, 8)
    TEST_TYPE_ALIGN  (PAPCFUNC, 8)
}

static void test_pack_PBY_HANDLE_FILE_INFORMATION(void)
{
    /* PBY_HANDLE_FILE_INFORMATION */
    TEST_TYPE_SIZE   (PBY_HANDLE_FILE_INFORMATION, 8)
    TEST_TYPE_ALIGN  (PBY_HANDLE_FILE_INFORMATION, 8)
    TEST_TARGET_SIZE (PBY_HANDLE_FILE_INFORMATION, 52)
    TEST_TARGET_ALIGN(PBY_HANDLE_FILE_INFORMATION, 4)
}

static void test_pack_PCACTCTXA(void)
{
    /* PCACTCTXA */
    TEST_TYPE_SIZE   (PCACTCTXA, 8)
    TEST_TYPE_ALIGN  (PCACTCTXA, 8)
    TEST_TARGET_SIZE (PCACTCTXA, 56)
    TEST_TARGET_ALIGN(PCACTCTXA, 8)
}

static void test_pack_PCACTCTXW(void)
{
    /* PCACTCTXW */
    TEST_TYPE_SIZE   (PCACTCTXW, 8)
    TEST_TYPE_ALIGN  (PCACTCTXW, 8)
    TEST_TARGET_SIZE (PCACTCTXW, 56)
    TEST_TARGET_ALIGN(PCACTCTXW, 8)
}

static void test_pack_PCACTCTX_SECTION_KEYED_DATA(void)
{
    /* PCACTCTX_SECTION_KEYED_DATA */
    TEST_TYPE_SIZE   (PCACTCTX_SECTION_KEYED_DATA, 8)
    TEST_TYPE_ALIGN  (PCACTCTX_SECTION_KEYED_DATA, 8)
    TEST_TARGET_SIZE (PCACTCTX_SECTION_KEYED_DATA, 112)
    TEST_TARGET_ALIGN(PCACTCTX_SECTION_KEYED_DATA, 8)
}

static void test_pack_PCACTCTX_SECTION_KEYED_DATA_2600(void)
{
    /* PCACTCTX_SECTION_KEYED_DATA_2600 */
    TEST_TYPE_SIZE   (PCACTCTX_SECTION_KEYED_DATA_2600, 8)
    TEST_TYPE_ALIGN  (PCACTCTX_SECTION_KEYED_DATA_2600, 8)
    TEST_TARGET_SIZE (PCACTCTX_SECTION_KEYED_DATA_2600, 72)
    TEST_TARGET_ALIGN(PCACTCTX_SECTION_KEYED_DATA_2600, 8)
}

static void test_pack_PCACTCTX_SECTION_KEYED_DATA_ASSEMBLY_METADATA(void)
{
    /* PCACTCTX_SECTION_KEYED_DATA_ASSEMBLY_METADATA */
    TEST_TYPE_SIZE   (PCACTCTX_SECTION_KEYED_DATA_ASSEMBLY_METADATA, 8)
    TEST_TYPE_ALIGN  (PCACTCTX_SECTION_KEYED_DATA_ASSEMBLY_METADATA, 8)
    TEST_TARGET_SIZE (PCACTCTX_SECTION_KEYED_DATA_ASSEMBLY_METADATA, 40)
    TEST_TARGET_ALIGN(PCACTCTX_SECTION_KEYED_DATA_ASSEMBLY_METADATA, 8)
}

static void test_pack_PCRITICAL_SECTION(void)
{
    /* PCRITICAL_SECTION */
    TEST_TYPE_SIZE   (PCRITICAL_SECTION, 8)
    TEST_TYPE_ALIGN  (PCRITICAL_SECTION, 8)
}

static void test_pack_PCRITICAL_SECTION_DEBUG(void)
{
    /* PCRITICAL_SECTION_DEBUG */
    TEST_TYPE_SIZE   (PCRITICAL_SECTION_DEBUG, 8)
    TEST_TYPE_ALIGN  (PCRITICAL_SECTION_DEBUG, 8)
}

static void test_pack_PFIBER_START_ROUTINE(void)
{
    /* PFIBER_START_ROUTINE */
    TEST_TYPE_SIZE   (PFIBER_START_ROUTINE, 8)
    TEST_TYPE_ALIGN  (PFIBER_START_ROUTINE, 8)
}

static void test_pack_POFSTRUCT(void)
{
    /* POFSTRUCT */
    TEST_TYPE_SIZE   (POFSTRUCT, 8)
    TEST_TYPE_ALIGN  (POFSTRUCT, 8)
    TEST_TARGET_SIZE (POFSTRUCT, 136)
    TEST_TARGET_ALIGN(POFSTRUCT, 2)
}

static void test_pack_PPROCESS_HEAP_ENTRY(void)
{
    /* PPROCESS_HEAP_ENTRY */
    TEST_TYPE_SIZE   (PPROCESS_HEAP_ENTRY, 8)
    TEST_TYPE_ALIGN  (PPROCESS_HEAP_ENTRY, 8)
}

static void test_pack_PPROCESS_INFORMATION(void)
{
    /* PPROCESS_INFORMATION */
    TEST_TYPE_SIZE   (PPROCESS_INFORMATION, 8)
    TEST_TYPE_ALIGN  (PPROCESS_INFORMATION, 8)
    TEST_TARGET_SIZE (PPROCESS_INFORMATION, 24)
    TEST_TARGET_ALIGN(PPROCESS_INFORMATION, 8)
}

static void test_pack_PQUERYACTCTXW_FUNC(void)
{
    /* PQUERYACTCTXW_FUNC */
    TEST_TYPE_SIZE   (PQUERYACTCTXW_FUNC, 8)
    TEST_TYPE_ALIGN  (PQUERYACTCTXW_FUNC, 8)
}

static void test_pack_PROCESS_HEAP_ENTRY(void)
{
    /* PROCESS_HEAP_ENTRY */
    TEST_FIELD_SIZE  (PROCESS_HEAP_ENTRY, lpData, 8)
    TEST_FIELD_ALIGN (PROCESS_HEAP_ENTRY, lpData, 8)
    TEST_FIELD_OFFSET(PROCESS_HEAP_ENTRY, lpData, 0)
    TEST_FIELD_SIZE  (PROCESS_HEAP_ENTRY, cbData, 4)
    TEST_FIELD_ALIGN (PROCESS_HEAP_ENTRY, cbData, 4)
    TEST_FIELD_OFFSET(PROCESS_HEAP_ENTRY, cbData, 8)
    TEST_FIELD_SIZE  (PROCESS_HEAP_ENTRY, cbOverhead, 1)
    TEST_FIELD_ALIGN (PROCESS_HEAP_ENTRY, cbOverhead, 1)
    TEST_FIELD_OFFSET(PROCESS_HEAP_ENTRY, cbOverhead, 12)
    TEST_FIELD_SIZE  (PROCESS_HEAP_ENTRY, iRegionIndex, 1)
    TEST_FIELD_ALIGN (PROCESS_HEAP_ENTRY, iRegionIndex, 1)
    TEST_FIELD_OFFSET(PROCESS_HEAP_ENTRY, iRegionIndex, 13)
    TEST_FIELD_SIZE  (PROCESS_HEAP_ENTRY, wFlags, 2)
    TEST_FIELD_ALIGN (PROCESS_HEAP_ENTRY, wFlags, 2)
    TEST_FIELD_OFFSET(PROCESS_HEAP_ENTRY, wFlags, 14)
}

static void test_pack_PROCESS_INFORMATION(void)
{
    /* PROCESS_INFORMATION */
    TEST_TYPE_SIZE   (PROCESS_INFORMATION, 24)
    TEST_TYPE_ALIGN  (PROCESS_INFORMATION, 8)
    TEST_FIELD_SIZE  (PROCESS_INFORMATION, hProcess, 8)
    TEST_FIELD_ALIGN (PROCESS_INFORMATION, hProcess, 8)
    TEST_FIELD_OFFSET(PROCESS_INFORMATION, hProcess, 0)
    TEST_FIELD_SIZE  (PROCESS_INFORMATION, hThread, 8)
    TEST_FIELD_ALIGN (PROCESS_INFORMATION, hThread, 8)
    TEST_FIELD_OFFSET(PROCESS_INFORMATION, hThread, 8)
    TEST_FIELD_SIZE  (PROCESS_INFORMATION, dwProcessId, 4)
    TEST_FIELD_ALIGN (PROCESS_INFORMATION, dwProcessId, 4)
    TEST_FIELD_OFFSET(PROCESS_INFORMATION, dwProcessId, 16)
    TEST_FIELD_SIZE  (PROCESS_INFORMATION, dwThreadId, 4)
    TEST_FIELD_ALIGN (PROCESS_INFORMATION, dwThreadId, 4)
    TEST_FIELD_OFFSET(PROCESS_INFORMATION, dwThreadId, 20)
}

static void test_pack_PSECURITY_ATTRIBUTES(void)
{
    /* PSECURITY_ATTRIBUTES */
    TEST_TYPE_SIZE   (PSECURITY_ATTRIBUTES, 8)
    TEST_TYPE_ALIGN  (PSECURITY_ATTRIBUTES, 8)
    TEST_TARGET_SIZE (PSECURITY_ATTRIBUTES, 24)
    TEST_TARGET_ALIGN(PSECURITY_ATTRIBUTES, 8)
}

static void test_pack_PSYSTEMTIME(void)
{
    /* PSYSTEMTIME */
    TEST_TYPE_SIZE   (PSYSTEMTIME, 8)
    TEST_TYPE_ALIGN  (PSYSTEMTIME, 8)
    TEST_TARGET_SIZE (PSYSTEMTIME, 16)
    TEST_TARGET_ALIGN(PSYSTEMTIME, 2)
}

static void test_pack_PTIMERAPCROUTINE(void)
{
    /* PTIMERAPCROUTINE */
    TEST_TYPE_SIZE   (PTIMERAPCROUTINE, 8)
    TEST_TYPE_ALIGN  (PTIMERAPCROUTINE, 8)
}

static void test_pack_PWIN32_FIND_DATAA(void)
{
    /* PWIN32_FIND_DATAA */
    TEST_TYPE_SIZE   (PWIN32_FIND_DATAA, 8)
    TEST_TYPE_ALIGN  (PWIN32_FIND_DATAA, 8)
    TEST_TARGET_SIZE (PWIN32_FIND_DATAA, 320)
    TEST_TARGET_ALIGN(PWIN32_FIND_DATAA, 4)
}

static void test_pack_PWIN32_FIND_DATAW(void)
{
    /* PWIN32_FIND_DATAW */
    TEST_TYPE_SIZE   (PWIN32_FIND_DATAW, 8)
    TEST_TYPE_ALIGN  (PWIN32_FIND_DATAW, 8)
    TEST_TARGET_SIZE (PWIN32_FIND_DATAW, 592)
    TEST_TARGET_ALIGN(PWIN32_FIND_DATAW, 4)
}

static void test_pack_RIP_INFO(void)
{
    /* RIP_INFO */
    TEST_TYPE_SIZE   (RIP_INFO, 8)
    TEST_TYPE_ALIGN  (RIP_INFO, 4)
    TEST_FIELD_SIZE  (RIP_INFO, dwError, 4)
    TEST_FIELD_ALIGN (RIP_INFO, dwError, 4)
    TEST_FIELD_OFFSET(RIP_INFO, dwError, 0)
    TEST_FIELD_SIZE  (RIP_INFO, dwType, 4)
    TEST_FIELD_ALIGN (RIP_INFO, dwType, 4)
    TEST_FIELD_OFFSET(RIP_INFO, dwType, 4)
}

static void test_pack_SECURITY_ATTRIBUTES(void)
{
    /* SECURITY_ATTRIBUTES */
    TEST_TYPE_SIZE   (SECURITY_ATTRIBUTES, 24)
    TEST_TYPE_ALIGN  (SECURITY_ATTRIBUTES, 8)
    TEST_FIELD_SIZE  (SECURITY_ATTRIBUTES, nLength, 4)
    TEST_FIELD_ALIGN (SECURITY_ATTRIBUTES, nLength, 4)
    TEST_FIELD_OFFSET(SECURITY_ATTRIBUTES, nLength, 0)
    TEST_FIELD_SIZE  (SECURITY_ATTRIBUTES, lpSecurityDescriptor, 8)
    TEST_FIELD_ALIGN (SECURITY_ATTRIBUTES, lpSecurityDescriptor, 8)
    TEST_FIELD_OFFSET(SECURITY_ATTRIBUTES, lpSecurityDescriptor, 8)
    TEST_FIELD_SIZE  (SECURITY_ATTRIBUTES, bInheritHandle, 4)
    TEST_FIELD_ALIGN (SECURITY_ATTRIBUTES, bInheritHandle, 4)
    TEST_FIELD_OFFSET(SECURITY_ATTRIBUTES, bInheritHandle, 16)
}

static void test_pack_STARTUPINFOA(void)
{
    /* STARTUPINFOA */
    TEST_TYPE_SIZE   (STARTUPINFOA, 104)
    TEST_TYPE_ALIGN  (STARTUPINFOA, 8)
    TEST_FIELD_SIZE  (STARTUPINFOA, cb, 4)
    TEST_FIELD_ALIGN (STARTUPINFOA, cb, 4)
    TEST_FIELD_OFFSET(STARTUPINFOA, cb, 0)
    TEST_FIELD_SIZE  (STARTUPINFOA, lpReserved, 8)
    TEST_FIELD_ALIGN (STARTUPINFOA, lpReserved, 8)
    TEST_FIELD_OFFSET(STARTUPINFOA, lpReserved, 8)
    TEST_FIELD_SIZE  (STARTUPINFOA, lpDesktop, 8)
    TEST_FIELD_ALIGN (STARTUPINFOA, lpDesktop, 8)
    TEST_FIELD_OFFSET(STARTUPINFOA, lpDesktop, 16)
    TEST_FIELD_SIZE  (STARTUPINFOA, lpTitle, 8)
    TEST_FIELD_ALIGN (STARTUPINFOA, lpTitle, 8)
    TEST_FIELD_OFFSET(STARTUPINFOA, lpTitle, 24)
    TEST_FIELD_SIZE  (STARTUPINFOA, dwX, 4)
    TEST_FIELD_ALIGN (STARTUPINFOA, dwX, 4)
    TEST_FIELD_OFFSET(STARTUPINFOA, dwX, 32)
    TEST_FIELD_SIZE  (STARTUPINFOA, dwY, 4)
    TEST_FIELD_ALIGN (STARTUPINFOA, dwY, 4)
    TEST_FIELD_OFFSET(STARTUPINFOA, dwY, 36)
    TEST_FIELD_SIZE  (STARTUPINFOA, dwXSize, 4)
    TEST_FIELD_ALIGN (STARTUPINFOA, dwXSize, 4)
    TEST_FIELD_OFFSET(STARTUPINFOA, dwXSize, 40)
    TEST_FIELD_SIZE  (STARTUPINFOA, dwYSize, 4)
    TEST_FIELD_ALIGN (STARTUPINFOA, dwYSize, 4)
    TEST_FIELD_OFFSET(STARTUPINFOA, dwYSize, 44)
    TEST_FIELD_SIZE  (STARTUPINFOA, dwXCountChars, 4)
    TEST_FIELD_ALIGN (STARTUPINFOA, dwXCountChars, 4)
    TEST_FIELD_OFFSET(STARTUPINFOA, dwXCountChars, 48)
    TEST_FIELD_SIZE  (STARTUPINFOA, dwYCountChars, 4)
    TEST_FIELD_ALIGN (STARTUPINFOA, dwYCountChars, 4)
    TEST_FIELD_OFFSET(STARTUPINFOA, dwYCountChars, 52)
    TEST_FIELD_SIZE  (STARTUPINFOA, dwFillAttribute, 4)
    TEST_FIELD_ALIGN (STARTUPINFOA, dwFillAttribute, 4)
    TEST_FIELD_OFFSET(STARTUPINFOA, dwFillAttribute, 56)
    TEST_FIELD_SIZE  (STARTUPINFOA, dwFlags, 4)
    TEST_FIELD_ALIGN (STARTUPINFOA, dwFlags, 4)
    TEST_FIELD_OFFSET(STARTUPINFOA, dwFlags, 60)
    TEST_FIELD_SIZE  (STARTUPINFOA, wShowWindow, 2)
    TEST_FIELD_ALIGN (STARTUPINFOA, wShowWindow, 2)
    TEST_FIELD_OFFSET(STARTUPINFOA, wShowWindow, 64)
    TEST_FIELD_SIZE  (STARTUPINFOA, cbReserved2, 2)
    TEST_FIELD_ALIGN (STARTUPINFOA, cbReserved2, 2)
    TEST_FIELD_OFFSET(STARTUPINFOA, cbReserved2, 66)
    TEST_FIELD_SIZE  (STARTUPINFOA, lpReserved2, 8)
    TEST_FIELD_ALIGN (STARTUPINFOA, lpReserved2, 8)
    TEST_FIELD_OFFSET(STARTUPINFOA, lpReserved2, 72)
    TEST_FIELD_SIZE  (STARTUPINFOA, hStdInput, 8)
    TEST_FIELD_ALIGN (STARTUPINFOA, hStdInput, 8)
    TEST_FIELD_OFFSET(STARTUPINFOA, hStdInput, 80)
    TEST_FIELD_SIZE  (STARTUPINFOA, hStdOutput, 8)
    TEST_FIELD_ALIGN (STARTUPINFOA, hStdOutput, 8)
    TEST_FIELD_OFFSET(STARTUPINFOA, hStdOutput, 88)
    TEST_FIELD_SIZE  (STARTUPINFOA, hStdError, 8)
    TEST_FIELD_ALIGN (STARTUPINFOA, hStdError, 8)
    TEST_FIELD_OFFSET(STARTUPINFOA, hStdError, 96)
}

static void test_pack_STARTUPINFOW(void)
{
    /* STARTUPINFOW */
    TEST_TYPE_SIZE   (STARTUPINFOW, 104)
    TEST_TYPE_ALIGN  (STARTUPINFOW, 8)
    TEST_FIELD_SIZE  (STARTUPINFOW, cb, 4)
    TEST_FIELD_ALIGN (STARTUPINFOW, cb, 4)
    TEST_FIELD_OFFSET(STARTUPINFOW, cb, 0)
    TEST_FIELD_SIZE  (STARTUPINFOW, lpReserved, 8)
    TEST_FIELD_ALIGN (STARTUPINFOW, lpReserved, 8)
    TEST_FIELD_OFFSET(STARTUPINFOW, lpReserved, 8)
    TEST_FIELD_SIZE  (STARTUPINFOW, lpDesktop, 8)
    TEST_FIELD_ALIGN (STARTUPINFOW, lpDesktop, 8)
    TEST_FIELD_OFFSET(STARTUPINFOW, lpDesktop, 16)
    TEST_FIELD_SIZE  (STARTUPINFOW, lpTitle, 8)
    TEST_FIELD_ALIGN (STARTUPINFOW, lpTitle, 8)
    TEST_FIELD_OFFSET(STARTUPINFOW, lpTitle, 24)
    TEST_FIELD_SIZE  (STARTUPINFOW, dwX, 4)
    TEST_FIELD_ALIGN (STARTUPINFOW, dwX, 4)
    TEST_FIELD_OFFSET(STARTUPINFOW, dwX, 32)
    TEST_FIELD_SIZE  (STARTUPINFOW, dwY, 4)
    TEST_FIELD_ALIGN (STARTUPINFOW, dwY, 4)
    TEST_FIELD_OFFSET(STARTUPINFOW, dwY, 36)
    TEST_FIELD_SIZE  (STARTUPINFOW, dwXSize, 4)
    TEST_FIELD_ALIGN (STARTUPINFOW, dwXSize, 4)
    TEST_FIELD_OFFSET(STARTUPINFOW, dwXSize, 40)
    TEST_FIELD_SIZE  (STARTUPINFOW, dwYSize, 4)
    TEST_FIELD_ALIGN (STARTUPINFOW, dwYSize, 4)
    TEST_FIELD_OFFSET(STARTUPINFOW, dwYSize, 44)
    TEST_FIELD_SIZE  (STARTUPINFOW, dwXCountChars, 4)
    TEST_FIELD_ALIGN (STARTUPINFOW, dwXCountChars, 4)
    TEST_FIELD_OFFSET(STARTUPINFOW, dwXCountChars, 48)
    TEST_FIELD_SIZE  (STARTUPINFOW, dwYCountChars, 4)
    TEST_FIELD_ALIGN (STARTUPINFOW, dwYCountChars, 4)
    TEST_FIELD_OFFSET(STARTUPINFOW, dwYCountChars, 52)
    TEST_FIELD_SIZE  (STARTUPINFOW, dwFillAttribute, 4)
    TEST_FIELD_ALIGN (STARTUPINFOW, dwFillAttribute, 4)
    TEST_FIELD_OFFSET(STARTUPINFOW, dwFillAttribute, 56)
    TEST_FIELD_SIZE  (STARTUPINFOW, dwFlags, 4)
    TEST_FIELD_ALIGN (STARTUPINFOW, dwFlags, 4)
    TEST_FIELD_OFFSET(STARTUPINFOW, dwFlags, 60)
    TEST_FIELD_SIZE  (STARTUPINFOW, wShowWindow, 2)
    TEST_FIELD_ALIGN (STARTUPINFOW, wShowWindow, 2)
    TEST_FIELD_OFFSET(STARTUPINFOW, wShowWindow, 64)
    TEST_FIELD_SIZE  (STARTUPINFOW, cbReserved2, 2)
    TEST_FIELD_ALIGN (STARTUPINFOW, cbReserved2, 2)
    TEST_FIELD_OFFSET(STARTUPINFOW, cbReserved2, 66)
    TEST_FIELD_SIZE  (STARTUPINFOW, lpReserved2, 8)
    TEST_FIELD_ALIGN (STARTUPINFOW, lpReserved2, 8)
    TEST_FIELD_OFFSET(STARTUPINFOW, lpReserved2, 72)
    TEST_FIELD_SIZE  (STARTUPINFOW, hStdInput, 8)
    TEST_FIELD_ALIGN (STARTUPINFOW, hStdInput, 8)
    TEST_FIELD_OFFSET(STARTUPINFOW, hStdInput, 80)
    TEST_FIELD_SIZE  (STARTUPINFOW, hStdOutput, 8)
    TEST_FIELD_ALIGN (STARTUPINFOW, hStdOutput, 8)
    TEST_FIELD_OFFSET(STARTUPINFOW, hStdOutput, 88)
    TEST_FIELD_SIZE  (STARTUPINFOW, hStdError, 8)
    TEST_FIELD_ALIGN (STARTUPINFOW, hStdError, 8)
    TEST_FIELD_OFFSET(STARTUPINFOW, hStdError, 96)
}

static void test_pack_SYSTEMTIME(void)
{
    /* SYSTEMTIME */
    TEST_TYPE_SIZE   (SYSTEMTIME, 16)
    TEST_TYPE_ALIGN  (SYSTEMTIME, 2)
    TEST_FIELD_SIZE  (SYSTEMTIME, wYear, 2)
    TEST_FIELD_ALIGN (SYSTEMTIME, wYear, 2)
    TEST_FIELD_OFFSET(SYSTEMTIME, wYear, 0)
    TEST_FIELD_SIZE  (SYSTEMTIME, wMonth, 2)
    TEST_FIELD_ALIGN (SYSTEMTIME, wMonth, 2)
    TEST_FIELD_OFFSET(SYSTEMTIME, wMonth, 2)
    TEST_FIELD_SIZE  (SYSTEMTIME, wDayOfWeek, 2)
    TEST_FIELD_ALIGN (SYSTEMTIME, wDayOfWeek, 2)
    TEST_FIELD_OFFSET(SYSTEMTIME, wDayOfWeek, 4)
    TEST_FIELD_SIZE  (SYSTEMTIME, wDay, 2)
    TEST_FIELD_ALIGN (SYSTEMTIME, wDay, 2)
    TEST_FIELD_OFFSET(SYSTEMTIME, wDay, 6)
    TEST_FIELD_SIZE  (SYSTEMTIME, wHour, 2)
    TEST_FIELD_ALIGN (SYSTEMTIME, wHour, 2)
    TEST_FIELD_OFFSET(SYSTEMTIME, wHour, 8)
    TEST_FIELD_SIZE  (SYSTEMTIME, wMinute, 2)
    TEST_FIELD_ALIGN (SYSTEMTIME, wMinute, 2)
    TEST_FIELD_OFFSET(SYSTEMTIME, wMinute, 10)
    TEST_FIELD_SIZE  (SYSTEMTIME, wSecond, 2)
    TEST_FIELD_ALIGN (SYSTEMTIME, wSecond, 2)
    TEST_FIELD_OFFSET(SYSTEMTIME, wSecond, 12)
    TEST_FIELD_SIZE  (SYSTEMTIME, wMilliseconds, 2)
    TEST_FIELD_ALIGN (SYSTEMTIME, wMilliseconds, 2)
    TEST_FIELD_OFFSET(SYSTEMTIME, wMilliseconds, 14)
}

static void test_pack_SYSTEM_INFO(void)
{
    /* SYSTEM_INFO */
}

static void test_pack_SYSTEM_POWER_STATUS(void)
{
    /* SYSTEM_POWER_STATUS */
    TEST_TYPE_SIZE   (SYSTEM_POWER_STATUS, 12)
    TEST_TYPE_ALIGN  (SYSTEM_POWER_STATUS, 4)
    TEST_FIELD_SIZE  (SYSTEM_POWER_STATUS, ACLineStatus, 1)
    TEST_FIELD_ALIGN (SYSTEM_POWER_STATUS, ACLineStatus, 1)
    TEST_FIELD_OFFSET(SYSTEM_POWER_STATUS, ACLineStatus, 0)
    TEST_FIELD_SIZE  (SYSTEM_POWER_STATUS, BatteryFlag, 1)
    TEST_FIELD_ALIGN (SYSTEM_POWER_STATUS, BatteryFlag, 1)
    TEST_FIELD_OFFSET(SYSTEM_POWER_STATUS, BatteryFlag, 1)
    TEST_FIELD_SIZE  (SYSTEM_POWER_STATUS, BatteryLifePercent, 1)
    TEST_FIELD_ALIGN (SYSTEM_POWER_STATUS, BatteryLifePercent, 1)
    TEST_FIELD_OFFSET(SYSTEM_POWER_STATUS, BatteryLifePercent, 2)
    TEST_FIELD_SIZE  (SYSTEM_POWER_STATUS, SystemStatusFlag, 1)
    TEST_FIELD_ALIGN (SYSTEM_POWER_STATUS, SystemStatusFlag, 1)
    TEST_FIELD_OFFSET(SYSTEM_POWER_STATUS, SystemStatusFlag, 3)
    TEST_FIELD_SIZE  (SYSTEM_POWER_STATUS, BatteryLifeTime, 4)
    TEST_FIELD_ALIGN (SYSTEM_POWER_STATUS, BatteryLifeTime, 4)
    TEST_FIELD_OFFSET(SYSTEM_POWER_STATUS, BatteryLifeTime, 4)
    TEST_FIELD_SIZE  (SYSTEM_POWER_STATUS, BatteryFullLifeTime, 4)
    TEST_FIELD_ALIGN (SYSTEM_POWER_STATUS, BatteryFullLifeTime, 4)
    TEST_FIELD_OFFSET(SYSTEM_POWER_STATUS, BatteryFullLifeTime, 8)
}

static void test_pack_UNLOAD_DLL_DEBUG_INFO(void)
{
    /* UNLOAD_DLL_DEBUG_INFO */
    TEST_TYPE_SIZE   (UNLOAD_DLL_DEBUG_INFO, 8)
    TEST_TYPE_ALIGN  (UNLOAD_DLL_DEBUG_INFO, 8)
    TEST_FIELD_SIZE  (UNLOAD_DLL_DEBUG_INFO, lpBaseOfDll, 8)
    TEST_FIELD_ALIGN (UNLOAD_DLL_DEBUG_INFO, lpBaseOfDll, 8)
    TEST_FIELD_OFFSET(UNLOAD_DLL_DEBUG_INFO, lpBaseOfDll, 0)
}

static void test_pack_WAITORTIMERCALLBACK(void)
{
    /* WAITORTIMERCALLBACK */
    TEST_TYPE_SIZE   (WAITORTIMERCALLBACK, 8)
    TEST_TYPE_ALIGN  (WAITORTIMERCALLBACK, 8)
}

static void test_pack_WIN32_FILE_ATTRIBUTE_DATA(void)
{
    /* WIN32_FILE_ATTRIBUTE_DATA */
    TEST_TYPE_SIZE   (WIN32_FILE_ATTRIBUTE_DATA, 36)
    TEST_TYPE_ALIGN  (WIN32_FILE_ATTRIBUTE_DATA, 4)
    TEST_FIELD_SIZE  (WIN32_FILE_ATTRIBUTE_DATA, dwFileAttributes, 4)
    TEST_FIELD_ALIGN (WIN32_FILE_ATTRIBUTE_DATA, dwFileAttributes, 4)
    TEST_FIELD_OFFSET(WIN32_FILE_ATTRIBUTE_DATA, dwFileAttributes, 0)
    TEST_FIELD_SIZE  (WIN32_FILE_ATTRIBUTE_DATA, ftCreationTime, 8)
    TEST_FIELD_ALIGN (WIN32_FILE_ATTRIBUTE_DATA, ftCreationTime, 4)
    TEST_FIELD_OFFSET(WIN32_FILE_ATTRIBUTE_DATA, ftCreationTime, 4)
    TEST_FIELD_SIZE  (WIN32_FILE_ATTRIBUTE_DATA, ftLastAccessTime, 8)
    TEST_FIELD_ALIGN (WIN32_FILE_ATTRIBUTE_DATA, ftLastAccessTime, 4)
    TEST_FIELD_OFFSET(WIN32_FILE_ATTRIBUTE_DATA, ftLastAccessTime, 12)
    TEST_FIELD_SIZE  (WIN32_FILE_ATTRIBUTE_DATA, ftLastWriteTime, 8)
    TEST_FIELD_ALIGN (WIN32_FILE_ATTRIBUTE_DATA, ftLastWriteTime, 4)
    TEST_FIELD_OFFSET(WIN32_FILE_ATTRIBUTE_DATA, ftLastWriteTime, 20)
    TEST_FIELD_SIZE  (WIN32_FILE_ATTRIBUTE_DATA, nFileSizeHigh, 4)
    TEST_FIELD_ALIGN (WIN32_FILE_ATTRIBUTE_DATA, nFileSizeHigh, 4)
    TEST_FIELD_OFFSET(WIN32_FILE_ATTRIBUTE_DATA, nFileSizeHigh, 28)
    TEST_FIELD_SIZE  (WIN32_FILE_ATTRIBUTE_DATA, nFileSizeLow, 4)
    TEST_FIELD_ALIGN (WIN32_FILE_ATTRIBUTE_DATA, nFileSizeLow, 4)
    TEST_FIELD_OFFSET(WIN32_FILE_ATTRIBUTE_DATA, nFileSizeLow, 32)
}

static void test_pack_WIN32_FIND_DATAA(void)
{
    /* WIN32_FIND_DATAA */
    TEST_TYPE_SIZE   (WIN32_FIND_DATAA, 320)
    TEST_TYPE_ALIGN  (WIN32_FIND_DATAA, 4)
    TEST_FIELD_SIZE  (WIN32_FIND_DATAA, dwFileAttributes, 4)
    TEST_FIELD_ALIGN (WIN32_FIND_DATAA, dwFileAttributes, 4)
    TEST_FIELD_OFFSET(WIN32_FIND_DATAA, dwFileAttributes, 0)
    TEST_FIELD_SIZE  (WIN32_FIND_DATAA, ftCreationTime, 8)
    TEST_FIELD_ALIGN (WIN32_FIND_DATAA, ftCreationTime, 4)
    TEST_FIELD_OFFSET(WIN32_FIND_DATAA, ftCreationTime, 4)
    TEST_FIELD_SIZE  (WIN32_FIND_DATAA, ftLastAccessTime, 8)
    TEST_FIELD_ALIGN (WIN32_FIND_DATAA, ftLastAccessTime, 4)
    TEST_FIELD_OFFSET(WIN32_FIND_DATAA, ftLastAccessTime, 12)
    TEST_FIELD_SIZE  (WIN32_FIND_DATAA, ftLastWriteTime, 8)
    TEST_FIELD_ALIGN (WIN32_FIND_DATAA, ftLastWriteTime, 4)
    TEST_FIELD_OFFSET(WIN32_FIND_DATAA, ftLastWriteTime, 20)
    TEST_FIELD_SIZE  (WIN32_FIND_DATAA, nFileSizeHigh, 4)
    TEST_FIELD_ALIGN (WIN32_FIND_DATAA, nFileSizeHigh, 4)
    TEST_FIELD_OFFSET(WIN32_FIND_DATAA, nFileSizeHigh, 28)
    TEST_FIELD_SIZE  (WIN32_FIND_DATAA, nFileSizeLow, 4)
    TEST_FIELD_ALIGN (WIN32_FIND_DATAA, nFileSizeLow, 4)
    TEST_FIELD_OFFSET(WIN32_FIND_DATAA, nFileSizeLow, 32)
    TEST_FIELD_SIZE  (WIN32_FIND_DATAA, dwReserved0, 4)
    TEST_FIELD_ALIGN (WIN32_FIND_DATAA, dwReserved0, 4)
    TEST_FIELD_OFFSET(WIN32_FIND_DATAA, dwReserved0, 36)
    TEST_FIELD_SIZE  (WIN32_FIND_DATAA, dwReserved1, 4)
    TEST_FIELD_ALIGN (WIN32_FIND_DATAA, dwReserved1, 4)
    TEST_FIELD_OFFSET(WIN32_FIND_DATAA, dwReserved1, 40)
    TEST_FIELD_SIZE  (WIN32_FIND_DATAA, cFileName, 260)
    TEST_FIELD_ALIGN (WIN32_FIND_DATAA, cFileName, 1)
    TEST_FIELD_OFFSET(WIN32_FIND_DATAA, cFileName, 44)
    TEST_FIELD_SIZE  (WIN32_FIND_DATAA, cAlternateFileName, 14)
    TEST_FIELD_ALIGN (WIN32_FIND_DATAA, cAlternateFileName, 1)
    TEST_FIELD_OFFSET(WIN32_FIND_DATAA, cAlternateFileName, 304)
}

static void test_pack_WIN32_FIND_DATAW(void)
{
    /* WIN32_FIND_DATAW */
    TEST_TYPE_SIZE   (WIN32_FIND_DATAW, 592)
    TEST_TYPE_ALIGN  (WIN32_FIND_DATAW, 4)
    TEST_FIELD_SIZE  (WIN32_FIND_DATAW, dwFileAttributes, 4)
    TEST_FIELD_ALIGN (WIN32_FIND_DATAW, dwFileAttributes, 4)
    TEST_FIELD_OFFSET(WIN32_FIND_DATAW, dwFileAttributes, 0)
    TEST_FIELD_SIZE  (WIN32_FIND_DATAW, ftCreationTime, 8)
    TEST_FIELD_ALIGN (WIN32_FIND_DATAW, ftCreationTime, 4)
    TEST_FIELD_OFFSET(WIN32_FIND_DATAW, ftCreationTime, 4)
    TEST_FIELD_SIZE  (WIN32_FIND_DATAW, ftLastAccessTime, 8)
    TEST_FIELD_ALIGN (WIN32_FIND_DATAW, ftLastAccessTime, 4)
    TEST_FIELD_OFFSET(WIN32_FIND_DATAW, ftLastAccessTime, 12)
    TEST_FIELD_SIZE  (WIN32_FIND_DATAW, ftLastWriteTime, 8)
    TEST_FIELD_ALIGN (WIN32_FIND_DATAW, ftLastWriteTime, 4)
    TEST_FIELD_OFFSET(WIN32_FIND_DATAW, ftLastWriteTime, 20)
    TEST_FIELD_SIZE  (WIN32_FIND_DATAW, nFileSizeHigh, 4)
    TEST_FIELD_ALIGN (WIN32_FIND_DATAW, nFileSizeHigh, 4)
    TEST_FIELD_OFFSET(WIN32_FIND_DATAW, nFileSizeHigh, 28)
    TEST_FIELD_SIZE  (WIN32_FIND_DATAW, nFileSizeLow, 4)
    TEST_FIELD_ALIGN (WIN32_FIND_DATAW, nFileSizeLow, 4)
    TEST_FIELD_OFFSET(WIN32_FIND_DATAW, nFileSizeLow, 32)
    TEST_FIELD_SIZE  (WIN32_FIND_DATAW, dwReserved0, 4)
    TEST_FIELD_ALIGN (WIN32_FIND_DATAW, dwReserved0, 4)
    TEST_FIELD_OFFSET(WIN32_FIND_DATAW, dwReserved0, 36)
    TEST_FIELD_SIZE  (WIN32_FIND_DATAW, dwReserved1, 4)
    TEST_FIELD_ALIGN (WIN32_FIND_DATAW, dwReserved1, 4)
    TEST_FIELD_OFFSET(WIN32_FIND_DATAW, dwReserved1, 40)
    TEST_FIELD_SIZE  (WIN32_FIND_DATAW, cFileName, 520)
    TEST_FIELD_ALIGN (WIN32_FIND_DATAW, cFileName, 2)
    TEST_FIELD_OFFSET(WIN32_FIND_DATAW, cFileName, 44)
    TEST_FIELD_SIZE  (WIN32_FIND_DATAW, cAlternateFileName, 28)
    TEST_FIELD_ALIGN (WIN32_FIND_DATAW, cAlternateFileName, 2)
    TEST_FIELD_OFFSET(WIN32_FIND_DATAW, cAlternateFileName, 564)
}

static void test_pack_WIN32_STREAM_ID(void)
{
    /* WIN32_STREAM_ID (pack 8) */
    TEST_TYPE_SIZE   (WIN32_STREAM_ID, 24)
    TEST_TYPE_ALIGN  (WIN32_STREAM_ID, 8)
    TEST_FIELD_SIZE  (WIN32_STREAM_ID, dwStreamId, 4)
    TEST_FIELD_ALIGN (WIN32_STREAM_ID, dwStreamId, 4)
    TEST_FIELD_OFFSET(WIN32_STREAM_ID, dwStreamId, 0)
    TEST_FIELD_SIZE  (WIN32_STREAM_ID, dwStreamAttributes, 4)
    TEST_FIELD_ALIGN (WIN32_STREAM_ID, dwStreamAttributes, 4)
    TEST_FIELD_OFFSET(WIN32_STREAM_ID, dwStreamAttributes, 4)
    TEST_FIELD_SIZE  (WIN32_STREAM_ID, Size, 8)
    TEST_FIELD_ALIGN (WIN32_STREAM_ID, Size, 8)
    TEST_FIELD_OFFSET(WIN32_STREAM_ID, Size, 8)
    TEST_FIELD_SIZE  (WIN32_STREAM_ID, dwStreamNameSize, 4)
    TEST_FIELD_ALIGN (WIN32_STREAM_ID, dwStreamNameSize, 4)
    TEST_FIELD_OFFSET(WIN32_STREAM_ID, dwStreamNameSize, 16)
    TEST_FIELD_SIZE  (WIN32_STREAM_ID, cStreamName, 2)
    TEST_FIELD_ALIGN (WIN32_STREAM_ID, cStreamName, 2)
    TEST_FIELD_OFFSET(WIN32_STREAM_ID, cStreamName, 20)
}

static void test_pack_DYNAMIC_TIME_ZONE_INFORMATION(void)
{
    /* DYNAMIC_TIME_ZONE_INFORMATION */
    TEST_TYPE_SIZE   (DYNAMIC_TIME_ZONE_INFORMATION, 432)
    TEST_TYPE_ALIGN  (DYNAMIC_TIME_ZONE_INFORMATION, 4)
    TEST_FIELD_SIZE  (DYNAMIC_TIME_ZONE_INFORMATION, Bias, 4)
    TEST_FIELD_ALIGN (DYNAMIC_TIME_ZONE_INFORMATION, Bias, 4)
    TEST_FIELD_OFFSET(DYNAMIC_TIME_ZONE_INFORMATION, Bias, 0)
    TEST_FIELD_SIZE  (DYNAMIC_TIME_ZONE_INFORMATION, StandardName, 64)
    TEST_FIELD_ALIGN (DYNAMIC_TIME_ZONE_INFORMATION, StandardName, 2)
    TEST_FIELD_OFFSET(DYNAMIC_TIME_ZONE_INFORMATION, StandardName, 4)
    TEST_FIELD_SIZE  (DYNAMIC_TIME_ZONE_INFORMATION, StandardDate, 16)
    TEST_FIELD_ALIGN (DYNAMIC_TIME_ZONE_INFORMATION, StandardDate, 2)
    TEST_FIELD_OFFSET(DYNAMIC_TIME_ZONE_INFORMATION, StandardDate, 68)
    TEST_FIELD_SIZE  (DYNAMIC_TIME_ZONE_INFORMATION, StandardBias, 4)
    TEST_FIELD_ALIGN (DYNAMIC_TIME_ZONE_INFORMATION, StandardBias, 4)
    TEST_FIELD_OFFSET(DYNAMIC_TIME_ZONE_INFORMATION, StandardBias, 84)
    TEST_FIELD_SIZE  (DYNAMIC_TIME_ZONE_INFORMATION, DaylightName, 64)
    TEST_FIELD_ALIGN (DYNAMIC_TIME_ZONE_INFORMATION, DaylightName, 2)
    TEST_FIELD_OFFSET(DYNAMIC_TIME_ZONE_INFORMATION, DaylightName, 88)
    TEST_FIELD_SIZE  (DYNAMIC_TIME_ZONE_INFORMATION, DaylightDate, 16)
    TEST_FIELD_ALIGN (DYNAMIC_TIME_ZONE_INFORMATION, DaylightDate, 2)
    TEST_FIELD_OFFSET(DYNAMIC_TIME_ZONE_INFORMATION, DaylightDate, 152)
    TEST_FIELD_SIZE  (DYNAMIC_TIME_ZONE_INFORMATION, DaylightBias, 4)
    TEST_FIELD_ALIGN (DYNAMIC_TIME_ZONE_INFORMATION, DaylightBias, 4)
    TEST_FIELD_OFFSET(DYNAMIC_TIME_ZONE_INFORMATION, DaylightBias, 168)
    TEST_FIELD_SIZE  (DYNAMIC_TIME_ZONE_INFORMATION, TimeZoneKeyName, 256)
    TEST_FIELD_ALIGN (DYNAMIC_TIME_ZONE_INFORMATION, TimeZoneKeyName, 2)
    TEST_FIELD_OFFSET(DYNAMIC_TIME_ZONE_INFORMATION, TimeZoneKeyName, 172)
    TEST_FIELD_SIZE  (DYNAMIC_TIME_ZONE_INFORMATION, DynamicDaylightTimeDisabled, 1)
    TEST_FIELD_ALIGN (DYNAMIC_TIME_ZONE_INFORMATION, DynamicDaylightTimeDisabled, 1)
    TEST_FIELD_OFFSET(DYNAMIC_TIME_ZONE_INFORMATION, DynamicDaylightTimeDisabled, 428)
}

static void test_pack_LPTIME_ZONE_INFORMATION(void)
{
    /* LPTIME_ZONE_INFORMATION */
    TEST_TYPE_SIZE   (LPTIME_ZONE_INFORMATION, 8)
    TEST_TYPE_ALIGN  (LPTIME_ZONE_INFORMATION, 8)
    TEST_TARGET_SIZE (LPTIME_ZONE_INFORMATION, 172)
    TEST_TARGET_ALIGN(LPTIME_ZONE_INFORMATION, 4)
}

static void test_pack_PDYNAMIC_TIME_ZONE_INFORMATION(void)
{
    /* PDYNAMIC_TIME_ZONE_INFORMATION */
    TEST_TYPE_SIZE   (PDYNAMIC_TIME_ZONE_INFORMATION, 8)
    TEST_TYPE_ALIGN  (PDYNAMIC_TIME_ZONE_INFORMATION, 8)
    TEST_TARGET_SIZE (PDYNAMIC_TIME_ZONE_INFORMATION, 432)
    TEST_TARGET_ALIGN(PDYNAMIC_TIME_ZONE_INFORMATION, 4)
}

static void test_pack_PTIME_ZONE_INFORMATION(void)
{
    /* PTIME_ZONE_INFORMATION */
    TEST_TYPE_SIZE   (PTIME_ZONE_INFORMATION, 8)
    TEST_TYPE_ALIGN  (PTIME_ZONE_INFORMATION, 8)
    TEST_TARGET_SIZE (PTIME_ZONE_INFORMATION, 172)
    TEST_TARGET_ALIGN(PTIME_ZONE_INFORMATION, 4)
}

static void test_pack_TIME_ZONE_INFORMATION(void)
{
    /* TIME_ZONE_INFORMATION */
    TEST_TYPE_SIZE   (TIME_ZONE_INFORMATION, 172)
    TEST_TYPE_ALIGN  (TIME_ZONE_INFORMATION, 4)
    TEST_FIELD_SIZE  (TIME_ZONE_INFORMATION, Bias, 4)
    TEST_FIELD_ALIGN (TIME_ZONE_INFORMATION, Bias, 4)
    TEST_FIELD_OFFSET(TIME_ZONE_INFORMATION, Bias, 0)
    TEST_FIELD_SIZE  (TIME_ZONE_INFORMATION, StandardName, 64)
    TEST_FIELD_ALIGN (TIME_ZONE_INFORMATION, StandardName, 2)
    TEST_FIELD_OFFSET(TIME_ZONE_INFORMATION, StandardName, 4)
    TEST_FIELD_SIZE  (TIME_ZONE_INFORMATION, StandardDate, 16)
    TEST_FIELD_ALIGN (TIME_ZONE_INFORMATION, StandardDate, 2)
    TEST_FIELD_OFFSET(TIME_ZONE_INFORMATION, StandardDate, 68)
    TEST_FIELD_SIZE  (TIME_ZONE_INFORMATION, StandardBias, 4)
    TEST_FIELD_ALIGN (TIME_ZONE_INFORMATION, StandardBias, 4)
    TEST_FIELD_OFFSET(TIME_ZONE_INFORMATION, StandardBias, 84)
    TEST_FIELD_SIZE  (TIME_ZONE_INFORMATION, DaylightName, 64)
    TEST_FIELD_ALIGN (TIME_ZONE_INFORMATION, DaylightName, 2)
    TEST_FIELD_OFFSET(TIME_ZONE_INFORMATION, DaylightName, 88)
    TEST_FIELD_SIZE  (TIME_ZONE_INFORMATION, DaylightDate, 16)
    TEST_FIELD_ALIGN (TIME_ZONE_INFORMATION, DaylightDate, 2)
    TEST_FIELD_OFFSET(TIME_ZONE_INFORMATION, DaylightDate, 152)
    TEST_FIELD_SIZE  (TIME_ZONE_INFORMATION, DaylightBias, 4)
    TEST_FIELD_ALIGN (TIME_ZONE_INFORMATION, DaylightBias, 4)
    TEST_FIELD_OFFSET(TIME_ZONE_INFORMATION, DaylightBias, 168)
}

#else /* _WIN64 */

static void test_pack_LPOSVERSIONINFOA(void)
{
    /* LPOSVERSIONINFOA */
    TEST_TYPE_SIZE   (LPOSVERSIONINFOA, 4)
    TEST_TYPE_ALIGN  (LPOSVERSIONINFOA, 4)
    TEST_TARGET_SIZE (LPOSVERSIONINFOA, 148)
    TEST_TARGET_ALIGN(LPOSVERSIONINFOA, 4)
}

static void test_pack_LPOSVERSIONINFOEXA(void)
{
    /* LPOSVERSIONINFOEXA */
    TEST_TYPE_SIZE   (LPOSVERSIONINFOEXA, 4)
    TEST_TYPE_ALIGN  (LPOSVERSIONINFOEXA, 4)
    TEST_TARGET_SIZE (LPOSVERSIONINFOEXA, 156)
    TEST_TARGET_ALIGN(LPOSVERSIONINFOEXA, 4)
}

static void test_pack_LPOSVERSIONINFOEXW(void)
{
    /* LPOSVERSIONINFOEXW */
    TEST_TYPE_SIZE   (LPOSVERSIONINFOEXW, 4)
    TEST_TYPE_ALIGN  (LPOSVERSIONINFOEXW, 4)
    TEST_TARGET_SIZE (LPOSVERSIONINFOEXW, 284)
    TEST_TARGET_ALIGN(LPOSVERSIONINFOEXW, 4)
}

static void test_pack_LPOSVERSIONINFOW(void)
{
    /* LPOSVERSIONINFOW */
    TEST_TYPE_SIZE   (LPOSVERSIONINFOW, 4)
    TEST_TYPE_ALIGN  (LPOSVERSIONINFOW, 4)
    TEST_TARGET_SIZE (LPOSVERSIONINFOW, 276)
    TEST_TARGET_ALIGN(LPOSVERSIONINFOW, 4)
}

static void test_pack_OSVERSIONINFOA(void)
{
    /* OSVERSIONINFOA */
    TEST_TYPE_SIZE   (OSVERSIONINFOA, 148)
    TEST_TYPE_ALIGN  (OSVERSIONINFOA, 4)
    TEST_FIELD_SIZE  (OSVERSIONINFOA, dwOSVersionInfoSize, 4)
    TEST_FIELD_ALIGN (OSVERSIONINFOA, dwOSVersionInfoSize, 4)
    TEST_FIELD_OFFSET(OSVERSIONINFOA, dwOSVersionInfoSize, 0)
    TEST_FIELD_SIZE  (OSVERSIONINFOA, dwMajorVersion, 4)
    TEST_FIELD_ALIGN (OSVERSIONINFOA, dwMajorVersion, 4)
    TEST_FIELD_OFFSET(OSVERSIONINFOA, dwMajorVersion, 4)
    TEST_FIELD_SIZE  (OSVERSIONINFOA, dwMinorVersion, 4)
    TEST_FIELD_ALIGN (OSVERSIONINFOA, dwMinorVersion, 4)
    TEST_FIELD_OFFSET(OSVERSIONINFOA, dwMinorVersion, 8)
    TEST_FIELD_SIZE  (OSVERSIONINFOA, dwBuildNumber, 4)
    TEST_FIELD_ALIGN (OSVERSIONINFOA, dwBuildNumber, 4)
    TEST_FIELD_OFFSET(OSVERSIONINFOA, dwBuildNumber, 12)
    TEST_FIELD_SIZE  (OSVERSIONINFOA, dwPlatformId, 4)
    TEST_FIELD_ALIGN (OSVERSIONINFOA, dwPlatformId, 4)
    TEST_FIELD_OFFSET(OSVERSIONINFOA, dwPlatformId, 16)
    TEST_FIELD_SIZE  (OSVERSIONINFOA, szCSDVersion, 128)
    TEST_FIELD_ALIGN (OSVERSIONINFOA, szCSDVersion, 1)
    TEST_FIELD_OFFSET(OSVERSIONINFOA, szCSDVersion, 20)
}

static void test_pack_OSVERSIONINFOEXA(void)
{
    /* OSVERSIONINFOEXA */
    TEST_TYPE_SIZE   (OSVERSIONINFOEXA, 156)
    TEST_TYPE_ALIGN  (OSVERSIONINFOEXA, 4)
    TEST_FIELD_SIZE  (OSVERSIONINFOEXA, dwOSVersionInfoSize, 4)
    TEST_FIELD_ALIGN (OSVERSIONINFOEXA, dwOSVersionInfoSize, 4)
    TEST_FIELD_OFFSET(OSVERSIONINFOEXA, dwOSVersionInfoSize, 0)
    TEST_FIELD_SIZE  (OSVERSIONINFOEXA, dwMajorVersion, 4)
    TEST_FIELD_ALIGN (OSVERSIONINFOEXA, dwMajorVersion, 4)
    TEST_FIELD_OFFSET(OSVERSIONINFOEXA, dwMajorVersion, 4)
    TEST_FIELD_SIZE  (OSVERSIONINFOEXA, dwMinorVersion, 4)
    TEST_FIELD_ALIGN (OSVERSIONINFOEXA, dwMinorVersion, 4)
    TEST_FIELD_OFFSET(OSVERSIONINFOEXA, dwMinorVersion, 8)
    TEST_FIELD_SIZE  (OSVERSIONINFOEXA, dwBuildNumber, 4)
    TEST_FIELD_ALIGN (OSVERSIONINFOEXA, dwBuildNumber, 4)
    TEST_FIELD_OFFSET(OSVERSIONINFOEXA, dwBuildNumber, 12)
    TEST_FIELD_SIZE  (OSVERSIONINFOEXA, dwPlatformId, 4)
    TEST_FIELD_ALIGN (OSVERSIONINFOEXA, dwPlatformId, 4)
    TEST_FIELD_OFFSET(OSVERSIONINFOEXA, dwPlatformId, 16)
    TEST_FIELD_SIZE  (OSVERSIONINFOEXA, szCSDVersion, 128)
    TEST_FIELD_ALIGN (OSVERSIONINFOEXA, szCSDVersion, 1)
    TEST_FIELD_OFFSET(OSVERSIONINFOEXA, szCSDVersion, 20)
    TEST_FIELD_SIZE  (OSVERSIONINFOEXA, wServicePackMajor, 2)
    TEST_FIELD_ALIGN (OSVERSIONINFOEXA, wServicePackMajor, 2)
    TEST_FIELD_OFFSET(OSVERSIONINFOEXA, wServicePackMajor, 148)
    TEST_FIELD_SIZE  (OSVERSIONINFOEXA, wServicePackMinor, 2)
    TEST_FIELD_ALIGN (OSVERSIONINFOEXA, wServicePackMinor, 2)
    TEST_FIELD_OFFSET(OSVERSIONINFOEXA, wServicePackMinor, 150)
    TEST_FIELD_SIZE  (OSVERSIONINFOEXA, wSuiteMask, 2)
    TEST_FIELD_ALIGN (OSVERSIONINFOEXA, wSuiteMask, 2)
    TEST_FIELD_OFFSET(OSVERSIONINFOEXA, wSuiteMask, 152)
    TEST_FIELD_SIZE  (OSVERSIONINFOEXA, wProductType, 1)
    TEST_FIELD_ALIGN (OSVERSIONINFOEXA, wProductType, 1)
    TEST_FIELD_OFFSET(OSVERSIONINFOEXA, wProductType, 154)
    TEST_FIELD_SIZE  (OSVERSIONINFOEXA, wReserved, 1)
    TEST_FIELD_ALIGN (OSVERSIONINFOEXA, wReserved, 1)
    TEST_FIELD_OFFSET(OSVERSIONINFOEXA, wReserved, 155)
}

static void test_pack_OSVERSIONINFOEXW(void)
{
    /* OSVERSIONINFOEXW */
    TEST_TYPE_SIZE   (OSVERSIONINFOEXW, 284)
    TEST_TYPE_ALIGN  (OSVERSIONINFOEXW, 4)
    TEST_FIELD_SIZE  (OSVERSIONINFOEXW, dwOSVersionInfoSize, 4)
    TEST_FIELD_ALIGN (OSVERSIONINFOEXW, dwOSVersionInfoSize, 4)
    TEST_FIELD_OFFSET(OSVERSIONINFOEXW, dwOSVersionInfoSize, 0)
    TEST_FIELD_SIZE  (OSVERSIONINFOEXW, dwMajorVersion, 4)
    TEST_FIELD_ALIGN (OSVERSIONINFOEXW, dwMajorVersion, 4)
    TEST_FIELD_OFFSET(OSVERSIONINFOEXW, dwMajorVersion, 4)
    TEST_FIELD_SIZE  (OSVERSIONINFOEXW, dwMinorVersion, 4)
    TEST_FIELD_ALIGN (OSVERSIONINFOEXW, dwMinorVersion, 4)
    TEST_FIELD_OFFSET(OSVERSIONINFOEXW, dwMinorVersion, 8)
    TEST_FIELD_SIZE  (OSVERSIONINFOEXW, dwBuildNumber, 4)
    TEST_FIELD_ALIGN (OSVERSIONINFOEXW, dwBuildNumber, 4)
    TEST_FIELD_OFFSET(OSVERSIONINFOEXW, dwBuildNumber, 12)
    TEST_FIELD_SIZE  (OSVERSIONINFOEXW, dwPlatformId, 4)
    TEST_FIELD_ALIGN (OSVERSIONINFOEXW, dwPlatformId, 4)
    TEST_FIELD_OFFSET(OSVERSIONINFOEXW, dwPlatformId, 16)
    TEST_FIELD_SIZE  (OSVERSIONINFOEXW, szCSDVersion, 256)
    TEST_FIELD_ALIGN (OSVERSIONINFOEXW, szCSDVersion, 2)
    TEST_FIELD_OFFSET(OSVERSIONINFOEXW, szCSDVersion, 20)
    TEST_FIELD_SIZE  (OSVERSIONINFOEXW, wServicePackMajor, 2)
    TEST_FIELD_ALIGN (OSVERSIONINFOEXW, wServicePackMajor, 2)
    TEST_FIELD_OFFSET(OSVERSIONINFOEXW, wServicePackMajor, 276)
    TEST_FIELD_SIZE  (OSVERSIONINFOEXW, wServicePackMinor, 2)
    TEST_FIELD_ALIGN (OSVERSIONINFOEXW, wServicePackMinor, 2)
    TEST_FIELD_OFFSET(OSVERSIONINFOEXW, wServicePackMinor, 278)
    TEST_FIELD_SIZE  (OSVERSIONINFOEXW, wSuiteMask, 2)
    TEST_FIELD_ALIGN (OSVERSIONINFOEXW, wSuiteMask, 2)
    TEST_FIELD_OFFSET(OSVERSIONINFOEXW, wSuiteMask, 280)
    TEST_FIELD_SIZE  (OSVERSIONINFOEXW, wProductType, 1)
    TEST_FIELD_ALIGN (OSVERSIONINFOEXW, wProductType, 1)
    TEST_FIELD_OFFSET(OSVERSIONINFOEXW, wProductType, 282)
    TEST_FIELD_SIZE  (OSVERSIONINFOEXW, wReserved, 1)
    TEST_FIELD_ALIGN (OSVERSIONINFOEXW, wReserved, 1)
    TEST_FIELD_OFFSET(OSVERSIONINFOEXW, wReserved, 283)
}

static void test_pack_OSVERSIONINFOW(void)
{
    /* OSVERSIONINFOW */
    TEST_TYPE_SIZE   (OSVERSIONINFOW, 276)
    TEST_TYPE_ALIGN  (OSVERSIONINFOW, 4)
    TEST_FIELD_SIZE  (OSVERSIONINFOW, dwOSVersionInfoSize, 4)
    TEST_FIELD_ALIGN (OSVERSIONINFOW, dwOSVersionInfoSize, 4)
    TEST_FIELD_OFFSET(OSVERSIONINFOW, dwOSVersionInfoSize, 0)
    TEST_FIELD_SIZE  (OSVERSIONINFOW, dwMajorVersion, 4)
    TEST_FIELD_ALIGN (OSVERSIONINFOW, dwMajorVersion, 4)
    TEST_FIELD_OFFSET(OSVERSIONINFOW, dwMajorVersion, 4)
    TEST_FIELD_SIZE  (OSVERSIONINFOW, dwMinorVersion, 4)
    TEST_FIELD_ALIGN (OSVERSIONINFOW, dwMinorVersion, 4)
    TEST_FIELD_OFFSET(OSVERSIONINFOW, dwMinorVersion, 8)
    TEST_FIELD_SIZE  (OSVERSIONINFOW, dwBuildNumber, 4)
    TEST_FIELD_ALIGN (OSVERSIONINFOW, dwBuildNumber, 4)
    TEST_FIELD_OFFSET(OSVERSIONINFOW, dwBuildNumber, 12)
    TEST_FIELD_SIZE  (OSVERSIONINFOW, dwPlatformId, 4)
    TEST_FIELD_ALIGN (OSVERSIONINFOW, dwPlatformId, 4)
    TEST_FIELD_OFFSET(OSVERSIONINFOW, dwPlatformId, 16)
    TEST_FIELD_SIZE  (OSVERSIONINFOW, szCSDVersion, 256)
    TEST_FIELD_ALIGN (OSVERSIONINFOW, szCSDVersion, 2)
    TEST_FIELD_OFFSET(OSVERSIONINFOW, szCSDVersion, 20)
}

static void test_pack_POSVERSIONINFOA(void)
{
    /* POSVERSIONINFOA */
    TEST_TYPE_SIZE   (POSVERSIONINFOA, 4)
    TEST_TYPE_ALIGN  (POSVERSIONINFOA, 4)
    TEST_TARGET_SIZE (POSVERSIONINFOA, 148)
    TEST_TARGET_ALIGN(POSVERSIONINFOA, 4)
}

static void test_pack_POSVERSIONINFOEXA(void)
{
    /* POSVERSIONINFOEXA */
    TEST_TYPE_SIZE   (POSVERSIONINFOEXA, 4)
    TEST_TYPE_ALIGN  (POSVERSIONINFOEXA, 4)
    TEST_TARGET_SIZE (POSVERSIONINFOEXA, 156)
    TEST_TARGET_ALIGN(POSVERSIONINFOEXA, 4)
}

static void test_pack_POSVERSIONINFOEXW(void)
{
    /* POSVERSIONINFOEXW */
    TEST_TYPE_SIZE   (POSVERSIONINFOEXW, 4)
    TEST_TYPE_ALIGN  (POSVERSIONINFOEXW, 4)
    TEST_TARGET_SIZE (POSVERSIONINFOEXW, 284)
    TEST_TARGET_ALIGN(POSVERSIONINFOEXW, 4)
}

static void test_pack_POSVERSIONINFOW(void)
{
    /* POSVERSIONINFOW */
    TEST_TYPE_SIZE   (POSVERSIONINFOW, 4)
    TEST_TYPE_ALIGN  (POSVERSIONINFOW, 4)
    TEST_TARGET_SIZE (POSVERSIONINFOW, 276)
    TEST_TARGET_ALIGN(POSVERSIONINFOW, 4)
}

static void test_pack_LPLONG(void)
{
    /* LPLONG */
    TEST_TYPE_SIZE   (LPLONG, 4)
    TEST_TYPE_ALIGN  (LPLONG, 4)
}

static void test_pack_LPVOID(void)
{
    /* LPVOID */
    TEST_TYPE_SIZE   (LPVOID, 4)
    TEST_TYPE_ALIGN  (LPVOID, 4)
}

static void test_pack_PHKEY(void)
{
    /* PHKEY */
    TEST_TYPE_SIZE   (PHKEY, 4)
    TEST_TYPE_ALIGN  (PHKEY, 4)
}

static void test_pack_ACTCTXA(void)
{
    /* ACTCTXA */
    TEST_TYPE_SIZE   (ACTCTXA, 32)
    TEST_TYPE_ALIGN  (ACTCTXA, 4)
    TEST_FIELD_SIZE  (ACTCTXA, cbSize, 4)
    TEST_FIELD_ALIGN (ACTCTXA, cbSize, 4)
    TEST_FIELD_OFFSET(ACTCTXA, cbSize, 0)
    TEST_FIELD_SIZE  (ACTCTXA, dwFlags, 4)
    TEST_FIELD_ALIGN (ACTCTXA, dwFlags, 4)
    TEST_FIELD_OFFSET(ACTCTXA, dwFlags, 4)
    TEST_FIELD_SIZE  (ACTCTXA, lpSource, 4)
    TEST_FIELD_ALIGN (ACTCTXA, lpSource, 4)
    TEST_FIELD_OFFSET(ACTCTXA, lpSource, 8)
    TEST_FIELD_SIZE  (ACTCTXA, wProcessorArchitecture, 2)
    TEST_FIELD_ALIGN (ACTCTXA, wProcessorArchitecture, 2)
    TEST_FIELD_OFFSET(ACTCTXA, wProcessorArchitecture, 12)
    TEST_FIELD_SIZE  (ACTCTXA, wLangId, 2)
    TEST_FIELD_ALIGN (ACTCTXA, wLangId, 2)
    TEST_FIELD_OFFSET(ACTCTXA, wLangId, 14)
    TEST_FIELD_SIZE  (ACTCTXA, lpAssemblyDirectory, 4)
    TEST_FIELD_ALIGN (ACTCTXA, lpAssemblyDirectory, 4)
    TEST_FIELD_OFFSET(ACTCTXA, lpAssemblyDirectory, 16)
    TEST_FIELD_SIZE  (ACTCTXA, lpResourceName, 4)
    TEST_FIELD_ALIGN (ACTCTXA, lpResourceName, 4)
    TEST_FIELD_OFFSET(ACTCTXA, lpResourceName, 20)
    TEST_FIELD_SIZE  (ACTCTXA, lpApplicationName, 4)
    TEST_FIELD_ALIGN (ACTCTXA, lpApplicationName, 4)
    TEST_FIELD_OFFSET(ACTCTXA, lpApplicationName, 24)
    TEST_FIELD_SIZE  (ACTCTXA, hModule, 4)
    TEST_FIELD_ALIGN (ACTCTXA, hModule, 4)
    TEST_FIELD_OFFSET(ACTCTXA, hModule, 28)
}

static void test_pack_ACTCTXW(void)
{
    /* ACTCTXW */
    TEST_TYPE_SIZE   (ACTCTXW, 32)
    TEST_TYPE_ALIGN  (ACTCTXW, 4)
    TEST_FIELD_SIZE  (ACTCTXW, cbSize, 4)
    TEST_FIELD_ALIGN (ACTCTXW, cbSize, 4)
    TEST_FIELD_OFFSET(ACTCTXW, cbSize, 0)
    TEST_FIELD_SIZE  (ACTCTXW, dwFlags, 4)
    TEST_FIELD_ALIGN (ACTCTXW, dwFlags, 4)
    TEST_FIELD_OFFSET(ACTCTXW, dwFlags, 4)
    TEST_FIELD_SIZE  (ACTCTXW, lpSource, 4)
    TEST_FIELD_ALIGN (ACTCTXW, lpSource, 4)
    TEST_FIELD_OFFSET(ACTCTXW, lpSource, 8)
    TEST_FIELD_SIZE  (ACTCTXW, wProcessorArchitecture, 2)
    TEST_FIELD_ALIGN (ACTCTXW, wProcessorArchitecture, 2)
    TEST_FIELD_OFFSET(ACTCTXW, wProcessorArchitecture, 12)
    TEST_FIELD_SIZE  (ACTCTXW, wLangId, 2)
    TEST_FIELD_ALIGN (ACTCTXW, wLangId, 2)
    TEST_FIELD_OFFSET(ACTCTXW, wLangId, 14)
    TEST_FIELD_SIZE  (ACTCTXW, lpAssemblyDirectory, 4)
    TEST_FIELD_ALIGN (ACTCTXW, lpAssemblyDirectory, 4)
    TEST_FIELD_OFFSET(ACTCTXW, lpAssemblyDirectory, 16)
    TEST_FIELD_SIZE  (ACTCTXW, lpResourceName, 4)
    TEST_FIELD_ALIGN (ACTCTXW, lpResourceName, 4)
    TEST_FIELD_OFFSET(ACTCTXW, lpResourceName, 20)
    TEST_FIELD_SIZE  (ACTCTXW, lpApplicationName, 4)
    TEST_FIELD_ALIGN (ACTCTXW, lpApplicationName, 4)
    TEST_FIELD_OFFSET(ACTCTXW, lpApplicationName, 24)
    TEST_FIELD_SIZE  (ACTCTXW, hModule, 4)
    TEST_FIELD_ALIGN (ACTCTXW, hModule, 4)
    TEST_FIELD_OFFSET(ACTCTXW, hModule, 28)
}

static void test_pack_ACTCTX_SECTION_KEYED_DATA(void)
{
    /* ACTCTX_SECTION_KEYED_DATA */
    TEST_TYPE_SIZE   (ACTCTX_SECTION_KEYED_DATA, 64)
    TEST_TYPE_ALIGN  (ACTCTX_SECTION_KEYED_DATA, 4)
    TEST_FIELD_SIZE  (ACTCTX_SECTION_KEYED_DATA, cbSize, 4)
    TEST_FIELD_ALIGN (ACTCTX_SECTION_KEYED_DATA, cbSize, 4)
    TEST_FIELD_OFFSET(ACTCTX_SECTION_KEYED_DATA, cbSize, 0)
    TEST_FIELD_SIZE  (ACTCTX_SECTION_KEYED_DATA, ulDataFormatVersion, 4)
    TEST_FIELD_ALIGN (ACTCTX_SECTION_KEYED_DATA, ulDataFormatVersion, 4)
    TEST_FIELD_OFFSET(ACTCTX_SECTION_KEYED_DATA, ulDataFormatVersion, 4)
    TEST_FIELD_SIZE  (ACTCTX_SECTION_KEYED_DATA, lpData, 4)
    TEST_FIELD_ALIGN (ACTCTX_SECTION_KEYED_DATA, lpData, 4)
    TEST_FIELD_OFFSET(ACTCTX_SECTION_KEYED_DATA, lpData, 8)
    TEST_FIELD_SIZE  (ACTCTX_SECTION_KEYED_DATA, ulLength, 4)
    TEST_FIELD_ALIGN (ACTCTX_SECTION_KEYED_DATA, ulLength, 4)
    TEST_FIELD_OFFSET(ACTCTX_SECTION_KEYED_DATA, ulLength, 12)
    TEST_FIELD_SIZE  (ACTCTX_SECTION_KEYED_DATA, lpSectionGlobalData, 4)
    TEST_FIELD_ALIGN (ACTCTX_SECTION_KEYED_DATA, lpSectionGlobalData, 4)
    TEST_FIELD_OFFSET(ACTCTX_SECTION_KEYED_DATA, lpSectionGlobalData, 16)
    TEST_FIELD_SIZE  (ACTCTX_SECTION_KEYED_DATA, ulSectionGlobalDataLength, 4)
    TEST_FIELD_ALIGN (ACTCTX_SECTION_KEYED_DATA, ulSectionGlobalDataLength, 4)
    TEST_FIELD_OFFSET(ACTCTX_SECTION_KEYED_DATA, ulSectionGlobalDataLength, 20)
    TEST_FIELD_SIZE  (ACTCTX_SECTION_KEYED_DATA, lpSectionBase, 4)
    TEST_FIELD_ALIGN (ACTCTX_SECTION_KEYED_DATA, lpSectionBase, 4)
    TEST_FIELD_OFFSET(ACTCTX_SECTION_KEYED_DATA, lpSectionBase, 24)
    TEST_FIELD_SIZE  (ACTCTX_SECTION_KEYED_DATA, ulSectionTotalLength, 4)
    TEST_FIELD_ALIGN (ACTCTX_SECTION_KEYED_DATA, ulSectionTotalLength, 4)
    TEST_FIELD_OFFSET(ACTCTX_SECTION_KEYED_DATA, ulSectionTotalLength, 28)
    TEST_FIELD_SIZE  (ACTCTX_SECTION_KEYED_DATA, hActCtx, 4)
    TEST_FIELD_ALIGN (ACTCTX_SECTION_KEYED_DATA, hActCtx, 4)
    TEST_FIELD_OFFSET(ACTCTX_SECTION_KEYED_DATA, hActCtx, 32)
    TEST_FIELD_SIZE  (ACTCTX_SECTION_KEYED_DATA, ulAssemblyRosterIndex, 4)
    TEST_FIELD_ALIGN (ACTCTX_SECTION_KEYED_DATA, ulAssemblyRosterIndex, 4)
    TEST_FIELD_OFFSET(ACTCTX_SECTION_KEYED_DATA, ulAssemblyRosterIndex, 36)
    TEST_FIELD_SIZE  (ACTCTX_SECTION_KEYED_DATA, ulFlags, 4)
    TEST_FIELD_ALIGN (ACTCTX_SECTION_KEYED_DATA, ulFlags, 4)
    TEST_FIELD_OFFSET(ACTCTX_SECTION_KEYED_DATA, ulFlags, 40)
    TEST_FIELD_SIZE  (ACTCTX_SECTION_KEYED_DATA, AssemblyMetadata, 20)
    TEST_FIELD_ALIGN (ACTCTX_SECTION_KEYED_DATA, AssemblyMetadata, 4)
    TEST_FIELD_OFFSET(ACTCTX_SECTION_KEYED_DATA, AssemblyMetadata, 44)
}

static void test_pack_ACTCTX_SECTION_KEYED_DATA_2600(void)
{
    /* ACTCTX_SECTION_KEYED_DATA_2600 */
    TEST_TYPE_SIZE   (ACTCTX_SECTION_KEYED_DATA_2600, 40)
    TEST_TYPE_ALIGN  (ACTCTX_SECTION_KEYED_DATA_2600, 4)
    TEST_FIELD_SIZE  (ACTCTX_SECTION_KEYED_DATA_2600, cbSize, 4)
    TEST_FIELD_ALIGN (ACTCTX_SECTION_KEYED_DATA_2600, cbSize, 4)
    TEST_FIELD_OFFSET(ACTCTX_SECTION_KEYED_DATA_2600, cbSize, 0)
    TEST_FIELD_SIZE  (ACTCTX_SECTION_KEYED_DATA_2600, ulDataFormatVersion, 4)
    TEST_FIELD_ALIGN (ACTCTX_SECTION_KEYED_DATA_2600, ulDataFormatVersion, 4)
    TEST_FIELD_OFFSET(ACTCTX_SECTION_KEYED_DATA_2600, ulDataFormatVersion, 4)
    TEST_FIELD_SIZE  (ACTCTX_SECTION_KEYED_DATA_2600, lpData, 4)
    TEST_FIELD_ALIGN (ACTCTX_SECTION_KEYED_DATA_2600, lpData, 4)
    TEST_FIELD_OFFSET(ACTCTX_SECTION_KEYED_DATA_2600, lpData, 8)
    TEST_FIELD_SIZE  (ACTCTX_SECTION_KEYED_DATA_2600, ulLength, 4)
    TEST_FIELD_ALIGN (ACTCTX_SECTION_KEYED_DATA_2600, ulLength, 4)
    TEST_FIELD_OFFSET(ACTCTX_SECTION_KEYED_DATA_2600, ulLength, 12)
    TEST_FIELD_SIZE  (ACTCTX_SECTION_KEYED_DATA_2600, lpSectionGlobalData, 4)
    TEST_FIELD_ALIGN (ACTCTX_SECTION_KEYED_DATA_2600, lpSectionGlobalData, 4)
    TEST_FIELD_OFFSET(ACTCTX_SECTION_KEYED_DATA_2600, lpSectionGlobalData, 16)
    TEST_FIELD_SIZE  (ACTCTX_SECTION_KEYED_DATA_2600, ulSectionGlobalDataLength, 4)
    TEST_FIELD_ALIGN (ACTCTX_SECTION_KEYED_DATA_2600, ulSectionGlobalDataLength, 4)
    TEST_FIELD_OFFSET(ACTCTX_SECTION_KEYED_DATA_2600, ulSectionGlobalDataLength, 20)
    TEST_FIELD_SIZE  (ACTCTX_SECTION_KEYED_DATA_2600, lpSectionBase, 4)
    TEST_FIELD_ALIGN (ACTCTX_SECTION_KEYED_DATA_2600, lpSectionBase, 4)
    TEST_FIELD_OFFSET(ACTCTX_SECTION_KEYED_DATA_2600, lpSectionBase, 24)
    TEST_FIELD_SIZE  (ACTCTX_SECTION_KEYED_DATA_2600, ulSectionTotalLength, 4)
    TEST_FIELD_ALIGN (ACTCTX_SECTION_KEYED_DATA_2600, ulSectionTotalLength, 4)
    TEST_FIELD_OFFSET(ACTCTX_SECTION_KEYED_DATA_2600, ulSectionTotalLength, 28)
    TEST_FIELD_SIZE  (ACTCTX_SECTION_KEYED_DATA_2600, hActCtx, 4)
    TEST_FIELD_ALIGN (ACTCTX_SECTION_KEYED_DATA_2600, hActCtx, 4)
    TEST_FIELD_OFFSET(ACTCTX_SECTION_KEYED_DATA_2600, hActCtx, 32)
    TEST_FIELD_SIZE  (ACTCTX_SECTION_KEYED_DATA_2600, ulAssemblyRosterIndex, 4)
    TEST_FIELD_ALIGN (ACTCTX_SECTION_KEYED_DATA_2600, ulAssemblyRosterIndex, 4)
    TEST_FIELD_OFFSET(ACTCTX_SECTION_KEYED_DATA_2600, ulAssemblyRosterIndex, 36)
}

static void test_pack_ACTCTX_SECTION_KEYED_DATA_ASSEMBLY_METADATA(void)
{
    /* ACTCTX_SECTION_KEYED_DATA_ASSEMBLY_METADATA */
    TEST_TYPE_SIZE   (ACTCTX_SECTION_KEYED_DATA_ASSEMBLY_METADATA, 20)
    TEST_TYPE_ALIGN  (ACTCTX_SECTION_KEYED_DATA_ASSEMBLY_METADATA, 4)
    TEST_FIELD_SIZE  (ACTCTX_SECTION_KEYED_DATA_ASSEMBLY_METADATA, lpInformation, 4)
    TEST_FIELD_ALIGN (ACTCTX_SECTION_KEYED_DATA_ASSEMBLY_METADATA, lpInformation, 4)
    TEST_FIELD_OFFSET(ACTCTX_SECTION_KEYED_DATA_ASSEMBLY_METADATA, lpInformation, 0)
    TEST_FIELD_SIZE  (ACTCTX_SECTION_KEYED_DATA_ASSEMBLY_METADATA, lpSectionBase, 4)
    TEST_FIELD_ALIGN (ACTCTX_SECTION_KEYED_DATA_ASSEMBLY_METADATA, lpSectionBase, 4)
    TEST_FIELD_OFFSET(ACTCTX_SECTION_KEYED_DATA_ASSEMBLY_METADATA, lpSectionBase, 4)
    TEST_FIELD_SIZE  (ACTCTX_SECTION_KEYED_DATA_ASSEMBLY_METADATA, ulSectionLength, 4)
    TEST_FIELD_ALIGN (ACTCTX_SECTION_KEYED_DATA_ASSEMBLY_METADATA, ulSectionLength, 4)
    TEST_FIELD_OFFSET(ACTCTX_SECTION_KEYED_DATA_ASSEMBLY_METADATA, ulSectionLength, 8)
    TEST_FIELD_SIZE  (ACTCTX_SECTION_KEYED_DATA_ASSEMBLY_METADATA, lpSectionGlobalDataBase, 4)
    TEST_FIELD_ALIGN (ACTCTX_SECTION_KEYED_DATA_ASSEMBLY_METADATA, lpSectionGlobalDataBase, 4)
    TEST_FIELD_OFFSET(ACTCTX_SECTION_KEYED_DATA_ASSEMBLY_METADATA, lpSectionGlobalDataBase, 12)
    TEST_FIELD_SIZE  (ACTCTX_SECTION_KEYED_DATA_ASSEMBLY_METADATA, ulSectionGlobalDataLength, 4)
    TEST_FIELD_ALIGN (ACTCTX_SECTION_KEYED_DATA_ASSEMBLY_METADATA, ulSectionGlobalDataLength, 4)
    TEST_FIELD_OFFSET(ACTCTX_SECTION_KEYED_DATA_ASSEMBLY_METADATA, ulSectionGlobalDataLength, 16)
}

static void test_pack_ACTIVATION_CONTEXT_BASIC_INFORMATION(void)
{
    /* ACTIVATION_CONTEXT_BASIC_INFORMATION */
    TEST_TYPE_SIZE   (ACTIVATION_CONTEXT_BASIC_INFORMATION, 8)
    TEST_TYPE_ALIGN  (ACTIVATION_CONTEXT_BASIC_INFORMATION, 4)
    TEST_FIELD_SIZE  (ACTIVATION_CONTEXT_BASIC_INFORMATION, hActCtx, 4)
    TEST_FIELD_ALIGN (ACTIVATION_CONTEXT_BASIC_INFORMATION, hActCtx, 4)
    TEST_FIELD_OFFSET(ACTIVATION_CONTEXT_BASIC_INFORMATION, hActCtx, 0)
    TEST_FIELD_SIZE  (ACTIVATION_CONTEXT_BASIC_INFORMATION, dwFlags, 4)
    TEST_FIELD_ALIGN (ACTIVATION_CONTEXT_BASIC_INFORMATION, dwFlags, 4)
    TEST_FIELD_OFFSET(ACTIVATION_CONTEXT_BASIC_INFORMATION, dwFlags, 4)
}

static void test_pack_BY_HANDLE_FILE_INFORMATION(void)
{
    /* BY_HANDLE_FILE_INFORMATION */
    TEST_TYPE_SIZE   (BY_HANDLE_FILE_INFORMATION, 52)
    TEST_TYPE_ALIGN  (BY_HANDLE_FILE_INFORMATION, 4)
    TEST_FIELD_SIZE  (BY_HANDLE_FILE_INFORMATION, dwFileAttributes, 4)
    TEST_FIELD_ALIGN (BY_HANDLE_FILE_INFORMATION, dwFileAttributes, 4)
    TEST_FIELD_OFFSET(BY_HANDLE_FILE_INFORMATION, dwFileAttributes, 0)
    TEST_FIELD_SIZE  (BY_HANDLE_FILE_INFORMATION, ftCreationTime, 8)
    TEST_FIELD_ALIGN (BY_HANDLE_FILE_INFORMATION, ftCreationTime, 4)
    TEST_FIELD_OFFSET(BY_HANDLE_FILE_INFORMATION, ftCreationTime, 4)
    TEST_FIELD_SIZE  (BY_HANDLE_FILE_INFORMATION, ftLastAccessTime, 8)
    TEST_FIELD_ALIGN (BY_HANDLE_FILE_INFORMATION, ftLastAccessTime, 4)
    TEST_FIELD_OFFSET(BY_HANDLE_FILE_INFORMATION, ftLastAccessTime, 12)
    TEST_FIELD_SIZE  (BY_HANDLE_FILE_INFORMATION, ftLastWriteTime, 8)
    TEST_FIELD_ALIGN (BY_HANDLE_FILE_INFORMATION, ftLastWriteTime, 4)
    TEST_FIELD_OFFSET(BY_HANDLE_FILE_INFORMATION, ftLastWriteTime, 20)
    TEST_FIELD_SIZE  (BY_HANDLE_FILE_INFORMATION, dwVolumeSerialNumber, 4)
    TEST_FIELD_ALIGN (BY_HANDLE_FILE_INFORMATION, dwVolumeSerialNumber, 4)
    TEST_FIELD_OFFSET(BY_HANDLE_FILE_INFORMATION, dwVolumeSerialNumber, 28)
    TEST_FIELD_SIZE  (BY_HANDLE_FILE_INFORMATION, nFileSizeHigh, 4)
    TEST_FIELD_ALIGN (BY_HANDLE_FILE_INFORMATION, nFileSizeHigh, 4)
    TEST_FIELD_OFFSET(BY_HANDLE_FILE_INFORMATION, nFileSizeHigh, 32)
    TEST_FIELD_SIZE  (BY_HANDLE_FILE_INFORMATION, nFileSizeLow, 4)
    TEST_FIELD_ALIGN (BY_HANDLE_FILE_INFORMATION, nFileSizeLow, 4)
    TEST_FIELD_OFFSET(BY_HANDLE_FILE_INFORMATION, nFileSizeLow, 36)
    TEST_FIELD_SIZE  (BY_HANDLE_FILE_INFORMATION, nNumberOfLinks, 4)
    TEST_FIELD_ALIGN (BY_HANDLE_FILE_INFORMATION, nNumberOfLinks, 4)
    TEST_FIELD_OFFSET(BY_HANDLE_FILE_INFORMATION, nNumberOfLinks, 40)
    TEST_FIELD_SIZE  (BY_HANDLE_FILE_INFORMATION, nFileIndexHigh, 4)
    TEST_FIELD_ALIGN (BY_HANDLE_FILE_INFORMATION, nFileIndexHigh, 4)
    TEST_FIELD_OFFSET(BY_HANDLE_FILE_INFORMATION, nFileIndexHigh, 44)
    TEST_FIELD_SIZE  (BY_HANDLE_FILE_INFORMATION, nFileIndexLow, 4)
    TEST_FIELD_ALIGN (BY_HANDLE_FILE_INFORMATION, nFileIndexLow, 4)
    TEST_FIELD_OFFSET(BY_HANDLE_FILE_INFORMATION, nFileIndexLow, 48)
}

static void test_pack_COMMCONFIG(void)
{
    /* COMMCONFIG */
    TEST_TYPE_SIZE   (COMMCONFIG, 52)
    TEST_TYPE_ALIGN  (COMMCONFIG, 4)
    TEST_FIELD_SIZE  (COMMCONFIG, dwSize, 4)
    TEST_FIELD_ALIGN (COMMCONFIG, dwSize, 4)
    TEST_FIELD_OFFSET(COMMCONFIG, dwSize, 0)
    TEST_FIELD_SIZE  (COMMCONFIG, wVersion, 2)
    TEST_FIELD_ALIGN (COMMCONFIG, wVersion, 2)
    TEST_FIELD_OFFSET(COMMCONFIG, wVersion, 4)
    TEST_FIELD_SIZE  (COMMCONFIG, wReserved, 2)
    TEST_FIELD_ALIGN (COMMCONFIG, wReserved, 2)
    TEST_FIELD_OFFSET(COMMCONFIG, wReserved, 6)
    TEST_FIELD_SIZE  (COMMCONFIG, dcb, 28)
    TEST_FIELD_ALIGN (COMMCONFIG, dcb, 4)
    TEST_FIELD_OFFSET(COMMCONFIG, dcb, 8)
    TEST_FIELD_SIZE  (COMMCONFIG, dwProviderSubType, 4)
    TEST_FIELD_ALIGN (COMMCONFIG, dwProviderSubType, 4)
    TEST_FIELD_OFFSET(COMMCONFIG, dwProviderSubType, 36)
    TEST_FIELD_SIZE  (COMMCONFIG, dwProviderOffset, 4)
    TEST_FIELD_ALIGN (COMMCONFIG, dwProviderOffset, 4)
    TEST_FIELD_OFFSET(COMMCONFIG, dwProviderOffset, 40)
    TEST_FIELD_SIZE  (COMMCONFIG, dwProviderSize, 4)
    TEST_FIELD_ALIGN (COMMCONFIG, dwProviderSize, 4)
    TEST_FIELD_OFFSET(COMMCONFIG, dwProviderSize, 44)
    TEST_FIELD_SIZE  (COMMCONFIG, wcProviderData, 2)
    TEST_FIELD_ALIGN (COMMCONFIG, wcProviderData, 2)
    TEST_FIELD_OFFSET(COMMCONFIG, wcProviderData, 48)
}

static void test_pack_COMMPROP(void)
{
    /* COMMPROP */
    TEST_TYPE_SIZE   (COMMPROP, 64)
    TEST_TYPE_ALIGN  (COMMPROP, 4)
    TEST_FIELD_SIZE  (COMMPROP, wPacketLength, 2)
    TEST_FIELD_ALIGN (COMMPROP, wPacketLength, 2)
    TEST_FIELD_OFFSET(COMMPROP, wPacketLength, 0)
    TEST_FIELD_SIZE  (COMMPROP, wPacketVersion, 2)
    TEST_FIELD_ALIGN (COMMPROP, wPacketVersion, 2)
    TEST_FIELD_OFFSET(COMMPROP, wPacketVersion, 2)
    TEST_FIELD_SIZE  (COMMPROP, dwServiceMask, 4)
    TEST_FIELD_ALIGN (COMMPROP, dwServiceMask, 4)
    TEST_FIELD_OFFSET(COMMPROP, dwServiceMask, 4)
    TEST_FIELD_SIZE  (COMMPROP, dwReserved1, 4)
    TEST_FIELD_ALIGN (COMMPROP, dwReserved1, 4)
    TEST_FIELD_OFFSET(COMMPROP, dwReserved1, 8)
    TEST_FIELD_SIZE  (COMMPROP, dwMaxTxQueue, 4)
    TEST_FIELD_ALIGN (COMMPROP, dwMaxTxQueue, 4)
    TEST_FIELD_OFFSET(COMMPROP, dwMaxTxQueue, 12)
    TEST_FIELD_SIZE  (COMMPROP, dwMaxRxQueue, 4)
    TEST_FIELD_ALIGN (COMMPROP, dwMaxRxQueue, 4)
    TEST_FIELD_OFFSET(COMMPROP, dwMaxRxQueue, 16)
    TEST_FIELD_SIZE  (COMMPROP, dwMaxBaud, 4)
    TEST_FIELD_ALIGN (COMMPROP, dwMaxBaud, 4)
    TEST_FIELD_OFFSET(COMMPROP, dwMaxBaud, 20)
    TEST_FIELD_SIZE  (COMMPROP, dwProvSubType, 4)
    TEST_FIELD_ALIGN (COMMPROP, dwProvSubType, 4)
    TEST_FIELD_OFFSET(COMMPROP, dwProvSubType, 24)
    TEST_FIELD_SIZE  (COMMPROP, dwProvCapabilities, 4)
    TEST_FIELD_ALIGN (COMMPROP, dwProvCapabilities, 4)
    TEST_FIELD_OFFSET(COMMPROP, dwProvCapabilities, 28)
    TEST_FIELD_SIZE  (COMMPROP, dwSettableParams, 4)
    TEST_FIELD_ALIGN (COMMPROP, dwSettableParams, 4)
    TEST_FIELD_OFFSET(COMMPROP, dwSettableParams, 32)
    TEST_FIELD_SIZE  (COMMPROP, dwSettableBaud, 4)
    TEST_FIELD_ALIGN (COMMPROP, dwSettableBaud, 4)
    TEST_FIELD_OFFSET(COMMPROP, dwSettableBaud, 36)
    TEST_FIELD_SIZE  (COMMPROP, wSettableData, 2)
    TEST_FIELD_ALIGN (COMMPROP, wSettableData, 2)
    TEST_FIELD_OFFSET(COMMPROP, wSettableData, 40)
    TEST_FIELD_SIZE  (COMMPROP, wSettableStopParity, 2)
    TEST_FIELD_ALIGN (COMMPROP, wSettableStopParity, 2)
    TEST_FIELD_OFFSET(COMMPROP, wSettableStopParity, 42)
    TEST_FIELD_SIZE  (COMMPROP, dwCurrentTxQueue, 4)
    TEST_FIELD_ALIGN (COMMPROP, dwCurrentTxQueue, 4)
    TEST_FIELD_OFFSET(COMMPROP, dwCurrentTxQueue, 44)
    TEST_FIELD_SIZE  (COMMPROP, dwCurrentRxQueue, 4)
    TEST_FIELD_ALIGN (COMMPROP, dwCurrentRxQueue, 4)
    TEST_FIELD_OFFSET(COMMPROP, dwCurrentRxQueue, 48)
    TEST_FIELD_SIZE  (COMMPROP, dwProvSpec1, 4)
    TEST_FIELD_ALIGN (COMMPROP, dwProvSpec1, 4)
    TEST_FIELD_OFFSET(COMMPROP, dwProvSpec1, 52)
    TEST_FIELD_SIZE  (COMMPROP, dwProvSpec2, 4)
    TEST_FIELD_ALIGN (COMMPROP, dwProvSpec2, 4)
    TEST_FIELD_OFFSET(COMMPROP, dwProvSpec2, 56)
    TEST_FIELD_SIZE  (COMMPROP, wcProvChar, 2)
    TEST_FIELD_ALIGN (COMMPROP, wcProvChar, 2)
    TEST_FIELD_OFFSET(COMMPROP, wcProvChar, 60)
}

static void test_pack_COMMTIMEOUTS(void)
{
    /* COMMTIMEOUTS */
    TEST_TYPE_SIZE   (COMMTIMEOUTS, 20)
    TEST_TYPE_ALIGN  (COMMTIMEOUTS, 4)
    TEST_FIELD_SIZE  (COMMTIMEOUTS, ReadIntervalTimeout, 4)
    TEST_FIELD_ALIGN (COMMTIMEOUTS, ReadIntervalTimeout, 4)
    TEST_FIELD_OFFSET(COMMTIMEOUTS, ReadIntervalTimeout, 0)
    TEST_FIELD_SIZE  (COMMTIMEOUTS, ReadTotalTimeoutMultiplier, 4)
    TEST_FIELD_ALIGN (COMMTIMEOUTS, ReadTotalTimeoutMultiplier, 4)
    TEST_FIELD_OFFSET(COMMTIMEOUTS, ReadTotalTimeoutMultiplier, 4)
    TEST_FIELD_SIZE  (COMMTIMEOUTS, ReadTotalTimeoutConstant, 4)
    TEST_FIELD_ALIGN (COMMTIMEOUTS, ReadTotalTimeoutConstant, 4)
    TEST_FIELD_OFFSET(COMMTIMEOUTS, ReadTotalTimeoutConstant, 8)
    TEST_FIELD_SIZE  (COMMTIMEOUTS, WriteTotalTimeoutMultiplier, 4)
    TEST_FIELD_ALIGN (COMMTIMEOUTS, WriteTotalTimeoutMultiplier, 4)
    TEST_FIELD_OFFSET(COMMTIMEOUTS, WriteTotalTimeoutMultiplier, 12)
    TEST_FIELD_SIZE  (COMMTIMEOUTS, WriteTotalTimeoutConstant, 4)
    TEST_FIELD_ALIGN (COMMTIMEOUTS, WriteTotalTimeoutConstant, 4)
    TEST_FIELD_OFFSET(COMMTIMEOUTS, WriteTotalTimeoutConstant, 16)
}

static void test_pack_COMSTAT(void)
{
    /* COMSTAT */
    TEST_TYPE_SIZE   (COMSTAT, 12)
    TEST_TYPE_ALIGN  (COMSTAT, 4)
    TEST_FIELD_SIZE  (COMSTAT, cbInQue, 4)
    TEST_FIELD_ALIGN (COMSTAT, cbInQue, 4)
    TEST_FIELD_OFFSET(COMSTAT, cbInQue, 4)
    TEST_FIELD_SIZE  (COMSTAT, cbOutQue, 4)
    TEST_FIELD_ALIGN (COMSTAT, cbOutQue, 4)
    TEST_FIELD_OFFSET(COMSTAT, cbOutQue, 8)
}

static void test_pack_CREATE_PROCESS_DEBUG_INFO(void)
{
    /* CREATE_PROCESS_DEBUG_INFO */
    TEST_TYPE_SIZE   (CREATE_PROCESS_DEBUG_INFO, 40)
    TEST_TYPE_ALIGN  (CREATE_PROCESS_DEBUG_INFO, 4)
    TEST_FIELD_SIZE  (CREATE_PROCESS_DEBUG_INFO, hFile, 4)
    TEST_FIELD_ALIGN (CREATE_PROCESS_DEBUG_INFO, hFile, 4)
    TEST_FIELD_OFFSET(CREATE_PROCESS_DEBUG_INFO, hFile, 0)
    TEST_FIELD_SIZE  (CREATE_PROCESS_DEBUG_INFO, hProcess, 4)
    TEST_FIELD_ALIGN (CREATE_PROCESS_DEBUG_INFO, hProcess, 4)
    TEST_FIELD_OFFSET(CREATE_PROCESS_DEBUG_INFO, hProcess, 4)
    TEST_FIELD_SIZE  (CREATE_PROCESS_DEBUG_INFO, hThread, 4)
    TEST_FIELD_ALIGN (CREATE_PROCESS_DEBUG_INFO, hThread, 4)
    TEST_FIELD_OFFSET(CREATE_PROCESS_DEBUG_INFO, hThread, 8)
    TEST_FIELD_SIZE  (CREATE_PROCESS_DEBUG_INFO, lpBaseOfImage, 4)
    TEST_FIELD_ALIGN (CREATE_PROCESS_DEBUG_INFO, lpBaseOfImage, 4)
    TEST_FIELD_OFFSET(CREATE_PROCESS_DEBUG_INFO, lpBaseOfImage, 12)
    TEST_FIELD_SIZE  (CREATE_PROCESS_DEBUG_INFO, dwDebugInfoFileOffset, 4)
    TEST_FIELD_ALIGN (CREATE_PROCESS_DEBUG_INFO, dwDebugInfoFileOffset, 4)
    TEST_FIELD_OFFSET(CREATE_PROCESS_DEBUG_INFO, dwDebugInfoFileOffset, 16)
    TEST_FIELD_SIZE  (CREATE_PROCESS_DEBUG_INFO, nDebugInfoSize, 4)
    TEST_FIELD_ALIGN (CREATE_PROCESS_DEBUG_INFO, nDebugInfoSize, 4)
    TEST_FIELD_OFFSET(CREATE_PROCESS_DEBUG_INFO, nDebugInfoSize, 20)
    TEST_FIELD_SIZE  (CREATE_PROCESS_DEBUG_INFO, lpThreadLocalBase, 4)
    TEST_FIELD_ALIGN (CREATE_PROCESS_DEBUG_INFO, lpThreadLocalBase, 4)
    TEST_FIELD_OFFSET(CREATE_PROCESS_DEBUG_INFO, lpThreadLocalBase, 24)
    TEST_FIELD_SIZE  (CREATE_PROCESS_DEBUG_INFO, lpStartAddress, 4)
    TEST_FIELD_ALIGN (CREATE_PROCESS_DEBUG_INFO, lpStartAddress, 4)
    TEST_FIELD_OFFSET(CREATE_PROCESS_DEBUG_INFO, lpStartAddress, 28)
    TEST_FIELD_SIZE  (CREATE_PROCESS_DEBUG_INFO, lpImageName, 4)
    TEST_FIELD_ALIGN (CREATE_PROCESS_DEBUG_INFO, lpImageName, 4)
    TEST_FIELD_OFFSET(CREATE_PROCESS_DEBUG_INFO, lpImageName, 32)
    TEST_FIELD_SIZE  (CREATE_PROCESS_DEBUG_INFO, fUnicode, 2)
    TEST_FIELD_ALIGN (CREATE_PROCESS_DEBUG_INFO, fUnicode, 2)
    TEST_FIELD_OFFSET(CREATE_PROCESS_DEBUG_INFO, fUnicode, 36)
}

static void test_pack_CREATE_THREAD_DEBUG_INFO(void)
{
    /* CREATE_THREAD_DEBUG_INFO */
    TEST_TYPE_SIZE   (CREATE_THREAD_DEBUG_INFO, 12)
    TEST_TYPE_ALIGN  (CREATE_THREAD_DEBUG_INFO, 4)
    TEST_FIELD_SIZE  (CREATE_THREAD_DEBUG_INFO, hThread, 4)
    TEST_FIELD_ALIGN (CREATE_THREAD_DEBUG_INFO, hThread, 4)
    TEST_FIELD_OFFSET(CREATE_THREAD_DEBUG_INFO, hThread, 0)
    TEST_FIELD_SIZE  (CREATE_THREAD_DEBUG_INFO, lpThreadLocalBase, 4)
    TEST_FIELD_ALIGN (CREATE_THREAD_DEBUG_INFO, lpThreadLocalBase, 4)
    TEST_FIELD_OFFSET(CREATE_THREAD_DEBUG_INFO, lpThreadLocalBase, 4)
    TEST_FIELD_SIZE  (CREATE_THREAD_DEBUG_INFO, lpStartAddress, 4)
    TEST_FIELD_ALIGN (CREATE_THREAD_DEBUG_INFO, lpStartAddress, 4)
    TEST_FIELD_OFFSET(CREATE_THREAD_DEBUG_INFO, lpStartAddress, 8)
}

static void test_pack_CRITICAL_SECTION(void)
{
    /* CRITICAL_SECTION */
    TEST_TYPE_SIZE   (CRITICAL_SECTION, 24)
    TEST_TYPE_ALIGN  (CRITICAL_SECTION, 4)
}

static void test_pack_CRITICAL_SECTION_DEBUG(void)
{
    /* CRITICAL_SECTION_DEBUG */
}

static void test_pack_DCB(void)
{
    /* DCB */
    TEST_TYPE_SIZE   (DCB, 28)
    TEST_TYPE_ALIGN  (DCB, 4)
    TEST_FIELD_SIZE  (DCB, DCBlength, 4)
    TEST_FIELD_ALIGN (DCB, DCBlength, 4)
    TEST_FIELD_OFFSET(DCB, DCBlength, 0)
    TEST_FIELD_SIZE  (DCB, BaudRate, 4)
    TEST_FIELD_ALIGN (DCB, BaudRate, 4)
    TEST_FIELD_OFFSET(DCB, BaudRate, 4)
    TEST_FIELD_SIZE  (DCB, wReserved, 2)
    TEST_FIELD_ALIGN (DCB, wReserved, 2)
    TEST_FIELD_OFFSET(DCB, wReserved, 12)
    TEST_FIELD_SIZE  (DCB, XonLim, 2)
    TEST_FIELD_ALIGN (DCB, XonLim, 2)
    TEST_FIELD_OFFSET(DCB, XonLim, 14)
    TEST_FIELD_SIZE  (DCB, XoffLim, 2)
    TEST_FIELD_ALIGN (DCB, XoffLim, 2)
    TEST_FIELD_OFFSET(DCB, XoffLim, 16)
    TEST_FIELD_SIZE  (DCB, ByteSize, 1)
    TEST_FIELD_ALIGN (DCB, ByteSize, 1)
    TEST_FIELD_OFFSET(DCB, ByteSize, 18)
    TEST_FIELD_SIZE  (DCB, Parity, 1)
    TEST_FIELD_ALIGN (DCB, Parity, 1)
    TEST_FIELD_OFFSET(DCB, Parity, 19)
    TEST_FIELD_SIZE  (DCB, StopBits, 1)
    TEST_FIELD_ALIGN (DCB, StopBits, 1)
    TEST_FIELD_OFFSET(DCB, StopBits, 20)
    TEST_FIELD_SIZE  (DCB, XonChar, 1)
    TEST_FIELD_ALIGN (DCB, XonChar, 1)
    TEST_FIELD_OFFSET(DCB, XonChar, 21)
    TEST_FIELD_SIZE  (DCB, XoffChar, 1)
    TEST_FIELD_ALIGN (DCB, XoffChar, 1)
    TEST_FIELD_OFFSET(DCB, XoffChar, 22)
    TEST_FIELD_SIZE  (DCB, ErrorChar, 1)
    TEST_FIELD_ALIGN (DCB, ErrorChar, 1)
    TEST_FIELD_OFFSET(DCB, ErrorChar, 23)
    TEST_FIELD_SIZE  (DCB, EofChar, 1)
    TEST_FIELD_ALIGN (DCB, EofChar, 1)
    TEST_FIELD_OFFSET(DCB, EofChar, 24)
    TEST_FIELD_SIZE  (DCB, EvtChar, 1)
    TEST_FIELD_ALIGN (DCB, EvtChar, 1)
    TEST_FIELD_OFFSET(DCB, EvtChar, 25)
    TEST_FIELD_SIZE  (DCB, wReserved1, 2)
    TEST_FIELD_ALIGN (DCB, wReserved1, 2)
    TEST_FIELD_OFFSET(DCB, wReserved1, 26)
}

static void test_pack_DEBUG_EVENT(void)
{
    /* DEBUG_EVENT */
    TEST_FIELD_SIZE  (DEBUG_EVENT, dwDebugEventCode, 4)
    TEST_FIELD_ALIGN (DEBUG_EVENT, dwDebugEventCode, 4)
    TEST_FIELD_OFFSET(DEBUG_EVENT, dwDebugEventCode, 0)
    TEST_FIELD_SIZE  (DEBUG_EVENT, dwProcessId, 4)
    TEST_FIELD_ALIGN (DEBUG_EVENT, dwProcessId, 4)
    TEST_FIELD_OFFSET(DEBUG_EVENT, dwProcessId, 4)
    TEST_FIELD_SIZE  (DEBUG_EVENT, dwThreadId, 4)
    TEST_FIELD_ALIGN (DEBUG_EVENT, dwThreadId, 4)
    TEST_FIELD_OFFSET(DEBUG_EVENT, dwThreadId, 8)
}

static void test_pack_ENUMRESLANGPROCA(void)
{
    /* ENUMRESLANGPROCA */
    TEST_TYPE_SIZE   (ENUMRESLANGPROCA, 4)
    TEST_TYPE_ALIGN  (ENUMRESLANGPROCA, 4)
}

static void test_pack_ENUMRESLANGPROCW(void)
{
    /* ENUMRESLANGPROCW */
    TEST_TYPE_SIZE   (ENUMRESLANGPROCW, 4)
    TEST_TYPE_ALIGN  (ENUMRESLANGPROCW, 4)
}

static void test_pack_ENUMRESNAMEPROCA(void)
{
    /* ENUMRESNAMEPROCA */
    TEST_TYPE_SIZE   (ENUMRESNAMEPROCA, 4)
    TEST_TYPE_ALIGN  (ENUMRESNAMEPROCA, 4)
}

static void test_pack_ENUMRESNAMEPROCW(void)
{
    /* ENUMRESNAMEPROCW */
    TEST_TYPE_SIZE   (ENUMRESNAMEPROCW, 4)
    TEST_TYPE_ALIGN  (ENUMRESNAMEPROCW, 4)
}

static void test_pack_ENUMRESTYPEPROCA(void)
{
    /* ENUMRESTYPEPROCA */
    TEST_TYPE_SIZE   (ENUMRESTYPEPROCA, 4)
    TEST_TYPE_ALIGN  (ENUMRESTYPEPROCA, 4)
}

static void test_pack_ENUMRESTYPEPROCW(void)
{
    /* ENUMRESTYPEPROCW */
    TEST_TYPE_SIZE   (ENUMRESTYPEPROCW, 4)
    TEST_TYPE_ALIGN  (ENUMRESTYPEPROCW, 4)
}

static void test_pack_EXCEPTION_DEBUG_INFO(void)
{
    /* EXCEPTION_DEBUG_INFO */
    TEST_TYPE_SIZE   (EXCEPTION_DEBUG_INFO, 84)
    TEST_TYPE_ALIGN  (EXCEPTION_DEBUG_INFO, 4)
    TEST_FIELD_SIZE  (EXCEPTION_DEBUG_INFO, ExceptionRecord, 80)
    TEST_FIELD_ALIGN (EXCEPTION_DEBUG_INFO, ExceptionRecord, 4)
    TEST_FIELD_OFFSET(EXCEPTION_DEBUG_INFO, ExceptionRecord, 0)
    TEST_FIELD_SIZE  (EXCEPTION_DEBUG_INFO, dwFirstChance, 4)
    TEST_FIELD_ALIGN (EXCEPTION_DEBUG_INFO, dwFirstChance, 4)
    TEST_FIELD_OFFSET(EXCEPTION_DEBUG_INFO, dwFirstChance, 80)
}

static void test_pack_EXIT_PROCESS_DEBUG_INFO(void)
{
    /* EXIT_PROCESS_DEBUG_INFO */
    TEST_TYPE_SIZE   (EXIT_PROCESS_DEBUG_INFO, 4)
    TEST_TYPE_ALIGN  (EXIT_PROCESS_DEBUG_INFO, 4)
    TEST_FIELD_SIZE  (EXIT_PROCESS_DEBUG_INFO, dwExitCode, 4)
    TEST_FIELD_ALIGN (EXIT_PROCESS_DEBUG_INFO, dwExitCode, 4)
    TEST_FIELD_OFFSET(EXIT_PROCESS_DEBUG_INFO, dwExitCode, 0)
}

static void test_pack_EXIT_THREAD_DEBUG_INFO(void)
{
    /* EXIT_THREAD_DEBUG_INFO */
    TEST_TYPE_SIZE   (EXIT_THREAD_DEBUG_INFO, 4)
    TEST_TYPE_ALIGN  (EXIT_THREAD_DEBUG_INFO, 4)
    TEST_FIELD_SIZE  (EXIT_THREAD_DEBUG_INFO, dwExitCode, 4)
    TEST_FIELD_ALIGN (EXIT_THREAD_DEBUG_INFO, dwExitCode, 4)
    TEST_FIELD_OFFSET(EXIT_THREAD_DEBUG_INFO, dwExitCode, 0)
}

static void test_pack_HW_PROFILE_INFOA(void)
{
    /* HW_PROFILE_INFOA */
    TEST_TYPE_SIZE   (HW_PROFILE_INFOA, 124)
    TEST_TYPE_ALIGN  (HW_PROFILE_INFOA, 4)
    TEST_FIELD_SIZE  (HW_PROFILE_INFOA, dwDockInfo, 4)
    TEST_FIELD_ALIGN (HW_PROFILE_INFOA, dwDockInfo, 4)
    TEST_FIELD_OFFSET(HW_PROFILE_INFOA, dwDockInfo, 0)
    TEST_FIELD_SIZE  (HW_PROFILE_INFOA, szHwProfileGuid, 39)
    TEST_FIELD_ALIGN (HW_PROFILE_INFOA, szHwProfileGuid, 1)
    TEST_FIELD_OFFSET(HW_PROFILE_INFOA, szHwProfileGuid, 4)
    TEST_FIELD_SIZE  (HW_PROFILE_INFOA, szHwProfileName, 80)
    TEST_FIELD_ALIGN (HW_PROFILE_INFOA, szHwProfileName, 1)
    TEST_FIELD_OFFSET(HW_PROFILE_INFOA, szHwProfileName, 43)
}

static void test_pack_HW_PROFILE_INFOW(void)
{
    /* HW_PROFILE_INFOW */
    TEST_TYPE_SIZE   (HW_PROFILE_INFOW, 244)
    TEST_TYPE_ALIGN  (HW_PROFILE_INFOW, 4)
    TEST_FIELD_SIZE  (HW_PROFILE_INFOW, dwDockInfo, 4)
    TEST_FIELD_ALIGN (HW_PROFILE_INFOW, dwDockInfo, 4)
    TEST_FIELD_OFFSET(HW_PROFILE_INFOW, dwDockInfo, 0)
    TEST_FIELD_SIZE  (HW_PROFILE_INFOW, szHwProfileGuid, 78)
    TEST_FIELD_ALIGN (HW_PROFILE_INFOW, szHwProfileGuid, 2)
    TEST_FIELD_OFFSET(HW_PROFILE_INFOW, szHwProfileGuid, 4)
    TEST_FIELD_SIZE  (HW_PROFILE_INFOW, szHwProfileName, 160)
    TEST_FIELD_ALIGN (HW_PROFILE_INFOW, szHwProfileName, 2)
    TEST_FIELD_OFFSET(HW_PROFILE_INFOW, szHwProfileName, 82)
}

static void test_pack_LOAD_DLL_DEBUG_INFO(void)
{
    /* LOAD_DLL_DEBUG_INFO */
    TEST_TYPE_SIZE   (LOAD_DLL_DEBUG_INFO, 24)
    TEST_TYPE_ALIGN  (LOAD_DLL_DEBUG_INFO, 4)
    TEST_FIELD_SIZE  (LOAD_DLL_DEBUG_INFO, hFile, 4)
    TEST_FIELD_ALIGN (LOAD_DLL_DEBUG_INFO, hFile, 4)
    TEST_FIELD_OFFSET(LOAD_DLL_DEBUG_INFO, hFile, 0)
    TEST_FIELD_SIZE  (LOAD_DLL_DEBUG_INFO, lpBaseOfDll, 4)
    TEST_FIELD_ALIGN (LOAD_DLL_DEBUG_INFO, lpBaseOfDll, 4)
    TEST_FIELD_OFFSET(LOAD_DLL_DEBUG_INFO, lpBaseOfDll, 4)
    TEST_FIELD_SIZE  (LOAD_DLL_DEBUG_INFO, dwDebugInfoFileOffset, 4)
    TEST_FIELD_ALIGN (LOAD_DLL_DEBUG_INFO, dwDebugInfoFileOffset, 4)
    TEST_FIELD_OFFSET(LOAD_DLL_DEBUG_INFO, dwDebugInfoFileOffset, 8)
    TEST_FIELD_SIZE  (LOAD_DLL_DEBUG_INFO, nDebugInfoSize, 4)
    TEST_FIELD_ALIGN (LOAD_DLL_DEBUG_INFO, nDebugInfoSize, 4)
    TEST_FIELD_OFFSET(LOAD_DLL_DEBUG_INFO, nDebugInfoSize, 12)
    TEST_FIELD_SIZE  (LOAD_DLL_DEBUG_INFO, lpImageName, 4)
    TEST_FIELD_ALIGN (LOAD_DLL_DEBUG_INFO, lpImageName, 4)
    TEST_FIELD_OFFSET(LOAD_DLL_DEBUG_INFO, lpImageName, 16)
    TEST_FIELD_SIZE  (LOAD_DLL_DEBUG_INFO, fUnicode, 2)
    TEST_FIELD_ALIGN (LOAD_DLL_DEBUG_INFO, fUnicode, 2)
    TEST_FIELD_OFFSET(LOAD_DLL_DEBUG_INFO, fUnicode, 20)
}

static void test_pack_LPBY_HANDLE_FILE_INFORMATION(void)
{
    /* LPBY_HANDLE_FILE_INFORMATION */
    TEST_TYPE_SIZE   (LPBY_HANDLE_FILE_INFORMATION, 4)
    TEST_TYPE_ALIGN  (LPBY_HANDLE_FILE_INFORMATION, 4)
    TEST_TARGET_SIZE (LPBY_HANDLE_FILE_INFORMATION, 52)
    TEST_TARGET_ALIGN(LPBY_HANDLE_FILE_INFORMATION, 4)
}

static void test_pack_LPCOMMCONFIG(void)
{
    /* LPCOMMCONFIG */
    TEST_TYPE_SIZE   (LPCOMMCONFIG, 4)
    TEST_TYPE_ALIGN  (LPCOMMCONFIG, 4)
    TEST_TARGET_SIZE (LPCOMMCONFIG, 52)
    TEST_TARGET_ALIGN(LPCOMMCONFIG, 4)
}

static void test_pack_LPCOMMPROP(void)
{
    /* LPCOMMPROP */
    TEST_TYPE_SIZE   (LPCOMMPROP, 4)
    TEST_TYPE_ALIGN  (LPCOMMPROP, 4)
    TEST_TARGET_SIZE (LPCOMMPROP, 64)
    TEST_TARGET_ALIGN(LPCOMMPROP, 4)
}

static void test_pack_LPCOMMTIMEOUTS(void)
{
    /* LPCOMMTIMEOUTS */
    TEST_TYPE_SIZE   (LPCOMMTIMEOUTS, 4)
    TEST_TYPE_ALIGN  (LPCOMMTIMEOUTS, 4)
    TEST_TARGET_SIZE (LPCOMMTIMEOUTS, 20)
    TEST_TARGET_ALIGN(LPCOMMTIMEOUTS, 4)
}

static void test_pack_LPCOMSTAT(void)
{
    /* LPCOMSTAT */
    TEST_TYPE_SIZE   (LPCOMSTAT, 4)
    TEST_TYPE_ALIGN  (LPCOMSTAT, 4)
    TEST_TARGET_SIZE (LPCOMSTAT, 12)
    TEST_TARGET_ALIGN(LPCOMSTAT, 4)
}

static void test_pack_LPCRITICAL_SECTION(void)
{
    /* LPCRITICAL_SECTION */
    TEST_TYPE_SIZE   (LPCRITICAL_SECTION, 4)
    TEST_TYPE_ALIGN  (LPCRITICAL_SECTION, 4)
}

static void test_pack_LPCRITICAL_SECTION_DEBUG(void)
{
    /* LPCRITICAL_SECTION_DEBUG */
    TEST_TYPE_SIZE   (LPCRITICAL_SECTION_DEBUG, 4)
    TEST_TYPE_ALIGN  (LPCRITICAL_SECTION_DEBUG, 4)
}

static void test_pack_LPDCB(void)
{
    /* LPDCB */
    TEST_TYPE_SIZE   (LPDCB, 4)
    TEST_TYPE_ALIGN  (LPDCB, 4)
    TEST_TARGET_SIZE (LPDCB, 28)
    TEST_TARGET_ALIGN(LPDCB, 4)
}

static void test_pack_LPDEBUG_EVENT(void)
{
    /* LPDEBUG_EVENT */
    TEST_TYPE_SIZE   (LPDEBUG_EVENT, 4)
    TEST_TYPE_ALIGN  (LPDEBUG_EVENT, 4)
}

static void test_pack_LPEXCEPTION_POINTERS(void)
{
    /* LPEXCEPTION_POINTERS */
    TEST_TYPE_SIZE   (LPEXCEPTION_POINTERS, 4)
    TEST_TYPE_ALIGN  (LPEXCEPTION_POINTERS, 4)
}

static void test_pack_LPEXCEPTION_RECORD(void)
{
    /* LPEXCEPTION_RECORD */
    TEST_TYPE_SIZE   (LPEXCEPTION_RECORD, 4)
    TEST_TYPE_ALIGN  (LPEXCEPTION_RECORD, 4)
}

static void test_pack_LPFIBER_START_ROUTINE(void)
{
    /* LPFIBER_START_ROUTINE */
    TEST_TYPE_SIZE   (LPFIBER_START_ROUTINE, 4)
    TEST_TYPE_ALIGN  (LPFIBER_START_ROUTINE, 4)
}

static void test_pack_LPHW_PROFILE_INFOA(void)
{
    /* LPHW_PROFILE_INFOA */
    TEST_TYPE_SIZE   (LPHW_PROFILE_INFOA, 4)
    TEST_TYPE_ALIGN  (LPHW_PROFILE_INFOA, 4)
    TEST_TARGET_SIZE (LPHW_PROFILE_INFOA, 124)
    TEST_TARGET_ALIGN(LPHW_PROFILE_INFOA, 4)
}

static void test_pack_LPHW_PROFILE_INFOW(void)
{
    /* LPHW_PROFILE_INFOW */
    TEST_TYPE_SIZE   (LPHW_PROFILE_INFOW, 4)
    TEST_TYPE_ALIGN  (LPHW_PROFILE_INFOW, 4)
    TEST_TARGET_SIZE (LPHW_PROFILE_INFOW, 244)
    TEST_TARGET_ALIGN(LPHW_PROFILE_INFOW, 4)
}

static void test_pack_LPMEMORYSTATUS(void)
{
    /* LPMEMORYSTATUS */
    TEST_TYPE_SIZE   (LPMEMORYSTATUS, 4)
    TEST_TYPE_ALIGN  (LPMEMORYSTATUS, 4)
    TEST_TARGET_SIZE (LPMEMORYSTATUS, 32)
    TEST_TARGET_ALIGN(LPMEMORYSTATUS, 4)
}

static void test_pack_LPMEMORYSTATUSEX(void)
{
    /* LPMEMORYSTATUSEX */
    TEST_TYPE_SIZE   (LPMEMORYSTATUSEX, 4)
    TEST_TYPE_ALIGN  (LPMEMORYSTATUSEX, 4)
    TEST_TARGET_SIZE (LPMEMORYSTATUSEX, 64)
    TEST_TARGET_ALIGN(LPMEMORYSTATUSEX, 8)
}

static void test_pack_LPOFSTRUCT(void)
{
    /* LPOFSTRUCT */
    TEST_TYPE_SIZE   (LPOFSTRUCT, 4)
    TEST_TYPE_ALIGN  (LPOFSTRUCT, 4)
    TEST_TARGET_SIZE (LPOFSTRUCT, 136)
    TEST_TARGET_ALIGN(LPOFSTRUCT, 2)
}

static void test_pack_LPOVERLAPPED(void)
{
    /* LPOVERLAPPED */
    TEST_TYPE_SIZE   (LPOVERLAPPED, 4)
    TEST_TYPE_ALIGN  (LPOVERLAPPED, 4)
}

static void test_pack_LPOVERLAPPED_COMPLETION_ROUTINE(void)
{
    /* LPOVERLAPPED_COMPLETION_ROUTINE */
    TEST_TYPE_SIZE   (LPOVERLAPPED_COMPLETION_ROUTINE, 4)
    TEST_TYPE_ALIGN  (LPOVERLAPPED_COMPLETION_ROUTINE, 4)
}

static void test_pack_LPPROCESS_HEAP_ENTRY(void)
{
    /* LPPROCESS_HEAP_ENTRY */
    TEST_TYPE_SIZE   (LPPROCESS_HEAP_ENTRY, 4)
    TEST_TYPE_ALIGN  (LPPROCESS_HEAP_ENTRY, 4)
}

static void test_pack_LPPROCESS_INFORMATION(void)
{
    /* LPPROCESS_INFORMATION */
    TEST_TYPE_SIZE   (LPPROCESS_INFORMATION, 4)
    TEST_TYPE_ALIGN  (LPPROCESS_INFORMATION, 4)
    TEST_TARGET_SIZE (LPPROCESS_INFORMATION, 16)
    TEST_TARGET_ALIGN(LPPROCESS_INFORMATION, 4)
}

static void test_pack_LPPROGRESS_ROUTINE(void)
{
    /* LPPROGRESS_ROUTINE */
    TEST_TYPE_SIZE   (LPPROGRESS_ROUTINE, 4)
    TEST_TYPE_ALIGN  (LPPROGRESS_ROUTINE, 4)
}

static void test_pack_LPSECURITY_ATTRIBUTES(void)
{
    /* LPSECURITY_ATTRIBUTES */
    TEST_TYPE_SIZE   (LPSECURITY_ATTRIBUTES, 4)
    TEST_TYPE_ALIGN  (LPSECURITY_ATTRIBUTES, 4)
    TEST_TARGET_SIZE (LPSECURITY_ATTRIBUTES, 12)
    TEST_TARGET_ALIGN(LPSECURITY_ATTRIBUTES, 4)
}

static void test_pack_LPSTARTUPINFOA(void)
{
    /* LPSTARTUPINFOA */
    TEST_TYPE_SIZE   (LPSTARTUPINFOA, 4)
    TEST_TYPE_ALIGN  (LPSTARTUPINFOA, 4)
    TEST_TARGET_SIZE (LPSTARTUPINFOA, 68)
    TEST_TARGET_ALIGN(LPSTARTUPINFOA, 4)
}

static void test_pack_LPSTARTUPINFOW(void)
{
    /* LPSTARTUPINFOW */
    TEST_TYPE_SIZE   (LPSTARTUPINFOW, 4)
    TEST_TYPE_ALIGN  (LPSTARTUPINFOW, 4)
    TEST_TARGET_SIZE (LPSTARTUPINFOW, 68)
    TEST_TARGET_ALIGN(LPSTARTUPINFOW, 4)
}

static void test_pack_LPSYSTEMTIME(void)
{
    /* LPSYSTEMTIME */
    TEST_TYPE_SIZE   (LPSYSTEMTIME, 4)
    TEST_TYPE_ALIGN  (LPSYSTEMTIME, 4)
    TEST_TARGET_SIZE (LPSYSTEMTIME, 16)
    TEST_TARGET_ALIGN(LPSYSTEMTIME, 2)
}

static void test_pack_LPSYSTEM_INFO(void)
{
    /* LPSYSTEM_INFO */
    TEST_TYPE_SIZE   (LPSYSTEM_INFO, 4)
    TEST_TYPE_ALIGN  (LPSYSTEM_INFO, 4)
}

static void test_pack_LPSYSTEM_POWER_STATUS(void)
{
    /* LPSYSTEM_POWER_STATUS */
    TEST_TYPE_SIZE   (LPSYSTEM_POWER_STATUS, 4)
    TEST_TYPE_ALIGN  (LPSYSTEM_POWER_STATUS, 4)
    TEST_TARGET_SIZE (LPSYSTEM_POWER_STATUS, 12)
    TEST_TARGET_ALIGN(LPSYSTEM_POWER_STATUS, 4)
}

static void test_pack_LPTHREAD_START_ROUTINE(void)
{
    /* LPTHREAD_START_ROUTINE */
    TEST_TYPE_SIZE   (LPTHREAD_START_ROUTINE, 4)
    TEST_TYPE_ALIGN  (LPTHREAD_START_ROUTINE, 4)
}

static void test_pack_LPWIN32_FILE_ATTRIBUTE_DATA(void)
{
    /* LPWIN32_FILE_ATTRIBUTE_DATA */
    TEST_TYPE_SIZE   (LPWIN32_FILE_ATTRIBUTE_DATA, 4)
    TEST_TYPE_ALIGN  (LPWIN32_FILE_ATTRIBUTE_DATA, 4)
    TEST_TARGET_SIZE (LPWIN32_FILE_ATTRIBUTE_DATA, 36)
    TEST_TARGET_ALIGN(LPWIN32_FILE_ATTRIBUTE_DATA, 4)
}

static void test_pack_LPWIN32_FIND_DATAA(void)
{
    /* LPWIN32_FIND_DATAA */
    TEST_TYPE_SIZE   (LPWIN32_FIND_DATAA, 4)
    TEST_TYPE_ALIGN  (LPWIN32_FIND_DATAA, 4)
    TEST_TARGET_SIZE (LPWIN32_FIND_DATAA, 320)
    TEST_TARGET_ALIGN(LPWIN32_FIND_DATAA, 4)
}

static void test_pack_LPWIN32_FIND_DATAW(void)
{
    /* LPWIN32_FIND_DATAW */
    TEST_TYPE_SIZE   (LPWIN32_FIND_DATAW, 4)
    TEST_TYPE_ALIGN  (LPWIN32_FIND_DATAW, 4)
    TEST_TARGET_SIZE (LPWIN32_FIND_DATAW, 592)
    TEST_TARGET_ALIGN(LPWIN32_FIND_DATAW, 4)
}

static void test_pack_LPWIN32_STREAM_ID(void)
{
    /* LPWIN32_STREAM_ID */
    TEST_TYPE_SIZE   (LPWIN32_STREAM_ID, 4)
    TEST_TYPE_ALIGN  (LPWIN32_STREAM_ID, 4)
    TEST_TARGET_SIZE (LPWIN32_STREAM_ID, 24)
    TEST_TARGET_ALIGN(LPWIN32_STREAM_ID, 8)
}

static void test_pack_MEMORYSTATUS(void)
{
    /* MEMORYSTATUS */
    TEST_TYPE_SIZE   (MEMORYSTATUS, 32)
    TEST_TYPE_ALIGN  (MEMORYSTATUS, 4)
    TEST_FIELD_SIZE  (MEMORYSTATUS, dwLength, 4)
    TEST_FIELD_ALIGN (MEMORYSTATUS, dwLength, 4)
    TEST_FIELD_OFFSET(MEMORYSTATUS, dwLength, 0)
    TEST_FIELD_SIZE  (MEMORYSTATUS, dwMemoryLoad, 4)
    TEST_FIELD_ALIGN (MEMORYSTATUS, dwMemoryLoad, 4)
    TEST_FIELD_OFFSET(MEMORYSTATUS, dwMemoryLoad, 4)
    TEST_FIELD_SIZE  (MEMORYSTATUS, dwTotalPhys, 4)
    TEST_FIELD_ALIGN (MEMORYSTATUS, dwTotalPhys, 4)
    TEST_FIELD_OFFSET(MEMORYSTATUS, dwTotalPhys, 8)
    TEST_FIELD_SIZE  (MEMORYSTATUS, dwAvailPhys, 4)
    TEST_FIELD_ALIGN (MEMORYSTATUS, dwAvailPhys, 4)
    TEST_FIELD_OFFSET(MEMORYSTATUS, dwAvailPhys, 12)
    TEST_FIELD_SIZE  (MEMORYSTATUS, dwTotalPageFile, 4)
    TEST_FIELD_ALIGN (MEMORYSTATUS, dwTotalPageFile, 4)
    TEST_FIELD_OFFSET(MEMORYSTATUS, dwTotalPageFile, 16)
    TEST_FIELD_SIZE  (MEMORYSTATUS, dwAvailPageFile, 4)
    TEST_FIELD_ALIGN (MEMORYSTATUS, dwAvailPageFile, 4)
    TEST_FIELD_OFFSET(MEMORYSTATUS, dwAvailPageFile, 20)
    TEST_FIELD_SIZE  (MEMORYSTATUS, dwTotalVirtual, 4)
    TEST_FIELD_ALIGN (MEMORYSTATUS, dwTotalVirtual, 4)
    TEST_FIELD_OFFSET(MEMORYSTATUS, dwTotalVirtual, 24)
    TEST_FIELD_SIZE  (MEMORYSTATUS, dwAvailVirtual, 4)
    TEST_FIELD_ALIGN (MEMORYSTATUS, dwAvailVirtual, 4)
    TEST_FIELD_OFFSET(MEMORYSTATUS, dwAvailVirtual, 28)
}

static void test_pack_MEMORYSTATUSEX(void)
{
    /* MEMORYSTATUSEX (pack 8) */
    TEST_TYPE_SIZE   (MEMORYSTATUSEX, 64)
    TEST_TYPE_ALIGN  (MEMORYSTATUSEX, 8)
    TEST_FIELD_SIZE  (MEMORYSTATUSEX, dwLength, 4)
    TEST_FIELD_ALIGN (MEMORYSTATUSEX, dwLength, 4)
    TEST_FIELD_OFFSET(MEMORYSTATUSEX, dwLength, 0)
    TEST_FIELD_SIZE  (MEMORYSTATUSEX, dwMemoryLoad, 4)
    TEST_FIELD_ALIGN (MEMORYSTATUSEX, dwMemoryLoad, 4)
    TEST_FIELD_OFFSET(MEMORYSTATUSEX, dwMemoryLoad, 4)
    TEST_FIELD_SIZE  (MEMORYSTATUSEX, ullTotalPhys, 8)
    TEST_FIELD_ALIGN (MEMORYSTATUSEX, ullTotalPhys, 8)
    TEST_FIELD_OFFSET(MEMORYSTATUSEX, ullTotalPhys, 8)
    TEST_FIELD_SIZE  (MEMORYSTATUSEX, ullAvailPhys, 8)
    TEST_FIELD_ALIGN (MEMORYSTATUSEX, ullAvailPhys, 8)
    TEST_FIELD_OFFSET(MEMORYSTATUSEX, ullAvailPhys, 16)
    TEST_FIELD_SIZE  (MEMORYSTATUSEX, ullTotalPageFile, 8)
    TEST_FIELD_ALIGN (MEMORYSTATUSEX, ullTotalPageFile, 8)
    TEST_FIELD_OFFSET(MEMORYSTATUSEX, ullTotalPageFile, 24)
    TEST_FIELD_SIZE  (MEMORYSTATUSEX, ullAvailPageFile, 8)
    TEST_FIELD_ALIGN (MEMORYSTATUSEX, ullAvailPageFile, 8)
    TEST_FIELD_OFFSET(MEMORYSTATUSEX, ullAvailPageFile, 32)
    TEST_FIELD_SIZE  (MEMORYSTATUSEX, ullTotalVirtual, 8)
    TEST_FIELD_ALIGN (MEMORYSTATUSEX, ullTotalVirtual, 8)
    TEST_FIELD_OFFSET(MEMORYSTATUSEX, ullTotalVirtual, 40)
    TEST_FIELD_SIZE  (MEMORYSTATUSEX, ullAvailVirtual, 8)
    TEST_FIELD_ALIGN (MEMORYSTATUSEX, ullAvailVirtual, 8)
    TEST_FIELD_OFFSET(MEMORYSTATUSEX, ullAvailVirtual, 48)
    TEST_FIELD_SIZE  (MEMORYSTATUSEX, ullAvailExtendedVirtual, 8)
    TEST_FIELD_ALIGN (MEMORYSTATUSEX, ullAvailExtendedVirtual, 8)
    TEST_FIELD_OFFSET(MEMORYSTATUSEX, ullAvailExtendedVirtual, 56)
}

static void test_pack_OFSTRUCT(void)
{
    /* OFSTRUCT */
    TEST_TYPE_SIZE   (OFSTRUCT, 136)
    TEST_TYPE_ALIGN  (OFSTRUCT, 2)
    TEST_FIELD_SIZE  (OFSTRUCT, cBytes, 1)
    TEST_FIELD_ALIGN (OFSTRUCT, cBytes, 1)
    TEST_FIELD_OFFSET(OFSTRUCT, cBytes, 0)
    TEST_FIELD_SIZE  (OFSTRUCT, fFixedDisk, 1)
    TEST_FIELD_ALIGN (OFSTRUCT, fFixedDisk, 1)
    TEST_FIELD_OFFSET(OFSTRUCT, fFixedDisk, 1)
    TEST_FIELD_SIZE  (OFSTRUCT, nErrCode, 2)
    TEST_FIELD_ALIGN (OFSTRUCT, nErrCode, 2)
    TEST_FIELD_OFFSET(OFSTRUCT, nErrCode, 2)
    TEST_FIELD_SIZE  (OFSTRUCT, Reserved1, 2)
    TEST_FIELD_ALIGN (OFSTRUCT, Reserved1, 2)
    TEST_FIELD_OFFSET(OFSTRUCT, Reserved1, 4)
    TEST_FIELD_SIZE  (OFSTRUCT, Reserved2, 2)
    TEST_FIELD_ALIGN (OFSTRUCT, Reserved2, 2)
    TEST_FIELD_OFFSET(OFSTRUCT, Reserved2, 6)
    TEST_FIELD_SIZE  (OFSTRUCT, szPathName, 128)
    TEST_FIELD_ALIGN (OFSTRUCT, szPathName, 1)
    TEST_FIELD_OFFSET(OFSTRUCT, szPathName, 8)
}

static void test_pack_OUTPUT_DEBUG_STRING_INFO(void)
{
    /* OUTPUT_DEBUG_STRING_INFO */
    TEST_TYPE_SIZE   (OUTPUT_DEBUG_STRING_INFO, 8)
    TEST_TYPE_ALIGN  (OUTPUT_DEBUG_STRING_INFO, 4)
    TEST_FIELD_SIZE  (OUTPUT_DEBUG_STRING_INFO, lpDebugStringData, 4)
    TEST_FIELD_ALIGN (OUTPUT_DEBUG_STRING_INFO, lpDebugStringData, 4)
    TEST_FIELD_OFFSET(OUTPUT_DEBUG_STRING_INFO, lpDebugStringData, 0)
    TEST_FIELD_SIZE  (OUTPUT_DEBUG_STRING_INFO, fUnicode, 2)
    TEST_FIELD_ALIGN (OUTPUT_DEBUG_STRING_INFO, fUnicode, 2)
    TEST_FIELD_OFFSET(OUTPUT_DEBUG_STRING_INFO, fUnicode, 4)
    TEST_FIELD_SIZE  (OUTPUT_DEBUG_STRING_INFO, nDebugStringLength, 2)
    TEST_FIELD_ALIGN (OUTPUT_DEBUG_STRING_INFO, nDebugStringLength, 2)
    TEST_FIELD_OFFSET(OUTPUT_DEBUG_STRING_INFO, nDebugStringLength, 6)
}

static void test_pack_PACTCTXA(void)
{
    /* PACTCTXA */
    TEST_TYPE_SIZE   (PACTCTXA, 4)
    TEST_TYPE_ALIGN  (PACTCTXA, 4)
    TEST_TARGET_SIZE (PACTCTXA, 32)
    TEST_TARGET_ALIGN(PACTCTXA, 4)
}

static void test_pack_PACTCTXW(void)
{
    /* PACTCTXW */
    TEST_TYPE_SIZE   (PACTCTXW, 4)
    TEST_TYPE_ALIGN  (PACTCTXW, 4)
    TEST_TARGET_SIZE (PACTCTXW, 32)
    TEST_TARGET_ALIGN(PACTCTXW, 4)
}

static void test_pack_PACTCTX_SECTION_KEYED_DATA(void)
{
    /* PACTCTX_SECTION_KEYED_DATA */
    TEST_TYPE_SIZE   (PACTCTX_SECTION_KEYED_DATA, 4)
    TEST_TYPE_ALIGN  (PACTCTX_SECTION_KEYED_DATA, 4)
    TEST_TARGET_SIZE (PACTCTX_SECTION_KEYED_DATA, 64)
    TEST_TARGET_ALIGN(PACTCTX_SECTION_KEYED_DATA, 4)
}

static void test_pack_PACTCTX_SECTION_KEYED_DATA_2600(void)
{
    /* PACTCTX_SECTION_KEYED_DATA_2600 */
    TEST_TYPE_SIZE   (PACTCTX_SECTION_KEYED_DATA_2600, 4)
    TEST_TYPE_ALIGN  (PACTCTX_SECTION_KEYED_DATA_2600, 4)
    TEST_TARGET_SIZE (PACTCTX_SECTION_KEYED_DATA_2600, 40)
    TEST_TARGET_ALIGN(PACTCTX_SECTION_KEYED_DATA_2600, 4)
}

static void test_pack_PACTCTX_SECTION_KEYED_DATA_ASSEMBLY_METADATA(void)
{
    /* PACTCTX_SECTION_KEYED_DATA_ASSEMBLY_METADATA */
    TEST_TYPE_SIZE   (PACTCTX_SECTION_KEYED_DATA_ASSEMBLY_METADATA, 4)
    TEST_TYPE_ALIGN  (PACTCTX_SECTION_KEYED_DATA_ASSEMBLY_METADATA, 4)
    TEST_TARGET_SIZE (PACTCTX_SECTION_KEYED_DATA_ASSEMBLY_METADATA, 20)
    TEST_TARGET_ALIGN(PACTCTX_SECTION_KEYED_DATA_ASSEMBLY_METADATA, 4)
}

static void test_pack_PACTIVATION_CONTEXT_BASIC_INFORMATION(void)
{
    /* PACTIVATION_CONTEXT_BASIC_INFORMATION */
    TEST_TYPE_SIZE   (PACTIVATION_CONTEXT_BASIC_INFORMATION, 4)
    TEST_TYPE_ALIGN  (PACTIVATION_CONTEXT_BASIC_INFORMATION, 4)
    TEST_TARGET_SIZE (PACTIVATION_CONTEXT_BASIC_INFORMATION, 8)
    TEST_TARGET_ALIGN(PACTIVATION_CONTEXT_BASIC_INFORMATION, 4)
}

static void test_pack_PAPCFUNC(void)
{
    /* PAPCFUNC */
    TEST_TYPE_SIZE   (PAPCFUNC, 4)
    TEST_TYPE_ALIGN  (PAPCFUNC, 4)
}

static void test_pack_PBY_HANDLE_FILE_INFORMATION(void)
{
    /* PBY_HANDLE_FILE_INFORMATION */
    TEST_TYPE_SIZE   (PBY_HANDLE_FILE_INFORMATION, 4)
    TEST_TYPE_ALIGN  (PBY_HANDLE_FILE_INFORMATION, 4)
    TEST_TARGET_SIZE (PBY_HANDLE_FILE_INFORMATION, 52)
    TEST_TARGET_ALIGN(PBY_HANDLE_FILE_INFORMATION, 4)
}

static void test_pack_PCACTCTXA(void)
{
    /* PCACTCTXA */
    TEST_TYPE_SIZE   (PCACTCTXA, 4)
    TEST_TYPE_ALIGN  (PCACTCTXA, 4)
    TEST_TARGET_SIZE (PCACTCTXA, 32)
    TEST_TARGET_ALIGN(PCACTCTXA, 4)
}

static void test_pack_PCACTCTXW(void)
{
    /* PCACTCTXW */
    TEST_TYPE_SIZE   (PCACTCTXW, 4)
    TEST_TYPE_ALIGN  (PCACTCTXW, 4)
    TEST_TARGET_SIZE (PCACTCTXW, 32)
    TEST_TARGET_ALIGN(PCACTCTXW, 4)
}

static void test_pack_PCACTCTX_SECTION_KEYED_DATA(void)
{
    /* PCACTCTX_SECTION_KEYED_DATA */
    TEST_TYPE_SIZE   (PCACTCTX_SECTION_KEYED_DATA, 4)
    TEST_TYPE_ALIGN  (PCACTCTX_SECTION_KEYED_DATA, 4)
    TEST_TARGET_SIZE (PCACTCTX_SECTION_KEYED_DATA, 64)
    TEST_TARGET_ALIGN(PCACTCTX_SECTION_KEYED_DATA, 4)
}

static void test_pack_PCACTCTX_SECTION_KEYED_DATA_2600(void)
{
    /* PCACTCTX_SECTION_KEYED_DATA_2600 */
    TEST_TYPE_SIZE   (PCACTCTX_SECTION_KEYED_DATA_2600, 4)
    TEST_TYPE_ALIGN  (PCACTCTX_SECTION_KEYED_DATA_2600, 4)
    TEST_TARGET_SIZE (PCACTCTX_SECTION_KEYED_DATA_2600, 40)
    TEST_TARGET_ALIGN(PCACTCTX_SECTION_KEYED_DATA_2600, 4)
}

static void test_pack_PCACTCTX_SECTION_KEYED_DATA_ASSEMBLY_METADATA(void)
{
    /* PCACTCTX_SECTION_KEYED_DATA_ASSEMBLY_METADATA */
    TEST_TYPE_SIZE   (PCACTCTX_SECTION_KEYED_DATA_ASSEMBLY_METADATA, 4)
    TEST_TYPE_ALIGN  (PCACTCTX_SECTION_KEYED_DATA_ASSEMBLY_METADATA, 4)
    TEST_TARGET_SIZE (PCACTCTX_SECTION_KEYED_DATA_ASSEMBLY_METADATA, 20)
    TEST_TARGET_ALIGN(PCACTCTX_SECTION_KEYED_DATA_ASSEMBLY_METADATA, 4)
}

static void test_pack_PCRITICAL_SECTION(void)
{
    /* PCRITICAL_SECTION */
    TEST_TYPE_SIZE   (PCRITICAL_SECTION, 4)
    TEST_TYPE_ALIGN  (PCRITICAL_SECTION, 4)
}

static void test_pack_PCRITICAL_SECTION_DEBUG(void)
{
    /* PCRITICAL_SECTION_DEBUG */
    TEST_TYPE_SIZE   (PCRITICAL_SECTION_DEBUG, 4)
    TEST_TYPE_ALIGN  (PCRITICAL_SECTION_DEBUG, 4)
}

static void test_pack_PFIBER_START_ROUTINE(void)
{
    /* PFIBER_START_ROUTINE */
    TEST_TYPE_SIZE   (PFIBER_START_ROUTINE, 4)
    TEST_TYPE_ALIGN  (PFIBER_START_ROUTINE, 4)
}

static void test_pack_POFSTRUCT(void)
{
    /* POFSTRUCT */
    TEST_TYPE_SIZE   (POFSTRUCT, 4)
    TEST_TYPE_ALIGN  (POFSTRUCT, 4)
    TEST_TARGET_SIZE (POFSTRUCT, 136)
    TEST_TARGET_ALIGN(POFSTRUCT, 2)
}

static void test_pack_PPROCESS_HEAP_ENTRY(void)
{
    /* PPROCESS_HEAP_ENTRY */
    TEST_TYPE_SIZE   (PPROCESS_HEAP_ENTRY, 4)
    TEST_TYPE_ALIGN  (PPROCESS_HEAP_ENTRY, 4)
}

static void test_pack_PPROCESS_INFORMATION(void)
{
    /* PPROCESS_INFORMATION */
    TEST_TYPE_SIZE   (PPROCESS_INFORMATION, 4)
    TEST_TYPE_ALIGN  (PPROCESS_INFORMATION, 4)
    TEST_TARGET_SIZE (PPROCESS_INFORMATION, 16)
    TEST_TARGET_ALIGN(PPROCESS_INFORMATION, 4)
}

static void test_pack_PQUERYACTCTXW_FUNC(void)
{
    /* PQUERYACTCTXW_FUNC */
    TEST_TYPE_SIZE   (PQUERYACTCTXW_FUNC, 4)
    TEST_TYPE_ALIGN  (PQUERYACTCTXW_FUNC, 4)
}

static void test_pack_PROCESS_HEAP_ENTRY(void)
{
    /* PROCESS_HEAP_ENTRY */
    TEST_FIELD_SIZE  (PROCESS_HEAP_ENTRY, lpData, 4)
    TEST_FIELD_ALIGN (PROCESS_HEAP_ENTRY, lpData, 4)
    TEST_FIELD_OFFSET(PROCESS_HEAP_ENTRY, lpData, 0)
    TEST_FIELD_SIZE  (PROCESS_HEAP_ENTRY, cbData, 4)
    TEST_FIELD_ALIGN (PROCESS_HEAP_ENTRY, cbData, 4)
    TEST_FIELD_OFFSET(PROCESS_HEAP_ENTRY, cbData, 4)
    TEST_FIELD_SIZE  (PROCESS_HEAP_ENTRY, cbOverhead, 1)
    TEST_FIELD_ALIGN (PROCESS_HEAP_ENTRY, cbOverhead, 1)
    TEST_FIELD_OFFSET(PROCESS_HEAP_ENTRY, cbOverhead, 8)
    TEST_FIELD_SIZE  (PROCESS_HEAP_ENTRY, iRegionIndex, 1)
    TEST_FIELD_ALIGN (PROCESS_HEAP_ENTRY, iRegionIndex, 1)
    TEST_FIELD_OFFSET(PROCESS_HEAP_ENTRY, iRegionIndex, 9)
    TEST_FIELD_SIZE  (PROCESS_HEAP_ENTRY, wFlags, 2)
    TEST_FIELD_ALIGN (PROCESS_HEAP_ENTRY, wFlags, 2)
    TEST_FIELD_OFFSET(PROCESS_HEAP_ENTRY, wFlags, 10)
}

static void test_pack_PROCESS_INFORMATION(void)
{
    /* PROCESS_INFORMATION */
    TEST_TYPE_SIZE   (PROCESS_INFORMATION, 16)
    TEST_TYPE_ALIGN  (PROCESS_INFORMATION, 4)
    TEST_FIELD_SIZE  (PROCESS_INFORMATION, hProcess, 4)
    TEST_FIELD_ALIGN (PROCESS_INFORMATION, hProcess, 4)
    TEST_FIELD_OFFSET(PROCESS_INFORMATION, hProcess, 0)
    TEST_FIELD_SIZE  (PROCESS_INFORMATION, hThread, 4)
    TEST_FIELD_ALIGN (PROCESS_INFORMATION, hThread, 4)
    TEST_FIELD_OFFSET(PROCESS_INFORMATION, hThread, 4)
    TEST_FIELD_SIZE  (PROCESS_INFORMATION, dwProcessId, 4)
    TEST_FIELD_ALIGN (PROCESS_INFORMATION, dwProcessId, 4)
    TEST_FIELD_OFFSET(PROCESS_INFORMATION, dwProcessId, 8)
    TEST_FIELD_SIZE  (PROCESS_INFORMATION, dwThreadId, 4)
    TEST_FIELD_ALIGN (PROCESS_INFORMATION, dwThreadId, 4)
    TEST_FIELD_OFFSET(PROCESS_INFORMATION, dwThreadId, 12)
}

static void test_pack_PSECURITY_ATTRIBUTES(void)
{
    /* PSECURITY_ATTRIBUTES */
    TEST_TYPE_SIZE   (PSECURITY_ATTRIBUTES, 4)
    TEST_TYPE_ALIGN  (PSECURITY_ATTRIBUTES, 4)
    TEST_TARGET_SIZE (PSECURITY_ATTRIBUTES, 12)
    TEST_TARGET_ALIGN(PSECURITY_ATTRIBUTES, 4)
}

static void test_pack_PSYSTEMTIME(void)
{
    /* PSYSTEMTIME */
    TEST_TYPE_SIZE   (PSYSTEMTIME, 4)
    TEST_TYPE_ALIGN  (PSYSTEMTIME, 4)
    TEST_TARGET_SIZE (PSYSTEMTIME, 16)
    TEST_TARGET_ALIGN(PSYSTEMTIME, 2)
}

static void test_pack_PTIMERAPCROUTINE(void)
{
    /* PTIMERAPCROUTINE */
    TEST_TYPE_SIZE   (PTIMERAPCROUTINE, 4)
    TEST_TYPE_ALIGN  (PTIMERAPCROUTINE, 4)
}

static void test_pack_PWIN32_FIND_DATAA(void)
{
    /* PWIN32_FIND_DATAA */
    TEST_TYPE_SIZE   (PWIN32_FIND_DATAA, 4)
    TEST_TYPE_ALIGN  (PWIN32_FIND_DATAA, 4)
    TEST_TARGET_SIZE (PWIN32_FIND_DATAA, 320)
    TEST_TARGET_ALIGN(PWIN32_FIND_DATAA, 4)
}

static void test_pack_PWIN32_FIND_DATAW(void)
{
    /* PWIN32_FIND_DATAW */
    TEST_TYPE_SIZE   (PWIN32_FIND_DATAW, 4)
    TEST_TYPE_ALIGN  (PWIN32_FIND_DATAW, 4)
    TEST_TARGET_SIZE (PWIN32_FIND_DATAW, 592)
    TEST_TARGET_ALIGN(PWIN32_FIND_DATAW, 4)
}

static void test_pack_RIP_INFO(void)
{
    /* RIP_INFO */
    TEST_TYPE_SIZE   (RIP_INFO, 8)
    TEST_TYPE_ALIGN  (RIP_INFO, 4)
    TEST_FIELD_SIZE  (RIP_INFO, dwError, 4)
    TEST_FIELD_ALIGN (RIP_INFO, dwError, 4)
    TEST_FIELD_OFFSET(RIP_INFO, dwError, 0)
    TEST_FIELD_SIZE  (RIP_INFO, dwType, 4)
    TEST_FIELD_ALIGN (RIP_INFO, dwType, 4)
    TEST_FIELD_OFFSET(RIP_INFO, dwType, 4)
}

static void test_pack_SECURITY_ATTRIBUTES(void)
{
    /* SECURITY_ATTRIBUTES */
    TEST_TYPE_SIZE   (SECURITY_ATTRIBUTES, 12)
    TEST_TYPE_ALIGN  (SECURITY_ATTRIBUTES, 4)
    TEST_FIELD_SIZE  (SECURITY_ATTRIBUTES, nLength, 4)
    TEST_FIELD_ALIGN (SECURITY_ATTRIBUTES, nLength, 4)
    TEST_FIELD_OFFSET(SECURITY_ATTRIBUTES, nLength, 0)
    TEST_FIELD_SIZE  (SECURITY_ATTRIBUTES, lpSecurityDescriptor, 4)
    TEST_FIELD_ALIGN (SECURITY_ATTRIBUTES, lpSecurityDescriptor, 4)
    TEST_FIELD_OFFSET(SECURITY_ATTRIBUTES, lpSecurityDescriptor, 4)
    TEST_FIELD_SIZE  (SECURITY_ATTRIBUTES, bInheritHandle, 4)
    TEST_FIELD_ALIGN (SECURITY_ATTRIBUTES, bInheritHandle, 4)
    TEST_FIELD_OFFSET(SECURITY_ATTRIBUTES, bInheritHandle, 8)
}

static void test_pack_STARTUPINFOA(void)
{
    /* STARTUPINFOA */
    TEST_TYPE_SIZE   (STARTUPINFOA, 68)
    TEST_TYPE_ALIGN  (STARTUPINFOA, 4)
    TEST_FIELD_SIZE  (STARTUPINFOA, cb, 4)
    TEST_FIELD_ALIGN (STARTUPINFOA, cb, 4)
    TEST_FIELD_OFFSET(STARTUPINFOA, cb, 0)
    TEST_FIELD_SIZE  (STARTUPINFOA, lpReserved, 4)
    TEST_FIELD_ALIGN (STARTUPINFOA, lpReserved, 4)
    TEST_FIELD_OFFSET(STARTUPINFOA, lpReserved, 4)
    TEST_FIELD_SIZE  (STARTUPINFOA, lpDesktop, 4)
    TEST_FIELD_ALIGN (STARTUPINFOA, lpDesktop, 4)
    TEST_FIELD_OFFSET(STARTUPINFOA, lpDesktop, 8)
    TEST_FIELD_SIZE  (STARTUPINFOA, lpTitle, 4)
    TEST_FIELD_ALIGN (STARTUPINFOA, lpTitle, 4)
    TEST_FIELD_OFFSET(STARTUPINFOA, lpTitle, 12)
    TEST_FIELD_SIZE  (STARTUPINFOA, dwX, 4)
    TEST_FIELD_ALIGN (STARTUPINFOA, dwX, 4)
    TEST_FIELD_OFFSET(STARTUPINFOA, dwX, 16)
    TEST_FIELD_SIZE  (STARTUPINFOA, dwY, 4)
    TEST_FIELD_ALIGN (STARTUPINFOA, dwY, 4)
    TEST_FIELD_OFFSET(STARTUPINFOA, dwY, 20)
    TEST_FIELD_SIZE  (STARTUPINFOA, dwXSize, 4)
    TEST_FIELD_ALIGN (STARTUPINFOA, dwXSize, 4)
    TEST_FIELD_OFFSET(STARTUPINFOA, dwXSize, 24)
    TEST_FIELD_SIZE  (STARTUPINFOA, dwYSize, 4)
    TEST_FIELD_ALIGN (STARTUPINFOA, dwYSize, 4)
    TEST_FIELD_OFFSET(STARTUPINFOA, dwYSize, 28)
    TEST_FIELD_SIZE  (STARTUPINFOA, dwXCountChars, 4)
    TEST_FIELD_ALIGN (STARTUPINFOA, dwXCountChars, 4)
    TEST_FIELD_OFFSET(STARTUPINFOA, dwXCountChars, 32)
    TEST_FIELD_SIZE  (STARTUPINFOA, dwYCountChars, 4)
    TEST_FIELD_ALIGN (STARTUPINFOA, dwYCountChars, 4)
    TEST_FIELD_OFFSET(STARTUPINFOA, dwYCountChars, 36)
    TEST_FIELD_SIZE  (STARTUPINFOA, dwFillAttribute, 4)
    TEST_FIELD_ALIGN (STARTUPINFOA, dwFillAttribute, 4)
    TEST_FIELD_OFFSET(STARTUPINFOA, dwFillAttribute, 40)
    TEST_FIELD_SIZE  (STARTUPINFOA, dwFlags, 4)
    TEST_FIELD_ALIGN (STARTUPINFOA, dwFlags, 4)
    TEST_FIELD_OFFSET(STARTUPINFOA, dwFlags, 44)
    TEST_FIELD_SIZE  (STARTUPINFOA, wShowWindow, 2)
    TEST_FIELD_ALIGN (STARTUPINFOA, wShowWindow, 2)
    TEST_FIELD_OFFSET(STARTUPINFOA, wShowWindow, 48)
    TEST_FIELD_SIZE  (STARTUPINFOA, cbReserved2, 2)
    TEST_FIELD_ALIGN (STARTUPINFOA, cbReserved2, 2)
    TEST_FIELD_OFFSET(STARTUPINFOA, cbReserved2, 50)
    TEST_FIELD_SIZE  (STARTUPINFOA, lpReserved2, 4)
    TEST_FIELD_ALIGN (STARTUPINFOA, lpReserved2, 4)
    TEST_FIELD_OFFSET(STARTUPINFOA, lpReserved2, 52)
    TEST_FIELD_SIZE  (STARTUPINFOA, hStdInput, 4)
    TEST_FIELD_ALIGN (STARTUPINFOA, hStdInput, 4)
    TEST_FIELD_OFFSET(STARTUPINFOA, hStdInput, 56)
    TEST_FIELD_SIZE  (STARTUPINFOA, hStdOutput, 4)
    TEST_FIELD_ALIGN (STARTUPINFOA, hStdOutput, 4)
    TEST_FIELD_OFFSET(STARTUPINFOA, hStdOutput, 60)
    TEST_FIELD_SIZE  (STARTUPINFOA, hStdError, 4)
    TEST_FIELD_ALIGN (STARTUPINFOA, hStdError, 4)
    TEST_FIELD_OFFSET(STARTUPINFOA, hStdError, 64)
}

static void test_pack_STARTUPINFOW(void)
{
    /* STARTUPINFOW */
    TEST_TYPE_SIZE   (STARTUPINFOW, 68)
    TEST_TYPE_ALIGN  (STARTUPINFOW, 4)
    TEST_FIELD_SIZE  (STARTUPINFOW, cb, 4)
    TEST_FIELD_ALIGN (STARTUPINFOW, cb, 4)
    TEST_FIELD_OFFSET(STARTUPINFOW, cb, 0)
    TEST_FIELD_SIZE  (STARTUPINFOW, lpReserved, 4)
    TEST_FIELD_ALIGN (STARTUPINFOW, lpReserved, 4)
    TEST_FIELD_OFFSET(STARTUPINFOW, lpReserved, 4)
    TEST_FIELD_SIZE  (STARTUPINFOW, lpDesktop, 4)
    TEST_FIELD_ALIGN (STARTUPINFOW, lpDesktop, 4)
    TEST_FIELD_OFFSET(STARTUPINFOW, lpDesktop, 8)
    TEST_FIELD_SIZE  (STARTUPINFOW, lpTitle, 4)
    TEST_FIELD_ALIGN (STARTUPINFOW, lpTitle, 4)
    TEST_FIELD_OFFSET(STARTUPINFOW, lpTitle, 12)
    TEST_FIELD_SIZE  (STARTUPINFOW, dwX, 4)
    TEST_FIELD_ALIGN (STARTUPINFOW, dwX, 4)
    TEST_FIELD_OFFSET(STARTUPINFOW, dwX, 16)
    TEST_FIELD_SIZE  (STARTUPINFOW, dwY, 4)
    TEST_FIELD_ALIGN (STARTUPINFOW, dwY, 4)
    TEST_FIELD_OFFSET(STARTUPINFOW, dwY, 20)
    TEST_FIELD_SIZE  (STARTUPINFOW, dwXSize, 4)
    TEST_FIELD_ALIGN (STARTUPINFOW, dwXSize, 4)
    TEST_FIELD_OFFSET(STARTUPINFOW, dwXSize, 24)
    TEST_FIELD_SIZE  (STARTUPINFOW, dwYSize, 4)
    TEST_FIELD_ALIGN (STARTUPINFOW, dwYSize, 4)
    TEST_FIELD_OFFSET(STARTUPINFOW, dwYSize, 28)
    TEST_FIELD_SIZE  (STARTUPINFOW, dwXCountChars, 4)
    TEST_FIELD_ALIGN (STARTUPINFOW, dwXCountChars, 4)
    TEST_FIELD_OFFSET(STARTUPINFOW, dwXCountChars, 32)
    TEST_FIELD_SIZE  (STARTUPINFOW, dwYCountChars, 4)
    TEST_FIELD_ALIGN (STARTUPINFOW, dwYCountChars, 4)
    TEST_FIELD_OFFSET(STARTUPINFOW, dwYCountChars, 36)
    TEST_FIELD_SIZE  (STARTUPINFOW, dwFillAttribute, 4)
    TEST_FIELD_ALIGN (STARTUPINFOW, dwFillAttribute, 4)
    TEST_FIELD_OFFSET(STARTUPINFOW, dwFillAttribute, 40)
    TEST_FIELD_SIZE  (STARTUPINFOW, dwFlags, 4)
    TEST_FIELD_ALIGN (STARTUPINFOW, dwFlags, 4)
    TEST_FIELD_OFFSET(STARTUPINFOW, dwFlags, 44)
    TEST_FIELD_SIZE  (STARTUPINFOW, wShowWindow, 2)
    TEST_FIELD_ALIGN (STARTUPINFOW, wShowWindow, 2)
    TEST_FIELD_OFFSET(STARTUPINFOW, wShowWindow, 48)
    TEST_FIELD_SIZE  (STARTUPINFOW, cbReserved2, 2)
    TEST_FIELD_ALIGN (STARTUPINFOW, cbReserved2, 2)
    TEST_FIELD_OFFSET(STARTUPINFOW, cbReserved2, 50)
    TEST_FIELD_SIZE  (STARTUPINFOW, lpReserved2, 4)
    TEST_FIELD_ALIGN (STARTUPINFOW, lpReserved2, 4)
    TEST_FIELD_OFFSET(STARTUPINFOW, lpReserved2, 52)
    TEST_FIELD_SIZE  (STARTUPINFOW, hStdInput, 4)
    TEST_FIELD_ALIGN (STARTUPINFOW, hStdInput, 4)
    TEST_FIELD_OFFSET(STARTUPINFOW, hStdInput, 56)
    TEST_FIELD_SIZE  (STARTUPINFOW, hStdOutput, 4)
    TEST_FIELD_ALIGN (STARTUPINFOW, hStdOutput, 4)
    TEST_FIELD_OFFSET(STARTUPINFOW, hStdOutput, 60)
    TEST_FIELD_SIZE  (STARTUPINFOW, hStdError, 4)
    TEST_FIELD_ALIGN (STARTUPINFOW, hStdError, 4)
    TEST_FIELD_OFFSET(STARTUPINFOW, hStdError, 64)
}

static void test_pack_SYSTEMTIME(void)
{
    /* SYSTEMTIME */
    TEST_TYPE_SIZE   (SYSTEMTIME, 16)
    TEST_TYPE_ALIGN  (SYSTEMTIME, 2)
    TEST_FIELD_SIZE  (SYSTEMTIME, wYear, 2)
    TEST_FIELD_ALIGN (SYSTEMTIME, wYear, 2)
    TEST_FIELD_OFFSET(SYSTEMTIME, wYear, 0)
    TEST_FIELD_SIZE  (SYSTEMTIME, wMonth, 2)
    TEST_FIELD_ALIGN (SYSTEMTIME, wMonth, 2)
    TEST_FIELD_OFFSET(SYSTEMTIME, wMonth, 2)
    TEST_FIELD_SIZE  (SYSTEMTIME, wDayOfWeek, 2)
    TEST_FIELD_ALIGN (SYSTEMTIME, wDayOfWeek, 2)
    TEST_FIELD_OFFSET(SYSTEMTIME, wDayOfWeek, 4)
    TEST_FIELD_SIZE  (SYSTEMTIME, wDay, 2)
    TEST_FIELD_ALIGN (SYSTEMTIME, wDay, 2)
    TEST_FIELD_OFFSET(SYSTEMTIME, wDay, 6)
    TEST_FIELD_SIZE  (SYSTEMTIME, wHour, 2)
    TEST_FIELD_ALIGN (SYSTEMTIME, wHour, 2)
    TEST_FIELD_OFFSET(SYSTEMTIME, wHour, 8)
    TEST_FIELD_SIZE  (SYSTEMTIME, wMinute, 2)
    TEST_FIELD_ALIGN (SYSTEMTIME, wMinute, 2)
    TEST_FIELD_OFFSET(SYSTEMTIME, wMinute, 10)
    TEST_FIELD_SIZE  (SYSTEMTIME, wSecond, 2)
    TEST_FIELD_ALIGN (SYSTEMTIME, wSecond, 2)
    TEST_FIELD_OFFSET(SYSTEMTIME, wSecond, 12)
    TEST_FIELD_SIZE  (SYSTEMTIME, wMilliseconds, 2)
    TEST_FIELD_ALIGN (SYSTEMTIME, wMilliseconds, 2)
    TEST_FIELD_OFFSET(SYSTEMTIME, wMilliseconds, 14)
}

static void test_pack_SYSTEM_INFO(void)
{
    /* SYSTEM_INFO */
}

static void test_pack_SYSTEM_POWER_STATUS(void)
{
    /* SYSTEM_POWER_STATUS */
    TEST_TYPE_SIZE   (SYSTEM_POWER_STATUS, 12)
    TEST_TYPE_ALIGN  (SYSTEM_POWER_STATUS, 4)
    TEST_FIELD_SIZE  (SYSTEM_POWER_STATUS, ACLineStatus, 1)
    TEST_FIELD_ALIGN (SYSTEM_POWER_STATUS, ACLineStatus, 1)
    TEST_FIELD_OFFSET(SYSTEM_POWER_STATUS, ACLineStatus, 0)
    TEST_FIELD_SIZE  (SYSTEM_POWER_STATUS, BatteryFlag, 1)
    TEST_FIELD_ALIGN (SYSTEM_POWER_STATUS, BatteryFlag, 1)
    TEST_FIELD_OFFSET(SYSTEM_POWER_STATUS, BatteryFlag, 1)
    TEST_FIELD_SIZE  (SYSTEM_POWER_STATUS, BatteryLifePercent, 1)
    TEST_FIELD_ALIGN (SYSTEM_POWER_STATUS, BatteryLifePercent, 1)
    TEST_FIELD_OFFSET(SYSTEM_POWER_STATUS, BatteryLifePercent, 2)
    TEST_FIELD_SIZE  (SYSTEM_POWER_STATUS, SystemStatusFlag, 1)
    TEST_FIELD_ALIGN (SYSTEM_POWER_STATUS, SystemStatusFlag, 1)
    TEST_FIELD_OFFSET(SYSTEM_POWER_STATUS, SystemStatusFlag, 3)
    TEST_FIELD_SIZE  (SYSTEM_POWER_STATUS, BatteryLifeTime, 4)
    TEST_FIELD_ALIGN (SYSTEM_POWER_STATUS, BatteryLifeTime, 4)
    TEST_FIELD_OFFSET(SYSTEM_POWER_STATUS, BatteryLifeTime, 4)
    TEST_FIELD_SIZE  (SYSTEM_POWER_STATUS, BatteryFullLifeTime, 4)
    TEST_FIELD_ALIGN (SYSTEM_POWER_STATUS, BatteryFullLifeTime, 4)
    TEST_FIELD_OFFSET(SYSTEM_POWER_STATUS, BatteryFullLifeTime, 8)
}

static void test_pack_UNLOAD_DLL_DEBUG_INFO(void)
{
    /* UNLOAD_DLL_DEBUG_INFO */
    TEST_TYPE_SIZE   (UNLOAD_DLL_DEBUG_INFO, 4)
    TEST_TYPE_ALIGN  (UNLOAD_DLL_DEBUG_INFO, 4)
    TEST_FIELD_SIZE  (UNLOAD_DLL_DEBUG_INFO, lpBaseOfDll, 4)
    TEST_FIELD_ALIGN (UNLOAD_DLL_DEBUG_INFO, lpBaseOfDll, 4)
    TEST_FIELD_OFFSET(UNLOAD_DLL_DEBUG_INFO, lpBaseOfDll, 0)
}

static void test_pack_WAITORTIMERCALLBACK(void)
{
    /* WAITORTIMERCALLBACK */
    TEST_TYPE_SIZE   (WAITORTIMERCALLBACK, 4)
    TEST_TYPE_ALIGN  (WAITORTIMERCALLBACK, 4)
}

static void test_pack_WIN32_FILE_ATTRIBUTE_DATA(void)
{
    /* WIN32_FILE_ATTRIBUTE_DATA */
    TEST_TYPE_SIZE   (WIN32_FILE_ATTRIBUTE_DATA, 36)
    TEST_TYPE_ALIGN  (WIN32_FILE_ATTRIBUTE_DATA, 4)
    TEST_FIELD_SIZE  (WIN32_FILE_ATTRIBUTE_DATA, dwFileAttributes, 4)
    TEST_FIELD_ALIGN (WIN32_FILE_ATTRIBUTE_DATA, dwFileAttributes, 4)
    TEST_FIELD_OFFSET(WIN32_FILE_ATTRIBUTE_DATA, dwFileAttributes, 0)
    TEST_FIELD_SIZE  (WIN32_FILE_ATTRIBUTE_DATA, ftCreationTime, 8)
    TEST_FIELD_ALIGN (WIN32_FILE_ATTRIBUTE_DATA, ftCreationTime, 4)
    TEST_FIELD_OFFSET(WIN32_FILE_ATTRIBUTE_DATA, ftCreationTime, 4)
    TEST_FIELD_SIZE  (WIN32_FILE_ATTRIBUTE_DATA, ftLastAccessTime, 8)
    TEST_FIELD_ALIGN (WIN32_FILE_ATTRIBUTE_DATA, ftLastAccessTime, 4)
    TEST_FIELD_OFFSET(WIN32_FILE_ATTRIBUTE_DATA, ftLastAccessTime, 12)
    TEST_FIELD_SIZE  (WIN32_FILE_ATTRIBUTE_DATA, ftLastWriteTime, 8)
    TEST_FIELD_ALIGN (WIN32_FILE_ATTRIBUTE_DATA, ftLastWriteTime, 4)
    TEST_FIELD_OFFSET(WIN32_FILE_ATTRIBUTE_DATA, ftLastWriteTime, 20)
    TEST_FIELD_SIZE  (WIN32_FILE_ATTRIBUTE_DATA, nFileSizeHigh, 4)
    TEST_FIELD_ALIGN (WIN32_FILE_ATTRIBUTE_DATA, nFileSizeHigh, 4)
    TEST_FIELD_OFFSET(WIN32_FILE_ATTRIBUTE_DATA, nFileSizeHigh, 28)
    TEST_FIELD_SIZE  (WIN32_FILE_ATTRIBUTE_DATA, nFileSizeLow, 4)
    TEST_FIELD_ALIGN (WIN32_FILE_ATTRIBUTE_DATA, nFileSizeLow, 4)
    TEST_FIELD_OFFSET(WIN32_FILE_ATTRIBUTE_DATA, nFileSizeLow, 32)
}

static void test_pack_WIN32_FIND_DATAA(void)
{
    /* WIN32_FIND_DATAA */
    TEST_TYPE_SIZE   (WIN32_FIND_DATAA, 320)
    TEST_TYPE_ALIGN  (WIN32_FIND_DATAA, 4)
    TEST_FIELD_SIZE  (WIN32_FIND_DATAA, dwFileAttributes, 4)
    TEST_FIELD_ALIGN (WIN32_FIND_DATAA, dwFileAttributes, 4)
    TEST_FIELD_OFFSET(WIN32_FIND_DATAA, dwFileAttributes, 0)
    TEST_FIELD_SIZE  (WIN32_FIND_DATAA, ftCreationTime, 8)
    TEST_FIELD_ALIGN (WIN32_FIND_DATAA, ftCreationTime, 4)
    TEST_FIELD_OFFSET(WIN32_FIND_DATAA, ftCreationTime, 4)
    TEST_FIELD_SIZE  (WIN32_FIND_DATAA, ftLastAccessTime, 8)
    TEST_FIELD_ALIGN (WIN32_FIND_DATAA, ftLastAccessTime, 4)
    TEST_FIELD_OFFSET(WIN32_FIND_DATAA, ftLastAccessTime, 12)
    TEST_FIELD_SIZE  (WIN32_FIND_DATAA, ftLastWriteTime, 8)
    TEST_FIELD_ALIGN (WIN32_FIND_DATAA, ftLastWriteTime, 4)
    TEST_FIELD_OFFSET(WIN32_FIND_DATAA, ftLastWriteTime, 20)
    TEST_FIELD_SIZE  (WIN32_FIND_DATAA, nFileSizeHigh, 4)
    TEST_FIELD_ALIGN (WIN32_FIND_DATAA, nFileSizeHigh, 4)
    TEST_FIELD_OFFSET(WIN32_FIND_DATAA, nFileSizeHigh, 28)
    TEST_FIELD_SIZE  (WIN32_FIND_DATAA, nFileSizeLow, 4)
    TEST_FIELD_ALIGN (WIN32_FIND_DATAA, nFileSizeLow, 4)
    TEST_FIELD_OFFSET(WIN32_FIND_DATAA, nFileSizeLow, 32)
    TEST_FIELD_SIZE  (WIN32_FIND_DATAA, dwReserved0, 4)
    TEST_FIELD_ALIGN (WIN32_FIND_DATAA, dwReserved0, 4)
    TEST_FIELD_OFFSET(WIN32_FIND_DATAA, dwReserved0, 36)
    TEST_FIELD_SIZE  (WIN32_FIND_DATAA, dwReserved1, 4)
    TEST_FIELD_ALIGN (WIN32_FIND_DATAA, dwReserved1, 4)
    TEST_FIELD_OFFSET(WIN32_FIND_DATAA, dwReserved1, 40)
    TEST_FIELD_SIZE  (WIN32_FIND_DATAA, cFileName, 260)
    TEST_FIELD_ALIGN (WIN32_FIND_DATAA, cFileName, 1)
    TEST_FIELD_OFFSET(WIN32_FIND_DATAA, cFileName, 44)
    TEST_FIELD_SIZE  (WIN32_FIND_DATAA, cAlternateFileName, 14)
    TEST_FIELD_ALIGN (WIN32_FIND_DATAA, cAlternateFileName, 1)
    TEST_FIELD_OFFSET(WIN32_FIND_DATAA, cAlternateFileName, 304)
}

static void test_pack_WIN32_FIND_DATAW(void)
{
    /* WIN32_FIND_DATAW */
    TEST_TYPE_SIZE   (WIN32_FIND_DATAW, 592)
    TEST_TYPE_ALIGN  (WIN32_FIND_DATAW, 4)
    TEST_FIELD_SIZE  (WIN32_FIND_DATAW, dwFileAttributes, 4)
    TEST_FIELD_ALIGN (WIN32_FIND_DATAW, dwFileAttributes, 4)
    TEST_FIELD_OFFSET(WIN32_FIND_DATAW, dwFileAttributes, 0)
    TEST_FIELD_SIZE  (WIN32_FIND_DATAW, ftCreationTime, 8)
    TEST_FIELD_ALIGN (WIN32_FIND_DATAW, ftCreationTime, 4)
    TEST_FIELD_OFFSET(WIN32_FIND_DATAW, ftCreationTime, 4)
    TEST_FIELD_SIZE  (WIN32_FIND_DATAW, ftLastAccessTime, 8)
    TEST_FIELD_ALIGN (WIN32_FIND_DATAW, ftLastAccessTime, 4)
    TEST_FIELD_OFFSET(WIN32_FIND_DATAW, ftLastAccessTime, 12)
    TEST_FIELD_SIZE  (WIN32_FIND_DATAW, ftLastWriteTime, 8)
    TEST_FIELD_ALIGN (WIN32_FIND_DATAW, ftLastWriteTime, 4)
    TEST_FIELD_OFFSET(WIN32_FIND_DATAW, ftLastWriteTime, 20)
    TEST_FIELD_SIZE  (WIN32_FIND_DATAW, nFileSizeHigh, 4)
    TEST_FIELD_ALIGN (WIN32_FIND_DATAW, nFileSizeHigh, 4)
    TEST_FIELD_OFFSET(WIN32_FIND_DATAW, nFileSizeHigh, 28)
    TEST_FIELD_SIZE  (WIN32_FIND_DATAW, nFileSizeLow, 4)
    TEST_FIELD_ALIGN (WIN32_FIND_DATAW, nFileSizeLow, 4)
    TEST_FIELD_OFFSET(WIN32_FIND_DATAW, nFileSizeLow, 32)
    TEST_FIELD_SIZE  (WIN32_FIND_DATAW, dwReserved0, 4)
    TEST_FIELD_ALIGN (WIN32_FIND_DATAW, dwReserved0, 4)
    TEST_FIELD_OFFSET(WIN32_FIND_DATAW, dwReserved0, 36)
    TEST_FIELD_SIZE  (WIN32_FIND_DATAW, dwReserved1, 4)
    TEST_FIELD_ALIGN (WIN32_FIND_DATAW, dwReserved1, 4)
    TEST_FIELD_OFFSET(WIN32_FIND_DATAW, dwReserved1, 40)
    TEST_FIELD_SIZE  (WIN32_FIND_DATAW, cFileName, 520)
    TEST_FIELD_ALIGN (WIN32_FIND_DATAW, cFileName, 2)
    TEST_FIELD_OFFSET(WIN32_FIND_DATAW, cFileName, 44)
    TEST_FIELD_SIZE  (WIN32_FIND_DATAW, cAlternateFileName, 28)
    TEST_FIELD_ALIGN (WIN32_FIND_DATAW, cAlternateFileName, 2)
    TEST_FIELD_OFFSET(WIN32_FIND_DATAW, cAlternateFileName, 564)
}

static void test_pack_WIN32_STREAM_ID(void)
{
    /* WIN32_STREAM_ID (pack 8) */
    TEST_TYPE_SIZE   (WIN32_STREAM_ID, 24)
    TEST_TYPE_ALIGN  (WIN32_STREAM_ID, 8)
    TEST_FIELD_SIZE  (WIN32_STREAM_ID, dwStreamId, 4)
    TEST_FIELD_ALIGN (WIN32_STREAM_ID, dwStreamId, 4)
    TEST_FIELD_OFFSET(WIN32_STREAM_ID, dwStreamId, 0)
    TEST_FIELD_SIZE  (WIN32_STREAM_ID, dwStreamAttributes, 4)
    TEST_FIELD_ALIGN (WIN32_STREAM_ID, dwStreamAttributes, 4)
    TEST_FIELD_OFFSET(WIN32_STREAM_ID, dwStreamAttributes, 4)
    TEST_FIELD_SIZE  (WIN32_STREAM_ID, Size, 8)
    TEST_FIELD_ALIGN (WIN32_STREAM_ID, Size, 8)
    TEST_FIELD_OFFSET(WIN32_STREAM_ID, Size, 8)
    TEST_FIELD_SIZE  (WIN32_STREAM_ID, dwStreamNameSize, 4)
    TEST_FIELD_ALIGN (WIN32_STREAM_ID, dwStreamNameSize, 4)
    TEST_FIELD_OFFSET(WIN32_STREAM_ID, dwStreamNameSize, 16)
    TEST_FIELD_SIZE  (WIN32_STREAM_ID, cStreamName, 2)
    TEST_FIELD_ALIGN (WIN32_STREAM_ID, cStreamName, 2)
    TEST_FIELD_OFFSET(WIN32_STREAM_ID, cStreamName, 20)
}

static void test_pack_DYNAMIC_TIME_ZONE_INFORMATION(void)
{
    /* DYNAMIC_TIME_ZONE_INFORMATION */
    TEST_TYPE_SIZE   (DYNAMIC_TIME_ZONE_INFORMATION, 432)
    TEST_TYPE_ALIGN  (DYNAMIC_TIME_ZONE_INFORMATION, 4)
    TEST_FIELD_SIZE  (DYNAMIC_TIME_ZONE_INFORMATION, Bias, 4)
    TEST_FIELD_ALIGN (DYNAMIC_TIME_ZONE_INFORMATION, Bias, 4)
    TEST_FIELD_OFFSET(DYNAMIC_TIME_ZONE_INFORMATION, Bias, 0)
    TEST_FIELD_SIZE  (DYNAMIC_TIME_ZONE_INFORMATION, StandardName, 64)
    TEST_FIELD_ALIGN (DYNAMIC_TIME_ZONE_INFORMATION, StandardName, 2)
    TEST_FIELD_OFFSET(DYNAMIC_TIME_ZONE_INFORMATION, StandardName, 4)
    TEST_FIELD_SIZE  (DYNAMIC_TIME_ZONE_INFORMATION, StandardDate, 16)
    TEST_FIELD_ALIGN (DYNAMIC_TIME_ZONE_INFORMATION, StandardDate, 2)
    TEST_FIELD_OFFSET(DYNAMIC_TIME_ZONE_INFORMATION, StandardDate, 68)
    TEST_FIELD_SIZE  (DYNAMIC_TIME_ZONE_INFORMATION, StandardBias, 4)
    TEST_FIELD_ALIGN (DYNAMIC_TIME_ZONE_INFORMATION, StandardBias, 4)
    TEST_FIELD_OFFSET(DYNAMIC_TIME_ZONE_INFORMATION, StandardBias, 84)
    TEST_FIELD_SIZE  (DYNAMIC_TIME_ZONE_INFORMATION, DaylightName, 64)
    TEST_FIELD_ALIGN (DYNAMIC_TIME_ZONE_INFORMATION, DaylightName, 2)
    TEST_FIELD_OFFSET(DYNAMIC_TIME_ZONE_INFORMATION, DaylightName, 88)
    TEST_FIELD_SIZE  (DYNAMIC_TIME_ZONE_INFORMATION, DaylightDate, 16)
    TEST_FIELD_ALIGN (DYNAMIC_TIME_ZONE_INFORMATION, DaylightDate, 2)
    TEST_FIELD_OFFSET(DYNAMIC_TIME_ZONE_INFORMATION, DaylightDate, 152)
    TEST_FIELD_SIZE  (DYNAMIC_TIME_ZONE_INFORMATION, DaylightBias, 4)
    TEST_FIELD_ALIGN (DYNAMIC_TIME_ZONE_INFORMATION, DaylightBias, 4)
    TEST_FIELD_OFFSET(DYNAMIC_TIME_ZONE_INFORMATION, DaylightBias, 168)
    TEST_FIELD_SIZE  (DYNAMIC_TIME_ZONE_INFORMATION, TimeZoneKeyName, 256)
    TEST_FIELD_ALIGN (DYNAMIC_TIME_ZONE_INFORMATION, TimeZoneKeyName, 2)
    TEST_FIELD_OFFSET(DYNAMIC_TIME_ZONE_INFORMATION, TimeZoneKeyName, 172)
    TEST_FIELD_SIZE  (DYNAMIC_TIME_ZONE_INFORMATION, DynamicDaylightTimeDisabled, 1)
    TEST_FIELD_ALIGN (DYNAMIC_TIME_ZONE_INFORMATION, DynamicDaylightTimeDisabled, 1)
    TEST_FIELD_OFFSET(DYNAMIC_TIME_ZONE_INFORMATION, DynamicDaylightTimeDisabled, 428)
}

static void test_pack_LPTIME_ZONE_INFORMATION(void)
{
    /* LPTIME_ZONE_INFORMATION */
    TEST_TYPE_SIZE   (LPTIME_ZONE_INFORMATION, 4)
    TEST_TYPE_ALIGN  (LPTIME_ZONE_INFORMATION, 4)
    TEST_TARGET_SIZE (LPTIME_ZONE_INFORMATION, 172)
    TEST_TARGET_ALIGN(LPTIME_ZONE_INFORMATION, 4)
}

static void test_pack_PDYNAMIC_TIME_ZONE_INFORMATION(void)
{
    /* PDYNAMIC_TIME_ZONE_INFORMATION */
    TEST_TYPE_SIZE   (PDYNAMIC_TIME_ZONE_INFORMATION, 4)
    TEST_TYPE_ALIGN  (PDYNAMIC_TIME_ZONE_INFORMATION, 4)
    TEST_TARGET_SIZE (PDYNAMIC_TIME_ZONE_INFORMATION, 432)
    TEST_TARGET_ALIGN(PDYNAMIC_TIME_ZONE_INFORMATION, 4)
}

static void test_pack_PTIME_ZONE_INFORMATION(void)
{
    /* PTIME_ZONE_INFORMATION */
    TEST_TYPE_SIZE   (PTIME_ZONE_INFORMATION, 4)
    TEST_TYPE_ALIGN  (PTIME_ZONE_INFORMATION, 4)
    TEST_TARGET_SIZE (PTIME_ZONE_INFORMATION, 172)
    TEST_TARGET_ALIGN(PTIME_ZONE_INFORMATION, 4)
}

static void test_pack_TIME_ZONE_INFORMATION(void)
{
    /* TIME_ZONE_INFORMATION */
    TEST_TYPE_SIZE   (TIME_ZONE_INFORMATION, 172)
    TEST_TYPE_ALIGN  (TIME_ZONE_INFORMATION, 4)
    TEST_FIELD_SIZE  (TIME_ZONE_INFORMATION, Bias, 4)
    TEST_FIELD_ALIGN (TIME_ZONE_INFORMATION, Bias, 4)
    TEST_FIELD_OFFSET(TIME_ZONE_INFORMATION, Bias, 0)
    TEST_FIELD_SIZE  (TIME_ZONE_INFORMATION, StandardName, 64)
    TEST_FIELD_ALIGN (TIME_ZONE_INFORMATION, StandardName, 2)
    TEST_FIELD_OFFSET(TIME_ZONE_INFORMATION, StandardName, 4)
    TEST_FIELD_SIZE  (TIME_ZONE_INFORMATION, StandardDate, 16)
    TEST_FIELD_ALIGN (TIME_ZONE_INFORMATION, StandardDate, 2)
    TEST_FIELD_OFFSET(TIME_ZONE_INFORMATION, StandardDate, 68)
    TEST_FIELD_SIZE  (TIME_ZONE_INFORMATION, StandardBias, 4)
    TEST_FIELD_ALIGN (TIME_ZONE_INFORMATION, StandardBias, 4)
    TEST_FIELD_OFFSET(TIME_ZONE_INFORMATION, StandardBias, 84)
    TEST_FIELD_SIZE  (TIME_ZONE_INFORMATION, DaylightName, 64)
    TEST_FIELD_ALIGN (TIME_ZONE_INFORMATION, DaylightName, 2)
    TEST_FIELD_OFFSET(TIME_ZONE_INFORMATION, DaylightName, 88)
    TEST_FIELD_SIZE  (TIME_ZONE_INFORMATION, DaylightDate, 16)
    TEST_FIELD_ALIGN (TIME_ZONE_INFORMATION, DaylightDate, 2)
    TEST_FIELD_OFFSET(TIME_ZONE_INFORMATION, DaylightDate, 152)
    TEST_FIELD_SIZE  (TIME_ZONE_INFORMATION, DaylightBias, 4)
    TEST_FIELD_ALIGN (TIME_ZONE_INFORMATION, DaylightBias, 4)
    TEST_FIELD_OFFSET(TIME_ZONE_INFORMATION, DaylightBias, 168)
}

#endif /* _WIN64 */

static void test_pack(void)
{
    test_pack_ACTCTXA();
    test_pack_ACTCTXW();
    test_pack_ACTCTX_SECTION_KEYED_DATA();
    test_pack_ACTCTX_SECTION_KEYED_DATA_2600();
    test_pack_ACTCTX_SECTION_KEYED_DATA_ASSEMBLY_METADATA();
    test_pack_ACTIVATION_CONTEXT_BASIC_INFORMATION();
    test_pack_BY_HANDLE_FILE_INFORMATION();
    test_pack_COMMCONFIG();
    test_pack_COMMPROP();
    test_pack_COMMTIMEOUTS();
    test_pack_COMSTAT();
    test_pack_CREATE_PROCESS_DEBUG_INFO();
    test_pack_CREATE_THREAD_DEBUG_INFO();
    test_pack_CRITICAL_SECTION();
    test_pack_CRITICAL_SECTION_DEBUG();
    test_pack_DCB();
    test_pack_DEBUG_EVENT();
    test_pack_DYNAMIC_TIME_ZONE_INFORMATION();
    test_pack_ENUMRESLANGPROCA();
    test_pack_ENUMRESLANGPROCW();
    test_pack_ENUMRESNAMEPROCA();
    test_pack_ENUMRESNAMEPROCW();
    test_pack_ENUMRESTYPEPROCA();
    test_pack_ENUMRESTYPEPROCW();
    test_pack_EXCEPTION_DEBUG_INFO();
    test_pack_EXIT_PROCESS_DEBUG_INFO();
    test_pack_EXIT_THREAD_DEBUG_INFO();
    test_pack_HW_PROFILE_INFOA();
    test_pack_HW_PROFILE_INFOW();
    test_pack_LOAD_DLL_DEBUG_INFO();
    test_pack_LPBY_HANDLE_FILE_INFORMATION();
    test_pack_LPCOMMCONFIG();
    test_pack_LPCOMMPROP();
    test_pack_LPCOMMTIMEOUTS();
    test_pack_LPCOMSTAT();
    test_pack_LPCRITICAL_SECTION();
    test_pack_LPCRITICAL_SECTION_DEBUG();
    test_pack_LPDCB();
    test_pack_LPDEBUG_EVENT();
    test_pack_LPEXCEPTION_POINTERS();
    test_pack_LPEXCEPTION_RECORD();
    test_pack_LPFIBER_START_ROUTINE();
    test_pack_LPHW_PROFILE_INFOA();
    test_pack_LPHW_PROFILE_INFOW();
    test_pack_LPLONG();
    test_pack_LPMEMORYSTATUS();
    test_pack_LPMEMORYSTATUSEX();
    test_pack_LPOFSTRUCT();
    test_pack_LPOSVERSIONINFOA();
    test_pack_LPOSVERSIONINFOEXA();
    test_pack_LPOSVERSIONINFOEXW();
    test_pack_LPOSVERSIONINFOW();
    test_pack_LPOVERLAPPED();
    test_pack_LPOVERLAPPED_COMPLETION_ROUTINE();
    test_pack_LPPROCESS_HEAP_ENTRY();
    test_pack_LPPROCESS_INFORMATION();
    test_pack_LPPROGRESS_ROUTINE();
    test_pack_LPSECURITY_ATTRIBUTES();
    test_pack_LPSTARTUPINFOA();
    test_pack_LPSTARTUPINFOW();
    test_pack_LPSYSTEMTIME();
    test_pack_LPSYSTEM_INFO();
    test_pack_LPSYSTEM_POWER_STATUS();
    test_pack_LPTHREAD_START_ROUTINE();
    test_pack_LPTIME_ZONE_INFORMATION();
    test_pack_LPVOID();
    test_pack_LPWIN32_FILE_ATTRIBUTE_DATA();
    test_pack_LPWIN32_FIND_DATAA();
    test_pack_LPWIN32_FIND_DATAW();
    test_pack_LPWIN32_STREAM_ID();
    test_pack_MEMORYSTATUS();
    test_pack_MEMORYSTATUSEX();
    test_pack_OFSTRUCT();
    test_pack_OSVERSIONINFOA();
    test_pack_OSVERSIONINFOEXA();
    test_pack_OSVERSIONINFOEXW();
    test_pack_OSVERSIONINFOW();
    test_pack_OUTPUT_DEBUG_STRING_INFO();
    test_pack_PACTCTXA();
    test_pack_PACTCTXW();
    test_pack_PACTCTX_SECTION_KEYED_DATA();
    test_pack_PACTCTX_SECTION_KEYED_DATA_2600();
    test_pack_PACTCTX_SECTION_KEYED_DATA_ASSEMBLY_METADATA();
    test_pack_PACTIVATION_CONTEXT_BASIC_INFORMATION();
    test_pack_PAPCFUNC();
    test_pack_PBY_HANDLE_FILE_INFORMATION();
    test_pack_PCACTCTXA();
    test_pack_PCACTCTXW();
    test_pack_PCACTCTX_SECTION_KEYED_DATA();
    test_pack_PCACTCTX_SECTION_KEYED_DATA_2600();
    test_pack_PCACTCTX_SECTION_KEYED_DATA_ASSEMBLY_METADATA();
    test_pack_PCRITICAL_SECTION();
    test_pack_PCRITICAL_SECTION_DEBUG();
    test_pack_PDYNAMIC_TIME_ZONE_INFORMATION();
    test_pack_PFIBER_START_ROUTINE();
    test_pack_PHKEY();
    test_pack_POFSTRUCT();
    test_pack_POSVERSIONINFOA();
    test_pack_POSVERSIONINFOEXA();
    test_pack_POSVERSIONINFOEXW();
    test_pack_POSVERSIONINFOW();
    test_pack_PPROCESS_HEAP_ENTRY();
    test_pack_PPROCESS_INFORMATION();
    test_pack_PQUERYACTCTXW_FUNC();
    test_pack_PROCESS_HEAP_ENTRY();
    test_pack_PROCESS_INFORMATION();
    test_pack_PSECURITY_ATTRIBUTES();
    test_pack_PSYSTEMTIME();
    test_pack_PTIMERAPCROUTINE();
    test_pack_PTIME_ZONE_INFORMATION();
    test_pack_PWIN32_FIND_DATAA();
    test_pack_PWIN32_FIND_DATAW();
    test_pack_RIP_INFO();
    test_pack_SECURITY_ATTRIBUTES();
    test_pack_STARTUPINFOA();
    test_pack_STARTUPINFOW();
    test_pack_SYSTEMTIME();
    test_pack_SYSTEM_INFO();
    test_pack_SYSTEM_POWER_STATUS();
    test_pack_TIME_ZONE_INFORMATION();
    test_pack_UNLOAD_DLL_DEBUG_INFO();
    test_pack_WAITORTIMERCALLBACK();
    test_pack_WIN32_FILE_ATTRIBUTE_DATA();
    test_pack_WIN32_FIND_DATAA();
    test_pack_WIN32_FIND_DATAW();
    test_pack_WIN32_STREAM_ID();
}

START_TEST(generated)
{
    test_pack();
}
