include(RunCMake)

function(run_test name)
  set(RunCMake_TEST_BINARY_DIR ${RunCMake_BINARY_DIR}/${name}-build)
  run_cmake(${name})
  set(RunCMake_TEST_NO_CLEAN 1)
  run_cmake_command(${name}-build ${CMAKE_COMMAND} --build . --config Debug)
  run_cmake_command(${name}-test ${CMAKE_CTEST_COMMAND} -C Debug)
endfunction()

function(run_build_verbose name)
  set(RunCMake_TEST_BINARY_DIR ${RunCMake_BINARY_DIR}/${name}-build)
  run_cmake(${name})
  set(RunCMake_TEST_NO_CLEAN 1)
  run_cmake_command(${name}-build ${CMAKE_COMMAND} --build . --verbose --config Debug)
endfunction()

run_test(PchReuseFrom-CMP0141-OLD)
run_test(PchReuseFrom-CMP0141-NEW)
if(CMAKE_C_COMPILER_ID STREQUAL "MSVC")
  run_test(PchReuseFrom-CMP0141-NEW-empty)
endif()
run_test(PchReuseFromPrefixed)
run_test(PchReuseFromSubdir)
run_build_verbose(PchReuseFromIgnoreOwnProps)
run_build_verbose(PchReuseFromUseUpdatedProps)
run_build_verbose(PchReuseConsistency)
run_cmake(PchReuseFromCycle)
run_cmake(PchReuseWithoutPch)
run_build_verbose(PchReuseAppend)
run_build_verbose(PchReuseDeclarationOrder)
run_test(PchReuseFromObjLib)
