/* Generated by wayland-scanner 1.23.0 */

#ifndef LVR_SVG_PATH_SERVER_PROTOCOL_H
#define LVR_SVG_PATH_SERVER_PROTOCOL_H

#include <stdint.h>
#include <stddef.h>
#include "wayland-server.h"

#ifdef  __cplusplus
extern "C" {
#endif

struct wl_client;
struct wl_resource;

/**
 * @page page_lvr_svg_path The lvr_svg_path protocol
 * vector shapes factory
 *
 * @section page_desc_lvr_svg_path Description
 *
 * This protocol provides an efficient way for clients to define complex shapes.
 *
 * One common use for these shapes is masking, as seen in the lvr_background_blur 
 * protocol. However, other protocols may apply them for purposes not covered in 
 * this document.
 *
 * Shapes are expressed as a string of SVG path commands, a standard and widely 
 * used format. In the future, this approach may be replaced by separate requests 
 * for each type of SVG path command.
 *
 * Warning: This protocol is experimental, and backward-incompatible changes may be 
 * made in the future.
 *
 * @section page_ifaces_lvr_svg_path Interfaces
 * - @subpage page_iface_lvr_svg_path_manager - SVG path manager
 * - @subpage page_iface_lvr_svg_path - SVG path object
 * @section page_copyright_lvr_svg_path Copyright
 * <pre>
 *
 * Copyright © 2025 Eduardo Hopperdietzel
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice (including the next
 * paragraph) shall be included in all copies or substantial portions of the
 * Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 * </pre>
 */
struct lvr_svg_path;
struct lvr_svg_path_manager;

#ifndef LVR_SVG_PATH_MANAGER_INTERFACE
#define LVR_SVG_PATH_MANAGER_INTERFACE
/**
 * @page page_iface_lvr_svg_path_manager lvr_svg_path_manager
 * @section page_iface_lvr_svg_path_manager_desc Description
 *
 * This interface allows a compositor to announce support for SVG paths.
 * @section page_iface_lvr_svg_path_manager_api API
 * See @ref iface_lvr_svg_path_manager.
 */
/**
 * @defgroup iface_lvr_svg_path_manager The lvr_svg_path_manager interface
 *
 * This interface allows a compositor to announce support for SVG paths.
 */
extern const struct wl_interface lvr_svg_path_manager_interface;
#endif
#ifndef LVR_SVG_PATH_INTERFACE
#define LVR_SVG_PATH_INTERFACE
/**
 * @page page_iface_lvr_svg_path lvr_svg_path
 * @section page_iface_lvr_svg_path_desc Description
 *
 * The SVG path is described as a string of commands, as outlined here:
 *
 * https://svgwg.org/specs/paths/
 *
 * After requesting a lvr_svg_path object, the client must send zero or multiple 
 * concat_commands if the string exceeds 4096 bytes, which is the default maximum 
 * length supported by libwayland. The compositor concatenates the strings in order 
 * of receipt. 
 *
 * Once all commands are sent, the client must issue a done request, at which point 
 * the SVG path is considered complete. Sending a done request without having previously 
 * sent a concat_command is valid and represents an empty path. 
 *
 * No requests, except for destroy, are accepted after a done event, otherwise, 
 * the already_constructed error is emitted.
 *
 * Sending a destroy request without having sent a done request triggers the incomplete error. 
 *
 * If the final string yield an invalid SVG path, the invalid_commands error is emitted. 
 *
 * The coordinate system of the described path depends on the context in which it is used.
 * @section page_iface_lvr_svg_path_api API
 * See @ref iface_lvr_svg_path.
 */
/**
 * @defgroup iface_lvr_svg_path The lvr_svg_path interface
 *
 * The SVG path is described as a string of commands, as outlined here:
 *
 * https://svgwg.org/specs/paths/
 *
 * After requesting a lvr_svg_path object, the client must send zero or multiple 
 * concat_commands if the string exceeds 4096 bytes, which is the default maximum 
 * length supported by libwayland. The compositor concatenates the strings in order 
 * of receipt. 
 *
 * Once all commands are sent, the client must issue a done request, at which point 
 * the SVG path is considered complete. Sending a done request without having previously 
 * sent a concat_command is valid and represents an empty path. 
 *
 * No requests, except for destroy, are accepted after a done event, otherwise, 
 * the already_constructed error is emitted.
 *
 * Sending a destroy request without having sent a done request triggers the incomplete error. 
 *
 * If the final string yield an invalid SVG path, the invalid_commands error is emitted. 
 *
 * The coordinate system of the described path depends on the context in which it is used.
 */
extern const struct wl_interface lvr_svg_path_interface;
#endif

/**
 * @ingroup iface_lvr_svg_path_manager
 * @struct lvr_svg_path_manager_interface
 */
struct lvr_svg_path_manager_interface {
	/**
	 * destroy the SVG path manager object
	 *
	 * Destroy the SVG path manager. This doesn't destroy objects
	 * created with the manager.
	 */
	void (*destroy)(struct wl_client *client,
			struct wl_resource *resource);
	/**
	 * create a new SVG path object
	 *
	 * 
	 */
	void (*get_svg_path)(struct wl_client *client,
			     struct wl_resource *resource,
			     uint32_t id);
};


/**
 * @ingroup iface_lvr_svg_path_manager
 */
#define LVR_SVG_PATH_MANAGER_DESTROY_SINCE_VERSION 1
/**
 * @ingroup iface_lvr_svg_path_manager
 */
#define LVR_SVG_PATH_MANAGER_GET_SVG_PATH_SINCE_VERSION 1

#ifndef LVR_SVG_PATH_ERROR_ENUM
#define LVR_SVG_PATH_ERROR_ENUM
enum lvr_svg_path_error {
	/**
	 * incomplete svg path
	 */
	LVR_SVG_PATH_ERROR_INCOMPLETE = 0,
	/**
	 * a request other than destroy was made after a done request
	 */
	LVR_SVG_PATH_ERROR_ALREADY_CONSTRUCTED = 1,
	/**
	 * the final string doesn't represent a valid svg path
	 */
	LVR_SVG_PATH_ERROR_INVALID_COMMANDS = 2,
};
/**
 * @ingroup iface_lvr_svg_path
 * Validate a lvr_svg_path error value.
 *
 * @return true on success, false on error.
 * @ref lvr_svg_path_error
 */
static inline bool
lvr_svg_path_error_is_valid(uint32_t value, uint32_t version) {
	switch (value) {
	case LVR_SVG_PATH_ERROR_INCOMPLETE:
		return version >= 1;
	case LVR_SVG_PATH_ERROR_ALREADY_CONSTRUCTED:
		return version >= 1;
	case LVR_SVG_PATH_ERROR_INVALID_COMMANDS:
		return version >= 1;
	default:
		return false;
	}
}
#endif /* LVR_SVG_PATH_ERROR_ENUM */

/**
 * @ingroup iface_lvr_svg_path
 * @struct lvr_svg_path_interface
 */
struct lvr_svg_path_interface {
	/**
	 * destroy the vector path object
	 *
	 * 
	 */
	void (*destroy)(struct wl_client *client,
			struct wl_resource *resource);
	/**
	 * append SVG path commands
	 *
	 * The string size of each request must not exceed the 4096-byte
	 * limit.
	 */
	void (*concat_commands)(struct wl_client *client,
				struct wl_resource *resource,
				const char *commands);
	/**
	 * all commands have been sent
	 *
	 * Once this request is sent, the only permissible action is
	 * destroy.
	 */
	void (*done)(struct wl_client *client,
		     struct wl_resource *resource);
};


/**
 * @ingroup iface_lvr_svg_path
 */
#define LVR_SVG_PATH_DESTROY_SINCE_VERSION 1
/**
 * @ingroup iface_lvr_svg_path
 */
#define LVR_SVG_PATH_CONCAT_COMMANDS_SINCE_VERSION 1
/**
 * @ingroup iface_lvr_svg_path
 */
#define LVR_SVG_PATH_DONE_SINCE_VERSION 1

#ifdef  __cplusplus
}
#endif

#endif
