/* foundry-hover-provider.h
 *
 * Copyright 2025 Christian Hergert <chergert@redhat.com>
 *
 * This library is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of the
 * License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * SPDX-License-Identifier: LGPL-2.1-or-later
 */

#pragma once

#include <libpeas.h>

#include "foundry-contextual.h"
#include "foundry-text-document.h"
#include "foundry-text-iter.h"

G_BEGIN_DECLS

#define FOUNDRY_TYPE_HOVER_PROVIDER (foundry_hover_provider_get_type())

FOUNDRY_AVAILABLE_IN_ALL
G_DECLARE_DERIVABLE_TYPE (FoundryHoverProvider, foundry_hover_provider, FOUNDRY, HOVER_PROVIDER, FoundryContextual)

struct _FoundryHoverProviderClass
{
  FoundryContextualClass parent_class;

  DexFuture *(*populate) (FoundryHoverProvider  *self,
                          const FoundryTextIter *location);

  /*< private >*/
  gpointer _reserved[8];
};

FOUNDRY_AVAILABLE_IN_ALL
FoundryTextBuffer   *foundry_hover_provider_dup_buffer      (FoundryHoverProvider *self);
FOUNDRY_AVAILABLE_IN_ALL
FoundryTextDocument *foundry_hover_provider_dup_document    (FoundryHoverProvider *self);
FOUNDRY_AVAILABLE_IN_ALL
DexFuture           *foundry_hover_provider_populate        (FoundryHoverProvider  *self,
                                                             const FoundryTextIter *location);
FOUNDRY_AVAILABLE_IN_ALL
PeasPluginInfo      *foundry_hover_provider_dup_plugin_info (FoundryHoverProvider  *self);

G_END_DECLS
