/* foundry-json-output-stream.h
 *
 * Copyright 2025 Christian Hergert <chergert@redhat.com>
 *
 * This library is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of the
 * License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * SPDX-License-Identifier: LGPL-2.1-or-later
 */

#pragma once

#include <json-glib/json-glib.h>
#include <libdex.h>

#include "foundry-version-macros.h"

G_BEGIN_DECLS

#define FOUNDRY_TYPE_JSON_OUTPUT_STREAM (foundry_json_output_stream_get_type())

FOUNDRY_AVAILABLE_IN_ALL
G_DECLARE_FINAL_TYPE (FoundryJsonOutputStream, foundry_json_output_stream, FOUNDRY, JSON_OUTPUT_STREAM, GDataOutputStream)

FOUNDRY_AVAILABLE_IN_ALL
FoundryJsonOutputStream *foundry_json_output_stream_new   (GOutputStream           *base_stream,
                                                           gboolean                 close_base_stream);
FOUNDRY_AVAILABLE_IN_ALL
DexFuture               *foundry_json_output_stream_write (FoundryJsonOutputStream *self,
                                                           GHashTable              *headers,
                                                           JsonNode                *node,
                                                           GBytes                  *delimiter);

G_END_DECLS
