$NetBSD: patch-configure.cmake,v 1.1 2024/08/05 01:23:59 jnemeth Exp $

--- configure.cmake.orig	2022-03-23 13:49:36.000000000 +0000
+++ configure.cmake
@@ -183,13 +183,9 @@ ENDIF()
 #
 INCLUDE (CheckIncludeFiles)
 
-IF(FREEBSD)
-  # On FreeBSD some includes, e.g. sasl/sasl.h, is in /usr/local/include
-  LIST(APPEND CMAKE_REQUIRED_INCLUDES "/usr/local/include")
-ENDIF()
-
 CHECK_INCLUDE_FILES (alloca.h HAVE_ALLOCA_H)
 CHECK_INCLUDE_FILES (arpa/inet.h HAVE_ARPA_INET_H)
+CHECK_INCLUDE_FILES (bstring.h HAVE_BSTRING_H)
 CHECK_INCLUDE_FILES (dlfcn.h HAVE_DLFCN_H)
 CHECK_INCLUDE_FILES (endian.h HAVE_ENDIAN_H)
 CHECK_INCLUDE_FILES (execinfo.h HAVE_EXECINFO_H)
@@ -238,6 +234,7 @@ CHECK_FUNCTION_EXISTS (fcntl HAVE_FCNTL)
 CHECK_FUNCTION_EXISTS (fdatasync HAVE_FDATASYNC)
 CHECK_SYMBOL_EXISTS(fdatasync "unistd.h" HAVE_DECL_FDATASYNC)
 CHECK_FUNCTION_EXISTS (fedisableexcept HAVE_FEDISABLEEXCEPT)
+CHECK_FUNCTION_EXISTS (ffsll HAVE_FFSLL)
 CHECK_FUNCTION_EXISTS (fsync HAVE_FSYNC)
 CHECK_FUNCTION_EXISTS (gethrtime HAVE_GETHRTIME)
 CHECK_FUNCTION_EXISTS (getpass HAVE_GETPASS)
@@ -298,6 +295,7 @@ CHECK_SYMBOL_EXISTS(TIOCGWINSZ "sys/ioct
 CHECK_SYMBOL_EXISTS(FIONREAD "sys/ioctl.h" FIONREAD_IN_SYS_IOCTL)
 CHECK_SYMBOL_EXISTS(FIONREAD "sys/filio.h" FIONREAD_IN_SYS_FILIO)
 CHECK_SYMBOL_EXISTS(MADV_DONTDUMP "sys/mman.h" HAVE_MADV_DONTDUMP)
+CHECK_SYMBOL_EXISTS(EVFILT_USER "sys/event.h" HAVE_EVFILT_USER)
 CHECK_CXX_SOURCE_COMPILES(
 "#include <sys/types.h>
  #include <sys/stat.h>
@@ -330,6 +328,14 @@ ELSEIF(HAVE_TIMER_CREATE AND HAVE_TIMER_
   SET(HAVE_POSIX_TIMERS 1 CACHE INTERNAL "Have POSIX timer-related functions")
 ENDIF()
 
+IF (NOT HAVE_EVFILT_USER)
+  SET(HAVE_KQUEUE 0)
+  SET(HAVE_KQUEUE_TIMERS 0)
+  IF(HAVE_TIMER_CREATE AND HAVE_TIMER_SETTIME)
+    SET(HAVE_POSIX_TIMERS 1 CACHE INTERNAL "Have POSIX timer-related functions")
+  ENDIF()
+ENDIF()
+
 IF(NOT HAVE_POSIX_TIMERS AND NOT HAVE_KQUEUE_TIMERS AND NOT WIN32)
   MESSAGE(FATAL_ERROR "No mysys timer support detected!")
 ENDIF()
