package POSIX::2008;

use strict;
use warnings;
use Carp ();
use IO::Dir ();
use IO::File ();
use Time::HiRes qw(gettimeofday tv_interval);

require Exporter;

our $VERSION = '0.25';
our $XS_VERSION = $VERSION;
$VERSION = eval $VERSION; # so "use Module 0.002" won't warn on underscore

our @_functions = qw(

a64l abort abs access acos acosh alarm asin asinh atan atan2 atanh atof atoi
basename cabs cacos cacosh carg casin casinh catan catanh catclose catgets
catopen cbrt ccos ccosh ceil cexp chdir chmod chown cimag clock
clock_getcpuclockid clock_getres clock_gettime clock_nanosleep clock_settime
clog close confstr conj copysign cos cosh cpow cproj creal creat csin csinh
csqrt ctan ctanh dirname div dlclose dlerror dlopen dlsym drand48 endutxent
erand48 erf erfc execveat exp exp2 expm1 faccessat fchmodat fchownat fdatasync
fdim fdopen fdopendir feclearexcept fegetround feraiseexcept fesetround
fetestexcept fexecve ffs floor fma fmax fmin fmod fnmatch fpclassify fstatat
fsync futimens getdate getdate_err getegid geteuid getgid gethostid
gethostname getitimer getpriority getsid getuid getutxent getutxid getutxline
hypot ilogb isalnum isalpha isascii isatty isblank iscntrl isdigit isfinite
isgraph isgreaterequal isinf isless islessequal islessgreater islower isnan
isnormal isprint ispunct isspace isunordered isupper isxdigit j0 j1 jn jrand48
killpg l64a lchown ldexp lgamma link linkat log log10 log1p log2 logb lrand48
lround lstat mkdir mkdirat mkdtemp mkfifo mkfifoat mknod mknodat mkstemp
mrand48 nanosleep nearbyint nextafter nexttoward nice nrand48 open openat
openat2 pathconf poll posix_fadvise posix_fallocate pread preadv preadv2
psignal ptsname pwrite pwritev pwritev2 random raise read readlink readlinkat
readv realpath remainder remove removeat remquo rename renameat renameat2
rmdir round scalbn seed48 setegid seteuid setgid setitimer setpriority
setregid setreuid setsid setuid setutxent sighold sigignore signbit sigpause
sigrelse sin sinh srand48 srandom stat statvfs strptime strsignal symlink
symlinkat sync sysconf tan tanh tgamma timer_create timer_delete
timer_getoverrun timer_gettime timer_settime trunc truncate ttyname unlink
unlinkat utimensat write writev y0 y1 yn

);

our @_constants = qw(

AT_EACCESS AT_EMPTY_PATH AT_FDCWD AT_NO_AUTOMOUNT AT_REMOVEDIR
AT_RESOLVE_BENEATH AT_SYMLINK_FOLLOW AT_SYMLINK_NOFOLLOW BOOT_TIME

CLOCK_BOOTTIME CLOCK_BOOTTIME_ALARM CLOCK_HIGHRES CLOCK_MONOTONIC
CLOCK_MONOTONIC_COARSE CLOCK_MONOTONIC_FAST CLOCK_MONOTONIC_PRECISE
CLOCK_MONOTONIC_RAW CLOCK_PROCESS_CPUTIME_ID CLOCK_REALTIME
CLOCK_REALTIME_ALARM CLOCK_REALTIME_COARSE CLOCK_REALTIME_FAST
CLOCK_REALTIME_PRECISE CLOCK_SOFTTIME CLOCK_TAI CLOCK_THREAD_CPUTIME_ID
CLOCK_UPTIME CLOCK_UPTIME_FAST CLOCK_UPTIME_PRECISE

DEAD_PROCESS FASYNC F_DUPFD F_DUPFD_CLOEXEC F_GETFD F_SETFD F_GETFL F_SETFL
F_GETLK F_SETLK F_SETLKW F_GETOWN F_SETOWN F_RDLCK F_UNLCK F_WRLCK FD_CLOEXEC
FE_TONEAREST FE_TOWARDZERO FE_UPWARD FE_DOWNWARD FE_DIVBYZERO FE_INEXACT
FE_INVALID FE_OVERFLOW FE_UNDERFLOW FE_ALL_EXCEPT FNM_CASEFOLD FNM_FILE_NAME
FNM_LEADING_DIR FNM_NOESCAPE FNM_NOMATCH FNM_PATHNAME FNM_PERIOD FP_INFINITE
FP_NAN FP_NORMAL FP_SUBNORMAL FP_ZERO INIT_PROCESS ITIMER_PROF ITIMER_REAL
ITIMER_VIRTUAL LOGIN_PROCESS NEW_TIME O_ACCMODE O_ASYNC O_APPEND O_CLOEXEC
O_CREAT O_DIRECT O_DIRECTORY O_DSYNC O_EMPTY_PATH O_EXEC O_EXCL O_EXLOCK
O_LARGEFILE O_NDELAY O_NOATIME O_NOCTTY O_NOFOLLOW O_NONBLOCK O_NOSIGPIPE
O_PATH O_RDONLY O_RDWR O_RESOLVE_BENEATH O_REGULAR O_RSYNC O_SEARCH O_SHLOCK
O_SYNC O_TMPFILE O_TRUNC O_TTY_INIT O_WRONLY OLD_TIME POSIX_FADV_NORMAL
POSIX_FADV_SEQUENTIAL POSIX_FADV_RANDOM POSIX_FADV_NOREUSE POSIX_FADV_WILLNEED
POSIX_FADV_DONTNEED PRIO_PROCESS PRIO_PGRP PRIO_USER RENAME_EXCHANGE
RENAME_NOREPLACE RENAME_WHITEOUT RESOLVE_BENEATH RESOLVE_IN_ROOT
RESOLVE_NO_MAGICLINKS RESOLVE_NO_SYMLINKS RESOLVE_NO_XDEV RESOLVE_CACHED
RTLD_DEEPBIND RTLD_GLOBAL RTLD_LAZY RTLD_LOCAL RTLD_MEMBER RTLD_NOAUTODEFER
RTLD_NODELETE RTLD_NOLOAD RTLD_NOW RUN_LVL RWF_DSYNC RWF_HIPRI RWF_SYNC
RWF_NOWAIT RWF_APPEND S_IFMT S_IFBLK S_IFCHR S_IFIFO S_IFREG S_IFDIR S_IFLNK
S_IFSOCK S_ISUID S_ISGID S_IRWXU S_IRUSR S_IWUSR S_IXUSR S_IRWXG S_IRGRP
S_IWGRP S_IXGRP S_IRWXO S_IROTH S_IWOTH S_IXOTH S_ISVTX SEEK_SET SEEK_CUR
SEEK_END SEEK_DATA SEEK_HOLE TIMER_ABSTIME USER_PROCESS UTIME_NOW UTIME_OMIT
F_OK R_OK W_OK X_OK

INFTIM POLLERR POLLFREE POLLHUP POLLIN POLLMSG POLLNORM POLLNVAL POLLOUT
POLLPRI POLLRDBAND POLLRDHUP POLLRDNORM POLLREMOVE POLLWRBAND POLLWRNORM
POLL_BUSY_LOOP

ST_NOSUID ST_RDONLY

ST_MANDLOCK ST_NOATIME ST_NODEV ST_NODIRATIME ST_NOEXEC ST_RELATIME
ST_SYNCHRONOUS

ST_ASYNC ST_DEFEXPORTED ST_EXKERB ST_EXNORESPORT ST_EXPORTANON ST_EXPORTED
ST_EXPUBLIC ST_EXRDONLY ST_LOCAL ST_LOG ST_NOCOREDUMP ST_NODEVMTIME
ST_QUOTA ST_ROOTFS ST_SYMPERM ST_UNION

_CS_GNU_LIBC_VERSION _CS_GNU_LIBPTHREAD_VERSION _CS_LFS64_CFLAGS
_CS_LFS64_LDFLAGS _CS_LFS64_LIBS _CS_LFS64_LINTFLAGS _CS_LFS_CFLAGS
_CS_LFS_LDFLAGS _CS_LFS_LIBS _CS_LFS_LINTFLAGS _CS_PATH
_CS_POSIX_V5_WIDTH_RESTRICTED_ENVS _CS_POSIX_V6_ILP32_OFF32_CFLAGS
_CS_POSIX_V6_ILP32_OFF32_LDFLAGS _CS_POSIX_V6_ILP32_OFF32_LIBS
_CS_POSIX_V6_ILP32_OFF32_LINTFLAGS _CS_POSIX_V6_ILP32_OFFBIG_CFLAGS
_CS_POSIX_V6_ILP32_OFFBIG_LDFLAGS _CS_POSIX_V6_ILP32_OFFBIG_LIBS
_CS_POSIX_V6_ILP32_OFFBIG_LINTFLAGS _CS_POSIX_V6_LP64_OFF64_CFLAGS
_CS_POSIX_V6_LP64_OFF64_LDFLAGS _CS_POSIX_V6_LP64_OFF64_LIBS
_CS_POSIX_V6_LP64_OFF64_LINTFLAGS _CS_POSIX_V6_LPBIG_OFFBIG_CFLAGS
_CS_POSIX_V6_LPBIG_OFFBIG_LDFLAGS _CS_POSIX_V6_LPBIG_OFFBIG_LIBS
_CS_POSIX_V6_LPBIG_OFFBIG_LINTFLAGS _CS_POSIX_V6_WIDTH_RESTRICTED_ENVS
_CS_POSIX_V7_ILP32_OFF32_CFLAGS _CS_POSIX_V7_ILP32_OFF32_LDFLAGS
_CS_POSIX_V7_ILP32_OFF32_LIBS _CS_POSIX_V7_ILP32_OFF32_LINTFLAGS
_CS_POSIX_V7_ILP32_OFFBIG_CFLAGS _CS_POSIX_V7_ILP32_OFFBIG_LDFLAGS
_CS_POSIX_V7_ILP32_OFFBIG_LIBS _CS_POSIX_V7_ILP32_OFFBIG_LINTFLAGS
_CS_POSIX_V7_LP64_OFF64_CFLAGS _CS_POSIX_V7_LP64_OFF64_LDFLAGS
_CS_POSIX_V7_LP64_OFF64_LIBS _CS_POSIX_V7_LP64_OFF64_LINTFLAGS
_CS_POSIX_V7_LPBIG_OFFBIG_CFLAGS _CS_POSIX_V7_LPBIG_OFFBIG_LDFLAGS
_CS_POSIX_V7_LPBIG_OFFBIG_LIBS _CS_POSIX_V7_LPBIG_OFFBIG_LINTFLAGS
_CS_POSIX_V7_WIDTH_RESTRICTED_ENVS _CS_V5_WIDTH_RESTRICTED_ENVS _CS_V6_ENV
_CS_V6_WIDTH_RESTRICTED_ENVS _CS_V7_ENV _CS_V7_WIDTH_RESTRICTED_ENVS
_CS_XBS5_ILP32_OFF32_CFLAGS _CS_XBS5_ILP32_OFF32_LDFLAGS
_CS_XBS5_ILP32_OFF32_LIBS _CS_XBS5_ILP32_OFF32_LINTFLAGS
_CS_XBS5_ILP32_OFFBIG_CFLAGS _CS_XBS5_ILP32_OFFBIG_LDFLAGS
_CS_XBS5_ILP32_OFFBIG_LIBS _CS_XBS5_ILP32_OFFBIG_LINTFLAGS
_CS_XBS5_LP64_OFF64_CFLAGS _CS_XBS5_LP64_OFF64_LDFLAGS
_CS_XBS5_LP64_OFF64_LIBS _CS_XBS5_LP64_OFF64_LINTFLAGS
_CS_XBS5_LPBIG_OFFBIG_CFLAGS _CS_XBS5_LPBIG_OFFBIG_LDFLAGS
_CS_XBS5_LPBIG_OFFBIG_LIBS _CS_XBS5_LPBIG_OFFBIG_LINTFLAGS

_PC_2_SYMLINKS _PC_ALLOC_SIZE_MIN _PC_ASYNC_IO _PC_CHOWN_RESTRICTED
_PC_FILESIZEBITS _PC_LINK_MAX _PC_MAX_CANON _PC_MAX_INPUT _PC_NAME_MAX
_PC_NO_TRUNC _PC_PATH_MAX _PC_PIPE_BUF _PC_PRIO_IO _PC_REC_INCR_XFER_SIZE
_PC_REC_MAX_XFER_SIZE _PC_REC_MIN_XFER_SIZE _PC_REC_XFER_ALIGN _PC_SOCK_MAXBUF
_PC_SYMLINK_MAX _PC_SYNC_IO _PC_VDISABLE

_SC_2_CHAR_TERM _SC_2_C_BIND _SC_2_C_DEV _SC_2_C_VERSION _SC_2_FORT_DEV
_SC_2_FORT_RUN _SC_2_LOCALEDEF _SC_2_PBS _SC_2_PBS_ACCOUNTING
_SC_2_PBS_CHECKPOINT _SC_2_PBS_LOCATE _SC_2_PBS_MESSAGE _SC_2_PBS_TRACK
_SC_2_SW_DEV _SC_2_UPE _SC_2_VERSION _SC_ADVISORY_INFO _SC_AIO_LISTIO_MAX
_SC_AIO_MAX _SC_AIO_PRIO_DELTA_MAX _SC_ARG_MAX _SC_ASYNCHRONOUS_IO
_SC_ATEXIT_MAX _SC_AVPHYS_PAGES _SC_BARRIERS _SC_BASE _SC_BC_BASE_MAX
_SC_BC_DIM_MAX _SC_BC_SCALE_MAX _SC_BC_STRING_MAX _SC_CHARCLASS_NAME_MAX
_SC_CHAR_BIT _SC_CHAR_MAX _SC_CHAR_MIN _SC_CHILD_MAX _SC_CLK_TCK
_SC_CLOCK_SELECTION _SC_COLL_WEIGHTS_MAX _SC_CPUTIME _SC_C_LANG_SUPPORT
_SC_C_LANG_SUPPORT_R _SC_DELAYTIMER_MAX _SC_DEVICE_IO _SC_DEVICE_SPECIFIC
_SC_DEVICE_SPECIFIC_R _SC_EQUIV_CLASS_MAX _SC_EXPR_NEST_MAX _SC_FD_MGMT
_SC_FIFO _SC_FILE_ATTRIBUTES _SC_FILE_LOCKING _SC_FILE_SYSTEM _SC_FSYNC
_SC_GETGR_R_SIZE_MAX _SC_GETPW_R_SIZE_MAX _SC_HOST_NAME_MAX _SC_INT_MAX
_SC_INT_MIN _SC_IOV_MAX _SC_IPV6 _SC_JOB_CONTROL _SC_LEVEL1_DCACHE_ASSOC
_SC_LEVEL1_DCACHE_LINESIZE _SC_LEVEL1_DCACHE_SIZE _SC_LEVEL1_ICACHE_ASSOC
_SC_LEVEL1_ICACHE_LINESIZE _SC_LEVEL1_ICACHE_SIZE _SC_LEVEL2_CACHE_ASSOC
_SC_LEVEL2_CACHE_LINESIZE _SC_LEVEL2_CACHE_SIZE _SC_LEVEL3_CACHE_ASSOC
_SC_LEVEL3_CACHE_LINESIZE _SC_LEVEL3_CACHE_SIZE _SC_LEVEL4_CACHE_ASSOC
_SC_LEVEL4_CACHE_LINESIZE _SC_LEVEL4_CACHE_SIZE _SC_LINE_MAX
_SC_LOGIN_NAME_MAX _SC_LONG_BIT _SC_MAPPED_FILES _SC_MB_LEN_MAX _SC_MEMLOCK
_SC_MEMLOCK_RANGE _SC_MEMORY_PROTECTION _SC_MESSAGE_PASSING _SC_MINSIGSTKSZ
_SC_MONOTONIC_CLOCK _SC_MQ_OPEN_MAX _SC_MQ_PRIO_MAX _SC_MULTI_PROCESS
_SC_NETWORKING _SC_NGROUPS_MAX _SC_NL_ARGMAX _SC_NL_LANGMAX _SC_NL_MSGMAX
_SC_NL_NMAX _SC_NL_SETMAX _SC_NL_TEXTMAX _SC_NPROCESSORS_CONF
_SC_NPROCESSORS_ONLN _SC_NZERO _SC_OPEN_MAX _SC_PAGESIZE _SC_PAGE_SIZE
_SC_PASS_MAX _SC_PHYS_PAGES _SC_PII _SC_PII_INTERNET _SC_PII_INTERNET_DGRAM
_SC_PII_INTERNET_STREAM _SC_PII_OSI _SC_PII_OSI_CLTS _SC_PII_OSI_COTS
_SC_PII_OSI_M _SC_PII_SOCKET _SC_PII_XTI _SC_PIPE _SC_POLL _SC_PRIORITIZED_IO
_SC_PRIORITY_SCHEDULING _SC_RAW_SOCKETS _SC_READER_WRITER_LOCKS
_SC_REALTIME_SIGNALS _SC_REGEXP _SC_REGEX_VERSION _SC_RE_DUP_MAX _SC_RTSIG_MAX
_SC_SAVED_IDS _SC_SCHAR_MAX _SC_SCHAR_MIN _SC_SELECT _SC_SEMAPHORES
_SC_SEM_NSEMS_MAX _SC_SEM_VALUE_MAX _SC_SHARED_MEMORY_OBJECTS _SC_SHELL
_SC_SHRT_MAX _SC_SHRT_MIN _SC_SIGNALS _SC_SIGQUEUE_MAX _SC_SIGSTKSZ
_SC_SINGLE_PROCESS _SC_SPAWN _SC_SPIN_LOCKS _SC_SPORADIC_SERVER _SC_SSIZE_MAX
_SC_SS_REPL_MAX _SC_STREAMS _SC_STREAM_MAX _SC_SYMLOOP_MAX _SC_SYNCHRONIZED_IO
_SC_SYSTEM_DATABASE _SC_SYSTEM_DATABASE_R _SC_THREADS
_SC_THREAD_ATTR_STACKADDR _SC_THREAD_ATTR_STACKSIZE _SC_THREAD_CPUTIME
_SC_THREAD_DESTRUCTOR_ITERATIONS _SC_THREAD_KEYS_MAX
_SC_THREAD_PRIORITY_SCHEDULING _SC_THREAD_PRIO_INHERIT _SC_THREAD_PRIO_PROTECT
_SC_THREAD_PROCESS_SHARED _SC_THREAD_ROBUST_PRIO_INHERIT
_SC_THREAD_ROBUST_PRIO_PROTECT _SC_THREAD_SAFE_FUNCTIONS
_SC_THREAD_SPORADIC_SERVER _SC_THREAD_STACK_MIN _SC_THREAD_THREADS_MAX
_SC_TIMEOUTS _SC_TIMERS _SC_TIMER_MAX _SC_TRACE _SC_TRACE_EVENT_FILTER
_SC_TRACE_EVENT_NAME_MAX _SC_TRACE_INHERIT _SC_TRACE_LOG _SC_TRACE_NAME_MAX
_SC_TRACE_SYS_MAX _SC_TRACE_USER_EVENT_MAX _SC_TTY_NAME_MAX
_SC_TYPED_MEMORY_OBJECTS _SC_TZNAME_MAX _SC_T_IOV_MAX _SC_UCHAR_MAX
_SC_UINT_MAX _SC_UIO_MAXIOV _SC_ULONG_MAX _SC_USER_GROUPS _SC_USER_GROUPS_R
_SC_USHRT_MAX _SC_V6_ILP32_OFF32 _SC_V6_ILP32_OFFBIG _SC_V6_LP64_OFF64
_SC_V6_LPBIG_OFFBIG _SC_V7_ILP32_OFF32 _SC_V7_ILP32_OFFBIG _SC_V7_LP64_OFF64
_SC_V7_LPBIG_OFFBIG _SC_VERSION _SC_WORD_BIT _SC_XBS5_ILP32_OFF32
_SC_XBS5_ILP32_OFFBIG _SC_XBS5_LP64_OFF64 _SC_XBS5_LPBIG_OFFBIG
_SC_XOPEN_CRYPT _SC_XOPEN_ENH_I18N _SC_XOPEN_LEGACY _SC_XOPEN_REALTIME
_SC_XOPEN_REALTIME_THREADS _SC_XOPEN_SHM _SC_XOPEN_STREAMS _SC_XOPEN_UNIX
_SC_XOPEN_VERSION _SC_XOPEN_XCU_VERSION _SC_XOPEN_XPG2 _SC_XOPEN_XPG3
_SC_XOPEN_XPG4

);

our @ISA = qw(Exporter);
our @EXPORT = ();
our @EXPORT_OK = (@_functions, @_constants);

our %EXPORT_TAGS = (
  # at: Older Perls don't have variable length lookbehind, hence two regexen
  # for functions.
  'at'     => [
    grep(/^(?:AT|RENAME|RESOLVE)_/, @_constants),
    grep(/at2?$/ && !/^(?:creat|l?stat)$/, @_functions),
  ],
  'id'     => [grep /^[gs]et.+id$/, @_functions],
  'is'     => [grep /^is/, @_functions],
  'rw'     => [qw(read write readv writev)],
  'prw'    => [qw(pread preadv preadv2 pwrite pwritev pwritev2)],
  'clock'  => [grep(/^(?:CLOCK_|TIMER_ABSTIME)/, @_constants), grep(/^clock/, @_functions)],
  'fcntl'  => [grep /^(?:[FORWX]|FD|POSIX_FADV|SEEK)_/, @_constants],
  'fenv_h' => [grep(/^FE_/, @_constants), grep (/^fe/, @_functions)],
  'fnm'    => [grep(/^FNM_/, @_constants), 'fnmatch'],
  'poll'   => ['poll', grep /^(?:POLL|INFTIM)/, @_constants],
  'stat_h' => [grep /^(?:S_I|UTIME_)/, @_constants],
  'time_h' => [grep /^(?:CLOCK|TIMER)_/, @_constants],
  'timer'  => [grep(/^TIMER_/, @_constants), grep(/^timer_/, @_functions)],
  'utmpx_h'  => [
    grep(/_(?:TIME|PROCESS)$/, @_constants),
    grep(/^(?:ACCOUNTING|EMPTY|RUN_LVL)$/, @_constants),
    grep(/utx/, @_functions),
  ],
  'confstr'  => ['confstr', grep /^_CS_/, @_constants],
  'pathconf' => ['pathconf', grep /^_PC_/, @_constants],
  'sysconf'  => ['sysconf', grep /^_SC_/, @_constants],
);

my %deprecated = (
  atol => 'atoi',
  atoll => 'atoi',
  ldiv => 'div',
  lldiv => 'div',
  fchdir => 'chdir',
  fchmod => 'chmod',
  fchown => 'chown',
  ftruncate => 'truncate',
);
my %deprecated_warned;

push @EXPORT_OK, keys %deprecated;

our $AUTOLOAD;
sub AUTOLOAD {
  my ($func) = ($AUTOLOAD =~ /.*::(.*)/);
  die "POSIX::2008.xs has failed to load\n" if $func eq 'constant';
  constant($func);
}

sub import {
  my $this = shift;

  # This is a hack that allows us to import only the non-XS portion of the
  # module in Makefile.PL to get the constants for WriteConstants(). It's not
  # intended for use in actual code!
  if (@_ && $_[0] eq '-noxs') {
    shift;
  }
  else {
    require XSLoader;
    XSLoader::load('POSIX::2008', $XS_VERSION);

    while (my ($func, $repl) = each %deprecated) {
      my $package_func = __PACKAGE__."::${func}";
      my $package_repl = __PACKAGE__."::${repl}";
      no strict 'refs';
      *{$package_func} = sub {
        Carp::carp(
          "${package_func}() is deprecated, use ${package_repl}() instead"
        ) unless $deprecated_warned{$func}++;
        &{*{$package_repl}};
      }
    }
  }

  __PACKAGE__->export_to_level(1, $this, @_);
}

1;
