/*
 * This file is part of OpenTTD.
 * OpenTTD is free software; you can redistribute it and/or modify it under the terms of the GNU General Public License as published by the Free Software Foundation, version 2.
 * OpenTTD is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details. You should have received a copy of the GNU General Public License along with OpenTTD. If not, see <http://www.gnu.org/licenses/>.
 */

/** @file cheat_widget.h Types related to the cheat widgets. */

#ifndef WIDGETS_CHEAT_WIDGET_H
#define WIDGETS_CHEAT_WIDGET_H

/** Widgets of the #CheatWindow class. */
enum CheatWidgets : WidgetID {
	WID_C_NOTE,  ///< Note on top of panel for use of cheat.
	WID_C_PANEL, ///< Panel where all cheats are shown in.
	WID_C_SETTINGS, ///< Panel where sandbox settings are shown.
};

#endif /* WIDGETS_CHEAT_WIDGET_H */
