// Generated by gmmproc 2.84.0 -- DO NOT MODIFY!
#ifndef _GTKMM_POPOVERBIN_H
#define _GTKMM_POPOVERBIN_H

#include <gtkmmconfig.h>


#include <glibmm/ustring.h>
#include <sigc++/sigc++.h>

/* Copyright (C) 2026 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library. If not, see <http://www.gnu.org/licenses/>.
 */


#include <gtkmm/widget.h>
#include <gtkmm/popover.h>
#include <giomm/menumodel.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Gtk
{ class GTKMM_API PopoverBin_Class; } // namespace Gtk
#endif //DOXYGEN_SHOULD_SKIP_THIS

namespace Gtk
{

/** A single child container with a popover.
 *
 * You should use %Gtk::PopoverBin whenever you need to present a Gtk::Popover
 * to the user.
 *
 * %Gtk::PopoverBin defines the `menu.popup` action, which can be activated
 * to present the popover to the user.
 *
 * @ingroup Widgets
 * @newin{4,22}
 */

class GTKMM_API PopoverBin : public Widget
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  typedef PopoverBin CppObjectType;
  typedef PopoverBin_Class CppClassType;
  typedef GtkPopoverBin BaseObjectType;
  typedef GtkPopoverBinClass BaseClassType;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

  PopoverBin(PopoverBin&& src) noexcept;
  PopoverBin& operator=(PopoverBin&& src) noexcept;

  // noncopyable
  PopoverBin(const PopoverBin&) = delete;
  PopoverBin& operator=(const PopoverBin&) = delete;

  ~PopoverBin() noexcept override;

#ifndef DOXYGEN_SHOULD_SKIP_THIS

private:
  friend GTKMM_API class PopoverBin_Class;
  static CppClassType popoverbin_class_;

protected:
  explicit PopoverBin(const Glib::ConstructParams& construct_params);
  explicit PopoverBin(GtkPopoverBin* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:

  /** Get the GType for this class, for use with the underlying GObject type system.
   */
  static GType get_type()      G_GNUC_CONST;

#ifndef DOXYGEN_SHOULD_SKIP_THIS


  static GType get_base_type() G_GNUC_CONST;
#endif

  /// Provides access to the underlying C GObject.
  GtkPopoverBin*       gobj()       { return reinterpret_cast<GtkPopoverBin*>(gobject_); }

  /// Provides access to the underlying C GObject.
  const GtkPopoverBin* gobj() const { return reinterpret_cast<GtkPopoverBin*>(gobject_); }

private:

     
public:
  PopoverBin();

  
  /** Sets the child of the popover bin.
   * 
   * @newin{4,22}
   * 
   * @param child The child of the popover bin.
   */
  void set_child(Widget& child);
  /** Unsets the child.
   *
   * @newin{4,22}
   */
  void unset_child();
  
  /** Retrieves the child widget of the popover bin.
   * 
   * @newin{4,22}
   * 
   * @return The child widget.
   */
  Widget* get_child();
  
  /** Retrieves the child widget of the popover bin.
   * 
   * @newin{4,22}
   * 
   * @return The child widget.
   */
  const Widget* get_child() const;

  
  /** Sets the menu model used to create the popover that will be
   * presented when calling popup().
   * 
   * If @a model is <tt>nullptr</tt>, the popover will be unset.
   * 
   * A Gtk::Popover will be created from the menu model with
   * Gtk::PopoverMenu::new_from_model(). Actions will be connected
   * as documented for this function.
   * 
   * If property_popover() is already set, it will be
   * dissociated from the popover bin, and the property is set to <tt>nullptr</tt>.
   * 
   * See: set_popover()
   * 
   * @newin{4,22}
   * 
   * @param model A menu model.
   */
  void set_menu_model(const Glib::RefPtr<Gio::MenuModel>& model);
  
  /** Retrieves the menu model set using set_menu_model().
   * 
   * @newin{4,22}
   * 
   * @return The menu model for the popover.
   */
  Glib::RefPtr<Gio::MenuModel> get_menu_model();
  
  /** Retrieves the menu model set using set_menu_model().
   * 
   * @newin{4,22}
   * 
   * @return The menu model for the popover.
   */
  Glib::RefPtr<const Gio::MenuModel> get_menu_model() const;

  // gtk_popover_bin_set_popover() takes a GtkWidget*, but requires it to be a GtkPopover*.
  
  /** Sets the `Gtk::Popover` that will be presented when calling
   * popup().
   * 
   * If @a child is <tt>nullptr</tt>, the popover will be unset.
   * 
   * If property_menu_model() is set before calling
   * this function, then the menu model property will be unset.
   * 
   * See: set_menu_model()
   * 
   * @newin{4,22}
   * 
   * @param child A `Gtk::Popover`.
   */
  void set_popover(Popover& child);
  /** Unsets the popover.
   *
   * @newin{4,22}
   */
  void unset_popover();
  
  /** Retrieves the `Gtk::Popover` set using set_popover().
   * 
   * @newin{4,22}
   * 
   * @return A popover widget.
   */
  Popover* get_popover();
  
  /** Retrieves the `Gtk::Popover` set using set_popover().
   * 
   * @newin{4,22}
   * 
   * @return A popover widget.
   */
  const Popover* get_popover() const;

  
  /** Presents the popover to the user.
   * 
   * Use set_popover() or
   * set_menu_model() to define the popover.
   * 
   * See: popdown()
   * 
   * @newin{4,22}
   */
  void popup();
  
  /** Hides the popover from the user.
   * 
   * See: popup()
   * 
   * @newin{4,22}
   */
  void popdown();

  
  /** Enables or disables input handling.
   * 
   * If enabled, the popover bin will pop up the
   * popover on right-click or long press, as expected
   * for a context menu.
   * 
   * @newin{4,22}
   * 
   * @param handle_input Whether to handle input.
   */
  void set_handle_input(bool handle_input =  true);
  
  bool get_handle_input() const;

  /** The child widget of the popover bin.
   * 
   * @newin{4,22}
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< Widget* > property_child() ;

/** The child widget of the popover bin.
   * 
   * @newin{4,22}
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Widget* > property_child() const;

  /** The `Gtk::Popover` that will be popped up when calling
   * Gtk::PopoverBin::popup().
   * 
   * @newin{4,22}
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< Popover* > property_popover() ;

/** The `Gtk::Popover` that will be popped up when calling
   * Gtk::PopoverBin::popup().
   * 
   * @newin{4,22}
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Popover* > property_popover() const;

  /** The `Gio::MenuModel` from which the popup will be created.
   * 
   * See Gtk::PopoverBin::set_menu_model() for the interaction
   * with the property_popover() property.
   * 
   * @newin{4,22}
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< Glib::RefPtr<Gio::MenuModel> > property_menu_model() ;

/** The `Gio::MenuModel` from which the popup will be created.
   * 
   * See Gtk::PopoverBin::set_menu_model() for the interaction
   * with the property_popover() property.
   * 
   * @newin{4,22}
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Glib::RefPtr<Gio::MenuModel> > property_menu_model() const;

  /** Whether the popover bin will handle input
   * to trigger the popup.
   * 
   * @newin{4,22}
   *
   * Default value: <tt>false</tt>
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< bool > property_handle_input() ;

/** Whether the popover bin will handle input
   * to trigger the popup.
   * 
   * @newin{4,22}
   *
   * Default value: <tt>false</tt>
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< bool > property_handle_input() const;


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::


};

} // namespace Gtk


namespace Glib
{
  /** A Glib::wrap() method for this object.
   *
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Gtk::PopoverBin
   */
  GTKMM_API
  Gtk::PopoverBin* wrap(GtkPopoverBin* object, bool take_copy = false);
} //namespace Glib


#endif /* _GTKMM_POPOVERBIN_H */

