---
title: "oct-vibrational_spectrum"
#series: "Manual"
---


This utility calculates the vibrational spectrum from a molecular-dynamics run.

What this utility does is to read the velocity from the {{< file "td.general/coordinates" >}} and calculate the Velocity Autocorrelation Function:

$$
C\_{v}(t)=\\sum\_{i=1}^{N\_{atoms}}\\vec{v}\_i(t)\\cdot\\vec{v}\_i(t\_0)\\ ,
$$

afterward a cosinusoidal envelope is added, to make the periodic extension of the function continuous and then the spectrum is calculated by taking the Fourier transform of the function. On exit, two files are generated {{< file "td.general/velocity_autocorrelation" >}} and {{< file "td.general/vibrational" >}}.

This utility honours the variables {{< variable "PropagationSpectrumStartTime" >}} and {{< variable "PropagationSpectrumEndTime" >}} to control the time of sampling. Note that the velocity in the initial time must be different from zero, or $C_{v}$ will be identically zero.
The variable {{< variable "VibrationalSpectrumTime" >}} can be used to control the maximum time for the calculation of $C_{v}(t)$.
Also, it is possible to skip certain times and only read one time-step out of X, where X is specified by the variable {{< variable "VibrationalSpectrumTimeStepFactor" >}}. By default, this is set to 10.

As a discrete Fourier tranform is used, this utility can take several minutes to process a large run. If {{< octopus >}} was compiled with OpenMP support, this utility can run in several threads.

{{< manual-foot prev="Manual:External utilities:oct-vdW_c6" next="Manual:External utilities:oct-xyz-anim" >}}
---------------------------------------------
