/*
 Copyright (C) 2010 X. Andrade

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2, or (at your option)
 any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 02110-1301, USA.

*/

#include <cl_global.h>

__kernel void set_zero(const long np, const long offset, __global double * restrict aa){
  long long ip = get_global_id(0);

  if(ip < np) aa[offset + ip] = 0.0;
}

__kernel void set_zero_int(const long np, const long offset, __global int * restrict aa){
  long long ip = get_global_id(0);

  if(ip < np) aa[offset + ip] = 0;
}

/*
 Local Variables:
 mode: c
 coding: utf-8
 End:
*/
