!! Copyright (C) 2020 M. Oliveira
!!
!! This Source Code Form is subject to the terms of the Mozilla Public
!! License, v. 2.0. If a copy of the MPL was not distributed with this
!! file, You can obtain one at https://mozilla.org/MPL/2.0/.
!!

#include "global.h"

module force_interaction_oct_m
  use global_oct_m
  use interaction_oct_m

  implicit none

  private
  public ::                &
    force_interaction_t

  type, extends(interaction_t), abstract :: force_interaction_t
    integer :: dim = 0       !< spatial dimensions
    integer :: system_np = 0 !< number of particles in the system that the forces are acting on

    real(real64), allocatable, public :: force(:,:)
  end type force_interaction_t

end module force_interaction_oct_m

!! Local Variables:
!! mode: f90
!! coding: utf-8
!! End:
