!! Copyright (C) 2020 M. Oliveira
!!
!! This Source Code Form is subject to the terms of the Mozilla Public
!! License, v. 2.0. If a copy of the MPL was not distributed with this
!! file, You can obtain one at https://mozilla.org/MPL/2.0/.
!!

!> This module defines the abstract class for the system factory.
module system_factory_abst_oct_m
  use namespace_oct_m
  use system_oct_m
  implicit none

  private
  public ::                        &
    system_factory_abst_t

  !> @brief abstract class of the system factory
  type, abstract :: system_factory_abst_t
  contains
    procedure(system_factory_abst_create),     deferred :: create
  end type system_factory_abst_t

  abstract interface
    function system_factory_abst_create(this, namespace, type) result(system)
      import :: system_factory_abst_t
      import system_t
      import namespace_t
      class(system_factory_abst_t), intent(in) :: this
      type(namespace_t),            intent(in) :: namespace
      integer,                      intent(in) :: type
      class(system_t),              pointer    :: system
    end function system_factory_abst_create
  end interface

end module system_factory_abst_oct_m

!! Local Variables:
!! mode: f90
!! coding: utf-8
!! End:
