! Note: this file is generated automatically by scripts/mk_functionals_list.pl
!
!%Variable XCFunctional
!%Type integer
!%Section Hamiltonian::XC
!%Description
!% Defines the exchange and correlation functionals to be used,
!% specified as a sum of an exchange functional and a
!% correlation functional, or a single exchange-correlation functional
!% (<i>e.g.</i> <tt>hyb_gga_xc_pbeh</tt>). For more information on the functionals, see
!% <a href=https://www.tddft.org/programs/libxc/functionals/libxc->
!% Libxc documentation</a>. The list provided here is from libxc ; if you have
!% linked against a different libxc version, you may have a somewhat different set
!% of available functionals. Note that kinetic-energy functionals are not supported.
!%
!% The default functional will be selected by Octopus to be consistent
!% with the pseudopotentials you are using. If you are not using
!% pseudopotentials, Octopus cannot determine the functional used to
!% generate the pseudopotential, or the pseudopotential functionals
!% are inconsistent, Octopus will use the following defaults:
!%
!% <br>1D: <tt>lda_x_1d_soft + lda_c_1d_csc</tt>
!% <br>2D: <tt>lda_x_2d + lda_c_2d_amgb</tt>
!% <br>3D: <tt>lda_x + lda_c_pz_mod</tt>
!%Option lda_x               1
!% Slater exchange
!%Option lda_c_wigner               2000
!% Wigner
!%Option lda_c_rpa               3000
!% Random Phase Approximation (RPA)
!%Option lda_c_hl               4000
!% Hedin & Lundqvist
!%Option lda_c_gl               5000
!% Gunnarson & Lundqvist
!%Option lda_c_xalpha               6000
!% Slater`s Xalpha
!%Option lda_c_vwn               7000
!% Vosko, Wilk & Nusair (VWN5)
!%Option lda_c_vwn_rpa               8000
!% Vosko, Wilk & Nusair (VWN5_RPA)
!%Option lda_c_pz               9000
!% Perdew & Zunger
!%Option lda_c_pz_mod               10000
!% Perdew & Zunger (Modified)
!%Option lda_c_ob_pz               11000
!% Ortiz & Ballone (PZ parametrization)
!%Option lda_c_pw               12000
!% Perdew & Wang
!%Option lda_c_pw_mod               13000
!% Perdew & Wang (modified)
!%Option lda_c_ob_pw               14000
!% Ortiz & Ballone (PW parametrization)
!%Option lda_c_2d_amgb               15000
!% AMGB (for 2D systems)
!%Option lda_c_2d_prm               16000
!% PRM (for 2D systems)
!%Option lda_c_vbh               17000
!% von Barth & Hedin
!%Option lda_c_1d_csc               18000
!% Casula, Sorella & Senatore
!%Option lda_x_2d               19
!% Slater exchange
!%Option lda_xc_teter93               20000
!% Teter 93
!%Option lda_x_1d_soft               21
!% Exchange in 1D for an soft-Coulomb interaction
!%Option lda_c_ml1               22000
!% Modified LSD (version 1) of Proynov and Salahub
!%Option lda_c_ml2               23000
!% Modified LSD (version 2) of Proynov and Salahub
!%Option lda_c_gombas               24000
!% Gombas
!%Option lda_c_pw_rpa               25000
!% Perdew & Wang (fit to the RPA energy)
!%Option lda_c_1d_loos               26000
!% P-F Loos correlation LDA
!%Option lda_c_rc04               27000
!% Ragot-Cortona
!%Option lda_c_vwn_1               28000
!% Vosko, Wilk & Nusair (VWN1)
!%Option lda_c_vwn_2               29000
!% Vosko, Wilk & Nusair (VWN2)
!%Option lda_c_vwn_3               30000
!% Vosko, Wilk & Nusair (VWN3)
!%Option lda_c_vwn_4               31000
!% Vosko, Wilk & Nusair (VWN4)
!%Option gga_x_gam               32
!% Minnesota GAM exhange functional
!%Option gga_c_gam               33000
!% Minnesota GAM correlation functional
!%Option gga_x_hcth_a               34
!% HCTH-A
!%Option gga_x_ev93               35
!% Engel and Vosko
!%Option hyb_mgga_x_dldf               36
!% Dispersionless Density Functional
!%Option mgga_c_dldf               37000
!% Dispersionless Density Functional
!%Option gga_x_bcgp               38
!% Burke, Cancio, Gould, and Pittalis
!%Option gga_c_acgga               39000
!% acGGA, asymptotically corrected GGA correlation
!%Option gga_x_lambda_oc2_n               40
!% lambda_OC2(N) version of PBE
!%Option gga_x_b86_r               41
!% Revised Becke 86 with modified gradient correction
!%Option mgga_xc_zlp               42000
!% Zhao, Levy & Parr, Eq. (21)
!%Option lda_xc_zlp               43000
!% Zhao, Levy & Parr, Eq. (20)
!%Option gga_x_lambda_ch_n               44
!% lambda_CH(N) version of PBE
!%Option gga_x_lambda_lo_n               45
!% lambda_LO(N) version of PBE
!%Option gga_x_hjs_b88_v2               46
!% HJS screened exchange B88 corrected version
!%Option gga_c_q2d               47000
!% Chiodo et al
!%Option gga_x_q2d               48
!% Chiodo et al
!%Option gga_x_pbe_mol               49
!% Reparametrized PBE by del Campo, Gazquez, Trickey & Vela
!%Option gga_x_ak13               56
!% Armiento & Kuemmel 2013
!%Option gga_x_lv_rpw86               58
!% Berland and Hyldgaard
!%Option gga_x_pbe_tca               59
!% PBE revised by Tognetti et al
!%Option gga_x_pbeint               60
!% PBE for hybrid interfaces
!%Option gga_c_zpbeint               61000
!% spin-dependent gradient correction to PBEint
!%Option gga_c_pbeint               62000
!% PBE for hybrid interfaces
!%Option gga_c_zpbesol               63000
!% spin-dependent gradient correction to PBEsol
!%Option mgga_xc_otpss_d               64000
!% oTPSS-D functional of Goerigk and Grimme
!%Option gga_xc_opbe_d               65000
!% oPBE-D functional of Goerigk and Grimme
!%Option gga_xc_opwlyp_d               66000
!% oPWLYP-D functional of Goerigk and Grimme
!%Option gga_xc_oblyp_d               67000
!% oBLYP-D functional of Goerigk and Grimme
!%Option gga_x_vmt84_ge               68
!% VMT{8,4} with constraint satisfaction with mu = mu_GE
!%Option gga_x_vmt84_pbe               69
!% VMT{8,4} with constraint satisfaction with mu = mu_PBE
!%Option gga_x_vmt_ge               70
!% Vela, Medel, and Trickey with mu = mu_GE
!%Option gga_x_vmt_pbe               71
!% Vela, Medel, and Trickey with mu = mu_PBE
!%Option mgga_c_cs               72000
!% Colle and Salvetti
!%Option mgga_c_mn12_sx               73000
!% Minnesota MN12-SX correlation functional
!%Option mgga_c_mn12_l               74000
!% Minnesota MN12-L correlation functional
!%Option mgga_c_m11_l               75000
!% Minnesota M11-L correlation functional
!%Option mgga_c_m11               76000
!% Minnesota M11 correlation functional
!%Option mgga_c_m08_so               77000
!% Minnesota M08-SO correlation functional
!%Option mgga_c_m08_hx               78000
!% Minnesota M08 correlation functional
!%Option gga_c_n12_sx               79000
!% Minnesota N12-SX correlation functional
!%Option gga_c_n12               80000
!% Minnesota N12 correlation functional
!%Option hyb_gga_x_n12_sx               81
!% Minnesota N12-SX exchange functional
!%Option gga_x_n12               82
!% Minnesota N12 exchange functional
!%Option gga_c_regtpss               83000
!% regularized TPSS correlation
!%Option gga_c_op_xalpha               84000
!% one-parameter progressive functional (Xalpha version)
!%Option gga_c_op_g96               85000
!% one-parameter progressive functional (G96 version)
!%Option gga_c_op_pbe               86000
!% one-parameter progressive functional (PBE version)
!%Option gga_c_op_b88               87000
!% one-parameter progressive functional (B88 version)
!%Option gga_c_ft97               88000
!% Filatov & Thiel correlation
!%Option gga_c_spbe               89000
!% PBE correlation to be used with the SSB exchange
!%Option gga_x_ssb_sw               90
!% Swart, Sola and Bickelhaupt correction to PBE
!%Option gga_x_ssb               91
!% Swart, Sola and Bickelhaupt
!%Option gga_x_ssb_d               92
!% Swart, Sola and Bickelhaupt dispersion
!%Option gga_xc_hcth_407p               93000
!% HCTH/407+
!%Option gga_xc_hcth_p76               94000
!% HCTH p=7/6
!%Option gga_xc_hcth_p14               95000
!% HCTH p=1/4
!%Option gga_xc_b97_gga1               96000
!% Becke 97 GGA-1
!%Option gga_c_hcth_a               97000
!% HCTH-A
!%Option gga_x_bpccac               98
!% BPCCAC (GRAC for the energy)
!%Option gga_c_revtca               99000
!% Tognetti, Cortona, Adamo (revised)
!%Option gga_c_tca               100000
!% Tognetti, Cortona, Adamo
!%Option gga_x_pbe               101
!% Perdew, Burke & Ernzerhof
!%Option gga_x_pbe_r               102
!% Revised PBE from Zhang & Yang
!%Option gga_x_b86               103
!% Becke 86
!%Option gga_x_b86_mgc               105
!% Becke 86 with modified gradient correction
!%Option gga_x_b88               106
!% Becke 88
!%Option gga_x_g96               107
!% Gill 96
!%Option gga_x_pw86               108
!% Perdew & Wang 86
!%Option gga_x_pw91               109
!% Perdew & Wang 91
!%Option gga_x_optx               110
!% Handy & Cohen OPTX 01
!%Option gga_x_dk87_r1               111
!% dePristo & Kress 87 version R1
!%Option gga_x_dk87_r2               112
!% dePristo & Kress 87 version R2
!%Option gga_x_lg93               113
!% Lacks & Gordon 93
!%Option gga_x_ft97_a               114
!% Filatov & Thiel 97 (version A)
!%Option gga_x_ft97_b               115
!% Filatov & Thiel 97 (version B)
!%Option gga_x_pbe_sol               116
!% Perdew, Burke & Ernzerhof SOL
!%Option gga_x_rpbe               117
!% Hammer, Hansen, and Norskov
!%Option gga_x_wc               118
!% Wu & Cohen
!%Option gga_x_mpw91               119
!% mPW91 of Adamo & Barone
!%Option gga_x_am05               120
!% Armiento & Mattsson 05
!%Option gga_x_pbea               121
!% Madsen 07
!%Option gga_x_mpbe               122
!% Adamo & Barone modification to PBE
!%Option gga_x_xpbe               123
!% Extended PBE by Xu & Goddard III
!%Option gga_x_2d_b86_mgc               124
!% Becke 86 with modified gradient correction for 2D
!%Option gga_x_bayesian               125
!% Bayesian best fit for the enhancement factor
!%Option gga_x_pbe_jsjr               126
!% Reparametrized PBE by Pedroza, Silva & Capelle
!%Option gga_x_2d_b88               127
!% Becke 88 in 2D
!%Option gga_x_2d_b86               128
!% Becke 86 in 2D
!%Option gga_x_2d_pbe               129
!% Perdew, Burke & Ernzerhof in 2D
!%Option gga_c_pbe               130000
!% Perdew, Burke & Ernzerhof
!%Option gga_c_lyp               131000
!% Lee, Yang & Parr
!%Option gga_c_p86               132000
!% Perdew 86
!%Option gga_c_pbe_sol               133000
!% Perdew, Burke & Ernzerhof SOL
!%Option gga_c_pw91               134000
!% Perdew & Wang 91
!%Option gga_c_am05               135000
!% Armiento & Mattsson 05
!%Option gga_c_xpbe               136000
!% Extended PBE by Xu & Goddard III
!%Option gga_c_lm               137000
!% Langreth & Mehl
!%Option gga_c_pbe_jrgx               138000
!% Reparametrized PBE by Pedroza, Silva & Capelle
!%Option gga_x_optb88_vdw               139
!% opt-Becke 88 for vdW
!%Option gga_x_pbek1_vdw               140
!% Reparametrized PBE for vdW
!%Option gga_x_optpbe_vdw               141
!% Reparametrized PBE for vdW
!%Option gga_x_rge2               142
!% Regularized PBE
!%Option gga_c_rge2               143000
!% Regularized PBE
!%Option gga_x_rpw86               144
!% Refitted Perdew & Wang 86
!%Option gga_x_kt1               145
!% Exchange part of Keal and Tozer version 1
!%Option gga_xc_kt2               146000
!% Keal and Tozer, version 2
!%Option gga_c_wl               147000
!% Wilson & Levy
!%Option gga_c_wi               148000
!% Wilson & Ivanov
!%Option gga_x_mb88               149
!% Modified Becke 88 for proton transfer
!%Option gga_x_sogga               150
!% Second-order generalized gradient approximation
!%Option gga_x_sogga11               151
!% Second-order generalized gradient approximation 2011
!%Option gga_c_sogga11               152000
!% Second-order generalized gradient approximation 2011
!%Option gga_c_wi0               153000
!% Wilson & Ivanov initial version
!%Option gga_xc_th1               154000
!% Tozer and Handy v. 1
!%Option gga_xc_th2               155000
!% Tozer and Handy v. 2
!%Option gga_xc_th3               156000
!% Tozer and Handy v. 3
!%Option gga_xc_th4               157000
!% Tozer and Handy v. 4
!%Option gga_x_c09x               158
!% C09x to be used with the VdW of Rutgers-Chalmers
!%Option gga_c_sogga11_x               159000
!% To be used with HYB_GGA_X_SOGGA11_X
!%Option gga_x_lb               160
!% van Leeuwen & Baerends
!%Option gga_xc_hcth_93               161000
!% HCTH/93
!%Option gga_xc_hcth_120               162000
!% HCTH/120
!%Option gga_xc_hcth_147               163000
!% HCTH/147
!%Option gga_xc_hcth_407               164000
!% HCTH/407
!%Option gga_xc_edf1               165000
!% EDF1
!%Option gga_xc_xlyp               166000
!% XLYP
!%Option gga_xc_kt1               167000
!% Keal and Tozer, version 1
!%Option gga_x_lspbe               168
!% lsPBE, a PW91-like modification of PBE exchange
!%Option gga_x_lsrpbe               169
!% lsRPBE, a PW91-like modification of RPBE
!%Option gga_xc_b97_d               170000
!% Becke 97-D
!%Option gga_x_optb86b_vdw               171
!% Becke 86 reoptimized for use with vdW functional of Dion et al
!%Option mgga_c_revm11               172000
!% Revised Minnesota M11 correlation functional
!%Option gga_xc_pbe1w               173000
!% PBE1W
!%Option gga_xc_mpwlyp1w               174000
!% mPWLYP1w
!%Option gga_xc_pbelyp1w               175000
!% PBELYP1W
!%Option gga_c_acggap               176000
!% acGGA+, asymptotically corrected GGA correlation+
!%Option hyb_lda_xc_lda0               177000
!% LDA hybrid exchange (LDA0)
!%Option hyb_lda_xc_cam_lda0               178000
!% CAM version of LDA0
!%Option gga_x_b88_6311g               179
!% Becke 88 reoptimized with the 6-311G** basis set
!%Option gga_x_ncap               180
!% Nearly correct asymptotic potential
!%Option gga_xc_ncap               181000
!% NCAP exchange + P86 correlation
!%Option gga_x_lbm               182
!% van Leeuwen & Baerends modified
!%Option gga_x_ol2               183
!% Exchange form based on Ou-Yang and Levy v.2
!%Option gga_x_apbe               184
!% mu fixed from the semiclassical neutral atom
!%Option gga_c_apbe               186000
!% mu fixed from the semiclassical neutral atom
!%Option gga_x_htbs               191
!% Haas, Tran, Blaha, and Schwarz
!%Option gga_x_airy               192
!% Constantin et al based on the Airy gas
!%Option gga_x_lag               193
!% Local Airy Gas
!%Option gga_xc_mohlyp               194000
!% Functional for organometallic chemistry
!%Option gga_xc_mohlyp2               195000
!% Functional for barrier heights
!%Option gga_xc_th_fl               196000
!% Tozer and Handy v. FL
!%Option gga_xc_th_fc               197000
!% Tozer and Handy v. FC
!%Option gga_xc_th_fcfo               198000
!% Tozer and Handy v. FCFO
!%Option gga_xc_th_fco               199000
!% Tozer and Handy v. FCO
!%Option gga_c_optc               200000
!% Optimized correlation functional of Cohen and Handy
!%Option mgga_x_lta               201
!% Local tau approximation
!%Option mgga_x_tpss               202
!% Tao, Perdew, Staroverov & Scuseria
!%Option mgga_x_m06_l               203
!% Minnesota M06-L exchange functional
!%Option mgga_x_gvt4               204
!% GVT4 (X part of VSXC)
!%Option mgga_x_tau_hcth               205
!% tau-HCTH from Boese and Handy
!%Option mgga_x_br89               206
!% Becke-Roussel 89, gamma = 0.8
!%Option mgga_x_bj06               207
!% Becke & Johnson 06
!%Option mgga_x_tb09               208
!% Tran & Blaha 09
!%Option mgga_x_rpp09               209
!% Rasanen, Pittalis & Proetto 09
!%Option mgga_x_2d_prhg07               210
!% Pittalis-Rasanen-Helbig-Gross 2007
!%Option mgga_x_2d_prhg07_prp10               211
!% PRHG07 with Pittalis-Rasanen-Proetto 2010 correction
!%Option mgga_x_revtpss               212
!% revised Tao, Perdew, Staroverov & Scuseria
!%Option mgga_x_pkzb               213
!% Perdew, Kurth, Zupan, and Blaha
!%Option mgga_x_br89_1               214
!% Becke-Roussel 89, gamma = 1.0
!%Option gga_x_ecmv92               215
!% Engel, Chevary, Macdonald and Vosko
!%Option gga_c_pbe_vwn               216000
!% Perdew, Burke & Ernzerhof based on VWN correlation
!%Option gga_c_p86_ft               217000
!% Perdew 86 with more accurate value for ftilde
!%Option mgga_x_ms0               221
!% MS exchange of Sun, Xiao, and Ruzsinszky
!%Option mgga_x_ms1               222
!% MS1 exchange of Sun, et al
!%Option mgga_x_ms2               223
!% MS2 exchange of Sun, et al
!%Option hyb_mgga_x_ms2h               224
!% MS2 hybrid exchange of Sun, et al
!%Option mgga_x_th               225
!% Tsuneda and Hirao
!%Option mgga_x_m11_l               226
!% Minnesota M11-L exchange functional
!%Option mgga_x_mn12_l               227
!% Minnesota MN12-L exchange functional
!%Option mgga_x_ms2_rev               228
!% MS2 exchange of Sun, et al with revised value for c
!%Option mgga_xc_cc06               229000
!% Cancio and Chou 2006
!%Option mgga_x_mk00               230
!% Exchange for accurate virtual orbital energies
!%Option mgga_c_tpss               231000
!% Tao, Perdew, Staroverov & Scuseria
!%Option mgga_c_vsxc               232000
!% VSXC (correlation part)
!%Option mgga_c_m06_l               233000
!% Minnesota M06-L correlation functional
!%Option mgga_c_m06_hf               234000
!% Minnesota M06-HF correlation functional
!%Option mgga_c_m06               235000
!% Minnesota M06 correlation functional
!%Option mgga_c_m06_2x               236000
!% Minnesota M06-2X correlation functional
!%Option mgga_c_m05               237000
!% Minnesota M05 correlation functional
!%Option mgga_c_m05_2x               238000
!% Minnesota M05-2X correlation functional
!%Option mgga_c_pkzb               239000
!% Perdew, Kurth, Zupan, and Blaha
!%Option mgga_c_bc95               240000
!% Becke correlation 95
!%Option mgga_c_revtpss               241000
!% revised TPSS correlation
!%Option mgga_xc_tpsslyp1w               242000
!% TPSSLYP1W
!%Option mgga_x_mk00b               243
!% Exchange for accurate virtual orbital energies (v. B)
!%Option mgga_x_bloc               244
!% functional with balanced localization
!%Option mgga_x_modtpss               245
!% Modified Tao, Perdew, Staroverov & Scuseria
!%Option gga_c_pbeloc               246000
!% Semilocal dynamical correlation
!%Option mgga_c_tpssloc               247000
!% Semilocal dynamical correlation
!%Option hyb_mgga_x_mn12_sx               248
!% Minnesota MN12-SX hybrid exchange functional
!%Option mgga_x_mbeef               249
!% mBEEF exchange
!%Option mgga_x_mbeefvdw               250
!% mBEEF-vdW exchange
!%Option mgga_c_tm               251000
!% Tao and Mo 2016 correlation
!%Option gga_c_p86vwn               252000
!% Perdew 86 based on VWN5 correlation
!%Option gga_c_p86vwn_ft               253000
!% Perdew 86 based on VWN5 correlation, with more accurate value for ftilde
!%Option mgga_xc_b97m_v               254000
!% B97M-V exchange-correlation functional
!%Option gga_xc_vv10               255000
!% Vydrov and Van Voorhis
!%Option mgga_x_jk               256
!% Jemmer-Knowles meta-GGA exchange
!%Option mgga_x_mvs               257
!% MVS exchange of Sun, Perdew, and Ruzsinszky
!%Option gga_c_pbefe               258000
!% PBE for formation energies
!%Option lda_xc_ksdt               259000
!% Karasiev, Sjostrom, Dufty & Trickey
!%Option mgga_x_mn15_l               260
!% Minnesota MN15-L exchange functional
!%Option mgga_c_mn15_l               261000
!% Minnesota MN15-L correlation functional
!%Option gga_c_op_pw91               262000
!% one-parameter progressive functional (PW91 version)
!%Option mgga_x_scan               263
!% SCAN exchange of Sun, Ruzsinszky, and Perdew
!%Option hyb_mgga_x_scan0               264
!% SCAN hybrid exchange (SCAN0)
!%Option gga_x_pbefe               265
!% PBE for formation energies
!%Option hyb_gga_xc_b97_1p               266000
!% version of B97 by Cohen and Handy
!%Option mgga_c_scan               267000
!% SCAN correlation of Sun, Ruzsinszky, and Perdew
!%Option hyb_mgga_x_mn15               268
!% Minnesota MN15 hybrid exchange functional
!%Option mgga_c_mn15               269000
!% Minnesota MN15 correlation functional
!%Option gga_x_cap               270
!% Correct Asymptotic Potential
!%Option gga_x_eb88               271
!% Non-empirical (excogitated) B88 functional of Becke and Elliott
!%Option gga_c_pbe_mol               272000
!% Reparametrized PBE by del Campo, Gazquez, Trickey & Vela
!%Option hyb_gga_xc_pbe_mol0               273000
!% PBEmol0
!%Option hyb_gga_xc_pbe_sol0               274000
!% PBEsol0
!%Option hyb_gga_xc_pbeb0               275000
!% PBEbeta0
!%Option hyb_gga_xc_pbe_molb0               276000
!% PBEmolbeta0
!%Option hyb_mgga_x_bmk               279
!% Boese-Martin for kinetics
!%Option gga_c_bmk               280000
!% Boese-Martin correlation for kinetics
!%Option gga_c_tau_hcth               281000
!% correlation part of tau-hcth
!%Option hyb_mgga_x_tau_hcth               282
!% Hybrid version of tau-HCTH
!%Option gga_c_hyb_tau_hcth               283000
!% correlation part of hyb-tau-hcth
!%Option mgga_x_b00               284
!% Becke 2000
!%Option gga_x_beefvdw               285
!% BEEF-vdW exchange
!%Option gga_xc_beefvdw               286000
!% BEEF-vdW exchange-correlation
!%Option lda_c_chachiyo               287000
!% Chachiyo simple 2 parameter correlation
!%Option mgga_xc_hle17               288000
!% high local exchange 2017
!%Option lda_c_lp96               289000
!% Liu-Parr correlation
!%Option hyb_gga_xc_pbe50               290000
!% PBE50
!%Option gga_x_pbetrans               291
!% Gradient-regulated connection-based correction for the PBE exchange
!%Option mgga_c_scan_rvv10               292000
!% SCAN + rVV10 correlation
!%Option mgga_x_revm06_l               293
!% Minnesota revM06-L exchange functional
!%Option mgga_c_revm06_l               294000
!% Minnesota revM06-L correlation functional
!%Option hyb_mgga_x_m08_hx               295
!% Minnesota M08-HX hybrid exchange functional
!%Option hyb_mgga_x_m08_so               296
!% Minnesota M08-SO hybrid exchange functional
!%Option hyb_mgga_x_m11               297
!% Minnesota M11 hybrid exchange functional
!%Option gga_x_chachiyo               298
!% Chachiyo exchange
!%Option mgga_x_rtpss               299
!% TPSS for surface adsorption
!%Option mgga_x_ms2b               300
!% MS2beta exchange of Furness and Sun
!%Option mgga_x_ms2bs               301
!% MS2beta* exchange of Furness and Sun
!%Option mgga_x_mvsb               302
!% MVSbeta exchange by Furness and Sun
!%Option mgga_x_mvsbs               303
!% MVSbeta* exchange by Furness and Sun
!%Option hyb_mgga_x_revm11               304
!% Revised Minnesota M11 hybrid exchange functional
!%Option hyb_mgga_x_revm06               305
!% Revised Minnesota M06 hybrid exchange functional
!%Option mgga_c_revm06               306000
!% Revised Minnesota M06 correlation functional
!%Option lda_c_chachiyo_mod               307000
!% Chachiyo simple 2 parameter correlation with modified spin scaling
!%Option lda_c_karasiev_mod               308000
!% Karasiev reparameterization of Chachiyo
!%Option gga_c_chachiyo               309000
!% Chachiyo simple GGA correlation
!%Option hyb_mgga_x_m06_sx               310
!% Minnesota M06-SX short-range hybrid exchange functional
!%Option mgga_c_m06_sx               311000
!% Minnesota M06-SX correlation functional
!%Option gga_x_revssb_d               312
!% Revised Swart, Sola and Bickelhaupt dispersion
!%Option gga_c_ccdf               313000
!% ccDF: coupled-cluster motivated density functional
!%Option hyb_gga_xc_hflyp               314000
!% HF + LYP correlation
!%Option hyb_gga_xc_b3p86_nwchem               315000
!% B3P86, NWChem version
!%Option gga_x_pw91_mod               316
!% PW91, alternate version with more digits
!%Option lda_c_w20               317000
!% Xie, Wu, and Zhao interpolation ansatz without fitting parameters
!%Option lda_xc_corrksdt               318000
!% Corrected KSDT by Karasiev, Dufty and Trickey
!%Option mgga_x_ft98               319
!% Filatov and Thiel 1998 meta-GGA exchange
!%Option gga_x_pbe_mod               320
!% Perdew, Burke & Ernzerhof with less precise value for beta
!%Option gga_x_pbe_gaussian               321
!% Perdew, Burke & Ernzerhof with parameter values used in Gaussian
!%Option gga_c_pbe_gaussian               322000
!% Perdew, Burke & Ernzerhof with parameters from Gaussian
!%Option mgga_c_tpss_gaussian               323000
!% Tao, Perdew, Staroverov & Scuseria with parameters from Gaussian
!%Option gga_x_ncapr               324
!% Nearly correct asymptotic potential revised
!%Option hyb_gga_xc_relpbe0               325000
!% relPBE0 a.k.a. relPBE: PBE0 refitted for actinide compounds
!%Option mgga_x_eel               326
!% Exact exchange-like exchange of Aschebrock et al
!%Option gga_xc_b97_3c               327000
!% Becke 97-3c by Grimme et. al.
!%Option lda_c_epc17               328000
!% epc17(-1): electron-proton correlation 2017
!%Option lda_c_epc17_2               329000
!% epc17-2: electron-proton correlation 2017 for proton affinities
!%Option lda_c_epc18_1               330000
!% epc18-1: electron-proton correlation 2018
!%Option lda_c_epc18_2               331000
!% epc18-2: electron-proton correlation 2018 for proton affinities
!%Option gga_x_bkl1               338
!% Type-I band gap functional by Bhattacharjee, Koshi and Lee
!%Option gga_x_bkl2               339
!% Type-II band gap functional by Bhattacharjee, Koshi and Lee
!%Option hyb_mgga_x_cf22d               340
!% Minnesota CF22D hybrid exchange functional
!%Option mgga_c_cf22d               341000
!% Minnesota CF22D correlation functional
!%Option mgga_x_lak               342
!% Lebeda-Aschebrock-Kummel meta-GGA exchange
!%Option hyb_gga_xc_opb3lyp               386000
!% opB3LYP: B3LYP reoptimized in 6-311++G(2d,2p) basis set
!%Option mgga_c_cc               387000
!% Self-interaction corrected correlation functional by Schmidt et al
!%Option mgga_c_ccalda               388000
!% Iso-orbital corrected LDA correlation by Lebeda et al
!%Option hyb_mgga_xc_br3p86               389000
!% BR3P86 hybrid meta-GGA from Neumann and Handy
!%Option hyb_gga_xc_case21               390000
!% CASE21: Constrained And Smoothed semi-Empirical 2021 functional
!%Option mgga_c_rregtm               391000
!% Revised regTM correlation by Jana et al
!%Option hyb_gga_xc_pbe_2x               392000
!% PBE-2X: PBE0 with 56% exact exchange
!%Option hyb_gga_xc_pbe38               393000
!% PBE38: PBE0 with 3/8 = 37.5% exact exchange
!%Option hyb_gga_xc_b3lyp3               394000
!% B3LYP with VWN functional 3 instead of RPA
!%Option hyb_gga_xc_cam_o3lyp               395000
!% CAM-O3LYP
!%Option hyb_mgga_xc_tpss0               396000
!% TPSS0 with 25% exact exchange
!%Option mgga_c_b94               397000
!% Becke 1994 meta-GGA correlation
!%Option hyb_mgga_xc_b94_hyb               398000
!% Becke 1994 hybrid meta-GGA
!%Option hyb_gga_xc_wb97x_d3               399000
!% wB97X-D3 range-separated functional
!%Option hyb_gga_xc_lc_blyp               400000
!% LC version of BLYP
!%Option hyb_gga_xc_b3pw91               401000
!% The original (ACM, B3PW91) hybrid of Becke
!%Option hyb_gga_xc_b3lyp               402000
!% B3LYP
!%Option hyb_gga_xc_b3p86               403000
!% B3P86
!%Option hyb_gga_xc_o3lyp               404000
!% O3LYP
!%Option hyb_gga_xc_mpw1k               405000
!% mPW1K
!%Option hyb_gga_xc_pbeh               406000
!% PBEH (PBE0)
!%Option hyb_gga_xc_b97               407000
!% Becke 97
!%Option hyb_gga_xc_b97_1               408000
!% Becke 97-1
!%Option hyb_gga_xc_apf               409000
!% APF hybrid functional
!%Option hyb_gga_xc_b97_2               410000
!% Becke 97-2
!%Option hyb_gga_xc_x3lyp               411000
!% X3LYP
!%Option hyb_gga_xc_b1wc               412000
!% B1WC
!%Option hyb_gga_xc_b97_k               413000
!% Boese-Martin for Kinetics
!%Option hyb_gga_xc_b97_3               414000
!% Becke 97-3
!%Option hyb_gga_xc_mpw3pw               415000
!% MPW3PW of Adamo & Barone
!%Option hyb_gga_xc_b1lyp               416000
!% B1LYP
!%Option hyb_gga_xc_b1pw91               417000
!% B1PW91
!%Option hyb_gga_xc_mpw1pw               418000
!% mPW1PW
!%Option hyb_gga_xc_mpw3lyp               419000
!% MPW3LYP
!%Option hyb_gga_xc_sb98_1a               420000
!% SB98 (1a)
!%Option hyb_gga_xc_sb98_1b               421000
!% SB98 (1b)
!%Option hyb_gga_xc_sb98_1c               422000
!% SB98 (1c)
!%Option hyb_gga_xc_sb98_2a               423000
!% SB98 (2a)
!%Option hyb_gga_xc_sb98_2b               424000
!% SB98 (2b)
!%Option hyb_gga_xc_sb98_2c               425000
!% SB98 (2c)
!%Option hyb_gga_x_sogga11_x               426
!% Hybrid based on SOGGA11 form
!%Option hyb_gga_xc_hse03               427000
!% HSE03
!%Option hyb_gga_xc_hse06               428000
!% HSE06
!%Option hyb_gga_xc_hjs_pbe               429000
!% HJS hybrid screened exchange PBE version
!%Option hyb_gga_xc_hjs_pbe_sol               430000
!% HJS hybrid screened exchange PBE_SOL version
!%Option hyb_gga_xc_hjs_b88               431000
!% HJS hybrid screened exchange B88 version
!%Option hyb_gga_xc_hjs_b97x               432000
!% HJS hybrid screened exchange B97x version
!%Option hyb_gga_xc_cam_b3lyp               433000
!% CAM version of B3LYP
!%Option hyb_gga_xc_tuned_cam_b3lyp               434000
!% CAM version of B3LYP, tuned for excitations and properties
!%Option hyb_gga_xc_bhandh               435000
!% BHandH i.e. BHLYP
!%Option hyb_gga_xc_bhandhlyp               436000
!% BHandHLYP
!%Option hyb_gga_xc_mb3lyp_rc04               437000
!% B3LYP with RC04 LDA
!%Option hyb_mgga_x_m05               438
!% Minnesota M05 hybrid exchange functional
!%Option hyb_mgga_x_m05_2x               439
!% Minnesota M05-2X hybrid exchange functional
!%Option hyb_mgga_xc_b88b95               440000
!% Mixture of B88 with BC95 (B1B95)
!%Option hyb_mgga_xc_b86b95               441000
!% Mixture of B86 with BC95
!%Option hyb_mgga_xc_pw86b95               442000
!% Mixture of PW86 with BC95
!%Option hyb_mgga_xc_bb1k               443000
!% Mixture of B88 with BC95 from Zhao and Truhlar
!%Option hyb_mgga_x_m06_hf               444
!% Minnesota M06-HF hybrid exchange functional
!%Option hyb_mgga_xc_mpw1b95               445000
!% Mixture of mPW91 with BC95 from Zhao and Truhlar
!%Option hyb_mgga_xc_mpwb1k               446000
!% Mixture of mPW91 with BC95 for kinetics
!%Option hyb_mgga_xc_x1b95               447000
!% Mixture of X with BC95
!%Option hyb_mgga_xc_xb1k               448000
!% Mixture of X with BC95 for kinetics
!%Option hyb_mgga_x_m06               449
!% Minnesota M06 hybrid exchange functional
!%Option hyb_mgga_x_m06_2x               450
!% Minnesota M06-2X hybrid exchange functional
!%Option hyb_mgga_xc_pw6b95               451000
!% Mixture of PW91 with BC95 from Zhao and Truhlar
!%Option hyb_mgga_xc_pwb6k               452000
!% Mixture of PW91 with BC95 from Zhao and Truhlar for kinetics
!%Option hyb_gga_xc_mpwlyp1m               453000
!% MPW with 1 par. for metals/LYP
!%Option hyb_gga_xc_revb3lyp               454000
!% Revised B3LYP
!%Option hyb_gga_xc_camy_blyp               455000
!% CAMY version of BLYP
!%Option hyb_gga_xc_pbe0_13               456000
!% PBE0-1/3
!%Option hyb_mgga_xc_tpssh               457000
!% TPSSh
!%Option hyb_mgga_xc_revtpssh               458000
!% revTPSSh
!%Option hyb_gga_xc_b3lyps               459000
!% B3LYP*
!%Option hyb_gga_xc_qtp17               460000
!% Global hybrid for vertical ionization potentials
!%Option hyb_gga_xc_b3lyp_mcm1               461000
!% B3LYP-MCM1
!%Option hyb_gga_xc_b3lyp_mcm2               462000
!% B3LYP-MCM2
!%Option hyb_gga_xc_wb97               463000
!% wB97 range-separated functional
!%Option hyb_gga_xc_wb97x               464000
!% wB97X range-separated functional
!%Option hyb_gga_xc_lrc_wpbeh               465000
!% Long-range corrected short-range hybrid PBE (LRC-wPBEh) by Rohrdanz, Martins and Herbert
!%Option hyb_gga_xc_wb97x_v               466000
!% wB97X-V range-separated functional
!%Option hyb_gga_xc_lcy_pbe               467000
!% LCY version of PBE
!%Option hyb_gga_xc_lcy_blyp               468000
!% LCY version of BLYP
!%Option hyb_gga_xc_lc_vv10               469000
!% Vydrov and Van Voorhis
!%Option hyb_gga_xc_camy_b3lyp               470000
!% CAMY version of B3LYP
!%Option hyb_gga_xc_wb97x_d               471000
!% wB97X-D range-separated functional
!%Option hyb_gga_xc_hpbeint               472000
!% hPBEint
!%Option hyb_gga_xc_lrc_wpbe               473000
!% Long-range corrected PBE (LRC-wPBE) by Rohrdanz, Martins and Herbert
!%Option hyb_mgga_x_mvsh               474
!% MVSh hybrid exchange functional
!%Option hyb_gga_xc_b3lyp5               475000
!% B3LYP with VWN functional 5 instead of RPA
!%Option hyb_gga_xc_edf2               476000
!% EDF2
!%Option hyb_gga_xc_cap0               477000
!% Correct Asymptotic Potential hybrid
!%Option hyb_gga_xc_lc_wpbe               478000
!% Long-range corrected PBE (LC-wPBE) by Vydrov and Scuseria
!%Option hyb_gga_xc_hse12               479000
!% HSE12
!%Option hyb_gga_xc_hse12s               480000
!% HSE12 (short-range version)
!%Option hyb_gga_xc_hse_sol               481000
!% HSEsol
!%Option hyb_gga_xc_cam_qtp_01               482000
!% CAM-B3LYP retuned using ionization potentials of water
!%Option hyb_gga_xc_mpw1lyp               483000
!% mPW1LYP
!%Option hyb_gga_xc_mpw1pbe               484000
!% mPW1PBE
!%Option hyb_gga_xc_kmlyp               485000
!% Kang-Musgrave hybrid
!%Option hyb_gga_xc_lc_wpbe_whs               486000
!% Long-range corrected PBE (LC-wPBE) by Weintraub, Henderson and Scuseria
!%Option hyb_gga_xc_lc_wpbeh_whs               487000
!% Long-range corrected short-range hybrid PBE (LC-wPBE) by Weintraub, Henderson and Scuseria
!%Option hyb_gga_xc_lc_wpbe08_whs               488000
!% Long-range corrected PBE (LC-wPBE) by Weintraub, Henderson and Scuseria
!%Option hyb_gga_xc_lc_wpbesol_whs               489000
!% Long-range corrected PBE (LC-wPBE) by Weintraub, Henderson and Scuseria
!%Option hyb_gga_xc_cam_qtp_00               490000
!% CAM-B3LYP retuned using ionization potentials of water
!%Option hyb_gga_xc_cam_qtp_02               491000
!% CAM-B3LYP retuned using ionization potentials of water
!%Option hyb_gga_xc_lc_qtp               492000
!% CAM-B3LYP retuned using ionization potentials of water
!%Option mgga_x_rscan               493
!% Regularized SCAN exchange by Bartok and Yates
!%Option mgga_c_rscan               494000
!% Regularized SCAN correlation by Bartok and Yates
!%Option gga_x_s12g               495
!% Swart 2012 GGA exchange
!%Option hyb_gga_x_s12h               496
!% Swart 2012 hybrid GGA exchange
!%Option mgga_x_r2scan               497
!% Re-regularized SCAN exchange by Furness et al
!%Option mgga_c_r2scan               498000
!% Re-regularized SCAN correlation by Furness et al
!%Option hyb_gga_xc_blyp35               499000
!% BLYP35
!%Option gga_x_wpbeh               524
!% short-range part of the PBE (default w=0 gives PBEh)
!%Option gga_x_hjs_pbe               525
!% HJS screened exchange PBE version
!%Option gga_x_hjs_pbe_sol               526
!% HJS screened exchange PBE_SOL version
!%Option gga_x_hjs_b88               527
!% HJS screened exchange B88 version
!%Option gga_x_hjs_b97x               528
!% HJS screened exchange B97x version
!%Option gga_x_ityh               529
!% Short-range recipe for B88 functional - erf
!%Option gga_x_sfat               530
!% Short-range recipe for B88 functional - Yukawa
!%Option hyb_mgga_xc_wb97m_v               531000
!% wB97M-V exchange-correlation functional
!%Option lda_x_rel               532
!% Slater exchange with relativistic corrections
!%Option gga_x_sg4               533
!% Semiclassical GGA at fourth order
!%Option gga_c_sg4               534000
!% Semiclassical GGA at fourth order
!%Option gga_x_gg99               535
!% Gilbert and Gill 1999
!%Option lda_xc_1d_ehwlrg_1               536000
!% LDA constructed from slab-like systems of 1 electron
!%Option lda_xc_1d_ehwlrg_2               537000
!% LDA constructed from slab-like systems of 2 electrons
!%Option lda_xc_1d_ehwlrg_3               538000
!% LDA constructed from slab-like systems of 3 electrons
!%Option gga_x_pbepow               539
!% PBE power
!%Option mgga_x_tm               540
!% Tao and Mo 2016 exchange
!%Option mgga_x_vt84               541
!% meta-GGA version of VT{8,4} GGA
!%Option mgga_x_sa_tpss               542
!% TPSS with correct surface asymptotics
!%Option gga_x_kgg99               544
!% Gilbert and Gill 1999 (mixed)
!%Option gga_xc_hle16               545000
!% high local exchange 2016
!%Option lda_x_erf               546
!% Short-range LDA exchange with error function kernel (erfc)
!%Option lda_xc_lp_a               547000
!% Lee-Parr reparametrization A
!%Option lda_xc_lp_b               548000
!% Lee-Parr reparametrization B
!%Option lda_x_rae               549
!% Rae self-energy corrected exchange
!%Option lda_c_mcweeny               551000
!% McWeeny 76
!%Option lda_c_br78               552000
!% Brual & Rothstein 78
!%Option gga_c_scan_e0               553000
!% GGA component of SCAN
!%Option lda_c_pk09               554000
!% Proynov and Kong 2009
!%Option gga_c_gapc               555000
!% GapC
!%Option gga_c_gaploc               556000
!% Gaploc
!%Option gga_c_zvpbeint               557000
!% another spin-dependent correction to PBEint
!%Option gga_c_zvpbesol               558000
!% another spin-dependent correction to PBEsol
!%Option gga_c_tm_lyp               559000
!% Takkar and McCarthy reparametrization, also known as reLYP
!%Option gga_c_tm_pbe               560000
!% Thakkar and McCarthy reparametrization
!%Option gga_c_w94               561000
!% Wilson 94 (Eq. 25)
!%Option mgga_c_kcis               562000
!% Krieger, Chen, Iafrate, and Savin
!%Option hyb_mgga_xc_b0kcis               563000
!% Hybrid based on KCIS
!%Option mgga_xc_lp90               564000
!% Lee & Parr, Eq. (56)
!%Option gga_c_cs1               565000
!% A dynamical correlation functional
!%Option hyb_mgga_xc_mpw1kcis               566000
!% MPW1KCIS for barrier heights
!%Option hyb_mgga_xc_mpwkcis1k               567000
!% MPWKCIS1K for barrier heights
!%Option hyb_mgga_xc_pbe1kcis               568000
!% PBE1KCIS for binding energies
!%Option hyb_mgga_xc_tpss1kcis               569000
!% TPSS1KCIS for thermochemistry and kinetics
!%Option gga_x_b88m               570
!% Becke 88 reoptimized to be used with tau1
!%Option mgga_c_b88               571000
!% Meta-GGA correlation by Becke
!%Option hyb_gga_xc_b5050lyp               572000
!% B5050LYP
!%Option lda_c_ow_lyp               573000
!% Wigner with corresponding LYP parameters
!%Option lda_c_ow               574000
!% Optimized Wigner
!%Option mgga_x_gx               575
!% GX functional of Loos
!%Option mgga_x_pbe_gx               576
!% PBE-GX functional of Loos
!%Option lda_xc_gdsmfb               577000
!% Groth, Dornheim, Sjostrom, Malone, Foulkes, Bonitz
!%Option lda_c_gk72               578000
!% Gordon and Kim 1972
!%Option lda_c_karasiev               579000
!% Karasiev reparameterization of Chachiyo
!%Option mgga_x_revscan               581
!% revised SCAN
!%Option mgga_c_revscan               582000
!% revised SCAN
!%Option hyb_mgga_x_revscan0               583
!% revised SCAN hybrid exchange (SCAN0)
!%Option mgga_c_scan_vv10               584000
!% SCAN + VV10 correlation
!%Option mgga_c_revscan_vv10               585000
!% REVSCAN + VV10 correlation
!%Option mgga_x_br89_explicit               586
!% Becke-Roussel 89 with an explicit inversion of x(y), gamma = 0.8
!%Option gga_xc_kt3               587000
!% Keal and Tozer, version 3
!%Option hyb_lda_xc_bn05               588000
!% Baer and Neuhauser, gamma=1
!%Option hyb_gga_xc_lb07               589000
!% Livshits and Baer, empirical functional also used for IP tuning
!%Option lda_c_pmgb06               590000
!% Long-range LDA correlation functional
!%Option hyb_mgga_xc_b98               598000
!% Becke 98
!%Option lda_xc_tih               599000
!% Neural network LDA from Tozer et al
!%Option lda_x_1d_exponential               600
!% Exchange in 1D for an exponentially screened interaction
!%Option gga_x_sfat_pbe               601
!% Short-range recipe for PBE functional - Yukawa
!%Option mgga_x_br89_explicit_1               602
!% Becke-Roussel 89 with an explicit inversion of x(y), gamma = 1.0
!%Option mgga_x_regtpss               603
!% Regularized TPSS
!%Option gga_x_fd_lb94               604
!% Functional derivative recovered from the stray LB94 potential
!%Option gga_x_fd_revlb94               605
!% Revised FD_LB94
!%Option gga_c_zvpbeloc               606000
!% PBEloc variation with enhanced compatibility with exact exchange
!%Option hyb_gga_xc_apbe0               607000
!% Hybrid based on APBE
!%Option hyb_gga_xc_hapbe               608000
!% Hybrid based in APBE and zvPBEloc
!%Option mgga_x_2d_js17               609
!% JS17 meta-GGA for 2D
!%Option hyb_gga_xc_rcam_b3lyp               610000
!% Similar to CAM-B3LYP, but trying to reduce the many-electron self-interaction
!%Option hyb_gga_xc_wc04               611000
!% hybrid fitted to carbon NMR shifts
!%Option hyb_gga_xc_wp04               612000
!% hybrid fitted to proton NMR shifts
!%Option hyb_gga_xc_camh_b3lyp               614000
!% CAM version of B3LYP, tuned for TDDFT
!%Option hyb_gga_xc_whpbe0               615000
!% Long-range corrected short-range hybrid PBE (whPBE0) by Shao et al
!%Option gga_x_ityh_optx               622
!% Short-range recipe for OPTX functional
!%Option gga_x_ityh_pbe               623
!% Short-range recipe for PBE functional
!%Option gga_c_lypr               624000
!% Short-range LYP by Ai, Fang, and Su
!%Option hyb_gga_xc_lc_blyp_ea               625000
!% LC version of BLYP for electron affinities
!%Option mgga_x_regtm               626
!% Regularized Tao and Mo exchange
!%Option hyb_gga_xc_lc_bop               636000
!% LC version of B88
!%Option hyb_gga_xc_lc_pbeop               637000
!% LC version of PBE
!%Option mgga_c_kcisk               638000
!% Krieger, Chen, and Kurth
!%Option hyb_gga_xc_lc_blypr               639000
!% LC version of BLYP with correlation only in the short range
!%Option hyb_gga_xc_mcam_b3lyp               640000
!% Modified CAM-B3LYP by Day, Nguyen and Pachter
!%Option lda_x_yukawa               641
!% Short-range LDA exchange with Yukawa attenuation
!%Option mgga_c_r2scan01               642000
!% Re-regularized SCAN correlation with larger value for eta
!%Option mgga_c_rmggac               643000
!% Revised correlation energy for MGGAC exchange functional
!%Option mgga_x_mcml               644
!% MCML exchange
!%Option mgga_x_r2scan01               645
!% Re-regularized SCAN exchange by Furness et al with larger value for eta
!%Option hyb_gga_x_cam_s12g               646
!% Swart 2012 range-separated hybrid GGA exchange
!%Option hyb_gga_x_cam_s12h               647
!% Swart 2012 range-separated hybrid GGA exchange
!%Option mgga_x_rppscan               648
!% r++SCAN: rSCAN with uniform density limit and coordinate scaling behavior
!%Option mgga_c_rppscan               649000
!% r++SCAN: rSCAN with uniform density limit and coordinate scaling behavior
!%Option mgga_x_r4scan               650
!% r$^{4}$SCAN, a functional that satisfies the same exact constraints that SCAN does
!%Option mgga_x_vcml               651
!% Exchange part of VCML-rVV10 by Trepte and Voss
!%Option mgga_xc_vcml_rvv10               652000
!% VCML-rVV10 by Trepte and Voss
!%Option hyb_lda_x_erf               653
!% Long-range corrected functional based on short-range LDA exchange (erfc)
!%Option lda_c_pw_erf               654000
!% Short ranged correlation LDA (erfc)
!%Option gga_x_pbe_erf_gws               655
!% Short ranged PBE exchange (erfc)
!%Option hyb_gga_x_pbe_erf_gws               656
!% Short-range PBE (GWS) exchange (erfc) + long-range exact exchange
!%Option gga_c_pbe_erf_gws               657000
!% Short ranged PBE correlation (erfc)
!%Option hyb_mgga_xc_gas22               658000
!% Google Accelerated Science 22
!%Option hyb_mgga_xc_r2scanh               659000
!% r2SCANh: r2SCAN hybrid like TPSSh with 10% exact exchange
!%Option hyb_mgga_xc_r2scan0               660000
!% r2SCAN0: r2SCAN hybrid like PBE0 with 25% exact exchange
!%Option hyb_mgga_xc_r2scan50               661000
!% r2SCAN50: r2SCAN hybrid like PBE50 with 50% exact exchange
!%Option hyb_gga_xc_cam_pbeh               681000
!% CAM hybrid screened exchange PBE version
!%Option hyb_gga_xc_camy_pbeh               682000
!% CAMY hybrid screened exchange PBE version
!%Option lda_c_upw92               683000
!% Ruggeri, Rios, and Alavi unrestricted fit
!%Option lda_c_rpw92               684000
!% Ruggeri, Rios, and Alavi restricted fit
!%Option mgga_x_tlda               685
!% LDA-type exchange with tau-dependent potential
!%Option mgga_x_edmgga               686
!% Tao 2001
!%Option mgga_x_gdme_nv               687
!% Generalized density-matrix with a=1/2
!%Option mgga_x_rlda               688
!% Reparametrized local-density approximation
!%Option mgga_x_gdme_0               689
!% Generalized density-matrix with a=0
!%Option mgga_x_gdme_kos               690
!% Generalized density-matrix with a=0.00638
!%Option mgga_x_gdme_vt               691
!% Varied-terms (VT) mGGA of Koehl, Odom, and Scuseria
!%Option lda_x_sloc               692
!% simple local model for Slater potential
!%Option mgga_x_revtm               693
!% revised Tao and Mo 2016 exchange
!%Option mgga_c_revtm               694000
!% revised Tao and Mo 2016 exchange
!%Option hyb_mgga_xc_edmggah               695000
!% EDMGGA hybrid
!%Option mgga_x_mbrxc_bg               696
!% Modified Becke-Roussel for band gaps - cuspless hole
!%Option mgga_x_mbrxh_bg               697
!% Modified Becke-Roussel for band gaps - hydrogen hole
!%Option mgga_x_hlta               698
!% Half-and-half meta-LDAized LDA exchange by Lehtola and Marques
!%Option mgga_c_hltapw               699000
!% Half-and-half meta-LDAized PW correlation by Lehtola and Marques
!%Option mgga_x_scanl               700
!% Deorbitalized SCAN (SCAN-L) exchange
!%Option mgga_x_revscanl               701
!% Deorbitalized revised SCAN (revSCAN-L) exchange
!%Option mgga_c_scanl               702000
!% Deorbitalized SCAN (SCAN-L) correlation
!%Option mgga_c_scanl_rvv10               703000
!% SCAN-L + rVV10 correlation
!%Option mgga_c_scanl_vv10               704000
!% SCAN-L + VV10 correlation
!%Option hyb_mgga_x_js18               705
!% Jana and Samal 2018, screened range-separated TM exchange
!%Option hyb_mgga_x_pjs18               706
!% Patra, Jana and Samal 2018, screened range-separated TM exchange
!%Option mgga_x_task               707
!% TASK exchange of Aschebrock and Kuemmel
!%Option mgga_x_mggac               711
!% MGGAC exchange of Patra et al
!%Option gga_c_mggac               712000
!% beta fitted to LC20 to be used with MGGAC
!%Option mgga_x_mbr               716
!% modified Becke-Roussel by Patra et al
!%Option mgga_x_r2scanl               718
!% Deorbitalized re-regularized SCAN (r2SCAN-L) exchange
!%Option mgga_c_r2scanl               719000
!% Deorbitalized re-regularized SCAN (r2SCAN-L) correlation
!%Option hyb_mgga_xc_lc_tmlyp               720000
!% Long-range corrected TM-LYP by Jana et al
!%Option mgga_x_mtask               724
!% modified TASK exchange
!%Option gga_x_q1d               734
!% Functional for quasi-1D systems
!%Option mgga_x_ktbm_0               735
!% KTBM learned exchange - 0
!%Option mgga_x_ktbm_1               736
!% KTBM learned exchange - 1
!%Option mgga_x_ktbm_2               737
!% KTBM learned exchange - 2
!%Option mgga_x_ktbm_3               738
!% KTBM learned exchange - 3
!%Option mgga_x_ktbm_4               739
!% KTBM learned exchange - 4
!%Option mgga_x_ktbm_5               740
!% KTBM learned exchange - 5
!%Option mgga_x_ktbm_6               741
!% KTBM learned exchange - 6
!%Option mgga_x_ktbm_7               742
!% KTBM learned exchange - 7
!%Option mgga_x_ktbm_8               743
!% KTBM learned exchange - 8
!%Option mgga_x_ktbm_9               744
!% KTBM learned exchange - 9
!%Option mgga_x_ktbm_10               745
!% KTBM learned exchange - 10
!%Option mgga_x_ktbm_11               746
!% KTBM learned exchange - 11
!%Option mgga_x_ktbm_12               747
!% KTBM learned exchange - 12
!%Option mgga_x_ktbm_13               748
!% KTBM learned exchange - 13
!%Option mgga_x_ktbm_14               749
!% KTBM learned exchange - 14
!%Option mgga_x_ktbm_15               750
!% KTBM learned exchange - 15
!%Option mgga_x_ktbm_16               751
!% KTBM learned exchange - 16
!%Option mgga_x_ktbm_17               752
!% KTBM learned exchange - 17
!%Option mgga_x_ktbm_18               753
!% KTBM learned exchange - 18
!%Option mgga_x_ktbm_19               754
!% KTBM learned exchange - 19
!%Option mgga_x_ktbm_20               755
!% KTBM learned exchange - 20
!%Option mgga_x_ktbm_21               756
!% KTBM learned exchange - 21
!%Option mgga_x_ktbm_22               757
!% KTBM learned exchange - 22
!%Option mgga_x_ktbm_23               758
!% KTBM learned exchange - 23
!%Option mgga_x_ktbm_24               759
!% KTBM learned exchange - 24
!%Option mgga_x_ktbm_gap               760
!% KTBM learned exchange - GAP
!%Option mgga_x_mspbel               761
!% MS-PBEl, a PBE-like meta-GGA exchange
!%Option mgga_x_rmspbel               762
!% regularized MS-PBEl
!%Option mgga_x_msrpbel               763
!% MS-RPBEl, a RPBE-like meta-GGA exchange
!%Option mgga_x_rmsrpbel               764
!% regularized MS-RPBEl
!%Option mgga_x_msb86bl               765
!% MS-B86bl, a B86b-like meta-GGA exchange
!%Option mgga_x_rmsb86bl               766
!% regularized MS-B86bl
!%Option oep_x                    901
!% OEP: Exact exchange (not from libxc).
!%Option slater_x                 902
!% Slater approximation to the exact exchange (not from libxc).
!%Option fbe_x                    903
!% Exchange functional based on the force balance equation (not from libxc).
!%Option ks_inversion             904
!% Inversion of KS potential (not from libxc).
!%Option rdmft_xc_m               905
!% RDMFT Mueller functional (not from libxc).
!%Option fbe_x_sl                 906
!% Exchange functional based on the force balance equation. Sturm-Liouville version (not from libxc).
!%Option lda_c_fbe                907000
!% Force-based local-density correlation functional (not from libxc)
!%Option lda_c_fbe_sl             908000
!% Force-based local-density correlation functional. Sturm-Liouville version (not from libxc)
!%Option hyb_gga_xc_mvorb_hse06   921000
!% Density-based mixing parameter of HSE06 (not from libxc).
!%Option hyb_gga_xc_mvorb_pbeh    922000
!% Density-based mixing parameter of PBEH (not from libxc).
!% At the moment this is not supported for libxc >= 4.0.
!%Option mgga_x_nc_br          923
!% Noncollinear version of the Becke-Roussel function (not from libxc).
!%Option mgga_x_nc_br_1        924
!% Noncollinear version of the Becke-Roussel function with gamma=1 (not from libxc).
!%Option mgga_c_nc_cs          925000
!% Noncollinear version of the Colle-Savetti correlation functional (not from libxc).
!%Option mgga_x_nc_br_explicit 926
!% Noncollinear version of the Becke-Roussel function with an explicit inversion of x(y), gamma = 0.8.
!%Option vdw_c_vdwdf      918000
!% van der Waals density functional vdW-DF correlation from libvdwxc (not from libxc).  Use with gga_x_pbe_r.
!%Option vdw_c_vdwdf2     919000
!% van der Waals density functional vdW-DF2 correlation from libvdwxc (not from libxc).  Use with gga_x_rpw86.
!%Option vdw_c_vdwdfcx    920000
!% van der Waals density functional vdW-DF-cx correlation from libvdwxc (not from libxc).  Use with gga_x_lv_rpw86.
!%Option none                       0
!% Exchange and correlation set to zero (not from libxc).
!%End
