# Chapter 1: Introduction {#tutorial_introduction}

Throughout this tutorial you will learn about Wayland, Louvre's API, and master its features to create your own compositor.\n
While prior knowledge of Wayland and some basic experience in C++ are beneficial, explanations will be provided for each concept as necessary.\n
By the end of this tutorial, you will have developed a 2D compositor that closely resembles the one shown in the image below:

<img src="https://lh3.googleusercontent.com/pw/ADCreHfr83RGTD9to6OLt-ohbjFw4bYgJJS9H8UunucxoCBwB5_m8nHOV_LXzIWObyhAk3xGLPpFfLS2YTiRTiTOFD2QdhyQYPm8KtJvb6VQlhHhgexhA1M=w2400"/>

This compositor will have the capability to drive multiple displays, move and scale windows interactively using the pointer, transmit keyboard events to them, and alter their states to maximize, go fullscreen, or minimize them to a top bar.

> The final result after completing the entire tutorial can be found [here](https://github.com/CuarzoSoftware/LouvreTutorial), but it is recommended to manually go through the steps to learn and become familiar with the API properly.

# Before Proceeding

Before you start, please ensure that you have correctly installed both Louvre and [weston-terminal](https://gitlab.freedesktop.org/wayland/weston). You can find detailed installation instructions in the [Downloads](md_md__downloads.html) section.\n
Additionally, for a seamless experience, it is recommended to work from a relatively recent Linux distribution with an X11 desktop environment to prevent conflicts between compositors and applications.

If you are currently using a Wayland desktop, please consult the [Environment](md_md__environment.html) section for guidance on configuring the **LOUVRE_WAYLAND_DISPLAY** and **WAYLAND_DISPLAY** environment variables properly.

<a href="02.md"> Chapter 2: Quick Overview ▶</a>