/* Generated by wayland-scanner 1.20.0 */

#ifndef TEARING_CONTROL_V1_SERVER_PROTOCOL_H
#define TEARING_CONTROL_V1_SERVER_PROTOCOL_H

#include <stdint.h>
#include <stddef.h>
#include "wayland-server.h"

#ifdef  __cplusplus
extern "C" {
#endif

struct wl_client;
struct wl_resource;

/**
 * @page page_tearing_control_v1 The tearing_control_v1 protocol
 * @section page_ifaces_tearing_control_v1 Interfaces
 * - @subpage page_iface_wp_tearing_control_manager_v1 - protocol for tearing control
 * - @subpage page_iface_wp_tearing_control_v1 - per-surface tearing control interface
 * @section page_copyright_tearing_control_v1 Copyright
 * <pre>
 *
 * Copyright © 2021 Xaver Hugl
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice (including the next
 * paragraph) shall be included in all copies or substantial portions of the
 * Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 * </pre>
 */
struct wl_surface;
struct wp_tearing_control_manager_v1;
struct wp_tearing_control_v1;

#ifndef WP_TEARING_CONTROL_MANAGER_V1_INTERFACE
#define WP_TEARING_CONTROL_MANAGER_V1_INTERFACE
/**
 * @page page_iface_wp_tearing_control_manager_v1 wp_tearing_control_manager_v1
 * @section page_iface_wp_tearing_control_manager_v1_desc Description
 *
 * For some use cases like games or drawing tablets it can make sense to
 * reduce latency by accepting tearing with the use of asynchronous page
 * flips. This global is a factory interface, allowing clients to inform
 * which type of presentation the content of their surfaces is suitable for.
 *
 * Graphics APIs like EGL or Vulkan, that manage the buffer queue and commits
 * of a wl_surface themselves, are likely to be using this extension
 * internally. If a client is using such an API for a wl_surface, it should
 * not directly use this extension on that surface, to avoid raising a
 * tearing_control_exists protocol error.
 *
 * Warning! The protocol described in this file is currently in the testing
 * phase. Backward compatible changes may be added together with the
 * corresponding interface version bump. Backward incompatible changes can
 * only be done by creating a new major version of the extension.
 * @section page_iface_wp_tearing_control_manager_v1_api API
 * See @ref iface_wp_tearing_control_manager_v1.
 */
/**
 * @defgroup iface_wp_tearing_control_manager_v1 The wp_tearing_control_manager_v1 interface
 *
 * For some use cases like games or drawing tablets it can make sense to
 * reduce latency by accepting tearing with the use of asynchronous page
 * flips. This global is a factory interface, allowing clients to inform
 * which type of presentation the content of their surfaces is suitable for.
 *
 * Graphics APIs like EGL or Vulkan, that manage the buffer queue and commits
 * of a wl_surface themselves, are likely to be using this extension
 * internally. If a client is using such an API for a wl_surface, it should
 * not directly use this extension on that surface, to avoid raising a
 * tearing_control_exists protocol error.
 *
 * Warning! The protocol described in this file is currently in the testing
 * phase. Backward compatible changes may be added together with the
 * corresponding interface version bump. Backward incompatible changes can
 * only be done by creating a new major version of the extension.
 */
extern const struct wl_interface wp_tearing_control_manager_v1_interface;
#endif
#ifndef WP_TEARING_CONTROL_V1_INTERFACE
#define WP_TEARING_CONTROL_V1_INTERFACE
/**
 * @page page_iface_wp_tearing_control_v1 wp_tearing_control_v1
 * @section page_iface_wp_tearing_control_v1_desc Description
 *
 * An additional interface to a wl_surface object, which allows the client
 * to hint to the compositor if the content on the surface is suitable for
 * presentation with tearing.
 * The default presentation hint is vsync. See presentation_hint for more
 * details.
 * @section page_iface_wp_tearing_control_v1_api API
 * See @ref iface_wp_tearing_control_v1.
 */
/**
 * @defgroup iface_wp_tearing_control_v1 The wp_tearing_control_v1 interface
 *
 * An additional interface to a wl_surface object, which allows the client
 * to hint to the compositor if the content on the surface is suitable for
 * presentation with tearing.
 * The default presentation hint is vsync. See presentation_hint for more
 * details.
 */
extern const struct wl_interface wp_tearing_control_v1_interface;
#endif

#ifndef WP_TEARING_CONTROL_MANAGER_V1_ERROR_ENUM
#define WP_TEARING_CONTROL_MANAGER_V1_ERROR_ENUM
enum wp_tearing_control_manager_v1_error {
	/**
	 * the surface already has a tearing object associated
	 */
	WP_TEARING_CONTROL_MANAGER_V1_ERROR_TEARING_CONTROL_EXISTS = 0,
};
#endif /* WP_TEARING_CONTROL_MANAGER_V1_ERROR_ENUM */

/**
 * @ingroup iface_wp_tearing_control_manager_v1
 * @struct wp_tearing_control_manager_v1_interface
 */
struct wp_tearing_control_manager_v1_interface {
	/**
	 * destroy tearing control factory object
	 *
	 * Destroy this tearing control factory object. Other objects,
	 * including wp_tearing_control_v1 objects created by this factory,
	 * are not affected by this request.
	 */
	void (*destroy)(struct wl_client *client,
			struct wl_resource *resource);
	/**
	 * extend surface interface for tearing control
	 *
	 * Instantiate an interface extension for the given wl_surface to
	 * request asynchronous page flips for presentation.
	 *
	 * If the given wl_surface already has a wp_tearing_control_v1
	 * object associated, the tearing_control_exists protocol error is
	 * raised.
	 */
	void (*get_tearing_control)(struct wl_client *client,
				    struct wl_resource *resource,
				    uint32_t id,
				    struct wl_resource *surface);
};


/**
 * @ingroup iface_wp_tearing_control_manager_v1
 */
#define WP_TEARING_CONTROL_MANAGER_V1_DESTROY_SINCE_VERSION 1
/**
 * @ingroup iface_wp_tearing_control_manager_v1
 */
#define WP_TEARING_CONTROL_MANAGER_V1_GET_TEARING_CONTROL_SINCE_VERSION 1

#ifndef WP_TEARING_CONTROL_V1_PRESENTATION_HINT_ENUM
#define WP_TEARING_CONTROL_V1_PRESENTATION_HINT_ENUM
/**
 * @ingroup iface_wp_tearing_control_v1
 * presentation hint values
 *
 * This enum provides information for if submitted frames from the client
 * may be presented with tearing.
 */
enum wp_tearing_control_v1_presentation_hint {
	/**
	 * tearing-free presentation
	 *
	 * The content of this surface is meant to be synchronized to the
	 * vertical blanking period. This should not result in visible
	 * tearing and may result in a delay before a surface commit is
	 * presented.
	 */
	WP_TEARING_CONTROL_V1_PRESENTATION_HINT_VSYNC = 0,
	/**
	 * asynchronous presentation
	 *
	 * The content of this surface is meant to be presented with
	 * minimal latency and tearing is acceptable.
	 */
	WP_TEARING_CONTROL_V1_PRESENTATION_HINT_ASYNC = 1,
};
#endif /* WP_TEARING_CONTROL_V1_PRESENTATION_HINT_ENUM */

/**
 * @ingroup iface_wp_tearing_control_v1
 * @struct wp_tearing_control_v1_interface
 */
struct wp_tearing_control_v1_interface {
	/**
	 * set presentation hint
	 *
	 * Set the presentation hint for the associated wl_surface. This
	 * state is double-buffered and is applied on the next
	 * wl_surface.commit.
	 *
	 * The compositor is free to dynamically respect or ignore this
	 * hint based on various conditions like hardware capabilities,
	 * surface state and user preferences.
	 */
	void (*set_presentation_hint)(struct wl_client *client,
				      struct wl_resource *resource,
				      uint32_t hint);
	/**
	 * destroy tearing control object
	 *
	 * Destroy this surface tearing object and revert the
	 * presentation hint to vsync. The change will be applied on the
	 * next wl_surface.commit.
	 */
	void (*destroy)(struct wl_client *client,
			struct wl_resource *resource);
};


/**
 * @ingroup iface_wp_tearing_control_v1
 */
#define WP_TEARING_CONTROL_V1_SET_PRESENTATION_HINT_SINCE_VERSION 1
/**
 * @ingroup iface_wp_tearing_control_v1
 */
#define WP_TEARING_CONTROL_V1_DESTROY_SINCE_VERSION 1

#ifdef  __cplusplus
}
#endif

#endif
