// This file was generated by the Gtk# code generator.
// Any changes made will be lost if regenerated.

namespace Gst {

	using System;
	using System.Collections;
	using System.Collections.Generic;
	using System.Runtime.InteropServices;

#region Autogenerated code
	public partial class Bin : Gst.Element, Gst.IChildProxy {

		public Bin (IntPtr raw) : base(raw) {}

		[DllImport("gstreamer-1.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern IntPtr gst_bin_new(IntPtr name);

		public Bin (string name) : base (IntPtr.Zero)
		{
			if (GetType () != typeof (Bin)) {
				var vals = new List<GLib.Value> ();
				var names = new List<string> ();
				names.Add ("name");
				vals.Add (new GLib.Value (name));
				CreateNativeObject (names.ToArray (), vals.ToArray ());
				return;
			}
			IntPtr native_name = GLib.Marshaller.StringToPtrGStrdup (name);
			Raw = gst_bin_new(native_name);
			GLib.Marshaller.Free (native_name);
		}

		[GLib.Property ("async-handling")]
		public bool AsyncHandling {
			get {
				GLib.Value val = GetProperty ("async-handling");
				bool ret = (bool) val;
				val.Dispose ();
				return ret;
			}
			set {
				GLib.Value val = new GLib.Value(value);
				SetProperty("async-handling", val);
				val.Dispose ();
			}
		}

		[GLib.Property ("message-forward")]
		public bool MessageForward {
			get {
				GLib.Value val = GetProperty ("message-forward");
				bool ret = (bool) val;
				val.Dispose ();
				return ret;
			}
			set {
				GLib.Value val = new GLib.Value(value);
				SetProperty("message-forward", val);
				val.Dispose ();
			}
		}

		public int Numchildren {
			get {
				unsafe {
					int* raw_ptr = (int*)(((byte*)Handle) + abi_info.GetFieldOffset("numchildren"));
					return (*raw_ptr);
				}
			}
		}

		public GLib.List Children {
			get {
				unsafe {
					IntPtr* raw_ptr = (IntPtr*)(((byte*)Handle) + abi_info.GetFieldOffset("children"));
					return new GLib.List((*raw_ptr));
				}
			}
		}

		public uint ChildrenCookie {
			get {
				unsafe {
					uint* raw_ptr = (uint*)(((byte*)Handle) + abi_info.GetFieldOffset("children_cookie"));
					return (*raw_ptr);
				}
			}
		}

		public Gst.Bus ChildBus {
			get {
				unsafe {
					IntPtr* raw_ptr = (IntPtr*)(((byte*)Handle) + abi_info.GetFieldOffset("child_bus"));
					return GLib.Object.GetObject((*raw_ptr)) as Gst.Bus;
				}
			}
		}

		public GLib.List Messages {
			get {
				unsafe {
					IntPtr* raw_ptr = (IntPtr*)(((byte*)Handle) + abi_info.GetFieldOffset("messages"));
					return new GLib.List((*raw_ptr));
				}
			}
		}

		public bool Polling {
			get {
				unsafe {
					bool* raw_ptr = (bool*)(((byte*)Handle) + abi_info.GetFieldOffset("polling"));
					return (*raw_ptr);
				}
			}
		}

		public bool StateDirty {
			get {
				unsafe {
					bool* raw_ptr = (bool*)(((byte*)Handle) + abi_info.GetFieldOffset("state_dirty"));
					return (*raw_ptr);
				}
			}
		}

		public bool ClockDirty {
			get {
				unsafe {
					bool* raw_ptr = (bool*)(((byte*)Handle) + abi_info.GetFieldOffset("clock_dirty"));
					return (*raw_ptr);
				}
			}
		}

		public Gst.Clock ProvidedClock {
			get {
				unsafe {
					IntPtr* raw_ptr = (IntPtr*)(((byte*)Handle) + abi_info.GetFieldOffset("provided_clock"));
					return GLib.Object.GetObject((*raw_ptr)) as Gst.Clock;
				}
			}
		}

		public Gst.Element ClockProvider {
			get {
				unsafe {
					IntPtr* raw_ptr = (IntPtr*)(((byte*)Handle) + abi_info.GetFieldOffset("clock_provider"));
					return GLib.Object.GetObject((*raw_ptr)) as Gst.Element;
				}
			}
		}

		[GLib.Signal("deep-element-added")]
		public event Gst.DeepElementAddedHandler DeepElementAdded {
			add {
				this.AddSignalHandler ("deep-element-added", value, typeof (Gst.DeepElementAddedArgs));
			}
			remove {
				this.RemoveSignalHandler ("deep-element-added", value);
			}
		}

		[GLib.Signal("deep-element-removed")]
		public event Gst.DeepElementRemovedHandler DeepElementRemoved {
			add {
				this.AddSignalHandler ("deep-element-removed", value, typeof (Gst.DeepElementRemovedArgs));
			}
			remove {
				this.RemoveSignalHandler ("deep-element-removed", value);
			}
		}

		[GLib.Signal("do-latency")]
		public event Gst.DoLatencyHandler DoLatency {
			add {
				this.AddSignalHandler ("do-latency", value, typeof (Gst.DoLatencyArgs));
			}
			remove {
				this.RemoveSignalHandler ("do-latency", value);
			}
		}

		[GLib.Signal("element-added")]
		public event Gst.ElementAddedHandler ElementAdded {
			add {
				this.AddSignalHandler ("element-added", value, typeof (Gst.ElementAddedArgs));
			}
			remove {
				this.RemoveSignalHandler ("element-added", value);
			}
		}

		[GLib.Signal("element-removed")]
		public event Gst.ElementRemovedHandler ElementRemoved {
			add {
				this.AddSignalHandler ("element-removed", value, typeof (Gst.ElementRemovedArgs));
			}
			remove {
				this.RemoveSignalHandler ("element-removed", value);
			}
		}

		static ElementAddedNativeDelegate ElementAdded_cb_delegate;
		static ElementAddedNativeDelegate ElementAddedVMCallback {
			get {
				if (ElementAdded_cb_delegate == null)
					ElementAdded_cb_delegate = new ElementAddedNativeDelegate (ElementAdded_cb);
				return ElementAdded_cb_delegate;
			}
		}

		static void OverrideElementAdded (GLib.GType gtype)
		{
			OverrideElementAdded (gtype, ElementAddedVMCallback);
		}

		static void OverrideElementAdded (GLib.GType gtype, ElementAddedNativeDelegate callback)
		{
			unsafe {
				IntPtr* raw_ptr = (IntPtr*)(((long) gtype.GetClassPtr()) + (long) class_abi.GetFieldOffset("element_added"));
				*raw_ptr = Marshal.GetFunctionPointerForDelegate((Delegate) callback);
			}
		}

		[UnmanagedFunctionPointer (CallingConvention.Cdecl)]
		delegate void ElementAddedNativeDelegate (IntPtr inst, IntPtr element);

		static void ElementAdded_cb (IntPtr inst, IntPtr element)
		{
			try {
				Bin __obj = GLib.Object.GetObject (inst, false) as Bin;
				__obj.OnElementAdded (GLib.Object.GetObject(element) as Gst.Element);
			} catch (Exception e) {
				GLib.ExceptionManager.RaiseUnhandledException (e, false);
			}
		}

		[GLib.DefaultSignalHandler(Type=typeof(Gst.Bin), ConnectionMethod="OverrideElementAdded")]
		protected virtual void OnElementAdded (Gst.Element element)
		{
			InternalElementAdded (element);
		}

		private void InternalElementAdded (Gst.Element element)
		{
			ElementAddedNativeDelegate unmanaged = null;
			unsafe {
				IntPtr* raw_ptr = (IntPtr*)(((long) this.LookupGType().GetThresholdType().GetClassPtr()) + (long) class_abi.GetFieldOffset("element_added"));
				unmanaged = (ElementAddedNativeDelegate) Marshal.GetDelegateForFunctionPointer(*raw_ptr, typeof(ElementAddedNativeDelegate));
			}
			if (unmanaged == null) return;

			unmanaged (this.Handle, element == null ? IntPtr.Zero : element.Handle);
		}

		static ElementRemovedNativeDelegate ElementRemoved_cb_delegate;
		static ElementRemovedNativeDelegate ElementRemovedVMCallback {
			get {
				if (ElementRemoved_cb_delegate == null)
					ElementRemoved_cb_delegate = new ElementRemovedNativeDelegate (ElementRemoved_cb);
				return ElementRemoved_cb_delegate;
			}
		}

		static void OverrideElementRemoved (GLib.GType gtype)
		{
			OverrideElementRemoved (gtype, ElementRemovedVMCallback);
		}

		static void OverrideElementRemoved (GLib.GType gtype, ElementRemovedNativeDelegate callback)
		{
			unsafe {
				IntPtr* raw_ptr = (IntPtr*)(((long) gtype.GetClassPtr()) + (long) class_abi.GetFieldOffset("element_removed"));
				*raw_ptr = Marshal.GetFunctionPointerForDelegate((Delegate) callback);
			}
		}

		[UnmanagedFunctionPointer (CallingConvention.Cdecl)]
		delegate void ElementRemovedNativeDelegate (IntPtr inst, IntPtr element);

		static void ElementRemoved_cb (IntPtr inst, IntPtr element)
		{
			try {
				Bin __obj = GLib.Object.GetObject (inst, false) as Bin;
				__obj.OnElementRemoved (GLib.Object.GetObject(element) as Gst.Element);
			} catch (Exception e) {
				GLib.ExceptionManager.RaiseUnhandledException (e, false);
			}
		}

		[GLib.DefaultSignalHandler(Type=typeof(Gst.Bin), ConnectionMethod="OverrideElementRemoved")]
		protected virtual void OnElementRemoved (Gst.Element element)
		{
			InternalElementRemoved (element);
		}

		private void InternalElementRemoved (Gst.Element element)
		{
			ElementRemovedNativeDelegate unmanaged = null;
			unsafe {
				IntPtr* raw_ptr = (IntPtr*)(((long) this.LookupGType().GetThresholdType().GetClassPtr()) + (long) class_abi.GetFieldOffset("element_removed"));
				unmanaged = (ElementRemovedNativeDelegate) Marshal.GetDelegateForFunctionPointer(*raw_ptr, typeof(ElementRemovedNativeDelegate));
			}
			if (unmanaged == null) return;

			unmanaged (this.Handle, element == null ? IntPtr.Zero : element.Handle);
		}

		static AddElementNativeDelegate AddElement_cb_delegate;
		static AddElementNativeDelegate AddElementVMCallback {
			get {
				if (AddElement_cb_delegate == null)
					AddElement_cb_delegate = new AddElementNativeDelegate (AddElement_cb);
				return AddElement_cb_delegate;
			}
		}

		static void OverrideAddElement (GLib.GType gtype)
		{
			OverrideAddElement (gtype, AddElementVMCallback);
		}

		static void OverrideAddElement (GLib.GType gtype, AddElementNativeDelegate callback)
		{
			unsafe {
				IntPtr* raw_ptr = (IntPtr*)(((long) gtype.GetClassPtr()) + (long) class_abi.GetFieldOffset("add_element"));
				*raw_ptr = Marshal.GetFunctionPointerForDelegate((Delegate) callback);
			}
		}

		[UnmanagedFunctionPointer (CallingConvention.Cdecl)]
		delegate bool AddElementNativeDelegate (IntPtr inst, IntPtr element);

		static bool AddElement_cb (IntPtr inst, IntPtr element)
		{
			try {
				Bin __obj = GLib.Object.GetObject (inst, false) as Bin;
				bool __result;
				__result = __obj.OnAddElement (GLib.Object.GetObject(element) as Gst.Element);
				return __result;
			} catch (Exception e) {
				GLib.ExceptionManager.RaiseUnhandledException (e, true);
				// NOTREACHED: above call does not return.
				throw e;
			}
		}

		[GLib.DefaultSignalHandler(Type=typeof(Gst.Bin), ConnectionMethod="OverrideAddElement")]
		protected virtual bool OnAddElement (Gst.Element element)
		{
			return InternalAddElement (element);
		}

		private bool InternalAddElement (Gst.Element element)
		{
			AddElementNativeDelegate unmanaged = null;
			unsafe {
				IntPtr* raw_ptr = (IntPtr*)(((long) this.LookupGType().GetThresholdType().GetClassPtr()) + (long) class_abi.GetFieldOffset("add_element"));
				unmanaged = (AddElementNativeDelegate) Marshal.GetDelegateForFunctionPointer(*raw_ptr, typeof(AddElementNativeDelegate));
			}
			if (unmanaged == null) return false;

			bool __result = unmanaged (this.Handle, element == null ? IntPtr.Zero : element.Handle);
			return __result;
		}

		static RemoveElementNativeDelegate RemoveElement_cb_delegate;
		static RemoveElementNativeDelegate RemoveElementVMCallback {
			get {
				if (RemoveElement_cb_delegate == null)
					RemoveElement_cb_delegate = new RemoveElementNativeDelegate (RemoveElement_cb);
				return RemoveElement_cb_delegate;
			}
		}

		static void OverrideRemoveElement (GLib.GType gtype)
		{
			OverrideRemoveElement (gtype, RemoveElementVMCallback);
		}

		static void OverrideRemoveElement (GLib.GType gtype, RemoveElementNativeDelegate callback)
		{
			unsafe {
				IntPtr* raw_ptr = (IntPtr*)(((long) gtype.GetClassPtr()) + (long) class_abi.GetFieldOffset("remove_element"));
				*raw_ptr = Marshal.GetFunctionPointerForDelegate((Delegate) callback);
			}
		}

		[UnmanagedFunctionPointer (CallingConvention.Cdecl)]
		delegate bool RemoveElementNativeDelegate (IntPtr inst, IntPtr element);

		static bool RemoveElement_cb (IntPtr inst, IntPtr element)
		{
			try {
				Bin __obj = GLib.Object.GetObject (inst, false) as Bin;
				bool __result;
				__result = __obj.OnRemoveElement (GLib.Object.GetObject(element) as Gst.Element);
				return __result;
			} catch (Exception e) {
				GLib.ExceptionManager.RaiseUnhandledException (e, true);
				// NOTREACHED: above call does not return.
				throw e;
			}
		}

		[GLib.DefaultSignalHandler(Type=typeof(Gst.Bin), ConnectionMethod="OverrideRemoveElement")]
		protected virtual bool OnRemoveElement (Gst.Element element)
		{
			return InternalRemoveElement (element);
		}

		private bool InternalRemoveElement (Gst.Element element)
		{
			RemoveElementNativeDelegate unmanaged = null;
			unsafe {
				IntPtr* raw_ptr = (IntPtr*)(((long) this.LookupGType().GetThresholdType().GetClassPtr()) + (long) class_abi.GetFieldOffset("remove_element"));
				unmanaged = (RemoveElementNativeDelegate) Marshal.GetDelegateForFunctionPointer(*raw_ptr, typeof(RemoveElementNativeDelegate));
			}
			if (unmanaged == null) return false;

			bool __result = unmanaged (this.Handle, element == null ? IntPtr.Zero : element.Handle);
			return __result;
		}

		static HandleMessageNativeDelegate HandleMessage_cb_delegate;
		static HandleMessageNativeDelegate HandleMessageVMCallback {
			get {
				if (HandleMessage_cb_delegate == null)
					HandleMessage_cb_delegate = new HandleMessageNativeDelegate (HandleMessage_cb);
				return HandleMessage_cb_delegate;
			}
		}

		static void OverrideHandleMessage (GLib.GType gtype)
		{
			OverrideHandleMessage (gtype, HandleMessageVMCallback);
		}

		static void OverrideHandleMessage (GLib.GType gtype, HandleMessageNativeDelegate callback)
		{
			unsafe {
				IntPtr* raw_ptr = (IntPtr*)(((long) gtype.GetClassPtr()) + (long) class_abi.GetFieldOffset("handle_message"));
				*raw_ptr = Marshal.GetFunctionPointerForDelegate((Delegate) callback);
			}
		}

		[UnmanagedFunctionPointer (CallingConvention.Cdecl)]
		delegate void HandleMessageNativeDelegate (IntPtr inst, IntPtr message);

		static void HandleMessage_cb (IntPtr inst, IntPtr message)
		{
			try {
				Bin __obj = GLib.Object.GetObject (inst, false) as Bin;
				__obj.OnHandleMessage (message == IntPtr.Zero ? null : (Gst.Message) GLib.Opaque.GetOpaque (message, typeof (Gst.Message), true));
			} catch (Exception e) {
				GLib.ExceptionManager.RaiseUnhandledException (e, false);
			}
		}

		[GLib.DefaultSignalHandler(Type=typeof(Gst.Bin), ConnectionMethod="OverrideHandleMessage")]
		protected virtual void OnHandleMessage (Gst.Message message)
		{
			InternalHandleMessage (message);
		}

		private void InternalHandleMessage (Gst.Message message)
		{
			HandleMessageNativeDelegate unmanaged = null;
			unsafe {
				IntPtr* raw_ptr = (IntPtr*)(((long) this.LookupGType().GetThresholdType().GetClassPtr()) + (long) class_abi.GetFieldOffset("handle_message"));
				unmanaged = (HandleMessageNativeDelegate) Marshal.GetDelegateForFunctionPointer(*raw_ptr, typeof(HandleMessageNativeDelegate));
			}
			if (unmanaged == null) return;

			message.Owned = false;
			unmanaged (this.Handle, message == null ? IntPtr.Zero : message.Handle);
		}

		static DoLatencyNativeDelegate DoLatency_cb_delegate;
		static DoLatencyNativeDelegate DoLatencyVMCallback {
			get {
				if (DoLatency_cb_delegate == null)
					DoLatency_cb_delegate = new DoLatencyNativeDelegate (DoLatency_cb);
				return DoLatency_cb_delegate;
			}
		}

		static void OverrideDoLatency (GLib.GType gtype)
		{
			OverrideDoLatency (gtype, DoLatencyVMCallback);
		}

		static void OverrideDoLatency (GLib.GType gtype, DoLatencyNativeDelegate callback)
		{
			unsafe {
				IntPtr* raw_ptr = (IntPtr*)(((long) gtype.GetClassPtr()) + (long) class_abi.GetFieldOffset("do_latency"));
				*raw_ptr = Marshal.GetFunctionPointerForDelegate((Delegate) callback);
			}
		}

		[UnmanagedFunctionPointer (CallingConvention.Cdecl)]
		delegate bool DoLatencyNativeDelegate (IntPtr inst);

		static bool DoLatency_cb (IntPtr inst)
		{
			try {
				Bin __obj = GLib.Object.GetObject (inst, false) as Bin;
				bool __result;
				__result = __obj.OnDoLatency ();
				return __result;
			} catch (Exception e) {
				GLib.ExceptionManager.RaiseUnhandledException (e, true);
				// NOTREACHED: above call does not return.
				throw e;
			}
		}

		[GLib.DefaultSignalHandler(Type=typeof(Gst.Bin), ConnectionMethod="OverrideDoLatency")]
		protected virtual bool OnDoLatency ()
		{
			return InternalDoLatency ();
		}

		private bool InternalDoLatency ()
		{
			DoLatencyNativeDelegate unmanaged = null;
			unsafe {
				IntPtr* raw_ptr = (IntPtr*)(((long) this.LookupGType().GetThresholdType().GetClassPtr()) + (long) class_abi.GetFieldOffset("do_latency"));
				unmanaged = (DoLatencyNativeDelegate) Marshal.GetDelegateForFunctionPointer(*raw_ptr, typeof(DoLatencyNativeDelegate));
			}
			if (unmanaged == null) return false;

			bool __result = unmanaged (this.Handle);
			return __result;
		}

		static DeepElementAddedNativeDelegate DeepElementAdded_cb_delegate;
		static DeepElementAddedNativeDelegate DeepElementAddedVMCallback {
			get {
				if (DeepElementAdded_cb_delegate == null)
					DeepElementAdded_cb_delegate = new DeepElementAddedNativeDelegate (DeepElementAdded_cb);
				return DeepElementAdded_cb_delegate;
			}
		}

		static void OverrideDeepElementAdded (GLib.GType gtype)
		{
			OverrideDeepElementAdded (gtype, DeepElementAddedVMCallback);
		}

		static void OverrideDeepElementAdded (GLib.GType gtype, DeepElementAddedNativeDelegate callback)
		{
			unsafe {
				IntPtr* raw_ptr = (IntPtr*)(((long) gtype.GetClassPtr()) + (long) class_abi.GetFieldOffset("deep_element_added"));
				*raw_ptr = Marshal.GetFunctionPointerForDelegate((Delegate) callback);
			}
		}

		[UnmanagedFunctionPointer (CallingConvention.Cdecl)]
		delegate void DeepElementAddedNativeDelegate (IntPtr inst, IntPtr sub_bin, IntPtr element);

		static void DeepElementAdded_cb (IntPtr inst, IntPtr sub_bin, IntPtr element)
		{
			try {
				Bin __obj = GLib.Object.GetObject (inst, false) as Bin;
				__obj.OnDeepElementAdded (GLib.Object.GetObject(sub_bin) as Gst.Bin, GLib.Object.GetObject(element) as Gst.Element);
			} catch (Exception e) {
				GLib.ExceptionManager.RaiseUnhandledException (e, false);
			}
		}

		[GLib.DefaultSignalHandler(Type=typeof(Gst.Bin), ConnectionMethod="OverrideDeepElementAdded")]
		protected virtual void OnDeepElementAdded (Gst.Bin sub_bin, Gst.Element element)
		{
			InternalDeepElementAdded (sub_bin, element);
		}

		private void InternalDeepElementAdded (Gst.Bin sub_bin, Gst.Element element)
		{
			DeepElementAddedNativeDelegate unmanaged = null;
			unsafe {
				IntPtr* raw_ptr = (IntPtr*)(((long) this.LookupGType().GetThresholdType().GetClassPtr()) + (long) class_abi.GetFieldOffset("deep_element_added"));
				unmanaged = (DeepElementAddedNativeDelegate) Marshal.GetDelegateForFunctionPointer(*raw_ptr, typeof(DeepElementAddedNativeDelegate));
			}
			if (unmanaged == null) return;

			unmanaged (this.Handle, sub_bin == null ? IntPtr.Zero : sub_bin.Handle, element == null ? IntPtr.Zero : element.Handle);
		}

		static DeepElementRemovedNativeDelegate DeepElementRemoved_cb_delegate;
		static DeepElementRemovedNativeDelegate DeepElementRemovedVMCallback {
			get {
				if (DeepElementRemoved_cb_delegate == null)
					DeepElementRemoved_cb_delegate = new DeepElementRemovedNativeDelegate (DeepElementRemoved_cb);
				return DeepElementRemoved_cb_delegate;
			}
		}

		static void OverrideDeepElementRemoved (GLib.GType gtype)
		{
			OverrideDeepElementRemoved (gtype, DeepElementRemovedVMCallback);
		}

		static void OverrideDeepElementRemoved (GLib.GType gtype, DeepElementRemovedNativeDelegate callback)
		{
			unsafe {
				IntPtr* raw_ptr = (IntPtr*)(((long) gtype.GetClassPtr()) + (long) class_abi.GetFieldOffset("deep_element_removed"));
				*raw_ptr = Marshal.GetFunctionPointerForDelegate((Delegate) callback);
			}
		}

		[UnmanagedFunctionPointer (CallingConvention.Cdecl)]
		delegate void DeepElementRemovedNativeDelegate (IntPtr inst, IntPtr sub_bin, IntPtr element);

		static void DeepElementRemoved_cb (IntPtr inst, IntPtr sub_bin, IntPtr element)
		{
			try {
				Bin __obj = GLib.Object.GetObject (inst, false) as Bin;
				__obj.OnDeepElementRemoved (GLib.Object.GetObject(sub_bin) as Gst.Bin, GLib.Object.GetObject(element) as Gst.Element);
			} catch (Exception e) {
				GLib.ExceptionManager.RaiseUnhandledException (e, false);
			}
		}

		[GLib.DefaultSignalHandler(Type=typeof(Gst.Bin), ConnectionMethod="OverrideDeepElementRemoved")]
		protected virtual void OnDeepElementRemoved (Gst.Bin sub_bin, Gst.Element element)
		{
			InternalDeepElementRemoved (sub_bin, element);
		}

		private void InternalDeepElementRemoved (Gst.Bin sub_bin, Gst.Element element)
		{
			DeepElementRemovedNativeDelegate unmanaged = null;
			unsafe {
				IntPtr* raw_ptr = (IntPtr*)(((long) this.LookupGType().GetThresholdType().GetClassPtr()) + (long) class_abi.GetFieldOffset("deep_element_removed"));
				unmanaged = (DeepElementRemovedNativeDelegate) Marshal.GetDelegateForFunctionPointer(*raw_ptr, typeof(DeepElementRemovedNativeDelegate));
			}
			if (unmanaged == null) return;

			unmanaged (this.Handle, sub_bin == null ? IntPtr.Zero : sub_bin.Handle, element == null ? IntPtr.Zero : element.Handle);
		}


		// Internal representation of the wrapped structure ABI.
		static GLib.AbiStruct _class_abi = null;
		static public new GLib.AbiStruct class_abi {
			get {
				if (_class_abi == null)
					_class_abi = new GLib.AbiStruct (new List<GLib.AbiField>{ 
						new GLib.AbiField("pool"
							, Gst.Element.class_abi.Fields
							, (uint) Marshal.SizeOf(typeof(IntPtr)) // pool
							, null
							, "element_added"
							, (uint) Marshal.SizeOf(typeof(IntPtr))
							, 0
							),
						new GLib.AbiField("element_added"
							, -1
							, (uint) Marshal.SizeOf(typeof(IntPtr)) // element_added
							, "pool"
							, "element_removed"
							, (uint) Marshal.SizeOf(typeof(IntPtr))
							, 0
							),
						new GLib.AbiField("element_removed"
							, -1
							, (uint) Marshal.SizeOf(typeof(IntPtr)) // element_removed
							, "element_added"
							, "add_element"
							, (uint) Marshal.SizeOf(typeof(IntPtr))
							, 0
							),
						new GLib.AbiField("add_element"
							, -1
							, (uint) Marshal.SizeOf(typeof(IntPtr)) // add_element
							, "element_removed"
							, "remove_element"
							, (uint) Marshal.SizeOf(typeof(IntPtr))
							, 0
							),
						new GLib.AbiField("remove_element"
							, -1
							, (uint) Marshal.SizeOf(typeof(IntPtr)) // remove_element
							, "add_element"
							, "handle_message"
							, (uint) Marshal.SizeOf(typeof(IntPtr))
							, 0
							),
						new GLib.AbiField("handle_message"
							, -1
							, (uint) Marshal.SizeOf(typeof(IntPtr)) // handle_message
							, "remove_element"
							, "do_latency"
							, (uint) Marshal.SizeOf(typeof(IntPtr))
							, 0
							),
						new GLib.AbiField("do_latency"
							, -1
							, (uint) Marshal.SizeOf(typeof(IntPtr)) // do_latency
							, "handle_message"
							, "deep_element_added"
							, (uint) Marshal.SizeOf(typeof(IntPtr))
							, 0
							),
						new GLib.AbiField("deep_element_added"
							, -1
							, (uint) Marshal.SizeOf(typeof(IntPtr)) // deep_element_added
							, "do_latency"
							, "deep_element_removed"
							, (uint) Marshal.SizeOf(typeof(IntPtr))
							, 0
							),
						new GLib.AbiField("deep_element_removed"
							, -1
							, (uint) Marshal.SizeOf(typeof(IntPtr)) // deep_element_removed
							, "deep_element_added"
							, "_gst_reserved"
							, (uint) Marshal.SizeOf(typeof(IntPtr))
							, 0
							),
						new GLib.AbiField("_gst_reserved"
							, -1
							, (uint) Marshal.SizeOf(typeof(IntPtr)) * 2 // _gst_reserved
							, "deep_element_removed"
							, null
							, (uint) Marshal.SizeOf(typeof(IntPtr))
							, 0
							),
					});

				return _class_abi;
			}
		}


		// End of the ABI representation.

		[DllImport("gstreamer-1.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern IntPtr gst_bin_get_type();

		public static new GLib.GType GType { 
			get {
				IntPtr raw_ret = gst_bin_get_type();
				GLib.GType ret = new GLib.GType(raw_ret);
				return ret;
			}
		}

		[DllImport("gstreamer-1.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern bool gst_bin_add(IntPtr raw, IntPtr element);

		public bool Add(Gst.Element element) {
			bool raw_ret = gst_bin_add(Handle, element == null ? IntPtr.Zero : element.Handle);
			bool ret = raw_ret;
			return ret;
		}

		[DllImport("gstreamer-1.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern IntPtr gst_bin_find_unlinked_pad(IntPtr raw, int direction);

		public Gst.Pad FindUnlinkedPad(Gst.PadDirection direction) {
			IntPtr raw_ret = gst_bin_find_unlinked_pad(Handle, (int) direction);
			Gst.Pad ret = GLib.Object.GetObject(raw_ret, true) as Gst.Pad;
			return ret;
		}

		[DllImport("gstreamer-1.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern IntPtr gst_bin_get_by_interface(IntPtr raw, IntPtr iface);

		public Gst.Element GetByInterface(GLib.GType iface) {
			IntPtr raw_ret = gst_bin_get_by_interface(Handle, iface.Val);
			Gst.Element ret = GLib.Object.GetObject(raw_ret, true) as Gst.Element;
			return ret;
		}

		[DllImport("gstreamer-1.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern IntPtr gst_bin_get_by_name(IntPtr raw, IntPtr name);

		public Gst.Element GetByName(string name) {
			IntPtr native_name = GLib.Marshaller.StringToPtrGStrdup (name);
			IntPtr raw_ret = gst_bin_get_by_name(Handle, native_name);
			Gst.Element ret = GLib.Object.GetObject(raw_ret, true) as Gst.Element;
			GLib.Marshaller.Free (native_name);
			return ret;
		}

		[DllImport("gstreamer-1.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern IntPtr gst_bin_get_by_name_recurse_up(IntPtr raw, IntPtr name);

		public Gst.Element GetByNameRecurseUp(string name) {
			IntPtr native_name = GLib.Marshaller.StringToPtrGStrdup (name);
			IntPtr raw_ret = gst_bin_get_by_name_recurse_up(Handle, native_name);
			Gst.Element ret = GLib.Object.GetObject(raw_ret, true) as Gst.Element;
			GLib.Marshaller.Free (native_name);
			return ret;
		}

		[DllImport("gstreamer-1.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern int gst_bin_get_suppressed_flags(IntPtr raw);

		[DllImport("gstreamer-1.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void gst_bin_set_suppressed_flags(IntPtr raw, int flags);

		public Gst.ElementFlags SuppressedFlags { 
			get {
				int raw_ret = gst_bin_get_suppressed_flags(Handle);
				Gst.ElementFlags ret = (Gst.ElementFlags) raw_ret;
				return ret;
			}
			set {
				gst_bin_set_suppressed_flags(Handle, (int) value);
			}
		}

		[DllImport("gstreamer-1.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern IntPtr gst_bin_iterate_all_by_element_factory_name(IntPtr raw, IntPtr factory_name);

		public Gst.Iterator IterateAllByElementFactoryName(string factory_name) {
			IntPtr native_factory_name = GLib.Marshaller.StringToPtrGStrdup (factory_name);
			IntPtr raw_ret = gst_bin_iterate_all_by_element_factory_name(Handle, native_factory_name);
			Gst.Iterator ret = raw_ret == IntPtr.Zero ? null : (Gst.Iterator) GLib.Opaque.GetOpaque (raw_ret, typeof (Gst.Iterator), true);
			GLib.Marshaller.Free (native_factory_name);
			return ret;
		}

		[DllImport("gstreamer-1.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern IntPtr gst_bin_iterate_all_by_interface(IntPtr raw, IntPtr iface);

		public Gst.Iterator IterateAllByInterface(GLib.GType iface) {
			IntPtr raw_ret = gst_bin_iterate_all_by_interface(Handle, iface.Val);
			Gst.Iterator ret = raw_ret == IntPtr.Zero ? null : (Gst.Iterator) GLib.Opaque.GetOpaque (raw_ret, typeof (Gst.Iterator), true);
			return ret;
		}

		[DllImport("gstreamer-1.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern IntPtr gst_bin_iterate_elements(IntPtr raw);

		public Gst.Iterator IterateElements() {
			IntPtr raw_ret = gst_bin_iterate_elements(Handle);
			Gst.Iterator ret = raw_ret == IntPtr.Zero ? null : (Gst.Iterator) GLib.Opaque.GetOpaque (raw_ret, typeof (Gst.Iterator), true);
			return ret;
		}

		[DllImport("gstreamer-1.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern IntPtr gst_bin_iterate_recurse(IntPtr raw);

		public Gst.Iterator IterateRecurse() {
			IntPtr raw_ret = gst_bin_iterate_recurse(Handle);
			Gst.Iterator ret = raw_ret == IntPtr.Zero ? null : (Gst.Iterator) GLib.Opaque.GetOpaque (raw_ret, typeof (Gst.Iterator), true);
			return ret;
		}

		[DllImport("gstreamer-1.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern IntPtr gst_bin_iterate_sinks(IntPtr raw);

		public Gst.Iterator IterateSinks() {
			IntPtr raw_ret = gst_bin_iterate_sinks(Handle);
			Gst.Iterator ret = raw_ret == IntPtr.Zero ? null : (Gst.Iterator) GLib.Opaque.GetOpaque (raw_ret, typeof (Gst.Iterator), true);
			return ret;
		}

		[DllImport("gstreamer-1.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern IntPtr gst_bin_iterate_sorted(IntPtr raw);

		public Gst.Iterator IterateSorted() {
			IntPtr raw_ret = gst_bin_iterate_sorted(Handle);
			Gst.Iterator ret = raw_ret == IntPtr.Zero ? null : (Gst.Iterator) GLib.Opaque.GetOpaque (raw_ret, typeof (Gst.Iterator), true);
			return ret;
		}

		[DllImport("gstreamer-1.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern IntPtr gst_bin_iterate_sources(IntPtr raw);

		public Gst.Iterator IterateSources() {
			IntPtr raw_ret = gst_bin_iterate_sources(Handle);
			Gst.Iterator ret = raw_ret == IntPtr.Zero ? null : (Gst.Iterator) GLib.Opaque.GetOpaque (raw_ret, typeof (Gst.Iterator), true);
			return ret;
		}

		[DllImport("gstreamer-1.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern bool gst_bin_recalculate_latency(IntPtr raw);

		public bool RecalculateLatency() {
			bool raw_ret = gst_bin_recalculate_latency(Handle);
			bool ret = raw_ret;
			return ret;
		}

		[DllImport("gstreamer-1.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern bool gst_bin_remove(IntPtr raw, IntPtr element);

		public bool Remove(Gst.Element element) {
			bool raw_ret = gst_bin_remove(Handle, element == null ? IntPtr.Zero : element.Handle);
			bool ret = raw_ret;
			return ret;
		}

		[DllImport("gstreamer-1.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern bool gst_bin_sync_children_states(IntPtr raw);

		public bool SyncChildrenStates() {
			bool raw_ret = gst_bin_sync_children_states(Handle);
			bool ret = raw_ret;
			return ret;
		}

		[DllImport("gstreamer-1.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void gst_child_proxy_child_added(IntPtr raw, IntPtr child, IntPtr name);

		public void ChildAdded(GLib.Object child, string name) {
			IntPtr native_name = GLib.Marshaller.StringToPtrGStrdup (name);
			gst_child_proxy_child_added(Handle, child == null ? IntPtr.Zero : child.Handle, native_name);
			GLib.Marshaller.Free (native_name);
		}

		[DllImport("gstreamer-1.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void gst_child_proxy_child_removed(IntPtr raw, IntPtr child, IntPtr name);

		public void ChildRemoved(GLib.Object child, string name) {
			IntPtr native_name = GLib.Marshaller.StringToPtrGStrdup (name);
			gst_child_proxy_child_removed(Handle, child == null ? IntPtr.Zero : child.Handle, native_name);
			GLib.Marshaller.Free (native_name);
		}

		[DllImport("gstreamer-1.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern IntPtr gst_child_proxy_get_child_by_index(IntPtr raw, uint index);

		public GLib.Object GetChildByIndex(uint index) {
			IntPtr raw_ret = gst_child_proxy_get_child_by_index(Handle, index);
			GLib.Object ret = GLib.Object.GetObject (raw_ret);
			return ret;
		}

		[DllImport("gstreamer-1.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern IntPtr gst_child_proxy_get_child_by_name(IntPtr raw, IntPtr name);

		public GLib.Object GetChildByName(string name) {
			IntPtr native_name = GLib.Marshaller.StringToPtrGStrdup (name);
			IntPtr raw_ret = gst_child_proxy_get_child_by_name(Handle, native_name);
			GLib.Object ret = GLib.Object.GetObject (raw_ret);
			GLib.Marshaller.Free (native_name);
			return ret;
		}

		[DllImport("gstreamer-1.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern IntPtr gst_child_proxy_get_child_by_name_recurse(IntPtr raw, IntPtr name);

		public GLib.Object GetChildByNameRecurse(string name) {
			IntPtr native_name = GLib.Marshaller.StringToPtrGStrdup (name);
			IntPtr raw_ret = gst_child_proxy_get_child_by_name_recurse(Handle, native_name);
			GLib.Object ret = GLib.Object.GetObject (raw_ret);
			GLib.Marshaller.Free (native_name);
			return ret;
		}

		[DllImport("gstreamer-1.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern uint gst_child_proxy_get_children_count(IntPtr raw);

		public uint ChildrenCount { 
			get {
				uint raw_ret = gst_child_proxy_get_children_count(Handle);
				uint ret = raw_ret;
				return ret;
			}
		}

		[DllImport("gstreamer-1.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern bool gst_child_proxy_lookup(IntPtr raw, IntPtr name, out IntPtr target, out IntPtr pspec);

		public bool Lookup(string name, out GLib.Object target, out IntPtr pspec) {
			IntPtr native_name = GLib.Marshaller.StringToPtrGStrdup (name);
			IntPtr native_target;
			bool raw_ret = gst_child_proxy_lookup(Handle, native_name, out native_target, out pspec);
			bool ret = raw_ret;
			GLib.Marshaller.Free (native_name);
			target = GLib.Object.GetObject (native_target);
			return ret;
		}

		[GLib.Signal("child-removed")]
		public event Gst.ChildRemovedEventHandler ChildRemovedEvent {
			add {
				this.AddSignalHandler ("child-removed", value, typeof (Gst.ChildRemovedEventArgs));
			}
			remove {
				this.RemoveSignalHandler ("child-removed", value);
			}
		}

		[GLib.Signal("child-added")]
		public event Gst.ChildAddedEventHandler ChildAddedEvent {
			add {
				this.AddSignalHandler ("child-added", value, typeof (Gst.ChildAddedEventArgs));
			}
			remove {
				this.RemoveSignalHandler ("child-added", value);
			}
		}

		static ChildAddedEventNativeDelegate ChildAddedEvent_cb_delegate;
		static ChildAddedEventNativeDelegate ChildAddedEventVMCallback {
			get {
				if (ChildAddedEvent_cb_delegate == null)
					ChildAddedEvent_cb_delegate = new ChildAddedEventNativeDelegate (ChildAddedEvent_cb);
				return ChildAddedEvent_cb_delegate;
			}
		}

		static void OverrideChildAddedEvent (GLib.GType gtype)
		{
			OverrideChildAddedEvent (gtype, ChildAddedEventVMCallback);
		}

		static void OverrideChildAddedEvent (GLib.GType gtype, ChildAddedEventNativeDelegate callback)
		{
			OverrideVirtualMethod (gtype, "child-added", callback);
		}
		[UnmanagedFunctionPointer (CallingConvention.Cdecl)]
		delegate void ChildAddedEventNativeDelegate (IntPtr inst, IntPtr _object, IntPtr name);

		static void ChildAddedEvent_cb (IntPtr inst, IntPtr _object, IntPtr name)
		{
			try {
				Gst.Bin __obj = GLib.Object.GetObject (inst, false) as Gst.Bin;
				__obj.OnChildAddedEvent (GLib.Object.GetObject (_object), GLib.Marshaller.Utf8PtrToString (name));
			} catch (Exception e) {
				GLib.ExceptionManager.RaiseUnhandledException (e, false);
			}
		}

		[GLib.DefaultSignalHandler(Type=typeof(Gst.Bin), ConnectionMethod="OverrideChildAddedEvent")]
		protected virtual void OnChildAddedEvent (GLib.Object _object, string name)
		{
			InternalChildAddedEvent (_object, name);
		}

		private void InternalChildAddedEvent (GLib.Object _object, string name)
		{
			GLib.Value ret = GLib.Value.Empty;
			GLib.ValueArray inst_and_params = new GLib.ValueArray (3);
			GLib.Value[] vals = new GLib.Value [3];
			vals [0] = new GLib.Value (this);
			inst_and_params.Append (vals [0]);
			vals [1] = new GLib.Value (_object);
			inst_and_params.Append (vals [1]);
			vals [2] = new GLib.Value (name);
			inst_and_params.Append (vals [2]);
			g_signal_chain_from_overridden (inst_and_params.ArrayPtr, ref ret);
			foreach (GLib.Value v in vals)
				v.Dispose ();
		}

		static ChildRemovedEventNativeDelegate ChildRemovedEvent_cb_delegate;
		static ChildRemovedEventNativeDelegate ChildRemovedEventVMCallback {
			get {
				if (ChildRemovedEvent_cb_delegate == null)
					ChildRemovedEvent_cb_delegate = new ChildRemovedEventNativeDelegate (ChildRemovedEvent_cb);
				return ChildRemovedEvent_cb_delegate;
			}
		}

		static void OverrideChildRemovedEvent (GLib.GType gtype)
		{
			OverrideChildRemovedEvent (gtype, ChildRemovedEventVMCallback);
		}

		static void OverrideChildRemovedEvent (GLib.GType gtype, ChildRemovedEventNativeDelegate callback)
		{
			OverrideVirtualMethod (gtype, "child-removed", callback);
		}
		[UnmanagedFunctionPointer (CallingConvention.Cdecl)]
		delegate void ChildRemovedEventNativeDelegate (IntPtr inst, IntPtr _object, IntPtr name);

		static void ChildRemovedEvent_cb (IntPtr inst, IntPtr _object, IntPtr name)
		{
			try {
				Gst.Bin __obj = GLib.Object.GetObject (inst, false) as Gst.Bin;
				__obj.OnChildRemovedEvent (GLib.Object.GetObject (_object), GLib.Marshaller.Utf8PtrToString (name));
			} catch (Exception e) {
				GLib.ExceptionManager.RaiseUnhandledException (e, false);
			}
		}

		[GLib.DefaultSignalHandler(Type=typeof(Gst.Bin), ConnectionMethod="OverrideChildRemovedEvent")]
		protected virtual void OnChildRemovedEvent (GLib.Object _object, string name)
		{
			InternalChildRemovedEvent (_object, name);
		}

		private void InternalChildRemovedEvent (GLib.Object _object, string name)
		{
			GLib.Value ret = GLib.Value.Empty;
			GLib.ValueArray inst_and_params = new GLib.ValueArray (3);
			GLib.Value[] vals = new GLib.Value [3];
			vals [0] = new GLib.Value (this);
			inst_and_params.Append (vals [0]);
			vals [1] = new GLib.Value (_object);
			inst_and_params.Append (vals [1]);
			vals [2] = new GLib.Value (name);
			inst_and_params.Append (vals [2]);
			g_signal_chain_from_overridden (inst_and_params.ArrayPtr, ref ret);
			foreach (GLib.Value v in vals)
				v.Dispose ();
		}


		// Internal representation of the wrapped structure ABI.
		static GLib.AbiStruct _abi_info = null;
		static public new GLib.AbiStruct abi_info {
			get {
				if (_abi_info == null)
					_abi_info = new GLib.AbiStruct (new List<GLib.AbiField>{ 
						new GLib.AbiField("numchildren"
							, Gst.Element.abi_info.Fields
							, (uint) Marshal.SizeOf(typeof(int)) // numchildren
							, null
							, "children"
							, (long) Marshal.OffsetOf(typeof(GstBin_numchildrenAlign), "numchildren")
							, 0
							),
						new GLib.AbiField("children"
							, -1
							, (uint) Marshal.SizeOf(typeof(IntPtr)) // children
							, "numchildren"
							, "children_cookie"
							, (uint) Marshal.SizeOf(typeof(IntPtr))
							, 0
							),
						new GLib.AbiField("children_cookie"
							, -1
							, (uint) Marshal.SizeOf(typeof(uint)) // children_cookie
							, "children"
							, "child_bus"
							, (long) Marshal.OffsetOf(typeof(GstBin_children_cookieAlign), "children_cookie")
							, 0
							),
						new GLib.AbiField("child_bus"
							, -1
							, (uint) Marshal.SizeOf(typeof(IntPtr)) // child_bus
							, "children_cookie"
							, "messages"
							, (uint) Marshal.SizeOf(typeof(IntPtr))
							, 0
							),
						new GLib.AbiField("messages"
							, -1
							, (uint) Marshal.SizeOf(typeof(IntPtr)) // messages
							, "child_bus"
							, "polling"
							, (uint) Marshal.SizeOf(typeof(IntPtr))
							, 0
							),
						new GLib.AbiField("polling"
							, -1
							, (uint) Marshal.SizeOf(typeof(bool)) // polling
							, "messages"
							, "state_dirty"
							, (long) Marshal.OffsetOf(typeof(GstBin_pollingAlign), "polling")
							, 0
							),
						new GLib.AbiField("state_dirty"
							, -1
							, (uint) Marshal.SizeOf(typeof(bool)) // state_dirty
							, "polling"
							, "clock_dirty"
							, (long) Marshal.OffsetOf(typeof(GstBin_state_dirtyAlign), "state_dirty")
							, 0
							),
						new GLib.AbiField("clock_dirty"
							, -1
							, (uint) Marshal.SizeOf(typeof(bool)) // clock_dirty
							, "state_dirty"
							, "provided_clock"
							, (long) Marshal.OffsetOf(typeof(GstBin_clock_dirtyAlign), "clock_dirty")
							, 0
							),
						new GLib.AbiField("provided_clock"
							, -1
							, (uint) Marshal.SizeOf(typeof(IntPtr)) // provided_clock
							, "clock_dirty"
							, "clock_provider"
							, (uint) Marshal.SizeOf(typeof(IntPtr))
							, 0
							),
						new GLib.AbiField("clock_provider"
							, -1
							, (uint) Marshal.SizeOf(typeof(IntPtr)) // clock_provider
							, "provided_clock"
							, "priv"
							, (uint) Marshal.SizeOf(typeof(IntPtr))
							, 0
							),
						new GLib.AbiField("priv"
							, -1
							, (uint) Marshal.SizeOf(typeof(IntPtr)) // priv
							, "clock_provider"
							, "_gst_reserved"
							, (uint) Marshal.SizeOf(typeof(IntPtr))
							, 0
							),
						new GLib.AbiField("_gst_reserved"
							, -1
							, (uint) Marshal.SizeOf(typeof(IntPtr)) * 4 // _gst_reserved
							, "priv"
							, null
							, (uint) Marshal.SizeOf(typeof(IntPtr))
							, 0
							),
					});

				return _abi_info;
			}
		}

		[StructLayout(LayoutKind.Sequential)]
		public struct GstBin_numchildrenAlign
		{
			sbyte f1;
			private int numchildren;
		}

		[StructLayout(LayoutKind.Sequential)]
		public struct GstBin_children_cookieAlign
		{
			sbyte f1;
			private uint children_cookie;
		}

		[StructLayout(LayoutKind.Sequential)]
		public struct GstBin_pollingAlign
		{
			sbyte f1;
			private bool polling;
		}

		[StructLayout(LayoutKind.Sequential)]
		public struct GstBin_state_dirtyAlign
		{
			sbyte f1;
			private bool state_dirty;
		}

		[StructLayout(LayoutKind.Sequential)]
		public struct GstBin_clock_dirtyAlign
		{
			sbyte f1;
			private bool clock_dirty;
		}


		// End of the ABI representation.

#endregion
	}
}
