$NetBSD$

* Part of patchset to build electron on NetBSD
* Based on OpenBSD's chromium patches, and
  FreeBSD's electron patches

--- third_party/electron_node/tools/generate_gn_filenames_json.py.orig	2025-03-03 17:47:27.719940814 +0000
+++ third_party/electron_node/tools/generate_gn_filenames_json.py
@@ -0,0 +1,117 @@
+#!@PYTHONBIN@
+import json
+import os
+import sys
+
+import install
+
+from utils import SearchFiles
+
+def LoadPythonDictionary(path):
+  file_string = open(path).read()
+  try:
+    file_data = eval(file_string, {'__builtins__': None}, None)
+  except SyntaxError as e:
+    e.filename = path
+    raise
+  except Exception as e:
+    raise Exception("Unexpected error while reading %s: %s" % (path, str(e)))
+
+  assert isinstance(file_data, dict), "%s does not eval to a dictionary" % path
+
+  return file_data
+
+
+FILENAMES_JSON_HEADER = '''
+// This file is automatically generated by generate_gn_filenames_json.py
+// DO NOT EDIT
+'''.lstrip()
+
+SRC_DIR = os.path.abspath(os.path.join(__file__, '..', '..', '..', '..'))
+
+def get_out_dir():
+  out_dir = 'Testing'
+  override = os.environ.get('ELECTRON_OUT_DIR')
+  if override is not None:
+    out_dir = override
+  return os.path.join(SRC_DIR, 'out', out_dir)
+
+if __name__ == '__main__':
+  node_root_dir = os.path.dirname(os.path.dirname(__file__))
+  node_gyp_path = os.path.join(node_root_dir, 'node.gyp')
+  out = {}
+  node_gyp = LoadPythonDictionary(node_gyp_path)
+  node_lib_target = next(
+      t for t in node_gyp['targets']
+      if t['target_name'] == '<(node_lib_target_name)')
+  node_source_blocklist = {
+      '<@(library_files)',
+      '<@(deps_files)',
+      '<@(node_sources)',
+      'common.gypi',
+      '<(SHARED_INTERMEDIATE_DIR)/node_javascript.cc',
+  }
+
+  def filter_v8_files(files):
+    v8_files = [f for f in files if f.startswith('deps/v8/')]
+    other_files = [f for f in files if not f.startswith('deps/v8/')]
+
+    for i, f in enumerate(v8_files):
+        if not f.startswith('deps/v8/tools'):
+            if f.endswith('js'):
+                v8_files[i] = f.replace('deps/v8/', '../../v8/', 1)
+            else:
+                v8_files[i] = f.replace('deps/v8/', '//v8/')
+
+    if any(f == '<@(node_builtin_shareable_builtins)' for f in other_files):
+      other_files.remove('<@(node_builtin_shareable_builtins)')
+      shared_builtins = ['deps/cjs-module-lexer/lexer.js', 'deps/cjs-module-lexer/dist/lexer.js', 'deps/undici/undici.js']
+      other_files.extend(shared_builtins)
+
+    return v8_files + other_files
+
+  def filter_fs_files(files):
+    return [f for f in files if f.startswith('lib/internal/fs/')] + ['lib/fs.js'] + ['lib/fs/promises.js']
+
+  lib_files = SearchFiles('lib', 'js')
+  out['library_files'] = filter_v8_files(lib_files)
+  out['library_files'] += filter_v8_files(node_gyp['variables']['deps_files'])
+  out['node_sources'] = node_gyp['variables']['node_sources']
+
+  out['fs_files'] = filter_fs_files(out['library_files'])
+  # fs files are handled separately
+  out['library_files'] = [f for f in out['library_files'] if f not in out['fs_files']]
+
+  blocklisted_sources = [
+      f for f in node_lib_target['sources']
+      if f not in node_source_blocklist]
+  out['node_sources'] += filter_v8_files(blocklisted_sources)
+
+  out['headers'] = []
+  def add_headers(options, files, dest_dir):
+    if 'src/node.h' in files:
+      files = [f for f in files if f.endswith('.h') and f != 'src/node_version.h']
+    elif any(f.startswith('../../v8/') for f in files):
+      files = [f.replace('../../v8/', '//v8/', 1) for f in files]
+    if files:
+      dir_index = next((i for i, d in enumerate(out['headers']) if d['dest_dir'] == dest_dir), -1)
+      if (dir_index != -1):
+        out['headers'][dir_index]['files'] += sorted(files)
+      else:
+        hs = {'files': sorted(files), 'dest_dir': dest_dir}
+        out['headers'].append(hs)
+
+  config_gypi_path = os.path.join(get_out_dir(), 'gen', 'config.gypi')
+  root_gen_dir = os.path.join(node_root_dir, 'out', 'Release', 'gen')
+
+  options = install.parse_options(['install', '--v8-dir', '../../v8', '--config-gypi-path', config_gypi_path, '--headers-only'])
+  options.variables['node_use_openssl'] = 'false'
+  options.variables['node_shared_libuv'] = 'false'
+  # We generate zlib headers in Electron's BUILD.gn.
+  options.variables['node_shared_zlib'] = ''
+
+  install.headers(options, add_headers)
+  with open(os.path.join(node_root_dir, 'filenames.json'), 'w') as f:
+    f.write(FILENAMES_JSON_HEADER)
+    f.write(json.dumps(out, sort_keys=True, indent=2, separators=(',', ': ')))
+    f.write('\n')
