#! /bin/bash

set -eux
set -o pipefail

CVE_MOUNTS="--mount cve /buildstream-build --mount cve-reports /cve-reports --mount manifests /manifests"
GEN_CVE_REPORT="${BST} ${ARCH_OPT} shell freedesktop-sdk.bst:utils/generate-cve-report.bst --mount cve /buildstream-build"

${BST} ${ARCH_OPT} artifact pull gnomeos/manifest-devel.bst
${BST} artifact pull flatpak/platform-manifest.bst flatpak/sdk-manifest.bst
${BST} build freedesktop-sdk.bst:utils/generate-cve-report.bst

mkdir -p cve manifests/ cve-reports/
${BST} artifact checkout flatpak/platform-manifest.bst --directory manifests/platform
${BST} artifact checkout flatpak/sdk-manifest.bst --directory manifests/sdk
${BST} ${ARCH_OPT} artifact checkout gnomeos/manifest-devel.bst --directory manifests/gnomeos

${GEN_CVE_REPORT} -- update_local_cve_database
${GEN_CVE_REPORT} ${CVE_MOUNTS} -- generate_cve_report /manifests/platform/usr/manifest.json /cve-reports/platform.html
${GEN_CVE_REPORT} ${CVE_MOUNTS} -- generate_cve_report /manifests/sdk/usr/manifest.json /cve-reports/sdk.html
${GEN_CVE_REPORT} ${CVE_MOUNTS} -- generate_cve_report /manifests/gnomeos/usr/manifest.json /cve-reports/gnomeos.html
