// generated by diplomat-tool
import type { CodePointSetBuilder } from "./CodePointSetBuilder"
import type { DataError } from "./DataError"
import type { DataProvider } from "./DataProvider"
import type { pointer, codepoint } from "./diplomat-runtime.d.ts";


/**
 * See the [Rust documentation for `CaseMapCloser`](https://docs.rs/icu/latest/icu/casemap/struct.CaseMapCloser.html) for more information.
 */


export class CaseMapCloser {
    get ffiValue(): pointer;


    /**
     * Construct a new CaseMapCloser instance using a particular data source.
     *
     * See the [Rust documentation for `new`](https://docs.rs/icu/latest/icu/casemap/struct.CaseMapCloser.html#method.new) for more information.
     */
    static createWithProvider(provider: DataProvider): CaseMapCloser;

    /**
     * Adds all simple case mappings and the full case folding for `c` to `builder`.
     * Also adds special case closure mappings.
     *
     * See the [Rust documentation for `add_case_closure_to`](https://docs.rs/icu/latest/icu/casemap/struct.CaseMapCloserBorrowed.html#method.add_case_closure_to) for more information.
     */
    addCaseClosureTo(c: codepoint, builder: CodePointSetBuilder): void;

    /**
     * Finds all characters and strings which may casemap to `s` as their full case folding string
     * and adds them to the set.
     *
     * Returns true if the string was found
     *
     * See the [Rust documentation for `add_string_case_closure_to`](https://docs.rs/icu/latest/icu/casemap/struct.CaseMapCloserBorrowed.html#method.add_string_case_closure_to) for more information.
     */
    addStringCaseClosureTo(s: string, builder: CodePointSetBuilder): boolean;

    constructor();
}