// generated by diplomat-tool
import { DecimalLimitError } from "./DecimalLimitError.mjs"
import { DecimalParseError } from "./DecimalParseError.mjs"
import { DecimalRoundingIncrement } from "./DecimalRoundingIncrement.mjs"
import { DecimalSign } from "./DecimalSign.mjs"
import { DecimalSignDisplay } from "./DecimalSignDisplay.mjs"
import { DecimalSignedRoundingMode } from "./DecimalSignedRoundingMode.mjs"
import wasm from "./diplomat-wasm.mjs";
import * as diplomatRuntime from "./diplomat-runtime.mjs";


/**
 * See the [Rust documentation for `Decimal`](https://docs.rs/fixed_decimal/latest/fixed_decimal/type.Decimal.html) for more information.
 */
const Decimal_box_destroy_registry = new FinalizationRegistry((ptr) => {
    wasm.icu4x_Decimal_destroy_mv1(ptr);
});

export class Decimal {
    // Internal ptr reference:
    #ptr = null;

    // Lifetimes are only to keep dependencies alive.
    // Since JS won't garbage collect until there are no incoming edges.
    #selfEdge = [];

    #internalConstructor(symbol, ptr, selfEdge) {
        if (symbol !== diplomatRuntime.internalConstructor) {
            console.error("Decimal is an Opaque type. You cannot call its constructor.");
            return;
        }
        this.#ptr = ptr;
        this.#selfEdge = selfEdge;

        // Are we being borrowed? If not, we can register.
        if (this.#selfEdge.length === 0) {
            Decimal_box_destroy_registry.register(this, this.#ptr);
        }

        return this;
    }
    get ffiValue() {
        return this.#ptr;
    }


    /**
     * Construct an [`Decimal`] from an integer.
     *
     * See the [Rust documentation for `Decimal`](https://docs.rs/fixed_decimal/latest/fixed_decimal/struct.Decimal.html) for more information.
     */
    static fromNumber(v) {

        const result = wasm.icu4x_Decimal_from_int32_mv1(v);

        try {
            return new Decimal(diplomatRuntime.internalConstructor, result, []);
        }

        finally {
        }
    }

    /**
     * Construct an [`Decimal`] from an integer.
     *
     * See the [Rust documentation for `Decimal`](https://docs.rs/fixed_decimal/latest/fixed_decimal/struct.Decimal.html) for more information.
     */
    static fromBigInt(v) {

        const result = wasm.icu4x_Decimal_from_int64_mv1(v);

        try {
            return new Decimal(diplomatRuntime.internalConstructor, result, []);
        }

        finally {
        }
    }

    /**
     * Construct an [`Decimal`] from an float, with a given power of 10 for the lower magnitude
     *
     * See the [Rust documentation for `try_from_f64`](https://docs.rs/fixed_decimal/latest/fixed_decimal/type.Decimal.html#method.try_from_f64) for more information.
     *
     * See the [Rust documentation for `FloatPrecision`](https://docs.rs/fixed_decimal/latest/fixed_decimal/enum.FloatPrecision.html) for more information.
     */
    static fromNumberWithLowerMagnitude(f, magnitude) {
        const diplomatReceive = new diplomatRuntime.DiplomatReceiveBuf(wasm, 5, 4, true);


        const result = wasm.icu4x_Decimal_from_double_with_lower_magnitude_mv1(diplomatReceive.buffer, f, magnitude);

        try {
            if (!diplomatReceive.resultFlag) {
                const cause = DecimalLimitError.fromFields({}, diplomatRuntime.internalConstructor);
                throw new globalThis.Error('DecimalLimitError', { cause });
            }
            return new Decimal(diplomatRuntime.internalConstructor, diplomatRuntime.ptrRead(wasm, diplomatReceive.buffer), []);
        }

        finally {
            diplomatReceive.free();
        }
    }

    /**
     * Construct an [`Decimal`] from an float, for a given number of significant digits
     *
     * See the [Rust documentation for `try_from_f64`](https://docs.rs/fixed_decimal/latest/fixed_decimal/type.Decimal.html#method.try_from_f64) for more information.
     *
     * See the [Rust documentation for `FloatPrecision`](https://docs.rs/fixed_decimal/latest/fixed_decimal/enum.FloatPrecision.html) for more information.
     */
    static fromNumberWithSignificantDigits(f, digits) {
        const diplomatReceive = new diplomatRuntime.DiplomatReceiveBuf(wasm, 5, 4, true);


        const result = wasm.icu4x_Decimal_from_double_with_significant_digits_mv1(diplomatReceive.buffer, f, digits);

        try {
            if (!diplomatReceive.resultFlag) {
                const cause = DecimalLimitError.fromFields({}, diplomatRuntime.internalConstructor);
                throw new globalThis.Error('DecimalLimitError', { cause });
            }
            return new Decimal(diplomatRuntime.internalConstructor, diplomatRuntime.ptrRead(wasm, diplomatReceive.buffer), []);
        }

        finally {
            diplomatReceive.free();
        }
    }

    /**
     * Construct an [`Decimal`] from an float, with enough digits to recover
     * the original floating point in IEEE 754 without needing trailing zeros
     *
     * See the [Rust documentation for `try_from_f64`](https://docs.rs/fixed_decimal/latest/fixed_decimal/type.Decimal.html#method.try_from_f64) for more information.
     *
     * See the [Rust documentation for `FloatPrecision`](https://docs.rs/fixed_decimal/latest/fixed_decimal/enum.FloatPrecision.html) for more information.
     */
    static fromNumberWithRoundTripPrecision(f) {
        const diplomatReceive = new diplomatRuntime.DiplomatReceiveBuf(wasm, 5, 4, true);


        const result = wasm.icu4x_Decimal_from_double_with_round_trip_precision_mv1(diplomatReceive.buffer, f);

        try {
            if (!diplomatReceive.resultFlag) {
                const cause = DecimalLimitError.fromFields({}, diplomatRuntime.internalConstructor);
                throw new globalThis.Error('DecimalLimitError', { cause });
            }
            return new Decimal(diplomatRuntime.internalConstructor, diplomatRuntime.ptrRead(wasm, diplomatReceive.buffer), []);
        }

        finally {
            diplomatReceive.free();
        }
    }

    /**
     * Construct an [`Decimal`] from a string.
     *
     * See the [Rust documentation for `try_from_str`](https://docs.rs/fixed_decimal/latest/fixed_decimal/type.Decimal.html#method.try_from_str) for more information.
     */
    static fromString(v) {
        let functionCleanupArena = new diplomatRuntime.CleanupArena();

        const vSlice = diplomatRuntime.DiplomatBuf.str8(wasm, v);
        const diplomatReceive = new diplomatRuntime.DiplomatReceiveBuf(wasm, 5, 4, true);


        const result = wasm.icu4x_Decimal_from_string_mv1(diplomatReceive.buffer, ...vSlice.splat());

        try {
            if (!diplomatReceive.resultFlag) {
                const cause = new DecimalParseError(diplomatRuntime.internalConstructor, diplomatRuntime.enumDiscriminant(wasm, diplomatReceive.buffer));
                throw new globalThis.Error('DecimalParseError: ' + cause.value, { cause });
            }
            return new Decimal(diplomatRuntime.internalConstructor, diplomatRuntime.ptrRead(wasm, diplomatReceive.buffer), []);
        }

        finally {
            functionCleanupArena.free();

            diplomatReceive.free();
        }
    }

    /**
     * See the [Rust documentation for `digit_at`](https://docs.rs/fixed_decimal/latest/fixed_decimal/type.Decimal.html#method.digit_at) for more information.
     */
    digitAt(magnitude) {

        const result = wasm.icu4x_Decimal_digit_at_mv1(this.ffiValue, magnitude);

        try {
            return result;
        }

        finally {
        }
    }

    /**
     * See the [Rust documentation for `magnitude_range`](https://docs.rs/fixed_decimal/latest/fixed_decimal/type.Decimal.html#method.magnitude_range) for more information.
     */
    get magnitudeStart() {

        const result = wasm.icu4x_Decimal_magnitude_start_mv1(this.ffiValue);

        try {
            return result;
        }

        finally {
        }
    }

    /**
     * See the [Rust documentation for `magnitude_range`](https://docs.rs/fixed_decimal/latest/fixed_decimal/type.Decimal.html#method.magnitude_range) for more information.
     */
    get magnitudeEnd() {

        const result = wasm.icu4x_Decimal_magnitude_end_mv1(this.ffiValue);

        try {
            return result;
        }

        finally {
        }
    }

    /**
     * See the [Rust documentation for `nonzero_magnitude_start`](https://docs.rs/fixed_decimal/latest/fixed_decimal/type.Decimal.html#method.nonzero_magnitude_start) for more information.
     */
    get nonzeroMagnitudeStart() {

        const result = wasm.icu4x_Decimal_nonzero_magnitude_start_mv1(this.ffiValue);

        try {
            return result;
        }

        finally {
        }
    }

    /**
     * See the [Rust documentation for `nonzero_magnitude_end`](https://docs.rs/fixed_decimal/latest/fixed_decimal/type.Decimal.html#method.nonzero_magnitude_end) for more information.
     */
    get nonzeroMagnitudeEnd() {

        const result = wasm.icu4x_Decimal_nonzero_magnitude_end_mv1(this.ffiValue);

        try {
            return result;
        }

        finally {
        }
    }

    /**
     * See the [Rust documentation for `is_zero`](https://docs.rs/fixed_decimal/latest/fixed_decimal/type.Decimal.html#method.is_zero) for more information.
     */
    get isZero() {

        const result = wasm.icu4x_Decimal_is_zero_mv1(this.ffiValue);

        try {
            return result;
        }

        finally {
        }
    }

    /**
     * Multiply the [`Decimal`] by a given power of ten.
     *
     * See the [Rust documentation for `multiply_pow10`](https://docs.rs/fixed_decimal/latest/fixed_decimal/type.Decimal.html#method.multiply_pow10) for more information.
     */
    multiplyPow10(power) {
    wasm.icu4x_Decimal_multiply_pow10_mv1(this.ffiValue, power);

        try {}

        finally {
        }
    }

    /**
     * See the [Rust documentation for `sign`](https://docs.rs/fixed_decimal/latest/fixed_decimal/type.Decimal.html#method.sign) for more information.
     */
    get sign() {

        const result = wasm.icu4x_Decimal_sign_mv1(this.ffiValue);

        try {
            return new DecimalSign(diplomatRuntime.internalConstructor, result);
        }

        finally {
        }
    }

    /**
     * Set the sign of the [`Decimal`].
     *
     * See the [Rust documentation for `set_sign`](https://docs.rs/fixed_decimal/latest/fixed_decimal/type.Decimal.html#method.set_sign) for more information.
     */
    set sign(sign) {
    wasm.icu4x_Decimal_set_sign_mv1(this.ffiValue, sign.ffiValue);

        try {}

        finally {
        }
    }

    /**
     * See the [Rust documentation for `apply_sign_display`](https://docs.rs/fixed_decimal/latest/fixed_decimal/type.Decimal.html#method.apply_sign_display) for more information.
     */
    applySignDisplay(signDisplay) {
    wasm.icu4x_Decimal_apply_sign_display_mv1(this.ffiValue, signDisplay.ffiValue);

        try {}

        finally {
        }
    }

    /**
     * See the [Rust documentation for `trim_start`](https://docs.rs/fixed_decimal/latest/fixed_decimal/type.Decimal.html#method.trim_start) for more information.
     */
    trimStart() {
    wasm.icu4x_Decimal_trim_start_mv1(this.ffiValue);

        try {}

        finally {
        }
    }

    /**
     * See the [Rust documentation for `trim_end`](https://docs.rs/fixed_decimal/latest/fixed_decimal/type.Decimal.html#method.trim_end) for more information.
     */
    trimEnd() {
    wasm.icu4x_Decimal_trim_end_mv1(this.ffiValue);

        try {}

        finally {
        }
    }

    /**
     * See the [Rust documentation for `trim_end_if_integer`](https://docs.rs/fixed_decimal/latest/fixed_decimal/type.Decimal.html#method.trim_end_if_integer) for more information.
     */
    trimEndIfInteger() {
    wasm.icu4x_Decimal_trim_end_if_integer_mv1(this.ffiValue);

        try {}

        finally {
        }
    }

    /**
     * Zero-pad the [`Decimal`] on the left to a particular position
     *
     * See the [Rust documentation for `pad_start`](https://docs.rs/fixed_decimal/latest/fixed_decimal/type.Decimal.html#method.pad_start) for more information.
     */
    padStart(position) {
    wasm.icu4x_Decimal_pad_start_mv1(this.ffiValue, position);

        try {}

        finally {
        }
    }

    /**
     * Zero-pad the [`Decimal`] on the right to a particular position
     *
     * See the [Rust documentation for `pad_end`](https://docs.rs/fixed_decimal/latest/fixed_decimal/type.Decimal.html#method.pad_end) for more information.
     */
    padEnd(position) {
    wasm.icu4x_Decimal_pad_end_mv1(this.ffiValue, position);

        try {}

        finally {
        }
    }

    /**
     * Truncate the [`Decimal`] on the left to a particular position, deleting digits if necessary. This is useful for, e.g. abbreviating years
     * ("2022" -> "22")
     *
     * See the [Rust documentation for `set_max_position`](https://docs.rs/fixed_decimal/latest/fixed_decimal/type.Decimal.html#method.set_max_position) for more information.
     */
    setMaxPosition(position) {
    wasm.icu4x_Decimal_set_max_position_mv1(this.ffiValue, position);

        try {}

        finally {
        }
    }

    /**
     * Round the number at a particular digit position.
     *
     * This uses half to even rounding, which resolves ties by selecting the nearest
     * even integer to the original value.
     *
     * See the [Rust documentation for `round`](https://docs.rs/fixed_decimal/latest/fixed_decimal/type.Decimal.html#method.round) for more information.
     */
    round(position) {
    wasm.icu4x_Decimal_round_mv1(this.ffiValue, position);

        try {}

        finally {
        }
    }

    /**
     * See the [Rust documentation for `ceil`](https://docs.rs/fixed_decimal/latest/fixed_decimal/type.Decimal.html#method.ceil) for more information.
     */
    ceil(position) {
    wasm.icu4x_Decimal_ceil_mv1(this.ffiValue, position);

        try {}

        finally {
        }
    }

    /**
     * See the [Rust documentation for `expand`](https://docs.rs/fixed_decimal/latest/fixed_decimal/type.Decimal.html#method.expand) for more information.
     */
    expand(position) {
    wasm.icu4x_Decimal_expand_mv1(this.ffiValue, position);

        try {}

        finally {
        }
    }

    /**
     * See the [Rust documentation for `floor`](https://docs.rs/fixed_decimal/latest/fixed_decimal/type.Decimal.html#method.floor) for more information.
     */
    floor(position) {
    wasm.icu4x_Decimal_floor_mv1(this.ffiValue, position);

        try {}

        finally {
        }
    }

    /**
     * See the [Rust documentation for `trunc`](https://docs.rs/fixed_decimal/latest/fixed_decimal/type.Decimal.html#method.trunc) for more information.
     */
    trunc(position) {
    wasm.icu4x_Decimal_trunc_mv1(this.ffiValue, position);

        try {}

        finally {
        }
    }

    /**
     * See the [Rust documentation for `round_with_mode`](https://docs.rs/fixed_decimal/latest/fixed_decimal/type.Decimal.html#method.round_with_mode) for more information.
     */
    roundWithMode(position, mode) {
    wasm.icu4x_Decimal_round_with_mode_mv1(this.ffiValue, position, mode.ffiValue);

        try {}

        finally {
        }
    }

    /**
     * See the [Rust documentation for `round_with_mode_and_increment`](https://docs.rs/fixed_decimal/latest/fixed_decimal/type.Decimal.html#method.round_with_mode_and_increment) for more information.
     */
    roundWithModeAndIncrement(position, mode, increment) {
    wasm.icu4x_Decimal_round_with_mode_and_increment_mv1(this.ffiValue, position, mode.ffiValue, increment.ffiValue);

        try {}

        finally {
        }
    }

    /**
     * Concatenates `other` to the end of `self`.
     *
     * If successful, `other` will be set to 0 and a successful status is returned.
     *
     * If not successful, `other` will be unchanged and an error is returned.
     *
     * See the [Rust documentation for `concatenate_end`](https://docs.rs/fixed_decimal/latest/fixed_decimal/type.Decimal.html#method.concatenate_end) for more information.
     */
    concatenateEnd(other) {

        const result = wasm.icu4x_Decimal_concatenate_end_mv1(this.ffiValue, other.ffiValue);

        try {
            return result === 1;
        }

        finally {
        }
    }

    /**
     * Format the [`Decimal`] as a string.
     *
     * See the [Rust documentation for `write_to`](https://docs.rs/fixed_decimal/latest/fixed_decimal/type.Decimal.html#method.write_to) for more information.
     */
    toString() {
        const write = new diplomatRuntime.DiplomatWriteBuf(wasm);

    wasm.icu4x_Decimal_to_string_mv1(this.ffiValue, write.buffer);

        try {
            return write.readString8();
        }

        finally {
            write.free();
        }
    }

    constructor(symbol, ptr, selfEdge) {
        return this.#internalConstructor(...arguments)
    }
}