// =============================================================================
// Scilab ( https://www.scilab.org/ ) - This file is part of Scilab
// Copyright (C) 2025 - Dassault Systèmes S.E. - Vincent COUVERT
//
//  This file is distributed under the same license as the Scilab package.
// =============================================================================
//
// <-- Non-regression test for issue 17261 -->
//
// <-- INTERACTIVE TEST -->
//
// <-- GitLab URL -->
// https://gitlab.com/scilab/scilab/-/issues/17261
//
// <-- Short Description -->
// Some uicontrol such as text and editbox does now support scroll by mouse wheel

// Execute this script
// Check that figure vertical scrollbar moves when you move your mouse wheel over each uicontrol

fig = figure(...
    "infobar_visible", "off", ...
    "toolbar", "none", ...
    "menubar_visible", "off", ...
    "menubar", "none", ...
    "default_axes", "off", ...
    "layout", "border", ...
    "background", -2, ...
    "figure_size", [300 400]);

fr1 = uicontrol(fig, ...
    "style", "frame", ...
    "backgroundcolor", [1 1 1], ...
    "layout", "gridbag", ...
    "margins", [0 0 0 0], ...
    "scrollable", "on", ...
    "border", createBorder("matte", 1, 1, 1, 1, "#808080"), ...
    "constraints", createConstraints("gridbag", [1 1 1 1], [1 1], "both", "upper_left", [1 1], [300 630]));

c3 = createConstraints("gridbag", [1 1 1 1], [1 1], "none", "upper_left", [1 1], [280 630])

fr1_layer = uicontrol(fr1, ...
    "style", "layer", ...
    "backgroundcolor", [1 1 1], ...
    "userdata", "", ...
    "visible", "on", ...
    "constraints", c3);

fr1_1 = uicontrol(fr1_layer, ...
    "style", "frame", ...
    "backgroundcolor", [1 1 1], ...
    "margins", [0 3 5 0], ...
    "border", createBorder("matte", 0, 0, 0, 0, "#808080"), ...
    "userdata", "");

i = 0;
for style = ["pushbutton", "frame", "listbox", "tab", "text", "edit", "table"] // All uicontrol styles using JScrollPane
    for item = 1:3
        uicontrol(fr1_1, "FontSize", 15, ...
            "Position", [10 30*i 100,30], ...
            "String", style + " " + string(i), ...
            "Style", style);
        i = i + 1;
    end
end
