/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (https://www.swig.org).
 * Version 4.3.0
 *
 * Do not make changes to this file unless you know what you are doing - modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */


#define SWIG_VERSION 0x040300
#define SWIGJAVA
#define SWIG_DIRECTORS

/* -----------------------------------------------------------------------------
 *  This section contains generic SWIG labels for method/variable
 *  declarations/attributes, and other compiler dependent labels.
 * ----------------------------------------------------------------------------- */

/* template workaround for compilers that cannot correctly implement the C++ standard */
#ifndef SWIGTEMPLATEDISAMBIGUATOR
# if defined(__SUNPRO_CC) && (__SUNPRO_CC <= 0x560)
#  define SWIGTEMPLATEDISAMBIGUATOR template
# elif defined(__HP_aCC)
/* Needed even with `aCC -AA' when `aCC -V' reports HP ANSI C++ B3910B A.03.55 */
/* If we find a maximum version that requires this, the test would be __HP_aCC <= 35500 for A.03.55 */
#  define SWIGTEMPLATEDISAMBIGUATOR template
# else
#  define SWIGTEMPLATEDISAMBIGUATOR
# endif
#endif

/* inline attribute */
#ifndef SWIGINLINE
# if defined(__cplusplus) || (defined(__GNUC__) && !defined(__STRICT_ANSI__))
#   define SWIGINLINE inline
# else
#   define SWIGINLINE
# endif
#endif

/* attribute recognised by some compilers to avoid 'unused' warnings */
#ifndef SWIGUNUSED
# if defined(__GNUC__)
#   if !(defined(__cplusplus)) || (__GNUC__ > 3 || (__GNUC__ == 3 && __GNUC_MINOR__ >= 4))
#     define SWIGUNUSED __attribute__ ((__unused__))
#   else
#     define SWIGUNUSED
#   endif
# elif defined(__ICC)
#   define SWIGUNUSED __attribute__ ((__unused__))
# else
#   define SWIGUNUSED
# endif
#endif

#ifndef SWIG_MSC_UNSUPPRESS_4505
# if defined(_MSC_VER)
#   pragma warning(disable : 4505) /* unreferenced local function has been removed */
# endif
#endif

#ifndef SWIGUNUSEDPARM
# ifdef __cplusplus
#   define SWIGUNUSEDPARM(p)
# else
#   define SWIGUNUSEDPARM(p) p SWIGUNUSED
# endif
#endif

/* internal SWIG method */
#ifndef SWIGINTERN
# define SWIGINTERN static SWIGUNUSED
#endif

/* internal inline SWIG method */
#ifndef SWIGINTERNINLINE
# define SWIGINTERNINLINE SWIGINTERN SWIGINLINE
#endif

/* exporting methods */
#if defined(__GNUC__)
#  if (__GNUC__ >= 4) || (__GNUC__ == 3 && __GNUC_MINOR__ >= 4)
#    ifndef GCC_HASCLASSVISIBILITY
#      define GCC_HASCLASSVISIBILITY
#    endif
#  endif
#endif

#ifndef SWIGEXPORT
# if defined(_WIN32) || defined(__WIN32__) || defined(__CYGWIN__)
#   if defined(STATIC_LINKED)
#     define SWIGEXPORT
#   else
#     define SWIGEXPORT __declspec(dllexport)
#   endif
# else
#   if defined(__GNUC__) && defined(GCC_HASCLASSVISIBILITY)
#     define SWIGEXPORT __attribute__ ((visibility("default")))
#   else
#     define SWIGEXPORT
#   endif
# endif
#endif

/* calling conventions for Windows */
#ifndef SWIGSTDCALL
# if defined(_WIN32) || defined(__WIN32__) || defined(__CYGWIN__)
#   define SWIGSTDCALL __stdcall
# else
#   define SWIGSTDCALL
# endif
#endif

/* Deal with Microsoft's attempt at deprecating C standard runtime functions */
#if !defined(SWIG_NO_CRT_SECURE_NO_DEPRECATE) && defined(_MSC_VER) && !defined(_CRT_SECURE_NO_DEPRECATE)
# define _CRT_SECURE_NO_DEPRECATE
#endif

/* Deal with Microsoft's attempt at deprecating methods in the standard C++ library */
#if !defined(SWIG_NO_SCL_SECURE_NO_DEPRECATE) && defined(_MSC_VER) && !defined(_SCL_SECURE_NO_DEPRECATE)
# define _SCL_SECURE_NO_DEPRECATE
#endif

/* Deal with Apple's deprecated 'AssertMacros.h' from Carbon-framework */
#if defined(__APPLE__) && !defined(__ASSERT_MACROS_DEFINE_VERSIONS_WITHOUT_UNDERSCORES)
# define __ASSERT_MACROS_DEFINE_VERSIONS_WITHOUT_UNDERSCORES 0
#endif

/* Intel's compiler complains if a variable which was never initialised is
 * cast to void, which is a common idiom which we use to indicate that we
 * are aware a variable isn't used.  So we just silence that warning.
 * See: https://github.com/swig/swig/issues/192 for more discussion.
 */
#ifdef __INTEL_COMPILER
# pragma warning disable 592
#endif

#if defined(__cplusplus) && __cplusplus >=201103L
# define SWIG_NULLPTR nullptr
#else
# define SWIG_NULLPTR NULL
#endif 

/* -----------------------------------------------------------------------------
 * swigcompat.swg
 *
 * Macros to provide support compatibility with older C and C++ standards.
 *
 * Note that SWIG expects __cplusplus to be defined to the appropriate C++ standard.
 * MSVC users are urged to check and examine the /Zc:__cplusplus compiler option.
 * See https://learn.microsoft.com/en-us/cpp/build/reference/zc-cplusplus.
 * ----------------------------------------------------------------------------- */

/* C99 and C++11 should provide snprintf, but define SWIG_NO_SNPRINTF
 * if you're missing it.
 */
#if ((defined __STDC_VERSION__ && __STDC_VERSION__ >= 199901L) || \
     (defined __cplusplus && __cplusplus >= 201103L) || \
     defined SWIG_HAVE_SNPRINTF) && \
    !defined SWIG_NO_SNPRINTF
# define SWIG_snprintf(O,S,F,A) snprintf(O,S,F,A)
# define SWIG_snprintf2(O,S,F,A,B) snprintf(O,S,F,A,B)
#else
/* Fallback versions ignore the buffer size, but most of our uses either have a
 * fixed maximum possible size or dynamically allocate a buffer that's large
 * enough.
 */
# define SWIG_snprintf(O,S,F,A) sprintf(O,F,A)
# define SWIG_snprintf2(O,S,F,A,B) sprintf(O,F,A,B)
#endif


#include <jni.h>
#include <stdlib.h>
#include <string.h>


/* Support for throwing Java exceptions */
typedef enum {
  SWIG_JavaOutOfMemoryError = 1,
  SWIG_JavaIOException,
  SWIG_JavaRuntimeException,
  SWIG_JavaIndexOutOfBoundsException,
  SWIG_JavaArithmeticException,
  SWIG_JavaIllegalArgumentException,
  SWIG_JavaNullPointerException,
  SWIG_JavaDirectorPureVirtual,
  SWIG_JavaUnknownError,
  SWIG_JavaIllegalStateException,
} SWIG_JavaExceptionCodes;

typedef struct {
  SWIG_JavaExceptionCodes code;
  const char *java_exception;
} SWIG_JavaExceptions_t;


static void SWIGUNUSED SWIG_JavaThrowException(JNIEnv *jenv, SWIG_JavaExceptionCodes code, const char *msg) {
  jclass excep;
  static const SWIG_JavaExceptions_t java_exceptions[] = {
    { SWIG_JavaOutOfMemoryError, "java/lang/OutOfMemoryError" },
    { SWIG_JavaIOException, "java/io/IOException" },
    { SWIG_JavaRuntimeException, "java/lang/RuntimeException" },
    { SWIG_JavaIndexOutOfBoundsException, "java/lang/IndexOutOfBoundsException" },
    { SWIG_JavaArithmeticException, "java/lang/ArithmeticException" },
    { SWIG_JavaIllegalArgumentException, "java/lang/IllegalArgumentException" },
    { SWIG_JavaNullPointerException, "java/lang/NullPointerException" },
    { SWIG_JavaDirectorPureVirtual, "java/lang/RuntimeException" },
    { SWIG_JavaUnknownError,  "java/lang/UnknownError" },
    { SWIG_JavaIllegalStateException, "java/lang/IllegalStateException" },
    { (SWIG_JavaExceptionCodes)0,  "java/lang/UnknownError" }
  };
  const SWIG_JavaExceptions_t *except_ptr = java_exceptions;

  while (except_ptr->code != code && except_ptr->code)
    except_ptr++;

  jenv->ExceptionClear();
  excep = jenv->FindClass(except_ptr->java_exception);
  if (excep)
    jenv->ThrowNew(excep, msg);
}


/* Contract support */

#define SWIG_contract_assert(nullreturn, expr, msg) do { if (!(expr)) {SWIG_JavaThrowException(jenv, SWIG_JavaIllegalArgumentException, msg); return nullreturn; } } while (0)

/* -----------------------------------------------------------------------------
 * director_common.swg
 *
 * This file contains support for director classes which is common between
 * languages.
 * ----------------------------------------------------------------------------- */

/*
  Use -DSWIG_DIRECTOR_STATIC if you prefer to avoid the use of the
  'Swig' namespace. This could be useful for multi-modules projects.
*/
#ifdef SWIG_DIRECTOR_STATIC
/* Force anonymous (static) namespace */
#define Swig
#endif
/* -----------------------------------------------------------------------------
 * director.swg
 *
 * This file contains support for director classes so that Java proxy
 * methods can be called from C++.
 * ----------------------------------------------------------------------------- */

#if defined(DEBUG_DIRECTOR_OWNED) || defined(DEBUG_DIRECTOR_EXCEPTION) || defined(DEBUG_DIRECTOR_THREAD_NAME)
#include <iostream>
#endif

#include <exception>

#if defined(SWIG_JAVA_USE_THREAD_NAME)

#if !defined(SWIG_JAVA_GET_THREAD_NAME)
namespace Swig {
  SWIGINTERN int GetThreadName(char *name, size_t len);
}

#if defined(__linux__)

#include <sys/prctl.h>
SWIGINTERN int Swig::GetThreadName(char *name, size_t len) {
  (void)len;
#if defined(PR_GET_NAME)
  return prctl(PR_GET_NAME, (unsigned long)name, 0, 0, 0);
#else
  (void)name;
  return 1;
#endif
}

#elif defined(__unix__) || defined(__APPLE__)

#include <pthread.h>
SWIGINTERN int Swig::GetThreadName(char *name, size_t len) {
  return pthread_getname_np(pthread_self(), name, len);
}

#else

SWIGINTERN int Swig::GetThreadName(char *name, size_t len) {
  (void)len;
  (void)name;
  return 1;
}
#endif

#endif

#endif

#if defined(SWIG_JAVA_DETACH_ON_THREAD_END)
#include <pthread.h>
#endif

namespace Swig {

  /* Java object wrapper */
  class JObjectWrapper {
  public:
    JObjectWrapper() : jthis_(SWIG_NULLPTR), weak_global_(true) {
    }

    ~JObjectWrapper() {
      jthis_ = SWIG_NULLPTR;
      weak_global_ = true;
    }

    bool set(JNIEnv *jenv, jobject jobj, bool mem_own, bool weak_global) {
      if (!jthis_) {
        weak_global_ = weak_global || !mem_own; // hold as weak global if explicitly requested or not owned
        if (jobj)
          jthis_ = weak_global_ ? jenv->NewWeakGlobalRef(jobj) : jenv->NewGlobalRef(jobj);
#if defined(DEBUG_DIRECTOR_OWNED)
        std::cout << "JObjectWrapper::set(" << jobj << ", " << (weak_global ? "weak_global" : "global_ref") << ") -> " << jthis_ << std::endl;
#endif
        return true;
      } else {
#if defined(DEBUG_DIRECTOR_OWNED)
        std::cout << "JObjectWrapper::set(" << jobj << ", " << (weak_global ? "weak_global" : "global_ref") << ") -> already set" << std::endl;
#endif
        return false;
      }
    }

    jobject get(JNIEnv *jenv) const {
#if defined(DEBUG_DIRECTOR_OWNED)
      std::cout << "JObjectWrapper::get(";
      if (jthis_)
        std::cout << jthis_;
      else
        std::cout << "null";
      std::cout << ") -> return new local ref" << std::endl;
#endif
      return (jthis_ ? jenv->NewLocalRef(jthis_) : jthis_);
    }

    void release(JNIEnv *jenv) {
#if defined(DEBUG_DIRECTOR_OWNED)
      std::cout << "JObjectWrapper::release(" << jthis_ << "): " << (weak_global_ ? "weak global ref" : "global ref") << std::endl;
#endif
      if (jthis_) {
        if (weak_global_) {
          if (jenv->IsSameObject(jthis_, SWIG_NULLPTR) == JNI_FALSE)
            jenv->DeleteWeakGlobalRef((jweak)jthis_);
        } else
          jenv->DeleteGlobalRef(jthis_);
      }

      jthis_ = SWIG_NULLPTR;
      weak_global_ = true;
    }

    /* Only call peek if you know what you are doing wrt to weak/global references */
    jobject peek() {
      return jthis_;
    }

    /* Java proxy releases ownership of C++ object, C++ object is now
       responsible for destruction (creates NewGlobalRef to pin Java proxy) */
    void java_change_ownership(JNIEnv *jenv, jobject jself, bool take_or_release) {
      if (take_or_release) {  /* Java takes ownership of C++ object's lifetime. */
        if (!weak_global_) {
          jenv->DeleteGlobalRef(jthis_);
          jthis_ = jenv->NewWeakGlobalRef(jself);
          weak_global_ = true;
        }
      } else {
	/* Java releases ownership of C++ object's lifetime */
        if (weak_global_) {
          jenv->DeleteWeakGlobalRef((jweak)jthis_);
          jthis_ = jenv->NewGlobalRef(jself);
          weak_global_ = false;
        }
      }
    }

#if defined(SWIG_JAVA_DETACH_ON_THREAD_END)
    static void detach(void *jvm) {
      static_cast<JavaVM *>(jvm)->DetachCurrentThread();
    }

    static void make_detach_key() {
      pthread_key_create(&detach_key_, detach);
    }

    /* thread-local key to register a destructor */
    static pthread_key_t detach_key_;
#endif

  private:
    /* pointer to Java object */
    jobject jthis_;
    /* Local or global reference flag */
    bool weak_global_;
  };

#if defined(SWIG_JAVA_DETACH_ON_THREAD_END)
  pthread_key_t JObjectWrapper::detach_key_;
#endif

  /* Local JNI reference deleter */
  class LocalRefGuard {
    JNIEnv *jenv_;
    jobject jobj_;

    // non-copyable
    LocalRefGuard(const LocalRefGuard &);
    LocalRefGuard &operator=(const LocalRefGuard &);
  public:
    LocalRefGuard(JNIEnv *jenv, jobject jobj): jenv_(jenv), jobj_(jobj) {}
    ~LocalRefGuard() {
      if (jobj_)
        jenv_->DeleteLocalRef(jobj_);
    }
  };

  /* director base class */
  class Director {
    /* pointer to Java virtual machine */
    JavaVM *swig_jvm_;

  protected:
#if defined (_MSC_VER) && (_MSC_VER<1300)
    class JNIEnvWrapper;
    friend class JNIEnvWrapper;
#endif
    /* Utility class for managing the JNI environment */
    class JNIEnvWrapper {
      const Director *director_;
      JNIEnv *jenv_;
      int env_status;
    public:
      JNIEnvWrapper(const Director *director) : director_(director), jenv_(SWIG_NULLPTR), env_status(0) {
#if defined(__ANDROID__)
        JNIEnv **jenv = &jenv_;
#else
        void **jenv = (void **)&jenv_;
#endif
        env_status = director_->swig_jvm_->GetEnv((void **)&jenv_, JNI_VERSION_1_2);
        JavaVMAttachArgs args;
        args.version = JNI_VERSION_1_2;
        args.group = SWIG_NULLPTR;
        args.name = SWIG_NULLPTR;
#if defined(SWIG_JAVA_USE_THREAD_NAME)
        char thread_name[64];  // MAX_TASK_COMM_LEN=16 is hard-coded in the Linux kernel and MacOS has MAXTHREADNAMESIZE=64.
        if (Swig::GetThreadName(thread_name, sizeof(thread_name)) == 0) {
          args.name = thread_name;
#if defined(DEBUG_DIRECTOR_THREAD_NAME)
          std::cout << "JNIEnvWrapper: thread name: " << thread_name << std::endl;
        } else {
          std::cout << "JNIEnvWrapper: Couldn't set Java thread name" << std::endl;
#endif
        }
#endif
#if defined(SWIG_JAVA_ATTACH_CURRENT_THREAD_AS_DAEMON)
        // Attach a daemon thread to the JVM. Useful when the JVM should not wait for
        // the thread to exit upon shutdown. Only for jdk-1.4 and later.
        director_->swig_jvm_->AttachCurrentThreadAsDaemon(jenv, &args);
#else
        director_->swig_jvm_->AttachCurrentThread(jenv, &args);
#endif

#if defined(SWIG_JAVA_DETACH_ON_THREAD_END)
        // At least on Android 6, detaching after every call causes a memory leak.
        // Instead, register a thread desructor and detach only when the thread ends.
        // See https://developer.android.com/training/articles/perf-jni#threads
        static pthread_once_t once = PTHREAD_ONCE_INIT;

        pthread_once(&once, JObjectWrapper::make_detach_key);
        pthread_setspecific(JObjectWrapper::detach_key_, director->swig_jvm_);
#endif
      }
      ~JNIEnvWrapper() {
#if !defined(SWIG_JAVA_DETACH_ON_THREAD_END) && !defined(SWIG_JAVA_NO_DETACH_CURRENT_THREAD)
        // Some JVMs, eg jdk-1.4.2 and lower on Solaris have a bug and crash with the DetachCurrentThread call.
        // However, without this call, the JVM hangs on exit when the thread was not created by the JVM and creates a memory leak.
        if (env_status == JNI_EDETACHED)
          director_->swig_jvm_->DetachCurrentThread();
#endif
      }
      JNIEnv *getJNIEnv() const {
        return jenv_;
      }
    };

    struct SwigDirectorMethod {
      const char *name;
      const char *desc;
      jmethodID methid;
      SwigDirectorMethod(JNIEnv *jenv, jclass baseclass, const char *name, const char *desc) : name(name), desc(desc) {
        methid = jenv->GetMethodID(baseclass, name, desc);
      }
    };

    /* Java object wrapper */
    JObjectWrapper swig_self_;

    /* Disconnect director from Java object */
    void swig_disconnect_director_self(const char *disconn_method) {
      JNIEnvWrapper jnienv(this) ;
      JNIEnv *jenv = jnienv.getJNIEnv() ;
      jobject jobj = swig_self_.get(jenv);
      LocalRefGuard ref_deleter(jenv, jobj);
#if defined(DEBUG_DIRECTOR_OWNED)
      std::cout << "Swig::Director::disconnect_director_self(" << jobj << ")" << std::endl;
#endif
      if (jobj && jenv->IsSameObject(jobj, SWIG_NULLPTR) == JNI_FALSE) {
        jmethodID disconn_meth = jenv->GetMethodID(jenv->GetObjectClass(jobj), disconn_method, "()V");
        if (disconn_meth) {
#if defined(DEBUG_DIRECTOR_OWNED)
          std::cout << "Swig::Director::disconnect_director_self upcall to " << disconn_method << std::endl;
#endif
          jenv->CallVoidMethod(jobj, disconn_meth);
        }
      }
    }

    jclass swig_new_global_ref(JNIEnv *jenv, const char *classname) {
      jclass clz = jenv->FindClass(classname);
      return clz ? (jclass)jenv->NewGlobalRef(clz) : SWIG_NULLPTR;
    }

  public:
    Director(JNIEnv *jenv) : swig_jvm_((JavaVM *) SWIG_NULLPTR), swig_self_() {
      /* Acquire the Java VM pointer */
      jenv->GetJavaVM(&swig_jvm_);
    }

    virtual ~Director() {
      JNIEnvWrapper jnienv(this) ;
      JNIEnv *jenv = jnienv.getJNIEnv() ;
      swig_self_.release(jenv);
    }

    bool swig_set_self(JNIEnv *jenv, jobject jself, bool mem_own, bool weak_global) {
      return swig_self_.set(jenv, jself, mem_own, weak_global);
    }

    jobject swig_get_self(JNIEnv *jenv) const {
      return swig_self_.get(jenv);
    }

    // Change C++ object's ownership, relative to Java
    void swig_java_change_ownership(JNIEnv *jenv, jobject jself, bool take_or_release) {
      swig_self_.java_change_ownership(jenv, jself, take_or_release);
    }
  };

  // Zero initialized bool array
  template<size_t N> class BoolArray {
    bool array_[N];
  public:
    BoolArray() {
      memset(array_, 0, sizeof(array_));
    }
    bool& operator[](size_t n) {
      return array_[n];
    }
    bool operator[](size_t n) const {
      return array_[n];
    }
  };

  // Utility classes and functions for exception handling.

  // Simple holder for a Java string during exception handling, providing access to a c-style string
  class JavaString {
  public:
    JavaString(JNIEnv *jenv, jstring jstr) : jenv_(jenv), jstr_(jstr), cstr_(SWIG_NULLPTR) {
      if (jenv_ && jstr_)
	cstr_ = (const char *) jenv_->GetStringUTFChars(jstr_, SWIG_NULLPTR);
    }

    ~JavaString() {
      if (jenv_ && jstr_ && cstr_)
	jenv_->ReleaseStringUTFChars(jstr_, cstr_);
    }

    const char *c_str(const char *null_string = "null JavaString") const {
      return cstr_ ? cstr_ : null_string;
    }

  private:
    // non-copyable
    JavaString(const JavaString &);
    JavaString &operator=(const JavaString &);

    JNIEnv *jenv_;
    jstring jstr_;
    const char *cstr_;
  };

  // Helper class to extract the exception message from a Java throwable
  class JavaExceptionMessage {
  public:
    JavaExceptionMessage(JNIEnv *jenv, jthrowable throwable) : message_(jenv, exceptionMessageFromThrowable(jenv, throwable)) {
    }

    // Return a C string of the exception message in the jthrowable passed in the constructor
    // If no message is available, null_string is return instead
    const char *message(const char *null_string = "Could not get exception message in JavaExceptionMessage") const {
      return message_.c_str(null_string);
    }

  private:
    // non-copyable
    JavaExceptionMessage(const JavaExceptionMessage &);
    JavaExceptionMessage &operator=(const JavaExceptionMessage &);

    // Get exception message by calling Java method Throwable.getMessage()
    static jstring exceptionMessageFromThrowable(JNIEnv *jenv, jthrowable throwable) {
      jstring jmsg = SWIG_NULLPTR;
      if (jenv && throwable) {
	jenv->ExceptionClear(); // Cannot invoke methods with any pending exceptions
	jclass throwclz = jenv->GetObjectClass(throwable);
	if (throwclz) {
	  // All Throwable classes have a getMessage() method, so call it to extract the exception message
	  jmethodID getMessageMethodID = jenv->GetMethodID(throwclz, "getMessage", "()Ljava/lang/String;");
	  if (getMessageMethodID)
	    jmsg = (jstring)jenv->CallObjectMethod(throwable, getMessageMethodID);
	}
	if (jmsg == SWIG_NULLPTR && jenv->ExceptionCheck())
	  jenv->ExceptionClear();
      }
      return jmsg;
    }

    JavaString message_;
  };

  // C++ Exception class for handling Java exceptions thrown during a director method Java upcall
  class DirectorException : public std::exception {
  public:

    // Construct exception from a Java throwable
    DirectorException(JNIEnv *jenv, jthrowable throwable) : jenv_(jenv), throwable_(throwable), classname_(SWIG_NULLPTR), msg_(SWIG_NULLPTR) {

      // Call Java method Object.getClass().getName() to obtain the throwable's class name (delimited by '/')
      if (jenv && throwable) {
	jenv->ExceptionClear(); // Cannot invoke methods with any pending exceptions
	jclass throwclz = jenv->GetObjectClass(throwable);
	if (throwclz) {
	  jclass clzclz = jenv->GetObjectClass(throwclz);
	  if (clzclz) {
	    jmethodID getNameMethodID = jenv->GetMethodID(clzclz, "getName", "()Ljava/lang/String;");
	    if (getNameMethodID) {
	      jstring jstr_classname = (jstring)(jenv->CallObjectMethod(throwclz, getNameMethodID));
              // Copy strings, since there is no guarantee that jenv will be active when handled
              if (jstr_classname) {
                JavaString jsclassname(jenv, jstr_classname);
                const char *classname = jsclassname.c_str(SWIG_NULLPTR);
                if (classname)
                  classname_ = copypath(classname);
              }
	    }
	  }
	}
      }

      JavaExceptionMessage exceptionmsg(jenv, throwable);
      msg_ = copystr(exceptionmsg.message(SWIG_NULLPTR));
    }

    // More general constructor for handling as a java.lang.RuntimeException
    DirectorException(const char *msg) : jenv_(SWIG_NULLPTR), throwable_(SWIG_NULLPTR), classname_(SWIG_NULLPTR), msg_(msg ? copystr(msg) : SWIG_NULLPTR) {
    }

    ~DirectorException() throw() {
      delete[] classname_;
      delete[] msg_;
    }

    const char *what() const throw() {
      return msg_ ? msg_ : "Unspecified DirectorException message";
    }

    // Reconstruct and raise/throw the Java Exception that caused the DirectorException
    // Note that any error in the JNI exception handling results in a Java RuntimeException
    void throwException(JNIEnv *jenv) const {
      if (jenv) {
        if (jenv == jenv_ && throwable_) {
          // Throw original exception if not already pending
          jthrowable throwable = jenv->ExceptionOccurred();
          if (throwable && jenv->IsSameObject(throwable, throwable_) == JNI_FALSE) {
            jenv->ExceptionClear();
            throwable = SWIG_NULLPTR;
          }
          if (!throwable)
            jenv->Throw(throwable_);
        } else {
          // Try and reconstruct original exception, but original stacktrace is not reconstructed
          jenv->ExceptionClear();

          jmethodID ctorMethodID = SWIG_NULLPTR;
          jclass throwableclass = SWIG_NULLPTR;
          if (classname_) {
            throwableclass = jenv->FindClass(classname_);
            if (throwableclass)
              ctorMethodID = jenv->GetMethodID(throwableclass, "<init>", "(Ljava/lang/String;)V");
          }

          if (ctorMethodID) {
            jenv->ThrowNew(throwableclass, what());
          } else {
            SWIG_JavaThrowException(jenv, SWIG_JavaRuntimeException, what());
          }
        }
      }
    }

    // Deprecated - use throwException
    void raiseJavaException(JNIEnv *jenv) const {
      throwException(jenv);
    }

    // Create and throw the DirectorException
    static void raise(JNIEnv *jenv, jthrowable throwable) {
      throw DirectorException(jenv, throwable);
    }

  private:
    static char *copypath(const char *srcmsg) {
      char *target = copystr(srcmsg);
      for (char *c=target; *c; ++c) {
        if ('.' == *c)
          *c = '/';
      }
      return target;
    }

    static char *copystr(const char *srcmsg) {
      char *target = SWIG_NULLPTR;
      if (srcmsg) {
	size_t msglen = strlen(srcmsg) + 1;
	target = new char[msglen];
	strncpy(target, srcmsg, msglen);
      }
      return target;
    }

    JNIEnv *jenv_;
    jthrowable throwable_;
    const char *classname_;
    const char *msg_;
  };

  // Helper method to determine if a Java throwable matches a particular Java class type
  // Note side effect of clearing any pending exceptions
  SWIGINTERN bool ExceptionMatches(JNIEnv *jenv, jthrowable throwable, const char *classname) {
    bool matches = false;

    if (throwable && jenv && classname) {
      // Exceptions need to be cleared for correct behavior.
      // The caller of ExceptionMatches should restore pending exceptions if desired -
      // the caller already has the throwable.
      jenv->ExceptionClear();

      jclass clz = jenv->FindClass(classname);
      if (clz) {
	jclass classclz = jenv->GetObjectClass(clz);
	jmethodID isInstanceMethodID = jenv->GetMethodID(classclz, "isInstance", "(Ljava/lang/Object;)Z");
	if (isInstanceMethodID) {
	  matches = jenv->CallBooleanMethod(clz, isInstanceMethodID, throwable) != 0;
	}
      }

#if defined(DEBUG_DIRECTOR_EXCEPTION)
      if (jenv->ExceptionCheck()) {
        // Typically occurs when an invalid classname argument is passed resulting in a ClassNotFoundException
        JavaExceptionMessage exc(jenv, jenv->ExceptionOccurred());
        std::cout << "Error: ExceptionMatches: class '" << classname << "' : " << exc.message() << std::endl;
      }
#endif
    }
    return matches;
  }
}

namespace Swig {
  namespace {
    jclass jclass_JavaControllerJNI = NULL;
    jmethodID director_method_ids[6];
  }
}

#ifdef __cplusplus
#include <utility>
/* SwigValueWrapper is described in swig.swg */
template<typename T> class SwigValueWrapper {
  struct SwigSmartPointer {
    T *ptr;
    SwigSmartPointer(T *p) : ptr(p) { }
    ~SwigSmartPointer() { delete ptr; }
    SwigSmartPointer& operator=(SwigSmartPointer& rhs) { T* oldptr = ptr; ptr = 0; delete oldptr; ptr = rhs.ptr; rhs.ptr = 0; return *this; }
    void reset(T *p) { T* oldptr = ptr; ptr = 0; delete oldptr; ptr = p; }
  } pointer;
  SwigValueWrapper& operator=(const SwigValueWrapper<T>& rhs);
  SwigValueWrapper(const SwigValueWrapper<T>& rhs);
public:
  SwigValueWrapper() : pointer(0) { }
  SwigValueWrapper& operator=(const T& t) { SwigSmartPointer tmp(new T(t)); pointer = tmp; return *this; }
#if __cplusplus >=201103L
  SwigValueWrapper& operator=(T&& t) { SwigSmartPointer tmp(new T(std::move(t))); pointer = tmp; return *this; }
  operator T&&() const { return std::move(*pointer.ptr); }
#else
  operator T&() const { return *pointer.ptr; }
#endif
  T *operator&() const { return pointer.ptr; }
  static void reset(SwigValueWrapper& t, T *p) { t.pointer.reset(p); }
};

/*
 * SwigValueInit() is a generic initialisation solution as the following approach:
 * 
 *       T c_result = T();
 * 
 * doesn't compile for all types for example:
 * 
 *       unsigned int c_result = unsigned int();
 */
template <typename T> T SwigValueInit() {
  return T();
}

#if __cplusplus >=201103L
# define SWIG_STD_MOVE(OBJ) std::move(OBJ)
#else
# define SWIG_STD_MOVE(OBJ) OBJ
#endif

#endif


#include <iterator>
#include <algorithm>
#include <vector>
#include <string>

#include "utilities.hxx"
#include "View.hxx"
#include "Controller.hxx"

#include "scicos.h"



#include <typeinfo>
#include <stdexcept>


#include <string>

SWIGINTERN bool std_vector_Sl_int_Sg__contains(std::vector< int > *self,int const &o){
               return std::find(self->begin(), self->end(), o) != self->end();
            }
SWIGINTERN int std_vector_Sl_int_Sg__indexOf(std::vector< int > *self,int const &o){
               auto it = std::find(self->begin(), self->end(), o);
               if (it != self->end())
                   return std::distance(self->begin(), it);
               else
                   return -1;
            }
SWIGINTERN std::vector< int >::const_reference std_vector_Sl_int_Sg__get(std::vector< int > *self,int i){
                int size = int(self->size());
                if (i>=0 && i<size)
                    return (*self)[i];
                else
                    throw std::out_of_range("vector index out of range");
            }
SWIGINTERN void std_vector_Sl_int_Sg__set(std::vector< int > *self,int i,std::vector< int >::value_type const &val){
                int size = int(self->size());
                if (i>=0 && i<size)
                    (*self)[i] = val;
                else
                    throw std::out_of_range("vector index out of range");
            }
SWIGINTERN void std_vector_Sl_int_Sg__add__SWIG_1(std::vector< int > *self,int i,std::vector< int >::value_type const &val){
                int size = int(self->size());
                if (i>=0 && i<=size)
                    self->insert(self->begin() + i, val);
                else
                    throw std::out_of_range("vector index out of range");
            }
SWIGINTERN bool std_vector_Sl_int_Sg__remove(std::vector< int > *self,std::vector< int >::value_type const &val){
                auto it = std::find(self->begin(), self->end(), val);
                if (it == self->end())
                    return false;
                else
                    self->erase(it);
                return true;
            }
SWIGINTERN void *std_vector_Sl_int_Sg__asByteBuffer(std::vector< int > *self,int i,int capacity){
                (void) capacity;
                void* buffer = nullptr;
                int size = int(self->size()) ;
                if (i>=0 && i<size) {
                    buffer = self->data() + i;
                } else if (i==0 && size == 0) {
                    buffer = self->data();
                } else {
                    throw std::out_of_range("vector index out of range");
                }
                return buffer;
            }
SWIGINTERN bool std_vector_Sl_bool_Sg__get(std::vector< bool > *self,int i){
                int size = int(self->size());
                if (i>=0 && i<size)
                    return (*self)[i];
                else
                    throw std::out_of_range("vector index out of range");
            }
SWIGINTERN void std_vector_Sl_bool_Sg__set(std::vector< bool > *self,int i,std::vector< bool >::value_type const &val){
                int size = int(self->size());
                if (i>=0 && i<size)
                    (*self)[i] = val;
                else
                    throw std::out_of_range("vector index out of range");
            }
SWIGINTERN void std_vector_Sl_bool_Sg__add__SWIG_1(std::vector< bool > *self,int i,std::vector< bool >::value_type const &val){
                int size = int(self->size());
                if (i>=0 && i<=size)
                    self->insert(self->begin() + i, val);
                else
                    throw std::out_of_range("vector index out of range");
            }
SWIGINTERN bool std_vector_Sl_bool_Sg__remove(std::vector< bool > *self,std::vector< bool >::value_type const &val){
                auto it = std::find(self->begin(), self->end(), val);
                if (it == self->end())
                    return false;
                else
                    self->erase(it);
                return true;
            }
SWIGINTERN bool std_vector_Sl_double_Sg__contains(std::vector< double > *self,double const &o){
               return std::find(self->begin(), self->end(), o) != self->end();
            }
SWIGINTERN int std_vector_Sl_double_Sg__indexOf(std::vector< double > *self,double const &o){
               auto it = std::find(self->begin(), self->end(), o);
               if (it != self->end())
                   return std::distance(self->begin(), it);
               else
                   return -1;
            }
SWIGINTERN std::vector< double >::const_reference std_vector_Sl_double_Sg__get(std::vector< double > *self,int i){
                int size = int(self->size());
                if (i>=0 && i<size)
                    return (*self)[i];
                else
                    throw std::out_of_range("vector index out of range");
            }
SWIGINTERN void std_vector_Sl_double_Sg__set(std::vector< double > *self,int i,std::vector< double >::value_type const &val){
                int size = int(self->size());
                if (i>=0 && i<size)
                    (*self)[i] = val;
                else
                    throw std::out_of_range("vector index out of range");
            }
SWIGINTERN void std_vector_Sl_double_Sg__add__SWIG_1(std::vector< double > *self,int i,std::vector< double >::value_type const &val){
                int size = int(self->size());
                if (i>=0 && i<=size)
                    self->insert(self->begin() + i, val);
                else
                    throw std::out_of_range("vector index out of range");
            }
SWIGINTERN bool std_vector_Sl_double_Sg__remove(std::vector< double > *self,std::vector< double >::value_type const &val){
                auto it = std::find(self->begin(), self->end(), val);
                if (it == self->end())
                    return false;
                else
                    self->erase(it);
                return true;
            }
SWIGINTERN void *std_vector_Sl_double_Sg__asByteBuffer(std::vector< double > *self,int i,int capacity){
                (void) capacity;
                void* buffer = nullptr;
                int size = int(self->size()) ;
                if (i>=0 && i<size) {
                    buffer = self->data() + i;
                } else if (i==0 && size == 0) {
                    buffer = self->data();
                } else {
                    throw std::out_of_range("vector index out of range");
                }
                return buffer;
            }
SWIGINTERN bool std_vector_Sl_std_string_Sg__contains(std::vector< std::string > *self,std::string const &o){
               return std::find(self->begin(), self->end(), o) != self->end();
            }
SWIGINTERN int std_vector_Sl_std_string_Sg__indexOf(std::vector< std::string > *self,std::string const &o){
               auto it = std::find(self->begin(), self->end(), o);
               if (it != self->end())
                   return std::distance(self->begin(), it);
               else
                   return -1;
            }
SWIGINTERN std::vector< std::string >::const_reference std_vector_Sl_std_string_Sg__get(std::vector< std::string > *self,int i){
                int size = int(self->size());
                if (i>=0 && i<size)
                    return (*self)[i];
                else
                    throw std::out_of_range("vector index out of range");
            }
SWIGINTERN void std_vector_Sl_std_string_Sg__set(std::vector< std::string > *self,int i,std::vector< std::string >::value_type const &val){
                int size = int(self->size());
                if (i>=0 && i<size)
                    (*self)[i] = val;
                else
                    throw std::out_of_range("vector index out of range");
            }
SWIGINTERN void std_vector_Sl_std_string_Sg__add__SWIG_1(std::vector< std::string > *self,int i,std::vector< std::string >::value_type const &val){
                int size = int(self->size());
                if (i>=0 && i<=size)
                    self->insert(self->begin() + i, val);
                else
                    throw std::out_of_range("vector index out of range");
            }
SWIGINTERN bool std_vector_Sl_std_string_Sg__remove(std::vector< std::string > *self,std::vector< std::string >::value_type const &val){
                auto it = std::find(self->begin(), self->end(), val);
                if (it == self->end())
                    return false;
                else
                    self->erase(it);
                return true;
            }
SWIGINTERN void *std_vector_Sl_std_string_Sg__asByteBuffer(std::vector< std::string > *self,int i,int capacity){
                (void) capacity;
                void* buffer = nullptr;
                int size = int(self->size()) ;
                if (i>=0 && i<size) {
                    buffer = self->data() + i;
                } else if (i==0 && size == 0) {
                    buffer = self->data();
                } else {
                    throw std::out_of_range("vector index out of range");
                }
                return buffer;
            }
SWIGINTERN bool std_vector_Sl_ScicosID_Sg__contains(std::vector< ScicosID > *self,long long const &o){
               return std::find(self->begin(), self->end(), o) != self->end();
            }
SWIGINTERN int std_vector_Sl_ScicosID_Sg__indexOf(std::vector< ScicosID > *self,long long const &o){
               auto it = std::find(self->begin(), self->end(), o);
               if (it != self->end())
                   return std::distance(self->begin(), it);
               else
                   return -1;
            }
SWIGINTERN std::vector< long long >::const_reference std_vector_Sl_ScicosID_Sg__get(std::vector< ScicosID > *self,int i){
                int size = int(self->size());
                if (i>=0 && i<size)
                    return (*self)[i];
                else
                    throw std::out_of_range("vector index out of range");
            }
SWIGINTERN void std_vector_Sl_ScicosID_Sg__set(std::vector< ScicosID > *self,int i,std::vector< long long >::value_type const &val){
                int size = int(self->size());
                if (i>=0 && i<size)
                    (*self)[i] = val;
                else
                    throw std::out_of_range("vector index out of range");
            }
SWIGINTERN void std_vector_Sl_ScicosID_Sg__add__SWIG_1(std::vector< ScicosID > *self,int i,std::vector< long long >::value_type const &val){
                int size = int(self->size());
                if (i>=0 && i<=size)
                    self->insert(self->begin() + i, val);
                else
                    throw std::out_of_range("vector index out of range");
            }
SWIGINTERN bool std_vector_Sl_ScicosID_Sg__remove(std::vector< ScicosID > *self,std::vector< long long >::value_type const &val){
                auto it = std::find(self->begin(), self->end(), val);
                if (it == self->end())
                    return false;
                else
                    self->erase(it);
                return true;
            }
SWIGINTERN void *std_vector_Sl_ScicosID_Sg__asByteBuffer(std::vector< ScicosID > *self,int i,int capacity){
                (void) capacity;
                void* buffer = nullptr;
                int size = int(self->size()) ;
                if (i>=0 && i<size) {
                    buffer = self->data() + i;
                } else if (i==0 && size == 0) {
                    buffer = self->data();
                } else {
                    throw std::out_of_range("vector index out of range");
                }
                return buffer;
            }

static void register_view(const std::string& name, org_scilab_modules_scicos::View* view) {
  org_scilab_modules_scicos::Controller::register_view(name, view);
};
static void unregister_view(org_scilab_modules_scicos::View* view) {
  org_scilab_modules_scicos::Controller::unregister_view(view);
};



/* ---------------------------------------------------
 * C++ director class methods
 * --------------------------------------------------- */

#include "JavaController_wrap.h"

SwigDirector_View::SwigDirector_View(JNIEnv *jenv) : org_scilab_modules_scicos::View(), Swig::Director(jenv) {
}

SwigDirector_View::~SwigDirector_View() {
  swig_disconnect_director_self("swigDirectorDisconnect");
}


void SwigDirector_View::objectCreated(ScicosID const &uid,kind_t kind) {
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong juid = 0 ;
  jint jkind  ;
  
  if (!swig_override[0]) {
    SWIG_JavaThrowException(JNIEnvWrapper(this).getJNIEnv(), SWIG_JavaDirectorPureVirtual, "Attempted to invoke pure virtual method org_scilab_modules_scicos::View::objectCreated.");
    return;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    juid = (jlong)uid;
    jkind = (jint) kind;
    jenv->CallStaticVoidMethod(Swig::jclass_JavaControllerJNI, Swig::director_method_ids[0], swigjobj, juid, jkind);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      Swig::DirectorException::raise(jenv, swigerror);
    }
    
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in org_scilab_modules_scicos::View::objectCreated ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
}

void SwigDirector_View::objectReferenced(ScicosID const &uid,kind_t kind,unsigned int refCount) {
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong juid = 0 ;
  jint jkind  ;
  jlong jrefCount  ;
  
  if (!swig_override[1]) {
    SWIG_JavaThrowException(JNIEnvWrapper(this).getJNIEnv(), SWIG_JavaDirectorPureVirtual, "Attempted to invoke pure virtual method org_scilab_modules_scicos::View::objectReferenced.");
    return;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    juid = (jlong)uid;
    jkind = (jint) kind;
    jrefCount = (jlong) refCount;
    jenv->CallStaticVoidMethod(Swig::jclass_JavaControllerJNI, Swig::director_method_ids[1], swigjobj, juid, jkind, jrefCount);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      Swig::DirectorException::raise(jenv, swigerror);
    }
    
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in org_scilab_modules_scicos::View::objectReferenced ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
}

void SwigDirector_View::objectUnreferenced(ScicosID const &uid,kind_t kind,unsigned int refCount) {
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong juid = 0 ;
  jint jkind  ;
  jlong jrefCount  ;
  
  if (!swig_override[2]) {
    SWIG_JavaThrowException(JNIEnvWrapper(this).getJNIEnv(), SWIG_JavaDirectorPureVirtual, "Attempted to invoke pure virtual method org_scilab_modules_scicos::View::objectUnreferenced.");
    return;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    juid = (jlong)uid;
    jkind = (jint) kind;
    jrefCount = (jlong) refCount;
    jenv->CallStaticVoidMethod(Swig::jclass_JavaControllerJNI, Swig::director_method_ids[2], swigjobj, juid, jkind, jrefCount);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      Swig::DirectorException::raise(jenv, swigerror);
    }
    
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in org_scilab_modules_scicos::View::objectUnreferenced ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
}

void SwigDirector_View::objectDeleted(ScicosID const &uid,kind_t kind) {
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong juid = 0 ;
  jint jkind  ;
  
  if (!swig_override[3]) {
    SWIG_JavaThrowException(JNIEnvWrapper(this).getJNIEnv(), SWIG_JavaDirectorPureVirtual, "Attempted to invoke pure virtual method org_scilab_modules_scicos::View::objectDeleted.");
    return;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    juid = (jlong)uid;
    jkind = (jint) kind;
    jenv->CallStaticVoidMethod(Swig::jclass_JavaControllerJNI, Swig::director_method_ids[3], swigjobj, juid, jkind);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      Swig::DirectorException::raise(jenv, swigerror);
    }
    
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in org_scilab_modules_scicos::View::objectDeleted ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
}

void SwigDirector_View::objectCloned(ScicosID const &uid,ScicosID const &cloned,kind_t kind) {
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong juid = 0 ;
  jlong jcloned = 0 ;
  jint jkind  ;
  
  if (!swig_override[4]) {
    SWIG_JavaThrowException(JNIEnvWrapper(this).getJNIEnv(), SWIG_JavaDirectorPureVirtual, "Attempted to invoke pure virtual method org_scilab_modules_scicos::View::objectCloned.");
    return;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    juid = (jlong)uid;
    jcloned = (jlong)cloned;
    jkind = (jint) kind;
    jenv->CallStaticVoidMethod(Swig::jclass_JavaControllerJNI, Swig::director_method_ids[4], swigjobj, juid, jcloned, jkind);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      Swig::DirectorException::raise(jenv, swigerror);
    }
    
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in org_scilab_modules_scicos::View::objectCloned ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
}

void SwigDirector_View::propertyUpdated(ScicosID const &uid,kind_t kind,object_properties_t property,update_status_t status) {
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong juid = 0 ;
  jint jkind  ;
  jint jproperty  ;
  jint jstatus  ;
  
  if (!swig_override[5]) {
    SWIG_JavaThrowException(JNIEnvWrapper(this).getJNIEnv(), SWIG_JavaDirectorPureVirtual, "Attempted to invoke pure virtual method org_scilab_modules_scicos::View::propertyUpdated.");
    return;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    juid = (jlong)uid;
    jkind = (jint) kind;
    jproperty = (jint) property;
    jstatus = (jint) status;
    jenv->CallStaticVoidMethod(Swig::jclass_JavaControllerJNI, Swig::director_method_ids[5], swigjobj, juid, jkind, jproperty, jstatus);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      Swig::DirectorException::raise(jenv, swigerror);
    }
    
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in org_scilab_modules_scicos::View::propertyUpdated ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
}

void SwigDirector_View::swig_connect_director(JNIEnv *jenv, jobject jself, jclass jcls, bool swig_mem_own, bool weak_global) {
  static jclass baseclass = swig_new_global_ref(jenv, "org/scilab/modules/xcos/View");
  if (!baseclass) return;
  static SwigDirectorMethod methods[] = {
    SwigDirectorMethod(jenv, baseclass, "objectCreated", "(JLorg/scilab/modules/xcos/Kind;)V"),
    SwigDirectorMethod(jenv, baseclass, "objectReferenced", "(JLorg/scilab/modules/xcos/Kind;J)V"),
    SwigDirectorMethod(jenv, baseclass, "objectUnreferenced", "(JLorg/scilab/modules/xcos/Kind;J)V"),
    SwigDirectorMethod(jenv, baseclass, "objectDeleted", "(JLorg/scilab/modules/xcos/Kind;)V"),
    SwigDirectorMethod(jenv, baseclass, "objectCloned", "(JJLorg/scilab/modules/xcos/Kind;)V"),
    SwigDirectorMethod(jenv, baseclass, "propertyUpdated", "(JLorg/scilab/modules/xcos/Kind;Lorg/scilab/modules/xcos/ObjectProperties;Lorg/scilab/modules/xcos/UpdateStatus;)V")
  };
  
  if (swig_set_self(jenv, jself, swig_mem_own, weak_global)) {
    bool derived = (jenv->IsSameObject(baseclass, jcls) ? false : true);
    for (int i = 0; i < 6; ++i) {
      swig_override[i] = false;
      if (derived) {
        jmethodID methid = jenv->GetMethodID(jcls, methods[i].name, methods[i].desc);
        swig_override[i] = methods[i].methid && (methid != methods[i].methid);
        jenv->ExceptionClear();
      }
    }
  }
}



#ifdef __cplusplus
extern "C" {
#endif

SWIGEXPORT jint JNICALL Java_org_scilab_modules_xcos_JavaControllerJNI_port_1from_1property(JNIEnv *jenv, jclass jcls, jint jarg1) {
  jint jresult = 0 ;
  object_properties_t arg1 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (object_properties_t)jarg1; 
  result = (int)port_from_property(arg1);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_scilab_modules_xcos_JavaControllerJNI_property_1from_1port(JNIEnv *jenv, jclass jcls, jint jarg1) {
  jint jresult = 0 ;
  enum portKind arg1 ;
  object_properties_t result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (enum portKind)jarg1; 
  result = (object_properties_t)property_from_port(arg1);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_scilab_modules_xcos_JavaControllerJNI_new_1View(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  org_scilab_modules_scicos::View **pArg ;
  org_scilab_modules_scicos::View *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (org_scilab_modules_scicos::View *)new SwigDirector_View(jenv);
  // fix -fstrict-aliasing - typemap(out)
  pArg = (org_scilab_modules_scicos::View **) &jresult;
  *pArg = result;
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_scilab_modules_xcos_JavaControllerJNI_delete_1View(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  org_scilab_modules_scicos::View *arg1 = (org_scilab_modules_scicos::View *) 0 ;
  org_scilab_modules_scicos::View **pArg1 ;
  
  (void)jenv;
  (void)jcls;
  // fix -fstrict-aliasing - typemap(in)
  pArg1 = (org_scilab_modules_scicos::View **) &jarg1;
  arg1 = *pArg1;
  delete arg1;
}


SWIGEXPORT void JNICALL Java_org_scilab_modules_xcos_JavaControllerJNI_View_1objectCreated(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jint jarg3) {
  org_scilab_modules_scicos::View *arg1 = (org_scilab_modules_scicos::View *) 0 ;
  ScicosID *arg2 = 0 ;
  kind_t arg3 ;
  org_scilab_modules_scicos::View **pArg1 ;
  ScicosID temp2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  // fix -fstrict-aliasing - typemap(in)
  pArg1 = (org_scilab_modules_scicos::View **) &jarg1;
  arg1 = *pArg1;
  temp2 = (ScicosID)jarg2; 
  arg2 = &temp2; 
  arg3 = (kind_t)jarg3; 
  (arg1)->objectCreated((ScicosID const &)*arg2,arg3);
}


SWIGEXPORT void JNICALL Java_org_scilab_modules_xcos_JavaControllerJNI_View_1objectReferenced(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jint jarg3, jlong jarg4) {
  org_scilab_modules_scicos::View *arg1 = (org_scilab_modules_scicos::View *) 0 ;
  ScicosID *arg2 = 0 ;
  kind_t arg3 ;
  unsigned int arg4 ;
  org_scilab_modules_scicos::View **pArg1 ;
  ScicosID temp2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  // fix -fstrict-aliasing - typemap(in)
  pArg1 = (org_scilab_modules_scicos::View **) &jarg1;
  arg1 = *pArg1;
  temp2 = (ScicosID)jarg2; 
  arg2 = &temp2; 
  arg3 = (kind_t)jarg3; 
  arg4 = (unsigned int)jarg4; 
  (arg1)->objectReferenced((ScicosID const &)*arg2,arg3,arg4);
}


SWIGEXPORT void JNICALL Java_org_scilab_modules_xcos_JavaControllerJNI_View_1objectUnreferenced(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jint jarg3, jlong jarg4) {
  org_scilab_modules_scicos::View *arg1 = (org_scilab_modules_scicos::View *) 0 ;
  ScicosID *arg2 = 0 ;
  kind_t arg3 ;
  unsigned int arg4 ;
  org_scilab_modules_scicos::View **pArg1 ;
  ScicosID temp2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  // fix -fstrict-aliasing - typemap(in)
  pArg1 = (org_scilab_modules_scicos::View **) &jarg1;
  arg1 = *pArg1;
  temp2 = (ScicosID)jarg2; 
  arg2 = &temp2; 
  arg3 = (kind_t)jarg3; 
  arg4 = (unsigned int)jarg4; 
  (arg1)->objectUnreferenced((ScicosID const &)*arg2,arg3,arg4);
}


SWIGEXPORT void JNICALL Java_org_scilab_modules_xcos_JavaControllerJNI_View_1objectDeleted(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jint jarg3) {
  org_scilab_modules_scicos::View *arg1 = (org_scilab_modules_scicos::View *) 0 ;
  ScicosID *arg2 = 0 ;
  kind_t arg3 ;
  org_scilab_modules_scicos::View **pArg1 ;
  ScicosID temp2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  // fix -fstrict-aliasing - typemap(in)
  pArg1 = (org_scilab_modules_scicos::View **) &jarg1;
  arg1 = *pArg1;
  temp2 = (ScicosID)jarg2; 
  arg2 = &temp2; 
  arg3 = (kind_t)jarg3; 
  (arg1)->objectDeleted((ScicosID const &)*arg2,arg3);
}


SWIGEXPORT void JNICALL Java_org_scilab_modules_xcos_JavaControllerJNI_View_1objectCloned(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jlong jarg3, jint jarg4) {
  org_scilab_modules_scicos::View *arg1 = (org_scilab_modules_scicos::View *) 0 ;
  ScicosID *arg2 = 0 ;
  ScicosID *arg3 = 0 ;
  kind_t arg4 ;
  org_scilab_modules_scicos::View **pArg1 ;
  ScicosID temp2 ;
  ScicosID temp3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  // fix -fstrict-aliasing - typemap(in)
  pArg1 = (org_scilab_modules_scicos::View **) &jarg1;
  arg1 = *pArg1;
  temp2 = (ScicosID)jarg2; 
  arg2 = &temp2; 
  temp3 = (ScicosID)jarg3; 
  arg3 = &temp3; 
  arg4 = (kind_t)jarg4; 
  (arg1)->objectCloned((ScicosID const &)*arg2,(ScicosID const &)*arg3,arg4);
}


SWIGEXPORT void JNICALL Java_org_scilab_modules_xcos_JavaControllerJNI_View_1propertyUpdated(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jint jarg3, jint jarg4, jint jarg5) {
  org_scilab_modules_scicos::View *arg1 = (org_scilab_modules_scicos::View *) 0 ;
  ScicosID *arg2 = 0 ;
  kind_t arg3 ;
  object_properties_t arg4 ;
  update_status_t arg5 ;
  org_scilab_modules_scicos::View **pArg1 ;
  ScicosID temp2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  // fix -fstrict-aliasing - typemap(in)
  pArg1 = (org_scilab_modules_scicos::View **) &jarg1;
  arg1 = *pArg1;
  temp2 = (ScicosID)jarg2; 
  arg2 = &temp2; 
  arg3 = (kind_t)jarg3; 
  arg4 = (object_properties_t)jarg4; 
  arg5 = (update_status_t)jarg5; 
  (arg1)->propertyUpdated((ScicosID const &)*arg2,arg3,arg4,arg5);
}


SWIGEXPORT void JNICALL Java_org_scilab_modules_xcos_JavaControllerJNI_View_1director_1connect(JNIEnv *jenv, jclass jcls, jobject jself, jlong objarg, jboolean jswig_mem_own, jboolean jweak_global) {
  org_scilab_modules_scicos::View *obj = *((org_scilab_modules_scicos::View **)&objarg);
  (void)jcls;
  SwigDirector_View *director = static_cast<SwigDirector_View *>(obj);
  director->swig_connect_director(jenv, jself, jenv->GetObjectClass(jself), (jswig_mem_own == JNI_TRUE), (jweak_global == JNI_TRUE));
}


SWIGEXPORT void JNICALL Java_org_scilab_modules_xcos_JavaControllerJNI_View_1change_1ownership(JNIEnv *jenv, jclass jcls, jobject jself, jlong objarg, jboolean jtake_or_release) {
  org_scilab_modules_scicos::View *obj = *((org_scilab_modules_scicos::View **)&objarg);
  SwigDirector_View *director = dynamic_cast<SwigDirector_View *>(obj);
  (void)jcls;
  if (director) {
    director->swig_java_change_ownership(jenv, jself, jtake_or_release ? true : false);
  }
}


SWIGEXPORT void JNICALL Java_org_scilab_modules_xcos_JavaControllerJNI_Controller_1end_1simulation(JNIEnv *jenv, jclass jcls) {
  (void)jenv;
  (void)jcls;
  org_scilab_modules_scicos::Controller::end_simulation();
}


SWIGEXPORT jlong JNICALL Java_org_scilab_modules_xcos_JavaControllerJNI_new_1Controller(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  org_scilab_modules_scicos::Controller **pArg ;
  org_scilab_modules_scicos::Controller *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (org_scilab_modules_scicos::Controller *)new org_scilab_modules_scicos::Controller();
  // fix -fstrict-aliasing - typemap(out)
  pArg = (org_scilab_modules_scicos::Controller **) &jresult;
  *pArg = result;
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_scilab_modules_xcos_JavaControllerJNI_delete_1Controller(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  org_scilab_modules_scicos::Controller *arg1 = (org_scilab_modules_scicos::Controller *) 0 ;
  org_scilab_modules_scicos::Controller **pArg1 ;
  
  (void)jenv;
  (void)jcls;
  // fix -fstrict-aliasing - typemap(in)
  pArg1 = (org_scilab_modules_scicos::Controller **) &jarg1;
  arg1 = *pArg1;
  delete arg1;
}


SWIGEXPORT jlong JNICALL Java_org_scilab_modules_xcos_JavaControllerJNI_Controller_1createObject(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jlong jresult = 0 ;
  org_scilab_modules_scicos::Controller *arg1 = (org_scilab_modules_scicos::Controller *) 0 ;
  kind_t arg2 ;
  org_scilab_modules_scicos::Controller **pArg1 ;
  ScicosID result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  // fix -fstrict-aliasing - typemap(in)
  pArg1 = (org_scilab_modules_scicos::Controller **) &jarg1;
  arg1 = *pArg1;
  arg2 = (kind_t)jarg2; 
  result = (ScicosID)(arg1)->createObject(arg2);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_scilab_modules_xcos_JavaControllerJNI_Controller_1referenceObject(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  jlong jresult = 0 ;
  org_scilab_modules_scicos::Controller *arg1 = (org_scilab_modules_scicos::Controller *) 0 ;
  ScicosID arg2 ;
  org_scilab_modules_scicos::Controller **pArg1 ;
  unsigned int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  // fix -fstrict-aliasing - typemap(in)
  pArg1 = (org_scilab_modules_scicos::Controller **) &jarg1;
  arg1 = *pArg1;
  arg2 = (ScicosID)jarg2; 
  result = (unsigned int)((org_scilab_modules_scicos::Controller const *)arg1)->referenceObject(arg2);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_scilab_modules_xcos_JavaControllerJNI_Controller_1deleteObject(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  org_scilab_modules_scicos::Controller *arg1 = (org_scilab_modules_scicos::Controller *) 0 ;
  ScicosID arg2 ;
  org_scilab_modules_scicos::Controller **pArg1 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  // fix -fstrict-aliasing - typemap(in)
  pArg1 = (org_scilab_modules_scicos::Controller **) &jarg1;
  arg1 = *pArg1;
  arg2 = (ScicosID)jarg2; 
  (arg1)->deleteObject(arg2);
}


SWIGEXPORT jlong JNICALL Java_org_scilab_modules_xcos_JavaControllerJNI_Controller_1cloneObject(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jboolean jarg3, jboolean jarg4) {
  jlong jresult = 0 ;
  org_scilab_modules_scicos::Controller *arg1 = (org_scilab_modules_scicos::Controller *) 0 ;
  ScicosID arg2 ;
  bool arg3 ;
  bool arg4 ;
  org_scilab_modules_scicos::Controller **pArg1 ;
  ScicosID result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  // fix -fstrict-aliasing - typemap(in)
  pArg1 = (org_scilab_modules_scicos::Controller **) &jarg1;
  arg1 = *pArg1;
  arg2 = (ScicosID)jarg2; 
  arg3 = jarg3 ? true : false; 
  arg4 = jarg4 ? true : false; 
  result = (ScicosID)(arg1)->cloneObject(arg2,arg3,arg4);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_scilab_modules_xcos_JavaControllerJNI_Controller_1getKind(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  jint jresult = 0 ;
  org_scilab_modules_scicos::Controller *arg1 = (org_scilab_modules_scicos::Controller *) 0 ;
  ScicosID arg2 ;
  org_scilab_modules_scicos::Controller **pArg1 ;
  kind_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  // fix -fstrict-aliasing - typemap(in)
  pArg1 = (org_scilab_modules_scicos::Controller **) &jarg1;
  arg1 = *pArg1;
  arg2 = (ScicosID)jarg2; 
  result = (kind_t)((org_scilab_modules_scicos::Controller const *)arg1)->getKind(arg2);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_scilab_modules_xcos_JavaControllerJNI_Controller_1getAll(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jlong jresult = 0 ;
  org_scilab_modules_scicos::Controller *arg1 = (org_scilab_modules_scicos::Controller *) 0 ;
  kind_t arg2 ;
  org_scilab_modules_scicos::Controller **pArg1 ;
  std::vector< ScicosID > result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  // fix -fstrict-aliasing - typemap(in)
  pArg1 = (org_scilab_modules_scicos::Controller **) &jarg1;
  arg1 = *pArg1;
  arg2 = (kind_t)jarg2; 
  result = ((org_scilab_modules_scicos::Controller const *)arg1)->getAll(arg2);
  *(std::vector< ScicosID > **)&jresult = new std::vector< ScicosID >(result); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_scilab_modules_xcos_JavaControllerJNI_Controller_1sortAndFillKind(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_) {
  org_scilab_modules_scicos::Controller *arg1 = (org_scilab_modules_scicos::Controller *) 0 ;
  std::vector< ScicosID > *arg2 = 0 ;
  std::vector< int > *arg3 = 0 ;
  org_scilab_modules_scicos::Controller **pArg1 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  // fix -fstrict-aliasing - typemap(in)
  pArg1 = (org_scilab_modules_scicos::Controller **) &jarg1;
  arg1 = *pArg1;
  arg2 = *(std::vector< ScicosID > **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< ScicosID > & is null");
    return ;
  } 
  arg3 = *(std::vector< int > **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< int > & is null");
    return ;
  } 
  (arg1)->sortAndFillKind(*arg2,*arg3);
}


SWIGEXPORT jboolean JNICALL Java_org_scilab_modules_xcos_JavaControllerJNI_Controller_1getObjectProperty_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jint jarg3, jint jarg4, jdoubleArray jarg5) {
  jboolean jresult = 0 ;
  org_scilab_modules_scicos::Controller *arg1 = (org_scilab_modules_scicos::Controller *) 0 ;
  ScicosID arg2 ;
  kind_t arg3 ;
  object_properties_t arg4 ;
  double *arg5 = 0 ;
  org_scilab_modules_scicos::Controller **pArg1 ;
  double temp5 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  // fix -fstrict-aliasing - typemap(in)
  pArg1 = (org_scilab_modules_scicos::Controller **) &jarg1;
  arg1 = *pArg1;
  arg2 = (ScicosID)jarg2; 
  arg3 = (kind_t)jarg3; 
  arg4 = (object_properties_t)jarg4; 
  {
    if (!jarg5) {
      SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "array null");
      return 0;
    }
    if (jenv->GetArrayLength(jarg5) == 0) {
      SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, "Array must contain at least 1 element");
      return 0;
    }
    temp5 = (double)0;
    arg5 = &temp5; 
  }
  result = (bool)((org_scilab_modules_scicos::Controller const *)arg1)->getObjectProperty(arg2,arg3,arg4,*arg5);
  jresult = (jboolean)result; 
  {
    jdouble jvalue = (jdouble)temp5;
    jenv->SetDoubleArrayRegion(jarg5, 0, 1, &jvalue);
  }
  
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_scilab_modules_xcos_JavaControllerJNI_Controller_1getObjectProperty_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jint jarg3, jint jarg4, jintArray jarg5) {
  jboolean jresult = 0 ;
  org_scilab_modules_scicos::Controller *arg1 = (org_scilab_modules_scicos::Controller *) 0 ;
  ScicosID arg2 ;
  kind_t arg3 ;
  object_properties_t arg4 ;
  int *arg5 = 0 ;
  org_scilab_modules_scicos::Controller **pArg1 ;
  int temp5 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  // fix -fstrict-aliasing - typemap(in)
  pArg1 = (org_scilab_modules_scicos::Controller **) &jarg1;
  arg1 = *pArg1;
  arg2 = (ScicosID)jarg2; 
  arg3 = (kind_t)jarg3; 
  arg4 = (object_properties_t)jarg4; 
  {
    if (!jarg5) {
      SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "array null");
      return 0;
    }
    if (jenv->GetArrayLength(jarg5) == 0) {
      SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, "Array must contain at least 1 element");
      return 0;
    }
    temp5 = (int)0;
    arg5 = &temp5; 
  }
  result = (bool)((org_scilab_modules_scicos::Controller const *)arg1)->getObjectProperty(arg2,arg3,arg4,*arg5);
  jresult = (jboolean)result; 
  {
    jint jvalue = (jint)temp5;
    jenv->SetIntArrayRegion(jarg5, 0, 1, &jvalue);
  }
  
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_scilab_modules_xcos_JavaControllerJNI_Controller_1getObjectProperty_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jint jarg3, jint jarg4, jbooleanArray jarg5) {
  jboolean jresult = 0 ;
  org_scilab_modules_scicos::Controller *arg1 = (org_scilab_modules_scicos::Controller *) 0 ;
  ScicosID arg2 ;
  kind_t arg3 ;
  object_properties_t arg4 ;
  bool *arg5 = 0 ;
  org_scilab_modules_scicos::Controller **pArg1 ;
  bool temp5 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  // fix -fstrict-aliasing - typemap(in)
  pArg1 = (org_scilab_modules_scicos::Controller **) &jarg1;
  arg1 = *pArg1;
  arg2 = (ScicosID)jarg2; 
  arg3 = (kind_t)jarg3; 
  arg4 = (object_properties_t)jarg4; 
  {
    if (!jarg5) {
      SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "array null");
      return 0;
    }
    if (jenv->GetArrayLength(jarg5) == 0) {
      SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, "Array must contain at least 1 element");
      return 0;
    }
    temp5 = false;
    arg5 = &temp5; 
  }
  result = (bool)((org_scilab_modules_scicos::Controller const *)arg1)->getObjectProperty(arg2,arg3,arg4,*arg5);
  jresult = (jboolean)result; 
  {
    jboolean jvalue = (jboolean)temp5;
    jenv->SetBooleanArrayRegion(jarg5, 0, 1, &jvalue);
  }
  
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_scilab_modules_xcos_JavaControllerJNI_Controller_1getObjectProperty_1_1SWIG_13(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jint jarg3, jint jarg4, jobjectArray jarg5) {
  jboolean jresult = 0 ;
  org_scilab_modules_scicos::Controller *arg1 = (org_scilab_modules_scicos::Controller *) 0 ;
  ScicosID arg2 ;
  kind_t arg3 ;
  object_properties_t arg4 ;
  std::string *arg5 = 0 ;
  org_scilab_modules_scicos::Controller **pArg1 ;
  std::string temp5 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  // fix -fstrict-aliasing - typemap(in)
  pArg1 = (org_scilab_modules_scicos::Controller **) &jarg1;
  arg1 = *pArg1;
  arg2 = (ScicosID)jarg2; 
  arg3 = (kind_t)jarg3; 
  arg4 = (object_properties_t)jarg4; 
  {
    if (!jarg5) {
      SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "array null");
      return 0;
    }
    if (jenv->GetArrayLength(jarg5) == 0) {
      SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, "Array must contain at least 1 element");
      return 0;
    }
    arg5 = &temp5;
  }
  result = (bool)((org_scilab_modules_scicos::Controller const *)arg1)->getObjectProperty(arg2,arg3,arg4,*arg5);
  jresult = (jboolean)result; 
  {
    jstring jnewstring = jenv->NewStringUTF(arg5->c_str());
    jenv->SetObjectArrayElement(jarg5, 0, jnewstring);
  }
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_scilab_modules_xcos_JavaControllerJNI_Controller_1getObjectProperty_1_1SWIG_14(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jint jarg3, jint jarg4, jlongArray jarg5) {
  jboolean jresult = 0 ;
  org_scilab_modules_scicos::Controller *arg1 = (org_scilab_modules_scicos::Controller *) 0 ;
  ScicosID arg2 ;
  kind_t arg3 ;
  object_properties_t arg4 ;
  ScicosID *arg5 = 0 ;
  org_scilab_modules_scicos::Controller **pArg1 ;
  ScicosID temp5 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  // fix -fstrict-aliasing - typemap(in)
  pArg1 = (org_scilab_modules_scicos::Controller **) &jarg1;
  arg1 = *pArg1;
  arg2 = (ScicosID)jarg2; 
  arg3 = (kind_t)jarg3; 
  arg4 = (object_properties_t)jarg4; 
  {
    if (!jarg5) {
      SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "array null");
      return 0;
    }
    if (jenv->GetArrayLength(jarg5) == 0) {
      SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, "Array must contain at least 1 element");
      return 0;
    }
    temp5 = (ScicosID)0;
    arg5 = &temp5; 
  }
  result = (bool)((org_scilab_modules_scicos::Controller const *)arg1)->getObjectProperty(arg2,arg3,arg4,*arg5);
  jresult = (jboolean)result; 
  {
    jlong jvalue = (jlong)temp5;
    jenv->SetLongArrayRegion(jarg5, 0, 1, &jvalue);
  }
  
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_scilab_modules_xcos_JavaControllerJNI_Controller_1getObjectProperty_1_1SWIG_15(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jint jarg3, jint jarg4, jlong jarg5, jobject jarg5_) {
  jboolean jresult = 0 ;
  org_scilab_modules_scicos::Controller *arg1 = (org_scilab_modules_scicos::Controller *) 0 ;
  ScicosID arg2 ;
  kind_t arg3 ;
  object_properties_t arg4 ;
  std::vector< double > *arg5 = 0 ;
  org_scilab_modules_scicos::Controller **pArg1 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg5_;
  // fix -fstrict-aliasing - typemap(in)
  pArg1 = (org_scilab_modules_scicos::Controller **) &jarg1;
  arg1 = *pArg1;
  arg2 = (ScicosID)jarg2; 
  arg3 = (kind_t)jarg3; 
  arg4 = (object_properties_t)jarg4; 
  arg5 = *(std::vector< double > **)&jarg5;
  if (!arg5) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< double > & is null");
    return 0;
  } 
  result = (bool)((org_scilab_modules_scicos::Controller const *)arg1)->getObjectProperty(arg2,arg3,arg4,*arg5);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_scilab_modules_xcos_JavaControllerJNI_Controller_1getObjectProperty_1_1SWIG_16(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jint jarg3, jint jarg4, jlong jarg5, jobject jarg5_) {
  jboolean jresult = 0 ;
  org_scilab_modules_scicos::Controller *arg1 = (org_scilab_modules_scicos::Controller *) 0 ;
  ScicosID arg2 ;
  kind_t arg3 ;
  object_properties_t arg4 ;
  std::vector< int > *arg5 = 0 ;
  org_scilab_modules_scicos::Controller **pArg1 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg5_;
  // fix -fstrict-aliasing - typemap(in)
  pArg1 = (org_scilab_modules_scicos::Controller **) &jarg1;
  arg1 = *pArg1;
  arg2 = (ScicosID)jarg2; 
  arg3 = (kind_t)jarg3; 
  arg4 = (object_properties_t)jarg4; 
  arg5 = *(std::vector< int > **)&jarg5;
  if (!arg5) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< int > & is null");
    return 0;
  } 
  result = (bool)((org_scilab_modules_scicos::Controller const *)arg1)->getObjectProperty(arg2,arg3,arg4,*arg5);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_scilab_modules_xcos_JavaControllerJNI_Controller_1getObjectProperty_1_1SWIG_17(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jint jarg3, jint jarg4, jlong jarg5, jobject jarg5_) {
  jboolean jresult = 0 ;
  org_scilab_modules_scicos::Controller *arg1 = (org_scilab_modules_scicos::Controller *) 0 ;
  ScicosID arg2 ;
  kind_t arg3 ;
  object_properties_t arg4 ;
  std::vector< bool > *arg5 = 0 ;
  org_scilab_modules_scicos::Controller **pArg1 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg5_;
  // fix -fstrict-aliasing - typemap(in)
  pArg1 = (org_scilab_modules_scicos::Controller **) &jarg1;
  arg1 = *pArg1;
  arg2 = (ScicosID)jarg2; 
  arg3 = (kind_t)jarg3; 
  arg4 = (object_properties_t)jarg4; 
  arg5 = *(std::vector< bool > **)&jarg5;
  if (!arg5) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< bool > & is null");
    return 0;
  } 
  result = (bool)((org_scilab_modules_scicos::Controller const *)arg1)->getObjectProperty(arg2,arg3,arg4,*arg5);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_scilab_modules_xcos_JavaControllerJNI_Controller_1getObjectProperty_1_1SWIG_18(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jint jarg3, jint jarg4, jlong jarg5, jobject jarg5_) {
  jboolean jresult = 0 ;
  org_scilab_modules_scicos::Controller *arg1 = (org_scilab_modules_scicos::Controller *) 0 ;
  ScicosID arg2 ;
  kind_t arg3 ;
  object_properties_t arg4 ;
  std::vector< std::string > *arg5 = 0 ;
  org_scilab_modules_scicos::Controller **pArg1 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg5_;
  // fix -fstrict-aliasing - typemap(in)
  pArg1 = (org_scilab_modules_scicos::Controller **) &jarg1;
  arg1 = *pArg1;
  arg2 = (ScicosID)jarg2; 
  arg3 = (kind_t)jarg3; 
  arg4 = (object_properties_t)jarg4; 
  arg5 = *(std::vector< std::string > **)&jarg5;
  if (!arg5) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< std::string > & is null");
    return 0;
  } 
  result = (bool)((org_scilab_modules_scicos::Controller const *)arg1)->getObjectProperty(arg2,arg3,arg4,*arg5);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_scilab_modules_xcos_JavaControllerJNI_Controller_1getObjectProperty_1_1SWIG_19(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jint jarg3, jint jarg4, jlong jarg5, jobject jarg5_) {
  jboolean jresult = 0 ;
  org_scilab_modules_scicos::Controller *arg1 = (org_scilab_modules_scicos::Controller *) 0 ;
  ScicosID arg2 ;
  kind_t arg3 ;
  object_properties_t arg4 ;
  std::vector< ScicosID > *arg5 = 0 ;
  org_scilab_modules_scicos::Controller **pArg1 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg5_;
  // fix -fstrict-aliasing - typemap(in)
  pArg1 = (org_scilab_modules_scicos::Controller **) &jarg1;
  arg1 = *pArg1;
  arg2 = (ScicosID)jarg2; 
  arg3 = (kind_t)jarg3; 
  arg4 = (object_properties_t)jarg4; 
  arg5 = *(std::vector< ScicosID > **)&jarg5;
  if (!arg5) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< ScicosID > & is null");
    return 0;
  } 
  result = (bool)((org_scilab_modules_scicos::Controller const *)arg1)->getObjectProperty(arg2,arg3,arg4,*arg5);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_scilab_modules_xcos_JavaControllerJNI_Controller_1setObjectProperty_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jint jarg3, jint jarg4, jdouble jarg5) {
  jint jresult = 0 ;
  org_scilab_modules_scicos::Controller *arg1 = (org_scilab_modules_scicos::Controller *) 0 ;
  ScicosID arg2 ;
  kind_t arg3 ;
  object_properties_t arg4 ;
  double arg5 ;
  org_scilab_modules_scicos::Controller **pArg1 ;
  update_status_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  // fix -fstrict-aliasing - typemap(in)
  pArg1 = (org_scilab_modules_scicos::Controller **) &jarg1;
  arg1 = *pArg1;
  arg2 = (ScicosID)jarg2; 
  arg3 = (kind_t)jarg3; 
  arg4 = (object_properties_t)jarg4; 
  arg5 = (double)jarg5; 
  result = (update_status_t)(arg1)->setObjectProperty(arg2,arg3,arg4,arg5);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_scilab_modules_xcos_JavaControllerJNI_Controller_1setObjectProperty_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jint jarg3, jint jarg4, jint jarg5) {
  jint jresult = 0 ;
  org_scilab_modules_scicos::Controller *arg1 = (org_scilab_modules_scicos::Controller *) 0 ;
  ScicosID arg2 ;
  kind_t arg3 ;
  object_properties_t arg4 ;
  int arg5 ;
  org_scilab_modules_scicos::Controller **pArg1 ;
  update_status_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  // fix -fstrict-aliasing - typemap(in)
  pArg1 = (org_scilab_modules_scicos::Controller **) &jarg1;
  arg1 = *pArg1;
  arg2 = (ScicosID)jarg2; 
  arg3 = (kind_t)jarg3; 
  arg4 = (object_properties_t)jarg4; 
  arg5 = (int)jarg5; 
  result = (update_status_t)(arg1)->setObjectProperty(arg2,arg3,arg4,arg5);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_scilab_modules_xcos_JavaControllerJNI_Controller_1setObjectProperty_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jint jarg3, jint jarg4, jboolean jarg5) {
  jint jresult = 0 ;
  org_scilab_modules_scicos::Controller *arg1 = (org_scilab_modules_scicos::Controller *) 0 ;
  ScicosID arg2 ;
  kind_t arg3 ;
  object_properties_t arg4 ;
  bool arg5 ;
  org_scilab_modules_scicos::Controller **pArg1 ;
  update_status_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  // fix -fstrict-aliasing - typemap(in)
  pArg1 = (org_scilab_modules_scicos::Controller **) &jarg1;
  arg1 = *pArg1;
  arg2 = (ScicosID)jarg2; 
  arg3 = (kind_t)jarg3; 
  arg4 = (object_properties_t)jarg4; 
  arg5 = jarg5 ? true : false; 
  result = (update_status_t)(arg1)->setObjectProperty(arg2,arg3,arg4,arg5);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_scilab_modules_xcos_JavaControllerJNI_Controller_1setObjectProperty_1_1SWIG_13(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jint jarg3, jint jarg4, jlong jarg5) {
  jint jresult = 0 ;
  org_scilab_modules_scicos::Controller *arg1 = (org_scilab_modules_scicos::Controller *) 0 ;
  ScicosID arg2 ;
  kind_t arg3 ;
  object_properties_t arg4 ;
  ScicosID arg5 ;
  org_scilab_modules_scicos::Controller **pArg1 ;
  update_status_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  // fix -fstrict-aliasing - typemap(in)
  pArg1 = (org_scilab_modules_scicos::Controller **) &jarg1;
  arg1 = *pArg1;
  arg2 = (ScicosID)jarg2; 
  arg3 = (kind_t)jarg3; 
  arg4 = (object_properties_t)jarg4; 
  arg5 = (ScicosID)jarg5; 
  result = (update_status_t)(arg1)->setObjectProperty(arg2,arg3,arg4,arg5);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_scilab_modules_xcos_JavaControllerJNI_Controller_1setObjectProperty_1_1SWIG_14(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jint jarg3, jint jarg4, jstring jarg5) {
  jint jresult = 0 ;
  org_scilab_modules_scicos::Controller *arg1 = (org_scilab_modules_scicos::Controller *) 0 ;
  ScicosID arg2 ;
  kind_t arg3 ;
  object_properties_t arg4 ;
  std::string *arg5 = 0 ;
  org_scilab_modules_scicos::Controller **pArg1 ;
  update_status_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  // fix -fstrict-aliasing - typemap(in)
  pArg1 = (org_scilab_modules_scicos::Controller **) &jarg1;
  arg1 = *pArg1;
  arg2 = (ScicosID)jarg2; 
  arg3 = (kind_t)jarg3; 
  arg4 = (object_properties_t)jarg4; 
  Swig::JavaString javaString(jenv, jarg5);
  std::string arg5_str(javaString.c_str());
  arg5 = &arg5_str;
  result = (update_status_t)(arg1)->setObjectProperty(arg2,arg3,arg4,(std::string const &)*arg5);
  jresult = (jint)result; 
  
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_scilab_modules_xcos_JavaControllerJNI_Controller_1setObjectProperty_1_1SWIG_15(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jint jarg3, jint jarg4, jlong jarg5, jobject jarg5_) {
  jint jresult = 0 ;
  org_scilab_modules_scicos::Controller *arg1 = (org_scilab_modules_scicos::Controller *) 0 ;
  ScicosID arg2 ;
  kind_t arg3 ;
  object_properties_t arg4 ;
  std::vector< double > *arg5 = 0 ;
  org_scilab_modules_scicos::Controller **pArg1 ;
  update_status_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg5_;
  // fix -fstrict-aliasing - typemap(in)
  pArg1 = (org_scilab_modules_scicos::Controller **) &jarg1;
  arg1 = *pArg1;
  arg2 = (ScicosID)jarg2; 
  arg3 = (kind_t)jarg3; 
  arg4 = (object_properties_t)jarg4; 
  arg5 = *(std::vector< double > **)&jarg5;
  if (!arg5) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< double > const & is null");
    return 0;
  } 
  result = (update_status_t)(arg1)->setObjectProperty(arg2,arg3,arg4,(std::vector< double > const &)*arg5);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_scilab_modules_xcos_JavaControllerJNI_Controller_1setObjectProperty_1_1SWIG_16(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jint jarg3, jint jarg4, jlong jarg5, jobject jarg5_) {
  jint jresult = 0 ;
  org_scilab_modules_scicos::Controller *arg1 = (org_scilab_modules_scicos::Controller *) 0 ;
  ScicosID arg2 ;
  kind_t arg3 ;
  object_properties_t arg4 ;
  std::vector< int > *arg5 = 0 ;
  org_scilab_modules_scicos::Controller **pArg1 ;
  update_status_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg5_;
  // fix -fstrict-aliasing - typemap(in)
  pArg1 = (org_scilab_modules_scicos::Controller **) &jarg1;
  arg1 = *pArg1;
  arg2 = (ScicosID)jarg2; 
  arg3 = (kind_t)jarg3; 
  arg4 = (object_properties_t)jarg4; 
  arg5 = *(std::vector< int > **)&jarg5;
  if (!arg5) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< int > const & is null");
    return 0;
  } 
  result = (update_status_t)(arg1)->setObjectProperty(arg2,arg3,arg4,(std::vector< int > const &)*arg5);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_scilab_modules_xcos_JavaControllerJNI_Controller_1setObjectProperty_1_1SWIG_17(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jint jarg3, jint jarg4, jlong jarg5, jobject jarg5_) {
  jint jresult = 0 ;
  org_scilab_modules_scicos::Controller *arg1 = (org_scilab_modules_scicos::Controller *) 0 ;
  ScicosID arg2 ;
  kind_t arg3 ;
  object_properties_t arg4 ;
  std::vector< bool > *arg5 = 0 ;
  org_scilab_modules_scicos::Controller **pArg1 ;
  update_status_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg5_;
  // fix -fstrict-aliasing - typemap(in)
  pArg1 = (org_scilab_modules_scicos::Controller **) &jarg1;
  arg1 = *pArg1;
  arg2 = (ScicosID)jarg2; 
  arg3 = (kind_t)jarg3; 
  arg4 = (object_properties_t)jarg4; 
  arg5 = *(std::vector< bool > **)&jarg5;
  if (!arg5) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< bool > const & is null");
    return 0;
  } 
  result = (update_status_t)(arg1)->setObjectProperty(arg2,arg3,arg4,(std::vector< bool > const &)*arg5);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_scilab_modules_xcos_JavaControllerJNI_Controller_1setObjectProperty_1_1SWIG_18(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jint jarg3, jint jarg4, jlong jarg5, jobject jarg5_) {
  jint jresult = 0 ;
  org_scilab_modules_scicos::Controller *arg1 = (org_scilab_modules_scicos::Controller *) 0 ;
  ScicosID arg2 ;
  kind_t arg3 ;
  object_properties_t arg4 ;
  std::vector< std::string > *arg5 = 0 ;
  org_scilab_modules_scicos::Controller **pArg1 ;
  update_status_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg5_;
  // fix -fstrict-aliasing - typemap(in)
  pArg1 = (org_scilab_modules_scicos::Controller **) &jarg1;
  arg1 = *pArg1;
  arg2 = (ScicosID)jarg2; 
  arg3 = (kind_t)jarg3; 
  arg4 = (object_properties_t)jarg4; 
  arg5 = *(std::vector< std::string > **)&jarg5;
  if (!arg5) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< std::string > const & is null");
    return 0;
  } 
  result = (update_status_t)(arg1)->setObjectProperty(arg2,arg3,arg4,(std::vector< std::string > const &)*arg5);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_scilab_modules_xcos_JavaControllerJNI_Controller_1setObjectProperty_1_1SWIG_19(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jint jarg3, jint jarg4, jlong jarg5, jobject jarg5_) {
  jint jresult = 0 ;
  org_scilab_modules_scicos::Controller *arg1 = (org_scilab_modules_scicos::Controller *) 0 ;
  ScicosID arg2 ;
  kind_t arg3 ;
  object_properties_t arg4 ;
  std::vector< ScicosID > *arg5 = 0 ;
  org_scilab_modules_scicos::Controller **pArg1 ;
  update_status_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg5_;
  // fix -fstrict-aliasing - typemap(in)
  pArg1 = (org_scilab_modules_scicos::Controller **) &jarg1;
  arg1 = *pArg1;
  arg2 = (ScicosID)jarg2; 
  arg3 = (kind_t)jarg3; 
  arg4 = (object_properties_t)jarg4; 
  arg5 = *(std::vector< ScicosID > **)&jarg5;
  if (!arg5) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< ScicosID > const & is null");
    return 0;
  } 
  result = (update_status_t)(arg1)->setObjectProperty(arg2,arg3,arg4,(std::vector< ScicosID > const &)*arg5);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_scilab_modules_xcos_JavaControllerJNI_new_1VectorOfInt_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  std::vector< int > **pArg ;
  std::vector< int > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (std::vector< int > *)new std::vector< int >();
  // fix -fstrict-aliasing - typemap(out)
  pArg = (std::vector< int > **) &jresult;
  *pArg = result;
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_scilab_modules_xcos_JavaControllerJNI_new_1VectorOfInt_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  std::vector< int >::size_type arg1 ;
  std::vector< int > **pArg ;
  std::vector< int > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (std::vector< int >::size_type)jarg1; 
  result = (std::vector< int > *)new std::vector< int >(SWIG_STD_MOVE(arg1));
  // fix -fstrict-aliasing - typemap(out)
  pArg = (std::vector< int > **) &jresult;
  *pArg = result;
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_scilab_modules_xcos_JavaControllerJNI_VectorOfInt_1ensureCapacity(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  std::vector< int > *arg1 = (std::vector< int > *) 0 ;
  std::vector< int >::size_type arg2 ;
  std::vector< int > **pArg1 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  // fix -fstrict-aliasing - typemap(in)
  pArg1 = (std::vector< int > **) &jarg1;
  arg1 = *pArg1;
  arg2 = (std::vector< int >::size_type)jarg2; 
  (arg1)->reserve(SWIG_STD_MOVE(arg2));
}


SWIGEXPORT void JNICALL Java_org_scilab_modules_xcos_JavaControllerJNI_VectorOfInt_1resize(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  std::vector< int > *arg1 = (std::vector< int > *) 0 ;
  std::vector< int >::size_type arg2 ;
  std::vector< int > **pArg1 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  // fix -fstrict-aliasing - typemap(in)
  pArg1 = (std::vector< int > **) &jarg1;
  arg1 = *pArg1;
  arg2 = (std::vector< int >::size_type)jarg2; 
  (arg1)->resize(SWIG_STD_MOVE(arg2));
}


SWIGEXPORT jint JNICALL Java_org_scilab_modules_xcos_JavaControllerJNI_VectorOfInt_1size(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  std::vector< int > *arg1 = (std::vector< int > *) 0 ;
  std::vector< int > **pArg1 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  // fix -fstrict-aliasing - typemap(in)
  pArg1 = (std::vector< int > **) &jarg1;
  arg1 = *pArg1;
  result = (int)((std::vector< int > const *)arg1)->size();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_scilab_modules_xcos_JavaControllerJNI_VectorOfInt_1isEmpty(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  std::vector< int > *arg1 = (std::vector< int > *) 0 ;
  std::vector< int > **pArg1 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  // fix -fstrict-aliasing - typemap(in)
  pArg1 = (std::vector< int > **) &jarg1;
  arg1 = *pArg1;
  result = (bool)((std::vector< int > const *)arg1)->empty();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_scilab_modules_xcos_JavaControllerJNI_VectorOfInt_1clear(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  std::vector< int > *arg1 = (std::vector< int > *) 0 ;
  std::vector< int > **pArg1 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  // fix -fstrict-aliasing - typemap(in)
  pArg1 = (std::vector< int > **) &jarg1;
  arg1 = *pArg1;
  (arg1)->clear();
}


SWIGEXPORT void JNICALL Java_org_scilab_modules_xcos_JavaControllerJNI_VectorOfInt_1add_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  std::vector< int > *arg1 = (std::vector< int > *) 0 ;
  std::vector< int >::value_type *arg2 = 0 ;
  std::vector< int > **pArg1 ;
  std::vector< int >::value_type temp2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  // fix -fstrict-aliasing - typemap(in)
  pArg1 = (std::vector< int > **) &jarg1;
  arg1 = *pArg1;
  temp2 = (std::vector< int >::value_type)jarg2; 
  arg2 = &temp2; 
  (arg1)->push_back((std::vector< int >::value_type const &)*arg2);
}


SWIGEXPORT jboolean JNICALL Java_org_scilab_modules_xcos_JavaControllerJNI_VectorOfInt_1contains(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jboolean jresult = 0 ;
  std::vector< int > *arg1 = (std::vector< int > *) 0 ;
  int *arg2 = 0 ;
  std::vector< int > **pArg1 ;
  int temp2 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  // fix -fstrict-aliasing - typemap(in)
  pArg1 = (std::vector< int > **) &jarg1;
  arg1 = *pArg1;
  temp2 = (int)jarg2; 
  arg2 = &temp2; 
  result = (bool)std_vector_Sl_int_Sg__contains(arg1,(int const &)*arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_scilab_modules_xcos_JavaControllerJNI_VectorOfInt_1indexOf(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jint jresult = 0 ;
  std::vector< int > *arg1 = (std::vector< int > *) 0 ;
  int *arg2 = 0 ;
  std::vector< int > **pArg1 ;
  int temp2 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  // fix -fstrict-aliasing - typemap(in)
  pArg1 = (std::vector< int > **) &jarg1;
  arg1 = *pArg1;
  temp2 = (int)jarg2; 
  arg2 = &temp2; 
  result = (int)std_vector_Sl_int_Sg__indexOf(arg1,(int const &)*arg2);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_scilab_modules_xcos_JavaControllerJNI_VectorOfInt_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jint jresult = 0 ;
  std::vector< int > *arg1 = (std::vector< int > *) 0 ;
  int arg2 ;
  std::vector< int > **pArg1 ;
  std::vector< int >::value_type *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  // fix -fstrict-aliasing - typemap(in)
  pArg1 = (std::vector< int > **) &jarg1;
  arg1 = *pArg1;
  arg2 = (int)jarg2; 
  try {
    result = (std::vector< int >::value_type *) &std_vector_Sl_int_Sg__get(arg1,arg2);
  } catch(std::out_of_range &_e) {
    SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
    return 0;
  }
  jresult = (jint)*result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_scilab_modules_xcos_JavaControllerJNI_VectorOfInt_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jint jarg3) {
  std::vector< int > *arg1 = (std::vector< int > *) 0 ;
  int arg2 ;
  std::vector< int >::value_type *arg3 = 0 ;
  std::vector< int > **pArg1 ;
  std::vector< int >::value_type temp3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  // fix -fstrict-aliasing - typemap(in)
  pArg1 = (std::vector< int > **) &jarg1;
  arg1 = *pArg1;
  arg2 = (int)jarg2; 
  temp3 = (std::vector< int >::value_type)jarg3; 
  arg3 = &temp3; 
  try {
    std_vector_Sl_int_Sg__set(arg1,arg2,(int const &)*arg3);
  } catch(std::out_of_range &_e) {
    SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
    return ;
  }
}


SWIGEXPORT void JNICALL Java_org_scilab_modules_xcos_JavaControllerJNI_VectorOfInt_1add_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jint jarg3) {
  std::vector< int > *arg1 = (std::vector< int > *) 0 ;
  int arg2 ;
  std::vector< int >::value_type *arg3 = 0 ;
  std::vector< int > **pArg1 ;
  std::vector< int >::value_type temp3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  // fix -fstrict-aliasing - typemap(in)
  pArg1 = (std::vector< int > **) &jarg1;
  arg1 = *pArg1;
  arg2 = (int)jarg2; 
  temp3 = (std::vector< int >::value_type)jarg3; 
  arg3 = &temp3; 
  try {
    std_vector_Sl_int_Sg__add__SWIG_1(arg1,arg2,(int const &)*arg3);
  } catch(std::out_of_range &_e) {
    SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
    return ;
  }
}


SWIGEXPORT jboolean JNICALL Java_org_scilab_modules_xcos_JavaControllerJNI_VectorOfInt_1remove(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jboolean jresult = 0 ;
  std::vector< int > *arg1 = (std::vector< int > *) 0 ;
  std::vector< int >::value_type *arg2 = 0 ;
  std::vector< int > **pArg1 ;
  std::vector< int >::value_type temp2 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  // fix -fstrict-aliasing - typemap(in)
  pArg1 = (std::vector< int > **) &jarg1;
  arg1 = *pArg1;
  temp2 = (std::vector< int >::value_type)jarg2; 
  arg2 = &temp2; 
  result = (bool)std_vector_Sl_int_Sg__remove(arg1,(int const &)*arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jobject JNICALL Java_org_scilab_modules_xcos_JavaControllerJNI_VectorOfInt_1asByteBuffer(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jint jarg3) {
  jobject jresult = 0 ;
  std::vector< int > *arg1 = (std::vector< int > *) 0 ;
  int arg2 ;
  int arg3 ;
  std::vector< int > **pArg1 ;
  void *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  // fix -fstrict-aliasing - typemap(in)
  pArg1 = (std::vector< int > **) &jarg1;
  arg1 = *pArg1;
  arg2 = (int)jarg2; 
  arg3 = (int)jarg3; 
  result = (void *)std_vector_Sl_int_Sg__asByteBuffer(arg1,arg2,arg3);
  {
    if (arg3 <= 0) {
      arg3 = arg1->size() - arg2;
    } else if (arg1->size() < arg3) {
      throw std::out_of_range("vector index out of range");
    }
    jresult = jenv->NewDirectByteBuffer(result, arg3 * sizeof(decltype(arg1->back())));
  }
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_scilab_modules_xcos_JavaControllerJNI_delete_1VectorOfInt(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  std::vector< int > *arg1 = (std::vector< int > *) 0 ;
  std::vector< int > **pArg1 ;
  
  (void)jenv;
  (void)jcls;
  // fix -fstrict-aliasing - typemap(in)
  pArg1 = (std::vector< int > **) &jarg1;
  arg1 = *pArg1;
  delete arg1;
}


SWIGEXPORT jlong JNICALL Java_org_scilab_modules_xcos_JavaControllerJNI_new_1VectorOfBool_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  std::vector< bool > **pArg ;
  std::vector< bool > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (std::vector< bool > *)new std::vector< bool >();
  // fix -fstrict-aliasing - typemap(out)
  pArg = (std::vector< bool > **) &jresult;
  *pArg = result;
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_scilab_modules_xcos_JavaControllerJNI_new_1VectorOfBool_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  std::vector< bool >::size_type arg1 ;
  std::vector< bool > **pArg ;
  std::vector< bool > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (std::vector< bool >::size_type)jarg1; 
  result = (std::vector< bool > *)new std::vector< bool >(SWIG_STD_MOVE(arg1));
  // fix -fstrict-aliasing - typemap(out)
  pArg = (std::vector< bool > **) &jresult;
  *pArg = result;
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_scilab_modules_xcos_JavaControllerJNI_VectorOfBool_1ensureCapacity(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  std::vector< bool > *arg1 = (std::vector< bool > *) 0 ;
  std::vector< bool >::size_type arg2 ;
  std::vector< bool > **pArg1 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  // fix -fstrict-aliasing - typemap(in)
  pArg1 = (std::vector< bool > **) &jarg1;
  arg1 = *pArg1;
  arg2 = (std::vector< bool >::size_type)jarg2; 
  (arg1)->reserve(SWIG_STD_MOVE(arg2));
}


SWIGEXPORT void JNICALL Java_org_scilab_modules_xcos_JavaControllerJNI_VectorOfBool_1resize(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  std::vector< bool > *arg1 = (std::vector< bool > *) 0 ;
  std::vector< bool >::size_type arg2 ;
  std::vector< bool > **pArg1 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  // fix -fstrict-aliasing - typemap(in)
  pArg1 = (std::vector< bool > **) &jarg1;
  arg1 = *pArg1;
  arg2 = (std::vector< bool >::size_type)jarg2; 
  (arg1)->resize(SWIG_STD_MOVE(arg2));
}


SWIGEXPORT jint JNICALL Java_org_scilab_modules_xcos_JavaControllerJNI_VectorOfBool_1size(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  std::vector< bool > *arg1 = (std::vector< bool > *) 0 ;
  std::vector< bool > **pArg1 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  // fix -fstrict-aliasing - typemap(in)
  pArg1 = (std::vector< bool > **) &jarg1;
  arg1 = *pArg1;
  result = (int)((std::vector< bool > const *)arg1)->size();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_scilab_modules_xcos_JavaControllerJNI_VectorOfBool_1isEmpty(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  std::vector< bool > *arg1 = (std::vector< bool > *) 0 ;
  std::vector< bool > **pArg1 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  // fix -fstrict-aliasing - typemap(in)
  pArg1 = (std::vector< bool > **) &jarg1;
  arg1 = *pArg1;
  result = (bool)((std::vector< bool > const *)arg1)->empty();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_scilab_modules_xcos_JavaControllerJNI_VectorOfBool_1clear(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  std::vector< bool > *arg1 = (std::vector< bool > *) 0 ;
  std::vector< bool > **pArg1 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  // fix -fstrict-aliasing - typemap(in)
  pArg1 = (std::vector< bool > **) &jarg1;
  arg1 = *pArg1;
  (arg1)->clear();
}


SWIGEXPORT void JNICALL Java_org_scilab_modules_xcos_JavaControllerJNI_VectorOfBool_1add_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jboolean jarg2) {
  std::vector< bool > *arg1 = (std::vector< bool > *) 0 ;
  std::vector< bool >::value_type *arg2 = 0 ;
  std::vector< bool > **pArg1 ;
  std::vector< bool >::value_type temp2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  // fix -fstrict-aliasing - typemap(in)
  pArg1 = (std::vector< bool > **) &jarg1;
  arg1 = *pArg1;
  temp2 = jarg2 ? true : false; 
  arg2 = &temp2; 
  (arg1)->push_back((std::vector< bool >::value_type const &)*arg2);
}


SWIGEXPORT jboolean JNICALL Java_org_scilab_modules_xcos_JavaControllerJNI_VectorOfBool_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jboolean jresult = 0 ;
  std::vector< bool > *arg1 = (std::vector< bool > *) 0 ;
  int arg2 ;
  std::vector< bool > **pArg1 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  // fix -fstrict-aliasing - typemap(in)
  pArg1 = (std::vector< bool > **) &jarg1;
  arg1 = *pArg1;
  arg2 = (int)jarg2; 
  try {
    result = (bool)std_vector_Sl_bool_Sg__get(arg1,arg2);
  } catch(std::out_of_range &_e) {
    SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
    return 0;
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_scilab_modules_xcos_JavaControllerJNI_VectorOfBool_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jboolean jarg3) {
  std::vector< bool > *arg1 = (std::vector< bool > *) 0 ;
  int arg2 ;
  std::vector< bool >::value_type *arg3 = 0 ;
  std::vector< bool > **pArg1 ;
  std::vector< bool >::value_type temp3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  // fix -fstrict-aliasing - typemap(in)
  pArg1 = (std::vector< bool > **) &jarg1;
  arg1 = *pArg1;
  arg2 = (int)jarg2; 
  temp3 = jarg3 ? true : false; 
  arg3 = &temp3; 
  try {
    std_vector_Sl_bool_Sg__set(arg1,arg2,(bool const &)*arg3);
  } catch(std::out_of_range &_e) {
    SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
    return ;
  }
}


SWIGEXPORT void JNICALL Java_org_scilab_modules_xcos_JavaControllerJNI_VectorOfBool_1add_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jboolean jarg3) {
  std::vector< bool > *arg1 = (std::vector< bool > *) 0 ;
  int arg2 ;
  std::vector< bool >::value_type *arg3 = 0 ;
  std::vector< bool > **pArg1 ;
  std::vector< bool >::value_type temp3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  // fix -fstrict-aliasing - typemap(in)
  pArg1 = (std::vector< bool > **) &jarg1;
  arg1 = *pArg1;
  arg2 = (int)jarg2; 
  temp3 = jarg3 ? true : false; 
  arg3 = &temp3; 
  try {
    std_vector_Sl_bool_Sg__add__SWIG_1(arg1,arg2,(bool const &)*arg3);
  } catch(std::out_of_range &_e) {
    SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
    return ;
  }
}


SWIGEXPORT jboolean JNICALL Java_org_scilab_modules_xcos_JavaControllerJNI_VectorOfBool_1remove(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jboolean jarg2) {
  jboolean jresult = 0 ;
  std::vector< bool > *arg1 = (std::vector< bool > *) 0 ;
  std::vector< bool >::value_type *arg2 = 0 ;
  std::vector< bool > **pArg1 ;
  std::vector< bool >::value_type temp2 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  // fix -fstrict-aliasing - typemap(in)
  pArg1 = (std::vector< bool > **) &jarg1;
  arg1 = *pArg1;
  temp2 = jarg2 ? true : false; 
  arg2 = &temp2; 
  result = (bool)std_vector_Sl_bool_Sg__remove(arg1,(bool const &)*arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_scilab_modules_xcos_JavaControllerJNI_delete_1VectorOfBool(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  std::vector< bool > *arg1 = (std::vector< bool > *) 0 ;
  std::vector< bool > **pArg1 ;
  
  (void)jenv;
  (void)jcls;
  // fix -fstrict-aliasing - typemap(in)
  pArg1 = (std::vector< bool > **) &jarg1;
  arg1 = *pArg1;
  delete arg1;
}


SWIGEXPORT jlong JNICALL Java_org_scilab_modules_xcos_JavaControllerJNI_new_1VectorOfDouble_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  std::vector< double > **pArg ;
  std::vector< double > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (std::vector< double > *)new std::vector< double >();
  // fix -fstrict-aliasing - typemap(out)
  pArg = (std::vector< double > **) &jresult;
  *pArg = result;
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_scilab_modules_xcos_JavaControllerJNI_new_1VectorOfDouble_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  std::vector< double >::size_type arg1 ;
  std::vector< double > **pArg ;
  std::vector< double > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (std::vector< double >::size_type)jarg1; 
  result = (std::vector< double > *)new std::vector< double >(SWIG_STD_MOVE(arg1));
  // fix -fstrict-aliasing - typemap(out)
  pArg = (std::vector< double > **) &jresult;
  *pArg = result;
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_scilab_modules_xcos_JavaControllerJNI_VectorOfDouble_1ensureCapacity(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  std::vector< double > *arg1 = (std::vector< double > *) 0 ;
  std::vector< double >::size_type arg2 ;
  std::vector< double > **pArg1 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  // fix -fstrict-aliasing - typemap(in)
  pArg1 = (std::vector< double > **) &jarg1;
  arg1 = *pArg1;
  arg2 = (std::vector< double >::size_type)jarg2; 
  (arg1)->reserve(SWIG_STD_MOVE(arg2));
}


SWIGEXPORT void JNICALL Java_org_scilab_modules_xcos_JavaControllerJNI_VectorOfDouble_1resize(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  std::vector< double > *arg1 = (std::vector< double > *) 0 ;
  std::vector< double >::size_type arg2 ;
  std::vector< double > **pArg1 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  // fix -fstrict-aliasing - typemap(in)
  pArg1 = (std::vector< double > **) &jarg1;
  arg1 = *pArg1;
  arg2 = (std::vector< double >::size_type)jarg2; 
  (arg1)->resize(SWIG_STD_MOVE(arg2));
}


SWIGEXPORT jint JNICALL Java_org_scilab_modules_xcos_JavaControllerJNI_VectorOfDouble_1size(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  std::vector< double > *arg1 = (std::vector< double > *) 0 ;
  std::vector< double > **pArg1 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  // fix -fstrict-aliasing - typemap(in)
  pArg1 = (std::vector< double > **) &jarg1;
  arg1 = *pArg1;
  result = (int)((std::vector< double > const *)arg1)->size();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_scilab_modules_xcos_JavaControllerJNI_VectorOfDouble_1isEmpty(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  std::vector< double > *arg1 = (std::vector< double > *) 0 ;
  std::vector< double > **pArg1 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  // fix -fstrict-aliasing - typemap(in)
  pArg1 = (std::vector< double > **) &jarg1;
  arg1 = *pArg1;
  result = (bool)((std::vector< double > const *)arg1)->empty();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_scilab_modules_xcos_JavaControllerJNI_VectorOfDouble_1clear(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  std::vector< double > *arg1 = (std::vector< double > *) 0 ;
  std::vector< double > **pArg1 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  // fix -fstrict-aliasing - typemap(in)
  pArg1 = (std::vector< double > **) &jarg1;
  arg1 = *pArg1;
  (arg1)->clear();
}


SWIGEXPORT void JNICALL Java_org_scilab_modules_xcos_JavaControllerJNI_VectorOfDouble_1add_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jdouble jarg2) {
  std::vector< double > *arg1 = (std::vector< double > *) 0 ;
  std::vector< double >::value_type *arg2 = 0 ;
  std::vector< double > **pArg1 ;
  std::vector< double >::value_type temp2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  // fix -fstrict-aliasing - typemap(in)
  pArg1 = (std::vector< double > **) &jarg1;
  arg1 = *pArg1;
  temp2 = (std::vector< double >::value_type)jarg2; 
  arg2 = &temp2; 
  (arg1)->push_back((std::vector< double >::value_type const &)*arg2);
}


SWIGEXPORT jboolean JNICALL Java_org_scilab_modules_xcos_JavaControllerJNI_VectorOfDouble_1contains(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jdouble jarg2) {
  jboolean jresult = 0 ;
  std::vector< double > *arg1 = (std::vector< double > *) 0 ;
  double *arg2 = 0 ;
  std::vector< double > **pArg1 ;
  double temp2 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  // fix -fstrict-aliasing - typemap(in)
  pArg1 = (std::vector< double > **) &jarg1;
  arg1 = *pArg1;
  temp2 = (double)jarg2; 
  arg2 = &temp2; 
  result = (bool)std_vector_Sl_double_Sg__contains(arg1,(double const &)*arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_scilab_modules_xcos_JavaControllerJNI_VectorOfDouble_1indexOf(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jdouble jarg2) {
  jint jresult = 0 ;
  std::vector< double > *arg1 = (std::vector< double > *) 0 ;
  double *arg2 = 0 ;
  std::vector< double > **pArg1 ;
  double temp2 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  // fix -fstrict-aliasing - typemap(in)
  pArg1 = (std::vector< double > **) &jarg1;
  arg1 = *pArg1;
  temp2 = (double)jarg2; 
  arg2 = &temp2; 
  result = (int)std_vector_Sl_double_Sg__indexOf(arg1,(double const &)*arg2);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_org_scilab_modules_xcos_JavaControllerJNI_VectorOfDouble_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jdouble jresult = 0 ;
  std::vector< double > *arg1 = (std::vector< double > *) 0 ;
  int arg2 ;
  std::vector< double > **pArg1 ;
  std::vector< double >::value_type *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  // fix -fstrict-aliasing - typemap(in)
  pArg1 = (std::vector< double > **) &jarg1;
  arg1 = *pArg1;
  arg2 = (int)jarg2; 
  try {
    result = (std::vector< double >::value_type *) &std_vector_Sl_double_Sg__get(arg1,arg2);
  } catch(std::out_of_range &_e) {
    SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
    return 0;
  }
  jresult = (jdouble)*result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_scilab_modules_xcos_JavaControllerJNI_VectorOfDouble_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jdouble jarg3) {
  std::vector< double > *arg1 = (std::vector< double > *) 0 ;
  int arg2 ;
  std::vector< double >::value_type *arg3 = 0 ;
  std::vector< double > **pArg1 ;
  std::vector< double >::value_type temp3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  // fix -fstrict-aliasing - typemap(in)
  pArg1 = (std::vector< double > **) &jarg1;
  arg1 = *pArg1;
  arg2 = (int)jarg2; 
  temp3 = (std::vector< double >::value_type)jarg3; 
  arg3 = &temp3; 
  try {
    std_vector_Sl_double_Sg__set(arg1,arg2,(double const &)*arg3);
  } catch(std::out_of_range &_e) {
    SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
    return ;
  }
}


SWIGEXPORT void JNICALL Java_org_scilab_modules_xcos_JavaControllerJNI_VectorOfDouble_1add_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jdouble jarg3) {
  std::vector< double > *arg1 = (std::vector< double > *) 0 ;
  int arg2 ;
  std::vector< double >::value_type *arg3 = 0 ;
  std::vector< double > **pArg1 ;
  std::vector< double >::value_type temp3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  // fix -fstrict-aliasing - typemap(in)
  pArg1 = (std::vector< double > **) &jarg1;
  arg1 = *pArg1;
  arg2 = (int)jarg2; 
  temp3 = (std::vector< double >::value_type)jarg3; 
  arg3 = &temp3; 
  try {
    std_vector_Sl_double_Sg__add__SWIG_1(arg1,arg2,(double const &)*arg3);
  } catch(std::out_of_range &_e) {
    SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
    return ;
  }
}


SWIGEXPORT jboolean JNICALL Java_org_scilab_modules_xcos_JavaControllerJNI_VectorOfDouble_1remove(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jdouble jarg2) {
  jboolean jresult = 0 ;
  std::vector< double > *arg1 = (std::vector< double > *) 0 ;
  std::vector< double >::value_type *arg2 = 0 ;
  std::vector< double > **pArg1 ;
  std::vector< double >::value_type temp2 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  // fix -fstrict-aliasing - typemap(in)
  pArg1 = (std::vector< double > **) &jarg1;
  arg1 = *pArg1;
  temp2 = (std::vector< double >::value_type)jarg2; 
  arg2 = &temp2; 
  result = (bool)std_vector_Sl_double_Sg__remove(arg1,(double const &)*arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jobject JNICALL Java_org_scilab_modules_xcos_JavaControllerJNI_VectorOfDouble_1asByteBuffer(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jint jarg3) {
  jobject jresult = 0 ;
  std::vector< double > *arg1 = (std::vector< double > *) 0 ;
  int arg2 ;
  int arg3 ;
  std::vector< double > **pArg1 ;
  void *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  // fix -fstrict-aliasing - typemap(in)
  pArg1 = (std::vector< double > **) &jarg1;
  arg1 = *pArg1;
  arg2 = (int)jarg2; 
  arg3 = (int)jarg3; 
  result = (void *)std_vector_Sl_double_Sg__asByteBuffer(arg1,arg2,arg3);
  {
    if (arg3 <= 0) {
      arg3 = arg1->size() - arg2;
    } else if (arg1->size() < arg3) {
      throw std::out_of_range("vector index out of range");
    }
    jresult = jenv->NewDirectByteBuffer(result, arg3 * sizeof(decltype(arg1->back())));
  }
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_scilab_modules_xcos_JavaControllerJNI_delete_1VectorOfDouble(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  std::vector< double > *arg1 = (std::vector< double > *) 0 ;
  std::vector< double > **pArg1 ;
  
  (void)jenv;
  (void)jcls;
  // fix -fstrict-aliasing - typemap(in)
  pArg1 = (std::vector< double > **) &jarg1;
  arg1 = *pArg1;
  delete arg1;
}


SWIGEXPORT jlong JNICALL Java_org_scilab_modules_xcos_JavaControllerJNI_new_1VectorOfString_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  std::vector< std::string > **pArg ;
  std::vector< std::string > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (std::vector< std::string > *)new std::vector< std::string >();
  // fix -fstrict-aliasing - typemap(out)
  pArg = (std::vector< std::string > **) &jresult;
  *pArg = result;
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_scilab_modules_xcos_JavaControllerJNI_new_1VectorOfString_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  std::vector< std::string >::size_type arg1 ;
  std::vector< std::string > **pArg ;
  std::vector< std::string > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (std::vector< std::string >::size_type)jarg1; 
  result = (std::vector< std::string > *)new std::vector< std::string >(SWIG_STD_MOVE(arg1));
  // fix -fstrict-aliasing - typemap(out)
  pArg = (std::vector< std::string > **) &jresult;
  *pArg = result;
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_scilab_modules_xcos_JavaControllerJNI_VectorOfString_1ensureCapacity(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  std::vector< std::string > *arg1 = (std::vector< std::string > *) 0 ;
  std::vector< std::string >::size_type arg2 ;
  std::vector< std::string > **pArg1 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  // fix -fstrict-aliasing - typemap(in)
  pArg1 = (std::vector< std::string > **) &jarg1;
  arg1 = *pArg1;
  arg2 = (std::vector< std::string >::size_type)jarg2; 
  (arg1)->reserve(SWIG_STD_MOVE(arg2));
}


SWIGEXPORT void JNICALL Java_org_scilab_modules_xcos_JavaControllerJNI_VectorOfString_1resize(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  std::vector< std::string > *arg1 = (std::vector< std::string > *) 0 ;
  std::vector< std::string >::size_type arg2 ;
  std::vector< std::string > **pArg1 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  // fix -fstrict-aliasing - typemap(in)
  pArg1 = (std::vector< std::string > **) &jarg1;
  arg1 = *pArg1;
  arg2 = (std::vector< std::string >::size_type)jarg2; 
  (arg1)->resize(SWIG_STD_MOVE(arg2));
}


SWIGEXPORT jint JNICALL Java_org_scilab_modules_xcos_JavaControllerJNI_VectorOfString_1size(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  std::vector< std::string > *arg1 = (std::vector< std::string > *) 0 ;
  std::vector< std::string > **pArg1 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  // fix -fstrict-aliasing - typemap(in)
  pArg1 = (std::vector< std::string > **) &jarg1;
  arg1 = *pArg1;
  result = (int)((std::vector< std::string > const *)arg1)->size();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_scilab_modules_xcos_JavaControllerJNI_VectorOfString_1isEmpty(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  std::vector< std::string > *arg1 = (std::vector< std::string > *) 0 ;
  std::vector< std::string > **pArg1 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  // fix -fstrict-aliasing - typemap(in)
  pArg1 = (std::vector< std::string > **) &jarg1;
  arg1 = *pArg1;
  result = (bool)((std::vector< std::string > const *)arg1)->empty();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_scilab_modules_xcos_JavaControllerJNI_VectorOfString_1clear(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  std::vector< std::string > *arg1 = (std::vector< std::string > *) 0 ;
  std::vector< std::string > **pArg1 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  // fix -fstrict-aliasing - typemap(in)
  pArg1 = (std::vector< std::string > **) &jarg1;
  arg1 = *pArg1;
  (arg1)->clear();
}


SWIGEXPORT void JNICALL Java_org_scilab_modules_xcos_JavaControllerJNI_VectorOfString_1add_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  std::vector< std::string > *arg1 = (std::vector< std::string > *) 0 ;
  std::vector< std::string >::value_type *arg2 = 0 ;
  std::vector< std::string > **pArg1 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  // fix -fstrict-aliasing - typemap(in)
  pArg1 = (std::vector< std::string > **) &jarg1;
  arg1 = *pArg1;
  Swig::JavaString javaString(jenv, jarg2);
  std::string arg2_str(javaString.c_str());
  arg2 = &arg2_str;
  (arg1)->push_back((std::vector< std::string >::value_type const &)*arg2);
  
}


SWIGEXPORT jboolean JNICALL Java_org_scilab_modules_xcos_JavaControllerJNI_VectorOfString_1contains(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  jboolean jresult = 0 ;
  std::vector< std::string > *arg1 = (std::vector< std::string > *) 0 ;
  std::string *arg2 = 0 ;
  std::vector< std::string > **pArg1 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  // fix -fstrict-aliasing - typemap(in)
  pArg1 = (std::vector< std::string > **) &jarg1;
  arg1 = *pArg1;
  Swig::JavaString javaString(jenv, jarg2);
  std::string arg2_str(javaString.c_str());
  arg2 = &arg2_str;
  result = (bool)std_vector_Sl_std_string_Sg__contains(arg1,(std::string const &)*arg2);
  jresult = (jboolean)result; 
  
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_scilab_modules_xcos_JavaControllerJNI_VectorOfString_1indexOf(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  jint jresult = 0 ;
  std::vector< std::string > *arg1 = (std::vector< std::string > *) 0 ;
  std::string *arg2 = 0 ;
  std::vector< std::string > **pArg1 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  // fix -fstrict-aliasing - typemap(in)
  pArg1 = (std::vector< std::string > **) &jarg1;
  arg1 = *pArg1;
  Swig::JavaString javaString(jenv, jarg2);
  std::string arg2_str(javaString.c_str());
  arg2 = &arg2_str;
  result = (int)std_vector_Sl_std_string_Sg__indexOf(arg1,(std::string const &)*arg2);
  jresult = (jint)result; 
  
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_org_scilab_modules_xcos_JavaControllerJNI_VectorOfString_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jstring jresult = 0 ;
  std::vector< std::string > *arg1 = (std::vector< std::string > *) 0 ;
  int arg2 ;
  std::vector< std::string > **pArg1 ;
  std::vector< std::string >::value_type *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  // fix -fstrict-aliasing - typemap(in)
  pArg1 = (std::vector< std::string > **) &jarg1;
  arg1 = *pArg1;
  arg2 = (int)jarg2; 
  try {
    result = (std::vector< std::string >::value_type *) &std_vector_Sl_std_string_Sg__get(arg1,arg2);
  } catch(std::out_of_range &_e) {
    SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
    return 0;
  }
  jresult = jenv->NewStringUTF(result->c_str()); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_scilab_modules_xcos_JavaControllerJNI_VectorOfString_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jstring jarg3) {
  std::vector< std::string > *arg1 = (std::vector< std::string > *) 0 ;
  int arg2 ;
  std::vector< std::string >::value_type *arg3 = 0 ;
  std::vector< std::string > **pArg1 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  // fix -fstrict-aliasing - typemap(in)
  pArg1 = (std::vector< std::string > **) &jarg1;
  arg1 = *pArg1;
  arg2 = (int)jarg2; 
  Swig::JavaString javaString(jenv, jarg3);
  std::string arg3_str(javaString.c_str());
  arg3 = &arg3_str;
  try {
    std_vector_Sl_std_string_Sg__set(arg1,arg2,(std::string const &)*arg3);
  } catch(std::out_of_range &_e) {
    SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
    return ;
  }
  
}


SWIGEXPORT void JNICALL Java_org_scilab_modules_xcos_JavaControllerJNI_VectorOfString_1add_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jstring jarg3) {
  std::vector< std::string > *arg1 = (std::vector< std::string > *) 0 ;
  int arg2 ;
  std::vector< std::string >::value_type *arg3 = 0 ;
  std::vector< std::string > **pArg1 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  // fix -fstrict-aliasing - typemap(in)
  pArg1 = (std::vector< std::string > **) &jarg1;
  arg1 = *pArg1;
  arg2 = (int)jarg2; 
  Swig::JavaString javaString(jenv, jarg3);
  std::string arg3_str(javaString.c_str());
  arg3 = &arg3_str;
  try {
    std_vector_Sl_std_string_Sg__add__SWIG_1(arg1,arg2,(std::string const &)*arg3);
  } catch(std::out_of_range &_e) {
    SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
    return ;
  }
  
}


SWIGEXPORT jboolean JNICALL Java_org_scilab_modules_xcos_JavaControllerJNI_VectorOfString_1remove(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  jboolean jresult = 0 ;
  std::vector< std::string > *arg1 = (std::vector< std::string > *) 0 ;
  std::vector< std::string >::value_type *arg2 = 0 ;
  std::vector< std::string > **pArg1 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  // fix -fstrict-aliasing - typemap(in)
  pArg1 = (std::vector< std::string > **) &jarg1;
  arg1 = *pArg1;
  Swig::JavaString javaString(jenv, jarg2);
  std::string arg2_str(javaString.c_str());
  arg2 = &arg2_str;
  result = (bool)std_vector_Sl_std_string_Sg__remove(arg1,(std::string const &)*arg2);
  jresult = (jboolean)result; 
  
  return jresult;
}


SWIGEXPORT jobject JNICALL Java_org_scilab_modules_xcos_JavaControllerJNI_VectorOfString_1asByteBuffer(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jint jarg3) {
  jobject jresult = 0 ;
  std::vector< std::string > *arg1 = (std::vector< std::string > *) 0 ;
  int arg2 ;
  int arg3 ;
  std::vector< std::string > **pArg1 ;
  void *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  // fix -fstrict-aliasing - typemap(in)
  pArg1 = (std::vector< std::string > **) &jarg1;
  arg1 = *pArg1;
  arg2 = (int)jarg2; 
  arg3 = (int)jarg3; 
  result = (void *)std_vector_Sl_std_string_Sg__asByteBuffer(arg1,arg2,arg3);
  {
    if (arg3 <= 0) {
      arg3 = arg1->size() - arg2;
    } else if (arg1->size() < arg3) {
      throw std::out_of_range("vector index out of range");
    }
    jresult = jenv->NewDirectByteBuffer(result, arg3 * sizeof(decltype(arg1->back())));
  }
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_scilab_modules_xcos_JavaControllerJNI_delete_1VectorOfString(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  std::vector< std::string > *arg1 = (std::vector< std::string > *) 0 ;
  std::vector< std::string > **pArg1 ;
  
  (void)jenv;
  (void)jcls;
  // fix -fstrict-aliasing - typemap(in)
  pArg1 = (std::vector< std::string > **) &jarg1;
  arg1 = *pArg1;
  delete arg1;
}


SWIGEXPORT jlong JNICALL Java_org_scilab_modules_xcos_JavaControllerJNI_new_1VectorOfScicosID_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  std::vector< ScicosID > **pArg ;
  std::vector< ScicosID > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (std::vector< ScicosID > *)new std::vector< ScicosID >();
  // fix -fstrict-aliasing - typemap(out)
  pArg = (std::vector< ScicosID > **) &jresult;
  *pArg = result;
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_scilab_modules_xcos_JavaControllerJNI_new_1VectorOfScicosID_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  std::vector< long long >::size_type arg1 ;
  std::vector< ScicosID > **pArg ;
  std::vector< ScicosID > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (std::vector< long long >::size_type)jarg1; 
  result = (std::vector< ScicosID > *)new std::vector< ScicosID >(SWIG_STD_MOVE(arg1));
  // fix -fstrict-aliasing - typemap(out)
  pArg = (std::vector< ScicosID > **) &jresult;
  *pArg = result;
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_scilab_modules_xcos_JavaControllerJNI_VectorOfScicosID_1ensureCapacity(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  std::vector< ScicosID > *arg1 = (std::vector< ScicosID > *) 0 ;
  std::vector< long long >::size_type arg2 ;
  std::vector< ScicosID > **pArg1 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  // fix -fstrict-aliasing - typemap(in)
  pArg1 = (std::vector< ScicosID > **) &jarg1;
  arg1 = *pArg1;
  arg2 = (std::vector< long long >::size_type)jarg2; 
  (arg1)->reserve(SWIG_STD_MOVE(arg2));
}


SWIGEXPORT void JNICALL Java_org_scilab_modules_xcos_JavaControllerJNI_VectorOfScicosID_1resize(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  std::vector< ScicosID > *arg1 = (std::vector< ScicosID > *) 0 ;
  std::vector< long long >::size_type arg2 ;
  std::vector< ScicosID > **pArg1 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  // fix -fstrict-aliasing - typemap(in)
  pArg1 = (std::vector< ScicosID > **) &jarg1;
  arg1 = *pArg1;
  arg2 = (std::vector< long long >::size_type)jarg2; 
  (arg1)->resize(SWIG_STD_MOVE(arg2));
}


SWIGEXPORT jint JNICALL Java_org_scilab_modules_xcos_JavaControllerJNI_VectorOfScicosID_1size(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  std::vector< ScicosID > *arg1 = (std::vector< ScicosID > *) 0 ;
  std::vector< ScicosID > **pArg1 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  // fix -fstrict-aliasing - typemap(in)
  pArg1 = (std::vector< ScicosID > **) &jarg1;
  arg1 = *pArg1;
  result = (int)((std::vector< ScicosID > const *)arg1)->size();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_scilab_modules_xcos_JavaControllerJNI_VectorOfScicosID_1isEmpty(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  std::vector< ScicosID > *arg1 = (std::vector< ScicosID > *) 0 ;
  std::vector< ScicosID > **pArg1 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  // fix -fstrict-aliasing - typemap(in)
  pArg1 = (std::vector< ScicosID > **) &jarg1;
  arg1 = *pArg1;
  result = (bool)((std::vector< ScicosID > const *)arg1)->empty();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_scilab_modules_xcos_JavaControllerJNI_VectorOfScicosID_1clear(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  std::vector< ScicosID > *arg1 = (std::vector< ScicosID > *) 0 ;
  std::vector< ScicosID > **pArg1 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  // fix -fstrict-aliasing - typemap(in)
  pArg1 = (std::vector< ScicosID > **) &jarg1;
  arg1 = *pArg1;
  (arg1)->clear();
}


SWIGEXPORT void JNICALL Java_org_scilab_modules_xcos_JavaControllerJNI_VectorOfScicosID_1add_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  std::vector< ScicosID > *arg1 = (std::vector< ScicosID > *) 0 ;
  std::vector< long long >::value_type *arg2 = 0 ;
  std::vector< ScicosID > **pArg1 ;
  std::vector< long long >::value_type temp2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  // fix -fstrict-aliasing - typemap(in)
  pArg1 = (std::vector< ScicosID > **) &jarg1;
  arg1 = *pArg1;
  temp2 = (std::vector< long long >::value_type)jarg2; 
  arg2 = &temp2; 
  (arg1)->push_back((std::vector< long long >::value_type const &)*arg2);
}


SWIGEXPORT jboolean JNICALL Java_org_scilab_modules_xcos_JavaControllerJNI_VectorOfScicosID_1contains(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  jboolean jresult = 0 ;
  std::vector< ScicosID > *arg1 = (std::vector< ScicosID > *) 0 ;
  long long *arg2 = 0 ;
  std::vector< ScicosID > **pArg1 ;
  long long temp2 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  // fix -fstrict-aliasing - typemap(in)
  pArg1 = (std::vector< ScicosID > **) &jarg1;
  arg1 = *pArg1;
  temp2 = (long long)jarg2; 
  arg2 = &temp2; 
  result = (bool)std_vector_Sl_ScicosID_Sg__contains(arg1,(long long const &)*arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_scilab_modules_xcos_JavaControllerJNI_VectorOfScicosID_1indexOf(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  jint jresult = 0 ;
  std::vector< ScicosID > *arg1 = (std::vector< ScicosID > *) 0 ;
  long long *arg2 = 0 ;
  std::vector< ScicosID > **pArg1 ;
  long long temp2 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  // fix -fstrict-aliasing - typemap(in)
  pArg1 = (std::vector< ScicosID > **) &jarg1;
  arg1 = *pArg1;
  temp2 = (long long)jarg2; 
  arg2 = &temp2; 
  result = (int)std_vector_Sl_ScicosID_Sg__indexOf(arg1,(long long const &)*arg2);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_scilab_modules_xcos_JavaControllerJNI_VectorOfScicosID_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jlong jresult = 0 ;
  std::vector< ScicosID > *arg1 = (std::vector< ScicosID > *) 0 ;
  int arg2 ;
  std::vector< ScicosID > **pArg1 ;
  std::vector< long long >::value_type *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  // fix -fstrict-aliasing - typemap(in)
  pArg1 = (std::vector< ScicosID > **) &jarg1;
  arg1 = *pArg1;
  arg2 = (int)jarg2; 
  try {
    result = (std::vector< long long >::value_type *) &std_vector_Sl_ScicosID_Sg__get(arg1,arg2);
  } catch(std::out_of_range &_e) {
    SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
    return 0;
  }
  jresult = (jlong)*result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_scilab_modules_xcos_JavaControllerJNI_VectorOfScicosID_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jlong jarg3) {
  std::vector< ScicosID > *arg1 = (std::vector< ScicosID > *) 0 ;
  int arg2 ;
  std::vector< long long >::value_type *arg3 = 0 ;
  std::vector< ScicosID > **pArg1 ;
  std::vector< long long >::value_type temp3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  // fix -fstrict-aliasing - typemap(in)
  pArg1 = (std::vector< ScicosID > **) &jarg1;
  arg1 = *pArg1;
  arg2 = (int)jarg2; 
  temp3 = (std::vector< long long >::value_type)jarg3; 
  arg3 = &temp3; 
  try {
    std_vector_Sl_ScicosID_Sg__set(arg1,arg2,(long long const &)*arg3);
  } catch(std::out_of_range &_e) {
    SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
    return ;
  }
}


SWIGEXPORT void JNICALL Java_org_scilab_modules_xcos_JavaControllerJNI_VectorOfScicosID_1add_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jlong jarg3) {
  std::vector< ScicosID > *arg1 = (std::vector< ScicosID > *) 0 ;
  int arg2 ;
  std::vector< long long >::value_type *arg3 = 0 ;
  std::vector< ScicosID > **pArg1 ;
  std::vector< long long >::value_type temp3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  // fix -fstrict-aliasing - typemap(in)
  pArg1 = (std::vector< ScicosID > **) &jarg1;
  arg1 = *pArg1;
  arg2 = (int)jarg2; 
  temp3 = (std::vector< long long >::value_type)jarg3; 
  arg3 = &temp3; 
  try {
    std_vector_Sl_ScicosID_Sg__add__SWIG_1(arg1,arg2,(long long const &)*arg3);
  } catch(std::out_of_range &_e) {
    SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
    return ;
  }
}


SWIGEXPORT jboolean JNICALL Java_org_scilab_modules_xcos_JavaControllerJNI_VectorOfScicosID_1remove(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  jboolean jresult = 0 ;
  std::vector< ScicosID > *arg1 = (std::vector< ScicosID > *) 0 ;
  std::vector< long long >::value_type *arg2 = 0 ;
  std::vector< ScicosID > **pArg1 ;
  std::vector< long long >::value_type temp2 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  // fix -fstrict-aliasing - typemap(in)
  pArg1 = (std::vector< ScicosID > **) &jarg1;
  arg1 = *pArg1;
  temp2 = (std::vector< long long >::value_type)jarg2; 
  arg2 = &temp2; 
  result = (bool)std_vector_Sl_ScicosID_Sg__remove(arg1,(long long const &)*arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jobject JNICALL Java_org_scilab_modules_xcos_JavaControllerJNI_VectorOfScicosID_1asByteBuffer(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jint jarg3) {
  jobject jresult = 0 ;
  std::vector< ScicosID > *arg1 = (std::vector< ScicosID > *) 0 ;
  int arg2 ;
  int arg3 ;
  std::vector< ScicosID > **pArg1 ;
  void *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  // fix -fstrict-aliasing - typemap(in)
  pArg1 = (std::vector< ScicosID > **) &jarg1;
  arg1 = *pArg1;
  arg2 = (int)jarg2; 
  arg3 = (int)jarg3; 
  result = (void *)std_vector_Sl_ScicosID_Sg__asByteBuffer(arg1,arg2,arg3);
  {
    if (arg3 <= 0) {
      arg3 = arg1->size() - arg2;
    } else if (arg1->size() < arg3) {
      throw std::out_of_range("vector index out of range");
    }
    jresult = jenv->NewDirectByteBuffer(result, arg3 * sizeof(decltype(arg1->back())));
  }
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_scilab_modules_xcos_JavaControllerJNI_delete_1VectorOfScicosID(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  std::vector< ScicosID > *arg1 = (std::vector< ScicosID > *) 0 ;
  std::vector< ScicosID > **pArg1 ;
  
  (void)jenv;
  (void)jcls;
  // fix -fstrict-aliasing - typemap(in)
  pArg1 = (std::vector< ScicosID > **) &jarg1;
  arg1 = *pArg1;
  delete arg1;
}


SWIGEXPORT void JNICALL Java_org_scilab_modules_xcos_JavaControllerJNI_register_1view(JNIEnv *jenv, jclass jcls, jstring jarg1, jlong jarg2, jobject jarg2_) {
  std::string *arg1 = 0 ;
  org_scilab_modules_scicos::View *arg2 = (org_scilab_modules_scicos::View *) 0 ;
  org_scilab_modules_scicos::View **pArg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg2_;
  Swig::JavaString javaString(jenv, jarg1);
  std::string arg1_str(javaString.c_str());
  arg1 = &arg1_str;
  // fix -fstrict-aliasing - typemap(in)
  pArg2 = (org_scilab_modules_scicos::View **) &jarg2;
  arg2 = *pArg2;
  register_view((std::string const &)*arg1,arg2);
  
}


SWIGEXPORT void JNICALL Java_org_scilab_modules_xcos_JavaControllerJNI_unregister_1view(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  org_scilab_modules_scicos::View *arg1 = (org_scilab_modules_scicos::View *) 0 ;
  org_scilab_modules_scicos::View **pArg1 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  // fix -fstrict-aliasing - typemap(in)
  pArg1 = (org_scilab_modules_scicos::View **) &jarg1;
  arg1 = *pArg1;
  unregister_view(arg1);
}


SWIGEXPORT void JNICALL Java_org_scilab_modules_xcos_JavaControllerJNI_swig_1module_1init(JNIEnv *jenv, jclass jcls) {
  int i;
  
  static struct {
    const char *method;
    const char *signature;
  } methods[6] = {
    {
      "SwigDirector_View_objectCreated", "(Lorg/scilab/modules/xcos/View;JI)V" 
    },
    {
      "SwigDirector_View_objectReferenced", "(Lorg/scilab/modules/xcos/View;JIJ)V" 
    },
    {
      "SwigDirector_View_objectUnreferenced", "(Lorg/scilab/modules/xcos/View;JIJ)V" 
    },
    {
      "SwigDirector_View_objectDeleted", "(Lorg/scilab/modules/xcos/View;JI)V" 
    },
    {
      "SwigDirector_View_objectCloned", "(Lorg/scilab/modules/xcos/View;JJI)V" 
    },
    {
      "SwigDirector_View_propertyUpdated", "(Lorg/scilab/modules/xcos/View;JIII)V" 
    }
  };
  Swig::jclass_JavaControllerJNI = (jclass) jenv->NewGlobalRef(jcls);
  if (!Swig::jclass_JavaControllerJNI) return;
  for (i = 0; i < (int) (sizeof(methods)/sizeof(methods[0])); ++i) {
    Swig::director_method_ids[i] = jenv->GetStaticMethodID(jcls, methods[i].method, methods[i].signature);
    if (!Swig::director_method_ids[i]) return;
  }
}


#ifdef __cplusplus
}
#endif

