/*
** Copyright (c) 2008 - present, Alexis Megas.
** All rights reserved.
**
** Redistribution and use in source and binary forms, with or without
** modification, are permitted provided that the following conditions
** are met:
** 1. Redistributions of source code must retain the above copyright
**    notice, this list of conditions and the following disclaimer.
** 2. Redistributions in binary form must reproduce the above copyright
**    notice, this list of conditions and the following disclaimer in the
**    documentation and/or other materials provided with the distribution.
** 3. The name of the author may not be used to endorse or promote products
**    derived from Dooble without specific prior written permission.
**
** DOOBLE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
** IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
** OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
** IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
** INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
** NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
** DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
** THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
** (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
** DOOBLE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

#ifndef dooble_javascript_h
#define dooble_javascript_h

#include <QPointer>

#include "ui_dooble_javascript.h"

class QWebEnginePage;
class dooble_web_engine_page;

class dooble_javascript: public QDialog
{
  Q_OBJECT

 public:
  dooble_javascript(QWidget *parent);
  static void purge(void);
  void set_page(QWebEnginePage *page);

 private:
  QPointer<dooble_web_engine_page> m_page;
  Ui_dooble_javascript m_ui;

 private slots:
  void slot_delete_others(void);
  void slot_execute(void);
  void slot_item_selection_changed(void);
  void slot_javascript_scripts_cleared(void);
  void slot_load_finished(bool state);
  void slot_refresh(void);
  void slot_refresh_others(void);
  void slot_save(void);
  void slot_save_others(void);
  void slot_title_changed(const QString &title);
  void slot_url_changed(const QUrl &url);
};

#endif
