sq_umount() {
    case linux-gnu in
        linux*)
            fusermount3 -u $1
            ;;
        *)
            umount $1
            ;;
    esac
}

sq_is_mountpoint() {
    mount | grep -q "$1"
}

find_compressors() {
  touch "$WORKDIR/comp_input"
  compressors=
  for comp in  gzip; do
    if mksquashfs "$WORKDIR/comp_input" "$WORKDIR/comp_output" -comp $comp >/dev/null 2>/dev/null; then
      compressors="$compressors $comp"
    fi
    rm -f "$WORKDIR/comp_output"
  done
  if [ -z "$compressors" ]; then
    echo "No common compressor support between squashfuse and mksquashfs!"
    exit 1
  fi
  echo "Found compressors:$compressors"
}
