/*
 * Copyright (C) the Wine project
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301, USA
 */

#ifndef __WINE_WINERROR_H
#define __WINE_WINERROR_H

#include <specstrings.h>

#define FACILITY_NULL                         0
#define FACILITY_RPC                          1
#define FACILITY_DISPATCH                     2
#define FACILITY_STORAGE                      3
#define FACILITY_ITF                          4
#define FACILITY_WIN32                        7
#define FACILITY_WINDOWS                      8
#define FACILITY_SSPI                         9
#define FACILITY_SECURITY                     FACILITY_SSPI
#define FACILITY_CONTROL                     10
#define FACILITY_CERT                        11
#define FACILITY_INTERNET                    12
#define FACILITY_MEDIASERVER                 13
#define FACILITY_MSMQ                        14
#define FACILITY_SETUPAPI                    15
#define FACILITY_SCARD                       16
#define FACILITY_COMPLUS                     17
#define FACILITY_AAF                         18
#define FACILITY_URT                         19
#define FACILITY_ACS                         20
#define FACILITY_DPLAY                       21
#define FACILITY_UMI                         22
#define FACILITY_SXS                         23
#define FACILITY_WINDOWS_CE                  24
#define FACILITY_HTTP                        25
#define FACILITY_COMMONLOG                   26
#define FACILITY_USERMODE_COMMONLOG          26
#define FACILITY_WER                         27
#define FACILITY_USERMODE_FILTER_MANAGER     31
#define FACILITY_BACKGROUNDCOPY              32
#define FACILITY_CONFIGURATION               33
#define FACILITY_WIA                         33
#define FACILITY_STATE_MANAGEMENT            34
#define FACILITY_METADIRECTORY               35
#define FACILITY_WINDOWSUPDATE               36
#define FACILITY_DIRECTORYSERVICE            37
#define FACILITY_GRAPHICS                    38
#define FACILITY_SHELL                       39
#define FACILITY_NAP                         39
#define FACILITY_TPM_SERVICES                40
#define FACILITY_TPM_SOFTWARE                41
#define FACILITY_UI                          42
#define FACILITY_XAML                        43
#define FACILITY_ACTION_QUEUE                44
#define FACILITY_WINDOWS_SETUP               48
#define FACILITY_PLA                         48
#define FACILITY_FVE                         49
#define FACILITY_FWP                         50
#define FACILITY_WINRM                       51
#define FACILITY_NDIS                        52
#define FACILITY_USERMODE_HYPERVISOR         53
#define FACILITY_CMI                         54
#define FACILITY_USERMODE_VIRTUALIZATION     55
#define FACILITY_USERMODE_VOLMGR             56
#define FACILITY_BCD                         57
#define FACILITY_USERMODE_VHD                58
#define FACILITY_USERMODE_HNS                59
#define FACILITY_SDIAG                       60
#define FACILITY_WEBSERVICES                 61
#define FACILITY_WINPE                       61
#define FACILITY_WPN                         62
#define FACILITY_WINDOWS_STORE               63
#define FACILITY_INPUT                       64
#define FACILITY_QUIC                        65
#define FACILITY_EAP                         66
#define FACILITY_IORING                      70
#define FACILITY_WINDOWS_DEFENDER            80
#define FACILITY_OPC                         81
#define FACILITY_XPS                         82
#define FACILITY_RAS                         83
#define FACILITY_MBN                         84
#define FACILITY_POWERSHELL                  84
#define FACILITY_EAS                         85
#define FACILITY_P2P_INT                     98
#define FACILITY_P2P                         99
#define FACILITY_DAF                         100
#define FACILITY_BLUETOOTH_ATT               101
#define FACILITY_AUDIO                       102
#define FACILITY_STATEREPOSITORY             103
#define FACILITY_VISUALCPP                   109
#define FACILITY_SCRIPT                      112
#define FACILITY_PARSE                       113
#define FACILITY_BLB                         120
#define FACILITY_BLB_CLI                     121
#define FACILITY_WSBAPP                      122
#define FACILITY_BLBUI                       128
#define FACILITY_USN                         129
#define FACILITY_USERMODE_VOLSNAP            130
#define FACILITY_TIERING                     131
#define FACILITY_WSB_ONLINE                  133
#define FACILITY_ONLINE_ID                   134
#define FACILITY_DEVICE_UPDATE_AGENT         135
#define FACILITY_DRVSERVICING                136
#define FACILITY_DLS                         153
#define FACILITY_SOS                         160
#define FACILITY_OCP_UPDATE_AGENT            173
#define FACILITY_DEBUGGERS                   176
#define FACILITY_DELIVERY_OPTIMIZATION       208
#define FACILITY_USERMODE_SPACES             231
#define FACILITY_USER_MODE_SECURITY_CORE     232
#define FACILITY_USERMODE_LICENSING          234
#define FACILITY_SPP                         256
#define FACILITY_RESTORE                     256
#define FACILITY_DMSERVER                    256
#define FACILITY_DEPLOYMENT_SERVICES_SERVER  257
#define FACILITY_DEPLOYMENT_SERVICES_IMAGING 258
#define FACILITY_DEPLOYMENT_SERVICES_MANAGEMENT 259
#define FACILITY_DEPLOYMENT_SERVICES_UTIL    260
#define FACILITY_DEPLOYMENT_SERVICES_BINLSVC 261
#define FACILITY_DEPLOYMENT_SERVICES_PXE     263
#define FACILITY_DEPLOYMENT_SERVICES_TFTP    264
#define FACILITY_DEPLOYMENT_SERVICES_TRANSPORT_MANAGEMENT 272
#define FACILITY_DEPLOYMENT_SERVICES_DRIVER_PROVISIONING 278
#define FACILITY_DEPLOYMENT_SERVICES_MULTICAST_SERVER 289
#define FACILITY_DEPLOYMENT_SERVICES_MULTICAST_CLIENT 290
#define FACILITY_DEPLOYMENT_SERVICES_CONTENT_PROVIDER 293
#define FACILITY_HSP_SERVICES                296
#define FACILITY_HSP_SOFTWARE                297
#define FACILITY_LINGUISTIC_SERVICES         305
#define FACILITY_WEB                         885
#define FACILITY_WEB_SOCKET                  886
#define FACILITY_AUDIOSTREAMING              1094
#define FACILITY_TTD                         1490
#define FACILITY_ACCELERATOR                 1536
#define FACILITY_MOBILE                      1793
#define FACILITY_SQLITE                      1967
#define FACILITY_SERVICE_FABRIC              1968
#define FACILITY_UTC                         1989
#define FACILITY_WMAAECMA                    1996
#define FACILITY_WEP                         2049
#define FACILITY_SYNCENGINE                  2050
#define FACILITY_DIRECTMUSIC                 2168
#define FACILITY_DIRECT3D10                  2169
#define FACILITY_DXGI                        2170
#define FACILITY_DXGI_DDI                    2171
#define FACILITY_DIRECT3D11                  2172
#define FACILITY_DIRECT3D11_DEBUG            2173
#define FACILITY_DIRECT3D12                  2174
#define FACILITY_DIRECT3D12_DEBUG            2175
#define FACILITY_DXCORE                      2176
#define FACILITY_PRESENTATION                2177
#define FACILITY_LEAP                        2184
#define FACILITY_AUDCLNT                     2185
#define FACILITY_WINCODEC_DWRITE_DWM         2200
#define FACILITY_WINML                       2192
#define FACILITY_DIRECT2D                    2201
#define FACILITY_DEFRAG                      2304
#define FACILITY_USERMODE_SDBUS              2305
#define FACILITY_JSCRIPT                     2306
#define FACILITY_XBOX                        2339
#define FACILITY_GAME                        2340
#define FACILITY_PIDGENX                     2561
#define FACILITY_PIX                         2748

#define SEVERITY_SUCCESS    0
#define SEVERITY_ERROR      1


#define MAKE_HRESULT(sev,fac,code) \
    ((HRESULT) (((unsigned int)(sev)<<31) | ((unsigned int)(fac)<<16) | ((unsigned int)(code))) )
#define MAKE_SCODE(sev,fac,code) \
        ((SCODE) (((unsigned int)(sev)<<31) | ((unsigned int)(fac)<<16) | ((unsigned int)(code))) )
#define SUCCEEDED(stat) ((HRESULT)(stat)>=0)
#define FAILED(stat) ((HRESULT)(stat)<0)
#define IS_ERROR(stat) (((unsigned int)(stat)>>31) == SEVERITY_ERROR)

#define HRESULT_CODE(hr) ((hr) & 0xFFFF)
#define SCODE_CODE(sc)   ((sc) & 0xFFFF)

#define HRESULT_FACILITY(hr)  (((hr) >> 16) & 0x1FFF)
#define SCODE_FACILITY(sc)  (((sc) >> 16) & 0x1FFF)

#define HRESULT_SEVERITY(hr)    (((hr) >> 31) & 0x1)
#define SCODE_SEVERITY(sc)      (((sc) >> 31) & 0x1)

#define __HRESULT_FROM_WIN32(x)   ((HRESULT)(x) > 0 ? ((HRESULT) (((x) & 0x0000FFFF) | (FACILITY_WIN32 << 16) | 0x80000000)) : (HRESULT)(x) )
#ifndef _HRESULT_DEFINED
#define _HRESULT_DEFINED
#if !defined(__LP64__) && !defined(WINE_NO_LONG_TYPES) && !defined(WINE_UNIX_LIB)
typedef long HRESULT;
#else
typedef int HRESULT;
#endif
#endif
static inline HRESULT HRESULT_FROM_WIN32(unsigned int x)
{
    return (HRESULT)x > 0 ? ((HRESULT) ((x & 0x0000FFFF) | (FACILITY_WIN32 << 16) | 0x80000000)) : (HRESULT)x;
}
#define FACILITY_NT_BIT         0x10000000
#define HRESULT_FROM_NT(x)      ((HRESULT) ((x) | FACILITY_NT_BIT))

/* SCODE <-> HRESULT functions */
/* This macros is obsolete and should not be used in new apps. */
#define GetScode(hr)         ((SCODE)(hr))
/* This macros is obsolete and should not be used in new apps. */
#define ResultFromScode(sc)  ((HRESULT)(sc))

#define NO_ERROR                                           0
#define ERROR_SUCCESS                                      0
#define ERROR_INVALID_FUNCTION                             1
#define ERROR_FILE_NOT_FOUND                               2
#define ERROR_PATH_NOT_FOUND                               3
#define ERROR_TOO_MANY_OPEN_FILES                          4
#define ERROR_ACCESS_DENIED                                5
#define ERROR_INVALID_HANDLE                               6
#define ERROR_ARENA_TRASHED                                7
#define ERROR_NOT_ENOUGH_MEMORY                            8
#define ERROR_INVALID_BLOCK                                9
#define ERROR_BAD_ENVIRONMENT                              10
#define ERROR_BAD_FORMAT                                   11
#define ERROR_INVALID_ACCESS                               12
#define ERROR_INVALID_DATA                                 13
#define ERROR_OUTOFMEMORY                                  14
#define ERROR_INVALID_DRIVE                                15
#define ERROR_CURRENT_DIRECTORY                            16
#define ERROR_NOT_SAME_DEVICE                              17
#define ERROR_NO_MORE_FILES                                18
#define ERROR_WRITE_PROTECT                                19
#define ERROR_BAD_UNIT                                     20
#define ERROR_NOT_READY                                    21
#define ERROR_BAD_COMMAND                                  22
#define ERROR_CRC                                          23
#define ERROR_BAD_LENGTH                                   24
#define ERROR_SEEK                                         25
#define ERROR_NOT_DOS_DISK                                 26
#define ERROR_SECTOR_NOT_FOUND                             27
#define ERROR_OUT_OF_PAPER                                 28
#define ERROR_WRITE_FAULT                                  29
#define ERROR_READ_FAULT                                   30
#define ERROR_GEN_FAILURE                                  31
#define ERROR_SHARING_VIOLATION                            32
#define ERROR_LOCK_VIOLATION                               33
#define ERROR_WRONG_DISK                                   34
#define ERROR_FCB_UNAVAILABLE                              35
#define ERROR_SHARING_BUFFER_EXCEEDED                      36
#define ERROR_HANDLE_EOF                                   38
#define ERROR_HANDLE_DISK_FULL                             39
#define ERROR_NOT_SUPPORTED                                50
#define ERROR_REM_NOT_LIST                                 51
#define ERROR_DUP_NAME                                     52
#define ERROR_BAD_NETPATH                                  53
#define ERROR_NETWORK_BUSY                                 54
#define ERROR_DEV_NOT_EXIST                                55
#define ERROR_TOO_MANY_CMDS                                56
#define ERROR_ADAP_HDW_ERR                                 57
#define ERROR_BAD_NET_RESP                                 58
#define ERROR_UNEXP_NET_ERR                                59
#define ERROR_BAD_REM_ADAP                                 60
#define ERROR_PRINTQ_FULL                                  61
#define ERROR_NO_SPOOL_SPACE                               62
#define ERROR_PRINT_CANCELLED                              63
#define ERROR_NETNAME_DELETED                              64
#define ERROR_NETWORK_ACCESS_DENIED                        65
#define ERROR_BAD_DEV_TYPE                                 66
#define ERROR_BAD_NET_NAME                                 67
#define ERROR_TOO_MANY_NAMES                               68
#define ERROR_TOO_MANY_SESS                                69
#define ERROR_SHARING_PAUSED                               70
#define ERROR_REQ_NOT_ACCEP                                71
#define ERROR_REDIR_PAUSED                                 72
#define ERROR_FILE_EXISTS                                  80
#define ERROR_CANNOT_MAKE                                  82
#define ERROR_FAIL_I24                                     83
#define ERROR_OUT_OF_STRUCTURES                            84
#define ERROR_ALREADY_ASSIGNED                             85
#define ERROR_INVALID_PASSWORD                             86
#define ERROR_INVALID_PARAMETER                            87
#define ERROR_NET_WRITE_FAULT                              88
#define ERROR_NO_PROC_SLOTS                                89
#define ERROR_TOO_MANY_SEMAPHORES                          100
#define ERROR_EXCL_SEM_ALREADY_OWNED                       101
#define ERROR_SEM_IS_SET                                   102
#define ERROR_TOO_MANY_SEM_REQUESTS                        103
#define ERROR_INVALID_AT_INTERRUPT_TIME                    104
#define ERROR_SEM_OWNER_DIED                               105
#define ERROR_SEM_USER_LIMIT                               106
#define ERROR_DISK_CHANGE                                  107
#define ERROR_DRIVE_LOCKED                                 108
#define ERROR_BROKEN_PIPE                                  109
#define ERROR_OPEN_FAILED                                  110
#define ERROR_BUFFER_OVERFLOW                              111
#define ERROR_DISK_FULL                                    112
#define ERROR_NO_MORE_SEARCH_HANDLES                       113
#define ERROR_INVALID_TARGET_HANDLE                        114
#define ERROR_INVALID_CATEGORY                             117
#define ERROR_INVALID_VERIFY_SWITCH                        118
#define ERROR_BAD_DRIVER_LEVEL                             119
#define ERROR_CALL_NOT_IMPLEMENTED                         120
#define ERROR_SEM_TIMEOUT                                  121
#define ERROR_INSUFFICIENT_BUFFER                          122
#define ERROR_INVALID_NAME                                 123
#define ERROR_INVALID_LEVEL                                124
#define ERROR_NO_VOLUME_LABEL                              125
#define ERROR_MOD_NOT_FOUND                                126
#define ERROR_PROC_NOT_FOUND                               127
#define ERROR_WAIT_NO_CHILDREN                             128
#define ERROR_CHILD_NOT_COMPLETE                           129
#define ERROR_DIRECT_ACCESS_HANDLE                         130
#define ERROR_NEGATIVE_SEEK                                131
#define ERROR_SEEK_ON_DEVICE                               132
#define ERROR_IS_JOIN_TARGET                               133
#define ERROR_IS_JOINED                                    134
#define ERROR_IS_SUBSTED                                   135
#define ERROR_NOT_JOINED                                   136
#define ERROR_NOT_SUBSTED                                  137
#define ERROR_JOIN_TO_JOIN                                 138
#define ERROR_SUBST_TO_SUBST                               139
#define ERROR_JOIN_TO_SUBST                                140
#define ERROR_SUBST_TO_JOIN                                141
#define ERROR_BUSY_DRIVE                                   142
#define ERROR_SAME_DRIVE                                   143
#define ERROR_DIR_NOT_ROOT                                 144
#define ERROR_DIR_NOT_EMPTY                                145
#define ERROR_IS_SUBST_PATH                                146
#define ERROR_IS_JOIN_PATH                                 147
#define ERROR_PATH_BUSY                                    148
#define ERROR_IS_SUBST_TARGET                              149
#define ERROR_SYSTEM_TRACE                                 150
#define ERROR_INVALID_EVENT_COUNT                          151
#define ERROR_TOO_MANY_MUXWAITERS                          152
#define ERROR_INVALID_LIST_FORMAT                          153
#define ERROR_LABEL_TOO_LONG                               154
#define ERROR_TOO_MANY_TCBS                                155
#define ERROR_SIGNAL_REFUSED                               156
#define ERROR_DISCARDED                                    157
#define ERROR_NOT_LOCKED                                   158
#define ERROR_BAD_THREADID_ADDR                            159
#define ERROR_BAD_ARGUMENTS                                160
#define ERROR_BAD_PATHNAME                                 161
#define ERROR_SIGNAL_PENDING                               162
#define ERROR_MAX_THRDS_REACHED                            164
#define ERROR_LOCK_FAILED                                  167
#define ERROR_BUSY                                         170
#define ERROR_DEVICE_SUPPORT_IN_PROGRESS                   171
#define ERROR_CANCEL_VIOLATION                             173
#define ERROR_ATOMIC_LOCKS_NOT_SUPPORTED                   174
#define ERROR_INVALID_SEGMENT_NUMBER                       180
#define ERROR_INVALID_ORDINAL                              182
#define ERROR_ALREADY_EXISTS                               183
#define ERROR_INVALID_FLAG_NUMBER                          186
#define ERROR_SEM_NOT_FOUND                                187
#define ERROR_INVALID_STARTING_CODESEG                     188
#define ERROR_INVALID_STACKSEG                             189
#define ERROR_INVALID_MODULETYPE                           190
#define ERROR_INVALID_EXE_SIGNATURE                        191
#define ERROR_EXE_MARKED_INVALID                           192
#define ERROR_BAD_EXE_FORMAT                               193
#define ERROR_ITERATED_DATA_EXCEEDS_64k                    194
#define ERROR_INVALID_MINALLOCSIZE                         195
#define ERROR_DYNLINK_FROM_INVALID_RING                    196
#define ERROR_IOPL_NOT_ENABLED                             197
#define ERROR_INVALID_SEGDPL                               198
#define ERROR_AUTODATASEG_EXCEEDS_64k                      199
#define ERROR_RING2SEG_MUST_BE_MOVABLE                     200
#define ERROR_RELOC_CHAIN_XEEDS_SEGLIM                     201
#define ERROR_INFLOOP_IN_RELOC_CHAIN                       202
#define ERROR_ENVVAR_NOT_FOUND                             203
#define ERROR_NO_SIGNAL_SENT                               205
#define ERROR_FILENAME_EXCED_RANGE                         206
#define ERROR_RING2_STACK_IN_USE                           207
#define ERROR_META_EXPANSION_TOO_LONG                      208
#define ERROR_INVALID_SIGNAL_NUMBER                        209
#define ERROR_THREAD_1_INACTIVE                            210
#define ERROR_LOCKED                                       212
#define ERROR_TOO_MANY_MODULES                             214
#define ERROR_NESTING_NOT_ALLOWED                          215
#define ERROR_EXE_MACHINE_TYPE_MISMATCH                    216
#define ERROR_EXE_CANNOT_MODIFY_SIGNED_BINARY              217
#define ERROR_EXE_CANNOT_MODIFY_STRONG_SIGNED_BINARY       218
#define ERROR_FILE_CHECKED_OUT                             220
#define ERROR_CHECKOUT_REQUIRED                            221
#define ERROR_BAD_FILE_TYPE                                222
#define ERROR_FILE_TOO_LARGE                               223
#define ERROR_FORMS_AUTH_REQUIRED                          224
#define ERROR_VIRUS_INFECTED                               225
#define ERROR_VIRUS_DELETED                                226
#define ERROR_PIPE_LOCAL                                   229
#define ERROR_BAD_PIPE                                     230
#define ERROR_PIPE_BUSY                                    231
#define ERROR_NO_DATA                                      232
#define ERROR_PIPE_NOT_CONNECTED                           233
#define ERROR_MORE_DATA                                    234
#define ERROR_NO_WORK_DONE                                 235
#define ERROR_VC_DISCONNECTED                              240
#define ERROR_INVALID_EA_NAME                              254
#define ERROR_EA_LIST_INCONSISTENT                         255
#define WAIT_TIMEOUT                                       258
#define ERROR_NO_MORE_ITEMS                                259
#define ERROR_CANNOT_COPY                                  266
#define ERROR_DIRECTORY                                    267
#define ERROR_EAS_DIDNT_FIT                                275
#define ERROR_EA_FILE_CORRUPT                              276
#define ERROR_EA_TABLE_FULL                                277
#define ERROR_INVALID_EA_HANDLE                            278
#define ERROR_EAS_NOT_SUPPORTED                            282
#define ERROR_NOT_OWNER                                    288
#define ERROR_TOO_MANY_POSTS                               298
#define ERROR_PARTIAL_COPY                                 299
#define ERROR_OPLOCK_NOT_GRANTED                           300
#define ERROR_INVALID_OPLOCK_PROTOCOL                      301
#define ERROR_DISK_TOO_FRAGMENTED                          302
#define ERROR_DELETE_PENDING                               303
#define ERROR_INCOMPATIBLE_WITH_GLOBAL_SHORT_NAME_REGISTRY_SETTING 304
#define ERROR_SHORT_NAMES_NOT_ENABLED_ON_VOLUME            305
#define ERROR_SECURITY_STREAM_IS_INCONSISTENT              306
#define ERROR_INVALID_LOCK_RANGE                           307
#define ERROR_IMAGE_SUBSYSTEM_NOT_PRESENT                  308
#define ERROR_NOTIFICATION_GUID_ALREADY_DEFINED            309
#define ERROR_INVALID_EXCEPTION_HANDLER                    310
#define ERROR_DUPLICATE_PRIVILEGES                         311
#define ERROR_NO_RANGES_PROCESSED                          312
#define ERROR_NOT_ALLOWED_ON_SYSTEM_FILE                   313
#define ERROR_DISK_RESOURCES_EXHAUSTED                     314
#define ERROR_INVALID_TOKEN                                315
#define ERROR_DEVICE_FEATURE_NOT_SUPPORTED                 316
#define ERROR_MR_MID_NOT_FOUND                             317
#define ERROR_SCOPE_NOT_FOUND                              318
#define ERROR_UNDEFINED_SCOPE                              319
#define ERROR_INVALID_CAP                                  320
#define ERROR_DEVICE_UNREACHABLE                           321
#define ERROR_DEVICE_NO_RESOURCES                          322
#define ERROR_DATA_CHECKSUM_ERROR                          323
#define ERROR_INTERMIXED_KERNEL_EA_OPERATION               324
#define ERROR_FILE_LEVEL_TRIM_NOT_SUPPORTED                326
#define ERROR_OFFSET_ALIGNMENT_VIOLATION                   327
#define ERROR_INVALID_FIELD_IN_PARAMETER_LIST              328
#define ERROR_OPERATION_IN_PROGRESS                        329
#define ERROR_BAD_DEVICE_PATH                              330
#define ERROR_TOO_MANY_DESCRIPTORS                         331
#define ERROR_SCRUB_DATA_DISABLED                          332
#define ERROR_NOT_REDUNDANT_STORAGE                        333
#define ERROR_RESIDENT_FILE_NOT_SUPPORTED                  334
#define ERROR_COMPRESSED_FILE_NOT_SUPPORTED                335
#define ERROR_DIRECTORY_NOT_SUPPORTED                      336
#define ERROR_NOT_READ_FROM_COPY                           337
#define ERROR_FT_WRITE_FAILURE                             338
#define ERROR_FT_DI_SCAN_REQUIRED                          339
#define ERROR_INVALID_KERNEL_INFO_VERSION                  340
#define ERROR_INVALID_PEP_INFO_VERSION                     341
#define ERROR_OBJECT_NOT_EXTERNALLY_BACKED                 342
#define ERROR_EXTERNAL_BACKING_PROVIDER_UNKNOWN            343
#define ERROR_COMPRESSION_NOT_BENEFICIAL                   344
#define ERROR_STORAGE_TOPOLOGY_ID_MISMATCH                 345
#define ERROR_BLOCKED_BY_PARENTAL_CONTROLS                 346
#define ERROR_BLOCK_TOO_MANY_REFERENCES                    347
#define ERROR_MARKED_TO_DISALLOW_WRITES                    348
#define ERROR_ENCLAVE_FAILURE                              349
#define ERROR_FAIL_NOACTION_REBOOT                         350
#define ERROR_FAIL_SHUTDOWN                                351
#define ERROR_FAIL_RESTART                                 352
#define ERROR_MAX_SESSIONS_REACHED                         353
#define ERROR_NETWORK_ACCESS_DENIED_EDP                    354
#define ERROR_DEVICE_HINT_NAME_BUFFER_TOO_SMALL            355
#define ERROR_EDP_POLICY_DENIES_OPERATION                  356
#define ERROR_EDP_DPL_POLICY_CANT_BE_SATISFIED             357
#define ERROR_CLOUD_FILE_SYNC_ROOT_METADATA_CORRUPT        358
#define ERROR_DEVICE_IN_MAINTENANCE                        359
#define ERROR_NOT_SUPPORTED_ON_DAX                         360
#define ERROR_DAX_MAPPING_EXISTS                           361
#define ERROR_CLOUD_FILE_PROVIDER_NOT_RUNNING              362
#define ERROR_CLOUD_FILE_METADATA_CORRUPT                  363
#define ERROR_CLOUD_FILE_METADATA_TOO_LARGE                364
#define ERROR_CLOUD_FILE_PROPERTY_BLOB_TOO_LARGE           365
#define ERROR_CLOUD_FILE_PROPERTY_BLOB_CHECKSUM_MISMATCH   366
#define ERROR_CHILD_PROCESS_BLOCKED                        367
#define ERROR_STORAGE_LOST_DATA_PERSISTENCE                368
#define ERROR_FILE_SYSTEM_VIRTUALIZATION_UNAVAILABLE       369
#define ERROR_FILE_SYSTEM_VIRTUALIZATION_METADATA_CORRUPT  370
#define ERROR_FILE_SYSTEM_VIRTUALIZATION_BUSY              371
#define ERROR_FILE_SYSTEM_VIRTUALIZATION_PROVIDER_UNKNOWN  372
#define ERROR_GDI_HANDLE_LEAK                              373
#define ERROR_CLOUD_FILE_TOO_MANY_PROPERTY_BLOBS           374
#define ERROR_CLOUD_FILE_PROPERTY_VERSION_NOT_SUPPORTED    375
#define ERROR_NOT_A_CLOUD_FILE                             376
#define ERROR_CLOUD_FILE_NOT_IN_SYNC                       377
#define ERROR_CLOUD_FILE_ALREADY_CONNECTED                 378
#define ERROR_CLOUD_FILE_NOT_SUPPORTED                     379
#define ERROR_CLOUD_FILE_INVALID_REQUEST                   380
#define ERROR_CLOUD_FILE_READ_ONLY_VOLUME                  381
#define ERROR_CLOUD_FILE_CONNECTED_PROVIDER_ONLY           382
#define ERROR_CLOUD_FILE_VALIDATION_FAILED                 383
#define ERROR_SMB1_NOT_AVAILABLE                           384
#define ERROR_FILE_SYSTEM_VIRTUALIZATION_INVALID_OPERATION 385
#define ERROR_CLOUD_FILE_AUTHENTICATION_FAILED             386
#define ERROR_CLOUD_FILE_INSUFFICIENT_RESOURCES            387
#define ERROR_CLOUD_FILE_NETWORK_UNAVAILABLE               388
#define ERROR_CLOUD_FILE_UNSUCCESSFUL                      389
#define ERROR_CLOUD_FILE_NOT_UNDER_SYNC_ROOT               390
#define ERROR_CLOUD_FILE_IN_USE                            391
#define ERROR_CLOUD_FILE_PINNED                            392
#define ERROR_CLOUD_FILE_REQUEST_ABORTED                   393
#define ERROR_CLOUD_FILE_PROPERTY_CORRUPT                  394
#define ERROR_CLOUD_FILE_ACCESS_DENIED                     395
#define ERROR_CLOUD_FILE_INCOMPATIBLE_HARDLINKS            396
#define ERROR_CLOUD_FILE_PROPERTY_LOCK_CONFLICT            397
#define ERROR_CLOUD_FILE_REQUEST_CANCELED                  398
#define ERROR_EXTERNAL_SYSKEY_NOT_SUPPORTED                399
#define ERROR_THREAD_MODE_ALREADY_BACKGROUND               400
#define ERROR_THREAD_MODE_NOT_BACKGROUND                   401
#define ERROR_PROCESS_MODE_ALREADY_BACKGROUND              402
#define ERROR_PROCESS_MODE_NOT_BACKGROUND                  403
#define ERROR_CLOUD_FILE_PROVIDER_TERMINATED               404
#define ERROR_NOT_A_CLOUD_SYNC_ROOT                        405
#define ERROR_FILE_PROTECTED_UNDER_DPL                     406
#define ERROR_VOLUME_NOT_CLUSTER_ALIGNED                   407
#define ERROR_NO_PHYSICALLY_ALIGNED_FREE_SPACE_FOUND       408
#define ERROR_APPX_FILE_NOT_ENCRYPTED                      409
#define ERROR_RWRAW_ENCRYPTED_FILE_NOT_ENCRYPTED           410
#define ERROR_RWRAW_ENCRYPTED_INVALID_EDATAINFO_FILEOFFSET 411
#define ERROR_RWRAW_ENCRYPTED_INVALID_EDATAINFO_FILERANGE  412
#define ERROR_RWRAW_ENCRYPTED_INVALID_EDATAINFO_PARAMETER  413
#define ERROR_LINUX_SUBSYSTEM_NOT_PRESENT                  414
#define ERROR_FT_READ_FAILURE                              415
#define ERROR_STORAGE_RESERVE_ID_INVALID                   416
#define ERROR_STORAGE_RESERVE_DOES_NOT_EXIST               417
#define ERROR_STORAGE_RESERVE_ALREADY_EXISTS               418
#define ERROR_STORAGE_RESERVE_NOT_EMPTY                    419
#define ERROR_NOT_A_DAX_VOLUME                             420
#define ERROR_NOT_DAX_MAPPABLE                             421
#define ERROR_TIME_SENSITIVE_THREAD                        422
#define ERROR_DPL_NOT_SUPPORTED_FOR_USER                   423
#define ERROR_CASE_DIFFERING_NAMES_IN_DIR                  424
#define ERROR_FILE_NOT_SUPPORTED                           425
#define ERROR_CLOUD_FILE_REQUEST_TIMEOUT                   426
#define ERROR_NO_TASK_QUEUE                                427
#define ERROR_SRC_SRV_DLL_LOAD_FAILED                      428
#define ERROR_NOT_SUPPORTED_WITH_BTT                       429
#define ERROR_ENCRYPTION_DISABLED                          430
#define ERROR_ENCRYPTING_METADATA_DISALLOWED               431
#define ERROR_CANT_CLEAR_ENCRYPTION_FLAG                   432
#define ERROR_NO_SUCH_DEVICE                               433
#define ERROR_CLOUD_FILE_DEHYDRATION_DISALLOWED            434
#define ERROR_FILE_SNAP_IN_PROGRESS                        435
#define ERROR_FILE_SNAP_USER_SECTION_NOT_SUPPORTED         436
#define ERROR_FILE_SNAP_MODIFY_NOT_SUPPORTED               437
#define ERROR_FILE_SNAP_IO_NOT_COORDINATED                 438
#define ERROR_FILE_SNAP_UNEXPECTED_ERROR                   439
#define ERROR_FILE_SNAP_INVALID_PARAMETER                  440
#define ERROR_UNSATISFIED_DEPENDENCIES                     441
#define ERROR_CASE_SENSITIVE_PATH                          442
#define ERROR_UNEXPECTED_NTCACHEMANAGER_ERROR              443
#define ERROR_LINUX_SUBSYSTEM_UPDATE_REQUIRED              444
#define ERROR_DLP_POLICY_WARNS_AGAINST_OPERATION           445
#define ERROR_DLP_POLICY_DENIES_OPERATION                  446
#define ERROR_SECURITY_DENIES_OPERATION                    447
#define ERROR_UNTRUSTED_MOUNT_POINT                        448
#define ERROR_DLP_POLICY_SILENTLY_FAIL                     449
#define ERROR_CAPAUTHZ_NOT_DEVUNLOCKED                     450
#define ERROR_CAPAUTHZ_CHANGE_TYPE                         451
#define ERROR_CAPAUTHZ_NOT_PROVISIONED                     452
#define ERROR_CAPAUTHZ_NOT_AUTHORIZED                      453
#define ERROR_CAPAUTHZ_NO_POLICY                           454
#define ERROR_CAPAUTHZ_DB_CORRUPTED                        455
#define ERROR_CAPAUTHZ_SCCD_INVALID_CATALOG                456
#define ERROR_CAPAUTHZ_SCCD_NO_AUTH_ENTITY                 457
#define ERROR_CAPAUTHZ_SCCD_PARSE_ERROR                    458
#define ERROR_CAPAUTHZ_SCCD_DEV_MODE_REQUIRED              459
#define ERROR_CAPAUTHZ_SCCD_NO_CAPABILITY_MATCH            460
#define ERROR_CIMFS_IMAGE_CORRUPT                          470
#define ERROR_CIMFS_IMAGE_VERSION_NOT_SUPPORTED            471
#define ERROR_STORAGE_STACK_ACCESS_DENIED                  472
#define ERROR_INSUFFICIENT_VIRTUAL_ADDR_RESOURCES          473
#define ERROR_INDEX_OUT_OF_BOUNDS                          474
#define ERROR_CLOUD_FILE_US_MESSAGE_TIMEOUT                475
#define ERROR_PNP_QUERY_REMOVE_DEVICE_TIMEOUT              480
#define ERROR_PNP_QUERY_REMOVE_RELATED_DEVICE_TIMEOUT      481
#define ERROR_PNP_QUERY_REMOVE_UNRELATED_DEVICE_TIMEOUT    482
#define ERROR_DEVICE_HARDWARE_ERROR                        483
#define ERROR_INVALID_ADDRESS                              487
#define ERROR_HAS_SYSTEM_CRITICAL_FILES                    488
#define ERROR_ENCRYPTED_FILE_NOT_SUPPORTED                 489
#define ERROR_SPARSE_FILE_NOT_SUPPORTED                    490
#define ERROR_PAGEFILE_NOT_SUPPORTED                       491
#define ERROR_VOLUME_NOT_SUPPORTED                         492
#define ERROR_NOT_SUPPORTED_WITH_BYPASSIO                  493
#define ERROR_NO_BYPASSIO_DRIVER_SUPPORT                   494
#define ERROR_NOT_SUPPORTED_WITH_ENCRYPTION                495
#define ERROR_NOT_SUPPORTED_WITH_COMPRESSION               496
#define ERROR_NOT_SUPPORTED_WITH_REPLICATION               497
#define ERROR_NOT_SUPPORTED_WITH_DEDUPLICATION             498
#define ERROR_NOT_SUPPORTED_WITH_AUDITING                  499
#define ERROR_USER_PROFILE_LOAD                            500
#define ERROR_SESSION_KEY_TOO_SHORT                        501
#define ERROR_ACCESS_DENIED_APPDATA                        502
#define ERROR_NOT_SUPPORTED_WITH_MONITORING                503
#define ERROR_NOT_SUPPORTED_WITH_SNAPSHOT                  504
#define ERROR_NOT_SUPPORTED_WITH_VIRTUALIZATION            505
#define ERROR_BYPASSIO_FLT_NOT_SUPPORTED                   506
#define ERROR_DEVICE_RESET_REQUIRED                        507
#define ERROR_VOLUME_WRITE_ACCESS_DENIED                   508
#define ERROR_NOT_SUPPORTED_WITH_CACHED_HANDLE             509
#define ERROR_FS_METADATA_INCONSISTENT                     510
#define ERROR_BLOCK_WEAK_REFERENCE_INVALID                 511
#define ERROR_BLOCK_SOURCE_WEAK_REFERENCE_INVALID          512
#define ERROR_BLOCK_TARGET_WEAK_REFERENCE_INVALID          513
#define ERROR_BLOCK_SHARED                                 514
#define ERROR_ARITHMETIC_OVERFLOW                          534
#define ERROR_PIPE_CONNECTED                               535
#define ERROR_PIPE_LISTENING                               536
#define ERROR_VERIFIER_STOP                                537
#define ERROR_ABIOS_ERROR                                  538
#define ERROR_WX86_WARNING                                 539
#define ERROR_WX86_ERROR                                   540
#define ERROR_TIMER_NOT_CANCELED                           541
#define ERROR_UNWIND                                       542
#define ERROR_BAD_STACK                                    543
#define ERROR_INVALID_UNWIND_TARGET                        544
#define ERROR_INVALID_PORT_ATTRIBUTES                      545
#define ERROR_PORT_MESSAGE_TOO_LONG                        546
#define ERROR_INVALID_QUOTA_LOWER                          547
#define ERROR_DEVICE_ALREADY_ATTACHED                      548
#define ERROR_INSTRUCTION_MISALIGNMENT                     549
#define ERROR_PROFILING_NOT_STARTED                        550
#define ERROR_PROFILING_NOT_STOPPED                        551
#define ERROR_COULD_NOT_INTERPRET                          552
#define ERROR_PROFILING_AT_LIMIT                           553
#define ERROR_CANT_WAIT                                    554
#define ERROR_CANT_TERMINATE_SELF                          555
#define ERROR_UNEXPECTED_MM_CREATE_ERR                     556
#define ERROR_UNEXPECTED_MM_MAP_ERROR                      557
#define ERROR_UNEXPECTED_MM_EXTEND_ERR                     558
#define ERROR_BAD_FUNCTION_TABLE                           559
#define ERROR_NO_GUID_TRANSLATION                          560
#define ERROR_INVALID_LDT_SIZE                             561
#define ERROR_INVALID_LDT_OFFSET                           563
#define ERROR_INVALID_LDT_DESCRIPTOR                       564
#define ERROR_TOO_MANY_THREADS                             565
#define ERROR_THREAD_NOT_IN_PROCESS                        566
#define ERROR_PAGEFILE_QUOTA_EXCEEDED                      567
#define ERROR_LOGON_SERVER_CONFLICT                        568
#define ERROR_SYNCHRONIZATION_REQUIRED                     569
#define ERROR_NET_OPEN_FAILED                              570
#define ERROR_IO_PRIVILEGE_FAILED                          571
#define ERROR_CONTROL_C_EXIT                               572
#define ERROR_MISSING_SYSTEMFILE                           573
#define ERROR_UNHANDLED_EXCEPTION                          574
#define ERROR_APP_INIT_FAILURE                             575
#define ERROR_PAGEFILE_CREATE_FAILED                       576
#define ERROR_INVALID_IMAGE_HASH                           577
#define ERROR_NO_PAGEFILE                                  578
#define ERROR_ILLEGAL_FLOAT_CONTEXT                        579
#define ERROR_NO_EVENT_PAIR                                580
#define ERROR_DOMAIN_CTRLR_CONFIG_ERROR                    581
#define ERROR_ILLEGAL_CHARACTER                            582
#define ERROR_UNDEFINED_CHARACTER                          583
#define ERROR_FLOPPY_VOLUME                                584
#define ERROR_BIOS_FAILED_TO_CONNECT_INTERRUPT             585
#define ERROR_BACKUP_CONTROLLER                            586
#define ERROR_MUTANT_LIMIT_EXCEEDED                        587
#define ERROR_FS_DRIVER_REQUIRED                           588
#define ERROR_CANNOT_LOAD_REGISTRY_FILE                    589
#define ERROR_DEBUG_ATTACH_FAILED                          590
#define ERROR_SYSTEM_PROCESS_TERMINATED                    591
#define ERROR_DATA_NOT_ACCEPTED                            592
#define ERROR_VDM_HARD_ERROR                               593
#define ERROR_DRIVER_CANCEL_TIMEOUT                        594
#define ERROR_REPLY_MESSAGE_MISMATCH                       595
#define ERROR_LOST_WRITEBEHIND_DATA                        596
#define ERROR_CLIENT_SERVER_PARAMETERS_INVALID             597
#define ERROR_NOT_TINY_STREAM                              598
#define ERROR_STACK_OVERFLOW_READ                          599
#define ERROR_CONVERT_TO_LARGE                             600
#define ERROR_FOUND_OUT_OF_SCOPE                           601
#define ERROR_ALLOCATE_BUCKET                              602
#define ERROR_MARSHALL_OVERFLOW                            603
#define ERROR_INVALID_VARIANT                              604
#define ERROR_BAD_COMPRESSION_BUFFER                       605
#define ERROR_AUDIT_FAILED                                 606
#define ERROR_TIMER_RESOLUTION_NOT_SET                     607
#define ERROR_INSUFFICIENT_LOGON_INFO                      608
#define ERROR_BAD_DLL_ENTRYPOINT                           609
#define ERROR_BAD_SERVICE_ENTRYPOINT                       610
#define ERROR_IP_ADDRESS_CONFLICT1                         611
#define ERROR_IP_ADDRESS_CONFLICT2                         612
#define ERROR_REGISTRY_QUOTA_LIMIT                         613
#define ERROR_NO_CALLBACK_ACTIVE                           614
#define ERROR_PWD_TOO_SHORT                                615
#define ERROR_PWD_TOO_RECENT                               616
#define ERROR_PWD_HISTORY_CONFLICT                         617
#define ERROR_UNSUPPORTED_COMPRESSION                      618
#define ERROR_INVALID_HW_PROFILE                           619
#define ERROR_INVALID_PLUGPLAY_DEVICE_PATH                 620
#define ERROR_QUOTA_LIST_INCONSISTENT                      621
#define ERROR_EVALUATION_EXPIRATION                        622
#define ERROR_ILLEGAL_DLL_RELOCATION                       623
#define ERROR_DLL_INIT_FAILED_LOGOFF                       624
#define ERROR_VALIDATE_CONTINUE                            625
#define ERROR_NO_MORE_MATCHES                              626
#define ERROR_RANGE_LIST_CONFLICT                          627
#define ERROR_SERVER_SID_MISMATCH                          628
#define ERROR_CANT_ENABLE_DENY_ONLY                        629
#define ERROR_FLOAT_MULTIPLE_FAULTS                        630
#define ERROR_FLOAT_MULTIPLE_TRAPS                         631
#define ERROR_NOINTERFACE                                  632
#define ERROR_DRIVER_FAILED_SLEEP                          633
#define ERROR_CORRUPT_SYSTEM_FILE                          634
#define ERROR_COMMITMENT_MINIMUM                           635
#define ERROR_PNP_RESTART_ENUMERATION                      636
#define ERROR_SYSTEM_IMAGE_BAD_SIGNATURE                   637
#define ERROR_PNP_REBOOT_REQUIRED                          638
#define ERROR_INSUFFICIENT_POWER                           639
#define ERROR_MULTIPLE_FAULT_VIOLATION                     640
#define ERROR_SYSTEM_SHUTDOWN                              641
#define ERROR_PORT_NOT_SET                                 642
#define ERROR_DS_VERSION_CHECK_FAILURE                     643
#define ERROR_RANGE_NOT_FOUND                              644
#define ERROR_NOT_SAFE_MODE_DRIVER                         646
#define ERROR_FAILED_DRIVER_ENTRY                          647
#define ERROR_DEVICE_ENUMERATION_ERROR                     648
#define ERROR_MOUNT_POINT_NOT_RESOLVED                     649
#define ERROR_INVALID_DEVICE_OBJECT_PARAMETER              650
#define ERROR_MCA_OCCURED                                  651
#define ERROR_DRIVER_DATABASE_ERROR                        652
#define ERROR_SYSTEM_HIVE_TOO_LARGE                        653
#define ERROR_DRIVER_FAILED_PRIOR_UNLOAD                   654
#define ERROR_VOLSNAP_PREPARE_HIBERNATE                    655
#define ERROR_HIBERNATION_FAILURE                          656
#define ERROR_PWD_TOO_LONG                                 657
#define ERROR_FILE_SYSTEM_LIMITATION                       665
#define ERROR_ASSERTION_FAILURE                            668
#define ERROR_ACPI_ERROR                                   669
#define ERROR_WOW_ASSERTION                                670
#define ERROR_PNP_BAD_MPS_TABLE                            671
#define ERROR_PNP_TRANSLATION_FAILED                       672
#define ERROR_PNP_IRQ_TRANSLATION_FAILED                   673
#define ERROR_PNP_INVALID_ID                               674
#define ERROR_WAKE_SYSTEM_DEBUGGER                         675
#define ERROR_HANDLES_CLOSED                               676
#define ERROR_EXTRANEOUS_INFORMATION                       677
#define ERROR_RXACT_COMMIT_NECESSARY                       678
#define ERROR_MEDIA_CHECK                                  679
#define ERROR_GUID_SUBSTITUTION_MADE                       680
#define ERROR_STOPPED_ON_SYMLINK                           681
#define ERROR_LONGJUMP                                     682
#define ERROR_PLUGPLAY_QUERY_VETOED                        683
#define ERROR_UNWIND_CONSOLIDATE                           684
#define ERROR_REGISTRY_HIVE_RECOVERED                      685
#define ERROR_DLL_MIGHT_BE_INSECURE                        686
#define ERROR_DLL_MIGHT_BE_INCOMPATIBLE                    687
#define ERROR_DBG_EXCEPTION_NOT_HANDLED                    688
#define ERROR_DBG_REPLY_LATER                              689
#define ERROR_DBG_UNABLE_TO_PROVIDE_HANDLE                 690
#define ERROR_DBG_TERMINATE_THREAD                         691
#define ERROR_DBG_TERMINATE_PROCESS                        692
#define ERROR_DBG_CONTROL_C                                693
#define ERROR_DBG_PRINTEXCEPTION_C                         694
#define ERROR_DBG_RIPEXCEPTION                             695
#define ERROR_DBG_CONTROL_BREAK                            696
#define ERROR_DBG_COMMAND_EXCEPTION                        697
#define ERROR_OBJECT_NAME_EXISTS                           698
#define ERROR_THREAD_WAS_SUSPENDED                         699
#define ERROR_IMAGE_NOT_AT_BASE                            700
#define ERROR_RXACT_STATE_CREATED                          701
#define ERROR_SEGMENT_NOTIFICATION                         702
#define ERROR_BAD_CURRENT_DIRECTORY                        703
#define ERROR_FT_READ_RECOVERY_FROM_BACKUP                 704
#define ERROR_FT_WRITE_RECOVERY                            705
#define ERROR_IMAGE_MACHINE_TYPE_MISMATCH                  706
#define ERROR_RECEIVE_PARTIAL                              707
#define ERROR_RECEIVE_EXPEDITED                            708
#define ERROR_RECEIVE_PARTIAL_EXPEDITED                    709
#define ERROR_EVENT_DONE                                   710
#define ERROR_EVENT_PENDING                                711
#define ERROR_CHECKING_FILE_SYSTEM                         712
#define ERROR_FATAL_APP_EXIT                               713
#define ERROR_PREDEFINED_HANDLE                            714
#define ERROR_WAS_UNLOCKED                                 715
#define ERROR_SERVICE_NOTIFICATION                         716
#define ERROR_WAS_LOCKED                                   717
#define ERROR_LOG_HARD_ERROR                               718
#define ERROR_ALREADY_WIN32                                719
#define ERROR_IMAGE_MACHINE_TYPE_MISMATCH_EXE              720
#define ERROR_NO_YIELD_PERFORMED                           721
#define ERROR_TIMER_RESUME_IGNORED                         722
#define ERROR_ARBITRATION_UNHANDLED                        723
#define ERROR_CARDBUS_NOT_SUPPORTED                        724
#define ERROR_MP_PROCESSOR_MISMATCH                        725
#define ERROR_HIBERNATED                                   726
#define ERROR_RESUME_HIBERNATION                           727
#define ERROR_FIRMWARE_UPDATED                             728
#define ERROR_DRIVERS_LEAKING_LOCKED_PAGES                 729
#define ERROR_WAKE_SYSTEM                                  730
#define ERROR_WAIT_1                                       731
#define ERROR_WAIT_2                                       732
#define ERROR_WAIT_3                                       733
#define ERROR_WAIT_63                                      734
#define ERROR_ABANDONED_WAIT_0                             735
#define ERROR_ABANDONED_WAIT_63                            736
#define ERROR_USER_APC                                     737
#define ERROR_KERNEL_APC                                   738
#define ERROR_ALERTED                                      739
#define ERROR_ELEVATION_REQUIRED                           740
#define ERROR_REPARSE                                      741
#define ERROR_OPLOCK_BREAK_IN_PROGRESS                     742
#define ERROR_VOLUME_MOUNTED                               743
#define ERROR_RXACT_COMMITTED                              744
#define ERROR_NOTIFY_CLEANUP                               745
#define ERROR_PRIMARY_TRANSPORT_CONNECT_FAILED             746
#define ERROR_PAGE_FAULT_TRANSITION                        747
#define ERROR_PAGE_FAULT_DEMAND_ZERO                       748
#define ERROR_PAGE_FAULT_COPY_ON_WRITE                     749
#define ERROR_PAGE_FAULT_GUARD_PAGE                        750
#define ERROR_PAGE_FAULT_PAGING_FILE                       751
#define ERROR_CACHE_PAGE_LOCKED                            752
#define ERROR_CRASH_DUMP                                   753
#define ERROR_BUFFER_ALL_ZEROS                             754
#define ERROR_REPARSE_OBJECT                               755
#define ERROR_RESOURCE_REQUIREMENTS_CHANGED                756
#define ERROR_TRANSLATION_COMPLETE                         757
#define ERROR_NOTHING_TO_TERMINATE                         758
#define ERROR_PROCESS_NOT_IN_JOB                           759
#define ERROR_PROCESS_IN_JOB                               760
#define ERROR_VOLSNAP_HIBERNATE_READY                      761
#define ERROR_FSFILTER_OP_COMPLETED_SUCCESSFULLY           762
#define ERROR_INTERRUPT_VECTOR_ALREADY_CONNECTED           763
#define ERROR_INTERRUPT_STILL_CONNECTED                    764
#define ERROR_WAIT_FOR_OPLOCK                              765
#define ERROR_DBG_EXCEPTION_HANDLED                        766
#define ERROR_DBG_CONTINUE                                 767
#define ERROR_CALLBACK_POP_STACK                           768
#define ERROR_COMPRESSION_DISABLED                         769
#define ERROR_CANTFETCHBACKWARDS                           770
#define ERROR_CANTSCROLLBACKWARDS                          771
#define ERROR_ROWSNOTRELEASED                              772
#define ERROR_BAD_ACCESSOR_FLAGS                           773
#define ERROR_ERRORS_ENCOUNTERED                           774
#define ERROR_NOT_CAPABLE                                  775
#define ERROR_REQUEST_OUT_OF_SEQUENCE                      776
#define ERROR_VERSION_PARSE_ERROR                          777
#define ERROR_BADSTARTPOSITION                             778
#define ERROR_MEMORY_HARDWARE                              779
#define ERROR_DISK_REPAIR_DISABLED                         780
#define ERROR_INSUFFICIENT_RESOURCE_FOR_SPECIFIED_SHARED_SECTION_SIZE 781
#define ERROR_SYSTEM_POWERSTATE_TRANSITION                 782
#define ERROR_SYSTEM_POWERSTATE_COMPLEX_TRANSITION         783
#define ERROR_MCA_EXCEPTION                                784
#define ERROR_ACCESS_AUDIT_BY_POLICY                       785
#define ERROR_ACCESS_DISABLED_NO_SAFER_UI_BY_POLICY        786
#define ERROR_ABANDON_HIBERFILE                            787
#define ERROR_LOST_WRITEBEHIND_DATA_NETWORK_DISCONNECTED   788
#define ERROR_LOST_WRITEBEHIND_DATA_NETWORK_SERVER_ERROR   789
#define ERROR_LOST_WRITEBEHIND_DATA_LOCAL_DISK_ERROR       790
#define ERROR_BAD_MCFG_TABLE                               791
#define ERROR_DISK_REPAIR_REDIRECTED                       792
#define ERROR_DISK_REPAIR_UNSUCCESSFUL                     793
#define ERROR_CORRUPT_LOG_OVERFULL                         794
#define ERROR_CORRUPT_LOG_CORRUPTED                        795
#define ERROR_CORRUPT_LOG_UNAVAILABLE                      796
#define ERROR_CORRUPT_LOG_DELETED_FULL                     797
#define ERROR_CORRUPT_LOG_CLEARED                          798
#define ERROR_ORPHAN_NAME_EXHAUSTED                        799
#define ERROR_OPLOCK_SWITCHED_TO_NEW_HANDLE                800
#define ERROR_CANNOT_GRANT_REQUESTED_OPLOCK                801
#define ERROR_CANNOT_BREAK_OPLOCK                          802
#define ERROR_OPLOCK_HANDLE_CLOSED                         803
#define ERROR_NO_ACE_CONDITION                             804
#define ERROR_INVALID_ACE_CONDITION                        805
#define ERROR_FILE_HANDLE_REVOKED                          806
#define ERROR_IMAGE_AT_DIFFERENT_BASE                      807
#define ERROR_ENCRYPTED_IO_NOT_POSSIBLE                    808
#define ERROR_FILE_METADATA_OPTIMIZATION_IN_PROGRESS       809
#define ERROR_QUOTA_ACTIVITY                               810
#define ERROR_HANDLE_REVOKED                               811
#define ERROR_CALLBACK_INVOKE_INLINE                       812
#define ERROR_CPU_SET_INVALID                              813
#define ERROR_ENCLAVE_NOT_TERMINATED                       814
#define ERROR_ENCLAVE_VIOLATION                            815
#define ERROR_SERVER_TRANSPORT_CONFLICT                    816
#define ERROR_CERTIFICATE_VALIDATION_PREFERENCE_CONFLICT   817
#define ERROR_FT_READ_FROM_COPY_FAILURE                    818
#define ERROR_SECTION_DIRECT_MAP_ONLY                      819
#define ERROR_EA_ACCESS_DENIED                             994
#define ERROR_OPERATION_ABORTED                            995
#define ERROR_IO_INCOMPLETE                                996
#define ERROR_IO_PENDING                                   997
#define ERROR_NOACCESS                                     998
#define ERROR_SWAPERROR                                    999
#define ERROR_STACK_OVERFLOW                               1001
#define ERROR_INVALID_MESSAGE                              1002
#define ERROR_CAN_NOT_COMPLETE                             1003
#define ERROR_INVALID_FLAGS                                1004
#define ERROR_UNRECOGNIZED_VOLUME                          1005
#define ERROR_FILE_INVALID                                 1006
#define ERROR_FULLSCREEN_MODE                              1007
#define ERROR_NO_TOKEN                                     1008
#define ERROR_BADDB                                        1009
#define ERROR_BADKEY                                       1010
#define ERROR_CANTOPEN                                     1011
#define ERROR_CANTREAD                                     1012
#define ERROR_CANTWRITE                                    1013
#define ERROR_REGISTRY_RECOVERED                           1014
#define ERROR_REGISTRY_CORRUPT                             1015
#define ERROR_REGISTRY_IO_FAILED                           1016
#define ERROR_NOT_REGISTRY_FILE                            1017
#define ERROR_KEY_DELETED                                  1018
#define ERROR_NO_LOG_SPACE                                 1019
#define ERROR_KEY_HAS_CHILDREN                             1020
#define ERROR_CHILD_MUST_BE_VOLATILE                       1021
#define ERROR_NOTIFY_ENUM_DIR                              1022
#define ERROR_DEPENDENT_SERVICES_RUNNING                   1051
#define ERROR_INVALID_SERVICE_CONTROL                      1052
#define ERROR_SERVICE_REQUEST_TIMEOUT                      1053
#define ERROR_SERVICE_NO_THREAD                            1054
#define ERROR_SERVICE_DATABASE_LOCKED                      1055
#define ERROR_SERVICE_ALREADY_RUNNING                      1056
#define ERROR_INVALID_SERVICE_ACCOUNT                      1057
#define ERROR_SERVICE_DISABLED                             1058
#define ERROR_CIRCULAR_DEPENDENCY                          1059
#define ERROR_SERVICE_DOES_NOT_EXIST                       1060
#define ERROR_SERVICE_CANNOT_ACCEPT_CTRL                   1061
#define ERROR_SERVICE_NOT_ACTIVE                           1062
#define ERROR_FAILED_SERVICE_CONTROLLER_CONNECT            1063
#define ERROR_EXCEPTION_IN_SERVICE                         1064
#define ERROR_DATABASE_DOES_NOT_EXIST                      1065
#define ERROR_SERVICE_SPECIFIC_ERROR                       1066
#define ERROR_PROCESS_ABORTED                              1067
#define ERROR_SERVICE_DEPENDENCY_FAIL                      1068
#define ERROR_SERVICE_LOGON_FAILED                         1069
#define ERROR_SERVICE_START_HANG                           1070
#define ERROR_INVALID_SERVICE_LOCK                         1071
#define ERROR_SERVICE_MARKED_FOR_DELETE                    1072
#define ERROR_SERVICE_EXISTS                               1073
#define ERROR_ALREADY_RUNNING_LKG                          1074
#define ERROR_SERVICE_DEPENDENCY_DELETED                   1075
#define ERROR_BOOT_ALREADY_ACCEPTED                        1076
#define ERROR_SERVICE_NEVER_STARTED                        1077
#define ERROR_DUPLICATE_SERVICE_NAME                       1078
#define ERROR_DIFFERENT_SERVICE_ACCOUNT                    1079
#define ERROR_CANNOT_DETECT_DRIVER_FAILURE                 1080
#define ERROR_CANNOT_DETECT_PROCESS_ABORT                  1081
#define ERROR_NO_RECOVERY_PROGRAM                          1082
#define ERROR_SERVICE_NOT_IN_EXE                           1083
#define ERROR_NOT_SAFEBOOT_SERVICE                         1084
#define ERROR_END_OF_MEDIA                                 1100
#define ERROR_FILEMARK_DETECTED                            1101
#define ERROR_BEGINNING_OF_MEDIA                           1102
#define ERROR_SETMARK_DETECTED                             1103
#define ERROR_NO_DATA_DETECTED                             1104
#define ERROR_PARTITION_FAILURE                            1105
#define ERROR_INVALID_BLOCK_LENGTH                         1106
#define ERROR_DEVICE_NOT_PARTITIONED                       1107
#define ERROR_UNABLE_TO_LOCK_MEDIA                         1108
#define ERROR_UNABLE_TO_UNLOAD_MEDIA                       1109
#define ERROR_MEDIA_CHANGED                                1110
#define ERROR_BUS_RESET                                    1111
#define ERROR_NO_MEDIA_IN_DRIVE                            1112
#define ERROR_NO_UNICODE_TRANSLATION                       1113
#define ERROR_DLL_INIT_FAILED                              1114
#define ERROR_SHUTDOWN_IN_PROGRESS                         1115
#define ERROR_NO_SHUTDOWN_IN_PROGRESS                      1116
#define ERROR_IO_DEVICE                                    1117
#define ERROR_SERIAL_NO_DEVICE                             1118
#define ERROR_IRQ_BUSY                                     1119
#define ERROR_MORE_WRITES                                  1120
#define ERROR_COUNTER_TIMEOUT                              1121
#define ERROR_FLOPPY_ID_MARK_NOT_FOUND                     1122
#define ERROR_FLOPPY_WRONG_CYLINDER                        1123
#define ERROR_FLOPPY_UNKNOWN_ERROR                         1124
#define ERROR_FLOPPY_BAD_REGISTERS                         1125
#define ERROR_DISK_RECALIBRATE_FAILED                      1126
#define ERROR_DISK_OPERATION_FAILED                        1127
#define ERROR_DISK_RESET_FAILED                            1128
#define ERROR_EOM_OVERFLOW                                 1129
#define ERROR_NOT_ENOUGH_SERVER_MEMORY                     1130
#define ERROR_POSSIBLE_DEADLOCK                            1131
#define ERROR_MAPPED_ALIGNMENT                             1132
#define ERROR_SET_POWER_STATE_VETOED                       1140
#define ERROR_SET_POWER_STATE_FAILED                       1141
#define ERROR_TOO_MANY_LINKS                               1142
#define ERROR_OLD_WIN_VERSION                              1150
#define ERROR_APP_WRONG_OS                                 1151
#define ERROR_SINGLE_INSTANCE_APP                          1152
#define ERROR_RMODE_APP                                    1153
#define ERROR_INVALID_DLL                                  1154
#define ERROR_NO_ASSOCIATION                               1155
#define ERROR_DDE_FAIL                                     1156
#define ERROR_DLL_NOT_FOUND                                1157
#define ERROR_NO_MORE_USER_HANDLES                         1158
#define ERROR_MESSAGE_SYNC_ONLY                            1159
#define ERROR_SOURCE_ELEMENT_EMPTY                         1160
#define ERROR_DESTINATION_ELEMENT_FULL                     1161
#define ERROR_ILLEGAL_ELEMENT_ADDRESS                      1162
#define ERROR_MAGAZINE_NOT_PRESENT                         1163
#define ERROR_DEVICE_REINITIALIZATION_NEEDED               1164
#define ERROR_DEVICE_REQUIRES_CLEANING                     1165
#define ERROR_DEVICE_DOOR_OPEN                             1166
#define ERROR_DEVICE_NOT_CONNECTED                         1167
#define ERROR_NOT_FOUND                                    1168
#define ERROR_NO_MATCH                                     1169
#define ERROR_SET_NOT_FOUND                                1170
#define ERROR_POINT_NOT_FOUND                              1171
#define ERROR_NO_TRACKING_SERVICE                          1172
#define ERROR_NO_VOLUME_ID                                 1173
#define ERROR_UNABLE_TO_REMOVE_REPLACED                    1175
#define ERROR_UNABLE_TO_MOVE_REPLACEMENT                   1176
#define ERROR_UNABLE_TO_MOVE_REPLACEMENT_2                 1177
#define ERROR_JOURNAL_DELETE_IN_PROGRESS                   1178
#define ERROR_JOURNAL_NOT_ACTIVE                           1179
#define ERROR_POTENTIAL_FILE_FOUND                         1180
#define ERROR_JOURNAL_ENTRY_DELETED                        1181
#define ERROR_VRF_CFG_ENABLED                              1183
#define ERROR_PARTITION_TERMINATING                        1184
#define ERROR_SHUTDOWN_IS_SCHEDULED                        1190
#define ERROR_SHUTDOWN_USERS_LOGGED_ON                     1191
#define ERROR_SHUTDOWN_DISKS_NOT_IN_MAINTENANCE_MODE       1192
#define ERROR_BAD_DEVICE                                   1200
#define ERROR_CONNECTION_UNAVAIL                           1201
#define ERROR_DEVICE_ALREADY_REMEMBERED                    1202
#define ERROR_NO_NET_OR_BAD_PATH                           1203
#define ERROR_BAD_PROVIDER                                 1204
#define ERROR_CANNOT_OPEN_PROFILE                          1205
#define ERROR_BAD_PROFILE                                  1206
#define ERROR_NOT_CONTAINER                                1207
#define ERROR_EXTENDED_ERROR                               1208
#define ERROR_INVALID_GROUPNAME                            1209
#define ERROR_INVALID_COMPUTERNAME                         1210
#define ERROR_INVALID_EVENTNAME                            1211
#define ERROR_INVALID_DOMAINNAME                           1212
#define ERROR_INVALID_SERVICENAME                          1213
#define ERROR_INVALID_NETNAME                              1214
#define ERROR_INVALID_SHARENAME                            1215
#define ERROR_INVALID_PASSWORDNAME                         1216
#define ERROR_INVALID_MESSAGENAME                          1217
#define ERROR_INVALID_MESSAGEDEST                          1218
#define ERROR_SESSION_CREDENTIAL_CONFLICT                  1219
#define ERROR_REMOTE_SESSION_LIMIT_EXCEEDED                1220
#define ERROR_DUP_DOMAINNAME                               1221
#define ERROR_NO_NETWORK                                   1222
#define ERROR_CANCELLED                                    1223
#define ERROR_USER_MAPPED_FILE                             1224
#define ERROR_CONNECTION_REFUSED                           1225
#define ERROR_GRACEFUL_DISCONNECT                          1226
#define ERROR_ADDRESS_ALREADY_ASSOCIATED                   1227
#define ERROR_ADDRESS_NOT_ASSOCIATED                       1228
#define ERROR_CONNECTION_INVALID                           1229
#define ERROR_CONNECTION_ACTIVE                            1230
#define ERROR_NETWORK_UNREACHABLE                          1231
#define ERROR_HOST_UNREACHABLE                             1232
#define ERROR_PROTOCOL_UNREACHABLE                         1233
#define ERROR_PORT_UNREACHABLE                             1234
#define ERROR_REQUEST_ABORTED                              1235
#define ERROR_CONNECTION_ABORTED                           1236
#define ERROR_RETRY                                        1237
#define ERROR_CONNECTION_COUNT_LIMIT                       1238
#define ERROR_LOGIN_TIME_RESTRICTION                       1239
#define ERROR_LOGIN_WKSTA_RESTRICTION                      1240
#define ERROR_INCORRECT_ADDRESS                            1241
#define ERROR_ALREADY_REGISTERED                           1242
#define ERROR_SERVICE_NOT_FOUND                            1243
#define ERROR_NOT_AUTHENTICATED                            1244
#define ERROR_NOT_LOGGED_ON                                1245
#define ERROR_CONTINUE                                     1246
#define ERROR_ALREADY_INITIALIZED                          1247
#define ERROR_NO_MORE_DEVICES                              1248
#define ERROR_NO_SUCH_SITE                                 1249
#define ERROR_DOMAIN_CONTROLLER_EXISTS                     1250
#define ERROR_ONLY_IF_CONNECTED                            1251
#define ERROR_OVERRIDE_NOCHANGES                           1252
#define ERROR_BAD_USER_PROFILE                             1253
#define ERROR_NOT_SUPPORTED_ON_SBS                         1254
#define ERROR_SERVER_SHUTDOWN_IN_PROGRESS                  1255
#define ERROR_HOST_DOWN                                    1256
#define ERROR_NON_ACCOUNT_SID                              1257
#define ERROR_NON_DOMAIN_SID                               1258
#define ERROR_APPHELP_BLOCK                                1259
#define ERROR_ACCESS_DISABLED_BY_POLICY                    1260
#define ERROR_REG_NAT_CONSUMPTION                          1261
#define ERROR_CSCSHARE_OFFLINE                             1262
#define ERROR_PKINIT_FAILURE                               1263
#define ERROR_SMARTCARD_SUBSYSTEM_FAILURE                  1264
#define ERROR_DOWNGRADE_DETECTED                           1265
#define ERROR_MACHINE_LOCKED                               1271
#define ERROR_SMB_GUEST_LOGON_BLOCKED                      1272
#define ERROR_CALLBACK_SUPPLIED_INVALID_DATA               1273
#define ERROR_SYNC_FOREGROUND_REFRESH_REQUIRED             1274
#define ERROR_DRIVER_BLOCKED                               1275
#define ERROR_INVALID_IMPORT_OF_NON_DLL                    1276
#define ERROR_ACCESS_DISABLED_WEBBLADE                     1277
#define ERROR_ACCESS_DISABLED_WEBBLADE_TAMPER              1278
#define ERROR_RECOVERY_FAILURE                             1279
#define ERROR_ALREADY_FIBER                                1280
#define ERROR_ALREADY_THREAD                               1281
#define ERROR_STACK_BUFFER_OVERRUN                         1282
#define ERROR_PARAMETER_QUOTA_EXCEEDED                     1283
#define ERROR_DEBUGGER_INACTIVE                            1284
#define ERROR_DELAY_LOAD_FAILED                            1285
#define ERROR_VDM_DISALLOWED                               1286
#define ERROR_UNIDENTIFIED_ERROR                           1287
#define ERROR_INVALID_CRUNTIME_PARAMETER                   1288
#define ERROR_BEYOND_VDL                                   1289
#define ERROR_INCOMPATIBLE_SERVICE_SID_TYPE                1290
#define ERROR_DRIVER_PROCESS_TERMINATED                    1291
#define ERROR_IMPLEMENTATION_LIMIT                         1292
#define ERROR_PROCESS_IS_PROTECTED                         1293
#define ERROR_SERVICE_NOTIFY_CLIENT_LAGGING                1294
#define ERROR_DISK_QUOTA_EXCEEDED                          1295
#define ERROR_CONTENT_BLOCKED                              1296
#define ERROR_INCOMPATIBLE_SERVICE_PRIVILEGE               1297
#define ERROR_APP_HANG                                     1298
#define ERROR_INVALID_LABEL                                1299
#define ERROR_NOT_ALL_ASSIGNED                             1300
#define ERROR_SOME_NOT_MAPPED                              1301
#define ERROR_NO_QUOTAS_FOR_ACCOUNT                        1302
#define ERROR_LOCAL_USER_SESSION_KEY                       1303
#define ERROR_NULL_LM_PASSWORD                             1304
#define ERROR_UNKNOWN_REVISION                             1305
#define ERROR_REVISION_MISMATCH                            1306
#define ERROR_INVALID_OWNER                                1307
#define ERROR_INVALID_PRIMARY_GROUP                        1308
#define ERROR_NO_IMPERSONATION_TOKEN                       1309
#define ERROR_CANT_DISABLE_MANDATORY                       1310
#define ERROR_NO_LOGON_SERVERS                             1311
#define ERROR_NO_SUCH_LOGON_SESSION                        1312
#define ERROR_NO_SUCH_PRIVILEGE                            1313
#define ERROR_PRIVILEGE_NOT_HELD                           1314
#define ERROR_INVALID_ACCOUNT_NAME                         1315
#define ERROR_USER_EXISTS                                  1316
#define ERROR_NO_SUCH_USER                                 1317
#define ERROR_GROUP_EXISTS                                 1318
#define ERROR_NO_SUCH_GROUP                                1319
#define ERROR_MEMBER_IN_GROUP                              1320
#define ERROR_MEMBER_NOT_IN_GROUP                          1321
#define ERROR_LAST_ADMIN                                   1322
#define ERROR_WRONG_PASSWORD                               1323
#define ERROR_ILL_FORMED_PASSWORD                          1324
#define ERROR_PASSWORD_RESTRICTION                         1325
#define ERROR_LOGON_FAILURE                                1326
#define ERROR_ACCOUNT_RESTRICTION                          1327
#define ERROR_INVALID_LOGON_HOURS                          1328
#define ERROR_INVALID_WORKSTATION                          1329
#define ERROR_PASSWORD_EXPIRED                             1330
#define ERROR_ACCOUNT_DISABLED                             1331
#define ERROR_NONE_MAPPED                                  1332
#define ERROR_TOO_MANY_LUIDS_REQUESTED                     1333
#define ERROR_LUIDS_EXHAUSTED                              1334
#define ERROR_INVALID_SUB_AUTHORITY                        1335
#define ERROR_INVALID_ACL                                  1336
#define ERROR_INVALID_SID                                  1337
#define ERROR_INVALID_SECURITY_DESCR                       1338
#define ERROR_BAD_INHERITANCE_ACL                          1340
#define ERROR_SERVER_DISABLED                              1341
#define ERROR_SERVER_NOT_DISABLED                          1342
#define ERROR_INVALID_ID_AUTHORITY                         1343
#define ERROR_ALLOTTED_SPACE_EXCEEDED                      1344
#define ERROR_INVALID_GROUP_ATTRIBUTES                     1345
#define ERROR_BAD_IMPERSONATION_LEVEL                      1346
#define ERROR_CANT_OPEN_ANONYMOUS                          1347
#define ERROR_BAD_VALIDATION_CLASS                         1348
#define ERROR_BAD_TOKEN_TYPE                               1349
#define ERROR_NO_SECURITY_ON_OBJECT                        1350
#define ERROR_CANT_ACCESS_DOMAIN_INFO                      1351
#define ERROR_INVALID_SERVER_STATE                         1352
#define ERROR_INVALID_DOMAIN_STATE                         1353
#define ERROR_INVALID_DOMAIN_ROLE                          1354
#define ERROR_NO_SUCH_DOMAIN                               1355
#define ERROR_DOMAIN_EXISTS                                1356
#define ERROR_DOMAIN_LIMIT_EXCEEDED                        1357
#define ERROR_INTERNAL_DB_CORRUPTION                       1358
#define ERROR_INTERNAL_ERROR                               1359
#define ERROR_GENERIC_NOT_MAPPED                           1360
#define ERROR_BAD_DESCRIPTOR_FORMAT                        1361
#define ERROR_NOT_LOGON_PROCESS                            1362
#define ERROR_LOGON_SESSION_EXISTS                         1363
#define ERROR_NO_SUCH_PACKAGE                              1364
#define ERROR_BAD_LOGON_SESSION_STATE                      1365
#define ERROR_LOGON_SESSION_COLLISION                      1366
#define ERROR_INVALID_LOGON_TYPE                           1367
#define ERROR_CANNOT_IMPERSONATE                           1368
#define ERROR_RXACT_INVALID_STATE                          1369
#define ERROR_RXACT_COMMIT_FAILURE                         1370
#define ERROR_SPECIAL_ACCOUNT                              1371
#define ERROR_SPECIAL_GROUP                                1372
#define ERROR_SPECIAL_USER                                 1373
#define ERROR_MEMBERS_PRIMARY_GROUP                        1374
#define ERROR_TOKEN_ALREADY_IN_USE                         1375
#define ERROR_NO_SUCH_ALIAS                                1376
#define ERROR_MEMBER_NOT_IN_ALIAS                          1377
#define ERROR_MEMBER_IN_ALIAS                              1378
#define ERROR_ALIAS_EXISTS                                 1379
#define ERROR_LOGON_NOT_GRANTED                            1380
#define ERROR_TOO_MANY_SECRETS                             1381
#define ERROR_SECRET_TOO_LONG                              1382
#define ERROR_INTERNAL_DB_ERROR                            1383
#define ERROR_TOO_MANY_CONTEXT_IDS                         1384
#define ERROR_LOGON_TYPE_NOT_GRANTED                       1385
#define ERROR_NT_CROSS_ENCRYPTION_REQUIRED                 1386
#define ERROR_NO_SUCH_MEMBER                               1387
#define ERROR_INVALID_MEMBER                               1388
#define ERROR_TOO_MANY_SIDS                                1389
#define ERROR_LM_CROSS_ENCRYPTION_REQUIRED                 1390
#define ERROR_NO_INHERITANCE                               1391
#define ERROR_FILE_CORRUPT                                 1392
#define ERROR_DISK_CORRUPT                                 1393
#define ERROR_NO_USER_SESSION_KEY                          1394
#define ERROR_LICENSE_QUOTA_EXCEEDED                       1395
#define ERROR_WRONG_TARGET_NAME                            1396
#define ERROR_MUTUAL_AUTH_FAILED                           1397
#define ERROR_TIME_SKEW                                    1398
#define ERROR_CURRENT_DOMAIN_NOT_ALLOWED                   1399
#define ERROR_INVALID_WINDOW_HANDLE                        1400
#define ERROR_INVALID_MENU_HANDLE                          1401
#define ERROR_INVALID_CURSOR_HANDLE                        1402
#define ERROR_INVALID_ACCEL_HANDLE                         1403
#define ERROR_INVALID_HOOK_HANDLE                          1404
#define ERROR_INVALID_DWP_HANDLE                           1405
#define ERROR_TLW_WITH_WSCHILD                             1406
#define ERROR_CANNOT_FIND_WND_CLASS                        1407
#define ERROR_WINDOW_OF_OTHER_THREAD                       1408
#define ERROR_HOTKEY_ALREADY_REGISTERED                    1409
#define ERROR_CLASS_ALREADY_EXISTS                         1410
#define ERROR_CLASS_DOES_NOT_EXIST                         1411
#define ERROR_CLASS_HAS_WINDOWS                            1412
#define ERROR_INVALID_INDEX                                1413
#define ERROR_INVALID_ICON_HANDLE                          1414
#define ERROR_PRIVATE_DIALOG_INDEX                         1415
#define ERROR_LISTBOX_ID_NOT_FOUND                         1416
#define ERROR_NO_WILDCARD_CHARACTERS                       1417
#define ERROR_CLIPBOARD_NOT_OPEN                           1418
#define ERROR_HOTKEY_NOT_REGISTERED                        1419
#define ERROR_WINDOW_NOT_DIALOG                            1420
#define ERROR_CONTROL_ID_NOT_FOUND                         1421
#define ERROR_INVALID_COMBOBOX_MESSAGE                     1422
#define ERROR_WINDOW_NOT_COMBOBOX                          1423
#define ERROR_INVALID_EDIT_HEIGHT                          1424
#define ERROR_DC_NOT_FOUND                                 1425
#define ERROR_INVALID_HOOK_FILTER                          1426
#define ERROR_INVALID_FILTER_PROC                          1427
#define ERROR_HOOK_NEEDS_HMOD                              1428
#define ERROR_GLOBAL_ONLY_HOOK                             1429
#define ERROR_JOURNAL_HOOK_SET                             1430
#define ERROR_HOOK_NOT_INSTALLED                           1431
#define ERROR_INVALID_LB_MESSAGE                           1432
#define ERROR_SETCOUNT_ON_BAD_LB                           1433
#define ERROR_LB_WITHOUT_TABSTOPS                          1434
#define ERROR_DESTROY_OBJECT_OF_OTHER_THREAD               1435
#define ERROR_CHILD_WINDOW_MENU                            1436
#define ERROR_NO_SYSTEM_MENU                               1437
#define ERROR_INVALID_MSGBOX_STYLE                         1438
#define ERROR_INVALID_SPI_VALUE                            1439
#define ERROR_SCREEN_ALREADY_LOCKED                        1440
#define ERROR_HWNDS_HAVE_DIFF_PARENT                       1441
#define ERROR_NOT_CHILD_WINDOW                             1442
#define ERROR_INVALID_GW_COMMAND                           1443
#define ERROR_INVALID_THREAD_ID                            1444
#define ERROR_NON_MDICHILD_WINDOW                          1445
#define ERROR_POPUP_ALREADY_ACTIVE                         1446
#define ERROR_NO_SCROLLBARS                                1447
#define ERROR_INVALID_SCROLLBAR_RANGE                      1448
#define ERROR_INVALID_SHOWWIN_COMMAND                      1449
#define ERROR_NO_SYSTEM_RESOURCES                          1450
#define ERROR_NONPAGED_SYSTEM_RESOURCES                    1451
#define ERROR_PAGED_SYSTEM_RESOURCES                       1452
#define ERROR_WORKING_SET_QUOTA                            1453
#define ERROR_PAGEFILE_QUOTA                               1454
#define ERROR_COMMITMENT_LIMIT                             1455
#define ERROR_MENU_ITEM_NOT_FOUND                          1456
#define ERROR_INVALID_KEYBOARD_HANDLE                      1457
#define ERROR_HOOK_TYPE_NOT_ALLOWED                        1458
#define ERROR_REQUIRES_INTERACTIVE_WINDOWSTATION           1459
#define ERROR_TIMEOUT                                      1460
#define ERROR_INVALID_MONITOR_HANDLE                       1461
#define ERROR_INCORRECT_SIZE                               1462
#define ERROR_SYMLINK_CLASS_DISABLED                       1463
#define ERROR_SYMLINK_NOT_SUPPORTED                        1464
#define ERROR_XML_PARSE_ERROR                              1465
#define ERROR_XMLDSIG_ERROR                                1466
#define ERROR_RESTART_APPLICATION                          1467
#define ERROR_WRONG_COMPARTMENT                            1468
#define ERROR_AUTHIP_FAILURE                               1469
#define ERROR_NO_NVRAM_RESOURCES                           1470
#define ERROR_NOT_GUI_PROCESS                              1471
#define ERROR_EVENTLOG_FILE_CORRUPT                        1500
#define ERROR_EVENTLOG_CANT_START                          1501
#define ERROR_LOG_FILE_FULL                                1502
#define ERROR_EVENTLOG_FILE_CHANGED                        1503
#define ERROR_CONTAINER_ASSIGNED                           1504
#define ERROR_JOB_NO_CONTAINER                             1505
#define ERROR_INVALID_TASK_NAME                            1550
#define ERROR_INVALID_TASK_INDEX                           1551
#define ERROR_THREAD_ALREADY_IN_TASK                       1552
#define ERROR_INSTALL_SERVICE_FAILURE                      1601
#define ERROR_INSTALL_USEREXIT                             1602
#define ERROR_INSTALL_FAILURE                              1603
#define ERROR_INSTALL_SUSPEND                              1604
#define ERROR_UNKNOWN_PRODUCT                              1605
#define ERROR_UNKNOWN_FEATURE                              1606
#define ERROR_UNKNOWN_COMPONENT                            1607
#define ERROR_UNKNOWN_PROPERTY                             1608
#define ERROR_INVALID_HANDLE_STATE                         1609
#define ERROR_BAD_CONFIGURATION                            1610
#define ERROR_INDEX_ABSENT                                 1611
#define ERROR_INSTALL_SOURCE_ABSENT                        1612
#define ERROR_INSTALL_PACKAGE_VERSION                      1613
#define ERROR_PRODUCT_UNINSTALLED                          1614
#define ERROR_BAD_QUERY_SYNTAX                             1615
#define ERROR_INVALID_FIELD                                1616
#define ERROR_DEVICE_REMOVED                               1617
#define ERROR_INSTALL_ALREADY_RUNNING                      1618
#define ERROR_INSTALL_PACKAGE_OPEN_FAILED                  1619
#define ERROR_INSTALL_PACKAGE_INVALID                      1620
#define ERROR_INSTALL_UI_FAILURE                           1621
#define ERROR_INSTALL_LOG_FAILURE                          1622
#define ERROR_INSTALL_LANGUAGE_UNSUPPORTED                 1623
#define ERROR_INSTALL_TRANSFORM_FAILURE                    1624
#define ERROR_INSTALL_PACKAGE_REJECTED                     1625
#define ERROR_FUNCTION_NOT_CALLED                          1626
#define ERROR_FUNCTION_FAILED                              1627
#define ERROR_INVALID_TABLE                                1628
#define ERROR_DATATYPE_MISMATCH                            1629
#define ERROR_UNSUPPORTED_TYPE                             1630
#define ERROR_CREATE_FAILED                                1631
#define ERROR_INSTALL_TEMP_UNWRITABLE                      1632
#define ERROR_INSTALL_PLATFORM_UNSUPPORTED                 1633
#define ERROR_INSTALL_NOTUSED                              1634
#define ERROR_PATCH_PACKAGE_OPEN_FAILED                    1635
#define ERROR_PATCH_PACKAGE_INVALID                        1636
#define ERROR_PATCH_PACKAGE_UNSUPPORTED                    1637
#define ERROR_PRODUCT_VERSION                              1638
#define ERROR_INVALID_COMMAND_LINE                         1639
#define ERROR_INSTALL_REMOTE_DISALLOWED                    1640
#define ERROR_SUCCESS_REBOOT_INITIATED                     1641
#define ERROR_PATCH_TARGET_NOT_FOUND                       1642
#define ERROR_PATCH_PACKAGE_REJECTED                       1643
#define ERROR_INSTALL_TRANSFORM_REJECTED                   1644
#define ERROR_INSTALL_REMOTE_PROHIBITED                    1645
#define ERROR_PATCH_REMOVAL_UNSUPPORTED                    1646
#define ERROR_UNKNOWN_PATCH                                1647
#define ERROR_PATCH_NO_SEQUENCE                            1648
#define ERROR_PATCH_REMOVAL_DISALLOWED                     1649
#define ERROR_INVALID_PATCH_XML                            1650
#define ERROR_PATCH_MANAGED_ADVERTISED_PRODUCT             1651
#define ERROR_INSTALL_SERVICE_SAFEBOOT                     1652
#define ERROR_FAIL_FAST_EXCEPTION                          1653
#define ERROR_INSTALL_REJECTED                             1654
#define ERROR_DYNAMIC_CODE_BLOCKED                         1655
#define ERROR_NOT_SAME_OBJECT                              1656
#define ERROR_STRICT_CFG_VIOLATION                         1657
#define ERROR_SET_CONTEXT_DENIED                           1660
#define ERROR_CROSS_PARTITION_VIOLATION                    1661
#define ERROR_RETURN_ADDRESS_HIJACK_ATTEMPT                1662
#define RPC_S_INVALID_STRING_BINDING                       1700
#define RPC_S_WRONG_KIND_OF_BINDING                        1701
#define RPC_S_INVALID_BINDING                              1702
#define RPC_S_PROTSEQ_NOT_SUPPORTED                        1703
#define RPC_S_INVALID_RPC_PROTSEQ                          1704
#define RPC_S_INVALID_STRING_UUID                          1705
#define RPC_S_INVALID_ENDPOINT_FORMAT                      1706
#define RPC_S_INVALID_NET_ADDR                             1707
#define RPC_S_NO_ENDPOINT_FOUND                            1708
#define RPC_S_INVALID_TIMEOUT                              1709
#define RPC_S_OBJECT_NOT_FOUND                             1710
#define RPC_S_ALREADY_REGISTERED                           1711
#define RPC_S_TYPE_ALREADY_REGISTERED                      1712
#define RPC_S_ALREADY_LISTENING                            1713
#define RPC_S_NO_PROTSEQS_REGISTERED                       1714
#define RPC_S_NOT_LISTENING                                1715
#define RPC_S_UNKNOWN_MGR_TYPE                             1716
#define RPC_S_UNKNOWN_IF                                   1717
#define RPC_S_NO_BINDINGS                                  1718
#define RPC_S_NO_PROTSEQS                                  1719
#define RPC_S_CANT_CREATE_ENDPOINT                         1720
#define RPC_S_OUT_OF_RESOURCES                             1721
#define RPC_S_SERVER_UNAVAILABLE                           1722
#define RPC_S_SERVER_TOO_BUSY                              1723
#define RPC_S_INVALID_NETWORK_OPTIONS                      1724
#define RPC_S_NO_CALL_ACTIVE                               1725
#define RPC_S_CALL_FAILED                                  1726
#define RPC_S_CALL_FAILED_DNE                              1727
#define RPC_S_PROTOCOL_ERROR                               1728
#define RPC_S_PROXY_ACCESS_DENIED                          1729
#define RPC_S_UNSUPPORTED_TRANS_SYN                        1730
#define RPC_S_UNSUPPORTED_TYPE                             1732
#define RPC_S_INVALID_TAG                                  1733
#define RPC_S_INVALID_BOUND                                1734
#define RPC_S_NO_ENTRY_NAME                                1735
#define RPC_S_INVALID_NAME_SYNTAX                          1736
#define RPC_S_UNSUPPORTED_NAME_SYNTAX                      1737
#define RPC_S_UUID_NO_ADDRESS                              1739
#define RPC_S_DUPLICATE_ENDPOINT                           1740
#define RPC_S_UNKNOWN_AUTHN_TYPE                           1741
#define RPC_S_MAX_CALLS_TOO_SMALL                          1742
#define RPC_S_STRING_TOO_LONG                              1743
#define RPC_S_PROTSEQ_NOT_FOUND                            1744
#define RPC_S_PROCNUM_OUT_OF_RANGE                         1745
#define RPC_S_BINDING_HAS_NO_AUTH                          1746
#define RPC_S_UNKNOWN_AUTHN_SERVICE                        1747
#define RPC_S_UNKNOWN_AUTHN_LEVEL                          1748
#define RPC_S_INVALID_AUTH_IDENTITY                        1749
#define RPC_S_UNKNOWN_AUTHZ_SERVICE                        1750
#define EPT_S_INVALID_ENTRY                                1751
#define EPT_S_CANT_PERFORM_OP                              1752
#define EPT_S_NOT_REGISTERED                               1753
#define RPC_S_NOTHING_TO_EXPORT                            1754
#define RPC_S_INCOMPLETE_NAME                              1755
#define RPC_S_INVALID_VERS_OPTION                          1756
#define RPC_S_NO_MORE_MEMBERS                              1757
#define RPC_S_NOT_ALL_OBJS_UNEXPORTED                      1758
#define RPC_S_INTERFACE_NOT_FOUND                          1759
#define RPC_S_ENTRY_ALREADY_EXISTS                         1760
#define RPC_S_ENTRY_NOT_FOUND                              1761
#define RPC_S_NAME_SERVICE_UNAVAILABLE                     1762
#define RPC_S_INVALID_NAF_ID                               1763
#define RPC_S_CANNOT_SUPPORT                               1764
#define RPC_S_NO_CONTEXT_AVAILABLE                         1765
#define RPC_S_INTERNAL_ERROR                               1766
#define RPC_S_ZERO_DIVIDE                                  1767
#define RPC_S_ADDRESS_ERROR                                1768
#define RPC_S_FP_DIV_ZERO                                  1769
#define RPC_S_FP_UNDERFLOW                                 1770
#define RPC_S_FP_OVERFLOW                                  1771
#define RPC_X_NO_MORE_ENTRIES                              1772
#define RPC_X_SS_CHAR_TRANS_OPEN_FAIL                      1773
#define RPC_X_SS_CHAR_TRANS_SHORT_FILE                     1774
#define RPC_X_SS_IN_NULL_CONTEXT                           1775
#define RPC_X_SS_CONTEXT_DAMAGED                           1777
#define RPC_X_SS_HANDLES_MISMATCH                          1778
#define RPC_X_SS_CANNOT_GET_CALL_HANDLE                    1779
#define RPC_X_NULL_REF_POINTER                             1780
#define RPC_X_ENUM_VALUE_OUT_OF_RANGE                      1781
#define RPC_X_BYTE_COUNT_TOO_SMALL                         1782
#define RPC_X_BAD_STUB_DATA                                1783
#define ERROR_INVALID_USER_BUFFER                          1784
#define ERROR_UNRECOGNIZED_MEDIA                           1785
#define ERROR_NO_TRUST_LSA_SECRET                          1786
#define ERROR_NO_TRUST_SAM_ACCOUNT                         1787
#define ERROR_TRUSTED_DOMAIN_FAILURE                       1788
#define ERROR_TRUSTED_RELATIONSHIP_FAILURE                 1789
#define ERROR_TRUST_FAILURE                                1790
#define RPC_S_CALL_IN_PROGRESS                             1791
#define ERROR_NETLOGON_NOT_STARTED                         1792
#define ERROR_ACCOUNT_EXPIRED                              1793
#define ERROR_REDIRECTOR_HAS_OPEN_HANDLES                  1794
#define ERROR_PRINTER_DRIVER_ALREADY_INSTALLED             1795
#define ERROR_UNKNOWN_PORT                                 1796
#define ERROR_UNKNOWN_PRINTER_DRIVER                       1797
#define ERROR_UNKNOWN_PRINTPROCESSOR                       1798
#define ERROR_INVALID_SEPARATOR_FILE                       1799
#define ERROR_INVALID_PRIORITY                             1800
#define ERROR_INVALID_PRINTER_NAME                         1801
#define ERROR_PRINTER_ALREADY_EXISTS                       1802
#define ERROR_INVALID_PRINTER_COMMAND                      1803
#define ERROR_INVALID_DATATYPE                             1804
#define ERROR_INVALID_ENVIRONMENT                          1805
#define RPC_S_NO_MORE_BINDINGS                             1806
#define ERROR_NOLOGON_INTERDOMAIN_TRUST_ACCOUNT            1807
#define ERROR_NOLOGON_WORKSTATION_TRUST_ACCOUNT            1808
#define ERROR_NOLOGON_SERVER_TRUST_ACCOUNT                 1809
#define ERROR_DOMAIN_TRUST_INCONSISTENT                    1810
#define ERROR_SERVER_HAS_OPEN_HANDLES                      1811
#define ERROR_RESOURCE_DATA_NOT_FOUND                      1812
#define ERROR_RESOURCE_TYPE_NOT_FOUND                      1813
#define ERROR_RESOURCE_NAME_NOT_FOUND                      1814
#define ERROR_RESOURCE_LANG_NOT_FOUND                      1815
#define ERROR_NOT_ENOUGH_QUOTA                             1816
#define RPC_S_NO_INTERFACES                                1817
#define RPC_S_CALL_CANCELLED                               1818
#define RPC_S_BINDING_INCOMPLETE                           1819
#define RPC_S_COMM_FAILURE                                 1820
#define RPC_S_UNSUPPORTED_AUTHN_LEVEL                      1821
#define RPC_S_NO_PRINC_NAME                                1822
#define RPC_S_NOT_RPC_ERROR                                1823
#define RPC_S_UUID_LOCAL_ONLY                              1824
#define RPC_S_SEC_PKG_ERROR                                1825
#define RPC_S_NOT_CANCELLED                                1826
#define RPC_X_INVALID_ES_ACTION                            1827
#define RPC_X_WRONG_ES_VERSION                             1828
#define RPC_X_WRONG_STUB_VERSION                           1829
#define RPC_X_INVALID_PIPE_OBJECT                          1830
#define RPC_X_WRONG_PIPE_ORDER                             1831
#define RPC_X_WRONG_PIPE_VERSION                           1832
#define RPC_S_COOKIE_AUTH_FAILED                           1833
#define RPC_S_DO_NOT_DISTURB                               1834
#define RPC_S_SYSTEM_HANDLE_COUNT_EXCEEDED                 1835
#define RPC_S_SYSTEM_HANDLE_TYPE_MISMATCH                  1836
#define RPC_S_GROUP_MEMBER_NOT_FOUND                       1898
#define EPT_S_CANT_CREATE                                  1899
#define RPC_S_INVALID_OBJECT                               1900
#define ERROR_INVALID_TIME                                 1901
#define ERROR_INVALID_FORM_NAME                            1902
#define ERROR_INVALID_FORM_SIZE                            1903
#define ERROR_ALREADY_WAITING                              1904
#define ERROR_PRINTER_DELETED                              1905
#define ERROR_INVALID_PRINTER_STATE                        1906
#define ERROR_PASSWORD_MUST_CHANGE                         1907
#define ERROR_DOMAIN_CONTROLLER_NOT_FOUND                  1908
#define ERROR_ACCOUNT_LOCKED_OUT                           1909
#define OR_INVALID_OXID                                    1910
#define OR_INVALID_OID                                     1911
#define OR_INVALID_SET                                     1912
#define RPC_S_SEND_INCOMPLETE                              1913
#define RPC_S_INVALID_ASYNC_HANDLE                         1914
#define RPC_S_INVALID_ASYNC_CALL                           1915
#define RPC_X_PIPE_CLOSED                                  1916
#define RPC_X_PIPE_DISCIPLINE_ERROR                        1917
#define RPC_X_PIPE_EMPTY                                   1918
#define ERROR_NO_SITENAME                                  1919
#define ERROR_CANT_ACCESS_FILE                             1920
#define ERROR_CANT_RESOLVE_FILENAME                        1921
#define RPC_S_ENTRY_TYPE_MISMATCH                          1922
#define RPC_S_NOT_ALL_OBJS_EXPORTED                        1923
#define RPC_S_INTERFACE_NOT_EXPORTED                       1924
#define RPC_S_PROFILE_NOT_ADDED                            1925
#define RPC_S_PRF_ELT_NOT_ADDED                            1926
#define RPC_S_PRF_ELT_NOT_REMOVED                          1927
#define RPC_S_GRP_ELT_NOT_ADDED                            1928
#define RPC_S_GRP_ELT_NOT_REMOVED                          1929
#define ERROR_KM_DRIVER_BLOCKED                            1930
#define ERROR_CONTEXT_EXPIRED                              1931
#define ERROR_PER_USER_TRUST_QUOTA_EXCEEDED                1932
#define ERROR_ALL_USER_TRUST_QUOTA_EXCEEDED                1933
#define ERROR_USER_DELETE_TRUST_QUOTA_EXCEEDED             1934
#define ERROR_AUTHENTICATION_FIREWALL_FAILED               1935
#define ERROR_REMOTE_PRINT_CONNECTIONS_BLOCKED             1936
#define ERROR_NTLM_BLOCKED                                 1937
#define ERROR_PASSWORD_CHANGE_REQUIRED                     1938
#define ERROR_LOST_MODE_LOGON_RESTRICTION                  1939
#define ERROR_INVALID_PIXEL_FORMAT                         2000
#define ERROR_BAD_DRIVER                                   2001
#define ERROR_INVALID_WINDOW_STYLE                         2002
#define ERROR_METAFILE_NOT_SUPPORTED                       2003
#define ERROR_TRANSFORM_NOT_SUPPORTED                      2004
#define ERROR_CLIPPING_NOT_SUPPORTED                       2005
#define ERROR_INVALID_CMM                                  2010
#define ERROR_INVALID_PROFILE                              2011
#define ERROR_TAG_NOT_FOUND                                2012
#define ERROR_TAG_NOT_PRESENT                              2013
#define ERROR_DUPLICATE_TAG                                2014
#define ERROR_PROFILE_NOT_ASSOCIATED_WITH_DEVICE           2015
#define ERROR_PROFILE_NOT_FOUND                            2016
#define ERROR_INVALID_COLORSPACE                           2017
#define ERROR_ICM_NOT_ENABLED                              2018
#define ERROR_DELETING_ICM_XFORM                           2019
#define ERROR_INVALID_TRANSFORM                            2020
#define ERROR_COLORSPACE_MISMATCH                          2021
#define ERROR_INVALID_COLORINDEX                           2022
#define ERROR_PROFILE_DOES_NOT_MATCH_DEVICE                2023
#define ERROR_CONNECTED_OTHER_PASSWORD                     2108
#define ERROR_CONNECTED_OTHER_PASSWORD_DEFAULT             2109
#define ERROR_BAD_USERNAME                                 2202
#define ERROR_NOT_CONNECTED                                2250
#define ERROR_OPEN_FILES                                   2401
#define ERROR_ACTIVE_CONNECTIONS                           2402
#define ERROR_DEVICE_IN_USE                                2404
#define ERROR_UNKNOWN_PRINT_MONITOR                        3000
#define ERROR_PRINTER_DRIVER_IN_USE                        3001
#define ERROR_SPOOL_FILE_NOT_FOUND                         3002
#define ERROR_SPL_NO_STARTDOC                              3003
#define ERROR_SPL_NO_ADDJOB                                3004
#define ERROR_PRINT_PROCESSOR_ALREADY_INSTALLED            3005
#define ERROR_PRINT_MONITOR_ALREADY_INSTALLED              3006
#define ERROR_INVALID_PRINT_MONITOR                        3007
#define ERROR_PRINT_MONITOR_IN_USE                         3008
#define ERROR_PRINTER_HAS_JOBS_QUEUED                      3009
#define ERROR_SUCCESS_REBOOT_REQUIRED                      3010
#define ERROR_SUCCESS_RESTART_REQUIRED                     3011
#define ERROR_PRINTER_NOT_FOUND                            3012
#define ERROR_PRINTER_DRIVER_WARNED                        3013
#define ERROR_PRINTER_DRIVER_BLOCKED                       3014
#define ERROR_PRINTER_DRIVER_PACKAGE_IN_USE                3015
#define ERROR_CORE_DRIVER_PACKAGE_NOT_FOUND                3016
#define ERROR_FAIL_REBOOT_REQUIRED                         3017
#define ERROR_FAIL_REBOOT_INITIATED                        3018
#define ERROR_PRINTER_DRIVER_DOWNLOAD_NEEDED               3019
#define ERROR_PRINT_JOB_RESTART_REQUIRED                   3020
#define ERROR_INVALID_PRINTER_DRIVER_MANIFEST              3021
#define ERROR_PRINTER_NOT_SHAREABLE                        3022
#define ERROR_SERVER_SERVICE_CALL_REQUIRES_SMB1            3023
#define ERROR_NETWORK_AUTHENTICATION_PROMPT_CANCELED       3024
#define ERROR_REQUEST_PAUSED                               3050
#define ERROR_APPEXEC_CONDITION_NOT_SATISFIED              3060
#define ERROR_APPEXEC_HANDLE_INVALIDATED                   3061
#define ERROR_APPEXEC_INVALID_HOST_GENERATION              3062
#define ERROR_APPEXEC_UNEXPECTED_PROCESS_REGISTRATION      3063
#define ERROR_APPEXEC_INVALID_HOST_STATE                   3064
#define ERROR_APPEXEC_NO_DONOR                             3065
#define ERROR_APPEXEC_HOST_ID_MISMATCH                     3066
#define ERROR_APPEXEC_UNKNOWN_USER                         3067
#define ERROR_APPEXEC_APP_COMPAT_BLOCK                     3068
#define ERROR_APPEXEC_CALLER_WAIT_TIMEOUT                  3069
#define ERROR_APPEXEC_CALLER_WAIT_TIMEOUT_TERMINATION      3070
#define ERROR_APPEXEC_CALLER_WAIT_TIMEOUT_LICENSING        3071
#define ERROR_APPEXEC_CALLER_WAIT_TIMEOUT_RESOURCES        3072
#define ERROR_VRF_VOLATILE_CFG_AND_IO_ENABLED              3080
#define ERROR_VRF_VOLATILE_NOT_STOPPABLE                   3081
#define ERROR_VRF_VOLATILE_SAFE_MODE                       3082
#define ERROR_VRF_VOLATILE_NOT_RUNNABLE_SYSTEM             3083
#define ERROR_VRF_VOLATILE_NOT_SUPPORTED_RULECLASS         3084
#define ERROR_VRF_VOLATILE_PROTECTED_DRIVER                3085
#define ERROR_VRF_VOLATILE_NMI_REGISTERED                  3086
#define ERROR_VRF_VOLATILE_SETTINGS_CONFLICT               3087
#define ERROR_DIF_IOCALLBACK_NOT_REPLACED                  3190
#define ERROR_DIF_LIVEDUMP_LIMIT_EXCEEDED                  3191
#define ERROR_DIF_VOLATILE_SECTION_NOT_LOCKED              3192
#define ERROR_DIF_VOLATILE_DRIVER_HOTPATCHED               3193
#define ERROR_DIF_VOLATILE_INVALID_INFO                    3194
#define ERROR_DIF_VOLATILE_DRIVER_IS_NOT_RUNNING           3195
#define ERROR_DIF_VOLATILE_PLUGIN_IS_NOT_RUNNING           3196
#define ERROR_DIF_VOLATILE_PLUGIN_CHANGE_NOT_ALLOWED       3197
#define ERROR_DIF_VOLATILE_NOT_ALLOWED                     3198
#define ERROR_DIF_BINDING_API_NOT_FOUND                    3199
#define ERROR_IO_REISSUE_AS_CACHED                         3950
#define ERROR_WINS_INTERNAL                                4000
#define ERROR_CAN_NOT_DEL_LOCAL_WINS                       4001
#define ERROR_STATIC_INIT                                  4002
#define ERROR_INC_BACKUP                                   4003
#define ERROR_FULL_BACKUP                                  4004
#define ERROR_REC_NON_EXISTENT                             4005
#define ERROR_RPL_NOT_ALLOWED                              4006
#define PEERDIST_ERROR_CONTENTINFO_VERSION_UNSUPPORTED     4050
#define PEERDIST_ERROR_CANNOT_PARSE_CONTENTINFO            4051
#define PEERDIST_ERROR_MISSING_DATA                        4052
#define PEERDIST_ERROR_NO_MORE                             4053
#define PEERDIST_ERROR_NOT_INITIALIZED                     4054
#define PEERDIST_ERROR_ALREADY_INITIALIZED                 4055
#define PEERDIST_ERROR_SHUTDOWN_IN_PROGRESS                4056
#define PEERDIST_ERROR_INVALIDATED                         4057
#define PEERDIST_ERROR_ALREADY_EXISTS                      4058
#define PEERDIST_ERROR_OPERATION_NOTFOUND                  4059
#define PEERDIST_ERROR_ALREADY_COMPLETED                   4060
#define PEERDIST_ERROR_OUT_OF_BOUNDS                       4061
#define PEERDIST_ERROR_VERSION_UNSUPPORTED                 4062
#define PEERDIST_ERROR_INVALID_CONFIGURATION               4063
#define PEERDIST_ERROR_NOT_LICENSED                        4064
#define PEERDIST_ERROR_SERVICE_UNAVAILABLE                 4065
#define PEERDIST_ERROR_TRUST_FAILURE                       4066
#define ERROR_DHCP_ADDRESS_CONFLICT                        4100
#define ERROR_WMI_GUID_NOT_FOUND                           4200
#define ERROR_WMI_INSTANCE_NOT_FOUND                       4201
#define ERROR_WMI_ITEMID_NOT_FOUND                         4202
#define ERROR_WMI_TRY_AGAIN                                4203
#define ERROR_WMI_DP_NOT_FOUND                             4204
#define ERROR_WMI_UNRESOLVED_INSTANCE_REF                  4205
#define ERROR_WMI_ALREADY_ENABLED                          4206
#define ERROR_WMI_GUID_DISCONNECTED                        4207
#define ERROR_WMI_SERVER_UNAVAILABLE                       4208
#define ERROR_WMI_DP_FAILED                                4209
#define ERROR_WMI_INVALID_MOF                              4210
#define ERROR_WMI_INVALID_REGINFO                          4211
#define ERROR_WMI_ALREADY_DISABLED                         4212
#define ERROR_WMI_READ_ONLY                                4213
#define ERROR_WMI_SET_FAILURE                              4214
#define ERROR_NOT_APPCONTAINER                             4250
#define ERROR_APPCONTAINER_REQUIRED                        4251
#define ERROR_NOT_SUPPORTED_IN_APPCONTAINER                4252
#define ERROR_INVALID_PACKAGE_SID_LENGTH                   4253
#define ERROR_INVALID_MEDIA                                4300
#define ERROR_INVALID_LIBRARY                              4301
#define ERROR_INVALID_MEDIA_POOL                           4302
#define ERROR_DRIVE_MEDIA_MISMATCH                         4303
#define ERROR_MEDIA_OFFLINE                                4304
#define ERROR_LIBRARY_OFFLINE                              4305
#define ERROR_EMPTY                                        4306
#define ERROR_NOT_EMPTY                                    4307
#define ERROR_MEDIA_UNAVAILABLE                            4308
#define ERROR_RESOURCE_DISABLED                            4309
#define ERROR_INVALID_CLEANER                              4310
#define ERROR_UNABLE_TO_CLEAN                              4311
#define ERROR_OBJECT_NOT_FOUND                             4312
#define ERROR_DATABASE_FAILURE                             4313
#define ERROR_DATABASE_FULL                                4314
#define ERROR_MEDIA_INCOMPATIBLE                           4315
#define ERROR_RESOURCE_NOT_PRESENT                         4316
#define ERROR_INVALID_OPERATION                            4317
#define ERROR_MEDIA_NOT_AVAILABLE                          4318
#define ERROR_DEVICE_NOT_AVAILABLE                         4319
#define ERROR_REQUEST_REFUSED                              4320
#define ERROR_INVALID_DRIVE_OBJECT                         4321
#define ERROR_LIBRARY_FULL                                 4322
#define ERROR_MEDIUM_NOT_ACCESSIBLE                        4323
#define ERROR_UNABLE_TO_LOAD_MEDIUM                        4324
#define ERROR_UNABLE_TO_INVENTORY_DRIVE                    4325
#define ERROR_UNABLE_TO_INVENTORY_SLOT                     4326
#define ERROR_UNABLE_TO_INVENTORY_TRANSPORT                4327
#define ERROR_TRANSPORT_FULL                               4328
#define ERROR_CONTROLLING_IEPORT                           4329
#define ERROR_UNABLE_TO_EJECT_MOUNTED_MEDIA                4330
#define ERROR_CLEANER_SLOT_SET                             4331
#define ERROR_CLEANER_SLOT_NOT_SET                         4332
#define ERROR_CLEANER_CARTRIDGE_SPENT                      4333
#define ERROR_UNEXPECTED_OMID                              4334
#define ERROR_CANT_DELETE_LAST_ITEM                        4335
#define ERROR_MESSAGE_EXCEEDS_MAX_SIZE                     4336
#define ERROR_VOLUME_CONTAINS_SYS_FILES                    4337
#define ERROR_INDIGENOUS_TYPE                              4338
#define ERROR_NO_SUPPORTING_DRIVES                         4339
#define ERROR_CLEANER_CARTRIDGE_INSTALLED                  4340
#define ERROR_IEPORT_FULL                                  4341
#define ERROR_FILE_OFFLINE                                 4350
#define ERROR_REMOTE_STORAGE_NOT_ACTIVE                    4351
#define ERROR_REMOTE_STORAGE_MEDIA_ERROR                   4352
#define ERROR_NOT_A_REPARSE_POINT                          4390
#define ERROR_REPARSE_ATTRIBUTE_CONFLICT                   4391
#define ERROR_INVALID_REPARSE_DATA                         4392
#define ERROR_REPARSE_TAG_INVALID                          4393
#define ERROR_REPARSE_TAG_MISMATCH                         4394
#define ERROR_REPARSE_POINT_ENCOUNTERED                    4395
#define ERROR_APP_DATA_NOT_FOUND                           4400
#define ERROR_APP_DATA_EXPIRED                             4401
#define ERROR_APP_DATA_CORRUPT                             4402
#define ERROR_APP_DATA_LIMIT_EXCEEDED                      4403
#define ERROR_APP_DATA_REBOOT_REQUIRED                     4404
#define ERROR_SECUREBOOT_ROLLBACK_DETECTED                 4420
#define ERROR_SECUREBOOT_POLICY_VIOLATION                  4421
#define ERROR_SECUREBOOT_INVALID_POLICY                    4422
#define ERROR_SECUREBOOT_POLICY_PUBLISHER_NOT_FOUND        4423
#define ERROR_SECUREBOOT_POLICY_NOT_SIGNED                 4424
#define ERROR_SECUREBOOT_NOT_ENABLED                       4425
#define ERROR_SECUREBOOT_FILE_REPLACED                     4426
#define ERROR_SECUREBOOT_POLICY_NOT_AUTHORIZED             4427
#define ERROR_SECUREBOOT_POLICY_UNKNOWN                    4428
#define ERROR_SECUREBOOT_POLICY_MISSING_ANTIROLLBACKVERSION 4429
#define ERROR_SECUREBOOT_PLATFORM_ID_MISMATCH              4430
#define ERROR_SECUREBOOT_POLICY_ROLLBACK_DETECTED          4431
#define ERROR_SECUREBOOT_POLICY_UPGRADE_MISMATCH           4432
#define ERROR_SECUREBOOT_REQUIRED_POLICY_FILE_MISSING      4433
#define ERROR_SECUREBOOT_NOT_BASE_POLICY                   4434
#define ERROR_SECUREBOOT_NOT_SUPPLEMENTAL_POLICY           4435
#define ERROR_OFFLOAD_READ_FLT_NOT_SUPPORTED               4440
#define ERROR_OFFLOAD_WRITE_FLT_NOT_SUPPORTED              4441
#define ERROR_OFFLOAD_READ_FILE_NOT_SUPPORTED              4442
#define ERROR_OFFLOAD_WRITE_FILE_NOT_SUPPORTED             4443
#define ERROR_ALREADY_HAS_STREAM_ID                        4444
#define ERROR_SMR_GARBAGE_COLLECTION_REQUIRED              4445
#define ERROR_WOF_WIM_HEADER_CORRUPT                       4446
#define ERROR_WOF_WIM_RESOURCE_TABLE_CORRUPT               4447
#define ERROR_WOF_FILE_RESOURCE_TABLE_CORRUPT              4448
#define ERROR_OBJECT_IS_IMMUTABLE                          4449
#define ERROR_VOLUME_NOT_SIS_ENABLED                       4500
#define ERROR_SYSTEM_INTEGRITY_ROLLBACK_DETECTED           4550
#define ERROR_SYSTEM_INTEGRITY_POLICY_VIOLATION            4551
#define ERROR_SYSTEM_INTEGRITY_INVALID_POLICY              4552
#define ERROR_SYSTEM_INTEGRITY_POLICY_NOT_SIGNED           4553
#define ERROR_SYSTEM_INTEGRITY_TOO_MANY_POLICIES           4554
#define ERROR_SYSTEM_INTEGRITY_SUPPLEMENTAL_POLICY_NOT_AUTHORIZED 4555
#define ERROR_SYSTEM_INTEGRITY_REPUTATION_MALICIOUS        4556
#define ERROR_SYSTEM_INTEGRITY_REPUTATION_PUA              4557
#define ERROR_SYSTEM_INTEGRITY_REPUTATION_DANGEROUS_EXT    4558
#define ERROR_SYSTEM_INTEGRITY_REPUTATION_OFFLINE          4559
#define ERROR_VSM_NOT_INITIALIZED                          4560
#define ERROR_VSM_DMA_PROTECTION_NOT_IN_USE                4561
#define ERROR_PLATFORM_MANIFEST_NOT_AUTHORIZED             4570
#define ERROR_PLATFORM_MANIFEST_INVALID                    4571
#define ERROR_PLATFORM_MANIFEST_FILE_NOT_AUTHORIZED        4572
#define ERROR_PLATFORM_MANIFEST_CATALOG_NOT_AUTHORIZED     4573
#define ERROR_PLATFORM_MANIFEST_BINARY_ID_NOT_FOUND        4574
#define ERROR_PLATFORM_MANIFEST_NOT_ACTIVE                 4575
#define ERROR_PLATFORM_MANIFEST_NOT_SIGNED                 4576
#define ERROR_SYSTEM_INTEGRITY_REPUTATION_UNFRIENDLY_FILE  4580
#define ERROR_SYSTEM_INTEGRITY_REPUTATION_UNATTAINABLE     4581
#define ERROR_SYSTEM_INTEGRITY_REPUTATION_EXPLICIT_DENY_FILE 4582
#define ERROR_DEPENDENT_RESOURCE_EXISTS                    5001
#define ERROR_DEPENDENCY_NOT_FOUND                         5002
#define ERROR_DEPENDENCY_ALREADY_EXISTS                    5003
#define ERROR_RESOURCE_NOT_ONLINE                          5004
#define ERROR_HOST_NODE_NOT_AVAILABLE                      5005
#define ERROR_RESOURCE_NOT_AVAILABLE                       5006
#define ERROR_RESOURCE_NOT_FOUND                           5007
#define ERROR_SHUTDOWN_CLUSTER                             5008
#define ERROR_CANT_EVICT_ACTIVE_NODE                       5009
#define ERROR_OBJECT_ALREADY_EXISTS                        5010
#define ERROR_OBJECT_IN_LIST                               5011
#define ERROR_GROUP_NOT_AVAILABLE                          5012
#define ERROR_GROUP_NOT_FOUND                              5013
#define ERROR_GROUP_NOT_ONLINE                             5014
#define ERROR_HOST_NODE_NOT_RESOURCE_OWNER                 5015
#define ERROR_HOST_NODE_NOT_GROUP_OWNER                    5016
#define ERROR_RESMON_CREATE_FAILED                         5017
#define ERROR_RESMON_ONLINE_FAILED                         5018
#define ERROR_RESOURCE_ONLINE                              5019
#define ERROR_QUORUM_RESOURCE                              5020
#define ERROR_NOT_QUORUM_CAPABLE                           5021
#define ERROR_CLUSTER_SHUTTING_DOWN                        5022
#define ERROR_INVALID_STATE                                5023
#define ERROR_RESOURCE_PROPERTIES_STORED                   5024
#define ERROR_NOT_QUORUM_CLASS                             5025
#define ERROR_CORE_RESOURCE                                5026
#define ERROR_QUORUM_RESOURCE_ONLINE_FAILED                5027
#define ERROR_QUORUMLOG_OPEN_FAILED                        5028
#define ERROR_CLUSTERLOG_CORRUPT                           5029
#define ERROR_CLUSTERLOG_RECORD_EXCEEDS_MAXSIZE            5030
#define ERROR_CLUSTERLOG_EXCEEDS_MAXSIZE                   5031
#define ERROR_CLUSTERLOG_CHKPOINT_NOT_FOUND                5032
#define ERROR_CLUSTERLOG_NOT_ENOUGH_SPACE                  5033
#define ERROR_QUORUM_OWNER_ALIVE                           5034
#define ERROR_NETWORK_NOT_AVAILABLE                        5035
#define ERROR_NODE_NOT_AVAILABLE                           5036
#define ERROR_ALL_NODES_NOT_AVAILABLE                      5037
#define ERROR_RESOURCE_FAILED                              5038
#define ERROR_CLUSTER_INVALID_NODE                         5039
#define ERROR_CLUSTER_NODE_EXISTS                          5040
#define ERROR_CLUSTER_JOIN_IN_PROGRESS                     5041
#define ERROR_CLUSTER_NODE_NOT_FOUND                       5042
#define ERROR_CLUSTER_LOCAL_NODE_NOT_FOUND                 5043
#define ERROR_CLUSTER_NETWORK_EXISTS                       5044
#define ERROR_CLUSTER_NETWORK_NOT_FOUND                    5045
#define ERROR_CLUSTER_NETINTERFACE_EXISTS                  5046
#define ERROR_CLUSTER_NETINTERFACE_NOT_FOUND               5047
#define ERROR_CLUSTER_INVALID_REQUEST                      5048
#define ERROR_CLUSTER_INVALID_NETWORK_PROVIDER             5049
#define ERROR_CLUSTER_NODE_DOWN                            5050
#define ERROR_CLUSTER_NODE_UNREACHABLE                     5051
#define ERROR_CLUSTER_NODE_NOT_MEMBER                      5052
#define ERROR_CLUSTER_JOIN_NOT_IN_PROGRESS                 5053
#define ERROR_CLUSTER_INVALID_NETWORK                      5054
#define ERROR_CLUSTER_NODE_UP                              5056
#define ERROR_CLUSTER_IPADDR_IN_USE                        5057
#define ERROR_CLUSTER_NODE_NOT_PAUSED                      5058
#define ERROR_CLUSTER_NO_SECURITY_CONTEXT                  5059
#define ERROR_CLUSTER_NETWORK_NOT_INTERNAL                 5060
#define ERROR_CLUSTER_NODE_ALREADY_UP                      5061
#define ERROR_CLUSTER_NODE_ALREADY_DOWN                    5062
#define ERROR_CLUSTER_NETWORK_ALREADY_ONLINE               5063
#define ERROR_CLUSTER_NETWORK_ALREADY_OFFLINE              5064
#define ERROR_CLUSTER_NODE_ALREADY_MEMBER                  5065
#define ERROR_CLUSTER_LAST_INTERNAL_NETWORK                5066
#define ERROR_CLUSTER_NETWORK_HAS_DEPENDENTS               5067
#define ERROR_INVALID_OPERATION_ON_QUORUM                  5068
#define ERROR_DEPENDENCY_NOT_ALLOWED                       5069
#define ERROR_CLUSTER_NODE_PAUSED                          5070
#define ERROR_NODE_CANT_HOST_RESOURCE                      5071
#define ERROR_CLUSTER_NODE_NOT_READY                       5072
#define ERROR_CLUSTER_NODE_SHUTTING_DOWN                   5073
#define ERROR_CLUSTER_JOIN_ABORTED                         5074
#define ERROR_CLUSTER_INCOMPATIBLE_VERSIONS                5075
#define ERROR_CLUSTER_MAXNUM_OF_RESOURCES_EXCEEDED         5076
#define ERROR_CLUSTER_SYSTEM_CONFIG_CHANGED                5077
#define ERROR_CLUSTER_RESOURCE_TYPE_NOT_FOUND              5078
#define ERROR_CLUSTER_RESTYPE_NOT_SUPPORTED                5079
#define ERROR_CLUSTER_RESNAME_NOT_FOUND                    5080
#define ERROR_CLUSTER_NO_RPC_PACKAGES_REGISTERED           5081
#define ERROR_CLUSTER_OWNER_NOT_IN_PREFLIST                5082
#define ERROR_CLUSTER_DATABASE_SEQMISMATCH                 5083
#define ERROR_RESMON_INVALID_STATE                         5084
#define ERROR_CLUSTER_GUM_NOT_LOCKER                       5085
#define ERROR_QUORUM_DISK_NOT_FOUND                        5086
#define ERROR_DATABASE_BACKUP_CORRUPT                      5087
#define ERROR_CLUSTER_NODE_ALREADY_HAS_DFS_ROOT            5088
#define ERROR_RESOURCE_PROPERTY_UNCHANGEABLE               5089
#define ERROR_NO_ADMIN_ACCESS_POINT                        5090
#define ERROR_CLUSTER_MEMBERSHIP_INVALID_STATE             5890
#define ERROR_CLUSTER_QUORUMLOG_NOT_FOUND                  5891
#define ERROR_CLUSTER_MEMBERSHIP_HALT                      5892
#define ERROR_CLUSTER_INSTANCE_ID_MISMATCH                 5893
#define ERROR_CLUSTER_NETWORK_NOT_FOUND_FOR_IP             5894
#define ERROR_CLUSTER_PROPERTY_DATA_TYPE_MISMATCH          5895
#define ERROR_CLUSTER_EVICT_WITHOUT_CLEANUP                5896
#define ERROR_CLUSTER_PARAMETER_MISMATCH                   5897
#define ERROR_NODE_CANNOT_BE_CLUSTERED                     5898
#define ERROR_CLUSTER_WRONG_OS_VERSION                     5899
#define ERROR_CLUSTER_CANT_CREATE_DUP_CLUSTER_NAME         5900
#define ERROR_CLUSCFG_ALREADY_COMMITTED                    5901
#define ERROR_CLUSCFG_ROLLBACK_FAILED                      5902
#define ERROR_CLUSCFG_SYSTEM_DISK_DRIVE_LETTER_CONFLICT    5903
#define ERROR_CLUSTER_OLD_VERSION                          5904
#define ERROR_CLUSTER_MISMATCHED_COMPUTER_ACCT_NAME        5905
#define ERROR_CLUSTER_NO_NET_ADAPTERS                      5906
#define ERROR_CLUSTER_POISONED                             5907
#define ERROR_CLUSTER_GROUP_MOVING                         5908
#define ERROR_CLUSTER_RESOURCE_TYPE_BUSY                   5909
#define ERROR_RESOURCE_CALL_TIMED_OUT                      5910
#define ERROR_INVALID_CLUSTER_IPV6_ADDRESS                 5911
#define ERROR_CLUSTER_INTERNAL_INVALID_FUNCTION            5912
#define ERROR_CLUSTER_PARAMETER_OUT_OF_BOUNDS              5913
#define ERROR_CLUSTER_PARTIAL_SEND                         5914
#define ERROR_CLUSTER_REGISTRY_INVALID_FUNCTION            5915
#define ERROR_CLUSTER_INVALID_STRING_TERMINATION           5916
#define ERROR_CLUSTER_INVALID_STRING_FORMAT                5917
#define ERROR_CLUSTER_DATABASE_TRANSACTION_IN_PROGRESS     5918
#define ERROR_CLUSTER_DATABASE_TRANSACTION_NOT_IN_PROGRESS 5919
#define ERROR_CLUSTER_NULL_DATA                            5920
#define ERROR_CLUSTER_PARTIAL_READ                         5921
#define ERROR_CLUSTER_PARTIAL_WRITE                        5922
#define ERROR_CLUSTER_CANT_DESERIALIZE_DATA                5923
#define ERROR_DEPENDENT_RESOURCE_PROPERTY_CONFLICT         5924
#define ERROR_CLUSTER_NO_QUORUM                            5925
#define ERROR_CLUSTER_INVALID_IPV6_NETWORK                 5926
#define ERROR_CLUSTER_INVALID_IPV6_TUNNEL_NETWORK          5927
#define ERROR_QUORUM_NOT_ALLOWED_IN_THIS_GROUP             5928
#define ERROR_DEPENDENCY_TREE_TOO_COMPLEX                  5929
#define ERROR_EXCEPTION_IN_RESOURCE_CALL                   5930
#define ERROR_CLUSTER_RHS_FAILED_INITIALIZATION            5931
#define ERROR_CLUSTER_NOT_INSTALLED                        5932
#define ERROR_CLUSTER_RESOURCES_MUST_BE_ONLINE_ON_THE_SAME_NODE 5933
#define ERROR_CLUSTER_MAX_NODES_IN_CLUSTER                 5934
#define ERROR_CLUSTER_TOO_MANY_NODES                       5935
#define ERROR_CLUSTER_OBJECT_ALREADY_USED                  5936
#define ERROR_NONCORE_GROUPS_FOUND                         5937
#define ERROR_FILE_SHARE_RESOURCE_CONFLICT                 5938
#define ERROR_CLUSTER_EVICT_INVALID_REQUEST                5939
#define ERROR_CLUSTER_SINGLETON_RESOURCE                   5940
#define ERROR_CLUSTER_GROUP_SINGLETON_RESOURCE             5941
#define ERROR_CLUSTER_RESOURCE_PROVIDER_FAILED             5942
#define ERROR_CLUSTER_RESOURCE_CONFIGURATION_ERROR         5943
#define ERROR_CLUSTER_GROUP_BUSY                           5944
#define ERROR_CLUSTER_NOT_SHARED_VOLUME                    5945
#define ERROR_CLUSTER_INVALID_SECURITY_DESCRIPTOR          5946
#define ERROR_CLUSTER_SHARED_VOLUMES_IN_USE                5947
#define ERROR_CLUSTER_USE_SHARED_VOLUMES_API               5948
#define ERROR_CLUSTER_BACKUP_IN_PROGRESS                   5949
#define ERROR_NON_CSV_PATH                                 5950
#define ERROR_CSV_VOLUME_NOT_LOCAL                         5951
#define ERROR_CLUSTER_WATCHDOG_TERMINATING                 5952
#define ERROR_CLUSTER_RESOURCE_VETOED_MOVE_INCOMPATIBLE_NODES 5953
#define ERROR_CLUSTER_INVALID_NODE_WEIGHT                  5954
#define ERROR_CLUSTER_RESOURCE_VETOED_CALL                 5955
#define ERROR_RESMON_SYSTEM_RESOURCES_LACKING              5956
#define ERROR_CLUSTER_RESOURCE_VETOED_MOVE_NOT_ENOUGH_RESOURCES_ON_DESTINATION 5957
#define ERROR_CLUSTER_RESOURCE_VETOED_MOVE_NOT_ENOUGH_RESOURCES_ON_SOURCE 5958
#define ERROR_CLUSTER_GROUP_QUEUED                         5959
#define ERROR_CLUSTER_RESOURCE_LOCKED_STATUS               5960
#define ERROR_CLUSTER_SHARED_VOLUME_FAILOVER_NOT_ALLOWED   5961
#define ERROR_CLUSTER_NODE_DRAIN_IN_PROGRESS               5962
#define ERROR_CLUSTER_DISK_NOT_CONNECTED                   5963
#define ERROR_DISK_NOT_CSV_CAPABLE                         5964
#define ERROR_RESOURCE_NOT_IN_AVAILABLE_STORAGE            5965
#define ERROR_CLUSTER_SHARED_VOLUME_REDIRECTED             5966
#define ERROR_CLUSTER_SHARED_VOLUME_NOT_REDIRECTED         5967
#define ERROR_CLUSTER_CANNOT_RETURN_PROPERTIES             5968
#define ERROR_CLUSTER_RESOURCE_CONTAINS_UNSUPPORTED_DIFF_AREA_FOR_SHARED_VOLUMES 5969
#define ERROR_CLUSTER_RESOURCE_IS_IN_MAINTENANCE_MODE      5970
#define ERROR_CLUSTER_AFFINITY_CONFLICT                    5971
#define ERROR_CLUSTER_RESOURCE_IS_REPLICA_VIRTUAL_MACHINE  5972
#define ERROR_CLUSTER_UPGRADE_INCOMPATIBLE_VERSIONS        5973
#define ERROR_CLUSTER_UPGRADE_FIX_QUORUM_NOT_SUPPORTED     5974
#define ERROR_CLUSTER_UPGRADE_RESTART_REQUIRED             5975
#define ERROR_CLUSTER_UPGRADE_IN_PROGRESS                  5976
#define ERROR_CLUSTER_UPGRADE_INCOMPLETE                   5977
#define ERROR_CLUSTER_NODE_IN_GRACE_PERIOD                 5978
#define ERROR_CLUSTER_CSV_IO_PAUSE_TIMEOUT                 5979
#define ERROR_NODE_NOT_ACTIVE_CLUSTER_MEMBER               5980
#define ERROR_CLUSTER_RESOURCE_NOT_MONITORED               5981
#define ERROR_CLUSTER_RESOURCE_DOES_NOT_SUPPORT_UNMONITORED 5982
#define ERROR_CLUSTER_RESOURCE_IS_REPLICATED               5983
#define ERROR_CLUSTER_NODE_ISOLATED                        5984
#define ERROR_CLUSTER_NODE_QUARANTINED                     5985
#define ERROR_CLUSTER_DATABASE_UPDATE_CONDITION_FAILED     5986
#define ERROR_CLUSTER_SPACE_DEGRADED                       5987
#define ERROR_CLUSTER_TOKEN_DELEGATION_NOT_SUPPORTED       5988
#define ERROR_CLUSTER_CSV_INVALID_HANDLE                   5989
#define ERROR_CLUSTER_CSV_SUPPORTED_ONLY_ON_COORDINATOR    5990
#define ERROR_GROUPSET_NOT_AVAILABLE                       5991
#define ERROR_GROUPSET_NOT_FOUND                           5992
#define ERROR_GROUPSET_CANT_PROVIDE                        5993
#define ERROR_CLUSTER_FAULT_DOMAIN_PARENT_NOT_FOUND        5994
#define ERROR_CLUSTER_FAULT_DOMAIN_INVALID_HIERARCHY       5995
#define ERROR_CLUSTER_FAULT_DOMAIN_FAILED_S2D_VALIDATION   5996
#define ERROR_CLUSTER_FAULT_DOMAIN_S2D_CONNECTIVITY_LOSS   5997
#define ERROR_CLUSTER_INVALID_INFRASTRUCTURE_FILESERVER_NAME 5998
#define ERROR_CLUSTERSET_MANAGEMENT_CLUSTER_UNREACHABLE    5999
#define ERROR_ENCRYPTION_FAILED                            6000
#define ERROR_DECRYPTION_FAILED                            6001
#define ERROR_FILE_ENCRYPTED                               6002
#define ERROR_NO_RECOVERY_POLICY                           6003
#define ERROR_NO_EFS                                       6004
#define ERROR_WRONG_EFS                                    6005
#define ERROR_NO_USER_KEYS                                 6006
#define ERROR_FILE_NOT_ENCRYPTED                           6007
#define ERROR_NOT_EXPORT_FORMAT                            6008
#define ERROR_FILE_READ_ONLY                               6009
#define ERROR_DIR_EFS_DISALLOWED                           6010
#define ERROR_EFS_SERVER_NOT_TRUSTED                       6011
#define ERROR_BAD_RECOVERY_POLICY                          6012
#define ERROR_EFS_ALG_BLOB_TOO_BIG                         6013
#define ERROR_VOLUME_NOT_SUPPORT_EFS                       6014
#define ERROR_EFS_DISABLED                                 6015
#define ERROR_EFS_VERSION_NOT_SUPPORT                      6016
#define ERROR_CS_ENCRYPTION_INVALID_SERVER_RESPONSE        6017
#define ERROR_CS_ENCRYPTION_UNSUPPORTED_SERVER             6018
#define ERROR_CS_ENCRYPTION_EXISTING_ENCRYPTED_FILE        6019
#define ERROR_CS_ENCRYPTION_NEW_ENCRYPTED_FILE             6020
#define ERROR_CS_ENCRYPTION_FILE_NOT_CSE                   6021
#define ERROR_ENCRYPTION_POLICY_DENIES_OPERATION           6022
#define ERROR_WIP_ENCRYPTION_FAILED                        6023
#define ERROR_NO_BROWSER_SERVERS_FOUND                     6118
#define SCHED_E_SERVICE_NOT_LOCALSYSTEM                    6200
#define ERROR_CLUSTER_OBJECT_IS_CLUSTER_SET_VM             6250
#define ERROR_LOG_SECTOR_INVALID                           6600
#define ERROR_LOG_SECTOR_PARITY_INVALID                    6601
#define ERROR_LOG_SECTOR_REMAPPED                          6602
#define ERROR_LOG_BLOCK_INCOMPLETE                         6603
#define ERROR_LOG_INVALID_RANGE                            6604
#define ERROR_LOG_BLOCKS_EXHAUSTED                         6605
#define ERROR_LOG_READ_CONTEXT_INVALID                     6606
#define ERROR_LOG_RESTART_INVALID                          6607
#define ERROR_LOG_BLOCK_VERSION                            6608
#define ERROR_LOG_BLOCK_INVALID                            6609
#define ERROR_LOG_READ_MODE_INVALID                        6610
#define ERROR_LOG_NO_RESTART                               6611
#define ERROR_LOG_METADATA_CORRUPT                         6612
#define ERROR_LOG_METADATA_INVALID                         6613
#define ERROR_LOG_METADATA_INCONSISTENT                    6614
#define ERROR_LOG_RESERVATION_INVALID                      6615
#define ERROR_LOG_CANT_DELETE                              6616
#define ERROR_LOG_CONTAINER_LIMIT_EXCEEDED                 6617
#define ERROR_LOG_START_OF_LOG                             6618
#define ERROR_LOG_POLICY_ALREADY_INSTALLED                 6619
#define ERROR_LOG_POLICY_NOT_INSTALLED                     6620
#define ERROR_LOG_POLICY_INVALID                           6621
#define ERROR_LOG_POLICY_CONFLICT                          6622
#define ERROR_LOG_PINNED_ARCHIVE_TAIL                      6623
#define ERROR_LOG_RECORD_NONEXISTENT                       6624
#define ERROR_LOG_RECORDS_RESERVED_INVALID                 6625
#define ERROR_LOG_SPACE_RESERVED_INVALID                   6626
#define ERROR_LOG_TAIL_INVALID                             6627
#define ERROR_LOG_FULL                                     6628
#define ERROR_COULD_NOT_RESIZE_LOG                         6629
#define ERROR_LOG_MULTIPLEXED                              6630
#define ERROR_LOG_DEDICATED                                6631
#define ERROR_LOG_ARCHIVE_NOT_IN_PROGRESS                  6632
#define ERROR_LOG_ARCHIVE_IN_PROGRESS                      6633
#define ERROR_LOG_EPHEMERAL                                6634
#define ERROR_LOG_NOT_ENOUGH_CONTAINERS                    6635
#define ERROR_LOG_CLIENT_ALREADY_REGISTERED                6636
#define ERROR_LOG_CLIENT_NOT_REGISTERED                    6637
#define ERROR_LOG_FULL_HANDLER_IN_PROGRESS                 6638
#define ERROR_LOG_CONTAINER_READ_FAILED                    6639
#define ERROR_LOG_CONTAINER_WRITE_FAILED                   6640
#define ERROR_LOG_CONTAINER_OPEN_FAILED                    6641
#define ERROR_LOG_CONTAINER_STATE_INVALID                  6642
#define ERROR_LOG_STATE_INVALID                            6643
#define ERROR_LOG_PINNED                                   6644
#define ERROR_LOG_METADATA_FLUSH_FAILED                    6645
#define ERROR_LOG_INCONSISTENT_SECURITY                    6646
#define ERROR_LOG_APPENDED_FLUSH_FAILED                    6647
#define ERROR_LOG_PINNED_RESERVATION                       6648
#define ERROR_INVALID_TRANSACTION                          6700
#define ERROR_TRANSACTION_NOT_ACTIVE                       6701
#define ERROR_TRANSACTION_REQUEST_NOT_VALID                6702
#define ERROR_TRANSACTION_NOT_REQUESTED                    6703
#define ERROR_TRANSACTION_ALREADY_ABORTED                  6704
#define ERROR_TRANSACTION_ALREADY_COMMITTED                6705
#define ERROR_TM_INITIALIZATION_FAILED                     6706
#define ERROR_RESOURCEMANAGER_READ_ONLY                    6707
#define ERROR_TRANSACTION_NOT_JOINED                       6708
#define ERROR_TRANSACTION_SUPERIOR_EXISTS                  6709
#define ERROR_CRM_PROTOCOL_ALREADY_EXISTS                  6710
#define ERROR_TRANSACTION_PROPAGATION_FAILED               6711
#define ERROR_CRM_PROTOCOL_NOT_FOUND                       6712
#define ERROR_TRANSACTION_INVALID_MARSHALL_BUFFER          6713
#define ERROR_CURRENT_TRANSACTION_NOT_VALID                6714
#define ERROR_TRANSACTION_NOT_FOUND                        6715
#define ERROR_RESOURCEMANAGER_NOT_FOUND                    6716
#define ERROR_ENLISTMENT_NOT_FOUND                         6717
#define ERROR_TRANSACTIONMANAGER_NOT_FOUND                 6718
#define ERROR_TRANSACTIONMANAGER_NOT_ONLINE                6719
#define ERROR_TRANSACTIONMANAGER_RECOVERY_NAME_COLLISION   6720
#define ERROR_TRANSACTION_NOT_ROOT                         6721
#define ERROR_TRANSACTION_OBJECT_EXPIRED                   6722
#define ERROR_TRANSACTION_RESPONSE_NOT_ENLISTED            6723
#define ERROR_TRANSACTION_RECORD_TOO_LONG                  6724
#define ERROR_IMPLICIT_TRANSACTION_NOT_SUPPORTED           6725
#define ERROR_TRANSACTION_INTEGRITY_VIOLATED               6726
#define ERROR_TRANSACTIONMANAGER_IDENTITY_MISMATCH         6727
#define ERROR_RM_CANNOT_BE_FROZEN_FOR_SNAPSHOT             6728
#define ERROR_TRANSACTION_MUST_WRITETHROUGH                6729
#define ERROR_TRANSACTION_NO_SUPERIOR                      6730
#define ERROR_HEURISTIC_DAMAGE_POSSIBLE                    6731
#define ERROR_TRANSACTIONAL_CONFLICT                       6800
#define ERROR_RM_NOT_ACTIVE                                6801
#define ERROR_RM_METADATA_CORRUPT                          6802
#define ERROR_DIRECTORY_NOT_RM                             6803
#define ERROR_TRANSACTIONS_UNSUPPORTED_REMOTE              6805
#define ERROR_LOG_RESIZE_INVALID_SIZE                      6806
#define ERROR_OBJECT_NO_LONGER_EXISTS                      6807
#define ERROR_STREAM_MINIVERSION_NOT_FOUND                 6808
#define ERROR_STREAM_MINIVERSION_NOT_VALID                 6809
#define ERROR_MINIVERSION_INACCESSIBLE_FROM_SPECIFIED_TRANSACTION 6810
#define ERROR_CANT_OPEN_MINIVERSION_WITH_MODIFY_INTENT     6811
#define ERROR_CANT_CREATE_MORE_STREAM_MINIVERSIONS         6812
#define ERROR_REMOTE_FILE_VERSION_MISMATCH                 6814
#define ERROR_HANDLE_NO_LONGER_VALID                       6815
#define ERROR_NO_TXF_METADATA                              6816
#define ERROR_LOG_CORRUPTION_DETECTED                      6817
#define ERROR_CANT_RECOVER_WITH_HANDLE_OPEN                6818
#define ERROR_RM_DISCONNECTED                              6819
#define ERROR_ENLISTMENT_NOT_SUPERIOR                      6820
#define ERROR_RECOVERY_NOT_NEEDED                          6821
#define ERROR_RM_ALREADY_STARTED                           6822
#define ERROR_FILE_IDENTITY_NOT_PERSISTENT                 6823
#define ERROR_CANT_BREAK_TRANSACTIONAL_DEPENDENCY          6824
#define ERROR_CANT_CROSS_RM_BOUNDARY                       6825
#define ERROR_TXF_DIR_NOT_EMPTY                            6826
#define ERROR_INDOUBT_TRANSACTIONS_EXIST                   6827
#define ERROR_TM_VOLATILE                                  6828
#define ERROR_ROLLBACK_TIMER_EXPIRED                       6829
#define ERROR_TXF_ATTRIBUTE_CORRUPT                        6830
#define ERROR_EFS_NOT_ALLOWED_IN_TRANSACTION               6831
#define ERROR_TRANSACTIONAL_OPEN_NOT_ALLOWED               6832
#define ERROR_LOG_GROWTH_FAILED                            6833
#define ERROR_TRANSACTED_MAPPING_UNSUPPORTED_REMOTE        6834
#define ERROR_TXF_METADATA_ALREADY_PRESENT                 6835
#define ERROR_TRANSACTION_SCOPE_CALLBACKS_NOT_SET          6836
#define ERROR_TRANSACTION_REQUIRED_PROMOTION               6837
#define ERROR_CANNOT_EXECUTE_FILE_IN_TRANSACTION           6838
#define ERROR_TRANSACTIONS_NOT_FROZEN                      6839
#define ERROR_TRANSACTION_FREEZE_IN_PROGRESS               6840
#define ERROR_NOT_SNAPSHOT_VOLUME                          6841
#define ERROR_NO_SAVEPOINT_WITH_OPEN_FILES                 6842
#define ERROR_DATA_LOST_REPAIR                             6843
#define ERROR_SPARSE_NOT_ALLOWED_IN_TRANSACTION            6844
#define ERROR_TM_IDENTITY_MISMATCH                         6845
#define ERROR_FLOATED_SECTION                              6846
#define ERROR_CANNOT_ACCEPT_TRANSACTED_WORK                6847
#define ERROR_CANNOT_ABORT_TRANSACTIONS                    6848
#define ERROR_BAD_CLUSTERS                                 6849
#define ERROR_COMPRESSION_NOT_ALLOWED_IN_TRANSACTION       6850
#define ERROR_VOLUME_DIRTY                                 6851
#define ERROR_NO_LINK_TRACKING_IN_TRANSACTION              6852
#define ERROR_OPERATION_NOT_SUPPORTED_IN_TRANSACTION       6853
#define ERROR_EXPIRED_HANDLE                               6854
#define ERROR_TRANSACTION_NOT_ENLISTED                     6855
#define ERROR_CTX_WINSTATION_NAME_INVALID                  7001
#define ERROR_CTX_INVALID_PD                               7002
#define ERROR_CTX_PD_NOT_FOUND                             7003
#define ERROR_CTX_WD_NOT_FOUND                             7004
#define ERROR_CTX_CANNOT_MAKE_EVENTLOG_ENTRY               7005
#define ERROR_CTX_SERVICE_NAME_COLLISION                   7006
#define ERROR_CTX_CLOSE_PENDING                            7007
#define ERROR_CTX_NO_OUTBUF                                7008
#define ERROR_CTX_MODEM_INF_NOT_FOUND                      7009
#define ERROR_CTX_INVALID_MODEMNAME                        7010
#define ERROR_CTX_MODEM_RESPONSE_ERROR                     7011
#define ERROR_CTX_MODEM_RESPONSE_TIMEOUT                   7012
#define ERROR_CTX_MODEM_RESPONSE_NO_CARRIER                7013
#define ERROR_CTX_MODEM_RESPONSE_NO_DIALTONE               7014
#define ERROR_CTX_MODEM_RESPONSE_BUSY                      7015
#define ERROR_CTX_MODEM_RESPONSE_VOICE                     7016
#define ERROR_CTX_TD_ERROR                                 7017
#define ERROR_CTX_WINSTATION_NOT_FOUND                     7022
#define ERROR_CTX_WINSTATION_ALREADY_EXISTS                7023
#define ERROR_CTX_WINSTATION_BUSY                          7024
#define ERROR_CTX_BAD_VIDEO_MODE                           7025
#define ERROR_CTX_GRAPHICS_INVALID                         7035
#define ERROR_CTX_LOGON_DISABLED                           7037
#define ERROR_CTX_NOT_CONSOLE                              7038
#define ERROR_CTX_CLIENT_QUERY_TIMEOUT                     7040
#define ERROR_CTX_CONSOLE_DISCONNECT                       7041
#define ERROR_CTX_CONSOLE_CONNECT                          7042
#define ERROR_CTX_SHADOW_DENIED                            7044
#define ERROR_CTX_WINSTATION_ACCESS_DENIED                 7045
#define ERROR_CTX_INVALID_WD                               7049
#define ERROR_CTX_SHADOW_INVALID                           7050
#define ERROR_CTX_SHADOW_DISABLED                          7051
#define ERROR_CTX_CLIENT_LICENSE_IN_USE                    7052
#define ERROR_CTX_CLIENT_LICENSE_NOT_SET                   7053
#define ERROR_CTX_LICENSE_NOT_AVAILABLE                    7054
#define ERROR_CTX_LICENSE_CLIENT_INVALID                   7055
#define ERROR_CTX_LICENSE_EXPIRED                          7056
#define ERROR_CTX_SHADOW_NOT_RUNNING                       7057
#define ERROR_CTX_SHADOW_ENDED_BY_MODE_CHANGE              7058
#define ERROR_ACTIVATION_COUNT_EXCEEDED                    7059
#define ERROR_CTX_WINSTATIONS_DISABLED                     7060
#define ERROR_CTX_ENCRYPTION_LEVEL_REQUIRED                7061
#define ERROR_CTX_SESSION_IN_USE                           7062
#define ERROR_CTX_NO_FORCE_LOGOFF                          7063
#define ERROR_CTX_ACCOUNT_RESTRICTION                      7064
#define ERROR_RDP_PROTOCOL_ERROR                           7065
#define ERROR_CTX_CDM_CONNECT                              7066
#define ERROR_CTX_CDM_DISCONNECT                           7067
#define ERROR_CTX_SECURITY_LAYER_ERROR                     7068
#define ERROR_TS_INCOMPATIBLE_SESSIONS                     7069
#define ERROR_TS_VIDEO_SUBSYSTEM_ERROR                     7070
#define FRS_ERR_INVALID_API_SEQUENCE                       8001
#define FRS_ERR_STARTING_SERVICE                           8002
#define FRS_ERR_STOPPING_SERVICE                           8003
#define FRS_ERR_INTERNAL_API                               8004
#define FRS_ERR_INTERNAL                                   8005
#define FRS_ERR_SERVICE_COMM                               8006
#define FRS_ERR_INSUFFICIENT_PRIV                          8007
#define FRS_ERR_AUTHENTICATION                             8008
#define FRS_ERR_PARENT_INSUFFICIENT_PRIV                   8009
#define FRS_ERR_PARENT_AUTHENTICATION                      8010
#define FRS_ERR_CHILD_TO_PARENT_COMM                       8011
#define FRS_ERR_PARENT_TO_CHILD_COMM                       8012
#define FRS_ERR_SYSVOL_POPULATE                            8013
#define FRS_ERR_SYSVOL_POPULATE_TIMEOUT                    8014
#define FRS_ERR_SYSVOL_IS_BUSY                             8015
#define FRS_ERR_SYSVOL_DEMOTE                              8016
#define FRS_ERR_INVALID_SERVICE_PARAMETER                  8017
#define ERROR_DS_NOT_INSTALLED                             8200
#define ERROR_DS_MEMBERSHIP_EVALUATED_LOCALLY              8201
#define ERROR_DS_NO_ATTRIBUTE_OR_VALUE                     8202
#define ERROR_DS_INVALID_ATTRIBUTE_SYNTAX                  8203
#define ERROR_DS_ATTRIBUTE_TYPE_UNDEFINED                  8204
#define ERROR_DS_ATTRIBUTE_OR_VALUE_EXISTS                 8205
#define ERROR_DS_BUSY                                      8206
#define ERROR_DS_UNAVAILABLE                               8207
#define ERROR_DS_NO_RIDS_ALLOCATED                         8208
#define ERROR_DS_NO_MORE_RIDS                              8209
#define ERROR_DS_INCORRECT_ROLE_OWNER                      8210
#define ERROR_DS_RIDMGR_INIT_ERROR                         8211
#define ERROR_DS_OBJ_CLASS_VIOLATION                       8212
#define ERROR_DS_CANT_ON_NON_LEAF                          8213
#define ERROR_DS_CANT_ON_RDN                               8214
#define ERROR_DS_CANT_MOD_OBJ_CLASS                        8215
#define ERROR_DS_CROSS_DOM_MOVE_ERROR                      8216
#define ERROR_DS_GC_NOT_AVAILABLE                          8217
#define ERROR_SHARED_POLICY                                8218
#define ERROR_POLICY_OBJECT_NOT_FOUND                      8219
#define ERROR_POLICY_ONLY_IN_DS                            8220
#define ERROR_PROMOTION_ACTIVE                             8221
#define ERROR_NO_PROMOTION_ACTIVE                          8222
#define ERROR_DS_OPERATIONS_ERROR                          8224
#define ERROR_DS_PROTOCOL_ERROR                            8225
#define ERROR_DS_TIMELIMIT_EXCEEDED                        8226
#define ERROR_DS_SIZELIMIT_EXCEEDED                        8227
#define ERROR_DS_ADMIN_LIMIT_EXCEEDED                      8228
#define ERROR_DS_COMPARE_FALSE                             8229
#define ERROR_DS_COMPARE_TRUE                              8230
#define ERROR_DS_AUTH_METHOD_NOT_SUPPORTED                 8231
#define ERROR_DS_STRONG_AUTH_REQUIRED                      8232
#define ERROR_DS_INAPPROPRIATE_AUTH                        8233
#define ERROR_DS_AUTH_UNKNOWN                              8234
#define ERROR_DS_REFERRAL                                  8235
#define ERROR_DS_UNAVAILABLE_CRIT_EXTENSION                8236
#define ERROR_DS_CONFIDENTIALITY_REQUIRED                  8237
#define ERROR_DS_INAPPROPRIATE_MATCHING                    8238
#define ERROR_DS_CONSTRAINT_VIOLATION                      8239
#define ERROR_DS_NO_SUCH_OBJECT                            8240
#define ERROR_DS_ALIAS_PROBLEM                             8241
#define ERROR_DS_INVALID_DN_SYNTAX                         8242
#define ERROR_DS_IS_LEAF                                   8243
#define ERROR_DS_ALIAS_DEREF_PROBLEM                       8244
#define ERROR_DS_UNWILLING_TO_PERFORM                      8245
#define ERROR_DS_LOOP_DETECT                               8246
#define ERROR_DS_NAMING_VIOLATION                          8247
#define ERROR_DS_OBJECT_RESULTS_TOO_LARGE                  8248
#define ERROR_DS_AFFECTS_MULTIPLE_DSAS                     8249
#define ERROR_DS_SERVER_DOWN                               8250
#define ERROR_DS_LOCAL_ERROR                               8251
#define ERROR_DS_ENCODING_ERROR                            8252
#define ERROR_DS_DECODING_ERROR                            8253
#define ERROR_DS_FILTER_UNKNOWN                            8254
#define ERROR_DS_PARAM_ERROR                               8255
#define ERROR_DS_NOT_SUPPORTED                             8256
#define ERROR_DS_NO_RESULTS_RETURNED                       8257
#define ERROR_DS_CONTROL_NOT_FOUND                         8258
#define ERROR_DS_CLIENT_LOOP                               8259
#define ERROR_DS_REFERRAL_LIMIT_EXCEEDED                   8260
#define ERROR_DS_SORT_CONTROL_MISSING                      8261
#define ERROR_DS_OFFSET_RANGE_ERROR                        8262
#define ERROR_DS_RIDMGR_DISABLED                           8263
#define ERROR_DS_ROOT_MUST_BE_NC                           8301
#define ERROR_DS_ADD_REPLICA_INHIBITED                     8302
#define ERROR_DS_ATT_NOT_DEF_IN_SCHEMA                     8303
#define ERROR_DS_MAX_OBJ_SIZE_EXCEEDED                     8304
#define ERROR_DS_OBJ_STRING_NAME_EXISTS                    8305
#define ERROR_DS_NO_RDN_DEFINED_IN_SCHEMA                  8306
#define ERROR_DS_RDN_DOESNT_MATCH_SCHEMA                   8307
#define ERROR_DS_NO_REQUESTED_ATTS_FOUND                   8308
#define ERROR_DS_USER_BUFFER_TO_SMALL                      8309
#define ERROR_DS_ATT_IS_NOT_ON_OBJ                         8310
#define ERROR_DS_ILLEGAL_MOD_OPERATION                     8311
#define ERROR_DS_OBJ_TOO_LARGE                             8312
#define ERROR_DS_BAD_INSTANCE_TYPE                         8313
#define ERROR_DS_MASTERDSA_REQUIRED                        8314
#define ERROR_DS_OBJECT_CLASS_REQUIRED                     8315
#define ERROR_DS_MISSING_REQUIRED_ATT                      8316
#define ERROR_DS_ATT_NOT_DEF_FOR_CLASS                     8317
#define ERROR_DS_ATT_ALREADY_EXISTS                        8318
#define ERROR_DS_CANT_ADD_ATT_VALUES                       8320
#define ERROR_DS_SINGLE_VALUE_CONSTRAINT                   8321
#define ERROR_DS_RANGE_CONSTRAINT                          8322
#define ERROR_DS_ATT_VAL_ALREADY_EXISTS                    8323
#define ERROR_DS_CANT_REM_MISSING_ATT                      8324
#define ERROR_DS_CANT_REM_MISSING_ATT_VAL                  8325
#define ERROR_DS_ROOT_CANT_BE_SUBREF                       8326
#define ERROR_DS_NO_CHAINING                               8327
#define ERROR_DS_NO_CHAINED_EVAL                           8328
#define ERROR_DS_NO_PARENT_OBJECT                          8329
#define ERROR_DS_PARENT_IS_AN_ALIAS                        8330
#define ERROR_DS_CANT_MIX_MASTER_AND_REPS                  8331
#define ERROR_DS_CHILDREN_EXIST                            8332
#define ERROR_DS_OBJ_NOT_FOUND                             8333
#define ERROR_DS_ALIASED_OBJ_MISSING                       8334
#define ERROR_DS_BAD_NAME_SYNTAX                           8335
#define ERROR_DS_ALIAS_POINTS_TO_ALIAS                     8336
#define ERROR_DS_CANT_DEREF_ALIAS                          8337
#define ERROR_DS_OUT_OF_SCOPE                              8338
#define ERROR_DS_OBJECT_BEING_REMOVED                      8339
#define ERROR_DS_CANT_DELETE_DSA_OBJ                       8340
#define ERROR_DS_GENERIC_ERROR                             8341
#define ERROR_DS_DSA_MUST_BE_INT_MASTER                    8342
#define ERROR_DS_CLASS_NOT_DSA                             8343
#define ERROR_DS_INSUFF_ACCESS_RIGHTS                      8344
#define ERROR_DS_ILLEGAL_SUPERIOR                          8345
#define ERROR_DS_ATTRIBUTE_OWNED_BY_SAM                    8346
#define ERROR_DS_NAME_TOO_MANY_PARTS                       8347
#define ERROR_DS_NAME_TOO_LONG                             8348
#define ERROR_DS_NAME_VALUE_TOO_LONG                       8349
#define ERROR_DS_NAME_UNPARSEABLE                          8350
#define ERROR_DS_NAME_TYPE_UNKNOWN                         8351
#define ERROR_DS_NOT_AN_OBJECT                             8352
#define ERROR_DS_SEC_DESC_TOO_SHORT                        8353
#define ERROR_DS_SEC_DESC_INVALID                          8354
#define ERROR_DS_NO_DELETED_NAME                           8355
#define ERROR_DS_SUBREF_MUST_HAVE_PARENT                   8356
#define ERROR_DS_NCNAME_MUST_BE_NC                         8357
#define ERROR_DS_CANT_ADD_SYSTEM_ONLY                      8358
#define ERROR_DS_CLASS_MUST_BE_CONCRETE                    8359
#define ERROR_DS_INVALID_DMD                               8360
#define ERROR_DS_OBJ_GUID_EXISTS                           8361
#define ERROR_DS_NOT_ON_BACKLINK                           8362
#define ERROR_DS_NO_CROSSREF_FOR_NC                        8363
#define ERROR_DS_SHUTTING_DOWN                             8364
#define ERROR_DS_UNKNOWN_OPERATION                         8365
#define ERROR_DS_INVALID_ROLE_OWNER                        8366
#define ERROR_DS_COULDNT_CONTACT_FSMO                      8367
#define ERROR_DS_CROSS_NC_DN_RENAME                        8368
#define ERROR_DS_CANT_MOD_SYSTEM_ONLY                      8369
#define ERROR_DS_REPLICATOR_ONLY                           8370
#define ERROR_DS_OBJ_CLASS_NOT_DEFINED                     8371
#define ERROR_DS_OBJ_CLASS_NOT_SUBCLASS                    8372
#define ERROR_DS_NAME_REFERENCE_INVALID                    8373
#define ERROR_DS_CROSS_REF_EXISTS                          8374
#define ERROR_DS_CANT_DEL_MASTER_CROSSREF                  8375
#define ERROR_DS_SUBTREE_NOTIFY_NOT_NC_HEAD                8376
#define ERROR_DS_NOTIFY_FILTER_TOO_COMPLEX                 8377
#define ERROR_DS_DUP_RDN                                   8378
#define ERROR_DS_DUP_OID                                   8379
#define ERROR_DS_DUP_MAPI_ID                               8380
#define ERROR_DS_DUP_SCHEMA_ID_GUID                        8381
#define ERROR_DS_DUP_LDAP_DISPLAY_NAME                     8382
#define ERROR_DS_SEMANTIC_ATT_TEST                         8383
#define ERROR_DS_SYNTAX_MISMATCH                           8384
#define ERROR_DS_EXISTS_IN_MUST_HAVE                       8385
#define ERROR_DS_EXISTS_IN_MAY_HAVE                        8386
#define ERROR_DS_NONEXISTENT_MAY_HAVE                      8387
#define ERROR_DS_NONEXISTENT_MUST_HAVE                     8388
#define ERROR_DS_AUX_CLS_TEST_FAIL                         8389
#define ERROR_DS_NONEXISTENT_POSS_SUP                      8390
#define ERROR_DS_SUB_CLS_TEST_FAIL                         8391
#define ERROR_DS_BAD_RDN_ATT_ID_SYNTAX                     8392
#define ERROR_DS_EXISTS_IN_AUX_CLS                         8393
#define ERROR_DS_EXISTS_IN_SUB_CLS                         8394
#define ERROR_DS_EXISTS_IN_POSS_SUP                        8395
#define ERROR_DS_RECALCSCHEMA_FAILED                       8396
#define ERROR_DS_TREE_DELETE_NOT_FINISHED                  8397
#define ERROR_DS_CANT_DELETE                               8398
#define ERROR_DS_ATT_SCHEMA_REQ_ID                         8399
#define ERROR_DS_BAD_ATT_SCHEMA_SYNTAX                     8400
#define ERROR_DS_CANT_CACHE_ATT                            8401
#define ERROR_DS_CANT_CACHE_CLASS                          8402
#define ERROR_DS_CANT_REMOVE_ATT_CACHE                     8403
#define ERROR_DS_CANT_REMOVE_CLASS_CACHE                   8404
#define ERROR_DS_CANT_RETRIEVE_DN                          8405
#define ERROR_DS_MISSING_SUPREF                            8406
#define ERROR_DS_CANT_RETRIEVE_INSTANCE                    8407
#define ERROR_DS_CODE_INCONSISTENCY                        8408
#define ERROR_DS_DATABASE_ERROR                            8409
#define ERROR_DS_GOVERNSID_MISSING                         8410
#define ERROR_DS_MISSING_EXPECTED_ATT                      8411
#define ERROR_DS_NCNAME_MISSING_CR_REF                     8412
#define ERROR_DS_SECURITY_CHECKING_ERROR                   8413
#define ERROR_DS_SCHEMA_NOT_LOADED                         8414
#define ERROR_DS_SCHEMA_ALLOC_FAILED                       8415
#define ERROR_DS_ATT_SCHEMA_REQ_SYNTAX                     8416
#define ERROR_DS_GCVERIFY_ERROR                            8417
#define ERROR_DS_DRA_SCHEMA_MISMATCH                       8418
#define ERROR_DS_CANT_FIND_DSA_OBJ                         8419
#define ERROR_DS_CANT_FIND_EXPECTED_NC                     8420
#define ERROR_DS_CANT_FIND_NC_IN_CACHE                     8421
#define ERROR_DS_CANT_RETRIEVE_CHILD                       8422
#define ERROR_DS_SECURITY_ILLEGAL_MODIFY                   8423
#define ERROR_DS_CANT_REPLACE_HIDDEN_REC                   8424
#define ERROR_DS_BAD_HIERARCHY_FILE                        8425
#define ERROR_DS_BUILD_HIERARCHY_TABLE_FAILED              8426
#define ERROR_DS_CONFIG_PARAM_MISSING                      8427
#define ERROR_DS_COUNTING_AB_INDICES_FAILED                8428
#define ERROR_DS_HIERARCHY_TABLE_MALLOC_FAILED             8429
#define ERROR_DS_INTERNAL_FAILURE                          8430
#define ERROR_DS_UNKNOWN_ERROR                             8431
#define ERROR_DS_ROOT_REQUIRES_CLASS_TOP                   8432
#define ERROR_DS_REFUSING_FSMO_ROLES                       8433
#define ERROR_DS_MISSING_FSMO_SETTINGS                     8434
#define ERROR_DS_UNABLE_TO_SURRENDER_ROLES                 8435
#define ERROR_DS_DRA_GENERIC                               8436
#define ERROR_DS_DRA_INVALID_PARAMETER                     8437
#define ERROR_DS_DRA_BUSY                                  8438
#define ERROR_DS_DRA_BAD_DN                                8439
#define ERROR_DS_DRA_BAD_NC                                8440
#define ERROR_DS_DRA_DN_EXISTS                             8441
#define ERROR_DS_DRA_INTERNAL_ERROR                        8442
#define ERROR_DS_DRA_INCONSISTENT_DIT                      8443
#define ERROR_DS_DRA_CONNECTION_FAILED                     8444
#define ERROR_DS_DRA_BAD_INSTANCE_TYPE                     8445
#define ERROR_DS_DRA_OUT_OF_MEM                            8446
#define ERROR_DS_DRA_MAIL_PROBLEM                          8447
#define ERROR_DS_DRA_REF_ALREADY_EXISTS                    8448
#define ERROR_DS_DRA_REF_NOT_FOUND                         8449
#define ERROR_DS_DRA_OBJ_IS_REP_SOURCE                     8450
#define ERROR_DS_DRA_DB_ERROR                              8451
#define ERROR_DS_DRA_NO_REPLICA                            8452
#define ERROR_DS_DRA_ACCESS_DENIED                         8453
#define ERROR_DS_DRA_NOT_SUPPORTED                         8454
#define ERROR_DS_DRA_RPC_CANCELLED                         8455
#define ERROR_DS_DRA_SOURCE_DISABLED                       8456
#define ERROR_DS_DRA_SINK_DISABLED                         8457
#define ERROR_DS_DRA_NAME_COLLISION                        8458
#define ERROR_DS_DRA_SOURCE_REINSTALLED                    8459
#define ERROR_DS_DRA_MISSING_PARENT                        8460
#define ERROR_DS_DRA_PREEMPTED                             8461
#define ERROR_DS_DRA_ABANDON_SYNC                          8462
#define ERROR_DS_DRA_SHUTDOWN                              8463
#define ERROR_DS_DRA_INCOMPATIBLE_PARTIAL_SET              8464
#define ERROR_DS_DRA_SOURCE_IS_PARTIAL_REPLICA             8465
#define ERROR_DS_DRA_EXTN_CONNECTION_FAILED                8466
#define ERROR_DS_INSTALL_SCHEMA_MISMATCH                   8467
#define ERROR_DS_DUP_LINK_ID                               8468
#define ERROR_DS_NAME_ERROR_RESOLVING                      8469
#define ERROR_DS_NAME_ERROR_NOT_FOUND                      8470
#define ERROR_DS_NAME_ERROR_NOT_UNIQUE                     8471
#define ERROR_DS_NAME_ERROR_NO_MAPPING                     8472
#define ERROR_DS_NAME_ERROR_DOMAIN_ONLY                    8473
#define ERROR_DS_NAME_ERROR_NO_SYNTACTICAL_MAPPING         8474
#define ERROR_DS_CONSTRUCTED_ATT_MOD                       8475
#define ERROR_DS_WRONG_OM_OBJ_CLASS                        8476
#define ERROR_DS_DRA_REPL_PENDING                          8477
#define ERROR_DS_DS_REQUIRED                               8478
#define ERROR_DS_INVALID_LDAP_DISPLAY_NAME                 8479
#define ERROR_DS_NON_BASE_SEARCH                           8480
#define ERROR_DS_CANT_RETRIEVE_ATTS                        8481
#define ERROR_DS_BACKLINK_WITHOUT_LINK                     8482
#define ERROR_DS_EPOCH_MISMATCH                            8483
#define ERROR_DS_SRC_NAME_MISMATCH                         8484
#define ERROR_DS_SRC_AND_DST_NC_IDENTICAL                  8485
#define ERROR_DS_DST_NC_MISMATCH                           8486
#define ERROR_DS_NOT_AUTHORITIVE_FOR_DST_NC                8487
#define ERROR_DS_SRC_GUID_MISMATCH                         8488
#define ERROR_DS_CANT_MOVE_DELETED_OBJECT                  8489
#define ERROR_DS_PDC_OPERATION_IN_PROGRESS                 8490
#define ERROR_DS_CROSS_DOMAIN_CLEANUP_REQD                 8491
#define ERROR_DS_ILLEGAL_XDOM_MOVE_OPERATION               8492
#define ERROR_DS_CANT_WITH_ACCT_GROUP_MEMBERSHPS           8493
#define ERROR_DS_NC_MUST_HAVE_NC_PARENT                    8494
#define ERROR_DS_CR_IMPOSSIBLE_TO_VALIDATE                 8495
#define ERROR_DS_DST_DOMAIN_NOT_NATIVE                     8496
#define ERROR_DS_MISSING_INFRASTRUCTURE_CONTAINER          8497
#define ERROR_DS_CANT_MOVE_ACCOUNT_GROUP                   8498
#define ERROR_DS_CANT_MOVE_RESOURCE_GROUP                  8499
#define ERROR_DS_INVALID_SEARCH_FLAG                       8500
#define ERROR_DS_NO_TREE_DELETE_ABOVE_NC                   8501
#define ERROR_DS_COULDNT_LOCK_TREE_FOR_DELETE              8502
#define ERROR_DS_COULDNT_IDENTIFY_OBJECTS_FOR_TREE_DELETE  8503
#define ERROR_DS_SAM_INIT_FAILURE                          8504
#define ERROR_DS_SENSITIVE_GROUP_VIOLATION                 8505
#define ERROR_DS_CANT_MOD_PRIMARYGROUPID                   8506
#define ERROR_DS_ILLEGAL_BASE_SCHEMA_MOD                   8507
#define ERROR_DS_NONSAFE_SCHEMA_CHANGE                     8508
#define ERROR_DS_SCHEMA_UPDATE_DISALLOWED                  8509
#define ERROR_DS_CANT_CREATE_UNDER_SCHEMA                  8510
#define ERROR_DS_INSTALL_NO_SRC_SCH_VERSION                8511
#define ERROR_DS_INSTALL_NO_SCH_VERSION_IN_INIFILE         8512
#define ERROR_DS_INVALID_GROUP_TYPE                        8513
#define ERROR_DS_NO_NEST_GLOBALGROUP_IN_MIXEDDOMAIN        8514
#define ERROR_DS_NO_NEST_LOCALGROUP_IN_MIXEDDOMAIN         8515
#define ERROR_DS_GLOBAL_CANT_HAVE_LOCAL_MEMBER             8516
#define ERROR_DS_GLOBAL_CANT_HAVE_UNIVERSAL_MEMBER         8517
#define ERROR_DS_UNIVERSAL_CANT_HAVE_LOCAL_MEMBER          8518
#define ERROR_DS_GLOBAL_CANT_HAVE_CROSSDOMAIN_MEMBER       8519
#define ERROR_DS_LOCAL_CANT_HAVE_CROSSDOMAIN_LOCAL_MEMBER  8520
#define ERROR_DS_HAVE_PRIMARY_MEMBERS                      8521
#define ERROR_DS_STRING_SD_CONVERSION_FAILED               8522
#define ERROR_DS_NAMING_MASTER_GC                          8523
#define ERROR_DS_DNS_LOOKUP_FAILURE                        8524
#define ERROR_DS_COULDNT_UPDATE_SPNS                       8525
#define ERROR_DS_CANT_RETRIEVE_SD                          8526
#define ERROR_DS_KEY_NOT_UNIQUE                            8527
#define ERROR_DS_WRONG_LINKED_ATT_SYNTAX                   8528
#define ERROR_DS_SAM_NEED_BOOTKEY_PASSWORD                 8529
#define ERROR_DS_SAM_NEED_BOOTKEY_FLOPPY                   8530
#define ERROR_DS_CANT_START                                8531
#define ERROR_DS_INIT_FAILURE                              8532
#define ERROR_DS_NO_PKT_PRIVACY_ON_CONNECTION              8533
#define ERROR_DS_SOURCE_DOMAIN_IN_FOREST                   8534
#define ERROR_DS_DESTINATION_DOMAIN_NOT_IN_FOREST          8535
#define ERROR_DS_DESTINATION_AUDITING_NOT_ENABLED          8536
#define ERROR_DS_CANT_FIND_DC_FOR_SRC_DOMAIN               8537
#define ERROR_DS_SRC_OBJ_NOT_GROUP_OR_USER                 8538
#define ERROR_DS_SRC_SID_EXISTS_IN_FOREST                  8539
#define ERROR_DS_SRC_AND_DST_OBJECT_CLASS_MISMATCH         8540
#define ERROR_SAM_INIT_FAILURE                             8541
#define ERROR_DS_DRA_SCHEMA_INFO_SHIP                      8542
#define ERROR_DS_DRA_SCHEMA_CONFLICT                       8543
#define ERROR_DS_DRA_EARLIER_SCHEMA_CONFLICT               8544
#define ERROR_DS_DRA_OBJ_NC_MISMATCH                       8545
#define ERROR_DS_NC_STILL_HAS_DSAS                         8546
#define ERROR_DS_GC_REQUIRED                               8547
#define ERROR_DS_LOCAL_MEMBER_OF_LOCAL_ONLY                8548
#define ERROR_DS_NO_FPO_IN_UNIVERSAL_GROUPS                8549
#define ERROR_DS_CANT_ADD_TO_GC                            8550
#define ERROR_DS_NO_CHECKPOINT_WITH_PDC                    8551
#define ERROR_DS_SOURCE_AUDITING_NOT_ENABLED               8552
#define ERROR_DS_CANT_CREATE_IN_NONDOMAIN_NC               8553
#define ERROR_DS_INVALID_NAME_FOR_SPN                      8554
#define ERROR_DS_FILTER_USES_CONTRUCTED_ATTRS              8555
#define ERROR_DS_UNICODEPWD_NOT_IN_QUOTES                  8556
#define ERROR_DS_MACHINE_ACCOUNT_QUOTA_EXCEEDED            8557
#define ERROR_DS_MUST_BE_RUN_ON_DST_DC                     8558
#define ERROR_DS_SRC_DC_MUST_BE_SP4_OR_GREATER             8559
#define ERROR_DS_CANT_TREE_DELETE_CRITICAL_OBJ             8560
#define ERROR_DS_INIT_FAILURE_CONSOLE                      8561
#define ERROR_DS_SAM_INIT_FAILURE_CONSOLE                  8562
#define ERROR_DS_FOREST_VERSION_TOO_HIGH                   8563
#define ERROR_DS_DOMAIN_VERSION_TOO_HIGH                   8564
#define ERROR_DS_FOREST_VERSION_TOO_LOW                    8565
#define ERROR_DS_DOMAIN_VERSION_TOO_LOW                    8566
#define ERROR_DS_INCOMPATIBLE_VERSION                      8567
#define ERROR_DS_LOW_DSA_VERSION                           8568
#define ERROR_DS_NO_BEHAVIOR_VERSION_IN_MIXEDDOMAIN        8569
#define ERROR_DS_NOT_SUPPORTED_SORT_ORDER                  8570
#define ERROR_DS_NAME_NOT_UNIQUE                           8571
#define ERROR_DS_MACHINE_ACCOUNT_CREATED_PRENT4            8572
#define ERROR_DS_OUT_OF_VERSION_STORE                      8573
#define ERROR_DS_INCOMPATIBLE_CONTROLS_USED                8574
#define ERROR_DS_NO_REF_DOMAIN                             8575
#define ERROR_DS_RESERVED_LINK_ID                          8576
#define ERROR_DS_LINK_ID_NOT_AVAILABLE                     8577
#define ERROR_DS_AG_CANT_HAVE_UNIVERSAL_MEMBER             8578
#define ERROR_DS_MODIFYDN_DISALLOWED_BY_INSTANCE_TYPE      8579
#define ERROR_DS_NO_OBJECT_MOVE_IN_SCHEMA_NC               8580
#define ERROR_DS_MODIFYDN_DISALLOWED_BY_FLAG               8581
#define ERROR_DS_MODIFYDN_WRONG_GRANDPARENT                8582
#define ERROR_DS_NAME_ERROR_TRUST_REFERRAL                 8583
#define ERROR_NOT_SUPPORTED_ON_STANDARD_SERVER             8584
#define ERROR_DS_CANT_ACCESS_REMOTE_PART_OF_AD             8585
#define ERROR_DS_CR_IMPOSSIBLE_TO_VALIDATE_V2              8586
#define ERROR_DS_THREAD_LIMIT_EXCEEDED                     8587
#define ERROR_DS_NOT_CLOSEST                               8588
#define ERROR_DS_CANT_DERIVE_SPN_WITHOUT_SERVER_REF        8589
#define ERROR_DS_SINGLE_USER_MODE_FAILED                   8590
#define ERROR_DS_NTDSCRIPT_SYNTAX_ERROR                    8591
#define ERROR_DS_NTDSCRIPT_PROCESS_ERROR                   8592
#define ERROR_DS_DIFFERENT_REPL_EPOCHS                     8593
#define ERROR_DS_DRS_EXTENSIONS_CHANGED                    8594
#define ERROR_DS_REPLICA_SET_CHANGE_NOT_ALLOWED_ON_DISABLED_CR 8595
#define ERROR_DS_NO_MSDS_INTID                             8596
#define ERROR_DS_DUP_MSDS_INTID                            8597
#define ERROR_DS_EXISTS_IN_RDNATTID                        8598
#define ERROR_DS_AUTHORIZATION_FAILED                      8599
#define ERROR_DS_INVALID_SCRIPT                            8600
#define ERROR_DS_REMOTE_CROSSREF_OP_FAILED                 8601
#define ERROR_DS_CROSS_REF_BUSY                            8602
#define ERROR_DS_CANT_DERIVE_SPN_FOR_DELETED_DOMAIN        8603
#define ERROR_DS_CANT_DEMOTE_WITH_WRITEABLE_NC             8604
#define ERROR_DS_DUPLICATE_ID_FOUND                        8605
#define ERROR_DS_INSUFFICIENT_ATTR_TO_CREATE_OBJECT        8606
#define ERROR_DS_GROUP_CONVERSION_ERROR                    8607
#define ERROR_DS_CANT_MOVE_APP_BASIC_GROUP                 8608
#define ERROR_DS_CANT_MOVE_APP_QUERY_GROUP                 8609
#define ERROR_DS_ROLE_NOT_VERIFIED                         8610
#define ERROR_DS_WKO_CONTAINER_CANNOT_BE_SPECIAL           8611
#define ERROR_DS_DOMAIN_RENAME_IN_PROGRESS                 8612
#define ERROR_DS_EXISTING_AD_CHILD_NC                      8613
#define ERROR_DS_REPL_LIFETIME_EXCEEDED                    8614
#define ERROR_DS_DISALLOWED_IN_SYSTEM_CONTAINER            8615
#define ERROR_DS_LDAP_SEND_QUEUE_FULL                      8616
#define ERROR_DS_DRA_OUT_SCHEDULE_WINDOW                   8617
#define ERROR_DS_POLICY_NOT_KNOWN                          8618
#define ERROR_NO_SITE_SETTINGS_OBJECT                      8619
#define ERROR_NO_SECRETS                                   8620
#define ERROR_NO_WRITABLE_DC_FOUND                         8621
#define ERROR_DS_NO_SERVER_OBJECT                          8622
#define ERROR_DS_NO_NTDSA_OBJECT                           8623
#define ERROR_DS_NON_ASQ_SEARCH                            8624
#define ERROR_DS_AUDIT_FAILURE                             8625
#define ERROR_DS_INVALID_SEARCH_FLAG_SUBTREE               8626
#define ERROR_DS_INVALID_SEARCH_FLAG_TUPLE                 8627
#define ERROR_DS_HIERARCHY_TABLE_TOO_DEEP                  8628
#define ERROR_DS_DRA_CORRUPT_UTD_VECTOR                    8629
#define ERROR_DS_DRA_SECRETS_DENIED                        8630
#define ERROR_DS_RESERVED_MAPI_ID                          8631
#define ERROR_DS_MAPI_ID_NOT_AVAILABLE                     8632
#define ERROR_DS_DRA_MISSING_KRBTGT_SECRET                 8633
#define ERROR_DS_DOMAIN_NAME_EXISTS_IN_FOREST              8634
#define ERROR_DS_FLAT_NAME_EXISTS_IN_FOREST                8635
#define ERROR_INVALID_USER_PRINCIPAL_NAME                  8636
#define ERROR_DS_OID_MAPPED_GROUP_CANT_HAVE_MEMBERS        8637
#define ERROR_DS_OID_NOT_FOUND                             8638
#define ERROR_DS_DRA_RECYCLED_TARGET                       8639
#define ERROR_DS_DISALLOWED_NC_REDIRECT                    8640
#define ERROR_DS_HIGH_ADLDS_FFL                            8641
#define ERROR_DS_HIGH_DSA_VERSION                          8642
#define ERROR_DS_LOW_ADLDS_FFL                             8643
#define ERROR_DOMAIN_SID_SAME_AS_LOCAL_WORKSTATION         8644
#define ERROR_DS_UNDELETE_SAM_VALIDATION_FAILED            8645
#define ERROR_INCORRECT_ACCOUNT_TYPE                       8646
#define ERROR_DS_SPN_VALUE_NOT_UNIQUE_IN_FOREST            8647
#define ERROR_DS_UPN_VALUE_NOT_UNIQUE_IN_FOREST            8648
#define ERROR_DS_MISSING_FOREST_TRUST                      8649
#define ERROR_DS_VALUE_KEY_NOT_UNIQUE                      8650
#define ERROR_WEAK_WHFBKEY_BLOCKED                         8651
#define ERROR_DS_PER_ATTRIBUTE_AUTHZ_FAILED_DURING_ADD     8652
#define ERROR_LOCAL_POLICY_MODIFICATION_NOT_SUPPORTED      8653
#define ERROR_POLICY_CONTROLLED_ACCOUNT                    8654
#define ERROR_LAPS_LEGACY_SCHEMA_MISSING                   8655
#define ERROR_LAPS_SCHEMA_MISSING                          8656
#define ERROR_LAPS_ENCRYPTION_REQUIRES_2016_DFL            8657
#define DNS_ERROR_RESPONSE_CODES_BASE                      9000
#define DNS_ERROR_RCODE_FORMAT_ERROR                       9001
#define DNS_ERROR_RCODE_SERVER_FAILURE                     9002
#define DNS_ERROR_RCODE_NAME_ERROR                         9003
#define DNS_ERROR_RCODE_NOT_IMPLEMENTED                    9004
#define DNS_ERROR_RCODE_REFUSED                            9005
#define DNS_ERROR_RCODE_YXDOMAIN                           9006
#define DNS_ERROR_RCODE_YXRRSET                            9007
#define DNS_ERROR_RCODE_NXRRSET                            9008
#define DNS_ERROR_RCODE_NOTAUTH                            9009
#define DNS_ERROR_RCODE_NOTZONE                            9010
#define DNS_ERROR_RCODE_BADSIG                             9016
#define DNS_ERROR_RCODE_BADKEY                             9017
#define DNS_ERROR_RCODE_BADTIME                            9018
#define DNS_ERROR_DNSSEC_BASE                              9100
#define DNS_ERROR_KEYMASTER_REQUIRED                       9101
#define DNS_ERROR_NOT_ALLOWED_ON_SIGNED_ZONE               9102
#define DNS_ERROR_NSEC3_INCOMPATIBLE_WITH_RSA_SHA1         9103
#define DNS_ERROR_NOT_ENOUGH_SIGNING_KEY_DESCRIPTORS       9104
#define DNS_ERROR_UNSUPPORTED_ALGORITHM                    9105
#define DNS_ERROR_INVALID_KEY_SIZE                         9106
#define DNS_ERROR_SIGNING_KEY_NOT_ACCESSIBLE               9107
#define DNS_ERROR_KSP_DOES_NOT_SUPPORT_PROTECTION          9108
#define DNS_ERROR_UNEXPECTED_DATA_PROTECTION_ERROR         9109
#define DNS_ERROR_UNEXPECTED_CNG_ERROR                     9110
#define DNS_ERROR_UNKNOWN_SIGNING_PARAMETER_VERSION        9111
#define DNS_ERROR_KSP_NOT_ACCESSIBLE                       9112
#define DNS_ERROR_TOO_MANY_SKDS                            9113
#define DNS_ERROR_INVALID_ROLLOVER_PERIOD                  9114
#define DNS_ERROR_INVALID_INITIAL_ROLLOVER_OFFSET          9115
#define DNS_ERROR_ROLLOVER_IN_PROGRESS                     9116
#define DNS_ERROR_STANDBY_KEY_NOT_PRESENT                  9117
#define DNS_ERROR_NOT_ALLOWED_ON_ZSK                       9118
#define DNS_ERROR_NOT_ALLOWED_ON_ACTIVE_SKD                9119
#define DNS_ERROR_ROLLOVER_ALREADY_QUEUED                  9120
#define DNS_ERROR_NOT_ALLOWED_ON_UNSIGNED_ZONE             9121
#define DNS_ERROR_BAD_KEYMASTER                            9122
#define DNS_ERROR_INVALID_SIGNATURE_VALIDITY_PERIOD        9123
#define DNS_ERROR_INVALID_NSEC3_ITERATION_COUNT            9124
#define DNS_ERROR_DNSSEC_IS_DISABLED                       9125
#define DNS_ERROR_INVALID_XML                              9126
#define DNS_ERROR_NO_VALID_TRUST_ANCHORS                   9127
#define DNS_ERROR_ROLLOVER_NOT_POKEABLE                    9128
#define DNS_ERROR_NSEC3_NAME_COLLISION                     9129
#define DNS_ERROR_NSEC_INCOMPATIBLE_WITH_NSEC3_RSA_SHA1    9130
#define DNS_ERROR_PACKET_FMT_BASE                          9500
#define DNS_INFO_NO_RECORDS                                9501
#define DNS_ERROR_BAD_PACKET                               9502
#define DNS_ERROR_NO_PACKET                                9503
#define DNS_ERROR_RCODE                                    9504
#define DNS_ERROR_UNSECURE_PACKET                          9505
#define DNS_REQUEST_PENDING                                9506
#define DNS_ERROR_GENERAL_API_BASE                         9550
#define DNS_ERROR_INVALID_TYPE                             9551
#define DNS_ERROR_INVALID_IP_ADDRESS                       9552
#define DNS_ERROR_INVALID_PROPERTY                         9553
#define DNS_ERROR_TRY_AGAIN_LATER                          9554
#define DNS_ERROR_NOT_UNIQUE                               9555
#define DNS_ERROR_NON_RFC_NAME                             9556
#define DNS_STATUS_FQDN                                    9557
#define DNS_STATUS_DOTTED_NAME                             9558
#define DNS_STATUS_SINGLE_PART_NAME                        9559
#define DNS_ERROR_INVALID_NAME_CHAR                        9560
#define DNS_ERROR_NUMERIC_NAME                             9561
#define DNS_ERROR_NOT_ALLOWED_ON_ROOT_SERVER               9562
#define DNS_ERROR_NOT_ALLOWED_UNDER_DELEGATION             9563
#define DNS_ERROR_CANNOT_FIND_ROOT_HINTS                   9564
#define DNS_ERROR_INCONSISTENT_ROOT_HINTS                  9565
#define DNS_ERROR_DWORD_VALUE_TOO_SMALL                    9566
#define DNS_ERROR_DWORD_VALUE_TOO_LARGE                    9567
#define DNS_ERROR_BACKGROUND_LOADING                       9568
#define DNS_ERROR_NOT_ALLOWED_ON_RODC                      9569
#define DNS_ERROR_NOT_ALLOWED_UNDER_DNAME                  9570
#define DNS_ERROR_DELEGATION_REQUIRED                      9571
#define DNS_ERROR_INVALID_POLICY_TABLE                     9572
#define DNS_ERROR_ADDRESS_REQUIRED                         9573
#define DNS_ERROR_ZONE_BASE                                9600
#define DNS_ERROR_ZONE_DOES_NOT_EXIST                      9601
#define DNS_ERROR_NO_ZONE_INFO                             9602
#define DNS_ERROR_INVALID_ZONE_OPERATION                   9603
#define DNS_ERROR_ZONE_CONFIGURATION_ERROR                 9604
#define DNS_ERROR_ZONE_HAS_NO_SOA_RECORD                   9605
#define DNS_ERROR_ZONE_HAS_NO_NS_RECORDS                   9606
#define DNS_ERROR_ZONE_LOCKED                              9607
#define DNS_ERROR_ZONE_CREATION_FAILED                     9608
#define DNS_ERROR_ZONE_ALREADY_EXISTS                      9609
#define DNS_ERROR_AUTOZONE_ALREADY_EXISTS                  9610
#define DNS_ERROR_INVALID_ZONE_TYPE                        9611
#define DNS_ERROR_SECONDARY_REQUIRES_MASTER_IP             9612
#define DNS_ERROR_ZONE_NOT_SECONDARY                       9613
#define DNS_ERROR_NEED_SECONDARY_ADDRESSES                 9614
#define DNS_ERROR_WINS_INIT_FAILED                         9615
#define DNS_ERROR_NEED_WINS_SERVERS                        9616
#define DNS_ERROR_NBSTAT_INIT_FAILED                       9617
#define DNS_ERROR_SOA_DELETE_INVALID                       9618
#define DNS_ERROR_FORWARDER_ALREADY_EXISTS                 9619
#define DNS_ERROR_ZONE_REQUIRES_MASTER_IP                  9620
#define DNS_ERROR_ZONE_IS_SHUTDOWN                         9621
#define DNS_ERROR_ZONE_LOCKED_FOR_SIGNING                  9622
#define DNS_ERROR_DATAFILE_BASE                            9650
#define DNS_ERROR_PRIMARY_REQUIRES_DATAFILE                9651
#define DNS_ERROR_INVALID_DATAFILE_NAME                    9652
#define DNS_ERROR_DATAFILE_OPEN_FAILURE                    9653
#define DNS_ERROR_FILE_WRITEBACK_FAILED                    9654
#define DNS_ERROR_DATAFILE_PARSING                         9655
#define DNS_ERROR_DATABASE_BASE                            9700
#define DNS_ERROR_RECORD_DOES_NOT_EXIST                    9701
#define DNS_ERROR_RECORD_FORMAT                            9702
#define DNS_ERROR_NODE_CREATION_FAILED                     9703
#define DNS_ERROR_UNKNOWN_RECORD_TYPE                      9704
#define DNS_ERROR_RECORD_TIMED_OUT                         9705
#define DNS_ERROR_NAME_NOT_IN_ZONE                         9706
#define DNS_ERROR_CNAME_LOOP                               9707
#define DNS_ERROR_NODE_IS_CNAME                            9708
#define DNS_ERROR_CNAME_COLLISION                          9709
#define DNS_ERROR_RECORD_ONLY_AT_ZONE_ROOT                 9710
#define DNS_ERROR_RECORD_ALREADY_EXISTS                    9711
#define DNS_ERROR_SECONDARY_DATA                           9712
#define DNS_ERROR_NO_CREATE_CACHE_DATA                     9713
#define DNS_ERROR_NAME_DOES_NOT_EXIST                      9714
#define DNS_WARNING_PTR_CREATE_FAILED                      9715
#define DNS_WARNING_DOMAIN_UNDELETED                       9716
#define DNS_ERROR_DS_UNAVAILABLE                           9717
#define DNS_ERROR_DS_ZONE_ALREADY_EXISTS                   9718
#define DNS_ERROR_NO_BOOTFILE_IF_DS_ZONE                   9719
#define DNS_ERROR_NODE_IS_DNAME                            9720
#define DNS_ERROR_DNAME_COLLISION                          9721
#define DNS_ERROR_ALIAS_LOOP                               9722
#define DNS_ERROR_OPERATION_BASE                           9750
#define DNS_INFO_AXFR_COMPLETE                             9751
#define DNS_ERROR_AXFR                                     9752
#define DNS_INFO_ADDED_LOCAL_WINS                          9753
#define DNS_ERROR_SECURE_BASE                              9800
#define DNS_STATUS_CONTINUE_NEEDED                         9801
#define DNS_ERROR_SETUP_BASE                               9850
#define DNS_ERROR_NO_TCPIP                                 9851
#define DNS_ERROR_NO_DNS_SERVERS                           9852
#define DNS_ERROR_DP_BASE                                  9900
#define DNS_ERROR_DP_DOES_NOT_EXIST                        9901
#define DNS_ERROR_DP_ALREADY_EXISTS                        9902
#define DNS_ERROR_DP_NOT_ENLISTED                          9903
#define DNS_ERROR_DP_ALREADY_ENLISTED                      9904
#define DNS_ERROR_DP_NOT_AVAILABLE                         9905
#define DNS_ERROR_DP_FSMO_ERROR                            9906
#define DNS_ERROR_RRL_NOT_ENABLED                          9911
#define DNS_ERROR_RRL_INVALID_WINDOW_SIZE                  9912
#define DNS_ERROR_RRL_INVALID_IPV4_PREFIX                  9913
#define DNS_ERROR_RRL_INVALID_IPV6_PREFIX                  9914
#define DNS_ERROR_RRL_INVALID_TC_RATE                      9915
#define DNS_ERROR_RRL_INVALID_LEAK_RATE                    9916
#define DNS_ERROR_RRL_LEAK_RATE_LESSTHAN_TC_RATE           9917
#define DNS_ERROR_VIRTUALIZATION_INSTANCE_ALREADY_EXISTS   9921
#define DNS_ERROR_VIRTUALIZATION_INSTANCE_DOES_NOT_EXIST   9922
#define DNS_ERROR_VIRTUALIZATION_TREE_LOCKED               9923
#define DNS_ERROR_INVAILD_VIRTUALIZATION_INSTANCE_NAME     9924
#define DNS_ERROR_DEFAULT_VIRTUALIZATION_INSTANCE          9925
#define DNS_ERROR_ZONESCOPE_ALREADY_EXISTS                 9951
#define DNS_ERROR_ZONESCOPE_DOES_NOT_EXIST                 9952
#define DNS_ERROR_DEFAULT_ZONESCOPE                        9953
#define DNS_ERROR_INVALID_ZONESCOPE_NAME                   9954
#define DNS_ERROR_NOT_ALLOWED_WITH_ZONESCOPES              9955
#define DNS_ERROR_LOAD_ZONESCOPE_FAILED                    9956
#define DNS_ERROR_ZONESCOPE_FILE_WRITEBACK_FAILED          9957
#define DNS_ERROR_INVALID_SCOPE_NAME                       9958
#define DNS_ERROR_SCOPE_DOES_NOT_EXIST                     9959
#define DNS_ERROR_DEFAULT_SCOPE                            9960
#define DNS_ERROR_INVALID_SCOPE_OPERATION                  9961
#define DNS_ERROR_SCOPE_LOCKED                             9962
#define DNS_ERROR_SCOPE_ALREADY_EXISTS                     9963
#define DNS_ERROR_POLICY_ALREADY_EXISTS                    9971
#define DNS_ERROR_POLICY_DOES_NOT_EXIST                    9972
#define DNS_ERROR_POLICY_INVALID_CRITERIA                  9973
#define DNS_ERROR_POLICY_INVALID_SETTINGS                  9974
#define DNS_ERROR_CLIENT_SUBNET_IS_ACCESSED                9975
#define DNS_ERROR_CLIENT_SUBNET_DOES_NOT_EXIST             9976
#define DNS_ERROR_CLIENT_SUBNET_ALREADY_EXISTS             9977
#define DNS_ERROR_SUBNET_DOES_NOT_EXIST                    9978
#define DNS_ERROR_SUBNET_ALREADY_EXISTS                    9979
#define DNS_ERROR_POLICY_LOCKED                            9980
#define DNS_ERROR_POLICY_INVALID_WEIGHT                    9981
#define DNS_ERROR_POLICY_INVALID_NAME                      9982
#define DNS_ERROR_POLICY_MISSING_CRITERIA                  9983
#define DNS_ERROR_INVALID_CLIENT_SUBNET_NAME               9984
#define DNS_ERROR_POLICY_PROCESSING_ORDER_INVALID          9985
#define DNS_ERROR_POLICY_SCOPE_MISSING                     9986
#define DNS_ERROR_POLICY_SCOPE_NOT_ALLOWED                 9987
#define DNS_ERROR_SERVERSCOPE_IS_REFERENCED                9988
#define DNS_ERROR_ZONESCOPE_IS_REFERENCED                  9989
#define DNS_ERROR_POLICY_INVALID_CRITERIA_CLIENT_SUBNET    9990
#define DNS_ERROR_POLICY_INVALID_CRITERIA_TRANSPORT_PROTOCOL 9991
#define DNS_ERROR_POLICY_INVALID_CRITERIA_NETWORK_PROTOCOL 9992
#define DNS_ERROR_POLICY_INVALID_CRITERIA_INTERFACE        9993
#define DNS_ERROR_POLICY_INVALID_CRITERIA_FQDN             9994
#define DNS_ERROR_POLICY_INVALID_CRITERIA_QUERY_TYPE       9995
#define DNS_ERROR_POLICY_INVALID_CRITERIA_TIME_OF_DAY      9996

/*
 * Also defined in winsock.h.
 *
 * All Windows Sockets error constants are biased by WSABASEERR from
 * the "normal"
 */
#define WSABASEERR                 10000
/*
 * Windows Sockets definitions of regular Microsoft C error constants
 */
#define WSAEINTR                   (WSABASEERR+4)
#define WSAEBADF                   (WSABASEERR+9)
#define WSAEACCES                  (WSABASEERR+13)
#define WSAEFAULT                  (WSABASEERR+14)
#define WSAEINVAL                  (WSABASEERR+22)
#define WSAEMFILE                  (WSABASEERR+24)

/*
 * Windows Sockets definitions of regular Berkeley error constants
 */
#define WSAEWOULDBLOCK             (WSABASEERR+35)
#define WSAEINPROGRESS             (WSABASEERR+36)
#define WSAEALREADY                (WSABASEERR+37)
#define WSAENOTSOCK                (WSABASEERR+38)
#define WSAEDESTADDRREQ            (WSABASEERR+39)
#define WSAEMSGSIZE                (WSABASEERR+40)
#define WSAEPROTOTYPE              (WSABASEERR+41)
#define WSAENOPROTOOPT             (WSABASEERR+42)
#define WSAEPROTONOSUPPORT         (WSABASEERR+43)
#define WSAESOCKTNOSUPPORT         (WSABASEERR+44)
#define WSAEOPNOTSUPP              (WSABASEERR+45)
#define WSAEPFNOSUPPORT            (WSABASEERR+46)
#define WSAEAFNOSUPPORT            (WSABASEERR+47)
#define WSAEADDRINUSE              (WSABASEERR+48)
#define WSAEADDRNOTAVAIL           (WSABASEERR+49)
#define WSAENETDOWN                (WSABASEERR+50)
#define WSAENETUNREACH             (WSABASEERR+51)
#define WSAENETRESET               (WSABASEERR+52)
#define WSAECONNABORTED            (WSABASEERR+53)
#define WSAECONNRESET              (WSABASEERR+54)
#define WSAENOBUFS                 (WSABASEERR+55)
#define WSAEISCONN                 (WSABASEERR+56)
#define WSAENOTCONN                (WSABASEERR+57)
#define WSAESHUTDOWN               (WSABASEERR+58)
#define WSAETOOMANYREFS            (WSABASEERR+59)
#define WSAETIMEDOUT               (WSABASEERR+60)
#define WSAECONNREFUSED            (WSABASEERR+61)
#define WSAELOOP                   (WSABASEERR+62)
#define WSAENAMETOOLONG            (WSABASEERR+63)
#define WSAEHOSTDOWN               (WSABASEERR+64)
#define WSAEHOSTUNREACH            (WSABASEERR+65)
#define WSAENOTEMPTY               (WSABASEERR+66)
#define WSAEPROCLIM                (WSABASEERR+67)
#define WSAEUSERS                  (WSABASEERR+68)
#define WSAEDQUOT                  (WSABASEERR+69)
#define WSAESTALE                  (WSABASEERR+70)
#define WSAEREMOTE                 (WSABASEERR+71)

/*
 * Extended Windows Sockets error constant definitions
 */
#define WSASYSNOTREADY             (WSABASEERR+91)
#define WSAVERNOTSUPPORTED         (WSABASEERR+92)
#define WSANOTINITIALISED          (WSABASEERR+93)
#define WSAEDISCON                 (WSABASEERR+101)
#define WSAENOMORE                 (WSABASEERR+102)
#define WSAECANCELLED              (WSABASEERR+103)
#define WSAEINVALIDPROCTABLE       (WSABASEERR+104)
#define WSAEINVALIDPROVIDER        (WSABASEERR+105)
#define WSAEPROVIDERFAILEDINIT     (WSABASEERR+106)
#define WSASYSCALLFAILURE          (WSABASEERR+107)
#define WSASERVICE_NOT_FOUND       (WSABASEERR+108)
#define WSATYPE_NOT_FOUND          (WSABASEERR+109)
#define WSA_E_NO_MORE              (WSABASEERR+110)
#define WSA_E_CANCELLED            (WSABASEERR+111)
#define WSAEREFUSED                (WSABASEERR+112)
#define WSAHOST_NOT_FOUND          (WSABASEERR+1001)
#define WSATRY_AGAIN               (WSABASEERR+1002)
#define WSANO_RECOVERY             (WSABASEERR+1003)
#define WSANO_DATA                 (WSABASEERR+1004)

#define WSA_QOS_RECEIVERS                                  11005
#define WSA_QOS_SENDERS                                    11006
#define WSA_QOS_NO_SENDERS                                 11007
#define WSA_QOS_NO_RECEIVERS                               11008
#define WSA_QOS_REQUEST_CONFIRMED                          11009
#define WSA_QOS_ADMISSION_FAILURE                          11010
#define WSA_QOS_POLICY_FAILURE                             11011
#define WSA_QOS_BAD_STYLE                                  11012
#define WSA_QOS_BAD_OBJECT                                 11013
#define WSA_QOS_TRAFFIC_CTRL_ERROR                         11014
#define WSA_QOS_GENERIC_ERROR                              11015
#define WSA_QOS_ESERVICETYPE                               11016
#define WSA_QOS_EFLOWSPEC                                  11017
#define WSA_QOS_EPROVSPECBUF                               11018
#define WSA_QOS_EFILTERSTYLE                               11019
#define WSA_QOS_EFILTERTYPE                                11020
#define WSA_QOS_EFILTERCOUNT                               11021
#define WSA_QOS_EOBJLENGTH                                 11022
#define WSA_QOS_EFLOWCOUNT                                 11023
#define WSA_QOS_EUNKOWNPSOBJ                               11024
#define WSA_QOS_EPOLICYOBJ                                 11025
#define WSA_QOS_EFLOWDESC                                  11026
#define WSA_QOS_EPSFLOWSPEC                                11027
#define WSA_QOS_EPSFILTERSPEC                              11028
#define WSA_QOS_ESDMODEOBJ                                 11029
#define WSA_QOS_ESHAPERATEOBJ                              11030
#define WSA_QOS_RESERVED_PETYPE                            11031
#define WSA_SECURE_HOST_NOT_FOUND                          11032
#define WSA_IPSEC_NAME_POLICY_ERROR                        11033
#define ERROR_IPSEC_QM_POLICY_EXISTS                       13000
#define ERROR_IPSEC_QM_POLICY_NOT_FOUND                    13001
#define ERROR_IPSEC_QM_POLICY_IN_USE                       13002
#define ERROR_IPSEC_MM_POLICY_EXISTS                       13003
#define ERROR_IPSEC_MM_POLICY_NOT_FOUND                    13004
#define ERROR_IPSEC_MM_POLICY_IN_USE                       13005
#define ERROR_IPSEC_MM_FILTER_EXISTS                       13006
#define ERROR_IPSEC_MM_FILTER_NOT_FOUND                    13007
#define ERROR_IPSEC_TRANSPORT_FILTER_EXISTS                13008
#define ERROR_IPSEC_TRANSPORT_FILTER_NOT_FOUND             13009
#define ERROR_IPSEC_MM_AUTH_EXISTS                         13010
#define ERROR_IPSEC_MM_AUTH_NOT_FOUND                      13011
#define ERROR_IPSEC_MM_AUTH_IN_USE                         13012
#define ERROR_IPSEC_DEFAULT_MM_POLICY_NOT_FOUND            13013
#define ERROR_IPSEC_DEFAULT_MM_AUTH_NOT_FOUND              13014
#define ERROR_IPSEC_DEFAULT_QM_POLICY_NOT_FOUND            13015
#define ERROR_IPSEC_TUNNEL_FILTER_EXISTS                   13016
#define ERROR_IPSEC_TUNNEL_FILTER_NOT_FOUND                13017
#define ERROR_IPSEC_MM_FILTER_PENDING_DELETION             13018
#define ERROR_IPSEC_TRANSPORT_FILTER_PENDING_DELETION      13019
#define ERROR_IPSEC_TUNNEL_FILTER_PENDING_DELETION         13020
#define ERROR_IPSEC_MM_POLICY_PENDING_DELETION             13021
#define ERROR_IPSEC_MM_AUTH_PENDING_DELETION               13022
#define ERROR_IPSEC_QM_POLICY_PENDING_DELETION             13023
#define WARNING_IPSEC_MM_POLICY_PRUNED                     13024
#define WARNING_IPSEC_QM_POLICY_PRUNED                     13025
#define ERROR_IPSEC_IKE_NEG_STATUS_BEGIN                   13800
#define ERROR_IPSEC_IKE_AUTH_FAIL                          13801
#define ERROR_IPSEC_IKE_ATTRIB_FAIL                        13802
#define ERROR_IPSEC_IKE_NEGOTIATION_PENDING                13803
#define ERROR_IPSEC_IKE_GENERAL_PROCESSING_ERROR           13804
#define ERROR_IPSEC_IKE_TIMED_OUT                          13805
#define ERROR_IPSEC_IKE_NO_CERT                            13806
#define ERROR_IPSEC_IKE_SA_DELETED                         13807
#define ERROR_IPSEC_IKE_SA_REAPED                          13808
#define ERROR_IPSEC_IKE_MM_ACQUIRE_DROP                    13809
#define ERROR_IPSEC_IKE_QM_ACQUIRE_DROP                    13810
#define ERROR_IPSEC_IKE_QUEUE_DROP_MM                      13811
#define ERROR_IPSEC_IKE_QUEUE_DROP_NO_MM                   13812
#define ERROR_IPSEC_IKE_DROP_NO_RESPONSE                   13813
#define ERROR_IPSEC_IKE_MM_DELAY_DROP                      13814
#define ERROR_IPSEC_IKE_QM_DELAY_DROP                      13815
#define ERROR_IPSEC_IKE_ERROR                              13816
#define ERROR_IPSEC_IKE_CRL_FAILED                         13817
#define ERROR_IPSEC_IKE_INVALID_KEY_USAGE                  13818
#define ERROR_IPSEC_IKE_INVALID_CERT_TYPE                  13819
#define ERROR_IPSEC_IKE_NO_PRIVATE_KEY                     13820
#define ERROR_IPSEC_IKE_SIMULTANEOUS_REKEY                 13821
#define ERROR_IPSEC_IKE_DH_FAIL                            13822
#define ERROR_IPSEC_IKE_CRITICAL_PAYLOAD_NOT_RECOGNIZED    13823
#define ERROR_IPSEC_IKE_INVALID_HEADER                     13824
#define ERROR_IPSEC_IKE_NO_POLICY                          13825
#define ERROR_IPSEC_IKE_INVALID_SIGNATURE                  13826
#define ERROR_IPSEC_IKE_KERBEROS_ERROR                     13827
#define ERROR_IPSEC_IKE_NO_PUBLIC_KEY                      13828
#define ERROR_IPSEC_IKE_PROCESS_ERR                        13829
#define ERROR_IPSEC_IKE_PROCESS_ERR_SA                     13830
#define ERROR_IPSEC_IKE_PROCESS_ERR_PROP                   13831
#define ERROR_IPSEC_IKE_PROCESS_ERR_TRANS                  13832
#define ERROR_IPSEC_IKE_PROCESS_ERR_KE                     13833
#define ERROR_IPSEC_IKE_PROCESS_ERR_ID                     13834
#define ERROR_IPSEC_IKE_PROCESS_ERR_CERT                   13835
#define ERROR_IPSEC_IKE_PROCESS_ERR_CERT_REQ               13836
#define ERROR_IPSEC_IKE_PROCESS_ERR_HASH                   13837
#define ERROR_IPSEC_IKE_PROCESS_ERR_SIG                    13838
#define ERROR_IPSEC_IKE_PROCESS_ERR_NONCE                  13839
#define ERROR_IPSEC_IKE_PROCESS_ERR_NOTIFY                 13840
#define ERROR_IPSEC_IKE_PROCESS_ERR_DELETE                 13841
#define ERROR_IPSEC_IKE_PROCESS_ERR_VENDOR                 13842
#define ERROR_IPSEC_IKE_INVALID_PAYLOAD                    13843
#define ERROR_IPSEC_IKE_LOAD_SOFT_SA                       13844
#define ERROR_IPSEC_IKE_SOFT_SA_TORN_DOWN                  13845
#define ERROR_IPSEC_IKE_INVALID_COOKIE                     13846
#define ERROR_IPSEC_IKE_NO_PEER_CERT                       13847
#define ERROR_IPSEC_IKE_PEER_CRL_FAILED                    13848
#define ERROR_IPSEC_IKE_POLICY_CHANGE                      13849
#define ERROR_IPSEC_IKE_NO_MM_POLICY                       13850
#define ERROR_IPSEC_IKE_NOTCBPRIV                          13851
#define ERROR_IPSEC_IKE_SECLOADFAIL                        13852
#define ERROR_IPSEC_IKE_FAILSSPINIT                        13853
#define ERROR_IPSEC_IKE_FAILQUERYSSP                       13854
#define ERROR_IPSEC_IKE_SRVACQFAIL                         13855
#define ERROR_IPSEC_IKE_SRVQUERYCRED                       13856
#define ERROR_IPSEC_IKE_GETSPIFAIL                         13857
#define ERROR_IPSEC_IKE_INVALID_FILTER                     13858
#define ERROR_IPSEC_IKE_OUT_OF_MEMORY                      13859
#define ERROR_IPSEC_IKE_ADD_UPDATE_KEY_FAILED              13860
#define ERROR_IPSEC_IKE_INVALID_POLICY                     13861
#define ERROR_IPSEC_IKE_UNKNOWN_DOI                        13862
#define ERROR_IPSEC_IKE_INVALID_SITUATION                  13863
#define ERROR_IPSEC_IKE_DH_FAILURE                         13864
#define ERROR_IPSEC_IKE_INVALID_GROUP                      13865
#define ERROR_IPSEC_IKE_ENCRYPT                            13866
#define ERROR_IPSEC_IKE_DECRYPT                            13867
#define ERROR_IPSEC_IKE_POLICY_MATCH                       13868
#define ERROR_IPSEC_IKE_UNSUPPORTED_ID                     13869
#define ERROR_IPSEC_IKE_INVALID_HASH                       13870
#define ERROR_IPSEC_IKE_INVALID_HASH_ALG                   13871
#define ERROR_IPSEC_IKE_INVALID_HASH_SIZE                  13872
#define ERROR_IPSEC_IKE_INVALID_ENCRYPT_ALG                13873
#define ERROR_IPSEC_IKE_INVALID_AUTH_ALG                   13874
#define ERROR_IPSEC_IKE_INVALID_SIG                        13875
#define ERROR_IPSEC_IKE_LOAD_FAILED                        13876
#define ERROR_IPSEC_IKE_RPC_DELETE                         13877
#define ERROR_IPSEC_IKE_BENIGN_REINIT                      13878
#define ERROR_IPSEC_IKE_INVALID_RESPONDER_LIFETIME_NOTIFY  13879
#define ERROR_IPSEC_IKE_INVALID_MAJOR_VERSION              13880
#define ERROR_IPSEC_IKE_INVALID_CERT_KEYLEN                13881
#define ERROR_IPSEC_IKE_MM_LIMIT                           13882
#define ERROR_IPSEC_IKE_NEGOTIATION_DISABLED               13883
#define ERROR_IPSEC_IKE_QM_LIMIT                           13884
#define ERROR_IPSEC_IKE_MM_EXPIRED                         13885
#define ERROR_IPSEC_IKE_PEER_MM_ASSUMED_INVALID            13886
#define ERROR_IPSEC_IKE_CERT_CHAIN_POLICY_MISMATCH         13887
#define ERROR_IPSEC_IKE_UNEXPECTED_MESSAGE_ID              13888
#define ERROR_IPSEC_IKE_INVALID_AUTH_PAYLOAD               13889
#define ERROR_IPSEC_IKE_DOS_COOKIE_SENT                    13890
#define ERROR_IPSEC_IKE_SHUTTING_DOWN                      13891
#define ERROR_IPSEC_IKE_CGA_AUTH_FAILED                    13892
#define ERROR_IPSEC_IKE_PROCESS_ERR_NATOA                  13893
#define ERROR_IPSEC_IKE_INVALID_MM_FOR_QM                  13894
#define ERROR_IPSEC_IKE_QM_EXPIRED                         13895
#define ERROR_IPSEC_IKE_TOO_MANY_FILTERS                   13896
#define ERROR_IPSEC_IKE_NEG_STATUS_END                     13897
#define ERROR_IPSEC_IKE_KILL_DUMMY_NAP_TUNNEL              13898
#define ERROR_IPSEC_IKE_INNER_IP_ASSIGNMENT_FAILURE        13899
#define ERROR_IPSEC_IKE_REQUIRE_CP_PAYLOAD_MISSING         13900
#define ERROR_IPSEC_KEY_MODULE_IMPERSONATION_NEGOTIATION_PENDING 13901
#define ERROR_IPSEC_IKE_COEXISTENCE_SUPPRESS               13902
#define ERROR_IPSEC_IKE_RATELIMIT_DROP                     13903
#define ERROR_IPSEC_IKE_PEER_DOESNT_SUPPORT_MOBIKE         13904
#define ERROR_IPSEC_IKE_AUTHORIZATION_FAILURE              13905
#define ERROR_IPSEC_IKE_STRONG_CRED_AUTHORIZATION_FAILURE  13906
#define ERROR_IPSEC_IKE_AUTHORIZATION_FAILURE_WITH_OPTIONAL_RETRY 13907
#define ERROR_IPSEC_IKE_STRONG_CRED_AUTHORIZATION_AND_CERTMAP_FAILURE 13908
#define ERROR_IPSEC_IKE_NEG_STATUS_EXTENDED_END            13909
#define ERROR_IPSEC_BAD_SPI                                13910
#define ERROR_IPSEC_SA_LIFETIME_EXPIRED                    13911
#define ERROR_IPSEC_WRONG_SA                               13912
#define ERROR_IPSEC_REPLAY_CHECK_FAILED                    13913
#define ERROR_IPSEC_INVALID_PACKET                         13914
#define ERROR_IPSEC_INTEGRITY_CHECK_FAILED                 13915
#define ERROR_IPSEC_CLEAR_TEXT_DROP                        13916
#define ERROR_IPSEC_AUTH_FIREWALL_DROP                     13917
#define ERROR_IPSEC_THROTTLE_DROP                          13918
#define ERROR_IPSEC_DOSP_BLOCK                             13925
#define ERROR_IPSEC_DOSP_RECEIVED_MULTICAST                13926
#define ERROR_IPSEC_DOSP_INVALID_PACKET                    13927
#define ERROR_IPSEC_DOSP_STATE_LOOKUP_FAILED               13928
#define ERROR_IPSEC_DOSP_MAX_ENTRIES                       13929
#define ERROR_IPSEC_DOSP_KEYMOD_NOT_ALLOWED                13930
#define ERROR_IPSEC_DOSP_NOT_INSTALLED                     13931
#define ERROR_IPSEC_DOSP_MAX_PER_IP_RATELIMIT_QUEUES       13932
#define ERROR_SXS_SECTION_NOT_FOUND                        14000
#define ERROR_SXS_CANT_GEN_ACTCTX                          14001
#define ERROR_SXS_INVALID_ACTCTXDATA_FORMAT                14002
#define ERROR_SXS_ASSEMBLY_NOT_FOUND                       14003
#define ERROR_SXS_MANIFEST_FORMAT_ERROR                    14004
#define ERROR_SXS_MANIFEST_PARSE_ERROR                     14005
#define ERROR_SXS_ACTIVATION_CONTEXT_DISABLED              14006
#define ERROR_SXS_KEY_NOT_FOUND                            14007
#define ERROR_SXS_VERSION_CONFLICT                         14008
#define ERROR_SXS_WRONG_SECTION_TYPE                       14009
#define ERROR_SXS_THREAD_QUERIES_DISABLED                  14010
#define ERROR_SXS_PROCESS_DEFAULT_ALREADY_SET              14011
#define ERROR_SXS_UNKNOWN_ENCODING_GROUP                   14012
#define ERROR_SXS_UNKNOWN_ENCODING                         14013
#define ERROR_SXS_INVALID_XML_NAMESPACE_URI                14014
#define ERROR_SXS_ROOT_MANIFEST_DEPENDENCY_NOT_INSTALLED   14015
#define ERROR_SXS_LEAF_MANIFEST_DEPENDENCY_NOT_INSTALLED   14016
#define ERROR_SXS_INVALID_ASSEMBLY_IDENTITY_ATTRIBUTE      14017
#define ERROR_SXS_MANIFEST_MISSING_REQUIRED_DEFAULT_NAMESPACE       14018
#define ERROR_SXS_MANIFEST_INVALID_REQUIRED_DEFAULT_NAMESPACE       14019
#define ERROR_SXS_PRIVATE_MANIFEST_CROSS_PATH_WITH_REPARSE_POINT    14020
#define ERROR_SXS_DUPLICATE_DLL_NAME                       14021
#define ERROR_SXS_DUPLICATE_WINDOWCLASS_NAME               14022
#define ERROR_SXS_DUPLICATE_CLSID                          14023
#define ERROR_SXS_DUPLICATE_IID                            14024
#define ERROR_SXS_DUPLICATE_TLBID                          14025
#define ERROR_SXS_DUPLICATE_PROGID                         14026
#define ERROR_SXS_DUPLICATE_ASSEMBLY_NAME                  14027
#define ERROR_SXS_FILE_HASH_MISMATCH                       14028
#define ERROR_SXS_POLICY_PARSE_ERROR                       14029
#define ERROR_SXS_XML_E_MISSINGQUOTE                       14030
#define ERROR_SXS_XML_E_COMMENTSYNTAX                      14031
#define ERROR_SXS_XML_E_BADSTARTNAMECHAR                   14032
#define ERROR_SXS_XML_E_BADNAMECHAR                        14033
#define ERROR_SXS_XML_E_BADCHARINSTRING                    14034
#define ERROR_SXS_XML_E_XMLDECLSYNTAX                      14035
#define ERROR_SXS_XML_E_BADCHARDATA                        14036
#define ERROR_SXS_XML_E_MISSINGWHITESPACE                  14037
#define ERROR_SXS_XML_E_EXPECTINGTAGEND                    14038
#define ERROR_SXS_XML_E_MISSINGSEMICOLON                   14039
#define ERROR_SXS_XML_E_UNBALANCEDPAREN                    14040
#define ERROR_SXS_XML_E_INTERNALERROR                      14041
#define ERROR_SXS_XML_E_UNEXPECTED_WHITESPACE              14042
#define ERROR_SXS_XML_E_INCOMPLETE_ENCODING                14043
#define ERROR_SXS_XML_E_MISSING_PAREN                      14044
#define ERROR_SXS_XML_E_EXPECTINGCLOSEQUOTE                14045
#define ERROR_SXS_XML_E_MULTIPLE_COLONS                    14046
#define ERROR_SXS_XML_E_INVALID_DECIMAL                    14047
#define ERROR_SXS_XML_E_INVALID_HEXIDECIMAL                14048
#define ERROR_SXS_XML_E_INVALID_UNICODE                    14049
#define ERROR_SXS_XML_E_WHITESPACEORQUESTIONMARK           14050
#define ERROR_SXS_XML_E_UNEXPECTEDENDTAG                   14051
#define ERROR_SXS_XML_E_UNCLOSEDTAG                        14052
#define ERROR_SXS_XML_E_DUPLICATEATTRIBUTE                 14053
#define ERROR_SXS_XML_E_MULTIPLEROOTS                      14054
#define ERROR_SXS_XML_E_INVALIDATROOTLEVEL                 14055
#define ERROR_SXS_XML_E_BADXMLDECL                         14056
#define ERROR_SXS_XML_E_MISSINGROOT                        14057
#define ERROR_SXS_XML_E_UNEXPECTEDEOF                      14058
#define ERROR_SXS_XML_E_BADPEREFINSUBSET                   14059
#define ERROR_SXS_XML_E_UNCLOSEDSTARTTAG                   14060
#define ERROR_SXS_XML_E_UNCLOSEDENDTAG                     14061
#define ERROR_SXS_XML_E_UNCLOSEDSTRING                     14062
#define ERROR_SXS_XML_E_UNCLOSEDCOMMENT                    14063
#define ERROR_SXS_XML_E_UNCLOSEDDECL                       14064
#define ERROR_SXS_XML_E_UNCLOSEDCDATA                      14065
#define ERROR_SXS_XML_E_RESERVEDNAMESPACE                  14066
#define ERROR_SXS_XML_E_INVALIDENCODING                    14067
#define ERROR_SXS_XML_E_INVALIDSWITCH                      14068
#define ERROR_SXS_XML_E_BADXMLCASE                         14069
#define ERROR_SXS_XML_E_INVALID_STANDALONE                 14070
#define ERROR_SXS_XML_E_UNEXPECTED_STANDALONE              14071
#define ERROR_SXS_XML_E_INVALID_VERSION                    14072
#define ERROR_SXS_XML_E_MISSINGEQUALS                      14073
#define ERROR_SXS_PROTECTION_RECOVERY_FAILED               14074
#define ERROR_SXS_PROTECTION_PUBLIC_KEY_TOO_SHORT          14075
#define ERROR_SXS_PROTECTION_CATALOG_NOT_VALID             14076
#define ERROR_SXS_UNTRANSLATABLE_HRESULT                   14077
#define ERROR_SXS_PROTECTION_CATALOG_FILE_MISSING          14078
#define ERROR_SXS_MISSING_ASSEMBLY_IDENTITY_ATTRIBUTE      14079
#define ERROR_SXS_INVALID_ASSEMBLY_IDENTITY_ATTRIBUTE_NAME 14080
#define ERROR_SXS_ASSEMBLY_MISSING                         14081
#define ERROR_SXS_CORRUPT_ACTIVATION_STACK                 14082
#define ERROR_SXS_CORRUPTION                               14083
#define ERROR_SXS_EARLY_DEACTIVATION                       14084
#define ERROR_SXS_INVALID_DEACTIVATION                     14085
#define ERROR_SXS_MULTIPLE_DEACTIVATION                    14086
#define ERROR_SXS_PROCESS_TERMINATION_REQUESTED            14087
#define ERROR_SXS_RELEASE_ACTIVATION_CONTEXT               14088
#define ERROR_SXS_SYSTEM_DEFAULT_ACTIVATION_CONTEXT_EMPTY  14089
#define ERROR_SXS_INVALID_IDENTITY_ATTRIBUTE_VALUE         14090
#define ERROR_SXS_INVALID_IDENTITY_ATTRIBUTE_NAME          14091
#define ERROR_SXS_IDENTITY_DUPLICATE_ATTRIBUTE             14092
#define ERROR_SXS_IDENTITY_PARSE_ERROR                     14093
#define ERROR_MALFORMED_SUBSTITUTION_STRING                14094
#define ERROR_SXS_INCORRECT_PUBLIC_KEY_TOKEN               14095
#define ERROR_UNMAPPED_SUBSTITUTION_STRING                 14096
#define ERROR_SXS_ASSEMBLY_NOT_LOCKED                      14097
#define ERROR_SXS_COMPONENT_STORE_CORRUPT                  14098
#define ERROR_ADVANCED_INSTALLER_FAILED                    14099
#define ERROR_XML_ENCODING_MISMATCH                        14100
#define ERROR_SXS_MANIFEST_IDENTITY_SAME_BUT_CONTENTS_DIFFERENT     14101
#define ERROR_SXS_IDENTITIES_DIFFERENT                     14102
#define ERROR_SXS_ASSEMBLY_IS_NOT_A_DEPLOYMENT             14103
#define ERROR_SXS_FILE_NOT_PART_OF_ASSEMBLY                14104
#define ERROR_SXS_MANIFEST_TOO_BIG                         14105
#define ERROR_SXS_SETTING_NOT_REGISTERED                   14106
#define ERROR_SXS_TRANSACTION_CLOSURE_INCOMPLETE           14107
#define ERROR_SMI_PRIMITIVE_INSTALLER_FAILED               14108
#define ERROR_GENERIC_COMMAND_FAILED                       14109
#define ERROR_SXS_FILE_HASH_MISSING                        14110
#define ERROR_SXS_DUPLICATE_ACTIVATABLE_CLASS              14111
#define ERROR_EVT_INVALID_CHANNEL_PATH                     15000
#define ERROR_EVT_INVALID_QUERY                            15001
#define ERROR_EVT_PUBLISHER_METADATA_NOT_FOUND             15002
#define ERROR_EVT_EVENT_TEMPLATE_NOT_FOUND                 15003
#define ERROR_EVT_INVALID_PUBLISHER_NAME                   15004
#define ERROR_EVT_INVALID_EVENT_DATA                       15005
#define ERROR_EVT_CHANNEL_NOT_FOUND                        15007
#define ERROR_EVT_MALFORMED_XML_TEXT                       15008
#define ERROR_EVT_SUBSCRIPTION_TO_DIRECT_CHANNEL           15009
#define ERROR_EVT_CONFIGURATION_ERROR                      15010
#define ERROR_EVT_QUERY_RESULT_STALE                       15011
#define ERROR_EVT_QUERY_RESULT_INVALID_POSITION            15012
#define ERROR_EVT_NON_VALIDATING_MSXML                     15013
#define ERROR_EVT_FILTER_ALREADYSCOPED                     15014
#define ERROR_EVT_FILTER_NOTELTSET                         15015
#define ERROR_EVT_FILTER_INVARG                            15016
#define ERROR_EVT_FILTER_INVTEST                           15017
#define ERROR_EVT_FILTER_INVTYPE                           15018
#define ERROR_EVT_FILTER_PARSEERR                          15019
#define ERROR_EVT_FILTER_UNSUPPORTEDOP                     15020
#define ERROR_EVT_FILTER_UNEXPECTEDTOKEN                   15021
#define ERROR_EVT_INVALID_OPERATION_OVER_ENABLED_DIRECT_CHANNEL 15022
#define ERROR_EVT_INVALID_CHANNEL_PROPERTY_VALUE           15023
#define ERROR_EVT_INVALID_PUBLISHER_PROPERTY_VALUE         15024
#define ERROR_EVT_CHANNEL_CANNOT_ACTIVATE                  15025
#define ERROR_EVT_FILTER_TOO_COMPLEX                       15026
#define ERROR_EVT_MESSAGE_NOT_FOUND                        15027
#define ERROR_EVT_MESSAGE_ID_NOT_FOUND                     15028
#define ERROR_EVT_UNRESOLVED_VALUE_INSERT                  15029
#define ERROR_EVT_UNRESOLVED_PARAMETER_INSERT              15030
#define ERROR_EVT_MAX_INSERTS_REACHED                      15031
#define ERROR_EVT_EVENT_DEFINITION_NOT_FOUND               15032
#define ERROR_EVT_MESSAGE_LOCALE_NOT_FOUND                 15033
#define ERROR_EVT_VERSION_TOO_OLD                          15034
#define ERROR_EVT_VERSION_TOO_NEW                          15035
#define ERROR_EVT_CANNOT_OPEN_CHANNEL_OF_QUERY             15036
#define ERROR_EVT_PUBLISHER_DISABLED                       15037
#define ERROR_EVT_FILTER_OUT_OF_RANGE                      15038
#define ERROR_EC_SUBSCRIPTION_CANNOT_ACTIVATE              15080
#define ERROR_EC_LOG_DISABLED                              15081
#define ERROR_EC_CIRCULAR_FORWARDING                       15082
#define ERROR_EC_CREDSTORE_FULL                            15083
#define ERROR_EC_CRED_NOT_FOUND                            15084
#define ERROR_EC_NO_ACTIVE_CHANNEL                         15085
#define ERROR_MUI_FILE_NOT_FOUND                           15100
#define ERROR_MUI_INVALID_FILE                             15101
#define ERROR_MUI_INVALID_RC_CONFIG                        15102
#define ERROR_MUI_INVALID_LOCALE_NAME                      15103
#define ERROR_MUI_INVALID_ULTIMATEFALLBACK_NAME            15104
#define ERROR_MUI_FILE_NOT_LOADED                          15105
#define ERROR_RESOURCE_ENUM_USER_STOP                      15106
#define ERROR_MUI_INTLSETTINGS_UILANG_NOT_INSTALLED        15107
#define ERROR_MUI_INTLSETTINGS_INVALID_LOCALE_NAME         15108
#define ERROR_MRM_RUNTIME_NO_DEFAULT_OR_NEUTRAL_RESOURCE   15110
#define ERROR_MRM_INVALID_PRICONFIG                        15111
#define ERROR_MRM_INVALID_FILE_TYPE                        15112
#define ERROR_MRM_UNKNOWN_QUALIFIER                        15113
#define ERROR_MRM_INVALID_QUALIFIER_VALUE                  15114
#define ERROR_MRM_NO_CANDIDATE                             15115
#define ERROR_MRM_NO_MATCH_OR_DEFAULT_CANDIDATE            15116
#define ERROR_MRM_RESOURCE_TYPE_MISMATCH                   15117
#define ERROR_MRM_DUPLICATE_MAP_NAME                       15118
#define ERROR_MRM_DUPLICATE_ENTRY                          15119
#define ERROR_MRM_INVALID_RESOURCE_IDENTIFIER              15120
#define ERROR_MRM_FILEPATH_TOO_LONG                        15121
#define ERROR_MRM_UNSUPPORTED_DIRECTORY_TYPE               15122
#define ERROR_MRM_INVALID_PRI_FILE                         15126
#define ERROR_MRM_NAMED_RESOURCE_NOT_FOUND                 15127
#define ERROR_MRM_MAP_NOT_FOUND                            15135
#define ERROR_MRM_UNSUPPORTED_PROFILE_TYPE                 15136
#define ERROR_MRM_INVALID_QUALIFIER_OPERATOR               15137
#define ERROR_MRM_INDETERMINATE_QUALIFIER_VALUE            15138
#define ERROR_MRM_AUTOMERGE_ENABLED                        15139
#define ERROR_MRM_TOO_MANY_RESOURCES                       15140
#define ERROR_MRM_UNSUPPORTED_FILE_TYPE_FOR_MERGE          15141
#define ERROR_MRM_UNSUPPORTED_FILE_TYPE_FOR_LOAD_UNLOAD_PRI_FILE 15142
#define ERROR_MRM_NO_CURRENT_VIEW_ON_THREAD                15143
#define ERROR_DIFFERENT_PROFILE_RESOURCE_MANAGER_EXIST     15144
#define ERROR_OPERATION_NOT_ALLOWED_FROM_SYSTEM_COMPONENT  15145
#define ERROR_MRM_DIRECT_REF_TO_NON_DEFAULT_RESOURCE       15146
#define ERROR_MRM_GENERATION_COUNT_MISMATCH                15147
#define ERROR_PRI_MERGE_VERSION_MISMATCH                   15148
#define ERROR_PRI_MERGE_MISSING_SCHEMA                     15149
#define ERROR_PRI_MERGE_LOAD_FILE_FAILED                   15150
#define ERROR_PRI_MERGE_ADD_FILE_FAILED                    15151
#define ERROR_PRI_MERGE_WRITE_FILE_FAILED                  15152
#define ERROR_PRI_MERGE_MULTIPLE_PACKAGE_FAMILIES_NOT_ALLOWED 15153
#define ERROR_PRI_MERGE_MULTIPLE_MAIN_PACKAGES_NOT_ALLOWED 15154
#define ERROR_PRI_MERGE_BUNDLE_PACKAGES_NOT_ALLOWED        15155
#define ERROR_PRI_MERGE_MAIN_PACKAGE_REQUIRED              15156
#define ERROR_PRI_MERGE_RESOURCE_PACKAGE_REQUIRED          15157
#define ERROR_PRI_MERGE_INVALID_FILE_NAME                  15158
#define ERROR_MRM_PACKAGE_NOT_FOUND                        15159
#define ERROR_MRM_MISSING_DEFAULT_LANGUAGE                 15160
#define ERROR_MRM_SCOPE_ITEM_CONFLICT                      15161
#define ERROR_MCA_INVALID_CAPABILITIES_STRING              15200
#define ERROR_MCA_INVALID_VCP_VERSION                      15201
#define ERROR_MCA_MONITOR_VIOLATES_MCCS_SPECIFICATION      15202
#define ERROR_MCA_MCCS_VERSION_MISMATCH                    15203
#define ERROR_MCA_UNSUPPORTED_MCCS_VERSION                 15204
#define ERROR_MCA_INTERNAL_ERROR                           15205
#define ERROR_MCA_INVALID_TECHNOLOGY_TYPE_RETURNED         15206
#define ERROR_MCA_UNSUPPORTED_COLOR_TEMPERATURE            15207
#define ERROR_AMBIGUOUS_SYSTEM_DEVICE                      15250
#define ERROR_SYSTEM_DEVICE_NOT_FOUND                      15299
#define ERROR_HASH_NOT_SUPPORTED                           15300
#define ERROR_HASH_NOT_PRESENT                             15301
#define ERROR_SECONDARY_IC_PROVIDER_NOT_REGISTERED         15321
#define ERROR_GPIO_CLIENT_INFORMATION_INVALID              15322
#define ERROR_GPIO_VERSION_NOT_SUPPORTED                   15323
#define ERROR_GPIO_INVALID_REGISTRATION_PACKET             15324
#define ERROR_GPIO_OPERATION_DENIED                        15325
#define ERROR_GPIO_INCOMPATIBLE_CONNECT_MODE               15326
#define ERROR_GPIO_INTERRUPT_ALREADY_UNMASKED              15327
#define ERROR_CANNOT_SWITCH_RUNLEVEL                       15400
#define ERROR_INVALID_RUNLEVEL_SETTING                     15401
#define ERROR_RUNLEVEL_SWITCH_TIMEOUT                      15402
#define ERROR_RUNLEVEL_SWITCH_AGENT_TIMEOUT                15403
#define ERROR_RUNLEVEL_SWITCH_IN_PROGRESS                  15404
#define ERROR_SERVICES_FAILED_AUTOSTART                    15405
#define ERROR_COM_TASK_STOP_PENDING                        15501
#define ERROR_INSTALL_OPEN_PACKAGE_FAILED                  15600
#define ERROR_INSTALL_PACKAGE_NOT_FOUND                    15601
#define ERROR_INSTALL_INVALID_PACKAGE                      15602
#define ERROR_INSTALL_RESOLVE_DEPENDENCY_FAILED            15603
#define ERROR_INSTALL_OUT_OF_DISK_SPACE                    15604
#define ERROR_INSTALL_NETWORK_FAILURE                      15605
#define ERROR_INSTALL_REGISTRATION_FAILURE                 15606
#define ERROR_INSTALL_DEREGISTRATION_FAILURE               15607
#define ERROR_INSTALL_CANCEL                               15608
#define ERROR_INSTALL_FAILED                               15609
#define ERROR_REMOVE_FAILED                                15610
#define ERROR_PACKAGE_ALREADY_EXISTS                       15611
#define ERROR_NEEDS_REMEDIATION                            15612
#define ERROR_INSTALL_PREREQUISITE_FAILED                  15613
#define ERROR_PACKAGE_REPOSITORY_CORRUPTED                 15614
#define ERROR_INSTALL_POLICY_FAILURE                       15615
#define ERROR_PACKAGE_UPDATING                             15616
#define ERROR_DEPLOYMENT_BLOCKED_BY_POLICY                 15617
#define ERROR_PACKAGES_IN_USE                              15618
#define ERROR_RECOVERY_FILE_CORRUPT                        15619
#define ERROR_INVALID_STAGED_SIGNATURE                     15620
#define ERROR_DELETING_EXISTING_APPLICATIONDATA_STORE_FAILED 15621
#define ERROR_INSTALL_PACKAGE_DOWNGRADE                    15622
#define ERROR_SYSTEM_NEEDS_REMEDIATION                     15623
#define ERROR_APPX_INTEGRITY_FAILURE_CLR_NGEN              15624
#define ERROR_RESILIENCY_FILE_CORRUPT                      15625
#define ERROR_INSTALL_FIREWALL_SERVICE_NOT_RUNNING         15626
#define ERROR_PACKAGE_MOVE_FAILED                          15627
#define ERROR_INSTALL_VOLUME_NOT_EMPTY                     15628
#define ERROR_INSTALL_VOLUME_OFFLINE                       15629
#define ERROR_INSTALL_VOLUME_CORRUPT                       15630
#define ERROR_NEEDS_REGISTRATION                           15631
#define ERROR_INSTALL_WRONG_PROCESSOR_ARCHITECTURE         15632
#define ERROR_DEV_SIDELOAD_LIMIT_EXCEEDED                  15633
#define ERROR_INSTALL_OPTIONAL_PACKAGE_REQUIRES_MAIN_PACKAGE 15634
#define ERROR_PACKAGE_NOT_SUPPORTED_ON_FILESYSTEM          15635
#define ERROR_PACKAGE_MOVE_BLOCKED_BY_STREAMING            15636
#define ERROR_INSTALL_OPTIONAL_PACKAGE_APPLICATIONID_NOT_UNIQUE 15637
#define ERROR_PACKAGE_STAGING_ONHOLD                       15638
#define ERROR_INSTALL_INVALID_RELATED_SET_UPDATE           15639
#define ERROR_INSTALL_OPTIONAL_PACKAGE_REQUIRES_MAIN_PACKAGE_FULLTRUST_CAPABILITY 15640
#define ERROR_DEPLOYMENT_BLOCKED_BY_USER_LOG_OFF           15641
#define ERROR_PROVISION_OPTIONAL_PACKAGE_REQUIRES_MAIN_PACKAGE_PROVISIONED 15642
#define ERROR_PACKAGES_REPUTATION_CHECK_FAILED             15643
#define ERROR_PACKAGES_REPUTATION_CHECK_TIMEDOUT           15644
#define ERROR_DEPLOYMENT_OPTION_NOT_SUPPORTED              15645
#define ERROR_APPINSTALLER_ACTIVATION_BLOCKED              15646
#define ERROR_REGISTRATION_FROM_REMOTE_DRIVE_NOT_SUPPORTED 15647
#define ERROR_APPX_RAW_DATA_WRITE_FAILED                   15648
#define ERROR_DEPLOYMENT_BLOCKED_BY_VOLUME_POLICY_PACKAGE  15649
#define ERROR_DEPLOYMENT_BLOCKED_BY_VOLUME_POLICY_MACHINE  15650
#define ERROR_DEPLOYMENT_BLOCKED_BY_PROFILE_POLICY         15651
#define ERROR_DEPLOYMENT_FAILED_CONFLICTING_MUTABLE_PACKAGE_DIRECTORY 15652
#define ERROR_SINGLETON_RESOURCE_INSTALLED_IN_ACTIVE_USER  15653
#define ERROR_DIFFERENT_VERSION_OF_PACKAGED_SERVICE_INSTALLED 15654
#define ERROR_SERVICE_EXISTS_AS_NON_PACKAGED_SERVICE       15655
#define ERROR_PACKAGED_SERVICE_REQUIRES_ADMIN_PRIVILEGES   15656
#define ERROR_REDIRECTION_TO_DEFAULT_ACCOUNT_NOT_ALLOWED   15657
#define ERROR_PACKAGE_LACKS_CAPABILITY_TO_DEPLOY_ON_HOST   15658
#define ERROR_UNSIGNED_PACKAGE_INVALID_CONTENT             15659
#define ERROR_UNSIGNED_PACKAGE_INVALID_PUBLISHER_NAMESPACE 15660
#define ERROR_SIGNED_PACKAGE_INVALID_PUBLISHER_NAMESPACE   15661
#define ERROR_PACKAGE_EXTERNAL_LOCATION_NOT_ALLOWED        15662
#define ERROR_INSTALL_FULLTRUST_HOSTRUNTIME_REQUIRES_MAIN_PACKAGE_FULLTRUST_CAPABILITY 15663
#define ERROR_PACKAGE_LACKS_CAPABILITY_FOR_MANDATORY_STARTUPTASKS 15664
#define ERROR_INSTALL_RESOLVE_HOSTRUNTIME_DEPENDENCY_FAILED 15665
#define ERROR_MACHINE_SCOPE_NOT_ALLOWED                    15666
#define ERROR_CLASSIC_COMPAT_MODE_NOT_ALLOWED              15667
#define ERROR_STAGEFROMUPDATEAGENT_PACKAGE_NOT_APPLICABLE  15668
#define ERROR_PACKAGE_NOT_REGISTERED_FOR_USER              15669
#define ERROR_PACKAGE_NAME_MISMATCH                        15670
#define ERROR_APPINSTALLER_URI_IN_USE                      15671
#define ERROR_APPINSTALLER_IS_MANAGED_BY_SYSTEM            15672
#define APPMODEL_ERROR_NO_PACKAGE                          15700
#define APPMODEL_ERROR_PACKAGE_RUNTIME_CORRUPT             15701
#define APPMODEL_ERROR_PACKAGE_IDENTITY_CORRUPT            15702
#define APPMODEL_ERROR_NO_APPLICATION                      15703
#define APPMODEL_ERROR_DYNAMIC_PROPERTY_READ_FAILED        15704
#define APPMODEL_ERROR_DYNAMIC_PROPERTY_INVALID            15705
#define APPMODEL_ERROR_PACKAGE_NOT_AVAILABLE               15706
#define APPMODEL_ERROR_NO_MUTABLE_DIRECTORY                15707
#define ERROR_STATE_LOAD_STORE_FAILED                      15800
#define ERROR_STATE_GET_VERSION_FAILED                     15801
#define ERROR_STATE_SET_VERSION_FAILED                     15802
#define ERROR_STATE_STRUCTURED_RESET_FAILED                15803
#define ERROR_STATE_OPEN_CONTAINER_FAILED                  15804
#define ERROR_STATE_CREATE_CONTAINER_FAILED                15805
#define ERROR_STATE_DELETE_CONTAINER_FAILED                15806
#define ERROR_STATE_READ_SETTING_FAILED                    15807
#define ERROR_STATE_WRITE_SETTING_FAILED                   15808
#define ERROR_STATE_DELETE_SETTING_FAILED                  15809
#define ERROR_STATE_QUERY_SETTING_FAILED                   15810
#define ERROR_STATE_READ_COMPOSITE_SETTING_FAILED          15811
#define ERROR_STATE_WRITE_COMPOSITE_SETTING_FAILED         15812
#define ERROR_STATE_ENUMERATE_CONTAINER_FAILED             15813
#define ERROR_STATE_ENUMERATE_SETTINGS_FAILED              15814
#define ERROR_STATE_COMPOSITE_SETTING_VALUE_SIZE_LIMIT_EXCEEDED 15815
#define ERROR_STATE_SETTING_VALUE_SIZE_LIMIT_EXCEEDED      15816
#define ERROR_STATE_SETTING_NAME_SIZE_LIMIT_EXCEEDED       15817
#define ERROR_STATE_CONTAINER_NAME_SIZE_LIMIT_EXCEEDED     15818
#define ERROR_API_UNAVAILABLE                              15841
#define STORE_ERROR_UNLICENSED                             15861
#define STORE_ERROR_UNLICENSED_USER                        15862
#define STORE_ERROR_PENDING_COM_TRANSACTION                15863
#define STORE_ERROR_LICENSE_REVOKED                        15864

/* HRESULT values for OLE, SHELL and other Interface stuff */
/* the codes 4000-40ff are reserved for OLE */
#undef NOERROR  /* arpa/nameser_compat.h defines this */

#define E_NOT_SUFFICIENT_BUFFER                            HRESULT_FROM_WIN32(ERROR_INSUFFICIENT_BUFFER)
#define E_NOT_VALID_STATE                                  HRESULT_FROM_WIN32(ERROR_INVALID_STATE)

#ifdef RC_INVOKED
#define _HRESULT_TYPEDEF_(x) (x)
#define _NDIS_ERROR_TYPEDEF_(x) (x)
#else
#define _HRESULT_TYPEDEF_(x) ((HRESULT)x)
#define _NDIS_ERROR_TYPEDEF_(x) ((DWORD)x)
#endif

#define NOERROR                                            _HRESULT_TYPEDEF_(0)
#define S_OK                                               _HRESULT_TYPEDEF_(0)
#define SEC_E_OK                                           _HRESULT_TYPEDEF_(0)
#define S_FALSE                                            _HRESULT_TYPEDEF_(1)

#define E_PENDING                                          _HRESULT_TYPEDEF_(0x8000000A)
#define E_BOUNDS                                           _HRESULT_TYPEDEF_(0x8000000B)
#define E_CHANGED_STATE                                    _HRESULT_TYPEDEF_(0x8000000C)
#define E_ILLEGAL_STATE_CHANGE                             _HRESULT_TYPEDEF_(0x8000000D)
#define E_ILLEGAL_METHOD_CALL                              _HRESULT_TYPEDEF_(0x8000000E)
#define RO_E_METADATA_NAME_NOT_FOUND                       _HRESULT_TYPEDEF_(0x8000000F)
#define RO_E_METADATA_NAME_IS_NAMESPACE                    _HRESULT_TYPEDEF_(0x80000010)
#define RO_E_METADATA_INVALID_TYPE_FORMAT                  _HRESULT_TYPEDEF_(0x80000011)
#define RO_E_INVALID_METADATA_FILE                         _HRESULT_TYPEDEF_(0x80000012)
#define RO_E_CLOSED                                        _HRESULT_TYPEDEF_(0x80000013)
#define RO_E_EXCLUSIVE_WRITE                               _HRESULT_TYPEDEF_(0x80000014)
#define RO_E_CHANGE_NOTIFICATION_IN_PROGRESS               _HRESULT_TYPEDEF_(0x80000015)
#define RO_E_ERROR_STRING_NOT_FOUND                        _HRESULT_TYPEDEF_(0x80000016)
#define E_STRING_NOT_NULL_TERMINATED                       _HRESULT_TYPEDEF_(0x80000017)
#define E_ILLEGAL_DELEGATE_ASSIGNMENT                      _HRESULT_TYPEDEF_(0x80000018)
#define E_ASYNC_OPERATION_NOT_STARTED                      _HRESULT_TYPEDEF_(0x80000019)
#define E_APPLICATION_EXITING                              _HRESULT_TYPEDEF_(0x8000001A)
#define E_APPLICATION_VIEW_EXITING                         _HRESULT_TYPEDEF_(0x8000001B)
#define RO_E_MUST_BE_AGILE                                 _HRESULT_TYPEDEF_(0x8000001C)
#define RO_E_UNSUPPORTED_FROM_MTA                          _HRESULT_TYPEDEF_(0x8000001D)
#define RO_E_COMMITTED                                     _HRESULT_TYPEDEF_(0x8000001E)
#define RO_E_BLOCKED_CROSS_ASTA_CALL                       _HRESULT_TYPEDEF_(0x8000001F)
#define RO_E_CANNOT_ACTIVATE_FULL_TRUST_SERVER             _HRESULT_TYPEDEF_(0x80000020)
#define RO_E_CANNOT_ACTIVATE_UNIVERSAL_APPLICATION_SERVER  _HRESULT_TYPEDEF_(0x80000021)

#define E_NOTIMPL                                          _HRESULT_TYPEDEF_(0x80004001)
#define E_NOINTERFACE                                      _HRESULT_TYPEDEF_(0x80004002)
#define E_POINTER                                          _HRESULT_TYPEDEF_(0x80004003)
#define E_ABORT                                            _HRESULT_TYPEDEF_(0x80004004)
#define E_FAIL                                             _HRESULT_TYPEDEF_(0x80004005)
#define CO_E_INIT_TLS                                      _HRESULT_TYPEDEF_(0x80004006)
#define CO_E_INIT_SHARED_ALLOCATOR                         _HRESULT_TYPEDEF_(0x80004007)
#define CO_E_INIT_MEMORY_ALLOCATOR                         _HRESULT_TYPEDEF_(0x80004008)
#define CO_E_INIT_CLASS_CACHE                              _HRESULT_TYPEDEF_(0x80004009)
#define CO_E_INIT_RPC_CHANNEL                              _HRESULT_TYPEDEF_(0x8000400A)
#define CO_E_INIT_TLS_SET_CHANNEL_CONTROL                  _HRESULT_TYPEDEF_(0x8000400B)
#define CO_E_INIT_TLS_CHANNEL_CONTROL                      _HRESULT_TYPEDEF_(0x8000400C)
#define CO_E_INIT_UNACCEPTED_USER_ALLOCATOR                _HRESULT_TYPEDEF_(0x8000400D)
#define CO_E_INIT_SCM_MUTEX_EXISTS                         _HRESULT_TYPEDEF_(0x8000400E)
#define CO_E_INIT_SCM_FILE_MAPPING_EXISTS                  _HRESULT_TYPEDEF_(0x8000400F)
#define CO_E_INIT_SCM_MAP_VIEW_OF_FILE                     _HRESULT_TYPEDEF_(0x80004010)
#define CO_E_INIT_SCM_EXEC_FAILURE                         _HRESULT_TYPEDEF_(0x80004011)
#define CO_E_INIT_ONLY_SINGLE_THREADED                     _HRESULT_TYPEDEF_(0x80004012)
#define CO_E_CANT_REMOTE                                   _HRESULT_TYPEDEF_(0x80004013)
#define CO_E_BAD_SERVER_NAME                               _HRESULT_TYPEDEF_(0x80004014)
#define CO_E_WRONG_SERVER_IDENTITY                         _HRESULT_TYPEDEF_(0x80004015)
#define CO_E_OLE1DDE_DISABLED                              _HRESULT_TYPEDEF_(0x80004016)
#define CO_E_RUNAS_SYNTAX                                  _HRESULT_TYPEDEF_(0x80004017)
#define CO_E_CREATEPROCESS_FAILURE                         _HRESULT_TYPEDEF_(0x80004018)
#define CO_E_RUNAS_CREATEPROCESS_FAILURE                   _HRESULT_TYPEDEF_(0x80004019)
#define CO_E_RUNAS_LOGON_FAILURE                           _HRESULT_TYPEDEF_(0x8000401A)
#define CO_E_LAUNCH_PERMISSION_DENIED                      _HRESULT_TYPEDEF_(0x8000401B)
#define CO_E_START_SERVICE_FAILURE                         _HRESULT_TYPEDEF_(0x8000401C)
#define CO_E_REMOTE_COMMUNICATION_FAILURE                  _HRESULT_TYPEDEF_(0x8000401D)
#define CO_E_SERVER_START_TIMEOUT                          _HRESULT_TYPEDEF_(0x8000401E)
#define CO_E_CLSREG_INCONSISTENT                           _HRESULT_TYPEDEF_(0x8000401F)
#define CO_E_IIDREG_INCONSISTENT                           _HRESULT_TYPEDEF_(0x80004020)
#define CO_E_NOT_SUPPORTED                                 _HRESULT_TYPEDEF_(0x80004021)
#define CO_E_RELOAD_DLL                                    _HRESULT_TYPEDEF_(0x80004022)
#define CO_E_MSI_ERROR                                     _HRESULT_TYPEDEF_(0x80004023)
#define CO_E_ATTEMPT_TO_CREATE_OUTSIDE_CLIENT_CONTEXT      _HRESULT_TYPEDEF_(0x80004024)
#define CO_E_SERVER_PAUSED                                 _HRESULT_TYPEDEF_(0x80004025)
#define CO_E_SERVER_NOT_PAUSED                             _HRESULT_TYPEDEF_(0x80004026)
#define CO_E_CLASS_DISABLED                                _HRESULT_TYPEDEF_(0x80004027)
#define CO_E_CLRNOTAVAILABLE                               _HRESULT_TYPEDEF_(0x80004028)
#define CO_E_ASYNC_WORK_REJECTED                           _HRESULT_TYPEDEF_(0x80004029)
#define CO_E_SERVER_INIT_TIMEOUT                           _HRESULT_TYPEDEF_(0x8000402A)
#define CO_E_NO_SECCTX_IN_ACTIVATE                         _HRESULT_TYPEDEF_(0x8000402B)
#define CO_E_TRACKER_CONFIG                                _HRESULT_TYPEDEF_(0x80004030)
#define CO_E_THREADPOOL_CONFIG                             _HRESULT_TYPEDEF_(0x80004031)
#define CO_E_SXS_CONFIG                                    _HRESULT_TYPEDEF_(0x80004032)
#define CO_E_MALFORMED_SPN                                 _HRESULT_TYPEDEF_(0x80004033)
#define CO_E_UNREVOKED_REGISTRATION_ON_APARTMENT_SHUTDOWN  _HRESULT_TYPEDEF_(0x80004034)
#define CO_E_PREMATURE_STUB_RUNDOWN                        _HRESULT_TYPEDEF_(0x80004035)

#define E_UNEXPECTED                                       _HRESULT_TYPEDEF_(0x8000FFFF)

#define RPC_E_CALL_REJECTED                                _HRESULT_TYPEDEF_(0x80010001)
#define RPC_E_CALL_CANCELED                                _HRESULT_TYPEDEF_(0x80010002)
#define RPC_E_CANTPOST_INSENDCALL                          _HRESULT_TYPEDEF_(0x80010003)
#define RPC_E_CANTCALLOUT_INASYNCCALL                      _HRESULT_TYPEDEF_(0x80010004)
#define RPC_E_CANTCALLOUT_INEXTERNALCALL                   _HRESULT_TYPEDEF_(0x80010005)
#define RPC_E_CONNECTION_TERMINATED                        _HRESULT_TYPEDEF_(0x80010006)
#define RPC_E_SERVER_DIED                                  _HRESULT_TYPEDEF_(0x80010007)
#define RPC_E_CLIENT_DIED                                  _HRESULT_TYPEDEF_(0x80010008)
#define RPC_E_INVALID_DATAPACKET                           _HRESULT_TYPEDEF_(0x80010009)
#define RPC_E_CANTTRANSMIT_CALL                            _HRESULT_TYPEDEF_(0x8001000A)
#define RPC_E_CLIENT_CANTMARSHAL_DATA                      _HRESULT_TYPEDEF_(0x8001000B)
#define RPC_E_CLIENT_CANTUNMARSHAL_DATA                    _HRESULT_TYPEDEF_(0x8001000C)
#define RPC_E_SERVER_CANTMARSHAL_DATA                      _HRESULT_TYPEDEF_(0x8001000D)
#define RPC_E_SERVER_CANTUNMARSHAL_DATA                    _HRESULT_TYPEDEF_(0x8001000E)
#define RPC_E_INVALID_DATA                                 _HRESULT_TYPEDEF_(0x8001000F)
#define RPC_E_INVALID_PARAMETER                            _HRESULT_TYPEDEF_(0x80010010)
#define RPC_E_CANTCALLOUT_AGAIN                            _HRESULT_TYPEDEF_(0x80010011)
#define RPC_E_SERVER_DIED_DNE                              _HRESULT_TYPEDEF_(0x80010012)
#define RPC_E_SYS_CALL_FAILED                              _HRESULT_TYPEDEF_(0x80010100)
#define RPC_E_OUT_OF_RESOURCES                             _HRESULT_TYPEDEF_(0x80010101)
#define RPC_E_ATTEMPTED_MULTITHREAD                        _HRESULT_TYPEDEF_(0x80010102)
#define RPC_E_NOT_REGISTERED                               _HRESULT_TYPEDEF_(0x80010103)
#define RPC_E_FAULT                                        _HRESULT_TYPEDEF_(0x80010104)
#define RPC_E_SERVERFAULT                                  _HRESULT_TYPEDEF_(0x80010105)
#define RPC_E_CHANGED_MODE                                 _HRESULT_TYPEDEF_(0x80010106)
#define RPC_E_INVALIDMETHOD                                _HRESULT_TYPEDEF_(0x80010107)
#define RPC_E_DISCONNECTED                                 _HRESULT_TYPEDEF_(0x80010108)
#define RPC_E_RETRY                                        _HRESULT_TYPEDEF_(0x80010109)
#define RPC_E_SERVERCALL_RETRYLATER                        _HRESULT_TYPEDEF_(0x8001010A)
#define RPC_E_SERVERCALL_REJECTED                          _HRESULT_TYPEDEF_(0x8001010B)
#define RPC_E_INVALID_CALLDATA                             _HRESULT_TYPEDEF_(0x8001010C)
#define RPC_E_CANTCALLOUT_ININPUTSYNCCALL                  _HRESULT_TYPEDEF_(0x8001010D)
#define RPC_E_WRONG_THREAD                                 _HRESULT_TYPEDEF_(0x8001010E)
#define RPC_E_THREAD_NOT_INIT                              _HRESULT_TYPEDEF_(0x8001010F)
#define RPC_E_VERSION_MISMATCH                             _HRESULT_TYPEDEF_(0x80010110)
#define RPC_E_INVALID_HEADER                               _HRESULT_TYPEDEF_(0x80010111)
#define RPC_E_INVALID_EXTENSION                            _HRESULT_TYPEDEF_(0x80010112)
#define RPC_E_INVALID_IPID                                 _HRESULT_TYPEDEF_(0x80010113)
#define RPC_E_INVALID_OBJECT                               _HRESULT_TYPEDEF_(0x80010114)
#define RPC_S_CALLPENDING                                  _HRESULT_TYPEDEF_(0x80010115)
#define RPC_S_WAITONTIMER                                  _HRESULT_TYPEDEF_(0x80010116)
#define RPC_E_CALL_COMPLETE                                _HRESULT_TYPEDEF_(0x80010117)
#define RPC_E_UNSECURE_CALL                                _HRESULT_TYPEDEF_(0x80010118)
#define RPC_E_TOO_LATE                                     _HRESULT_TYPEDEF_(0x80010119)
#define RPC_E_NO_GOOD_SECURITY_PACKAGES                    _HRESULT_TYPEDEF_(0x8001011A)
#define RPC_E_ACCESS_DENIED                                _HRESULT_TYPEDEF_(0x8001011B)
#define RPC_E_REMOTE_DISABLED                              _HRESULT_TYPEDEF_(0x8001011C)
#define RPC_E_INVALID_OBJREF                               _HRESULT_TYPEDEF_(0x8001011D)
#define RPC_E_NO_CONTEXT                                   _HRESULT_TYPEDEF_(0x8001011E)
#define RPC_E_TIMEOUT                                      _HRESULT_TYPEDEF_(0x8001011F)
#define RPC_E_NO_SYNC                                      _HRESULT_TYPEDEF_(0x80010120)
#define RPC_E_FULLSIC_REQUIRED                             _HRESULT_TYPEDEF_(0x80010121)
#define RPC_E_INVALID_STD_NAME                             _HRESULT_TYPEDEF_(0x80010122)
#define CO_E_FAILEDTOIMPERSONATE                           _HRESULT_TYPEDEF_(0x80010123)
#define CO_E_FAILEDTOGETSECCTX                             _HRESULT_TYPEDEF_(0x80010124)
#define CO_E_FAILEDTOOPENTHREADTOKEN                       _HRESULT_TYPEDEF_(0x80010125)
#define CO_E_FAILEDTOGETTOKENINFO                          _HRESULT_TYPEDEF_(0x80010126)
#define CO_E_TRUSTEEDOESNTMATCHCLIENT                      _HRESULT_TYPEDEF_(0x80010127)
#define CO_E_FAILEDTOQUERYCLIENTBLANKET                    _HRESULT_TYPEDEF_(0x80010128)
#define CO_E_FAILEDTOSETDACL                               _HRESULT_TYPEDEF_(0x80010129)
#define CO_E_ACCESSCHECKFAILED                             _HRESULT_TYPEDEF_(0x8001012A)
#define CO_E_NETACCESSAPIFAILED                            _HRESULT_TYPEDEF_(0x8001012B)
#define CO_E_WRONGTRUSTEENAMESYNTAX                        _HRESULT_TYPEDEF_(0x8001012C)
#define CO_E_INVALIDSID                                    _HRESULT_TYPEDEF_(0x8001012D)
#define CO_E_CONVERSIONFAILED                              _HRESULT_TYPEDEF_(0x8001012E)
#define CO_E_NOMATCHINGSIDFOUND                            _HRESULT_TYPEDEF_(0x8001012F)
#define CO_E_LOOKUPACCSIDFAILED                            _HRESULT_TYPEDEF_(0x80010130)
#define CO_E_NOMATCHINGNAMEFOUND                           _HRESULT_TYPEDEF_(0x80010131)
#define CO_E_LOOKUPACCNAMEFAILED                           _HRESULT_TYPEDEF_(0x80010132)
#define CO_E_SETSERLHNDLFAILED                             _HRESULT_TYPEDEF_(0x80010133)
#define CO_E_FAILEDTOGETWINDIR                             _HRESULT_TYPEDEF_(0x80010134)
#define CO_E_PATHTOOLONG                                   _HRESULT_TYPEDEF_(0x80010135)
#define CO_E_FAILEDTOGENUUID                               _HRESULT_TYPEDEF_(0x80010136)
#define CO_E_FAILEDTOCREATEFILE                            _HRESULT_TYPEDEF_(0x80010137)
#define CO_E_FAILEDTOCLOSEHANDLE                           _HRESULT_TYPEDEF_(0x80010138)
#define CO_E_EXCEEDSYSACLLIMIT                             _HRESULT_TYPEDEF_(0x80010139)
#define CO_E_ACESINWRONGORDER                              _HRESULT_TYPEDEF_(0x8001013A)
#define CO_E_INCOMPATIBLESTREAMVERSION                     _HRESULT_TYPEDEF_(0x8001013B)
#define CO_E_FAILEDTOOPENPROCESSTOKEN                      _HRESULT_TYPEDEF_(0x8001013C)
#define CO_E_DECODEFAILED                                  _HRESULT_TYPEDEF_(0x8001013D)
#define CO_E_ACNOTINITIALIZED                              _HRESULT_TYPEDEF_(0x8001013F)
#define CO_E_CANCEL_DISABLED                               _HRESULT_TYPEDEF_(0x80010140)
#define RPC_E_UNEXPECTED                                   _HRESULT_TYPEDEF_(0x8001FFFF)

#define DISP_E_UNKNOWNINTERFACE                            _HRESULT_TYPEDEF_(0x80020001)
#define DISP_E_MEMBERNOTFOUND                              _HRESULT_TYPEDEF_(0x80020003)
#define DISP_E_PARAMNOTFOUND                               _HRESULT_TYPEDEF_(0x80020004)
#define DISP_E_TYPEMISMATCH                                _HRESULT_TYPEDEF_(0x80020005)
#define DISP_E_UNKNOWNNAME                                 _HRESULT_TYPEDEF_(0x80020006)
#define DISP_E_NONAMEDARGS                                 _HRESULT_TYPEDEF_(0x80020007)
#define DISP_E_BADVARTYPE                                  _HRESULT_TYPEDEF_(0x80020008)
#define DISP_E_EXCEPTION                                   _HRESULT_TYPEDEF_(0x80020009)
#define DISP_E_OVERFLOW                                    _HRESULT_TYPEDEF_(0x8002000A)
#define DISP_E_BADINDEX                                    _HRESULT_TYPEDEF_(0x8002000B)
#define DISP_E_UNKNOWNLCID                                 _HRESULT_TYPEDEF_(0x8002000C)
#define DISP_E_ARRAYISLOCKED                               _HRESULT_TYPEDEF_(0x8002000D)
#define DISP_E_BADPARAMCOUNT                               _HRESULT_TYPEDEF_(0x8002000E)
#define DISP_E_PARAMNOTOPTIONAL                            _HRESULT_TYPEDEF_(0x8002000F)
#define DISP_E_BADCALLEE                                   _HRESULT_TYPEDEF_(0x80020010)
#define DISP_E_NOTACOLLECTION                              _HRESULT_TYPEDEF_(0x80020011)
#define DISP_E_DIVBYZERO                                   _HRESULT_TYPEDEF_(0x80020012)
#define DISP_E_BUFFERTOOSMALL                              _HRESULT_TYPEDEF_(0x80020013)
#define TYPE_E_BUFFERTOOSMALL                              _HRESULT_TYPEDEF_(0x80028016)
#define TYPE_E_FIELDNOTFOUND                               _HRESULT_TYPEDEF_(0x80028017)
#define TYPE_E_INVDATAREAD                                 _HRESULT_TYPEDEF_(0x80028018)
#define TYPE_E_UNSUPFORMAT                                 _HRESULT_TYPEDEF_(0x80028019)
#define TYPE_E_REGISTRYACCESS                              _HRESULT_TYPEDEF_(0x8002801C)
#define TYPE_E_LIBNOTREGISTERED                            _HRESULT_TYPEDEF_(0x8002801D)
#define TYPE_E_UNDEFINEDTYPE                               _HRESULT_TYPEDEF_(0x80028027)
#define TYPE_E_QUALIFIEDNAMEDISALLOWED                     _HRESULT_TYPEDEF_(0x80028028)
#define TYPE_E_INVALIDSTATE                                _HRESULT_TYPEDEF_(0x80028029)
#define TYPE_E_WRONGTYPEKIND                               _HRESULT_TYPEDEF_(0x8002802A)
#define TYPE_E_ELEMENTNOTFOUND                             _HRESULT_TYPEDEF_(0x8002802B)
#define TYPE_E_AMBIGUOUSNAME                               _HRESULT_TYPEDEF_(0x8002802C)
#define TYPE_E_NAMECONFLICT                                _HRESULT_TYPEDEF_(0x8002802D)
#define TYPE_E_UNKNOWNLCID                                 _HRESULT_TYPEDEF_(0x8002802E)
#define TYPE_E_DLLFUNCTIONNOTFOUND                         _HRESULT_TYPEDEF_(0x8002802F)
#define TYPE_E_BADMODULEKIND                               _HRESULT_TYPEDEF_(0x800288BD)
#define TYPE_E_SIZETOOBIG                                  _HRESULT_TYPEDEF_(0x800288C5)
#define TYPE_E_DUPLICATEID                                 _HRESULT_TYPEDEF_(0x800288C6)
#define TYPE_E_INVALIDID                                   _HRESULT_TYPEDEF_(0x800288CF)
#define TYPE_E_TYPEMISMATCH                                _HRESULT_TYPEDEF_(0x80028CA0)
#define TYPE_E_OUTOFBOUNDS                                 _HRESULT_TYPEDEF_(0x80028CA1)
#define TYPE_E_IOERROR                                     _HRESULT_TYPEDEF_(0x80028CA2)
#define TYPE_E_CANTCREATETMPFILE                           _HRESULT_TYPEDEF_(0x80028CA3)
#define TYPE_E_CANTLOADLIBRARY                             _HRESULT_TYPEDEF_(0x80029C4A)
#define TYPE_E_INCONSISTENTPROPFUNCS                       _HRESULT_TYPEDEF_(0x80029C83)
#define TYPE_E_CIRCULARTYPE                                _HRESULT_TYPEDEF_(0x80029C84)

#define STG_E_INVALIDFUNCTION                              _HRESULT_TYPEDEF_(0x80030001)
#define STG_E_FILENOTFOUND                                 _HRESULT_TYPEDEF_(0x80030002)
#define STG_E_PATHNOTFOUND                                 _HRESULT_TYPEDEF_(0x80030003)
#define STG_E_TOOMANYOPENFILES                             _HRESULT_TYPEDEF_(0x80030004)
#define STG_E_ACCESSDENIED                                 _HRESULT_TYPEDEF_(0x80030005)
#define STG_E_INVALIDHANDLE                                _HRESULT_TYPEDEF_(0x80030006)
#define STG_E_INSUFFICIENTMEMORY                           _HRESULT_TYPEDEF_(0x80030008)
#define STG_E_INVALIDPOINTER                               _HRESULT_TYPEDEF_(0x80030009)
#define STG_E_NOMOREFILES                                  _HRESULT_TYPEDEF_(0x80030012)
#define STG_E_DISKISWRITEPROTECTED                         _HRESULT_TYPEDEF_(0x80030013)
#define STG_E_SEEKERROR                                    _HRESULT_TYPEDEF_(0x80030019)
#define STG_E_WRITEFAULT                                   _HRESULT_TYPEDEF_(0x8003001D)
#define STG_E_READFAULT                                    _HRESULT_TYPEDEF_(0x8003001E)
#define STG_E_SHAREVIOLATION                               _HRESULT_TYPEDEF_(0x80030020)
#define STG_E_LOCKVIOLATION                                _HRESULT_TYPEDEF_(0x80030021)
#define STG_E_FILEALREADYEXISTS                            _HRESULT_TYPEDEF_(0x80030050)
#define STG_E_INVALIDPARAMETER                             _HRESULT_TYPEDEF_(0x80030057)
#define STG_E_MEDIUMFULL                                   _HRESULT_TYPEDEF_(0x80030070)
#define STG_E_PROPSETMISMATCHED                            _HRESULT_TYPEDEF_(0x800300F0)
#define STG_E_ABNORMALAPIEXIT                              _HRESULT_TYPEDEF_(0x800300FA)
#define STG_E_INVALIDHEADER                                _HRESULT_TYPEDEF_(0x800300FB)
#define STG_E_INVALIDNAME                                  _HRESULT_TYPEDEF_(0x800300FC)
#define STG_E_UNKNOWN                                      _HRESULT_TYPEDEF_(0x800300FD)
#define STG_E_UNIMPLEMENTEDFUNCTION                        _HRESULT_TYPEDEF_(0x800300FE)
#define STG_E_INVALIDFLAG                                  _HRESULT_TYPEDEF_(0x800300FF)
#define STG_E_INUSE                                        _HRESULT_TYPEDEF_(0x80030100)
#define STG_E_NOTCURRENT                                   _HRESULT_TYPEDEF_(0x80030101)
#define STG_E_REVERTED                                     _HRESULT_TYPEDEF_(0x80030102)
#define STG_E_CANTSAVE                                     _HRESULT_TYPEDEF_(0x80030103)
#define STG_E_OLDFORMAT                                    _HRESULT_TYPEDEF_(0x80030104)
#define STG_E_OLDDLL                                       _HRESULT_TYPEDEF_(0x80030105)
#define STG_E_SHAREREQUIRED                                _HRESULT_TYPEDEF_(0x80030106)
#define STG_E_NOTFILEBASEDSTORAGE                          _HRESULT_TYPEDEF_(0x80030107)
#define STG_E_EXTANTMARSHALLINGS                           _HRESULT_TYPEDEF_(0x80030108)
#define STG_E_DOCFILECORRUPT                               _HRESULT_TYPEDEF_(0x80030109)
#define STG_E_BADBASEADDRESS                               _HRESULT_TYPEDEF_(0x80030110)
#define STG_E_DOCFILETOOLARGE                              _HRESULT_TYPEDEF_(0x80030111)
#define STG_E_NOTSIMPLEFORMAT                              _HRESULT_TYPEDEF_(0x80030112)

#define STG_S_CONVERTED                                    _HRESULT_TYPEDEF_(0x00030200)
#define STG_S_BLOCK                                        _HRESULT_TYPEDEF_(0x00030201)
#define STG_E_INCOMPLETE                                   _HRESULT_TYPEDEF_(0x80030201)
#define STG_S_RETRYNOW                                     _HRESULT_TYPEDEF_(0x00030202)
#define STG_E_TERMINATED                                   _HRESULT_TYPEDEF_(0x80030202)
#define STG_S_MONITORING                                   _HRESULT_TYPEDEF_(0x00030203)
#define STG_S_MULTIPLEOPENS                                _HRESULT_TYPEDEF_(0x00030204)
#define STG_S_CONSOLIDATIONFAILED                          _HRESULT_TYPEDEF_(0x00030205)
#define STG_S_CANNOTCONSOLIDATE                            _HRESULT_TYPEDEF_(0x00030206)
#define STG_S_POWER_CYCLE_REQUIRED                         _HRESULT_TYPEDEF_(0x00030207)
#define STG_E_FIRMWARE_SLOT_INVALID                        _HRESULT_TYPEDEF_(0x80030208)
#define STG_E_FIRMWARE_IMAGE_INVALID                       _HRESULT_TYPEDEF_(0x80030209)
#define STG_E_DEVICE_UNRESPONSIVE                          _HRESULT_TYPEDEF_(0x8003020A)

#define STG_E_STATUS_COPY_PROTECTION_FAILURE               _HRESULT_TYPEDEF_(0x80030305)
#define STG_E_CSS_AUTHENTICATION_FAILURE                   _HRESULT_TYPEDEF_(0x80030306)
#define STG_E_CSS_KEY_NOT_PRESENT                          _HRESULT_TYPEDEF_(0x80030307)
#define STG_E_CSS_KEY_NOT_ESTABLISHED                      _HRESULT_TYPEDEF_(0x80030308)
#define STG_E_CSS_SCRAMBLED_SECTOR                         _HRESULT_TYPEDEF_(0x80030309)
#define STG_E_CSS_REGION_MISMATCH                          _HRESULT_TYPEDEF_(0x8003030A)
#define STG_E_RESETS_EXHAUSTED                             _HRESULT_TYPEDEF_(0x8003030B)

#define OLE_S_FIRST                                        _HRESULT_TYPEDEF_(0x00040000)
#define OLE_E_FIRST                                        _HRESULT_TYPEDEF_(0x80040000)
#define OLE_S_USEREG                                       _HRESULT_TYPEDEF_(0x00040000)
#define OLE_E_OLEVERB                                      _HRESULT_TYPEDEF_(0x80040000)
#define OLE_S_STATIC                                       _HRESULT_TYPEDEF_(0x00040001)
#define OLE_E_ADVF                                         _HRESULT_TYPEDEF_(0x80040001)
#define OLE_S_MAC_CLIPFORMAT                               _HRESULT_TYPEDEF_(0x00040002)
#define OLE_E_ENUM_NOMORE                                  _HRESULT_TYPEDEF_(0x80040002)
#define OLE_E_ADVISENOTSUPPORTED                           _HRESULT_TYPEDEF_(0x80040003)
#define OLE_E_NOCONNECTION                                 _HRESULT_TYPEDEF_(0x80040004)
#define OLE_E_NOTRUNNING                                   _HRESULT_TYPEDEF_(0x80040005)
#define OLE_E_NOCACHE                                      _HRESULT_TYPEDEF_(0x80040006)
#define OLE_E_BLANK                                        _HRESULT_TYPEDEF_(0x80040007)
#define OLE_E_CLASSDIFF                                    _HRESULT_TYPEDEF_(0x80040008)
#define OLE_E_CANT_GETMONIKER                              _HRESULT_TYPEDEF_(0x80040009)
#define OLE_E_CANT_BINDTOSOURCE                            _HRESULT_TYPEDEF_(0x8004000A)
#define OLE_E_STATIC                                       _HRESULT_TYPEDEF_(0x8004000B)
#define OLE_E_PROMPTSAVECANCELLED                          _HRESULT_TYPEDEF_(0x8004000C)
#define OLE_E_INVALIDRECT                                  _HRESULT_TYPEDEF_(0x8004000D)
#define OLE_E_WRONGCOMPOBJ                                 _HRESULT_TYPEDEF_(0x8004000E)
#define OLE_E_INVALIDHWND                                  _HRESULT_TYPEDEF_(0x8004000F)
#define OLE_E_NOT_INPLACEACTIVE                            _HRESULT_TYPEDEF_(0x80040010)
#define OLE_E_CANTCONVERT                                  _HRESULT_TYPEDEF_(0x80040011)
#define OLE_E_NOSTORAGE                                    _HRESULT_TYPEDEF_(0x80040012)
#define DV_E_FORMATETC                                     _HRESULT_TYPEDEF_(0x80040064)
#define DV_E_DVTARGETDEVICE                                _HRESULT_TYPEDEF_(0x80040065)
#define DV_E_STGMEDIUM                                     _HRESULT_TYPEDEF_(0x80040066)
#define DV_E_STATDATA                                      _HRESULT_TYPEDEF_(0x80040067)
#define DV_E_LINDEX                                        _HRESULT_TYPEDEF_(0x80040068)
#define DV_E_TYMED                                         _HRESULT_TYPEDEF_(0x80040069)
#define DV_E_CLIPFORMAT                                    _HRESULT_TYPEDEF_(0x8004006A)
#define DV_E_DVASPECT                                      _HRESULT_TYPEDEF_(0x8004006B)
#define DV_E_DVTARGETDEVICE_SIZE                           _HRESULT_TYPEDEF_(0x8004006C)
#define DV_E_NOIVIEWOBJECT                                 _HRESULT_TYPEDEF_(0x8004006D)
#define OLE_S_LAST                                         _HRESULT_TYPEDEF_(0x000400FF)
#define OLE_E_LAST                                         _HRESULT_TYPEDEF_(0x800400FF)

#define DRAGDROP_S_FIRST                                   0x00040100
#define DRAGDROP_S_DROP                                    _HRESULT_TYPEDEF_(0x00040100)
#define DRAGDROP_E_FIRST                                   0x80040100
#define DRAGDROP_E_NOTREGISTERED                           _HRESULT_TYPEDEF_(0x80040100)
#define DRAGDROP_S_CANCEL                                  _HRESULT_TYPEDEF_(0x00040101)
#define DRAGDROP_E_ALREADYREGISTERED                       _HRESULT_TYPEDEF_(0x80040101)
#define DRAGDROP_S_USEDEFAULTCURSORS                       _HRESULT_TYPEDEF_(0x00040102)
#define DRAGDROP_E_INVALIDHWND                             _HRESULT_TYPEDEF_(0x80040102)
#define DRAGDROP_E_CONCURRENT_DRAG_ATTEMPTED               _HRESULT_TYPEDEF_(0x80040103)
#define DRAGDROP_S_LAST                                    0x0004010F
#define DRAGDROP_E_LAST                                    0x8004010F

#define CLASSFACTORY_S_FIRST                               0x00040110
#define CLASSFACTORY_E_FIRST                               0x80040110
#define CLASS_E_NOAGGREGATION                              _HRESULT_TYPEDEF_(0x80040110)
#define CLASS_E_CLASSNOTAVAILABLE                          _HRESULT_TYPEDEF_(0x80040111)
#define CLASS_E_NOTLICENSED                                _HRESULT_TYPEDEF_(0x80040112)
#define CLASSFACTORY_S_LAST                                0x0004011F
#define CLASSFACTORY_E_LAST                                0x8004011F

#define MARSHAL_S_FIRST                                    0x00040120
#define MARSHAL_E_FIRST                                    0x80040120
#define MARSHAL_S_LAST                                     0x0004012F
#define MARSHAL_E_LAST                                     0x8004012F

#define DATA_S_FIRST                                       0x00040130
#define DATA_S_SAMEFORMATETC                               _HRESULT_TYPEDEF_(0x00040130)
#define DATA_E_FIRST                                       0x80040130
#define DATA_S_LAST                                        0x0004013F
#define DATA_E_LAST                                        0x8004013F

#define VIEW_S_FIRST                                       0x00040140
#define VIEW_S_ALREADY_FROZEN                              _HRESULT_TYPEDEF_(0x00040140)
#define VIEW_E_FIRST                                       0x80040140
#define VIEW_E_DRAW                                        _HRESULT_TYPEDEF_(0x80040140)
#define VIEW_S_LAST                                        0x0004014F
#define VIEW_E_LAST                                        0x8004014F

#define REGDB_S_FIRST                                      0x00040150
#define REGDB_E_FIRST                                      0x80040150
#define REGDB_E_READREGDB                                  _HRESULT_TYPEDEF_(0x80040150)
#define REGDB_E_WRITEREGDB                                 _HRESULT_TYPEDEF_(0x80040151)
#define REGDB_E_KEYMISSING                                 _HRESULT_TYPEDEF_(0x80040152)
#define REGDB_E_INVALIDVALUE                               _HRESULT_TYPEDEF_(0x80040153)
#define REGDB_E_CLASSNOTREG                                _HRESULT_TYPEDEF_(0x80040154)
#define REGDB_E_IIDNOTREG                                  _HRESULT_TYPEDEF_(0x80040155)
#define REGDB_E_BADTHREADINGMODEL                          _HRESULT_TYPEDEF_(0x80040156)
#define REGDB_E_PACKAGEPOLICYVIOLATION                     _HRESULT_TYPEDEF_(0x80040157)
#define REGDB_S_LAST                                       0x0004015F
#define REGDB_E_LAST                                       0x8004015F

#define CAT_E_FIRST                                        0x80040160
#define CAT_E_CATIDNOEXIST                                 _HRESULT_TYPEDEF_(0x80040160)
#define CAT_E_NODESCRIPTION                                _HRESULT_TYPEDEF_(0x80040161)
#define CAT_E_LAST                                         0x80040161

#define CS_E_FIRST                                         0x80040164
#define CS_E_PACKAGE_NOTFOUND                              _HRESULT_TYPEDEF_(0x80040164)
#define CS_E_NOT_DELETABLE                                 _HRESULT_TYPEDEF_(0x80040165)
#define CS_E_CLASS_NOTFOUND                                _HRESULT_TYPEDEF_(0x80040166)
#define CS_E_INVALID_VERSION                               _HRESULT_TYPEDEF_(0x80040167)
#define CS_E_NO_CLASSSTORE                                 _HRESULT_TYPEDEF_(0x80040168)
#define CS_E_OBJECT_NOTFOUND                               _HRESULT_TYPEDEF_(0x80040169)
#define CS_E_OBJECT_ALREADY_EXISTS                         _HRESULT_TYPEDEF_(0x8004016A)
#define CS_E_INVALID_PATH                                  _HRESULT_TYPEDEF_(0x8004016B)
#define CS_E_NETWORK_ERROR                                 _HRESULT_TYPEDEF_(0x8004016C)
#define CS_E_ADMIN_LIMIT_EXCEEDED                          _HRESULT_TYPEDEF_(0x8004016D)
#define CS_E_SCHEMA_MISMATCH                               _HRESULT_TYPEDEF_(0x8004016E)
#define CS_E_INTERNAL_ERROR                                _HRESULT_TYPEDEF_(0x8004016F)
#define CS_E_LAST                                          0x8004016F

#define CACHE_S_FIRST                                      0x00040170
#define CACHE_S_FORMATETC_NOTSUPPORTED                     _HRESULT_TYPEDEF_(0x00040170)
#define CACHE_E_FIRST                                      0x80040170
#define CACHE_E_NOCACHE_UPDATED                            _HRESULT_TYPEDEF_(0x80040170)
#define CACHE_S_SAMECACHE                                  _HRESULT_TYPEDEF_(0x00040171)
#define CACHE_S_SOMECACHES_NOTUPDATED                      _HRESULT_TYPEDEF_(0x00040172)
#define CACHE_S_LAST                                       0x0004017F
#define CACHE_E_LAST                                       0x8004017F

#define OLEOBJ_S_FIRST                                     0x00040180
#define OLEOBJ_S_INVALIDVERB                               _HRESULT_TYPEDEF_(0x00040180)
#define OLEOBJ_E_FIRST                                     0x80040180
#define OLEOBJ_E_NOVERBS                                   _HRESULT_TYPEDEF_(0x80040180)
#define OLEOBJ_S_CANNOT_DOVERB_NOW                         _HRESULT_TYPEDEF_(0x00040181)
#define OLEOBJ_E_INVALIDVERB                               _HRESULT_TYPEDEF_(0x80040181)
#define OLEOBJ_S_INVALIDHWND                               _HRESULT_TYPEDEF_(0x00040182)
#define OLEOBJ_S_LAST                                      0x0004018F
#define OLEOBJ_E_LAST                                      0x8004018F

#define CLIENTSITE_S_FIRST                                 0x00040190
#define CLIENTSITE_E_FIRST                                 0x80040190
#define CLIENTSITE_S_LAST                                  0x0004019F
#define CLIENTSITE_E_LAST                                  0x8004019F

#define INPLACE_S_FIRST                                    0x000401A0
#define INPLACE_S_TRUNCATED                                _HRESULT_TYPEDEF_(0x000401A0)
#define INPLACE_E_FIRST                                    0x800401A0
#define INPLACE_E_NOTUNDOABLE                              _HRESULT_TYPEDEF_(0x800401A0)
#define INPLACE_E_NOTOOLSPACE                              _HRESULT_TYPEDEF_(0x800401A1)
#define INPLACE_S_LAST                                     0x000401AF
#define INPLACE_E_LAST                                     0x800401AF

#define ENUM_S_FIRST                                       0x000401B0
#define ENUM_E_FIRST                                       0x800401B0
#define ENUM_S_LAST                                        0x000401BF
#define ENUM_E_LAST                                        0x800401BF

#define CONVERT10_S_FIRST                                  0x000401C0
#define CONVERT10_S_NO_PRESENTATION                        _HRESULT_TYPEDEF_(0x000401C0)
#define CONVERT10_E_FIRST                                  0x800401C0
#define CONVERT10_E_OLESTREAM_GET                          _HRESULT_TYPEDEF_(0x800401C0)
#define CONVERT10_E_OLESTREAM_PUT                          _HRESULT_TYPEDEF_(0x800401C1)
#define CONVERT10_E_OLESTREAM_FMT                          _HRESULT_TYPEDEF_(0x800401C2)
#define CONVERT10_E_OLESTREAM_BITMAP_TO_DIB                _HRESULT_TYPEDEF_(0x800401C3)
#define CONVERT10_E_STG_FMT                                _HRESULT_TYPEDEF_(0x800401C4)
#define CONVERT10_E_STG_NO_STD_STREAM                      _HRESULT_TYPEDEF_(0x800401C5)
#define CONVERT10_E_STG_DIB_TO_BITMAP                      _HRESULT_TYPEDEF_(0x800401C6)
#define CONVERT10_S_LAST                                   0x000401CF
#define CONVERT10_E_LAST                                   0x800401CF

#define CLIPBRD_S_FIRST                                    0x000401D0
#define CLIPBRD_E_FIRST                                    0x800401D0
#define CLIPBRD_E_CANT_OPEN                                _HRESULT_TYPEDEF_(0x800401D0)
#define CLIPBRD_E_CANT_EMPTY                               _HRESULT_TYPEDEF_(0x800401D1)
#define CLIPBRD_E_CANT_SET                                 _HRESULT_TYPEDEF_(0x800401D2)
#define CLIPBRD_E_BAD_DATA                                 _HRESULT_TYPEDEF_(0x800401D3)
#define CLIPBRD_E_CANT_CLOSE                               _HRESULT_TYPEDEF_(0x800401D4)
#define CLIPBRD_S_LAST                                     0x000401DF
#define CLIPBRD_E_LAST                                     0x800401DF

#define MK_S_FIRST                                         0x000401E0
#define MK_E_FIRST                                         0x800401E0
#define MK_E_CONNECTMANUALLY                               _HRESULT_TYPEDEF_(0x800401E0)
#define MK_E_EXCEEDEDDEADLINE                              _HRESULT_TYPEDEF_(0x800401E1)
#define MK_S_REDUCED_TO_SELF                               _HRESULT_TYPEDEF_(0x000401E2)
#define MK_E_NEEDGENERIC                                   _HRESULT_TYPEDEF_(0x800401E2)
#define MK_E_UNAVAILABLE                                   _HRESULT_TYPEDEF_(0x800401E3)
#define MK_S_ME                                            _HRESULT_TYPEDEF_(0x000401E4)
#define MK_E_SYNTAX                                        _HRESULT_TYPEDEF_(0x800401E4)
#define MK_S_HIM                                           _HRESULT_TYPEDEF_(0x000401E5)
#define MK_E_NOOBJECT                                      _HRESULT_TYPEDEF_(0x800401E5)
#define MK_S_US                                            _HRESULT_TYPEDEF_(0x000401E6)
#define MK_E_INVALIDEXTENSION                              _HRESULT_TYPEDEF_(0x800401E6)
#define MK_S_MONIKERALREADYREGISTERED                      _HRESULT_TYPEDEF_(0x000401E7)
#define MK_E_INTERMEDIATEINTERFACENOTSUPPORTED             _HRESULT_TYPEDEF_(0x800401E7)
#define MK_E_NOTBINDABLE                                   _HRESULT_TYPEDEF_(0x800401E8)
#define MK_E_NOTBOUND                                      _HRESULT_TYPEDEF_(0x800401E9)
#define MK_E_CANTOPENFILE                                  _HRESULT_TYPEDEF_(0x800401EA)
#define MK_E_MUSTBOTHERUSER                                _HRESULT_TYPEDEF_(0x800401EB)
#define MK_E_NOINVERSE                                     _HRESULT_TYPEDEF_(0x800401EC)
#define MK_E_NOSTORAGE                                     _HRESULT_TYPEDEF_(0x800401ED)
#define MK_E_NOPREFIX                                      _HRESULT_TYPEDEF_(0x800401EE)
#define MK_S_LAST                                          0x000401EF
#define MK_E_ENUMERATION_FAILED                            _HRESULT_TYPEDEF_(0x800401EF)
#define MK_E_LAST                                          0x800401EF

#define CO_S_FIRST                                         0x000401F0
#define CO_E_FIRST                                         0x800401F0
#define CO_E_NOTINITIALIZED                                _HRESULT_TYPEDEF_(0x800401F0)
#define CO_E_ALREADYINITIALIZED                            _HRESULT_TYPEDEF_(0x800401F1)
#define CO_E_CANTDETERMINECLASS                            _HRESULT_TYPEDEF_(0x800401F2)
#define CO_E_CLASSSTRING                                   _HRESULT_TYPEDEF_(0x800401F3)
#define CO_E_IIDSTRING                                     _HRESULT_TYPEDEF_(0x800401F4)
#define CO_E_APPNOTFOUND                                   _HRESULT_TYPEDEF_(0x800401F5)
#define CO_E_APPSINGLEUSE                                  _HRESULT_TYPEDEF_(0x800401F6)
#define CO_E_ERRORINAPP                                    _HRESULT_TYPEDEF_(0x800401F7)
#define CO_E_DLLNOTFOUND                                   _HRESULT_TYPEDEF_(0x800401F8)
#define CO_E_ERRORINDLL                                    _HRESULT_TYPEDEF_(0x800401F9)
#define CO_E_WRONGOSFORAPP                                 _HRESULT_TYPEDEF_(0x800401FA)
#define CO_E_OBJNOTREG                                     _HRESULT_TYPEDEF_(0x800401FB)
#define CO_E_OBJISREG                                      _HRESULT_TYPEDEF_(0x800401FC)
#define CO_E_OBJNOTCONNECTED                               _HRESULT_TYPEDEF_(0x800401FD)
#define CO_E_APPDIDNTREG                                   _HRESULT_TYPEDEF_(0x800401FE)
#define CO_S_LAST                                          0x000401FF
#define CO_E_RELEASED                                      _HRESULT_TYPEDEF_(0x800401FF)
#define CO_E_LAST                                          0x800401FF

#define EVENT_E_FIRST                                      0x00040200
#define EVENT_S_FIRST                                      0x00040200
#define EVENT_S_SOME_SUBSCRIBERS_FAILED                    _HRESULT_TYPEDEF_(0x00040200)
#define EVENT_E_ALL_SUBSCRIBERS_FAILED                     _HRESULT_TYPEDEF_(0x80040201)
#define EVENT_S_NOSUBSCRIBERS                              _HRESULT_TYPEDEF_(0x00040202)
#define EVENT_E_QUERYSYNTAX                                _HRESULT_TYPEDEF_(0x80040203)
#define EVENT_E_QUERYFIELD                                 _HRESULT_TYPEDEF_(0x80040204)
#define EVENT_E_INTERNALEXCEPTION                          _HRESULT_TYPEDEF_(0x80040205)
#define EVENT_E_INTERNALERROR                              _HRESULT_TYPEDEF_(0x80040206)
#define EVENT_E_INVALID_PER_USER_SID                       _HRESULT_TYPEDEF_(0x80040207)
#define EVENT_E_USER_EXCEPTION                             _HRESULT_TYPEDEF_(0x80040208)
#define EVENT_E_TOO_MANY_METHODS                           _HRESULT_TYPEDEF_(0x80040209)
#define EVENT_E_MISSING_EVENTCLASS                         _HRESULT_TYPEDEF_(0x8004020A)
#define EVENT_E_NOT_ALL_REMOVED                            _HRESULT_TYPEDEF_(0x8004020B)
#define EVENT_E_COMPLUS_NOT_INSTALLED                      _HRESULT_TYPEDEF_(0x8004020C)
#define EVENT_E_CANT_MODIFY_OR_DELETE_UNCONFIGURED_OBJECT  _HRESULT_TYPEDEF_(0x8004020D)
#define EVENT_E_CANT_MODIFY_OR_DELETE_CONFIGURED_OBJECT    _HRESULT_TYPEDEF_(0x8004020E)
#define EVENT_E_INVALID_EVENT_CLASS_PARTITION              _HRESULT_TYPEDEF_(0x8004020F)
#define EVENT_E_PER_USER_SID_NOT_LOGGED_ON                 _HRESULT_TYPEDEF_(0x80040210)
#define TPC_E_NO_DEFAULT_TABLET                            _HRESULT_TYPEDEF_(0x80040212)
#define TPC_E_INVALID_INPUT_RECT                           _HRESULT_TYPEDEF_(0x80040219)
#define TPC_E_UNKNOWN_PROPERTY                             _HRESULT_TYPEDEF_(0x8004021B)
#define EVENT_S_LAST                                       0x0004021F
#define EVENT_E_LAST                                       0x8004021F
#define TPC_E_INVALID_STROKE                               _HRESULT_TYPEDEF_(0x80040222)
#define TPC_E_INITIALIZE_FAIL                              _HRESULT_TYPEDEF_(0x80040223)
#define TPC_E_NOT_RELEVANT                                 _HRESULT_TYPEDEF_(0x80040232)
#define TPC_E_INVALID_PACKET_DESCRIPTION                   _HRESULT_TYPEDEF_(0x80040233)
#define TPC_E_RECOGNIZER_NOT_REGISTERED                    _HRESULT_TYPEDEF_(0x80040235)
#define TPC_E_INVALID_RIGHTS                               _HRESULT_TYPEDEF_(0x80040236)
#define TPC_E_OUT_OF_ORDER_CALL                            _HRESULT_TYPEDEF_(0x80040237)
#define TPC_E_QUEUE_FULL                                   _HRESULT_TYPEDEF_(0x80040238)
#define TPC_E_INVALID_CONFIGURATION                        _HRESULT_TYPEDEF_(0x80040239)
#define TPC_E_INVALID_DATA_FROM_RECOGNIZER                 _HRESULT_TYPEDEF_(0x8004023A)
#define TPC_E_INVALID_PROPERTY                             _HRESULT_TYPEDEF_(0x80040241)
#define TPC_S_TRUNCATED                                    _HRESULT_TYPEDEF_(0x00040252)
#define TPC_S_INTERRUPTED                                  _HRESULT_TYPEDEF_(0x00040253)
#define TPC_S_NO_DATA_TO_PROCESS                           _HRESULT_TYPEDEF_(0x00040254)

#define SCHED_S_TASK_READY                                 _HRESULT_TYPEDEF_(0x00041300)
#define SCHED_S_TASK_RUNNING                               _HRESULT_TYPEDEF_(0x00041301)
#define SCHED_S_TASK_DISABLED                              _HRESULT_TYPEDEF_(0x00041302)
#define SCHED_S_TASK_HAS_NOT_RUN                           _HRESULT_TYPEDEF_(0x00041303)
#define SCHED_S_TASK_NO_MORE_RUNS                          _HRESULT_TYPEDEF_(0x00041304)
#define SCHED_S_TASK_NOT_SCHEDULED                         _HRESULT_TYPEDEF_(0x00041305)
#define SCHED_S_TASK_TERMINATED                            _HRESULT_TYPEDEF_(0x00041306)
#define SCHED_S_TASK_NO_VALID_TRIGGERS                     _HRESULT_TYPEDEF_(0x00041307)
#define SCHED_S_EVENT_TRIGGER                              _HRESULT_TYPEDEF_(0x00041308)
#define SCHED_E_TRIGGER_NOT_FOUND                          _HRESULT_TYPEDEF_(0x80041309)
#define SCHED_E_TASK_NOT_READY                             _HRESULT_TYPEDEF_(0x8004130A)
#define SCHED_E_TASK_NOT_RUNNING                           _HRESULT_TYPEDEF_(0x8004130B)
#define SCHED_E_SERVICE_NOT_INSTALLED                      _HRESULT_TYPEDEF_(0x8004130C)
#define SCHED_E_CANNOT_OPEN_TASK                           _HRESULT_TYPEDEF_(0x8004130D)
#define SCHED_E_INVALID_TASK                               _HRESULT_TYPEDEF_(0x8004130E)
#define SCHED_E_ACCOUNT_INFORMATION_NOT_SET                _HRESULT_TYPEDEF_(0x8004130F)
#define SCHED_E_ACCOUNT_NAME_NOT_FOUND                     _HRESULT_TYPEDEF_(0x80041310)
#define SCHED_E_ACCOUNT_DBASE_CORRUPT                      _HRESULT_TYPEDEF_(0x80041311)
#define SCHED_E_NO_SECURITY_SERVICES                       _HRESULT_TYPEDEF_(0x80041312)
#define SCHED_E_UNKNOWN_OBJECT_VERSION                     _HRESULT_TYPEDEF_(0x80041313)
#define SCHED_E_UNSUPPORTED_ACCOUNT_OPTION                 _HRESULT_TYPEDEF_(0x80041314)
#define SCHED_E_SERVICE_NOT_RUNNING                        _HRESULT_TYPEDEF_(0x80041315)
#define SCHED_E_UNEXPECTEDNODE                             _HRESULT_TYPEDEF_(0x80041316)
#define SCHED_E_NAMESPACE                                  _HRESULT_TYPEDEF_(0x80041317)
#define SCHED_E_INVALIDVALUE                               _HRESULT_TYPEDEF_(0x80041318)
#define SCHED_E_MISSINGNODE                                _HRESULT_TYPEDEF_(0x80041319)
#define SCHED_E_MALFORMEDXML                               _HRESULT_TYPEDEF_(0x8004131A)
#define SCHED_S_SOME_TRIGGERS_FAILED                       _HRESULT_TYPEDEF_(0x0004131B)
#define SCHED_S_BATCH_LOGON_PROBLEM                        _HRESULT_TYPEDEF_(0x0004131C)
#define SCHED_E_TOO_MANY_NODES                             _HRESULT_TYPEDEF_(0x8004131D)
#define SCHED_E_PAST_END_BOUNDARY                          _HRESULT_TYPEDEF_(0x8004131E)
#define SCHED_E_ALREADY_RUNNING                            _HRESULT_TYPEDEF_(0x8004131F)
#define SCHED_E_USER_NOT_LOGGED_ON                         _HRESULT_TYPEDEF_(0x80041320)
#define SCHED_E_INVALID_TASK_HASH                          _HRESULT_TYPEDEF_(0x80041321)
#define SCHED_E_SERVICE_NOT_AVAILABLE                      _HRESULT_TYPEDEF_(0x80041322)
#define SCHED_E_SERVICE_TOO_BUSY                           _HRESULT_TYPEDEF_(0x80041323)
#define SCHED_E_TASK_ATTEMPTED                             _HRESULT_TYPEDEF_(0x80041324)
#define SCHED_S_TASK_QUEUED                                _HRESULT_TYPEDEF_(0x00041325)
#define SCHED_E_TASK_DISABLED                              _HRESULT_TYPEDEF_(0x80041326)
#define SCHED_E_TASK_NOT_V1_COMPAT                         _HRESULT_TYPEDEF_(0x80041327)
#define SCHED_E_START_ON_DEMAND                            _HRESULT_TYPEDEF_(0x80041328)
#define SCHED_E_TASK_NOT_UBPM_COMPAT                       _HRESULT_TYPEDEF_(0x80041329)
#define SCHED_E_DEPRECATED_FEATURE_USED                    _HRESULT_TYPEDEF_(0x80041330)

#define XACT_S_FIRST                                       0x0004D000
#define XACT_E_FIRST                                       0x8004D000
#define XACT_S_ASYNC                                       _HRESULT_TYPEDEF_(0x0004D000)
#define XACT_E_ALREADYOTHERSINGLEPHASE                     _HRESULT_TYPEDEF_(0x8004D000)
#define XACT_S_DEFECT                                      _HRESULT_TYPEDEF_(0x0004D001)
#define XACT_E_CANTRETAIN                                  _HRESULT_TYPEDEF_(0x8004D001)
#define XACT_S_READONLY                                    _HRESULT_TYPEDEF_(0x0004D002)
#define XACT_E_COMMITFAILED                                _HRESULT_TYPEDEF_(0x8004D002)
#define XACT_S_SOMENORETAIN                                _HRESULT_TYPEDEF_(0x0004D003)
#define XACT_E_COMMITPREVENTED                             _HRESULT_TYPEDEF_(0x8004D003)
#define XACT_S_OKINFORM                                    _HRESULT_TYPEDEF_(0x0004D004)
#define XACT_E_HEURISTICABORT                              _HRESULT_TYPEDEF_(0x8004D004)
#define XACT_S_MADECHANGESCONTENT                          _HRESULT_TYPEDEF_(0x0004D005)
#define XACT_E_HEURISTICCOMMIT                             _HRESULT_TYPEDEF_(0x8004D005)
#define XACT_S_MADECHANGESINFORM                           _HRESULT_TYPEDEF_(0x0004D006)
#define XACT_E_HEURISTICDAMAGE                             _HRESULT_TYPEDEF_(0x8004D006)
#define XACT_S_ALLNORETAIN                                 _HRESULT_TYPEDEF_(0x0004D007)
#define XACT_E_HEURISTICDANGER                             _HRESULT_TYPEDEF_(0x8004D007)
#define XACT_S_ABORTING                                    _HRESULT_TYPEDEF_(0x0004D008)
#define XACT_E_ISOLATIONLEVEL                              _HRESULT_TYPEDEF_(0x8004D008)
#define XACT_S_SINGLEPHASE                                 _HRESULT_TYPEDEF_(0x0004D009)
#define XACT_E_NOASYNC                                     _HRESULT_TYPEDEF_(0x8004D009)
#define XACT_S_LOCALLY_OK                                  _HRESULT_TYPEDEF_(0x0004D00A)
#define XACT_E_NOENLIST                                    _HRESULT_TYPEDEF_(0x8004D00A)
#define XACT_E_NOISORETAIN                                 _HRESULT_TYPEDEF_(0x8004D00B)
#define XACT_E_NORESOURCE                                  _HRESULT_TYPEDEF_(0x8004D00C)
#define XACT_E_NOTCURRENT                                  _HRESULT_TYPEDEF_(0x8004D00D)
#define XACT_E_NOTRANSACTION                               _HRESULT_TYPEDEF_(0x8004D00E)
#define XACT_E_NOTSUPPORTED                                _HRESULT_TYPEDEF_(0x8004D00F)
#define XACT_S_LASTRESOURCEMANAGER                         _HRESULT_TYPEDEF_(0x0004D010)
#define XACT_S_LAST                                        0x0004D010
#define XACT_E_UNKNOWNRMGRID                               _HRESULT_TYPEDEF_(0x8004D010)
#define XACT_E_WRONGSTATE                                  _HRESULT_TYPEDEF_(0x8004D011)
#define XACT_E_WRONGUOW                                    _HRESULT_TYPEDEF_(0x8004D012)
#define XACT_E_XTIONEXISTS                                 _HRESULT_TYPEDEF_(0x8004D013)
#define XACT_E_NOIMPORTOBJECT                              _HRESULT_TYPEDEF_(0x8004D014)
#define XACT_E_INVALIDCOOKIE                               _HRESULT_TYPEDEF_(0x8004D015)
#define XACT_E_INDOUBT                                     _HRESULT_TYPEDEF_(0x8004D016)
#define XACT_E_NOTIMEOUT                                   _HRESULT_TYPEDEF_(0x8004D017)
#define XACT_E_ALREADYINPROGRESS                           _HRESULT_TYPEDEF_(0x8004D018)
#define XACT_E_ABORTED                                     _HRESULT_TYPEDEF_(0x8004D019)
#define XACT_E_LOGFULL                                     _HRESULT_TYPEDEF_(0x8004D01A)
#define XACT_E_TMNOTAVAILABLE                              _HRESULT_TYPEDEF_(0x8004D01B)
#define XACT_E_CONNECTION_DOWN                             _HRESULT_TYPEDEF_(0x8004D01C)
#define XACT_E_CONNECTION_DENIED                           _HRESULT_TYPEDEF_(0x8004D01D)
#define XACT_E_REENLISTTIMEOUT                             _HRESULT_TYPEDEF_(0x8004D01E)
#define XACT_E_TIP_CONNECT_FAILED                          _HRESULT_TYPEDEF_(0x8004D01F)
#define XACT_E_TIP_PROTOCOL_ERROR                          _HRESULT_TYPEDEF_(0x8004D020)
#define XACT_E_TIP_PULL_FAILED                             _HRESULT_TYPEDEF_(0x8004D021)
#define XACT_E_DEST_TMNOTAVAILABLE                         _HRESULT_TYPEDEF_(0x8004D022)
#define XACT_E_TIP_DISABLED                                _HRESULT_TYPEDEF_(0x8004D023)
#define XACT_E_NETWORK_TX_DISABLED                         _HRESULT_TYPEDEF_(0x8004D024)
#define XACT_E_PARTNER_NETWORK_TX_DISABLED                 _HRESULT_TYPEDEF_(0x8004D025)
#define XACT_E_XA_TX_DISABLED                              _HRESULT_TYPEDEF_(0x8004D026)
#define XACT_E_UNABLE_TO_READ_DTC_CONFIG                   _HRESULT_TYPEDEF_(0x8004D027)
#define XACT_E_UNABLE_TO_LOAD_DTC_PROXY                    _HRESULT_TYPEDEF_(0x8004D028)
#define XACT_E_ABORTING                                    _HRESULT_TYPEDEF_(0x8004D029)
#define XACT_E_PUSH_COMM_FAILURE                           _HRESULT_TYPEDEF_(0x8004D02A)
#define XACT_E_PULL_COMM_FAILURE                           _HRESULT_TYPEDEF_(0x8004D02B)
#define XACT_E_LAST                                        0x8004D02B
#define XACT_E_LU_TX_DISABLED                              _HRESULT_TYPEDEF_(0x8004D02C)
#define XACT_E_CLERKNOTFOUND                               _HRESULT_TYPEDEF_(0x8004D080)
#define XACT_E_CLERKEXISTS                                 _HRESULT_TYPEDEF_(0x8004D081)
#define XACT_E_RECOVERYINPROGRESS                          _HRESULT_TYPEDEF_(0x8004D082)
#define XACT_E_TRANSACTIONCLOSED                           _HRESULT_TYPEDEF_(0x8004D083)
#define XACT_E_INVALIDLSN                                  _HRESULT_TYPEDEF_(0x8004D084)
#define XACT_E_REPLAYREQUEST                               _HRESULT_TYPEDEF_(0x8004D085)

#define CONTEXT_S_FIRST                                    0x0004E000
#define CONTEXT_E_FIRST                                    0x8004E000
#define CONTEXT_E_ABORTED                                  _HRESULT_TYPEDEF_(0x8004E002)
#define CONTEXT_E_ABORTING                                 _HRESULT_TYPEDEF_(0x8004E003)
#define CONTEXT_E_NOCONTEXT                                _HRESULT_TYPEDEF_(0x8004E004)
#define CONTEXT_E_WOULD_DEADLOCK                           _HRESULT_TYPEDEF_(0x8004E005)
#define CONTEXT_E_SYNCH_TIMEOUT                            _HRESULT_TYPEDEF_(0x8004E006)
#define CONTEXT_E_OLDREF                                   _HRESULT_TYPEDEF_(0x8004E007)
#define CONTEXT_E_ROLENOTFOUND                             _HRESULT_TYPEDEF_(0x8004E00C)
#define CONTEXT_E_TMNOTAVAILABLE                           _HRESULT_TYPEDEF_(0x8004E00F)
#define CO_E_ACTIVATIONFAILED                              _HRESULT_TYPEDEF_(0x8004E021)
#define CO_E_ACTIVATIONFAILED_EVENTLOGGED                  _HRESULT_TYPEDEF_(0x8004E022)
#define CO_E_ACTIVATIONFAILED_CATALOGERROR                 _HRESULT_TYPEDEF_(0x8004E023)
#define CO_E_ACTIVATIONFAILED_TIMEOUT                      _HRESULT_TYPEDEF_(0x8004E024)
#define CO_E_INITIALIZATIONFAILED                          _HRESULT_TYPEDEF_(0x8004E025)
#define CONTEXT_E_NOJIT                                    _HRESULT_TYPEDEF_(0x8004E026)
#define CONTEXT_E_NOTRANSACTION                            _HRESULT_TYPEDEF_(0x8004E027)
#define CO_E_THREADINGMODEL_CHANGED                        _HRESULT_TYPEDEF_(0x8004E028)
#define CO_E_NOIISINTRINSICS                               _HRESULT_TYPEDEF_(0x8004E029)
#define CO_E_NOCOOKIES                                     _HRESULT_TYPEDEF_(0x8004E02A)
#define CO_E_DBERROR                                       _HRESULT_TYPEDEF_(0x8004E02B)
#define CO_E_NOTPOOLED                                     _HRESULT_TYPEDEF_(0x8004E02C)
#define CO_E_NOTCONSTRUCTED                                _HRESULT_TYPEDEF_(0x8004E02D)
#define CO_E_NOSYNCHRONIZATION                             _HRESULT_TYPEDEF_(0x8004E02E)
#define CONTEXT_S_LAST                                     0x0004E02F
#define CO_E_ISOLEVELMISMATCH                              _HRESULT_TYPEDEF_(0x8004E02F)
#define CONTEXT_E_LAST                                     0x8004E02F
#define CO_E_CALL_OUT_OF_TX_SCOPE_NOT_ALLOWED              _HRESULT_TYPEDEF_(0x8004E030)
#define CO_E_EXIT_TRANSACTION_SCOPE_NOT_CALLED             _HRESULT_TYPEDEF_(0x8004E031)

#define E_ACCESSDENIED                                     _HRESULT_TYPEDEF_(0x80070005)
#define E_HANDLE                                           _HRESULT_TYPEDEF_(0x80070006)
#define E_OUTOFMEMORY                                      _HRESULT_TYPEDEF_(0x8007000E)
#define E_INVALIDARG                                       _HRESULT_TYPEDEF_(0x80070057)

#define WININET_E_OUT_OF_HANDLES                           _HRESULT_TYPEDEF_(0x80072EE1)
#define WININET_E_TIMEOUT                                  _HRESULT_TYPEDEF_(0x80072EE2)
#define WININET_E_EXTENDED_ERROR                           _HRESULT_TYPEDEF_(0x80072EE3)
#define WININET_E_INTERNAL_ERROR                           _HRESULT_TYPEDEF_(0x80072EE4)
#define WININET_E_INVALID_URL                              _HRESULT_TYPEDEF_(0x80072EE5)
#define WININET_E_UNRECOGNIZED_SCHEME                      _HRESULT_TYPEDEF_(0x80072EE6)
#define WININET_E_NAME_NOT_RESOLVED                        _HRESULT_TYPEDEF_(0x80072EE7)
#define WININET_E_PROTOCOL_NOT_FOUND                       _HRESULT_TYPEDEF_(0x80072EE8)
#define WININET_E_INVALID_OPTION                           _HRESULT_TYPEDEF_(0x80072EE9)
#define WININET_E_BAD_OPTION_LENGTH                        _HRESULT_TYPEDEF_(0x80072EEA)
#define WININET_E_OPTION_NOT_SETTABLE                      _HRESULT_TYPEDEF_(0x80072EEB)
#define WININET_E_SHUTDOWN                                 _HRESULT_TYPEDEF_(0x80072EEC)
#define WININET_E_INCORRECT_USER_NAME                      _HRESULT_TYPEDEF_(0x80072EED)
#define WININET_E_INCORRECT_PASSWORD                       _HRESULT_TYPEDEF_(0x80072EEE)
#define WININET_E_LOGIN_FAILURE                            _HRESULT_TYPEDEF_(0x80072EEF)
#define WININET_E_INVALID_OPERATION                        _HRESULT_TYPEDEF_(0x80072EF0)
#define WININET_E_OPERATION_CANCELLED                      _HRESULT_TYPEDEF_(0x80072EF1)
#define WININET_E_INCORRECT_HANDLE_TYPE                    _HRESULT_TYPEDEF_(0x80072EF2)
#define WININET_E_INCORRECT_HANDLE_STATE                   _HRESULT_TYPEDEF_(0x80072EF3)
#define WININET_E_NOT_PROXY_REQUEST                        _HRESULT_TYPEDEF_(0x80072EF4)
#define WININET_E_REGISTRY_VALUE_NOT_FOUND                 _HRESULT_TYPEDEF_(0x80072EF5)
#define WININET_E_BAD_REGISTRY_PARAMETER                   _HRESULT_TYPEDEF_(0x80072EF6)
#define WININET_E_NO_DIRECT_ACCESS                         _HRESULT_TYPEDEF_(0x80072EF7)
#define WININET_E_NO_CONTEXT                               _HRESULT_TYPEDEF_(0x80072EF8)
#define WININET_E_NO_CALLBACK                              _HRESULT_TYPEDEF_(0x80072EF9)
#define WININET_E_REQUEST_PENDING                          _HRESULT_TYPEDEF_(0x80072EFA)
#define WININET_E_INCORRECT_FORMAT                         _HRESULT_TYPEDEF_(0x80072EFB)
#define WININET_E_ITEM_NOT_FOUND                           _HRESULT_TYPEDEF_(0x80072EFC)
#define WININET_E_CANNOT_CONNECT                           _HRESULT_TYPEDEF_(0x80072EFD)
#define WININET_E_CONNECTION_ABORTED                       _HRESULT_TYPEDEF_(0x80072EFE)
#define WININET_E_CONNECTION_RESET                         _HRESULT_TYPEDEF_(0x80072EFF)
#define WININET_E_FORCE_RETRY                              _HRESULT_TYPEDEF_(0x80072F00)
#define WININET_E_INVALID_PROXY_REQUEST                    _HRESULT_TYPEDEF_(0x80072F01)
#define WININET_E_NEED_UI                                  _HRESULT_TYPEDEF_(0x80072F02)
#define WININET_E_HANDLE_EXISTS                            _HRESULT_TYPEDEF_(0x80072F04)
#define WININET_E_SEC_CERT_DATE_INVALID                    _HRESULT_TYPEDEF_(0x80072F05)
#define WININET_E_SEC_CERT_CN_INVALID                      _HRESULT_TYPEDEF_(0x80072F06)
#define WININET_E_HTTP_TO_HTTPS_ON_REDIR                   _HRESULT_TYPEDEF_(0x80072F07)
#define WININET_E_HTTPS_TO_HTTP_ON_REDIR                   _HRESULT_TYPEDEF_(0x80072F08)
#define WININET_E_MIXED_SECURITY                           _HRESULT_TYPEDEF_(0x80072F09)
#define WININET_E_CHG_POST_IS_NON_SECURE                   _HRESULT_TYPEDEF_(0x80072F0A)
#define WININET_E_POST_IS_NON_SECURE                       _HRESULT_TYPEDEF_(0x80072F0B)
#define WININET_E_CLIENT_AUTH_CERT_NEEDED                  _HRESULT_TYPEDEF_(0x80072F0C)
#define WININET_E_INVALID_CA                               _HRESULT_TYPEDEF_(0x80072F0D)
#define WININET_E_CLIENT_AUTH_NOT_SETUP                    _HRESULT_TYPEDEF_(0x80072F0E)
#define WININET_E_ASYNC_THREAD_FAILED                      _HRESULT_TYPEDEF_(0x80072F0F)
#define WININET_E_REDIRECT_SCHEME_CHANGE                   _HRESULT_TYPEDEF_(0x80072F10)
#define WININET_E_DIALOG_PENDING                           _HRESULT_TYPEDEF_(0x80072F11)
#define WININET_E_RETRY_DIALOG                             _HRESULT_TYPEDEF_(0x80072F12)
#define WININET_E_NO_NEW_CONTAINERS                        _HRESULT_TYPEDEF_(0x80072F13)
#define WININET_E_HTTPS_HTTP_SUBMIT_REDIR                  _HRESULT_TYPEDEF_(0x80072F14)
#define WININET_E_SEC_CERT_ERRORS                          _HRESULT_TYPEDEF_(0x80072F17)
#define WININET_E_SEC_CERT_REV_FAILED                      _HRESULT_TYPEDEF_(0x80072F19)
#define WININET_E_HEADER_NOT_FOUND                         _HRESULT_TYPEDEF_(0x80072F76)
#define WININET_E_DOWNLEVEL_SERVER                         _HRESULT_TYPEDEF_(0x80072F77)
#define WININET_E_INVALID_SERVER_RESPONSE                  _HRESULT_TYPEDEF_(0x80072F78)
#define WININET_E_INVALID_HEADER                           _HRESULT_TYPEDEF_(0x80072F79)
#define WININET_E_INVALID_QUERY_REQUEST                    _HRESULT_TYPEDEF_(0x80072F7A)
#define WININET_E_HEADER_ALREADY_EXISTS                    _HRESULT_TYPEDEF_(0x80072F7B)
#define WININET_E_REDIRECT_FAILED                          _HRESULT_TYPEDEF_(0x80072F7C)
#define WININET_E_SECURITY_CHANNEL_ERROR                   _HRESULT_TYPEDEF_(0x80072F7D)
#define WININET_E_UNABLE_TO_CACHE_FILE                     _HRESULT_TYPEDEF_(0x80072F7E)
#define WININET_E_TCPIP_NOT_INSTALLED                      _HRESULT_TYPEDEF_(0x80072F7F)
#define WININET_E_NOT_REDIRECTED                           _HRESULT_TYPEDEF_(0x80072F80)
#define WININET_E_COOKIE_NEEDS_CONFIRMATION                _HRESULT_TYPEDEF_(0x80072F81)
#define WININET_E_COOKIE_DECLINED                          _HRESULT_TYPEDEF_(0x80072F82)
#define WININET_E_DISCONNECTED                             _HRESULT_TYPEDEF_(0x80072F83)
#define WININET_E_SERVER_UNREACHABLE                       _HRESULT_TYPEDEF_(0x80072F84)
#define WININET_E_PROXY_SERVER_UNREACHABLE                 _HRESULT_TYPEDEF_(0x80072F85)
#define WININET_E_BAD_AUTO_PROXY_SCRIPT                    _HRESULT_TYPEDEF_(0x80072F86)
#define WININET_E_UNABLE_TO_DOWNLOAD_SCRIPT                _HRESULT_TYPEDEF_(0x80072F87)
#define WININET_E_REDIRECT_NEEDS_CONFIRMATION              _HRESULT_TYPEDEF_(0x80072F88)
#define WININET_E_SEC_INVALID_CERT                         _HRESULT_TYPEDEF_(0x80072F89)
#define WININET_E_SEC_CERT_REVOKED                         _HRESULT_TYPEDEF_(0x80072F8A)
#define WININET_E_FAILED_DUETOSECURITYCHECK                _HRESULT_TYPEDEF_(0x80072F8B)
#define WININET_E_NOT_INITIALIZED                          _HRESULT_TYPEDEF_(0x80072F8C)
#define WININET_E_LOGIN_FAILURE_DISPLAY_ENTITY_BODY        _HRESULT_TYPEDEF_(0x80072F8E)
#define WININET_E_DECODING_FAILED                          _HRESULT_TYPEDEF_(0x80072F8F)

#define CO_E_CLASS_CREATE_FAILED                           _HRESULT_TYPEDEF_(0x80080001)
#define CO_E_SCM_ERROR                                     _HRESULT_TYPEDEF_(0x80080002)
#define CO_E_SCM_RPC_FAILURE                               _HRESULT_TYPEDEF_(0x80080003)
#define CO_E_BAD_PATH                                      _HRESULT_TYPEDEF_(0x80080004)
#define CO_E_SERVER_EXEC_FAILURE                           _HRESULT_TYPEDEF_(0x80080005)
#define CO_E_OBJSRV_RPC_FAILURE                            _HRESULT_TYPEDEF_(0x80080006)
#define MK_E_NO_NORMALIZED                                 _HRESULT_TYPEDEF_(0x80080007)
#define CO_E_SERVER_STOPPING                               _HRESULT_TYPEDEF_(0x80080008)
#define MEM_E_INVALID_ROOT                                 _HRESULT_TYPEDEF_(0x80080009)
#define MEM_E_INVALID_LINK                                 _HRESULT_TYPEDEF_(0x80080010)
#define MEM_E_INVALID_SIZE                                 _HRESULT_TYPEDEF_(0x80080011)
#define CO_S_NOTALLINTERFACES                              _HRESULT_TYPEDEF_(0x00080012)
#define CO_S_MACHINENAMENOTFOUND                           _HRESULT_TYPEDEF_(0x00080013)
#define CO_E_MISSING_DISPLAYNAME                           _HRESULT_TYPEDEF_(0x80080015)
#define CO_E_RUNAS_VALUE_MUST_BE_AAA                       _HRESULT_TYPEDEF_(0x80080016)
#define CO_E_ELEVATION_DISABLED                            _HRESULT_TYPEDEF_(0x80080017)
#define APPX_E_PACKAGING_INTERNAL                          _HRESULT_TYPEDEF_(0x80080200)
#define APPX_E_INTERLEAVING_NOT_ALLOWED                    _HRESULT_TYPEDEF_(0x80080201)
#define APPX_E_RELATIONSHIPS_NOT_ALLOWED                   _HRESULT_TYPEDEF_(0x80080202)
#define APPX_E_MISSING_REQUIRED_FILE                       _HRESULT_TYPEDEF_(0x80080203)
#define APPX_E_INVALID_MANIFEST                            _HRESULT_TYPEDEF_(0x80080204)
#define APPX_E_INVALID_BLOCKMAP                            _HRESULT_TYPEDEF_(0x80080205)
#define APPX_E_CORRUPT_CONTENT                             _HRESULT_TYPEDEF_(0x80080206)
#define APPX_E_BLOCK_HASH_INVALID                          _HRESULT_TYPEDEF_(0x80080207)
#define APPX_E_REQUESTED_RANGE_TOO_LARGE                   _HRESULT_TYPEDEF_(0x80080208)
#define APPX_E_INVALID_SIP_CLIENT_DATA                     _HRESULT_TYPEDEF_(0x80080209)
#define APPX_E_INVALID_KEY_INFO                            _HRESULT_TYPEDEF_(0x8008020A)
#define APPX_E_INVALID_CONTENTGROUPMAP                     _HRESULT_TYPEDEF_(0x8008020B)
#define APPX_E_INVALID_APPINSTALLER                        _HRESULT_TYPEDEF_(0x8008020C)
#define APPX_E_DELTA_BASELINE_VERSION_MISMATCH             _HRESULT_TYPEDEF_(0x8008020D)
#define APPX_E_DELTA_PACKAGE_MISSING_FILE                  _HRESULT_TYPEDEF_(0x8008020E)
#define APPX_E_INVALID_DELTA_PACKAGE                       _HRESULT_TYPEDEF_(0x8008020F)
#define APPX_E_DELTA_APPENDED_PACKAGE_NOT_ALLOWED          _HRESULT_TYPEDEF_(0x80080210)
#define APPX_E_INVALID_PACKAGING_LAYOUT                    _HRESULT_TYPEDEF_(0x80080211)
#define APPX_E_INVALID_PACKAGESIGNCONFIG                   _HRESULT_TYPEDEF_(0x80080212)
#define APPX_E_RESOURCESPRI_NOT_ALLOWED                    _HRESULT_TYPEDEF_(0x80080213)
#define APPX_E_FILE_COMPRESSION_MISMATCH                   _HRESULT_TYPEDEF_(0x80080214)
#define APPX_E_INVALID_PAYLOAD_PACKAGE_EXTENSION           _HRESULT_TYPEDEF_(0x80080215)
#define APPX_E_INVALID_ENCRYPTION_EXCLUSION_FILE_LIST      _HRESULT_TYPEDEF_(0x80080216)
#define APPX_E_INVALID_PACKAGE_FOLDER_ACLS                 _HRESULT_TYPEDEF_(0x80080217)
#define APPX_E_INVALID_PUBLISHER_BRIDGING                  _HRESULT_TYPEDEF_(0x80080218)
#define APPX_E_DIGEST_MISMATCH                             _HRESULT_TYPEDEF_(0x80080219)
#define BT_E_SPURIOUS_ACTIVATION                           _HRESULT_TYPEDEF_(0x80080300)

/*Cryptographic Error Codes */
#define NTE_BAD_UID                                        _HRESULT_TYPEDEF_(0x80090001)
#define ERROR_AUDITING_DISABLED                            _HRESULT_TYPEDEF_(0xC0090001)
#define NTE_BAD_HASH                                       _HRESULT_TYPEDEF_(0x80090002)
#define ERROR_ALL_SIDS_FILTERED                            _HRESULT_TYPEDEF_(0xC0090002)
#define NTE_BAD_KEY                                        _HRESULT_TYPEDEF_(0x80090003)
#define ERROR_BIZRULES_NOT_ENABLED                         _HRESULT_TYPEDEF_(0xC0090003)
#define NTE_BAD_LEN                                        _HRESULT_TYPEDEF_(0x80090004)
#define NTE_BAD_DATA                                       _HRESULT_TYPEDEF_(0x80090005)
#define NTE_BAD_SIGNATURE                                  _HRESULT_TYPEDEF_(0x80090006)
#define NTE_BAD_VER                                        _HRESULT_TYPEDEF_(0x80090007)
#define NTE_BAD_ALGID                                      _HRESULT_TYPEDEF_(0x80090008)
#define NTE_BAD_FLAGS                                      _HRESULT_TYPEDEF_(0x80090009)
#define NTE_BAD_TYPE                                       _HRESULT_TYPEDEF_(0x8009000A)
#define NTE_BAD_KEY_STATE                                  _HRESULT_TYPEDEF_(0x8009000B)
#define NTE_BAD_HASH_STATE                                 _HRESULT_TYPEDEF_(0x8009000C)
#define NTE_NO_KEY                                         _HRESULT_TYPEDEF_(0x8009000D)
#define NTE_NO_MEMORY                                      _HRESULT_TYPEDEF_(0x8009000E)
#define NTE_EXISTS                                         _HRESULT_TYPEDEF_(0x8009000F)
#define NTE_PERM                                           _HRESULT_TYPEDEF_(0x80090010)
#define NTE_NOT_FOUND                                      _HRESULT_TYPEDEF_(0x80090011)
#define NTE_DOUBLE_ENCRYPT                                 _HRESULT_TYPEDEF_(0x80090012)
#define NTE_BAD_PROVIDER                                   _HRESULT_TYPEDEF_(0x80090013)
#define NTE_BAD_PROV_TYPE                                  _HRESULT_TYPEDEF_(0x80090014)
#define NTE_BAD_PUBLIC_KEY                                 _HRESULT_TYPEDEF_(0x80090015)
#define NTE_BAD_KEYSET                                     _HRESULT_TYPEDEF_(0x80090016)
#define NTE_PROV_TYPE_NOT_DEF                              _HRESULT_TYPEDEF_(0x80090017)
#define NTE_PROV_TYPE_ENTRY_BAD                            _HRESULT_TYPEDEF_(0x80090018)
#define NTE_KEYSET_NOT_DEF                                 _HRESULT_TYPEDEF_(0x80090019)
#define NTE_KEYSET_ENTRY_BAD                               _HRESULT_TYPEDEF_(0x8009001A)
#define NTE_PROV_TYPE_NO_MATCH                             _HRESULT_TYPEDEF_(0x8009001B)
#define NTE_SIGNATURE_FILE_BAD                             _HRESULT_TYPEDEF_(0x8009001C)
#define NTE_PROVIDER_DLL_FAIL                              _HRESULT_TYPEDEF_(0x8009001D)
#define NTE_PROV_DLL_NOT_FOUND                             _HRESULT_TYPEDEF_(0x8009001E)
#define NTE_BAD_KEYSET_PARAM                               _HRESULT_TYPEDEF_(0x8009001F)
#define NTE_FAIL                                           _HRESULT_TYPEDEF_(0x80090020)
#define NTE_SYS_ERR                                        _HRESULT_TYPEDEF_(0x80090021)
#define NTE_SILENT_CONTEXT                                 _HRESULT_TYPEDEF_(0x80090022)
#define NTE_TOKEN_KEYSET_STORAGE_FULL                      _HRESULT_TYPEDEF_(0x80090023)
#define NTE_TEMPORARY_PROFILE                              _HRESULT_TYPEDEF_(0x80090024)
#define NTE_FIXEDPARAMETER                                 _HRESULT_TYPEDEF_(0x80090025)
#define NTE_INVALID_HANDLE                                 _HRESULT_TYPEDEF_(0x80090026)
#define NTE_INVALID_PARAMETER                              _HRESULT_TYPEDEF_(0x80090027)
#define NTE_BUFFER_TOO_SMALL                               _HRESULT_TYPEDEF_(0x80090028)
#define NTE_NOT_SUPPORTED                                  _HRESULT_TYPEDEF_(0x80090029)
#define NTE_NO_MORE_ITEMS                                  _HRESULT_TYPEDEF_(0x8009002A)
#define NTE_BUFFERS_OVERLAP                                _HRESULT_TYPEDEF_(0x8009002B)
#define NTE_DECRYPTION_FAILURE                             _HRESULT_TYPEDEF_(0x8009002C)
#define NTE_INTERNAL_ERROR                                 _HRESULT_TYPEDEF_(0x8009002D)
#define NTE_UI_REQUIRED                                    _HRESULT_TYPEDEF_(0x8009002E)
#define NTE_HMAC_NOT_SUPPORTED                             _HRESULT_TYPEDEF_(0x8009002F)
#define NTE_DEVICE_NOT_READY                               _HRESULT_TYPEDEF_(0x80090030)
#define NTE_AUTHENTICATION_IGNORED                         _HRESULT_TYPEDEF_(0x80090031)
#define NTE_VALIDATION_FAILED                              _HRESULT_TYPEDEF_(0x80090032)
#define NTE_INCORRECT_PASSWORD                             _HRESULT_TYPEDEF_(0x80090033)
#define NTE_ENCRYPTION_FAILURE                             _HRESULT_TYPEDEF_(0x80090034)
#define NTE_DEVICE_NOT_FOUND                               _HRESULT_TYPEDEF_(0x80090035)
#define NTE_USER_CANCELLED                                 _HRESULT_TYPEDEF_(0x80090036)
#define NTE_PASSWORD_CHANGE_REQUIRED                       _HRESULT_TYPEDEF_(0x80090037)
#define NTE_NOT_ACTIVE_CONSOLE                             _HRESULT_TYPEDEF_(0x80090038)
#define NTE_OP_OK                                          _HRESULT_TYPEDEF_(0)

#define SEC_E_INSUFFICIENT_MEMORY                          _HRESULT_TYPEDEF_(0x80090300)
#define SEC_E_INVALID_HANDLE                               _HRESULT_TYPEDEF_(0x80090301)
#define SEC_E_UNSUPPORTED_FUNCTION                         _HRESULT_TYPEDEF_(0x80090302)
#define SEC_E_TARGET_UNKNOWN                               _HRESULT_TYPEDEF_(0x80090303)
#define SEC_E_INTERNAL_ERROR                               _HRESULT_TYPEDEF_(0x80090304)
#define SEC_E_SECPKG_NOT_FOUND                             _HRESULT_TYPEDEF_(0x80090305)
#define SEC_E_NOT_OWNER                                    _HRESULT_TYPEDEF_(0x80090306)
#define SEC_E_CANNOT_INSTALL                               _HRESULT_TYPEDEF_(0x80090307)
#define SEC_E_INVALID_TOKEN                                _HRESULT_TYPEDEF_(0x80090308)
#define SEC_E_CANNOT_PACK                                  _HRESULT_TYPEDEF_(0x80090309)
#define SEC_E_QOP_NOT_SUPPORTED                            _HRESULT_TYPEDEF_(0x8009030A)
#define SEC_E_NO_IMPERSONATION                             _HRESULT_TYPEDEF_(0x8009030B)
#define SEC_E_LOGON_DENIED                                 _HRESULT_TYPEDEF_(0x8009030C)
#define SEC_E_UNKNOWN_CREDENTIALS                          _HRESULT_TYPEDEF_(0x8009030D)
#define SEC_E_NO_CREDENTIALS                               _HRESULT_TYPEDEF_(0x8009030E)
#define SEC_E_MESSAGE_ALTERED                              _HRESULT_TYPEDEF_(0x8009030F)
#define SEC_E_OUT_OF_SEQUENCE                              _HRESULT_TYPEDEF_(0x80090310)
#define SEC_E_NO_AUTHENTICATING_AUTHORITY                  _HRESULT_TYPEDEF_(0x80090311)
#define SEC_I_CONTINUE_NEEDED                              _HRESULT_TYPEDEF_(0x00090312)
#define SEC_I_COMPLETE_NEEDED                              _HRESULT_TYPEDEF_(0x00090313)
#define SEC_I_COMPLETE_AND_CONTINUE                        _HRESULT_TYPEDEF_(0x00090314)
#define SEC_I_LOCAL_LOGON                                  _HRESULT_TYPEDEF_(0x00090315)
#define SEC_I_GENERIC_EXTENSION_RECEIVED                   _HRESULT_TYPEDEF_(0x00090316)
#define SEC_E_BAD_PKGID                                    _HRESULT_TYPEDEF_(0x80090316)
#define SEC_I_CONTEXT_EXPIRED                              _HRESULT_TYPEDEF_(0x00090317)
#define SEC_E_CONTEXT_EXPIRED                              _HRESULT_TYPEDEF_(0x80090317)
#define SEC_E_INCOMPLETE_MESSAGE                           _HRESULT_TYPEDEF_(0x80090318)
#define SEC_I_INCOMPLETE_CREDENTIALS                       _HRESULT_TYPEDEF_(0x00090320)
#define SEC_E_INCOMPLETE_CREDENTIALS                       _HRESULT_TYPEDEF_(0x80090320)
#define SEC_I_RENEGOTIATE                                  _HRESULT_TYPEDEF_(0x00090321)
#define SEC_E_BUFFER_TOO_SMALL                             _HRESULT_TYPEDEF_(0x80090321)
#define SEC_E_WRONG_PRINCIPAL                              _HRESULT_TYPEDEF_(0x80090322)
#define SEC_I_NO_LSA_CONTEXT                               _HRESULT_TYPEDEF_(0x00090323)
#define SEC_E_TIME_SKEW                                    _HRESULT_TYPEDEF_(0x80090324)
#define SEC_E_UNTRUSTED_ROOT                               _HRESULT_TYPEDEF_(0x80090325)
#define SEC_E_ILLEGAL_MESSAGE                              _HRESULT_TYPEDEF_(0x80090326)
#define SEC_E_CERT_UNKNOWN                                 _HRESULT_TYPEDEF_(0x80090327)
#define SEC_E_CERT_EXPIRED                                 _HRESULT_TYPEDEF_(0x80090328)
#define SEC_E_ENCRYPT_FAILURE                              _HRESULT_TYPEDEF_(0x80090329)
#define SEC_E_DECRYPT_FAILURE                              _HRESULT_TYPEDEF_(0x80090330)
#define SEC_E_ALGORITHM_MISMATCH                           _HRESULT_TYPEDEF_(0x80090331)
#define SEC_E_SECURITY_QOS_FAILED                          _HRESULT_TYPEDEF_(0x80090332)
#define SEC_E_UNFINISHED_CONTEXT_DELETED                   _HRESULT_TYPEDEF_(0x80090333)
#define SEC_E_NO_TGT_REPLY                                 _HRESULT_TYPEDEF_(0x80090334)
#define SEC_E_NO_IP_ADDRESSES                              _HRESULT_TYPEDEF_(0x80090335)
#define SEC_E_WRONG_CREDENTIAL_HANDLE                      _HRESULT_TYPEDEF_(0x80090336)
#define SEC_E_CRYPTO_SYSTEM_INVALID                        _HRESULT_TYPEDEF_(0x80090337)
#define SEC_E_MAX_REFERRALS_EXCEEDED                       _HRESULT_TYPEDEF_(0x80090338)
#define SEC_E_MUST_BE_KDC                                  _HRESULT_TYPEDEF_(0x80090339)
#define SEC_E_STRONG_CRYPTO_NOT_SUPPORTED                  _HRESULT_TYPEDEF_(0x8009033A)
#define SEC_E_TOO_MANY_PRINCIPALS                          _HRESULT_TYPEDEF_(0x8009033B)
#define SEC_E_NO_PA_DATA                                   _HRESULT_TYPEDEF_(0x8009033C)
#define SEC_E_PKINIT_NAME_MISMATCH                         _HRESULT_TYPEDEF_(0x8009033D)
#define SEC_E_SMARTCARD_LOGON_REQUIRED                     _HRESULT_TYPEDEF_(0x8009033E)
#define SEC_E_SHUTDOWN_IN_PROGRESS                         _HRESULT_TYPEDEF_(0x8009033F)
#define SEC_E_KDC_INVALID_REQUEST                          _HRESULT_TYPEDEF_(0x80090340)
#define SEC_E_KDC_UNABLE_TO_REFER                          _HRESULT_TYPEDEF_(0x80090341)
#define SEC_E_KDC_UNKNOWN_ETYPE                            _HRESULT_TYPEDEF_(0x80090342)
#define SEC_E_UNSUPPORTED_PREAUTH                          _HRESULT_TYPEDEF_(0x80090343)
#define SEC_E_DELEGATION_REQUIRED                          _HRESULT_TYPEDEF_(0x80090345)
#define SEC_E_BAD_BINDINGS                                 _HRESULT_TYPEDEF_(0x80090346)
#define SEC_E_MULTIPLE_ACCOUNTS                            _HRESULT_TYPEDEF_(0x80090347)
#define SEC_E_NO_KERB_KEY                                  _HRESULT_TYPEDEF_(0x80090348)
#define SEC_E_CERT_WRONG_USAGE                             _HRESULT_TYPEDEF_(0x80090349)
#define SEC_E_DOWNGRADE_DETECTED                           _HRESULT_TYPEDEF_(0x80090350)
#define SEC_E_SMARTCARD_CERT_REVOKED                       _HRESULT_TYPEDEF_(0x80090351)
#define SEC_E_ISSUING_CA_UNTRUSTED                         _HRESULT_TYPEDEF_(0x80090352)
#define SEC_E_REVOCATION_OFFLINE_C                         _HRESULT_TYPEDEF_(0x80090353)
#define SEC_E_PKINIT_CLIENT_FAILURE                        _HRESULT_TYPEDEF_(0x80090354)
#define SEC_E_SMARTCARD_CERT_EXPIRED                       _HRESULT_TYPEDEF_(0x80090355)
#define SEC_E_NO_S4U_PROT_SUPPORT                          _HRESULT_TYPEDEF_(0x80090356)
#define SEC_E_CROSSREALM_DELEGATION_FAILURE                _HRESULT_TYPEDEF_(0x80090357)
#define SEC_E_REVOCATION_OFFLINE_KDC                       _HRESULT_TYPEDEF_(0x80090358)
#define SEC_E_ISSUING_CA_UNTRUSTED_KDC                     _HRESULT_TYPEDEF_(0x80090359)
#define SEC_E_KDC_CERT_EXPIRED                             _HRESULT_TYPEDEF_(0x8009035A)
#define SEC_E_KDC_CERT_REVOKED                             _HRESULT_TYPEDEF_(0x8009035B)
#define SEC_I_SIGNATURE_NEEDED                             _HRESULT_TYPEDEF_(0x0009035C)
#define SEC_E_INVALID_PARAMETER                            _HRESULT_TYPEDEF_(0x8009035D)
#define SEC_E_DELEGATION_POLICY                            _HRESULT_TYPEDEF_(0x8009035E)
#define SEC_E_POLICY_NLTM_ONLY                             _HRESULT_TYPEDEF_(0x8009035F)
#define SEC_I_NO_RENEGOTIATION                             _HRESULT_TYPEDEF_(0x00090360)
#define SEC_E_NO_CONTEXT                                   _HRESULT_TYPEDEF_(0x80090361)
#define SEC_E_PKU2U_CERT_FAILURE                           _HRESULT_TYPEDEF_(0x80090362)
#define SEC_E_MUTUAL_AUTH_FAILED                           _HRESULT_TYPEDEF_(0x80090363)
#define SEC_I_MESSAGE_FRAGMENT                             _HRESULT_TYPEDEF_(0x00090364)
#define SEC_E_ONLY_HTTPS_ALLOWED                           _HRESULT_TYPEDEF_(0x80090365)
#define SEC_I_CONTINUE_NEEDED_MESSAGE_OK                   _HRESULT_TYPEDEF_(0x00090366)
#define SEC_E_APPLICATION_PROTOCOL_MISMATCH                _HRESULT_TYPEDEF_(0x80090367)
#define SEC_I_ASYNC_CALL_PENDING                           _HRESULT_TYPEDEF_(0x00090368)
#define SEC_E_INVALID_UPN_NAME                             _HRESULT_TYPEDEF_(0x80090369)
#define SEC_E_EXT_BUFFER_TOO_SMALL                         _HRESULT_TYPEDEF_(0x8009036A)
#define SEC_E_INSUFFICIENT_BUFFERS                         _HRESULT_TYPEDEF_(0x8009036B)

#define CRYPT_E_MSG_ERROR                                  _HRESULT_TYPEDEF_(0x80091001)
#define CRYPT_E_UNKNOWN_ALGO                               _HRESULT_TYPEDEF_(0x80091002)
#define CRYPT_E_OID_FORMAT                                 _HRESULT_TYPEDEF_(0x80091003)
#define CRYPT_E_INVALID_MSG_TYPE                           _HRESULT_TYPEDEF_(0x80091004)
#define CRYPT_E_UNEXPECTED_ENCODING                        _HRESULT_TYPEDEF_(0x80091005)
#define CRYPT_E_AUTH_ATTR_MISSING                          _HRESULT_TYPEDEF_(0x80091006)
#define CRYPT_E_HASH_VALUE                                 _HRESULT_TYPEDEF_(0x80091007)
#define CRYPT_E_INVALID_INDEX                              _HRESULT_TYPEDEF_(0x80091008)
#define CRYPT_E_ALREADY_DECRYPTED                          _HRESULT_TYPEDEF_(0x80091009)
#define CRYPT_E_NOT_DECRYPTED                              _HRESULT_TYPEDEF_(0x8009100A)
#define CRYPT_E_RECIPIENT_NOT_FOUND                        _HRESULT_TYPEDEF_(0x8009100B)
#define CRYPT_E_CONTROL_TYPE                               _HRESULT_TYPEDEF_(0x8009100C)
#define CRYPT_E_ISSUER_SERIALNUMBER                        _HRESULT_TYPEDEF_(0x8009100D)
#define CRYPT_E_SIGNER_NOT_FOUND                           _HRESULT_TYPEDEF_(0x8009100E)
#define CRYPT_E_ATTRIBUTES_MISSING                         _HRESULT_TYPEDEF_(0x8009100F)
#define CRYPT_E_STREAM_MSG_NOT_READY                       _HRESULT_TYPEDEF_(0x80091010)
#define CRYPT_E_STREAM_INSUFFICIENT_DATA                   _HRESULT_TYPEDEF_(0x80091011)
#define CRYPT_I_NEW_PROTECTION_REQUIRED                    _HRESULT_TYPEDEF_(0x00091012)

#define CRYPT_E_BAD_LEN                                    _HRESULT_TYPEDEF_(0x80092001)
#define CRYPT_E_BAD_ENCODE                                 _HRESULT_TYPEDEF_(0x80092002)
#define CRYPT_E_FILE_ERROR                                 _HRESULT_TYPEDEF_(0x80092003)
#define CRYPT_E_NOT_FOUND                                  _HRESULT_TYPEDEF_(0x80092004)
#define CRYPT_E_EXISTS                                     _HRESULT_TYPEDEF_(0x80092005)
#define CRYPT_E_NO_PROVIDER                                _HRESULT_TYPEDEF_(0x80092006)
#define CRYPT_E_SELF_SIGNED                                _HRESULT_TYPEDEF_(0x80092007)
#define CRYPT_E_DELETED_PREV                               _HRESULT_TYPEDEF_(0x80092008)
#define CRYPT_E_NO_MATCH                                   _HRESULT_TYPEDEF_(0x80092009)
#define CRYPT_E_UNEXPECTED_MSG_TYPE                        _HRESULT_TYPEDEF_(0x8009200A)
#define CRYPT_E_NO_KEY_PROPERTY                            _HRESULT_TYPEDEF_(0x8009200B)
#define CRYPT_E_NO_DECRYPT_CERT                            _HRESULT_TYPEDEF_(0x8009200C)
#define CRYPT_E_BAD_MSG                                    _HRESULT_TYPEDEF_(0x8009200D)
#define CRYPT_E_NO_SIGNER                                  _HRESULT_TYPEDEF_(0x8009200E)
#define CRYPT_E_PENDING_CLOSE                              _HRESULT_TYPEDEF_(0x8009200F)
#define CRYPT_E_REVOKED                                    _HRESULT_TYPEDEF_(0x80092010)
#define CRYPT_E_NO_REVOCATION_DLL                          _HRESULT_TYPEDEF_(0x80092011)
#define CRYPT_E_NO_REVOCATION_CHECK                        _HRESULT_TYPEDEF_(0x80092012)
#define CRYPT_E_REVOCATION_OFFLINE                         _HRESULT_TYPEDEF_(0x80092013)
#define CRYPT_E_NOT_IN_REVOCATION_DATABASE                 _HRESULT_TYPEDEF_(0x80092014)
#define CRYPT_E_INVALID_NUMERIC_STRING                     _HRESULT_TYPEDEF_(0x80092020)
#define CRYPT_E_INVALID_PRINTABLE_STRING                   _HRESULT_TYPEDEF_(0x80092021)
#define CRYPT_E_INVALID_IA5_STRING                         _HRESULT_TYPEDEF_(0x80092022)
#define CRYPT_E_INVALID_X500_STRING                        _HRESULT_TYPEDEF_(0x80092023)
#define CRYPT_E_NOT_CHAR_STRING                            _HRESULT_TYPEDEF_(0x80092024)
#define CRYPT_E_FILERESIZED                                _HRESULT_TYPEDEF_(0x80092025)
#define CRYPT_E_SECURITY_SETTINGS                          _HRESULT_TYPEDEF_(0x80092026)
#define CRYPT_E_NO_VERIFY_USAGE_DLL                        _HRESULT_TYPEDEF_(0x80092027)
#define CRYPT_E_NO_VERIFY_USAGE_CHECK                      _HRESULT_TYPEDEF_(0x80092028)
#define CRYPT_E_VERIFY_USAGE_OFFLINE                       _HRESULT_TYPEDEF_(0x80092029)
#define CRYPT_E_NOT_IN_CTL                                 _HRESULT_TYPEDEF_(0x8009202A)
#define CRYPT_E_NO_TRUSTED_SIGNER                          _HRESULT_TYPEDEF_(0x8009202B)
#define CRYPT_E_MISSING_PUBKEY_PARA                        _HRESULT_TYPEDEF_(0x8009202C)
#define CRYPT_E_OBJECT_LOCATOR_OBJECT_NOT_FOUND            _HRESULT_TYPEDEF_(0x8009202D)
#define CRYPT_E_OSS_ERROR                                  _HRESULT_TYPEDEF_(0x80093000)
#define OSS_MORE_BUF                                       _HRESULT_TYPEDEF_(0x80093001)
#define OSS_NEGATIVE_UINTEGER                              _HRESULT_TYPEDEF_(0x80093002)
#define OSS_PDU_RANGE                                      _HRESULT_TYPEDEF_(0x80093003)
#define OSS_MORE_INPUT                                     _HRESULT_TYPEDEF_(0x80093004)
#define OSS_DATA_ERROR                                     _HRESULT_TYPEDEF_(0x80093005)
#define OSS_BAD_ARG                                        _HRESULT_TYPEDEF_(0x80093006)
#define OSS_BAD_VERSION                                    _HRESULT_TYPEDEF_(0x80093007)
#define OSS_OUT_MEMORY                                     _HRESULT_TYPEDEF_(0x80093008)
#define OSS_PDU_MISMATCH                                   _HRESULT_TYPEDEF_(0x80093009)
#define OSS_LIMITED                                        _HRESULT_TYPEDEF_(0x8009300A)
#define OSS_BAD_PTR                                        _HRESULT_TYPEDEF_(0x8009300B)
#define OSS_BAD_TIME                                       _HRESULT_TYPEDEF_(0x8009300C)
#define OSS_INDEFINITE_NOT_SUPPORTED                       _HRESULT_TYPEDEF_(0x8009300D)
#define OSS_MEM_ERROR                                      _HRESULT_TYPEDEF_(0x8009300E)
#define OSS_BAD_TABLE                                      _HRESULT_TYPEDEF_(0x8009300F)
#define OSS_TOO_LONG                                       _HRESULT_TYPEDEF_(0x80093010)
#define OSS_CONSTRAINT_VIOLATED                            _HRESULT_TYPEDEF_(0x80093011)
#define OSS_FATAL_ERROR                                    _HRESULT_TYPEDEF_(0x80093012)
#define OSS_ACCESS_SERIALIZATION_ERROR                     _HRESULT_TYPEDEF_(0x80093013)
#define OSS_NULL_TBL                                       _HRESULT_TYPEDEF_(0x80093014)
#define OSS_NULL_FCN                                       _HRESULT_TYPEDEF_(0x80093015)
#define OSS_BAD_ENCRULES                                   _HRESULT_TYPEDEF_(0x80093016)
#define OSS_UNAVAIL_ENCRULES                               _HRESULT_TYPEDEF_(0x80093017)
#define OSS_CANT_OPEN_TRACE_WINDOW                         _HRESULT_TYPEDEF_(0x80093018)
#define OSS_UNIMPLEMENTED                                  _HRESULT_TYPEDEF_(0x80093019)
#define OSS_OID_DLL_NOT_LINKED                             _HRESULT_TYPEDEF_(0x8009301A)
#define OSS_CANT_OPEN_TRACE_FILE                           _HRESULT_TYPEDEF_(0x8009301B)
#define OSS_TRACE_FILE_ALREADY_OPEN                        _HRESULT_TYPEDEF_(0x8009301C)
#define OSS_TABLE_MISMATCH                                 _HRESULT_TYPEDEF_(0x8009301D)
#define OSS_TYPE_NOT_SUPPORTED                             _HRESULT_TYPEDEF_(0x8009301E)
#define OSS_REAL_DLL_NOT_LINKED                            _HRESULT_TYPEDEF_(0x8009301F)
#define OSS_REAL_CODE_NOT_LINKED                           _HRESULT_TYPEDEF_(0x80093020)
#define OSS_OUT_OF_RANGE                                   _HRESULT_TYPEDEF_(0x80093021)
#define OSS_COPIER_DLL_NOT_LINKED                          _HRESULT_TYPEDEF_(0x80093022)
#define OSS_CONSTRAINT_DLL_NOT_LINKED                      _HRESULT_TYPEDEF_(0x80093023)
#define OSS_COMPARATOR_DLL_NOT_LINKED                      _HRESULT_TYPEDEF_(0x80093024)
#define OSS_COMPARATOR_CODE_NOT_LINKED                     _HRESULT_TYPEDEF_(0x80093025)
#define OSS_MEM_MGR_DLL_NOT_LINKED                         _HRESULT_TYPEDEF_(0x80093026)
#define OSS_PDV_DLL_NOT_LINKED                             _HRESULT_TYPEDEF_(0x80093027)
#define OSS_PDV_CODE_NOT_LINKED                            _HRESULT_TYPEDEF_(0x80093028)
#define OSS_API_DLL_NOT_LINKED                             _HRESULT_TYPEDEF_(0x80093029)
#define OSS_BERDER_DLL_NOT_LINKED                          _HRESULT_TYPEDEF_(0x8009302A)
#define OSS_PER_DLL_NOT_LINKED                             _HRESULT_TYPEDEF_(0x8009302B)
#define OSS_OPEN_TYPE_ERROR                                _HRESULT_TYPEDEF_(0x8009302C)
#define OSS_MUTEX_NOT_CREATED                              _HRESULT_TYPEDEF_(0x8009302D)
#define OSS_CANT_CLOSE_TRACE_FILE                          _HRESULT_TYPEDEF_(0x8009302E)
#define CRYPT_E_ASN1_ERROR                                 _HRESULT_TYPEDEF_(0x80093100)
#define CRYPT_E_ASN1_INTERNAL                              _HRESULT_TYPEDEF_(0x80093101)
#define CRYPT_E_ASN1_EOD                                   _HRESULT_TYPEDEF_(0x80093102)
#define CRYPT_E_ASN1_CORRUPT                               _HRESULT_TYPEDEF_(0x80093103)
#define CRYPT_E_ASN1_LARGE                                 _HRESULT_TYPEDEF_(0x80093104)
#define CRYPT_E_ASN1_CONSTRAINT                            _HRESULT_TYPEDEF_(0x80093105)
#define CRYPT_E_ASN1_MEMORY                                _HRESULT_TYPEDEF_(0x80093106)
#define CRYPT_E_ASN1_OVERFLOW                              _HRESULT_TYPEDEF_(0x80093107)
#define CRYPT_E_ASN1_BADPDU                                _HRESULT_TYPEDEF_(0x80093108)
#define CRYPT_E_ASN1_BADARGS                               _HRESULT_TYPEDEF_(0x80093109)
#define CRYPT_E_ASN1_BADREAL                               _HRESULT_TYPEDEF_(0x8009310A)
#define CRYPT_E_ASN1_BADTAG                                _HRESULT_TYPEDEF_(0x8009310B)
#define CRYPT_E_ASN1_CHOICE                                _HRESULT_TYPEDEF_(0x8009310C)
#define CRYPT_E_ASN1_RULE                                  _HRESULT_TYPEDEF_(0x8009310D)
#define CRYPT_E_ASN1_UTF8                                  _HRESULT_TYPEDEF_(0x8009310E)
#define CRYPT_E_ASN1_PDU_TYPE                              _HRESULT_TYPEDEF_(0x80093133)
#define CRYPT_E_ASN1_NYI                                   _HRESULT_TYPEDEF_(0x80093134)
#define CRYPT_E_ASN1_EXTENDED                              _HRESULT_TYPEDEF_(0x80093201)
#define CRYPT_E_ASN1_NOEOD                                 _HRESULT_TYPEDEF_(0x80093202)

#define CERTSRV_E_BAD_REQUESTSUBJECT                       _HRESULT_TYPEDEF_(0x80094001)
#define CERTSRV_E_NO_REQUEST                               _HRESULT_TYPEDEF_(0x80094002)
#define CERTSRV_E_BAD_REQUESTSTATUS                        _HRESULT_TYPEDEF_(0x80094003)
#define CERTSRV_E_PROPERTY_EMPTY                           _HRESULT_TYPEDEF_(0x80094004)
#define CERTSRV_E_INVALID_CA_CERTIFICATE                   _HRESULT_TYPEDEF_(0x80094005)
#define CERTSRV_E_SERVER_SUSPENDED                         _HRESULT_TYPEDEF_(0x80094006)
#define CERTSRV_E_ENCODING_LENGTH                          _HRESULT_TYPEDEF_(0x80094007)
#define CERTSRV_E_ROLECONFLICT                             _HRESULT_TYPEDEF_(0x80094008)
#define CERTSRV_E_RESTRICTEDOFFICER                        _HRESULT_TYPEDEF_(0x80094009)
#define CERTSRV_E_KEY_ARCHIVAL_NOT_CONFIGURED              _HRESULT_TYPEDEF_(0x8009400A)
#define CERTSRV_E_NO_VALID_KRA                             _HRESULT_TYPEDEF_(0x8009400B)
#define CERTSRV_E_BAD_REQUEST_KEY_ARCHIVAL                 _HRESULT_TYPEDEF_(0x8009400C)
#define CERTSRV_E_NO_CAADMIN_DEFINED                       _HRESULT_TYPEDEF_(0x8009400D)
#define CERTSRV_E_BAD_RENEWAL_CERT_ATTRIBUTE               _HRESULT_TYPEDEF_(0x8009400E)
#define CERTSRV_E_NO_DB_SESSIONS                           _HRESULT_TYPEDEF_(0x8009400F)
#define CERTSRV_E_ALIGNMENT_FAULT                          _HRESULT_TYPEDEF_(0x80094010)
#define CERTSRV_E_ENROLL_DENIED                            _HRESULT_TYPEDEF_(0x80094011)
#define CERTSRV_E_TEMPLATE_DENIED                          _HRESULT_TYPEDEF_(0x80094012)
#define CERTSRV_E_DOWNLEVEL_DC_SSL_OR_UPGRADE              _HRESULT_TYPEDEF_(0x80094013)
#define CERTSRV_E_ADMIN_DENIED_REQUEST                     _HRESULT_TYPEDEF_(0x80094014)
#define CERTSRV_E_NO_POLICY_SERVER                         _HRESULT_TYPEDEF_(0x80094015)
#define CERTSRV_E_WEAK_SIGNATURE_OR_KEY                    _HRESULT_TYPEDEF_(0x80094016)
#define CERTSRV_E_KEY_ATTESTATION_NOT_SUPPORTED            _HRESULT_TYPEDEF_(0x80094017)
#define CERTSRV_E_ENCRYPTION_CERT_REQUIRED                 _HRESULT_TYPEDEF_(0x80094018)
#define CERTSRV_E_UNSUPPORTED_CERT_TYPE                    _HRESULT_TYPEDEF_(0x80094800)
#define CERTSRV_E_NO_CERT_TYPE                             _HRESULT_TYPEDEF_(0x80094801)
#define CERTSRV_E_TEMPLATE_CONFLICT                        _HRESULT_TYPEDEF_(0x80094802)
#define CERTSRV_E_SUBJECT_ALT_NAME_REQUIRED                _HRESULT_TYPEDEF_(0x80094803)
#define CERTSRV_E_ARCHIVED_KEY_REQUIRED                    _HRESULT_TYPEDEF_(0x80094804)
#define CERTSRV_E_SMIME_REQUIRED                           _HRESULT_TYPEDEF_(0x80094805)
#define CERTSRV_E_BAD_RENEWAL_SUBJECT                      _HRESULT_TYPEDEF_(0x80094806)
#define CERTSRV_E_BAD_TEMPLATE_VERSION                     _HRESULT_TYPEDEF_(0x80094807)
#define CERTSRV_E_TEMPLATE_POLICY_REQUIRED                 _HRESULT_TYPEDEF_(0x80094808)
#define CERTSRV_E_SIGNATURE_POLICY_REQUIRED                _HRESULT_TYPEDEF_(0x80094809)
#define CERTSRV_E_SIGNATURE_COUNT                          _HRESULT_TYPEDEF_(0x8009480A)
#define CERTSRV_E_SIGNATURE_REJECTED                       _HRESULT_TYPEDEF_(0x8009480B)
#define CERTSRV_E_ISSUANCE_POLICY_REQUIRED                 _HRESULT_TYPEDEF_(0x8009480C)
#define CERTSRV_E_SUBJECT_UPN_REQUIRED                     _HRESULT_TYPEDEF_(0x8009480D)
#define CERTSRV_E_SUBJECT_DIRECTORY_GUID_REQUIRED          _HRESULT_TYPEDEF_(0x8009480E)
#define CERTSRV_E_SUBJECT_DNS_REQUIRED                     _HRESULT_TYPEDEF_(0x8009480F)
#define CERTSRV_E_ARCHIVED_KEY_UNEXPECTED                  _HRESULT_TYPEDEF_(0x80094810)
#define CERTSRV_E_KEY_LENGTH                               _HRESULT_TYPEDEF_(0x80094811)
#define CERTSRV_E_SUBJECT_EMAIL_REQUIRED                   _HRESULT_TYPEDEF_(0x80094812)
#define CERTSRV_E_UNKNOWN_CERT_TYPE                        _HRESULT_TYPEDEF_(0x80094813)
#define CERTSRV_E_CERT_TYPE_OVERLAP                        _HRESULT_TYPEDEF_(0x80094814)
#define CERTSRV_E_TOO_MANY_SIGNATURES                      _HRESULT_TYPEDEF_(0x80094815)
#define CERTSRV_E_RENEWAL_BAD_PUBLIC_KEY                   _HRESULT_TYPEDEF_(0x80094816)
#define CERTSRV_E_INVALID_EK                               _HRESULT_TYPEDEF_(0x80094817)
#define CERTSRV_E_INVALID_IDBINDING                        _HRESULT_TYPEDEF_(0x80094818)
#define CERTSRV_E_INVALID_ATTESTATION                      _HRESULT_TYPEDEF_(0x80094819)
#define CERTSRV_E_KEY_ATTESTATION                          _HRESULT_TYPEDEF_(0x8009481A)
#define CERTSRV_E_CORRUPT_KEY_ATTESTATION                  _HRESULT_TYPEDEF_(0x8009481B)
#define CERTSRV_E_EXPIRED_CHALLENGE                        _HRESULT_TYPEDEF_(0x8009481C)
#define CERTSRV_E_INVALID_RESPONSE                         _HRESULT_TYPEDEF_(0x8009481D)
#define CERTSRV_E_INVALID_REQUESTID                        _HRESULT_TYPEDEF_(0x8009481E)
#define CERTSRV_E_REQUEST_PRECERTIFICATE_MISMATCH          _HRESULT_TYPEDEF_(0x8009481F)
#define CERTSRV_E_PENDING_CLIENT_RESPONSE                  _HRESULT_TYPEDEF_(0x80094820)
#define CERTSRV_E_SEC_EXT_DIRECTORY_SID_REQUIRED           _HRESULT_TYPEDEF_(0x80094821)

#define XENROLL_E_KEY_NOT_EXPORTABLE                       _HRESULT_TYPEDEF_(0x80095000)
#define XENROLL_E_CANNOT_ADD_ROOT_CERT                     _HRESULT_TYPEDEF_(0x80095001)
#define XENROLL_E_RESPONSE_KA_HASH_NOT_FOUND               _HRESULT_TYPEDEF_(0x80095002)
#define XENROLL_E_RESPONSE_UNEXPECTED_KA_HASH              _HRESULT_TYPEDEF_(0x80095003)
#define XENROLL_E_RESPONSE_KA_HASH_MISMATCH                _HRESULT_TYPEDEF_(0x80095004)
#define XENROLL_E_KEYSPEC_SMIME_MISMATCH                   _HRESULT_TYPEDEF_(0x80095005)

#define TRUST_E_SYSTEM_ERROR                               _HRESULT_TYPEDEF_(0x80096001)
#define TRUST_E_NO_SIGNER_CERT                             _HRESULT_TYPEDEF_(0x80096002)
#define TRUST_E_COUNTER_SIGNER                             _HRESULT_TYPEDEF_(0x80096003)
#define TRUST_E_CERT_SIGNATURE                             _HRESULT_TYPEDEF_(0x80096004)
#define TRUST_E_TIME_STAMP                                 _HRESULT_TYPEDEF_(0x80096005)
#define TRUST_E_BAD_DIGEST                                 _HRESULT_TYPEDEF_(0x80096010)
#define TRUST_E_MALFORMED_SIGNATURE                        _HRESULT_TYPEDEF_(0x80096011)
#define TRUST_E_BASIC_CONSTRAINTS                          _HRESULT_TYPEDEF_(0x80096019)
#define TRUST_E_FINANCIAL_CRITERIA                         _HRESULT_TYPEDEF_(0x8009601E)

#define MSSIPOTF_E_OUTOFMEMRANGE                           _HRESULT_TYPEDEF_(0x80097001)
#define MSSIPOTF_E_CANTGETOBJECT                           _HRESULT_TYPEDEF_(0x80097002)
#define MSSIPOTF_E_NOHEADTABLE                             _HRESULT_TYPEDEF_(0x80097003)
#define MSSIPOTF_E_BAD_MAGICNUMBER                         _HRESULT_TYPEDEF_(0x80097004)
#define MSSIPOTF_E_BAD_OFFSET_TABLE                        _HRESULT_TYPEDEF_(0x80097005)
#define MSSIPOTF_E_TABLE_TAGORDER                          _HRESULT_TYPEDEF_(0x80097006)
#define MSSIPOTF_E_TABLE_LONGWORD                          _HRESULT_TYPEDEF_(0x80097007)
#define MSSIPOTF_E_BAD_FIRST_TABLE_PLACEMENT               _HRESULT_TYPEDEF_(0x80097008)
#define MSSIPOTF_E_TABLES_OVERLAP                          _HRESULT_TYPEDEF_(0x80097009)
#define MSSIPOTF_E_TABLE_PADBYTES                          _HRESULT_TYPEDEF_(0x8009700A)
#define MSSIPOTF_E_FILETOOSMALL                            _HRESULT_TYPEDEF_(0x8009700B)
#define MSSIPOTF_E_TABLE_CHECKSUM                          _HRESULT_TYPEDEF_(0x8009700C)
#define MSSIPOTF_E_FILE_CHECKSUM                           _HRESULT_TYPEDEF_(0x8009700D)
#define MSSIPOTF_E_FAILED_POLICY                           _HRESULT_TYPEDEF_(0x80097010)
#define MSSIPOTF_E_FAILED_HINTS_CHECK                      _HRESULT_TYPEDEF_(0x80097011)
#define MSSIPOTF_E_NOT_OPENTYPE                            _HRESULT_TYPEDEF_(0x80097012)
#define MSSIPOTF_E_FILE                                    _HRESULT_TYPEDEF_(0x80097013)
#define MSSIPOTF_E_CRYPT                                   _HRESULT_TYPEDEF_(0x80097014)
#define MSSIPOTF_E_BADVERSION                              _HRESULT_TYPEDEF_(0x80097015)
#define MSSIPOTF_E_DSIG_STRUCTURE                          _HRESULT_TYPEDEF_(0x80097016)
#define MSSIPOTF_E_PCONST_CHECK                            _HRESULT_TYPEDEF_(0x80097017)
#define MSSIPOTF_E_STRUCTURE                               _HRESULT_TYPEDEF_(0x80097018)
#define ERROR_CRED_REQUIRES_CONFIRMATION                   _HRESULT_TYPEDEF_(0x80097019)

#define TRUST_E_PROVIDER_UNKNOWN                           _HRESULT_TYPEDEF_(0x800B0001)
#define TRUST_E_ACTION_UNKNOWN                             _HRESULT_TYPEDEF_(0x800B0002)
#define TRUST_E_SUBJECT_FORM_UNKNOWN                       _HRESULT_TYPEDEF_(0x800B0003)
#define TRUST_E_SUBJECT_NOT_TRUSTED                        _HRESULT_TYPEDEF_(0x800B0004)
#define DIGSIG_E_ENCODE                                    _HRESULT_TYPEDEF_(0x800B0005)
#define DIGSIG_E_DECODE                                    _HRESULT_TYPEDEF_(0x800B0006)
#define DIGSIG_E_EXTENSIBILITY                             _HRESULT_TYPEDEF_(0x800B0007)
#define DIGSIG_E_CRYPTO                                    _HRESULT_TYPEDEF_(0x800B0008)
#define PERSIST_E_SIZEDEFINITE                             _HRESULT_TYPEDEF_(0x800B0009)
#define PERSIST_E_SIZEINDEFINITE                           _HRESULT_TYPEDEF_(0x800B000A)
#define PERSIST_E_NOTSELFSIZING                            _HRESULT_TYPEDEF_(0x800B000B)
#define TRUST_E_NOSIGNATURE                                _HRESULT_TYPEDEF_(0x800B0100)
#define CERT_E_EXPIRED                                     _HRESULT_TYPEDEF_(0x800B0101)
#define CERT_E_VALIDITYPERIODNESTING                       _HRESULT_TYPEDEF_(0x800B0102)
#define CERT_E_ROLE                                        _HRESULT_TYPEDEF_(0x800B0103)
#define CERT_E_PATHLENCONST                                _HRESULT_TYPEDEF_(0x800B0104)
#define CERT_E_CRITICAL                                    _HRESULT_TYPEDEF_(0x800B0105)
#define CERT_E_PURPOSE                                     _HRESULT_TYPEDEF_(0x800B0106)
#define CERT_E_ISSUERCHAINING                              _HRESULT_TYPEDEF_(0x800B0107)
#define CERT_E_MALFORMED                                   _HRESULT_TYPEDEF_(0x800B0108)
#define CERT_E_UNTRUSTEDROOT                               _HRESULT_TYPEDEF_(0x800B0109)
#define CERT_E_CHAINING                                    _HRESULT_TYPEDEF_(0x800B010A)
#define TRUST_E_FAIL                                       _HRESULT_TYPEDEF_(0x800B010B)
#define CERT_E_REVOKED                                     _HRESULT_TYPEDEF_(0x800B010C)
#define CERT_E_UNTRUSTEDTESTROOT                           _HRESULT_TYPEDEF_(0x800B010D)
#define CERT_E_REVOCATION_FAILURE                          _HRESULT_TYPEDEF_(0x800B010E)
#define CERT_E_CN_NO_MATCH                                 _HRESULT_TYPEDEF_(0x800B010F)
#define CERT_E_WRONG_USAGE                                 _HRESULT_TYPEDEF_(0x800B0110)
#define TRUST_E_EXPLICIT_DISTRUST                          _HRESULT_TYPEDEF_(0x800B0111)
#define CERT_E_UNTRUSTEDCA                                 _HRESULT_TYPEDEF_(0x800B0112)
#define CERT_E_INVALID_POLICY                              _HRESULT_TYPEDEF_(0x800B0113)
#define CERT_E_INVALID_NAME                                _HRESULT_TYPEDEF_(0x800B0114)

#define INET_E_INVALID_URL                                 _HRESULT_TYPEDEF_(0x800C0002)
#define INET_E_NO_SESSION                                  _HRESULT_TYPEDEF_(0x800C0003)
#define INET_E_CANNOT_CONNECT                              _HRESULT_TYPEDEF_(0x800C0004)
#define INET_E_RESOURCE_NOT_FOUND                          _HRESULT_TYPEDEF_(0x800C0005)
#define INET_E_OBJECT_NOT_FOUND                            _HRESULT_TYPEDEF_(0x800C0006)
#define INET_E_DATA_NOT_AVAILABLE                          _HRESULT_TYPEDEF_(0x800C0007)
#define INET_E_DOWNLOAD_FAILURE                            _HRESULT_TYPEDEF_(0x800C0008)
#define INET_E_AUTHENTICATION_REQUIRED                     _HRESULT_TYPEDEF_(0x800C0009)
#define INET_E_NO_VALID_MEDIA                              _HRESULT_TYPEDEF_(0x800C000A)
#define INET_E_CONNECTION_TIMEOUT                          _HRESULT_TYPEDEF_(0x800C000B)
#define INET_E_INVALID_REQUEST                             _HRESULT_TYPEDEF_(0x800C000C)
#define INET_E_UNKNOWN_PROTOCOL                            _HRESULT_TYPEDEF_(0x800C000D)
#define INET_E_SECURITY_PROBLEM                            _HRESULT_TYPEDEF_(0x800C000E)
#define INET_E_CANNOT_LOAD_DATA                            _HRESULT_TYPEDEF_(0x800C000F)
#define INET_E_CANNOT_INSTANTIATE_OBJECT                   _HRESULT_TYPEDEF_(0x800C0010)
#define INET_E_REDIRECT_FAILED                             _HRESULT_TYPEDEF_(0x800C0014)
#define INET_E_REDIRECT_TO_DIR                             _HRESULT_TYPEDEF_(0x800C0015)
#define INET_E_INVALID_CERTIFICATE                         _HRESULT_TYPEDEF_(0x800C0019)

#define SPAPI_E_EXPECTED_SECTION_NAME                      _HRESULT_TYPEDEF_(0x800F0000)
#define SPAPI_E_BAD_SECTION_NAME_LINE                      _HRESULT_TYPEDEF_(0x800F0001)
#define SPAPI_E_SECTION_NAME_TOO_LONG                      _HRESULT_TYPEDEF_(0x800F0002)
#define SPAPI_E_GENERAL_SYNTAX                             _HRESULT_TYPEDEF_(0x800F0003)
#define SPAPI_E_WRONG_INF_STYLE                            _HRESULT_TYPEDEF_(0x800F0100)
#define SPAPI_E_SECTION_NOT_FOUND                          _HRESULT_TYPEDEF_(0x800F0101)
#define SPAPI_E_LINE_NOT_FOUND                             _HRESULT_TYPEDEF_(0x800F0102)
#define SPAPI_E_NO_BACKUP                                  _HRESULT_TYPEDEF_(0x800F0103)
#define SPAPI_E_NO_ASSOCIATED_CLASS                        _HRESULT_TYPEDEF_(0x800F0200)
#define SPAPI_E_CLASS_MISMATCH                             _HRESULT_TYPEDEF_(0x800F0201)
#define SPAPI_E_DUPLICATE_FOUND                            _HRESULT_TYPEDEF_(0x800F0202)
#define SPAPI_E_NO_DRIVER_SELECTED                         _HRESULT_TYPEDEF_(0x800F0203)
#define SPAPI_E_KEY_DOES_NOT_EXIST                         _HRESULT_TYPEDEF_(0x800F0204)
#define SPAPI_E_INVALID_DEVINST_NAME                       _HRESULT_TYPEDEF_(0x800F0205)
#define SPAPI_E_INVALID_CLASS                              _HRESULT_TYPEDEF_(0x800F0206)
#define SPAPI_E_DEVINST_ALREADY_EXISTS                     _HRESULT_TYPEDEF_(0x800F0207)
#define SPAPI_E_DEVINFO_NOT_REGISTERED                     _HRESULT_TYPEDEF_(0x800F0208)
#define SPAPI_E_INVALID_REG_PROPERTY                       _HRESULT_TYPEDEF_(0x800F0209)
#define SPAPI_E_NO_INF                                     _HRESULT_TYPEDEF_(0x800F020A)
#define SPAPI_E_NO_SUCH_DEVINST                            _HRESULT_TYPEDEF_(0x800F020B)
#define SPAPI_E_CANT_LOAD_CLASS_ICON                       _HRESULT_TYPEDEF_(0x800F020C)
#define SPAPI_E_INVALID_CLASS_INSTALLER                    _HRESULT_TYPEDEF_(0x800F020D)
#define SPAPI_E_DI_DO_DEFAULT                              _HRESULT_TYPEDEF_(0x800F020E)
#define SPAPI_E_DI_NOFILECOPY                              _HRESULT_TYPEDEF_(0x800F020F)
#define SPAPI_E_INVALID_HWPROFILE                          _HRESULT_TYPEDEF_(0x800F0210)
#define SPAPI_E_NO_DEVICE_SELECTED                         _HRESULT_TYPEDEF_(0x800F0211)
#define SPAPI_E_DEVINFO_LIST_LOCKED                        _HRESULT_TYPEDEF_(0x800F0212)
#define SPAPI_E_DEVINFO_DATA_LOCKED                        _HRESULT_TYPEDEF_(0x800F0213)
#define SPAPI_E_DI_BAD_PATH                                _HRESULT_TYPEDEF_(0x800F0214)
#define SPAPI_E_NO_CLASSINSTALL_PARAMS                     _HRESULT_TYPEDEF_(0x800F0215)
#define SPAPI_E_FILEQUEUE_LOCKED                           _HRESULT_TYPEDEF_(0x800F0216)
#define SPAPI_E_BAD_SERVICE_INSTALLSECT                    _HRESULT_TYPEDEF_(0x800F0217)
#define SPAPI_E_NO_CLASS_DRIVER_LIST                       _HRESULT_TYPEDEF_(0x800F0218)
#define SPAPI_E_NO_ASSOCIATED_SERVICE                      _HRESULT_TYPEDEF_(0x800F0219)
#define SPAPI_E_NO_DEFAULT_DEVICE_INTERFACE                _HRESULT_TYPEDEF_(0x800F021A)
#define SPAPI_E_DEVICE_INTERFACE_ACTIVE                    _HRESULT_TYPEDEF_(0x800F021B)
#define SPAPI_E_DEVICE_INTERFACE_REMOVED                   _HRESULT_TYPEDEF_(0x800F021C)
#define SPAPI_E_BAD_INTERFACE_INSTALLSECT                  _HRESULT_TYPEDEF_(0x800F021D)
#define SPAPI_E_NO_SUCH_INTERFACE_CLASS                    _HRESULT_TYPEDEF_(0x800F021E)
#define SPAPI_E_INVALID_REFERENCE_STRING                   _HRESULT_TYPEDEF_(0x800F021F)
#define SPAPI_E_INVALID_MACHINENAME                        _HRESULT_TYPEDEF_(0x800F0220)
#define SPAPI_E_REMOTE_COMM_FAILURE                        _HRESULT_TYPEDEF_(0x800F0221)
#define SPAPI_E_MACHINE_UNAVAILABLE                        _HRESULT_TYPEDEF_(0x800F0222)
#define SPAPI_E_NO_CONFIGMGR_SERVICES                      _HRESULT_TYPEDEF_(0x800F0223)
#define SPAPI_E_INVALID_PROPPAGE_PROVIDER                  _HRESULT_TYPEDEF_(0x800F0224)
#define SPAPI_E_NO_SUCH_DEVICE_INTERFACE                   _HRESULT_TYPEDEF_(0x800F0225)
#define SPAPI_E_DI_POSTPROCESSING_REQUIRED                 _HRESULT_TYPEDEF_(0x800F0226)
#define SPAPI_E_INVALID_COINSTALLER                        _HRESULT_TYPEDEF_(0x800F0227)
#define SPAPI_E_NO_COMPAT_DRIVERS                          _HRESULT_TYPEDEF_(0x800F0228)
#define SPAPI_E_NO_DEVICE_ICON                             _HRESULT_TYPEDEF_(0x800F0229)
#define SPAPI_E_INVALID_INF_LOGCONFIG                      _HRESULT_TYPEDEF_(0x800F022A)
#define SPAPI_E_DI_DONT_INSTALL                            _HRESULT_TYPEDEF_(0x800F022B)
#define SPAPI_E_INVALID_FILTER_DRIVER                      _HRESULT_TYPEDEF_(0x800F022C)
#define SPAPI_E_NON_WINDOWS_NT_DRIVER                      _HRESULT_TYPEDEF_(0x800F022D)
#define SPAPI_E_NON_WINDOWS_DRIVER                         _HRESULT_TYPEDEF_(0x800F022E)
#define SPAPI_E_NO_CATALOG_FOR_OEM_INF                     _HRESULT_TYPEDEF_(0x800F022F)
#define SPAPI_E_DEVINSTALL_QUEUE_NONNATIVE                 _HRESULT_TYPEDEF_(0x800F0230)
#define SPAPI_E_NOT_DISABLEABLE                            _HRESULT_TYPEDEF_(0x800F0231)
#define SPAPI_E_CANT_REMOVE_DEVINST                        _HRESULT_TYPEDEF_(0x800F0232)
#define SPAPI_E_INVALID_TARGET                             _HRESULT_TYPEDEF_(0x800F0233)
#define SPAPI_E_DRIVER_NONNATIVE                           _HRESULT_TYPEDEF_(0x800F0234)
#define SPAPI_E_IN_WOW64                                   _HRESULT_TYPEDEF_(0x800F0235)
#define SPAPI_E_SET_SYSTEM_RESTORE_POINT                   _HRESULT_TYPEDEF_(0x800F0236)
#define SPAPI_E_INCORRECTLY_COPIED_INF                     _HRESULT_TYPEDEF_(0x800F0237)
#define SPAPI_E_SCE_DISABLED                               _HRESULT_TYPEDEF_(0x800F0238)
#define SPAPI_E_UNKNOWN_EXCEPTION                          _HRESULT_TYPEDEF_(0x800F0239)
#define SPAPI_E_PNP_REGISTRY_ERROR                         _HRESULT_TYPEDEF_(0x800F023A)
#define SPAPI_E_REMOTE_REQUEST_UNSUPPORTED                 _HRESULT_TYPEDEF_(0x800F023B)
#define SPAPI_E_NOT_AN_INSTALLED_OEM_INF                   _HRESULT_TYPEDEF_(0x800F023C)
#define SPAPI_E_INF_IN_USE_BY_DEVICES                      _HRESULT_TYPEDEF_(0x800F023D)
#define SPAPI_E_DI_FUNCTION_OBSOLETE                       _HRESULT_TYPEDEF_(0x800F023E)
#define SPAPI_E_NO_AUTHENTICODE_CATALOG                    _HRESULT_TYPEDEF_(0x800F023F)
#define SPAPI_E_AUTHENTICODE_DISALLOWED                    _HRESULT_TYPEDEF_(0x800F0240)
#define SPAPI_E_AUTHENTICODE_TRUSTED_PUBLISHER             _HRESULT_TYPEDEF_(0x800F0241)
#define SPAPI_E_AUTHENTICODE_TRUST_NOT_ESTABLISHED         _HRESULT_TYPEDEF_(0x800F0242)
#define SPAPI_E_AUTHENTICODE_PUBLISHER_NOT_TRUSTED         _HRESULT_TYPEDEF_(0x800F0243)
#define SPAPI_E_SIGNATURE_OSATTRIBUTE_MISMATCH             _HRESULT_TYPEDEF_(0x800F0244)
#define SPAPI_E_ONLY_VALIDATE_VIA_AUTHENTICODE             _HRESULT_TYPEDEF_(0x800F0245)
#define SPAPI_E_DEVICE_INSTALLER_NOT_READY                 _HRESULT_TYPEDEF_(0x800F0246)
#define SPAPI_E_DRIVER_STORE_ADD_FAILED                    _HRESULT_TYPEDEF_(0x800F0247)
#define SPAPI_E_DEVICE_INSTALL_BLOCKED                     _HRESULT_TYPEDEF_(0x800F0248)
#define SPAPI_E_DRIVER_INSTALL_BLOCKED                     _HRESULT_TYPEDEF_(0x800F0249)
#define SPAPI_E_WRONG_INF_TYPE                             _HRESULT_TYPEDEF_(0x800F024A)
#define SPAPI_E_FILE_HASH_NOT_IN_CATALOG                   _HRESULT_TYPEDEF_(0x800F024B)
#define SPAPI_E_DRIVER_STORE_DELETE_FAILED                 _HRESULT_TYPEDEF_(0x800F024C)
#define SPAPI_E_UNRECOVERABLE_STACK_OVERFLOW               _HRESULT_TYPEDEF_(0x800F0300)
#define SPAPI_E_ERROR_NOT_INSTALLED                        _HRESULT_TYPEDEF_(0x800F1000)

/* Smart card management error codes */
#define SCARD_S_SUCCESS                                    NO_ERROR
#define SCARD_F_INTERNAL_ERROR                             _HRESULT_TYPEDEF_(0x80100001)
#define SCARD_E_CANCELLED                                  _HRESULT_TYPEDEF_(0x80100002)
#define SCARD_E_INVALID_HANDLE                             _HRESULT_TYPEDEF_(0x80100003)
#define SCARD_E_INVALID_PARAMETER                          _HRESULT_TYPEDEF_(0x80100004)
#define SCARD_E_INVALID_TARGET                             _HRESULT_TYPEDEF_(0x80100005)
#define SCARD_E_NO_MEMORY                                  _HRESULT_TYPEDEF_(0x80100006)
#define SCARD_F_WAITED_TOO_LONG                            _HRESULT_TYPEDEF_(0x80100007)
#define SCARD_E_INSUFFICIENT_BUFFER                        _HRESULT_TYPEDEF_(0x80100008)
#define SCARD_E_UNKNOWN_READER                             _HRESULT_TYPEDEF_(0x80100009)
#define SCARD_E_TIMEOUT                                    _HRESULT_TYPEDEF_(0x8010000A)
#define SCARD_E_SHARING_VIOLATION                          _HRESULT_TYPEDEF_(0x8010000B)
#define SCARD_E_NO_SMARTCARD                               _HRESULT_TYPEDEF_(0x8010000C)
#define SCARD_E_UNKNOWN_CARD                               _HRESULT_TYPEDEF_(0x8010000D)
#define SCARD_E_CANT_DISPOSE                               _HRESULT_TYPEDEF_(0x8010000E)
#define SCARD_E_PROTO_MISMATCH                             _HRESULT_TYPEDEF_(0x8010000F)
#define SCARD_E_NOT_READY                                  _HRESULT_TYPEDEF_(0x80100010)
#define SCARD_E_INVALID_VALUE                              _HRESULT_TYPEDEF_(0x80100011)
#define SCARD_E_SYSTEM_CANCELLED                           _HRESULT_TYPEDEF_(0x80100012)
#define SCARD_F_COMM_ERROR                                 _HRESULT_TYPEDEF_(0x80100013)
#define SCARD_F_UNKNOWN_ERROR                              _HRESULT_TYPEDEF_(0x80100014)
#define SCARD_E_INVALID_ATR                                _HRESULT_TYPEDEF_(0x80100015)
#define SCARD_E_NOT_TRANSACTED                             _HRESULT_TYPEDEF_(0x80100016)
#define SCARD_E_READER_UNAVAILABLE                         _HRESULT_TYPEDEF_(0x80100017)
#define SCARD_P_SHUTDOWN                                   _HRESULT_TYPEDEF_(0x80100018)
#define SCARD_E_PCI_TOO_SMALL                              _HRESULT_TYPEDEF_(0x80100019)
#define SCARD_E_READER_UNSUPPORTED                         _HRESULT_TYPEDEF_(0x8010001A)
#define SCARD_E_DUPLICATE_READER                           _HRESULT_TYPEDEF_(0x8010001B)
#define SCARD_E_CARD_UNSUPPORTED                           _HRESULT_TYPEDEF_(0x8010001C)
#define SCARD_E_NO_SERVICE                                 _HRESULT_TYPEDEF_(0x8010001D)
#define SCARD_E_SERVICE_STOPPED                            _HRESULT_TYPEDEF_(0x8010001E)
#define SCARD_E_UNEXPECTED                                 _HRESULT_TYPEDEF_(0x8010001F)
#define SCARD_E_ICC_INSTALLATION                           _HRESULT_TYPEDEF_(0x80100020)
#define SCARD_E_ICC_CREATEORDER                            _HRESULT_TYPEDEF_(0x80100021)
#define SCARD_E_UNSUPPORTED_FEATURE                        _HRESULT_TYPEDEF_(0x80100022)
#define SCARD_E_DIR_NOT_FOUND                              _HRESULT_TYPEDEF_(0x80100023)
#define SCARD_E_FILE_NOT_FOUND                             _HRESULT_TYPEDEF_(0x80100024)
#define SCARD_E_NO_DIR                                     _HRESULT_TYPEDEF_(0x80100025)
#define SCARD_E_NO_FILE                                    _HRESULT_TYPEDEF_(0x80100026)
#define SCARD_E_NO_ACCESS                                  _HRESULT_TYPEDEF_(0x80100027)
#define SCARD_E_WRITE_TOO_MANY                             _HRESULT_TYPEDEF_(0x80100028)
#define SCARD_E_BAD_SEEK                                   _HRESULT_TYPEDEF_(0x80100029)
#define SCARD_E_INVALID_CHV                                _HRESULT_TYPEDEF_(0x8010002A)
#define SCARD_E_UNKNOWN_RES_MNG                            _HRESULT_TYPEDEF_(0x8010002B)
#define SCARD_E_NO_SUCH_CERTIFICATE                        _HRESULT_TYPEDEF_(0x8010002C)
#define SCARD_E_CERTIFICATE_UNAVAILABLE                    _HRESULT_TYPEDEF_(0x8010002D)
#define SCARD_E_NO_READERS_AVAILABLE                       _HRESULT_TYPEDEF_(0x8010002E)
#define SCARD_E_COMM_DATA_LOST                             _HRESULT_TYPEDEF_(0x8010002F)
#define SCARD_E_NO_KEY_CONTAINER                           _HRESULT_TYPEDEF_(0x80100030)
#define SCARD_E_SERVER_TOO_BUSY                            _HRESULT_TYPEDEF_(0x80100031)
#define SCARD_E_PIN_CACHE_EXPIRED                          _HRESULT_TYPEDEF_(0x80100032)
#define SCARD_E_NO_PIN_CACHE                               _HRESULT_TYPEDEF_(0x80100033)
#define SCARD_E_READ_ONLY_CARD                             _HRESULT_TYPEDEF_(0x80100034)
#define SCARD_W_UNSUPPORTED_CARD                           _HRESULT_TYPEDEF_(0x80100065)
#define SCARD_W_UNRESPONSIVE_CARD                          _HRESULT_TYPEDEF_(0x80100066)
#define SCARD_W_UNPOWERED_CARD                             _HRESULT_TYPEDEF_(0x80100067)
#define SCARD_W_RESET_CARD                                 _HRESULT_TYPEDEF_(0x80100068)
#define SCARD_W_REMOVED_CARD                               _HRESULT_TYPEDEF_(0x80100069)
#define SCARD_W_SECURITY_VIOLATION                         _HRESULT_TYPEDEF_(0x8010006A)
#define SCARD_W_WRONG_CHV                                  _HRESULT_TYPEDEF_(0x8010006B)
#define SCARD_W_CHV_BLOCKED                                _HRESULT_TYPEDEF_(0x8010006C)
#define SCARD_W_EOF                                        _HRESULT_TYPEDEF_(0x8010006D)
#define SCARD_W_CANCELLED_BY_USER                          _HRESULT_TYPEDEF_(0x8010006E)
#define SCARD_W_CARD_NOT_AUTHENTICATED                     _HRESULT_TYPEDEF_(0x8010006F)
#define SCARD_W_CACHE_ITEM_NOT_FOUND                       _HRESULT_TYPEDEF_(0x80100070)
#define SCARD_W_CACHE_ITEM_STALE                           _HRESULT_TYPEDEF_(0x80100071)
#define SCARD_W_CACHE_ITEM_TOO_BIG                         _HRESULT_TYPEDEF_(0x80100072)

#define COMADMIN_E_OBJECTERRORS                            _HRESULT_TYPEDEF_(0x80110401)
#define COMADMIN_E_OBJECTINVALID                           _HRESULT_TYPEDEF_(0x80110402)
#define COMADMIN_E_KEYMISSING                              _HRESULT_TYPEDEF_(0x80110403)
#define COMADMIN_E_ALREADYINSTALLED                        _HRESULT_TYPEDEF_(0x80110404)
#define COMADMIN_E_APP_FILE_WRITEFAIL                      _HRESULT_TYPEDEF_(0x80110407)
#define COMADMIN_E_APP_FILE_READFAIL                       _HRESULT_TYPEDEF_(0x80110408)
#define COMADMIN_E_APP_FILE_VERSION                        _HRESULT_TYPEDEF_(0x80110409)
#define COMADMIN_E_BADPATH                                 _HRESULT_TYPEDEF_(0x8011040A)
#define COMADMIN_E_APPLICATIONEXISTS                       _HRESULT_TYPEDEF_(0x8011040B)
#define COMADMIN_E_ROLEEXISTS                              _HRESULT_TYPEDEF_(0x8011040C)
#define COMADMIN_E_CANTCOPYFILE                            _HRESULT_TYPEDEF_(0x8011040D)
#define COMADMIN_E_NOUSER                                  _HRESULT_TYPEDEF_(0x8011040F)
#define COMADMIN_E_INVALIDUSERIDS                          _HRESULT_TYPEDEF_(0x80110410)
#define COMADMIN_E_NOREGISTRYCLSID                         _HRESULT_TYPEDEF_(0x80110411)
#define COMADMIN_E_BADREGISTRYPROGID                       _HRESULT_TYPEDEF_(0x80110412)
#define COMADMIN_E_AUTHENTICATIONLEVEL                     _HRESULT_TYPEDEF_(0x80110413)
#define COMADMIN_E_USERPASSWDNOTVALID                      _HRESULT_TYPEDEF_(0x80110414)
#define COMADMIN_E_CLSIDORIIDMISMATCH                      _HRESULT_TYPEDEF_(0x80110418)
#define COMADMIN_E_REMOTEINTERFACE                         _HRESULT_TYPEDEF_(0x80110419)
#define COMADMIN_E_DLLREGISTERSERVER                       _HRESULT_TYPEDEF_(0x8011041A)
#define COMADMIN_E_NOSERVERSHARE                           _HRESULT_TYPEDEF_(0x8011041B)
#define COMADMIN_E_DLLLOADFAILED                           _HRESULT_TYPEDEF_(0x8011041D)
#define COMADMIN_E_BADREGISTRYLIBID                        _HRESULT_TYPEDEF_(0x8011041E)
#define COMADMIN_E_APPDIRNOTFOUND                          _HRESULT_TYPEDEF_(0x8011041F)
#define COMADMIN_E_REGISTRARFAILED                         _HRESULT_TYPEDEF_(0x80110423)
#define COMADMIN_E_COMPFILE_DOESNOTEXIST                   _HRESULT_TYPEDEF_(0x80110424)
#define COMADMIN_E_COMPFILE_LOADDLLFAIL                    _HRESULT_TYPEDEF_(0x80110425)
#define COMADMIN_E_COMPFILE_GETCLASSOBJ                    _HRESULT_TYPEDEF_(0x80110426)
#define COMADMIN_E_COMPFILE_CLASSNOTAVAIL                  _HRESULT_TYPEDEF_(0x80110427)
#define COMADMIN_E_COMPFILE_BADTLB                         _HRESULT_TYPEDEF_(0x80110428)
#define COMADMIN_E_COMPFILE_NOTINSTALLABLE                 _HRESULT_TYPEDEF_(0x80110429)
#define COMADMIN_E_NOTCHANGEABLE                           _HRESULT_TYPEDEF_(0x8011042A)
#define COMADMIN_E_NOTDELETEABLE                           _HRESULT_TYPEDEF_(0x8011042B)
#define COMADMIN_E_SESSION                                 _HRESULT_TYPEDEF_(0x8011042C)
#define COMADMIN_E_COMP_MOVE_LOCKED                        _HRESULT_TYPEDEF_(0x8011042D)
#define COMADMIN_E_COMP_MOVE_BAD_DEST                      _HRESULT_TYPEDEF_(0x8011042E)
#define COMADMIN_E_REGISTERTLB                             _HRESULT_TYPEDEF_(0x80110430)
#define COMADMIN_E_SYSTEMAPP                               _HRESULT_TYPEDEF_(0x80110433)
#define COMADMIN_E_COMPFILE_NOREGISTRAR                    _HRESULT_TYPEDEF_(0x80110434)
#define COMADMIN_E_COREQCOMPINSTALLED                      _HRESULT_TYPEDEF_(0x80110435)
#define COMADMIN_E_SERVICENOTINSTALLED                     _HRESULT_TYPEDEF_(0x80110436)
#define COMADMIN_E_PROPERTYSAVEFAILED                      _HRESULT_TYPEDEF_(0x80110437)
#define COMADMIN_E_OBJECTEXISTS                            _HRESULT_TYPEDEF_(0x80110438)
#define COMADMIN_E_COMPONENTEXISTS                         _HRESULT_TYPEDEF_(0x80110439)
#define COMADMIN_E_REGFILE_CORRUPT                         _HRESULT_TYPEDEF_(0x8011043B)
#define COMADMIN_E_PROPERTY_OVERFLOW                       _HRESULT_TYPEDEF_(0x8011043C)
#define COMADMIN_E_NOTINREGISTRY                           _HRESULT_TYPEDEF_(0x8011043E)
#define COMADMIN_E_OBJECTNOTPOOLABLE                       _HRESULT_TYPEDEF_(0x8011043F)
#define COMADMIN_E_APPLID_MATCHES_CLSID                    _HRESULT_TYPEDEF_(0x80110446)
#define COMADMIN_E_ROLE_DOES_NOT_EXIST                     _HRESULT_TYPEDEF_(0x80110447)
#define COMADMIN_E_START_APP_NEEDS_COMPONENTS              _HRESULT_TYPEDEF_(0x80110448)
#define COMADMIN_E_REQUIRES_DIFFERENT_PLATFORM             _HRESULT_TYPEDEF_(0x80110449)
#define COMADMIN_E_CAN_NOT_EXPORT_APP_PROXY                _HRESULT_TYPEDEF_(0x8011044A)
#define COMADMIN_E_CAN_NOT_START_APP                       _HRESULT_TYPEDEF_(0x8011044B)
#define COMADMIN_E_CAN_NOT_EXPORT_SYS_APP                  _HRESULT_TYPEDEF_(0x8011044C)
#define COMADMIN_E_CANT_SUBSCRIBE_TO_COMPONENT             _HRESULT_TYPEDEF_(0x8011044D)
#define COMADMIN_E_EVENTCLASS_CANT_BE_SUBSCRIBER           _HRESULT_TYPEDEF_(0x8011044E)
#define COMADMIN_E_LIB_APP_PROXY_INCOMPATIBLE              _HRESULT_TYPEDEF_(0x8011044F)
#define COMADMIN_E_BASE_PARTITION_ONLY                     _HRESULT_TYPEDEF_(0x80110450)
#define COMADMIN_E_START_APP_DISABLED                      _HRESULT_TYPEDEF_(0x80110451)
#define COMADMIN_E_CAT_DUPLICATE_PARTITION_NAME            _HRESULT_TYPEDEF_(0x80110457)
#define COMADMIN_E_CAT_INVALID_PARTITION_NAME              _HRESULT_TYPEDEF_(0x80110458)
#define COMADMIN_E_CAT_PARTITION_IN_USE                    _HRESULT_TYPEDEF_(0x80110459)
#define COMADMIN_E_FILE_PARTITION_DUPLICATE_FILES          _HRESULT_TYPEDEF_(0x8011045A)
#define COMADMIN_E_CAT_IMPORTED_COMPONENTS_NOT_ALLOWED     _HRESULT_TYPEDEF_(0x8011045B)
#define COMADMIN_E_AMBIGUOUS_APPLICATION_NAME              _HRESULT_TYPEDEF_(0x8011045C)
#define COMADMIN_E_AMBIGUOUS_PARTITION_NAME                _HRESULT_TYPEDEF_(0x8011045D)
#define COMADMIN_E_REGDB_NOTINITIALIZED                    _HRESULT_TYPEDEF_(0x80110472)
#define COMADMIN_E_REGDB_NOTOPEN                           _HRESULT_TYPEDEF_(0x80110473)
#define COMADMIN_E_REGDB_SYSTEMERR                         _HRESULT_TYPEDEF_(0x80110474)
#define COMADMIN_E_REGDB_ALREADYRUNNING                    _HRESULT_TYPEDEF_(0x80110475)
#define COMADMIN_E_MIG_VERSIONNOTSUPPORTED                 _HRESULT_TYPEDEF_(0x80110480)
#define COMADMIN_E_MIG_SCHEMANOTFOUND                      _HRESULT_TYPEDEF_(0x80110481)
#define COMADMIN_E_CAT_BITNESSMISMATCH                     _HRESULT_TYPEDEF_(0x80110482)
#define COMADMIN_E_CAT_UNACCEPTABLEBITNESS                 _HRESULT_TYPEDEF_(0x80110483)
#define COMADMIN_E_CAT_WRONGAPPBITNESS                     _HRESULT_TYPEDEF_(0x80110484)
#define COMADMIN_E_CAT_PAUSE_RESUME_NOT_SUPPORTED          _HRESULT_TYPEDEF_(0x80110485)
#define COMADMIN_E_CAT_SERVERFAULT                         _HRESULT_TYPEDEF_(0x80110486)
#define COMQC_E_APPLICATION_NOT_QUEUED                     _HRESULT_TYPEDEF_(0x80110600)
#define COMQC_E_NO_QUEUEABLE_INTERFACES                    _HRESULT_TYPEDEF_(0x80110601)
#define COMQC_E_QUEUING_SERVICE_NOT_AVAILABLE              _HRESULT_TYPEDEF_(0x80110602)
#define COMQC_E_NO_IPERSISTSTREAM                          _HRESULT_TYPEDEF_(0x80110603)
#define COMQC_E_BAD_MESSAGE                                _HRESULT_TYPEDEF_(0x80110604)
#define COMQC_E_UNAUTHENTICATED                            _HRESULT_TYPEDEF_(0x80110605)
#define COMQC_E_UNTRUSTED_ENQUEUER                         _HRESULT_TYPEDEF_(0x80110606)
#define MSDTC_E_DUPLICATE_RESOURCE                         _HRESULT_TYPEDEF_(0x80110701)
#define COMADMIN_E_OBJECT_PARENT_MISSING                   _HRESULT_TYPEDEF_(0x80110808)
#define COMADMIN_E_OBJECT_DOES_NOT_EXIST                   _HRESULT_TYPEDEF_(0x80110809)
#define COMADMIN_E_APP_NOT_RUNNING                         _HRESULT_TYPEDEF_(0x8011080A)
#define COMADMIN_E_INVALID_PARTITION                       _HRESULT_TYPEDEF_(0x8011080B)
#define COMADMIN_E_SVCAPP_NOT_POOLABLE_OR_RECYCLABLE       _HRESULT_TYPEDEF_(0x8011080D)
#define COMADMIN_E_USER_IN_SET                             _HRESULT_TYPEDEF_(0x8011080E)
#define COMADMIN_E_CANTRECYCLELIBRARYAPPS                  _HRESULT_TYPEDEF_(0x8011080F)
#define COMADMIN_E_CANTRECYCLESERVICEAPPS                  _HRESULT_TYPEDEF_(0x80110811)
#define COMADMIN_E_PROCESSALREADYRECYCLED                  _HRESULT_TYPEDEF_(0x80110812)
#define COMADMIN_E_PAUSEDPROCESSMAYNOTBERECYCLED           _HRESULT_TYPEDEF_(0x80110813)
#define COMADMIN_E_CANTMAKEINPROCSERVICE                   _HRESULT_TYPEDEF_(0x80110814)
#define COMADMIN_E_PROGIDINUSEBYCLSID                      _HRESULT_TYPEDEF_(0x80110815)
#define COMADMIN_E_DEFAULT_PARTITION_NOT_IN_SET            _HRESULT_TYPEDEF_(0x80110816)
#define COMADMIN_E_RECYCLEDPROCESSMAYNOTBEPAUSED           _HRESULT_TYPEDEF_(0x80110817)
#define COMADMIN_E_PARTITION_ACCESSDENIED                  _HRESULT_TYPEDEF_(0x80110818)
#define COMADMIN_E_PARTITION_MSI_ONLY                      _HRESULT_TYPEDEF_(0x80110819)
#define COMADMIN_E_LEGACYCOMPS_NOT_ALLOWED_IN_1_0_FORMAT   _HRESULT_TYPEDEF_(0x8011081A)
#define COMADMIN_E_LEGACYCOMPS_NOT_ALLOWED_IN_NONBASE_PARTITIONS _HRESULT_TYPEDEF_(0x8011081B)
#define COMADMIN_E_COMP_MOVE_SOURCE                        _HRESULT_TYPEDEF_(0x8011081C)
#define COMADMIN_E_COMP_MOVE_DEST                          _HRESULT_TYPEDEF_(0x8011081D)
#define COMADMIN_E_COMP_MOVE_PRIVATE                       _HRESULT_TYPEDEF_(0x8011081E)
#define COMADMIN_E_BASEPARTITION_REQUIRED_IN_SET           _HRESULT_TYPEDEF_(0x8011081F)
#define COMADMIN_E_CANNOT_ALIAS_EVENTCLASS                 _HRESULT_TYPEDEF_(0x80110820)
#define COMADMIN_E_PRIVATE_ACCESSDENIED                    _HRESULT_TYPEDEF_(0x80110821)
#define COMADMIN_E_SAFERINVALID                            _HRESULT_TYPEDEF_(0x80110822)
#define COMADMIN_E_REGISTRY_ACCESSDENIED                   _HRESULT_TYPEDEF_(0x80110823)
#define COMADMIN_E_PARTITIONS_DISABLED                     _HRESULT_TYPEDEF_(0x80110824)

#define MENROLL_E_DEVICE_MESSAGE_FORMAT_ERROR              _HRESULT_TYPEDEF_(0x80180001)
#define MENROLL_E_DEVICE_AUTHENTICATION_ERROR              _HRESULT_TYPEDEF_(0x80180002)
#define MENROLL_E_DEVICE_AUTHORIZATION_ERROR               _HRESULT_TYPEDEF_(0x80180003)
#define MENROLL_E_DEVICE_CERTIFICATEREQUEST_ERROR          _HRESULT_TYPEDEF_(0x80180004)
#define MENROLL_E_DEVICE_CONFIGMGRSERVER_ERROR             _HRESULT_TYPEDEF_(0x80180005)
#define MENROLL_E_DEVICE_INTERNALSERVICE_ERROR             _HRESULT_TYPEDEF_(0x80180006)
#define MENROLL_E_DEVICE_INVALIDSECURITY_ERROR             _HRESULT_TYPEDEF_(0x80180007)
#define MENROLL_E_DEVICE_UNKNOWN_ERROR                     _HRESULT_TYPEDEF_(0x80180008)
#define MENROLL_E_ENROLLMENT_IN_PROGRESS                   _HRESULT_TYPEDEF_(0x80180009)
#define MENROLL_E_DEVICE_ALREADY_ENROLLED                  _HRESULT_TYPEDEF_(0x8018000A)
#define MENROLL_E_DISCOVERY_SEC_CERT_DATE_INVALID          _HRESULT_TYPEDEF_(0x8018000D)
#define MENROLL_E_PASSWORD_NEEDED                          _HRESULT_TYPEDEF_(0x8018000E)
#define MENROLL_E_WAB_ERROR                                _HRESULT_TYPEDEF_(0x8018000F)
#define MENROLL_E_CONNECTIVITY                             _HRESULT_TYPEDEF_(0x80180010)
#define MENROLL_S_ENROLLMENT_SUSPENDED                     _HRESULT_TYPEDEF_(0x00180011)
#define MENROLL_E_INVALIDSSLCERT                           _HRESULT_TYPEDEF_(0x80180012)
#define MENROLL_E_DEVICECAPREACHED                         _HRESULT_TYPEDEF_(0x80180013)
#define MENROLL_E_DEVICENOTSUPPORTED                       _HRESULT_TYPEDEF_(0x80180014)
#define MENROLL_E_NOT_SUPPORTED                            _HRESULT_TYPEDEF_(0x80180015)
#define MENROLL_E_NOTELIGIBLETORENEW                       _HRESULT_TYPEDEF_(0x80180016)
#define MENROLL_E_INMAINTENANCE                            _HRESULT_TYPEDEF_(0x80180017)
#define MENROLL_E_USER_LICENSE                             _HRESULT_TYPEDEF_(0x80180018)
#define MENROLL_E_ENROLLMENTDATAINVALID                    _HRESULT_TYPEDEF_(0x80180019)
#define MENROLL_E_INSECUREREDIRECT                         _HRESULT_TYPEDEF_(0x8018001A)
#define MENROLL_E_PLATFORM_WRONG_STATE                     _HRESULT_TYPEDEF_(0x8018001B)
#define MENROLL_E_PLATFORM_LICENSE_ERROR                   _HRESULT_TYPEDEF_(0x8018001C)
#define MENROLL_E_PLATFORM_UNKNOWN_ERROR                   _HRESULT_TYPEDEF_(0x8018001D)
#define MENROLL_E_PROV_CSP_CERTSTORE                       _HRESULT_TYPEDEF_(0x8018001E)
#define MENROLL_E_PROV_CSP_W7                              _HRESULT_TYPEDEF_(0x8018001F)
#define MENROLL_E_PROV_CSP_DMCLIENT                        _HRESULT_TYPEDEF_(0x80180020)
#define MENROLL_E_PROV_CSP_PFW                             _HRESULT_TYPEDEF_(0x80180021)
#define MENROLL_E_PROV_CSP_MISC                            _HRESULT_TYPEDEF_(0x80180022)
#define MENROLL_E_PROV_UNKNOWN                             _HRESULT_TYPEDEF_(0x80180023)
#define MENROLL_E_PROV_SSLCERTNOTFOUND                     _HRESULT_TYPEDEF_(0x80180024)
#define MENROLL_E_PROV_CSP_APPMGMT                         _HRESULT_TYPEDEF_(0x80180025)
#define MENROLL_E_DEVICE_MANAGEMENT_BLOCKED                _HRESULT_TYPEDEF_(0x80180026)
#define MENROLL_E_CERTPOLICY_PRIVATEKEYCREATION_FAILED     _HRESULT_TYPEDEF_(0x80180027)
#define MENROLL_E_CERTAUTH_FAILED_TO_FIND_CERT             _HRESULT_TYPEDEF_(0x80180028)
#define MENROLL_E_EMPTY_MESSAGE                            _HRESULT_TYPEDEF_(0x80180029)
#define MENROLL_E_USER_CANCELLED                           _HRESULT_TYPEDEF_(0x80180030)
#define MENROLL_E_MDM_NOT_CONFIGURED                       _HRESULT_TYPEDEF_(0x80180031)

#define HTTP_E_STATUS_UNEXPECTED                           _HRESULT_TYPEDEF_(0x80190001)
#define HTTP_E_STATUS_UNEXPECTED_REDIRECTION               _HRESULT_TYPEDEF_(0x80190003)
#define HTTP_E_STATUS_UNEXPECTED_CLIENT_ERROR              _HRESULT_TYPEDEF_(0x80190004)
#define HTTP_E_STATUS_UNEXPECTED_SERVER_ERROR              _HRESULT_TYPEDEF_(0x80190005)
#define HTTP_E_STATUS_AMBIGUOUS                            _HRESULT_TYPEDEF_(0x8019012C)
#define HTTP_E_STATUS_MOVED                                _HRESULT_TYPEDEF_(0x8019012D)
#define HTTP_E_STATUS_REDIRECT                             _HRESULT_TYPEDEF_(0x8019012E)
#define HTTP_E_STATUS_REDIRECT_METHOD                      _HRESULT_TYPEDEF_(0x8019012F)
#define HTTP_E_STATUS_NOT_MODIFIED                         _HRESULT_TYPEDEF_(0x80190130)
#define HTTP_E_STATUS_USE_PROXY                            _HRESULT_TYPEDEF_(0x80190131)
#define HTTP_E_STATUS_REDIRECT_KEEP_VERB                   _HRESULT_TYPEDEF_(0x80190133)
#define HTTP_E_STATUS_BAD_REQUEST                          _HRESULT_TYPEDEF_(0x80190190)
#define HTTP_E_STATUS_DENIED                               _HRESULT_TYPEDEF_(0x80190191)
#define HTTP_E_STATUS_PAYMENT_REQ                          _HRESULT_TYPEDEF_(0x80190192)
#define HTTP_E_STATUS_FORBIDDEN                            _HRESULT_TYPEDEF_(0x80190193)
#define HTTP_E_STATUS_NOT_FOUND                            _HRESULT_TYPEDEF_(0x80190194)
#define HTTP_E_STATUS_BAD_METHOD                           _HRESULT_TYPEDEF_(0x80190195)
#define HTTP_E_STATUS_NONE_ACCEPTABLE                      _HRESULT_TYPEDEF_(0x80190196)
#define HTTP_E_STATUS_PROXY_AUTH_REQ                       _HRESULT_TYPEDEF_(0x80190197)
#define HTTP_E_STATUS_REQUEST_TIMEOUT                      _HRESULT_TYPEDEF_(0x80190198)
#define HTTP_E_STATUS_CONFLICT                             _HRESULT_TYPEDEF_(0x80190199)
#define HTTP_E_STATUS_GONE                                 _HRESULT_TYPEDEF_(0x8019019A)
#define HTTP_E_STATUS_LENGTH_REQUIRED                      _HRESULT_TYPEDEF_(0x8019019B)
#define HTTP_E_STATUS_PRECOND_FAILED                       _HRESULT_TYPEDEF_(0x8019019C)
#define HTTP_E_STATUS_REQUEST_TOO_LARGE                    _HRESULT_TYPEDEF_(0x8019019D)
#define HTTP_E_STATUS_URI_TOO_LONG                         _HRESULT_TYPEDEF_(0x8019019E)
#define HTTP_E_STATUS_UNSUPPORTED_MEDIA                    _HRESULT_TYPEDEF_(0x8019019F)
#define HTTP_E_STATUS_RANGE_NOT_SATISFIABLE                _HRESULT_TYPEDEF_(0x801901A0)
#define HTTP_E_STATUS_EXPECTATION_FAILED                   _HRESULT_TYPEDEF_(0x801901A1)
#define HTTP_E_STATUS_SERVER_ERROR                         _HRESULT_TYPEDEF_(0x801901F4)
#define HTTP_E_STATUS_NOT_SUPPORTED                        _HRESULT_TYPEDEF_(0x801901F5)
#define HTTP_E_STATUS_BAD_GATEWAY                          _HRESULT_TYPEDEF_(0x801901F6)
#define HTTP_E_STATUS_SERVICE_UNAVAIL                      _HRESULT_TYPEDEF_(0x801901F7)
#define HTTP_E_STATUS_GATEWAY_TIMEOUT                      _HRESULT_TYPEDEF_(0x801901F8)
#define HTTP_E_STATUS_VERSION_NOT_SUP                      _HRESULT_TYPEDEF_(0x801901F9)

#define WER_S_REPORT_DEBUG                                 _HRESULT_TYPEDEF_(0x001B0000)
#define WER_S_REPORT_UPLOADED                              _HRESULT_TYPEDEF_(0x001B0001)
#define WER_S_REPORT_QUEUED                                _HRESULT_TYPEDEF_(0x001B0002)
#define WER_S_DISABLED                                     _HRESULT_TYPEDEF_(0x001B0003)
#define WER_S_SUSPENDED_UPLOAD                             _HRESULT_TYPEDEF_(0x001B0004)
#define WER_S_DISABLED_QUEUE                               _HRESULT_TYPEDEF_(0x001B0005)
#define WER_S_DISABLED_ARCHIVE                             _HRESULT_TYPEDEF_(0x001B0006)
#define WER_S_REPORT_ASYNC                                 _HRESULT_TYPEDEF_(0x001B0007)
#define WER_S_IGNORE_ASSERT_INSTANCE                       _HRESULT_TYPEDEF_(0x001B0008)
#define WER_S_IGNORE_ALL_ASSERTS                           _HRESULT_TYPEDEF_(0x001B0009)
#define WER_S_ASSERT_CONTINUE                              _HRESULT_TYPEDEF_(0x001B000A)
#define WER_S_THROTTLED                                    _HRESULT_TYPEDEF_(0x001B000B)
#define WER_S_REPORT_UPLOADED_CAB                          _HRESULT_TYPEDEF_(0x001B000C)
#define WER_E_CRASH_FAILURE                                _HRESULT_TYPEDEF_(0x801B8000)
#define WER_E_CANCELED                                     _HRESULT_TYPEDEF_(0x801B8001)
#define WER_E_NETWORK_FAILURE                              _HRESULT_TYPEDEF_(0x801B8002)
#define WER_E_NOT_INITIALIZED                              _HRESULT_TYPEDEF_(0x801B8003)
#define WER_E_ALREADY_REPORTING                            _HRESULT_TYPEDEF_(0x801B8004)
#define WER_E_DUMP_THROTTLED                               _HRESULT_TYPEDEF_(0x801B8005)
#define WER_E_INSUFFICIENT_CONSENT                         _HRESULT_TYPEDEF_(0x801B8006)
#define WER_E_TOO_HEAVY                                    _HRESULT_TYPEDEF_(0x801B8007)

#define ERROR_FLT_IO_COMPLETE                              _HRESULT_TYPEDEF_(0x001F0001)
#define ERROR_FLT_NO_HANDLER_DEFINED                       _HRESULT_TYPEDEF_(0x801F0001)
#define ERROR_FLT_CONTEXT_ALREADY_DEFINED                  _HRESULT_TYPEDEF_(0x801F0002)
#define ERROR_FLT_INVALID_ASYNCHRONOUS_REQUEST             _HRESULT_TYPEDEF_(0x801F0003)
#define ERROR_FLT_DISALLOW_FAST_IO                         _HRESULT_TYPEDEF_(0x801F0004)
#define ERROR_FLT_INVALID_NAME_REQUEST                     _HRESULT_TYPEDEF_(0x801F0005)
#define ERROR_FLT_NOT_SAFE_TO_POST_OPERATION               _HRESULT_TYPEDEF_(0x801F0006)
#define ERROR_FLT_NOT_INITIALIZED                          _HRESULT_TYPEDEF_(0x801F0007)
#define ERROR_FLT_FILTER_NOT_READY                         _HRESULT_TYPEDEF_(0x801F0008)
#define ERROR_FLT_POST_OPERATION_CLEANUP                   _HRESULT_TYPEDEF_(0x801F0009)
#define ERROR_FLT_INTERNAL_ERROR                           _HRESULT_TYPEDEF_(0x801F000A)
#define ERROR_FLT_DELETING_OBJECT                          _HRESULT_TYPEDEF_(0x801F000B)
#define ERROR_FLT_MUST_BE_NONPAGED_POOL                    _HRESULT_TYPEDEF_(0x801F000C)
#define ERROR_FLT_DUPLICATE_ENTRY                          _HRESULT_TYPEDEF_(0x801F000D)
#define ERROR_FLT_CBDQ_DISABLED                            _HRESULT_TYPEDEF_(0x801F000E)
#define ERROR_FLT_DO_NOT_ATTACH                            _HRESULT_TYPEDEF_(0x801F000F)
#define ERROR_FLT_DO_NOT_DETACH                            _HRESULT_TYPEDEF_(0x801F0010)
#define ERROR_FLT_INSTANCE_ALTITUDE_COLLISION              _HRESULT_TYPEDEF_(0x801F0011)
#define ERROR_FLT_INSTANCE_NAME_COLLISION                  _HRESULT_TYPEDEF_(0x801F0012)
#define ERROR_FLT_FILTER_NOT_FOUND                         _HRESULT_TYPEDEF_(0x801F0013)
#define ERROR_FLT_VOLUME_NOT_FOUND                         _HRESULT_TYPEDEF_(0x801F0014)
#define ERROR_FLT_INSTANCE_NOT_FOUND                       _HRESULT_TYPEDEF_(0x801F0015)
#define ERROR_FLT_CONTEXT_ALLOCATION_NOT_FOUND             _HRESULT_TYPEDEF_(0x801F0016)
#define ERROR_FLT_INVALID_CONTEXT_REGISTRATION             _HRESULT_TYPEDEF_(0x801F0017)
#define ERROR_FLT_NAME_CACHE_MISS                          _HRESULT_TYPEDEF_(0x801F0018)
#define ERROR_FLT_NO_DEVICE_OBJECT                         _HRESULT_TYPEDEF_(0x801F0019)
#define ERROR_FLT_VOLUME_ALREADY_MOUNTED                   _HRESULT_TYPEDEF_(0x801F001A)
#define ERROR_FLT_ALREADY_ENLISTED                         _HRESULT_TYPEDEF_(0x801F001B)
#define ERROR_FLT_CONTEXT_ALREADY_LINKED                   _HRESULT_TYPEDEF_(0x801F001C)
#define ERROR_FLT_NO_WAITER_FOR_REPLY                      _HRESULT_TYPEDEF_(0x801F0020)
#define ERROR_FLT_REGISTRATION_BUSY                        _HRESULT_TYPEDEF_(0x801F0023)
#define ERROR_FLT_WCOS_NOT_SUPPORTED                       _HRESULT_TYPEDEF_(0x801F0024)

#define ERROR_HUNG_DISPLAY_DRIVER_THREAD                   _HRESULT_TYPEDEF_(0x80260001)
#define ERROR_GRAPHICS_SESSION_TYPE_CHANGE_IN_PROGRESS     _HRESULT_TYPEDEF_(0xC02605E8)
#define ERROR_MONITOR_NO_DESCRIPTOR                        _HRESULT_TYPEDEF_(0x00261001)
#define ERROR_MONITOR_UNKNOWN_DESCRIPTOR_FORMAT            _HRESULT_TYPEDEF_(0x00261002)
#define ERROR_MONITOR_INVALID_DESCRIPTOR_CHECKSUM          _HRESULT_TYPEDEF_(0xC0261003)
#define ERROR_MONITOR_INVALID_STANDARD_TIMING_BLOCK        _HRESULT_TYPEDEF_(0xC0261004)
#define ERROR_MONITOR_WMI_DATABLOCK_REGISTRATION_FAILED    _HRESULT_TYPEDEF_(0xC0261005)
#define ERROR_MONITOR_INVALID_SERIAL_NUMBER_MONDSC_BLOCK   _HRESULT_TYPEDEF_(0xC0261006)
#define ERROR_MONITOR_INVALID_USER_FRIENDLY_MONDSC_BLOCK   _HRESULT_TYPEDEF_(0xC0261007)
#define ERROR_MONITOR_NO_MORE_DESCRIPTOR_DATA              _HRESULT_TYPEDEF_(0xC0261008)
#define ERROR_MONITOR_INVALID_DETAILED_TIMING_BLOCK        _HRESULT_TYPEDEF_(0xC0261009)
#define ERROR_MONITOR_INVALID_MANUFACTURE_DATE             _HRESULT_TYPEDEF_(0xC026100A)
#define ERROR_GRAPHICS_NOT_EXCLUSIVE_MODE_OWNER            _HRESULT_TYPEDEF_(0xC0262000)
#define ERROR_GRAPHICS_INSUFFICIENT_DMA_BUFFER             _HRESULT_TYPEDEF_(0xC0262001)
#define ERROR_GRAPHICS_INVALID_DISPLAY_ADAPTER             _HRESULT_TYPEDEF_(0xC0262002)
#define ERROR_GRAPHICS_ADAPTER_WAS_RESET                   _HRESULT_TYPEDEF_(0xC0262003)
#define ERROR_GRAPHICS_INVALID_DRIVER_MODEL                _HRESULT_TYPEDEF_(0xC0262004)
#define ERROR_GRAPHICS_PRESENT_MODE_CHANGED                _HRESULT_TYPEDEF_(0xC0262005)
#define ERROR_GRAPHICS_PRESENT_OCCLUDED                    _HRESULT_TYPEDEF_(0xC0262006)
#define ERROR_GRAPHICS_PRESENT_DENIED                      _HRESULT_TYPEDEF_(0xC0262007)
#define ERROR_GRAPHICS_CANNOTCOLORCONVERT                  _HRESULT_TYPEDEF_(0xC0262008)
#define ERROR_GRAPHICS_DRIVER_MISMATCH                     _HRESULT_TYPEDEF_(0xC0262009)
#define ERROR_GRAPHICS_PARTIAL_DATA_POPULATED              _HRESULT_TYPEDEF_(0x4026200A)
#define ERROR_GRAPHICS_PRESENT_REDIRECTION_DISABLED        _HRESULT_TYPEDEF_(0xC026200B)
#define ERROR_GRAPHICS_PRESENT_UNOCCLUDED                  _HRESULT_TYPEDEF_(0xC026200C)
#define ERROR_GRAPHICS_WINDOWDC_NOT_AVAILABLE              _HRESULT_TYPEDEF_(0xC026200D)
#define ERROR_GRAPHICS_WINDOWLESS_PRESENT_DISABLED         _HRESULT_TYPEDEF_(0xC026200E)
#define ERROR_GRAPHICS_PRESENT_INVALID_WINDOW              _HRESULT_TYPEDEF_(0xC026200F)
#define ERROR_GRAPHICS_PRESENT_BUFFER_NOT_BOUND            _HRESULT_TYPEDEF_(0xC0262010)
#define ERROR_GRAPHICS_VAIL_STATE_CHANGED                  _HRESULT_TYPEDEF_(0xC0262011)
#define ERROR_GRAPHICS_INDIRECT_DISPLAY_ABANDON_SWAPCHAIN  _HRESULT_TYPEDEF_(0xC0262012)
#define ERROR_GRAPHICS_INDIRECT_DISPLAY_DEVICE_STOPPED     _HRESULT_TYPEDEF_(0xC0262013)
#define ERROR_GRAPHICS_VAIL_FAILED_TO_SEND_CREATE_SUPERWETINK_MESSAGE _HRESULT_TYPEDEF_(0xC0262014)
#define ERROR_GRAPHICS_VAIL_FAILED_TO_SEND_DESTROY_SUPERWETINK_MESSAGE _HRESULT_TYPEDEF_(0xC0262015)
#define ERROR_GRAPHICS_VAIL_FAILED_TO_SEND_COMPOSITION_WINDOW_DPI_MESSAGE _HRESULT_TYPEDEF_(0xC0262016)
#define ERROR_GRAPHICS_LINK_CONFIGURATION_IN_PROGRESS      _HRESULT_TYPEDEF_(0xC0262017)
#define ERROR_GRAPHICS_MPO_ALLOCATION_UNPINNED             _HRESULT_TYPEDEF_(0xC0262018)
#define ERROR_GRAPHICS_NO_VIDEO_MEMORY                     _HRESULT_TYPEDEF_(0xC0262100)
#define ERROR_GRAPHICS_CANT_LOCK_MEMORY                    _HRESULT_TYPEDEF_(0xC0262101)
#define ERROR_GRAPHICS_ALLOCATION_BUSY                     _HRESULT_TYPEDEF_(0xC0262102)
#define ERROR_GRAPHICS_TOO_MANY_REFERENCES                 _HRESULT_TYPEDEF_(0xC0262103)
#define ERROR_GRAPHICS_TRY_AGAIN_LATER                     _HRESULT_TYPEDEF_(0xC0262104)
#define ERROR_GRAPHICS_TRY_AGAIN_NOW                       _HRESULT_TYPEDEF_(0xC0262105)
#define ERROR_GRAPHICS_ALLOCATION_INVALID                  _HRESULT_TYPEDEF_(0xC0262106)
#define ERROR_GRAPHICS_UNSWIZZLING_APERTURE_UNAVAILABLE    _HRESULT_TYPEDEF_(0xC0262107)
#define ERROR_GRAPHICS_UNSWIZZLING_APERTURE_UNSUPPORTED    _HRESULT_TYPEDEF_(0xC0262108)
#define ERROR_GRAPHICS_CANT_EVICT_PINNED_ALLOCATION        _HRESULT_TYPEDEF_(0xC0262109)
#define ERROR_GRAPHICS_INVALID_ALLOCATION_USAGE            _HRESULT_TYPEDEF_(0xC0262110)
#define ERROR_GRAPHICS_CANT_RENDER_LOCKED_ALLOCATION       _HRESULT_TYPEDEF_(0xC0262111)
#define ERROR_GRAPHICS_ALLOCATION_CLOSED                   _HRESULT_TYPEDEF_(0xC0262112)
#define ERROR_GRAPHICS_INVALID_ALLOCATION_INSTANCE         _HRESULT_TYPEDEF_(0xC0262113)
#define ERROR_GRAPHICS_INVALID_ALLOCATION_HANDLE           _HRESULT_TYPEDEF_(0xC0262114)
#define ERROR_GRAPHICS_WRONG_ALLOCATION_DEVICE             _HRESULT_TYPEDEF_(0xC0262115)
#define ERROR_GRAPHICS_ALLOCATION_CONTENT_LOST             _HRESULT_TYPEDEF_(0xC0262116)
#define ERROR_GRAPHICS_GPU_EXCEPTION_ON_DEVICE             _HRESULT_TYPEDEF_(0xC0262200)
#define ERROR_GRAPHICS_SKIP_ALLOCATION_PREPARATION         _HRESULT_TYPEDEF_(0x40262201)
#define ERROR_GRAPHICS_INVALID_VIDPN_TOPOLOGY              _HRESULT_TYPEDEF_(0xC0262300)
#define ERROR_GRAPHICS_VIDPN_TOPOLOGY_NOT_SUPPORTED        _HRESULT_TYPEDEF_(0xC0262301)
#define ERROR_GRAPHICS_VIDPN_TOPOLOGY_CURRENTLY_NOT_SUPPORTED _HRESULT_TYPEDEF_(0xC0262302)
#define ERROR_GRAPHICS_INVALID_VIDPN                       _HRESULT_TYPEDEF_(0xC0262303)
#define ERROR_GRAPHICS_INVALID_VIDEO_PRESENT_SOURCE        _HRESULT_TYPEDEF_(0xC0262304)
#define ERROR_GRAPHICS_INVALID_VIDEO_PRESENT_TARGET        _HRESULT_TYPEDEF_(0xC0262305)
#define ERROR_GRAPHICS_VIDPN_MODALITY_NOT_SUPPORTED        _HRESULT_TYPEDEF_(0xC0262306)
#define ERROR_GRAPHICS_MODE_NOT_PINNED                     _HRESULT_TYPEDEF_(0x00262307)
#define ERROR_GRAPHICS_INVALID_VIDPN_SOURCEMODESET         _HRESULT_TYPEDEF_(0xC0262308)
#define ERROR_GRAPHICS_INVALID_VIDPN_TARGETMODESET         _HRESULT_TYPEDEF_(0xC0262309)
#define ERROR_GRAPHICS_INVALID_FREQUENCY                   _HRESULT_TYPEDEF_(0xC026230A)
#define ERROR_GRAPHICS_INVALID_ACTIVE_REGION               _HRESULT_TYPEDEF_(0xC026230B)
#define ERROR_GRAPHICS_INVALID_TOTAL_REGION                _HRESULT_TYPEDEF_(0xC026230C)
#define ERROR_GRAPHICS_INVALID_VIDEO_PRESENT_SOURCE_MODE   _HRESULT_TYPEDEF_(0xC0262310)
#define ERROR_GRAPHICS_INVALID_VIDEO_PRESENT_TARGET_MODE   _HRESULT_TYPEDEF_(0xC0262311)
#define ERROR_GRAPHICS_PINNED_MODE_MUST_REMAIN_IN_SET      _HRESULT_TYPEDEF_(0xC0262312)
#define ERROR_GRAPHICS_PATH_ALREADY_IN_TOPOLOGY            _HRESULT_TYPEDEF_(0xC0262313)
#define ERROR_GRAPHICS_MODE_ALREADY_IN_MODESET             _HRESULT_TYPEDEF_(0xC0262314)
#define ERROR_GRAPHICS_INVALID_VIDEOPRESENTSOURCESET       _HRESULT_TYPEDEF_(0xC0262315)
#define ERROR_GRAPHICS_INVALID_VIDEOPRESENTTARGETSET       _HRESULT_TYPEDEF_(0xC0262316)
#define ERROR_GRAPHICS_SOURCE_ALREADY_IN_SET               _HRESULT_TYPEDEF_(0xC0262317)
#define ERROR_GRAPHICS_TARGET_ALREADY_IN_SET               _HRESULT_TYPEDEF_(0xC0262318)
#define ERROR_GRAPHICS_INVALID_VIDPN_PRESENT_PATH          _HRESULT_TYPEDEF_(0xC0262319)
#define ERROR_GRAPHICS_NO_RECOMMENDED_VIDPN_TOPOLOGY       _HRESULT_TYPEDEF_(0xC026231A)
#define ERROR_GRAPHICS_INVALID_MONITOR_FREQUENCYRANGESET   _HRESULT_TYPEDEF_(0xC026231B)
#define ERROR_GRAPHICS_INVALID_MONITOR_FREQUENCYRANGE      _HRESULT_TYPEDEF_(0xC026231C)
#define ERROR_GRAPHICS_FREQUENCYRANGE_NOT_IN_SET           _HRESULT_TYPEDEF_(0xC026231D)
#define ERROR_GRAPHICS_NO_PREFERRED_MODE                   _HRESULT_TYPEDEF_(0x0026231E)
#define ERROR_GRAPHICS_FREQUENCYRANGE_ALREADY_IN_SET       _HRESULT_TYPEDEF_(0xC026231F)
#define ERROR_GRAPHICS_STALE_MODESET                       _HRESULT_TYPEDEF_(0xC0262320)
#define ERROR_GRAPHICS_INVALID_MONITOR_SOURCEMODESET       _HRESULT_TYPEDEF_(0xC0262321)
#define ERROR_GRAPHICS_INVALID_MONITOR_SOURCE_MODE         _HRESULT_TYPEDEF_(0xC0262322)
#define ERROR_GRAPHICS_NO_RECOMMENDED_FUNCTIONAL_VIDPN     _HRESULT_TYPEDEF_(0xC0262323)
#define ERROR_GRAPHICS_MODE_ID_MUST_BE_UNIQUE              _HRESULT_TYPEDEF_(0xC0262324)
#define ERROR_GRAPHICS_EMPTY_ADAPTER_MONITOR_MODE_SUPPORT_INTERSECTION _HRESULT_TYPEDEF_(0xC0262325)
#define ERROR_GRAPHICS_VIDEO_PRESENT_TARGETS_LESS_THAN_SOURCES _HRESULT_TYPEDEF_(0xC0262326)
#define ERROR_GRAPHICS_PATH_NOT_IN_TOPOLOGY                _HRESULT_TYPEDEF_(0xC0262327)
#define ERROR_GRAPHICS_ADAPTER_MUST_HAVE_AT_LEAST_ONE_SOURCE _HRESULT_TYPEDEF_(0xC0262328)
#define ERROR_GRAPHICS_ADAPTER_MUST_HAVE_AT_LEAST_ONE_TARGET _HRESULT_TYPEDEF_(0xC0262329)
#define ERROR_GRAPHICS_INVALID_MONITORDESCRIPTORSET        _HRESULT_TYPEDEF_(0xC026232A)
#define ERROR_GRAPHICS_INVALID_MONITORDESCRIPTOR           _HRESULT_TYPEDEF_(0xC026232B)
#define ERROR_GRAPHICS_MONITORDESCRIPTOR_NOT_IN_SET        _HRESULT_TYPEDEF_(0xC026232C)
#define ERROR_GRAPHICS_MONITORDESCRIPTOR_ALREADY_IN_SET    _HRESULT_TYPEDEF_(0xC026232D)
#define ERROR_GRAPHICS_MONITORDESCRIPTOR_ID_MUST_BE_UNIQUE _HRESULT_TYPEDEF_(0xC026232E)
#define ERROR_GRAPHICS_INVALID_VIDPN_TARGET_SUBSET_TYPE    _HRESULT_TYPEDEF_(0xC026232F)
#define ERROR_GRAPHICS_RESOURCES_NOT_RELATED               _HRESULT_TYPEDEF_(0xC0262330)
#define ERROR_GRAPHICS_SOURCE_ID_MUST_BE_UNIQUE            _HRESULT_TYPEDEF_(0xC0262331)
#define ERROR_GRAPHICS_TARGET_ID_MUST_BE_UNIQUE            _HRESULT_TYPEDEF_(0xC0262332)
#define ERROR_GRAPHICS_NO_AVAILABLE_VIDPN_TARGET           _HRESULT_TYPEDEF_(0xC0262333)
#define ERROR_GRAPHICS_MONITOR_COULD_NOT_BE_ASSOCIATED_WITH_ADAPTER _HRESULT_TYPEDEF_(0xC0262334)
#define ERROR_GRAPHICS_NO_VIDPNMGR                         _HRESULT_TYPEDEF_(0xC0262335)
#define ERROR_GRAPHICS_NO_ACTIVE_VIDPN                     _HRESULT_TYPEDEF_(0xC0262336)
#define ERROR_GRAPHICS_STALE_VIDPN_TOPOLOGY                _HRESULT_TYPEDEF_(0xC0262337)
#define ERROR_GRAPHICS_MONITOR_NOT_CONNECTED               _HRESULT_TYPEDEF_(0xC0262338)
#define ERROR_GRAPHICS_SOURCE_NOT_IN_TOPOLOGY              _HRESULT_TYPEDEF_(0xC0262339)
#define ERROR_GRAPHICS_INVALID_PRIMARYSURFACE_SIZE         _HRESULT_TYPEDEF_(0xC026233A)
#define ERROR_GRAPHICS_INVALID_VISIBLEREGION_SIZE          _HRESULT_TYPEDEF_(0xC026233B)
#define ERROR_GRAPHICS_INVALID_STRIDE                      _HRESULT_TYPEDEF_(0xC026233C)
#define ERROR_GRAPHICS_INVALID_PIXELFORMAT                 _HRESULT_TYPEDEF_(0xC026233D)
#define ERROR_GRAPHICS_INVALID_COLORBASIS                  _HRESULT_TYPEDEF_(0xC026233E)
#define ERROR_GRAPHICS_INVALID_PIXELVALUEACCESSMODE        _HRESULT_TYPEDEF_(0xC026233F)
#define ERROR_GRAPHICS_TARGET_NOT_IN_TOPOLOGY              _HRESULT_TYPEDEF_(0xC0262340)
#define ERROR_GRAPHICS_NO_DISPLAY_MODE_MANAGEMENT_SUPPORT  _HRESULT_TYPEDEF_(0xC0262341)
#define ERROR_GRAPHICS_VIDPN_SOURCE_IN_USE                 _HRESULT_TYPEDEF_(0xC0262342)
#define ERROR_GRAPHICS_CANT_ACCESS_ACTIVE_VIDPN            _HRESULT_TYPEDEF_(0xC0262343)
#define ERROR_GRAPHICS_INVALID_PATH_IMPORTANCE_ORDINAL     _HRESULT_TYPEDEF_(0xC0262344)
#define ERROR_GRAPHICS_INVALID_PATH_CONTENT_GEOMETRY_TRANSFORMATION _HRESULT_TYPEDEF_(0xC0262345)
#define ERROR_GRAPHICS_PATH_CONTENT_GEOMETRY_TRANSFORMATION_NOT_SUPPORTED _HRESULT_TYPEDEF_(0xC0262346)
#define ERROR_GRAPHICS_INVALID_GAMMA_RAMP                  _HRESULT_TYPEDEF_(0xC0262347)
#define ERROR_GRAPHICS_GAMMA_RAMP_NOT_SUPPORTED            _HRESULT_TYPEDEF_(0xC0262348)
#define ERROR_GRAPHICS_MULTISAMPLING_NOT_SUPPORTED         _HRESULT_TYPEDEF_(0xC0262349)
#define ERROR_GRAPHICS_MODE_NOT_IN_MODESET                 _HRESULT_TYPEDEF_(0xC026234A)
#define ERROR_GRAPHICS_DATASET_IS_EMPTY                    _HRESULT_TYPEDEF_(0x0026234B)
#define ERROR_GRAPHICS_NO_MORE_ELEMENTS_IN_DATASET         _HRESULT_TYPEDEF_(0x0026234C)
#define ERROR_GRAPHICS_INVALID_VIDPN_TOPOLOGY_RECOMMENDATION_REASON _HRESULT_TYPEDEF_(0xC026234D)
#define ERROR_GRAPHICS_INVALID_PATH_CONTENT_TYPE           _HRESULT_TYPEDEF_(0xC026234E)
#define ERROR_GRAPHICS_INVALID_COPYPROTECTION_TYPE         _HRESULT_TYPEDEF_(0xC026234F)
#define ERROR_GRAPHICS_UNASSIGNED_MODESET_ALREADY_EXISTS   _HRESULT_TYPEDEF_(0xC0262350)
#define ERROR_GRAPHICS_PATH_CONTENT_GEOMETRY_TRANSFORMATION_NOT_PINNED _HRESULT_TYPEDEF_(0x00262351)
#define ERROR_GRAPHICS_INVALID_SCANLINE_ORDERING           _HRESULT_TYPEDEF_(0xC0262352)
#define ERROR_GRAPHICS_TOPOLOGY_CHANGES_NOT_ALLOWED        _HRESULT_TYPEDEF_(0xC0262353)
#define ERROR_GRAPHICS_NO_AVAILABLE_IMPORTANCE_ORDINALS    _HRESULT_TYPEDEF_(0xC0262354)
#define ERROR_GRAPHICS_INCOMPATIBLE_PRIVATE_FORMAT         _HRESULT_TYPEDEF_(0xC0262355)
#define ERROR_GRAPHICS_INVALID_MODE_PRUNING_ALGORITHM      _HRESULT_TYPEDEF_(0xC0262356)
#define ERROR_GRAPHICS_INVALID_MONITOR_CAPABILITY_ORIGIN   _HRESULT_TYPEDEF_(0xC0262357)
#define ERROR_GRAPHICS_INVALID_MONITOR_FREQUENCYRANGE_CONSTRAINT _HRESULT_TYPEDEF_(0xC0262358)
#define ERROR_GRAPHICS_MAX_NUM_PATHS_REACHED               _HRESULT_TYPEDEF_(0xC0262359)
#define ERROR_GRAPHICS_CANCEL_VIDPN_TOPOLOGY_AUGMENTATION  _HRESULT_TYPEDEF_(0xC026235A)
#define ERROR_GRAPHICS_INVALID_CLIENT_TYPE                 _HRESULT_TYPEDEF_(0xC026235B)
#define ERROR_GRAPHICS_CLIENTVIDPN_NOT_SET                 _HRESULT_TYPEDEF_(0xC026235C)
#define ERROR_GRAPHICS_SPECIFIED_CHILD_ALREADY_CONNECTED   _HRESULT_TYPEDEF_(0xC0262400)
#define ERROR_GRAPHICS_CHILD_DESCRIPTOR_NOT_SUPPORTED      _HRESULT_TYPEDEF_(0xC0262401)
#define ERROR_GRAPHICS_UNKNOWN_CHILD_STATUS                _HRESULT_TYPEDEF_(0x4026242F)
#define ERROR_GRAPHICS_NOT_A_LINKED_ADAPTER                _HRESULT_TYPEDEF_(0xC0262430)
#define ERROR_GRAPHICS_LEADLINK_NOT_ENUMERATED             _HRESULT_TYPEDEF_(0xC0262431)
#define ERROR_GRAPHICS_CHAINLINKS_NOT_ENUMERATED           _HRESULT_TYPEDEF_(0xC0262432)
#define ERROR_GRAPHICS_ADAPTER_CHAIN_NOT_READY             _HRESULT_TYPEDEF_(0xC0262433)
#define ERROR_GRAPHICS_CHAINLINKS_NOT_STARTED              _HRESULT_TYPEDEF_(0xC0262434)
#define ERROR_GRAPHICS_CHAINLINKS_NOT_POWERED_ON           _HRESULT_TYPEDEF_(0xC0262435)
#define ERROR_GRAPHICS_INCONSISTENT_DEVICE_LINK_STATE      _HRESULT_TYPEDEF_(0xC0262436)
#define ERROR_GRAPHICS_LEADLINK_START_DEFERRED             _HRESULT_TYPEDEF_(0x40262437)
#define ERROR_GRAPHICS_NOT_POST_DEVICE_DRIVER              _HRESULT_TYPEDEF_(0xC0262438)
#define ERROR_GRAPHICS_POLLING_TOO_FREQUENTLY              _HRESULT_TYPEDEF_(0x40262439)
#define ERROR_GRAPHICS_START_DEFERRED                      _HRESULT_TYPEDEF_(0x4026243A)
#define ERROR_GRAPHICS_ADAPTER_ACCESS_NOT_EXCLUDED         _HRESULT_TYPEDEF_(0xC026243B)
#define ERROR_GRAPHICS_DEPENDABLE_CHILD_STATUS             _HRESULT_TYPEDEF_(0x4026243C)
#define ERROR_GRAPHICS_OPM_NOT_SUPPORTED                   _HRESULT_TYPEDEF_(0xC0262500)
#define ERROR_GRAPHICS_COPP_NOT_SUPPORTED                  _HRESULT_TYPEDEF_(0xC0262501)
#define ERROR_GRAPHICS_UAB_NOT_SUPPORTED                   _HRESULT_TYPEDEF_(0xC0262502)
#define ERROR_GRAPHICS_OPM_INVALID_ENCRYPTED_PARAMETERS    _HRESULT_TYPEDEF_(0xC0262503)
#define ERROR_GRAPHICS_OPM_NO_VIDEO_OUTPUTS_EXIST          _HRESULT_TYPEDEF_(0xC0262505)
#define ERROR_GRAPHICS_OPM_INTERNAL_ERROR                  _HRESULT_TYPEDEF_(0xC026250B)
#define ERROR_GRAPHICS_OPM_INVALID_HANDLE                  _HRESULT_TYPEDEF_(0xC026250C)
#define ERROR_GRAPHICS_PVP_INVALID_CERTIFICATE_LENGTH      _HRESULT_TYPEDEF_(0xC026250E)
#define ERROR_GRAPHICS_OPM_SPANNING_MODE_ENABLED           _HRESULT_TYPEDEF_(0xC026250F)
#define ERROR_GRAPHICS_OPM_THEATER_MODE_ENABLED            _HRESULT_TYPEDEF_(0xC0262510)
#define ERROR_GRAPHICS_PVP_HFS_FAILED                      _HRESULT_TYPEDEF_(0xC0262511)
#define ERROR_GRAPHICS_OPM_INVALID_SRM                     _HRESULT_TYPEDEF_(0xC0262512)
#define ERROR_GRAPHICS_OPM_OUTPUT_DOES_NOT_SUPPORT_HDCP    _HRESULT_TYPEDEF_(0xC0262513)
#define ERROR_GRAPHICS_OPM_OUTPUT_DOES_NOT_SUPPORT_ACP     _HRESULT_TYPEDEF_(0xC0262514)
#define ERROR_GRAPHICS_OPM_OUTPUT_DOES_NOT_SUPPORT_CGMSA   _HRESULT_TYPEDEF_(0xC0262515)
#define ERROR_GRAPHICS_OPM_HDCP_SRM_NEVER_SET              _HRESULT_TYPEDEF_(0xC0262516)
#define ERROR_GRAPHICS_OPM_RESOLUTION_TOO_HIGH             _HRESULT_TYPEDEF_(0xC0262517)
#define ERROR_GRAPHICS_OPM_ALL_HDCP_HARDWARE_ALREADY_IN_USE _HRESULT_TYPEDEF_(0xC0262518)
#define ERROR_GRAPHICS_OPM_VIDEO_OUTPUT_NO_LONGER_EXISTS   _HRESULT_TYPEDEF_(0xC026251A)
#define ERROR_GRAPHICS_OPM_SESSION_TYPE_CHANGE_IN_PROGRESS _HRESULT_TYPEDEF_(0xC026251B)
#define ERROR_GRAPHICS_OPM_VIDEO_OUTPUT_DOES_NOT_HAVE_COPP_SEMANTICS _HRESULT_TYPEDEF_(0xC026251C)
#define ERROR_GRAPHICS_OPM_INVALID_INFORMATION_REQUEST     _HRESULT_TYPEDEF_(0xC026251D)
#define ERROR_GRAPHICS_OPM_DRIVER_INTERNAL_ERROR           _HRESULT_TYPEDEF_(0xC026251E)
#define ERROR_GRAPHICS_OPM_VIDEO_OUTPUT_DOES_NOT_HAVE_OPM_SEMANTICS _HRESULT_TYPEDEF_(0xC026251F)
#define ERROR_GRAPHICS_OPM_SIGNALING_NOT_SUPPORTED         _HRESULT_TYPEDEF_(0xC0262520)
#define ERROR_GRAPHICS_OPM_INVALID_CONFIGURATION_REQUEST   _HRESULT_TYPEDEF_(0xC0262521)
#define ERROR_GRAPHICS_I2C_NOT_SUPPORTED                   _HRESULT_TYPEDEF_(0xC0262580)
#define ERROR_GRAPHICS_I2C_DEVICE_DOES_NOT_EXIST           _HRESULT_TYPEDEF_(0xC0262581)
#define ERROR_GRAPHICS_I2C_ERROR_TRANSMITTING_DATA         _HRESULT_TYPEDEF_(0xC0262582)
#define ERROR_GRAPHICS_I2C_ERROR_RECEIVING_DATA            _HRESULT_TYPEDEF_(0xC0262583)
#define ERROR_GRAPHICS_DDCCI_VCP_NOT_SUPPORTED             _HRESULT_TYPEDEF_(0xC0262584)
#define ERROR_GRAPHICS_DDCCI_INVALID_DATA                  _HRESULT_TYPEDEF_(0xC0262585)
#define ERROR_GRAPHICS_DDCCI_MONITOR_RETURNED_INVALID_TIMING_STATUS_BYTE _HRESULT_TYPEDEF_(0xC0262586)
#define ERROR_GRAPHICS_MCA_INVALID_CAPABILITIES_STRING     _HRESULT_TYPEDEF_(0xC0262587)
#define ERROR_GRAPHICS_MCA_INTERNAL_ERROR                  _HRESULT_TYPEDEF_(0xC0262588)
#define ERROR_GRAPHICS_DDCCI_INVALID_MESSAGE_COMMAND       _HRESULT_TYPEDEF_(0xC0262589)
#define ERROR_GRAPHICS_DDCCI_INVALID_MESSAGE_LENGTH        _HRESULT_TYPEDEF_(0xC026258A)
#define ERROR_GRAPHICS_DDCCI_INVALID_MESSAGE_CHECKSUM      _HRESULT_TYPEDEF_(0xC026258B)
#define ERROR_GRAPHICS_INVALID_PHYSICAL_MONITOR_HANDLE     _HRESULT_TYPEDEF_(0xC026258C)
#define ERROR_GRAPHICS_MONITOR_NO_LONGER_EXISTS            _HRESULT_TYPEDEF_(0xC026258D)
#define ERROR_GRAPHICS_DDCCI_CURRENT_CURRENT_VALUE_GREATER_THAN_MAXIMUM_VALUE _HRESULT_TYPEDEF_(0xC02625D8)
#define ERROR_GRAPHICS_MCA_INVALID_VCP_VERSION             _HRESULT_TYPEDEF_(0xC02625D9)
#define ERROR_GRAPHICS_MCA_MONITOR_VIOLATES_MCCS_SPECIFICATION _HRESULT_TYPEDEF_(0xC02625DA)
#define ERROR_GRAPHICS_MCA_MCCS_VERSION_MISMATCH           _HRESULT_TYPEDEF_(0xC02625DB)
#define ERROR_GRAPHICS_MCA_UNSUPPORTED_MCCS_VERSION        _HRESULT_TYPEDEF_(0xC02625DC)
#define ERROR_GRAPHICS_MCA_INVALID_TECHNOLOGY_TYPE_RETURNED _HRESULT_TYPEDEF_(0xC02625DE)
#define ERROR_GRAPHICS_MCA_UNSUPPORTED_COLOR_TEMPERATURE   _HRESULT_TYPEDEF_(0xC02625DF)
#define ERROR_GRAPHICS_ONLY_CONSOLE_SESSION_SUPPORTED      _HRESULT_TYPEDEF_(0xC02625E0)
#define ERROR_GRAPHICS_NO_DISPLAY_DEVICE_CORRESPONDS_TO_NAME _HRESULT_TYPEDEF_(0xC02625E1)
#define ERROR_GRAPHICS_DISPLAY_DEVICE_NOT_ATTACHED_TO_DESKTOP _HRESULT_TYPEDEF_(0xC02625E2)
#define ERROR_GRAPHICS_MIRRORING_DEVICES_NOT_SUPPORTED     _HRESULT_TYPEDEF_(0xC02625E3)
#define ERROR_GRAPHICS_INVALID_POINTER                     _HRESULT_TYPEDEF_(0xC02625E4)
#define ERROR_GRAPHICS_NO_MONITORS_CORRESPOND_TO_DISPLAY_DEVICE _HRESULT_TYPEDEF_(0xC02625E5)
#define ERROR_GRAPHICS_PARAMETER_ARRAY_TOO_SMALL           _HRESULT_TYPEDEF_(0xC02625E6)
#define ERROR_GRAPHICS_INTERNAL_ERROR                      _HRESULT_TYPEDEF_(0xC02625E7)
#define DWM_E_COMPOSITIONDISABLED                          _HRESULT_TYPEDEF_(0x80263001)
#define DWM_E_REMOTING_NOT_SUPPORTED                       _HRESULT_TYPEDEF_(0x80263002)
#define DWM_E_NO_REDIRECTION_SURFACE_AVAILABLE             _HRESULT_TYPEDEF_(0x80263003)
#define DWM_E_NOT_QUEUING_PRESENTS                         _HRESULT_TYPEDEF_(0x80263004)
#define DWM_S_GDI_REDIRECTION_SURFACE                      _HRESULT_TYPEDEF_(0x00263005)
#define DWM_E_ADAPTER_NOT_FOUND                            _HRESULT_TYPEDEF_(0x80263005)
#define DWM_E_TEXTURE_TOO_LARGE                            _HRESULT_TYPEDEF_(0x80263007)
#define DWM_S_GDI_REDIRECTION_SURFACE_BLT_VIA_GDI          _HRESULT_TYPEDEF_(0x00263008)

#define NAP_E_INVALID_PACKET                               _HRESULT_TYPEDEF_(0x80270001)
#define NAP_E_MISSING_SOH                                  _HRESULT_TYPEDEF_(0x80270002)
#define NAP_E_CONFLICTING_ID                               _HRESULT_TYPEDEF_(0x80270003)
#define NAP_E_NO_CACHED_SOH                                _HRESULT_TYPEDEF_(0x80270004)
#define NAP_E_STILL_BOUND                                  _HRESULT_TYPEDEF_(0x80270005)
#define NAP_E_NOT_REGISTERED                               _HRESULT_TYPEDEF_(0x80270006)
#define NAP_E_NOT_INITIALIZED                              _HRESULT_TYPEDEF_(0x80270007)
#define NAP_E_MISMATCHED_ID                                _HRESULT_TYPEDEF_(0x80270008)
#define NAP_E_NOT_PENDING                                  _HRESULT_TYPEDEF_(0x80270009)
#define NAP_E_ID_NOT_FOUND                                 _HRESULT_TYPEDEF_(0x8027000A)
#define NAP_E_MAXSIZE_TOO_SMALL                            _HRESULT_TYPEDEF_(0x8027000B)
#define NAP_E_SERVICE_NOT_RUNNING                          _HRESULT_TYPEDEF_(0x8027000C)
#define NAP_S_CERT_ALREADY_PRESENT                         _HRESULT_TYPEDEF_(0x0027000D)
#define NAP_E_ENTITY_DISABLED                              _HRESULT_TYPEDEF_(0x8027000E)
#define NAP_E_NETSH_GROUPPOLICY_ERROR                      _HRESULT_TYPEDEF_(0x8027000F)
#define NAP_E_TOO_MANY_CALLS                               _HRESULT_TYPEDEF_(0x80270010)
#define NAP_E_SHV_CONFIG_EXISTED                           _HRESULT_TYPEDEF_(0x80270011)
#define NAP_E_SHV_CONFIG_NOT_FOUND                         _HRESULT_TYPEDEF_(0x80270012)
#define NAP_E_SHV_TIMEOUT                                  _HRESULT_TYPEDEF_(0x80270013)
#define FA_E_MAX_PERSISTED_ITEMS_REACHED                   _HRESULT_TYPEDEF_(0x80270220)
#define FA_E_HOMEGROUP_NOT_AVAILABLE                       _HRESULT_TYPEDEF_(0x80270222)
#define E_MONITOR_RESOLUTION_TOO_LOW                       _HRESULT_TYPEDEF_(0x80270250)
#define E_ELEVATED_ACTIVATION_NOT_SUPPORTED                _HRESULT_TYPEDEF_(0x80270251)
#define E_UAC_DISABLED                                     _HRESULT_TYPEDEF_(0x80270252)
#define E_FULL_ADMIN_NOT_SUPPORTED                         _HRESULT_TYPEDEF_(0x80270253)
#define E_APPLICATION_NOT_REGISTERED                       _HRESULT_TYPEDEF_(0x80270254)
#define E_MULTIPLE_EXTENSIONS_FOR_APPLICATION              _HRESULT_TYPEDEF_(0x80270255)
#define E_MULTIPLE_PACKAGES_FOR_FAMILY                     _HRESULT_TYPEDEF_(0x80270256)
#define E_APPLICATION_MANAGER_NOT_RUNNING                  _HRESULT_TYPEDEF_(0x80270257)
#define S_STORE_LAUNCHED_FOR_REMEDIATION                   _HRESULT_TYPEDEF_(0x00270258)
#define S_APPLICATION_ACTIVATION_ERROR_HANDLED_BY_DIALOG   _HRESULT_TYPEDEF_(0x00270259)
#define E_APPLICATION_ACTIVATION_TIMED_OUT                 _HRESULT_TYPEDEF_(0x8027025A)
#define E_APPLICATION_ACTIVATION_EXEC_FAILURE              _HRESULT_TYPEDEF_(0x8027025B)
#define E_APPLICATION_TEMPORARY_LICENSE_ERROR              _HRESULT_TYPEDEF_(0x8027025C)
#define E_APPLICATION_TRIAL_LICENSE_EXPIRED                _HRESULT_TYPEDEF_(0x8027025D)
#define E_SKYDRIVE_ROOT_TARGET_FILE_SYSTEM_NOT_SUPPORTED   _HRESULT_TYPEDEF_(0x80270260)
#define E_SKYDRIVE_ROOT_TARGET_OVERLAP                     _HRESULT_TYPEDEF_(0x80270261)
#define E_SKYDRIVE_ROOT_TARGET_CANNOT_INDEX                _HRESULT_TYPEDEF_(0x80270262)
#define E_SKYDRIVE_FILE_NOT_UPLOADED                       _HRESULT_TYPEDEF_(0x80270263)
#define E_SKYDRIVE_UPDATE_AVAILABILITY_FAIL                _HRESULT_TYPEDEF_(0x80270264)
#define E_SKYDRIVE_ROOT_TARGET_VOLUME_ROOT_NOT_SUPPORTED   _HRESULT_TYPEDEF_(0x80270265)

#define TPM_E_ERROR_MASK                                   _HRESULT_TYPEDEF_(0x80280000)
#define TPM_E_AUTHFAIL                                     _HRESULT_TYPEDEF_(0x80280001)
#define TPM_E_BADINDEX                                     _HRESULT_TYPEDEF_(0x80280002)
#define TPM_E_BAD_PARAMETER                                _HRESULT_TYPEDEF_(0x80280003)
#define TPM_E_AUDITFAILURE                                 _HRESULT_TYPEDEF_(0x80280004)
#define TPM_E_CLEAR_DISABLED                               _HRESULT_TYPEDEF_(0x80280005)
#define TPM_E_DEACTIVATED                                  _HRESULT_TYPEDEF_(0x80280006)
#define TPM_E_DISABLED                                     _HRESULT_TYPEDEF_(0x80280007)
#define TPM_E_DISABLED_CMD                                 _HRESULT_TYPEDEF_(0x80280008)
#define TPM_E_FAIL                                         _HRESULT_TYPEDEF_(0x80280009)
#define TPM_E_BAD_ORDINAL                                  _HRESULT_TYPEDEF_(0x8028000A)
#define TPM_E_INSTALL_DISABLED                             _HRESULT_TYPEDEF_(0x8028000B)
#define TPM_E_INVALID_KEYHANDLE                            _HRESULT_TYPEDEF_(0x8028000C)
#define TPM_E_KEYNOTFOUND                                  _HRESULT_TYPEDEF_(0x8028000D)
#define TPM_E_INAPPROPRIATE_ENC                            _HRESULT_TYPEDEF_(0x8028000E)
#define TPM_E_MIGRATEFAIL                                  _HRESULT_TYPEDEF_(0x8028000F)
#define TPM_E_INVALID_PCR_INFO                             _HRESULT_TYPEDEF_(0x80280010)
#define TPM_E_NOSPACE                                      _HRESULT_TYPEDEF_(0x80280011)
#define TPM_E_NOSRK                                        _HRESULT_TYPEDEF_(0x80280012)
#define TPM_E_NOTSEALED_BLOB                               _HRESULT_TYPEDEF_(0x80280013)
#define TPM_E_OWNER_SET                                    _HRESULT_TYPEDEF_(0x80280014)
#define TPM_E_RESOURCES                                    _HRESULT_TYPEDEF_(0x80280015)
#define TPM_E_SHORTRANDOM                                  _HRESULT_TYPEDEF_(0x80280016)
#define TPM_E_SIZE                                         _HRESULT_TYPEDEF_(0x80280017)
#define TPM_E_WRONGPCRVAL                                  _HRESULT_TYPEDEF_(0x80280018)
#define TPM_E_BAD_PARAM_SIZE                               _HRESULT_TYPEDEF_(0x80280019)
#define TPM_E_SHA_THREAD                                   _HRESULT_TYPEDEF_(0x8028001A)
#define TPM_E_SHA_ERROR                                    _HRESULT_TYPEDEF_(0x8028001B)
#define TPM_E_FAILEDSELFTEST                               _HRESULT_TYPEDEF_(0x8028001C)
#define TPM_E_AUTH2FAIL                                    _HRESULT_TYPEDEF_(0x8028001D)
#define TPM_E_BADTAG                                       _HRESULT_TYPEDEF_(0x8028001E)
#define TPM_E_IOERROR                                      _HRESULT_TYPEDEF_(0x8028001F)
#define TPM_E_ENCRYPT_ERROR                                _HRESULT_TYPEDEF_(0x80280020)
#define TPM_E_DECRYPT_ERROR                                _HRESULT_TYPEDEF_(0x80280021)
#define TPM_E_INVALID_AUTHHANDLE                           _HRESULT_TYPEDEF_(0x80280022)
#define TPM_E_NO_ENDORSEMENT                               _HRESULT_TYPEDEF_(0x80280023)
#define TPM_E_INVALID_KEYUSAGE                             _HRESULT_TYPEDEF_(0x80280024)
#define TPM_E_WRONG_ENTITYTYPE                             _HRESULT_TYPEDEF_(0x80280025)
#define TPM_E_INVALID_POSTINIT                             _HRESULT_TYPEDEF_(0x80280026)
#define TPM_E_INAPPROPRIATE_SIG                            _HRESULT_TYPEDEF_(0x80280027)
#define TPM_E_BAD_KEY_PROPERTY                             _HRESULT_TYPEDEF_(0x80280028)
#define TPM_E_BAD_MIGRATION                                _HRESULT_TYPEDEF_(0x80280029)
#define TPM_E_BAD_SCHEME                                   _HRESULT_TYPEDEF_(0x8028002A)
#define TPM_E_BAD_DATASIZE                                 _HRESULT_TYPEDEF_(0x8028002B)
#define TPM_E_BAD_MODE                                     _HRESULT_TYPEDEF_(0x8028002C)
#define TPM_E_BAD_PRESENCE                                 _HRESULT_TYPEDEF_(0x8028002D)
#define TPM_E_BAD_VERSION                                  _HRESULT_TYPEDEF_(0x8028002E)
#define TPM_E_NO_WRAP_TRANSPORT                            _HRESULT_TYPEDEF_(0x8028002F)
#define TPM_E_AUDITFAIL_UNSUCCESSFUL                       _HRESULT_TYPEDEF_(0x80280030)
#define TPM_E_AUDITFAIL_SUCCESSFUL                         _HRESULT_TYPEDEF_(0x80280031)
#define TPM_E_NOTRESETABLE                                 _HRESULT_TYPEDEF_(0x80280032)
#define TPM_E_NOTLOCAL                                     _HRESULT_TYPEDEF_(0x80280033)
#define TPM_E_BAD_TYPE                                     _HRESULT_TYPEDEF_(0x80280034)
#define TPM_E_INVALID_RESOURCE                             _HRESULT_TYPEDEF_(0x80280035)
#define TPM_E_NOTFIPS                                      _HRESULT_TYPEDEF_(0x80280036)
#define TPM_E_INVALID_FAMILY                               _HRESULT_TYPEDEF_(0x80280037)
#define TPM_E_NO_NV_PERMISSION                             _HRESULT_TYPEDEF_(0x80280038)
#define TPM_E_REQUIRES_SIGN                                _HRESULT_TYPEDEF_(0x80280039)
#define TPM_E_KEY_NOTSUPPORTED                             _HRESULT_TYPEDEF_(0x8028003A)
#define TPM_E_AUTH_CONFLICT                                _HRESULT_TYPEDEF_(0x8028003B)
#define TPM_E_AREA_LOCKED                                  _HRESULT_TYPEDEF_(0x8028003C)
#define TPM_E_BAD_LOCALITY                                 _HRESULT_TYPEDEF_(0x8028003D)
#define TPM_E_READ_ONLY                                    _HRESULT_TYPEDEF_(0x8028003E)
#define TPM_E_PER_NOWRITE                                  _HRESULT_TYPEDEF_(0x8028003F)
#define TPM_E_FAMILYCOUNT                                  _HRESULT_TYPEDEF_(0x80280040)
#define TPM_E_WRITE_LOCKED                                 _HRESULT_TYPEDEF_(0x80280041)
#define TPM_E_BAD_ATTRIBUTES                               _HRESULT_TYPEDEF_(0x80280042)
#define TPM_E_INVALID_STRUCTURE                            _HRESULT_TYPEDEF_(0x80280043)
#define TPM_E_KEY_OWNER_CONTROL                            _HRESULT_TYPEDEF_(0x80280044)
#define TPM_E_BAD_COUNTER                                  _HRESULT_TYPEDEF_(0x80280045)
#define TPM_E_NOT_FULLWRITE                                _HRESULT_TYPEDEF_(0x80280046)
#define TPM_E_CONTEXT_GAP                                  _HRESULT_TYPEDEF_(0x80280047)
#define TPM_E_MAXNVWRITES                                  _HRESULT_TYPEDEF_(0x80280048)
#define TPM_E_NOOPERATOR                                   _HRESULT_TYPEDEF_(0x80280049)
#define TPM_E_RESOURCEMISSING                              _HRESULT_TYPEDEF_(0x8028004A)
#define TPM_E_DELEGATE_LOCK                                _HRESULT_TYPEDEF_(0x8028004B)
#define TPM_E_DELEGATE_FAMILY                              _HRESULT_TYPEDEF_(0x8028004C)
#define TPM_E_DELEGATE_ADMIN                               _HRESULT_TYPEDEF_(0x8028004D)
#define TPM_E_TRANSPORT_NOTEXCLUSIVE                       _HRESULT_TYPEDEF_(0x8028004E)
#define TPM_E_OWNER_CONTROL                                _HRESULT_TYPEDEF_(0x8028004F)
#define TPM_E_DAA_RESOURCES                                _HRESULT_TYPEDEF_(0x80280050)
#define TPM_E_DAA_INPUT_DATA0                              _HRESULT_TYPEDEF_(0x80280051)
#define TPM_E_DAA_INPUT_DATA1                              _HRESULT_TYPEDEF_(0x80280052)
#define TPM_E_DAA_ISSUER_SETTINGS                          _HRESULT_TYPEDEF_(0x80280053)
#define TPM_E_DAA_TPM_SETTINGS                             _HRESULT_TYPEDEF_(0x80280054)
#define TPM_E_DAA_STAGE                                    _HRESULT_TYPEDEF_(0x80280055)
#define TPM_E_DAA_ISSUER_VALIDITY                          _HRESULT_TYPEDEF_(0x80280056)
#define TPM_E_DAA_WRONG_W                                  _HRESULT_TYPEDEF_(0x80280057)
#define TPM_E_BAD_HANDLE                                   _HRESULT_TYPEDEF_(0x80280058)
#define TPM_E_BAD_DELEGATE                                 _HRESULT_TYPEDEF_(0x80280059)
#define TPM_E_BADCONTEXT                                   _HRESULT_TYPEDEF_(0x8028005A)
#define TPM_E_TOOMANYCONTEXTS                              _HRESULT_TYPEDEF_(0x8028005B)
#define TPM_E_MA_TICKET_SIGNATURE                          _HRESULT_TYPEDEF_(0x8028005C)
#define TPM_E_MA_DESTINATION                               _HRESULT_TYPEDEF_(0x8028005D)
#define TPM_E_MA_SOURCE                                    _HRESULT_TYPEDEF_(0x8028005E)
#define TPM_E_MA_AUTHORITY                                 _HRESULT_TYPEDEF_(0x8028005F)
#define TPM_E_PERMANENTEK                                  _HRESULT_TYPEDEF_(0x80280061)
#define TPM_E_BAD_SIGNATURE                                _HRESULT_TYPEDEF_(0x80280062)
#define TPM_E_NOCONTEXTSPACE                               _HRESULT_TYPEDEF_(0x80280063)
#define TPM_20_E_ASYMMETRIC                                _HRESULT_TYPEDEF_(0x80280081)
#define TPM_20_E_ATTRIBUTES                                _HRESULT_TYPEDEF_(0x80280082)
#define TPM_20_E_HASH                                      _HRESULT_TYPEDEF_(0x80280083)
#define TPM_20_E_VALUE                                     _HRESULT_TYPEDEF_(0x80280084)
#define TPM_20_E_HIERARCHY                                 _HRESULT_TYPEDEF_(0x80280085)
#define TPM_20_E_KEY_SIZE                                  _HRESULT_TYPEDEF_(0x80280087)
#define TPM_20_E_MGF                                       _HRESULT_TYPEDEF_(0x80280088)
#define TPM_20_E_MODE                                      _HRESULT_TYPEDEF_(0x80280089)
#define TPM_20_E_TYPE                                      _HRESULT_TYPEDEF_(0x8028008A)
#define TPM_20_E_HANDLE                                    _HRESULT_TYPEDEF_(0x8028008B)
#define TPM_20_E_KDF                                       _HRESULT_TYPEDEF_(0x8028008C)
#define TPM_20_E_RANGE                                     _HRESULT_TYPEDEF_(0x8028008D)
#define TPM_20_E_AUTH_FAIL                                 _HRESULT_TYPEDEF_(0x8028008E)
#define TPM_20_E_NONCE                                     _HRESULT_TYPEDEF_(0x8028008F)
#define TPM_20_E_PP                                        _HRESULT_TYPEDEF_(0x80280090)
#define TPM_20_E_SCHEME                                    _HRESULT_TYPEDEF_(0x80280092)
#define TPM_20_E_SIZE                                      _HRESULT_TYPEDEF_(0x80280095)
#define TPM_20_E_SYMMETRIC                                 _HRESULT_TYPEDEF_(0x80280096)
#define TPM_20_E_TAG                                       _HRESULT_TYPEDEF_(0x80280097)
#define TPM_20_E_SELECTOR                                  _HRESULT_TYPEDEF_(0x80280098)
#define TPM_20_E_INSUFFICIENT                              _HRESULT_TYPEDEF_(0x8028009A)
#define TPM_20_E_SIGNATURE                                 _HRESULT_TYPEDEF_(0x8028009B)
#define TPM_20_E_KEY                                       _HRESULT_TYPEDEF_(0x8028009C)
#define TPM_20_E_POLICY_FAIL                               _HRESULT_TYPEDEF_(0x8028009D)
#define TPM_20_E_INTEGRITY                                 _HRESULT_TYPEDEF_(0x8028009F)
#define TPM_20_E_TICKET                                    _HRESULT_TYPEDEF_(0x802800A0)
#define TPM_20_E_RESERVED_BITS                             _HRESULT_TYPEDEF_(0x802800A1)
#define TPM_20_E_BAD_AUTH                                  _HRESULT_TYPEDEF_(0x802800A2)
#define TPM_20_E_EXPIRED                                   _HRESULT_TYPEDEF_(0x802800A3)
#define TPM_20_E_POLICY_CC                                 _HRESULT_TYPEDEF_(0x802800A4)
#define TPM_20_E_BINDING                                   _HRESULT_TYPEDEF_(0x802800A5)
#define TPM_20_E_CURVE                                     _HRESULT_TYPEDEF_(0x802800A6)
#define TPM_20_E_ECC_POINT                                 _HRESULT_TYPEDEF_(0x802800A7)
#define TPM_20_E_INITIALIZE                                _HRESULT_TYPEDEF_(0x80280100)
#define TPM_20_E_FAILURE                                   _HRESULT_TYPEDEF_(0x80280101)
#define TPM_20_E_SEQUENCE                                  _HRESULT_TYPEDEF_(0x80280103)
#define TPM_20_E_PRIVATE                                   _HRESULT_TYPEDEF_(0x8028010B)
#define TPM_20_E_HMAC                                      _HRESULT_TYPEDEF_(0x80280119)
#define TPM_20_E_DISABLED                                  _HRESULT_TYPEDEF_(0x80280120)
#define TPM_20_E_EXCLUSIVE                                 _HRESULT_TYPEDEF_(0x80280121)
#define TPM_20_E_ECC_CURVE                                 _HRESULT_TYPEDEF_(0x80280123)
#define TPM_20_E_AUTH_TYPE                                 _HRESULT_TYPEDEF_(0x80280124)
#define TPM_20_E_AUTH_MISSING                              _HRESULT_TYPEDEF_(0x80280125)
#define TPM_20_E_POLICY                                    _HRESULT_TYPEDEF_(0x80280126)
#define TPM_20_E_PCR                                       _HRESULT_TYPEDEF_(0x80280127)
#define TPM_20_E_PCR_CHANGED                               _HRESULT_TYPEDEF_(0x80280128)
#define TPM_20_E_UPGRADE                                   _HRESULT_TYPEDEF_(0x8028012D)
#define TPM_20_E_TOO_MANY_CONTEXTS                         _HRESULT_TYPEDEF_(0x8028012E)
#define TPM_20_E_AUTH_UNAVAILABLE                          _HRESULT_TYPEDEF_(0x8028012F)
#define TPM_20_E_REBOOT                                    _HRESULT_TYPEDEF_(0x80280130)
#define TPM_20_E_UNBALANCED                                _HRESULT_TYPEDEF_(0x80280131)
#define TPM_20_E_COMMAND_SIZE                              _HRESULT_TYPEDEF_(0x80280142)
#define TPM_20_E_COMMAND_CODE                              _HRESULT_TYPEDEF_(0x80280143)
#define TPM_20_E_AUTHSIZE                                  _HRESULT_TYPEDEF_(0x80280144)
#define TPM_20_E_AUTH_CONTEXT                              _HRESULT_TYPEDEF_(0x80280145)
#define TPM_20_E_NV_RANGE                                  _HRESULT_TYPEDEF_(0x80280146)
#define TPM_20_E_NV_SIZE                                   _HRESULT_TYPEDEF_(0x80280147)
#define TPM_20_E_NV_LOCKED                                 _HRESULT_TYPEDEF_(0x80280148)
#define TPM_20_E_NV_AUTHORIZATION                          _HRESULT_TYPEDEF_(0x80280149)
#define TPM_20_E_NV_UNINITIALIZED                          _HRESULT_TYPEDEF_(0x8028014A)
#define TPM_20_E_NV_SPACE                                  _HRESULT_TYPEDEF_(0x8028014B)
#define TPM_20_E_NV_DEFINED                                _HRESULT_TYPEDEF_(0x8028014C)
#define TPM_20_E_BAD_CONTEXT                               _HRESULT_TYPEDEF_(0x80280150)
#define TPM_20_E_CPHASH                                    _HRESULT_TYPEDEF_(0x80280151)
#define TPM_20_E_PARENT                                    _HRESULT_TYPEDEF_(0x80280152)
#define TPM_20_E_NEEDS_TEST                                _HRESULT_TYPEDEF_(0x80280153)
#define TPM_20_E_NO_RESULT                                 _HRESULT_TYPEDEF_(0x80280154)
#define TPM_20_E_SENSITIVE                                 _HRESULT_TYPEDEF_(0x80280155)
#define TPM_E_COMMAND_BLOCKED                              _HRESULT_TYPEDEF_(0x80280400)
#define TPM_E_INVALID_HANDLE                               _HRESULT_TYPEDEF_(0x80280401)
#define TPM_E_DUPLICATE_VHANDLE                            _HRESULT_TYPEDEF_(0x80280402)
#define TPM_E_EMBEDDED_COMMAND_BLOCKED                     _HRESULT_TYPEDEF_(0x80280403)
#define TPM_E_EMBEDDED_COMMAND_UNSUPPORTED                 _HRESULT_TYPEDEF_(0x80280404)
#define TPM_E_RETRY                                        _HRESULT_TYPEDEF_(0x80280800)
#define TPM_E_NEEDS_SELFTEST                               _HRESULT_TYPEDEF_(0x80280801)
#define TPM_E_DOING_SELFTEST                               _HRESULT_TYPEDEF_(0x80280802)
#define TPM_E_DEFEND_LOCK_RUNNING                          _HRESULT_TYPEDEF_(0x80280803)
#define TPM_20_E_CONTEXT_GAP                               _HRESULT_TYPEDEF_(0x80280901)
#define TPM_20_E_OBJECT_MEMORY                             _HRESULT_TYPEDEF_(0x80280902)
#define TPM_20_E_SESSION_MEMORY                            _HRESULT_TYPEDEF_(0x80280903)
#define TPM_20_E_MEMORY                                    _HRESULT_TYPEDEF_(0x80280904)
#define TPM_20_E_SESSION_HANDLES                           _HRESULT_TYPEDEF_(0x80280905)
#define TPM_20_E_OBJECT_HANDLES                            _HRESULT_TYPEDEF_(0x80280906)
#define TPM_20_E_LOCALITY                                  _HRESULT_TYPEDEF_(0x80280907)
#define TPM_20_E_YIELDED                                   _HRESULT_TYPEDEF_(0x80280908)
#define TPM_20_E_CANCELED                                  _HRESULT_TYPEDEF_(0x80280909)
#define TPM_20_E_TESTING                                   _HRESULT_TYPEDEF_(0x8028090A)
#define TPM_20_E_NV_RATE                                   _HRESULT_TYPEDEF_(0x80280920)
#define TPM_20_E_LOCKOUT                                   _HRESULT_TYPEDEF_(0x80280921)
#define TPM_20_E_RETRY                                     _HRESULT_TYPEDEF_(0x80280922)
#define TPM_20_E_NV_UNAVAILABLE                            _HRESULT_TYPEDEF_(0x80280923)

#define TBS_E_INTERNAL_ERROR                               _HRESULT_TYPEDEF_(0x80284001)
#define TBS_E_BAD_PARAMETER                                _HRESULT_TYPEDEF_(0x80284002)
#define TBS_E_INVALID_OUTPUT_POINTER                       _HRESULT_TYPEDEF_(0x80284003)
#define TBS_E_INVALID_CONTEXT                              _HRESULT_TYPEDEF_(0x80284004)
#define TBS_E_INSUFFICIENT_BUFFER                          _HRESULT_TYPEDEF_(0x80284005)
#define TBS_E_IOERROR                                      _HRESULT_TYPEDEF_(0x80284006)
#define TBS_E_INVALID_CONTEXT_PARAM                        _HRESULT_TYPEDEF_(0x80284007)
#define TBS_E_SERVICE_NOT_RUNNING                          _HRESULT_TYPEDEF_(0x80284008)
#define TBS_E_TOO_MANY_TBS_CONTEXTS                        _HRESULT_TYPEDEF_(0x80284009)
#define TBS_E_TOO_MANY_RESOURCES                           _HRESULT_TYPEDEF_(0x8028400A)
#define TBS_E_SERVICE_START_PENDING                        _HRESULT_TYPEDEF_(0x8028400B)
#define TBS_E_PPI_NOT_SUPPORTED                            _HRESULT_TYPEDEF_(0x8028400C)
#define TBS_E_COMMAND_CANCELED                             _HRESULT_TYPEDEF_(0x8028400D)
#define TBS_E_BUFFER_TOO_LARGE                             _HRESULT_TYPEDEF_(0x8028400E)
#define TBS_E_TPM_NOT_FOUND                                _HRESULT_TYPEDEF_(0x8028400F)
#define TBS_E_SERVICE_DISABLED                             _HRESULT_TYPEDEF_(0x80284010)
#define TBS_E_NO_EVENT_LOG                                 _HRESULT_TYPEDEF_(0x80284011)
#define TBS_E_ACCESS_DENIED                                _HRESULT_TYPEDEF_(0x80284012)
#define TBS_E_PROVISIONING_NOT_ALLOWED                     _HRESULT_TYPEDEF_(0x80284013)
#define TBS_E_PPI_FUNCTION_UNSUPPORTED                     _HRESULT_TYPEDEF_(0x80284014)
#define TBS_E_OWNERAUTH_NOT_FOUND                          _HRESULT_TYPEDEF_(0x80284015)
#define TBS_E_PROVISIONING_INCOMPLETE                      _HRESULT_TYPEDEF_(0x80284016)

#define TPMAPI_E_INVALID_STATE                             _HRESULT_TYPEDEF_(0x80290100)
#define TPMAPI_E_NOT_ENOUGH_DATA                           _HRESULT_TYPEDEF_(0x80290101)
#define TPMAPI_E_TOO_MUCH_DATA                             _HRESULT_TYPEDEF_(0x80290102)
#define TPMAPI_E_INVALID_OUTPUT_POINTER                    _HRESULT_TYPEDEF_(0x80290103)
#define TPMAPI_E_INVALID_PARAMETER                         _HRESULT_TYPEDEF_(0x80290104)
#define TPMAPI_E_OUT_OF_MEMORY                             _HRESULT_TYPEDEF_(0x80290105)
#define TPMAPI_E_BUFFER_TOO_SMALL                          _HRESULT_TYPEDEF_(0x80290106)
#define TPMAPI_E_INTERNAL_ERROR                            _HRESULT_TYPEDEF_(0x80290107)
#define TPMAPI_E_ACCESS_DENIED                             _HRESULT_TYPEDEF_(0x80290108)
#define TPMAPI_E_AUTHORIZATION_FAILED                      _HRESULT_TYPEDEF_(0x80290109)
#define TPMAPI_E_INVALID_CONTEXT_HANDLE                    _HRESULT_TYPEDEF_(0x8029010A)
#define TPMAPI_E_TBS_COMMUNICATION_ERROR                   _HRESULT_TYPEDEF_(0x8029010B)
#define TPMAPI_E_TPM_COMMAND_ERROR                         _HRESULT_TYPEDEF_(0x8029010C)
#define TPMAPI_E_MESSAGE_TOO_LARGE                         _HRESULT_TYPEDEF_(0x8029010D)
#define TPMAPI_E_INVALID_ENCODING                          _HRESULT_TYPEDEF_(0x8029010E)
#define TPMAPI_E_INVALID_KEY_SIZE                          _HRESULT_TYPEDEF_(0x8029010F)
#define TPMAPI_E_ENCRYPTION_FAILED                         _HRESULT_TYPEDEF_(0x80290110)
#define TPMAPI_E_INVALID_KEY_PARAMS                        _HRESULT_TYPEDEF_(0x80290111)
#define TPMAPI_E_INVALID_MIGRATION_AUTHORIZATION_BLOB      _HRESULT_TYPEDEF_(0x80290112)
#define TPMAPI_E_INVALID_PCR_INDEX                         _HRESULT_TYPEDEF_(0x80290113)
#define TPMAPI_E_INVALID_DELEGATE_BLOB                     _HRESULT_TYPEDEF_(0x80290114)
#define TPMAPI_E_INVALID_CONTEXT_PARAMS                    _HRESULT_TYPEDEF_(0x80290115)
#define TPMAPI_E_INVALID_KEY_BLOB                          _HRESULT_TYPEDEF_(0x80290116)
#define TPMAPI_E_INVALID_PCR_DATA                          _HRESULT_TYPEDEF_(0x80290117)
#define TPMAPI_E_INVALID_OWNER_AUTH                        _HRESULT_TYPEDEF_(0x80290118)
#define TPMAPI_E_FIPS_RNG_CHECK_FAILED                     _HRESULT_TYPEDEF_(0x80290119)
#define TPMAPI_E_EMPTY_TCG_LOG                             _HRESULT_TYPEDEF_(0x8029011A)
#define TPMAPI_E_INVALID_TCG_LOG_ENTRY                     _HRESULT_TYPEDEF_(0x8029011B)
#define TPMAPI_E_TCG_SEPARATOR_ABSENT                      _HRESULT_TYPEDEF_(0x8029011C)
#define TPMAPI_E_TCG_INVALID_DIGEST_ENTRY                  _HRESULT_TYPEDEF_(0x8029011D)
#define TPMAPI_E_POLICY_DENIES_OPERATION                   _HRESULT_TYPEDEF_(0x8029011E)
#define TPMAPI_E_NV_BITS_NOT_DEFINED                       _HRESULT_TYPEDEF_(0x8029011F)
#define TPMAPI_E_NV_BITS_NOT_READY                         _HRESULT_TYPEDEF_(0x80290120)
#define TPMAPI_E_SEALING_KEY_NOT_AVAILABLE                 _HRESULT_TYPEDEF_(0x80290121)
#define TPMAPI_E_NO_AUTHORIZATION_CHAIN_FOUND              _HRESULT_TYPEDEF_(0x80290122)
#define TPMAPI_E_SVN_COUNTER_NOT_AVAILABLE                 _HRESULT_TYPEDEF_(0x80290123)
#define TPMAPI_E_OWNER_AUTH_NOT_NULL                       _HRESULT_TYPEDEF_(0x80290124)
#define TPMAPI_E_ENDORSEMENT_AUTH_NOT_NULL                 _HRESULT_TYPEDEF_(0x80290125)
#define TPMAPI_E_AUTHORIZATION_REVOKED                     _HRESULT_TYPEDEF_(0x80290126)
#define TPMAPI_E_MALFORMED_AUTHORIZATION_KEY               _HRESULT_TYPEDEF_(0x80290127)
#define TPMAPI_E_AUTHORIZING_KEY_NOT_SUPPORTED             _HRESULT_TYPEDEF_(0x80290128)
#define TPMAPI_E_INVALID_AUTHORIZATION_SIGNATURE           _HRESULT_TYPEDEF_(0x80290129)
#define TPMAPI_E_MALFORMED_AUTHORIZATION_POLICY            _HRESULT_TYPEDEF_(0x8029012A)
#define TPMAPI_E_MALFORMED_AUTHORIZATION_OTHER             _HRESULT_TYPEDEF_(0x8029012B)
#define TPMAPI_E_SEALING_KEY_CHANGED                       _HRESULT_TYPEDEF_(0x8029012C)
#define TPMAPI_E_INVALID_TPM_VERSION                       _HRESULT_TYPEDEF_(0x8029012D)
#define TPMAPI_E_INVALID_POLICYAUTH_BLOB_TYPE              _HRESULT_TYPEDEF_(0x8029012E)
#define TBSIMP_E_BUFFER_TOO_SMALL                          _HRESULT_TYPEDEF_(0x80290200)
#define TBSIMP_E_CLEANUP_FAILED                            _HRESULT_TYPEDEF_(0x80290201)
#define TBSIMP_E_INVALID_CONTEXT_HANDLE                    _HRESULT_TYPEDEF_(0x80290202)
#define TBSIMP_E_INVALID_CONTEXT_PARAM                     _HRESULT_TYPEDEF_(0x80290203)
#define TBSIMP_E_TPM_ERROR                                 _HRESULT_TYPEDEF_(0x80290204)
#define TBSIMP_E_HASH_BAD_KEY                              _HRESULT_TYPEDEF_(0x80290205)
#define TBSIMP_E_DUPLICATE_VHANDLE                         _HRESULT_TYPEDEF_(0x80290206)
#define TBSIMP_E_INVALID_OUTPUT_POINTER                    _HRESULT_TYPEDEF_(0x80290207)
#define TBSIMP_E_INVALID_PARAMETER                         _HRESULT_TYPEDEF_(0x80290208)
#define TBSIMP_E_RPC_INIT_FAILED                           _HRESULT_TYPEDEF_(0x80290209)
#define TBSIMP_E_SCHEDULER_NOT_RUNNING                     _HRESULT_TYPEDEF_(0x8029020A)
#define TBSIMP_E_COMMAND_CANCELED                          _HRESULT_TYPEDEF_(0x8029020B)
#define TBSIMP_E_OUT_OF_MEMORY                             _HRESULT_TYPEDEF_(0x8029020C)
#define TBSIMP_E_LIST_NO_MORE_ITEMS                        _HRESULT_TYPEDEF_(0x8029020D)
#define TBSIMP_E_LIST_NOT_FOUND                            _HRESULT_TYPEDEF_(0x8029020E)
#define TBSIMP_E_NOT_ENOUGH_SPACE                          _HRESULT_TYPEDEF_(0x8029020F)
#define TBSIMP_E_NOT_ENOUGH_TPM_CONTEXTS                   _HRESULT_TYPEDEF_(0x80290210)
#define TBSIMP_E_COMMAND_FAILED                            _HRESULT_TYPEDEF_(0x80290211)
#define TBSIMP_E_UNKNOWN_ORDINAL                           _HRESULT_TYPEDEF_(0x80290212)
#define TBSIMP_E_RESOURCE_EXPIRED                          _HRESULT_TYPEDEF_(0x80290213)
#define TBSIMP_E_INVALID_RESOURCE                          _HRESULT_TYPEDEF_(0x80290214)
#define TBSIMP_E_NOTHING_TO_UNLOAD                         _HRESULT_TYPEDEF_(0x80290215)
#define TBSIMP_E_HASH_TABLE_FULL                           _HRESULT_TYPEDEF_(0x80290216)
#define TBSIMP_E_TOO_MANY_TBS_CONTEXTS                     _HRESULT_TYPEDEF_(0x80290217)
#define TBSIMP_E_TOO_MANY_RESOURCES                        _HRESULT_TYPEDEF_(0x80290218)
#define TBSIMP_E_PPI_NOT_SUPPORTED                         _HRESULT_TYPEDEF_(0x80290219)
#define TBSIMP_E_TPM_INCOMPATIBLE                          _HRESULT_TYPEDEF_(0x8029021A)
#define TBSIMP_E_NO_EVENT_LOG                              _HRESULT_TYPEDEF_(0x8029021B)
#define TPM_E_PPI_ACPI_FAILURE                             _HRESULT_TYPEDEF_(0x80290300)
#define TPM_E_PPI_USER_ABORT                               _HRESULT_TYPEDEF_(0x80290301)
#define TPM_E_PPI_BIOS_FAILURE                             _HRESULT_TYPEDEF_(0x80290302)
#define TPM_E_PPI_NOT_SUPPORTED                            _HRESULT_TYPEDEF_(0x80290303)
#define TPM_E_PPI_BLOCKED_IN_BIOS                          _HRESULT_TYPEDEF_(0x80290304)
#define TPM_E_PCP_ERROR_MASK                               _HRESULT_TYPEDEF_(0x80290400)
#define TPM_E_PCP_DEVICE_NOT_READY                         _HRESULT_TYPEDEF_(0x80290401)
#define TPM_E_PCP_INVALID_HANDLE                           _HRESULT_TYPEDEF_(0x80290402)
#define TPM_E_PCP_INVALID_PARAMETER                        _HRESULT_TYPEDEF_(0x80290403)
#define TPM_E_PCP_FLAG_NOT_SUPPORTED                       _HRESULT_TYPEDEF_(0x80290404)
#define TPM_E_PCP_NOT_SUPPORTED                            _HRESULT_TYPEDEF_(0x80290405)
#define TPM_E_PCP_BUFFER_TOO_SMALL                         _HRESULT_TYPEDEF_(0x80290406)
#define TPM_E_PCP_INTERNAL_ERROR                           _HRESULT_TYPEDEF_(0x80290407)
#define TPM_E_PCP_AUTHENTICATION_FAILED                    _HRESULT_TYPEDEF_(0x80290408)
#define TPM_E_PCP_AUTHENTICATION_IGNORED                   _HRESULT_TYPEDEF_(0x80290409)
#define TPM_E_PCP_POLICY_NOT_FOUND                         _HRESULT_TYPEDEF_(0x8029040A)
#define TPM_E_PCP_PROFILE_NOT_FOUND                        _HRESULT_TYPEDEF_(0x8029040B)
#define TPM_E_PCP_VALIDATION_FAILED                        _HRESULT_TYPEDEF_(0x8029040C)
#define TPM_E_PCP_WRONG_PARENT                             _HRESULT_TYPEDEF_(0x8029040E)
#define TPM_E_KEY_NOT_LOADED                               _HRESULT_TYPEDEF_(0x8029040F)
#define TPM_E_NO_KEY_CERTIFICATION                         _HRESULT_TYPEDEF_(0x80290410)
#define TPM_E_KEY_NOT_FINALIZED                            _HRESULT_TYPEDEF_(0x80290411)
#define TPM_E_ATTESTATION_CHALLENGE_NOT_SET                _HRESULT_TYPEDEF_(0x80290412)
#define TPM_E_NOT_PCR_BOUND                                _HRESULT_TYPEDEF_(0x80290413)
#define TPM_E_KEY_ALREADY_FINALIZED                        _HRESULT_TYPEDEF_(0x80290414)
#define TPM_E_KEY_USAGE_POLICY_NOT_SUPPORTED               _HRESULT_TYPEDEF_(0x80290415)
#define TPM_E_KEY_USAGE_POLICY_INVALID                     _HRESULT_TYPEDEF_(0x80290416)
#define TPM_E_SOFT_KEY_ERROR                               _HRESULT_TYPEDEF_(0x80290417)
#define TPM_E_KEY_NOT_AUTHENTICATED                        _HRESULT_TYPEDEF_(0x80290418)
#define TPM_E_PCP_KEY_NOT_AIK                              _HRESULT_TYPEDEF_(0x80290419)
#define TPM_E_KEY_NOT_SIGNING_KEY                          _HRESULT_TYPEDEF_(0x8029041A)
#define TPM_E_LOCKED_OUT                                   _HRESULT_TYPEDEF_(0x8029041B)
#define TPM_E_CLAIM_TYPE_NOT_SUPPORTED                     _HRESULT_TYPEDEF_(0x8029041C)
#define TPM_E_VERSION_NOT_SUPPORTED                        _HRESULT_TYPEDEF_(0x8029041D)
#define TPM_E_BUFFER_LENGTH_MISMATCH                       _HRESULT_TYPEDEF_(0x8029041E)
#define TPM_E_PCP_IFX_RSA_KEY_CREATION_BLOCKED             _HRESULT_TYPEDEF_(0x8029041F)
#define TPM_E_PCP_TICKET_MISSING                           _HRESULT_TYPEDEF_(0x80290420)
#define TPM_E_PCP_RAW_POLICY_NOT_SUPPORTED                 _HRESULT_TYPEDEF_(0x80290421)
#define TPM_E_PCP_KEY_HANDLE_INVALIDATED                   _HRESULT_TYPEDEF_(0x80290422)
#define TPM_E_PCP_UNSUPPORTED_PSS_SALT                     _HRESULT_TYPEDEF_(0x40290423)
#define TPM_E_PCP_PLATFORM_CLAIM_MAY_BE_OUTDATED           _HRESULT_TYPEDEF_(0x40290424)
#define TPM_E_PCP_PLATFORM_CLAIM_OUTDATED                  _HRESULT_TYPEDEF_(0x40290425)
#define TPM_E_PCP_PLATFORM_CLAIM_REBOOT                    _HRESULT_TYPEDEF_(0x40290426)
#define TPM_E_ZERO_EXHAUST_ENABLED                         _HRESULT_TYPEDEF_(0x80290500)
#define TPM_E_PROVISIONING_INCOMPLETE                      _HRESULT_TYPEDEF_(0x80290600)
#define TPM_E_INVALID_OWNER_AUTH                           _HRESULT_TYPEDEF_(0x80290601)
#define TPM_E_TOO_MUCH_DATA                                _HRESULT_TYPEDEF_(0x80290602)
#define TPM_E_TPM_GENERATED_EPS                            _HRESULT_TYPEDEF_(0x80290603)

#define UI_E_CREATE_FAILED                                 _HRESULT_TYPEDEF_(0x802A0001)
#define UI_E_SHUTDOWN_CALLED                               _HRESULT_TYPEDEF_(0x802A0002)
#define UI_E_ILLEGAL_REENTRANCY                            _HRESULT_TYPEDEF_(0x802A0003)
#define UI_E_OBJECT_SEALED                                 _HRESULT_TYPEDEF_(0x802A0004)
#define UI_E_VALUE_NOT_SET                                 _HRESULT_TYPEDEF_(0x802A0005)
#define UI_E_VALUE_NOT_DETERMINED                          _HRESULT_TYPEDEF_(0x802A0006)
#define UI_E_INVALID_OUTPUT                                _HRESULT_TYPEDEF_(0x802A0007)
#define UI_E_BOOLEAN_EXPECTED                              _HRESULT_TYPEDEF_(0x802A0008)
#define UI_E_DIFFERENT_OWNER                               _HRESULT_TYPEDEF_(0x802A0009)
#define UI_E_AMBIGUOUS_MATCH                               _HRESULT_TYPEDEF_(0x802A000A)
#define UI_E_FP_OVERFLOW                                   _HRESULT_TYPEDEF_(0x802A000B)
#define UI_E_WRONG_THREAD                                  _HRESULT_TYPEDEF_(0x802A000C)
#define UI_E_STORYBOARD_ACTIVE                             _HRESULT_TYPEDEF_(0x802A0101)
#define UI_E_STORYBOARD_NOT_PLAYING                        _HRESULT_TYPEDEF_(0x802A0102)
#define UI_E_START_KEYFRAME_AFTER_END                      _HRESULT_TYPEDEF_(0x802A0103)
#define UI_E_END_KEYFRAME_NOT_DETERMINED                   _HRESULT_TYPEDEF_(0x802A0104)
#define UI_E_LOOPS_OVERLAP                                 _HRESULT_TYPEDEF_(0x802A0105)
#define UI_E_TRANSITION_ALREADY_USED                       _HRESULT_TYPEDEF_(0x802A0106)
#define UI_E_TRANSITION_NOT_IN_STORYBOARD                  _HRESULT_TYPEDEF_(0x802A0107)
#define UI_E_TRANSITION_ECLIPSED                           _HRESULT_TYPEDEF_(0x802A0108)
#define UI_E_TIME_BEFORE_LAST_UPDATE                       _HRESULT_TYPEDEF_(0x802A0109)
#define UI_E_TIMER_CLIENT_ALREADY_CONNECTED                _HRESULT_TYPEDEF_(0x802A010A)
#define UI_E_INVALID_DIMENSION                             _HRESULT_TYPEDEF_(0x802A010B)
#define UI_E_PRIMITIVE_OUT_OF_BOUNDS                       _HRESULT_TYPEDEF_(0x802A010C)
#define UI_E_WINDOW_CLOSED                                 _HRESULT_TYPEDEF_(0x802A0201)

#define PLA_E_DCS_NOT_FOUND                                _HRESULT_TYPEDEF_(0x80300002)
#define PLA_E_TOO_MANY_FOLDERS                             _HRESULT_TYPEDEF_(0x80300045)
#define PLA_E_NO_MIN_DISK                                  _HRESULT_TYPEDEF_(0x80300070)
#define PLA_E_DCS_IN_USE                                   _HRESULT_TYPEDEF_(0x803000AA)
#define PLA_E_DCS_ALREADY_EXISTS                           _HRESULT_TYPEDEF_(0x803000B7)
#define PLA_S_PROPERTY_IGNORED                             _HRESULT_TYPEDEF_(0x00300100)
#define PLA_E_PROPERTY_CONFLICT                            _HRESULT_TYPEDEF_(0x80300101)
#define PLA_E_DCS_SINGLETON_REQUIRED                       _HRESULT_TYPEDEF_(0x80300102)
#define PLA_E_CREDENTIALS_REQUIRED                         _HRESULT_TYPEDEF_(0x80300103)
#define PLA_E_DCS_NOT_RUNNING                              _HRESULT_TYPEDEF_(0x80300104)
#define PLA_E_CONFLICT_INCL_EXCL_API                       _HRESULT_TYPEDEF_(0x80300105)
#define PLA_E_NETWORK_EXE_NOT_VALID                        _HRESULT_TYPEDEF_(0x80300106)
#define PLA_E_EXE_ALREADY_CONFIGURED                       _HRESULT_TYPEDEF_(0x80300107)
#define PLA_E_EXE_PATH_NOT_VALID                           _HRESULT_TYPEDEF_(0x80300108)
#define PLA_E_DC_ALREADY_EXISTS                            _HRESULT_TYPEDEF_(0x80300109)
#define PLA_E_DCS_START_WAIT_TIMEOUT                       _HRESULT_TYPEDEF_(0x8030010A)
#define PLA_E_DC_START_WAIT_TIMEOUT                        _HRESULT_TYPEDEF_(0x8030010B)
#define PLA_E_REPORT_WAIT_TIMEOUT                          _HRESULT_TYPEDEF_(0x8030010C)
#define PLA_E_NO_DUPLICATES                                _HRESULT_TYPEDEF_(0x8030010D)
#define PLA_E_EXE_FULL_PATH_REQUIRED                       _HRESULT_TYPEDEF_(0x8030010E)
#define PLA_E_INVALID_SESSION_NAME                         _HRESULT_TYPEDEF_(0x8030010F)
#define PLA_E_PLA_CHANNEL_NOT_ENABLED                      _HRESULT_TYPEDEF_(0x80300110)
#define PLA_E_TASKSCHED_CHANNEL_NOT_ENABLED                _HRESULT_TYPEDEF_(0x80300111)
#define PLA_E_RULES_MANAGER_FAILED                         _HRESULT_TYPEDEF_(0x80300112)
#define PLA_E_CABAPI_FAILURE                               _HRESULT_TYPEDEF_(0x80300113)

#define FVE_E_LOCKED_VOLUME                                _HRESULT_TYPEDEF_(0x80310000)
#define FVE_E_NOT_ENCRYPTED                                _HRESULT_TYPEDEF_(0x80310001)
#define FVE_E_NO_TPM_BIOS                                  _HRESULT_TYPEDEF_(0x80310002)
#define FVE_E_NO_MBR_METRIC                                _HRESULT_TYPEDEF_(0x80310003)
#define FVE_E_NO_BOOTSECTOR_METRIC                         _HRESULT_TYPEDEF_(0x80310004)
#define FVE_E_NO_BOOTMGR_METRIC                            _HRESULT_TYPEDEF_(0x80310005)
#define FVE_E_WRONG_BOOTMGR                                _HRESULT_TYPEDEF_(0x80310006)
#define FVE_E_SECURE_KEY_REQUIRED                          _HRESULT_TYPEDEF_(0x80310007)
#define FVE_E_NOT_ACTIVATED                                _HRESULT_TYPEDEF_(0x80310008)
#define FVE_E_ACTION_NOT_ALLOWED                           _HRESULT_TYPEDEF_(0x80310009)
#define FVE_E_AD_SCHEMA_NOT_INSTALLED                      _HRESULT_TYPEDEF_(0x8031000A)
#define FVE_E_AD_INVALID_DATATYPE                          _HRESULT_TYPEDEF_(0x8031000B)
#define FVE_E_AD_INVALID_DATASIZE                          _HRESULT_TYPEDEF_(0x8031000C)
#define FVE_E_AD_NO_VALUES                                 _HRESULT_TYPEDEF_(0x8031000D)
#define FVE_E_AD_ATTR_NOT_SET                              _HRESULT_TYPEDEF_(0x8031000E)
#define FVE_E_AD_GUID_NOT_FOUND                            _HRESULT_TYPEDEF_(0x8031000F)
#define FVE_E_BAD_INFORMATION                              _HRESULT_TYPEDEF_(0x80310010)
#define FVE_E_TOO_SMALL                                    _HRESULT_TYPEDEF_(0x80310011)
#define FVE_E_SYSTEM_VOLUME                                _HRESULT_TYPEDEF_(0x80310012)
#define FVE_E_FAILED_WRONG_FS                              _HRESULT_TYPEDEF_(0x80310013)
#define FVE_E_BAD_PARTITION_SIZE                           _HRESULT_TYPEDEF_(0x80310014)
#define FVE_E_NOT_SUPPORTED                                _HRESULT_TYPEDEF_(0x80310015)
#define FVE_E_BAD_DATA                                     _HRESULT_TYPEDEF_(0x80310016)
#define FVE_E_VOLUME_NOT_BOUND                             _HRESULT_TYPEDEF_(0x80310017)
#define FVE_E_TPM_NOT_OWNED                                _HRESULT_TYPEDEF_(0x80310018)
#define FVE_E_NOT_DATA_VOLUME                              _HRESULT_TYPEDEF_(0x80310019)
#define FVE_E_AD_INSUFFICIENT_BUFFER                       _HRESULT_TYPEDEF_(0x8031001A)
#define FVE_E_CONV_READ                                    _HRESULT_TYPEDEF_(0x8031001B)
#define FVE_E_CONV_WRITE                                   _HRESULT_TYPEDEF_(0x8031001C)
#define FVE_E_KEY_REQUIRED                                 _HRESULT_TYPEDEF_(0x8031001D)
#define FVE_E_CLUSTERING_NOT_SUPPORTED                     _HRESULT_TYPEDEF_(0x8031001E)
#define FVE_E_VOLUME_BOUND_ALREADY                         _HRESULT_TYPEDEF_(0x8031001F)
#define FVE_E_OS_NOT_PROTECTED                             _HRESULT_TYPEDEF_(0x80310020)
#define FVE_E_PROTECTION_DISABLED                          _HRESULT_TYPEDEF_(0x80310021)
#define FVE_E_RECOVERY_KEY_REQUIRED                        _HRESULT_TYPEDEF_(0x80310022)
#define FVE_E_FOREIGN_VOLUME                               _HRESULT_TYPEDEF_(0x80310023)
#define FVE_E_OVERLAPPED_UPDATE                            _HRESULT_TYPEDEF_(0x80310024)
#define FVE_E_TPM_SRK_AUTH_NOT_ZERO                        _HRESULT_TYPEDEF_(0x80310025)
#define FVE_E_FAILED_SECTOR_SIZE                           _HRESULT_TYPEDEF_(0x80310026)
#define FVE_E_FAILED_AUTHENTICATION                        _HRESULT_TYPEDEF_(0x80310027)
#define FVE_E_NOT_OS_VOLUME                                _HRESULT_TYPEDEF_(0x80310028)
#define FVE_E_AUTOUNLOCK_ENABLED                           _HRESULT_TYPEDEF_(0x80310029)
#define FVE_E_WRONG_BOOTSECTOR                             _HRESULT_TYPEDEF_(0x8031002A)
#define FVE_E_WRONG_SYSTEM_FS                              _HRESULT_TYPEDEF_(0x8031002B)
#define FVE_E_POLICY_PASSWORD_REQUIRED                     _HRESULT_TYPEDEF_(0x8031002C)
#define FVE_E_CANNOT_SET_FVEK_ENCRYPTED                    _HRESULT_TYPEDEF_(0x8031002D)
#define FVE_E_CANNOT_ENCRYPT_NO_KEY                        _HRESULT_TYPEDEF_(0x8031002E)
#define FVE_E_BOOTABLE_CDDVD                               _HRESULT_TYPEDEF_(0x80310030)
#define FVE_E_PROTECTOR_EXISTS                             _HRESULT_TYPEDEF_(0x80310031)
#define FVE_E_RELATIVE_PATH                                _HRESULT_TYPEDEF_(0x80310032)
#define FVE_E_PROTECTOR_NOT_FOUND                          _HRESULT_TYPEDEF_(0x80310033)
#define FVE_E_INVALID_KEY_FORMAT                           _HRESULT_TYPEDEF_(0x80310034)
#define FVE_E_INVALID_PASSWORD_FORMAT                      _HRESULT_TYPEDEF_(0x80310035)
#define FVE_E_FIPS_RNG_CHECK_FAILED                        _HRESULT_TYPEDEF_(0x80310036)
#define FVE_E_FIPS_PREVENTS_RECOVERY_PASSWORD              _HRESULT_TYPEDEF_(0x80310037)
#define FVE_E_FIPS_PREVENTS_EXTERNAL_KEY_EXPORT            _HRESULT_TYPEDEF_(0x80310038)
#define FVE_E_NOT_DECRYPTED                                _HRESULT_TYPEDEF_(0x80310039)
#define FVE_E_INVALID_PROTECTOR_TYPE                       _HRESULT_TYPEDEF_(0x8031003A)
#define FVE_E_NO_PROTECTORS_TO_TEST                        _HRESULT_TYPEDEF_(0x8031003B)
#define FVE_E_KEYFILE_NOT_FOUND                            _HRESULT_TYPEDEF_(0x8031003C)
#define FVE_E_KEYFILE_INVALID                              _HRESULT_TYPEDEF_(0x8031003D)
#define FVE_E_KEYFILE_NO_VMK                               _HRESULT_TYPEDEF_(0x8031003E)
#define FVE_E_TPM_DISABLED                                 _HRESULT_TYPEDEF_(0x8031003F)
#define FVE_E_NOT_ALLOWED_IN_SAFE_MODE                     _HRESULT_TYPEDEF_(0x80310040)
#define FVE_E_TPM_INVALID_PCR                              _HRESULT_TYPEDEF_(0x80310041)
#define FVE_E_TPM_NO_VMK                                   _HRESULT_TYPEDEF_(0x80310042)
#define FVE_E_PIN_INVALID                                  _HRESULT_TYPEDEF_(0x80310043)
#define FVE_E_AUTH_INVALID_APPLICATION                     _HRESULT_TYPEDEF_(0x80310044)
#define FVE_E_AUTH_INVALID_CONFIG                          _HRESULT_TYPEDEF_(0x80310045)
#define FVE_E_FIPS_DISABLE_PROTECTION_NOT_ALLOWED          _HRESULT_TYPEDEF_(0x80310046)
#define FVE_E_FS_NOT_EXTENDED                              _HRESULT_TYPEDEF_(0x80310047)
#define FVE_E_FIRMWARE_TYPE_NOT_SUPPORTED                  _HRESULT_TYPEDEF_(0x80310048)
#define FVE_E_NO_LICENSE                                   _HRESULT_TYPEDEF_(0x80310049)
#define FVE_E_NOT_ON_STACK                                 _HRESULT_TYPEDEF_(0x8031004A)
#define FVE_E_FS_MOUNTED                                   _HRESULT_TYPEDEF_(0x8031004B)
#define FVE_E_TOKEN_NOT_IMPERSONATED                       _HRESULT_TYPEDEF_(0x8031004C)
#define FVE_E_DRY_RUN_FAILED                               _HRESULT_TYPEDEF_(0x8031004D)
#define FVE_E_REBOOT_REQUIRED                              _HRESULT_TYPEDEF_(0x8031004E)
#define FVE_E_DEBUGGER_ENABLED                             _HRESULT_TYPEDEF_(0x8031004F)
#define FVE_E_RAW_ACCESS                                   _HRESULT_TYPEDEF_(0x80310050)
#define FVE_E_RAW_BLOCKED                                  _HRESULT_TYPEDEF_(0x80310051)
#define FVE_E_BCD_APPLICATIONS_PATH_INCORRECT              _HRESULT_TYPEDEF_(0x80310052)
#define FVE_E_NOT_ALLOWED_IN_VERSION                       _HRESULT_TYPEDEF_(0x80310053)
#define FVE_E_NO_AUTOUNLOCK_MASTER_KEY                     _HRESULT_TYPEDEF_(0x80310054)
#define FVE_E_MOR_FAILED                                   _HRESULT_TYPEDEF_(0x80310055)
#define FVE_E_HIDDEN_VOLUME                                _HRESULT_TYPEDEF_(0x80310056)
#define FVE_E_TRANSIENT_STATE                              _HRESULT_TYPEDEF_(0x80310057)
#define FVE_E_PUBKEY_NOT_ALLOWED                           _HRESULT_TYPEDEF_(0x80310058)
#define FVE_E_VOLUME_HANDLE_OPEN                           _HRESULT_TYPEDEF_(0x80310059)
#define FVE_E_NO_FEATURE_LICENSE                           _HRESULT_TYPEDEF_(0x8031005A)
#define FVE_E_INVALID_STARTUP_OPTIONS                      _HRESULT_TYPEDEF_(0x8031005B)
#define FVE_E_POLICY_RECOVERY_PASSWORD_NOT_ALLOWED         _HRESULT_TYPEDEF_(0x8031005C)
#define FVE_E_POLICY_RECOVERY_PASSWORD_REQUIRED            _HRESULT_TYPEDEF_(0x8031005D)
#define FVE_E_POLICY_RECOVERY_KEY_NOT_ALLOWED              _HRESULT_TYPEDEF_(0x8031005E)
#define FVE_E_POLICY_RECOVERY_KEY_REQUIRED                 _HRESULT_TYPEDEF_(0x8031005F)
#define FVE_E_POLICY_STARTUP_PIN_NOT_ALLOWED               _HRESULT_TYPEDEF_(0x80310060)
#define FVE_E_POLICY_STARTUP_PIN_REQUIRED                  _HRESULT_TYPEDEF_(0x80310061)
#define FVE_E_POLICY_STARTUP_KEY_NOT_ALLOWED               _HRESULT_TYPEDEF_(0x80310062)
#define FVE_E_POLICY_STARTUP_KEY_REQUIRED                  _HRESULT_TYPEDEF_(0x80310063)
#define FVE_E_POLICY_STARTUP_PIN_KEY_NOT_ALLOWED           _HRESULT_TYPEDEF_(0x80310064)
#define FVE_E_POLICY_STARTUP_PIN_KEY_REQUIRED              _HRESULT_TYPEDEF_(0x80310065)
#define FVE_E_POLICY_STARTUP_TPM_NOT_ALLOWED               _HRESULT_TYPEDEF_(0x80310066)
#define FVE_E_POLICY_STARTUP_TPM_REQUIRED                  _HRESULT_TYPEDEF_(0x80310067)
#define FVE_E_POLICY_INVALID_PIN_LENGTH                    _HRESULT_TYPEDEF_(0x80310068)
#define FVE_E_KEY_PROTECTOR_NOT_SUPPORTED                  _HRESULT_TYPEDEF_(0x80310069)
#define FVE_E_POLICY_PASSPHRASE_NOT_ALLOWED                _HRESULT_TYPEDEF_(0x8031006A)
#define FVE_E_POLICY_PASSPHRASE_REQUIRED                   _HRESULT_TYPEDEF_(0x8031006B)
#define FVE_E_FIPS_PREVENTS_PASSPHRASE                     _HRESULT_TYPEDEF_(0x8031006C)
#define FVE_E_OS_VOLUME_PASSPHRASE_NOT_ALLOWED             _HRESULT_TYPEDEF_(0x8031006D)
#define FVE_E_INVALID_BITLOCKER_OID                        _HRESULT_TYPEDEF_(0x8031006E)
#define FVE_E_VOLUME_TOO_SMALL                             _HRESULT_TYPEDEF_(0x8031006F)
#define FVE_E_DV_NOT_SUPPORTED_ON_FS                       _HRESULT_TYPEDEF_(0x80310070)
#define FVE_E_DV_NOT_ALLOWED_BY_GP                         _HRESULT_TYPEDEF_(0x80310071)
#define FVE_E_POLICY_USER_CERTIFICATE_NOT_ALLOWED          _HRESULT_TYPEDEF_(0x80310072)
#define FVE_E_POLICY_USER_CERTIFICATE_REQUIRED             _HRESULT_TYPEDEF_(0x80310073)
#define FVE_E_POLICY_USER_CERT_MUST_BE_HW                  _HRESULT_TYPEDEF_(0x80310074)
#define FVE_E_POLICY_USER_CONFIGURE_FDV_AUTOUNLOCK_NOT_ALLOWED _HRESULT_TYPEDEF_(0x80310075)
#define FVE_E_POLICY_USER_CONFIGURE_RDV_AUTOUNLOCK_NOT_ALLOWED _HRESULT_TYPEDEF_(0x80310076)
#define FVE_E_POLICY_USER_CONFIGURE_RDV_NOT_ALLOWED        _HRESULT_TYPEDEF_(0x80310077)
#define FVE_E_POLICY_USER_ENABLE_RDV_NOT_ALLOWED           _HRESULT_TYPEDEF_(0x80310078)
#define FVE_E_POLICY_USER_DISABLE_RDV_NOT_ALLOWED          _HRESULT_TYPEDEF_(0x80310079)
#define FVE_E_POLICY_INVALID_PASSPHRASE_LENGTH             _HRESULT_TYPEDEF_(0x80310080)
#define FVE_E_POLICY_PASSPHRASE_TOO_SIMPLE                 _HRESULT_TYPEDEF_(0x80310081)
#define FVE_E_RECOVERY_PARTITION                           _HRESULT_TYPEDEF_(0x80310082)
#define FVE_E_POLICY_CONFLICT_FDV_RK_OFF_AUK_ON            _HRESULT_TYPEDEF_(0x80310083)
#define FVE_E_POLICY_CONFLICT_RDV_RK_OFF_AUK_ON            _HRESULT_TYPEDEF_(0x80310084)
#define FVE_E_NON_BITLOCKER_OID                            _HRESULT_TYPEDEF_(0x80310085)
#define FVE_E_POLICY_PROHIBITS_SELFSIGNED                  _HRESULT_TYPEDEF_(0x80310086)
#define FVE_E_POLICY_CONFLICT_RO_AND_STARTUP_KEY_REQUIRED  _HRESULT_TYPEDEF_(0x80310087)
#define FVE_E_CONV_RECOVERY_FAILED                         _HRESULT_TYPEDEF_(0x80310088)
#define FVE_E_VIRTUALIZED_SPACE_TOO_BIG                    _HRESULT_TYPEDEF_(0x80310089)
#define FVE_E_POLICY_CONFLICT_OSV_RP_OFF_ADB_ON            _HRESULT_TYPEDEF_(0x80310090)
#define FVE_E_POLICY_CONFLICT_FDV_RP_OFF_ADB_ON            _HRESULT_TYPEDEF_(0x80310091)
#define FVE_E_POLICY_CONFLICT_RDV_RP_OFF_ADB_ON            _HRESULT_TYPEDEF_(0x80310092)
#define FVE_E_NON_BITLOCKER_KU                             _HRESULT_TYPEDEF_(0x80310093)
#define FVE_E_PRIVATEKEY_AUTH_FAILED                       _HRESULT_TYPEDEF_(0x80310094)
#define FVE_E_REMOVAL_OF_DRA_FAILED                        _HRESULT_TYPEDEF_(0x80310095)
#define FVE_E_OPERATION_NOT_SUPPORTED_ON_VISTA_VOLUME      _HRESULT_TYPEDEF_(0x80310096)
#define FVE_E_CANT_LOCK_AUTOUNLOCK_ENABLED_VOLUME          _HRESULT_TYPEDEF_(0x80310097)
#define FVE_E_FIPS_HASH_KDF_NOT_ALLOWED                    _HRESULT_TYPEDEF_(0x80310098)
#define FVE_E_ENH_PIN_INVALID                              _HRESULT_TYPEDEF_(0x80310099)
#define FVE_E_INVALID_PIN_CHARS                            _HRESULT_TYPEDEF_(0x8031009A)
#define FVE_E_INVALID_DATUM_TYPE                           _HRESULT_TYPEDEF_(0x8031009B)
#define FVE_E_EFI_ONLY                                     _HRESULT_TYPEDEF_(0x8031009C)
#define FVE_E_MULTIPLE_NKP_CERTS                           _HRESULT_TYPEDEF_(0x8031009D)
#define FVE_E_REMOVAL_OF_NKP_FAILED                        _HRESULT_TYPEDEF_(0x8031009E)
#define FVE_E_INVALID_NKP_CERT                             _HRESULT_TYPEDEF_(0x8031009F)
#define FVE_E_NO_EXISTING_PIN                              _HRESULT_TYPEDEF_(0x803100A0)
#define FVE_E_PROTECTOR_CHANGE_PIN_MISMATCH                _HRESULT_TYPEDEF_(0x803100A1)
#define FVE_E_PIN_PROTECTOR_CHANGE_BY_STD_USER_DISALLOWED  _HRESULT_TYPEDEF_(0x803100A2)
#define FVE_E_PROTECTOR_CHANGE_MAX_PIN_CHANGE_ATTEMPTS_REACHED _HRESULT_TYPEDEF_(0x803100A3)
#define FVE_E_POLICY_PASSPHRASE_REQUIRES_ASCII             _HRESULT_TYPEDEF_(0x803100A4)
#define FVE_E_FULL_ENCRYPTION_NOT_ALLOWED_ON_TP_STORAGE    _HRESULT_TYPEDEF_(0x803100A5)
#define FVE_E_WIPE_NOT_ALLOWED_ON_TP_STORAGE               _HRESULT_TYPEDEF_(0x803100A6)
#define FVE_E_KEY_LENGTH_NOT_SUPPORTED_BY_EDRIVE           _HRESULT_TYPEDEF_(0x803100A7)
#define FVE_E_NO_EXISTING_PASSPHRASE                       _HRESULT_TYPEDEF_(0x803100A8)
#define FVE_E_PROTECTOR_CHANGE_PASSPHRASE_MISMATCH         _HRESULT_TYPEDEF_(0x803100A9)
#define FVE_E_PASSPHRASE_TOO_LONG                          _HRESULT_TYPEDEF_(0x803100AA)
#define FVE_E_NO_PASSPHRASE_WITH_TPM                       _HRESULT_TYPEDEF_(0x803100AB)
#define FVE_E_NO_TPM_WITH_PASSPHRASE                       _HRESULT_TYPEDEF_(0x803100AC)
#define FVE_E_NOT_ALLOWED_ON_CSV_STACK                     _HRESULT_TYPEDEF_(0x803100AD)
#define FVE_E_NOT_ALLOWED_ON_CLUSTER                       _HRESULT_TYPEDEF_(0x803100AE)
#define FVE_E_EDRIVE_NO_FAILOVER_TO_SW                     _HRESULT_TYPEDEF_(0x803100AF)
#define FVE_E_EDRIVE_BAND_IN_USE                           _HRESULT_TYPEDEF_(0x803100B0)
#define FVE_E_EDRIVE_DISALLOWED_BY_GP                      _HRESULT_TYPEDEF_(0x803100B1)
#define FVE_E_EDRIVE_INCOMPATIBLE_VOLUME                   _HRESULT_TYPEDEF_(0x803100B2)
#define FVE_E_NOT_ALLOWED_TO_UPGRADE_WHILE_CONVERTING      _HRESULT_TYPEDEF_(0x803100B3)
#define FVE_E_EDRIVE_DV_NOT_SUPPORTED                      _HRESULT_TYPEDEF_(0x803100B4)
#define FVE_E_NO_PREBOOT_KEYBOARD_DETECTED                 _HRESULT_TYPEDEF_(0x803100B5)
#define FVE_E_NO_PREBOOT_KEYBOARD_OR_WINRE_DETECTED        _HRESULT_TYPEDEF_(0x803100B6)
#define FVE_E_POLICY_REQUIRES_STARTUP_PIN_ON_TOUCH_DEVICE  _HRESULT_TYPEDEF_(0x803100B7)
#define FVE_E_POLICY_REQUIRES_RECOVERY_PASSWORD_ON_TOUCH_DEVICE _HRESULT_TYPEDEF_(0x803100B8)
#define FVE_E_WIPE_CANCEL_NOT_APPLICABLE                   _HRESULT_TYPEDEF_(0x803100B9)
#define FVE_E_SECUREBOOT_DISABLED                          _HRESULT_TYPEDEF_(0x803100BA)
#define FVE_E_SECUREBOOT_CONFIGURATION_INVALID             _HRESULT_TYPEDEF_(0x803100BB)
#define FVE_E_EDRIVE_DRY_RUN_FAILED                        _HRESULT_TYPEDEF_(0x803100BC)
#define FVE_E_SHADOW_COPY_PRESENT                          _HRESULT_TYPEDEF_(0x803100BD)
#define FVE_E_POLICY_INVALID_ENHANCED_BCD_SETTINGS         _HRESULT_TYPEDEF_(0x803100BE)
#define FVE_E_EDRIVE_INCOMPATIBLE_FIRMWARE                 _HRESULT_TYPEDEF_(0x803100BF)
#define FVE_E_PROTECTOR_CHANGE_MAX_PASSPHRASE_CHANGE_ATTEMPTS_REACHED _HRESULT_TYPEDEF_(0x803100C0)
#define FVE_E_PASSPHRASE_PROTECTOR_CHANGE_BY_STD_USER_DISALLOWED _HRESULT_TYPEDEF_(0x803100C1)
#define FVE_E_LIVEID_ACCOUNT_SUSPENDED                     _HRESULT_TYPEDEF_(0x803100C2)
#define FVE_E_LIVEID_ACCOUNT_BLOCKED                       _HRESULT_TYPEDEF_(0x803100C3)
#define FVE_E_NOT_PROVISIONED_ON_ALL_VOLUMES               _HRESULT_TYPEDEF_(0x803100C4)
#define FVE_E_DE_FIXED_DATA_NOT_SUPPORTED                  _HRESULT_TYPEDEF_(0x803100C5)
#define FVE_E_DE_HARDWARE_NOT_COMPLIANT                    _HRESULT_TYPEDEF_(0x803100C6)
#define FVE_E_DE_WINRE_NOT_CONFIGURED                      _HRESULT_TYPEDEF_(0x803100C7)
#define FVE_E_DE_PROTECTION_SUSPENDED                      _HRESULT_TYPEDEF_(0x803100C8)
#define FVE_E_DE_OS_VOLUME_NOT_PROTECTED                   _HRESULT_TYPEDEF_(0x803100C9)
#define FVE_E_DE_DEVICE_LOCKEDOUT                          _HRESULT_TYPEDEF_(0x803100CA)
#define FVE_E_DE_PROTECTION_NOT_YET_ENABLED                _HRESULT_TYPEDEF_(0x803100CB)
#define FVE_E_INVALID_PIN_CHARS_DETAILED                   _HRESULT_TYPEDEF_(0x803100CC)
#define FVE_E_DEVICE_LOCKOUT_COUNTER_UNAVAILABLE           _HRESULT_TYPEDEF_(0x803100CD)
#define FVE_E_DEVICELOCKOUT_COUNTER_MISMATCH               _HRESULT_TYPEDEF_(0x803100CE)
#define FVE_E_BUFFER_TOO_LARGE                             _HRESULT_TYPEDEF_(0x803100CF)
#define FVE_E_NO_SUCH_CAPABILITY_ON_TARGET                 _HRESULT_TYPEDEF_(0x803100D0)
#define FVE_E_DE_PREVENTED_FOR_OS                          _HRESULT_TYPEDEF_(0x803100D1)
#define FVE_E_DE_VOLUME_OPTED_OUT                          _HRESULT_TYPEDEF_(0x803100D2)
#define FVE_E_DE_VOLUME_NOT_SUPPORTED                      _HRESULT_TYPEDEF_(0x803100D3)
#define FVE_E_EOW_NOT_SUPPORTED_IN_VERSION                 _HRESULT_TYPEDEF_(0x803100D4)
#define FVE_E_ADBACKUP_NOT_ENABLED                         _HRESULT_TYPEDEF_(0x803100D5)
#define FVE_E_VOLUME_EXTEND_PREVENTS_EOW_DECRYPT           _HRESULT_TYPEDEF_(0x803100D6)
#define FVE_E_NOT_DE_VOLUME                                _HRESULT_TYPEDEF_(0x803100D7)
#define FVE_E_PROTECTION_CANNOT_BE_DISABLED                _HRESULT_TYPEDEF_(0x803100D8)
#define FVE_E_OSV_KSR_NOT_ALLOWED                          _HRESULT_TYPEDEF_(0x803100D9)
#define FVE_E_AD_BACKUP_REQUIRED_POLICY_NOT_SET_OS_DRIVE   _HRESULT_TYPEDEF_(0x803100DA)
#define FVE_E_AD_BACKUP_REQUIRED_POLICY_NOT_SET_FIXED_DRIVE _HRESULT_TYPEDEF_(0x803100DB)
#define FVE_E_AD_BACKUP_REQUIRED_POLICY_NOT_SET_REMOVABLE_DRIVE _HRESULT_TYPEDEF_(0x803100DC)
#define FVE_E_KEY_ROTATION_NOT_SUPPORTED                   _HRESULT_TYPEDEF_(0x803100DD)
#define FVE_E_EXECUTE_REQUEST_SENT_TOO_SOON                _HRESULT_TYPEDEF_(0x803100DE)
#define FVE_E_KEY_ROTATION_NOT_ENABLED                     _HRESULT_TYPEDEF_(0x803100DF)
#define FVE_E_DEVICE_NOT_JOINED                            _HRESULT_TYPEDEF_(0x803100E0)
#define FVE_E_AAD_ENDPOINT_BUSY                            _HRESULT_TYPEDEF_(0x803100E1)
#define FVE_E_INVALID_NBP_CERT                             _HRESULT_TYPEDEF_(0x803100E2)
#define FVE_E_EDRIVE_BAND_ENUMERATION_FAILED               _HRESULT_TYPEDEF_(0x803100E3)
#define FVE_E_POLICY_ON_RDV_EXCLUSION_LIST                 _HRESULT_TYPEDEF_(0x803100E4)
#define FVE_E_PREDICTED_TPM_PROTECTOR_NOT_SUPPORTED        _HRESULT_TYPEDEF_(0x803100E5)
#define FVE_E_SETUP_TPM_CALLBACK_NOT_SUPPORTED             _HRESULT_TYPEDEF_(0x803100E6)
#define FVE_E_TPM_CONTEXT_SETUP_NOT_SUPPORTED              _HRESULT_TYPEDEF_(0x803100E7)
#define FVE_E_UPDATE_INVALID_CONFIG                        _HRESULT_TYPEDEF_(0x803100E8)
#define FVE_E_AAD_SERVER_FAIL_RETRY_AFTER                  _HRESULT_TYPEDEF_(0x803100E9)
#define FVE_E_AAD_SERVER_FAIL_BACKOFF                      _HRESULT_TYPEDEF_(0x803100EA)
#define FVE_E_DATASET_FULL                                 _HRESULT_TYPEDEF_(0x803100EB)
#define FVE_E_METADATA_FULL                                _HRESULT_TYPEDEF_(0x803100EC)

#define FWP_E_CALLOUT_NOT_FOUND                            _HRESULT_TYPEDEF_(0x80320001)
#define FWP_E_CONDITION_NOT_FOUND                          _HRESULT_TYPEDEF_(0x80320002)
#define FWP_E_FILTER_NOT_FOUND                             _HRESULT_TYPEDEF_(0x80320003)
#define FWP_E_LAYER_NOT_FOUND                              _HRESULT_TYPEDEF_(0x80320004)
#define FWP_E_PROVIDER_NOT_FOUND                           _HRESULT_TYPEDEF_(0x80320005)
#define FWP_E_PROVIDER_CONTEXT_NOT_FOUND                   _HRESULT_TYPEDEF_(0x80320006)
#define FWP_E_SUBLAYER_NOT_FOUND                           _HRESULT_TYPEDEF_(0x80320007)
#define FWP_E_NOT_FOUND                                    _HRESULT_TYPEDEF_(0x80320008)
#define FWP_E_ALREADY_EXISTS                               _HRESULT_TYPEDEF_(0x80320009)
#define FWP_E_IN_USE                                       _HRESULT_TYPEDEF_(0x8032000A)
#define FWP_E_DYNAMIC_SESSION_IN_PROGRESS                  _HRESULT_TYPEDEF_(0x8032000B)
#define FWP_E_WRONG_SESSION                                _HRESULT_TYPEDEF_(0x8032000C)
#define FWP_E_NO_TXN_IN_PROGRESS                           _HRESULT_TYPEDEF_(0x8032000D)
#define FWP_E_TXN_IN_PROGRESS                              _HRESULT_TYPEDEF_(0x8032000E)
#define FWP_E_TXN_ABORTED                                  _HRESULT_TYPEDEF_(0x8032000F)
#define FWP_E_SESSION_ABORTED                              _HRESULT_TYPEDEF_(0x80320010)
#define FWP_E_INCOMPATIBLE_TXN                             _HRESULT_TYPEDEF_(0x80320011)
#define FWP_E_TIMEOUT                                      _HRESULT_TYPEDEF_(0x80320012)
#define FWP_E_NET_EVENTS_DISABLED                          _HRESULT_TYPEDEF_(0x80320013)
#define FWP_E_INCOMPATIBLE_LAYER                           _HRESULT_TYPEDEF_(0x80320014)
#define FWP_E_KM_CLIENTS_ONLY                              _HRESULT_TYPEDEF_(0x80320015)
#define FWP_E_LIFETIME_MISMATCH                            _HRESULT_TYPEDEF_(0x80320016)
#define FWP_E_BUILTIN_OBJECT                               _HRESULT_TYPEDEF_(0x80320017)
#define FWP_E_TOO_MANY_CALLOUTS                            _HRESULT_TYPEDEF_(0x80320018)
#define FWP_E_NOTIFICATION_DROPPED                         _HRESULT_TYPEDEF_(0x80320019)
#define FWP_E_TRAFFIC_MISMATCH                             _HRESULT_TYPEDEF_(0x8032001A)
#define FWP_E_INCOMPATIBLE_SA_STATE                        _HRESULT_TYPEDEF_(0x8032001B)
#define FWP_E_NULL_POINTER                                 _HRESULT_TYPEDEF_(0x8032001C)
#define FWP_E_INVALID_ENUMERATOR                           _HRESULT_TYPEDEF_(0x8032001D)
#define FWP_E_INVALID_FLAGS                                _HRESULT_TYPEDEF_(0x8032001E)
#define FWP_E_INVALID_NET_MASK                             _HRESULT_TYPEDEF_(0x8032001F)
#define FWP_E_INVALID_RANGE                                _HRESULT_TYPEDEF_(0x80320020)
#define FWP_E_INVALID_INTERVAL                             _HRESULT_TYPEDEF_(0x80320021)
#define FWP_E_ZERO_LENGTH_ARRAY                            _HRESULT_TYPEDEF_(0x80320022)
#define FWP_E_NULL_DISPLAY_NAME                            _HRESULT_TYPEDEF_(0x80320023)
#define FWP_E_INVALID_ACTION_TYPE                          _HRESULT_TYPEDEF_(0x80320024)
#define FWP_E_INVALID_WEIGHT                               _HRESULT_TYPEDEF_(0x80320025)
#define FWP_E_MATCH_TYPE_MISMATCH                          _HRESULT_TYPEDEF_(0x80320026)
#define FWP_E_TYPE_MISMATCH                                _HRESULT_TYPEDEF_(0x80320027)
#define FWP_E_OUT_OF_BOUNDS                                _HRESULT_TYPEDEF_(0x80320028)
#define FWP_E_RESERVED                                     _HRESULT_TYPEDEF_(0x80320029)
#define FWP_E_DUPLICATE_CONDITION                          _HRESULT_TYPEDEF_(0x8032002A)
#define FWP_E_DUPLICATE_KEYMOD                             _HRESULT_TYPEDEF_(0x8032002B)
#define FWP_E_ACTION_INCOMPATIBLE_WITH_LAYER               _HRESULT_TYPEDEF_(0x8032002C)
#define FWP_E_ACTION_INCOMPATIBLE_WITH_SUBLAYER            _HRESULT_TYPEDEF_(0x8032002D)
#define FWP_E_CONTEXT_INCOMPATIBLE_WITH_LAYER              _HRESULT_TYPEDEF_(0x8032002E)
#define FWP_E_CONTEXT_INCOMPATIBLE_WITH_CALLOUT            _HRESULT_TYPEDEF_(0x8032002F)
#define FWP_E_INCOMPATIBLE_AUTH_METHOD                     _HRESULT_TYPEDEF_(0x80320030)
#define FWP_E_INCOMPATIBLE_DH_GROUP                        _HRESULT_TYPEDEF_(0x80320031)
#define FWP_E_EM_NOT_SUPPORTED                             _HRESULT_TYPEDEF_(0x80320032)
#define FWP_E_NEVER_MATCH                                  _HRESULT_TYPEDEF_(0x80320033)
#define FWP_E_PROVIDER_CONTEXT_MISMATCH                    _HRESULT_TYPEDEF_(0x80320034)
#define FWP_E_INVALID_PARAMETER                            _HRESULT_TYPEDEF_(0x80320035)
#define FWP_E_TOO_MANY_SUBLAYERS                           _HRESULT_TYPEDEF_(0x80320036)
#define FWP_E_CALLOUT_NOTIFICATION_FAILED                  _HRESULT_TYPEDEF_(0x80320037)
#define FWP_E_INVALID_AUTH_TRANSFORM                       _HRESULT_TYPEDEF_(0x80320038)
#define FWP_E_INVALID_CIPHER_TRANSFORM                     _HRESULT_TYPEDEF_(0x80320039)
#define FWP_E_INCOMPATIBLE_CIPHER_TRANSFORM                _HRESULT_TYPEDEF_(0x8032003A)
#define FWP_E_INVALID_TRANSFORM_COMBINATION                _HRESULT_TYPEDEF_(0x8032003B)
#define FWP_E_DUPLICATE_AUTH_METHOD                        _HRESULT_TYPEDEF_(0x8032003C)
#define FWP_E_INVALID_TUNNEL_ENDPOINT                      _HRESULT_TYPEDEF_(0x8032003D)
#define FWP_E_L2_DRIVER_NOT_READY                          _HRESULT_TYPEDEF_(0x8032003E)
#define FWP_E_KEY_DICTATOR_ALREADY_REGISTERED              _HRESULT_TYPEDEF_(0x8032003F)
#define FWP_E_KEY_DICTATION_INVALID_KEYING_MATERIAL        _HRESULT_TYPEDEF_(0x80320040)
#define FWP_E_CONNECTIONS_DISABLED                         _HRESULT_TYPEDEF_(0x80320041)
#define FWP_E_INVALID_DNS_NAME                             _HRESULT_TYPEDEF_(0x80320042)
#define FWP_E_STILL_ON                                     _HRESULT_TYPEDEF_(0x80320043)
#define FWP_E_IKEEXT_NOT_RUNNING                           _HRESULT_TYPEDEF_(0x80320044)
#define FWP_E_DROP_NOICMP                                  _HRESULT_TYPEDEF_(0x80320104)

#define ERROR_NDIS_INDICATION_REQUIRED                     _NDIS_ERROR_TYPEDEF_(0x00340001)
#define ERROR_NDIS_INTERFACE_CLOSING                       _NDIS_ERROR_TYPEDEF_(0x80340002)
#define ERROR_NDIS_BAD_VERSION                             _NDIS_ERROR_TYPEDEF_(0x80340004)
#define ERROR_NDIS_BAD_CHARACTERISTICS                     _NDIS_ERROR_TYPEDEF_(0x80340005)
#define ERROR_NDIS_ADAPTER_NOT_FOUND                       _NDIS_ERROR_TYPEDEF_(0x80340006)
#define ERROR_NDIS_OPEN_FAILED                             _NDIS_ERROR_TYPEDEF_(0x80340007)
#define ERROR_NDIS_DEVICE_FAILED                           _NDIS_ERROR_TYPEDEF_(0x80340008)
#define ERROR_NDIS_MULTICAST_FULL                          _NDIS_ERROR_TYPEDEF_(0x80340009)
#define ERROR_NDIS_MULTICAST_EXISTS                        _NDIS_ERROR_TYPEDEF_(0x8034000A)
#define ERROR_NDIS_MULTICAST_NOT_FOUND                     _NDIS_ERROR_TYPEDEF_(0x8034000B)
#define ERROR_NDIS_REQUEST_ABORTED                         _NDIS_ERROR_TYPEDEF_(0x8034000C)
#define ERROR_NDIS_RESET_IN_PROGRESS                       _NDIS_ERROR_TYPEDEF_(0x8034000D)
#define ERROR_NDIS_INVALID_PACKET                          _NDIS_ERROR_TYPEDEF_(0x8034000F)
#define ERROR_NDIS_INVALID_DEVICE_REQUEST                  _NDIS_ERROR_TYPEDEF_(0x80340010)
#define ERROR_NDIS_ADAPTER_NOT_READY                       _NDIS_ERROR_TYPEDEF_(0x80340011)
#define ERROR_NDIS_INVALID_LENGTH                          _NDIS_ERROR_TYPEDEF_(0x80340014)
#define ERROR_NDIS_INVALID_DATA                            _NDIS_ERROR_TYPEDEF_(0x80340015)
#define ERROR_NDIS_BUFFER_TOO_SHORT                        _NDIS_ERROR_TYPEDEF_(0x80340016)
#define ERROR_NDIS_INVALID_OID                             _NDIS_ERROR_TYPEDEF_(0x80340017)
#define ERROR_NDIS_ADAPTER_REMOVED                         _NDIS_ERROR_TYPEDEF_(0x80340018)
#define ERROR_NDIS_UNSUPPORTED_MEDIA                       _NDIS_ERROR_TYPEDEF_(0x80340019)
#define ERROR_NDIS_GROUP_ADDRESS_IN_USE                    _NDIS_ERROR_TYPEDEF_(0x8034001A)
#define ERROR_NDIS_FILE_NOT_FOUND                          _NDIS_ERROR_TYPEDEF_(0x8034001B)
#define ERROR_NDIS_ERROR_READING_FILE                      _NDIS_ERROR_TYPEDEF_(0x8034001C)
#define ERROR_NDIS_ALREADY_MAPPED                          _NDIS_ERROR_TYPEDEF_(0x8034001D)
#define ERROR_NDIS_RESOURCE_CONFLICT                       _NDIS_ERROR_TYPEDEF_(0x8034001E)
#define ERROR_NDIS_MEDIA_DISCONNECTED                      _NDIS_ERROR_TYPEDEF_(0x8034001F)
#define ERROR_NDIS_INVALID_ADDRESS                         _NDIS_ERROR_TYPEDEF_(0x80340022)
#define ERROR_NDIS_PAUSED                                  _NDIS_ERROR_TYPEDEF_(0x8034002A)
#define ERROR_NDIS_INTERFACE_NOT_FOUND                     _NDIS_ERROR_TYPEDEF_(0x8034002B)
#define ERROR_NDIS_UNSUPPORTED_REVISION                    _NDIS_ERROR_TYPEDEF_(0x8034002C)
#define ERROR_NDIS_INVALID_PORT                            _NDIS_ERROR_TYPEDEF_(0x8034002D)
#define ERROR_NDIS_INVALID_PORT_STATE                      _NDIS_ERROR_TYPEDEF_(0x8034002E)
#define ERROR_NDIS_LOW_POWER_STATE                         _NDIS_ERROR_TYPEDEF_(0x8034002F)
#define ERROR_NDIS_REINIT_REQUIRED                         _NDIS_ERROR_TYPEDEF_(0x80340030)
#define ERROR_NDIS_NO_QUEUES                               _NDIS_ERROR_TYPEDEF_(0x80340031)
#define ERROR_NDIS_NOT_SUPPORTED                           _NDIS_ERROR_TYPEDEF_(0x803400BB)
#define ERROR_NDIS_OFFLOAD_POLICY                          _NDIS_ERROR_TYPEDEF_(0xC034100F)
#define ERROR_NDIS_OFFLOAD_CONNECTION_REJECTED             _NDIS_ERROR_TYPEDEF_(0xC0341012)
#define ERROR_NDIS_OFFLOAD_PATH_REJECTED                   _NDIS_ERROR_TYPEDEF_(0xC0341013)
#define ERROR_NDIS_DOT11_AUTO_CONFIG_ENABLED               _NDIS_ERROR_TYPEDEF_(0x80342000)
#define ERROR_NDIS_DOT11_MEDIA_IN_USE                      _NDIS_ERROR_TYPEDEF_(0x80342001)
#define ERROR_NDIS_DOT11_POWER_STATE_INVALID               _NDIS_ERROR_TYPEDEF_(0x80342002)
#define ERROR_NDIS_PM_WOL_PATTERN_LIST_FULL                _NDIS_ERROR_TYPEDEF_(0x80342003)
#define ERROR_NDIS_PM_PROTOCOL_OFFLOAD_LIST_FULL           _NDIS_ERROR_TYPEDEF_(0x80342004)
#define ERROR_NDIS_DOT11_AP_CHANNEL_CURRENTLY_NOT_AVAILABLE _NDIS_ERROR_TYPEDEF_(0x80342005)
#define ERROR_NDIS_DOT11_AP_BAND_CURRENTLY_NOT_AVAILABLE   _NDIS_ERROR_TYPEDEF_(0x80342006)
#define ERROR_NDIS_DOT11_AP_CHANNEL_NOT_ALLOWED            _NDIS_ERROR_TYPEDEF_(0x80342007)
#define ERROR_NDIS_DOT11_AP_BAND_NOT_ALLOWED               _NDIS_ERROR_TYPEDEF_(0x80342008)

#define ERROR_HV_INVALID_HYPERCALL_CODE                    _NDIS_ERROR_TYPEDEF_(0xC0350002)
#define ERROR_HV_INVALID_HYPERCALL_INPUT                   _NDIS_ERROR_TYPEDEF_(0xC0350003)
#define ERROR_HV_INVALID_ALIGNMENT                         _NDIS_ERROR_TYPEDEF_(0xC0350004)
#define ERROR_HV_INVALID_PARAMETER                         _NDIS_ERROR_TYPEDEF_(0xC0350005)
#define ERROR_HV_ACCESS_DENIED                             _NDIS_ERROR_TYPEDEF_(0xC0350006)
#define ERROR_HV_INVALID_PARTITION_STATE                   _NDIS_ERROR_TYPEDEF_(0xC0350007)
#define ERROR_HV_OPERATION_DENIED                          _NDIS_ERROR_TYPEDEF_(0xC0350008)
#define ERROR_HV_UNKNOWN_PROPERTY                          _NDIS_ERROR_TYPEDEF_(0xC0350009)
#define ERROR_HV_PROPERTY_VALUE_OUT_OF_RANGE               _NDIS_ERROR_TYPEDEF_(0xC035000A)
#define ERROR_HV_INSUFFICIENT_MEMORY                       _NDIS_ERROR_TYPEDEF_(0xC035000B)
#define ERROR_HV_PARTITION_TOO_DEEP                        _NDIS_ERROR_TYPEDEF_(0xC035000C)
#define ERROR_HV_INVALID_PARTITION_ID                      _NDIS_ERROR_TYPEDEF_(0xC035000D)
#define ERROR_HV_INVALID_VP_INDEX                          _NDIS_ERROR_TYPEDEF_(0xC035000E)
#define ERROR_HV_INVALID_PORT_ID                           _NDIS_ERROR_TYPEDEF_(0xC0350011)
#define ERROR_HV_INVALID_CONNECTION_ID                     _NDIS_ERROR_TYPEDEF_(0xC0350012)
#define ERROR_HV_INSUFFICIENT_BUFFERS                      _NDIS_ERROR_TYPEDEF_(0xC0350013)
#define ERROR_HV_NOT_ACKNOWLEDGED                          _NDIS_ERROR_TYPEDEF_(0xC0350014)
#define ERROR_HV_INVALID_VP_STATE                          _NDIS_ERROR_TYPEDEF_(0xC0350015)
#define ERROR_HV_ACKNOWLEDGED                              _NDIS_ERROR_TYPEDEF_(0xC0350016)
#define ERROR_HV_INVALID_SAVE_RESTORE_STATE                _NDIS_ERROR_TYPEDEF_(0xC0350017)
#define ERROR_HV_INVALID_SYNIC_STATE                       _NDIS_ERROR_TYPEDEF_(0xC0350018)
#define ERROR_HV_OBJECT_IN_USE                             _NDIS_ERROR_TYPEDEF_(0xC0350019)
#define ERROR_HV_INVALID_PROXIMITY_DOMAIN_INFO             _NDIS_ERROR_TYPEDEF_(0xC035001A)
#define ERROR_HV_NO_DATA                                   _NDIS_ERROR_TYPEDEF_(0xC035001B)
#define ERROR_HV_INACTIVE                                  _NDIS_ERROR_TYPEDEF_(0xC035001C)
#define ERROR_HV_NO_RESOURCES                              _NDIS_ERROR_TYPEDEF_(0xC035001D)
#define ERROR_HV_FEATURE_UNAVAILABLE                       _NDIS_ERROR_TYPEDEF_(0xC035001E)
#define ERROR_HV_INSUFFICIENT_BUFFER                       _NDIS_ERROR_TYPEDEF_(0xC0350033)
#define ERROR_HV_INSUFFICIENT_DEVICE_DOMAINS               _NDIS_ERROR_TYPEDEF_(0xC0350038)
#define ERROR_HV_CPUID_FEATURE_VALIDATION                  _NDIS_ERROR_TYPEDEF_(0xC035003C)
#define ERROR_HV_CPUID_XSAVE_FEATURE_VALIDATION            _NDIS_ERROR_TYPEDEF_(0xC035003D)
#define ERROR_HV_PROCESSOR_STARTUP_TIMEOUT                 _NDIS_ERROR_TYPEDEF_(0xC035003E)
#define ERROR_HV_SMX_ENABLED                               _NDIS_ERROR_TYPEDEF_(0xC035003F)
#define ERROR_HV_INVALID_LP_INDEX                          _NDIS_ERROR_TYPEDEF_(0xC0350041)
#define ERROR_HV_INVALID_REGISTER_VALUE                    _NDIS_ERROR_TYPEDEF_(0xC0350050)
#define ERROR_HV_INVALID_VTL_STATE                         _NDIS_ERROR_TYPEDEF_(0xC0350051)
#define ERROR_HV_NX_NOT_DETECTED                           _NDIS_ERROR_TYPEDEF_(0xC0350055)
#define ERROR_HV_INVALID_DEVICE_ID                         _NDIS_ERROR_TYPEDEF_(0xC0350057)
#define ERROR_HV_INVALID_DEVICE_STATE                      _NDIS_ERROR_TYPEDEF_(0xC0350058)
#define ERROR_HV_PENDING_PAGE_REQUESTS                     _NDIS_ERROR_TYPEDEF_(0x00350059)
#define ERROR_HV_PAGE_REQUEST_INVALID                      _NDIS_ERROR_TYPEDEF_(0xC0350060)
#define ERROR_HV_INVALID_CPU_GROUP_ID                      _NDIS_ERROR_TYPEDEF_(0xC035006F)
#define ERROR_HV_INVALID_CPU_GROUP_STATE                   _NDIS_ERROR_TYPEDEF_(0xC0350070)
#define ERROR_HV_OPERATION_FAILED                          _NDIS_ERROR_TYPEDEF_(0xC0350071)
#define ERROR_HV_NOT_ALLOWED_WITH_NESTED_VIRT_ACTIVE       _NDIS_ERROR_TYPEDEF_(0xC0350072)
#define ERROR_HV_INSUFFICIENT_ROOT_MEMORY                  _NDIS_ERROR_TYPEDEF_(0xC0350073)
#define ERROR_HV_EVENT_BUFFER_ALREADY_FREED                _NDIS_ERROR_TYPEDEF_(0xC0350074)
#define ERROR_HV_INSUFFICIENT_CONTIGUOUS_MEMORY            _NDIS_ERROR_TYPEDEF_(0xC0350075)
#define ERROR_HV_DEVICE_NOT_IN_DOMAIN                      _NDIS_ERROR_TYPEDEF_(0xC0350076)
#define ERROR_HV_NESTED_VM_EXIT                            _NDIS_ERROR_TYPEDEF_(0xC0350077)
#define ERROR_HV_MSR_ACCESS_FAILED                         _NDIS_ERROR_TYPEDEF_(0xC0350080)
#define ERROR_HV_INSUFFICIENT_MEMORY_MIRRORING             _NDIS_ERROR_TYPEDEF_(0xC0350081)
#define ERROR_HV_INSUFFICIENT_CONTIGUOUS_MEMORY_MIRRORING  _NDIS_ERROR_TYPEDEF_(0xC0350082)
#define ERROR_HV_INSUFFICIENT_CONTIGUOUS_ROOT_MEMORY       _NDIS_ERROR_TYPEDEF_(0xC0350083)
#define ERROR_HV_INSUFFICIENT_ROOT_MEMORY_MIRRORING        _NDIS_ERROR_TYPEDEF_(0xC0350084)
#define ERROR_HV_INSUFFICIENT_CONTIGUOUS_ROOT_MEMORY_MIRRORING _NDIS_ERROR_TYPEDEF_(0xC0350085)
#define ERROR_HV_NOT_PRESENT                               _NDIS_ERROR_TYPEDEF_(0xC0351000)

#define ERROR_VID_REMOTE_NODE_PARENT_GPA_PAGES_USED        _NDIS_ERROR_TYPEDEF_(0x80370001)
#define ERROR_VID_DUPLICATE_HANDLER                        _NDIS_ERROR_TYPEDEF_(0xC0370001)
#define ERROR_VID_TOO_MANY_HANDLERS                        _NDIS_ERROR_TYPEDEF_(0xC0370002)
#define ERROR_VID_QUEUE_FULL                               _NDIS_ERROR_TYPEDEF_(0xC0370003)
#define ERROR_VID_HANDLER_NOT_PRESENT                      _NDIS_ERROR_TYPEDEF_(0xC0370004)
#define ERROR_VID_INVALID_OBJECT_NAME                      _NDIS_ERROR_TYPEDEF_(0xC0370005)
#define ERROR_VID_PARTITION_NAME_TOO_LONG                  _NDIS_ERROR_TYPEDEF_(0xC0370006)
#define ERROR_VID_MESSAGE_QUEUE_NAME_TOO_LONG              _NDIS_ERROR_TYPEDEF_(0xC0370007)
#define ERROR_VID_PARTITION_ALREADY_EXISTS                 _NDIS_ERROR_TYPEDEF_(0xC0370008)
#define ERROR_VID_PARTITION_DOES_NOT_EXIST                 _NDIS_ERROR_TYPEDEF_(0xC0370009)
#define ERROR_VID_PARTITION_NAME_NOT_FOUND                 _NDIS_ERROR_TYPEDEF_(0xC037000A)
#define ERROR_VID_MESSAGE_QUEUE_ALREADY_EXISTS             _NDIS_ERROR_TYPEDEF_(0xC037000B)
#define ERROR_VID_EXCEEDED_MBP_ENTRY_MAP_LIMIT             _NDIS_ERROR_TYPEDEF_(0xC037000C)
#define ERROR_VID_MB_STILL_REFERENCED                      _NDIS_ERROR_TYPEDEF_(0xC037000D)
#define ERROR_VID_CHILD_GPA_PAGE_SET_CORRUPTED             _NDIS_ERROR_TYPEDEF_(0xC037000E)
#define ERROR_VID_INVALID_NUMA_SETTINGS                    _NDIS_ERROR_TYPEDEF_(0xC037000F)
#define ERROR_VID_INVALID_NUMA_NODE_INDEX                  _NDIS_ERROR_TYPEDEF_(0xC0370010)
#define ERROR_VID_NOTIFICATION_QUEUE_ALREADY_ASSOCIATED    _NDIS_ERROR_TYPEDEF_(0xC0370011)
#define ERROR_VID_INVALID_MEMORY_BLOCK_HANDLE              _NDIS_ERROR_TYPEDEF_(0xC0370012)
#define ERROR_VID_PAGE_RANGE_OVERFLOW                      _NDIS_ERROR_TYPEDEF_(0xC0370013)
#define ERROR_VID_INVALID_MESSAGE_QUEUE_HANDLE             _NDIS_ERROR_TYPEDEF_(0xC0370014)
#define ERROR_VID_INVALID_GPA_RANGE_HANDLE                 _NDIS_ERROR_TYPEDEF_(0xC0370015)
#define ERROR_VID_NO_MEMORY_BLOCK_NOTIFICATION_QUEUE       _NDIS_ERROR_TYPEDEF_(0xC0370016)
#define ERROR_VID_MEMORY_BLOCK_LOCK_COUNT_EXCEEDED         _NDIS_ERROR_TYPEDEF_(0xC0370017)
#define ERROR_VID_INVALID_PPM_HANDLE                       _NDIS_ERROR_TYPEDEF_(0xC0370018)
#define ERROR_VID_MBPS_ARE_LOCKED                          _NDIS_ERROR_TYPEDEF_(0xC0370019)
#define ERROR_VID_MESSAGE_QUEUE_CLOSED                     _NDIS_ERROR_TYPEDEF_(0xC037001A)
#define ERROR_VID_VIRTUAL_PROCESSOR_LIMIT_EXCEEDED         _NDIS_ERROR_TYPEDEF_(0xC037001B)
#define ERROR_VID_STOP_PENDING                             _NDIS_ERROR_TYPEDEF_(0xC037001C)
#define ERROR_VID_INVALID_PROCESSOR_STATE                  _NDIS_ERROR_TYPEDEF_(0xC037001D)
#define ERROR_VID_EXCEEDED_KM_CONTEXT_COUNT_LIMIT          _NDIS_ERROR_TYPEDEF_(0xC037001E)
#define ERROR_VID_KM_INTERFACE_ALREADY_INITIALIZED         _NDIS_ERROR_TYPEDEF_(0xC037001F)
#define ERROR_VID_MB_PROPERTY_ALREADY_SET_RESET            _NDIS_ERROR_TYPEDEF_(0xC0370020)
#define ERROR_VID_MMIO_RANGE_DESTROYED                     _NDIS_ERROR_TYPEDEF_(0xC0370021)
#define ERROR_VID_INVALID_CHILD_GPA_PAGE_SET               _NDIS_ERROR_TYPEDEF_(0xC0370022)
#define ERROR_VID_RESERVE_PAGE_SET_IS_BEING_USED           _NDIS_ERROR_TYPEDEF_(0xC0370023)
#define ERROR_VID_RESERVE_PAGE_SET_TOO_SMALL               _NDIS_ERROR_TYPEDEF_(0xC0370024)
#define ERROR_VID_MBP_ALREADY_LOCKED_USING_RESERVED_PAGE   _NDIS_ERROR_TYPEDEF_(0xC0370025)
#define ERROR_VID_MBP_COUNT_EXCEEDED_LIMIT                 _NDIS_ERROR_TYPEDEF_(0xC0370026)
#define ERROR_VID_SAVED_STATE_CORRUPT                      _NDIS_ERROR_TYPEDEF_(0xC0370027)
#define ERROR_VID_SAVED_STATE_UNRECOGNIZED_ITEM            _NDIS_ERROR_TYPEDEF_(0xC0370028)
#define ERROR_VID_SAVED_STATE_INCOMPATIBLE                 _NDIS_ERROR_TYPEDEF_(0xC0370029)
#define ERROR_VID_VTL_ACCESS_DENIED                        _NDIS_ERROR_TYPEDEF_(0xC037002A)
#define ERROR_VID_INSUFFICIENT_RESOURCES_RESERVE           _NDIS_ERROR_TYPEDEF_(0xC037002B)
#define ERROR_VID_INSUFFICIENT_RESOURCES_PHYSICAL_BUFFER   _NDIS_ERROR_TYPEDEF_(0xC037002C)
#define ERROR_VID_INSUFFICIENT_RESOURCES_HV_DEPOSIT        _NDIS_ERROR_TYPEDEF_(0xC037002D)
#define ERROR_VID_MEMORY_TYPE_NOT_SUPPORTED                _NDIS_ERROR_TYPEDEF_(0xC037002E)
#define ERROR_VID_INSUFFICIENT_RESOURCES_WITHDRAW          _NDIS_ERROR_TYPEDEF_(0xC037002F)
#define ERROR_VID_PROCESS_ALREADY_SET                      _NDIS_ERROR_TYPEDEF_(0xC0370030)
#define HCS_E_TERMINATED_DURING_START                      _HRESULT_TYPEDEF_(0x80370100)
#define ERROR_VMCOMPUTE_TERMINATED_DURING_START            _NDIS_ERROR_TYPEDEF_(0xC0370100)
#define HCS_E_IMAGE_MISMATCH                               _HRESULT_TYPEDEF_(0x80370101)
#define ERROR_VMCOMPUTE_IMAGE_MISMATCH                     _NDIS_ERROR_TYPEDEF_(0xC0370101)
#define HCS_E_HYPERV_NOT_INSTALLED                         _HRESULT_TYPEDEF_(0x80370102)
#define ERROR_VMCOMPUTE_HYPERV_NOT_INSTALLED               _NDIS_ERROR_TYPEDEF_(0xC0370102)
#define ERROR_VMCOMPUTE_OPERATION_PENDING                  _NDIS_ERROR_TYPEDEF_(0xC0370103)
#define ERROR_VMCOMPUTE_TOO_MANY_NOTIFICATIONS             _NDIS_ERROR_TYPEDEF_(0xC0370104)
#define HCS_E_INVALID_STATE                                _HRESULT_TYPEDEF_(0x80370105)
#define ERROR_VMCOMPUTE_INVALID_STATE                      _NDIS_ERROR_TYPEDEF_(0xC0370105)
#define HCS_E_UNEXPECTED_EXIT                              _HRESULT_TYPEDEF_(0x80370106)
#define ERROR_VMCOMPUTE_UNEXPECTED_EXIT                    _NDIS_ERROR_TYPEDEF_(0xC0370106)
#define HCS_E_TERMINATED                                   _HRESULT_TYPEDEF_(0x80370107)
#define ERROR_VMCOMPUTE_TERMINATED                         _NDIS_ERROR_TYPEDEF_(0xC0370107)
#define HCS_E_CONNECT_FAILED                               _HRESULT_TYPEDEF_(0x80370108)
#define ERROR_VMCOMPUTE_CONNECT_FAILED                     _NDIS_ERROR_TYPEDEF_(0xC0370108)
#define HCS_E_CONNECTION_TIMEOUT                           _HRESULT_TYPEDEF_(0x80370109)
#define ERROR_VMCOMPUTE_TIMEOUT                            _NDIS_ERROR_TYPEDEF_(0xC0370109)
#define HCS_E_CONNECTION_CLOSED                            _HRESULT_TYPEDEF_(0x8037010A)
#define ERROR_VMCOMPUTE_CONNECTION_CLOSED                  _NDIS_ERROR_TYPEDEF_(0xC037010A)
#define HCS_E_UNKNOWN_MESSAGE                              _HRESULT_TYPEDEF_(0x8037010B)
#define ERROR_VMCOMPUTE_UNKNOWN_MESSAGE                    _NDIS_ERROR_TYPEDEF_(0xC037010B)
#define HCS_E_UNSUPPORTED_PROTOCOL_VERSION                 _HRESULT_TYPEDEF_(0x8037010C)
#define ERROR_VMCOMPUTE_UNSUPPORTED_PROTOCOL_VERSION       _NDIS_ERROR_TYPEDEF_(0xC037010C)
#define HCS_E_INVALID_JSON                                 _HRESULT_TYPEDEF_(0x8037010D)
#define ERROR_VMCOMPUTE_INVALID_JSON                       _NDIS_ERROR_TYPEDEF_(0xC037010D)
#define HCS_E_SYSTEM_NOT_FOUND                             _HRESULT_TYPEDEF_(0x8037010E)
#define ERROR_VMCOMPUTE_SYSTEM_NOT_FOUND                   _NDIS_ERROR_TYPEDEF_(0xC037010E)
#define HCS_E_SYSTEM_ALREADY_EXISTS                        _HRESULT_TYPEDEF_(0x8037010F)
#define ERROR_VMCOMPUTE_SYSTEM_ALREADY_EXISTS              _NDIS_ERROR_TYPEDEF_(0xC037010F)
#define HCS_E_SYSTEM_ALREADY_STOPPED                       _HRESULT_TYPEDEF_(0x80370110)
#define ERROR_VMCOMPUTE_SYSTEM_ALREADY_STOPPED             _NDIS_ERROR_TYPEDEF_(0xC0370110)
#define HCS_E_PROTOCOL_ERROR                               _HRESULT_TYPEDEF_(0x80370111)
#define ERROR_VMCOMPUTE_PROTOCOL_ERROR                     _NDIS_ERROR_TYPEDEF_(0xC0370111)
#define HCS_E_INVALID_LAYER                                _HRESULT_TYPEDEF_(0x80370112)
#define ERROR_VMCOMPUTE_INVALID_LAYER                      _NDIS_ERROR_TYPEDEF_(0xC0370112)
#define HCS_E_WINDOWS_INSIDER_REQUIRED                     _HRESULT_TYPEDEF_(0x80370113)
#define ERROR_VMCOMPUTE_WINDOWS_INSIDER_REQUIRED           _NDIS_ERROR_TYPEDEF_(0xC0370113)
#define HCS_E_SERVICE_NOT_AVAILABLE                        _HRESULT_TYPEDEF_(0x80370114)
#define HCS_E_OPERATION_NOT_STARTED                        _HRESULT_TYPEDEF_(0x80370115)
#define HCS_E_OPERATION_ALREADY_STARTED                    _HRESULT_TYPEDEF_(0x80370116)
#define HCS_E_OPERATION_PENDING                            _HRESULT_TYPEDEF_(0x80370117)
#define HCS_E_OPERATION_TIMEOUT                            _HRESULT_TYPEDEF_(0x80370118)
#define HCS_E_OPERATION_SYSTEM_CALLBACK_ALREADY_SET        _HRESULT_TYPEDEF_(0x80370119)
#define HCS_E_OPERATION_RESULT_ALLOCATION_FAILED           _HRESULT_TYPEDEF_(0x8037011A)
#define HCS_E_ACCESS_DENIED                                _HRESULT_TYPEDEF_(0x8037011B)
#define HCS_E_GUEST_CRITICAL_ERROR                         _HRESULT_TYPEDEF_(0x8037011C)
#define HCS_E_PROCESS_INFO_NOT_AVAILABLE                   _HRESULT_TYPEDEF_(0x8037011D)
#define HCS_E_SERVICE_DISCONNECT                           _HRESULT_TYPEDEF_(0x8037011E)
#define HCS_E_PROCESS_ALREADY_STOPPED                      _HRESULT_TYPEDEF_(0x8037011F)
#define HCS_E_SYSTEM_NOT_CONFIGURED_FOR_OPERATION          _HRESULT_TYPEDEF_(0x80370120)
#define HCS_E_OPERATION_ALREADY_CANCELLED                  _HRESULT_TYPEDEF_(0x80370121)
#define ERROR_VNET_VIRTUAL_SWITCH_NAME_NOT_FOUND           _NDIS_ERROR_TYPEDEF_(0xC0370200)
#define WHV_E_UNKNOWN_CAPABILITY                           _HRESULT_TYPEDEF_(0x80370300)
#define WHV_E_INSUFFICIENT_BUFFER                          _HRESULT_TYPEDEF_(0x80370301)
#define WHV_E_UNKNOWN_PROPERTY                             _HRESULT_TYPEDEF_(0x80370302)
#define WHV_E_UNSUPPORTED_HYPERVISOR_CONFIG                _HRESULT_TYPEDEF_(0x80370303)
#define WHV_E_INVALID_PARTITION_CONFIG                     _HRESULT_TYPEDEF_(0x80370304)
#define WHV_E_GPA_RANGE_NOT_FOUND                          _HRESULT_TYPEDEF_(0x80370305)
#define WHV_E_VP_ALREADY_EXISTS                            _HRESULT_TYPEDEF_(0x80370306)
#define WHV_E_VP_DOES_NOT_EXIST                            _HRESULT_TYPEDEF_(0x80370307)
#define WHV_E_INVALID_VP_STATE                             _HRESULT_TYPEDEF_(0x80370308)
#define WHV_E_INVALID_VP_REGISTER_NAME                     _HRESULT_TYPEDEF_(0x80370309)
#define WHV_E_UNSUPPORTED_PROCESSOR_CONFIG                 _HRESULT_TYPEDEF_(0x80370310)
#define ERROR_VSMB_SAVED_STATE_FILE_NOT_FOUND              _NDIS_ERROR_TYPEDEF_(0xC0370400)
#define ERROR_VSMB_SAVED_STATE_CORRUPT                     _NDIS_ERROR_TYPEDEF_(0xC0370401)
#define VM_SAVED_STATE_DUMP_E_PARTITION_STATE_NOT_FOUND    _HRESULT_TYPEDEF_(0xC0370500)
#define VM_SAVED_STATE_DUMP_E_GUEST_MEMORY_NOT_FOUND       _HRESULT_TYPEDEF_(0xC0370501)
#define VM_SAVED_STATE_DUMP_E_NO_VP_FOUND_IN_PARTITION_STATE _HRESULT_TYPEDEF_(0xC0370502)
#define VM_SAVED_STATE_DUMP_E_NESTED_VIRTUALIZATION_NOT_SUPPORTED _HRESULT_TYPEDEF_(0xC0370503)
#define VM_SAVED_STATE_DUMP_E_WINDOWS_KERNEL_IMAGE_NOT_FOUND _HRESULT_TYPEDEF_(0xC0370504)
#define VM_SAVED_STATE_DUMP_E_VA_NOT_MAPPED                _HRESULT_TYPEDEF_(0xC0370505)
#define VM_SAVED_STATE_DUMP_E_INVALID_VP_STATE             _HRESULT_TYPEDEF_(0xC0370506)
#define VM_SAVED_STATE_DUMP_E_VP_VTL_NOT_ENABLED           _HRESULT_TYPEDEF_(0xC0370509)
#define ERROR_DM_OPERATION_LIMIT_EXCEEDED                  _HRESULT_TYPEDEF_(0xC0370600)

#define ERROR_VOLMGR_INCOMPLETE_REGENERATION               _NDIS_ERROR_TYPEDEF_(0x80380001)
#define ERROR_VOLMGR_DATABASE_FULL                         _NDIS_ERROR_TYPEDEF_(0xC0380001)
#define ERROR_VOLMGR_INCOMPLETE_DISK_MIGRATION             _NDIS_ERROR_TYPEDEF_(0x80380002)
#define ERROR_VOLMGR_DISK_CONFIGURATION_CORRUPTED          _NDIS_ERROR_TYPEDEF_(0xC0380002)
#define ERROR_VOLMGR_DISK_CONFIGURATION_NOT_IN_SYNC        _NDIS_ERROR_TYPEDEF_(0xC0380003)
#define ERROR_VOLMGR_PACK_CONFIG_UPDATE_FAILED             _NDIS_ERROR_TYPEDEF_(0xC0380004)
#define ERROR_VOLMGR_DISK_CONTAINS_NON_SIMPLE_VOLUME       _NDIS_ERROR_TYPEDEF_(0xC0380005)
#define ERROR_VOLMGR_DISK_DUPLICATE                        _NDIS_ERROR_TYPEDEF_(0xC0380006)
#define ERROR_VOLMGR_DISK_DYNAMIC                          _NDIS_ERROR_TYPEDEF_(0xC0380007)
#define ERROR_VOLMGR_DISK_ID_INVALID                       _NDIS_ERROR_TYPEDEF_(0xC0380008)
#define ERROR_VOLMGR_DISK_INVALID                          _NDIS_ERROR_TYPEDEF_(0xC0380009)
#define ERROR_VOLMGR_DISK_LAST_VOTER                       _NDIS_ERROR_TYPEDEF_(0xC038000A)
#define ERROR_VOLMGR_DISK_LAYOUT_INVALID                   _NDIS_ERROR_TYPEDEF_(0xC038000B)
#define ERROR_VOLMGR_DISK_LAYOUT_NON_BASIC_BETWEEN_BASIC_PARTITIONS _NDIS_ERROR_TYPEDEF_(0xC038000C)
#define ERROR_VOLMGR_DISK_LAYOUT_NOT_CYLINDER_ALIGNED      _NDIS_ERROR_TYPEDEF_(0xC038000D)
#define ERROR_VOLMGR_DISK_LAYOUT_PARTITIONS_TOO_SMALL      _NDIS_ERROR_TYPEDEF_(0xC038000E)
#define ERROR_VOLMGR_DISK_LAYOUT_PRIMARY_BETWEEN_LOGICAL_PARTITIONS _NDIS_ERROR_TYPEDEF_(0xC038000F)
#define ERROR_VOLMGR_DISK_LAYOUT_TOO_MANY_PARTITIONS       _NDIS_ERROR_TYPEDEF_(0xC0380010)
#define ERROR_VOLMGR_DISK_MISSING                          _NDIS_ERROR_TYPEDEF_(0xC0380011)
#define ERROR_VOLMGR_DISK_NOT_EMPTY                        _NDIS_ERROR_TYPEDEF_(0xC0380012)
#define ERROR_VOLMGR_DISK_NOT_ENOUGH_SPACE                 _NDIS_ERROR_TYPEDEF_(0xC0380013)
#define ERROR_VOLMGR_DISK_REVECTORING_FAILED               _NDIS_ERROR_TYPEDEF_(0xC0380014)
#define ERROR_VOLMGR_DISK_SECTOR_SIZE_INVALID              _NDIS_ERROR_TYPEDEF_(0xC0380015)
#define ERROR_VOLMGR_DISK_SET_NOT_CONTAINED                _NDIS_ERROR_TYPEDEF_(0xC0380016)
#define ERROR_VOLMGR_DISK_USED_BY_MULTIPLE_MEMBERS         _NDIS_ERROR_TYPEDEF_(0xC0380017)
#define ERROR_VOLMGR_DISK_USED_BY_MULTIPLE_PLEXES          _NDIS_ERROR_TYPEDEF_(0xC0380018)
#define ERROR_VOLMGR_DYNAMIC_DISK_NOT_SUPPORTED            _NDIS_ERROR_TYPEDEF_(0xC0380019)
#define ERROR_VOLMGR_EXTENT_ALREADY_USED                   _NDIS_ERROR_TYPEDEF_(0xC038001A)
#define ERROR_VOLMGR_EXTENT_NOT_CONTIGUOUS                 _NDIS_ERROR_TYPEDEF_(0xC038001B)
#define ERROR_VOLMGR_EXTENT_NOT_IN_PUBLIC_REGION           _NDIS_ERROR_TYPEDEF_(0xC038001C)
#define ERROR_VOLMGR_EXTENT_NOT_SECTOR_ALIGNED             _NDIS_ERROR_TYPEDEF_(0xC038001D)
#define ERROR_VOLMGR_EXTENT_OVERLAPS_EBR_PARTITION         _NDIS_ERROR_TYPEDEF_(0xC038001E)
#define ERROR_VOLMGR_EXTENT_VOLUME_LENGTHS_DO_NOT_MATCH    _NDIS_ERROR_TYPEDEF_(0xC038001F)
#define ERROR_VOLMGR_FAULT_TOLERANT_NOT_SUPPORTED          _NDIS_ERROR_TYPEDEF_(0xC0380020)
#define ERROR_VOLMGR_INTERLEAVE_LENGTH_INVALID             _NDIS_ERROR_TYPEDEF_(0xC0380021)
#define ERROR_VOLMGR_MAXIMUM_REGISTERED_USERS              _NDIS_ERROR_TYPEDEF_(0xC0380022)
#define ERROR_VOLMGR_MEMBER_IN_SYNC                        _NDIS_ERROR_TYPEDEF_(0xC0380023)
#define ERROR_VOLMGR_MEMBER_INDEX_DUPLICATE                _NDIS_ERROR_TYPEDEF_(0xC0380024)
#define ERROR_VOLMGR_MEMBER_INDEX_INVALID                  _NDIS_ERROR_TYPEDEF_(0xC0380025)
#define ERROR_VOLMGR_MEMBER_MISSING                        _NDIS_ERROR_TYPEDEF_(0xC0380026)
#define ERROR_VOLMGR_MEMBER_NOT_DETACHED                   _NDIS_ERROR_TYPEDEF_(0xC0380027)
#define ERROR_VOLMGR_MEMBER_REGENERATING                   _NDIS_ERROR_TYPEDEF_(0xC0380028)
#define ERROR_VOLMGR_ALL_DISKS_FAILED                      _NDIS_ERROR_TYPEDEF_(0xC0380029)
#define ERROR_VOLMGR_NO_REGISTERED_USERS                   _NDIS_ERROR_TYPEDEF_(0xC038002A)
#define ERROR_VOLMGR_NO_SUCH_USER                          _NDIS_ERROR_TYPEDEF_(0xC038002B)
#define ERROR_VOLMGR_NOTIFICATION_RESET                    _NDIS_ERROR_TYPEDEF_(0xC038002C)
#define ERROR_VOLMGR_NUMBER_OF_MEMBERS_INVALID             _NDIS_ERROR_TYPEDEF_(0xC038002D)
#define ERROR_VOLMGR_NUMBER_OF_PLEXES_INVALID              _NDIS_ERROR_TYPEDEF_(0xC038002E)
#define ERROR_VOLMGR_PACK_DUPLICATE                        _NDIS_ERROR_TYPEDEF_(0xC038002F)
#define ERROR_VOLMGR_PACK_ID_INVALID                       _NDIS_ERROR_TYPEDEF_(0xC0380030)
#define ERROR_VOLMGR_PACK_INVALID                          _NDIS_ERROR_TYPEDEF_(0xC0380031)
#define ERROR_VOLMGR_PACK_NAME_INVALID                     _NDIS_ERROR_TYPEDEF_(0xC0380032)
#define ERROR_VOLMGR_PACK_OFFLINE                          _NDIS_ERROR_TYPEDEF_(0xC0380033)
#define ERROR_VOLMGR_PACK_HAS_QUORUM                       _NDIS_ERROR_TYPEDEF_(0xC0380034)
#define ERROR_VOLMGR_PACK_WITHOUT_QUORUM                   _NDIS_ERROR_TYPEDEF_(0xC0380035)
#define ERROR_VOLMGR_PARTITION_STYLE_INVALID               _NDIS_ERROR_TYPEDEF_(0xC0380036)
#define ERROR_VOLMGR_PARTITION_UPDATE_FAILED               _NDIS_ERROR_TYPEDEF_(0xC0380037)
#define ERROR_VOLMGR_PLEX_IN_SYNC                          _NDIS_ERROR_TYPEDEF_(0xC0380038)
#define ERROR_VOLMGR_PLEX_INDEX_DUPLICATE                  _NDIS_ERROR_TYPEDEF_(0xC0380039)
#define ERROR_VOLMGR_PLEX_INDEX_INVALID                    _NDIS_ERROR_TYPEDEF_(0xC038003A)
#define ERROR_VOLMGR_PLEX_LAST_ACTIVE                      _NDIS_ERROR_TYPEDEF_(0xC038003B)
#define ERROR_VOLMGR_PLEX_MISSING                          _NDIS_ERROR_TYPEDEF_(0xC038003C)
#define ERROR_VOLMGR_PLEX_REGENERATING                     _NDIS_ERROR_TYPEDEF_(0xC038003D)
#define ERROR_VOLMGR_PLEX_TYPE_INVALID                     _NDIS_ERROR_TYPEDEF_(0xC038003E)
#define ERROR_VOLMGR_PLEX_NOT_RAID5                        _NDIS_ERROR_TYPEDEF_(0xC038003F)
#define ERROR_VOLMGR_PLEX_NOT_SIMPLE                       _NDIS_ERROR_TYPEDEF_(0xC0380040)
#define ERROR_VOLMGR_STRUCTURE_SIZE_INVALID                _NDIS_ERROR_TYPEDEF_(0xC0380041)
#define ERROR_VOLMGR_TOO_MANY_NOTIFICATION_REQUESTS        _NDIS_ERROR_TYPEDEF_(0xC0380042)
#define ERROR_VOLMGR_TRANSACTION_IN_PROGRESS               _NDIS_ERROR_TYPEDEF_(0xC0380043)
#define ERROR_VOLMGR_UNEXPECTED_DISK_LAYOUT_CHANGE         _NDIS_ERROR_TYPEDEF_(0xC0380044)
#define ERROR_VOLMGR_VOLUME_CONTAINS_MISSING_DISK          _NDIS_ERROR_TYPEDEF_(0xC0380045)
#define ERROR_VOLMGR_VOLUME_ID_INVALID                     _NDIS_ERROR_TYPEDEF_(0xC0380046)
#define ERROR_VOLMGR_VOLUME_LENGTH_INVALID                 _NDIS_ERROR_TYPEDEF_(0xC0380047)
#define ERROR_VOLMGR_VOLUME_LENGTH_NOT_SECTOR_SIZE_MULTIPLE _NDIS_ERROR_TYPEDEF_(0xC0380048)
#define ERROR_VOLMGR_VOLUME_NOT_MIRRORED                   _NDIS_ERROR_TYPEDEF_(0xC0380049)
#define ERROR_VOLMGR_VOLUME_NOT_RETAINED                   _NDIS_ERROR_TYPEDEF_(0xC038004A)
#define ERROR_VOLMGR_VOLUME_OFFLINE                        _NDIS_ERROR_TYPEDEF_(0xC038004B)
#define ERROR_VOLMGR_VOLUME_RETAINED                       _NDIS_ERROR_TYPEDEF_(0xC038004C)
#define ERROR_VOLMGR_NUMBER_OF_EXTENTS_INVALID             _NDIS_ERROR_TYPEDEF_(0xC038004D)
#define ERROR_VOLMGR_DIFFERENT_SECTOR_SIZE                 _NDIS_ERROR_TYPEDEF_(0xC038004E)
#define ERROR_VOLMGR_BAD_BOOT_DISK                         _NDIS_ERROR_TYPEDEF_(0xC038004F)
#define ERROR_VOLMGR_PACK_CONFIG_OFFLINE                   _NDIS_ERROR_TYPEDEF_(0xC0380050)
#define ERROR_VOLMGR_PACK_CONFIG_ONLINE                    _NDIS_ERROR_TYPEDEF_(0xC0380051)
#define ERROR_VOLMGR_NOT_PRIMARY_PACK                      _NDIS_ERROR_TYPEDEF_(0xC0380052)
#define ERROR_VOLMGR_PACK_LOG_UPDATE_FAILED                _NDIS_ERROR_TYPEDEF_(0xC0380053)
#define ERROR_VOLMGR_NUMBER_OF_DISKS_IN_PLEX_INVALID       _NDIS_ERROR_TYPEDEF_(0xC0380054)
#define ERROR_VOLMGR_NUMBER_OF_DISKS_IN_MEMBER_INVALID     _NDIS_ERROR_TYPEDEF_(0xC0380055)
#define ERROR_VOLMGR_VOLUME_MIRRORED                       _NDIS_ERROR_TYPEDEF_(0xC0380056)
#define ERROR_VOLMGR_PLEX_NOT_SIMPLE_SPANNED               _NDIS_ERROR_TYPEDEF_(0xC0380057)
#define ERROR_VOLMGR_NO_VALID_LOG_COPIES                   _NDIS_ERROR_TYPEDEF_(0xC0380058)
#define ERROR_VOLMGR_PRIMARY_PACK_PRESENT                  _NDIS_ERROR_TYPEDEF_(0xC0380059)
#define ERROR_VOLMGR_NUMBER_OF_DISKS_INVALID               _NDIS_ERROR_TYPEDEF_(0xC038005A)
#define ERROR_VOLMGR_MIRROR_NOT_SUPPORTED                  _NDIS_ERROR_TYPEDEF_(0xC038005B)
#define ERROR_VOLMGR_RAID5_NOT_SUPPORTED                   _NDIS_ERROR_TYPEDEF_(0xC038005C)

#define ERROR_BCD_NOT_ALL_ENTRIES_IMPORTED                 _NDIS_ERROR_TYPEDEF_(0x80390001)
#define ERROR_BCD_TOO_MANY_ELEMENTS                        _NDIS_ERROR_TYPEDEF_(0xC0390002)
#define ERROR_BCD_NOT_ALL_ENTRIES_SYNCHRONIZED             _NDIS_ERROR_TYPEDEF_(0x80390003)

#define ERROR_QUERY_STORAGE_ERROR                          _NDIS_ERROR_TYPEDEF_(0x803A0001)
#define ERROR_VHD_DRIVE_FOOTER_MISSING                     _NDIS_ERROR_TYPEDEF_(0xC03A0001)
#define ERROR_VHD_DRIVE_FOOTER_CHECKSUM_MISMATCH           _NDIS_ERROR_TYPEDEF_(0xC03A0002)
#define ERROR_VHD_DRIVE_FOOTER_CORRUPT                     _NDIS_ERROR_TYPEDEF_(0xC03A0003)
#define ERROR_VHD_FORMAT_UNKNOWN                           _NDIS_ERROR_TYPEDEF_(0xC03A0004)
#define ERROR_VHD_FORMAT_UNSUPPORTED_VERSION               _NDIS_ERROR_TYPEDEF_(0xC03A0005)
#define ERROR_VHD_SPARSE_HEADER_CHECKSUM_MISMATCH          _NDIS_ERROR_TYPEDEF_(0xC03A0006)
#define ERROR_VHD_SPARSE_HEADER_UNSUPPORTED_VERSION        _NDIS_ERROR_TYPEDEF_(0xC03A0007)
#define ERROR_VHD_SPARSE_HEADER_CORRUPT                    _NDIS_ERROR_TYPEDEF_(0xC03A0008)
#define ERROR_VHD_BLOCK_ALLOCATION_FAILURE                 _NDIS_ERROR_TYPEDEF_(0xC03A0009)
#define ERROR_VHD_BLOCK_ALLOCATION_TABLE_CORRUPT           _NDIS_ERROR_TYPEDEF_(0xC03A000A)
#define ERROR_VHD_INVALID_BLOCK_SIZE                       _NDIS_ERROR_TYPEDEF_(0xC03A000B)
#define ERROR_VHD_BITMAP_MISMATCH                          _NDIS_ERROR_TYPEDEF_(0xC03A000C)
#define ERROR_VHD_PARENT_VHD_NOT_FOUND                     _NDIS_ERROR_TYPEDEF_(0xC03A000D)
#define ERROR_VHD_CHILD_PARENT_ID_MISMATCH                 _NDIS_ERROR_TYPEDEF_(0xC03A000E)
#define ERROR_VHD_CHILD_PARENT_TIMESTAMP_MISMATCH          _NDIS_ERROR_TYPEDEF_(0xC03A000F)
#define ERROR_VHD_METADATA_READ_FAILURE                    _NDIS_ERROR_TYPEDEF_(0xC03A0010)
#define ERROR_VHD_METADATA_WRITE_FAILURE                   _NDIS_ERROR_TYPEDEF_(0xC03A0011)
#define ERROR_VHD_INVALID_SIZE                             _NDIS_ERROR_TYPEDEF_(0xC03A0012)
#define ERROR_VHD_INVALID_FILE_SIZE                        _NDIS_ERROR_TYPEDEF_(0xC03A0013)
#define ERROR_VIRTDISK_PROVIDER_NOT_FOUND                  _NDIS_ERROR_TYPEDEF_(0xC03A0014)
#define ERROR_VIRTDISK_NOT_VIRTUAL_DISK                    _NDIS_ERROR_TYPEDEF_(0xC03A0015)
#define ERROR_VHD_PARENT_VHD_ACCESS_DENIED                 _NDIS_ERROR_TYPEDEF_(0xC03A0016)
#define ERROR_VHD_CHILD_PARENT_SIZE_MISMATCH               _NDIS_ERROR_TYPEDEF_(0xC03A0017)
#define ERROR_VHD_DIFFERENCING_CHAIN_CYCLE_DETECTED        _NDIS_ERROR_TYPEDEF_(0xC03A0018)
#define ERROR_VHD_DIFFERENCING_CHAIN_ERROR_IN_PARENT       _NDIS_ERROR_TYPEDEF_(0xC03A0019)
#define ERROR_VIRTUAL_DISK_LIMITATION                      _NDIS_ERROR_TYPEDEF_(0xC03A001A)
#define ERROR_VHD_INVALID_TYPE                             _NDIS_ERROR_TYPEDEF_(0xC03A001B)
#define ERROR_VHD_INVALID_STATE                            _NDIS_ERROR_TYPEDEF_(0xC03A001C)
#define ERROR_VIRTDISK_UNSUPPORTED_DISK_SECTOR_SIZE        _NDIS_ERROR_TYPEDEF_(0xC03A001D)
#define ERROR_VIRTDISK_DISK_ALREADY_OWNED                  _NDIS_ERROR_TYPEDEF_(0xC03A001E)
#define ERROR_VIRTDISK_DISK_ONLINE_AND_WRITABLE            _NDIS_ERROR_TYPEDEF_(0xC03A001F)
#define ERROR_CTLOG_TRACKING_NOT_INITIALIZED               _NDIS_ERROR_TYPEDEF_(0xC03A0020)
#define ERROR_CTLOG_LOGFILE_SIZE_EXCEEDED_MAXSIZE          _NDIS_ERROR_TYPEDEF_(0xC03A0021)
#define ERROR_CTLOG_VHD_CHANGED_OFFLINE                    _NDIS_ERROR_TYPEDEF_(0xC03A0022)
#define ERROR_CTLOG_INVALID_TRACKING_STATE                 _NDIS_ERROR_TYPEDEF_(0xC03A0023)
#define ERROR_CTLOG_INCONSISTENT_TRACKING_FILE             _NDIS_ERROR_TYPEDEF_(0xC03A0024)
#define ERROR_VHD_RESIZE_WOULD_TRUNCATE_DATA               _NDIS_ERROR_TYPEDEF_(0xC03A0025)
#define ERROR_VHD_COULD_NOT_COMPUTE_MINIMUM_VIRTUAL_SIZE   _NDIS_ERROR_TYPEDEF_(0xC03A0026)
#define ERROR_VHD_ALREADY_AT_OR_BELOW_MINIMUM_VIRTUAL_SIZE _NDIS_ERROR_TYPEDEF_(0xC03A0027)
#define ERROR_VHD_METADATA_FULL                            _NDIS_ERROR_TYPEDEF_(0xC03A0028)
#define ERROR_VHD_INVALID_CHANGE_TRACKING_ID               _NDIS_ERROR_TYPEDEF_(0xC03A0029)
#define ERROR_VHD_CHANGE_TRACKING_DISABLED                 _NDIS_ERROR_TYPEDEF_(0xC03A002A)
#define ERROR_VHD_MISSING_CHANGE_TRACKING_INFORMATION      _NDIS_ERROR_TYPEDEF_(0xC03A0030)

#define HCN_E_NETWORK_NOT_FOUND                            _HRESULT_TYPEDEF_(0x803B0001)
#define HCN_E_ENDPOINT_NOT_FOUND                           _HRESULT_TYPEDEF_(0x803B0002)
#define HCN_E_LAYER_NOT_FOUND                              _HRESULT_TYPEDEF_(0x803B0003)
#define HCN_E_SWITCH_NOT_FOUND                             _HRESULT_TYPEDEF_(0x803B0004)
#define HCN_E_SUBNET_NOT_FOUND                             _HRESULT_TYPEDEF_(0x803B0005)
#define HCN_E_ADAPTER_NOT_FOUND                            _HRESULT_TYPEDEF_(0x803B0006)
#define HCN_E_PORT_NOT_FOUND                               _HRESULT_TYPEDEF_(0x803B0007)
#define HCN_E_POLICY_NOT_FOUND                             _HRESULT_TYPEDEF_(0x803B0008)
#define HCN_E_VFP_PORTSETTING_NOT_FOUND                    _HRESULT_TYPEDEF_(0x803B0009)
#define HCN_E_INVALID_NETWORK                              _HRESULT_TYPEDEF_(0x803B000A)
#define HCN_E_INVALID_NETWORK_TYPE                         _HRESULT_TYPEDEF_(0x803B000B)
#define HCN_E_INVALID_ENDPOINT                             _HRESULT_TYPEDEF_(0x803B000C)
#define HCN_E_INVALID_POLICY                               _HRESULT_TYPEDEF_(0x803B000D)
#define HCN_E_INVALID_POLICY_TYPE                          _HRESULT_TYPEDEF_(0x803B000E)
#define HCN_E_INVALID_REMOTE_ENDPOINT_OPERATION            _HRESULT_TYPEDEF_(0x803B000F)
#define HCN_E_NETWORK_ALREADY_EXISTS                       _HRESULT_TYPEDEF_(0x803B0010)
#define HCN_E_LAYER_ALREADY_EXISTS                         _HRESULT_TYPEDEF_(0x803B0011)
#define HCN_E_POLICY_ALREADY_EXISTS                        _HRESULT_TYPEDEF_(0x803B0012)
#define HCN_E_PORT_ALREADY_EXISTS                          _HRESULT_TYPEDEF_(0x803B0013)
#define HCN_E_ENDPOINT_ALREADY_ATTACHED                    _HRESULT_TYPEDEF_(0x803B0014)
#define HCN_E_REQUEST_UNSUPPORTED                          _HRESULT_TYPEDEF_(0x803B0015)
#define HCN_E_MAPPING_NOT_SUPPORTED                        _HRESULT_TYPEDEF_(0x803B0016)
#define HCN_E_DEGRADED_OPERATION                           _HRESULT_TYPEDEF_(0x803B0017)
#define HCN_E_SHARED_SWITCH_MODIFICATION                   _HRESULT_TYPEDEF_(0x803B0018)
#define HCN_E_GUID_CONVERSION_FAILURE                      _HRESULT_TYPEDEF_(0x803B0019)
#define HCN_E_REGKEY_FAILURE                               _HRESULT_TYPEDEF_(0x803B001A)
#define HCN_E_INVALID_JSON                                 _HRESULT_TYPEDEF_(0x803B001B)
#define HCN_E_INVALID_JSON_REFERENCE                       _HRESULT_TYPEDEF_(0x803B001C)
#define HCN_E_ENDPOINT_SHARING_DISABLED                    _HRESULT_TYPEDEF_(0x803B001D)
#define HCN_E_INVALID_IP                                   _HRESULT_TYPEDEF_(0x803B001E)
#define HCN_E_SWITCH_EXTENSION_NOT_FOUND                   _HRESULT_TYPEDEF_(0x803B001F)
#define HCN_E_MANAGER_STOPPED                              _HRESULT_TYPEDEF_(0x803B0020)
#define GCN_E_MODULE_NOT_FOUND                             _HRESULT_TYPEDEF_(0x803B0021)
#define GCN_E_NO_REQUEST_HANDLERS                          _HRESULT_TYPEDEF_(0x803B0022)
#define GCN_E_REQUEST_UNSUPPORTED                          _HRESULT_TYPEDEF_(0x803B0023)
#define GCN_E_RUNTIMEKEYS_FAILED                           _HRESULT_TYPEDEF_(0x803B0024)
#define GCN_E_NETADAPTER_TIMEOUT                           _HRESULT_TYPEDEF_(0x803B0025)
#define GCN_E_NETADAPTER_NOT_FOUND                         _HRESULT_TYPEDEF_(0x803B0026)
#define GCN_E_NETCOMPARTMENT_NOT_FOUND                     _HRESULT_TYPEDEF_(0x803B0027)
#define GCN_E_NETINTERFACE_NOT_FOUND                       _HRESULT_TYPEDEF_(0x803B0028)
#define GCN_E_DEFAULTNAMESPACE_EXISTS                      _HRESULT_TYPEDEF_(0x803B0029)
#define HCN_E_ICS_DISABLED                                 _HRESULT_TYPEDEF_(0x803B002A)
#define HCN_E_ENDPOINT_NAMESPACE_ALREADY_EXISTS            _HRESULT_TYPEDEF_(0x803B002B)
#define HCN_E_ENTITY_HAS_REFERENCES                        _HRESULT_TYPEDEF_(0x803B002C)
#define HCN_E_INVALID_INTERNAL_PORT                        _HRESULT_TYPEDEF_(0x803B002D)
#define HCN_E_NAMESPACE_ATTACH_FAILED                      _HRESULT_TYPEDEF_(0x803B002E)
#define HCN_E_ADDR_INVALID_OR_RESERVED                     _HRESULT_TYPEDEF_(0x803B002F)
#define HCN_E_INVALID_PREFIX                               _HRESULT_TYPEDEF_(0x803B0030)
#define HCN_E_OBJECT_USED_AFTER_UNLOAD                     _HRESULT_TYPEDEF_(0x803B0031)
#define HCN_E_INVALID_SUBNET                               _HRESULT_TYPEDEF_(0x803B0032)
#define HCN_E_INVALID_IP_SUBNET                            _HRESULT_TYPEDEF_(0x803B0033)
#define HCN_E_ENDPOINT_NOT_ATTACHED                        _HRESULT_TYPEDEF_(0x803B0034)
#define HCN_E_ENDPOINT_NOT_LOCAL                           _HRESULT_TYPEDEF_(0x803B0035)
#define HCN_INTERFACEPARAMETERS_ALREADY_APPLIED            _HRESULT_TYPEDEF_(0x803B0036)
#define HCN_E_VFP_NOT_ALLOWED                              _HRESULT_TYPEDEF_(0x803B0037)

#define SDIAG_E_CANCELLED                                  _NDIS_ERROR_TYPEDEF_(0x803C0100)
#define SDIAG_E_SCRIPT                                     _NDIS_ERROR_TYPEDEF_(0x803C0101)
#define SDIAG_E_POWERSHELL                                 _NDIS_ERROR_TYPEDEF_(0x803C0102)
#define SDIAG_E_MANAGEDHOST                                _NDIS_ERROR_TYPEDEF_(0x803C0103)
#define SDIAG_E_NOVERIFIER                                 _NDIS_ERROR_TYPEDEF_(0x803C0104)
#define SDIAG_S_CANNOTRUN                                  _NDIS_ERROR_TYPEDEF_(0x003C0105)
#define SDIAG_E_DISABLED                                   _NDIS_ERROR_TYPEDEF_(0x803C0106)
#define SDIAG_E_TRUST                                      _NDIS_ERROR_TYPEDEF_(0x803C0107)
#define SDIAG_E_CANNOTRUN                                  _NDIS_ERROR_TYPEDEF_(0x803C0108)
#define SDIAG_E_VERSION                                    _NDIS_ERROR_TYPEDEF_(0x803C0109)
#define SDIAG_E_RESOURCE                                   _NDIS_ERROR_TYPEDEF_(0x803C010A)
#define SDIAG_E_ROOTCAUSE                                  _NDIS_ERROR_TYPEDEF_(0x803C010B)

#define WS_S_ASYNC                                         _HRESULT_TYPEDEF_(0x003D0000)
#define WS_E_INVALID_FORMAT                                _HRESULT_TYPEDEF_(0x803D0000)
#define WS_S_END                                           _HRESULT_TYPEDEF_(0x003D0001)
#define WS_E_OBJECT_FAULTED                                _HRESULT_TYPEDEF_(0x803D0001)
#define WS_E_NUMERIC_OVERFLOW                              _HRESULT_TYPEDEF_(0x803D0002)
#define WS_E_INVALID_OPERATION                             _HRESULT_TYPEDEF_(0x803D0003)
#define WS_E_OPERATION_ABORTED                             _HRESULT_TYPEDEF_(0x803D0004)
#define WS_E_ENDPOINT_ACCESS_DENIED                        _HRESULT_TYPEDEF_(0x803D0005)
#define WS_E_OPERATION_TIMED_OUT                           _HRESULT_TYPEDEF_(0x803D0006)
#define WS_E_OPERATION_ABANDONED                           _HRESULT_TYPEDEF_(0x803D0007)
#define WS_E_QUOTA_EXCEEDED                                _HRESULT_TYPEDEF_(0x803D0008)
#define WS_E_NO_TRANSLATION_AVAILABLE                      _HRESULT_TYPEDEF_(0x803D0009)
#define WS_E_SECURITY_VERIFICATION_FAILURE                 _HRESULT_TYPEDEF_(0x803D000A)
#define WS_E_ADDRESS_IN_USE                                _HRESULT_TYPEDEF_(0x803D000B)
#define WS_E_ADDRESS_NOT_AVAILABLE                         _HRESULT_TYPEDEF_(0x803D000C)
#define WS_E_ENDPOINT_NOT_FOUND                            _HRESULT_TYPEDEF_(0x803D000D)
#define WS_E_ENDPOINT_NOT_AVAILABLE                        _HRESULT_TYPEDEF_(0x803D000E)
#define WS_E_ENDPOINT_FAILURE                              _HRESULT_TYPEDEF_(0x803D000F)
#define WS_E_ENDPOINT_UNREACHABLE                          _HRESULT_TYPEDEF_(0x803D0010)
#define WS_E_ENDPOINT_ACTION_NOT_SUPPORTED                 _HRESULT_TYPEDEF_(0x803D0011)
#define WS_E_ENDPOINT_TOO_BUSY                             _HRESULT_TYPEDEF_(0x803D0012)
#define WS_E_ENDPOINT_FAULT_RECEIVED                       _HRESULT_TYPEDEF_(0x803D0013)
#define WS_E_ENDPOINT_DISCONNECTED                         _HRESULT_TYPEDEF_(0x803D0014)
#define WS_E_PROXY_FAILURE                                 _HRESULT_TYPEDEF_(0x803D0015)
#define WS_E_PROXY_ACCESS_DENIED                           _HRESULT_TYPEDEF_(0x803D0016)
#define WS_E_NOT_SUPPORTED                                 _HRESULT_TYPEDEF_(0x803D0017)
#define WS_E_PROXY_REQUIRES_BASIC_AUTH                     _HRESULT_TYPEDEF_(0x803D0018)
#define WS_E_PROXY_REQUIRES_DIGEST_AUTH                    _HRESULT_TYPEDEF_(0x803D0019)
#define WS_E_PROXY_REQUIRES_NTLM_AUTH                      _HRESULT_TYPEDEF_(0x803D001A)
#define WS_E_PROXY_REQUIRES_NEGOTIATE_AUTH                 _HRESULT_TYPEDEF_(0x803D001B)
#define WS_E_SERVER_REQUIRES_BASIC_AUTH                    _HRESULT_TYPEDEF_(0x803D001C)
#define WS_E_SERVER_REQUIRES_DIGEST_AUTH                   _HRESULT_TYPEDEF_(0x803D001D)
#define WS_E_SERVER_REQUIRES_NTLM_AUTH                     _HRESULT_TYPEDEF_(0x803D001E)
#define WS_E_SERVER_REQUIRES_NEGOTIATE_AUTH                _HRESULT_TYPEDEF_(0x803D001F)
#define WS_E_INVALID_ENDPOINT_URL                          _HRESULT_TYPEDEF_(0x803D0020)
#define WS_E_OTHER                                         _HRESULT_TYPEDEF_(0x803D0021)
#define WS_E_SECURITY_TOKEN_EXPIRED                        _HRESULT_TYPEDEF_(0x803D0022)
#define WS_E_SECURITY_SYSTEM_FAILURE                       _HRESULT_TYPEDEF_(0x803D0023)

#define WPN_E_CHANNEL_CLOSED                               _HRESULT_TYPEDEF_(0x803E0100)
#define WPN_E_CHANNEL_REQUEST_NOT_COMPLETE                 _HRESULT_TYPEDEF_(0x803E0101)
#define WPN_E_INVALID_APP                                  _HRESULT_TYPEDEF_(0x803E0102)
#define WPN_E_OUTSTANDING_CHANNEL_REQUEST                  _HRESULT_TYPEDEF_(0x803E0103)
#define WPN_E_DUPLICATE_CHANNEL                            _HRESULT_TYPEDEF_(0x803E0104)
#define WPN_E_PLATFORM_UNAVAILABLE                         _HRESULT_TYPEDEF_(0x803E0105)
#define WPN_E_NOTIFICATION_POSTED                          _HRESULT_TYPEDEF_(0x803E0106)
#define WPN_E_NOTIFICATION_HIDDEN                          _HRESULT_TYPEDEF_(0x803E0107)
#define WPN_E_NOTIFICATION_NOT_POSTED                      _HRESULT_TYPEDEF_(0x803E0108)
#define WPN_E_CLOUD_DISABLED                               _HRESULT_TYPEDEF_(0x803E0109)
#define WPN_E_CLOUD_INCAPABLE                              _HRESULT_TYPEDEF_(0x803E0110)
#define WPN_E_NOTIFICATION_DISABLED                        _HRESULT_TYPEDEF_(0x803E0111)
#define WPN_E_NOTIFICATION_INCAPABLE                       _HRESULT_TYPEDEF_(0x803E0112)
#define WPN_E_INTERNET_INCAPABLE                           _HRESULT_TYPEDEF_(0x803E0113)
#define WPN_E_NOTIFICATION_TYPE_DISABLED                   _HRESULT_TYPEDEF_(0x803E0114)
#define WPN_E_NOTIFICATION_SIZE                            _HRESULT_TYPEDEF_(0x803E0115)
#define WPN_E_TAG_SIZE                                     _HRESULT_TYPEDEF_(0x803E0116)
#define WPN_E_ACCESS_DENIED                                _HRESULT_TYPEDEF_(0x803E0117)
#define WPN_E_DUPLICATE_REGISTRATION                       _HRESULT_TYPEDEF_(0x803E0118)
#define WPN_E_PUSH_NOTIFICATION_INCAPABLE                  _HRESULT_TYPEDEF_(0x803E0119)
#define WPN_E_CLOUD_AUTH_UNAVAILABLE                       _HRESULT_TYPEDEF_(0x803E011A)
#define WPN_E_CLOUD_SERVICE_UNAVAILABLE                    _HRESULT_TYPEDEF_(0x803E011B)
#define WPN_E_FAILED_LOCK_SCREEN_UPDATE_INTIALIZATION      _HRESULT_TYPEDEF_(0x803E011C)
#define WPN_E_DEV_ID_SIZE                                  _HRESULT_TYPEDEF_(0x803E0120)
#define WPN_E_TAG_ALPHANUMERIC                             _HRESULT_TYPEDEF_(0x803E012A)
#define WPN_E_INVALID_HTTP_STATUS_CODE                     _HRESULT_TYPEDEF_(0x803E012B)
#define WPN_E_OUT_OF_SESSION                               _HRESULT_TYPEDEF_(0x803E0200)
#define WPN_E_POWER_SAVE                                   _HRESULT_TYPEDEF_(0x803E0201)
#define WPN_E_IMAGE_NOT_FOUND_IN_CACHE                     _HRESULT_TYPEDEF_(0x803E0202)
#define WPN_E_ALL_URL_NOT_COMPLETED                        _HRESULT_TYPEDEF_(0x803E0203)
#define WPN_E_INVALID_CLOUD_IMAGE                          _HRESULT_TYPEDEF_(0x803E0204)
#define WPN_E_NOTIFICATION_ID_MATCHED                      _HRESULT_TYPEDEF_(0x803E0205)
#define WPN_E_CALLBACK_ALREADY_REGISTERED                  _HRESULT_TYPEDEF_(0x803E0206)
#define WPN_E_TOAST_NOTIFICATION_DROPPED                   _HRESULT_TYPEDEF_(0x803E0207)
#define WPN_E_STORAGE_LOCKED                               _HRESULT_TYPEDEF_(0x803E0208)
#define WPN_E_GROUP_SIZE                                   _HRESULT_TYPEDEF_(0x803E0209)
#define WPN_E_GROUP_ALPHANUMERIC                           _HRESULT_TYPEDEF_(0x803E020A)
#define WPN_E_CLOUD_DISABLED_FOR_APP                       _HRESULT_TYPEDEF_(0x803E020B)

#define INPUT_E_OUT_OF_ORDER                               _HRESULT_TYPEDEF_(0x80400000)
#define INPUT_E_REENTRANCY                                 _HRESULT_TYPEDEF_(0x80400001)
#define INPUT_E_MULTIMODAL                                 _HRESULT_TYPEDEF_(0x80400002)
#define INPUT_E_PACKET                                     _HRESULT_TYPEDEF_(0x80400003)
#define INPUT_E_FRAME                                      _HRESULT_TYPEDEF_(0x80400004)
#define INPUT_E_HISTORY                                    _HRESULT_TYPEDEF_(0x80400005)
#define INPUT_E_DEVICE_INFO                                _HRESULT_TYPEDEF_(0x80400006)
#define INPUT_E_TRANSFORM                                  _HRESULT_TYPEDEF_(0x80400007)
#define INPUT_E_DEVICE_PROPERTY                            _HRESULT_TYPEDEF_(0x80400008)

#define ERROR_QUIC_HANDSHAKE_FAILURE                       _HRESULT_TYPEDEF_(0x80410000)
#define ERROR_QUIC_VER_NEG_FAILURE                         _HRESULT_TYPEDEF_(0x80410001)
#define ERROR_QUIC_USER_CANCELED                           _HRESULT_TYPEDEF_(0x80410002)
#define ERROR_QUIC_INTERNAL_ERROR                          _HRESULT_TYPEDEF_(0x80410003)
#define ERROR_QUIC_PROTOCOL_VIOLATION                      _HRESULT_TYPEDEF_(0x80410004)
#define ERROR_QUIC_CONNECTION_IDLE                         _HRESULT_TYPEDEF_(0x80410005)
#define ERROR_QUIC_CONNECTION_TIMEOUT                      _HRESULT_TYPEDEF_(0x80410006)
#define ERROR_QUIC_ALPN_NEG_FAILURE                        _HRESULT_TYPEDEF_(0x80410007)

#define IORING_E_REQUIRED_FLAG_NOT_SUPPORTED               _HRESULT_TYPEDEF_(0x80460001)
#define IORING_E_SUBMISSION_QUEUE_FULL                     _HRESULT_TYPEDEF_(0x80460002)
#define IORING_E_VERSION_NOT_SUPPORTED                     _HRESULT_TYPEDEF_(0x80460003)
#define IORING_E_SUBMISSION_QUEUE_TOO_BIG                  _HRESULT_TYPEDEF_(0x80460004)
#define IORING_E_COMPLETION_QUEUE_TOO_BIG                  _HRESULT_TYPEDEF_(0x80460005)
#define IORING_E_SUBMIT_IN_PROGRESS                        _HRESULT_TYPEDEF_(0x80460006)
#define IORING_E_CORRUPT                                   _HRESULT_TYPEDEF_(0x80460007)
#define IORING_E_COMPLETION_QUEUE_TOO_FULL                 _HRESULT_TYPEDEF_(0x80460008)

#define E_MBN_CONTEXT_NOT_ACTIVATED                        _HRESULT_TYPEDEF_(0x80548201)
#define E_MBN_BAD_SIM                                      _HRESULT_TYPEDEF_(0x80548202)
#define E_MBN_DATA_CLASS_NOT_AVAILABLE                     _HRESULT_TYPEDEF_(0x80548203)
#define E_MBN_INVALID_ACCESS_STRING                        _HRESULT_TYPEDEF_(0x80548204)
#define E_MBN_MAX_ACTIVATED_CONTEXTS                       _HRESULT_TYPEDEF_(0x80548205)
#define E_MBN_PACKET_SVC_DETACHED                          _HRESULT_TYPEDEF_(0x80548206)
#define E_MBN_PROVIDER_NOT_VISIBLE                         _HRESULT_TYPEDEF_(0x80548207)
#define E_MBN_RADIO_POWER_OFF                              _HRESULT_TYPEDEF_(0x80548208)
#define E_MBN_SERVICE_NOT_ACTIVATED                        _HRESULT_TYPEDEF_(0x80548209)
#define E_MBN_SIM_NOT_INSERTED                             _HRESULT_TYPEDEF_(0x8054820A)
#define E_MBN_VOICE_CALL_IN_PROGRESS                       _HRESULT_TYPEDEF_(0x8054820B)
#define E_MBN_INVALID_CACHE                                _HRESULT_TYPEDEF_(0x8054820C)
#define E_MBN_NOT_REGISTERED                               _HRESULT_TYPEDEF_(0x8054820D)
#define E_MBN_PROVIDERS_NOT_FOUND                          _HRESULT_TYPEDEF_(0x8054820E)
#define E_MBN_PIN_NOT_SUPPORTED                            _HRESULT_TYPEDEF_(0x8054820F)
#define E_MBN_PIN_REQUIRED                                 _HRESULT_TYPEDEF_(0x80548210)
#define E_MBN_PIN_DISABLED                                 _HRESULT_TYPEDEF_(0x80548211)
#define E_MBN_FAILURE                                      _HRESULT_TYPEDEF_(0x80548212)
#define E_MBN_INVALID_PROFILE                              _HRESULT_TYPEDEF_(0x80548218)
#define E_MBN_DEFAULT_PROFILE_EXIST                        _HRESULT_TYPEDEF_(0x80548219)
#define E_MBN_SMS_ENCODING_NOT_SUPPORTED                   _HRESULT_TYPEDEF_(0x80548220)
#define E_MBN_SMS_FILTER_NOT_SUPPORTED                     _HRESULT_TYPEDEF_(0x80548221)
#define E_MBN_SMS_INVALID_MEMORY_INDEX                     _HRESULT_TYPEDEF_(0x80548222)
#define E_MBN_SMS_LANG_NOT_SUPPORTED                       _HRESULT_TYPEDEF_(0x80548223)
#define E_MBN_SMS_MEMORY_FAILURE                           _HRESULT_TYPEDEF_(0x80548224)
#define E_MBN_SMS_NETWORK_TIMEOUT                          _HRESULT_TYPEDEF_(0x80548225)
#define E_MBN_SMS_UNKNOWN_SMSC_ADDRESS                     _HRESULT_TYPEDEF_(0x80548226)
#define E_MBN_SMS_FORMAT_NOT_SUPPORTED                     _HRESULT_TYPEDEF_(0x80548227)
#define E_MBN_SMS_OPERATION_NOT_ALLOWED                    _HRESULT_TYPEDEF_(0x80548228)
#define E_MBN_SMS_MEMORY_FULL                              _HRESULT_TYPEDEF_(0x80548229)

#define EAS_E_POLICY_NOT_MANAGED_BY_OS                     _HRESULT_TYPEDEF_(0x80550001)
#define EAS_E_POLICY_COMPLIANT_WITH_ACTIONS                _HRESULT_TYPEDEF_(0x80550002)
#define EAS_E_REQUESTED_POLICY_NOT_ENFORCEABLE             _HRESULT_TYPEDEF_(0x80550003)
#define EAS_E_CURRENT_USER_HAS_BLANK_PASSWORD              _HRESULT_TYPEDEF_(0x80550004)
#define EAS_E_REQUESTED_POLICY_PASSWORD_EXPIRATION_INCOMPATIBLE _HRESULT_TYPEDEF_(0x80550005)
#define EAS_E_USER_CANNOT_CHANGE_PASSWORD                  _HRESULT_TYPEDEF_(0x80550006)
#define EAS_E_ADMINS_HAVE_BLANK_PASSWORD                   _HRESULT_TYPEDEF_(0x80550007)
#define EAS_E_ADMINS_CANNOT_CHANGE_PASSWORD                _HRESULT_TYPEDEF_(0x80550008)
#define EAS_E_LOCAL_CONTROLLED_USERS_CANNOT_CHANGE_PASSWORD _HRESULT_TYPEDEF_(0x80550009)
#define EAS_E_PASSWORD_POLICY_NOT_ENFORCEABLE_FOR_CONNECTED_ADMINS _HRESULT_TYPEDEF_(0x8055000A)
#define EAS_E_CONNECTED_ADMINS_NEED_TO_CHANGE_PASSWORD     _HRESULT_TYPEDEF_(0x8055000B)
#define EAS_E_PASSWORD_POLICY_NOT_ENFORCEABLE_FOR_CURRENT_CONNECTED_USER _HRESULT_TYPEDEF_(0x8055000C)
#define EAS_E_CURRENT_CONNECTED_USER_NEED_TO_CHANGE_PASSWORD _HRESULT_TYPEDEF_(0x8055000D)

#define ERROR_SVHDX_ERROR_STORED                           _HRESULT_TYPEDEF_(0xC05C0000)
#define ERROR_SVHDX_ERROR_NOT_AVAILABLE                    _HRESULT_TYPEDEF_(0xC05CFF00)
#define ERROR_SVHDX_UNIT_ATTENTION_AVAILABLE               _HRESULT_TYPEDEF_(0xC05CFF01)
#define ERROR_SVHDX_UNIT_ATTENTION_CAPACITY_DATA_CHANGED   _HRESULT_TYPEDEF_(0xC05CFF02)
#define ERROR_SVHDX_UNIT_ATTENTION_RESERVATIONS_PREEMPTED  _HRESULT_TYPEDEF_(0xC05CFF03)
#define ERROR_SVHDX_UNIT_ATTENTION_RESERVATIONS_RELEASED   _HRESULT_TYPEDEF_(0xC05CFF04)
#define ERROR_SVHDX_UNIT_ATTENTION_REGISTRATIONS_PREEMPTED _HRESULT_TYPEDEF_(0xC05CFF05)
#define ERROR_SVHDX_UNIT_ATTENTION_OPERATING_DEFINITION_CHANGED _HRESULT_TYPEDEF_(0xC05CFF06)
#define ERROR_SVHDX_RESERVATION_CONFLICT                   _HRESULT_TYPEDEF_(0xC05CFF07)
#define ERROR_SVHDX_WRONG_FILE_TYPE                        _HRESULT_TYPEDEF_(0xC05CFF08)
#define ERROR_SVHDX_VERSION_MISMATCH                       _HRESULT_TYPEDEF_(0xC05CFF09)
#define ERROR_VHD_SHARED                                   _HRESULT_TYPEDEF_(0xC05CFF0A)
#define ERROR_SVHDX_NO_INITIATOR                           _HRESULT_TYPEDEF_(0xC05CFF0B)
#define ERROR_VHDSET_BACKING_STORAGE_NOT_FOUND             _HRESULT_TYPEDEF_(0xC05CFF0C)

#define ERROR_SMB_NO_PREAUTH_INTEGRITY_HASH_OVERLAP        _HRESULT_TYPEDEF_(0xC05D0000)
#define ERROR_SMB_BAD_CLUSTER_DIALECT                      _HRESULT_TYPEDEF_(0xC05D0001)
#define ERROR_SMB_NO_SIGNING_ALGORITHM_OVERLAP             _HRESULT_TYPEDEF_(0xC05D0002)

#define PEER_S_GRAPH_DATA_CREATED                          _HRESULT_TYPEDEF_(0x00630001)
#define PEER_E_IPV6_NOT_INSTALLED                          _HRESULT_TYPEDEF_(0x80630001)
#define PEER_S_NO_EVENT_DATA                               _HRESULT_TYPEDEF_(0x00630002)
#define PEER_E_NOT_INITIALIZED                             _HRESULT_TYPEDEF_(0x80630002)
#define PEER_E_CANNOT_START_SERVICE                        _HRESULT_TYPEDEF_(0x80630003)
#define PEER_E_NOT_LICENSED                                _HRESULT_TYPEDEF_(0x80630004)
#define PEER_S_NO_CONNECTIVITY                             _HRESULT_TYPEDEF_(0x00630005)
#define PEER_S_ALREADY_A_MEMBER                            _HRESULT_TYPEDEF_(0x00630006)
#define PEER_E_INVALID_GRAPH                               _HRESULT_TYPEDEF_(0x80630010)
#define PEER_E_DBNAME_CHANGED                              _HRESULT_TYPEDEF_(0x80630011)
#define PEER_E_DUPLICATE_GRAPH                             _HRESULT_TYPEDEF_(0x80630012)
#define PEER_E_GRAPH_NOT_READY                             _HRESULT_TYPEDEF_(0x80630013)
#define PEER_E_GRAPH_SHUTTING_DOWN                         _HRESULT_TYPEDEF_(0x80630014)
#define PEER_E_GRAPH_IN_USE                                _HRESULT_TYPEDEF_(0x80630015)
#define PEER_E_INVALID_DATABASE                            _HRESULT_TYPEDEF_(0x80630016)
#define PEER_E_TOO_MANY_ATTRIBUTES                         _HRESULT_TYPEDEF_(0x80630017)
#define PEER_E_CONNECTION_NOT_FOUND                        _HRESULT_TYPEDEF_(0x80630103)
#define PEER_E_CONNECT_SELF                                _HRESULT_TYPEDEF_(0x80630106)
#define PEER_E_ALREADY_LISTENING                           _HRESULT_TYPEDEF_(0x80630107)
#define PEER_E_NODE_NOT_FOUND                              _HRESULT_TYPEDEF_(0x80630108)
#define PEER_E_CONNECTION_FAILED                           _HRESULT_TYPEDEF_(0x80630109)
#define PEER_E_CONNECTION_NOT_AUTHENTICATED                _HRESULT_TYPEDEF_(0x8063010A)
#define PEER_E_CONNECTION_REFUSED                          _HRESULT_TYPEDEF_(0x8063010B)
#define PEER_E_CLASSIFIER_TOO_LONG                         _HRESULT_TYPEDEF_(0x80630201)
#define PEER_E_TOO_MANY_IDENTITIES                         _HRESULT_TYPEDEF_(0x80630202)
#define PEER_E_NO_KEY_ACCESS                               _HRESULT_TYPEDEF_(0x80630203)
#define PEER_E_GROUPS_EXIST                                _HRESULT_TYPEDEF_(0x80630204)
#define PEER_E_RECORD_NOT_FOUND                            _HRESULT_TYPEDEF_(0x80630301)
#define PEER_E_DATABASE_ACCESSDENIED                       _HRESULT_TYPEDEF_(0x80630302)
#define PEER_E_DBINITIALIZATION_FAILED                     _HRESULT_TYPEDEF_(0x80630303)
#define PEER_E_MAX_RECORD_SIZE_EXCEEDED                    _HRESULT_TYPEDEF_(0x80630304)
#define PEER_E_DATABASE_ALREADY_PRESENT                    _HRESULT_TYPEDEF_(0x80630305)
#define PEER_E_DATABASE_NOT_PRESENT                        _HRESULT_TYPEDEF_(0x80630306)
#define PEER_E_IDENTITY_NOT_FOUND                          _HRESULT_TYPEDEF_(0x80630401)
#define PEER_E_EVENT_HANDLE_NOT_FOUND                      _HRESULT_TYPEDEF_(0x80630501)
#define PEER_E_INVALID_SEARCH                              _HRESULT_TYPEDEF_(0x80630601)
#define PEER_E_INVALID_ATTRIBUTES                          _HRESULT_TYPEDEF_(0x80630602)
#define PEER_E_INVITATION_NOT_TRUSTED                      _HRESULT_TYPEDEF_(0x80630701)
#define PEER_E_CHAIN_TOO_LONG                              _HRESULT_TYPEDEF_(0x80630703)
#define PEER_E_INVALID_TIME_PERIOD                         _HRESULT_TYPEDEF_(0x80630705)
#define PEER_E_CIRCULAR_CHAIN_DETECTED                     _HRESULT_TYPEDEF_(0x80630706)
#define PEER_E_CERT_STORE_CORRUPTED                        _HRESULT_TYPEDEF_(0x80630801)
#define PEER_E_NO_CLOUD                                    _HRESULT_TYPEDEF_(0x80631001)
#define PEER_E_CLOUD_NAME_AMBIGUOUS                        _HRESULT_TYPEDEF_(0x80631005)
#define PEER_S_ALREADY_CONNECTED                           _HRESULT_TYPEDEF_(0x00632000)
#define PEER_E_INVALID_RECORD                              _HRESULT_TYPEDEF_(0x80632010)
#define PEER_E_NOT_AUTHORIZED                              _HRESULT_TYPEDEF_(0x80632020)
#define PEER_E_PASSWORD_DOES_NOT_MEET_POLICY               _HRESULT_TYPEDEF_(0x80632021)
#define PEER_E_DEFERRED_VALIDATION                         _HRESULT_TYPEDEF_(0x80632030)
#define PEER_E_INVALID_GROUP_PROPERTIES                    _HRESULT_TYPEDEF_(0x80632040)
#define PEER_E_INVALID_PEER_NAME                           _HRESULT_TYPEDEF_(0x80632050)
#define PEER_E_INVALID_CLASSIFIER                          _HRESULT_TYPEDEF_(0x80632060)
#define PEER_E_INVALID_FRIENDLY_NAME                       _HRESULT_TYPEDEF_(0x80632070)
#define PEER_E_INVALID_ROLE_PROPERTY                       _HRESULT_TYPEDEF_(0x80632071)
#define PEER_E_INVALID_CLASSIFIER_PROPERTY                 _HRESULT_TYPEDEF_(0x80632072)
#define PEER_E_INVALID_RECORD_EXPIRATION                   _HRESULT_TYPEDEF_(0x80632080)
#define PEER_E_INVALID_CREDENTIAL_INFO                     _HRESULT_TYPEDEF_(0x80632081)
#define PEER_E_INVALID_CREDENTIAL                          _HRESULT_TYPEDEF_(0x80632082)
#define PEER_E_INVALID_RECORD_SIZE                         _HRESULT_TYPEDEF_(0x80632083)
#define PEER_E_UNSUPPORTED_VERSION                         _HRESULT_TYPEDEF_(0x80632090)
#define PEER_E_GROUP_NOT_READY                             _HRESULT_TYPEDEF_(0x80632091)
#define PEER_E_GROUP_IN_USE                                _HRESULT_TYPEDEF_(0x80632092)
#define PEER_E_INVALID_GROUP                               _HRESULT_TYPEDEF_(0x80632093)
#define PEER_E_NO_MEMBERS_FOUND                            _HRESULT_TYPEDEF_(0x80632094)
#define PEER_E_NO_MEMBER_CONNECTIONS                       _HRESULT_TYPEDEF_(0x80632095)
#define PEER_E_UNABLE_TO_LISTEN                            _HRESULT_TYPEDEF_(0x80632096)
#define PEER_E_IDENTITY_DELETED                            _HRESULT_TYPEDEF_(0x806320A0)
#define PEER_E_SERVICE_NOT_AVAILABLE                       _HRESULT_TYPEDEF_(0x806320A1)
#define PEER_E_CANNOT_CONVERT_PEER_NAME                    _HRESULT_TYPEDEF_(0x80634001)
#define PEER_E_INVALID_PEER_HOST_NAME                      _HRESULT_TYPEDEF_(0x80634002)
#define PEER_E_NO_MORE                                     _HRESULT_TYPEDEF_(0x80634003)
#define PEER_E_PNRP_DUPLICATE_PEER_NAME                    _HRESULT_TYPEDEF_(0x80634005)
#define PEER_S_SUBSCRIPTION_EXISTS                         _HRESULT_TYPEDEF_(0x00636000)
#define PEER_E_CONTACT_NOT_FOUND                           _HRESULT_TYPEDEF_(0x80636001)
#define PEER_E_INVITE_CANCELLED                            _HRESULT_TYPEDEF_(0x80637000)
#define PEER_E_INVITE_RESPONSE_NOT_AVAILABLE               _HRESULT_TYPEDEF_(0x80637001)
#define PEER_E_NOT_SIGNED_IN                               _HRESULT_TYPEDEF_(0x80637003)
#define PEER_E_PRIVACY_DECLINED                            _HRESULT_TYPEDEF_(0x80637004)
#define PEER_E_TIMEOUT                                     _HRESULT_TYPEDEF_(0x80637005)
#define PEER_E_INVALID_ADDRESS                             _HRESULT_TYPEDEF_(0x80637007)
#define PEER_E_FW_EXCEPTION_DISABLED                       _HRESULT_TYPEDEF_(0x80637008)
#define PEER_E_FW_BLOCKED_BY_POLICY                        _HRESULT_TYPEDEF_(0x80637009)
#define PEER_E_FW_BLOCKED_BY_SHIELDS_UP                    _HRESULT_TYPEDEF_(0x8063700A)
#define PEER_E_FW_DECLINED                                 _HRESULT_TYPEDEF_(0x8063700B)

#define E_BLUETOOTH_ATT_INVALID_HANDLE                     _HRESULT_TYPEDEF_(0x80650001)
#define E_BLUETOOTH_ATT_READ_NOT_PERMITTED                 _HRESULT_TYPEDEF_(0x80650002)
#define E_BLUETOOTH_ATT_WRITE_NOT_PERMITTED                _HRESULT_TYPEDEF_(0x80650003)
#define E_BLUETOOTH_ATT_INVALID_PDU                        _HRESULT_TYPEDEF_(0x80650004)
#define E_BLUETOOTH_ATT_INSUFFICIENT_AUTHENTICATION        _HRESULT_TYPEDEF_(0x80650005)
#define E_BLUETOOTH_ATT_REQUEST_NOT_SUPPORTED              _HRESULT_TYPEDEF_(0x80650006)
#define E_BLUETOOTH_ATT_INVALID_OFFSET                     _HRESULT_TYPEDEF_(0x80650007)
#define E_BLUETOOTH_ATT_INSUFFICIENT_AUTHORIZATION         _HRESULT_TYPEDEF_(0x80650008)
#define E_BLUETOOTH_ATT_PREPARE_QUEUE_FULL                 _HRESULT_TYPEDEF_(0x80650009)
#define E_BLUETOOTH_ATT_ATTRIBUTE_NOT_FOUND                _HRESULT_TYPEDEF_(0x8065000A)
#define E_BLUETOOTH_ATT_ATTRIBUTE_NOT_LONG                 _HRESULT_TYPEDEF_(0x8065000B)
#define E_BLUETOOTH_ATT_INSUFFICIENT_ENCRYPTION_KEY_SIZE   _HRESULT_TYPEDEF_(0x8065000C)
#define E_BLUETOOTH_ATT_INVALID_ATTRIBUTE_VALUE_LENGTH     _HRESULT_TYPEDEF_(0x8065000D)
#define E_BLUETOOTH_ATT_UNLIKELY                           _HRESULT_TYPEDEF_(0x8065000E)
#define E_BLUETOOTH_ATT_INSUFFICIENT_ENCRYPTION            _HRESULT_TYPEDEF_(0x8065000F)
#define E_BLUETOOTH_ATT_UNSUPPORTED_GROUP_TYPE             _HRESULT_TYPEDEF_(0x80650010)
#define E_BLUETOOTH_ATT_INSUFFICIENT_RESOURCES             _HRESULT_TYPEDEF_(0x80650011)
#define E_BLUETOOTH_ATT_UNKNOWN_ERROR                      _HRESULT_TYPEDEF_(0x80651000)
#define E_AUDIO_ENGINE_NODE_NOT_FOUND                      _HRESULT_TYPEDEF_(0x80660001)
#define E_HDAUDIO_EMPTY_CONNECTION_LIST                    _HRESULT_TYPEDEF_(0x80660002)
#define E_HDAUDIO_CONNECTION_LIST_NOT_SUPPORTED            _HRESULT_TYPEDEF_(0x80660003)
#define E_HDAUDIO_NO_LOGICAL_DEVICES_CREATED               _HRESULT_TYPEDEF_(0x80660004)
#define E_HDAUDIO_NULL_LINKED_LIST_ENTRY                   _HRESULT_TYPEDEF_(0x80660005)
#define STATEREPOSITORY_E_CONCURRENCY_LOCKING_FAILURE      _HRESULT_TYPEDEF_(0x80670001)
#define STATEREPOSITORY_E_STATEMENT_INPROGRESS             _HRESULT_TYPEDEF_(0x80670002)
#define STATEREPOSITORY_E_CONFIGURATION_INVALID            _HRESULT_TYPEDEF_(0x80670003)
#define STATEREPOSITORY_E_UNKNOWN_SCHEMA_VERSION           _HRESULT_TYPEDEF_(0x80670004)
#define STATEREPOSITORY_ERROR_DICTIONARY_CORRUPTED         _HRESULT_TYPEDEF_(0x80670005)
#define STATEREPOSITORY_E_BLOCKED                          _HRESULT_TYPEDEF_(0x80670006)
#define STATEREPOSITORY_E_BUSY_RETRY                       _HRESULT_TYPEDEF_(0x80670007)
#define STATEREPOSITORY_E_BUSY_RECOVERY_RETRY              _HRESULT_TYPEDEF_(0x80670008)
#define STATEREPOSITORY_E_LOCKED_RETRY                     _HRESULT_TYPEDEF_(0x80670009)
#define STATEREPOSITORY_E_LOCKED_SHAREDCACHE_RETRY         _HRESULT_TYPEDEF_(0x8067000A)
#define STATEREPOSITORY_E_TRANSACTION_REQUIRED             _HRESULT_TYPEDEF_(0x8067000B)
#define STATEREPOSITORY_E_BUSY_TIMEOUT_EXCEEDED            _HRESULT_TYPEDEF_(0x8067000C)
#define STATEREPOSITORY_E_BUSY_RECOVERY_TIMEOUT_EXCEEDED   _HRESULT_TYPEDEF_(0x8067000D)
#define STATEREPOSITORY_E_LOCKED_TIMEOUT_EXCEEDED          _HRESULT_TYPEDEF_(0x8067000E)
#define STATEREPOSITORY_E_LOCKED_SHAREDCACHE_TIMEOUT_EXCEEDED _HRESULT_TYPEDEF_(0x8067000F)
#define STATEREPOSITORY_E_SERVICE_STOP_IN_PROGRESS         _HRESULT_TYPEDEF_(0x80670010)
#define STATEREPOSTORY_E_NESTED_TRANSACTION_NOT_SUPPORTED  _HRESULT_TYPEDEF_(0x80670011)
#define STATEREPOSITORY_ERROR_CACHE_CORRUPTED              _HRESULT_TYPEDEF_(0x80670012)
#define STATEREPOSITORY_TRANSACTION_CALLER_ID_CHANGED      _HRESULT_TYPEDEF_(0x00670013)
#define STATEREPOSITORY_TRANSACTION_IN_PROGRESS            _HRESULT_TYPEDEF_(0x80670014)
#define STATEREPOSITORY_E_CACHE_NOT_INIITALIZED            _HRESULT_TYPEDEF_(0x80670015)
#define STATEREPOSITORY_E_DEPENDENCY_NOT_RESOLVED          _HRESULT_TYPEDEF_(0x80670016)

#define ERROR_VOLSNAP_BOOTFILE_NOT_VALID                   _HRESULT_TYPEDEF_(0x80820001)
#define ERROR_VOLSNAP_ACTIVATION_TIMEOUT                   _HRESULT_TYPEDEF_(0x80820002)
#define ERROR_VOLSNAP_NO_BYPASSIO_WITH_SNAPSHOT            _HRESULT_TYPEDEF_(0x80820003)

#define ERROR_TIERING_NOT_SUPPORTED_ON_VOLUME              _HRESULT_TYPEDEF_(0x80830001)
#define ERROR_TIERING_VOLUME_DISMOUNT_IN_PROGRESS          _HRESULT_TYPEDEF_(0x80830002)
#define ERROR_TIERING_STORAGE_TIER_NOT_FOUND               _HRESULT_TYPEDEF_(0x80830003)
#define ERROR_TIERING_INVALID_FILE_ID                      _HRESULT_TYPEDEF_(0x80830004)
#define ERROR_TIERING_WRONG_CLUSTER_NODE                   _HRESULT_TYPEDEF_(0x80830005)
#define ERROR_TIERING_ALREADY_PROCESSING                   _HRESULT_TYPEDEF_(0x80830006)
#define ERROR_TIERING_CANNOT_PIN_OBJECT                    _HRESULT_TYPEDEF_(0x80830007)
#define ERROR_TIERING_FILE_IS_NOT_PINNED                   _HRESULT_TYPEDEF_(0x80830008)
#define ERROR_NOT_A_TIERED_VOLUME                          _HRESULT_TYPEDEF_(0x80830009)
#define ERROR_ATTRIBUTE_NOT_PRESENT                        _HRESULT_TYPEDEF_(0x8083000A)

#define ONL_E_INVALID_AUTHENTICATION_TARGET                _HRESULT_TYPEDEF_(0x80860001)
#define ONL_E_ACCESS_DENIED_BY_TOU                         _HRESULT_TYPEDEF_(0x80860002)
#define ONL_E_INVALID_APPLICATION                          _HRESULT_TYPEDEF_(0x80860003)
#define ONL_E_PASSWORD_UPDATE_REQUIRED                     _HRESULT_TYPEDEF_(0x80860004)
#define ONL_E_ACCOUNT_UPDATE_REQUIRED                      _HRESULT_TYPEDEF_(0x80860005)
#define ONL_E_FORCESIGNIN                                  _HRESULT_TYPEDEF_(0x80860006)
#define ONL_E_ACCOUNT_LOCKED                               _HRESULT_TYPEDEF_(0x80860007)
#define ONL_E_PARENTAL_CONSENT_REQUIRED                    _HRESULT_TYPEDEF_(0x80860008)
#define ONL_E_EMAIL_VERIFICATION_REQUIRED                  _HRESULT_TYPEDEF_(0x80860009)
#define ONL_E_ACCOUNT_SUSPENDED_COMPROIMISE                _HRESULT_TYPEDEF_(0x8086000A)
#define ONL_E_ACCOUNT_SUSPENDED_ABUSE                      _HRESULT_TYPEDEF_(0x8086000B)
#define ONL_E_ACTION_REQUIRED                              _HRESULT_TYPEDEF_(0x8086000C)
#define ONL_CONNECTION_COUNT_LIMIT                         _HRESULT_TYPEDEF_(0x8086000D)
#define ONL_E_CONNECTED_ACCOUNT_CAN_NOT_SIGNOUT            _HRESULT_TYPEDEF_(0x8086000E)
#define ONL_E_USER_AUTHENTICATION_REQUIRED                 _HRESULT_TYPEDEF_(0x8086000F)
#define ONL_E_REQUEST_THROTTLED                            _HRESULT_TYPEDEF_(0x80860010)

#define ERROR_DBG_CREATE_PROCESS_FAILURE_LOCKDOWN          _HRESULT_TYPEDEF_(0x80B00001)
#define ERROR_DBG_ATTACH_PROCESS_FAILURE_LOCKDOWN          _HRESULT_TYPEDEF_(0x80B00002)
#define ERROR_DBG_CONNECT_SERVER_FAILURE_LOCKDOWN          _HRESULT_TYPEDEF_(0x80B00003)
#define ERROR_DBG_START_SERVER_FAILURE_LOCKDOWN            _HRESULT_TYPEDEF_(0x80B00004)

#define ERROR_SPACES_POOL_WAS_DELETED                      _HRESULT_TYPEDEF_(0x00E70001)
#define ERROR_SPACES_FAULT_DOMAIN_TYPE_INVALID             _HRESULT_TYPEDEF_(0x80E70001)
#define ERROR_SPACES_INTERNAL_ERROR                        _HRESULT_TYPEDEF_(0x80E70002)
#define ERROR_SPACES_RESILIENCY_TYPE_INVALID               _HRESULT_TYPEDEF_(0x80E70003)
#define ERROR_SPACES_DRIVE_SECTOR_SIZE_INVALID             _HRESULT_TYPEDEF_(0x80E70004)
#define ERROR_SPACES_DRIVE_REDUNDANCY_INVALID              _HRESULT_TYPEDEF_(0x80E70006)
#define ERROR_SPACES_NUMBER_OF_DATA_COPIES_INVALID         _HRESULT_TYPEDEF_(0x80E70007)
#define ERROR_SPACES_PARITY_LAYOUT_INVALID                 _HRESULT_TYPEDEF_(0x80E70008)
#define ERROR_SPACES_INTERLEAVE_LENGTH_INVALID             _HRESULT_TYPEDEF_(0x80E70009)
#define ERROR_SPACES_NUMBER_OF_COLUMNS_INVALID             _HRESULT_TYPEDEF_(0x80E7000A)
#define ERROR_SPACES_NOT_ENOUGH_DRIVES                     _HRESULT_TYPEDEF_(0x80E7000B)
#define ERROR_SPACES_EXTENDED_ERROR                        _HRESULT_TYPEDEF_(0x80E7000C)
#define ERROR_SPACES_PROVISIONING_TYPE_INVALID             _HRESULT_TYPEDEF_(0x80E7000D)
#define ERROR_SPACES_ALLOCATION_SIZE_INVALID               _HRESULT_TYPEDEF_(0x80E7000E)
#define ERROR_SPACES_ENCLOSURE_AWARE_INVALID               _HRESULT_TYPEDEF_(0x80E7000F)
#define ERROR_SPACES_WRITE_CACHE_SIZE_INVALID              _HRESULT_TYPEDEF_(0x80E70010)
#define ERROR_SPACES_NUMBER_OF_GROUPS_INVALID              _HRESULT_TYPEDEF_(0x80E70011)
#define ERROR_SPACES_DRIVE_OPERATIONAL_STATE_INVALID       _HRESULT_TYPEDEF_(0x80E70012)
#define ERROR_SPACES_ENTRY_INCOMPLETE                      _HRESULT_TYPEDEF_(0x80E70013)
#define ERROR_SPACES_ENTRY_INVALID                         _HRESULT_TYPEDEF_(0x80E70014)
#define ERROR_SPACES_UPDATE_COLUMN_STATE                   _HRESULT_TYPEDEF_(0x80E70015)
#define ERROR_SPACES_MAP_REQUIRED                          _HRESULT_TYPEDEF_(0x80E70016)
#define ERROR_SPACES_UNSUPPORTED_VERSION                   _HRESULT_TYPEDEF_(0x80E70017)
#define ERROR_SPACES_CORRUPT_METADATA                      _HRESULT_TYPEDEF_(0x80E70018)
#define ERROR_SPACES_DRT_FULL                              _HRESULT_TYPEDEF_(0x80E70019)
#define ERROR_SPACES_INCONSISTENCY                         _HRESULT_TYPEDEF_(0x80E7001A)
#define ERROR_SPACES_LOG_NOT_READY                         _HRESULT_TYPEDEF_(0x80E7001B)
#define ERROR_SPACES_NO_REDUNDANCY                         _HRESULT_TYPEDEF_(0x80E7001C)
#define ERROR_SPACES_DRIVE_NOT_READY                       _HRESULT_TYPEDEF_(0x80E7001D)
#define ERROR_SPACES_DRIVE_SPLIT                           _HRESULT_TYPEDEF_(0x80E7001E)
#define ERROR_SPACES_DRIVE_LOST_DATA                       _HRESULT_TYPEDEF_(0x80E7001F)
#define ERROR_SPACES_MARK_DIRTY                            _HRESULT_TYPEDEF_(0x80E70020)
#define ERROR_SPACES_FLUSH_METADATA                        _HRESULT_TYPEDEF_(0x80E70025)
#define ERROR_SPACES_CACHE_FULL                            _HRESULT_TYPEDEF_(0x80E70026)
#define ERROR_SPACES_REPAIR_IN_PROGRESS                    _HRESULT_TYPEDEF_(0x80E70027)

#define ERROR_SECCORE_INVALID_COMMAND                      _HRESULT_TYPEDEF_(0xC0E80000)

#define ERROR_NO_APPLICABLE_APP_LICENSES_FOUND             _HRESULT_TYPEDEF_(0xC0EA0001)
#define ERROR_CLIP_LICENSE_NOT_FOUND                       _HRESULT_TYPEDEF_(0xC0EA0002)
#define ERROR_CLIP_DEVICE_LICENSE_MISSING                  _HRESULT_TYPEDEF_(0xC0EA0003)
#define ERROR_CLIP_LICENSE_INVALID_SIGNATURE               _HRESULT_TYPEDEF_(0xC0EA0004)
#define ERROR_CLIP_KEYHOLDER_LICENSE_MISSING_OR_INVALID    _HRESULT_TYPEDEF_(0xC0EA0005)
#define ERROR_CLIP_LICENSE_EXPIRED                         _HRESULT_TYPEDEF_(0xC0EA0006)
#define ERROR_CLIP_LICENSE_SIGNED_BY_UNKNOWN_SOURCE        _HRESULT_TYPEDEF_(0xC0EA0007)
#define ERROR_CLIP_LICENSE_NOT_SIGNED                      _HRESULT_TYPEDEF_(0xC0EA0008)
#define ERROR_CLIP_LICENSE_HARDWARE_ID_OUT_OF_TOLERANCE    _HRESULT_TYPEDEF_(0xC0EA0009)
#define ERROR_CLIP_LICENSE_DEVICE_ID_MISMATCH              _HRESULT_TYPEDEF_(0xC0EA000A)

#define HSP_E_ERROR_MASK                                   _HRESULT_TYPEDEF_(0x81280000)
#define HSP_E_INTERNAL_ERROR                               _HRESULT_TYPEDEF_(0x81280FFF)
#define HSP_BS_ERROR_MASK                                  _HRESULT_TYPEDEF_(0x81281000)
#define HSP_BS_INTERNAL_ERROR                              _HRESULT_TYPEDEF_(0x812810FF)

#define HSP_DRV_ERROR_MASK                                 _HRESULT_TYPEDEF_(0x81290000)
#define HSP_DRV_INTERNAL_ERROR                             _HRESULT_TYPEDEF_(0x812900FF)
#define HSP_BASE_ERROR_MASK                                _HRESULT_TYPEDEF_(0x81290100)
#define HSP_BASE_INTERNAL_ERROR                            _HRESULT_TYPEDEF_(0x812901FF)
#define HSP_KSP_ERROR_MASK                                 _HRESULT_TYPEDEF_(0x81290200)
#define HSP_KSP_DEVICE_NOT_READY                           _HRESULT_TYPEDEF_(0x81290201)
#define HSP_KSP_INVALID_PROVIDER_HANDLE                    _HRESULT_TYPEDEF_(0x81290202)
#define HSP_KSP_INVALID_KEY_HANDLE                         _HRESULT_TYPEDEF_(0x81290203)
#define HSP_KSP_INVALID_PARAMETER                          _HRESULT_TYPEDEF_(0x81290204)
#define HSP_KSP_BUFFER_TOO_SMALL                           _HRESULT_TYPEDEF_(0x81290205)
#define HSP_KSP_NOT_SUPPORTED                              _HRESULT_TYPEDEF_(0x81290206)
#define HSP_KSP_INVALID_DATA                               _HRESULT_TYPEDEF_(0x81290207)
#define HSP_KSP_INVALID_FLAGS                              _HRESULT_TYPEDEF_(0x81290208)
#define HSP_KSP_ALGORITHM_NOT_SUPPORTED                    _HRESULT_TYPEDEF_(0x81290209)
#define HSP_KSP_KEY_ALREADY_FINALIZED                      _HRESULT_TYPEDEF_(0x8129020A)
#define HSP_KSP_KEY_NOT_FINALIZED                          _HRESULT_TYPEDEF_(0x8129020B)
#define HSP_KSP_INVALID_KEY_TYPE                           _HRESULT_TYPEDEF_(0x8129020C)
#define HSP_KSP_NO_MEMORY                                  _HRESULT_TYPEDEF_(0x81290210)
#define HSP_KSP_PARAMETER_NOT_SET                          _HRESULT_TYPEDEF_(0x81290211)
#define HSP_KSP_KEY_EXISTS                                 _HRESULT_TYPEDEF_(0x81290215)
#define HSP_KSP_KEY_MISSING                                _HRESULT_TYPEDEF_(0x81290216)
#define HSP_KSP_KEY_LOAD_FAIL                              _HRESULT_TYPEDEF_(0x81290217)
#define HSP_KSP_NO_MORE_ITEMS                              _HRESULT_TYPEDEF_(0x81290218)
#define HSP_KSP_INTERNAL_ERROR                             _HRESULT_TYPEDEF_(0x812902FF)

#define WEB_E_UNSUPPORTED_FORMAT                           _HRESULT_TYPEDEF_(0x83750001)
#define WEB_E_INVALID_XML                                  _HRESULT_TYPEDEF_(0x83750002)
#define WEB_E_MISSING_REQUIRED_ELEMENT                     _HRESULT_TYPEDEF_(0x83750003)
#define WEB_E_MISSING_REQUIRED_ATTRIBUTE                   _HRESULT_TYPEDEF_(0x83750004)
#define WEB_E_UNEXPECTED_CONTENT                           _HRESULT_TYPEDEF_(0x83750005)
#define WEB_E_RESOURCE_TOO_LARGE                           _HRESULT_TYPEDEF_(0x83750006)
#define WEB_E_INVALID_JSON_STRING                          _HRESULT_TYPEDEF_(0x83750007)
#define WEB_E_INVALID_JSON_NUMBER                          _HRESULT_TYPEDEF_(0x83750008)
#define WEB_E_JSON_VALUE_NOT_FOUND                         _HRESULT_TYPEDEF_(0x83750009)

#define E_INVALID_PROTOCOL_OPERATION                       _HRESULT_TYPEDEF_(0x83760001)
#define E_INVALID_PROTOCOL_FORMAT                          _HRESULT_TYPEDEF_(0x83760002)
#define E_PROTOCOL_EXTENSIONS_NOT_SUPPORTED                _HRESULT_TYPEDEF_(0x83760003)
#define E_SUBPROTOCOL_NOT_SUPPORTED                        _HRESULT_TYPEDEF_(0x83760004)
#define E_PROTOCOL_VERSION_NOT_SUPPORTED                   _HRESULT_TYPEDEF_(0x83760005)

#define SQLITE_E_ERROR                                     _HRESULT_TYPEDEF_(0x87AF0001)
#define SQLITE_E_INTERNAL                                  _HRESULT_TYPEDEF_(0x87AF0002)
#define SQLITE_E_PERM                                      _HRESULT_TYPEDEF_(0x87AF0003)
#define SQLITE_E_ABORT                                     _HRESULT_TYPEDEF_(0x87AF0004)
#define SQLITE_E_BUSY                                      _HRESULT_TYPEDEF_(0x87AF0005)
#define SQLITE_E_LOCKED                                    _HRESULT_TYPEDEF_(0x87AF0006)
#define SQLITE_E_NOMEM                                     _HRESULT_TYPEDEF_(0x87AF0007)
#define SQLITE_E_READONLY                                  _HRESULT_TYPEDEF_(0x87AF0008)
#define SQLITE_E_INTERRUPT                                 _HRESULT_TYPEDEF_(0x87AF0009)
#define SQLITE_E_IOERR                                     _HRESULT_TYPEDEF_(0x87AF000A)
#define SQLITE_E_CORRUPT                                   _HRESULT_TYPEDEF_(0x87AF000B)
#define SQLITE_E_NOTFOUND                                  _HRESULT_TYPEDEF_(0x87AF000C)
#define SQLITE_E_FULL                                      _HRESULT_TYPEDEF_(0x87AF000D)
#define SQLITE_E_CANTOPEN                                  _HRESULT_TYPEDEF_(0x87AF000E)
#define SQLITE_E_PROTOCOL                                  _HRESULT_TYPEDEF_(0x87AF000F)
#define SQLITE_E_EMPTY                                     _HRESULT_TYPEDEF_(0x87AF0010)
#define SQLITE_E_SCHEMA                                    _HRESULT_TYPEDEF_(0x87AF0011)
#define SQLITE_E_TOOBIG                                    _HRESULT_TYPEDEF_(0x87AF0012)
#define SQLITE_E_CONSTRAINT                                _HRESULT_TYPEDEF_(0x87AF0013)
#define SQLITE_E_MISMATCH                                  _HRESULT_TYPEDEF_(0x87AF0014)
#define SQLITE_E_MISUSE                                    _HRESULT_TYPEDEF_(0x87AF0015)
#define SQLITE_E_NOLFS                                     _HRESULT_TYPEDEF_(0x87AF0016)
#define SQLITE_E_AUTH                                      _HRESULT_TYPEDEF_(0x87AF0017)
#define SQLITE_E_FORMAT                                    _HRESULT_TYPEDEF_(0x87AF0018)
#define SQLITE_E_RANGE                                     _HRESULT_TYPEDEF_(0x87AF0019)
#define SQLITE_E_NOTADB                                    _HRESULT_TYPEDEF_(0x87AF001A)
#define SQLITE_E_NOTICE                                    _HRESULT_TYPEDEF_(0x87AF001B)
#define SQLITE_E_WARNING                                   _HRESULT_TYPEDEF_(0x87AF001C)
#define SQLITE_E_ROW                                       _HRESULT_TYPEDEF_(0x87AF0064)
#define SQLITE_E_DONE                                      _HRESULT_TYPEDEF_(0x87AF0065)
#define SQLITE_E_BUSY_RECOVERY                             _HRESULT_TYPEDEF_(0x87AF0105)
#define SQLITE_E_LOCKED_SHAREDCACHE                        _HRESULT_TYPEDEF_(0x87AF0106)
#define SQLITE_E_READONLY_RECOVERY                         _HRESULT_TYPEDEF_(0x87AF0108)
#define SQLITE_E_IOERR_READ                                _HRESULT_TYPEDEF_(0x87AF010A)
#define SQLITE_E_CORRUPT_VTAB                              _HRESULT_TYPEDEF_(0x87AF010B)
#define SQLITE_E_CANTOPEN_NOTEMPDIR                        _HRESULT_TYPEDEF_(0x87AF010E)
#define SQLITE_E_CONSTRAINT_CHECK                          _HRESULT_TYPEDEF_(0x87AF0113)
#define SQLITE_E_NOTICE_RECOVER_WAL                        _HRESULT_TYPEDEF_(0x87AF011B)
#define SQLITE_E_WARNING_AUTOINDEX                         _HRESULT_TYPEDEF_(0x87AF011C)
#define SQLITE_E_ABORT_ROLLBACK                            _HRESULT_TYPEDEF_(0x87AF0204)
#define SQLITE_E_BUSY_SNAPSHOT                             _HRESULT_TYPEDEF_(0x87AF0205)
#define SQLITE_E_READONLY_CANTLOCK                         _HRESULT_TYPEDEF_(0x87AF0208)
#define SQLITE_E_IOERR_SHORT_READ                          _HRESULT_TYPEDEF_(0x87AF020A)
#define SQLITE_E_CANTOPEN_ISDIR                            _HRESULT_TYPEDEF_(0x87AF020E)
#define SQLITE_E_CONSTRAINT_COMMITHOOK                     _HRESULT_TYPEDEF_(0x87AF0213)
#define SQLITE_E_NOTICE_RECOVER_ROLLBACK                   _HRESULT_TYPEDEF_(0x87AF021B)
#define SQLITE_E_READONLY_ROLLBACK                         _HRESULT_TYPEDEF_(0x87AF0308)
#define SQLITE_E_IOERR_WRITE                               _HRESULT_TYPEDEF_(0x87AF030A)
#define SQLITE_E_CANTOPEN_FULLPATH                         _HRESULT_TYPEDEF_(0x87AF030E)
#define SQLITE_E_CONSTRAINT_FOREIGNKEY                     _HRESULT_TYPEDEF_(0x87AF0313)
#define SQLITE_E_READONLY_DBMOVED                          _HRESULT_TYPEDEF_(0x87AF0408)
#define SQLITE_E_IOERR_FSYNC                               _HRESULT_TYPEDEF_(0x87AF040A)
#define SQLITE_E_CANTOPEN_CONVPATH                         _HRESULT_TYPEDEF_(0x87AF040E)
#define SQLITE_E_CONSTRAINT_FUNCTION                       _HRESULT_TYPEDEF_(0x87AF0413)
#define SQLITE_E_IOERR_DIR_FSYNC                           _HRESULT_TYPEDEF_(0x87AF050A)
#define SQLITE_E_CONSTRAINT_NOTNULL                        _HRESULT_TYPEDEF_(0x87AF0513)
#define SQLITE_E_IOERR_TRUNCATE                            _HRESULT_TYPEDEF_(0x87AF060A)
#define SQLITE_E_CONSTRAINT_PRIMARYKEY                     _HRESULT_TYPEDEF_(0x87AF0613)
#define SQLITE_E_IOERR_FSTAT                               _HRESULT_TYPEDEF_(0x87AF070A)
#define SQLITE_E_CONSTRAINT_TRIGGER                        _HRESULT_TYPEDEF_(0x87AF0713)
#define SQLITE_E_IOERR_UNLOCK                              _HRESULT_TYPEDEF_(0x87AF080A)
#define SQLITE_E_CONSTRAINT_UNIQUE                         _HRESULT_TYPEDEF_(0x87AF0813)
#define SQLITE_E_IOERR_RDLOCK                              _HRESULT_TYPEDEF_(0x87AF090A)
#define SQLITE_E_CONSTRAINT_VTAB                           _HRESULT_TYPEDEF_(0x87AF0913)
#define SQLITE_E_IOERR_DELETE                              _HRESULT_TYPEDEF_(0x87AF0A0A)
#define SQLITE_E_CONSTRAINT_ROWID                          _HRESULT_TYPEDEF_(0x87AF0A13)
#define SQLITE_E_IOERR_BLOCKED                             _HRESULT_TYPEDEF_(0x87AF0B0A)
#define SQLITE_E_IOERR_NOMEM                               _HRESULT_TYPEDEF_(0x87AF0C0A)
#define SQLITE_E_IOERR_ACCESS                              _HRESULT_TYPEDEF_(0x87AF0D0A)
#define SQLITE_E_IOERR_CHECKRESERVEDLOCK                   _HRESULT_TYPEDEF_(0x87AF0E0A)
#define SQLITE_E_IOERR_LOCK                                _HRESULT_TYPEDEF_(0x87AF0F0A)
#define SQLITE_E_IOERR_CLOSE                               _HRESULT_TYPEDEF_(0x87AF100A)
#define SQLITE_E_IOERR_DIR_CLOSE                           _HRESULT_TYPEDEF_(0x87AF110A)
#define SQLITE_E_IOERR_SHMOPEN                             _HRESULT_TYPEDEF_(0x87AF120A)
#define SQLITE_E_IOERR_SHMSIZE                             _HRESULT_TYPEDEF_(0x87AF130A)
#define SQLITE_E_IOERR_SHMLOCK                             _HRESULT_TYPEDEF_(0x87AF140A)
#define SQLITE_E_IOERR_SHMMAP                              _HRESULT_TYPEDEF_(0x87AF150A)
#define SQLITE_E_IOERR_SEEK                                _HRESULT_TYPEDEF_(0x87AF160A)
#define SQLITE_E_IOERR_DELETE_NOENT                        _HRESULT_TYPEDEF_(0x87AF170A)
#define SQLITE_E_IOERR_MMAP                                _HRESULT_TYPEDEF_(0x87AF180A)
#define SQLITE_E_IOERR_GETTEMPPATH                         _HRESULT_TYPEDEF_(0x87AF190A)
#define SQLITE_E_IOERR_VNODE                               _HRESULT_TYPEDEF_(0x87AF1A02)
#define SQLITE_E_IOERR_AUTH                                _HRESULT_TYPEDEF_(0x87AF1A03)
#define SQLITE_E_IOERR_CONVPATH                            _HRESULT_TYPEDEF_(0x87AF1A0A)

#define UTC_E_TOGGLE_TRACE_STARTED                         _HRESULT_TYPEDEF_(0x87C51001)
#define UTC_E_ALTERNATIVE_TRACE_CANNOT_PREEMPT             _HRESULT_TYPEDEF_(0x87C51002)
#define UTC_E_AOT_NOT_RUNNING                              _HRESULT_TYPEDEF_(0x87C51003)
#define UTC_E_SCRIPT_TYPE_INVALID                          _HRESULT_TYPEDEF_(0x87C51004)
#define UTC_E_SCENARIODEF_NOT_FOUND                        _HRESULT_TYPEDEF_(0x87C51005)
#define UTC_E_TRACEPROFILE_NOT_FOUND                       _HRESULT_TYPEDEF_(0x87C51006)
#define UTC_E_FORWARDER_ALREADY_ENABLED                    _HRESULT_TYPEDEF_(0x87C51007)
#define UTC_E_FORWARDER_ALREADY_DISABLED                   _HRESULT_TYPEDEF_(0x87C51008)
#define UTC_E_EVENTLOG_ENTRY_MALFORMED                     _HRESULT_TYPEDEF_(0x87C51009)
#define UTC_E_DIAGRULES_SCHEMAVERSION_MISMATCH             _HRESULT_TYPEDEF_(0x87C5100A)
#define UTC_E_SCRIPT_TERMINATED                            _HRESULT_TYPEDEF_(0x87C5100B)
#define UTC_E_INVALID_CUSTOM_FILTER                        _HRESULT_TYPEDEF_(0x87C5100C)
#define UTC_E_TRACE_NOT_RUNNING                            _HRESULT_TYPEDEF_(0x87C5100D)
#define UTC_E_REESCALATED_TOO_QUICKLY                      _HRESULT_TYPEDEF_(0x87C5100E)
#define UTC_E_ESCALATION_ALREADY_RUNNING                   _HRESULT_TYPEDEF_(0x87C5100F)
#define UTC_E_PERFTRACK_ALREADY_TRACING                    _HRESULT_TYPEDEF_(0x87C51010)
#define UTC_E_REACHED_MAX_ESCALATIONS                      _HRESULT_TYPEDEF_(0x87C51011)
#define UTC_E_FORWARDER_PRODUCER_MISMATCH                  _HRESULT_TYPEDEF_(0x87C51012)
#define UTC_E_INTENTIONAL_SCRIPT_FAILURE                   _HRESULT_TYPEDEF_(0x87C51013)
#define UTC_E_SQM_INIT_FAILED                              _HRESULT_TYPEDEF_(0x87C51014)
#define UTC_E_NO_WER_LOGGER_SUPPORTED                      _HRESULT_TYPEDEF_(0x87C51015)
#define UTC_E_TRACERS_DONT_EXIST                           _HRESULT_TYPEDEF_(0x87C51016)
#define UTC_E_WINRT_INIT_FAILED                            _HRESULT_TYPEDEF_(0x87C51017)
#define UTC_E_SCENARIODEF_SCHEMAVERSION_MISMATCH           _HRESULT_TYPEDEF_(0x87C51018)
#define UTC_E_INVALID_FILTER                               _HRESULT_TYPEDEF_(0x87C51019)
#define UTC_E_EXE_TERMINATED                               _HRESULT_TYPEDEF_(0x87C5101A)
#define UTC_E_ESCALATION_NOT_AUTHORIZED                    _HRESULT_TYPEDEF_(0x87C5101B)
#define UTC_E_SETUP_NOT_AUTHORIZED                         _HRESULT_TYPEDEF_(0x87C5101C)
#define UTC_E_CHILD_PROCESS_FAILED                         _HRESULT_TYPEDEF_(0x87C5101D)
#define UTC_E_COMMAND_LINE_NOT_AUTHORIZED                  _HRESULT_TYPEDEF_(0x87C5101E)
#define UTC_E_CANNOT_LOAD_SCENARIO_EDITOR_XML              _HRESULT_TYPEDEF_(0x87C5101F)
#define UTC_E_ESCALATION_TIMED_OUT                         _HRESULT_TYPEDEF_(0x87C51020)
#define UTC_E_SETUP_TIMED_OUT                              _HRESULT_TYPEDEF_(0x87C51021)
#define UTC_E_TRIGGER_MISMATCH                             _HRESULT_TYPEDEF_(0x87C51022)
#define UTC_E_TRIGGER_NOT_FOUND                            _HRESULT_TYPEDEF_(0x87C51023)
#define UTC_E_SIF_NOT_SUPPORTED                            _HRESULT_TYPEDEF_(0x87C51024)
#define UTC_E_DELAY_TERMINATED                             _HRESULT_TYPEDEF_(0x87C51025)
#define UTC_E_DEVICE_TICKET_ERROR                          _HRESULT_TYPEDEF_(0x87C51026)
#define UTC_E_TRACE_BUFFER_LIMIT_EXCEEDED                  _HRESULT_TYPEDEF_(0x87C51027)
#define UTC_E_API_RESULT_UNAVAILABLE                       _HRESULT_TYPEDEF_(0x87C51028)
#define UTC_E_RPC_TIMEOUT                                  _HRESULT_TYPEDEF_(0x87C51029)
#define UTC_E_RPC_WAIT_FAILED                              _HRESULT_TYPEDEF_(0x87C5102A)
#define UTC_E_API_BUSY                                     _HRESULT_TYPEDEF_(0x87C5102B)
#define UTC_E_TRACE_MIN_DURATION_REQUIREMENT_NOT_MET       _HRESULT_TYPEDEF_(0x87C5102C)
#define UTC_E_EXCLUSIVITY_NOT_AVAILABLE                    _HRESULT_TYPEDEF_(0x87C5102D)
#define UTC_E_GETFILE_FILE_PATH_NOT_APPROVED               _HRESULT_TYPEDEF_(0x87C5102E)
#define UTC_E_ESCALATION_DIRECTORY_ALREADY_EXISTS          _HRESULT_TYPEDEF_(0x87C5102F)
#define UTC_E_TIME_TRIGGER_ON_START_INVALID                _HRESULT_TYPEDEF_(0x87C51030)
#define UTC_E_TIME_TRIGGER_ONLY_VALID_ON_SINGLE_TRANSITION _HRESULT_TYPEDEF_(0x87C51031)
#define UTC_E_TIME_TRIGGER_INVALID_TIME_RANGE              _HRESULT_TYPEDEF_(0x87C51032)
#define UTC_E_MULTIPLE_TIME_TRIGGER_ON_SINGLE_STATE        _HRESULT_TYPEDEF_(0x87C51033)
#define UTC_E_BINARY_MISSING                               _HRESULT_TYPEDEF_(0x87C51034)
#define UTC_E_FAILED_TO_RESOLVE_CONTAINER_ID               _HRESULT_TYPEDEF_(0x87C51036)
#define UTC_E_UNABLE_TO_RESOLVE_SESSION                    _HRESULT_TYPEDEF_(0x87C51037)
#define UTC_E_THROTTLED                                    _HRESULT_TYPEDEF_(0x87C51038)
#define UTC_E_UNAPPROVED_SCRIPT                            _HRESULT_TYPEDEF_(0x87C51039)
#define UTC_E_SCRIPT_MISSING                               _HRESULT_TYPEDEF_(0x87C5103A)
#define UTC_E_SCENARIO_THROTTLED                           _HRESULT_TYPEDEF_(0x87C5103B)
#define UTC_E_API_NOT_SUPPORTED                            _HRESULT_TYPEDEF_(0x87C5103C)
#define UTC_E_GETFILE_EXTERNAL_PATH_NOT_APPROVED           _HRESULT_TYPEDEF_(0x87C5103D)
#define UTC_E_TRY_GET_SCENARIO_TIMEOUT_EXCEEDED            _HRESULT_TYPEDEF_(0x87C5103E)
#define UTC_E_CERT_REV_FAILED                              _HRESULT_TYPEDEF_(0x87C5103F)
#define UTC_E_FAILED_TO_START_NDISCAP                      _HRESULT_TYPEDEF_(0x87C51040)
#define UTC_E_KERNELDUMP_LIMIT_REACHED                     _HRESULT_TYPEDEF_(0x87C51041)
#define UTC_E_MISSING_AGGREGATE_EVENT_TAG                  _HRESULT_TYPEDEF_(0x87C51042)
#define UTC_E_INVALID_AGGREGATION_STRUCT                   _HRESULT_TYPEDEF_(0x87C51043)
#define UTC_E_ACTION_NOT_SUPPORTED_IN_DESTINATION          _HRESULT_TYPEDEF_(0x87C51044)
#define UTC_E_FILTER_MISSING_ATTRIBUTE                     _HRESULT_TYPEDEF_(0x87C51045)
#define UTC_E_FILTER_INVALID_TYPE                          _HRESULT_TYPEDEF_(0x87C51046)
#define UTC_E_FILTER_VARIABLE_NOT_FOUND                    _HRESULT_TYPEDEF_(0x87C51047)
#define UTC_E_FILTER_FUNCTION_RESTRICTED                   _HRESULT_TYPEDEF_(0x87C51048)
#define UTC_E_FILTER_VERSION_MISMATCH                      _HRESULT_TYPEDEF_(0x87C51049)
#define UTC_E_FILTER_INVALID_FUNCTION                      _HRESULT_TYPEDEF_(0x87C51050)
#define UTC_E_FILTER_INVALID_FUNCTION_PARAMS               _HRESULT_TYPEDEF_(0x87C51051)
#define UTC_E_FILTER_INVALID_COMMAND                       _HRESULT_TYPEDEF_(0x87C51052)
#define UTC_E_FILTER_ILLEGAL_EVAL                          _HRESULT_TYPEDEF_(0x87C51053)
#define UTC_E_TTTRACER_RETURNED_ERROR                      _HRESULT_TYPEDEF_(0x87C51054)
#define UTC_E_AGENT_DIAGNOSTICS_TOO_LARGE                  _HRESULT_TYPEDEF_(0x87C51055)
#define UTC_E_FAILED_TO_RECEIVE_AGENT_DIAGNOSTICS          _HRESULT_TYPEDEF_(0x87C51056)
#define UTC_E_SCENARIO_HAS_NO_ACTIONS                      _HRESULT_TYPEDEF_(0x87C51057)
#define UTC_E_TTTRACER_STORAGE_FULL                        _HRESULT_TYPEDEF_(0x87C51058)
#define UTC_E_INSUFFICIENT_SPACE_TO_START_TRACE            _HRESULT_TYPEDEF_(0x87C51059)
#define UTC_E_ESCALATION_CANCELLED_AT_SHUTDOWN             _HRESULT_TYPEDEF_(0x87C5105A)
#define UTC_E_GETFILEINFOACTION_FILE_NOT_APPROVED          _HRESULT_TYPEDEF_(0x87C5105B)
#define UTC_E_SETREGKEYACTION_TYPE_NOT_APPROVED            _HRESULT_TYPEDEF_(0x87C5105C)
#define UTC_E_TRACE_THROTTLED                              _HRESULT_TYPEDEF_(0x87C5105D)

#define WEP_E_NOT_PROVISIONED_ON_ALL_VOLUMES               _HRESULT_TYPEDEF_(0x88010001)
#define WEP_E_FIXED_DATA_NOT_SUPPORTED                     _HRESULT_TYPEDEF_(0x88010002)
#define WEP_E_HARDWARE_NOT_COMPLIANT                       _HRESULT_TYPEDEF_(0x88010003)
#define WEP_E_LOCK_NOT_CONFIGURED                          _HRESULT_TYPEDEF_(0x88010004)
#define WEP_E_PROTECTION_SUSPENDED                         _HRESULT_TYPEDEF_(0x88010005)
#define WEP_E_NO_LICENSE                                   _HRESULT_TYPEDEF_(0x88010006)
#define WEP_E_OS_NOT_PROTECTED                             _HRESULT_TYPEDEF_(0x88010007)
#define WEP_E_UNEXPECTED_FAIL                              _HRESULT_TYPEDEF_(0x88010008)
#define WEP_E_BUFFER_TOO_LARGE                             _HRESULT_TYPEDEF_(0x88010009)

#define E_SYNCENGINE_FILE_SIZE_OVER_LIMIT                  _HRESULT_TYPEDEF_(0x8802B001)
#define E_SYNCENGINE_FILE_SIZE_EXCEEDS_REMAINING_QUOTA     _HRESULT_TYPEDEF_(0x8802B002)
#define E_SYNCENGINE_UNSUPPORTED_FILE_NAME                 _HRESULT_TYPEDEF_(0x8802B003)
#define E_SYNCENGINE_FOLDER_ITEM_COUNT_LIMIT_EXCEEDED      _HRESULT_TYPEDEF_(0x8802B004)
#define E_SYNCENGINE_FILE_SYNC_PARTNER_ERROR               _HRESULT_TYPEDEF_(0x8802B005)
#define E_SYNCENGINE_SYNC_PAUSED_BY_SERVICE                _HRESULT_TYPEDEF_(0x8802B006)
#define E_SYNCENGINE_FILE_IDENTIFIER_UNKNOWN               _HRESULT_TYPEDEF_(0x8802C002)
#define E_SYNCENGINE_SERVICE_AUTHENTICATION_FAILED         _HRESULT_TYPEDEF_(0x8802C003)
#define E_SYNCENGINE_UNKNOWN_SERVICE_ERROR                 _HRESULT_TYPEDEF_(0x8802C004)
#define E_SYNCENGINE_SERVICE_RETURNED_UNEXPECTED_SIZE      _HRESULT_TYPEDEF_(0x8802C005)
#define E_SYNCENGINE_REQUEST_BLOCKED_BY_SERVICE            _HRESULT_TYPEDEF_(0x8802C006)
#define E_SYNCENGINE_REQUEST_BLOCKED_DUE_TO_CLIENT_ERROR   _HRESULT_TYPEDEF_(0x8802C007)
#define E_SYNCENGINE_FOLDER_INACCESSIBLE                   _HRESULT_TYPEDEF_(0x8802D001)
#define E_SYNCENGINE_UNSUPPORTED_FOLDER_NAME               _HRESULT_TYPEDEF_(0x8802D002)
#define E_SYNCENGINE_UNSUPPORTED_MARKET                    _HRESULT_TYPEDEF_(0x8802D003)
#define E_SYNCENGINE_PATH_LENGTH_LIMIT_EXCEEDED            _HRESULT_TYPEDEF_(0x8802D004)
#define E_SYNCENGINE_REMOTE_PATH_LENGTH_LIMIT_EXCEEDED     _HRESULT_TYPEDEF_(0x8802D005)
#define E_SYNCENGINE_CLIENT_UPDATE_NEEDED                  _HRESULT_TYPEDEF_(0x8802D006)
#define E_SYNCENGINE_PROXY_AUTHENTICATION_REQUIRED         _HRESULT_TYPEDEF_(0x8802D007)
#define E_SYNCENGINE_STORAGE_SERVICE_PROVISIONING_FAILED   _HRESULT_TYPEDEF_(0x8802D008)
#define E_SYNCENGINE_UNSUPPORTED_REPARSE_POINT             _HRESULT_TYPEDEF_(0x8802D009)
#define E_SYNCENGINE_STORAGE_SERVICE_BLOCKED               _HRESULT_TYPEDEF_(0x8802D00A)
#define E_SYNCENGINE_FOLDER_IN_REDIRECTION                 _HRESULT_TYPEDEF_(0x8802D00B)

#define D3D10_ERROR_TOO_MANY_UNIQUE_STATE_OBJECTS          _HRESULT_TYPEDEF_(0x88790001)
#define D3D10_ERROR_FILE_NOT_FOUND                         _HRESULT_TYPEDEF_(0x88790002)

#define DXGI_STATUS_OCCLUDED                               _HRESULT_TYPEDEF_(0x087A0001)
#define DXGI_ERROR_INVALID_CALL                            _HRESULT_TYPEDEF_(0x887A0001)
#define DXGI_STATUS_CLIPPED                                _HRESULT_TYPEDEF_(0x087A0002)
#define DXGI_ERROR_NOT_FOUND                               _HRESULT_TYPEDEF_(0x887A0002)
#define DXGI_ERROR_MORE_DATA                               _HRESULT_TYPEDEF_(0x887A0003)
#define DXGI_STATUS_NO_REDIRECTION                         _HRESULT_TYPEDEF_(0x087A0004)
#define DXGI_ERROR_UNSUPPORTED                             _HRESULT_TYPEDEF_(0x887A0004)
#define DXGI_STATUS_NO_DESKTOP_ACCESS                      _HRESULT_TYPEDEF_(0x087A0005)
#define DXGI_ERROR_DEVICE_REMOVED                          _HRESULT_TYPEDEF_(0x887A0005)
#define DXGI_STATUS_GRAPHICS_VIDPN_SOURCE_IN_USE           _HRESULT_TYPEDEF_(0x087A0006)
#define DXGI_ERROR_DEVICE_HUNG                             _HRESULT_TYPEDEF_(0x887A0006)
#define DXGI_STATUS_MODE_CHANGED                           _HRESULT_TYPEDEF_(0x087A0007)
#define DXGI_ERROR_DEVICE_RESET                            _HRESULT_TYPEDEF_(0x887A0007)
#define DXGI_STATUS_MODE_CHANGE_IN_PROGRESS                _HRESULT_TYPEDEF_(0x087A0008)
#define DXGI_STATUS_UNOCCLUDED                             _HRESULT_TYPEDEF_(0x087A0009)
#define DXGI_STATUS_DDA_WAS_STILL_DRAWING                  _HRESULT_TYPEDEF_(0x087A000A)
#define DXGI_ERROR_WAS_STILL_DRAWING                       _HRESULT_TYPEDEF_(0x887A000A)
#define DXGI_ERROR_FRAME_STATISTICS_DISJOINT               _HRESULT_TYPEDEF_(0x887A000B)
#define DXGI_ERROR_GRAPHICS_VIDPN_SOURCE_IN_USE            _HRESULT_TYPEDEF_(0x887A000C)
#define DXGI_ERROR_DRIVER_INTERNAL_ERROR                   _HRESULT_TYPEDEF_(0x887A0020)
#define DXGI_ERROR_NONEXCLUSIVE                            _HRESULT_TYPEDEF_(0x887A0021)
#define DXGI_ERROR_NOT_CURRENTLY_AVAILABLE                 _HRESULT_TYPEDEF_(0x887A0022)
#define DXGI_ERROR_REMOTE_CLIENT_DISCONNECTED              _HRESULT_TYPEDEF_(0x887A0023)
#define DXGI_ERROR_REMOTE_OUTOFMEMORY                      _HRESULT_TYPEDEF_(0x887A0024)
#define DXGI_ERROR_MODE_CHANGE_IN_PROGRESS                 _HRESULT_TYPEDEF_(0x887A0025)
#define DXGI_ERROR_ACCESS_LOST                             _HRESULT_TYPEDEF_(0x887A0026)
#define DXGI_ERROR_WAIT_TIMEOUT                            _HRESULT_TYPEDEF_(0x887A0027)
#define DXGI_ERROR_SESSION_DISCONNECTED                    _HRESULT_TYPEDEF_(0x887A0028)
#define DXGI_ERROR_RESTRICT_TO_OUTPUT_STALE                _HRESULT_TYPEDEF_(0x887A0029)
#define DXGI_ERROR_CANNOT_PROTECT_CONTENT                  _HRESULT_TYPEDEF_(0x887A002A)
#define DXGI_ERROR_ACCESS_DENIED                           _HRESULT_TYPEDEF_(0x887A002B)
#define DXGI_ERROR_NAME_ALREADY_EXISTS                     _HRESULT_TYPEDEF_(0x887A002C)
#define DXGI_ERROR_SDK_COMPONENT_MISSING                   _HRESULT_TYPEDEF_(0x887A002D)
#define DXGI_ERROR_NOT_CURRENT                             _HRESULT_TYPEDEF_(0x887A002E)
#define DXGI_STATUS_PRESENT_REQUIRED                       _HRESULT_TYPEDEF_(0x087A002F)
#define DXGI_ERROR_HW_PROTECTION_OUTOFMEMORY               _HRESULT_TYPEDEF_(0x887A0030)
#define DXGI_ERROR_DYNAMIC_CODE_POLICY_VIOLATION           _HRESULT_TYPEDEF_(0x887A0031)
#define DXGI_ERROR_NON_COMPOSITED_UI                       _HRESULT_TYPEDEF_(0x887A0032)
#define DXGI_ERROR_CACHE_CORRUPT                           _HRESULT_TYPEDEF_(0x887A0033)
#define DXGI_ERROR_CACHE_FULL                              _HRESULT_TYPEDEF_(0x887A0034)
#define DXGI_ERROR_CACHE_HASH_COLLISION                    _HRESULT_TYPEDEF_(0x887A0035)
#define DXGI_ERROR_ALREADY_EXISTS                          _HRESULT_TYPEDEF_(0x887A0036)
#define DXGI_ERROR_MPO_UNPINNED                            _HRESULT_TYPEDEF_(0x887A0064)

#define DXGI_DDI_ERR_WASSTILLDRAWING                       _HRESULT_TYPEDEF_(0x887B0001)
#define DXGI_DDI_ERR_UNSUPPORTED                           _HRESULT_TYPEDEF_(0x887B0002)
#define DXGI_DDI_ERR_NONEXCLUSIVE                          _HRESULT_TYPEDEF_(0x887B0003)

#define D3D11_ERROR_TOO_MANY_UNIQUE_STATE_OBJECTS          _HRESULT_TYPEDEF_(0x887C0001)
#define D3D11_ERROR_FILE_NOT_FOUND                         _HRESULT_TYPEDEF_(0x887C0002)
#define D3D11_ERROR_TOO_MANY_UNIQUE_VIEW_OBJECTS           _HRESULT_TYPEDEF_(0x887C0003)
#define D3D11_ERROR_DEFERRED_CONTEXT_MAP_WITHOUT_INITIAL_DISCARD _HRESULT_TYPEDEF_(0x887C0004)

#define D3D12_ERROR_ADAPTER_NOT_FOUND                      _HRESULT_TYPEDEF_(0x887E0001)
#define D3D12_ERROR_DRIVER_VERSION_MISMATCH                _HRESULT_TYPEDEF_(0x887E0002)
#define D3D12_ERROR_INVALID_REDIST                         _HRESULT_TYPEDEF_(0x887E0003)

#define DXCORE_ERROR_EVENT_NOT_UNREGISTERED                _HRESULT_TYPEDEF_(0x88800001)

#define PRESENTATION_ERROR_LOST                            _HRESULT_TYPEDEF_(0x88810001)

#define WINML_ERR_INVALID_DEVICE                           _HRESULT_TYPEDEF_(0x88900001)
#define WINML_ERR_INVALID_BINDING                          _HRESULT_TYPEDEF_(0x88900002)
#define WINML_ERR_VALUE_NOTFOUND                           _HRESULT_TYPEDEF_(0x88900003)
#define WINML_ERR_SIZE_MISMATCH                            _HRESULT_TYPEDEF_(0x88900004)

#define MILERR_OBJECTBUSY                                  _HRESULT_TYPEDEF_(0x88980001)
#define MILERR_INSUFFICIENTBUFFER                          _HRESULT_TYPEDEF_(0x88980002)
#define MILERR_WIN32ERROR                                  _HRESULT_TYPEDEF_(0x88980003)
#define MILERR_SCANNER_FAILED                              _HRESULT_TYPEDEF_(0x88980004)
#define MILERR_SCREENACCESSDENIED                          _HRESULT_TYPEDEF_(0x88980005)
#define MILERR_DISPLAYSTATEINVALID                         _HRESULT_TYPEDEF_(0x88980006)
#define MILERR_NONINVERTIBLEMATRIX                         _HRESULT_TYPEDEF_(0x88980007)
#define MILERR_ZEROVECTOR                                  _HRESULT_TYPEDEF_(0x88980008)
#define MILERR_TERMINATED                                  _HRESULT_TYPEDEF_(0x88980009)
#define MILERR_BADNUMBER                                   _HRESULT_TYPEDEF_(0x8898000A)
#define MILERR_INTERNALERROR                               _HRESULT_TYPEDEF_(0x88980080)
#define MILERR_DISPLAYFORMATNOTSUPPORTED                   _HRESULT_TYPEDEF_(0x88980084)
#define MILERR_INVALIDCALL                                 _HRESULT_TYPEDEF_(0x88980085)
#define MILERR_ALREADYLOCKED                               _HRESULT_TYPEDEF_(0x88980086)
#define MILERR_NOTLOCKED                                   _HRESULT_TYPEDEF_(0x88980087)
#define MILERR_DEVICECANNOTRENDERTEXT                      _HRESULT_TYPEDEF_(0x88980088)
#define MILERR_GLYPHBITMAPMISSED                           _HRESULT_TYPEDEF_(0x88980089)
#define MILERR_MALFORMEDGLYPHCACHE                         _HRESULT_TYPEDEF_(0x8898008A)
#define MILERR_GENERIC_IGNORE                              _HRESULT_TYPEDEF_(0x8898008B)
#define MILERR_MALFORMED_GUIDELINE_DATA                    _HRESULT_TYPEDEF_(0x8898008C)
#define MILERR_NO_HARDWARE_DEVICE                          _HRESULT_TYPEDEF_(0x8898008D)
#define MILERR_NEED_RECREATE_AND_PRESENT                   _HRESULT_TYPEDEF_(0x8898008E)
#define MILERR_ALREADY_INITIALIZED                         _HRESULT_TYPEDEF_(0x8898008F)
#define MILERR_MISMATCHED_SIZE                             _HRESULT_TYPEDEF_(0x88980090)
#define MILERR_NO_REDIRECTION_SURFACE_AVAILABLE            _HRESULT_TYPEDEF_(0x88980091)
#define MILERR_REMOTING_NOT_SUPPORTED                      _HRESULT_TYPEDEF_(0x88980092)
#define MILERR_QUEUED_PRESENT_NOT_SUPPORTED                _HRESULT_TYPEDEF_(0x88980093)
#define MILERR_NOT_QUEUING_PRESENTS                        _HRESULT_TYPEDEF_(0x88980094)
#define MILERR_NO_REDIRECTION_SURFACE_RETRY_LATER          _HRESULT_TYPEDEF_(0x88980095)
#define MILERR_TOOMANYSHADERELEMNTS                        _HRESULT_TYPEDEF_(0x88980096)
#define MILERR_MROW_READLOCK_FAILED                        _HRESULT_TYPEDEF_(0x88980097)
#define MILERR_MROW_UPDATE_FAILED                          _HRESULT_TYPEDEF_(0x88980098)
#define MILERR_SHADER_COMPILE_FAILED                       _HRESULT_TYPEDEF_(0x88980099)
#define MILERR_MAX_TEXTURE_SIZE_EXCEEDED                   _HRESULT_TYPEDEF_(0x8898009A)
#define MILERR_QPC_TIME_WENT_BACKWARD                      _HRESULT_TYPEDEF_(0x8898009B)
#define MILERR_DXGI_ENUMERATION_OUT_OF_SYNC                _HRESULT_TYPEDEF_(0x8898009D)
#define MILERR_ADAPTER_NOT_FOUND                           _HRESULT_TYPEDEF_(0x8898009E)
#define MILERR_COLORSPACE_NOT_SUPPORTED                    _HRESULT_TYPEDEF_(0x8898009F)
#define MILERR_PREFILTER_NOT_SUPPORTED                     _HRESULT_TYPEDEF_(0x889800A0)
#define MILERR_DISPLAYID_ACCESS_DENIED                     _HRESULT_TYPEDEF_(0x889800A1)
#define UCEERR_INVALIDPACKETHEADER                         _HRESULT_TYPEDEF_(0x88980400)
#define UCEERR_UNKNOWNPACKET                               _HRESULT_TYPEDEF_(0x88980401)
#define UCEERR_ILLEGALPACKET                               _HRESULT_TYPEDEF_(0x88980402)
#define UCEERR_MALFORMEDPACKET                             _HRESULT_TYPEDEF_(0x88980403)
#define UCEERR_ILLEGALHANDLE                               _HRESULT_TYPEDEF_(0x88980404)
#define UCEERR_HANDLELOOKUPFAILED                          _HRESULT_TYPEDEF_(0x88980405)
#define UCEERR_RENDERTHREADFAILURE                         _HRESULT_TYPEDEF_(0x88980406)
#define UCEERR_CTXSTACKFRSTTARGETNULL                      _HRESULT_TYPEDEF_(0x88980407)
#define UCEERR_CONNECTIONIDLOOKUPFAILED                    _HRESULT_TYPEDEF_(0x88980408)
#define UCEERR_BLOCKSFULL                                  _HRESULT_TYPEDEF_(0x88980409)
#define UCEERR_MEMORYFAILURE                               _HRESULT_TYPEDEF_(0x8898040A)
#define UCEERR_PACKETRECORDOUTOFRANGE                      _HRESULT_TYPEDEF_(0x8898040B)
#define UCEERR_ILLEGALRECORDTYPE                           _HRESULT_TYPEDEF_(0x8898040C)
#define UCEERR_OUTOFHANDLES                                _HRESULT_TYPEDEF_(0x8898040D)
#define UCEERR_UNCHANGABLE_UPDATE_ATTEMPTED                _HRESULT_TYPEDEF_(0x8898040E)
#define UCEERR_NO_MULTIPLE_WORKER_THREADS                  _HRESULT_TYPEDEF_(0x8898040F)
#define UCEERR_REMOTINGNOTSUPPORTED                        _HRESULT_TYPEDEF_(0x88980410)
#define UCEERR_MISSINGENDCOMMAND                           _HRESULT_TYPEDEF_(0x88980411)
#define UCEERR_MISSINGBEGINCOMMAND                         _HRESULT_TYPEDEF_(0x88980412)
#define UCEERR_CHANNELSYNCTIMEDOUT                         _HRESULT_TYPEDEF_(0x88980413)
#define UCEERR_CHANNELSYNCABANDONED                        _HRESULT_TYPEDEF_(0x88980414)
#define UCEERR_UNSUPPORTEDTRANSPORTVERSION                 _HRESULT_TYPEDEF_(0x88980415)
#define UCEERR_TRANSPORTUNAVAILABLE                        _HRESULT_TYPEDEF_(0x88980416)
#define UCEERR_FEEDBACK_UNSUPPORTED                        _HRESULT_TYPEDEF_(0x88980417)
#define UCEERR_COMMANDTRANSPORTDENIED                      _HRESULT_TYPEDEF_(0x88980418)
#define UCEERR_GRAPHICSSTREAMUNAVAILABLE                   _HRESULT_TYPEDEF_(0x88980419)
#define UCEERR_GRAPHICSSTREAMALREADYOPEN                   _HRESULT_TYPEDEF_(0x88980420)
#define UCEERR_TRANSPORTDISCONNECTED                       _HRESULT_TYPEDEF_(0x88980421)
#define UCEERR_TRANSPORTOVERLOADED                         _HRESULT_TYPEDEF_(0x88980422)
#define UCEERR_PARTITION_ZOMBIED                           _HRESULT_TYPEDEF_(0x88980423)
#define MILAVERR_NOCLOCK                                   _HRESULT_TYPEDEF_(0x88980500)
#define MILAVERR_NOMEDIATYPE                               _HRESULT_TYPEDEF_(0x88980501)
#define MILAVERR_NOVIDEOMIXER                              _HRESULT_TYPEDEF_(0x88980502)
#define MILAVERR_NOVIDEOPRESENTER                          _HRESULT_TYPEDEF_(0x88980503)
#define MILAVERR_NOREADYFRAMES                             _HRESULT_TYPEDEF_(0x88980504)
#define MILAVERR_MODULENOTLOADED                           _HRESULT_TYPEDEF_(0x88980505)
#define MILAVERR_WMPFACTORYNOTREGISTERED                   _HRESULT_TYPEDEF_(0x88980506)
#define MILAVERR_INVALIDWMPVERSION                         _HRESULT_TYPEDEF_(0x88980507)
#define MILAVERR_INSUFFICIENTVIDEORESOURCES                _HRESULT_TYPEDEF_(0x88980508)
#define MILAVERR_VIDEOACCELERATIONNOTAVAILABLE             _HRESULT_TYPEDEF_(0x88980509)
#define MILAVERR_REQUESTEDTEXTURETOOBIG                    _HRESULT_TYPEDEF_(0x8898050A)
#define MILAVERR_SEEKFAILED                                _HRESULT_TYPEDEF_(0x8898050B)
#define MILAVERR_UNEXPECTEDWMPFAILURE                      _HRESULT_TYPEDEF_(0x8898050C)
#define MILAVERR_MEDIAPLAYERCLOSED                         _HRESULT_TYPEDEF_(0x8898050D)
#define MILAVERR_UNKNOWNHARDWAREERROR                      _HRESULT_TYPEDEF_(0x8898050E)
#define MILEFFECTSERR_UNKNOWNPROPERTY                      _HRESULT_TYPEDEF_(0x8898060E)
#define MILEFFECTSERR_EFFECTNOTPARTOFGROUP                 _HRESULT_TYPEDEF_(0x8898060F)
#define MILEFFECTSERR_NOINPUTSOURCEATTACHED                _HRESULT_TYPEDEF_(0x88980610)
#define MILEFFECTSERR_CONNECTORNOTCONNECTED                _HRESULT_TYPEDEF_(0x88980611)
#define MILEFFECTSERR_CONNECTORNOTASSOCIATEDWITHEFFECT     _HRESULT_TYPEDEF_(0x88980612)
#define MILEFFECTSERR_RESERVED                             _HRESULT_TYPEDEF_(0x88980613)
#define MILEFFECTSERR_CYCLEDETECTED                        _HRESULT_TYPEDEF_(0x88980614)
#define MILEFFECTSERR_EFFECTINMORETHANONEGRAPH             _HRESULT_TYPEDEF_(0x88980615)
#define MILEFFECTSERR_EFFECTALREADYINAGRAPH                _HRESULT_TYPEDEF_(0x88980616)
#define MILEFFECTSERR_EFFECTHASNOCHILDREN                  _HRESULT_TYPEDEF_(0x88980617)
#define MILEFFECTSERR_ALREADYATTACHEDTOLISTENER            _HRESULT_TYPEDEF_(0x88980618)
#define MILEFFECTSERR_NOTAFFINETRANSFORM                   _HRESULT_TYPEDEF_(0x88980619)
#define MILEFFECTSERR_EMPTYBOUNDS                          _HRESULT_TYPEDEF_(0x8898061A)
#define MILEFFECTSERR_OUTPUTSIZETOOLARGE                   _HRESULT_TYPEDEF_(0x8898061B)
#define DWMERR_STATE_TRANSITION_FAILED                     _HRESULT_TYPEDEF_(0x88980700)
#define DWMERR_THEME_FAILED                                _HRESULT_TYPEDEF_(0x88980701)
#define DWMERR_CATASTROPHIC_FAILURE                        _HRESULT_TYPEDEF_(0x88980702)

#define DCOMPOSITION_ERROR_WINDOW_ALREADY_COMPOSED         _HRESULT_TYPEDEF_(0x88980800)
#define DCOMPOSITION_ERROR_SURFACE_BEING_RENDERED          _HRESULT_TYPEDEF_(0x88980801)
#define DCOMPOSITION_ERROR_SURFACE_NOT_BEING_RENDERED      _HRESULT_TYPEDEF_(0x88980802)

#define WINCODEC_ERR_WRONGSTATE                            _HRESULT_TYPEDEF_(0x88982F04)
#define WINCODEC_ERR_VALUEOUTOFRANGE                       _HRESULT_TYPEDEF_(0x88982F05)
#define WINCODEC_ERR_UNKNOWNIMAGEFORMAT                    _HRESULT_TYPEDEF_(0x88982F07)
#define WINCODEC_ERR_UNSUPPORTEDVERSION                    _HRESULT_TYPEDEF_(0x88982F0B)
#define WINCODEC_ERR_NOTINITIALIZED                        _HRESULT_TYPEDEF_(0x88982F0C)
#define WINCODEC_ERR_ALREADYLOCKED                         _HRESULT_TYPEDEF_(0x88982F0D)
#define WINCODEC_ERR_PROPERTYNOTFOUND                      _HRESULT_TYPEDEF_(0x88982F40)
#define WINCODEC_ERR_PROPERTYNOTSUPPORTED                  _HRESULT_TYPEDEF_(0x88982F41)
#define WINCODEC_ERR_PROPERTYSIZE                          _HRESULT_TYPEDEF_(0x88982F42)
#define WINCODEC_ERR_CODECPRESENT                          _HRESULT_TYPEDEF_(0x88982F43)
#define WINCODEC_ERR_CODECNOTHUMBNAIL                      _HRESULT_TYPEDEF_(0x88982F44)
#define WINCODEC_ERR_PALETTEUNAVAILABLE                    _HRESULT_TYPEDEF_(0x88982F45)
#define WINCODEC_ERR_CODECTOOMANYSCANLINES                 _HRESULT_TYPEDEF_(0x88982F46)
#define WINCODEC_ERR_INTERNALERROR                         _HRESULT_TYPEDEF_(0x88982F48)
#define WINCODEC_ERR_SOURCERECTDOESNOTMATCHDIMENSIONS      _HRESULT_TYPEDEF_(0x88982F49)
#define WINCODEC_ERR_COMPONENTNOTFOUND                     _HRESULT_TYPEDEF_(0x88982F50)
#define WINCODEC_ERR_IMAGESIZEOUTOFRANGE                   _HRESULT_TYPEDEF_(0x88982F51)
#define WINCODEC_ERR_TOOMUCHMETADATA                       _HRESULT_TYPEDEF_(0x88982F52)
#define WINCODEC_ERR_BADIMAGE                              _HRESULT_TYPEDEF_(0x88982F60)
#define WINCODEC_ERR_BADHEADER                             _HRESULT_TYPEDEF_(0x88982F61)
#define WINCODEC_ERR_FRAMEMISSING                          _HRESULT_TYPEDEF_(0x88982F62)
#define WINCODEC_ERR_BADMETADATAHEADER                     _HRESULT_TYPEDEF_(0x88982F63)
#define WINCODEC_ERR_BADSTREAMDATA                         _HRESULT_TYPEDEF_(0x88982F70)
#define WINCODEC_ERR_STREAMWRITE                           _HRESULT_TYPEDEF_(0x88982F71)
#define WINCODEC_ERR_STREAMREAD                            _HRESULT_TYPEDEF_(0x88982F72)
#define WINCODEC_ERR_STREAMNOTAVAILABLE                    _HRESULT_TYPEDEF_(0x88982F73)
#define WINCODEC_ERR_UNSUPPORTEDPIXELFORMAT                _HRESULT_TYPEDEF_(0x88982F80)
#define WINCODEC_ERR_UNSUPPORTEDOPERATION                  _HRESULT_TYPEDEF_(0x88982F81)
#define WINCODEC_ERR_INVALIDREGISTRATION                   _HRESULT_TYPEDEF_(0x88982F8A)
#define WINCODEC_ERR_COMPONENTINITIALIZEFAILURE            _HRESULT_TYPEDEF_(0x88982F8B)
#define WINCODEC_ERR_INSUFFICIENTBUFFER                    _HRESULT_TYPEDEF_(0x88982F8C)
#define WINCODEC_ERR_DUPLICATEMETADATAPRESENT              _HRESULT_TYPEDEF_(0x88982F8D)
#define WINCODEC_ERR_PROPERTYUNEXPECTEDTYPE                _HRESULT_TYPEDEF_(0x88982F8E)
#define WINCODEC_ERR_UNEXPECTEDSIZE                        _HRESULT_TYPEDEF_(0x88982F8F)
#define WINCODEC_ERR_INVALIDQUERYREQUEST                   _HRESULT_TYPEDEF_(0x88982F90)
#define WINCODEC_ERR_UNEXPECTEDMETADATATYPE                _HRESULT_TYPEDEF_(0x88982F91)
#define WINCODEC_ERR_REQUESTONLYVALIDATMETADATAROOT        _HRESULT_TYPEDEF_(0x88982F92)
#define WINCODEC_ERR_INVALIDQUERYCHARACTER                 _HRESULT_TYPEDEF_(0x88982F93)
#define WINCODEC_ERR_WIN32ERROR                            _HRESULT_TYPEDEF_(0x88982F94)
#define WINCODEC_ERR_INVALIDPROGRESSIVELEVEL               _HRESULT_TYPEDEF_(0x88982F95)
#define WINCODEC_ERR_INVALIDJPEGSCANINDEX                  _HRESULT_TYPEDEF_(0x88982F96)

#define DWRITE_E_FILEFORMAT                                _HRESULT_TYPEDEF_(0x88985000)
#define DWRITE_E_UNEXPECTED                                _HRESULT_TYPEDEF_(0x88985001)
#define DWRITE_E_NOFONT                                    _HRESULT_TYPEDEF_(0x88985002)
#define DWRITE_E_FILENOTFOUND                              _HRESULT_TYPEDEF_(0x88985003)
#define DWRITE_E_FILEACCESS                                _HRESULT_TYPEDEF_(0x88985004)
#define DWRITE_E_FONTCOLLECTIONOBSOLETE                    _HRESULT_TYPEDEF_(0x88985005)
#define DWRITE_E_ALREADYREGISTERED                         _HRESULT_TYPEDEF_(0x88985006)
#define DWRITE_E_CACHEFORMAT                               _HRESULT_TYPEDEF_(0x88985007)
#define DWRITE_E_CACHEVERSION                              _HRESULT_TYPEDEF_(0x88985008)
#define DWRITE_E_UNSUPPORTEDOPERATION                      _HRESULT_TYPEDEF_(0x88985009)
#define DWRITE_E_TEXTRENDERERINCOMPATIBLE                  _HRESULT_TYPEDEF_(0x8898500A)
#define DWRITE_E_FLOWDIRECTIONCONFLICTS                    _HRESULT_TYPEDEF_(0x8898500B)
#define DWRITE_E_NOCOLOR                                   _HRESULT_TYPEDEF_(0x8898500C)
#define DWRITE_E_REMOTEFONT                                _HRESULT_TYPEDEF_(0x8898500D)
#define DWRITE_E_DOWNLOADCANCELLED                         _HRESULT_TYPEDEF_(0x8898500E)
#define DWRITE_E_DOWNLOADFAILED                            _HRESULT_TYPEDEF_(0x8898500F)
#define DWRITE_E_TOOMANYDOWNLOADS                          _HRESULT_TYPEDEF_(0x88985010)

#define D2DERR_WRONG_STATE                                 _HRESULT_TYPEDEF_(0x88990001)
#define D2DERR_NOT_INITIALIZED                             _HRESULT_TYPEDEF_(0x88990002)
#define D2DERR_UNSUPPORTED_OPERATION                       _HRESULT_TYPEDEF_(0x88990003)
#define D2DERR_SCANNER_FAILED                              _HRESULT_TYPEDEF_(0x88990004)
#define D2DERR_SCREEN_ACCESS_DENIED                        _HRESULT_TYPEDEF_(0x88990005)
#define D2DERR_DISPLAY_STATE_INVALID                       _HRESULT_TYPEDEF_(0x88990006)
#define D2DERR_ZERO_VECTOR                                 _HRESULT_TYPEDEF_(0x88990007)
#define D2DERR_INTERNAL_ERROR                              _HRESULT_TYPEDEF_(0x88990008)
#define D2DERR_DISPLAY_FORMAT_NOT_SUPPORTED                _HRESULT_TYPEDEF_(0x88990009)
#define D2DERR_INVALID_CALL                                _HRESULT_TYPEDEF_(0x8899000A)
#define D2DERR_NO_HARDWARE_DEVICE                          _HRESULT_TYPEDEF_(0x8899000B)
#define D2DERR_RECREATE_TARGET                             _HRESULT_TYPEDEF_(0x8899000C)
#define D2DERR_TOO_MANY_SHADER_ELEMENTS                    _HRESULT_TYPEDEF_(0x8899000D)
#define D2DERR_SHADER_COMPILE_FAILED                       _HRESULT_TYPEDEF_(0x8899000E)
#define D2DERR_MAX_TEXTURE_SIZE_EXCEEDED                   _HRESULT_TYPEDEF_(0x8899000F)
#define D2DERR_UNSUPPORTED_VERSION                         _HRESULT_TYPEDEF_(0x88990010)
#define D2DERR_BAD_NUMBER                                  _HRESULT_TYPEDEF_(0x88990011)
#define D2DERR_WRONG_FACTORY                               _HRESULT_TYPEDEF_(0x88990012)
#define D2DERR_LAYER_ALREADY_IN_USE                        _HRESULT_TYPEDEF_(0x88990013)
#define D2DERR_POP_CALL_DID_NOT_MATCH_PUSH                 _HRESULT_TYPEDEF_(0x88990014)
#define D2DERR_WRONG_RESOURCE_DOMAIN                       _HRESULT_TYPEDEF_(0x88990015)
#define D2DERR_PUSH_POP_UNBALANCED                         _HRESULT_TYPEDEF_(0x88990016)
#define D2DERR_RENDER_TARGET_HAS_LAYER_OR_CLIPRECT         _HRESULT_TYPEDEF_(0x88990017)
#define D2DERR_INCOMPATIBLE_BRUSH_TYPES                    _HRESULT_TYPEDEF_(0x88990018)
#define D2DERR_WIN32_ERROR                                 _HRESULT_TYPEDEF_(0x88990019)
#define D2DERR_TARGET_NOT_GDI_COMPATIBLE                   _HRESULT_TYPEDEF_(0x8899001A)
#define D2DERR_TEXT_EFFECT_IS_WRONG_TYPE                   _HRESULT_TYPEDEF_(0x8899001B)
#define D2DERR_TEXT_RENDERER_NOT_RELEASED                  _HRESULT_TYPEDEF_(0x8899001C)
#define D2DERR_EXCEEDS_MAX_BITMAP_SIZE                     _HRESULT_TYPEDEF_(0x8899001D)
#define D2DERR_INVALID_GRAPH_CONFIGURATION                 _HRESULT_TYPEDEF_(0x8899001E)
#define D2DERR_INVALID_INTERNAL_GRAPH_CONFIGURATION        _HRESULT_TYPEDEF_(0x8899001F)
#define D2DERR_CYCLIC_GRAPH                                _HRESULT_TYPEDEF_(0x88990020)
#define D2DERR_BITMAP_CANNOT_DRAW                          _HRESULT_TYPEDEF_(0x88990021)
#define D2DERR_OUTSTANDING_BITMAP_REFERENCES               _HRESULT_TYPEDEF_(0x88990022)
#define D2DERR_ORIGINAL_TARGET_NOT_BOUND                   _HRESULT_TYPEDEF_(0x88990023)
#define D2DERR_INVALID_TARGET                              _HRESULT_TYPEDEF_(0x88990024)
#define D2DERR_BITMAP_BOUND_AS_TARGET                      _HRESULT_TYPEDEF_(0x88990025)
#define D2DERR_INSUFFICIENT_DEVICE_CAPABILITIES            _HRESULT_TYPEDEF_(0x88990026)
#define D2DERR_INTERMEDIATE_TOO_LARGE                      _HRESULT_TYPEDEF_(0x88990027)
#define D2DERR_EFFECT_IS_NOT_REGISTERED                    _HRESULT_TYPEDEF_(0x88990028)
#define D2DERR_INVALID_PROPERTY                            _HRESULT_TYPEDEF_(0x88990029)
#define D2DERR_NO_SUBPROPERTIES                            _HRESULT_TYPEDEF_(0x8899002A)
#define D2DERR_PRINT_JOB_CLOSED                            _HRESULT_TYPEDEF_(0x8899002B)
#define D2DERR_PRINT_FORMAT_NOT_SUPPORTED                  _HRESULT_TYPEDEF_(0x8899002C)
#define D2DERR_TOO_MANY_TRANSFORM_INPUTS                   _HRESULT_TYPEDEF_(0x8899002D)
#define D2DERR_INVALID_GLYPH_IMAGE                         _HRESULT_TYPEDEF_(0x8899002E)

#define ERROR_IO_PREEMPTED                                 _HRESULT_TYPEDEF_(0x89010001)

#define JSCRIPT_E_CANTEXECUTE                              _HRESULT_TYPEDEF_(0x89020001)

#endif  /* __WINE_WINERROR_H */
