// This file was generated by gir (https://github.com/gtk-rs/gir)
// from gir-files (https://github.com/gtk-rs/gir-files)
// from gst-gir-files (https://gitlab.freedesktop.org/gstreamer/gir-files-rs.git)
// DO NOT EDIT

use crate::{ffi, Object, PluginDependencyFlags, Structure};
use glib::translate::*;

glib::wrapper! {
    #[doc(alias = "GstPlugin")]
    pub struct Plugin(Object<ffi::GstPlugin, ffi::GstPluginClass>) @extends Object;

    match fn {
        type_ => || ffi::gst_plugin_get_type(),
    }
}

impl Plugin {
    #[doc(alias = "gst_plugin_add_dependency")]
    pub fn add_dependency(
        &self,
        env_vars: &[&str],
        paths: &[&str],
        names: &[&str],
        flags: PluginDependencyFlags,
    ) {
        unsafe {
            ffi::gst_plugin_add_dependency(
                self.to_glib_none().0,
                env_vars.to_glib_none().0,
                paths.to_glib_none().0,
                names.to_glib_none().0,
                flags.into_glib(),
            );
        }
    }

    #[doc(alias = "gst_plugin_add_dependency_simple")]
    pub fn add_dependency_simple(
        &self,
        env_vars: Option<&str>,
        paths: Option<&str>,
        names: Option<&str>,
        flags: PluginDependencyFlags,
    ) {
        unsafe {
            ffi::gst_plugin_add_dependency_simple(
                self.to_glib_none().0,
                env_vars.to_glib_none().0,
                paths.to_glib_none().0,
                names.to_glib_none().0,
                flags.into_glib(),
            );
        }
    }

    #[cfg(feature = "v1_24")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_24")))]
    #[doc(alias = "gst_plugin_add_status_error")]
    pub fn add_status_error(&self, message: &str) {
        unsafe {
            ffi::gst_plugin_add_status_error(self.to_glib_none().0, message.to_glib_none().0);
        }
    }

    #[cfg(feature = "v1_24")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_24")))]
    #[doc(alias = "gst_plugin_add_status_info")]
    pub fn add_status_info(&self, message: &str) {
        unsafe {
            ffi::gst_plugin_add_status_info(self.to_glib_none().0, message.to_glib_none().0);
        }
    }

    #[cfg(feature = "v1_24")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_24")))]
    #[doc(alias = "gst_plugin_add_status_warning")]
    pub fn add_status_warning(&self, message: &str) {
        unsafe {
            ffi::gst_plugin_add_status_warning(self.to_glib_none().0, message.to_glib_none().0);
        }
    }

    #[doc(alias = "gst_plugin_get_description")]
    #[doc(alias = "get_description")]
    pub fn description(&self) -> glib::GString {
        unsafe { from_glib_none(ffi::gst_plugin_get_description(self.to_glib_none().0)) }
    }

    #[doc(alias = "gst_plugin_get_filename")]
    #[doc(alias = "get_filename")]
    pub fn filename(&self) -> Option<std::path::PathBuf> {
        unsafe { from_glib_none(ffi::gst_plugin_get_filename(self.to_glib_none().0)) }
    }

    #[doc(alias = "gst_plugin_get_license")]
    #[doc(alias = "get_license")]
    pub fn license(&self) -> glib::GString {
        unsafe { from_glib_none(ffi::gst_plugin_get_license(self.to_glib_none().0)) }
    }

    #[doc(alias = "gst_plugin_get_name")]
    #[doc(alias = "get_name")]
    pub fn plugin_name(&self) -> glib::GString {
        unsafe { from_glib_none(ffi::gst_plugin_get_name(self.to_glib_none().0)) }
    }

    #[doc(alias = "gst_plugin_get_origin")]
    #[doc(alias = "get_origin")]
    pub fn origin(&self) -> glib::GString {
        unsafe { from_glib_none(ffi::gst_plugin_get_origin(self.to_glib_none().0)) }
    }

    #[doc(alias = "gst_plugin_get_package")]
    #[doc(alias = "get_package")]
    pub fn package(&self) -> glib::GString {
        unsafe { from_glib_none(ffi::gst_plugin_get_package(self.to_glib_none().0)) }
    }

    #[doc(alias = "gst_plugin_get_release_date_string")]
    #[doc(alias = "get_release_date_string")]
    pub fn release_date_string(&self) -> Option<glib::GString> {
        unsafe {
            from_glib_none(ffi::gst_plugin_get_release_date_string(
                self.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gst_plugin_get_source")]
    #[doc(alias = "get_source")]
    pub fn source(&self) -> glib::GString {
        unsafe { from_glib_none(ffi::gst_plugin_get_source(self.to_glib_none().0)) }
    }

    #[cfg(feature = "v1_24")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_24")))]
    #[doc(alias = "gst_plugin_get_status_errors")]
    #[doc(alias = "get_status_errors")]
    pub fn status_errors(&self) -> Vec<glib::GString> {
        unsafe {
            FromGlibPtrContainer::from_glib_full(ffi::gst_plugin_get_status_errors(
                self.to_glib_none().0,
            ))
        }
    }

    #[cfg(feature = "v1_24")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_24")))]
    #[doc(alias = "gst_plugin_get_status_infos")]
    #[doc(alias = "get_status_infos")]
    pub fn status_infos(&self) -> Vec<glib::GString> {
        unsafe {
            FromGlibPtrContainer::from_glib_full(ffi::gst_plugin_get_status_infos(
                self.to_glib_none().0,
            ))
        }
    }

    #[cfg(feature = "v1_24")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_24")))]
    #[doc(alias = "gst_plugin_get_status_warnings")]
    #[doc(alias = "get_status_warnings")]
    pub fn status_warnings(&self) -> Vec<glib::GString> {
        unsafe {
            FromGlibPtrContainer::from_glib_full(ffi::gst_plugin_get_status_warnings(
                self.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gst_plugin_get_version")]
    #[doc(alias = "get_version")]
    pub fn version(&self) -> glib::GString {
        unsafe { from_glib_none(ffi::gst_plugin_get_version(self.to_glib_none().0)) }
    }

    #[doc(alias = "gst_plugin_is_loaded")]
    pub fn is_loaded(&self) -> bool {
        unsafe { from_glib(ffi::gst_plugin_is_loaded(self.to_glib_none().0)) }
    }

    #[doc(alias = "gst_plugin_load")]
    pub fn load(&self) -> Result<Plugin, glib::BoolError> {
        unsafe {
            Option::<_>::from_glib_full(ffi::gst_plugin_load(self.to_glib_none().0))
                .ok_or_else(|| glib::bool_error!("Failed to load plugin"))
        }
    }

    #[doc(alias = "gst_plugin_set_cache_data")]
    pub fn set_cache_data(&self, cache_data: Structure) {
        unsafe {
            ffi::gst_plugin_set_cache_data(self.to_glib_none().0, cache_data.into_glib_ptr());
        }
    }

    #[doc(alias = "gst_plugin_load_by_name")]
    pub fn load_by_name(name: &str) -> Result<Plugin, glib::BoolError> {
        assert_initialized_main_thread!();
        unsafe {
            Option::<_>::from_glib_full(ffi::gst_plugin_load_by_name(name.to_glib_none().0))
                .ok_or_else(|| glib::bool_error!("Failed to load plugin"))
        }
    }

    #[doc(alias = "gst_plugin_load_file")]
    pub fn load_file(filename: impl AsRef<std::path::Path>) -> Result<Plugin, glib::Error> {
        assert_initialized_main_thread!();
        unsafe {
            let mut error = std::ptr::null_mut();
            let ret = ffi::gst_plugin_load_file(filename.as_ref().to_glib_none().0, &mut error);
            if error.is_null() {
                Ok(from_glib_full(ret))
            } else {
                Err(from_glib_full(error))
            }
        }
    }
}

impl std::fmt::Display for Plugin {
    #[inline]
    fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
        f.write_str(&self.plugin_name())
    }
}

unsafe impl Send for Plugin {}
unsafe impl Sync for Plugin {}
