// |reftest| shell-option(--enable-iterator-helpers) skip-if(!this.hasOwnProperty('Iterator')||!xulRuntime.shell) -- iterator-helpers is not enabled unconditionally, requires shell-options
// Copyright (C) 2024 Mozilla Corporation. All rights reserved.
// This code is governed by the BSD license found in the LICENSE file.

/*---
includes: [sm/non262-shell.js, sm/non262.js]
flags:
- noStrict
features:
- iterator-helpers
info: |
  Iterator is not enabled unconditionally
description: |
  pending
esid: pending
---*/
const iter = {
  next: () => ({ done: false, value: 0 }),
};

const wrap = Iterator.from(iter);

iter.next = () => ({ done: true, value: undefined });

let {done, value} = wrap.next();
assert.sameValue(done, false);
assert.sameValue(value, 0);


reportCompare(0, 0);
