// Copyright (C) 2024 Mozilla Corporation. All rights reserved.
// This code is governed by the BSD license found in the LICENSE file.

/*---
includes: [sm/non262-shell.js, sm/non262.js]
flags:
- noStrict
description: |
  pending
esid: pending
---*/
let values = [
  [-0, undefined, "0e+0"],
  [-0, 0, "0e+0"],
  [-0, 1, "0.0e+0"],
  [-0, 10, "0.0000000000e+0"],
  [-0, 50, "0.00000000000000000000000000000000000000000000000000e+0"],
  [-0, 100, "0.0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+0"],
  [0, undefined, "0e+0"],
  [0, 0, "0e+0"],
  [0, 1, "0.0e+0"],
  [0, 10, "0.0000000000e+0"],
  [0, 50, "0.00000000000000000000000000000000000000000000000000e+0"],
  [0, 100, "0.0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+0"],
  [NaN, undefined, "NaN"],
  [NaN, 0, "NaN"],
  [NaN, 1, "NaN"],
  [NaN, 10, "NaN"],
  [NaN, 50, "NaN"],
  [NaN, 100, "NaN"],
  [Infinity, undefined, "Infinity"],
  [Infinity, 0, "Infinity"],
  [Infinity, 1, "Infinity"],
  [Infinity, 10, "Infinity"],
  [Infinity, 50, "Infinity"],
  [Infinity, 100, "Infinity"],
  [-Infinity, undefined, "-Infinity"],
  [-Infinity, 0, "-Infinity"],
  [-Infinity, 1, "-Infinity"],
  [-Infinity, 10, "-Infinity"],
  [-Infinity, 50, "-Infinity"],
  [-Infinity, 100, "-Infinity"],
  [3.141592653589793, undefined, "3.141592653589793e+0"],
  [3.141592653589793, 0, "3e+0"],
  [3.141592653589793, 1, "3.1e+0"],
  [3.141592653589793, 10, "3.1415926536e+0"],
  [3.141592653589793, 50, "3.14159265358979311599796346854418516159057617187500e+0"],
  [3.141592653589793, 100, "3.1415926535897931159979634685441851615905761718750000000000000000000000000000000000000000000000000000e+0"],
  [-1, undefined, "-1e+0"],
  [-1, 0, "-1e+0"],
  [-1, 1, "-1.0e+0"],
  [-1, 10, "-1.0000000000e+0"],
  [-1, 50, "-1.00000000000000000000000000000000000000000000000000e+0"],
  [-1, 100, "-1.0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+0"],
  [1, undefined, "1e+0"],
  [1, 0, "1e+0"],
  [1, 1, "1.0e+0"],
  [1, 10, "1.0000000000e+0"],
  [1, 50, "1.00000000000000000000000000000000000000000000000000e+0"],
  [1, 100, "1.0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+0"],
  [-123456.78, undefined, "-1.2345678e+5"],
  [-123456.78, 0, "-1e+5"],
  [-123456.78, 1, "-1.2e+5"],
  [-123456.78, 10, "-1.2345678000e+5"],
  [-123456.78, 50, "-1.23456779999999998835846781730651855468750000000000e+5"],
  [-123456.78, 100, "-1.2345677999999999883584678173065185546875000000000000000000000000000000000000000000000000000000000000e+5"],
  [123456.78, undefined, "1.2345678e+5"],
  [123456.78, 0, "1e+5"],
  [123456.78, 1, "1.2e+5"],
  [123456.78, 10, "1.2345678000e+5"],
  [123456.78, 50, "1.23456779999999998835846781730651855468750000000000e+5"],
  [123456.78, 100, "1.2345677999999999883584678173065185546875000000000000000000000000000000000000000000000000000000000000e+5"],
  [100000000000000000000, undefined, "1e+20"],
  [100000000000000000000, 0, "1e+20"],
  [100000000000000000000, 1, "1.0e+20"],
  [100000000000000000000, 10, "1.0000000000e+20"],
  [100000000000000000000, 50, "1.00000000000000000000000000000000000000000000000000e+20"],
  [100000000000000000000, 100, "1.0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+20"],
  [1e+21, undefined, "1e+21"],
  [1e+21, 0, "1e+21"],
  [1e+21, 1, "1.0e+21"],
  [1e+21, 10, "1.0000000000e+21"],
  [1e+21, 50, "1.00000000000000000000000000000000000000000000000000e+21"],
  [1e+21, 100, "1.0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+21"],
  [-100000000000000000000, undefined, "-1e+20"],
  [-100000000000000000000, 0, "-1e+20"],
  [-100000000000000000000, 1, "-1.0e+20"],
  [-100000000000000000000, 10, "-1.0000000000e+20"],
  [-100000000000000000000, 50, "-1.00000000000000000000000000000000000000000000000000e+20"],
  [-100000000000000000000, 100, "-1.0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+20"],
  [-1e+21, undefined, "-1e+21"],
  [-1e+21, 0, "-1e+21"],
  [-1e+21, 1, "-1.0e+21"],
  [-1e+21, 10, "-1.0000000000e+21"],
  [-1e+21, 50, "-1.00000000000000000000000000000000000000000000000000e+21"],
  [-1e+21, 100, "-1.0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+21"],
  [Number.MAX_VALUE, undefined, "1.7976931348623157e+308"],
  [Number.MAX_VALUE, 0, "2e+308"],
  [Number.MAX_VALUE, 1, "1.8e+308"],
  [Number.MAX_VALUE, 10, "1.7976931349e+308"],
  [Number.MAX_VALUE, 50, "1.79769313486231570814527423731704356798070567525845e+308"],
  [Number.MAX_VALUE, 100, "1.7976931348623157081452742373170435679807056752584499659891747680315726078002853876058955863276687817e+308"],
  [-Number.MAX_VALUE, undefined, "-1.7976931348623157e+308"],
  [-Number.MAX_VALUE, 0, "-2e+308"],
  [-Number.MAX_VALUE, 1, "-1.8e+308"],
  [-Number.MAX_VALUE, 10, "-1.7976931349e+308"],
  [-Number.MAX_VALUE, 50, "-1.79769313486231570814527423731704356798070567525845e+308"],
  [-Number.MAX_VALUE, 100, "-1.7976931348623157081452742373170435679807056752584499659891747680315726078002853876058955863276687817e+308"],
  [Number.MIN_VALUE, undefined, "5e-324"],
  [Number.MIN_VALUE, 0, "5e-324"],
  [Number.MIN_VALUE, 1, "4.9e-324"],
  [Number.MIN_VALUE, 10, "4.9406564584e-324"],
  [Number.MIN_VALUE, 50, "4.94065645841246544176568792868221372365059802614325e-324"],
  [Number.MIN_VALUE, 100, "4.9406564584124654417656879286822137236505980261432476442558568250067550727020875186529983636163599238e-324"],
  [-Number.MIN_VALUE, undefined, "-5e-324"],
  [-Number.MIN_VALUE, 0, "-5e-324"],
  [-Number.MIN_VALUE, 1, "-4.9e-324"],
  [-Number.MIN_VALUE, 10, "-4.9406564584e-324"],
  [-Number.MIN_VALUE, 50, "-4.94065645841246544176568792868221372365059802614325e-324"],
  [-Number.MIN_VALUE, 100, "-4.9406564584124654417656879286822137236505980261432476442558568250067550727020875186529983636163599238e-324"],
];

for (let [val, prec, expected] of values) {
  assert.sameValue(Number.prototype.toExponential.call(val, prec), expected);
}

if (typeof assert.sameValue === "function") {
}

reportCompare(0, 0);
