#[==============================================================================================[
#                                BerkeleyGW compatibility wrapper                                #
]==============================================================================================]

#[===[.md
# FindBerkeleyGW

BerkeleyGW compatibility module for Octopus

This file is specifically tuned for Octopus usage. See `Octopus_FindPackage` for a more general
interface.

]===]

# Early exit if module already found and defined
# These files do not contain components, so early-exiting is acceptable
if (${CMAKE_FIND_PACKAGE_NAME}_FOUND AND TARGET BerkeleyGW::berkeleygw)
    return()
endif ()

list(APPEND CMAKE_MESSAGE_CONTEXT FindBerkeleyGW)
include(Octopus)
Octopus_FindPackage(${CMAKE_FIND_PACKAGE_NAME}
        HAVE_FALLBACK
        NAMES BerkeleyGW
        PKG_MODULE_NAMES berkeleygw)

# Create appropriate aliases
if (${CMAKE_FIND_PACKAGE_NAME}_PKGCONFIG)
    add_library(BerkeleyGW::berkeleygw ALIAS PkgConfig::${CMAKE_FIND_PACKAGE_NAME})
endif ()
# Temporary workarounds for non-packages
if (NOT ${CMAKE_FIND_PACKAGE_NAME}_FOUND)
    find_library(BerkeleyGW_LIBRARY
            NAMES BGW_wfn
    )
    mark_as_advanced(BerkeleyGW_LIBRARY)
    find_path(BerkeleyGW_INCLUDE_DIR
            NAMES wfn_rho_vxc_io_m.mod
            PATH_SUFFIXES berkeleygw BerkeleyGW
    )
    mark_as_advanced(BerkeleyGW_INCLUDE_DIR)
    find_package_handle_standard_args(${CMAKE_FIND_PACKAGE_NAME}
            REQUIRED_VARS BerkeleyGW_LIBRARY BerkeleyGW_INCLUDE_DIR
    )
    if(${CMAKE_FIND_PACKAGE_NAME}_FOUND)
        set(${CMAKE_FIND_PACKAGE_NAME}_INCLUDE_DIRS ${BerkeleyGW_INCLUDE_DIR})
        set(${CMAKE_FIND_PACKAGE_NAME}_LIBRARIES ${BerkeleyGW_LIBRARY})
        add_library(BerkeleyGW::berkeleygw UNKNOWN IMPORTED)
        set_target_properties(BerkeleyGW::berkeleygw PROPERTIES
                IMPORTED_LOCATION ${BerkeleyGW_LIBRARY}
                IMPORTED_LINK_INTERFACE_LANGUAGES Fortran
        )
        target_include_directories(BerkeleyGW::berkeleygw INTERFACE ${${CMAKE_FIND_PACKAGE_NAME}_INCLUDE_DIRS})

        # Assume ${CMAKE_FIND_PACKAGE_NAME}_FIND_COMPONENTS is a list of requested components.
        set(requested_components ${${CMAKE_FIND_PACKAGE_NAME}_FIND_COMPONENTS})

        if ("MPI" IN_LIST requested_components)
        	target_link_libraries(BerkeleyGW::berkeleygw INTERFACE ${${CMAKE_FIND_PACKAGE_NAME}_LIBRARIES} MPI::MPI_Fortran)
        else ()
                target_link_libraries(BerkeleyGW::berkeleygw INTERFACE ${${CMAKE_FIND_PACKAGE_NAME}_LIBRARIES})
        endif ()
    endif ()
endif ()
if(${CMAKE_FIND_PACKAGE_NAME}_FOUND)
    set(HAVE_BERKELEYGW 1)
endif ()
set_package_properties(${CMAKE_FIND_PACKAGE_NAME} PROPERTIES
        URL https://berkeleygw.org/
        DESCRIPTION "BerkeleyGW is a many-body perturbation theory code for excited states, using the GW method and the GW plus Bethe-Salpeter equation (GW-BSE)"
)
list(POP_BACK CMAKE_MESSAGE_CONTEXT)
