---
title: "Born-Oppenheimer Molecular Dynamics"
series: "Tutorials"
author: "Nicolas Tancogne-Dejean"
theories: ["DFT"]
calculation_modes: ["Geometry Optimization", "Time-dependent"]
system_types: "Molecule"
species_types: "Pseudopotentials"
features: ["Vibrational Modes","Forces"]
description: "how to run BO-MD simulations."
---


This tutorial aims at presenting how to perform a Born-Oppenheimer Molecular Dynamics (BOMD) simulation with {{< octopus >}}, as well as the related tools that can be used to analyze the data generated by such a run.
A typical BOMD simulation goes as follows. One first computes the ground state of the system under interest. 
Then, one performs the actual time evolution, in which the ions are evolved, using a velocity Verlet algorithm, and the electrons remain in their ground state at each step of the time evolution. 
A SCF cycle is then done for each step of the molecular dynamics, after which the electronic forces are computed.

## Ground-state input file
As always, we will start with a simple input file. As an example, in this tutorial we will look at the case of a Water molecule:

{{< code-block >}}
#include_input doc/tutorials/other/bomd/1-gs/inp
{{< /code-block >}}

Now run {{< octopus >}} using the above input file. This produces the usual output, as described in previous tutorials. 

From the static/info file, one can find the usual information of the ground-state of the water molecule. As H2O is a polar molecule, we can in particular find the dipole moment of the molecule, which is here of about 1.33 Debye, quite far from the experimental value of 1.855 Debye, see Ref.[^footnote-1], as the calculation is not converged here.

## Born-Oppenheimer molecular dynamics

Let us now perform the BOMD calculation. For this, we will use the following input file:
{{< code-block >}}
#include_input doc/tutorials/other/bomd/2-bo/inp
{{< /code-block >}}

In order to perform the BOMD, we changed few thing in the above input file.
First, we change the {{<variable "CalculationMode">}} to td, as we are now perforing a time evolution. 
In order to tell {{< octopus >}} that we want a BOMD calculation, we set the variable {{<variable "TDDynamics">}} to bo. 
We further activated the motion of the ions using {{<variable "MoveIons">}} = yes.

In order to make the run fast, we also here deactivated the parallelization over states, using {{<variable "ParStates">}} = no, and tuned some parameters of the Chebyshev filtering to avoid recomputing initial bounds of the filters, as each BOMD step provides a good initial starting point for the next one.

It should be noted that the parameters used in this tutorial (box size, grid spacing, tolerance on the relative density...) are not converged, and should be adjusted for any practical calculation.

## Analysis of the results

In order to analyze the motion of the molecule, we now compute the velocity correlation function and compute its Fourier transform.
This is done using the tool {{<manual "utilities/oct-vibrational_spectrum" "oct-vibrational_spectrum">}}.
As we performed here a relatively short calculation, we want to use all the time steps for the analysis, so we use
{{< code-block >}}
{{<variable "VibrationalSpectrumTimeStepFactor">}} = 1
{{< /code-block >}}

After running the utility, we obtain the files td.general/velocity_autocorrelation and td.general/vibrational_spectrum.
Plotting the file td.general/vibrational_spectrum shows the spectrum of the velocity correlation function, displaying peaks at the vibrational modes of H2O, see Fig. 1. We observe a main peak around 3000 cm^-1, as well as other side structures.  

#include_eps /doc/tutorials/other/bomd/3-results/BOMD_H2O.eps caption="Fig. 1. Vibrational spectrum of H2O from BOMD."

## Generate a movie from the actual data

Let us finally produce a movie from the coordinates generated during the BOMD run. For this, one can use the utility {{<manual "utilities/oct-xyz-anim" "oct-xyz-anim">}}.
This generates a file called td.general/movie.xyz, that can be later converted to an animated GIF using for instance XCrysden.
{{%expand "Expand to see the XCrysden command"%}}
```bash
xcrysden --xyz td.general/movie.xyz
```
{{%/expand%}}


The resulting movie is shown in Fig. 2 below, for a longer simulation of 100fs, using a tighter relative density convergence criterim of 1e-7, and otherwise the same input parameters as the above input.
It is possible to use the variable {{<variable "AnimationSampling">}} to select how many frame are used for the movie. In order to produce the movie below, we used {{<variable "AnimationSampling">}}=1.

{{< figure src="/images/H2O_bomd.gif" width="500px" caption="Fig. 2. Born-Oppenheimer molecular dynamics of H2O from this tutorial." >}} 

##  References
<references/>

[^footnote-1]: {{< article title="The dipole moment of water. I. Dipole moments and hyperfine properties of H2O and HDO in the ground and excited vibrational states" authors="Shelley L. Shostak; William L. Ebenstein; J. S. Muenter" journal="J. Chem. Phys." volume="94" pages="5875" year="1991" doi="10.1063/1.460471" >}}
