/* foundry-llm-provider.h
 *
 * Copyright 2024 Christian Hergert <chergert@redhat.com>
 *
 * This library is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of the
 * License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * SPDX-License-Identifier: LGPL-2.1-or-later
 */

#pragma once

#include <libpeas.h>

#include "foundry-contextual.h"
#include "foundry-operation.h"

G_BEGIN_DECLS

#define FOUNDRY_TYPE_LLM_PROVIDER (foundry_llm_provider_get_type())

FOUNDRY_AVAILABLE_IN_ALL
G_DECLARE_DERIVABLE_TYPE (FoundryLlmProvider, foundry_llm_provider, FOUNDRY, LLM_PROVIDER, FoundryContextual)

struct _FoundryLlmProviderClass
{
  FoundryContextualClass parent_class;

  char      *(*dup_name)     (FoundryLlmProvider *self);
  DexFuture *(*load)         (FoundryLlmProvider *self);
  DexFuture *(*unload)       (FoundryLlmProvider *self);
  DexFuture *(*list_models)  (FoundryLlmProvider *self);

  /*< private >*/
  gpointer _reserved[16];
};

FOUNDRY_AVAILABLE_IN_ALL
PeasPluginInfo *foundry_llm_provider_dup_plugin_info (FoundryLlmProvider *self);
FOUNDRY_AVAILABLE_IN_ALL
char           *foundry_llm_provider_dup_name        (FoundryLlmProvider *self);
FOUNDRY_AVAILABLE_IN_ALL
DexFuture      *foundry_llm_provider_list_models     (FoundryLlmProvider *self);

G_END_DECLS
