#!/bin/bash

# Copyright (C) 2024. Alex Buccheri.
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2, or (at your option)
# any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
# 02110-1301, USA.

# Doxygen requires some Octopus source files generated by the preprocessor
# else compilation fails. This script mocks them, runs doxygen in the src/, 
# then cleans up.
# TODO. This script should get scrapped when autotools is removed from Octopus
# Additionally, Doxyfile should be replaced with cmake_doxyfile

DOXY_ROOT="$PWD"
# Absolute path, that assumes two levels above $DOXY_ROOT
DOXY_OCTOPUS_ROOT="$(cd "$(dirname "$PWD/../../../")" && pwd)"

# options.h (and superfluously, defaults.h)
"$DOXY_OCTOPUS_ROOT/scripts/mk_varinfo.pl" -b "$DOXY_OCTOPUS_ROOT" -s "$DOXY_OCTOPUS_ROOT"

# config_F90.h containing all #define macros
# This specifically defines Octopus as having all external libraries
sed s'|#cmakedefine|#define|' $DOXY_OCTOPUS_ROOT/src/include/config.h.in | 
grep '^#define' > $DOXY_OCTOPUS_ROOT/src/include/config_F90.h

# config.h
cp "$DOXY_OCTOPUS_ROOT/src/include/config_F90.h" "$DOXY_OCTOPUS_ROOT/src/include/config.h"

# Remove prior docs build
rm -rf doxygen_doc

# Copy work files to src/
cp Doxyfile "$DOXY_OCTOPUS_ROOT/src/".
cp octopus.png "$DOXY_OCTOPUS_ROOT/src/".
cp DoxygenLayout.xml "$DOXY_OCTOPUS_ROOT/src/".

# Specifying INPUT = ../../src in Doxyfile does not result in a docs build
# hence cd to src/ and build from there.
# However, OUTPUT_DIRECTORY in Doxyfile points to the correct place
cd "$DOXY_OCTOPUS_ROOT/src/"
doxygen
echo "Doxygen documentation created in $DOXY_ROOT/doxygen_doc/html"
echo "Load index.html in the browser to view the documentation"

# Remove work files from src/
rm Doxyfile octopus.png DoxygenLayout.xml

# Clean up mocked files
rm "$DOXY_OCTOPUS_ROOT/src/include/options.h"
rm "$DOXY_OCTOPUS_ROOT/src/include/defaults.h"
rm "$DOXY_OCTOPUS_ROOT/src/include/config_F90.h"
rm "$DOXY_OCTOPUS_ROOT/src/include/config.h"

cd "$DOXY_ROOT"
