---
title: "About this manual"
series: "Manual"
weight: 1
---


## Copying

'''This manual is for {{< octopus >}} {{< octopus-version >}}, a first principles, electronic structure, excited states, time-dependent density functional theory program.'''

''Copyright © 2006 Miguel A. L. Marques, Xavier Andrade, Alberto Castro and Angel Rubio''

Permission is granted to copy, distribute and/or modify this document under the terms of the GNU Free Documentation License, Version 1.1 or any later version published by the Free Software Foundation; with no Invariant Sections, no Front-Cover Texts, and no Back-Cover Texts.

You can find a copy of the Free Documentation License [here](https://www.gnu.org/copyleft/fdl.html)

## Reading this manual

If you are new to {{< octopus >}} it is recommended that you read this manual sequentially. To read this manual you need some basic knowledge of {{< name "Density Functional Theory" >}} ({{< name "DFT" >}}) and {{< name "Time Dependent Density Functional Theory" >}} ({{< name "TDDFT" >}}), also a bit of numerical methods may be useful.

The way to tell what to do to {{< octopus >}} is through input variables, each one of these variables has its own proper documentation describing what it does and what are the possible values that it can take. All the documentation of the variables is contained in the {{< versioned-link "Variables" "Variables Reference" >}}. That information is complementary to this manual, here we will only give a brief description of the functionality of each variable and we will leave the details for the Reference Manual. If you are reading an electronic version of this manual, all references to input variables will be marked as hyperlinks. Opening that link will take you to a page with the reference documentation for that variable.

There are some styles used in this documents: "{{< name "proper names" >}}" (like {{< name "Fortran" >}}), "{{< file "files and directories" >}}" (like {{< file "inp" >}} or {{< file "/tmp/" >}}), "{{< command "commands" >}}" (like {{< command "ls" >}}) and "{{< code "input file text" >}}" (like {{< code "a=0.5" >}}).


## Getting help

If you need help using {{< octopus >}}, you have any doubts about the content of this manual or you want to contact us for any reason, please do it so through the [octopus users mailing list](https://listserv.gwdg.de/pipermail/octopus-users/).



{{< manual-foot prev="" next="About Octopus" >}}
