---
title: "Docker images"
series: "Manual"
weight: 4
---

Docker images with the compiled {{< octopus >}} binary are available in the
[container registry](https://gitlab.com/octopus-code/octopus/container_registry). Two
images are available:

- `octopus:latest`: Only CPU support, compiled for `amd64` and `arm64`, MPI support and a subset of the optional libraries
- `octopus/gpu:latest`: GPU support, compiled only for `amd64`, MPI support and a subset of the optional libraries

In addition to the `latest` tag, version-specific tags for Octopus releases
starting with 16.0 are also provided.

Other available tags are meant for development purposes only and should
generally not be used in production.

{{%notice note%}}
The images do not provide optimised builds for CPU (no vector instructions are
used). Therefore, they are best suited for small calculations such as in a
workshop or tutorial.
{{%/notice%}}

## Using the image

For all subsequent commands we assume that the current working directory contains the `inp` file.

### Serial execution

The default entrypoint is `octopus` so for a serial run it is not necessary to
specify any command. The following line will run {{< octopus >}} with the
`inp` file and write output files to the current working directory on the host machine.

```shell
docker run --rm -v=$(pwd):/io --user=$(id -u):$(id -g) registry.gitlab.com/octopus-code/octopus:latest
```

The default working directory inside the container is `/io`. The option `-v`
bind mounts the current working directory `$(pwd)` to `/io` inside the container
so that the `inp` file is available inside the container and the output persists
after the container stops.

On Linux it is necessary to map the user inside the container to the current
user. Otherwise files written inside the container are owned by root and cannot
be processed outside of the container. On Mac and Windows the `--user` option
can be omitted.

### Parallel execution

To use OpenMP specify `OMP_NUM_THREADS`, it defaults to 1 inside the container.

```shell
docker run --rm -v=$(pwd):/io --user=$(id -u):$(id -g) --env OMP_NUM_THREADS=2 registry.gitlab.com/octopus-code/octopus:latest
```

To use MPI a different command needs to be specified.

```shell
docker run --rm -v=$(pwd):/io --user=$(id -u):$(id -g) registry.gitlab.com/octopus-code/octopus:latest mpirun -n 4 octopus
```

Both options can be combined to run with MPI + OpenMP:

```shell
docker run --rm -v=$(pwd):/io --user=$(id -u):$(id -g) --env OMP_NUM_THREADS=2 registry.gitlab.com/octopus-code/octopus:latest mpirun -n 4 octopus
```

### GPU execution

To use Octopus with GPU support use the other image and attach one or multiple
GPUs to the container. The Docker runtime needs GPU support. On Linux install
the [NVIDIA Container Toolkit](https://docs.nvidia.com/datacenter/cloud-native/container-toolkit/latest/install-guide.html).

```shell
docker run --rm -v=$(pwd):/io --user=$(id -u):$(id -g) --gpus all registry.gitlab.com/octopus-code/octopus/gpu:latest
```

To efficiently use multiple GPUs run with MPI and use the same number of processes as GPUs.

### Other commands

To see the version or available features use:

```shell
docker run --rm registry.gitlab.com/octopus-code/octopus:latest octopus --version
```
```shell
docker run --rm registry.gitlab.com/octopus-code/octopus:latest octopus --config
```

To get a shell inside the container use:

```shell
docker run -it --rm registry.gitlab.com/octopus-code/octopus:latest bash
```

### Select specific Octopus versions

#### Octopus versions 16.0 and more recent

To use a particular Octopus version, the tag `latest` can be replaced by the
version identifier, such as `16.0` or `16.1`, for example:

```shell
docker run --rm registry.gitlab.com/octopus-code/octopus:16.0 octopus --version
```

#### Octopus versions 15.1 and older

Octopus versions 12.0 to 15.1 are [available from a different container
registry](https://hub.docker.com/r/fangohr/octopus/tags). To use version 12.0, for example, we can use:

```shell
docker run --rm docker.io/fangohr/octopus:12.0 octopus --version
```
