---
title: "Hello world"
series: "Manual"
weight: 1
---


As a first example, we will take a sodium atom. With your favourite text editor, create the file {{< file "inp" >}}.

```text
 {{< variable "CalculationMode" >}} = gs
 %{{< variable "Coordinates" >}}
     'Na' | 0.0 | 0.0 | 0.0
 %

 Radius = 10.0
 Spacing = 0.5
```

This input file should be essentially self-explanatory.

Note that when a species is not specified in the {{< variable "Species" >}} block, octopus reads the information of pseudopotentials from the {{< file "defaults" >}} file (located under {{< inst_file "share/octopus/PP/" >}}. The variables {{<variable "Radius">}} and {{<variable "Spacing">}} always have to be specified. There are no default values, in order to make sure that the convergence with respect to these is tested properly (see the tutorial on {{<tutorial "Total_energy_convergence" "total energy convergence" >}}).



Then run octopus – for example, do

{{< command-line "octopus > out" >}}
so that the output is stored in {{< file "out" >}} file. If everything goes OK, {{< file "out" >}} should look like:

{{% expand "Expand for full output" %}}
```text

    <><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><>
                                ___
                             .-'   `'.
                            /         \
                            |         ;
                            |         |           ___.--,
                   _.._     |0) ~ (0) |    _.---'`__.-( (_.
            __.--'`_.. '.__.\    '--. \_.-' ,.--'`     `""`
           ( ,.--'`   ',__ /./;   ;, '.__.'`    __
           _`) )  .---.__.' / |   |\   \__..--""  """--.,_
          `---' .'.''-._.-'`_./  /\ '.  \ _.-~~~````~~~-._`-.__.'
                | |  .' _.-' |  |  \  \  '.               `~---`
                 \ \/ .'     \  \   '. '-._)
                  \/ /        \  \    `=.__`~-.
             jgs  / /\         `) )    / / `"".`\
            , _.-'.'\ \        / /    ( (     / /
             `--~`   ) )    .-'.'      '.'.  | (
                    (/`    ( (`          ) )  '-;
                     `      '-;         (-'

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2, or (at your option)
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA

    <><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><>

                           Running octopus

Version                : 15.1
Commit                 : c97bf31c7e
Configuration time     : 2025-03-27T16:03:06
Configuration options  :  openmp mpi libxc_fxc libxc_kxc
Optional libraries     : cgal metis
Architecture           : x86_64
C compiler             : /usr/bin/cc
C compiler flags       :
C++ compiler           : /usr/bin/c++
C++ compiler flags     :
Fortran compiler       : /usr/bin/gfortran (GCC version 12.2.0)
Fortran compiler flags : -O3 -g -fallow-argument-mismatch -fno-var-tracking-assignments -fbacktrace -ffree-line-length-none -ffree-line-length-none

          The octopus is swimming in cfelm-pcx65043 (Linux)


            Calculation started on 2025/03/27 at 16:12:59


************************** Calculation Mode **************************
Input: [CalculationMode = gs]
**********************************************************************

Input: [SpinComponents = unpolarized]

******************************* Space ********************************
Octopus will run in 3 dimension(s).
Octopus will treat the system as periodic in 0 dimension(s).
**********************************************************************

Input: [AllElectronType = no]
Input: [PseudopotentialSet = standard]
Reading Coordinates from Coordinates block

****************************** Species *******************************
  Species 'Na'
    type             : pseudopotential
    file             : '/home/luedersm/Octopus2/octopus/installed/share/octopus/pseudopotentials/PSF/Na.psf'
    file format      : PSF
    valence charge   : 1.0
    atomic number    :  11
    form on file     : semilocal
    orbital origin   : calculated
    lmax             : 0
    llocal           : 0
    projectors per l : 1
    total projectors : 0
    application form : local
    orbitals         : 16
    bound orbitals   :  4

**********************************************************************


***************************** Symmetries *****************************
Symmetry elements : (i) (Cinf) (sigma)
Symmetry group    : Kh
**********************************************************************

Input: [CurvMethod = curv_affine]
Input: [DerivativesStencil = stencil_star]
Input: [SmearingFunction = semiconducting]
Input: [SymmetrizeDensity = no]

******************************* States *******************************
Total electronic charge  =        1.000
Number of states         =        1
States block-size        =        1
**********************************************************************


************************** Parallelization ***************************
Info: Octopus will run in *serial*
**********************************************************************

Info: Generating weights for finite-difference discretization of x-gradient
Info: Generating weights for finite-difference discretization of y-gradient
Info: Generating weights for finite-difference discretization of z-gradient
Info: Generating weights for finite-difference discretization of Laplacian

******************************** Grid ********************************
Simulation Box:
  Type = minimum
  Radius  [b] =  10.000
Main mesh:
  Spacing [b] = ( 0.500, 0.500, 0.500)    volume/point [b^3] =      0.12500
  # inner mesh =      33401
  # total mesh =      53601
  Grid Cutoff [H] =    19.739209    Grid Cutoff [Ry] =    39.478418
**********************************************************************

Info: states-block size = 0.4 MiB
Input: [StatesPack = yes]
Input: [StatesOrthogonalization = cholesky_serial]
Info: the XCFunctional has been selected to match the pseudopotentials
      used in the calculation.

**************************** Theory Level ****************************
Input: [TheoryLevel = kohn_sham]

Exchange-correlation:
  Exchange
    Slater exchange (LDA)
    [1] P. A. M. Dirac.,  Math. Proc. Cambridge Philos. Soc. 26, 376 (1930)
    [2] F. Bloch.,  Z. Phys. 57, 545 (1929)
  Correlation
    Perdew & Zunger (Modified) (LDA)
    [1] J. P. Perdew and A. Zunger.,  Phys. Rev. B 23, 5048 (1981)

**********************************************************************


****************************** Hartree *******************************
Input: [DressedOrbitals = no]
The chosen Poisson solver is 'interpolating scaling functions'
**********************************************************************

Input: [FilterPotentials = filter_TS]
Info: Pseudopotential for Na
  Radii for localized parts:
    local part     =  3.8 b
    non-local part =  0.0 b
    orbitals       = 19.9 b

Input: [RelativisticCorrection = non_relativistic]
Input: [DFTULevel = dft_u_none]
Input: [MagneticConstrain = 0]

****************** Approximate memory requirements *******************
Mesh
  global  :       0.4 MiB
  local   :       1.6 MiB
  total   :       2.0 MiB

States
  real    :       0.4 MiB (par_kpoints + par_states + par_domains)
  complex :       0.8 MiB (par_kpoints + par_states + par_domains)

**********************************************************************

Info: Generating external potential
      done.
Input: [InteractionTiming = timing_exact]
Info: Octopus initialization completed.
Info: Starting calculation mode.
Info: Allocating ground state wave-functions
Info: Blocks of states
      Block       1 contains       1 states:       1 -       1
Info: Ground-state allocation done.
Info: Could not find 'restart/gs' directory for restart.
Info: No restart information will be read.

**************************** Eigensolver *****************************
Input: [Eigensolver = cg]
Input: [Preconditioner = pre_filter]
Info: Generating weights for finite-difference discretization of Preconditioner
Input: [PreconditionerFilterFactor = 0.5000]
Input: [SubspaceDiagonalization = standard]
**********************************************************************

Input: [MixField = potential] (what to mix during SCF cycles)
Input: [MixingScheme = broyden]
Info: Mixing uses    4 steps and restarts after   20 steps.
Input: [LCAOStart = lcao_states]
Input: [LCAOScaleFactor = 1.000]
Input: [LCAOMaximumOrbitalRadius = 20.00 b]
Info: Double-precision storage for     1 extra orbitals will be allocated.
Info: Unnormalized total charge =      0.994401
Info: Renormalized total charge =      1.000000
Info: Setting up Hamiltonian.
Info: Performing initial LCAO calculation with      2 orbitals.
Info: Getting Hamiltonian matrix elements.
ETA: .......1......2.......3......4......5.......6......7.......8......9......0

Eigenvalues [H]
 #st  Spin   Eigenvalue      Occupation
   1   --    -0.093893       1.000000
Info: Ground-state restart information will be written to 'restart/gs'.
Info: SCF using real wavefunctions.
Info: Starting SCF iteration.
ETA: .......1......2.......3......4......5.......6......7.......8......9......0


*********************** SCF CYCLE ITER #    1 ************************
 etot  = -1.82474874E-01 abs_ev   =  6.78E-03 rel_ev   =  6.73E-02
 ediff =        1.82E-01 abs_dens =  1.22E-02 rel_dens =  1.22E-02
Matrix vector products:      4
Converged eigenvectors:      0

#  State  Eigenvalue [H]  Occupation    Error
      1       -0.100669    1.000000   ( 3.2E-02)

Elapsed time for SCF step     1:          0.02
**********************************************************************

ETA: .......1......2.......3......4......5.......6......7.......8......9......0


*********************** SCF CYCLE ITER #    2 ************************
 etot  = -1.84062252E-01 abs_ev   =  4.00E-04 rel_ev   =  3.96E-03
 ediff =        1.59E-03 abs_dens =  2.88E-02 rel_dens =  2.88E-02
Matrix vector products:      9
Converged eigenvectors:      0

#  State  Eigenvalue [H]  Occupation    Error
      1       -0.101069    1.000000   ( 5.9E-03)

Elapsed time for SCF step     2:          0.02
**********************************************************************

ETA: .......1......2.......3......4......5.......6......7.......8......9......0


*********************** SCF CYCLE ITER #    3 ************************
 etot  = -1.84705574E-01 abs_ev   =  5.98E-05 rel_ev   =  5.92E-04
 ediff =        6.43E-04 abs_dens =  1.71E-02 rel_dens =  1.71E-02
Matrix vector products:      8
Converged eigenvectors:      0

#  State  Eigenvalue [H]  Occupation    Error
      1       -0.101009    1.000000   ( 7.5E-04)

Elapsed time for SCF step     3:          0.02
**********************************************************************

ETA: .......1......2.......3......4......5.......6......7.......8......9......0


*********************** SCF CYCLE ITER #    4 ************************
 etot  = -1.84680503E-01 abs_ev   =  1.10E-04 rel_ev   =  1.09E-03
 ediff =        2.51E-05 abs_dens =  1.97E-03 rel_dens =  1.97E-03
Matrix vector products:      7
Converged eigenvectors:      0

#  State  Eigenvalue [H]  Occupation    Error
      1       -0.100899    1.000000   ( 1.7E-04)

Elapsed time for SCF step     4:          0.02
**********************************************************************

ETA: .......1......2.......3......4......5.......6......7.......8......9......0


*********************** SCF CYCLE ITER #    5 ************************
 etot  = -2.12237536E-01 abs_ev   =  2.77E-02 rel_ev   =  2.15E-01
 ediff =        2.76E-02 abs_dens =  1.25E-02 rel_dens =  1.25E-02
Matrix vector products:      3
Converged eigenvectors:      0

#  State  Eigenvalue [H]  Occupation    Error
      1       -0.128570    1.000000   ( 4.1E-03)

Elapsed time for SCF step     5:          0.02
**********************************************************************

ETA: .......1......2.......3......4......5.......6......7.......8......9......0


*********************** SCF CYCLE ITER #    6 ************************
 etot  = -1.57719076E-01 abs_ev   =  5.47E-02 rel_ev   =  7.40E-01
 ediff =        5.45E-02 abs_dens =  2.40E-02 rel_dens =  2.40E-02
Matrix vector products:      5
Converged eigenvectors:      0

#  State  Eigenvalue [H]  Occupation    Error
      1       -0.073904    1.000000   ( 3.4E-03)

Elapsed time for SCF step     6:          0.02
**********************************************************************

ETA: .......1......2.......3......4......5.......6......7.......8......9......0


*********************** SCF CYCLE ITER #    7 ************************
 etot  = -1.77195191E-01 abs_ev   =  1.94E-02 rel_ev   =  2.08E-01
 ediff =        1.95E-02 abs_dens =  6.96E-03 rel_dens =  6.96E-03
Matrix vector products:      4
Converged eigenvectors:      0

#  State  Eigenvalue [H]  Occupation    Error
      1       -0.093322    1.000000   ( 9.7E-04)

Elapsed time for SCF step     7:          0.02
**********************************************************************

ETA: .......1......2.......3......4......5.......6......7.......8......9......0


*********************** SCF CYCLE ITER #    8 ************************
 etot  = -1.83377201E-01 abs_ev   =  6.21E-03 rel_ev   =  6.24E-02
 ediff =        6.18E-03 abs_dens =  3.63E-03 rel_dens =  3.63E-03
Matrix vector products:      6
Converged eigenvectors:      0

#  State  Eigenvalue [H]  Occupation    Error
      1       -0.099533    1.000000   ( 6.2E-04)

Elapsed time for SCF step     8:          0.02
**********************************************************************

ETA: .......1......2.......3......4......5.......6......7.......8......9......0


*********************** SCF CYCLE ITER #    9 ************************
 etot  = -1.82554896E-01 abs_ev   =  7.71E-04 rel_ev   =  7.81E-03
 ediff =        8.22E-04 abs_dens =  1.13E-03 rel_dens =  1.13E-03
Matrix vector products:     10
Converged eigenvectors:      0

#  State  Eigenvalue [H]  Occupation    Error
      1       -0.098761    1.000000   ( 1.4E-04)

Elapsed time for SCF step     9:          0.03
**********************************************************************

ETA: .......1......2.......3......4......5.......6......7.......8......9......0


*********************** SCF CYCLE ITER #   10 ************************
 etot  = -1.82657020E-01 abs_ev   =  1.18E-04 rel_ev   =  1.19E-03
 ediff =        1.02E-04 abs_dens =  3.94E-04 rel_dens =  3.94E-04
Matrix vector products:     10
Converged eigenvectors:      0

#  State  Eigenvalue [H]  Occupation    Error
      1       -0.098879    1.000000   ( 3.4E-05)

Elapsed time for SCF step    10:          0.03
**********************************************************************

ETA: .......1......2.......3......4......5.......6......7.......8......9......0


*********************** SCF CYCLE ITER #   11 ************************
 etot  = -1.82617873E-01 abs_ev   =  3.73E-05 rel_ev   =  3.78E-04
 ediff =        3.91E-05 abs_dens =  5.27E-05 rel_dens =  5.27E-05
Matrix vector products:      8
Converged eigenvectors:      0

#  State  Eigenvalue [H]  Occupation    Error
      1       -0.098842    1.000000   ( 1.4E-05)

Elapsed time for SCF step    11:          0.02
**********************************************************************

ETA: .......1......2.......3......4......5.......6......7.......8......9......0


*********************** SCF CYCLE ITER #   12 ************************
 etot  = -1.82375128E-01 abs_ev   =  2.44E-04 rel_ev   =  2.47E-03
 ediff =        2.43E-04 abs_dens =  1.92E-04 rel_dens =  1.92E-04
Matrix vector products:      5
Converged eigenvectors:      0

#  State  Eigenvalue [H]  Occupation    Error
      1       -0.098598    1.000000   ( 3.2E-05)

Elapsed time for SCF step    12:          0.02
**********************************************************************

ETA: .......1......2.......3......4......5.......6......7.......8......9......0


*********************** SCF CYCLE ITER #   13 ************************
 etot  = -1.82600464E-01 abs_ev   =  2.25E-04 rel_ev   =  2.28E-03
 ediff =        2.25E-04 abs_dens =  1.13E-04 rel_dens =  1.13E-04
Matrix vector products:      5
Converged eigenvectors:      0

#  State  Eigenvalue [H]  Occupation    Error
      1       -0.098823    1.000000   ( 1.8E-05)

Elapsed time for SCF step    13:          0.02
**********************************************************************

ETA: .......1......2.......3......4......5.......6......7.......8......9......0


*********************** SCF CYCLE ITER #   14 ************************
 etot  = -1.82577126E-01 abs_ev   =  2.31E-05 rel_ev   =  2.34E-04
 ediff =        2.33E-05 abs_dens =  1.05E-05 rel_dens =  1.05E-05
Matrix vector products:      6
Converged eigenvectors:      0

#  State  Eigenvalue [H]  Occupation    Error
      1       -0.098800    1.000000   ( 7.2E-06)

Elapsed time for SCF step    14:          0.02
**********************************************************************

ETA: .......1......2.......3......4......5.......6......7.......8......9......0


*********************** SCF CYCLE ITER #   15 ************************
 etot  = -1.82577169E-01 abs_ev   =  3.77E-07 rel_ev   =  3.81E-06
 ediff =        4.29E-08 abs_dens =  7.55E-06 rel_dens =  7.55E-06
Matrix vector products:     12
Converged eigenvectors:      0

#  State  Eigenvalue [H]  Occupation    Error
      1       -0.098800    1.000000   ( 3.2E-06)

Elapsed time for SCF step    15:          0.03
**********************************************************************

ETA: .......1......2.......3......4......5.......6......7.......8......9......0


*********************** SCF CYCLE ITER #   16 ************************
 etot  = -1.82576499E-01 abs_ev   =  6.65E-07 rel_ev   =  6.73E-06
 ediff =        6.70E-07 abs_dens =  1.83E-06 rel_dens =  1.83E-06
Matrix vector products:     12
Converged eigenvectors:      0

#  State  Eigenvalue [H]  Occupation    Error
      1       -0.098800    1.000000   ( 2.5E-07)

Elapsed time for SCF step    16:          0.03
**********************************************************************

ETA: .......1......2.......3......4......5.......6......7.......8......9......0


*********************** SCF CYCLE ITER #   17 ************************
 etot  = -1.82576496E-01 abs_ev   =  1.73E-09 rel_ev   =  1.75E-08
 ediff =        3.05E-09 abs_dens =  2.85E-07 rel_dens =  2.85E-07
Matrix vector products:      7
Converged eigenvectors:      0

#  State  Eigenvalue [H]  Occupation    Error
      1       -0.098800    1.000000   ( 1.6E-07)

Elapsed time for SCF step    17:          0.02
**********************************************************************

ETA: .......1......2.......3......4......5.......6......7.......8......9......0


*********************** SCF CYCLE ITER #   18 ************************
 etot  = -1.82576542E-01 abs_ev   =  4.84E-08 rel_ev   =  4.90E-07
 ediff =        4.56E-08 abs_dens =  2.26E-07 rel_dens =  2.26E-07
Matrix vector products:      7
Converged eigenvectors:      0

#  State  Eigenvalue [H]  Occupation    Error
      1       -0.098800    1.000000   ( 1.2E-07)

Elapsed time for SCF step    18:          0.02
**********************************************************************


             Info: Writing states. 2025/03/27 at 16:13:00


        Info: Finished writing states. 2025/03/27 at 16:13:00

Info: SCF converged in   18 iterations

Info: Number of matrix-vector products:        128
Info: Finished writing information to 'restart/gs'.

             Calculation ended on 2025/03/27 at 16:13:00

                          Walltime:  00.921s

Octopus emitted 2 warnings.
```
{{%/expand %}}

Take now a look at the working directory. Besides the initial file ({{< file "inp" >}}) and the {{< file "out" >}} file, three new directories appear. In {{< file "static/" >}}, you will find the file {{< file "info" >}}, with information about the static calculation (it should be hopefully self-explanatory, otherwise please complain to the authors...). In {{< file "restart/" >}}, you will find the {{< file "gs" >}} directory that contains restart information about the ground-state, which is used if, for example, you want to start a time-dependent calculation afterwards. Finally, the {{< file "exec" >}} directory has information about the run of octopus; inside the {{< file "parser.log" >}} contains all the input variables parsed by octopus.

### Exercises

* Study how the total energy and eigenvalue of the sodium atom improve with the mesh spacing.
* Calculate the static polarizability of the sodium atom ({{< variable "CalculationMode" >}} = em_resp). A {{< file "em_resp/freq_0.0000/alpha" >}} will be created containing the static polarizability tensor.
* Calculate a few unoccupied states ({{< variable "CalculationMode" >}} = unocc). The eigenspectrum will be in the file {{< file "static/eigenvalues" >}}. Why don't we find a Rydberg series in the eigenspectrum?
* Repeat the previous calculation with different exchange and correlation functionals like PBE, LB94, and exact exchange (see {{< variable "XCFunctional" >}}).
* Perform a time-dependent evolution ({{< variable "CalculationMode" >}} = td), to calculate the optical spectrum of the Na atom. Use a {{< variable "TDDeltaStrength" >}} = 0.05, polarised in the ''x''-direction. The multipole moments of the density are output to the file {{< file "td.general/multipoles" >}}. You can process this file with the utility {{<manual  "utilities:oct-propagation_spectrum" "oct-propagation_spectrum" >}} to obtain the optical spectrum. If you have computer time to waste, re-run the time-dependent simulation for some other xc choices.

{{< manual-foot series="Examples" prev="Deprecated Utilities" next="Examples:Benzene" >}}
