---
title: "Pseudopotentials"
#series: "Manual"
weight: 100
description: " "
---


{{< octopus >}} is capable of using different formats for pseudopotentials (see {{< variable Species >}} for more information). We include in the distribution some LDA Troullier-Martins pseudopotentials for some common atoms, but it is likely that you will need other pseudopotentials.

#### Pseudopotentials provided by Octopus

For convenience, Octopus provides some of the these sets directly, see the variable {{<variable "PseudopotentialSet">}} and the {{<variable "Species">}} 
block for more details on how to use them.

Octopus already provides a number of pseudopotentials, which can be found in the {{<file "share/pseudopotentials/" >}} folder.

- {{<file "HGH/">}}: (Hartwigesen-Goedecker-Hutter)
  - {{<file "lda/">}}: HGH LDA
  - {{<file "lda_sc/">}}: HGH LDA with semic-core
- {{<file "pseudo-dojo.org/">}}:
  ({{< article authors="M. J. van Setten, M. Giantomassi, E. Bousquet, M. J. Verstraete, D. R. Hamann, X. Gonze, G.-M. Rignanese" 
       title="The PseudoDojo: Training and grading a 85 element optimized norm-conserving pseudopotential table" 
       journal="Computer Physics Communications" volume="226" pages="39-54" year="2018" doi="10.1016/j.cpc.2018.01.012">}})
  - {{<file "nc-fr-04_pbe_standard/">}}: Norm-conserving fully-relativistic PBE pseudopotentials (version 4)
  - {{<file "nc-sr-04_pbesol_standard/">}}: Norm-conserving scalar-relativistic PBEsol pseudopotentials (version 4)
  - {{<file "nc-sr-04_pw_standard/">}}: Norm-conserving scalar-relativistic LDA-PW pseudopotentials (version 4)
  - {{<file "nc-sr-05_pbe_standard/">}}: Norm-conserving scalar-relativistic PBE pseudopotentials (version 5)
- {{<file "PSF/">}}: standard set with only few elements in PSF format
- {{<file "quantum-simulation.org/">}}:
  - {{<file "hscv/">}}:
    - {{<file "lda/">}}: HSCV LDA pseudopotentials
    - {{<file "pbe/">}}: HSCV PBE pseudopotentials
  - {{<file "sg15/">}}: SG15 PBE pseudopotentials 
    ({{< article authors="M. Schlipf and F. Gygi" title="Optimization algorithm for the generation of ONCV pseudopotentials" journal="Computer Physics Communications" volume="196" pages="36" year="2015" doi="10.1016/j.cpc.2015.05.011" >}})


#### Repositories on the web

These are places on the web that include pseudopotential files in a variety of formats. Note that not all formats are read by {{<octopus>}} but many are.

* [NNIN Virtual Vault for Pseudopotentials](https://www.nnin.org/nnin_comp_psp_vault.html) Contains an extensive list of pseudo-potential databases and a search engine. It also has links to pseudo-potential related tools.
* [ABINIT](https://www.abinit.org) has a quite complete [set of pseudopotentials](https://www.abinit.org/atomic-data-files). At this moment only <tt>.fhi</tt> files are supported.
* [QuantumEspresso](https://www.quantum-espresso.org/)'s format is also accepted. So you can use the <i>norm-conserving</i> pseudopotentials from their [repository](https://www.quantum-espresso.org/pseudopotentials).
* [PseudoDojo](http://www.pseudo-dojo.org/) The PseudoDojo.org website gives access to the latest released version of the pseudopotentials of the PseudoDojo project.
* [quantum-simulations.org](http://www.quantum-simulation.org/potentials/) including SG15, HSCV and BHS pseudopotentials.

#### Pseudopotential generators

In order to generate your own pseudopotentials, we advise the use of the following programs:
* [APE](https://gitlab.com/ape/ape)
* [opium](https://opium.sourceforge.net/)
* [FHI98PP](https://www.fhi-berlin.mpg.de/th/fhi98md/fhi98PP/)
