---
Title: "Non-dispersive linear media"
series: "Tutorials"
tutorials: "Maxwell"
author: ["Franco Bonafé","René Jestaedt","Heiko Appel","Martin Lueders"]
Weight: 18
---

## Including non-disperive linear media objects

An arbitrary number of linear medium shapes can be placed inside simulation
box.  Linear media are defined as a separate system type, for example:

{{< code-block >}}
#include_input_snippet doc/tutorials/maxwell/2.linear-medium/1.cosinoidal_pulse_td_mask/inp systems
{{< /code-block >}}


The object shape can be defined in two ways, which are given by the variable
{{<variable "LinearMediumBoxShape">}}: if set to medium_parallelepiped, the
parallelepiped box will be defined by its center, and size in each dimension
through the {{<variable "LinearMediumBoxSize">}} block; if the box shape is
defined as medium_box_file, the box shape will be read from an external
geometry file in [OFF](https://en.wikipedia.org/wiki/OFF_(file_format)) format,
defined through the variable {{<variable "LinearMediumBoxFile">}}.

In this tutorial, we will simulate light propagation though a spherical lens,
for which we need to provide an OFF file representing a suitable shape. There
are many software packages around to generate such files, but we recommend
[openSCAD](https://www.openscad.org/index.html) and `ctmconv` which is part
of [OpenCTM](https://openctm.sourceforge.net/).

{{< notice info >}}
    In Debian style systems, these can be installed using
    {{< code-block >}}
    apt-get install openscad
    apt-get install openctm-tools
    {{< /code-block >}}
{{< /notice >}}

OpenSCAD provides its own scripting language for creating geometries, which can
be created in a GUI, but also can be rendered on the command line. Here we will
use the following code to create a simple lens from the intersection of two
spheres and shift its position to the negative x-axis with openSCAD, using the
following script:
{{< code-block >}}
$fs=2.0;
$fa=2.0;
translate([-10,0,0]) {
intersection(){
  translate([-8,0,0]) sphere(r=10);
  translate([ 8,0,0]) sphere(r=10);
};
};
{{< /code-block >}}

copy the above code into a file `lens.scad`, you can generate the required
`OFF` file by the command:
```bash
openscad -o lens.off lens.scad
```

For details on the syntax of this, see the openSCAD {{< link "https://www.openscad.org/documentation.html" "tutorials" >}}.
This creates the following lens: {{< figure src="/images/Maxwell/Lense.png" width="500px"
>}}

{{< expand "If you want to manipulate your OFF file with ctmconv, click here." >}}
{{< notice warning >}}
    The `OFF` files, generated by openSCAD are malformed. If you want to further manipulate them with `ctmconv`, the header needs to be fixed:
    {{< code-block >}}
    OFF 1162 2320 0
    1.81312 4.79828 5.90861
    1.73416 3.80751 6.86969
    1.98506 3.84776 5.90861
    1.72673 7.81373 -0.993913
    1.39732 8.75085 -0.993913
    1.41584 8.75777 0
    ...
    {{< /code-block >}}
    The first line needs to be `OFF` only, and the first line of the data block needs to contain the number of vertices, planes and (optional) connections.
    You can add comments (starting with `#` of empty lines are allowed after the header).
    {{< code-block >}}
    OFF
    # This is a lens (generated with OpenSCAD)

    1162 2320 0
    1.81312 4.79828 5.90861
    1.73416 3.80751 6.86969
    1.98506 3.84776 5.90861
    1.72673 7.81373 -0.993913
    1.39732 8.75085 -0.993913
    1.41584 8.75777 0
    ...
    {{< /code-block >}}
{{< /notice >}}
{{< /expand >}}


Now we have the OFF file, let's consider the
electromagnetic properties of the medium. These must be defined in the {{<variable
"LinearMediumProperties">}} block, which specifies the relative electric
permittivity, relative magnetic permeability, and the electric and magnetic
conductivities (for lossy media). In addition to
adding the linear_medium system, we need to switch the {{<variable
"MaxwellHamiltonianOperator">}} to {{<code "faraday_ampere_medium">}}.

As a linear medium will scatter waves in all directions, there need to be
absorbing boundary conditions to avoid spurious reflections on the box
boundaries. For this purpose, we change the {{<variable
"MaxwellAbsorbingBoundaries">}} block to mask in all directions, to damp the
field at the boundaries by multiplying it with a scalar mask function.  The
width of this mask {{<variable "MaxwellABWidth">}} is set to 5 Bohr.

As a consequence of the additional region for the absorbing boundary condition,
we have to increase the box size. Therefore, the {{<code "lsize_mx">}} value is
now 20.0 (13.0 Bohr for propagation region plus 2.0 Bohr for the incident wave
boundaries plus 5.0 Bohr for absorbing boundary conditions).

Finally, as non-dispersive linear media are static,
{{<code-inline>}}{{<variable "TDSystemPropagator">}} = static
{{</code-inline>}}, which is the default option, must be set for the medium,
while the Maxwell system needs to be set to {{<code "exp_mid">}}.  A possible
  input file to run this simulation, then, would be the following:

{{< code-block >}}
#include_input doc/tutorials/maxwell/2.linear-medium/1.cosinoidal_pulse_td_mask/inp
{{< /code-block >}}

{{< notice note >}}
As the {{<code "exp_mid">}} propagator contains two algorithmic steps, it must
be clocked twice as fast as the {{<code "static">}} propagator and hence the
time step of the medium bust be set to half the Maxwell time step. This is
currently a workaround, and is likely to change in future releases of the code.
{{< /notice >}}

For this run, we use the previous incident plane wave propagating only in the
x-direction but place a medium box inside the simulation box. After running the
code, we can visualize the results with the following gnuplot script:

{{% expand "gnuplot script" %}}
```
#include_file doc/tutorials/maxwell/2.linear-medium/1.cosinoidal_pulse_td_mask/plot1.gnu
```
{{% /expand %}}

Contour plot of the electric field in z-direction after 50 time steps for
t=0.11 and 100 time steps for t=0.21:
{{< figure src="/images/Maxwell/tutorial_03.1-plot1.png" width="50%" >}}

Contour plot of the electric field in z-direction after 125 time steps for
t=0.26 and 150 time steps for t=0.32:
{{< figure src="/images/Maxwell/tutorial_03.1-plot2.png" width="50%" >}}

In the last panel, it can be seen that there is a significant amount of
scattered waves which, in large parts, are scattered from the box boundaries.
This is due to making use of plane wave boundary conditions and absorbing
boundaries simultaneously, and would be less noticeable if we increase the size
of the box. In this tutorial we keep the box small to stay within a reasonable
computation time.

{{< tutorial-footer >}}
