---
title: "Cell relaxation in solids"
series: "Tutorials"
tutorials: ["Periodic Systems"]
difficulties: "Basic"
difficulties_weight: 2
theories: "DFT"
calculation_modes: ["Ground state", "Geometry Optimization"]
system_types: "Bulk"
species_types: "Pseudopotentials"
description: "How to perform geometry relaxation in periodic systems."
weight: 7
---

In this tutorial, we will learn how to determine the lattice parameters of a bulk material, as well as getting the relaxed atomic coordinates in bulk materials.
Different flavors of cell dynamics are available in Octopus, which we will explore here.

## Determination of the cell shape and cell volume

In this tutorial, we will start by determining the equilibrium lattice parameters of bulk silicon. 
The input file is the following:

{{< code-block >}}
#include_input doc/tutorials/periodic_systems/cell_relax/GO_Si/inp
{{< /code-block >}}

We are not doing here a GS calculation, but a GO calculation (that stands for geometry optimization).
The type of geometry optimization is determined by the variable {{< variable "GOType">}}. In the above example, we are asking for optimizing the shape of the lattice vector, meaning both their directions and lengths. We could have equally asked for optimizing only the cell volume, as we started from an already correct space group.
This has the advantage to allow using symmetries, which makes the calculation faster and more accurate.
Note that several options exists for controlling the behavior of the geometry optimizer, in particular
{{< variable "GOMethod">}}, {{< variable "GOMaxIter">}}, {{< variable "GOTolerance">}}, and {{< variable "GOStep">}}.

Running {{< octopus >}}, we will perform consecutive cycles of ground-state calculations, after which forces and stress tensor will be computed.
This information is then used to generate new atomic positions and lattice vectors. Based on this, a new real space grid is regenerated. The number of grid point is however kept constant, so it is adviced to start from a reasonably-size unit cell before performing a geometry relaxation with {{< octopus >}}.
It is important to note that accurate forces and stress tensors are critical in order to get precise results. This is why we request here a tight convergence of the relative density.

After every iteration the lattice vectors of the newly generated cell are displayed in the output.
At each step, the geometry of the system is also printed in the {{< file "geom/">}} folder, containing for the structure in XYZ format {{< file "geom/go.0001.xyz">}}, a modified XYZ format with reduced coordinates {{< file "geom/go.0001.xyz_red">}}, and a XCrysden file {{< file "geom/go.0001.xsf">}}.
The file {{< file "geom/optimization.log">}} contains the evolution of the energy, force, as well as cell parameters versus the GO iterations.

The effect of the relaxation is clear. We started with the original lattice vectors
{{< code-block >}}
#include_file doc/tutorials/periodic_systems/cell_relax/GO_Si/lattice_start.txt
{{< /code-block >}}
that correspond to a lattice parameter of 10 Bohr, and obtained the relaxed lattice vectors
{{< code-block >}}
#include_file doc/tutorials/periodic_systems/cell_relax/GO_Si/lattice_end.txt
{{< /code-block >}}
corresponding to a lattice parameter of 10.153 Bohr, or 5.373 Angstrom.
This can be compared with the experimental value of 5.431 Angstrom, see for instance the [NIST website](https://physics.nist.gov/cgi-bin/cuu/Value?asil|search_for=silicon).

What about the convergence of this value?
Because of the real-space grid and in particular the so-called egg-box effect, special care is required for the convergence of forces and stress in grid spacing.
To illustrate this, we can repeat the previous calculation for a grid spacing of 0.4 Bohr, yielding a lattice parameter of 10.173 Bohr, showing that the above values was not fully converged.
As an exercise you might want to converge the grid spacing.
Just keep in mind that calculations with smaller grid spacing might take quite some time to run.

## Full geometry relaxation of bulk tellurium

We now look at the more challenging relaxation of a tellurium crystal, in which the crystal symmetry does not fix the reduced coordinates of all atoms.
In particular, in this system, the atomic coordinates are defined by an internal coordinate, defined as uu in the following input file, that we want to determine alongside with the lattice parameters.
This calculation is a bit more demanding than for silicon as more degrees of freedom are involved, and will require few minutes to be completed.

{{< code-block >}}
#include_input doc/tutorials/periodic_systems/cell_relax/GO_Te/inp
{{< /code-block >}}

Here, we prepared the input file such that the space group is known. Hence, we will only optimize the length of the lattice vectors and the atomic coordinates ({{< variable "GOType">}})=ion_positions + cell_volume.

{{%notice note%}}
As the system is close to be metallic, we add the smearing to the input file, as commonly done in DFT codes to stabilize the SCF calculation.
{{%/notice%}}

At the end of the calculation, we obtain
{{< code-block >}}
#include_file doc/tutorials/periodic_systems/cell_relax/GO_Te/lattice_end.txt
{{< /code-block >}}
and the reduced coordinates (from the file geom/go.0051.xyz_red)
{{< code-block >}}
#include_file doc/tutorials/periodic_systems/cell_relax/GO_Te/relaxed_pos.txt
{{< /code-block >}}

We have thus converged to a relaxed internal coordinate of u = 0.274, with lattice parameters a = 4.448 Angstrom and c = 6.00 Angstrom.
The experimental lattice parameters are u=0.2633, a = 4.451 Angstrom and c = 5.926 Angstrom, see [ Keller et al., PRB 16, 4404 (1977)].
The disagreement with experimental values is larger here, which comes from several factors that are not only due to convergence of the simulation parameters: spin-orbit coupling was not included in the simulation, and LDA is not good at describing the insulating nature of the material.
More advanced functionals should therefor be employed for properly relaxing bulk Te.
As an exercise you might want to test the effect for DFT+U on the equilibrium property of Te, using for instance a value of U=5eV on the p orbitals for Te.
{{< code-block >}}
%{{< variable "Species">}}
 "Te" | species_pseudo | hubbard_l | 1 | hubbard_u | 5*eV
%
{{< variable "DFTULevel">}} = dft_u_empirical
{{< /code-block >}}

The details on how to run the DFT+U calculations are given in the {{<tutorial "unsorted/dft+u" "corresponding tutorial">}}.

{{< tutorial-foot series="periodic_systems" prev="hhg_1d_chain" next="" >}}
